/**
 * @author Sumit meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.markgrade.markgradedetail.ResultStatisticController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['examinationcenters.markgrade.MarkBasedTransformation',
	          'examinationcenters.markgrade.StudentBasedTransformation',
	          'examinationcenters.markgrade.StudentResultGrid'],
	stores : ['examinationcenters.markgrade.MarkBasedTransformation',
	          'examinationcenters.markgrade.StudentBasedTransformation',
	          'examinationcenters.evaluation.evaluationPlanHeirarchy.AssignQuesPaper',
	          'examinationcenters.markgrade.StudentResultGrid','examinationcenters.markgrade.CurrentGradeTreeStore',
	          'examinationcenters.markgrade.GradeMasterDetailsStore','examinationcenters.markgrade.StudentBasedTransformation',
	          'examinationcenters.markgrade.GradeDistributionStatisticsStore','examinationcenters.markgrade.StoMarkBasedTransformStudentGridStore'],
	views : ['examinationcenters.markgrade.markgradedetail.MarkGradeDetailTabStructure',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.ResultStatisticDisplayData',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.ResultStatisticDisplayChart',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.ResultStatisticsDisplayGrid',
	         'examinationcenters.markgrade.markgradedetail.markgradetransformation.MarkBasedTransformationGrid',
	         'examinationcenters.markgrade.markgradedetail.markgradetransformation.MarkGradeTransformationForm',
	         'examinationcenters.markgrade.markgradedetail.markgradetransformation.StudentBasedTransformationGrid',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.GradeMasterDetailsGrid',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.GradeMasterDetailsStructure',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.CurrentGradeTabPanel',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.GradeDistributionDetailsStructure',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.GradeDistributionDetailsGrid',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.DistributionChartView',
	         'program.programDetails.viewHistory.selectionSummary.ProgramSelectionProcessChart',	           
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.DistributionProcessChart',
	         'examinationcenters.markgrade.markgradedetail.resultstatistic.GradeDistributionStatistics',
	         'examinationcenters.markgrade.markgradedetail.markgradetransformation.AddGradeTypeWin',
	         'reports.common.ParetoChartReport','examinationcenters.markgrade.markgradedetail.GradeMasterDetailTabStructure',
	         'examinationcenters.markgrade.markgradedetail.GradeDistributionDetailTabStructure','examinationcenters.markgrade.markgradedetail.VWExamTransformStudentDetailWindow',
	         'examinationcenters.markgrade.markgradedetail.TransformMarksStudentCountWindow'],
	 config:{
		      TRANSFER_MARK_TO_GRADE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSFER_MARK_TO_GRADE_PRIVILEGES')
	          },
	         refs : [{
	        	 ref:'markgradequicksearch',
	        	 selector:'markgradequicksearch'
	         },{
	        	  ref:'markgrademastergrid',
	        	  selector:'markgrademastergrid'
	          },{
	              ref: 'contentPanel',
	              selector: 'contentPanel'
             },{
             	 ref: 'markgradedetailtabstructure',
            	 selector: 'markgradedetailtabstructure'
             },{
             	 ref: 'rsdstatistics',
            	 selector: 'resultstatisticdisplaydata[itemId=rsdStatisticsItemId]'
             },{
             	 ref: 'resultstatisticdisplaychart',
            	 selector: 'resultstatisticdisplaychart'
             },{
             	 ref: 'resultstatisticsdisplaygrid',
            	 selector: 'resultstatisticsdisplaygrid'
             },{
             	 ref: 'resultstatisticdisplaydata',
            	 selector: 'resultstatisticdisplaydata'
             },{
             	 ref: 'rsdtransformation',
            	 selector: 'resultstatisticdisplaydata[itemId=rsdTransformationItemId]'
             },{
             	 ref: 'markbasedtransformationgrid',
            	 selector: 'markbasedtransformationgrid'
             },{
             	 ref: 'markgradetransformationform',
            	 selector: 'markgradetransformationform'
             },{
             	 ref: 'studentbasedtransformationgrid',
            	 selector: 'studentbasedtransformationgrid'
             },{
		        ref: 'notificationsection',
		        selector: 'notificationsection'
	    	},{
	            ref: 'contentPanel',
	            selector: 'contentpanel'
	        },{
	            ref: 'distributionprocesschart',
	            selector: 'distributionprocesschart[itemId=distributionprocesschart]'
	        },{
	            ref: 'gradedistributionstatistics',
	            selector: 'gradedistributionstatistics'
	        },{
	            ref: 'distributionchartview',
	            selector: 'distributionchartview'
	        },{
	            ref: 'addgradetypewin',
	            selector: 'addgradetypewin'
	        },{
	            ref: 'gradedistributiondetailtabstructure',
	            selector: 'gradedistributiondetailtabstructure'
	        },{
	        	ref: 'vwexamtransformstudentdetailwindow',
	            selector: 'vwexamtransformstudentdetailwindow'
	        },{
	        	ref: 'TransformMarksStudentCountWindow',
	            selector: 'vwexamtransformstudentdetailwindow grid'
	        },{
	        	ref: 'transformmarksstudentcountwindow',
	            selector: 'transformmarksstudentcountwindow'
	        }],
	          init : function() {
	        	  this.control({
	        		 
	        		  'markgradetransformationform':{
	        			  afterrender:function(){
	        				  var $this =this;
	        				  var form = $this.getMarkgradetransformationform();
	        				  var getForm = form.getForm();
	        				  var grid=$this.getMarkgrademastergrid();
	        				  var saveButton=form.down('#btnSave');
	        				  var records = grid.getSelectionModel().getSelection()[0];
	        				  if(records.data.distributionStatus == 'APPROVED') {
	        					  saveButton.setVisible(false);
	        				  }
	        				  if(grid.getSelectionModel().getCount()>0){
	        					  var records = grid.getSelectionModel().getSelection()[0];
	        					  if(records.data.distributionEntryDate!=null){
	        						  //obj.setValue(records.data.distributionEntryDate);
	        						  form.down('#entryDate').setValue(dateRender(records.data.distributionEntryDate));
	        					  }

	        					  var radiofield=form.down('#gradeBasedItemId');
	        					  if(records.data.type == 'MARK_BASED'){
	        						  radiofield.items.items[0].setValue(true);
	        						  radiofield.items.items[1].setValue(false);
	        						  //$this.getStudentbasedtransformationgrid().setVisible(false);
	        						  //$this.getMarkbasedtransformationgrid().setVisible(true);

	        					  }else{

	        						  radiofield.items.items[0].setValue(false);
	        						  radiofield.items.items[1].setValue(true);
	        						  //$this.getStudentbasedtransformationgrid().setVisible(true);
	        						  //$this.getMarkbasedtransformationgrid().setVisible(false);
	        						  $this.caculateStudentMarksByTotalMarks();
	        					  }
	        				  }
	        			  },
	        			  render:function(grid){
	        				  this.disableMoreActionPivileges(grid,this.getTRANSFER_MARK_TO_GRADE_PERMISSION());
	        			  },
	        		  },
	        		  'markgrademastergrid button[itemId=btnAdd]':{
	        			  click:function(){
	        				  this.loadResultStatisticChartAndGridData();
	        			  }
	        		  },
	        		  'resultstatisticdisplaydata[itemId=rsdStatisticsItemId]':{
	        			  afterrender:function(obj){
	        				  var form=obj.getForm();
	        				  this.loadResultStatisticDisplayData(form);
	        			  }
	        		  },
	        		  'markbasedtransformationgrid':{
	        			  render:function(obj){
	        				  this.loadMarkGardeTransformationGrid();
	        				  this.loadTotalNumberOfStudents();
	        			  },
	        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        				  var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

	        				  if(columnName == "studentCount"){
	        					  if(e.target.tagName=='A'){
	        						  this.getMarkBasedTranformationStudentCountDetails(grid,record);
	        					  }
	        			  }
	        		  },
	        		  },
	        		  'resultstatisticdisplaydata[itemId=rsdTransformationItemId]':{
	        			  afterrender:function(obj){
	        				  var $this=this;
	        				  var form=obj.getForm();
	        				  $this.loadResultStatisticDisplayData(form);
	        				  $this.loadMarkGardeTransformationGrid();
	        			  }
	        		  },
	        		  'resultstatisticdisplaydata[itemId=rsdViewGraphItemId]':{
	        			  afterrender:function(obj){
	        				  var form=obj.getForm();
	        				  this.loadResultStatisticDisplayData(form);
	        			  }
	        		  },
	        		  'markgradetransformationform radiogroup[itemId=gradeBasedItemId]':{
	        			  change:function(obj,val){
	        				  var $this=this;
	        				  if(val.grade){
	        					  $this.getStudentbasedtransformationgrid().setVisible(false);
	        					  $this.getMarkbasedtransformationgrid().setVisible(true);
	        				  }else{
	        					  $this.getStudentbasedtransformationgrid().setVisible(true);
	        					  $this.getMarkbasedtransformationgrid().setVisible(false);

	        					  $this.caculateStudentMarksByTotalMarks();
	        				  }
	        			  }
	        		  },
	        		  'markbasedtransformationgrid numberfield[itemId=markRangeFromItemId]': {

//	        			  blur: function(obj, val) {
//	        				  var $this = this;
//	        				  var transformationGrid = $this.getMarkbasedtransformationgrid();
//	        				  //transformationGrid.getSelectionModel().selectPrevious();
//	        				  /* var records = transformationGrid.getSelectionModel().getSelection()[0];
//		        				                  		     records.set('markRangeFrom',obj.getValue());*/
//	        				  if (val != undefined) {
//	        					  var selectionModel= transformationGrid.getSelectionModel().getSelection()[0];
//	        					  var index=transformationGrid.getStore().findExact('grade',selectionModel.get('grade'));
//	        					  var expressionValue=null
//	        					  if(!isNullOrEmpty(val.currentTarget.activeElement)) {
//	        						  expressionValue=parseInt(val.currentTarget.activeElement.getAttribute('data-recordindex'));
//	        					  }
//	        					  if (val.target.innerText == "Click to enter"  && expressionValue !=index) {
//
//	        					  }else if(expressionValue==index){
//	        						  this.checkStudentRangeOfMarks(obj);
//	        					  } else if (!isNullOrEmpty(obj.getValue())) {
//	        						  this.checkStudentRangeOfMarks(obj);
//	        					  }
//	        				  } else {
//	        					  this.checkStudentRangeOfMarks(obj);
//	        				  }
//	        			  },
	        			  focus: function( field, e, eOpts ){
	        				  var me = this;
	        				  //field.validated = false;
	        				  var grid = me.getMarkbasedtransformationgrid();
	        				  var currentRecord = grid.getSelectionModel().selected.items[0];
	        				  
	        				  //-- initially getting min and max values
	        				  var minValue = 0;
	        				  var gridAllRecords = grid.getStore().data.items;
	        				  if(Ext.isDefined(gridAllRecords[currentRecord.index+1])){
	        					  var minValue = (parseFloat(gridAllRecords[currentRecord.index+1].data.markRangeFrom)+0.01).toFixed(2);
	        				  }
	        				  var maxValue = 100;
	        				  
	        				  //-- checking for zero values
	        				  if(currentRecord.data.markRangeTo==0){
	        					  var maxValue = maxValue;
	        					  var minValue = minValue;
	        				  } else{
	        					  //-- changing min and max values from record
		        				  var maxValue = isNullOrEmpty(currentRecord.data.markRangeTo) ? maxValue : currentRecord.data.markRangeTo;
		        				  var minValue = minValue;
	        				  }

	        				  //-- setting min and max value in field
	        				  field.setMinValue(minValue);	        				  
	        				  field.setMaxValue(maxValue);
	        			  },
	        			  keyup: function( obj, e, eOpts ){
	        				  var me = this;
	        				  var currentField = obj;
	        				  //currentField.validated = false;
	        				  var grid = me.getMarkbasedtransformationgrid();
	        				  var currentRecord = grid.getSelectionModel().selected.items[0];
	        				  
	        				  me.calculateStudentCount(me,currentField,grid,currentRecord);
	        			  },
	        			  change: function(obj){
	        				  if(!isNullOrEmpty(arguments[1]) && !isNullOrEmpty(arguments[2])){
	        					  obj.validated = false;
	        				  }
	        			  }
	        		  },
	        		  'markbasedtransformationgrid numberfield[itemId=markRangeToItemId]': {
//	        			  blur: function(obj, val, e) {
//	        				  var $this = this;
//	        				  var transformationGrid = $this.getMarkbasedtransformationgrid();
//	        				  //transformationGrid.getSelectionModel().selectPrevious();
//	        				  //var records = transformationGrid.selected.items[0].data;
//	        				  //var records = transformationGrid.getSelectionModel().getSelection()[0];
//	        				  //records.set('markRangeTo',obj.getValue());
//	        				  if (val != undefined) {
//	        					  if (val.target.innerText == "Click to enter") {
//
//	        					  } else if (!isNullOrEmpty(obj.getValue())) {
//	        						  this.checkStudentRangeOfMarks(obj);
//	        					  }
//	        				  } else {
//	        					  this.checkStudentRangeOfMarks(obj);
//	        				  }
//	        			  },
	        			  focus: function( field, e, eOpts ){
	        				  var me = this;
	        				  var grid = me.getMarkbasedtransformationgrid();
	        				  var currentRecord = grid.getSelectionModel().selected.items[0];
	        				  
	        				  //-- initially getting min and max values
	        				  var minValue = 0;
	        				  var maxValue = 100;
	        				  
	        				  //-- changing min and max values from record
	        				  var maxValue = maxValue;
	        				  var minValue = isNullOrEmpty(currentRecord.data.markRangeFrom) ? minValue : currentRecord.data.markRangeFrom;
	        				  
	        				  //-- setting min and max value in field
	        				  field.setMinValue(minValue);	        				  
	        				  field.setMaxValue(maxValue);
	        			  },
	        			  keyup: function( obj, e, eOpts ){
	        				  var me = this;
	        				  var currentField = obj;
	        				  var grid = me.getMarkbasedtransformationgrid();
	        				  var currentRecord = grid.getSelectionModel().selected.items[0];

	        				  me.calculateStudentCount(me,currentField,grid,currentRecord);
	        			  }
	        		  },
	        		  'markgradetransformationform button[itemId=btnSave]':{
	        			  click:function(button){
	        				  var $this=this;
	        				  var markBasedGrid=$this.getMarkbasedtransformationgrid();
	        				  var stdBasedGrid=$this.getStudentbasedtransformationgrid();
	        				  var mastergrid = $this.getMarkgrademastergrid();
	        				  var records = mastergrid.getSelectionModel().getSelection();
	        				  if(records.length){
	        					  var data = records[0].data;
	        					  localStorage.setItem("selectedRecord",Ext.encode(records[0].data));
	        				  }
	        				  else{
	        					  try{
	        						  var selectedRecord = localStorage.getItem("selectedRecord");
	        						  if(selectedRecord){
	        							  var data = Ext.decode(selectedRecord);
	        						  }
	        					  }
	        					  catch(e){
	        						  //--(no record selected case)
	        					  }
	        				  }
	        				  var models = markBasedGrid.getStore().getRange();
	        				  var marksValidation=false;
	        				  if(!isNullOrEmpty(data.marksObtainedFrom)) {
	        					  for (var i=0;i<models.length;i++) {
	        						  if(models[i].get('markRangeTo') == data.marksObtainedFrom && models[i].get('markRangeTo') >! data.marksObtainedFrom ){
	        							  marksValidation=true;
	        						  }
	        					  }
	        					  if(!markBasedGrid.isHidden() && marksValidation){
	        						  $this.saveMarkBasedStudentData(markBasedGrid, button);
	        						  //$this.secondSaveForMarkToGradeData(markBasedGrid);
	        					  }else {
	        						  //$this.saveMarkBasedStudentData(stdBasedGrid);
	        						  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAX_MARKS_NOT_SELECTED')); 
	        					  }
	        				  }
	        			  }
	        		  },

	        		  /*'markgradetransformationform datefield[itemId=entryDate]':{
		        			 change:function(){
		        				 var mastergrid = this.getMarkgrademastergrid();
                	        	 var records = mastergrid.getSelectionModel().getSelection();
                	        	 var data = records[0].data;
		        				 var form1 = this.getMarkgradetransformationform();
                                 if(data.distributionStatus == 'APPROVED'){
                                	 form1.down('#btnSave').setDisabled(true);
                                 }		 
		        			 }
		        		 },*/

	        		  /*'markgradetransformationform button[itemId=btnApprove]':{
		        			 click:function(obj){
		        				 this.approveRecord(obj);
		        			 }
		        		 },*/
	        		  'studentbasedtransformationgrid numberfield[itemId=prcntStdFromItemId]':{
	        			  blur:function(obj){
	        				  var $this=this; 
	        				  var studentBasedGrid=$this.getStudentbasedtransformationgrid();
	        				  var records = studentBasedGrid.getSelectionModel().getSelection()[0];
	        				  records.set('rankFrom',obj.getValue());
	        				  this.checkStudentPercentage();
	        			  }
	        		  },
	        		  'studentbasedtransformationgrid numberfield[itemId=prcntStdTillItemId]':{
	        			  blur:function(obj){
	        				  var $this=this; 
	        				  var studentBasedGrid=$this.getStudentbasedtransformationgrid();
	        				  var records = studentBasedGrid.getSelectionModel().getSelection()[0];
	        				  records.set('rankTo',obj.getValue());
	        				  this.checkStudentPercentage();
	        			  }
	        		  },
	        		  'markgradetransformationform button[itemId=btnCancel]':{
	        			  click:function(){
	        				  var form=this.getMarkgradetransformationform().getForm();
	        				  form.reset();
	        			  }
	        		  },
	        		  'resultstatisticdisplaychart panel[itemId=gradeDetailsView] treepanel[itemId=gradeDetailsId]' : {
	        			  itemclick : this.getOpenGradeDetailsStructure
	        		  },
	        		  'grademasterdetailsgrid': {
	        			  render: function(grid){
	        				//  this.loadGradeMasterdetailsGrid(grid);
	        			  }
	        		  },
	        		  'gradedistributiondetailsgrid': {
	        			  render: function(grid){
	        				  this.loadGradeDistributiondetailsGrid(grid);
	        			  }
	        		  },
	        		 /* 'distributionchartview': {
	        			  render: function(grid){
	        				  this.loadGradePointDistributionChart(grid);
	        			  }
	        		  }, */
	        		  'gradedistributionstatistics': {
	        			  render: function(grid){
	        				  this.loadGradeDistributionStatistics(grid);
	        			  }
	        		  }, 
	        		  'distributionprocesschart': {
	        			  render: function(grid){
	        				  this.loadGradePointDistributionChart(grid);
	        			  }
	        		  }, 

	        		  'markbasedtransformationgrid button[itemId=btnAdd]':{
	        			  click:function(){
	        				  var $this = this;
	        				  var formWindow = $this.getAddgradetypewin();
	        				  if (!formWindow) {
	        					  Ext.widget('addgradetypewin');
	        					  formWindow = $this.getAddgradetypewin();
	        				  }
	        				  formWindow.show();
	        			  }	
	        		  },
	        		  'addgradetypewin  button[itemId=gradeMasterAddButtonId]': {
	        			  click: this.saveUpdateGrade
	        		  },
	        		  'addgradetypewin button[itemId=cancelBtn]':{
	        			  click: function(){
	        				  this.resetGradeType();
	        			  }
	        		  },
	        		  'vwexamtransformstudentdetailwindow': {
	        			  render: function(grid){
	        				  this.doAccessControlValidation(grid, this.getTRANSFER_MARK_TO_GRADE_PERMISSION());
	        			  }
	        		  }, 

	        		  
	        	  });
	          },
	          loadTotalNumberOfStudents: function(){
	        	  var me = this;
	        	  var markGradeMasterGrid = me.getMarkgrademastergrid();
	        	  var selectedRecord = markGradeMasterGrid.getSelectionModel().selected;
	        	  localStorage.setItem("totalStudents","");
	        	  localStorage.setItem("totalStudentsCount","");
	        	  if(selectedRecord.length){
	        		  var records = selectedRecord.items[0];
	        		  var params = {
	        				  evaluationPlanId:records.data.evalPlanId,
	        				  courseVariantIds:records.data.courseVariantIds.join(),
	        				 // periodId:records.data.periodId,
	        				 // academicTermId:records.data.academicTermId,
	        		  };
		        	  Ext.Ajax.request({
	        			  type: 'rest',
	        			  url: SERVERURL.PATH_FIND_TOTAL_NO_OF_STUDENT_BY_CV,
	        			  method: 'GET',
	        			  params:params,
	        			  async:false,
	        			  success: function(obj, action) {
	        				  if(obj.responseText!=""){
	        					  var data = Ext.decode(obj.responseText);
	        					  localStorage.setItem("totalStudentsCount",data.lenght);
	        					  if(data.length>0){
	        						  if(obj.responseText!=""){
	                					  var data = Ext.decode(obj.responseText);
	                					  if(data.length>0){
	                						  localStorage.setItem("totalStudents", obj.responseText);
	                					  }
	                				  }
	        			          }
	        				  }
	        			  }
	        		  });
	        	  }
	          },
	          calculateStudentCount: function(me,currentField,grid,currentRecord){
	        	  var me = this;
	        	  if(currentField.name=="markRangeFrom"){
	        		  var markRangeFrom = currentField.getValue();
	        		  var markRangeTo = currentRecord.data.markRangeTo;
	        	  }
	        	  else
        		  {
	        		  var markRangeFrom = currentRecord.data.markRangeFrom;
	        		  var markRangeTo = currentField.getValue();
        		  }
	        	  
	        	  /*currentRecord.set('markRangeTo',markRangeTo);
	        	  currentRecord.set('markRangeFrom',markRangeFrom);*/
	        	  
	        	  if(markRangeFrom<markRangeTo){
	        		  if(!isNullOrEmpty(localStorage.getItem("totalStudents"))){
	        			  var totalStudents = Ext.decode(localStorage.getItem("totalStudents"));
	        			  var totalStudentCounts = totalStudents.length;
	        			  var count = 0;
	        			  Ext.each(totalStudents, function(currentStudentNumber){
	        				 if(currentStudentNumber>=markRangeFrom && currentStudentNumber<=markRangeTo){
	        					 count = count+1;
	        				 }
	        			  });
	        			  if(currentField.maxValue<currentField.getValue()){
	        				  count = 0;
	        			  }
	        			  currentRecord.set('studentCount',count);
	        			  currentRecord.set('distributionPoint',((currentRecord.data.gradePoint)*(count)));
	        			  currentRecord.set('percentageOfStudent',((count*100)/totalStudentCounts).toFixed(2)+ "%");
	        			  
	        			  var dataToLoad = grid.getStore().data.items;
	        			  dataToLoad[currentRecord.index].markRangeTo = markRangeTo;
	        			  dataToLoad[currentRecord.index].markRangeFrom = markRangeFrom;
	        			  
	        			  var distributionprocesschart = me.getDistributionprocesschart();
	        			  var processChart=distributionprocesschart.down('#selectionProcessOverviewColumnChart');
	        			  processChart.getStore().loadData(dataToLoad);
	        			  processChart.redraw();
	        		  }
	        	  }
	          },
	          openMarkGradeDetailTab: function() {
	             	 var me = this;
	             	 var contentpanel = me.getContentPanel();
	             	 var markGradeDetailTab = Ext.widget('markgradedetailtabstructure');
	             	 var tabName = getExaminationTranslation('GRADE_DEFINITION');
	             	  /**
              	    * This is to remove tab from content panel and open same tab again
              	    */
	             	 var getcontroller=this.getController('menu.CoreERPNavigationController');
	             	 var getTab=getcontroller.getTab(tabName);
	             	 if(getTab!=null){
	             		 contentPanel.remove(getTab, true);
	             	 }
	             	 openTab(contentpanel, tabName, markGradeDetailTab,CONSTANTS.MENU_COLOR_FOUR);

	          },
	          /**
	           * Load data in Result Statistics Display Fields in all the 3 tabs
	           */
	          loadResultStatisticDisplayData:function(form){
	        	  var $this=this;
		        	 var grid=$this.getMarkgrademastergrid();
		        	 var searchForm = this.getMarkgradequicksearch().getForm();
	        		 var courseVariantFormId = searchForm.findField('courseVariant').getValue();
	        		 var cvFormDataArray=[];
	        		 if(!isNullOrEmpty(courseVariantFormId) && !(courseVariantFormId=="")){
	        			 for(var i=0;i<courseVariantFormId.length;i++){
		        			 var cvformIds= courseVariantFormId[i].data.id;
		        			 cvFormDataArray.push(cvformIds);
		              }
	        		}
	 				if(grid.getSelectionModel().getCount()>0){
	 				 var records = grid.getSelectionModel().getSelection()[0];
		                var data=records.data;
		                var cvIdArrayData=[];
		                var cvNameArrayData=[];
		                var cvList="";
		   	 		  //  form.findField('evalPlanNo').setValue(data.evaluationPlanNumber);
		   	 		    form.findField('course').setValue(data.courseName);
		   	 	        form.findField('courseVariant').setValue(data.courseVariantCode);
		                form.findField('maxGrade').setValue(records.raw.maxGrade);
		                form.findField('minGrade').setValue(records.raw.minGrade);
		                var sectionType=null;
		                if(!isNullOrEmpty(records.raw.courseSectionType)) {
		                	if(records.raw.courseSectionType == 'ProgramBatchSection') {
		                		sectionType="Program Batch Section";
		                	}
		                	else {
		                		sectionType="Course Section";
		                	}
		                }
		                form.findField('courseSectionType').setValue(sectionType);
		                form.findField('gradeType').setValue(data.gradeType);
		                form.findField('evalSeqDetailId').setValue(data.id);
		                form.findField('courseVariantIds').setValue(data.courseVariantIds);
		                form.findField('courseId').setValue(data.courseId);
		                form.findField('courseVariantId').setValue(data.courseVariantId);
		                form.findField('evaluationPlanId').setValue(data.evalPlanId);
		                params = {
	        					  evaluationPlanId:records.data.evalPlanId,
	        					  courseId:records.data.courseId,
	        					  courseVariantIds:cvFormDataArray.join(),
	        			};
		                Ext.Ajax.request({
		        			  type: 'rest',
		        			  url: SERVERURL.PATH_FIND_RELATIVE_GRADE_TYPE_COURSES,
		        			  method: 'GET',
		        			  params:params,
		        			  async:false,
		        			  success: function(obj, action) {
		        				  if(obj.responseText!=""){
		        					  var data = Ext.decode(obj.responseText);
		        					  if(data.length>0){
		        			        		 for(var i=0;i<data.length;i++){
		        			        			 var cvIds= data[i].id;
		        			        			 cvList=cvList+","+data[i].value;
		        			        			 cvIdArrayData.push(cvIds);
		        			        		 }
		        			        		 cvNameArrayData.push(cvList.slice(1));
		        			        		 
		        			        		 if(!isNullOrEmpty(courseVariantFormId)){
		        			        			 records.set("courseVariantIds",cvFormDataArray);
			        			        		 records.set("coureseVariantList",cvNameArrayData);
			        			        		 form.findField('courseVariant').setValue(cvNameArrayData);
		        			        		 }else{
		        			        			 records.set("courseVariantIds",cvIdArrayData);
			        			        		 records.set("coureseVariantList",cvNameArrayData);
			        			        		 form.findField('courseVariant').setValue(cvNameArrayData);
		        			        		 }		        			        		 
		        			          }
		        				  }
		        			  }
		        		  });
		                
	 				}
	          },
	          /**
	           * Load data in Result Statistics Tab
	           */
	          loadResultStatisticChartAndGridData:function(){
	        	  var $this=this;
	        	  var grid=$this.getMarkgrademastergrid();
	        	  if(grid.getSelectionModel().getCount()>0){
	        		  var records = grid.getSelectionModel().getSelection()[0];
	        		  $this.openMarkGradeDetailTab();
//	        		  var form1=getDistributionchartview();
//	        		  var form=$this.getGradedistributionstatistics().getForm();

	        		  var searchForm = this.getMarkgradequicksearch().getForm();
	        		  var grade = searchForm.findField('grade').getValue();
	        		  var url;
	        		  var params;

	        		  //var store=this.getResultstatisticsdisplaygrid().getStore();
	        		  if(grade){
	        			  url = SERVERURL.RESULT_STATISTICS_DATA_BY_EVAL_SEQ_DETAil_ID;
	        			  params = {
	        					  //evalSeqId:records.data.evalSequenceId
	        					  evalDetailSeqId:records.data.evalSequenceDetailId
	        			  };

	        			  //store.getProxy().api.read=SERVERURL.GET_STUDENT_BY_SEQUENCE_ID;
	        			  store.getProxy().api.read=SERVERURL.GET_STUDENT_DATA_BY_EVAL_SEQ_DETAIL_ID_URL;
	        			  store.getProxy().extraParams = {
	        				  //sequenceId : records.data.evalSequenceId
	        				  evalSeqDetailId : records.data.evalSequenceDetailId
	        			  };
	        			  store.load();

	        		  }else{
	        			  url = SERVERURL.GET_STUDENT_BY_EVALUATION_PLAN_ID;
	        			  params = {
	        					  evaluationPlanId:records.data.evalPlanId,
	        					  courseId:records.data.courseId,
	        					  //courseVariantId:records.data.courseVariantId,
	        					  courseVariantIds:records.data.courseVariantIds.join()
	        			  };

	        			 /* store.getProxy().api.read=SERVERURL.GET_STUDENT_BY_EVALUATION_PLAN_ID;
	        			  store.getProxy().extraParams = {
	        				  evaluationPlanId : records.data.evalPlanId
	        			  };
	        			  store.load();	*/

	        		  }

	        		  /*Ext.Ajax.request({
	        			  type: 'rest',
	        			  url: url,
	        			  method: 'GET',
	        			  params:params,
	        			  success: function(obj, action) {
	        				  if(obj.responseText!=""){
	        					  var data = Ext.decode(obj.responseText);
	        					  form.findField('minMarks').setValue(data.minMarks);
	        					  form.findField('firstQuartile').setValue(data.firstQuartile);
	        					  form.findField('secondQuartile').setValue(data.secondQuartile);
	        					  form.findField('thirdQuartile').setValue(data.thirdQuartile);
	        					  form.findField('mean').setValue(data.mean);
	        					  form.findField('standardDeviation').setValue(data.standardDeviation);
	        					  form.findField('maxMarks').setValue(data.maxMarks);
	        					  form.findField('total').setValue(data.total);
	        				  }
	        			  }
	        		  });*/

	        	  }else{
	        		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	        	  }
	          },
	         /**
	          * Load data in Mark and student based transformation grid 
	          */
	          loadMarkGardeTransformationGrid:function(){
	        	  var $this=this;
	        	  var grid=$this.getMarkgrademastergrid();
	        	  var transformationGrid=$this.getMarkbasedtransformationgrid();
	        	  var stdBasedGrid=$this.getStudentbasedtransformationgrid();
	        	  var searchForm = this.getMarkgradequicksearch().getForm();
	        	  var grade = searchForm.findField('grade').getValue();
	        	  
	        	  var structure=this.getMarkgradedetailtabstructure();
				  var basicDetailForm = structure.down('#basicDetailForm');
				  this.loadResultStatisticDisplayData(basicDetailForm.getForm());
	        	  
	        	  if(grid.getSelectionModel().getCount()>0){
	        		  var records = grid.getSelectionModel().getSelection()[0];

	        		  if(records.data.distributionEntryDate!=null){//records.data.distributionEntryDate
	        			  var date = records.data.distributionEntryDate; 
	        		  }

	        		  if(records.data.gradeType!=null){

	        			  if(grade){
	        				  transformationGrid.getStore().getProxy().extraParams = {
	        					  evaluationDetailSequneceId:records.data.evalSequenceDetailId,
	        					  gradeType : records.data.gradeType
	        				  };
	        				  transformationGrid.getStore().load();

	        				  stdBasedGrid.getStore().getProxy().extraParams = {
	        					  evaluationDetailSequneceId:records.data.evalSequenceDetailId,
	        					  gradeType : records.data.gradeType
	        				  };
	        				  stdBasedGrid.getStore().load();

	        			  }else{
	        				  transformationGrid.getStore().getProxy().extraParams = {
	        					  evaluationPlanId:records.data.evalPlanId,
	        					  gradeType : records.data.gradeType,
	        					  courseId:records.data.courseId,
	        					  courseVariantIds:records.data.courseVariantIds.join(),
	        					  draftGradeDistributionId:records.data.draftGradeDistributionId,
	        					  isTransferMarksToGrade: true
	        					//  periodId:records.data.periodId,
	      		          		//  academicTermId:records.data.academicTermId,
	        				  };
	        				  transformationGrid.getStore().load({
 								 callback: function(record, operation, success) {
	 								 if (record.length > 0) {
	 									var responseText = Ext.decode(operation.response.responseText);
	 									if(Ext.isDefined(responseText.id)){
	 										var draftId = responseText.id;
	 									}
	 									else
	 									{
	 										var draftId = 0;
	 									}
	 									Ext.ComponentQuery.query('#draftId')[0].setValue(draftId);
	 									$this.toggleGridSummaryRow(transformationGrid,true);
	 									
	 									setTimeout(function(){
	 										if(!isNullOrEmpty(localStorage.getItem("totalStudents"))){
	 											var totalStudents = Ext.decode(localStorage.getItem("totalStudents"));
	 											var totalStudentCounts=totalStudents.length;
	 											Ext.each(record, function(currentGridRecord){
	 												var count = 0;
	 												Ext.each(totalStudents, function(currentStudentNumber){
	 													if(currentStudentNumber>=currentGridRecord.data.markRangeFrom && currentStudentNumber<=currentGridRecord.data.markRangeTo){
	 														count = count+1;
	 													}
	 												});
	 												currentGridRecord.set('studentCount',count);
	 												currentGridRecord.set('distributionPoint',((currentGridRecord.data.gradePoint)*(count)));
	 												currentGridRecord.set('percentageOfStudent',((count*100)/totalStudentCounts).toFixed(2)+ "%");
	 												currentGridRecord.modified = {};
	 											});
	 											transformationGrid.getView().refresh();

	 											var distributionprocesschart = $this.getDistributionprocesschart();
	 											var processChart=distributionprocesschart.down('#selectionProcessOverviewColumnChart');
	 											setTimeout(function(){
	 												processChart.getStore().loadData(record);
		 											processChart.redraw();
	 											},300);
		 					        		  }
	 									},300);
	 									
	 									
	 								 }else{
	 									$this.toggleGridSummaryRow(transformationGrid,false);
	 								 }
	 							 }
							});
	        			  }
	        		  }
	        	  }
	          },
	         /**
	          * This function is used to check student range according to the min and max mark range of grade
	          */
	        checkStudentRangeOfMarks:function(obj){
	        	 var $this=this;
	        	 var transformationGrid=$this.getMarkbasedtransformationgrid();
	        	 var records = transformationGrid.getSelectionModel().getSelection()[0];
	        	 var settedRecords = transformationGrid.getSelectionModel().getSelection();
	        	 var models = transformationGrid.getStore().getRange();
	        	 var responseValue=true;
	        	 if (obj.itemId == 'markRangeFromItemId') {
	        		 for (var i=0;i<models.length;i++) { 
	        			 if(!isNullOrEmpty(models[i].data.markRangeFrom) && !isNullOrEmpty(models[i].data.markRangeTo)) {
	        				 if(models[i].index == settedRecords[0].index) {
	        					 responseValue=true;
	        				 } else if (models[i].index != settedRecords[0].index) {
	        					 /*if(obj.getValue() >= models[i].data.markRangeFrom && 
	        					 	obj.getValue() <= models[i].data.markRangeTo) {
	        						 showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_N_RANGE_ALREADY_EXIST'));
	        						 settedRecords[0].set('markRangeFrom',"");
	        						 settedRecords[0].set('markRangeTo',"");
	        						 settedRecords[0].set('studentCount',0);
	        						 responseValue=false;
	        						 return false;
	        					 }*/
	        				 } else {
	        					 responseValue=true;
	        				 }
	        			 } else {
	        				 responseValue=true;
	        			 }
	        		 }
	        	 }
	        	 if(obj.itemId == 'markRangeToItemId') {
	        		 for (var i=0;i<models.length;i++) {
	        			 if(!isNullOrEmpty(models[i].data.markRangeFrom) && !isNullOrEmpty(models[i].data.markRangeTo)) {
	        				 if(models[i].index == settedRecords[0].index) {
	        					 responseValue=true;
	        				 } else if (models[i].index != settedRecords[0].index) {
	        					 /*if(obj.getValue() >= models[i].data.markRangeFrom && 
	        					 	obj.getValue() <= models[i].data.markRangeTo) {
	        						 showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_N_RANGE_ALREADY_EXIST'));
	        						 settedRecords[0].set('markRangeFrom', "");
	        						 settedRecords[0].set('markRangeTo', "");
	        						 settedRecords[0].set('studentCount',0);
	        						 responseValue=false;
	        						 return false;
	        					 }*/
	        				 } else {
	        					 responseValue=true;
	        				 }
	        			 }
	        			 else {
	        				 responseValue=true;
	        			 }
	        		 }
	        	 }
	        	// var form=$this.getResultstatisticdisplaychart().getForm();
	        	 var masterGrid=$this.getMarkgrademastergrid();
	        	 var masterRecord=masterGrid.getSelectionModel().getSelection()[0];

	        	 var gradeStatistics = $this.getGradedistributionstatistics();
	        	 if (!gradeStatistics) {
	        		 Ext.widget('gradedistributionstatistics');
	        		 gradeStatistics = $this.getGradedistributionstatistics();
	        	 }
	        	 var masterrecords = masterGrid.getSelectionModel().getSelection()[0];
	        	 gradeStatistics.getStore().getProxy().extraParams = {
	        		 gradeType : masterrecords.data.gradeType,
	        		 evaluationPlanId:masterrecords.data.evalPlanId,
	        		 //courseVariantId:masterrecords.data.courseVariantId,
	        		 courseVariantIds:masterrecords.data.courseVariantIds.join()

	        	 };
	        	 gradeStatistics.getStore().load();


	        	 //var gradeStatistics=$this.getGradedistributionstatistics();
	        	 	//var totalCount=gradeStatistics.getStore().data.items[0].data.total;
	        	 var searchForm = this.getMarkgradequicksearch().getForm();
	        	 var grade = searchForm.findField('grade').getValue();

	        	 /**
	        	  * Compare min and max range  
	        	  */
	        	 if(records.data.markRangeFrom>=0&&records.data.markRangeTo>=0
	        			 &&!isNullOrEmpty(records.data.markRangeFrom)&&!isNullOrEmpty(records.data.markRangeTo)){
	        		 if(records.data.markRangeFrom>records.data.markRangeTo){
	        			 showWarningMessage(getExaminationTranslation('MARK_RANGE'),getExaminationTranslation('MARK_RANGE_FROM_TO_WRNING_MSG'));
	        			 return false;
	        		 }
	        	 }
	        	/* if(records.data.gradeId!=null&&records.data.markRangeFrom>=0&&records.data.markRangeTo>=0
	        			 &&!isNullOrEmpty(records.data.markRangeFrom)&&!isNullOrEmpty(records.data.markRangeTo)){*/

	        		 var params=null; 
	        		 if(grade){
	        			 params = {
	        					 evaluationPlanId:masterRecord.data.evalPlanId,
	        					 rangeFrom:records.data.markRangeFrom,
	        					 rangeTo:records.data.markRangeTo,
	        					 evalSeqDetailId:masterRecord.data.evalSequenceDetailId
	        					 /*evalSeqId:masterRecord.data.evalSequenceId,
	 	  		   	 	         rangeFrom:records.data.markRangeFrom,
	 	  		   	 	         rangeTo:records.data.markRangeTo*/
	        			 };
	        		 }else{
	        			 params = {
	        					 evaluationPlanId:masterRecord.data.evalPlanId,
	        					 rangeFrom:records.data.markRangeFrom,
	        					 rangeTo:obj.getValue(),
	        					 //courseVariant:masterRecord.data.courseVariantId
	        					 courseVariantIds:masterRecord.data.courseVariantIds.join()
	        			 };
	        		 }
	        		 if (responseValue){
	        			 Ext.Ajax.request({
	        				 type: 'rest',
	        				 url: SERVERURL.CHECK_STUDENT_RANGE_BY_EVAL_SEQ_DETAIL_ID,
	        				 method: 'GET',
	        				 params:params,
	        				 success: function(obj, action) {
	        					 if(obj.responseText!=""){
	        						 var data = Ext.decode(obj.responseText);

	        						 // var total=form.findField('total').getValue();
	        						 //	 var percent=data/totalCount*100;
	        						 Ext.defer(function() {
	        							 if(obj.status == 200){
	        								 records.set('studentCount',data);
	        								 records.set('distributionPoint',data*records.get('gradePoint'));
	        								 records.set('percentageOfStudent',((count*100)/data.length).toFixed(2)+ "%");
	        							 }
	        						 }, 500, this);
	        						 //	 records.set('percentageOfStudents',percent);
	        					 }
	        				 }
	        			 });
	        		 }
	        	 
	         },
	         /**
	          * Submit Data For Student Based and mark based Grid data
	          */
	         saveMarkBasedStudentData:function(grid, button){
	        	 button.disable();
	        	 var $this=this;
	        	 /** "resultStaticsStore" store consist of student list
	        	  * "transformationStore" store used for grade type and other data
	        	  */
	        	 var transformationStore=grid.getStore();
	        	 var markGradeTabStructure=$this.getMarkgradedetailtabstructure();
	        	// var resultStaticsStore=$this.getResultstatisticsdisplaygrid().getStore();
	        	 var tabName = getExaminationTranslation('GRADE_DEFINITION');
	        	 var getcontroller=this.getController('menu.CoreERPNavigationController');
          	   	 var getTab=getcontroller.getTab(tabName);
	        	/* if(resultStaticsStore.data.items.length>0){
	        		 for(var i=0;i<resultStaticsStore.data.items.length;i++){
	        			 var resultStaticsData= resultStaticsStore.data.items[i];
	        			 resultStaticsData.set("upgradeGrade",false);
	        		 }
	        		 
	        	 }*/
          	   	var draftId=Ext.ComponentQuery.query('#draftId')[0].getValue();
          	   if(transformationStore.data.items.length>0){
	        		var submitData=[];
	        		
	        		
	        		var mastergrid = $this.getMarkgrademastergrid();
				    var records = mastergrid.getSelectionModel().getSelection();
				    //var data = records[0].data;
	        		
				    if(records.length){
				    	var data = records[0].data;
				    	localStorage.setItem("selectedRecord",Ext.encode(records[0].data));
				    }
				    else{
				    	try{
				    		var selectedRecord = localStorage.getItem("selectedRecord");
				    		if(selectedRecord){
				    			var data = Ext.decode(selectedRecord);
				    		}
				    	}
				    	catch(e){
				    		//--(no record selected case)
				    	}
				    }
				    
	        		var markGradeForm=$this.getMarkgradetransformationform().getForm();
		        	var formValues=markGradeForm.getValues();
		        	var gridData = [];
		        	var draftGradeDetailData = [];
		        	var searchForm = this.getMarkgradequicksearch().getForm();
	  		        var grade = searchForm.findField('grade').getValue();
	  		        
	  		      draftGradeDetailData.push({
	  		    	  courseVariantIds:data.courseVariantIds.join()
	  		      });
	  		        
	  		        
		        	Ext.each(transformationStore.data.items, function (value) {
		        		if(formValues.grade){
		        			gridData.push({
		        				"grade": value.data.grade,
		        				"gradeId":value.data.gradeId,
		        				"markRangeFrom" : !isNullOrEmpty(value.data.markRangeFrom) ? value.data.markRangeFrom : 0,
		        				"markRangeTo": !isNullOrEmpty(value.data.markRangeTo) ? value.data.markRangeTo : 0,
		        				"percentageOfStudents":value.data.percentageOfStudents,
		        				"studentCount":value.data.studentCount,
		        				//"type": "MARK_BASED",
		        				"evaluationSequenceId": data.evalSequenceId,
		        				"whetherPassingGrade":value.data.whetherPassingGrade,
		        			});
		        		}else{
		        			gridData.push({
		        				"grade": value.data.grade,
		        				"gradeId":value.data.gradeId,
		        				"rankFrom": value.data.rankFrom,
		        				"rankTo": value.data.rankTo,
		        				"studentCount":value.data.studentCount,
		        				"markRangeFrom": value.data.markRangeFrom,
		        				"markRangeTo": value.data.markRangeTo,
		        				//"type": "STUDENT_BASED",
		        				"evaluationSequenceId": data.evalSequenceId,
		        			});
		        		}
		        	});
		        	
		        	/**
		        	 * Check grading type form search screen
		        	 * 
		        	 */
		        	var type;
		        	if(formValues.grade){
		        		type= "MARK_BASED";
		        	}else{
		        		type = "STUDENT_BASED";
		        	}
		        	if(grade){
		        	submitData = {
		        			"id": data.draftGradeDistributionId,
		        			"detailSequenceId": data.evalSequenceDetailId,
		        			"courseId": data.courseId,
		        			"courseVariantId": data.courseVariantId,
		        			"batchId": data.batchId,
		        			"entryDate": new Date(),
		        			"gradeDisributionModels":gridData,
		        			"type":type
		        	};
		        }else{
		        	submitData = {
		        			"id": draftId,
		        			"evaluationPlanId": data.evalPlanId,
		        			"courseId": data.courseId,
		        			"courseVariantId": data.courseVariantId,
		        			"batchId": data.batchId,
		        			"entryDate": new Date(),
		        			"gradeDisributionModels":gridData,
		        			"draftGradeDistributionDetailModel":draftGradeDetailData,
		        			"type":type,
		        			"courseVariantIds": data.courseVariantIds.join(),
//		        			"periodId": data.periodId,
//		        			"academicTermId": data.academicTermId,
		        			"gradeType": data.gradeType,
		        	};
		        }	
		        	Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
		        	
	        		 Ext.Ajax.request({
	  		   	 		 type: 'rest',
	  		   	 		 jsonData:submitData,
	  		   	 		 url: SERVERURL.SAVE_MARK_BASED_GRID_DATA_URL,
	  		   	 		 method: 'POST',
	  		   	 		 success: function(obj, action) {
	  		   	 			 Ext.getBody().unmask();
	  		   	 			 showSuccessMessage(getExaminationTranslation('MARK_TO_GRADE'), getCommonTranslation('SUCCESS'));
	  		   	 			 mastergrid.getStore().reload();
	  		   	 			 Ext.defer(function() {
	  		   	 				 grid.getStore().reload();
	  		   	 				 $this.loadGradePointDistributionChart();
	  		   	 				 Ext.defer(function() {
	  		   	 					 button.enable();
	  		   	 				 }, 500);
	  		   	 			 }, 500, this);

	  		   	 		 }
        		       });
	        	 }
	         },
	         
	         /**
	          * function is call on blur of student from and till percent in student based grid
	          */
	         checkStudentPercentage:function(){
	        	 var $this=this; 
	        	 var studentBasedGrid=$this.getStudentbasedtransformationgrid();
	        	 var records = studentBasedGrid.getSelectionModel().getSelection()[0];
	        	 var masterGrid=$this.getMarkgrademastergrid();
          		 var masterRecord=masterGrid.getSelectionModel().getSelection()[0];
          		 
          		 var searchForm = this.getMarkgradequicksearch().getForm();
	  		     var grade = searchForm.findField('grade').getValue();
	  		        
        		 /**
          		 * Compare student From and till percentage 
          		 */
	  		     if(!isNullOrEmpty(records.data.rankFrom)&&!isNullOrEmpty(records.data.rankTo)){
	          		if(records.data.rankFrom>=0&&records.data.rankTo>=0){
		             		if(records.data.rankFrom>records.data.rankTo){
		             			 showWarningMessage(getExaminationTranslation('MARK_TO_GRADE'),getExaminationTranslation('STUDENT_FROM_TILL_WRNING_MSG'));
		             			 return false;
		             		}
	          		}
        		 
	        	 if(records.data.rankTo!=""&&records.data.rankFrom!=""){
	        		 
	        		 var params;
	        		 if(grade){
	        			 params ={
	        					 //sequenceId:masterRecord.data.evalSequenceId,
	        					 detailSequenceId:masterRecord.data.evalSequenceDetailId,
	        					 fromRank:records.data.rankFrom,
	        					 toRank:records.data.rankTo
	        			 };
	        		 }else{
	        			 params ={
	        					 evaluationPlanId:masterRecord.data.evalPlanId,
	        					 fromRank:records.data.rankFrom,
	        					 toRank:records.data.rankTo
	        			 };
	        		 }
	        		 
	        		 Ext.Ajax.request({
 	  		   	 		 type: 'rest',
 	  		   	 		 url: SERVERURL.STUDENT_BASED_GRADE_CALCULATE_PERCENTAGE_URL,
 	  		   	 		 method: 'GET',
 	  		   	 		 params:params,
 	  		   	 		 success: function(obj, action) {
 	  		   	 		    if(obj.responseText!=""){
 	  		   	 		     var data = Ext.decode(obj.responseText);
 	  		   	 		     records.set('markRangeFrom',data.minMarks);
  		   	 	             records.set('markRangeTo',data.maxMarks);
						     records.set('studentCount',data.count);
 	  		   	 		    }
 	  		   	 		 }
         		   });
	        	}
	  		  }
	         },
	         /**
	          * Second Save function for mark based and student based grid data. 
	          */
	         secondSaveForMarkToGradeData:function(grid){
	        	 var $this=this;
	        	 var form=$this.getRsdtransformation().getForm();
	        	 var evalSeqId=form.findField('evalSeqDetailId').getValue();
	        	 var markGradeForm=$this.getMarkgradetransformationform().getForm();
	        	 var formValues=markGradeForm.getValues();
	        	 if(evalSeqId>0&&evalSeqId!=null){
	        		 var firstGradeData=[];

	        		 /**
	        		  * This request is to fetch programId,batchId,courseId,courseVariantId on bases of eva sequence ID
	        		  */
	        		 Ext.Ajax.request({
	        			 type: 'rest',
	        			 url: SERVERURL.EVAL_DETAIL_SEQ_FOR_MARK_GRADE_URL,
	        			 method: 'GET',
	        			 params:{
	        				 evalSeqDetailId : evalSeqId,
	        				 batchId	:0,
	        				 courseId	:0,
	        				 courseVariantId:	0,
	        				 programId	:0,
	        				 sectionId	:0
	        			 },
	        			 success: function(obj, action) {
	        				 if(obj.responseText!=""){
	        					 var data = Ext.decode(obj.responseText);
	        					 if(data.length>0&&data!=null){

	        						 Ext.each(data, function (value) {
	        							 var firstData={
	        									 "programId":value.programId,
	        									 "batchId":value.batchId,
	        									 "courseId":value.courseId,
	        									 "courseVariantId":value.courseVariantId,
	        									 "evalSequenceId":value.evalSequenceId,
	        									 "evalSequenceDetailId":value.id,
	        									 "enteredBy":1,//TODO data is not in combo so hard cord value
	        									 "entryDate":formValues.entryDate,
	        									 "distributionStatus":getExaminationTranslation('CNTRL_PENDING')
	        							 };
	        							 firstGradeData.push(firstData);
	        						 });

	        						 if(firstGradeData.length>0){
	        							 /**
	        							  * Here First request is for save the all the ids and entryby , entry date ,status
	        							  */
	        							 Ext.each(firstGradeData, function (firstGradeDataValue) { 
	        								 var firstGradeDataValueArray=[firstGradeDataValue];
	        								 Ext.Ajax.request({
	        									 type: 'rest',
	        									 jsonData:firstGradeDataValueArray,
	        									 url: SERVERURL.FIRST_CREATE_MARK_BASED_TRANSFORMATION_DATA_URL,
	        									 method: 'POST',
	        									 success: function(obj, action) {
	        										 var firstSaveData = Ext.decode(obj.responseText);
	        										 if(firstSaveData>0&&firstSaveData!=null){
	        											 var secondGradeData=[];
	        											 var transformationGridStore=grid.getStore();
	        											 if(transformationGridStore.data.items.length>0){	 
	        												 Ext.each(transformationGridStore.data.items, function (value) {
	        													 var secondData={
	        															 "draftGradeDistributionId":firstSaveData,
	        															 "gradeId":value.data.id,
	        															 "enteredBy":1,//TODO entered by is hard cord store is not define in  
	        															 "percentFrom":value.data.markRangeFrom,
	        															 "percentTo":value.data.markRangeTo
	        													 };
	        													 secondGradeData.push(secondData);
	        												 });
	        											 }
	        											 if(secondGradeData.length>0){
	        												 /**
	        												  * Here Second request is for save all percentFrom and percentTo 
	        												  */
	        												 Ext.Ajax.request({
	        													 type: 'rest',
	        													 jsonData:secondGradeData,
	        													 url: SERVERURL.SECOND_CREATE_MARK_BASED_TRANSFORMATION_DATA_URL,
	        													 method: 'POST',
	        													 success: function(obj, action) {
	        														 showSuccessMessage(getExaminationTranslation('MARK_TO_GRADE'), getCommonTranslation('SUCCESS'));
	        														 secondGradeData=[];
	        														 grid.getStore().reload();
	        													 }
	        												 });
	        											 }
	        										 }
	        									 }
	        								 });

	        							 });

	        						 }
	        					 }
	        				 }
	        			 }
	        		 });
	        	 }
	         },
	         
	         getOpenGradeDetailsStructure : function(treePanel, record, item,index, e, eOpts) {
	     		var $this = this;
	     		var resultstatisticdisplaychart = $this.getResultstatisticdisplaychart();
	     		var contentPanel = $this.getContentPanel();
	     		var treeTab = resultstatisticdisplaychart.down('#gradeDetailsId');
	     		var programSelectionProcessStructure = resultstatisticdisplaychart.down('#currentGradeTabPanelId');
	     		
	     		var tabDetail = record.data;
	     		var structure = Ext.widget(tabDetail.reportXtype);

	     		if (!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype) && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
	     			//openTab(contentpanel, tabName, markGradeDetailTab,CONSTANTS.MENU_COLOR_FOUR);
	     			openTab(programSelectionProcessStructure, tabDetail.text,structure,CONSTANTS.MENU_COLOR_FOUR);
	     			treePanel.getSelectionModel().deselectAll();
	     		}
	     	},
	     	
	     	// Grade Master Screen 
	     	
	     	loadGradeMasterdetailsGrid:function(grid){
	        	  	var $this=this;
	        	 	var masterGrid=$this.getMarkgrademastergrid();
	        	    var records = masterGrid.getSelectionModel().getSelection()[0];
	        	    
	        	  	grid.getStore().getProxy().extraParams = {
						gradeType : records.data.gradeType,
						};
	        	  	grid.getStore().load();
	 				if(grid.getSelectionModel().getCount()>0){
	 				 var records = grid.getSelectionModel().getSelection()[0];
		                var data=records.data;
		   	 		    form.findField('evalPlanNo').setValue(data.evaluationPlanNumber);
		   	 		    form.findField('course').setValue(data.courseName);
		   	 	        form.findField('courseVariant').setValue(data.courseVariantCode);
		   	            form.findField('program').setValue(data.programName);
		                form.findField('batch').setValue(data.batchName);
		                form.findField('section').setValue(data.sectionCode);
		                //form.findField('detailSequence').setValue(data.detailSequenceNumber);
		                form.findField('evalSeqDetailId').setValue(data.id);
	 				}
	          },
	          
	          loadGradeDistributiondetailsGrid:function(grid){
	        	  var $this=this;
	        	    var masterGrid=$this.getMarkgrademastergrid();
	        	    var records = masterGrid.getSelectionModel().getSelection()[0];
	        	  	grid.getStore().getProxy().extraParams = {
	        	  		gradeType : records.data.gradeType,
						evaluationPlanId:records.data.evalPlanId,
						//courseVariantId:records.data.courseVariantId,
						 courseVariantIds:records.data.courseVariantIds.join()
						};
	        	  	grid.getStore().load();
	          },
	          
	          loadGradePointDistributionChart : function(grid){
	          	var this$ = this;
	          	//var facultyServiceLevelSearch = this$.getFacultyServiceLevelSearch();
	          	var distributionprocesschart = this$.getDistributionprocesschart();
	          	var processChart=distributionprocesschart.down('#selectionProcessOverviewColumnChart');
	          	var masterGrid=this$.getMarkgrademastergrid();
	          	var records = masterGrid.getSelectionModel().getSelection();
	          	
	          //var data = records[0].data;
        		
			    if(records.length){
			    	var data = records[0].data;
			    	localStorage.setItem("selectedRecord",Ext.encode(records[0].data));
			    }
			    else{
			    	try{
			    		var selectedRecord = localStorage.getItem("selectedRecord");
			    		if(selectedRecord){
			    			var data = Ext.decode(selectedRecord);
			    		}
			    	}
			    	catch(e){
			    		//--(no record selected case)
			    	}
			    }
	          	
	          	var transformationGrid=this$.getMarkbasedtransformationgrid();
	          	/*transformationGrid.getStore().getProxy().extraParams = {
	          		evaluationPlanId:records.data.evalPlanId,
	          		gradeType : records.data.gradeType,
	          		courseVariantId:records.data.courseVariantId
	          	};
	          	transformationGrid.getStore().load();
	          	*/
	        	params = {
	        			evaluationPlanId:data.evalPlanId,
		          		gradeType : data.gradeType,
		          		courseId : data.courseId,
		          		courseVariantIds:data.courseVariantIds.join(),
		          		draftGradeDistributionId:data.draftGradeDistributionId,
		          		isTransferMarksToGrade: true
		          		//periodId:data.periodId,
//		          		academicTermId:data.academicTermId,
  			  	};
	          	 //Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
	              Ext.Ajax.request({
	                  type: 'rest',
	                  url: SERVERURL.GRADE_GROUP_MAPPING_ITEMSELECTOR_STORE_URL,
	                  method: 'GET',
	                  params:params,
	                  headers: {
	                      'Content-Type': 'application/json'
	                  },
	                  //jsonData:records,
	                  success: function(response) {
	                	  //Ext.getBody().unmask();
	                	  data = Ext.decode(response.responseText);
	                	  Ext.defer(function() {
	                		  processChart.getStore().loadData(data.gradeDisributionModels);
	                		  processChart.redraw();
	                	  }, 500, this);
	                  }
	              });
	          },
	          
	          loadGradeDistributionStatistics : function(grid){
	        	  var $this=this;
	        	  var masterGrid=$this.getMarkgrademastergrid();
	        	  var records = masterGrid.getSelectionModel().getSelection()[0];
	        	  var gradeDistributionstatisticsGrid=$this.getGradedistributionstatistics();
	        	  var store=gradeDistributionstatisticsGrid.getStore();

	        	  store.getProxy().extraParams = {
	        		  evaluationPlanId : records.data.evalPlanId,
	        		  gradeType : records.data.gradeType,
	        		  //courseVariantId:records.data.courseVariantId,
	        		  courseVariantIds:records.data.courseVariantIds.join(),
	        		  courseId:records.data.courseId,
//	        		  academicTermId:records.data.academicTermId,
	        		//  periodId:records.data.periodId
	        	  };
	        	  store.load();
	          },
	          
	          saveUpdateGrade: function(model, records,obj) {
	      		var $this = this;
	      		var grademasteradd = $this.getAddgradetypewin();
	      		var grid=$this.getMarkbasedtransformationgrid();
	      		var gradeNameValue=grademasteradd.down('#gradeName').getValue();
	      		var gradeRangeFromValue=grademasteradd.down('#gradeRangeFrom').getValue();
	      		var gradeRangeToValue=grademasteradd.down('#gradeRangeTo').getValue();
	     		var gradePointValue=grademasteradd.down('#gradePoint').getValue();
	     		var id=grademasteradd.down('form').getForm().findField('id').getValue();
	     		
	      		//var form = grademasteradd.getForm();
	      		var grade = new Academia.model.gradeMaster.GradeMasterModel();
	      		grade.set("id", id);
	      		grade.set("gradeName", gradeNameValue);
	      		grade.set("gradeType", 'Relative');
	      		grade.set("minPercent", null);
	      		grade.set("maxPercent", null);
	      		grade.set("gradeRangeFrom", gradeRangeFromValue);
	      		grade.set("gradeRangeTo",gradeRangeToValue);
	      		grade.set("hasGroup",true);
	      		grade.set("gradeStatus", 'ACTIVE');
	      		grade.set("gradePoint", gradePointValue);
	      		var submitUrl;
	      		
	      		if (grademasteradd.down('form').getForm().findField('id').getSubmitValue() == null
	      				|| grademasteradd.down('form').getForm().findField('id').getSubmitValue() == "") {
	      			submitUrl = SERVERURL.GRADE_MASTER_ADD;
	      		} else {
	      			grade.set("id", id);
	      			submitUrl = SERVERURL.GRADE_MASTER_UPDATE_URL;
	      		}
	      		var formData = Ext.encode(grade.data);
	      		Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
	      		Ext.Ajax.request({
	      			type : 'rest',
	      			url : submitUrl,
	      			jsonData : formData,
	      			method : 'POST',
	      			success : function(fm, action) {
	      				Ext.getBody().unmask();
	      				if(fm.responseText==getExaminationTranslation('GRADE_MASTER_SAVE_DUPLICATE_CHECK')){
	      					showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_N_RANGE_ALREADY_EXIST'));
	      				}else if(fm.responseText==getExaminationTranslation('GRADE_RANGE_SAVE_CHECK')){
	      					showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_RANGE_ALREADY_EXIST'));
	      				}else {
	      					showSuccessMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_SUCCESS_MSG'));
	      					
	      				}
	      				grid.getStore().reload();
	      				$this.resetGradeType();
	      			}
	      		});
	          },
	          
	          resetGradeType:function(obj){
           	   this.getAddgradetypewin().close();
              },
              
              disableMoreActionPivileges: function(gridReference,permissionsMap) {
            	  var $this=this;
            	  var associatedAcadLocationIds = new Array();
            	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            	  var form = this.getMarkgradetransformationform();
            	  var getForm = form.getForm();
            	  var grid=this.getMarkgrademastergrid();
            	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	  buttonsToolBar = gridReference.query('toolbar')[0];
            	  var saveButton=form.down('#btnSave');
            	  saveButton.setVisible(false);
            	  Ext.each(permissionList, function(privilege) {
            		  if (privilege === 'SAVE') {
            			 saveButton.setVisible(true);
            		  }
            	  });
              },
              //********** Mark Based Transform Student Detail Grid************//
              getMarkBasedTranformationStudentCountDetails : function(grid,record){
             	 var $this=this;
             	 var formWindow = $this.getTransformmarksstudentcountwindow();
             	 if (!formWindow) {
             		 Ext.widget('transformmarksstudentcountwindow');
             		 formWindow = $this.getTransformmarksstudentcountwindow();
             	 }
             	 var markBasedStore = this.getStore('examinationcenters.markgrade.StoMarkBasedTransformStudentGridStore');
             	 var listGrid=formWindow.down('#vwexamtransformstudentdetailwindow');
    	            var paginationStore = listGrid.getDockedItems()[2].items.items[0];
             	 listGrid.bindStore(markBasedStore);
             	 paginationStore.bindStore(markBasedStore);
             	 var masterGrid=$this.getMarkgrademastergrid();
	        	 var masterRecord=masterGrid.getSelectionModel().getSelection()[0];
	        	 var formValues=this.getMarkgradedetailtabstructure().down('#basicDetailForm').getForm().getValues();
	        	 var evaluationPlanId=null;
	        	 var courseId=null;
	        	 
	        	 if(masterRecord!=null){
	        		 evaluationPlanId=masterRecord.data.evalPlanId;
	        		 courseId=masterRecord.data.courseId;
	        	 } else {
	        		 evaluationPlanId=formValues.evaluationPlanId;
	        		 courseId=formValues.courseId;
	        	 }
	        	 
	        	 
             	 var store = listGrid.getStore();
             	 var courseVariantIds=[]; 
             	 if(masterRecord!=null && !isNullOrEmpty(masterRecord.data.courseVariantIds)){
             		courseVariantIds=masterRecord.data.courseVariantIds.join();
             	 }else {
             		 if(!isNullOrEmpty(formValues.courseVariantIds)){
             			courseVariantIds=formValues.courseVariantIds
             		 } 
             	 }
             	 var markRangeFrom;
             	 var markRangeTo;
             	 if(!isNullOrEmpty(record)){
             		markRangeFrom = record.data.markRangeFrom;
             		markRangeTo = record.data.markRangeTo;
             	 }else{
             		markRangeFrom = null; 
             		markRangeTo=null;
             	 }
             	 store.getProxy().extraParams = {
             		 evaluationPlanId:evaluationPlanId,
             		 courseId:courseId,
	        		 courseVariantIds:courseVariantIds,
	        		 markRangeFrom:markRangeFrom,
	        		 markRangeTo:markRangeTo,
	        		 limit:5,
		        	 sort:null
             	 };
             	 store.loadPage(1);
             	 formWindow.show();
             	 $this.disableExportActionPivileges(listGrid,this.getTRANSFER_MARK_TO_GRADE_PERMISSION());
              },
              
              disableExportActionPivileges: function(gridReference,permissionsMap) {
            	  var $this=this;
            	  var associatedAcadLocationIds = new Array();
            	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            	  var form = this.getMarkgradetransformationform();
            	  var getForm = form.getForm();
            	  var grid=this.getMarkgrademastergrid();
            	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
            	  var pdfButton=buttonsToolBar.query('#btnExportToPDF')[0];
          		  var excelButton=buttonsToolBar.query('#btnExportToExcel')[0];
          		  pdfButton.setVisible(false);
          		  excelButton.setVisible(false);
            	  Ext.each(permissionList, function(privilege) {
            		  if (privilege === 'GRADE_DISTRIBUTION_EXPORT') {
            			  pdfButton.setVisible(true);
                  		  excelButton.setVisible(true);
            		  }
            	  });
              },
});