/**
 * @author sumit.meena
 * 
 */
Ext.define('Academia.controller.examinationcenters.repetitioncompletion.RepetitionCompletionController', {
	//xtend : 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	stores : ['examinationcenters.repetitioncompletion.RnCEvaluationGroup','examinationcenters.repetitioncompletion.RnCProgramsByCourseNComponent','examinationcenters.repetitioncompletion.CourseCompletionStatus',
	          'examinationcenters.repetitioncompletion.RepetitionFor','examinationcenters.repetitioncompletion.RepetitionType',
	          'examinationcenters.repetitioncompletion.ManageRepetitionCompletion','examinationcenters.repetitioncompletion.CourseComponentRepeated','examinationcenters.repetitioncompletion.DetailSequenceRepeated',
	          'examinationcenters.repetitioncompletion.EquivalentDetailSequence','examinationcenters.repetitioncompletion.NewCourseVariant','course.courseequivalence.CourseComponentEquivalenceStore',
	          'examinationcenters.repetitioncompletion.RnCProgramsByVariantNAcadLocId','examinationcenters.repetitioncompletion.DetailSequenceRepeatedSaveStudent',
	          'examinationcenters.repetitioncompletion.AddRepetitionGridStore','examinationcenters.repetitioncompletion.RnCFeePlan','examinationcenters.repetitioncompletion.RnCSequenceByFeePlan',
	          'attendance.VariantMappedToPlan','examinationcenters.repetitioncompletion.RnCStageByFeePlanRule','examinationcenters.repetitioncompletion.RnCCoureVariantByCourseIds','examinationcenters.roomallocation.RoomAllocationCourses',
	          'common.BatchesByProgramId','coursetransaction.sectionmanagement.SectionMultiSelect','examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupDetailSequenceConflicts',
	          'feeandpayment.feerequest.ApprovalStatus','examinationcenters.evaluation.CourseofAllPlan','examinationcenters.CenterResponisble',
	          'examinationcenters.repetitioncompletion.RepetitionCompletionEnum','attendance.VariantMapping'],
	views : ['examinationcenters.repetitioncompletion.RepetitionCompletionStructure','examinationcenters.repetitioncompletion.RepetitionCompletionFilter',
	         'examinationcenters.repetitioncompletion.managerepetitioncompletion.ManageRepetitionCompletionFilter','examinationcenters.repetitioncompletion.managerepetitioncompletion.ManageRepetitionCompletionStructure',
	         'examinationcenters.repetitioncompletion.managerepetitioncompletion.ManageRepetitionCompletionForm','examinationcenters.repetitioncompletion.managerepetitioncompletion.DetailSequenceRepeatedGrid',
	         'examinationcenters.repetitioncompletion.EvaluationToBeRepeatedWin','examinationcenters.repetitioncompletion.ApproverWindow',
	         'examinationcenters.repetitioncompletion.managerepetitioncompletion.DetailSequenceRepeatedSaveStudentGrid','examinationcenters.repetitioncompletion.managerepetitioncompletion.AddRepetitionGrid'],
   config:{
	  			REPITITION_AND_COMPLETION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REPITITION_AND_COMPLETION_PRIVILEGES'),
	  			MANAGE_REPETITION_AND_COMPLETION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_REPETITION_AND_COMPLETION_PRIVILEGES')
   		},	         
	          refs : [{
		        	  ref:'repetitioncompletionfilter',
	                  selector:'repetitioncompletionfilter'
	               },{
		        	  ref:'contentPanel',
	                  selector:'contentPanel'
	               },{
		        	  ref:'repetitionNcompletionGrid',
	                  selector:'searchresultgrid[itemId=repetitionNcompletionGridItemId]'
	               },{
			          ref:'evaluationtoberepeatedwingrid',
		              selector:'searchresultgrid[itemId=evaluationtoberepeatedwingridItemId]'
		           },{
		        	  ref:'managerepetitioncompletionform',
	                  selector:'managerepetitioncompletionform'
	               },{
		        	  ref:'evaluationtoberepeatedwin',
	                  selector:'evaluationtoberepeatedwin'
	               },{
		        	  ref:'managerepetitioncompletiongrid',
	                  selector:'managerepetitioncompletiongrid'
	               },{
		        	  ref:'markrepetitioncompletionfilter',
	                  selector:'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId]'
	               },{
		        	  ref:'addrepetitioncompletionfilter',
	                  selector:'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId]'
	               },{
		        	  ref:'detailsequencerepeatedgrid',
	                  selector:'detailsequencerepeatedgrid'
	               },{
		        	  ref:'approverwindow',
	                  selector:'approverwindow'
	               },{
		        	  ref:'approverWindowForm',
	                  selector:'approverwindow form'
	             /*  },{
		        	  ref:'detailsequencerepeatedsavestudentgrid',
	                  selector:'detailsequencerepeatedsavestudentgrid'*/
	               },{
		        	  ref:'addrepetitiongrid',
	                  selector:'addrepetitiongrid'
	               },{
		        	  ref:'managerepetitioncompletionstructure',
	                  selector:'managerepetitioncompletionstructure'
	               },{
			        	  ref:'repetitioncompletionstructure',
		                  selector:'repetitioncompletionstructure'
		           },{
	                	 ref: 'searchresultgrid',
	                	 selector: 'searchresultgrid[itemId=repetitionNcompletionGridItemId]'
	               }],
	          init : function() {
	        	  this.control({
	        		  'searchresultgrid[itemId=repetitionNcompletionGridItemId]':{
	        			render:function(grid){
	        				this.gridRenderFunction(grid);
	        				this.genericCBGridAccessControlValidation(grid,this.getREPITITION_AND_COMPLETION_PERMISSION());
	        				this.disableMoreActionPivileges(grid,this.getREPITITION_AND_COMPLETION_PERMISSION());
	        			},
	        			cellclick:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts){
	        				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	        				if(columnName == "EVAL_TO_BE_REPEATED"){
	        					if(e.target.tagName=='A'){
	        						//if(colIndex==12){
	        						this.openEvaluationtoberepeatedwin();  
	        						this.loadEvaluationToBeRepeatedWin(record.data.ADMISSION_ID);	        						
	        						//}
	        					}
	        				}
	        			}
	        		  },
	        		  'searchresultgrid[itemId=repetitionNcompletionGridItemId] button[itemId=searchResultGridBtnAdd]':{
		        			click:function(){
		        				this.openManageRepetitionCompletionTab();
		        			}  
		        	  },
		        	  'repetitioncompletionfilter button[itemId=resetBtn]':{
			        		click:function(obj){
			        			var filterForm=obj.up('form').getForm();
			        			filterForm.findField('courseId').setDisabled(true);
			        			filterForm.findField('componentId').setDisabled(true);
			        			filterForm.findField('courseVariantId').setDisabled(true);
			        			filterForm.findField('programId').setDisabled(true);
			        			filterForm.findField('batchId').setDisabled(true);
			        			filterForm.findField('sectionId').setDisabled(true);
			        			filterForm.findField('evalSeqId').setDisabled(true);
			        			filterForm.reset();
			        		}  
		        	  },
	        		  'repetitioncompletionfilter customcombobox[itemId=evalGroupItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var data=rec[0].data.id;
	        				  /**
	        				   * Load course , evaluation event and program on the bases of evaluation group id 
	        				   */
	        				  var courseIdField=form.findField('courseId');
	        				  var evalSeqIdField=form.findField('evalSeqId');
	        				  var programIdField=form.findField('programId');
	        				  programIdField.enable();
	        				  courseIdField.enable();
	        				  courseIdField.reset();
	        				  courseIdField.getStore().getProxy().extraParams = {
	        					  evaluationGroupIds: data
	   	    				   };
	        				  courseIdField.getStore().load();
	        				  
	        				  evalSeqIdField.enable();
	        				  evalSeqIdField.getStore().getProxy().extraParams = {
	        					  evaluationGroupId: data
	   	    				   };
	        				  evalSeqIdField.getStore().load();
	        				  
	        				  programIdField.getStore().getProxy().extraParams = {
	        					  evaluationGroupId: data
	   	    				   };
	        				  programIdField.getStore().load();
	        			  }
	        		  },
	        		  'repetitioncompletionfilter customcombobox[itemId=courseItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var alinfomodel = Academia.model.authentication.ALInfoModel;
			                  var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				  var data=rec[0].data.id;
	        				  /**
	        				   * Load Course Component and Course Variant on the bases of course 
	        				   */
	        				  var componentIdField=form.findField('componentId');
	        				  componentIdField.enable();
	        				  componentIdField.getStore().getProxy().extraParams = {
	        					  id: data
	   	    				   };
	        				  componentIdField.getStore().load();
	        				  
	        				  var courseVariantIdField=form.findField('courseVariantId');
        				      courseVariantIdField.enable();
        				      courseVariantIdField.reset();
        	        		  courseVariantIdField.getStore().getProxy().extraParams = {
        	        			  courseIds: data,
        	        			  wheatherSchool:wheatherSchool
        	    				   };
        	        		  courseVariantIdField.getStore().load();
	        	        	  
	        			  }
	        		  },
	        		  'repetitioncompletionfilter customcombobox[itemId=programItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var data=rec[0].data.id;
	        				  var batchIdField=form.findField('batchId');
	        				  batchIdField.enable();
	        				  batchIdField.getStore().getProxy().extraParams = {
	        					  id: data,
	        					  isActive:true
	   	    				   };
	        				  batchIdField.getStore().load();
	        			  }
	        		  },
	        		  'repetitioncompletionfilter customcombobox[itemId=batchItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var sectionIdField=form.findField('sectionId');
	        				  sectionIdField.enable();
	        				  /**
	        				   * it is to send string values comma separated to fetch programs.
	        				   */
	        				  var batchIds=new Array();
	        				  if(rec.length>0){
	        					  Ext.Array.each(rec,function(value,index){
	        						  batchIds.push(value.data.id);
	        					  });
	        				  }
	        				  sectionIdField.getStore().getProxy().extraParams = {
	        					  batchIds: batchIds.join()  
	   	    				   };
	        				  sectionIdField.getStore().load();
	        			  }
	        		  },
	        		  'repetitioncompletionfilter customcombobox[itemId=courseCompletionStatusId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var data=form.findField('courseCompletionStatus').getValue();
	        				  var evalSeqIdField=form.findField('evalSeqId');
	        				  var repetitionForField=form.findField('repetitionFor');
	        				  var repetitionTypeField=form.findField('repetitionType');
	        				 
	        				  evalSeqIdField.reset();
	        				  repetitionForField.reset();
	        				  repetitionTypeField.reset();
	        				  
	        				  evalSeqIdField.setVisible(false);
	        				  repetitionForField.setVisible(false);
	        				  repetitionTypeField.setVisible(false);
	        				  /**
	        				   * Hide and show fields on the bases of status
	        				   */
	        				  if(data==getExaminationTranslation('CNTRL_PASS')){
	        					  if(evalSeqIdField.getStore().data.length>0){
	        						  evalSeqIdField.enable();
	        					  }
	        					  evalSeqIdField.setVisible(true);
		        				  repetitionForField.setVisible(true);
		        				  repetitionTypeField.setVisible(true);
	        				  }
	        			  }
	        		  },
	        		  'repetitioncompletionfilter button[itemId=searchBtn]' : {
							click : this.loadRepetitionCompletionFilter
					  },
					  /*************Mark Repetition Completion Start**************/
					 /* 'managerepetitioncompletionstructure':{
						  tabchange:function(tabPanel, newCard, oldCard){
	        				  *//**
	        				   * Reset form when ever search form get open. 
	        				   *//*
							  var filterFormNewCard = newCard.items.items[0].getForm();
							  var completionStatusField=filterFormNewCard.findField('courseCompletionStatus');
							  var detailSequenceIdField=filterFormNewCard.findField('detailSequenceId');
							      detailSequenceIdField.setVisible(true);
							  if(newCard.title==getExaminationTranslation('MARK_COMPLETION_AND_REPETITION')){
								  detailSequenceIdField.allowBlank=false;
								  completionStatusField.allowBlank=false;
								  completionStatusField.setFieldLabel(getExaminationTranslation('COURSE_COMPLETION_STATUS')+'<span class="required" style="color:red"> *</span>');
							  }else if(newCard.title==getExaminationTranslation('ADD_REPETITION_DETAILS')){
								  detailSequenceIdField.allowBlank=true;
								  detailSequenceIdField.setVisible(false);
								  completionStatusField.allowBlank=true;
								  completionStatusField.setFieldLabel(getExaminationTranslation('COURSE_COMPLETION_STATUS'));
							  }
							  //filterFormNewCard.isValid();
							  var filterFormOldCard = oldCard.items.items[0].getForm();
							  filterFormOldCard.reset();
							 
							 var gridStore= oldCard.items.items[1].getStore();
							 if(gridStore.getCount()>0){
								 gridStore.removeAll();
							 }
	        			  }
	        		  },*/
					  /*'managerepetitioncompletionfilter':{
			        		render:function(obj){
			        			var $this=this;
			        			var filterForm=$this.getMarkrepetitioncompletionfilter();
			        			var formValues=filterForm.getValues();
			        			var grid=$this.getManagerepetitioncompletiongrid();
			        			var store=grid.getStore();
			        			    store.getProxy().extraParams = {
		        					    courseId:formValues.courseId,
		        					    courseVariantId:formValues.courseVariantId,
		        					    programId:formValues.programId,
		        					    batchId:formValues.batchId,
		        					    sectionId:formValues.sectionId,
		        					    examResultStatus:formValues.courseCompletionStatus,
		        					   // detailSequenceId:formValues.detailSequenceId
		   	    				        };
			        			    store.load();
			        		}  
		        	  },*/
	        		  /**
	        		   * Load Grid on the bases of Mark repetition completion filter
	        		   */
		        	  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] button[itemId=searchBtn]':{
			        		click:function(obj){
			        			var $this=this;
			        			var filterForm=$this.getMarkrepetitioncompletionfilter();
			        			var formValues=filterForm.getValues();
			        			var grid=$this.getManagerepetitioncompletiongrid();
			        			var store=grid.getStore();
			        			    store.getProxy().extraParams = {
		        					    courseId:formValues.courseId,
		        					    courseVariantId:formValues.courseVariantId,
		        					    programId:formValues.programId,
		        					    batchId:formValues.batchId,
		        					    sectionId:formValues.sectionId,
		        					    examResultStatus:formValues.courseCompletionStatus,
		        					   // detailSequenceId:formValues.detailSequenceId
		   	    				        };
			        			    store.load();
			        		}  
		        	  },
		        	  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] button[itemId=resetBtn]':{
			        		click:function(obj){
			        			var filterForm=obj.up('form').getForm();
			        			filterForm.findField('courseVariantId').setDisabled(true);
			        			filterForm.findField('programId').setDisabled(true);
			        			filterForm.findField('courseVariantId').setDisabled(true);
			        			filterForm.findField('batchId').setDisabled(true);
			        			filterForm.findField('sectionId').setDisabled(true);
			        			filterForm.reset();
			        		}  
		        	  },
	        		  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] customcombobox[itemId=courseItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var $this = this;
	        				  var form=obj.up('form').getForm();
	        				  /**
	        				   * Load Course variant on the bases of course
	        				   */
	        				  var courseVariantIdField=form.findField('courseVariantId');
	        				  courseVariantIdField.enable();
	        				  courseVariantIdField.getStore().getProxy().extraParams = {
	        					  courseId: data,
	        					  academyLocationId : $this.getCurrentAcademyLocation()
	   	    				   };
	        				  courseVariantIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] customcombobox[itemId=courseVariantItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var programIdField=form.findField('programId');
	        				  programIdField.enable();
	        				  programIdField.getStore().getProxy().extraParams = {
	        					  courseVariantIds: data
	   	    				   };
	        				  programIdField.getStore().load();
	        				  
	        				/*  var detailSequenceIdField=form.findField('detailSequenceId');
	        				  detailSequenceIdField.enable();
	        				  detailSequenceIdField.getStore().getProxy().extraParams = {
	        					  courseVariantId: data
	   	    				   };
	        				  detailSequenceIdField.getStore().load();*/
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] customcombobox[itemId=programItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var data=rec[0].data.id;
	        				  var batchIdField=form.findField('batchId');
	        				  batchIdField.enable();
	        				  batchIdField.getStore().getProxy().extraParams = {
	        					  id: data,
	        					  isActive:true
	   	    				   };
	        				  batchIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] customcombobox[itemId=batchItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var sectionIdField=form.findField('sectionId');
	        				  sectionIdField.enable();
	        				  sectionIdField.getStore().getProxy().extraParams = {
	        					  batchIds:data 
	   	    				   };
	        				  sectionIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=markrepetitioncompletionfilterItemId] customcombobox[itemId=courseCompletionStatusItemId]':{
	        			  select:function(obj,rec){
	        				  /**
	        				   * This condition is used to remove record from grid while switching course completion status
	        				   */
	        				  var grid=this.getManagerepetitioncompletiongrid();
	        				  if(grid.getStore().data.items.length>0){
	        					  grid.getStore().removeAll();
	        				  }
	        			  }
	        		  },
	        		  'managerepetitioncompletiongrid':{
	        			  render:function(grid){
		        			/*	this.doAccessControlValidation(grid,this.getMANAGE_REPETITION_AND_COMPLETION_PERMISSION());
		        				this.disableMoreActionPivilegesForManageRepetitionAndCompletion(grid,this.getMANAGE_REPETITION_AND_COMPLETION_PERMISSION());*/
		        				grid.getStore().removeAll();
		        			},
	        			  cellclick:function(view, rowindex, colIndex, record, event,target,pop){
	        			      var $this=this; 
	        				  var columnName = view.ownerCt.columnManager.columns[colIndex].dataIndex;
	  	        				if(pop.target.tagName=='A'){
	        					      $this.openManageRepetitionCompletionFormTab();
	        						  var form=$this.getManagerepetitioncompletionform().getForm();
	        						  form.findField('examinationRepetitionId').setValue(record.data.examinationRepetitionId);
	        						  form.findField('admissionId').setValue(record.data.admissionId);
	        						  form.findField('studentName').setValue(record.data.studentName);
	        						  form.findField('courseId').setValue(record.data.courseId);
	        						  form.findField('gridRecordcourseVariantId').setValue(record.data.courseVaraintId);
	        						  /**
	        						   * combine grade name and markObtained in single parameter in mark obtained
	        						   */
	        						  var markGradeValues=null;
		                  		    	if(!isNullOrEmpty(record.data.markObtained)){
		                  		    		markGradeValues=record.data.markObtained;
		                  		    	}else{
		                  		    		markGradeValues=record.data.gradeName;
		                  		    	}
	        						  form.findField('markObtained').setValue(markGradeValues);
	        						  form.findField('sectionId').setValue(record.data.sectionId);
	        						  form.findField('examResultStatus').setValue(record.data.examResultStatus);
	        						  form.findField('repeatOrComplete').setValue(record.data.repeatOrComplete);
	        						  form.findField('courseName').setValue(record.data.courseName);
	        						  form.findField('courseVariantName').setValue(record.data.courseVaraintName);
	        						  /**
	        		            	   * At the time of edit hide fields on the bases of examinationRepetitionIdValue. 
	        		            	   */
	        						  var detailSeqGrid=$this.getDetailsequencerepeatedgrid();
	        						  detailSeqGrid.columns[2].setVisible(false);
	        		            	  if(!isNullOrEmpty(record.data.examinationRepetitionId)){
	        		            		  var courseVariantIdField=form.findField('courseVariantId');
	        		            		  courseVariantIdField.setVisible(true);
	        		            		  courseVariantIdField.setDisabled(false);
	        		            		  courseVariantIdField.allowBlank=false;
	        		            		  courseVariantIdField.setFieldLabel(getExaminationTranslation('NEW_COURSE_VARIANT')+'<span class="required" style="color:red"> *</span>');
		    	        				  courseVariantIdField.getStore().getProxy().extraParams = {
		    	        					  admissionId:record.data.admissionId
		    	   	    				   };
		    	        				  courseVariantIdField.getStore().load({
		    	        					  callback:function(records, options, success){
		    	        						  var courseVarIds=[];
		    	        						  Ext.Array.each(records,function(value){
		    	        							  courseVarIds.push(value.data.id);
		    										});
		    	        						  courseVariantIdField.setValue(courseVarIds);
		    	        					  }
		    	        				  });
		    	        				  /**
		    	        				   * 1. Show columns of detail sequence grid at the time of edit.
		    	        				   * 2. Show fields of fees.  
		    	        				   */
		    	        				 var  repetitionFeePlanField=form.findField('repetitionFeePlan');
		    	        				  repetitionFeePlanField.setVisible(true);
		    	        				  repetitionFeePlanField.getStore().getProxy().extraParams = {
		    	        					  courseId:record.data.courseId,
		    	        					  programBatchSeatConfigId:record.data.programBatchSeatConfigId
		    	   	    				   };
		    	        				  repetitionFeePlanField.getStore().load();
		    	        				  form.findField('repetitionFeePlanSequence').setVisible(true);
		    	        				  form.findField('repetitionFeePlanStage').setVisible(true);
		    	        				  
		    	        				  detailSeqGrid.columns[2].setVisible(true);
		    	        				  detailSeqGrid.columns[3].setVisible(true);
	        		            	  }
	        		            	  /**
	        						   * list for detail sequence grid to save
	        						   */
	        						  detailSeqGrid.getStore().getProxy().extraParams={
	        							  admissionId:record.data.admissionId
	        						  };
	        						  detailSeqGrid.getStore().load();	
	        						  /**
	        						   * Load Course Component repeated and detail sequence grid n the bases of course id and admission id
	        						   */
	        						  var courseComponentField=form.findField('courseComponentId');
	        						  courseComponentField.getStore().getProxy().extraParams = {
	        							  courseVariantId:record.data.courseVariantId, 
	        							  admissionId:record.data.admissionId
	    	   	    				   };
	        						  courseComponentField.getStore().load();
	  	        			 }
	        			  }
	        		  },
	        		  'managerepetitioncompletiongrid button[itemId=btnRepetion]':{
	        			  click:function(obj){
	        				  var $this=this;
	        				  var grid=$this.getManagerepetitioncompletiongrid();
	        				  /**
	 		        	      *It is used to close editing cell in grid.
	 		        	      */
	        				  editor = grid.findPlugin('cellediting');
                              editor.completeEdit();
	        				  var form=$this.getMarkrepetitioncompletionfilter().getForm();
	        				  var completionStatus=form.findField('courseCompletionStatus').getValue();
	        				  if(completionStatus!=null){
	        					  $this.savePassFailStudentDetailRepetion();
	        				  }else{
	        					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_COURSE_COMPLETION_STATUS'));
	        				  }
	        			  }
	        		  },
	        		  
	        		  'managerepetitioncompletiongrid button[itemId=btnCompletion]':{
	        			  click:function(obj){
	        				  var $this=this;
	        				  var grid=$this.getManagerepetitioncompletiongrid();
	        				  /**
	 		        	      *It is used to close editing cell in grid.
	 		        	      */
	        				  editor = grid.findPlugin('cellediting');
                              editor.completeEdit();
	        				  var form=$this.getMarkrepetitioncompletionfilter().getForm();
	        				  var completionStatus=form.findField('courseCompletionStatus').getValue();
	        				  if(completionStatus!=null){
	        					  $this.savePassFailStudentDetail();
	        				  }else{
	        					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_COURSE_COMPLETION_STATUS'));
	        				  }
	        			  }
	        		  },
	        		  /*************Mark Repetition Completion End**************/
	        		  
	        		  /*************Add repetition completion Start************/
	        		  /**
	        		   * Load Grid on the bases of Add repetition completion filter
	        		   */
	        		  // This functionality is not in use of add repetition its included to its previous screen.
		        	  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] button[itemId=searchBtn]':{
			        		click:function(obj){
			        			var $this=this;
			        			var filterForm=$this.getAddrepetitioncompletionfilter();
			        			var formValues=filterForm.getValues();
			        			var grid=$this.getAddrepetitiongrid();
			        			var store=grid.getStore();
			        			    store.getProxy().extraParams = {
		        					    courseId:formValues.courseId,
		        					    courseVariantId:formValues.courseVariantId,
		        					    programId:formValues.programId,
		        					    batchId:formValues.batchId,
		        					    sectionId:formValues.sectionId
		   	    				        };
			        			    store.load();
			        		}  
		        	  },
		        	  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] button[itemId=resetBtn]':{
			        		click:function(obj){
			        			obj.up('form').getForm().reset();
			        		}  
		        	  },
	        		  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] customcombobox[itemId=courseItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  /**
	        				   * Load Course variant on the bases of course
	        				   */
	        				  var courseVariantIdField=form.findField('courseVariantId');
	        				  courseVariantIdField.enable();
	        				  courseVariantIdField.getStore().getProxy().extraParams = {
	        					  courseIds: data
	   	    				   };
	        				  courseVariantIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] customcombobox[itemId=courseVariantItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var programIdField=form.findField('programId');
	        				  programIdField.enable();
	        				  programIdField.getStore().getProxy().extraParams = {
	        					  courseVariantIds: data
	   	    				   };
	        				  programIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] customcombobox[itemId=programItemId]':{
	        			  select:function(obj,rec){
	        				  var form=obj.up('form').getForm();
	        				  var data=rec[0].data.id;
	        				  var batchIdField=form.findField('batchId');
	        				  batchIdField.enable();
	        				  batchIdField.getStore().getProxy().extraParams = {
	        					  id: data,
	        					  isActive:true
	   	    				   };
	        				  batchIdField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionfilter[itemId=addrepetitioncompletionfilterItemId] customcombobox[itemId=batchItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var sectionIdField=form.findField('sectionId');
	        				  sectionIdField.enable();
	        				  sectionIdField.getStore().getProxy().extraParams = {
	        					  batchIds:data 
	   	    				   };
	        				  sectionIdField.getStore().load();
	        			  }
	        		  },
	        		  'addrepetitiongrid':{
	        			  cellclick:function(view, rowindex, colIndex, record, event,target,pop){
	        			      var $this=this; 
	        				  var columnName = view.ownerCt.columnManager.columns[colIndex].dataIndex;
	        					 if(columnName=='status'){
	        					    if(colIndex==2){
	        					      $this.openManageRepetitionCompletionFormTab();
	        						  var form=$this.getManagerepetitioncompletionform().getForm();
	        						  form.findField('examinationRepetitionId').setValue(record.data.examinationRepetitionId);
	        						  form.findField('admissionId').setValue(record.data.admissionId);
	        						  form.findField('studentName').setValue(record.data.studentName);
	        						  form.findField('courseId').setValue(record.data.courseId);
	        						  form.findField('gridRecordcourseVariantId').setValue(record.data.courseVariantId);
	        						  form.findField('markObtained').setValue(record.data.markObtained);
	        						  form.findField('sectionId').setValue(record.data.sectionId);
	        						  form.findField('whetherPassed').setValue(record.data.whetherPassed);
	        						  form.findField('whetherFailed').setValue(record.data.whetherFailed);
	        						  form.findField('repeatOrComplete').setValue(record.data.repeatOrComplete);
	        						  form.findField('courseName').setValue(record.data.courseName);
	        						  form.findField('courseVariantName').setValue(record.data.courseVaraintName);
	        						  /**
	        		            	   * At the time of edit hide fields on the bases of examinationRepetitionIdValue. 
	        		            	   */
	        						  var detailSeqGrid=$this.getDetailsequencerepeatedgrid();
	        						  
	        		            	  if(!isNullOrEmpty(record.data.examinationRepetitionId)){
	        		            		  var courseVariantIdField=form.findField('courseVariantId');
	        		            		  courseVariantIdField.setVisible(true);
	        		            		  courseVariantIdField.setDisabled(true);
		    	        				  courseVariantIdField.getStore().getProxy().extraParams = {
		    	        					  admissionId:record.data.admissionId
		    	   	    				   };
		    	        				  courseVariantIdField.getStore().load({
		    	        					  callback:function(records, options, success){
		    	        						  var courseVarIds=[];
		    	        						  Ext.Array.each(records,function(value){
		    	        							  courseVarIds.push(value.data.id);
		    										});
		    	        						  courseVariantIdField.setValue(courseVarIds);
		    	        					  }
		    	        				  });
		    	        				  /**
		    	        				   * 1. Show columns of detail sequence grid at the time of edit.
		    	        				   * 2. Show fields of fees.  
		    	        				   */
		    	        				 var  repetitionFeePlanField=form.findField('repetitionFeePlan');
		    	        				  repetitionFeePlanField.setVisible(true);
		    	        				  repetitionFeePlanField.getStore().getProxy().extraParams = {
		    	        					  courseId:record.data.courseId,
		    	        					  programBatchSeatConfigId:record.data.programBatchSeatConfigId
		    	   	    				   };
		    	        				  repetitionFeePlanField.getStore().load();
		    	        				  form.findField('repetitionFeePlanSequence').setVisible(true);
		    	        				  form.findField('repetitionFeePlanStage').setVisible(true);
		    	        				  
		    	        				  detailSeqGrid.columns[2].setVisible(true);
		    	        				  detailSeqGrid.columns[3].setVisible(true);
	        		            	  }
	        		            	  /**
	        						   * list for detail sequence grid to save
	        						   */
	        						  detailSeqGrid.getStore().getProxy().extraParams={
	        							  admissionId:record.data.admissionId
	        						  };
	        						  detailSeqGrid.getStore().load();	
	        						  /**
	        						   * Load Course Component repeated and detail sequence grid n the bases of course id and admission id
	        						   */
	        						  var courseComponentField=form.findField('courseComponentId');
	        						  courseComponentField.getStore().getProxy().extraParams = {
	        							  courseVariantId:record.data.courseVaraintId, 
	        							  admissionId:record.data.admissionId
	    	   	    				   };
	        						  courseComponentField.getStore().load();
	        					  }
	        				  }
	        			  }
	        		  },
	        		  /*************Add repetition completion End************/
	        		  'managerepetitioncompletionform customcombobox[itemId=repetitionForItemId]':{
	        			  select:function(obj,rec){
	        				  this.hideNshowFieldBasesOfRepetitionForNRepetitionType();
	        			  }
	        		  },
	        		  'managerepetitioncompletionform customcombobox[itemId=repetitionTypeItemId]':{
	        			  select:function(obj,rec){
	        				  this.hideNshowFieldBasesOfRepetitionForNRepetitionType();
	        			  }
	        		  },
	        		  'managerepetitioncompletionform customcombobox[itemId=courseComponentItemId]':{
	        			  select:function(obj,rec){
        					  if(obj.getValue().length==obj.getStore().getCount()){
	        					  showWarningMessage(getExaminationTranslation('MANAGE_COURSE_REPETITION_N_COMPLETION'),getExaminationTranslation('COURSE_COMPLETION_REPETITION_TYPE_MSG'));
	        					  obj.reset();
	        				  }
	        			  }
	        		  },
	        		  'managerepetitioncompletionform customcombobox[itemId=repetitionFeePlanItemdId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var feePlanSequenceField=form.findField('repetitionFeePlanSequence');
	        				  feePlanSequenceField.enable();
	        				  feePlanSequenceField.getStore().getProxy().extraParams = {
	        					  feePlanId:data
	   	    				   };
	        				  feePlanSequenceField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionform customcombobox[itemId=repetitionFeePlanSequenceItemdId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var feePlanStageField=form.findField('repetitionFeePlanStage');
	        				  feePlanStageField.enable();
	        				  feePlanStageField.getStore().getProxy().extraParams = {
	        					  feePlanRuleId:data
	   	    				   };
	        				  feePlanStageField.getStore().load();
	        			  }
	        		  },
	        		  'managerepetitioncompletionform button[itemId=submitBtn]':{
	        			  click:function(){
	        				  this.saveManageRepetitionCompletionFormData();
	        			  }
	        		  },
	        		  'managerepetitioncompletionform button[itemId=cancelBtn]':{
	        			  click:function(obj){
	        				  obj.up('form').getForm().reset();
	        			  }
	        		  },
	        		  'searchresultgrid[itemId=repetitionNcompletionGridItemId] menuitem[itemId=approveItemId]':{
							click:function(obj){
								var $this=this;
								var grid=$this.getRepetitionNcompletionGrid();
								if(grid.getSelectionModel().getCount()>0){
									$this.openApproverWindow();
									var academyLocationId=$this.getCurrentAcademyLocation();
									var approverForm=$this.getApproverWindowForm().getForm();
									var approverId=approverForm.findField('approverId');
									approverId.getStore().getProxy().extraParams = {
										academyLocationId:academyLocationId,
										role:getExaminationTranslation('CNTRL_RESULT_APPROVER')
			   	    				   };
									approverId.getStore().load();
								}else{
		        					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		        				}	
							}
	        		  },
	        		  'approverwindow button[itemId=btnSave]':{
	        			  click:function(){
	        				  var $this=this;
	        				  var grid=$this.getRepetitionNcompletionGrid();
								if(grid.getSelectionModel().getCount()>0){
									var approverwindow=$this.getApproverwindow();
									var approverForm=$this.getApproverWindowForm().getForm();
									var approverFormValues=approverForm.getValues();
									var records = grid.getSelectionModel().getSelection();
									var repetitionIds=[];
									Ext.Array.each(records,function(value){
										repetitionIds.push(value.data.ID);
									});
									var data={
											"repetitionIds":repetitionIds.join(),
											"approverId":approverFormValues.approverId,
											"approvalStatus":getExaminationTranslation('CNTRL_APPROVED')
									};
									var submitUrl=SERVERURL.RNC_STUDENT_APPROVE_URL;
				            		  Ext.Ajax.request({
											type : 'rest',
											url : submitUrl,
										    method : 'POST',
										    jsonData:data,
											success : function(form, action) {
												showSuccessMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'),getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION_SUCCESS_MSG'));
												grid.getStore().reload();
												approverwindow.close();
											}
									});
								}       				  
	        			  }
	        		  },
	        		  'approverwindow button[itemId=btnCancel]':{
	        			  click:function(obj){
	        				  obj.up('window').close();
	        			  }
	        		  },
	        		  
	        		  
	        	   'searchresultgrid[itemId=repetitionNcompletionGridItemId] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
      		            click: function() {
      		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
      		            }
      		        },
      		      'searchresultgrid[itemId=repetitionNcompletionGridItemId] button[itemId=exportToPdfBtn] #exportPdfAll': {
      		            click: function() {
      		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
      		            }
      		        },
      		      'searchresultgrid[itemId=repetitionNcompletionGridItemId] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
      		            click: function() {
      		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
      		            }
      		        },
      		      'searchresultgrid[itemId=repetitionNcompletionGridItemId] button[itemId=exportToPdfBtn] #exportExcelAll': {
      		            click: function() {
      		                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
      		            }
      		        },
      		        
      		       'repetitioncompletionstructure':{
	      	        	afterrender : function(structure){
	    	        		var form = structure.down('form');
	    	        		var grid = structure.down('searchresultgrid');
	    	        	    this.getCBGridHeaderFreeze(grid,form);
	    	        	} 
      		       	}
	        	  });
	          },
	          /**
	           * Open window for Approver.
	           */
	          openApproverWindow:function(){
     	    	 var formWindow = this.getApproverwindow();
     	         if (!formWindow) {
     	             Ext.widget('approverwindow');
     	             formWindow = this.getApproverwindow();
     	         }
     	         formWindow.show();
     	       },
	          /**
	           * Open window for Evaluationtoberepeated grid.
	           */
	          openEvaluationtoberepeatedwin:function(){
     	    	 var formWindow = this.getEvaluationtoberepeatedwin();
     	         if (!formWindow) {
     	             Ext.widget('evaluationtoberepeatedwin');
     	             formWindow = this.getEvaluationtoberepeatedwin();
     	         }
     	         formWindow.show();
     	       },
	          /**
	           * Open tab manage repetition and completion
	           */
	          openManageRepetitionCompletionTab: function() {
             	 var me = this;
             	 var contentpanel = me.getContentPanel();
             	 var manageRnC = Ext.widget('managerepetitioncompletionstructure');
             	 var tabName = getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION_FOR_STUDENTS');
             	 openTab(contentpanel, tabName, manageRnC,CONSTANTS.MENU_COLOR_FOUR);
              },
              /**
	           * Open tab manage repetition and completion , details equence tab form
	           */
	          openManageRepetitionCompletionFormTab: function() {
             	 var me = this;
             	 var contentpanel = me.getContentPanel();
             	 var repetitionAndCompletion = Ext.widget('managerepetitioncompletionform');
             	 var tabName = getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION');
             	 openTab(contentpanel, tabName, repetitionAndCompletion,CONSTANTS.MENU_COLOR_FOUR);
              },
              /**
               * Hide and show field and grid on the bases of repetition for and repetition type 
               */
              hideNshowFieldBasesOfRepetitionForNRepetitionType:function(){
            	  var $this=this;
            	  var form=$this.getManagerepetitioncompletionform();
            	  var getForm=form.getForm();
            	  var repetitionForValue=getForm.findField('repetitionFor').getValue();
            	  var repetitionTypeValue=getForm.findField('repetitionType').getValue();
            	  var courseComponentField= getForm.findField('courseComponentId');
            	  var detailSeqGrid=$this.getDetailsequencerepeatedgrid();
            	  if(repetitionForValue!=null && repetitionTypeValue!=null){
            		  detailSeqGrid.setVisible(false);
            		  courseComponentField.setVisible(false);
                	  courseComponentField.reset();
                	  courseComponentField.allowBlank=true;
            		  /**
            		   * 1. If repetitionForValue=COURSE and repetitionTypeValue=COMPELTE then show course completion.
            		   * 
            		   * 2. If repetitionForValue=COURSE and repetitionTypeValue=PARTIAL then hide course completion.
            		   * 
            		   * 3. If repetitionForValue=EVALUATION and repetitionTypeValue=COMPELTE then show Detail sequence and save student Grid.
            		   * 
            		   * 4. If repetitionForValue=EVALUATION and repetitionTypeValue=PARTIAL then show Detail sequence Grid and save student Grid but cannot select checkbox.
            		   */
                	  var courseComponentStore=courseComponentField.getStore();
                	  var courseComponentIds=[];
            		  if(repetitionForValue==getExaminationTranslation('CNTRL_COURSE')&&repetitionTypeValue==getExaminationTranslation('CNTRL_COMPLETE')){
            			  courseComponentField.setVisible(true);
            			  courseComponentField.setReadOnly(true);
            			  courseComponentField.allowBlank=false;
            			  courseComponentField.setFieldLabel(getExaminationTranslation('COURSE_COMPENENT_REPEATED')+'<span class="required" style="color:red"> *</span>');
            			  Ext.Array.each(courseComponentStore.data.items,function(value){
            				  courseComponentIds.push(value.data.id);
                		  });
            			  courseComponentField.setValue(courseComponentIds);
            		  }else if(repetitionForValue==getExaminationTranslation('CNTRL_COURSE')&&repetitionTypeValue==getExaminationTranslation('CNTRL_PARTIAL')){
            			  courseComponentField.setVisible(true);
            			  courseComponentField.setReadOnly(false);
            			  courseComponentField.allowBlank=false;
            			  courseComponentField.setFieldLabel(getExaminationTranslation('COURSE_COMPENENT_REPEATED')+'<span class="required" style="color:red"> *</span>');
            			  /**
            			   * If thier is only one data in store then by default data is selected and read only
            			   */
            			   if(courseComponentStore.getCount()==1){
            				   courseComponentField.setReadOnly(true);
            				   Ext.Array.each(courseComponentStore.data.items,function(value){
                 				  courseComponentIds.push(value.data.id);
                     		  });
            				   courseComponentField.setValue(courseComponentIds);
            			   }
            		  }else if(repetitionForValue==getExaminationTranslation('CNTRL_EVALUATION')&&repetitionTypeValue==getExaminationTranslation('CNTRL_COMPLETE')){
            			  detailSeqGrid.setVisible(true);
            			  detailSeqGrid.columns[0].setVisible(false);
            		  }else if(repetitionForValue==getExaminationTranslation('CNTRL_EVALUATION')&&repetitionTypeValue==getExaminationTranslation('CNTRL_PARTIAL')){
            			  detailSeqGrid.setVisible(true);
            			  detailSeqGrid.columns[0].setVisible(true);
            			  /**
            			   * If thier is only one data in store then user cannot select data.
            			   */
            			  if(detailSeqGrid.getStore().getCount()==1){
            				  detailSeqGrid.columns[0].setVisible(false);
            			  }
            			  detailSeqGrid.getStore().reload();
            		  }
            	  }
            	  form.isValid();
              },
              
              
              savePassFailStudentDetailRepetion:function(){
            	  var $this=this;
            	  var filterForm=$this.getMarkrepetitioncompletionfilter().getForm();
            	  var completionStatus=filterForm.findField('courseCompletionStatus').getValue();
            	  var studentGrid=$this.getManagerepetitioncompletiongrid();
            	  var stdData=[];
            	  if (studentGrid.getSelectionModel().getCount() > 0) {
            		  var records = studentGrid.getSelectionModel().getSelection();
            		  for(var i in records){

              			var record=studentGrid.getStore().data.items[i];
              		    	var completedStatus=null;
              		    	/**
              		    	 * Here completion means true and repetition and false.
              		    	 */
              		    /*	if(Ext.isObject(record.data.repeatOrComplete)){
              		    		completedStatus=record.data.repeatOrComplete.repeatOrComplete;
              		    	}else{
              		    		completedStatus=record.data.repeatOrComplete;
              		    	}*/
              		    	
              		    	var markGradeValues=null;
              		    	if(!isNullOrEmpty(record.data.markObtained)){
              		    		markGradeValues=record.data.markObtained;
              		    	}else{
              		    		markGradeValues=record.data.gradeName;
              		    	}
              		    	
              		    	var data={
              		    			"admissionId":records[i].data.admissionId,
              		    			"courseId":records[i].data.courseId,
              		    			"courseVariantId":records[i].data.courseVaraintId,
              		    			"sectionId":records[i].data.sectionId,
              		    			"markObtained":markGradeValues,
              		    			"examResultStatus":completionStatus,//same data is sending in exam status and completion status as discussed with pushpendra sir
              		    			"courseCompletionStatus":completionStatus,
              		    			"repeatOrComplete":"Repetition",
              		    			'whetherCompleted':false
              		    	};
              		    	stdData.push(data);      
              		    
            		  }
            		  /**
            		   * It is used encode array becoz it creating object in array
            		   */
	            	  var encodeData=Ext.encode(stdData);
	            	  showConfirmMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'), getExaminationTranslation('MARK_REPETITION'),function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				            	
			            		  submitUrl=SERVERURL.RNC_SAVE_FOR_PASSED_STUDENT;
			            		  Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : encodeData,
									    method : 'POST',
										success : function(form, action) {
											  Ext.getBody().unmask();
											showSuccessMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'),getExaminationTranslation('STUDENT_SUCCESS_MSG'));
											studentGrid.getStore().reload();
										}
								});
							}
	            	  });

            	   }
            	   else {
            		  Ext.getBody().unmask();
					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				 }
              },
              
              /**
               * Save data of passed/fail student detail.
               */
              savePassFailStudentDetail:function(){
            	  var $this=this;
            	  var filterForm=$this.getMarkrepetitioncompletionfilter().getForm();
            	  var completionStatus=filterForm.findField('courseCompletionStatus').getValue();
            	  var studentGrid=$this.getManagerepetitioncompletiongrid();
            	  var stdData=[];
            	  if (studentGrid.getSelectionModel().getCount() > 0) {
            		  var records = studentGrid.getSelectionModel().getSelection();
            		  for(var i in records){

              			var record=studentGrid.getStore().data.items[i];
              		    	var completedStatus=null;
              		    	/**
              		    	 * Here completion means true and repetition and false.
              		    	 */
              		    /*	if(Ext.isObject(record.data.repeatOrComplete)){
              		    		completedStatus=record.data.repeatOrComplete.repeatOrComplete;
              		    	}else{
              		    		completedStatus=record.data.repeatOrComplete;
              		    	}*/
              		    	
              		    	var markGradeValues=null;
              		    	if(!isNullOrEmpty(record.data.markObtained)){
              		    		markGradeValues=record.data.markObtained;
              		    	}else{
              		    		markGradeValues=record.data.gradeName;
              		    	}
              		    	
              		    	var data={
              		    			"admissionId":records[i].data.admissionId,
              		    			"courseId":records[i].data.courseId,
              		    			"courseVariantId":records[i].data.courseVaraintId,
              		    			"sectionId":records[i].data.sectionId,
              		    			"markObtained":markGradeValues,
              		    			"examResultStatus":completionStatus,//same data is sending in exam status and completion status as discussed with pushpendra sir
              		    			"courseCompletionStatus":completionStatus,
              		    			"repeatOrComplete":"Completition",
              		    			'whetherCompleted':true
              		    	};
              		    	stdData.push(data);      
              		    
            		  }
            		  /**
            		   * It is used encode array becoz it creating object in array
            		   */
	            	  var encodeData=Ext.encode(stdData);
	            	  showConfirmMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'), getExaminationTranslation('MARK_COMPLETITION'),function(btn, text) {
							if (btn == 'yes') {
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				            	
			            		  submitUrl=SERVERURL.RNC_SAVE_FOR_PASSED_STUDENT;
			            		  Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : encodeData,
									    method : 'POST',
										success : function(form, action) {
											  Ext.getBody().unmask();
											showSuccessMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'),getExaminationTranslation('STUDENT_SUCCESS_MSG'));
											studentGrid.getStore().reload();
										}
								});
							}
	            	  });
            	   }
            	   else {
            		  Ext.getBody().unmask();
					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				 }
              },
              /**
               * Save Enter repetition detail tab data
               */
              saveManageRepetitionCompletionFormData:function(){
            	  var $this=this;
            	  var detailSeqGrid=$this.getDetailsequencerepeatedgrid();
            	  var grid=$this.getAddrepetitiongrid();
            	  var records = grid.getSelectionModel().getSelection()[0];
            	  var form=$this.getManagerepetitioncompletionform();
            	  var getForm=form.getForm();
            	  var formValues=getForm.getValues();
            	  
            	  var courseComponentField=getForm.findField('courseComponentId');
            	  var courseComponentIds=[];
            	  if(!courseComponentField.isHidden()){
            		  Ext.Array.each(courseComponentField.getValue(),function(value){
            			  if(Ext.isObject(value)){
  							    courseComponentIds.push(value.data.id);  
	  						}else{
	  							courseComponentIds.push(value);  
	  						}
            		  });
            	  }
            	  
            	  if(!isNullOrEmpty(formValues.courseVariantId)){
                	  var courseVariantIds=[];
            		  Ext.Array.each(formValues.courseVariantId,function(value){
            			  courseVariantIds.push(value.data.id);  
            		  });
                  }
            	  
            	  if(!detailSeqGrid.isHidden()){
            		  var detailSeqData=[];
            		  Ext.Array.each(detailSeqGrid.getStore().data.items,function(value){	  
            			  if(value.get('checkDetailSeq')==true){
        					  detailSeqData.push({
        						  "detailSequenceId":value.get('detailSequenceId'),
        						  "equivalentDetailSequenceId":value.get('equivalentDetailSequenceId')
        						  });
            			  }else{
            				  detailSeqData.push({
        						  "detailSequenceId":value.get('detailSequenceId'),
        						  "equivalentDetailSequenceId":value.get('equivalentDetailSequenceId')
        						  });
            			  }
            		  });
            		 
            		  if(detailSeqData.length==0){
            			  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            			  return;
            		  };
            		
            		  data ={
                			  "admissionId":formValues.admissionId, 
                			  "courseId":formValues.courseId, 
                			  "courseCompletionStatus":formValues.examResultStatus, // fields are not their in the form
                			  "repetitionFor":formValues.repetitionFor, 
                			  "repetitionType":formValues.repetitionType,
                    		  "courseComponentIds":null,
                    		  "detailedSequenceRepeateds":detailSeqData,
                    		  "feePlanRuleStageId":formValues.repetitionFeePlanStage,
                    		  "remarks":formValues.remarks,
                    		  "repetitionCourseVariantIds":courseVariantIds,
                    		  "approvalStatus":"PENDING",//hard Cord
                    		  "approvedById":1,//hard Cord,
                    		  "markObtained":formValues.markObtained,
                    		  "sectionId":formValues.sectionId,
                    		  "courseVariantId":formValues.gridRecordcourseVariantId,
                    		  "repeatOrComplete":formValues.repeatOrComplete
                    		  };
            	  }else{
            		   data={
                			  "admissionId":formValues.admissionId, 
                			  "courseId":formValues.courseId, 
                			  "courseCompletionStatus":formValues.examResultStatus, // fields are not their in the form //hard Cord
                			  "repetitionFor":formValues.repetitionFor,
                			  "repetitionType":formValues.repetitionType,
                    		  "courseComponentIds":courseComponentIds,
                    		  "detailedSequenceRepeateds":null,
                    		  "feePlanRuleStageId":formValues.repetitionFeePlanStage,
                    		  "remarks":formValues.remarks, 
                    		  "repetitionCourseVariantIds":courseVariantIds,
                    		  "approvalStatus":"PENDING",//hard Cord
                    		  "approvedById":1,//hard Cord
                    		  "markObtained":formValues.markObtained,
                    		  "sectionId":formValues.sectionId,
                    		  "courseVariantId":formValues.gridRecordcourseVariantId,
                    		  "repeatOrComplete":formValues.repeatOrComplete
                    		  };
            	  }
            	  
            	  submitUrl=SERVERURL.RNC_SAVE_MANAGE_REPETITION_FORM_DATA;
            	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            	
            	  Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : data,
					    method : 'POST',
						success : function(form, action) {
							  Ext.getBody().unmask();
							showSuccessMessage(getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION'),getExaminationTranslation('MANAGE_REPETITION_N_COMPLETION_SUCCESS_MSG'));
							//grid.getStore().reload();
						}
				});
              },
              loadEvaluationToBeRepeatedWin : function(admissionIdValue) {
					var quickSearchForm = this.getRepetitioncompletionfilter();
					/**
					 * Load xml Assessment to be repeated window grid
					 */
					var viewCode=CONSTANTS.CB.FIND_REPEATED_EVALUATION_OF_STUDENT_LISTING_VIEWCODE;
					var configCode=CONSTANTS.CB. FIND_REPEATED_EVALUATION_OF_STUDENT_LISTING_CONFIGCODE;
										
					var jsonFormatFormData = this.createJsonFormat(quickSearchForm,configCode ,admissionIdValue);
					var searchResultGrid = this.getEvaluationtoberepeatedwingrid();
					var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					resultViewUrl = resultViewUrl.concat(viewCode);
					searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl,jsonFormatFormData);
				},
	          loadRepetitionCompletionFilter : function() {
					var quickSearchForm = this.getRepetitioncompletionfilter();
					/**
					 * Load xml Repetition and completion grid
					 */
					var viewCode=CONSTANTS.CB.REPETITION_AND_COMPLETION_LISTING_VIEWCODE;
					var configCode=CONSTANTS.CB.REPETITION_AND_COMPLETION_LISTING_CONFIGCODE;
										
					var jsonFormatFormData = this.createJsonFormat(quickSearchForm,configCode );
					var searchResultGrid = this.getRepetitionNcompletionGrid();
					var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
					resultViewUrl = resultViewUrl.concat(viewCode);
					searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl,jsonFormatFormData);
				},
				createJsonFormat : function(quickSearchForm, configCode, admissionIdValue) {
					var form = quickSearchForm.getForm();
				    var formValues=form.getValues();
					var values = new Object();
					var searchcriteria = new Array();
					values.configCode = configCode;
					
					var courseVariantArray=[];
					var courseVariantField=form.findField('courseVariantId');
					if(courseVariantField.getValue()!=""){
						Ext.Array.each(courseVariantField.getValue(),function(value){
						if(Ext.isObject(value)){
							courseVariantArray.push(value.data.id);
						}else{
							courseVariantArray.push(value);
						}
					  });
					}
					var batchIdArray=[];
					var batchIdField=form.findField('batchId');
					if(batchIdField.getValue()!=""){
						Ext.Array.each(batchIdField.getValue(),function(value){
						if(Ext.isObject(value)){
							batchIdArray.push(value.data.id);
						}else{
							batchIdArray.push(value);
						}
					  });
					}
					var sectionIdArray=[];
					var sectionIdField=form.findField('sectionId');
					if(sectionIdField.getValue()!=""){
						Ext.Array.each(sectionIdField.getValue(),function(value){
						if(Ext.isObject(value)){
							sectionIdArray.push(value.data.id);
						}else{
							sectionIdArray.push(value);
						}
					  });
					}
					//For other fields data is not their so implemented without data
					var ADMISSION_ID = this.getJsonObject('ADMISSION_ID', admissionIdValue);
	            	this.pushJsonObjectInArray(ADMISSION_ID,searchcriteria);
					var COURSE_ID = this.getJsonObject('COURSE_ID', formValues.courseId);
	            	this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
	            	var COURSE_VARIANT_ID = this.getJsonObject('COURSE_VARIANT_ID', courseVariantArray.join());
	            	this.pushJsonObjectInArray(COURSE_VARIANT_ID,searchcriteria);
	            	var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', formValues.programId);
	            	this.pushJsonObjectInArray(PROGRAM_ID,searchcriteria);
	            	var BATCH_ID = this.getJsonObject('BATCH_ID', batchIdArray.join());
	            	this.pushJsonObjectInArray(BATCH_ID,searchcriteria);
	            	var section_ID = this.getJsonObject('section_ID', sectionIdArray.join());
	            	this.pushJsonObjectInArray(section_ID,searchcriteria);
	            	var REPETITION_TYPE = this.getJsonObject('REPETITION_TYPE', formValues.repetitionType);
	            	this.pushJsonObjectInArray(REPETITION_TYPE,searchcriteria);
	            	var COURSE_COMPLETION_STATUS = this.getJsonObject('COURSE_COMPLETION_STATUS', formValues.courseCompletionStatus);
	            	this.pushJsonObjectInArray(COURSE_COMPLETION_STATUS,searchcriteria);
	            	var REPETITION_FOR = this.getJsonObject('REPETITION_FOR', formValues.repetitionFor);
	            	this.pushJsonObjectInArray(REPETITION_FOR,searchcriteria);
//	            	var EVAL_DETAIL_SEQ_ID = this.getJsonObject('EVAL_DETAIL_SEQ_ID', formValues.evalSeqId);
//	            	this.pushJsonObjectInArray(EVAL_DETAIL_SEQ_ID,searchcriteria);
	            	var REPETITION_COMPLETION_STATUS = this.getJsonObject('REPETITION_COMPLETION_STATUS', formValues.repetitionCompletion);
	            	this.pushJsonObjectInArray(REPETITION_COMPLETION_STATUS,searchcriteria);
	            	if(isNullOrEmpty(admissionIdValue)){
	            		var APPROVAL_STATUS_PENDING = this.getJsonObject('APPROVAL_STATUS_PENDING', getExaminationTranslation('CNTRL_MARK_ENTRY_PENDING'));
		            	this.pushJsonObjectInArray(APPROVAL_STATUS_PENDING,searchcriteria);
	            	}
					values.searchCriterias = searchcriteria;
					return values;
				},
				getJsonObject : function(key, value, additionalValue) {
					if (value != '' && value != null
							&& additionalValue == undefined) {
						return {
							"paramCode" : key,
							"paramValues" : [ value ]
						};
					} else if (value != '' && additionalValue != undefined) {
						return {
							"paramCode" : key,
							"paramValues" : [ value, additionalValue ]
						};
					}
				},
				pushJsonObjectInArray : function(object, array) {
					if (object) {
						array.push(object);
					}
				},
				gridRenderFunction : function(grid) {
					grid.addButtonToolbar();
					var moreActionButton={
							xtype : 'splitbutton',
							itemId:'spBtnMoreActions',
							text : getCommonTranslation('MOREACTIONS'),//More Actions
							menu:[{
								text:getExaminationTranslation('APPROVE'),
								itemId:'approveItemId'	
							}],
							listeners: { click: function() { this.showMenu(); } }
					};
					//grid.down('#functionButtonsToolbar').add(moreActionButton);
					grid.down('#functionButtonsToolbar').insert(4,moreActionButton);
				},
				
				// ********* Hide  all more Action button *************
			    disableMoreActionPivileges: function(gridReference,permissionsMap) {
			    	var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			    	buttonsToolBar = gridReference.query('toolbar')[0];
			    	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
			    	splitbuttons.setVisible(false);
			    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
			    		menuItems.setVisible(false);
			    	});
			    	Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'MOREACTION') {
			    			var button = buttonsToolBar.query('#spBtnMoreActions')[0];
			    			if(!isNullOrEmpty(button)){
			    				button.setVisible(true);
			    			}        		
			    		}
			    		if (privilege === 'APPROVE') {
			    			var button = buttonsToolBar.query('#approveItemId')[0];
			    			if(!isNullOrEmpty(button)){
			    				button.setVisible(true);
			    			}        		
			    		}
			    	});
			    },
			    
			    
			    exportUserList : function(exportUrl,filetype,whetherAll) {
                    var quickSearchForm=this.getRepetitioncompletionfilter(); 
                    var searchResultGrid = this.getSearchresultgrid();
                    var pagingtoolbaroptions = this.getSearchresultgrid().down('pagingtoolbar').getStore().lastOptions;
                    var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
                    var configCode=CONSTANTS.CB. REPETITION_AND_COMPLETION_LISTING_CONFIGCODE;
                    var jsonFormatFormData=this.createJsonFormat(quickSearchForm,configCode);
                    var visibleColumns=this.getVisibleColumns(searchResultGrid);
                    var reportTitle=getCommonTranslation('REPETITION_AND_COMPLETION_LIST');
                    if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
                                  jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
                    }
                    searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

			    	},
			    
			    createSearchCriteriaString: function(searchForm) {
        		    	var me=this;
        		        var formValues = new Array();
        		        formValues = searchForm.getValues();        
        		        var searchCriteriaString="";
        		        for (var key in formValues) {
        		        	var value = formValues[key];            
        		            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
        		              //  var keyValueJsonObject = me.getJsonObject( key , value);
        		//searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
        		            }
        		        }
        		        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        		        return searchCriteriaString;
        		},
			    	
			 // ********* Hide  all more Action button for Manage Repetition and completion *************
			    disableMoreActionPivilegesForManageRepetitionAndCompletion: function(gridReference,permissionsMap) {
			    	var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
//			    	button = gridReference.down('#btnSave');
			    	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
//			    	button.setVisible(false);
			   /* 	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
			    		menuItems.setVisible(false);
			    	});*/
			    	Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'SAVEBUTTON') {
//			    			var button = buttonsToolBar.query('#btnSave')[0];
//			    			if(!isNullOrEmpty(button)){
//			    				button.setVisible(true);
//			    			}        		
			    		}
			    		/*if (privilege === 'EXPORT') {
			    			var button = buttonsToolBar.query('#approveLinked')[0];
			    			if(!isNullOrEmpty(button)){
			    				button.setVisible(true);
			    			}        		
			    		}*/
			    	});
			    }
});
