/**
 * @author Dharmendra.Prajapati
 */
Ext.define('Academia.controller.examinationcenters.reports.ExaminationDocumentController',{
	extend: 'Academia.controller.base.BaseController',
	models : ['examinationcenters.remark.ExaminationDocumentMdl'],
	stores : ['examinationcenters.reports.ExaminationDocumentNameFilter',
				'examinationcenters.examinationdocuments.ExaminationDocumentsStore'], 
	views : ['examinationcenters.reports.examinationdocuments.ExaminationDocumentsSearch',
	         'examinationcenters.reports.examinationdocuments.ExaminationDocumentsStructure',
	         'examinationcenters.reports.examinationdocuments.ExaminationDocumentsWin',
			  'examinationcenters.reports.examinationdocuments.Examinationdocumentsgrid' 
	         ],

	refs : [{ref: 'contentPanel',
		        selector: 'contentpanel' 
		    }, {
				ref : 'examinationdocumentsgrid',
				selector : 'examinationdocumentsgrid'  // searchresultgrid[itemId=examinationdocumentsgridId]
			},{
		        ref: 'examinationdocumentswin',
		        selector: 'examinationdocumentswin'
		    },{
		        ref: 'examinationDocumentswin',
		        selector: 'examinationdocumentswin form'
		    },{
		        ref: 'examinationdocumentssearch',
		        selector: 'examinationdocumentssearch'
		    }],
		    config:{
		    	EXAMINATION_EXAM_DOCUMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_EXAM_DOCUMENTS_PRIVILEGES')
		    },
		    
	init : function(application) {
		this.control({
			'examinationdocumentsgrid':{
				render:function(grid){
					var gridStore=grid.getStore();
					gridStore.removeAll();     		
				   	var permissionsMap=this.getEXAMINATION_EXAM_DOCUMENTS_PERMISSIONS();   
									    var associatedAcadLocationIds = new Array();
               	    					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());   
										grid.down('#btnExportToPDF').setVisible(false);
		            					grid.down('#btnExportToExcel').setVisible(false);
										grid.down('#btnView').setVisible(false);
										grid.down('#btnAdd').setVisible(false);
										grid.down('#btnEdit').setVisible(false);
										grid.down('#btnDelete').setVisible(false); 
										var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
										Ext.each(permissionList, function(privilege) {
					            		if (privilege == 'EXPORT') {      
					            		grid.down('#btnExportToPDF').setVisible(true);
		            					grid.down('#btnExportToExcel').setVisible(true); 
					            		 } if (privilege == 'VIEW') {      
					            		grid.down('#btnView').setVisible(true);
		            					} if (privilege == 'CREATE') {      
					            		grid.down('#btnAdd').setVisible(true);
		            					} if (privilege == 'UPDATE') {      
					            		grid.down('#btnEdit').setVisible(true);
		            					} if (privilege == 'DELETE') {       
					            		grid.down('#btnDelete').setVisible(true);
		            					 } 
									}); 
				},
				cellclick:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ){
					 var grid =this.getExaminationdocumentsgrid(); 
	                  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
	                  if(columnName=='documentPath'){  
	                	  //check apply for the Azure Storage 
	                		  var submitUrl= SERVERURL.EXAMINATION_DOC_DOWNLOAD_URL;
	                		  var csvForm = Ext.create('Ext.form.Panel'); 
	                		  csvForm.getForm().submit({
	                			  url : submitUrl+"?filePath="+record.data.documentPath,  
	                			  method : 'POST',
	                			  target: '_blank',
	                			  params :{
	                				  access_token : Ext.Ajax.defaultHeaders.access_token
	                			  },
	                			  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	                			  standardSubmit :true
	                		  }); 
                    }
                }
			},

			//***********************Export for Report	  
			'examinationdocumentsgrid splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
				click: function() {
					this.exportReportList(SERVERURL.PDFEXPORT,'pdf',false);
				}
			},
			'examinationdocumentsgrid splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
				click: function() {
					this.exportReportList(SERVERURL.PDFEXPORT,'pdf',true);
					}
			},
			'examinationdocumentsgrid splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
				click: function() {
					this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
					}
			},
			'examinationdocumentsgrid splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
				click: function() {
					this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
				}
			},
			'examinationdocumentssearch button[itemId=resetBtn]':{
				click:function(){
					var form = this.getExaminationdocumentssearch().getForm();
					form.reset();
					var fromDate = form.findField('fromDate');
					fromDate.setMinValue(false);
					fromDate.setMaxValue(false);
					var toDate = form.findField('toDate');
					toDate.setMinValue(false);
					toDate.setMaxValue(false);
					
				}
			},
			'examinationdocumentssearch button[itemId=searchBtn]':{
				click:function(obj){
					this.loadSearchData();
				}
			},
			'examinationdocumentsgrid button[itemId=btnAdd]': {
                click : this.showDocumentWindow
            },
            'examinationdocumentsgrid button[itemId=btnEdit]': {
                click: this.editDocumentWindow
            },
            'examinationdocumentsgrid button[itemId=btnView]': {
                click :  this.viewDocumentWindow
            },
            'examinationdocumentsgrid button[itemId=btnDelete]': { 
                click : this.deleteExaminationDocRecord
            },
            'examinationdocumentswin button[itemId=saveBtn]':{ 
            	click:this.uploadExaminationDoc
            },
            'examinationdocumentswin button[itemId=cancelBtn]':{
            	click:function(){
            		this.getExaminationdocumentswin().close();
            	}

            },
          /*  'examinationdocumentswin filefield[itemId=examinationDocument]': {
    			change: function(photoFileImage, value, eOpts) {
    				this.uploadExaminationDoc(photoFileImage,value);
    			}
    		},*/
            'examinationdocumentswin': {
            	afterrender: function(cmp) {
            		const examDocWinInterval = setInterval(examDocWinTimer, 500);
					 function examDocWinTimer() {
						 if(cmp && cmp.down('form')) {
							 cmp.down('form').isValid();
							 cmp.down('form').getForm().clearInvalid();
						 }
						 else {
							 clearInterval(examDocWinInterval);
						 }
					 }
            	}
            }
            
		});
	},
	uploadExaminationDoc:function(btn){
			var $this = this;
			btn.setDisabled(true);
			var form = $this.getExaminationDocumentswin();
			$this.saveTemplatePhotoUpload(form, null, SERVERURL.EXAMINATION_DOC_UPLOAD_DOC, SERVERURL.TEMPLATE_DOWNLOAD_DOC, function(success){
//			$this.saveTemplatePhotoUpload(form, null, SERVERURL.DOCUMENT_FILE_ADD, SERVERURL.TEMPLATE_DOWNLOAD_DOC, function(success){
				if(success){ 
					console.log('SUCCESS');
				}
			});
	},
	saveTemplatePhotoUpload : function(form, personId, uplaodUrl, downloadUrl, callback){
		var this$ = this;
		var photoFileImage = form.down('#examinationDocument');
		var fileUploadPath = photoFileImage.getValue();
		var values = form.getForm().getValues();
		
		if(!isNullOrEmpty(values.id)){
			this$.saveExaminationDocuments();
		}else{
		if(!isNullOrEmpty(fileUploadPath)){
			var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
			/*if (extension == "gif" || extension == "png" || extension == "bmp"
				|| extension == "jpeg" || extension == "jpg") {*/
				form.getForm().submit({
					method : 'POST',
					url : uplaodUrl,
					success : function(form1, action){
						callback(true);
						var responseData = Ext.decode(action.response.responseText);
						var path = responseData.path;
						form.getForm().findField('documentPath').setValue(path);	
//						showSuccessMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('PHOTO_UPLOAD_SUCCESS'));
						this$.saveExaminationDocuments();
//						this$.setTemplateUploadedPhotoToPersonProfile(downloadUrl,path);
					}
				});
			/*}else{
				photoFileImage.reset();
				showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
			}*/
		}
	}

	},
	loadSearchData:function(){
    	var form = this.getExaminationdocumentssearch();
		var mainForm=form.getForm();
		var formValues=form.getForm().getValues();
		var grid = this.getExaminationdocumentsgrid();
		var gridStore=grid.getStore(); 
		this.resetPageSetting(grid.getStore(),grid);
		gridStore.getProxy().extraParams={
						documentUploadDateFrom:formValues.fromDate,
						documentUploadDateTill:formValues.toDate,         
						documentNameId:formValues.documentName         
					};
		grid.getStore().load(); 
	},
	createJsonFormat:function(quickSearchForm){			
		var documentName = quickSearchForm.down('#documentName');
		var fromDate = quickSearchForm.down('#fromDate');
		var toDate = quickSearchForm.down('#toDate');


		var values = new Object();
		values.configCode = CONSTANTS.CB.EXAMINATION_DOCUMENTS_LISTING_CONFIGCODE;
		var searchcriteria = new Array();
		if(!isNullOrEmpty(documentName.getValue())){
			searchcriteria.push({paramCode:"DOCUMENT_NAME_ID", paramValues:[documentName.getValue()]});
		}
		if(!isNullOrEmpty(fromDate.getValue())){
			searchcriteria.push({paramCode:"DOCUMENT_UPLOAD_DATE_FROM", paramValues:[fromDate.getValue()]});
		}
		if(!isNullOrEmpty(toDate.getValue())){
			searchcriteria.push({paramCode:"DOCUMENT_UPLOAD_DATE_TILL", paramValues:[toDate.getValue()]});
		}

		values.searchCriterias=searchcriteria;
		return values;
	},
	showDocumentWindow:function(){
		var $this = this;
		var formWindow = $this.getExaminationdocumentswin();
		if (!formWindow) {
			Ext.widget('examinationdocumentswin');
			formWindow = $this.getExaminationdocumentswin();
		}
		formWindow.show();
	},
	saveExaminationDocuments:function(){
		var $this = this;
		var form = $this.getExaminationDocumentswin().getForm();
		var grid = $this .getExaminationdocumentsgrid();
		var values = form.getValues();
		var jsonData = {
				"id" : values.id,
				"examDocumentNameId" : values.examDocumentNameId,
				"uploadDate" : values.uploadDate,
				"description":values.description,
				"documentPath" :values.documentPath,
				"version":values.version,
				"customData": values.customData
		};
		var submitUrl;
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") {
			submitUrl = SERVERURL.EXAMINATION_DOCUMENTS_SAVE;
		} else {
			submitUrl = SERVERURL.EXAMINATION_DOCUMENTS_UPDATE;
		}
		var formData = Ext.encode(jsonData);

		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(form1, action) {
				showSuccessMessage(getExaminationTranslation('EXAM_DOCUMENTS'),getCommonTranslation('SUCCESS'));
				$this.getExaminationdocumentswin().close();
				grid.getStore().reload();
			}
		});
	},
	editDocumentWindow:function(){
    	var $this = this;
        var grid = $this.getExaminationdocumentsgrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
        	$this .showDocumentWindow();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
            	var id = records[0].data.id; 
				Ext.Ajax.request({
							type : 'rest', 
							url : SERVERURL.EXAMINATION_DOCUMENTS_FIND_BY_ID,
							params : {
								id : id
							},
							method : 'GET',
							success : function(response) {
								var form = $this.getExaminationDocumentswin().getForm();
								var data = Ext.decode(response.responseText);

	        					var examinationDocMdl  =  new Academia.model.examinationcenters.remark.ExaminationDocumentMdl(data);

	        					form.loadRecord(examinationDocMdl);
								var examDocName = form.findField('examDocumentNameId');
								var examDocStore =  examDocName.getStore();
								examDocStore.load({
			                            callback: function(record, operation, success) {
			                                if (success) {
			                                    form.findField('examDocumentNameId').setValue(data.examDocumentNameId);
			                                }
			                            }
			                        });
								form.findField('id').setValue(data.id);
								form.findField('uploadDate').setValue(dateRender(data.uploadDate));
								form.findField('description').setValue(data.description);
								form.findField('documentPath').setValue(data.documentPath);
								form.findField('version').setValue(data.version);
								$this.getExaminationDocumentswin().down('#examinationDocument').allowBlank=true;
								$this.getExaminationDocumentswin().down('#examinationDocument').setVisible(false);
								$this.getExaminationdocumentswin().setHeight(300);
							}
						});
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
	},
	deleteExaminationDocRecord:function(){
		var grid = this .getExaminationdocumentsgrid();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getExaminationTranslation('EXAM_DOCUMENTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var record = grid.getSelectionModel().getSelection()[0];
					var id = record.get("id");

					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.EXAMINATION_DOCUMENTS_DELETE + '?id=' + id ,
						headers : {
							'Content-Type' : 'application/json'
						},
						params: {
							id: id
						},
						success: function(form, action) {
								showSuccessMessage(getExaminationTranslation('EXAM_DOCUMENTS'),getCommonTranslation('SUCCESS'));
								grid.getStore().reload();
							}
					});
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	viewDocumentWindow:function(){
        this.editDocumentWindow();
        var form = this.getExaminationDocumentswin();
        if (form) {
            form.down('#saveBtn').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
	},
	exportReportList : function(exportUrl,filetype,whetherAll) {
		var quickSearchForm=this.getExaminationdocumentssearch(); 
		var searchResultGrid = this.getExaminationdocumentsgrid();
		var pagingtoolbaroptions = this.getExaminationdocumentsgrid().down('pagingtoolbar').getStore().lastOptions;
		var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
		var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
		var visibleColumns=this.getVisibleColumns(searchResultGrid);
		var reportTitle=getCommonTranslation('EXAM_DOCUMENTS_REPORT');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		}
		searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

	},

	createSearchCriteriaString: function(searchForm) {
		var me=this;
		var formValues = new Array();
		formValues = searchForm.getValues();        
		var searchCriteriaString="";
		for (var key in formValues) {
			var value = formValues[key];            
			if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
				var keyValueJsonObject = me.createJsonObjectFromKeyValue( key , value);
				searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
			}
		}
		searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
		return searchCriteriaString;
	},
	
	createJsonObjectFromKeyValue: function(key, value, additionalValue) {
		   if (value != '' && value != null && additionalValue == undefined) {
			   return {
				   "paramCode": key,
				   "paramValues": [value]
			   };
		   } else if (value != '' && additionalValue != undefined) {
			   return {
				   "paramCode": key,
				   "paramValues": [value, additionalValue]
			   };
		   }
	},

	});