/**
 * @author Bhanu PS
 */
Ext.define('Academia.controller.examinationcenters.revaluation.RevaluationController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationcenters.revaluation.RevaluationProgramStore','examinationcenters.revaluation.RevaluationBatchStore',
	          'examinationcenters.revaluation.RevaluationPeriodStore', 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'examinationcenters.studentportal.revaluation.StudentRevalGridStore','servicerequest.programcoursesectiontransfer.FindAllBatchsWithOutCurrentCheck',
	          'examCenter.AssignSequence.RevaluationTypeStore','examinationcenters.reports.ExaminationReportCourseStore','examinationcenters.studentportal.revaluation.RevaluationStatusStore',
	          'examinationcenters.reports.ExaminationReportStudentStore','attendance.CoursesForRevaluation','examinationcenters.revaluation.RevaluationCourseStore',
	          'examinationcenters.studentportal.revaluation.RevaluationApprovalStatusStore','examinationcenters.revaluation.RevaluationStudentListStore',
	          'examinationcenters.studentportal.revaluation.StudentListRevalGridStore','examinationcenters.evaluation.coverageDetails.CourseCoverageStore',
	          'examinationcenters.revaluation.RevaluationAccessibleProgramStore','servicerequest.programcoursesectiontransfer.FindAllBatchsWithOutCurrentCheck',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore',
	          'examinationcenters.studentportal.revaluation.RevaluationApprovalStatusStore','examinationcenters.studentportal.revaluation.RevaluationApprovalRejectedStore'],
	          
	          views : ['examinationcenters.revaluation.RevaluationCoreERPStructure','examinationcenters.revaluation.RevaluationCoreErpStudentFilter',
	                   'examinationcenters.revaluation.RevaluationCoreErpStudentGrid','studentPortal.revaluation.RevalSummaryWin', 'studentPortal.revaluation.RevalTransactionWindow',
	                   'examinationcenters.revaluation.RevaluationApprovalWin'],
	                   config:{
	                	   EXAM_REVALUATION_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_REVALUATION_PRIVILEGES')
	                   },           
	                   refs : [{
	                	   ref: 'contentPanel',
	                	   selector: 'contentpanel'
	                   },{
	                	   ref:'revaluationcoreerpstudentfilter',
	                	   selector:'revaluationcoreerpstudentfilter'
	                   },{
	                	   ref:'revaluationcoreerpstudentgrid',
	                	   selector:'revaluationcoreerpstudentgrid'
	                   },{
	                	   ref:'revaluationcoreerpstructure',
	                	   selector:'revaluationcoreerpstructure'
	                   },{
	                       ref: 'documentFormWindow',
	                       selector: 'documentformwindow[itemId=offlinePaymentDocumentCoreErp]'
	                   },{
	                       ref: 'revalsummarywin',
	                       selector: 'revalsummarywin'
	                   },{
	                       ref: 'revaltransactionwindow',
	                       selector: 'revaltransactionwindow'
	                   },{
	                	   ref: 'revaluationapprovalwin',
	                       selector: 'revaluationapprovalwin'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'revaluationcoreerpstructure':{
	                			   afterrender : function(structure){
	                				   var $this = this;
	                				   var grid = structure.down('#revaluationcoreerpstudentgrid');
	                				 //  $this.getGridHeaderFreeze(grid,structure.up(), true);
	                				   
	                					var form = structure.down('form');
	                					this.getGridHeaderFreeze(grid,form);
	                				   
	                				  // $this.getMultipleGridHeaderFreeze(grid,structure,true); 
	                				   setTimeout(function(){
	                					   $this.addDataGridConfigButton(grid,$this.getEXAM_REVALUATION_PERMISSION());
	   	    	        		        },1500);
	                				   try {
	                					   structure.down('form').body.on('scroll', function() {
	                						   var activeEditor = grid.plugins[0].getActiveEditor();
	                						   if(activeEditor && activeEditor.cancelEdit) {
	                							   activeEditor.cancelEdit();
	                						   }
	                					   });
	                				   }
	                				   catch(error) {
	                					   console.log(error);
	                				   }
	                			   }
	                		   },

	                		   'revaluationcoreerpstudentgrid':{
	                			   render : function(grid){
	                				   var $this = this;
	                				   this.doAccessControlValidation(grid, this.getEXAM_REVALUATION_PERMISSION());
	                				   this.disableMoreActionGridPivileges(grid, this.getEXAM_REVALUATION_PERMISSION());
	                				   Ext.apply(grid,{
	                					   challengeCount:null,
	                					   setChallengeCount : function(challengeCount){
	                						   grid.challengeCount = challengeCount;
	                					   },
	                					   getChallengeCount:function(){
	                						   return grid.challengeCount;
	                					   }
	                				   });
	                				   Ext.apply(grid,{
	                					   bucket:null,
	                					   setBucket : function(bucket){
	                						   grid.bucket = bucket;
	                					   },
	                					   getBucket:function(){
	                						   return grid.bucket;
	                					   }
	                				   });
	                				   grid.setBucket(null);
	                				   grid.getStore().removeAll();
	                				   grid.getStore().loadData([]);
	                				   Ext.apply(grid,{
	                					   revaluationCount:null,
	                					   setRevaluationCount : function(revaluationCount){
	                						   grid.revaluationCount = revaluationCount;
	                					   },
	                					   getRevaluationCount:function(){
	                						   return grid.revaluationCount;
	                					   }
	                				   });
        							   var XMLHttpRequestObject = false;  
        							   if (window.XMLHttpRequest) {  
        								   XMLHttpRequestObject = new XMLHttpRequest();  
        								   XMLHttpRequestObject.overrideMimeType("text/xml");  
        							   }  
        							   else if (window.ActiveXObject) {  
        								   XMLHttpRequestObject = new  
        								   ActiveXObject("Microsoft.XMLHTTP");  
        							   } 
        							   var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
        							   var getcontroller=$this.getController('menu.CoreERPNavigationController');
        							   var getTab=getcontroller.getTab(tabName);
        							   var contentpanel = this.getContentPanel();
        							   if(XMLHttpRequestObject) {  
        								   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
        								   XMLHttpRequestObject.onreadystatechange = function() {       
        									   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
        										   var xmlDocument = XMLHttpRequestObject.responseXML;  
        										   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
        										   revalPostDataUrl = buildInfo.getElementsByTagName("revalPostDataUrl") [0].childNodes[0].nodeValue;
        										   Ext.apply(grid,{
        		                					   revalPath:null,
        		                					   setRevalPath : function(revalPath){
        		                						   grid.revalPath = revalPath;
        		                					   },
        		                					   getRevalPath:function(){
        		                						   return grid.revalPath;
        		                					   }
        		                				   });
        										   grid.setRevalPath(revalPostDataUrl);
        									   }  
        								   }  
        								   XMLHttpRequestObject.send(null);  
        							   }
	                			   },
	                			   
	                			   selectionchange: function(column, selected,eOpts ){
		    	                	   var $this = this;
		    	                	   var grid = $this.getRevaluationcoreerpstudentgrid();
		    	                	   uniqueAdmissionIds = new Ext.util.HashMap();
		    	                	   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
		    	                	   var btnApprove=grid.down('#btnApprove');
		    	                	   var btnApplyItemId=grid.down('#btnApplyItemId');
		    	                	   var btnApplyNow=grid.down('#btnApplyNowItemId');
		    	                	   var withFeeApplicable=false;
		    	                	   var withoutFeeApplicable=false;
		    	                	   var store = grid.getStore();
		    	                	   var models = store.getRange();
		    	                	   var withFeeReval=false;
		    	                	   var withChallenge=false;
		    	                	   var withReview=false;
		    	                	   var withoutReval=false;
		    	                	   var withoutChallenge=false;
		    	                	   var withoutReview=false;
		    	                	   var filterForm=this.getRevaluationcoreerpstudentfilter();
    	                			   var isRevalFeeApplicable=filterForm.down('#isRevalFeeApplicable').getValue();
    	                			   var isReviewFeeApplicable=filterForm.down('#isReviewFeeApplicable').getValue();
    	                			   var isChallengeFeeApplicable=filterForm.down('#isChallengeFeeApplicable').getValue();
    	                			  
    	                			   var ReavlStatusArray =[];
    	                			   var applyNowFlag=true;
    	                			   var currentDate = new Date().setHours(0,0,0,0);
		    	                	   for(var i in selected) {
		    	                		   if(!isNullOrEmpty(selected[i].data.admissionId)) {
		    	                			   if(selected.length>1){
		    	                				   offlinePaymentItemId.setDisabled(true);
		    	                				   //btnApprove.setDisabled(true);
		    	                			   }else{
		    	                				   offlinePaymentItemId.setDisabled(false);
		    	                				   //btnApprove.setDisabled(false);
		    	                			   }
		    	                			   
		    	                			   if(selected[i].data.revaluationStatus=== "Applied" || selected[i].data.revaluationStatus=== "Pending" ){
			    	                			   	ReavlStatusArray.push(selected[i])
			    	                			   	    //grid.getSelectionModel().selectA()
			    	                			   }else{
			    	                			   	 if(selected[i].data.approvalStatus==="APPROVED" || 
			    	                					   selected[i].data.approvalStatus==="REJECTED"){
			    	                				   grid.getSelectionModel().deselect(selected[i]);
			    	                				   return false;
			    	                			   }
			    	                			
			    	                			   }
			    	                			   
		    	                			   if(isNullOrEmpty(selected[i].data.revaluationTypeEnum)){
		    	                				   grid.getSelectionModel().deselect(selected[i]);
		    	                				   return false;
		    	                			   }
		    	                			  
		    	                			   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
		    	                					   (selected[i].data.revaluationTypeEnum=="Revaluation" ||
		    	                							   selected[i].data.revaluationTypeEnum=="REVALUATION")){
		    	                				   if(isRevalFeeApplicable=="true"){
		    	                					   withFeeReval=true
		    	                				   }
		    	                				   if (isRevalFeeApplicable=="false") {
		    	                					   withoutReval=true
		    	                				   } 
		    	                			   } 
		    	                			   
		    	                			   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
			    	                				   selected[i].data.revaluationTypeEnum=="Review"  ||
    	                							   selected[i].data.revaluationTypeEnum=="REVIEW"){
		    	                				   if(isReviewFeeApplicable=="true"){
		    	                					   withReview=true
		    	                				   }
		    	                				   if (isReviewFeeApplicable=="false") {
		    	                					   withoutReview=true
		    	                				   } 
		    	                			   } 
		    	                			   
		    	                			   
		    	                			   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) &&
			    	                				   selected[i].data.revaluationTypeEnum=="Challenge"  ||
    	                							   selected[i].data.revaluationTypeEnum=="CHALLENGE"){
		    	                				   if(isChallengeFeeApplicable=="true"){
		    	                					   withChallenge=true
		    	                				   }
		    	                				   if (isChallengeFeeApplicable=="false") {
		    	                					   withoutChallenge=true
		    	                				   } 
		    	                			   } 
		    	                		   }
		    	                		}
									   for (var i in selected) {
										   if (selected[i].data.endDate < currentDate) {
											   applyNowFlag = false;
											   break;
										   } 
										   if (selected[i].data.endDate === currentDate) {
											   applyNowFlag = true;
											   break;
										   }

									   }
		    	                	   if(ReavlStatusArray.length >0){
			    	                	   	grid.getSelectionModel().select(ReavlStatusArray);
			    	                	   }
		    	                	   setTimeout(function(){
		    	                		   if((withFeeReval || withChallenge || withReview) &&
			    	                			   (withoutReval || withoutChallenge || withoutReview)){
			    	                		   btnApplyNow.setDisabled(false);
			    	                		   btnApprove.setDisabled(false);
			    	                		   btnApplyItemId.setDisabled(false);
			    	                		   offlinePaymentItemId.setDisabled(false);
			    	                		   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REVALUATION_TYPE_WITH_FEE_AND_WITHOUT_FEE'));
			    	                		   grid.getSelectionModel().deselectAll();
			    	                	   } else if (withFeeReval || withChallenge || withReview){
			    	                		   btnApplyNow.setDisabled(true);
			    	                		   btnApprove.setDisabled(false);
			    	                		   btnApplyItemId.setDisabled(false);
			    	                		   offlinePaymentItemId.setDisabled(false);
			    	                	   } else if(withoutReval || withoutChallenge || withoutReview) {
			    	                		   btnApplyNow.setDisabled(false);
			    	                		   btnApprove.setDisabled(false);
			    	                		   btnApplyItemId.setDisabled(true);
			    	                		   offlinePaymentItemId.setDisabled(true);
			    	                	   } else {
				    	                		   btnApplyNow.setDisabled(true);
				    	                		   btnApprove.setDisabled(true);
				    	                		   btnApplyItemId.setDisabled(true);
				    	                		   offlinePaymentItemId.setDisabled(true);
				    	                		   grid.getSelectionModel().deselectAll();
			    	                	   }
										   if (applyNowFlag === false) {
											   btnApplyNow.setDisabled(true);
											   btnApplyItemId.setDisabled(true);
											   offlinePaymentItemId.setDisabled(true);
										   } else {
											   if (withFeeReval || withChallenge || withReview) {
												   btnApplyNow.setDisabled(true);  
												   btnApprove.setDisabled(false);
												   btnApplyItemId.setDisabled(false);
												   offlinePaymentItemId.setDisabled(false);
											   } else {
												   if(selected.length) {
													   btnApplyNow.setDisabled(false);
												   }
												   btnApplyItemId.setDisabled(true);
												   offlinePaymentItemId.setDisabled(true);
											   }

										   }
	   	    	        		        },500);
		    	                	   
		    	                	  
		    	                	   
		    	                	   var msgLable = grid.down('#applyForRevalMsgId');
		    	                	   msgLable.setValue('');
		    	                	   var totalAmount=0, submittedRecordsCount=0,
		    	                	   revalCount=0, challengeCount=0, reviewCount=0, masterId=[], bucketSize=0, count=0;
		    	                	   for(var i in selected) {
		    	                		   if(!isNullOrEmpty(selected[i].data.feeAmount)) {
		    	                			   totalAmount=totalAmount+parseInt(selected[i].data.feeAmount);
		    	                		   }
		    	                		   if(!isNullOrEmpty(selected[i].data.revaluationTypeEnum) && (masterId.length==0  || 
		    	                				   (!isNullOrEmpty(masterId)?masterId.id != selected[i].data.examRevaluationId:false))) {
		    	                			   masterId.push({
		    	                				   "id":selected[i].data.examRevaluationId,
		    	                				   "bucketSize":selected[i].data.maxMasterCount,
		    	                				   "revalType" : selected[i].data.revaluationTypeEnum
		    	                			   })
		    	                		   }
		    	                	   }
		    	                	  
		    	                	 
		    	                	   /*var appeningString='';
		    	                	   setTimeout(function(){
		    	                		   if(totalAmount>0 && withFeeApplicable) { 
			    	                		   appeningString = 'Amount to be paid '+"<span style='color:green'>"+totalAmount+"/-</span>";
			    	                		   msgLable.setValue(appeningString);
				    	                	   msgLable.setVisible(true);
			    	                	   } else {
			    	                		   msgLable.setVisible(false);
			    	                	   }
	   	    	        		        },500);*/
								 
		    	                   	},
	                			   
	                			  

	                			   cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	                				   var $this = this;
	                				   var documentGrid = $this.getRevaluationcoreerpstudentgrid();
	                				   var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
	                				   var offlinePaymentItemId=documentGrid.down('#offlinePaymentItemId');
	                				   var btnApprove=documentGrid.down('#btnApprove');
		    	                	   var btnApplyItemId=documentGrid.down('#btnApplyItemId');
		    	                	   var btnApplyNow=documentGrid.down('#btnApplyNowItemId');
	                				   
	                				   if (columnName == "documentName") {
	                					   if (e.target.tagName == 'A') {
	                						   var documentId = record
	                						   .get("documentId");
	                						   if (!isNullOrEmpty(documentId)) {
	                							   $this.getDocumentController().downloadDocumentFile(documentId);
	                						   }
	                					   }
	                				   }
	                				   
	                				   if(e.target.type=='checkbox'){
	                					   if(cellIndex==0){
	                						   /**
	                						    * This function call on click of 0th column on check box click. 
	                						    ***/
	                						   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	    	                				   if(!e.target.checked){
	                							   tempStore.remove(record,true);
	                						   }else if(e.target.checked){
	                							   tempStore.loadRawData(record,true);
	                						   }
	                					   }
	                				   }
	                			   }
	                		   },
	                		  
	                		   'revaluationcoreerpstudentgrid menuitem#btnApplyItemId' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var grid = $this.getRevaluationcoreerpstudentgrid();
	                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   //if(grid.getSelectionModel().getCount()>0){

	        	                	   var record =tempStore.data.items.length!=0?tempStore.data.items:grid.getSelectionModel().getSelection();
	        	                	 
	                				   if(record.length>0){
	                					   var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
	                					   //var record =tempStore.data.items;//grid.getSelectionModel().getSelection();
	                					   var innerJsonArr=[], json;
	                					   var totalAmmount=0;
	                					   var models = grid.getStore().getRange();
	                					   
	                					   
	                					   var totalRevalApplied=0;
	                					   for(var i in models) {
	                						   if(!isNullOrEmpty(models[i].data.revaluationTypeEnum) && models[i].data.revaluationStatus.toUpperCase()!='SUBMITTED'.toUpperCase()){
	                							   totalRevalApplied=totalRevalApplied+1;
	                						   }
	                					   }
	                					   for(var i in record) {
	                						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
	                							   if(record[i].data.approvalStatus=="APPROVED"){
	                								   showWarningMessage(getCommonTranslation('ALERT'),
		                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
		                							   return false; 
	                							   }
	                						   }
	                					   }
	                					   
											//V2D-370907
	                					   
											 var totAmount = 0;
                        for (var i in record) {
                            if (!isNullOrEmpty(record[i].data.revaluationTypeEnum)) { 
                                if (record[i].data.revaluationTypeEnum.toLowerCase()== "review") {
                                    totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#reviewFeeAmount")[0].getValue())
                                } else {
                                    if (record[i].data.revaluationTypeEnum.toLowerCase() == "revaluation") {
                                        totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue())
                                    } else {
                                        if (record[i].data.revaluationTypeEnum.toLowerCase() == "challenge") {
                                            totAmount = totAmount + parseInt(Ext.ComponentQuery.query("#challengeFeeAmount")[0].getValue())
                                        }
                                    }
                                }
                            }
                        }
	                					   for(var i in record) {
	                						   
	                							if (!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
                                if (record[i].data.revaluationTypeEnum.toLowerCase() == "review") {
                                   totalAmmount = Ext.ComponentQuery.query("#reviewFeeAmount")[0].getValue()
                                } else {
                                    if (record[i].data.revaluationTypeEnum.toLowerCase() == "revaluation") {
                                       totalAmmount = Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue()
                                    } else {
                                        if (record[i].data.revaluationTypeEnum.toLowerCase() == "challenge") {
                                          totalAmmount = Ext.ComponentQuery.query("#challengeFeeAmount")[0].getValue()
                                        } else {
                                            if (isNaN(totalAmmount)) {
                                              totalAmmount = Ext.ComponentQuery.query("#revalFeeAmount")[0].getValue()
                                            }
                                        }
                                    }
                                }

								var FeePlanRuleID = null;
                                if (record[i].data.revaluationTypeEnum.toLowerCase() == "review") {
                                    FeePlanRuleID = Ext.ComponentQuery.query("#reviewFeePlanRuleStageId")[0].getValue()
                                } else {
                                    if (record[i].data.revaluationTypeEnum.toLowerCase() == "revaluation") {
                                        FeePlanRuleID = Ext.ComponentQuery.query("#revalFeePlanRuleStageId")[0].getValue()
                                    } else {
                                        if (record[i].data.revaluationTypeEnum.toLowerCase() == "challenge") {
                                            FeePlanRuleID = Ext.ComponentQuery.query("#challengeFeePlanRuleStageId")[0].getValue()
                                        }
                                    }
                                }
	                							   innerJsonArr.push({
	                								   "admissionId": record[i].data.admissionId,
	                								   "studentId": record[i].data.studentId,
	                								   "feePlanRuleStageId": FeePlanRuleID,
	                								   "amount": totalAmmount,
	                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
	                								   "examinationResultId": record[i].data.revaluationFor!= "COURSE_LEVEL"?record[i].data.examinationResultId:null,
	                										   "courseVariantId": record[i].data.courseVariantId,
	                										   "periodId": record[i].data.periodId,
	                										   "eventId": record[i].data.eventId,
	                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record[i].data.appliedDate,
	                										   "courseCode": record[i].data.courseCode,
	                										   "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										   "eventName": record[i].data.event,
	                										   "previousMarks": record[i].data.obtainedMarks,
	                										   "previousGrade": record[i].data.finalGrade,
	                										   "previousGradePoint": record[i].data.gradePoints,
	                										   "previousResultStatus": record[i].data.resultStatus,
	                										   "examStudentRevalId":record[i].data.studentRevalId
	                							   });
	                							   json={ 
	                									   'firstName':record[0].data.firstName,
	                									   'lastName':record[0].data.lastName,
	                									   'phoneNo':record[0].data.mobileCountryCode+" "
	                									   +record[0].data.mobileNumber,
	                									   'email':record[0].data.emailId,
	                									   'studentCode':record[0].data.studentCode,
	                									   "totalAmount":totAmount,
	                									   "examRevalPaymentDetail":innerJsonArr
	                							   };
	                						   } else {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	                							   return false;
	                						   }
	                					   }
	                					   var buildInfo="";  
	                					   var revalPaymentUrl = ""; 
	                					   if(!isNullOrEmpty(json)) {
	                						   var XMLHttpRequestObject = false;  
	                						   if (window.XMLHttpRequest) {  
	                							   XMLHttpRequestObject = new XMLHttpRequest();  
	                							   XMLHttpRequestObject.overrideMimeType("text/xml");  
	                						   }  
	                						   else if (window.ActiveXObject) {  
	                							   XMLHttpRequestObject = new  
	                							   ActiveXObject("Microsoft.XMLHTTP");  
	                						   } 
	                						   XMLHttpRequestObject.withCredentials = false;
	                						   XMLHttpRequestObject.onreadystatechange = function() {
	                							   if (this.readyState == 4 && this.status == 200) {
	                								   var id = parseInt(XMLHttpRequestObject.responseText);
	                								   if(!isNaN(id)) {
	                									   var formWindow = $this.getRevalsummarywin();
	                									   if (!formWindow) {
	                										   Ext.widget('revalsummarywin');
	                										   formWindow = $this.getRevalsummarywin();
	                									   }
	                									   formWindow.show();
	                									   var summaryGrid = formWindow.down('grid');
	                									   summaryGrid.getStore().loadRawData([]);
	                									   summaryGrid.getStore().loadRawData(innerJsonArr);
	                									   var summaryWindMsg = formWindow.down('#summaryWindMsg');
	                									   summaryWindMsg.setVisible(true);
	                									   summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totAmount+" /-</b>");
	                									   Ext.apply(formWindow,{
	                										   data:null,
	                										   setData : function(data){
	                											   formWindow.data = data;
	                										   },
	                										   getData:function(){
	                											   return formWindow.data;
	                										   }
	                									   });
	                									   formWindow.setData(id);
	                								   } else {
	                									   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
	                								   }
	                							   }
	                						   };
								
								var admissionIds = []; // Initialize admissionIds as an array
										for (var i = 0; i < record.length; i++) {
										    var recordNew = record[i];   
										    admissionIds.push(recordNew.data.admissionId); // Add admission ID to the array
										}  
								
							Ext.Ajax.request({       
				                   type: 'rest', 
				                   url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
				                   params: {
				                       periodId:record[0].data.periodId,
				                       admissionIds: admissionIds.join(),   
				                       portalId:portalId        
				                   },
				                   method: 'GET',
				                   success: function(res, action) {
				                       var response = Ext.decode(res.responseText);
				                      var capacity = Ext.decode(res.responseText);
					var gridRecord = grid.getSelectionModel().getSelection();
					var selectionByStudentAndPeriod = {};    				
					Ext.each(gridRecord, function(record) {  
                        var studentId = record.get('studentId');
                        var periodId = record.get('periodId');
                        var key = studentId + '-' + periodId;

                        if (!selectionByStudentAndPeriod[key]) {
                            selectionByStudentAndPeriod[key] = [];
                        }
                        selectionByStudentAndPeriod[key].push(record);
                    });

                    // Check if any student exceeds the capacity for the period
                    for (var key in selectionByStudentAndPeriod) {  
                        if (capacity==0) {    
                            var studentPeriod = key.split('-');
                            var studentId = studentPeriod[0];
                            var periodId = studentPeriod[1]; 
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP'));
                           // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
                            break; 
                        }else{    
								XMLHttpRequestObject.open("POST",  grid.getRevalPath(), true);
					             XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
					              XMLHttpRequestObject.send(""+Ext.encode(json));  
                    		}
                        }
				                   }
				                   
				               }); 
												
	                						  
	                					   }
	                				   } else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                				   }
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentgrid menuitem#btnApplyNowItemId' : {
	                			   click : function(obj) {
	                				   obj.setDisabled(true);
	                				   var $this = this;
	                				   var totalAmmount=0;
	                				   var innerJsonArr=[], json;
                					   var totalAmmount=0;
                					   var arrayData=[];
                					   var  saveModel=new Array();
                					   var grid=$this.getRevaluationcoreerpstudentgrid();
                					   var record=grid.getSelectionModel().getSelection();
                					   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
                					   //var btnApprove=grid.down('#btnApprove');
                					   //btnApprove.setDisabled(true);
                					   var models = grid.getStore().getRange();
                					   var totalRevalApplied=0;
	                				   var grid = $this.getRevaluationcoreerpstudentgrid();
	                				   //if(grid.getSelectionModel().getCount()>0){
	                				   if(record.length>0){
	                					   
	                					   for(var i in record) {
	                						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	    	                					   obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
	                							   if(record[i].data.approvalStatus=="APPROVED"){
	                								   showWarningMessage(getCommonTranslation('ALERT'),
		                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
	        	                					   obj.setDisabled(false);
		                							   return false; 
	                							   }
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   totalAmmount=totalAmmount+parseInt(record[i].data.feeAmount);
	                							   innerJsonArr.push({
	                								   "admissionId": record[i].data.admissionId,
	                								   "studentId": record[i].data.studentId,
	                								   "feePlanRuleStageId": record[i].data.feePlanRuleStageId,
	                								   "amount": record[i].data.feeAmount,
	                								  // "remark": remark.getValue(),
	                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
	                								   "examinationResultId": record[i].data.examinationResultId,
	                										   "courseVariantId": record[i].data.courseVariantId,
	                										   "periodId": record[i].data.periodId,
	                										   "eventId": record[i].data.eventId,
	                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record[i].data.appliedDate,
	                										 //  "courseCode": record[i].data.courseCode,
	                										  // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										 //  "eventName": record[i].data.event,
	                										   "previousMarks": record[i].data.obtainedMarks,
	                										   "previousGrade": record[i].data.finalGrade,
	                										   "previousGradePoint": record[i].data.gradePoints,
	                										   "previousResultStatus": record[i].data.resultStatus,
	                										   "isApproveEvent":true,
	                										   "examStudentRevalId":record[i].data.studentRevalId,
	                										   "approvalStatus":"APPROVED"
	                							   });
	                							   json={
	                									   'firstName':record[0].data.firstName,
	                									   'lastName':record[0].data.lastName,
	                									   'phoneNo':record[0].data.mobileCountryCode+" "
	                									   +record[0].data.mobileNumber,
	                									   'email':record[0].data.emailId,
	                									   'studentCode':record[0].data.studentCode,
	                									   "totalAmount":totalAmmount,
	                									   "detailModel":innerJsonArr
	                							   };
	                							   arrayData.push(json);
	                							  
	                							   
	                						   } else {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	    	                					   obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   var admissionIds = []; // Initialize admissionIds as an array
										for (var i = 0; i < record.length; i++) {
										    var recordNew = record[i];   
										    admissionIds.push(recordNew.data.admissionId); // Add admission ID to the array
										}

										   Ext.Ajax.request({        
				                   type: 'rest', 
				                   url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
				                   params: {
				                       periodId:record[0].data.periodId,
				                       admissionIds: admissionIds.join(),   
				                       portalId:portalId       
				                   },
				                   method: 'GET',
				                   success: function(res, action) {
				                       var response = Ext.decode(res.responseText);
				                      var capacity = Ext.decode(res.responseText);
					var gridRecord = grid.getSelectionModel().getSelection();
					var selectionByStudentAndPeriod = {};    				
					Ext.each(gridRecord, function(record) {  
                        var studentId = record.get('studentId');
                        var periodId = record.get('periodId');
                        var key = studentId + '-' + periodId;

                        if (!selectionByStudentAndPeriod[key]) {
                            selectionByStudentAndPeriod[key] = [];
                        }
                        selectionByStudentAndPeriod[key].push(record);
                    });

                    // Check if any student exceeds the capacity for the period
                    for (var key in selectionByStudentAndPeriod) {
                        if (capacity==0) { 
                            var studentPeriod = key.split('-');
                            var studentId = studentPeriod[0];
                            var periodId = studentPeriod[1];
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP')); 
                           // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
                            break;  
                        }else{    
								Ext.Ajax.request({
  	    	            						type: 'rest',
  	    	            						url: SERVERURL.PATH_GENERATE_REVALUATION_WITHOUT_FEE,
  	    	            						jsonData: arrayData,
  	    	            						method: 'POST',
       	                					   success : function(response, action) {
       		                					   obj.setDisabled(false);
       	                						   showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getExaminationTranslation('SUCCESSFULLY_APPLIED_FOR_THE_REVALUATION'));
       	                						   grid.getSelectionModel().deselectAll();
       	                						   tempStore.removeAll();
       	                						   grid.getStore().load();
       	                					   }
       	                				   });    
                    		}
                        }
				                   }
				                   
				               });
	                		}else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                					   obj.setDisabled(false);
	                				   }
	                			   }
	                		   },
	                		   
	                		   'revalsummarywin button#payNow' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   
	                				   var XMLHttpRequestObject = false;  
        							   if (window.XMLHttpRequest) {  
        								   XMLHttpRequestObject = new XMLHttpRequest();  
        								   XMLHttpRequestObject.overrideMimeType("text/xml");  
        							   }  
        							   else if (window.ActiveXObject) {  
        								   XMLHttpRequestObject = new  
        								   ActiveXObject("Microsoft.XMLHTTP");  
        							   } 
        							   var tabName = getExaminationTranslation('EXAMINATION_APPLY_FOR_REVALUATION');
        							   var getcontroller=$this.getController('menu.CoreERPNavigationController');
        							   var getTab=getcontroller.getTab(tabName);
        							   var contentpanel = this.getContentPanel();
        							   if(XMLHttpRequestObject) {  
        								   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
        								   XMLHttpRequestObject.onreadystatechange = function() {       
        									   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
        										   var xmlDocument = XMLHttpRequestObject.responseXML;  
        										   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
        										   revalPaymentUrl = buildInfo.getElementsByTagName("revalPaymentUrl") [0].childNodes[0].nodeValue;
        										   var w ='900',h ='500';
        										// Fixes dual-screen position                         Most browsers      Firefox
        										    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
        										    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

        										    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        										    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

        										    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        										    var top = ((height / 2) - (h / 2)) + dualScreenTop;
        										    var newWindow = window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

        										    // Puts focus on the newWindow
        										    if (window.focus) {
        										        newWindow.focus();
        										    }
        										    
        										   window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment',
        												    "status=no,height=" + 800 + ",width=" + 800 + ",resizable=yes,left="
        												    + left + ",top=" + top + ",screenX=" + left + ",screenY="
        												    + top + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");
        		                				   Ext.defer(function() {
        		                					   formWindow.down('#payNow').setVisible(false);
        		                					   formWindow.down('#cancelBtn').setVisible(false);
        		                					   formWindow.down('#okBtn').setVisible(true);
        		                				   }, 150, this);
        									   }  
        								   }  
        								   XMLHttpRequestObject.send(null);  
        							   }
	                			   }
	                		   },

	                		   'revalsummarywin button#okBtn' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var grid = $this.getRevaluationcoreerpstudentgrid();
	                				   grid.getSelectionModel().deselectAll();
	                				   
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                					   tempStore.removeAll();
	                				   }
	                				   catch(e){}
	                				   
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   grid.getStore().reload();
	                				   formWindow.close();
	                			   }
	                		   },
	                		   'revalsummarywin button#cancelBtn' : {
	                			   click : function(obj) {
	                				   var $this = this;
	                				   var formWindow  = $this.getRevalsummarywin();
	                				   formWindow.close();
	                			   }
	                		   },

	                		   'revaluationcoreerpstudentgrid menuitem#btnRefreshItemId' : {
	                			   click : function(obj, record) {
	                				   var $this = this;
	                				   var form = $this.getRevaluationcoreerpstudentfilter();
	                				   var grid = $this.getRevaluationcoreerpstudentgrid();
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                				   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                				   var attendanceProgram = form.down("#programIdQuickFilter");
	                				   var attendanceProgram = form.down("#programIdQuickFilter");
	                				   var revaluationApprovalStatus = form.down("#revaluationApprovalStatus");
	                				   var revaluationStatus = form.down("#revaluationStatus");
	                				   var revaluationTypeEnum = form.down("#revaluationTypeEnum");
	                				   var courseItemId = form.down("#courseItemId");
	                				   var fromdate = form.down("#fromdate");
	                				   var tilldate = form.down("#tilldate");
	                				   var studentItemId = form.down("#studentItemId");
	                				   var revalType=null;
	                				   if(revaluationTypeEnum.getValue()=="Review"){
	                					   revalType="REVIEW";
	                				   }else if(revaluationTypeEnum.getValue()=="Revaluation"){
	                					   revalType="REVALUATION";
	                				   }else if (revaluationTypeEnum.getValue()=="Challenge"){
	                					   revalType="CHALLENGE";
	                				   }
	                				   
	                				   var data=attendanceProgram.getStore().proxy.reader.rawData;
	                				   var admissionId=null;
	                				   for(var i in data) {
	                					   if(data[i].programId==attendanceProgram.getValue()) {
	                						   admissionId=data[i].admissionId;
	                					   }
	                				   }
	                				   var batchCombo = form.down("#batchIdQuickFilter");
	                				   var periodField = form.down('#periodIdQuickFilter');


	                				   grid.getSelectionModel().deselectAll();
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                					   tempStore.removeAll();
	                				   }
	                				   catch(e){}
	                				   $this.resetGridSetting(grid);
	                				   $this.resetPageSetting(grid.getStore(), grid);
	                				   grid.getStore().getProxy().extraParams={
	                					   admissionId : studentItemId.getValue(),
	                					   programId:attendanceProgram.getValue(),
	                					   batchId:batchCombo.getValue(),
	                					   periodId:periodField.getValue(),
	                					   revalApprovalStatus:revaluationApprovalStatus.getValue(),
	                					   revaluationStatus: revaluationStatus.getValue(),
	                					   revaluationType:revalType,
	                					   courseId:courseItemId.getValue(),
	                					   fromDate:fromdate.getValue(),
	                					   tillDate:tilldate.getValue(),
	                					   sort:null
	                				   };
	                				   grid.getStore().load({
	                					   callback:function(records){
	                						   var msgLable = grid.down('#applyForRevalMsgId');
	                						   if(records.length>0){
	                							   msgLable.setValue('');
	                						   } else {
	                							   msgLable.setValue("<span style='color:blue'>Process not started yet</span>");
	                						   }
	                						   msgLable.setVisible(true);
	                					   }
	                				   });
	                				   grid.down('#btnApplyItemId').setDisabled(true);
	                				   grid.down('#btnApplyNowItemId').setDisabled(true);
	                				   grid.down('#offlinePaymentItemId').setDisabled(true);
	                				   grid.down('#btnApprove').setDisabled(true);
	                			   }
	                		   },
	                			   
	                		   'revaluationcoreerpstudentfilter':{
	                			   beforerender : function(form){
	                				   var $this = this;
	                				   var attendanceProgram = form.down("#attendanceProgramId");
	                				   var batchCombo = form.down("#batchCombo");
	                				   var periodField = form.down('combo#periodId');
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var facultyId = null;

	                				   if (this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7) {
	                					   attendanceProgram.setVisible(true);
	                					   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                					   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                					   var studentPeriodId = studentPortalInfo.programBatchDetails.periodId;

	                					   var attendanceProgramStore = attendanceProgram.getStore();
	                					   attendanceProgramStore.getProxy().extraParams = {
	                						   studentId: studentPortalInfo.student.id,
											   onlyCurrentRecords: false
	                					   };
	                					   attendanceProgramStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   for(var i in records){
	                									   if(records[i].data.programId == studentprogramId){
	                										   attendanceProgram.setValue(records[i].data.programId);
	                										   var batchStore = batchCombo.getStore();
	                										   batchCombo.setDisabled(false);
	                										   batchStore.getProxy().extraParams = {
	                											   programId: records[i].data.id,
	                											   studentId : studentPortalInfo.student.id,
	                											   onlyCurrentRecords: false
	                										   };
	                										   batchStore.load({
	                											   callback: function(records, operation, success) {
	                												   if (success) {
	                													   for(var i in records){
	                														   if(records[i].data.batchId == studentbatchId){
	                															   batchCombo.setValue(records[i].data.batchId);
	                															   var periodCombo = form.down("#periodId");
	                															   periodCombo.setDisabled(false);

	                															   var periodStore = periodCombo.getStore();
	                															   periodStore.getProxy().extraParams = {
	                																   id: records[i].data.batchId
	                															   };
	                															   periodStore.load({
	                																   callback: function(records, operation, success) {
	                																	   if (success) {
	                																		   for(var i in records){
		                																		   if (records[i].data.id == studentPeriodId) {
		                																			   periodCombo.setValue(records[i].data.id);
		                																		   }
	                																		   }
	                																	   }
	                																   }
	                															   });
	                						                					   form.isValid();
	                														   }
	                													   }
	                												   }
	                											   }
	                										   });
	                									   }
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                			   },
	                			   render:function(form){
	                				   var admission = form.down("#studentItemId");
	                				   var academicTerm = form.down("#academicTerm");
	                				   admission.reset();
	                				   var admissionStore = admission.getStore();
	                				   admissionStore.getProxy().extraParams = {
	                					   academyLocationId: this.getCurrentAcademyLocation()
	                				   };
	                				   admissionStore.load();
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentfilter combo#academicTerm' : {
	                			   afterrender :function(form){
	                				   form.getStore().load();
	                			   },
	                			   select : function(obj, record) {
	                				   var form = obj.up('form');
	                				   var course = form.down("#courseItemId");
	                				   var admission = form.down("#studentItemId");
	                				   var program = form.down("#programIdQuickFilter");
	                				   var batch = form.down("#batchIdQuickFilter");
	                				   var period = form.down("#periodIdQuickFilter");
	                				   period.reset();
	                				   period.setDisabled(true);
	                				   batch.setDisabled(true);
	                				   batch.reset();
	                				   course.reset();
	                				   if(record && record[0]) {
	                					   var courseStore = course.getStore();
	                					   courseStore.getProxy().extraParams = {
	                						   academicTermId: record[0].data.id,
	                					   };
	                					   courseStore.load();

	                					   admission.reset();
	                					   var admissionStore = admission.getStore();
	                					   admissionStore.getProxy().extraParams = {
	                						   academicTermId: record[0].data.id
	                					   };
	                					   admissionStore.load();

	                					   program.reset();
	                					   var programStore = program.getStore();
	                					   programStore.getProxy().extraParams = {
	                						   academicTermId : record[0].data.id,
	                					   };
	                					   programStore.load({
	                						   callback: function(rec) {
	                							   if(rec && rec.length == 1 ) {
	                								   program.setValue(rec.get('id'));
	                								   program.fireEvent('select', program, rec);
	                							   }
	                						   }
	                					   });
	                				   }
	                				   else {
	                					   obj.reset();
	                					   batch.enable();
	                				   }
	                				   this.resetMoreFilter();
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentfilter combo#courseItemId' : {
	                			   select : function(obj, record) {
	                				   var form = obj.up('form');
	                				   var admission = form.down("#studentItemId");
	                				   var academicTerm = form.down("#academicTerm");
	                				   var program = form.down("#programIdQuickFilter");
	                				   var batch = form.down("#batchIdQuickFilter");
	                				   var period = form.down("#periodIdQuickFilter");
	                				   period.reset();
	                				   period.setDisabled(true);
	                				   batch.setDisabled(true);
	                				   batch.reset();
	                				   admission.reset();
	                				   var admissionStore = admission.getStore();
	                				   admissionStore.getProxy().extraParams = {
	                					   courseId: record[0].data.id,
	                					   academicTermId : academicTerm.getValue()
	                				   };
	                				   admissionStore.load();
	                				   program.reset();
	                				   var programStore = program.getStore();
	                				   programStore.getProxy().extraParams = {
	                					   courseId:  record[0].data.id,
	                					   academicTermId : academicTerm.getValue(),
	                					   admissionId : admission.getValue()
	                				   };
	                				   programStore.load();
	                				   
	                				   this.resetMoreFilter();
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentfilter combo#studentItemId' : {
	                			   select : function(obj, record) {
	                				   var form = obj.up('form');
	                				   var admission = form.down("#studentItemId");
	                				   var academicTerm = form.down("#academicTerm");
	                				   var courseItemId = form.down("#courseItemId");
	                				   var program = form.down("#programIdQuickFilter");
	                				   var batch = form.down("#batchIdQuickFilter");
	                				   var period = form.down("#periodIdQuickFilter");
	                				   program.reset();
	                				   batch.reset();
	                				   period.reset();
	                				   var arr=[];
		            				   arr.push(this.getCurrentAcademyLocation());
		            				   var academyLocationIds=arr.join();
		            				   var admId=record[0].data.id;
	                				   var programStore = program.getStore();
	                				   programStore.getProxy().extraParams = {
	                					   courseId: courseItemId.getValue(),
	                					   academicTermId : academicTerm.getValue(),
	                					   admissionId : record[0].data.id
	                				   };
	                				   programStore.load({
	                					   callback: function(records, operation, success) {
	                						   if (success) {
	                							   program.setValue(records[0].data.id);
	                							   batch.reset();
	                							   var batchId = batch.getStore();
	                							   batchId.getProxy().extraParams={
	                								   academyLocationIds:arr.join(),
	                								   admissionId:admId,
	                								   programId:records[0].data.id,
	                							   };
	                							   batchId.load({
	                								   callback: function(record, operation, success) {
	                									   if (success) {
	                										   batch.setDisabled(false);
	                										   if(record.length==1){
	                											   batch.setValue(record[0].data.id);
		                										   var periodId = period.getStore();
		                										   periodId.getProxy().extraParams={
		                											   academyLocationIds:academyLocationIds,
		                											   admissionId:admId,
		                											   programId:records[0].data.id,
		                											   batchId:record[0].data.id,
		                										   };
		                										   periodId.load({
		        	                								   callback: function(record, operation, success) {
		        	                									   if (success) {
		        	                										   period.setDisabled(false);
		        	                										   if(record.length==1){
		        	                											   period.setValue(record[0].data.id);
		        	                										   }else{
		        	                											   period.setDisabled(false);
		        	                										   }
		        	                										   
		        	                									   }
		        	                								   }
		        	                							   });
	                										   }else{
	                											   batch.setDisabled(false);
	                										   }
	                										   
	                									   }
	                								   }
	                							   });
	                						   }
	                					   }	   
	                				   });
	                				   
	                				   this.resetMoreFilter();
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentfilter combo#programIdQuickFilter' : {
	                			   select : function(obj, record) {
	                				
	                				   var form = obj.up('form');
	                				   var batchCombo = form.down("#batchIdQuickFilter");
	                				   var periodComboBox = form.down('#periodIdQuickFilter');
	                				   periodComboBox.reset();
	                				   periodComboBox.disable();
	                				   batchCombo.reset();
	                				   var batchStore = batchCombo.getStore();
	                				   batchCombo.setDisabled(false);
	                				   batchStore.getProxy().extraParams = {
	                					   programId: record[0].data.id,
	                				   };
	                				   batchStore.load();
	                				   
	                				   this.resetMoreFilter();
	                			   }
	                		   },

	                		   'revaluationcoreerpstudentfilter combo#batchIdQuickFilter' : {
	                			   select : function(obj, record) {
	                				   var batch_Id = record[0].get("id");
	                				   var form = obj.up('form');
	                				   var periodComboBox = form.down('#periodIdQuickFilter');
	                				   periodComboBox.clearValue();
	                				   periodComboBox.setDisabled(false);
	                				   var periodStore = periodComboBox.getStore();
	                				   periodStore.getProxy().extraParams = {
	                					   batchId: batch_Id
	                				   };
	                				   periodStore.load();
	                				   this.resetMoreFilter();
	                			   }
	                		   },

	                		   'revaluationcoreerpstudentfilter button#searchBtn' : {
	                			   click : function(obj, record) {
	                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   if(tempStore.data.length >0 ){
	                					   tempStore.removeAll();
	                				   }
	                				   var filterForm = this.getRevaluationcoreerpstudentfilter();
	                				   var form = obj.up('form');
	                				   var $this = this;
	                				   var grid = this.getRevaluationcoreerpstudentgrid();
	                				   var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                				   var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	                				   var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	                				   var attendanceProgram = form.down("#programIdQuickFilter");
	                				   var revaluationApprovalStatus = form.down("#revaluationApprovalStatus");
	                				   var revaluationStatus = form.down("#revaluationStatus");
	                				   var revaluationTypeEnum = form.down("#revaluationTypeEnum");
	                				   var courseItemId = form.down("#courseItemId");
	                				   var fromdate = form.down("#fromdate");
	                				   var tilldate = form.down("#tilldate");
	                				   var studentItemId = form.down("#studentItemId");
	                				   var revalType=null;
	                				   if(revaluationTypeEnum.getValue()=="Review"){
	                					   revalType="REVIEW";
	                				   }else if(revaluationTypeEnum.getValue()=="Revaluation"){
	                					   revalType="REVALUATION";
	                				   }else if (revaluationTypeEnum.getValue()=="Challenge"){
	                					   revalType="CHALLENGE";
	                				   }
	                				   
	                				   var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
	                				   var btnApprove=grid.down('#btnApprove');
		    	                	   var btnApplyItemId=grid.down('#btnApplyItemId');
		    	                	   var btnApplyNow=grid.down('#btnApplyNowItemId');
	                				   
	                				   btnApplyNow.setDisabled(true);
	    	                		   btnApprove.setDisabled(true);
	    	                		   btnApplyItemId.setDisabled(true);
	    	                		   offlinePaymentItemId.setDisabled(true);
	                				  
	                				   var store = grid.getStore();
		    	                	   var models = store.getRange();
	                				   
	                				   var data=attendanceProgram.getStore().proxy.reader.rawData;
	                				   var admissionId=null;
	                				   for(var i in data) {
	                					   if(data[i].programId==attendanceProgram.getValue()) {
	                						   admissionId=data[i].admissionId;
	                					   }
	                				   }
	                				   var batchCombo = form.down("#batchIdQuickFilter");
	                				   var periodField = form.down('#periodIdQuickFilter');
	                				   var store = $this.getStore('examCenter.AssignSequence.RevaluationTypeByPeriod');
	                				   store.getProxy().extraParams={
	                					   periodId:periodField.getValue()
	                				   };
	                				   store.load();
									   var withFeeReval=false;
		    	                	   var withChallenge=false;
		    	                	   var withReview=false;
	                				   Ext.Ajax.request({
	       									type : 'rest',
	       									url : SERVERURL.PATH_FIND_REVAL_TYPE_BY_PERIOD,
	       									params : {
	       										periodId : periodField.getValue()
	       									},
	       									method : 'GET',
	       									success : function(response, action) {
		                				   	var revalStoreData = Ext.decode(response.responseText);
		                				   	for(var i in revalStoreData){
		                				   		
				    	                		   if(revalStoreData[i].code=="REVALUATION"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isRevalFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isRevalFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#revalFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                			   form.down('#revalFeeAmount').setValue(revalStoreData[i].doubleValue);
				    	                		   } 
				    	                		   if(revalStoreData[i].code=="REVIEW"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isReviewFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isReviewFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#reviewFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                			   form.down('#reviewFeeAmount').setValue(revalStoreData[i].doubleValue);
				    	                		   } 
				    	                		   if(revalStoreData[i].code=="CHALLENGE"){
				    	                			   if(revalStoreData[i].sequence==1){
				    	                				   form.down('#isChallengeFeeApplicable').setValue(true);
				    	                			   } else {
				    	                				   form.down('#isChallengeFeeApplicable').setValue(false);
				    	                			   }
				    	                			   form.down('#challengeFeePlanRuleStageId').setValue(revalStoreData[i].academicTermId);
				    	                			   form.down('#challengeFeeAmount').setValue(revalStoreData[i].doubleValue);
				    	                		   } 
				    	                	   }	       									
		                				   	}
		                				   });
	                				   
	                				   if(!isNullOrEmpty(periodField.getValue())){
	                					   grid.getSelectionModel().deselectAll();
		                				   $this.resetGridSetting(grid);
		                				   $this.resetPageSetting(grid.getStore(), grid);
		                				   grid.getStore().getProxy().extraParams={
		                					   admissionId : studentItemId.getValue(),
		                					   programId:attendanceProgram.getValue(),
		                					   batchId:batchCombo.getValue(),
		                					   periodId:periodField.getValue(),
		                					   revalApprovalStatus:revaluationApprovalStatus.getValue(),
		                					   revaluationStatus: revaluationStatus.getValue(),
		                					   revaluationType:revalType,
		                					   courseId:courseItemId.getValue(),
		                					   fromDate:fromdate.getValue(),
		                					   tillDate:tilldate.getValue(),
		                					   sort:null
		                				   };
		                				   grid.getStore().load({
		                					   callback:function(records){
		                						   var msgLable = grid.down('#applyForRevalMsgId');
		                						   if(isNullOrEmpty(records) && records.length>0){
		                							   msgLable.setValue('');
		                							   var doneCount=0;
		                							   for(var i in records){
		                								   if(records[i].data.revaluationStatus.toUpperCase() == 'SUBMITTED'.toUpperCase()){
		                									   doneCount++;
		                								   }
		                							   }
		                							   if(records[0].data.revaluationFor == 'COURSE_LEVEL') {
		                								   //grid.columns[8].setVisible(false);
		                								   for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
							                                var column = grid.columnManager.columns[i];
							                                if (column.dataIndex == 'DETAILED_SEQUENCE') {
							                                    column.hide();
							                                }
							                            }
		                							   } else {
		                								   //grid.columns[8].setVisible(true);
		                								   for (var i = grid.columnManager.columns.length - 1; i >= 0; i--) {
							                                var column = grid.columnManager.columns[i];
							                                if (column.dataIndex == 'DETAILED_SEQUENCE') {
							                                    column.show();
							                                }
							                            }
		                							   }
		                						   } else {
		                							   //msgLable.setValue("<span style='color:blue'>Process not configured or not started for "+periodField.getRawValue()+"</span>");
		                						   }
		                						   msgLable.setVisible(true);
		                					   }
		                				   });
	                				   }else{
                							   showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('SELECTION_ALERT_MSG'));
                							   return false;
	                				   }
	                				   grid.config.searchFilterForm = filterForm;
	                			   }
	                		   },

	                		   'revaluationcoreerpstudentfilter button#resetBtn' : {
	                			   click : function(obj, record) {
	                				   var $this = this;
	                				   var form = obj.up('form');
	                				   form.getForm().reset();
	                				   form.down('#periodIdQuickFilter').setDisabled(true);
	                				   form.down('#batchIdQuickFilter').setDisabled(true);
	                				   var fromDate=form.down('#fromdate');
	                				   var tillDate=form.down('#tilldate');
	                				   var program=form.down('#programIdQuickFilter')
	                				   fromDate.setMinValue(null);
	                				   tillDate.setMinValue(null);
	                				   fromDate.setMaxValue(null);
	                				   tillDate.setMaxValue(null);
	                				   var admission = form.down("#studentItemId");
	                				   var academicTerm = form.down("#academicTerm");
	                				   admission.reset();
	                				   var admissionStore = admission.getStore();
	                				   admissionStore.getProxy().extraParams = {
	                					   academyLocationId: this.getCurrentAcademyLocation()
	                				   };
	                				   admissionStore.load();
	                				   
	                				   program.reset();
	                				   var programStore = program.getStore();
	                				   programStore.getProxy().extraParams = {
	                				   };
	                				   programStore.load();
	                				   
	                				   var grid = this.getRevaluationcoreerpstudentgrid();
	                				   grid.getSelectionModel().deselectAll();
	                				   try{
		                				   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
		                				   if(tempStore.data.length >0 ){
		                					   tempStore.removeAll();
		                				   }
	                				   }
	                				   catch(e){}
	                				   $this.resetGridSetting(grid);
	                				   $this.resetPageSetting(grid.getStore(), grid);
	                				 //  grid.getStore().loadRawData([]);
	                			   }
	                		   },
	                		   
	                		   'revaluationcoreerpstudentgrid menuitem#offlinePaymentItemId': {
	                               click: function() {
	                            	 var this$ = this;
	        	                	   var grid=this.getRevaluationcoreerpstudentgrid();
	        	                	   
	        	                	   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                				   
	        	                	   //var record =tempStore.data.items;//grid.getSelectionModel().getSelection();

	        	                	   var record =tempStore.data.items.length!=0?tempStore.data.items:grid.getSelectionModel().getSelection();
	        	                	   
	        	                	   if(record.length==0){
	        	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	                		   return false;
	        	                	   }

							 
	        	                	   
	        	                	   for(var i in record) {
	            						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	            							   showWarningMessage(getCommonTranslation('ALERT'),
	            									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	            							   return false;
	            						   }
	            					   }
	        	                	   
	        	                	   for(var i in record) {
                						   if(!isNullOrEmpty(record[i].data.approvalStatus)) {
                							   if(record[i].data.approvalStatus=="APPROVED"){
                								   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getExaminationTranslation('DISTRIBUTION_STATUS_APPROVED'));
	                							   return false; 
                							   }
                						   }
                					   }
										var admissionIds = []; // Initialize admissionIds as an array
										for (var i = 0; i < record.length; i++) {
										    var recordNew = record[i];   
										    admissionIds.push(recordNew.data.admissionId); // Add admission ID to the array
										}

	                              var docController=this.getDocumentController();
								Ext.Ajax.request({        
				                   type: 'rest', 
				                   url: SERVERURL.PATH_REVALUATION_CAPACITY_URL,
				                   params: { 
				                       periodId:record[0].data.periodId,
				                       admissionIds: admissionIds.join(),   
				                       portalId:portalId      
				                   },
				                   method: 'GET',
				                   success: function(res, action) {
				    var capacity = Ext.decode(res.responseText);
					var gridRecord = grid.getSelectionModel().getSelection(); 
					var selectionByStudentAndPeriod = {};    				
					Ext.each(gridRecord, function(record) {   
                        var studentId = record.get('studentId');
                        var periodId = record.get('periodId');
                        var key = studentId + '-' + periodId;

                        if (!selectionByStudentAndPeriod[key]) {
                            selectionByStudentAndPeriod[key] = [];
                        }
                        selectionByStudentAndPeriod[key].push(record);
                    });

                    // Check if any student exceeds the capacity for the period
                    for (var key in selectionByStudentAndPeriod) {
                        if (capacity==0) {
                            var studentPeriod = key.split('-');
                            var studentId = studentPeriod[0];
                            var periodId = studentPeriod[1];
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAXIMUM_COURSE_CAPACITY_EXP'));  
                           // selModel.deselect(selectionByStudentAndPeriod[key][selectionByStudentAndPeriod[key].length - 1]);
                            break; 
                        }else{    
								docController.showDocumentFormWindow('offlinePaymentDocumentCoreErp', 'DOCUMENT');
	                                   Ext.defer(function() {   
	                                	   Ext.ComponentQuery.query('documentformwindow')[0].setTitle(getExaminationTranslation('TRANSACTION_DETAILS'));
	                                   }, 10, this);	
										}
                    		}}
				                   
				               });  
								
									 
	                                   
	                               }
	                           },
	                		   
	                	       'documentformwindow[itemId=offlinePaymentDocumentCoreErp] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
	                			   click : this.saveRevalTransaction
	                		   },
	                		   
	                		   'revaluationcoreerpstudentgrid menuitem#btnApprove' : {
	                			   click : function(obj) { 
	                				   var $this = this;
	                				   var formWindow = $this.getRevaluationapprovalwin();
	                				   var grid=$this.getRevaluationcoreerpstudentgrid();
                					   var record=grid.getSelectionModel().getSelection();
	                				   
	        	                	   if(record.length==0){
	        	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	                		   return false;
	        	                	   }
	        	                	   
                					   for(var i in record) {
                						   if(isNullOrEmpty(record[i].data.documentId) &&
                								   (record[i].data.revaluationStatus=="Pending")) {
                							   showWarningMessage(getCommonTranslation('ALERT'),
                									   getExaminationTranslation('TRANSACTION_IS_PENDING'));
    	                					   obj.setDisabled(false);
                							   return false;
                						   }
                					   }
	                				   
	                				   if (!formWindow) {
	                					   Ext.widget('revaluationapprovalwin');
	                					   formWindow = $this.getRevaluationapprovalwin();
	                				   }
	                				   formWindow.show();
	                				   var approveRejectBtn=formWindow.down('#approveRejectId');
	                				   approveRejectBtn.getStore().load({
							        		callback: function(records, operation, success) {
							        			if(records.length>0){
							        				Ext.each(records, function(value) {
							        					approveRejectBtn.setValue(records[0].data.value);
							        				});
							        			}
							        		}
							        	});
	                			   }
	                		   },
	                		   
	                		   'revaluationapprovalwin button#submitBtnWin' : {
	                			   click : function(obj, record) {
	                				   obj.setDisabled(true);
	                				   var $this = this;
	                				   var totalAmmount=0;
	                				   var innerJsonArr=[], json;
                					   var totalAmmount=0;
                					   var arrayData=[];
                					   var grid=$this.getRevaluationcoreerpstudentgrid();
                					   var record=grid.getSelectionModel().getSelection();
                					   var getForm=$this.getRevaluationcoreerpstudentfilter();
                					   
                					   
                					   
                					   var revalFeePlanRuleStageId=getForm.down('#revalFeePlanRuleStageId').getValue();
                					   var reviewFeePlanRuleStageId=getForm.down('#reviewFeePlanRuleStageId').getValue();
                					   var challengeFeePlanRuleStageId= getForm.down('#challengeFeePlanRuleStageId').getValue();
                					   
                					   var revalFeeAmount= getForm.down('#revalFeeAmount').getValue();
                					   var reviewFeeAmount= getForm.down('#reviewFeeAmount').getValue();
                					   var challengeFeeAmount= getForm.down('#challengeFeeAmount').getValue();
                					   
                					   var formWin=$this.getRevaluationapprovalwin();
                					   var approveRejectStatus=formWin.down('#approveRejectId');
                					   var remark=formWin.down('#remark');
                					   var models = grid.getStore().getRange();
                					   var totalRevalApplied=0;
	                				   var grid = $this.getRevaluationcoreerpstudentgrid();
	                				   //if(grid.getSelectionModel().getCount()>0){
	                				   if(record.length>0){
	                					    
	                					   for(var i in record) {
	                						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	                							   	//obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
	                					   
	                					   for(var i in record) {
	                						   if(!isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
	                							   
	                							   var feePlanRuleStageId=null;
	                							   var feeAmount=0.0;
	                							   if(!isNullOrEmpty(revalFeePlanRuleStageId) && record[i].data.revaluationTypeEnum.toUpperCase()=="REVALUATION"){
	                								   feePlanRuleStageId=revalFeePlanRuleStageId
	                							   } else if(!isNullOrEmpty(reviewFeePlanRuleStageId) && record[i].data.revaluationTypeEnum.toUpperCase()=="REVIEW"){
	                								   feePlanRuleStageId=reviewFeePlanRuleStageId
	                							   } else if (!isNullOrEmpty(challengeFeePlanRuleStageId) && record[i].data.revaluationTypeEnum.toUpperCase()=="CHALLENGE"){
	                								   feePlanRuleStageId=challengeFeePlanRuleStageId
	                							   }
	                							   
	                							   if(!isNullOrEmpty(revalFeeAmount) && record[i].data.revaluationTypeEnum.toUpperCase()=="REVALUATION"){
	                								   feeAmount=revalFeeAmount
	                							   } else if(!isNullOrEmpty(reviewFeeAmount) && record[i].data.revaluationTypeEnum.toUpperCase()=="REVIEW"){
	                								   feeAmount=reviewFeeAmount
	                							   } else if (!isNullOrEmpty(challengeFeeAmount) && record[i].data.revaluationTypeEnum.toUpperCase()=="CHALLENGE"){
	                								   feeAmount=challengeFeeAmount
	                							   }
	                							   var setUrl=null;
	                							   if(isNullOrEmpty(feePlanRuleStageId)){
	                								   totalAmmount=totalAmmount+parseInt(record[i].data.feeAmount);
	                								   setUrl=SERVERURL.PATH_GENERATE_REVALUATION_WITHOUT_FEE;
		                							   innerJsonArr.push({
		                								   "admissionId": record[i].data.admissionId,
		                								   "studentId": record[i].data.studentId,
		                								   "feePlanRuleStageId": record[i].data.feePlanRuleStageId,
		                								   "amount": feeAmount,
		                								   "remark": remark.getValue(),
		                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
		                								   "examinationResultId": record[i].data.examinationResultId,
		                										   "courseVariantId": record[i].data.courseVariantId,
		                										   "periodId": record[i].data.periodId,
		                										   "eventId": record[i].data.eventId,
		                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
		                										   "appliedDate": record[i].data.appliedDate,
		                										 //  "courseCode": record[i].data.courseCode,
		                										  // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
		                										 //  "eventName": record[i].data.event,
		                										   "previousMarks": record[i].data.obtainedMarks,
		                										   "previousGrade": record[i].data.finalGrade,
		                										   "previousGradePoint": record[i].data.gradePoints,
		                										   "previousResultStatus": record[i].data.resultStatus,
		                										   "isApproveEvent":true,
		                										   "examStudentRevalId":record[i].data.studentRevalId,
		                										   "approvalStatus":approveRejectStatus.valueModels[0].data.name
		                							   });
		                							   json={
		                									   'firstName':record[0].data.firstName,
		                									   'lastName':record[0].data.lastName,
		                									   'phoneNo':record[0].data.mobileCountryCode+" "
		                									   +record[0].data.mobileNumber,
		                									   'email':record[0].data.emailId,
		                									   'studentCode':record[0].data.studentCode,
		                									   "totalAmount":totalAmmount,
		                									   "detailModel":innerJsonArr
		                							   };
		                							   arrayData.push(json);
	                							   }
	                							   else {
	                								   setUrl=SERVERURL.PATH_GENERATE_REVALUATION_WITH_FEE;
	                								   totalAmmount=totalAmmount+parseInt(feeAmount);
		                							   innerJsonArr.push({
		                								   "admissionId": record[i].data.admissionId,
		                								   "studentId": record[i].data.studentId,
		                								   "feePlanRuleStageId": parseInt(feePlanRuleStageId),
		                								   "remark": remark.getValue(),
		                								   "amount": feeAmount,
		                								   "examRevalRuleMappingId": record[i].data.examRevalRuleMappingId,
		                								   "examinationResultId": record[i].data.examinationResultId,
		                										   "courseVariantId": record[i].data.courseVariantId,
		                										   "periodId": record[i].data.periodId,
		                										   "eventId": record[i].data.eventId,
		                										   "revaluationType": record[i].data.revaluationTypeEnum.toUpperCase(),
		                										   "appliedDate": record[i].data.appliedDate,
		                										 //  "courseCode": record[i].data.courseCode,
		                										  // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
		                										 //  "eventName": record[i].data.event,
		                										   "previousMarks": record[i].data.obtainedMarks,
		                										   "previousGrade": record[i].data.finalGrade,
		                										   "previousGradePoint": record[i].data.gradePoints,
		                										   "previousResultStatus": record[i].data.resultStatus,
		                										   "isApproveEvent":true,
		                										   "examStudentRevalId":record[i].data.studentRevalId,
		                										   "approvalStatus":approveRejectStatus.valueModels[0].data.name
		                							   });
		                							   json={
		                									   'firstName':record[0].data.firstName,
		                									   'lastName':record[0].data.lastName,
		                									   'phoneNo':record[0].data.mobileCountryCode+" "
		                									   +record[0].data.mobileNumber,
		                									   'email':record[0].data.emailId,
		                									   'studentCode':record[0].data.studentCode,
		                									   "totalAmount":totalAmmount,
		                									   "detailModel":innerJsonArr
		                							   };
		                							   arrayData.push(json);
	                							   }
	                							   
	                							 
	                							   
	                						   } else {
	                							   showWarningMessage(getCommonTranslation('ALERT'),
	                									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
	    	                					   obj.setDisabled(false);
	                							   return false;
	                						   }
	                					   }
	                					   this$.applyWindowMask();
	                					   Ext.Ajax.request({
  	    	            						type: 'rest',
  	    	            						url: setUrl,
  	    	            						jsonData: arrayData,
  	    	            						method: 'POST',
  	    	            						timeout:120000,
       	                					    success : function(response, action) {
       		                					   if(approveRejectStatus.valueModels[0].data.name=="APPROVED"){
       		                						showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getExaminationTranslation('REVALUATION_REQUEST_HAS_BEEN_APPROVED_SUCCESSFULLY'));
       		                					   } else {
       		                						showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getExaminationTranslation('REVALUATION_REQUEST_HAS_BEEN_REJECTED_SUCCESSFULLY'));
       		                					   }
       	                						   grid.getSelectionModel().deselectAll();
       	                						   grid.getStore().load();
       	                						   this$.hideWindowMask();
       	                						   formWin.close();
       	                						   
       	                						var offlinePaymentItemId=grid.down('#offlinePaymentItemId');
       	                						var btnApprove=grid.down('#btnApprove');
       	                						var btnApplyItemId=grid.down('#btnApplyItemId');
       	                						var btnApplyNow=grid.down('#btnApplyNowItemId');
       		                				   
       		                				   btnApplyNow.setDisabled(true);
       		    	                		   btnApprove.setDisabled(true);
       		    	                		   btnApplyItemId.setDisabled(true);
       		    	                		   offlinePaymentItemId.setDisabled(true);
       	                					   }
       	                				   });
	                					   
	                					   //obj.setDisabled(false);
	                				   }else {
	                					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                					  // obj.setDisabled(false);
	                				   }
	                			   }
	                		   },
	                		   
	                		   'revaluationapprovalwin button[itemId=cancelBtn]': {
	                               click: function(obj) {
	                                   obj.up('window').close();
	                               }
	                           },
	                		   
	                	   });
	                   },

	                   disableMoreActionGridPivileges: function(structure,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var offlinePaymentItemId = structure.down('#offlinePaymentItemId');
	                	   var btnApplyItemId = structure.down('#btnApplyItemId');
	                	   var btnApprove = structure.down('#btnApprove');
	                	   var btnRefreshItemId = structure.down('#btnRefreshItemId');
	                	   var btnApplyNowItemId = structure.down('#btnApplyNowItemId');

	                	   offlinePaymentItemId.setVisible(false);
	                	   btnApplyItemId.setVisible(false);
	                	   btnApprove.setVisible(false);
	                	   btnRefreshItemId.setVisible(true);
	                	   btnApplyNowItemId.setVisible(false);
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'APPLY_AND_PAY_ONLINE') {
	                			   if(!isNullOrEmpty(btnApplyItemId)){
	                				   btnApplyItemId.setVisible(true);
	                			   }        		
	                		   } else if (privilege === 'OFFLINE_PAYMENT') {
	                			   if(!isNullOrEmpty(offlinePaymentItemId)){
	                				   offlinePaymentItemId.setVisible(true);
	                			   }        		
	                		   } else if (privilege === 'APPROVE_OR_REJECT') {
	                			   if(!isNullOrEmpty(btnApprove)){
	                				   btnApprove.setVisible(true);
	                			   }        		
	                		   } else if (privilege === 'APPLY_NOW') {
	                			   if(!isNullOrEmpty(btnApprove)){
	                				   btnApplyNowItemId.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                	   structure.down('#applyForRevaluationGridMoreAction').show();
	                   },
	                   
	                   saveRevalTransaction: function(obj) {
	                	   var this$ = this;
	                	   var grid=this$.getRevaluationcoreerpstudentgrid();
	                	   var tempStore=this.getStore('examinationcenters.studentportal.revaluation.TempStudentListRevalGridStore');
	                	   var record =tempStore.data.items;//grid.getSelectionModel().getSelection();
	                	   var isTransient = false;
	                	   var module = 'offlinePaymentDocumentCoreErp';
	                	   var entityId ;
	                	   var entityType = 'offlinePaymentDocumentCoreErp';
	                	   var formWin =  this.getDocumentFormWindow();
	                	   var uploadFiled=formWin.down('#uploadFileField');
	                	   var fileUploadPath=uploadFiled.getValue();
	                	   var submitUrl;
	                	   var totalAmmount=0;
        				   var innerJsonArr=[], json;
    					   var totalAmmount=0;
    					   var arrayData=[];

	                	   for(var i in record) {
    						   if(isNullOrEmpty(record[i].data.revaluationTypeEnum)) {
    							   showWarningMessage(getCommonTranslation('ALERT'),
    									   getCommonTranslation('REVALUATION_TYPE_SELECTION_MSG'));
    							   return false;
    						   }
    					   }
	                	   
	                	   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
	                	   if (extension == "gif"  || extension == "png" || extension == "bmp"
	                		   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
	                		   || extension == "doc"  || extension == "docx" || extension == "txt"
	                		   || extension == "csv"  || extension == "zip") {

	                		   this$.applyWindowMask(); 
	                		   this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	                		   this$.hideWindowMask();
	                			   if(success){
	                				   var record=tempStore.data.items.length!=0?tempStore.data.items[0]:grid.getSelectionModel().getSelection()[0];
	                				   //var record = tempStore.data.items[0];//grid.getSelectionModel().getSelection()[0];
	                				   var id = record.get("studentRevalId");
	                				   var documentId = Ext.decode(response.responseText);
	                				   if(isNullOrEmpty(id)){
	                						   if(!isNullOrEmpty(record.data.revaluationTypeEnum)) {
	                							   totalAmmount=totalAmmount+parseInt(record.data.feeAmount);
	                							   innerJsonArr.push({
	                								   "admissionId": record.data.admissionId,
	                								   "studentId": record.data.studentId,
	                								   "feePlanRuleStageId": record.data.feePlanRuleStageId,
	                								   "feeAmount": record.data.feeAmount,
	                								   "examRevalRuleMappingId": record.data.examRevalRuleMappingId,
	                								   "examinationResultId": record.data.examinationResultId,
	                										   "courseVariantId": record.data.courseVariantId,
	                										   "periodId": record.data.periodId,
	                										   "eventId": record.data.eventId,
	                										   "revalType": record.data.revaluationTypeEnum.toUpperCase(),
	                										   "appliedDate": record.data.appliedDate,
	                										   //  "courseCode": record[i].data.courseCode,
	                										   // "courseName": record[i].data.courseCode + " / " +record[i].data.courseName,
	                										   //  "eventName": record[i].data.event,
	                										   "previousMarks": record.data.obtainedMarks,
	                										   "previousGrade": record.data.finalGrade,
	                										   "previousGradePoint": record.data.gradePoints,
	                										   "previousResultStatus": record.data.resultStatus,
	                										  //"approvalStatusEnum": "NOT_APPROVED",
	                										   "documentId":documentId
	                							   });
	                							   json={
	                									   'firstName':record.data.firstName,
	                									   'lastName':record.data.lastName,
	                									   'phoneNo':record.data.mobileCountryCode+" "
	                									   +record.data.mobileNumber,
	                									   'email':record.data.emailId,
	                									   'studentCode':record.data.studentCode,
	                									   "totalAmount":totalAmmount,
	                									   "detailModel":innerJsonArr
	                							   };
	                							   arrayData.push(json);

	                							   Ext.Ajax.request({
	                								   type: 'rest',
	                								   url: SERVERURL.PATH_SAVE_EXAM_STUDENT_REVALUATION,
	                								   jsonData: innerJsonArr,
	                								   method: 'POST',
	                								   success : function(response, action) {
	                									   showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                									   grid.getSelectionModel().deselectAll();
	                									   tempStore.removeAll();
		                								   grid.getStore().load();
	                								   }
	                							   });

	                						   } 
	                			   }else{
	                						   var updateUrl = SERVERURL.PATH_UPDATE_STUDENT_REVAL_DOCUMENT+'?id='+id+'&documentId='+documentId;
	                						   Ext.Ajax.request({
	                							   type : 'rest',
	                							   url : updateUrl,
	                							   method : 'POST',
	                							   success : function(response, action) {
	                								   this$.hideWindowMask();
	                								   showSuccessMessage(getExaminationTranslation('TRANSACTION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                								   grid.getSelectionModel().deselectAll();
	                								   tempStore.removeAll();
	                								   grid.getStore().load() 
	                							   }
	                						   });
	                					   }
	                			   this$.getDocumentController().closeDocumentFormWindow();
	                			   }
	                		   }, isTransient);
	                	   }else{
	                		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
	                		   return;
	                	   }
	                   },
        			   
        			   getDocumentController : function(){
                    	   var this$ = this;
                    	   return this$.getController('Academia.controller.document.DocumentController');
                       },
                       
   	           	    
   	           	 	loadGridWithFileNameMessage:function(grid,value,store){
	           	    	grid.bindStore(store);
	           	    },
	           	    
	           	    resetMoreFilter: function(obj) {
	           	    	var $this=this;
	           	    	var form=$this.getRevaluationcoreerpstudentfilter();

	           	    	var revaluationApprovalStatus=form.down('#revaluationApprovalStatus');
	           	    	var revaluationStatus=form.down('#revaluationStatus');
	           	    	var revaluationTypeEnum=form.down('#revaluationTypeEnum');
	           	    	revaluationApprovalStatus.reset();
	           	    	revaluationStatus.reset();
	           	    	revaluationTypeEnum.reset();
	           	    	
	           	    	var fromDate=form.down('#fromdate');
	           	    	var tillDate=form.down('#tilldate');
	           	    	
	           	    	fromDate.setMinValue(null);
	           	    	tillDate.setMinValue(null);
	           	    	fromDate.setMaxValue(null);
	           	    	tillDate.setMaxValue(null);
	           	    },
	           	    
});
