/**
 * @author Raghavendra.Soni
 * 
 */
Ext
		.define(
				'Academia.controller.examinationdegreeremark.ExaminationDegreeRemarkController',
				{
					extend : 'Academia.controller.base.BaseController',
					models : [
							'examinationdegreeremark.DegreeClassificationGridModel',
							'examinationdegreeremark.DegreeClassificationRemarksGridModel',
							'examinationdegreeremark.DegreeAuditReportModel' ],
					stores : [
							'examinationdegreeremark.DegreeClassificationGridStore',
							'examinationdegreeremark.DegreeClassificationRemarksGridStore',
							'examinationdegreeremark.DegreeRemarkProgramAssociatedGridStore',
							'examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData',
							'examinationdegreeremark.DegreeAuditReportCoursesStatusChartStore',
							'examinationdegreeremark.DegreeAuditReportCreditStatusChartStore',
							'examinationdegreeremark.DegreeAuditReportCGPAStatusChartStore',
							'examinationdegreeremark.DegreeAuditReportGridStore' ],
					views : [
							'baselayout.contentarea.ContentPanel',
							'examinationdegreeremark.ExaminationDegreeRemarkStructure',
							'examinationdegreeremark.DegreeClassificationGrid',
							'examinationdegreeremark.DegreeClassificationRemarksGrid',
							'examinationdegreeremark.ProgramsAssociatedGridWindow',
							'examinationdegreeremark.DegreeClassificationWindow',
							'examinationdegreeremark.DegreeRemarkWindow',
							'examinationdegreeremark.ExaminationDegreeRemarkApplyToStructure',
							'examinationdegreeremark.ExaminationDegreeRemarkAddMappingStructure',
							'examinationdegreeremark.DegreeRemarkApplyToWindow',
							'examinationdegreeremark.DegreeRemarkProgressTracker',
							'examinationdegreeremark.AddMappingTabStructure',
							'examinationdegreeremark.AddMappingAcademyLocationTab',
							'examinationdegreeremark.AddMappingProgramTab',
							'examinationdegreeremark.AddMappingProgramBatchTab',
							'examinationdegreeremark.DegreeAuditReportView',
							'examinationdegreeremark.DegreeAuditReportGrid',
							'reports.common.DegreeAuditReportGroupedBarChart',
							'examinationdegreeremark.DegreeClassificationForm',
							'examinationdegreeremark.DegreeRemarkForm' ],
					config : {
						EXAMINATION_DEGREE_REMARK_PRIVILEGES : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('EXAMINATION_DEGREE_REMARK_PRIVILEGES'),
						EXAMINATION_DEGREE_REMARK_PRIVILEGES_CR : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('EXAMINATION_DEGREE_REMARK_PRIVILEGES_CR'),
						EXAMINATION_DEGREE_REMARK_PRIVILEGES_APPLY_TO : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('EXAMINATION_DEGREE_REMARK_PRIVILEGES_APPLY_TO'),
						PARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('PARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
						STUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
								.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES'),
					},
					refs : [
							{
								ref : 'contentPanel',
								selector : 'contentPanel'
							},
							{
								ref : 'examinationdegreeremarkstructure',
								selector : 'examinationdegreeremarkstructure'
							},
							{
								ref : 'degreeclassificationgrid',
								selector : 'degreeclassificationgrid'
							},
							{
								ref : 'degreeclassificationremarksgrid',
								selector : 'degreeclassificationremarksgrid'
							},
							{
								ref : 'programsassociatedgridwindow',
								selector : 'programsassociatedgridwindow'
							},
							{
								ref : 'degreeclassificationwindow',
								selector : 'degreeclassificationwindow'
							},
							{
								ref : 'degreeremarkwindow',
								selector : 'degreeremarkwindow'
							},
							{
								ref : 'examinationdegreeremarkapplytostructure',
								selector : 'examinationdegreeremarkapplytostructure'
							},
							{
								ref : 'degreeremarkapplytowindow',
								selector : 'degreeremarkapplytowindow'
							},
							{
								ref : 'degreeremarkprogresstracker',
								selector : 'degreeremarkprogresstracker'
							},
							{
								ref : 'addmappingtabstructure',
								selector : 'addmappingtabstructure'
							},
							{
								ref : 'addmappingacademylocationtab',
								selector : 'addmappingacademylocationtab'
							},
							{
								ref : 'addmappingprogramtab',
								selector : 'addmappingprogramtab'
							},
							{
								ref : 'addmappingprogrambatchtab',
								selector : 'addmappingprogrambatchtab'
							},
							{
								ref : 'examinationdegreeremarkaddmappingstructure',
								selector : 'examinationdegreeremarkaddmappingstructure'
							},
							{
								ref : 'degreeauditreportview',
								selector : 'degreeauditreportview'
							},
							{
								ref : 'degreeclassificationform',
								selector : 'degreeclassificationform'
							},
							{
								ref : 'degreeremarkform',
								selector : 'degreeremarkform'
							},
							{
								ref : 'degreeauditreportgrid',
								selector : 'degreeauditreportgrid[itemId=studentDegreeAuditReportGrid]'
							} ],
					init : function() {
						this
								.control({
									'degreeclassificationwindow' : {
										afterrender : function(window) {
											$this = this;
											var filterForm = window
													.down('form');
											window.body
													.on(
															'click',
															function() {
																$this
																		.hideInvalidIconFromField(filterForm);
															});
										}
									},
									'degreeremarkwindow' : {
										afterrender : function(window) {
											$this = this;
											var filterForm = window
													.down('form');
											window.body
													.on(
															'click',
															function() {
																$this
																		.hideInvalidIconFromField(filterForm);
															});
										}
									},
									'examinationdegreeremarkstructure' : {
										afterrender : function(structure) {
											var me = this;
											var associatedAcadLocationIds = new Array();
											associatedAcadLocationIds
													.push(me
															.getCurrentAcademyLocation());
											var permissionList = Academia.utilities.accessControl.AccessControlManager
													.checkFeaturePrivelages(
															associatedAcadLocationIds,
															me
																	.getEXAMINATION_DEGREE_REMARK_PRIVILEGES());
											var permissionListTwo = Academia.utilities.accessControl.AccessControlManager
													.checkFeaturePrivelages(
															associatedAcadLocationIds,
															me
																	.getEXAMINATION_DEGREE_REMARK_PRIVILEGES_CR());

											var btnAdd_dc = structure
													.down('#btnAdd_dc');
											var btnEdit_dc = structure
													.down('#btnEdit_dc');
											var btnDelete_dc = structure
													.down('#btnDelete_dc');
											var btnApplyTo_dc = structure
													.down('#btnApplyTo_dc');
											var btnApplyTo_dc = structure
													.down('#btnApplyTo_dc');
											var btnAdd_cr = structure
													.down('#btnAdd_cr');
											var btnEdit_cr = structure
													.down('#btnEdit_cr');
											var btnDelete_cr = structure
													.down('#btnDelete_cr');
											var exportToPdfBtn_dc = structure
													.down(
															'degreeclassificationgrid')
													.down('#btnExportToPDF');
											var exportToXcelBtn_dc = structure
													.down(
															'degreeclassificationgrid')
													.down('#btnExportToExcel');
											var exportToPdfBtn_cr = structure
													.down(
															'degreeclassificationremarksgrid')
													.down('#btnExportToPDF');
											var exportToXcelBtn_cr = structure
													.down(
															'degreeclassificationremarksgrid')
													.down('#btnExportToExcel');

											btnAdd_dc.setVisible(false);
											btnEdit_dc.setVisible(false);
											btnDelete_dc.setVisible(false);
											btnApplyTo_dc.setVisible(false);
											btnAdd_cr.setVisible(false);
											btnEdit_cr.setVisible(false);
											btnDelete_cr.setVisible(false);
											exportToPdfBtn_dc.setVisible(false);
											exportToXcelBtn_dc
													.setVisible(false);
											exportToPdfBtn_cr.setVisible(false);
											exportToXcelBtn_cr
													.setVisible(false);

											if ((Ext.Array.contains(
													permissionList, 'CREATE'))) {
												btnAdd_dc.setVisible(true);
											}

											if ((Ext.Array.contains(
													permissionList, 'UPDATE'))) {
												btnEdit_dc.setVisible(true);
											}

											if ((Ext.Array.contains(
													permissionList, 'DELETE'))) {
												btnDelete_dc.setVisible(true);
											}
											if ((Ext.Array.contains(
													permissionList, 'APPLY'))) {
												btnApplyTo_dc.setVisible(true);
											}
											if ((Ext.Array
													.contains(
															permissionListTwo,
															'CREATE'))) {
												btnAdd_cr.setVisible(true);
											}

											if ((Ext.Array
													.contains(
															permissionListTwo,
															'UPDATE'))) {
												btnEdit_cr.setVisible(true);
											}
											if ((Ext.Array
													.contains(
															permissionListTwo,
															'DELETE'))) {
												btnDelete_cr.setVisible(true);
											}

											if ((Ext.Array.contains(
													permissionList, 'EXPORT'))) {
												exportToPdfBtn_dc
														.setVisible(true);
												exportToXcelBtn_dc
														.setVisible(true);
											}
											if ((Ext.Array
													.contains(
															permissionListTwo,
															'EXPORT'))) {
												exportToPdfBtn_cr
														.setVisible(true);
												exportToXcelBtn_cr
														.setVisible(true);
											}
										}
									},
									'degreeclassificationgrid' : {
										afterrender : function(obj) {
											var me = this;
											obj.getStore().loadPage(1);
										},
										cellclick : function(View, CellEl,
												ColIdx, record, RowEl, RowIdx,
												e, eopts) {
											var me = this;
											var degreeclassificationgrid = View
													.up('grid');
											if (e.target.tagName == 'A') {
												var classificationId = record.data.id;
												var programsassociatedgridwindow = me
														.showWindow('programsassociatedgridwindow');
												programsassociatedgridwindowStore = programsassociatedgridwindow
														.down('grid')
														.getStore();
												programsassociatedgridwindowStore
														.removeAll();
												programsassociatedgridwindowStore
														.getProxy().extraParams = {
													classificationId : classificationId
												};
												programsassociatedgridwindowStore
														.load();
												Ext.defer(function() {
													programsassociatedgridwindow.center();
												}, 500);
											}
										},
										selectionchange : function(row, record) {
											var me = this;
											try {
												var degreeclassificationgrid = row.view
														.up('grid');
												var btnEdit_dc = degreeclassificationgrid
														.down('#btnEdit_dc');
												var btnDelete_dc = degreeclassificationgrid
														.down('#btnDelete_dc');
												var btnApplyTo_dc = degreeclassificationgrid
														.down('#btnApplyTo_dc');

												btnEdit_dc
														.setDisabled(!degreeclassificationgrid
																.getSelectionModel()
																.getSelection().length);
												btnDelete_dc
														.setDisabled(!degreeclassificationgrid
																.getSelectionModel()
																.getSelection().length);
												btnApplyTo_dc
														.setDisabled(!degreeclassificationgrid
																.getSelectionModel()
																.getSelection().length);

												var degreeclassificationremarksgrid = degreeclassificationgrid
														.up(
																'examinationdegreeremarkstructure')
														.down(
																'degreeclassificationremarksgrid');
												var degreeclassificationremarksgridStore = degreeclassificationremarksgrid
														.getStore();
												var btnAdd_cr = degreeclassificationremarksgrid
														.down('#btnAdd_cr');
												var btnEdit_cr = degreeclassificationremarksgrid
														.down('#btnEdit_cr');
												var btnDelete_cr = degreeclassificationremarksgrid
														.down('#btnDelete_cr');
												degreeclassificationremarksgrid
														.getSelectionModel()
														.deselectAll();
												if (degreeclassificationgrid
														.getSelectionModel()
														.getSelection().length) {
													var classificationId = record[0].data.id;
													var markingType = record[0].data.programMarkingType;
													var degreeType = record[0].data.degreeType;

													btnAdd_cr
															.setDisabled(false);
													var rangeFromColumn = me
															.getColumnByDataIndex(
																	degreeclassificationremarksgrid,
																	'CGPAOrPercentageRangeFrom');
													var rangeToColumn = me
															.getColumnByDataIndex(
																	degreeclassificationremarksgrid,
																	'CGPAOrPercentageRangeTo');

													if (getCommonTranslation(markingType) == "Grade") {
														if(degreeType == 'CGPA') {
														rangeFromColumn
																.setText(getCommonTranslation('GRADE_RANGE_FROM_DEGREE'));
														rangeToColumn
																.setText(getCommonTranslation('GRADE_RANGE_TO_DEGREE'));
														}
														else {
															rangeFromColumn.setText(getCommonTranslation('GRADE_CPA_RANGE_FROM_DEGREE'));
															rangeToColumn.setText(getCommonTranslation('GRADE_CPA_RANGE_TO_DEGREE'));
														}
													} else {
														rangeFromColumn
																.setText(getCommonTranslation('MARK_RANGE_FROM'));
														rangeToColumn
																.setText(getCommonTranslation('MARK_RANGE_TO'));
													}

													degreeclassificationremarksgridStore
															.getProxy().extraParams = {
														classificationId : classificationId,
														type: degreeType,
														programMarkingType: markingType
													}
													 
												    this.resetPageSetting(degreeclassificationremarksgridStore,degreeclassificationremarksgrid);
													degreeclassificationremarksgridStore.load();   
												} else {
													degreeclassificationremarksgridStore
															.removeAll();
													btnAdd_cr.setDisabled(true);
													btnEdit_cr
															.setDisabled(true);
													btnDelete_cr
															.setDisabled(true);

													var rangeFromColumn = me
															.getColumnByDataIndex(
																	degreeclassificationremarksgrid,
																	'CGPAOrPercentageRangeFrom');
													var rangeToColumn = me
															.getColumnByDataIndex(
																	degreeclassificationremarksgrid,
																	'CGPAOrPercentageRangeTo');

													rangeFromColumn
															.setText(getCommonTranslation('RANGE_FROM'));
													rangeToColumn
															.setText(getCommonTranslation('RANGE_TO'));
												}
											} catch (e) {
											}
										}
									},
									'degreeauditreportgrid[itemId=studentDegreeAuditReportGrid]' : {
										beforedestroy : function(tree, eOpts) {
											tree.getStore().getRootNode()
													.removeAll();
										}
									},
									'degreeremarkform' : {
										beforerender : function(obj) {
											var me = this;
											me
													.saveDFRInfo(me
															.getCurrentAcademyLocation());
										},
									},
									'degreeclassificationform' : {
										beforerender : function(obj) {
											var me = this;
											me
													.saveDFRInfo(me
															.getCurrentAcademyLocation());
										},
									},
									'degreeclassificationgrid button[itemId=btnAdd_dc]' : {
										click : function(button) {
											var me = this;
											var degreeclassificationwindow = me
													.showWindow('degreeclassificationwindow');
										}
									},
									'degreeclassificationwindow button[itemId=degreeClassificationSubmitBtn]' : {
										click : function(button) {
											var me = this;
											var form = button.up('form');
											var formWindow = button
													.up('window');
											me.saveDegreeClassification(form,formWindow,button);
										}
									},
									'degreeclassificationwindow button[itemId=degreeClassificationCancelBtn]' : {
										click : function(button) {
											var formWindow = button
													.up('window');
											formWindow.close();
										}
									},
									'degreeclassificationgrid button[itemId=btnEdit_dc]' : {
										click : function(button) {
											var me = this;

											var degreeclassificationgrid = button
													.up('grid');
											var remarkGrid = me
													.getDegreeclassificationremarksgrid();
											var selectedRecord = degreeclassificationgrid
													.getSelectionModel()
													.getSelection()[0];

											var formRecord = {
												id : selectedRecord.data.id,
												classificationName : selectedRecord.data.classificationName,
												markingType : selectedRecord.data.programMarkingType,
												degreeClassificationType : selectedRecord.data.degreeClassificationType,
												gradeType: selectedRecord.data.degreeType
											};

											var degreeclassificationwindow = me
													.showWindow('degreeclassificationwindow');
											var form = degreeclassificationwindow
													.down('form');
											var markingTypeFld = form.down('[name=markingType]');

											markingTypeFld
													.getStore()
													.load(
															{
																callback : function() {
																	form
																			.getForm()
																			.setValues(
																					formRecord);
																	markingTypeFld
																			.setReadOnly(
																					true);
																	if (selectedRecord.data.programsAssociated > 0
																			|| remarkGrid
																					.getStore().data.items.length > 0) {
																		form
																				.down(
																						'#degreeClassificationTypeRadio')
																				.setDisabled(
																						true);
																		;
																	}
																	markingTypeFld.fireEvent('select', markingTypeFld, markingTypeFld.lastSelection);
																	form.down('#gradeType').setReadOnly(true);
																}
															});
										}
									},
									'degreeclassificationgrid button[itemId=btnDelete_dc]' : {
										click : function(button) {
											var me = this;

											var degreeclassificationgrid = button
													.up('grid');
											var gridRecord = degreeclassificationgrid
													.getSelectionModel()
													.getSelection()[0];
											var jsonData = [];
											if (degreeclassificationgrid
													.getSelectionModel()
													.getCount() > 0) {
												var submitUrl = SERVERURL.DEGREE_CLASSIFICATION_DELETE;
												showConfirmMessage(
														getCommonTranslation('DEGREE_CLASSIFICATION'),
														getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),
														function(btn, text) {
															if (btn == 'yes') {
																Ext
																		.getBody()
																		.mask(
																				getCommonTranslation("SUBMITTING_FORM"),
																				'x-mask-loading');
																Ext.Ajax
																		.request({
																			type : 'rest',
																			url : submitUrl
																					+ '?id='
																					+ gridRecord.data.id,
																			method : 'DELETE',
																			success : function(
																					response,
																					action) {
																				Ext
																						.getBody()
																						.unmask();
																				degreeclassificationgrid
																						.getStore()
																						.loadPage(
																								1);
																				degreeclassificationgrid
																						.getSelectionModel()
																						.deselectAll();
																				showSuccessMessage(
																						getCommonTranslation('DEGREE_CLASSIFICATION'),
																						getCommonTranslation('RECORD_DELETE_SUCCESS'));
																			}
																		});
															}
														});
											} else {
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('PLEASE_SELECT_RECORD'));
											}
										}
									},
									'degreeclassificationgrid button[itemId=btnApplyTo_dc]' : {
										click : function(button) {
											var me = this;
											var degreeclassificationgrid = button
													.up('grid');
											var gridRecord = degreeclassificationgrid
													.getSelectionModel()
													.getSelection()[0];
											if (degreeclassificationgrid
													.getSelectionModel()
													.getCount() > 0) {
												var classificationId = gridRecord.data.id;
												var classificationName = gridRecord.data.classificationName;
												var contentpanel = me
														.getContentPanel();
												var applyToTab = Ext
														.widget(
																'examinationdegreeremarkapplytostructure',
																{
																	classificationId : classificationId,
																	classificationName : classificationName
																});
												var tabName = getCommonTranslation('APPLY_TO');
												var getcontroller = this
														.getController('menu.CoreERPNavigationController');
												var getTab = getcontroller
														.getTab(tabName);
												if (getTab != null) {
													contentpanel.remove(getTab,
															true);
												}
												openTab(
														contentpanel,
														tabName,
														applyToTab,
														CONSTANTS.MENU_COLOR_FOUR);
											} else {
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('PLEASE_SELECT_RECORD'));
											}
										}
									},
									'degreeclassificationremarksgrid' : {
										afterrender : function(obj) {
											var me = this;
											obj.getStore().removeAll();
										},
										selectionchange : function(row, record) {
											var me = this;
											try {
												var degreeclassificationremarksgrid = row.view
														.up('grid');

												var btnEdit_cr = degreeclassificationremarksgrid
														.down('#btnEdit_cr');
												var btnDelete_cr = degreeclassificationremarksgrid
														.down('#btnDelete_cr');

												btnEdit_cr
														.setDisabled(!degreeclassificationremarksgrid
																.getSelectionModel()
																.getSelection().length);
												btnDelete_cr
														.setDisabled(!degreeclassificationremarksgrid
																.getSelectionModel()
																.getSelection().length);
											} catch (e) {
											}
										}
									},
									'degreeclassificationremarksgrid button[itemId=btnAdd_cr]' : {
										click : function(button) {
											var me = this;
											var degreeclassificationgrid = button
													.up(
															'examinationdegreeremarkstructure')
													.down(
															'degreeclassificationgrid');
											var degreeclassificationgridRecord = degreeclassificationgrid
													.getSelectionModel()
													.getSelection()[0];

											var degreeremarkwindow = me
													.showWindow('degreeremarkwindow');
											degreeremarkwindow
													.down(
															'[name=degreeClassificationId]')
													.setValue(
															degreeclassificationgridRecord.data.id);
											degreeremarkwindow
													.down(
															'[name=classificationName]')
													.setValue(
															degreeclassificationgridRecord.data.classificationName);
											degreeremarkwindow
													.down('[name=markingType]')
													.getStore()
													.load(
															{
																callback : function() {
																	degreeremarkwindow
																			.down(
																					'[name=markingType]')
																			.setValue(
																					degreeclassificationgridRecord.data.programMarkingType);
																	if (getCommonTranslation(degreeclassificationgridRecord.data.programMarkingType) == "Grade") {
																		if(degreeclassificationgridRecord.data.degreeType == 'CGPA') {
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setFieldLabel(
																						getCommonTranslation('GRADE_RANGE_FROM_DEGREE'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setFieldLabel(
																						getCommonTranslation('GRADE_RANGE_TO_DEGREE'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMinValue(
																						0);
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMaxValue(
																						9.99);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMinValue(
																						0.01);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMaxValue(
																						10);
																		}
																		else {
																			degreeremarkwindow.down('[name=rangeFrom]').setFieldLabel(getCommonTranslation('GRADE_CPA_RANGE_FROM_DEGREE'));
																			degreeremarkwindow.down('[name=rangeTo]').setFieldLabel(getCommonTranslation('GRADE_CPA_RANGE_TO_DEGREE'));
																			degreeremarkwindow.down('[name=rangeFrom]').setMinValue(0);
																			degreeremarkwindow.down('[name=rangeFrom]').setMaxValue(99.99);
																			degreeremarkwindow.down('[name=rangeTo]').setMinValue(0.01);
																			degreeremarkwindow.down('[name=rangeTo]').setMaxValue(100);
																		}
																	} else {
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setFieldLabel(
																						getCommonTranslation('MARK_RANGE_FROM'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setFieldLabel(
																						getCommonTranslation('MARK_RANGE_TO'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMinValue(
																						0);
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMaxValue(
																						99.99);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMinValue(
																						0.01);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMaxValue(
																						100);
																	}
																	me
																			.setAllowBlank(
																					degreeremarkwindow
																							.down('[name=rangeFrom]'),
																					false);
																	me
																			.setAllowBlank(
																					degreeremarkwindow
																							.down('[name=rangeTo]'),
																					false);
																}
															})

											if (degreeclassificationgridRecord.data.degreeClassificationType == "DEGREE_AUDIT_REPORT") {
												degreeremarkwindow
														.down(
																'[name=recommendation]')
														.setVisible(true);
												degreeremarkwindow.down(
														'[name=graphColor]')
														.setVisible(true);
												degreeremarkwindow
														.setHeight(430);
											} else {
												degreeremarkwindow
														.down(
																'[name=recommendation]')
														.setVisible(false);
												degreeremarkwindow.down(
														'[name=graphColor]')
														.setVisible(false);
												degreeremarkwindow
														.setHeight(320);
											}
										}
									},
									'degreeremarkwindow button[itemId=degreeRemarkSubmitBtn]' : {
										click : function(button) {
											var me = this;
											var form = button.up('form');
											var formWindow = button
													.up('window');

											if (!button.isClicked) {
												me.saveDegreeRemark(form,
														formWindow, button);
														
											}
											 
										}
									},
									'degreeremarkwindow button[itemId=degreeRemarkCancelBtn]' : {
										click : function(button) {
											var formWindow = button
													.up('window');
											formWindow.close();
										}
									},

									'degreeremarkwindow numberfield[name=rangeFrom]': {
										change: function(obj) {
											var rangeFromField = obj;
											var rangeToField = obj.up('form').down('[name=rangeTo]');
											var remarkField = obj.up('form').down('[name=remark]');

											var rangeFrom =rangeFromField.getValue();
											var rangeTo = rangeToField.getValue();
											var remark = remarkField.getValue();
											
											
										   if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
													if(parseFloat((rangeTo-0.01).toFixed(2))>=0){
													rangeFromField.setMaxValue(parseFloat((rangeTo-0.01).toFixed(2)));
												}
											}
											if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
												if(parseFloat((rangeFrom+0.01).toFixed(2))<10){
												rangeToField.setMinValue(parseFloat((rangeFrom+0.01).toFixed(2)));
												}
											}
											
											if(rangeFrom!="" && rangeFrom!=null){
												if(!rangeFromField.isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											}
											else{
												if(obj.up('form').isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
												}
											}
											
											if(rangeTo!="" && rangeTo!=null){
												if(!rangeToField.isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											}
											else{
												if(obj.up('form').isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
												}
											}
											
											try{
												if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null ){
													obj.up('form').isValid();
												}
												obj.up('form').getForm().clearInvalid();
											}
											catch(e){}
											
											/*
											rangeToField.setMinValue(rangeFrom + 0.01);

											if (rangeFrom != "" && rangeFrom != null) {
												if (!rangeFromField.isValid()) {
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											} else {
												obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
											}

											if (rangeTo != "" && rangeTo != null) {
												if (!rangeToField.isValid()) {
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											} else {
												obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
											}

											try {
												if (rangeFrom != "" && rangeFrom != null && rangeTo != "" && rangeTo != null && !isNullOrEmpty(remark)) {
													obj.up('form').isValid();
												}
											} catch (e) {
											}*/
										}
									},
									'degreeremarkwindow numberfield[name=rangeTo]': {
										change: function(obj) {
											var rangeFromField = obj.up('form').down('[name=rangeFrom]');
											var rangeToField = obj;
											var remarkField = obj.up('form').down('[name=remark]');

											var rangeFrom = rangeFromField.getValue();
											var rangeTo = rangeToField.getValue();
											var remark = remarkField.getValue();
											
											if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
												if(parseFloat((rangeFrom+0.01).toFixed(2))<=10){
												rangeToField.setMinValue(parseFloat((rangeFrom+0.01).toFixed(2)));
												}
											}
											if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
												if(parseFloat((rangeTo-0.01).toFixed(2))>=0){
													rangeFromField.setMaxValue(parseFloat((rangeTo-0.01).toFixed(2)));
												}
											}
											if(rangeFrom!=""){
												if(!rangeFromField.isValid() || !rangeToField.isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
												
											}
											else{
												if(obj.up('form').isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
												}
											}
											
											if(rangeTo!=""){
												if(!rangeToField.isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
												if(remark == null || remark == ""){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											}
											else{
												if(obj.up('form').isValid()){
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
												}
											}
											
											try{
												if(rangeFrom!="" && rangeFrom!=null && rangeTo!="" && rangeTo!=null){
													obj.up('form').isValid();
												}
												obj.up('form').getForm().clearInvalid();
											}
											catch(e){}

											/*if (parseFloat((rangeTo - 0.01).toFixed(2)) >= 0) {
												rangeFromField.setMaxValue(parseFloat((rangeTo - 0.01).toFixed(2)));
											}

											if (rangeFrom != "") {
												if (!rangeFromField.isValid() || !rangeToField.isValid()) {
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											} else {
												obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
											}

											if (rangeTo != "") {
												if (!rangeToField.isValid()) {
													obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(true);
												}
											} else {
												obj.up('form').down('#degreeRemarkSubmitBtn').setDisabled(false);
											}

											try {
												if (rangeFrom != "" && rangeFrom != null && rangeTo != "" && rangeTo != null && !isNullOrEmpty(remark)) {
													obj.up('form').isValid();
												}
											} catch (e) {
											}*/
										}
									},
									
									'degreeclassificationremarksgrid button[itemId=btnEdit_cr]' : {
										click : function(button) {
											var me = this;
											var degreeclassificationgrid = button
													.up(
															'examinationdegreeremarkstructure')
													.down(
															'degreeclassificationgrid');
											var degreeclassificationgridRecord = degreeclassificationgrid
													.getSelectionModel()
													.getSelection()[0];

											var degreeclassificationremarksgrid = button
													.up('degreeclassificationremarksgrid');
											var selectedRecord = degreeclassificationremarksgrid
													.getSelectionModel()
													.getSelection()[0];

											var formRecord = {
												id : selectedRecord.data.id,
												degreeClassificationId : degreeclassificationgridRecord.data.id,
												classificationName : degreeclassificationgridRecord.data.classificationName,
												markingType : degreeclassificationgridRecord.data.programMarkingType,
												rangeFrom : selectedRecord.data.CGPAOrPercentageRangeFrom,
												rangeTo : selectedRecord.data.CGPAOrPercentageRangeTo,
												remark : selectedRecord.data.remarks,
												recommendation : selectedRecord.data.recommendation,
												graphColor : selectedRecord.data.graphColor
											};

											var degreeremarkwindow = me
													.showWindow('degreeremarkwindow');
											var form = degreeremarkwindow
													.down('form');

											form
													.down('[name=markingType]')
													.getStore()
													.load(
															{
																callback : function() {
																	form
																			.getForm()
																			.setValues(
																					formRecord);
																	if (getCommonTranslation(degreeclassificationgridRecord.data.programMarkingType) == "Grade") {
																		if(degreeclassificationgridRecord.data.degreeType == 'CGPA') {
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setFieldLabel(
																						getCommonTranslation('GRADE_RANGE_FROM_DEGREE'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setFieldLabel(
																						getCommonTranslation('GRADE_RANGE_TO_DEGREE'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMinValue(
																						0);
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMaxValue(
																						9.99);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMinValue(
																						0.01);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMaxValue(
																						10);
																		}
																		else {
																			degreeremarkwindow.down('[name=rangeFrom]').setFieldLabel(getCommonTranslation('GRADE_CPA_RANGE_FROM_DEGREE'));
																			degreeremarkwindow.down('[name=rangeTo]').setFieldLabel(getCommonTranslation('GRADE_CPA_RANGE_TO_DEGREE'));
																			degreeremarkwindow.down('[name=rangeFrom]').setMinValue(0);
																			degreeremarkwindow.down('[name=rangeFrom]').setMaxValue(99.99);
																			degreeremarkwindow.down('[name=rangeTo]').setMinValue(0.01);
																			degreeremarkwindow.down('[name=rangeTo]').setMaxValue(100);
																		}
																	} else {
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setFieldLabel(
																						getCommonTranslation('MARK_RANGE_FROM'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setFieldLabel(
																						getCommonTranslation('MARK_RANGE_TO'));
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMinValue(
																						0);
																		degreeremarkwindow
																				.down(
																						'[name=rangeFrom]')
																				.setMaxValue(
																						99.99);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMinValue(
																						0.01);
																		degreeremarkwindow
																				.down(
																						'[name=rangeTo]')
																				.setMaxValue(
																						100);
																	}
																	me
																			.setAllowBlank(
																					degreeremarkwindow
																							.down('[name=rangeFrom]'),
																					false);
																	me
																			.setAllowBlank(
																					degreeremarkwindow
																							.down('[name=rangeTo]'),
																					false);
																}
															});

											if (degreeclassificationgridRecord.data.degreeClassificationType == "DEGREE_AUDIT_REPORT") {
												degreeremarkwindow
														.down(
																'[name=recommendation]')
														.setVisible(true);
												degreeremarkwindow.down(
														'[name=graphColor]')
														.setVisible(true);
												degreeremarkwindow
														.setHeight(430);
											} else {
												degreeremarkwindow
														.down(
																'[name=recommendation]')
														.setVisible(false);
												degreeremarkwindow.down(
														'[name=graphColor]')
														.setVisible(false);
												degreeremarkwindow
														.setHeight(320);
											}
										}
									},
									'degreeclassificationremarksgrid button[itemId=btnDelete_cr]' : {
										click : function(button) {
											var me = this;

											var degreeclassificationremarksgrid = button
													.up('grid');
											var gridRecord = degreeclassificationremarksgrid
													.getSelectionModel()
													.getSelection()[0];
											var jsonData = [];
											if (degreeclassificationremarksgrid
													.getSelectionModel()
													.getCount() > 0) {
												var submitUrl = SERVERURL.DEGREE_CLASSIFICATION_REMARK_DELETE;
												showConfirmMessage(
														getCommonTranslation('DEGREE_REMARK'),
														getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),
														function(btn, text) {
															if (btn == 'yes') {
																Ext
																		.getBody()
																		.mask(
																				getCommonTranslation("SUBMITTING_FORM"),
																				'x-mask-loading');
																Ext.Ajax
																		.request({
																			type : 'rest',
																			url : submitUrl
																					+ '?id='
																					+ gridRecord.data.id,
																			method : 'DELETE',
																			success : function(
																					response,
																					action) {
																				Ext
																						.getBody()
																						.unmask();
																				degreeclassificationremarksgrid
																						.getStore()
																						.loadPage(
																								1);
																				degreeclassificationremarksgrid
																						.getSelectionModel()
																						.deselectAll();
																				showSuccessMessage(
																						getCommonTranslation('DEGREE_REMARK'),
																						getCommonTranslation('RECORD_DELETE_SUCCESS'));
																			}
																		});
															}
														});
											} else {
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('PLEASE_SELECT_RECORD'));
											}
										}
									},
									'examinationdegreeremarkapplytostructure' : {
										afterrender : function(structure) {
											var me = this;
											var applyToGrid = structure
													.down('grid');
											var classificationId = structure.classificationId;
											var applyToGridStore = applyToGrid
													.getStore();
											applyToGridStore.getProxy().extraParams = {
												classificationId : classificationId
											};
											this
													.resetPageSetting(applyToGridStore, applyToGrid);
											applyToGridStore.load();

											var associatedAcadLocationIds = new Array();
											associatedAcadLocationIds
													.push(me
															.getCurrentAcademyLocation());
											var permissionListThree = Academia.utilities.accessControl.AccessControlManager
													.checkFeaturePrivelages(
															associatedAcadLocationIds,
															me
																	.getEXAMINATION_DEGREE_REMARK_PRIVILEGES_APPLY_TO());

											var btnAdd_Apply_To = structure
													.down('#btnAdd');
											var btnView_Apply_To = structure
													.down('#btnView');
											var btnDelete_Apply_To = structure
													.down('#btnDelete');

											btnAdd_Apply_To.setVisible(false);
											btnView_Apply_To.setVisible(false);
											btnDelete_Apply_To
													.setVisible(false);

											if ((Ext.Array.contains(
													permissionListThree,
													'CREATE'))) {
												btnAdd_Apply_To
														.setVisible(true);
											}

											if ((Ext.Array
													.contains(
															permissionListThree,
															'VIEW'))) {
												btnView_Apply_To
														.setVisible(true);
											}

											if ((Ext.Array.contains(
													permissionListThree,
													'DELETE'))) {
												btnDelete_Apply_To
														.setVisible(true);
											}
										}

									},
									'examinationdegreeremarkapplytostructure grid' : {
										selectionchange : function(row, record) {
											var me = this;
											try {
												var applyToGrid = row.view
														.up('grid');

												var btnView = applyToGrid
														.down('#btnView');
												var btnDelete = applyToGrid
														.down('#btnDelete');

												btnView
														.setDisabled(!applyToGrid
																.getSelectionModel()
																.getSelection().length);
												btnDelete
														.setDisabled(!applyToGrid
																.getSelectionModel()
																.getSelection().length);
											} catch (e) {
											}
										}
									},
									'examinationdegreeremarkapplytostructure button[itemId=btnAdd]' : {
										click : function(button) {
											var me = this;
											var applyToStructure = button
													.up('examinationdegreeremarkapplytostructure');
											var classificationId = applyToStructure.classificationId;
											var classificationName = applyToStructure.classificationName;
											var contentpanel = me
													.getContentPanel();
											var addMappingTab = Ext
													.widget(
															'examinationdegreeremarkaddmappingstructure',
															{
																classificationId : classificationId,
																classificationName : classificationName
															});
											var tabName = getCommonTranslation('ADD_MAPPING');
											var getcontroller = this
													.getController('menu.CoreERPNavigationController');
											var getTab = getcontroller
													.getTab(tabName);
											if (getTab != null) {
												contentpanel.remove(getTab,
														true);
											}
											openTab(contentpanel, tabName,
													addMappingTab,
													CONSTANTS.MENU_COLOR_FOUR);
										}
									},
									'examinationdegreeremarkapplytostructure button[itemId=btnView]' : {
										click : function(button) {
											var me = this;
											var applyToStructure = button
													.up('examinationdegreeremarkapplytostructure');
											var applyToGrid = button.up('grid');
											var applyToRecord = applyToGrid
													.getSelectionModel()
													.getSelection()[0];

											var formRecord = {
												classificationName : applyToStructure.classificationName,
												academyLocationName : applyToRecord
														.get('academyLocationName'),
												programName : applyToRecord
														.get('programName'),
												batchName : applyToRecord
														.get('batchName')
											};
											var degreeremarkapplytowindow = me
													.showWindow('degreeremarkapplytowindow');
											setTimeout(
													function() {
														var form = degreeremarkapplytowindow
																.down('form');
														form
																.getForm()
																.setValues(
																		formRecord);
													}, 300);
										}
									},
									'degreeremarkapplytowindow button[itemId=applyToWindowCancelBtn]' : {
										click : function(button) {
											var window = button
													.up('degreeremarkapplytowindow');
											window.close();
										}
									},
									'examinationdegreeremarkapplytostructure button[itemId=btnDelete]' : {
										click : function(button) {
											var me = this;

											var applyToGrid = button.up('grid');
											var gridRecord = applyToGrid
													.getSelectionModel()
													.getSelection()[0];
											if (applyToGrid.getSelectionModel()
													.getCount() > 0) {
												var submitUrl = SERVERURL.ASSOCIATED_PROGRAM_DELETE;
												showConfirmMessage(
														getExaminationTranslation('APPLY_TO'),
														getCommonTranslation('DEGREE_CLASSIFICATION_DELETE_ALERT'),
														function(btn, text) {
															if (btn == 'yes') {
																Ext
																		.getBody()
																		.mask(
																				getCommonTranslation("SUBMITTING_FORM"),
																				'x-mask-loading');
																Ext.Ajax
																		.request({
																			type : 'rest',
																			url : submitUrl
																					+ '?id='
																					+ gridRecord.data.id,
																			method : 'DELETE',
																			success : function(
																					response,
																					action) {
																				Ext
																						.getBody()
																						.unmask();
																				applyToGrid
																						.getStore()
																						.loadPage(
																								1);
																				applyToGrid
																						.getSelectionModel()
																						.deselectAll();
																				showSuccessMessage(
																						getExaminationTranslation('APPLY_TO'),
																						getCommonTranslation('RECORD_DELETE_SUCCESS'));
																			}
																		});
															}
														});
											} else {
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('PLEASE_SELECT_RECORD'));
											}
										}
									},
									'examinationdegreeremarkaddmappingstructure' : {
										afterrender : function(structure) {
											var me = this;

											var degreeremarkprogresstracker = structure
													.down('degreeremarkprogresstracker');
											degreeremarkprogresstracker
													.setVisible(true);
											var progresstracker1 = degreeremarkprogresstracker
													.down("#progresstracker1");
											var progresstracker2 = degreeremarkprogresstracker
													.down("#progresstracker2");
											var progresstracker3 = degreeremarkprogresstracker
													.down("#progresstracker3");

											progresstracker1.textEl
													.removeCls("x-progress-text x-progress-text-back");
											progresstracker1.textEl
													.addCls("inProgressCss-progress-text");
											progresstracker1
													.updateText("Step 1 In Progress");

											progresstracker2.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker2.textEl
													.addCls("x-progress-text x-progress-text-back");
											progresstracker2.updateText("");

											progresstracker3.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker3.textEl
													.addCls("x-progress-text x-progress-text-back");
											progresstracker3.updateText("");

											var academyLocationTab = structure
													.down('addmappingacademylocationtab');
											var programTab = structure
													.down('addmappingprogramtab');
											var programBatchTab = structure
													.down('addmappingprogrambatchtab');

											academyLocationTab
													.down(
															'#degreeClassificationNameLabel')
													.setText(
															getCommonTranslation('DEGREE_CLASSIFICATION')
																	+ ': '
																	+ structure.classificationName);

											academyLocationTab
													.setDisabled(false);
											programTab.setDisabled(true);
											programBatchTab.setDisabled(true);

											academyLocationTab.down('grid')
													.getStore().load();
											academyLocationTab.down(
													'#academyLocationCombo')
													.getStore().load();
										}
									},
									'addmappingacademylocationtab grid' : {
										selectionchange : function(row, record) {
											var me = this;
											try {
												var addmappingacademylocationtabgrid = row.view
														.up('grid');

												var btnNext = addmappingacademylocationtabgrid
														.down('#academyLocationNextBtn');

												btnNext
														.setDisabled(!addmappingacademylocationtabgrid
																.getSelectionModel()
																.getSelection().length);
											} catch (e) {
											}
										}
									},	
									'addmappingacademylocationtab combo[itemId=academyLocationCombo]' : {
										select: function(combo) {
											var me = this;
											var alId = combo.getValue();

											var grid = combo.up('grid');
											var store = grid.getStore();
											store.clearFilter();
											store
												.filterBy(function(record,
													id) {
													return (record
														.get('id') == alId);
												});
											var gridDom = grid.el ? grid.el.dom
												: null;
											gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')
												+ ": " + store.getCount();
											grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS') + ": " + store.getCount());
										}
									},
									'addmappingacademylocationtab button[itemId=academyLocationResetBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											grid.getStore().clearFilter();

											grid.down('#academyLocationCombo')
													.reset();
											grid.down('#academyLocationCombo')
													.clearValue();
											grid.down('#academyLocationCombo')
													.getStore().clearFilter();

											grid.getSelectionModel()
													.deselectAll();
										}
									},
									'addmappingacademylocationtab button[itemId=academyLocationNextBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											var addmappingtabstructure = button
													.up('addmappingtabstructure');

											var selectedRecords = grid
													.getSelectionModel()
													.getSelection();
											var selectedAls = [];
											Ext.each(selectedRecords, function(
													selectedRecord) {
												selectedAls.push(selectedRecord
														.get('id'));
											});

											var structure = button
													.up('examinationdegreeremarkaddmappingstructure');

											var degreeremarkprogresstracker = structure
													.down('degreeremarkprogresstracker');
											degreeremarkprogresstracker
													.setVisible(true);
											var progresstracker1 = degreeremarkprogresstracker
													.down("#progresstracker1");
											var progresstracker2 = degreeremarkprogresstracker
													.down("#progresstracker2");
											var progresstracker3 = degreeremarkprogresstracker
													.down("#progresstracker3");

											for (var i = 0; i < 11; i++) {
												progresstracker1
														.updateProgress(
																(i * 0.1), '');
											}
											progresstracker1.textEl
													.addCls("custom-progress-text");
											progresstracker1.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker2.textEl
													.removeCls("x-progress-text x-progress-text-back");
											progresstracker2.textEl
													.addCls("inProgressCss-progress-text");
											progresstracker2
													.updateText("Step 2 In Progress");
											progresstracker1
													.updateText(getCommonTranslation('STEP_1_COMPLETE'));

											progresstracker3.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker3.textEl
													.addCls("x-progress-text x-progress-text-back");
											progresstracker3.updateText("");

											var academyLocationTab = structure
													.down('addmappingacademylocationtab');
											var programTab = structure
													.down('addmappingprogramtab');
											var programBatchTab = structure
													.down('addmappingprogrambatchtab');

											programTab
													.down(
															'#degreeClassificationNameLabel')
													.setText(
															getCommonTranslation('DEGREE_CLASSIFICATION')
																	+ ': '
																	+ structure.classificationName);

											academyLocationTab
													.setDisabled(false);
											programTab.setDisabled(false);
											programBatchTab.setDisabled(true);

											addmappingtabstructure
													.setActiveTab(1);

											programTab.down('grid').getStore()
													.getProxy().extraParams = {
												'academyLocationIds' : selectedAls
														.join()
											};
											programTab.down('grid').getStore()
													.load();
											programTab.down('#programCombo')
													.getStore().getProxy().extraParams = {
												'academyLocationIds' : selectedAls
														.join()
											};
											programTab.down('#programCombo')
													.getStore().load();
										}
									},
									'addmappingprogramtab grid' : {
										selectionchange : function(row, record) {
											var me = this;
											try {
												var addmappingprogramtabgrid = row.view
														.up('grid');

												var btnNext = addmappingprogramtabgrid
														.down('#programNextBtn');
												var btnSubmit = addmappingprogramtabgrid
														.down('#programSubmitBtn');

												btnNext
														.setDisabled(!addmappingprogramtabgrid
																.getSelectionModel()
																.getSelection().length);
												btnSubmit
														.setDisabled(!addmappingprogramtabgrid
																.getSelectionModel()
																.getSelection().length);
											} catch (e) {
											}
										}
									},
									'addmappingprogramtab combo[itemId=programCombo]' : {
										select : function(combo) {
											var me = this;
											var programId = combo.getValue();

											var grid = combo.up('grid');
											var store = grid.getStore();
											store.clearFilter();
											store
													.filterBy(function(record,
															id) {
														return (record
																.get('id') == programId);
													});
											var gridDom = grid.el ? grid.el.dom
													: null;
											gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')
													+ ": " + store.getCount();
													grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount());

										}
									},
									'addmappingprogramtab button[itemId=programResetBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											grid.getStore().clearFilter();

											grid.down('#programCombo').reset();
											grid.down('#programCombo')
													.clearValue();
											grid.down('#programCombo')
													.getStore().clearFilter();

											grid.getSelectionModel()
													.deselectAll();
										}
									},
									'addmappingprogramtab button[itemId=programNextBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											var addmappingtabstructure = button
													.up('addmappingtabstructure');

											var selectedRecords = grid
													.getSelectionModel()
													.getSelection();
											var selectedAls = [];
											Ext.each(selectedRecords, function(
													selectedRecord) {
												selectedAls.push(selectedRecord
														.get('id'));
											});

											var structure = button
													.up('examinationdegreeremarkaddmappingstructure');

											var degreeremarkprogresstracker = structure
													.down('degreeremarkprogresstracker');
											degreeremarkprogresstracker
													.setVisible(true);
											var progresstracker1 = degreeremarkprogresstracker
													.down("#progresstracker1");
											var progresstracker2 = degreeremarkprogresstracker
													.down("#progresstracker2");
											var progresstracker3 = degreeremarkprogresstracker
													.down("#progresstracker3");

											for (var i = 0; i < 11; i++) {
												progresstracker1
														.updateProgress(
																(i * 0.1), '');
											}
											progresstracker1.textEl
													.addCls("custom-progress-text");
											progresstracker1.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker1
													.updateText(getCommonTranslation('STEP_1_COMPLETE'));
											for (var i = 0; i < 11; i++) {
												progresstracker2
														.updateProgress(
																(i * 0.1), '');
											}
											progresstracker2.textEl
													.addCls("custom-progress-text");
											progresstracker2.textEl
													.removeCls("inProgressCss-progress-text");
											progresstracker2
													.updateText(getCommonTranslation('STEP_2_COMPLETE'));

											progresstracker3.textEl
													.removeCls("x-progress-text x-progress-text-back");
											progresstracker3.textEl
													.addCls("inProgressCss-progress-text");
											progresstracker3
													.updateText("Step 3 In Progress");

											var academyLocationTab = structure
													.down('addmappingacademylocationtab');
											var programTab = structure
													.down('addmappingprogramtab');
											var programBatchTab = structure
													.down('addmappingprogrambatchtab');

											programBatchTab
													.down(
															'#degreeClassificationNameLabel')
													.setText(
															getCommonTranslation('DEGREE_CLASSIFICATION')
																	+ ': '
																	+ structure.classificationName);

											academyLocationTab
													.setDisabled(false);
											programTab.setDisabled(false);
											programBatchTab.setDisabled(false);

											addmappingtabstructure
													.setActiveTab(2);

											programBatchTab.down('grid')
													.getStore().getProxy().extraParams = {
												'programIds' : selectedAls
														.join()
											};
											programBatchTab.down('grid')
													.getStore().load();
											programBatchTab.down('#batchCombo')
													.getStore().getProxy().extraParams = {
												'programIds' : selectedAls
														.join()
											};
											programBatchTab.down('#batchCombo')
													.getStore().load();
										}
									},
									'addmappingprogrambatchtab grid' : {
										selectionchange : function(row, record) {
											var me = this;
											try {
												var addmappingprogrambatchtabgrid = row.view
														.up('grid');

												var btnSubmit = addmappingprogrambatchtabgrid
														.down('#batchSubmitBtn');

												btnSubmit
														.setDisabled(!addmappingprogrambatchtabgrid
																.getSelectionModel()
																.getSelection().length);
											} catch (e) {
											}
										}
									},
									'addmappingprogrambatchtab combo[itemId=batchCombo]' : {
										select : function(combo) {
											var me = this;
											var batchId = combo.getValue();

											var grid = combo.up('grid');
											var store = grid.getStore();
											store.clearFilter();
											store
													.filterBy(function(record,
															id) {
														return (record
																.get('batchId') == batchId);
													});
											var gridDom = grid.el ? grid.el.dom
													: null;
											gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')
													+ ": " + store.getCount();

										}
									},
									'addmappingprogrambatchtab button[itemId=batchResetBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											grid.getStore().clearFilter();

											grid.down('#batchCombo').reset();
											grid.down('#batchCombo')
													.clearValue();
											grid.down('#batchCombo').getStore()
													.clearFilter();

											grid.getSelectionModel()
													.deselectAll();
										}
									},
									'addmappingprogramtab button[itemId=programSubmitBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');

											var mainGridRecord = me
													.getDegreeclassificationgrid()
													.getSelectionModel()
													.getSelection()[0];
											var gridRecord = grid
													.getSelectionModel()
													.getSelection();
											var classificationId = button
													.up('examinationdegreeremarkaddmappingstructure').classificationId;

											var formData = [];
											Ext
													.each(
															gridRecord,
															function(
																	currentRecord) {
																formData
																		.push({
																			degreeClassificationId : classificationId,
																			academyLocationId : currentRecord
																					.get('secondId'),
																			programId : currentRecord
																					.get('id'),
																			classificationName : mainGridRecord.data.degreeClassificationType
																		});
															});

											me.saveAllMappings(formData);
										}
									},
									'addmappingprogrambatchtab button[itemId=batchSubmitBtn]' : {
										click : function(button) {
											var me = this;
											var grid = button.up('grid');
											var mainGridRecord = me
													.getDegreeclassificationgrid()
													.getSelectionModel()
													.getSelection()[0];
											var gridRecord = grid
													.getSelectionModel()
													.getSelection();
											var classificationId = button
													.up('examinationdegreeremarkaddmappingstructure').classificationId;

											var formData = [];
											Ext
													.each(
															gridRecord,
															function(
																	currentRecord) {
																formData
																		.push({
																			degreeClassificationId : classificationId,
																			academyLocationId : currentRecord
																					.get('academyLocationId'),
																			programId : currentRecord
																					.get('programId'),
																			batchId : currentRecord
																					.get('batchId'),
																			classificationName : mainGridRecord.data.degreeClassificationType
																		});
															});
											me.saveAllMappings(formData);
										}
									},
									'degreeauditreportview' : {
										render : function(view) {
											this
													.auditReportFormChartGridLoad(view);
										}
									},
									'degreeauditreportview form[itemId=degreeAuditReportSearchForm] button[itemId=degreeAuditReportFindButtonId]' : {
										click : function(obj) {
											this.auditReportChartAndGridLoad();
										}
									},
									'degreeauditreportview form[itemId=degreeAuditReportSearchForm] customcombobox[itemId=programId]' : {
										select : function(obj) {
											var $this = this;
											var studentPortalInfo = $this
													.getCurrentlyLoggedInUserInfoForPortal();
											var academyLocationId = this
													.getCurrentAcademyLocation();
											var view = $this
													.getDegreeauditreportview();
											var form = view
													.down(
															'#degreeAuditReportSearchForm')
													.getForm();
											var programField = form
													.findField('programId');
											var batchField = form
													.findField('batchId');
											var findButton = view
													.down(
															'#degreeAuditReportSearchForm')
													.down(
															'#degreeAuditReportFindButtonId');
											batchField.reset();
													batchField.store.getProxy().extraParams = {
														studentId : studentPortalInfo.student.id,
														programId : programField
																.getValue(),
														onlyCurrentRecord : false
													},
													batchField.store
															.load({
																callback : function(
																		records,
																		operation,
																		success) {
																	if (success) {
																		if (records.length == 1) {
																			batchField
																					.setValue(records[0].data.id);
																			findButton
																					.setDisabled(false);
																		}
																	}
																}
															});
											form.isValid();
										}
									},
									'degreeauditreportview form[itemId=degreeAuditReportSearchForm] button[itemId=degreeAuditReportClearSearch]' : {
										click : function(obj) {
											var view = this
													.getDegreeauditreportview();
											this
													.auditReportFormChartGridLoad(view);
										}
									},
									'degreeauditreportgrid[itemId=studentDegreeAuditReportGrid] button[itemId=exportDegreeAuditReportGrid]' : {
										click : function() {
											var $this = this;
											var studentPortalInfo = $this
													.getCurrentlyLoggedInUserInfoForPortal();
											var reportParams = new Object();
											var view = $this
													.getDegreeauditreportview();
											var form = view
													.down(
															'#degreeAuditReportSearchForm')
													.getForm();
											var programField = form
													.findField('programId');
											var batchField = form
													.findField('batchId');
											reportParams.PROGRAM_ID = programField
													.getValue();
											reportParams.BATCH_ID = batchField
													.getValue();
											reportParams.STUDENT_ID = studentPortalInfo.student.id;
											reportParams.reportTitle = "Degree Audit Report";

											var code = "AU_DEGREE_AUDIT_REPORT";
											var URL = SERVERURL.PATH_FIND_DEGREE_AUDIT_EXPORT_REPORT;
											$this.exportJRXMLReport(code,
													reportParams,
													reportParams.reportTitle,
													'.pdf', URL);
										}
									},
									'degreeclassificationform customcombobox[itemId=markingType]': {
										select: this.onMarkingTypeSelect
									}
								});
					},
					saveDegreeClassification : function(form, formWindow, button) {
						var me = this;
						var formValues = form.getForm().getValues();

						var id = formValues.id;
						var programMarkingType = formValues.markingType;
						var classificationName = formValues.classificationName;
						var degreeClassificationType = form.query('[name=degreeClassificationType][checked=true]')[0].inputValue;

						var submitUrl, isUpdate = false;
						if (isNullOrEmpty(id)) {
							submitUrl = SERVERURL.DEGREE_CLASSIFICATION_CREATE,
									isUpdate = false;
							var formData = {
								programMarkingType : programMarkingType,
								classificationName : classificationName,
								degreeClassificationType : degreeClassificationType,
								degreeType: formValues.gradeType
							};
						} else {
							submitUrl = SERVERURL.DEGREE_CLASSIFICATION_UPDATE,
									isUpdate = true;
							var formData = {
								id : id,
								programMarkingType : programMarkingType,
								classificationName : classificationName,
								degreeClassificationType : degreeClassificationType,
								degreeType: formValues.gradeType
							};
						}
var btn = formWindow.down('#degreeClassificationSubmitBtn');
						btn.setDisabled(true);
						Ext.getBody().mask(
								getCommonTranslation('SUBMITTING_FORM'),
								'x-mask-loading');
						//button.setDisabled(false); 
						Ext.Ajax
								.request({
									type : 'rest',
									url : submitUrl,
									jsonData : formData,
									method : 'POST',
									success : function(response, form) {
										Ext.getBody().unmask();
										if (response.responseText == "Success") {
											if (isUpdate) {
												showSuccessMessage(
														getCommonTranslation('DEGREE_CLASSIFICATION'),
														getCommonTranslation('RECORD_UPDATE_SUCCESS'));
											} else {
												showSuccessMessage(
														getCommonTranslation('DEGREE_CLASSIFICATION'),
														getCommonTranslation('SUCCESS'));
											}
											formWindow.close();
											me.getDegreeclassificationgrid()
													.getSelectionModel()
													.deselectAll();
											me.getDegreeclassificationgrid()
													.getStore().loadPage(1);
										} else {
											showWarningMessage(
													getCommonTranslation('ALERT'),
													response.responseText);
											Ext.defer(function() {
												button.setDisabled(false);
											}, 1000);
										}
									}
								});
					},
					saveDegreeRemark : function(form, formWindow, btn) {
						btn.isClicked = true;
						btn.setDisabled(true);
						var me = this;
						form.down('#degreeRemarkSubmitBtn').setDisabled(true);
						var formValues = form.getForm().getValues();

						var id = formValues.id;
						var degreeClassificationId = formValues.degreeClassificationId;
						var CGPAOrPercentageRangeFrom = formValues.rangeFrom;
						var CGPAOrPercentageRangeTo = formValues.rangeTo;
						var remarks = formValues.remark;
						var recommendation = formValues.recommendation;
						var graphColor = formValues.graphColor;

						var submitUrl, isUpdate = false;
						if (isNullOrEmpty(id)) {
									submitUrl = SERVERURL.DEGREE_CLASSIFICATION_REMARK_CREATE,
									isUpdate = false;
							var formData = {
								degreeClassificationId : degreeClassificationId,
								CGPAOrPercentageRangeFrom : CGPAOrPercentageRangeFrom,
								CGPAOrPercentageRangeTo : CGPAOrPercentageRangeTo,
								remarks : remarks,
								recommendation : recommendation,
								graphColor : graphColor
							};
						} else {
									submitUrl = SERVERURL.DEGREE_CLASSIFICATION_REMARK_UPDATE,
									isUpdate = true;
							var formData = {
								id : id,
								degreeClassificationId : degreeClassificationId,
								CGPAOrPercentageRangeFrom : CGPAOrPercentageRangeFrom,
								CGPAOrPercentageRangeTo : CGPAOrPercentageRangeTo,
								remarks : remarks,
								recommendation : recommendation,
								graphColor : graphColor
							};
						}

						Ext.getBody().mask(
								getCommonTranslation('SUBMITTING_FORM'),
								'x-mask-loading');
						Ext.Ajax
								.request({
									type : 'rest',
									url : submitUrl,
									jsonData : formData,
									method : 'POST',
									success : function(response, form) {
										btn.isClicked = false;
										//btn.setDisabled(false);
										Ext.getBody().unmask();
										if (response.responseText == "success") {
											if (isUpdate) {
												showSuccessMessage(
														getCommonTranslation('DEGREE_REMARK'),
														getCommonTranslation('RECORD_UPDATE_SUCCESS'));
											} else {
												showSuccessMessage(
														getCommonTranslation('DEGREE_REMARK'),
														getCommonTranslation('SUCCESS'));
											}
											formWindow.close();
											me
													.getDegreeclassificationremarksgrid()
													.getSelectionModel()
													.deselectAll();
											me
													.getDegreeclassificationremarksgrid()
													.getStore().loadPage(1);
										} else {
											showWarningMessage(
													getCommonTranslation('ALERT'),
													response.responseText);
											Ext.defer(function() {
												formWindow.down('#degreeRemarkSubmitBtn').setDisabled(false);
											}, 100);
										}
									},
									failure : function(response) {
										formWindow.down(
												'#degreeRemarkSubmitBtn')
												.setDisabled(false);
										console.log(response);

									}
								});
					},
					getColumnByDataIndex : function(grid, dataIndex) {
						var foundColumn;
						Ext.each(grid.columns, function(currentColumn) {
							if (currentColumn.dataIndex == dataIndex) {
								foundColumn = currentColumn;
								return;
							}
						});
						return foundColumn;
					},
					saveAllMappings : function(formData) {
						var me = this;
						Ext.getBody().mask(
								getCommonTranslation('SUBMITTING_FORM'),
								'x-mask-loading');
						Ext.Ajax
								.request({
									type : 'rest',
									url : SERVERURL.ASSOCIATED_PROGRAM_SAVE_ALL_URL,
									jsonData : formData,
									method : 'POST',
									success : function(response, form) {
										Ext.getBody().unmask();
										var responseJson = Ext
												.decode(response.responseText);
										if (responseJson.length == 0) {
											showSuccessMessage(
													getCommonTranslation('ADD_MAPPING'),
													getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));
											try {
												me.getContentPanel()
														.getActiveTab().close();
												me
														.getExaminationdegreeremarkapplytostructure()
														.down('grid')
														.getStore().loadPage(1);
											} catch (e) {
											}
										} else if (responseJson.length > 0) {

											var notMappedArray = [];
											Ext
													.each(
															responseJson,
															function(
																	currentRecord) {
																if (currentRecord.classificationId != me
																		.getContentPanel()
																		.getActiveTab()
																		.down(
																				'examinationdegreeremarkaddmappingstructure').classificationId) {
																	notMappedArray
																			.push(currentRecord);
																}
															});

											if (notMappedArray.length == 0) {
												showWarningMessage(
														getCommonTranslation('ADD_MAPPING'),
														getCommonTranslation('DEGREE_REMARK_ALREADY_MAPPED_MSG'));
												try {
													me.getContentPanel()
															.getActiveTab()
															.close();
													me
															.getExaminationdegreeremarkapplytostructure()
															.down('grid')
															.getStore()
															.loadPage(1);
												} catch (e) {
												}
											} else {
												var responseJson = notMappedArray;
												var messageText = "Other Degree Classification is already mapped with the following programs and batches<br />";
												messageText = messageText
														+ "<p style=\"height: auto;max-height:100px;display:block;float:left;width:100%;overflow-y:auto;\">";
												Ext
														.each(
																responseJson,
																function(
																		currentBatchDetail) {
																	messageText = messageText
																			+ currentBatchDetail.programName
																			+ " and "
																			+ currentBatchDetail.batchName
																			+ "<br />";
																});
												messageText = messageText
														+ "</p><br />Do you still want to map the degree classification with the selected programs and batches?";

												var newFormData = [];
												Ext
														.each(
																responseJson,
																function(
																		currentRecord) {
																	newFormData
																			.push({
																				degreeClassificationId : me
																						.getContentPanel()
																						.getActiveTab()
																						.down(
																								'examinationdegreeremarkaddmappingstructure').classificationId,
																				academyLocationId : currentRecord.academyLocationId,
																				programId : currentRecord.programId,
																				batchId : currentRecord.batchId,
																				id : currentRecord.degreeClassificationBatchMappingId
																			});
																});

												showConfirmMessage(
														getCommonTranslation('APPLY_TO'),
														messageText,
														function(btn, text) {
															if (btn == 'yes') {
																Ext
																		.getBody()
																		.mask(
																				getCommonTranslation('SUBMITTING_FORM'),
																				'x-mask-loading');
																Ext.Ajax
																		.request({
																			type : 'rest',
																			url : SERVERURL.ASSOCIATED_PROGRAM_SAVE_UPDATE_URL,
																			jsonData : newFormData,
																			method : 'POST',
																			success : function(
																					form,
																					action) {
																				Ext
																						.getBody()
																						.unmask();
																				showSuccessMessage(
																						getCommonTranslation('ADD_MAPPING'),
																						getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));
																				try {
																					me
																							.getContentPanel()
																							.getActiveTab()
																							.close();
																					me
																							.getExaminationdegreeremarkapplytostructure()
																							.down(
																									'grid')
																							.getStore()
																							.loadPage(
																									1);
																				} catch (e) {
																				}
																			}
																		});
															} else {
																Ext
																		.getBody()
																		.unmask();
																// showSuccessMessage(getCommonTranslation('ADD_MAPPING'),
																// getCommonTranslation('DEGREE_CLASSIFICATION_MAPPED_SUCCESS_MSG'));
																try {
																	me
																			.getContentPanel()
																			.getActiveTab()
																			.close();
																	me
																			.getExaminationdegreeremarkapplytostructure()
																			.down(
																					'grid')
																			.getStore()
																			.loadPage(
																					1);
																} catch (e) {
																}
															}
														});
											}
										} else {
											showWarningMessage(
													getCommonTranslation('ALERT'),
													response.responseText);
										}
									},
									failure : function(response) {
										console.log(response);
									}
								});
					},
					addExportToPngForDegreeReportStatistics : function(panel,
							chart) {
						var $this = this;
						var exportToPNG = {
							text : 'Export To PNG',
							itemId : 'exportToPng',
							handler : function(btn, target, header, tool) {
								var customWidth = 30;
								var title = 'Statistics By '
										+ getCommonTranslation(chart.up().title);
								var surface = chart.surface;
								var svg = Ext.draw.engine.SvgExporter
										.generate(surface);
								var canvas = document.createElement('canvas');
								var context = canvas.getContext("2d");
								canvas.height = surface.height + 100;
								canvas.width = surface.width + 200;
								var x = canvas.width / 10;

								context.font = "18px Georgia";
								context.textAlign = 'bottom';
								context.fillText(title, x, 20);
								context.fillStyle = "#FFFFFF";
								context.fillRect(0, 30, surface.width + 100,
										surface.height + 100);
								context.drawSvg(svg, customWidth, 30);
								var dataURL = canvas
										.toDataURL('image/png', 1.0);
								downloadImage(dataURL, 'chart.png');
							}
						};
						if (!Ext.isDefined(panel.items.items[0])) {
							panel.add(exportToPNG);
						}
					},
					saveDFRInfo : function(academyLocationId) {
						Ext.Ajax
								.request({
									url : SERVERURL.COMMON_FORM_FIELD_INFO,
									method : 'GET',
									async : false,
									params : {
										academyLocationId : academyLocationId,
										languageCode : 'en'
									},
									success : function(response) {
										var json = JSON
												.parse(response.responseText);
										var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
										fieldInfo.set("formFieldsInfo", json);
									}
								});

					},
					auditReportChartAndGridLoad : function() {
						var $this = this;
						var view = $this.getDegreeauditreportview();
						view.setDisabled(true);
						var studentPortalInfo = $this
								.getCurrentlyLoggedInUserInfoForPortal();
						var academyLocationId = this
								.getCurrentAcademyLocation();
						var form = view.down('#degreeAuditReportSearchForm')
								.getForm();
						var programField = form.findField('programId');
						var batchField = form.findField('batchId');

						var studentId = studentPortalInfo.student.id;
						var programId = programField.getValue();
						var batchId = batchField.getValue();

						var degreeAuditReportGrid = view
								.down('#studentDegreeAuditReportGrid');
						var courseStatusBarChart = view
								.down('#degreeAuditReportCourseStatusForBarChart');
						var creditsStatusBarChart = view
								.down('#degreeAuditReportCreditsStatusForBarChart');
						var cgpaStatusBarChart = view
								.down('#degreeAuditReportCGPAStatusForBarChart');

						var courseStatusExportButton = view
								.down('#CourseStatusExtraBtns');
						var creditsStatusExportButton = view
								.down('#creditsStatusExtraBtns');
						var cgpaStatusExportButton = view
								.down('#cgpaStatusExtraBtns');

						courseStatusExportButton.setVisible(true);
						creditsStatusExportButton.setVisible(true);
						cgpaStatusExportButton.setVisible(true);

						$this.addExportToPngForDegreeReportStatistics(
								courseStatusExportButton.menu,
								courseStatusBarChart);
						$this.addExportToPngForDegreeReportStatistics(
								creditsStatusExportButton.menu,
								creditsStatusBarChart);
						$this
								.addExportToPngForDegreeReportStatistics(
										cgpaStatusExportButton.menu,
										cgpaStatusBarChart);

						degreeAuditReportGrid.store.getProxy().extraParams = {
							studentId : studentId,
							programId : programField.getValue(),
							batchId : batchField.getValue()
						}
						degreeAuditReportGrid.store
								.load({
									callback : function(records, operation,
											success) {
										view.setDisabled(false);
										if (success) {
											var exportBtn = view
													.down('#exportDegreeAuditReportGrid');
											if (records.length <= 0) {
												exportBtn.setDisabled(true);
											} else {
												exportBtn.setDisabled(false);
											}
										}
									}
								});
						courseStatusBarChart.store.getProxy().extraParams = {
							studentId : studentId,
							programId : programField.getValue(),
							batchId : batchField.getValue()
						}
						courseStatusBarChart.store.load();

						creditsStatusBarChart.store.getProxy().extraParams = {
							studentId : studentId,
							programId : programField.getValue(),
							batchId : batchField.getValue()
						}
						creditsStatusBarChart.store.load();

						cgpaStatusBarChart.store.getProxy().extraParams = {
							studentId : studentId,
							programId : programField.getValue(),
							batchId : batchField.getValue()
						}
						cgpaStatusBarChart.store.load();
					},
					auditReportFormChartGridLoad : function(view) {
						var $this = this;
						var studentPortalInfo = $this
								.getCurrentlyLoggedInUserInfoForPortal();
						var academyLocationId = this
								.getCurrentAcademyLocation();
						var form = view.down('#degreeAuditReportSearchForm')
								.getForm();
						var programField = form.findField('programId');
						var batchField = form.findField('batchId');
						var view = $this.getDegreeauditreportview();
						var degreeAuditReportGrid = view
								.down('#studentDegreeAuditReportGrid');
						var studentId = studentPortalInfo.student.id;
						var programId = studentPortalInfo.programBatchDetails.programId;
						var batchId = studentPortalInfo.programBatchDetails.batchId;
						var exportBtn = degreeAuditReportGrid
								.down('#exportDegreeAuditReportGrid');
						exportBtn.setVisible(false);

						if (this.getCurrentLoggedPortalId() == 3) {
							permissionsMap = this
									.getSTUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS();
						}
						if (this.getCurrentLoggedPortalId() == 7) {
							permissionsMap = this
									.getPARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PERMISSIONS();
						}

						var associatedAcadLocationIds = new Array();
						associatedAcadLocationIds.push(this
								.getCurrentAcademyLocation());

						var permissionList = Academia.utilities.accessControl.AccessControlManager
								.checkFeaturePrivelages(
										associatedAcadLocationIds,
										permissionsMap);
						Ext.each(permissionList, function(privilege) {
							if (privilege === 'EXPORT') {
								exportBtn.setVisible(true);
							}
						});

								programField.store.getProxy().extraParams = {
									studentId : studentId,
									academyLocationId : academyLocationId,
									onlyCurrentRecord : false
								},

								programField.store
										.load({
											callback : function(records,
													operation, success) {
												if (success) {
													for ( var i in records) {
														if (records[i].data.id == programId) {
															programField
																	.setValue(records[i].data.id);
																	batchField.store
																			.getProxy().extraParams = {
																		studentId : studentId,
																		programId : records[i].data.id,
																		onlyCurrentRecord : false
																	},
																	batchField.store
																			.load({
																				callback : function(
																						records,
																						operation,
																						success) {
																					if (success) {
																						for ( var i in records) {
																							if (records[i].data.id == batchId) {
																								batchField
																										.setValue(records[i].data.id);
																								$this
																										.auditReportChartAndGridLoad(view);
																							}
																						}
																					}
																				}
																			});
														}
													}
												}
											}
										});
					},
					
					onMarkingTypeSelect: function(cmp, record) {
						var gradeTypeFld = cmp.up('form').down('#gradeType');
						if(record[0].get('id') == 'GRADE') {
							gradeTypeFld.show();
							gradeTypeFld.enable();
						}
						else {
							gradeTypeFld.hide();
							gradeTypeFld.disable();
						}
					}
				});