/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.examinationtimetable.ExamTimetableController', {
	extend : 'Academia.controller.base.BaseController',
	models : [],
	stores : ['examinationtimetable.ExamTimetableGridStore','examinationcenters.manageEvaluation.evaluationgroup.studentPrgramExaminationTableStore'],
	views : ['examinationtimetable.ExamTimetable', 'examinationtimetable.ExamTimetableFilter', 'examinationtimetable.ExamTimetableGrid'],	
	refs : [{
		ref: 'examtimetable',
		selector: 'examtimetable'
	}, {
		ref: 'examtimetablefilter',
		selector: 'examtimetablefilter'
	}, {
		ref: 'examtimetablegrid',
		selector: 'examtimetablegrid'
	}],
	init : function() {
		this.control({
			'examtimetablefilter button[itemId=resetBtn]': {
				click: function(btn) {
					btn.up('form').getForm().reset();

					var $this = this;
					var me = this, val, emptyArry= [],params,
					studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					currentLocationId= this.getCurrentAcademyLocation();
					filterView = me.getExamtimetablefilter()
					if(Ext.isArray(currentLocationId)){
						currentLocationId.forEach(function(rec){
							if(rec){
								emptyArry.push(rec.data.id);
							}
						});
						currentLocationId = emptyArry.join();
					}
					var	studentprogramId = filterView.down('#studentprogramId');
					studentprogramIdStore = studentprogramId.getStore();
					studentprogramIdStore.proxy.extraParams = {
							academyLocationId	:currentLocationId,
							studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
					};
					studentprogramId.getStore().load({
						callback: function(record, operation, success) {
							if (success) {
								if(studentprogramId.getStore().getCount()) {
									studentprogramId.setValue(record[0].data.id);
									var studentbatch = filterView.down('#studentbatchId');
									studentbatch.getStore().proxy.extraParams = {
										programId:record[0].data.id,
										studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
										onlyCurrentRecord: false
									};
									studentbatch.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												if(studentbatch.getStore().getCount() == 1) {
													studentbatch.setValue(records[0].data.id);
													studentbatch.setReadOnly(true);
													var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId'),
													studentperiodIdStore = studentperiodId.getStore();
													studentperiodId.reset();
													studentperiodIdStore.proxy.extraParams = {
															id:records[0].data.id,
															studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
															onlyCurrentRecord: false
													};
													studentperiodIdStore.load({
														callback: function(recs, operation, success) {
															if (success) {
																 for(var i in recs){
																		if(recs[i].data.isCurrentPeriodOfProgram == true && studentperiodId.getStore().getCount()){
																			studentperiodId.setValue(recs[i].data.id);
																		 }
																	  }
//																if() {}
															}
														}
													});
												}
											}
										}
									});
								}
							}
						}
					});
					//studentprogramIdStore.load();
				
				}
			},

			'examtimetablefilter':{
				afterrender:function(cmp,record){
					var $this = this;
					var me = this, val, emptyArry= [],params,
					studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					currentLocationId= this.getCurrentAcademyLocation();
					filterView = me.getExamtimetablefilter()
					if(Ext.isArray(currentLocationId)){
						currentLocationId.forEach(function(rec){
							if(rec){
								emptyArry.push(rec.data.id);
							}
						});
						currentLocationId = emptyArry.join();
					}
					var	studentprogramId = filterView.down('#studentprogramId');
					studentprogramIdStore = studentprogramId.getStore();
					studentprogramIdStore.proxy.extraParams = {
							academyLocationId	:currentLocationId,
							studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
					};
					studentprogramId.getStore().load({
						callback: function(record, operation, success) {
							if (success) {
								if(studentprogramId.getStore().getCount()) {
									studentprogramId.setValue(record[0].data.id);
									var studentbatch = filterView.down('#studentbatchId');
									studentbatch.getStore().proxy.extraParams = {
										programId:record[0].data.id,
										studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
										onlyCurrentRecord: false
									};
									studentbatch.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												if(studentbatch.getStore().getCount() == 1) {
													studentbatch.setValue(records[0].data.id);
													studentbatch.setReadOnly(true);
													var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId'),
													studentperiodIdStore = studentperiodId.getStore();
													studentperiodId.reset();
													studentperiodIdStore.proxy.extraParams = {
															id:records[0].data.id,
															studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
															onlyCurrentRecord: false
													};
													
													var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId'),
													studentcourseCodeNameIdStore = studentcourseCodeNameId.getStore();
													
													
													studentperiodIdStore.load({
														callback: function(recs, operation, success) {
															if (success) {
																 for(var i in recs){
																		if( studentperiodId.getStore().getCount()){
//																			studentperiodId.setValue(recs[i].data.id);
																			var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId').getValue();
																			var	studentprogramId = $this.getExamtimetablefilter().down('#studentprogramId').getValue();
																			var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId'),
																			studentcourseCodeNameIdStore = studentcourseCodeNameId.getStore();
																			if(recs.length){
//																				studentID.setDisabled(false);
																				studentcourseCodeNameId.reset();
																				studentcourseCodeNameIdStore.proxy.extraParams = {
																						periodId:studentperiodId.getValue(),
																						programId:studentprogramId,
																						academyLocationId:currentLocationId,
																						batchId:studentbatchId,
																				};
																				studentcourseCodeNameIdStore.load();
																			}
																		 }
																	  }
//																if() {}
															}
														}
													});
												}
											}
										}
									});
								}
							}
						}
					});
					//studentprogramIdStore.load();
				}
			},
			'examtimetablefilter customcombobox[itemId=studentprogramId]':{
				select:function(obj, record){
					var $this = this;
					var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId');
					var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId');
					var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId');
					studentcourseCodeNameId.reset();
					studentbatchIdStore = studentbatchId.getStore();
					if(record.length){
//						studentID.setDisabled(false);
						studentbatchId.reset();
						studentperiodId.reset();
						studentbatchIdStore.proxy.extraParams = {
								programId:record[0].data.id,
								studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
								onlyCurrentRecord: false
						};
						studentbatchId.getStore().load({
							callback: function(records, operation, success) {
								if (success) {
									if(studentbatchId.getStore().getCount() == 1) {
										studentbatchId.setValue(records[0].data.id);
										studentbatchId.setReadOnly(true);
										var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId'),
										studentperiodIdStore = studentperiodId.getStore();
										studentperiodId.reset();
										studentperiodIdStore.proxy.extraParams = {
												id:records[0].data.id,
												studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
												onlyCurrentRecord: false
										};
										studentperiodIdStore.load({
											callback: function(recss, operation, success) {
												if (success) {
													 for(var i in recss){
															if(recss[i].data.isCurrentPeriodOfProgram == true && studentperiodId.getStore().getCount()){
																studentperiodId.setValue(recss[i].data.id);
																var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId').getValue();
																var	studentprogramId = $this.getExamtimetablefilter().down('#studentprogramId').getValue();
																var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId'),
																studentcourseCodeNameIdStore = studentcourseCodeNameId.getStore();
																if(recss.length){
//																	studentID.setDisabled(false);
//																	studentID.reset();
																	studentcourseCodeNameIdStore.proxy.extraParams = {
																			periodId:recss[i].data.id,
																			programId:studentprogramId,
																			academyLocationId:currentLocationId,
																			batchId:studentbatchId,
																	};
																	studentcourseCodeNameIdStore.load();
																	
																}
															
															 }
														  }
//													if() {}
												}
											}
										});
									}else{
										studentbatchId.setReadOnly(false);
									}
								}
							}
						});
						//studentbatchIdStore.load();
					}
				},
			},
			'examtimetablefilter customcombobox[itemId=studentbatchId]':{
				select:function(obj, record){
					var $this = this;
//					var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId'),
					var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId'),
					studentperiodIdStore = studentperiodId.getStore();
					if(record.length){
//						studentID.setDisabled(false);
						studentperiodId.reset();
						studentperiodIdStore.proxy.extraParams = {
								id:record[0].data.id,
//								studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
								onlyCurrentRecord: false
						};
						studentperiodIdStore.load({
							callback: function(recs, operation, success) {
								if (success) {
									 for(var i in recs){
											if(recs[i].data.isCurrentPeriodOfProgram == true && studentperiodId.getStore().getCount()){
												studentperiodId.setValue(recs[i].data.id);
												var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId').getValue();
												var	studentprogramId = $this.getExamtimetablefilter().down('#studentprogramId').getValue();
												var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId'),
												studentcourseCodeNameIdStore = studentcourseCodeNameId.getStore();
												if(recs.length){
//													studentID.setDisabled(false);
//													studentID.reset();
													studentcourseCodeNameIdStore.proxy.extraParams = {
															periodId:recs[i].data.id,
															programId:studentprogramId,
															academyLocationId:currentLocationId,
															batchId:studentbatchId,
													};
													studentcourseCodeNameIdStore.load();
													
												}
											
											 }
										  }
//									if() {}
								}
							}
						});
//						studentperiodIdStore.load();
					}
				},
			},
			'examtimetablefilter customcombobox[itemId=studentperiodId]':{
				select:function(obj, record){
					var $this = this;
					var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId').getValue();
					var	studentprogramId = $this.getExamtimetablefilter().down('#studentprogramId').getValue();
					var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId'),
					studentcourseCodeNameIdStore = studentcourseCodeNameId.getStore();
					if(record.length){
//						studentID.setDisabled(false);
						studentcourseCodeNameId.reset();
						studentcourseCodeNameIdStore.proxy.extraParams = {
								periodId:record[0].data.id,
								programId:studentprogramId,
								academyLocationId:currentLocationId,
								batchId:studentbatchId,
						};
						studentcourseCodeNameIdStore.load();
					}

				},
			},
			'examtimetablefilter button[itemId=searchBtn]':{
				click:function(obj, record){
					var $this=this;
					var grid = $this.getExamtimetablegrid();
					var filterForm=this.getExamtimetablefilter().getForm();
					var	studentprogramId = $this.getExamtimetablefilter().down('#studentprogramId').getValue();
					var studentbatchId =$this.getExamtimetablefilter().down('#studentbatchId').getValue();
					var studentperiodId =$this.getExamtimetablefilter().down('#studentperiodId').getValue();
					var studentcourseCodeNameId =$this.getExamtimetablefilter().down('#studentcourseCodeNameId').getValue();
					var dateFrom = !isNullOrEmpty(filterForm.findField('dateFrom').value)?new Date(filterForm.findField('dateFrom').value):null;
					var dateTo = $this.getExamtimetablefilter().down('#dateTo').getValue();
//					var batchId = this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.batchId;
					//if(!isNullOrEmpty(center.valueModels)){
					grid.getStore().getProxy().extraParams={
						studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
						programId:studentprogramId,
						batchId:studentbatchId,
						periodId:studentperiodId,
						fromDate:dateFrom,
						tillDate:dateTo,
						courseId:studentcourseCodeNameId,
						onlyEnrolledCourses: filterForm.getValues().onlyEnrolledCourses
					};
//					grid.getStore().load();

					$this.resetPageSetting(grid.getStore(), grid);
					grid.getStore().load();     
					grid.getSelectionModel().deselectAll();
					grid.getStore().pageSize=100;
				}   
			//}
			},
			
			'examtimetablegrid': {
				beforerender: function(grid) {
					grid.getStore().removeAll();
				}
			}
		});
	}
});