/*
 * @author prathamesh.sheth
 * 
 * This controller is used for to perform all actions related to events(Resource Bookings).    
 */
Ext.define('Academia.controller.facilitiesresources.resourcebooking.ResourceBookingController', {
   
	extend: 'Academia.controller.base.BaseController',
	
    models: ['facilitiesresources.resourcebooking.ResourceBookingModel', 'facilitiesresources.resourcebooking.FacilityTreeModel',
    	         'facilitiesresources.resourcebooking.MarkEventAttendanceModel','alumni.alumniEventRegistrationDetails.alumniEventRegistrationDetailsModel',
    	         'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableModel',
    	         'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedModel'],

    stores: ['facilitiesresources.resourcebooking.ResourceBookingStore', 'facilitiesresources.resourcebooking.ResourceFeedbackStore', 
             'facilitiesresources.resourcebooking.ResourceBookingPurposeStore', 'facilitiesresources.resourcebooking.ResourceGroupStore', 
             'facilitiesresources.resourcebooking.ResourceTypeStore', 'facilitiesresources.resourcebooking.AllBatchesStore',
             'facilitiesresources.resourcebooking.AllProgramsStore', 'facilitiesresources.resourcebooking.AllSectionsStore', 
             'facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesSelectedStore', 'common.UsersComboStore',
             'facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesTreeStore', 'facilitiesresources.resourcebooking.EquipmentListStore',
             'facilitiesresources.resourcebooking.EquipmentSelectedStore', 'facilitiesresources.resourcebooking.ExternalResourceListStore', 
             'facilitiesresources.resourcebooking.ExternalResourceSelectedStore', 'facilitiesresources.resourcebooking.AdhocResourceListStore', 
             'facilitiesresources.resourcebooking.FacultyListStore', 'facilitiesresources.resourcebooking.FacultySelectedStore', 
             'facilitiesresources.resourcebooking.UserListStore', 'facilitiesresources.resourcebooking.UserSelectedStore', 
             'facilitiesresources.resourcebooking.ProgramListStore', 'facilitiesresources.resourcebooking.ProgramSelectedStore', 
             'facilitiesresources.resourcebooking.CourseListStore', 'facilitiesresources.resourcebooking.CourseSelectedStore', 
             'facilitiesresources.resourcebooking.AcademyLocationListStore', 'facilitiesresources.resourcebooking.AcademyLocationSelectedStore', 
             'department.ParentDepartmentStore', 'department.ChildDepartmentStore','facilitiesresources.resourcebooking.departmentFilterStore',
             'facilitiesresources.resourcebooking.subdepartmentFilterStore','admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
             'facilitiesresources.resourcebooking.AdhocStatusStore',
             'common.AcademyLocationNameSeparated', 'facilitiesresources.resourcebooking.EventResourceGroupStore',
             'facilitiesresources.resourcebooking.InternalFacilityResourceListStore', 'facilitiesresources.resourcebooking.IndependentEquipmentResourceListStore',
             'facilitiesresources.resourcebooking.ExternalFacilityEquipmentListStore', 'facilitiesresources.resourcebooking.ListOfWhetherFacultyStore',
             'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore', 'Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore',
             'common.ActiveUsersByAcademyLocation','servicerequest.eventcalendar.EventCalendarName','committee.committee.CommitteeStore','user.UserAcademyLocationStore',
             'committee.committee.CommitteeGridStore','committee.committee.CommitteeParticipantGridStore','course.QuestionPaperBankDocument','common.AllUserBySmartSearch',
             'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
             'transport.serviceRoute.WeekDays','facilitiesresources.resourcebooking.MarkEventAttendanceStore',
             'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore','facilitiesresources.resourcebooking.MarkEventAttendanceUserTypeStore',
             'alumni.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsStore',
             'alumni.alumniEventRegistrationDetails.AlumniNameStore','alumni.alumniEventRegistrationDetails.AlumniIDStore',
             'alumni.alumniEventRegistrationDetails.AlumniALStore','facilitiesresources.resourcebooking.AlumniAllProgramsStore',
             'alumni.alumniEventRegistrationDetails.AlumniProgramStore','facilitiesresources.resourcebooking.AlumniAcademyLocationListByUserStore',
             'facilitiesresources.resourcebooking.AlumniResourceListStore',
             'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableStore',
             'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedStore'
             ],
    views: ['baselayout.contentarea.ContentPanel', 'facilitiesresources.resourcebooking.ResourceBooking', 'facilitiesresources.resourcebooking.ResourceBookingListSearchForm',
            'facilitiesresources.resourcebooking.ResourceBookingGrid', 'facilitiesresources.resourcebooking.ResourceBookingFormLayout', 
            'facilitiesresources.resourcebooking.ResourceFeedBackWindow', 'facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceGrid',
            'facilitiesresources.resourcebooking.ResourceBookingFormAdhocResourceWindow', 
            'facilitiesresources.resourcebooking.ResourceBookingFormFacilitySelectedPanel','facilitiesresources.resourcebooking.ResourceBookingCalendarWindow',
            'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport','facilitiesresources.resourcebooking.AssignCalendarWin',
            'Academia.view.facilitiesresources.resourcebooking.exportAllGrid','examinationcenters.questionPaperBank.MeetingDocumentGrid','personinfo.common.personalinfo.PhotoUploadForm',
            'facilitiesresources.resourcebooking.MarkEventAttendanceTab','facilitiesresources.resourcebooking.MarkEventAttendanceGrid',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniGrid','facilitiesresources.resourcebooking.OpenResourceBookingWindow',
            'facilitiesresources.resourcebooking.AlumniResourceBookingFormLayout',
            'facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsStructure',
            'facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsFilter',
            'facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsGrid',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableStructure',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableFilter',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniAvailableGrid',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedStructure',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedFilter',
            'facilitiesresources.resourcebooking.ResourceBookingAlumniMappedGrid'
            ],

    alias: 'widget.resourcebookingcontroller',

    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'resourceBookingListSearchForm',
        selector: 'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm]'
    }, {
        ref: 'resourceBookingGrid',
        selector: 'resourcebooking searchresultgrid[itemId=resourceBookingGrid]'
    }, {
        ref: 'panelResourceBookingFormLayout',
        selector: 'resourcebookingformlayout'
    }, {
        ref: 'frmResourceBooking',
        selector: 'resourcebookingformlayout form[itemId=resourcebookingform]'
    }, {
        ref: 'winResourceFeedBack',
        selector: 'resourcefeedbackwindow'
    }, {
        ref: 'grdAdhocResources',
        selector: 'adhocresourcesgrid'
    }, {
        ref: 'winAdhocResourceForm',
        selector: 'adhocresourceformwindow'
    }, {
        ref: 'frmAdhocResource',
        selector: 'adhocresourceformwindow form[itemId=adhocresourceForm]'
    }, {
        ref: 'grdResourceFeedback',
        selector: 'resourcefeedbackwindow grid[itemId=resourcefeedbackgrid]'
    }, {
        ref: 'selectedFacilitiesPanelContainer',
        selector: 'resourcebookingformfacilityselectedpanel dataview[itemId=selectedFacilitiesPanel]'
    },{
        ref: 'calendar',
        selector: 'resourcebookingcalendarwindow'
    },{
        ref: 'assigncalendarwin',
        selector: 'assigncalendarwin'
    },{
        ref: 'assignCalendarwin',
        selector: 'assigncalendarwin form'
    },{
    	ref :'resourcebookingusergrid',
    	selector : 'resourcebookingusergrid'
    },{
    	ref :'meetingdocumentgrid',
    	selector : 'meetingdocumentgrid[itemId=documentsGridResourceBooking]'
    },{
    	ref:'markeventattendancetab',
    	selector:'markeventattendancetab'
    },{
    	ref:'markeventattendancegrid',
    	selector:'markeventattendancegrid'
    },{
    	ref:'alumniresourcebookingformlayout',
    	selector:'alumniresourcebookingformlayout'
    },{
    	ref:'resourcebookingalumnigrid',
    	selector:'resourcebookingalumnigrid'    	
    },{
    	ref:'alumnieventregistrationdetailsfilter',
    	selector:'alumnieventregistrationdetailsfilter'
    },{
    	ref:'alumnieventregistrationdetailsgrid',
    	selector:'alumnieventregistrationdetailsgrid'
    },{
    	ref:'openresourcebookingwindow',
    	selector:'openresourcebookingwindow'    	
    },{
    	ref:'resourcebookingalumniavailablefilter',
    	selector:'resourcebookingalumniavailablefilter'
    },{
    	ref:'resourcebookingalumniavailablegrid',
    	selector:'resourcebookingalumniavailablegrid'
    },{
    	ref:'resourcebookingalumnimappedfilter',
    	selector:'resourcebookingalumnimappedfilter'
    },{
    	ref:'resourcebookingalumnimappedgrid',
    	selector:'resourcebookingalumnimappedgrid'
    },{
    	ref:'resourcebookingalumnimappedstructure',
    	selector:'resourcebookingalumnimappedstructure'    	
    }],    
    config: {
    	RESOURCE_BOOKING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RESOURCE_BOOKING_PRIVILEGES')
    },
    init: function(application) {
    	
    	this.ACADEMIC_BOOKING_PURPOSE = 1;    	
    	this.NON_ACADEMIC_BOOKING_PURPOSE = 2;
    	this.SELECTION_BOOKING_PURPOSE = 3;
    	this.ADDMISION_BOOKING_PURPOSE = 4;
    	this.EXAMINATION_BOOKING_PURPOSE = 5;
    	this.ORGANIZATION_BOOKING_PURPOSE = 6;
    	this.EXTERNAL_EVENT_BOOKING_PURPOSE = 7;
    	
        var acadLocSelectedStore;
        var facilitiesSelectedStore;        
        this.control({
        	'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] combo[itemId=resourceGroupCombo]': {
                select: function(combo, records, eOpts){
                	this.showHideComboOnGroupSelection(combo, records, eOpts);
                	var form = this.getResourceBookingListSearchForm();
            		if(records[0].data.name == 'faculty'){
            			var facultyStore = form.down('#faculty').getStore();
                		var academyLocationId = this.getCurrentAcademyLocation();
                		facultyStore.getProxy().extraParams = {
            				academyLocationIds: academyLocationId,
            				whetherFaculty: true
                        }
            		} else if(records[0].data.name == 'user'){
            			var userStore = form.down('#user').getStore();
                		var academyLocationId = this.getCurrentAcademyLocation();
            			userStore.getProxy().extraParams = {
            				academyLocationIds: academyLocationId,
            				whetherFaculty: false
                        }
            		}
            		
                }
            },
            'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] combo[itemId=resourceTypeCombo]': {
            	select: function(combo, records, eOpts){
            		this.showHideComboOnTypeSelection(combo, records, eOpts);
            		var form = this.getResourceBookingListSearchForm();
            		var facilityStore = form.down('#facility').getStore();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		facilityStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationId,
            			resourceTypeId: records[0].data.id
            		}
            		var equipmentStore = form.down('#equipment').getStore();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		equipmentStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationId,
            			resourceTypeId: records[0].data.id
            		}
            		var externalStore = form.down('#external').getStore();
            		var academyLocationId = this.getCurrentAcademyLocation();
            		externalStore.getProxy().extraParams = {
            			academyLocationIds: academyLocationId,
            			resourceTypeId: records[0].data.id
            		}
            	}
            },
            /*'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] multiselectcombofield[itemId=multiselectAcademyLocationId]': {
                change: function(field, newValue, oldValue, eOpts){
                	console.log(newValue)
                	this.setParamsToComboField(field, newValue, oldValue, eOpts);
                }
            },*/
        	'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadBookingSearchResultGrid();
                }
            },
            'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] button[itemId=resetButtonId]': {
                click: function(){
                	var this$ = this;
                	var form = this$.getResourceBookingListSearchForm();
                	form.getForm().reset();
                	this$.onResetComboFieldContainer();
                }
            },
            'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] livesearchcombo[itemId=faculty]' : {
            	click: function() {
            		var form = this.getResourceBookingListSearchForm();
            		var resourceGroup = form.down('#resourceGroupCombo').getValue();
            	}
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.PDFEXPORT,'pdf',false);
 	            }
 	        },
 	        'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.PDFEXPORT,'pdf',true);
 	            }
 	        },
 	        'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 	            }
 	        },
 	        'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 	            }
 	        },
        	'resourcebooking searchresultgrid[itemId=resourceBookingGrid]': {
        		render: function(grid) {
        			Academia.app.getController('Academia.controller.eventmeetingminutes.EventMeetingMinutesController');
        			this.gridRenderFunctionForBooking(grid);
                    this.genericCBGridAccessControlValidation(grid, this.getRESOURCE_BOOKING_PERMISSIONS());
        			this.disableMoreActionPivileges(grid,this.getRESOURCE_BOOKING_PERMISSIONS());        			
        			this.loadBookingSearchResultGrid();
                },
                select:function(rowModel, record, index, eOpts ){
                	var me=this;
                	var grid=me.getResourceBookingGrid();
                	if(!isEmpty(record)){                		            	        
            	        var eventDate = record.get('EVENT_DATE');
            	        var editButton=grid.down('#searchResultGridBtnEdit');
            	        var viewButton=grid.down('#searchResultGridBtnView');
            	        var splitButton=grid.down('#spBtnResourceBookingMoreActions');
            	        var resourceADhocConfirmMenu = splitButton.down('#resourceADhocConfirmMenu');
            	        if(!isNullOrEmpty(eventDate)){
            	        	/**
                    		 * @author Ravi Choudhary
                    		 * to manage organization date format
                    		 */
//                    		var orgModel = Academia.model.common.OrgSettingDateTimeModel;
//                    	    var currentDateFormat = orgModel.get('dateFormat');
//                    		if(currentDateFormat ==="DMY_DESH") {
                    			//eventDate = this.getDateFromDMYdate(eventDate);
//                    		} else if(currentDateFormat ==="DMY_SLASH") {
//                    			eventDate = this.getDateFromDMYdate(eventDate, 'd/m/Y')
//                    		} else {
//                    			eventDate = new Date(eventDate);
//                    		}
                    		/*eventDate.setHours(24);
                    		eventDate = new Date(eventDate);
            	        	var currentDate =new Date();
            	        	if(eventDate > currentDate) {
            	        		editButton.setDisabled(false);
            	        		//viewButton.setDisabled(false);
            	        		resourceADhocConfirmMenu.setVisible(true);
            	        	}else{
            	        		editButton.setDisabled(true);
            	        		//viewButton.setDisabled(true);
            	        		resourceADhocConfirmMenu.setVisible(false);
            	        	}*/
            	        }            	        
                	}                	
                }
        	},
        	/*'resourcebookinggrid': {
                render: function(component, eOpts) {
                    component.getStore().load();
                },
                
            },  */         	
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=searchResultGridBtnEdit]': {
                click: function(btn){
                	/*if(Ext.isDefined(btn.firstTimeFired) && btn.firstTimeFired==true){
                		btn.firstTimeFired = false;
                	}
                	else{
                		btn.firstTimeFired = true;
                    	this.editResourceBooking(false);
                	}*/
                		 var grid = this.getResourceBookingGrid();
                         var records = grid.getSelectionModel().getSelection();
                         if(records[0].data.IS_CHECK_ALUMNI == true) {
                        	 this.editAlumniResourceBooking(false);
                         }else {
                        	 this.editResourceBooking(false);
                         }
                }
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=searchResultGridBtnView]': {
            	click: function(btn){
            		var grid = this.getResourceBookingGrid();
            		var records = grid.getSelectionModel().getSelection();
            		if(records[0].data.IS_CHECK_ALUMNI == true) {
                   	 this.editAlumniResourceBooking(true);
                    }else {                    	
                    	this.editResourceBooking(true);
                    }
                }
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=searchResultGridBtnDelete]': {
                click: this.deleteResourceBooking
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] splitbutton[itemId=spBtnResourceBookingMoreActions]': {
            	menushow:function(cmb,menu,eOpts){
            		var me = this;
            		var confirmAdhocMenuItem=cmb.down('#resourceADhocConfirmMenu');
                    var grid = me.getResourceBookingGrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        if (!isEmpty(records)) {
                        	var status=records[0].data.adhocStatus;
                        	if(!isNullOrEmpty(status)){
                        		if (status === getCommonTranslation('CONFIRMED')) {
                        			confirmAdhocMenuItem.setVisible(true);
                                } else if(status === getCommonTranslation('PENDING')) {
                                	confirmAdhocMenuItem.setVisible(true);
                                }else if(status === getCommonTranslation('UNAVAILABLE')) {
                                	confirmAdhocMenuItem.setVisible(false);
                                }else{
                                	confirmAdhocMenuItem.setVisible(false);
                                }
                        	}
                        }
                    } else {
                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                    }
            	}
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=resourceFeedbackMenu]': {
                click: this.resourceFeedbackMenuClicked
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=resourceADhocConfirmMenu]': {
                click: this.resourceADhocConfirmMenuClicked
            },
            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=assignCalender]': {
                click: this.resourceAssignCalendarClicked
            },
            'resourcefeedbackwindow button[itemId=btnSaveResourceFeedBack]': {
                click: this.saveResourceFeedBack
            },
            'resourcefeedbackwindow button[itemId=btnCancelResourceFeedBack]': {
                click: this.cancelResourceFeedBack
            },
            'resourcebookingformlayout button[itemId=btnSaveResourceBookingForm]': {
                click: function(btn){
                	var me = this;
                	me.saveResourceBookingForm(btn);
                	/*if(Ext.isDefined(btn.firstTimeFire) && btn.firstTimeFire==true){
                		btn.firstTimeFire = false;
                	}
                	else{
                		btn.firstTimeFire = true;
                		me.saveResourceBookingForm(btn);
                	}*/
                }
            },
            'resourcebookingformlayout button[itemId=btnCancelResourceBookingForm]': {
                click: this.closeResourceBookingFormTab
            },
            'resourcebookingformlayout button[itemId=gradeMasterResetButtonId]': {
            	click: function() {
            	    $this = this;
            	    var formLayout = $this.getPanelResourceBookingFormLayout()
            	    var form = formLayout.getForm();
            	    form.reset();
            	    var eventDate = formLayout.down('#eventDate');
            	    eventDate.setValue(new Date());

            	    var timeFromField = formLayout.down('#timeFrom');
            	    var timeToField = formLayout.down('#timeTo');
            	    timeFromField.setMinValue(false);
            	    timeToField.setMinValue(false);
            	    timeFromField.setMaxValue(false);
            	    timeToField.setMaxValue(false);
            	    
            	    /** Reset Tab Start */
            	    var userSelectedGrid = formLayout.down('#userSelectedGrid');
            	    var userSelectedStore = userSelectedGrid.getStore();
            	    userSelectedStore.removeAll();
            	    userSelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#userListGrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'userListGrid', params);

            	    var programSelectedGrid = formLayout.down('#programSelectedGrid');
            	    var programSelectedStore = programSelectedGrid.getStore();
            	    programSelectedStore.removeAll();
            	    programSelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#programListGrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'programListGrid', params);

            	    var courseSelectedGrid = formLayout.down('#courseSelectedGrid');
            	    var courseSelectedStore = courseSelectedGrid.getStore();
            	    courseSelectedStore.removeAll();
            	    courseSelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#courseListGrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'courseListGrid', params);

            	    var facultySelectedGrid = formLayout.down('#facultySelectedgrid');
            	    var facultySelectedStore = facultySelectedGrid.getStore();
            	    facultySelectedStore.removeAll();
            	    facultySelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#facultyListgrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'facultyListgrid', params);

            	    var academyLocationListGrid = formLayout.down('#academyLocationListGrid');
            	    academyLocationListGrid.getSelectionModel().deselectAll();

            	    var equipmentSelectedGrid = formLayout.down('#equipmentSelectedGrid');
            	    var equipmentSelectedStore = equipmentSelectedGrid.getStore();
            	    equipmentSelectedStore.removeAll();
            	    equipmentSelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#equipmentListGrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'equipmentListGrid', params);

            	    var externalResourceSelectedGrid = formLayout.down('#externalResourceSelectedGrid');
            	    var externalResourceSelectedStore = externalResourceSelectedGrid.getStore();
            	    externalResourceSelectedStore.removeAll();
            	    externalResourceSelectedStore.loadData([]);

            	    var params = this.createLoadingCriteria(formLayout.down('#externalResourceListGrid'));
            	    this.loadSpecificResourceBookingTab(formLayout, 'externalResourceListGrid', params);

            	    var adhocResourcesGrid = formLayout.down('#adhocresourcesgrid');
            	    var adhocResourcesGridStore = adhocResourcesGrid.getStore();
            	    adhocResourcesGridStore.removeAll();
            	    adhocResourcesGridStore.loadData([]);

            	    var dataStore = formLayout.down('#selectedFacilitiesPanel').getStore();
            	    dataStore.removeAll();

            	    var params = this.createLoadingCriteria(formLayout.down('#resourcebookingfacilitytree'));
            	    this.filterData(formLayout, 'resourcebookingfacilitytree', null, params);
            	    formLayout.down('#resourcebookingfacilitytree').collapseAll();
            	    /** Reset Tab End */
            	}
            },
            'resourcebookingformlayout checkbox[itemId=chkCompleteDay]': {
                change: this.checkCompleteDayValue
            },
            'adhocresourcesgrid button[itemId=btnAdd]': {
                click: Ext.bind(this.addAdhocResource, this, [""])
            },
            'adhocresourcesgrid button[itemId=btnEdit]': { 
                click: Ext.bind(this.editAdhocResource, this, [false])
            },
            'adhocresourcesgrid button[itemId=btnView]': {
                click: Ext.bind(this.editAdhocResource, this, [true])
            },
            'adhocresourcesgrid button[itemId=btnDelete]': {
                click: this.deleteAdhocResource
            },
            'adhocresourcesgrid[itemId=adhocresourcesgrid]': {
            	render: function(grid){
            		this.doAccessControlValidation(grid, this.getRESOURCE_BOOKING_PERMISSIONS());
            		this.disableMoreActionPivileges(grid,this.getRESOURCE_BOOKING_PERMISSIONS());
            	}
            },
            'adhocresourceformwindow button[itemId=btnSaveAdhocResourceForm]': {
                click: this.saveAdhocResource
            },
            'adhocresourceformwindow button[itemId=btnCancelAdhocResourceForm]': {
                click: this.cancelAdhocResource
            },            
            'resourcebookingformlayout button[itemId=btnViewCalendar]': { 
                click: function(cmp, e, eOpts ){
                	var me = this;
                	var parentComponent = cmp.up().up();
                    if (parentComponent) {                    	                            
                          if (parentComponent.getSelectionModel().getCount() > 0) {                        	  
                        	  var winResourceBookingCalendar=Ext.widget('resourcebookingcalendarwindow');
                        	  winResourceBookingCalendar.show();                        	  
                              var records = parentComponent.getSelectionModel().getSelection();
                              if (!isEmpty(records)) {
                            	  var params=me.sendCalendarEventsRequest(me,parentComponent,records);                            	                              	  
                              }
                          } else {
                        	  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.                              
                          }
                    }
                }
            },
            
            'resourcebookingformlayout checkbox[itemId=orgScheduleEvents]': {
                change: function(cmp, currentValue, oldValue, eOpts) {
                	var frmResourceBooking = this.getFormComponent();
                    var academyLocationGrid = frmResourceBooking.down('#academyLocationListGrid');        
                    if(currentValue==true){
                    	academyLocationGrid.getSelectionModel().selectAll();
                    }else{
                    	academyLocationGrid.getSelectionModel().deselectAll();
                    }
                }
            },
            
            'resourcebookingformlayout treepanel[itemId=resourcebookingfacilitytree]': {
                checkchange: function(node, checked, eOpts) {
                	if (!isNullOrEmpty(node.data.model) && node.data.model.resourceGroup==='EQUIPMENT') {
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_NODE_NOT_BOOKED_INDEPENDENTLY')); //Selected equipment should not be booked independently.
                		if(node.parentNode.data.checked){
                			node.set('checked', true);
                		}else{
                			node.set('checked', false);
                		}
                		
                    }else if (!isNullOrEmpty(node.data.model) && node.parentNode.data.root == false &&  node.data.model.resourceGroup==='FACILITY') {
                		
                    	function selectParentNodes(node, checked){
                   	     var parentNode = node.parentNode;
                   	     if(parentNode){
                   	    	 if(checked == false){
                   	    		 var childChecked = false;
                   	    		 if(parentNode.hasChildNodes()){
                   	    			 parentNode.cascadeBy(function(childNode) {
											 if(parentNode.data.text !=childNode.data.text){
												 if(childChecked == false){
													childChecked = childNode.get('checked'); 
									 			}
											 }
                   	    			 });
                   	    		 }
                   	    		 if(!childChecked){
                   	    			if(parentNode.data.text != "My Organization"){
                   	    				parentNode.set('checked', false);
                          	        	selectParentNodes(parentNode, false);
                   	    			}
                   	    		 }
                   	    	 }else{
                         	         if(parentNode.data.text != "My Organization"){
                         	        	parentNode.set('checked', true);
                         	        	selectParentNodes(parentNode, true);
                         	         }
                   	    	 }
                   	        
                   	     }
                   	 	}
                    	if(node.hasChildNodes()){
                    		node.set('checked', checked);
                    		node.cascadeBy(function(node) {
    	                        node.set('checked', checked);
    	                    });
                    	}
                    	selectParentNodes(node, checked);
                    	var frmResourceBooking = this.getFormComponent();
                    	var dataStore = frmResourceBooking.down('#selectedFacilitiesPanel').getStore();
	                    dataStore.removeAll();
                    	var treePanel = frmResourceBooking.down('treepanel');
                    	var treeStore = treePanel.getStore();
                    	treeStore.getRootNode().cascadeBy(function(eachNode) {
	                        if (eachNode.data.checked) {
	                            var dataModel = new Academia.model.facilitiesresources.resourcebooking.SelectedFacilitiesModel();
	                            dataModel.set('selectedText', eachNode.data.text);
	                            dataStore.add(dataModel);
	                        }
	                    });
                		
                    }else{
                    	var frmResourceBooking = this.getFormComponent();                    	
	                    var dataStore = frmResourceBooking.down('#selectedFacilitiesPanel').getStore();
	                    dataStore.removeAll();
	                    var frmResourceBooking = this.getFormComponent();
	                    var treePanel = frmResourceBooking.down('treepanel');
	                    var treeStore = treePanel.getStore();
	                    node.cascadeBy(function(node) {
	                        node.set('checked', checked);
	                    });
	                    treeStore.getRootNode().cascadeBy(function(eachNode) {
	                        if (eachNode.data.checked) {
	                            var dataModel = new Academia.model.facilitiesresources.resourcebooking.SelectedFacilitiesModel();
	                            dataModel.set('selectedText', eachNode.data.text);
	                            dataStore.add(dataModel);
	                        }
	                    });
                    }    
                },
                itemclick:function( me, node, item, index, e, eOpts) {                	
                	var checked = node.get('checked');
                	if(checked == false){
                		checked = true;
                		node.set("checked", true);
                	}
                	else{
                		checked = false;
                		node.set("checked", false);
                	}

                	if (!isNullOrEmpty(node.data.model) && node.data.model.resourceGroup==='EQUIPMENT') {
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_NODE_NOT_BOOKED_INDEPENDENTLY')); //Selected equipment should not be booked independently.
                		if(node.parentNode.data.checked){
                			node.set('checked', true);
                		}else{
                			node.set('checked', false);
                		}
                		
                    }else if (!isNullOrEmpty(node.data.model) && node.parentNode.data.root == false &&  node.data.model.resourceGroup==='FACILITY') {
                		
                    	function selectParentNodes(node, checked){
                   	     var parentNode = node.parentNode;
                   	     if(parentNode){
                   	    	 if(checked == false){
                   	    		 var childChecked = false;
                   	    		 if(parentNode.hasChildNodes()){
                   	    			 parentNode.cascadeBy(function(childNode) {
											 if(parentNode.data.text !=childNode.data.text){
												 if(childChecked == false){
													childChecked = childNode.get('checked'); 
									 			}
											 }
                   	    			 });
                   	    		 }
                   	    		 if(!childChecked){
                   	    			if(parentNode.data.text != "My Organization"){
                   	    				parentNode.set('checked', false);
                          	        	selectParentNodes(parentNode, false);
                   	    			}
                   	    		 }
                   	    	 }else{
                         	         if(parentNode.data.text != "My Organization"){
                         	        	parentNode.set('checked', true);
                         	        	selectParentNodes(parentNode, true);
                         	         }
                   	    	 }
                   	        
                   	     }
                   	 	}
                    	if(node.hasChildNodes()){
                    		node.set('checked', checked);
                    		node.cascadeBy(function(node) {
    	                        node.set('checked', checked);
    	                    });
                    	}
                    	selectParentNodes(node, checked);
                    	var frmResourceBooking = this.getFormComponent();
                    	var dataStore = frmResourceBooking.down('#selectedFacilitiesPanel').getStore();
	                    dataStore.removeAll();
                    	var treePanel = frmResourceBooking.down('treepanel');
                    	var treeStore = treePanel.getStore();
                    	treeStore.getRootNode().cascadeBy(function(eachNode) {
	                        if (eachNode.data.checked) {
	                            var dataModel = new Academia.model.facilitiesresources.resourcebooking.SelectedFacilitiesModel();
	                            dataModel.set('selectedText', eachNode.data.text);
	                            dataStore.add(dataModel);
	                        }
	                    });
                		
                    }else{
                    	var frmResourceBooking = this.getFormComponent();                    	
	                    var dataStore = frmResourceBooking.down('#selectedFacilitiesPanel').getStore();
	                    dataStore.removeAll();
	                    var frmResourceBooking = this.getFormComponent();
	                    var treePanel = frmResourceBooking.down('treepanel');
	                    var treeStore = treePanel.getStore();
	                    node.cascadeBy(function(node) {
	                        node.set('checked', checked);
	                    });
	                    treeStore.getRootNode().cascadeBy(function(eachNode) {
	                        if (eachNode.data.checked) {
	                            var dataModel = new Academia.model.facilitiesresources.resourcebooking.SelectedFacilitiesModel();
	                            dataModel.set('selectedText', eachNode.data.text);
	                            dataStore.add(dataModel);
	                        }
	                    });
                    }    
                
                }
                
            },
            'resourcebookingformlayout combo[itemId=cmbBookedBy]': {
                render: function(component, options) {
                	var academyLocationId=this.getCurrentAcademyLocation();
                	component.getStore().getProxy().actionMethods.read='GET';
                    component.getStore().getProxy().extraParams = {
                    	academyLocationIds :academyLocationId
                    }
                    component.getStore().load();
                }
            },
            
            'resourcebookingformlayout multiselectcombofield[itemId=repeatOnItemId]': {
            	afterrender: function(obj, record) {
            		obj.getStore().load();
                }
            },
            
            'resourcebookingformlayout button#meetingDocsId' : {
    			click : function() {
    				this
    				.getDocumentController()
    				.showDocumentFormWindow(
    						'meetingItemId',
    						'DOCUMENT');
    			}
    		},
    		
    		'documentformwindow[itemId=meetingItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = true;
    				var module = 'tools&services';
    				var entityId;
    				var entityType = 'meeting';
    				$this
    				.getDocumentController()
    				.saveDocumentForm(
    						entityId,
    						module,
    						entityType,
    						'DOCUMENT',
    						function(success,
    								response,
    								isCallBackTransient) {
    							var documentModel = new Academia.model.course.QuestionPaperDocument();
    							documentModel
    							.set(
    									"documentName",
    									response.name);
    							documentModel
    							.set(
    									"path",
    									response.path);
    							documentModel
    							.set(
    									"type",
    									response.type);
    							documentModel
    							.set(
    									"documentName",
    									response.name);
    							documentModel
    							.set(
    									"isNewRecord",
    									true);
    							documentModel
    							.set(
    									"createdBy",
    									$this
    									.getIdValueJson(
    											response.createdBy.id,
    											response.createdBy.value));
    							var meetingdocumentgrid = $this
    							.getMeetingdocumentgrid();
    							var store = meetingdocumentgrid
    							.getStore();
    							store
    							.add(documentModel);
    							if (meetingdocumentgrid
    									.isHidden()
    									&& store.data.items.length > 0) {
    								meetingdocumentgrid
    								.setVisible(true);
    							}
    							Ext.apply(meetingdocumentgrid,{
					        		code:null,
					     		  setCode : function(code){
					     			 meetingdocumentgrid.code = code;
					     		  },
					     		  getCode:function(){
					     			  return meetingdocumentgrid.code;
					     		  }
								});
    							meetingdocumentgrid.setCode(documentModel);
    							$this
    							.getDocumentController()
    							.closeDocumentFormWindow();
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=meetingItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController()
    				.closeDocumentFormWindow();
    			}
    		},
    		'resourcebookingformlayout tabpanel[itemId=resourceBookingTabPanel]':{
    			beforerender:function(object) {
    				var $this = this;
    				var form = $this.getPanelResourceBookingFormLayout();
    				try {
    				    var academyLocationPanel = form.down('#academyLocationPanel');
    				    academyLocationPanel.setTitle(getCommonTranslation('ACADEMY_LOCATION_TABTILE'));

    				    var academyLocationListGrid = form.down('#academyLocationListGrid');
    				    academyLocationListGrid.setTitle(getCommonTranslation('LIST_OF_Academy_Location'));

    				    var gridColumns;
    				    if (!isNullOrEmpty(academyLocationListGrid)) {
    				        gridColumns = academyLocationListGrid.columns;
    				    }
    				    for (i in gridColumns) {
    				        var gridColumn = gridColumns[i];
    				        if (gridColumn.dataIndex == "value") {
    				            gridColumn.setText(getCommonTranslation('ACADEMY_LOCATION'));
    				        }
    				    }

    				    var programPanel = form.down('#programPanel');
    				    programPanel.setTitle(getCommonTranslation('PROGRAM_TABTITLE'));

    				    var programListGrid = form.down('#programListGrid');
    				    programListGrid.setTitle(getCommonTranslation('PROGRAMS_AVAILABLE'));
    				    var programSelectedGrid = form.down('#programSelectedGrid');
    				    programSelectedGrid.setTitle(getCommonTranslation('PROGRAMS_SELECTED'));
    				    var programListGridColumns;
    				    if (!isNullOrEmpty(programListGrid)) {
    				        programListGridColumns = programListGrid.columns;
    				    }
    				    for (i in programListGridColumns) {
    				        var gridColumn = programListGridColumns[i];
    				        if (gridColumn.dataIndex == "program") {
    				            gridColumn.setText(getCommonTranslation('PROGRAM_NAME'));
    				        }
    				    }
    				    var programSelectedGridColumns;
    				    if (!isNullOrEmpty(programSelectedGrid)) {
    				        programSelectedGridColumns = programSelectedGrid.columns;
    				    }
    				    for (i in programSelectedGridColumns) {
    				        var gridColumn = programSelectedGridColumns[i];
    				        if (gridColumn.dataIndex == "program") {
    				            gridColumn.setText(getCommonTranslation('PROGRAM_NAME'));
    				        }
    				    }

    				    var coursePanel = form.down('#coursePanel');
    				    coursePanel.setTitle(getCommonTranslation('COURSE_TABTITLE'));

    				    var courseListGrid = form.down('#courseListGrid');
    				    courseListGrid.setTitle(getCommonTranslation('COURSES_AVAILABLE'));
    				    var courseSelectedGrid = form.down('#courseSelectedGrid');
    				    courseSelectedGrid.setTitle(getCommonTranslation('COURSES_SELECTED'));
    				    var courseListGridColumns;
    				    if (!isNullOrEmpty(courseListGrid)) {
    				        courseListGridColumns = courseListGrid.columns;
    				    }
    				    for (i in courseListGridColumns) {
    				        var gridColumn = courseListGridColumns[i];
    				        if (gridColumn.dataIndex == "code") {
    				            gridColumn.setText(getCommonTranslation('COURSE_NAME'));
    				        }
    				    }
    				    var courseSelectedGridColumns;
    				    if (!isNullOrEmpty(courseSelectedGrid)) {
    				        courseSelectedGridColumns = courseSelectedGrid.columns;
    				    }
    				    for (i in courseSelectedGridColumns) {
    				        var gridColumn = courseSelectedGridColumns[i];
    				        if (gridColumn.dataIndex == "code") {
    				            gridColumn.setText(getCommonTranslation('COURSE_NAME'));
    				        }
    				    }

    				    var facultyPanel = form.down('#facultyPanel');
    				    facultyPanel.setTitle(getCommonTranslation('FACULTY_TABTITLE'));

    				    var facultyListgrid = form.down('#facultyListgrid');
    				    facultyListgrid.setTitle(getCommonTranslation('FACULTIES_AVAILABLE'));
    				    var facultySelectedgrid = form.down('#facultySelectedgrid');
    				    facultySelectedgrid.setTitle(getCommonTranslation('FACULTIES_SELECTED'));
    				    var facultyListgridColumns;
    				    if (!isNullOrEmpty(facultyListgrid)) {
    				        facultyListgridColumns = facultyListgrid.columns;
    				    }
    				    for (i in facultyListgridColumns) {
    				        var gridColumn = facultyListgridColumns[i];
    				        if (gridColumn.dataIndex == "name") {
    				            gridColumn.setText(getCommonTranslation('FACULTY_NAME'));
    				        }
    				    }
    				    var facultySelectedgridColumns;
    				    if (!isNullOrEmpty(facultySelectedgrid)) {
    				        facultySelectedgridColumns = facultySelectedgrid.columns;
    				    }
    				    for (i in facultySelectedgridColumns) {
    				        var gridColumn = facultySelectedgridColumns[i];
    				        if (gridColumn.dataIndex == "name") {
    				            gridColumn.setText(getCommonTranslation('FACULTY_NAME'));
    				        }
    				    }
    				    var userTabPanel = form.down('#userTabPanel'),
    				    facilitiesTabPanel = form.down('#facilitiesTabPanel'),
    				    equipmentsTabPanel = form.down('#equipmentsTabPanel'),
    				    externalResourceTabPanel = form.down('#externalResourceTabPanel'),
    				    adhocResourceTabPanel = form.down('#adhocResourceTabPanel');
    				   /* academyLocationPanel.setDisabled(true);
    				    userTabPanel.setDisabled(true);
    				    programPanel.setDisabled(true);
    				    coursePanel.setDisabled(true);
    				    facultyPanel.setDisabled(true);
    				    facilitiesTabPanel.setDisabled(true);
    				    equipmentsTabPanel.setDisabled(true);
    				    externalResourceTabPanel.setDisabled(true);
    				    adhocResourceTabPanel.setDisabled(true);*/
    				} catch (error) {

    				}
    			},
    			render:function(object) {
    				var $this = this;
    				var grid1 = $this.getPanelResourceBookingFormLayout().down('#userListGrid');
    				Ext.apply(grid1,{
						code:null,
						setCode : function(code){
							grid1.code = code;
						},
						getCode:function(){
							return grid1.code;
						}
					});
    			},
    			tabchange:function(tabPanel, newCard, oldCard, eOpts){    				
    				var $this = this;
    				var form = $this.getPanelResourceBookingFormLayout().getForm();
    				var bookingPurpose = form.findField('bookingPurpose');
    				var committee = form.findField('committee');
    				var eventDate =  form.getValues().eventDate;
    				var timeFrom =  form.getValues().timeFrom;
    				var timeTo =  form.getValues().timeTo;
    				var isCompleteDay =  form.getValues().isCompleteDay;
    				var purpose = bookingPurpose.getRawValue();
    				var alinfomodel = Academia.model.authentication.ALInfoModel;
    				var whetherSchool = alinfomodel.get('wheatherSchool');
    				var alGrid = $this.getPanelResourceBookingFormLayout().down('#academyLocationListGrid');
    				var grid2 = $this.getPanelResourceBookingFormLayout().down('#userSelectedGrid');
    				var grid1 = $this.getPanelResourceBookingFormLayout().down('#userListGrid');
    				var store1 = grid1.getStore();
    				var store2 = grid2.getStore();
    				
    			//	if(grid1.getCode() != 1) {
    					if(purpose==getCommonTranslation('MEETING')) {
    						
    						if(newCard.title == getCommonTranslation('USER_TABTITLE')) {
    							if(!isNullOrEmpty(committee.getValue())){
    	    						var currentAcademyLocation = this.getCurrentAcademyLocation();
    								grid1.setCode(1);
        							//store2.removeAll();
        							//store2.loadData([]);
        							//store2.getProxy().api.read = SERVERURL.COMMITTEE_FIND_ALL_PARTICIPANT+"?committeeId="+committee.getValue();
        							//store2.getProxy().method= 'POST';
        							store1.getProxy().method= 'POST';
        							store1.getProxy().api.read = SERVERURL.COMMITTEE_FIND_ALL_PARTICIPANT+"?committeeId="+committee.getValue();
        							store1.removeAll();
        							//store1.loadData([]);
        							
        							store1.sorters.clear();
        							if(grid1 && grid1.body){
            							grid1.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
            						}
            						store1.load({
            							callback:function(records, operation, success){
            								if(store2.data.length>0){
            									store2.data.items.forEach(function(obj){
            										store1.removeAt(store1.find('id', obj.data.id))
            									});
            								}
            								if(grid1.down('#totalRecordDisplayField')){
              								  grid1.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store1.getCount());
              								}
            								if(grid1 && grid1.body){
            									grid1.body.unmask();
            								}
            							}
            						});
    							}
    						}
    						var grid4 = $this.getPanelResourceBookingFormLayout().down('#facultySelectedgrid');
		    				var grid3 = $this.getPanelResourceBookingFormLayout().down('#facultyListgrid');
		    				var store3 = grid3.getStore();
		    				var store4 = grid4.getStore();
		    				
		    				store3.getProxy().actionMethods.read = 'POST';
		    				store3.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_LIST_FACULTY;
		    				store3.removeAll();
		    				store3.loadData([]);
		    				store3.getProxy().extraParams = {
    							whetherFaculty: true,
		    					academyLocationId:this.getCurrentAcademyLocation(),
		    					eventDate:eventDate,
		    					timeFrom:timeFrom,
		    					timeTo:timeTo
		    					
		    				};
		    				store3.sorters.clear();
		    				store3.load(); 
		    				
    					} else {
    						if(newCard.title == getCommonTranslation('USER_TABTITLE')) {
    						/*store2.removeAll();
    						store2.loadData([]);
    						store2.getProxy().actionMethods.read = 'POST';
    						store2.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_LIST_USER;
    						store2.load();*/
    						var alGridSel= alGrid.getSelectionModel().getSelection();
    						var alids=[];
    						var currentAcademyLocation = this.getCurrentAcademyLocation();
    						if(alGridSel.length>0){
    							for (var i in alGridSel) {
                					alids.push(alGridSel[i].data.id);
                				}
    							
    							currentAcademyLocation = null;
    						}
    						store1.getProxy().actionMethods.read = 'POST';
    						store1.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_LIST_USER;
    						store1.removeAll();
    						store1.loadData([]);
    						store1.getProxy().extraParams = {
    							whetherFaculty: false,
		    					academyLocationId:currentAcademyLocation,
		    					academyLocationIds:alids.join(),
		    					eventDate:eventDate,
		    					timeFrom:timeFrom,
		    					timeTo:timeTo
		    					
		    				};
    						store1.sorters.clear();
    						if(grid1 && grid1.body){
    							grid1.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    						}
    						store1.load({
    							callback:function(records, operation, success){
    								if(store2.data.length>0){
    									store2.data.items.forEach(function(obj){
    										store1.removeAt(store1.find('id', obj.data.id))
    									});
    								}
    								if(grid1.down('#totalRecordDisplayField')){
    								  grid1.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store1.getCount());
    								}
    								if(grid1 && grid1.body){
    									grid1.body.unmask();
    								}
    							}
    						});
    					}
    						
    						else if(newCard.getItemId() == 'facultyPanel') {
    							
    							var alGridSel= alGrid.getSelectionModel().getSelection();
        						var alids=[];
        						var currentAcademyLocation = this.getCurrentAcademyLocation();
        						if(alGridSel.length>0){
        							for (var i in alGridSel) {
                    					alids.push(alGridSel[i].data.id);
                    				}
        							
        							currentAcademyLocation = null;
        						}
        						
    							var grid4 = $this.getPanelResourceBookingFormLayout().down('#facultySelectedgrid');
    		    				var grid3 = $this.getPanelResourceBookingFormLayout().down('#facultyListgrid');
    		    				var store3 = grid3.getStore();
    		    				var store4 = grid4.getStore();
    		    				
    		    				store3.getProxy().actionMethods.read = 'POST';
    		    				store3.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_LIST_FACULTY;
    		    				store3.removeAll();
    		    				store3.loadData([]);
    		    				store3.getProxy().extraParams = {
        							whetherFaculty: true,
    		    					academyLocationId:currentAcademyLocation,
    		    					academyLocationIds:alids.join(),
    		    					eventDate:eventDate,
    		    					timeFrom:timeFrom,
    		    					timeTo:timeTo,
    		    					limit:-1
    		    					
    		    				};
    		    				store3.sorters.clear();
    		    				if(grid3 && grid3.body){
    		    					grid3.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    		    				}
    		    				store3.load({
        							callback:function(records, operation, success){
        								if(store4.data.length>0){
        									store4.data.items.forEach(function(obj){
        										store3.removeAt(store3.find('id', obj.data.id))
        									});
        								}
        								if(grid3.down('#totalRecordDisplayField')){
        									grid3.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ store3.getCount());
          								}
        								if(grid3 && grid3.body){
        									grid3.body.unmask();
        								}
        							}
        						});
    						}
    						else if(newCard.getItemId() == 'programPanel') {
    							var alGridSel= alGrid.getSelectionModel().getSelection();
        						var alids=[];
        						var currentAcademyLocation = this.getCurrentAcademyLocation();
        						if(alGridSel.length>0){
        							for (var i in alGridSel) {
                    					alids.push(alGridSel[i].data.id);
                    				}
        							
        							currentAcademyLocation = null;
        						}
        						
    							var programSelectedGrid = $this.getPanelResourceBookingFormLayout().down('#programSelectedGrid');
    		    				var programListGrid = $this.getPanelResourceBookingFormLayout().down('#programListGrid');
    		    				var programListGridStore = programListGrid.getStore();
    		    				var programSelectedGridStore = programSelectedGrid.getStore();
    		    				programListGridStore.getProxy().actionMethods.read = 'GET';
    		    				programListGridStore.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_PROGRAM_LIST;
    		    				programListGridStore.removeAll();
    		    				programListGridStore.loadData([]);
    		    				
    		    				var cmbProgram = programListGrid.down('#cmbProgram');
    		    				var cmbBatch = programListGrid.down('#cmbBatch');
    		    				var cmbPeriod = programListGrid.down('#cmbPeriod');
    		    				var cmbSection = programListGrid.down('#cmbSection');
    		    				cmbProgram.reset();
    		    				cmbPeriod.reset();
    		    				cmbSection.reset();
    		    				cmbBatch.setDisabled(true);
    		    				cmbPeriod.setDisabled(true);
    		    				cmbSection.setDisabled(true);
    		    				if(whetherSchool){
    		    					cmbPeriod.setVisible(false);
    		    				}

    		    				var academicTerm=programListGrid.down('#academicTerm');
    		    				if(programListGrid && programListGrid.body){
    		    					programListGrid.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    		    				}
    	                		academicTerm.getStore().load({
    	                			callback:function(records, operation, success){
    	                				var recVal = academicTerm.getStore().findRecord('whetherCurrentAcademicTerm',true);
    	                				academicTerm.setValue(recVal);
    	                				var id;
    	                				if(!isNullOrEmpty(recVal)){
    	                				   id = recVal.data.id;
    	                				}else{
    	                					 id = null;
    	                				}
    	                				cmbProgram.getStore().getProxy().extraParams = {
    	    		    					academyLocationId:currentAcademyLocation,
    	    		    					academyLocationIds:alids.join(),
    	    		    					academicTermId:id
    	    		    				};
    	    		    				cmbProgram.getStore().load();
    	    		    				
    	    		    				programListGridStore.getProxy().extraParams = {
    	    		    					academyLocationId:currentAcademyLocation,
    	    		    					academyLocationIds:alids.join(),
    	    		    					academicTermId:id,
    	    		    					isAccesibleProgram:true
    	    		    				};
    	    		    				programListGridStore.sorters.clear();
    	    		    				programListGridStore.load({
    	    		    						callback:function(records, operation, success){
    	    		    							if(programSelectedGridStore.data.length>0){
    	    		    								programSelectedGridStore.data.items.forEach(function(obj){
    	    		    									var index = programListGridStore.findBy(function(record) {
        	    		    								    return record.get('program') && record.get('program').id === obj.data.program.id;
        	    		    								});
        	    		    								if (index !== -1) {
        	    		    								    var record = programListGridStore.getAt(index);
        	    		    								    programListGridStore.remove(record);
        	    		    								}
    	    	    									});
    	    	    								}
    	    		    							if(programListGrid.down('#totalRecordDisplayField')){
    	    		    								programListGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ programListGridStore.getCount());
    	    		    							}
    	    		    							if(programListGrid && programListGrid.body){
    	    		    								programListGrid.body.unmask();
    	    		    							}
    	    		    						}
    	    		    				});
    	    		    				cmbBatch.reset();
    	                			}
    	                		})
    	                		
    						}
    						else if(newCard.getItemId() == 'coursePanel'){
    							var alGridSel= alGrid.getSelectionModel().getSelection();
        						var alids=[];
        						var currentAcademyLocation = this.getCurrentAcademyLocation();
        						if(alGridSel.length>0){
        							for (var i in alGridSel) {
                    					alids.push(alGridSel[i].data.id);
                    				}
        							
        							currentAcademyLocation = null;
        						}
        						
    							var courseSelectedGrid = $this.getPanelResourceBookingFormLayout().down('#courseSelectedGrid');
    		    				var courseListGrid = $this.getPanelResourceBookingFormLayout().down('#courseListGrid');
    		    				var courseListGridStore = courseListGrid.getStore();
    		    				var courseSelectedGridStore = courseSelectedGrid.getStore();
    		    				
    		    				courseListGridStore.getProxy().actionMethods.read = 'GET';
    		    				courseListGridStore.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_COURSES_LIST;
    		    				courseListGridStore.removeAll();
    		    				courseListGridStore.loadData([]);
    		    				courseListGridStore.getProxy().extraParams = {
    		    					academyLocationId:currentAcademyLocation,
    		    					academyLocationIds:alids.join()    		    					
    		    				};
    		    				courseListGridStore.sorters.clear();
    		    				if(courseListGrid && courseListGrid.body){
    		    					courseListGrid.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    		    				}
    		    				courseListGridStore.load({
        							callback:function(records, operation, success){
        								if(courseSelectedGridStore.data.length>0){
        									courseSelectedGridStore.data.items.forEach(function(obj){
        										courseListGridStore.removeAt(courseListGridStore.find('id', obj.data.id))
        									});
        								}
        								if(courseListGrid.down('#totalRecordDisplayField')){
        									courseListGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ courseListGridStore.getCount());
		    							}
        								if(courseListGrid && courseListGrid.body){
        									courseListGrid.body.unmask();
        								}
        							}
        						});
    						}else if(newCard.getItemId() == 'equipmentsTabPanel'){
        						var currentAcademyLocation = this.getCurrentAcademyLocation();
    							var equipmentSelectedGrid = $this.getPanelResourceBookingFormLayout().down('#equipmentSelectedGrid');
    		    				var equipmentListGrid = $this.getPanelResourceBookingFormLayout().down('#equipmentListGrid');
    		    				var equipmentListGridStore = equipmentListGrid.getStore();
    		    				var equipmentSelectedGridStore = equipmentSelectedGrid.getStore();
    		    				
    		    				equipmentListGridStore.removeAll();
    		    				equipmentListGridStore.loadData([]);
    		    				equipmentListGridStore.getProxy().extraParams = {
    		    					academyLocationId:currentAcademyLocation,
    		    					eventDate:eventDate,
    		    					isCompleteDay: isCompleteDay,
    		    					limit:-1
    		    				};
    		    				equipmentListGridStore.sorters.clear();
    		    				if(equipmentListGrid && equipmentListGrid.body){
    		    					equipmentListGrid.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    		    				}
    		    				equipmentListGridStore.load({
        							callback:function(records, operation, success){
        								if(equipmentSelectedGridStore.data.length>0){
        									equipmentSelectedGridStore.data.items.forEach(function(obj){
        										equipmentListGridStore.removeAt(equipmentListGridStore.find('id', obj.data.id))
        									});
        								}
        								if(equipmentListGrid.down('#totalRecordDisplayField')){
        									equipmentListGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ equipmentListGridStore.getCount());
		    							}
        								if(equipmentListGrid && equipmentListGrid.body){
        									equipmentListGrid.body.unmask();
        								}
        							}
        						});
    						}else if(newCard.getItemId() =='externalResourceTabPanel'){
        						var currentAcademyLocation = this.getCurrentAcademyLocation();
    							var externalResourceSelectedGrid = $this.getPanelResourceBookingFormLayout().down('#externalResourceSelectedGrid');
    		    				var externalResourceListGrid = $this.getPanelResourceBookingFormLayout().down('#externalResourceListGrid');
    		    				var externalResourceListGridStore = externalResourceListGrid.getStore();
    		    				var externalResourceSelectedGridStore = externalResourceSelectedGrid.getStore();
    		    				
    		    				externalResourceListGridStore.removeAll();
    		    				externalResourceListGridStore.loadData([]);
    		    				externalResourceListGridStore.getProxy().extraParams = {
    		    					academyLocationId:currentAcademyLocation,
    		    					eventDate:eventDate,
    		    					isCompleteDay: isCompleteDay,
    		    					limit:-1
    		    				};
    		    				externalResourceListGridStore.sorters.clear();
    		    				if(externalResourceListGrid && externalResourceListGrid.body){
    		    					externalResourceListGrid.body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading', {fixed: true});
    		    				}
    		    				externalResourceListGridStore.load({
        							callback:function(records, operation, success){
        								if(externalResourceSelectedGridStore.data.length>0){
        									externalResourceSelectedGridStore.data.items.forEach(function(obj){
        										externalResourceListGridStore.removeAt(externalResourceListGridStore.find('id', obj.data.id))
        									});
        								}
        								if(externalResourceListGrid.down('#totalRecordDisplayField')){
        									externalResourceListGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ externalResourceListGridStore.getCount());
		    							}
        								if(externalResourceListGrid && externalResourceListGrid.body){
        									externalResourceListGrid.body.unmask();
        								}
        							}
        						});
    						
    						}
    				}
    			}
    		},    		
            'resourcebookingformlayout combo[itemId=committeeItemId]': {
            	select: function(combo, records, eOpts){
            		var $this = this;
            		var form = $this.getPanelResourceBookingFormLayout().getForm();
            		var bookedBy = form.findField('bookedBy');
            		var numOfParticipants = $this.getPanelResourceBookingFormLayout().down('#numOfParticipants');
            		var committeeStore = $this.getStore('committee.committee.CommitteeGridStore');
            		var store = $this.getStore('user.UserAcademyLocationStore');
            		var alids=[];
            		store.getProxy().extraParams={
            			id:$this.getCurrentlyLoggedInUser().id
            		};
            		store.load({
            			callback:function(record) {
            				for (var i in record) {
            					alids.push(record[i].data.id);
            				}
            				committeeStore.getProxy().extraParams= {
            					committeeId:records[0].data.id,
            					isActive:true,
            					academyLocationIds :alids.join()
            				};
            				committeeStore.load({
            					callback:function(rec) {
            						numOfParticipants.setValue(rec[0].data.committeeParticipants.length);
            						bookedBy.getStore().getProxy().actionMethods.read='GET';
            						bookedBy.getStore().load({
            							callback:function(records) {
            								bookedBy.setValue(rec[0].data.committeeCoordinatorId);
            								bookedBy.setReadOnly(true);
            							}
            						});
            					}
            				});
            			}
            		});
            	}
            },
            
            'meetingdocumentgrid[itemId=documentsGridResourceBooking]': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getMeetingdocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                    e.preventDefault();
                    e.stopPropagation();
                }
            },
            
            'resourcebookingformlayout combo[itemId=cmbBookingPurpose]': {
                render: function(component, options) {
                	component.getStore().load();
                	var $this = this;
                	$this.populateFormData(component);
                },
                select: function(combo, records, eOpts){
                	this.selectBookingPurpose(combo, records, eOpts);      
                	var $this = this;
                	var purpose = combo.getRawValue();
                	 var activeTab = $this.getActiveTabfromContentPanel();
                	var form = activeTab.down('form').getForm();
                	//var form = $this.getPanelResourceBookingFormLayout().getForm();
                	var frmResourceBooking = $this.getFormComponent();
                	var committee = form.findField('committee');
                	var bookedBy = form.findField('bookedBy');
                	var isMendatory  = form.findField('isMendatory');
                	var eventDesc   = form.findField('eventDesc');
                	var purposeDesc = form.findField('purposeDesc');
                	var documentsGrid = $this.getPanelResourceBookingFormLayout().down('#documentsGridResourceBooking');
                	var meetingDocs = $this.getPanelResourceBookingFormLayout().down('#meetingDocsId');
                	var academyLocationListGrid = $this.getPanelResourceBookingFormLayout().down('#academyLocationListGrid');
                	if(purpose==getCommonTranslation('MEETING')) {
                		//documentsGrid.setVisible(true);
                		var store = $this.getStore('user.UserAcademyLocationStore');
                		var alids=[];
                		store.getProxy().extraParams={
                			id:$this.getCurrentlyLoggedInUser().id
                		}
                		var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: false, isCource: false, isAcademyLocation: true
                		};
                		this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                		store.load({
                			callback:function(record) {
                				for (var i in record) {
                					alids.push(record[i].data.id);
                				}
                				if(!isNullOrEmpty(committee.getStore())){
                					committee.getStore().getProxy().extraParams={
                    					academyLocationIds:alids.join()
                    				};
                    				committee.getStore().load();
                				}
                			}
                		});
                		committee.setVisible(true);
                		committee.allowBlank=false;
                		isMendatory.setVisible(false);
                		//eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA')+"<span style='color:red'>*</span>");
                		eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA'));
                		$this.setAllowBlank(eventDesc, false);
                		committee.reset();
                		purposeDesc.setVisible(false);
                		eventDesc.setWidth(256);
                		eventDesc.clearInvalid();
                		academyLocationListGrid.getSelectionModel().deselectAll();
                		//meetingDocs.setVisible(true);
                	} else {
                		//meetingDocs.setVisible(false);
                		//documentsGrid.setVisible(false);
                		//eventDesc.setFieldLabel(getCommonTranslation('EVENT_DESC')+"<span style='color:red'>*</span>");
                		eventDesc.setFieldLabel(getCommonTranslation('EVENT_DESC'));
                		$this.setAllowBlank(eventDesc, false);
                		committee.setVisible(false);
                		committee.allowBlank=true;
                		bookedBy.setReadOnly(false);
                		isMendatory.setVisible(true);
                		purposeDesc.setVisible(true);
                		eventDesc.setWidth(256);
                		eventDesc.clearInvalid();
                		if(academyLocationListGrid.getSelectionModel().getCount()>0){
                		  academyLocationListGrid.getSelectionModel().deselectAll();
                		}
                		//bookedBy.reset();
                	}
                	/*var selectedFacilitiesPanelStore = $this.getPanelResourceBookingFormLayout().down('#selectedFacilitiesPanel').getStore();
                	selectedFacilitiesPanelStore.removeAll();*/
                }
            },
            
            /*'resourcebookingformlayout combo[itemId=cmbconductedBy]': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },*/
            
            'resourcebookingformlayout textfield[itemId=txtName]': {            	
                change: function(txt, newValue, oldValue, eOpts) {
                	if(newValue.length>=3 || newValue.length==0){ //At least enter allowed three characters for search
                		var parentComponent = txt.up().up();                    
                        if (parentComponent) {       
                            var frmResourceBooking = this.getFormComponent();    
                            var params = this.createLoadingCriteria(parentComponent);
                            this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);
                        }
                	}                    
                }
            },
            
            'resourcebookingformlayout combo[itemId=cmbResourceGroup]': {
            	render : function(combo, options) {
            		var parentComponent = combo.up().up();
            		if (parentComponent.itemId == 'resourcebookingfacilitytree') { 
            			combo.setValue('FACILITY');
            			combo.setReadOnly(true);
            		}else{
            			combo.setReadOnly(false);
            		}
            		//combo.setReadOnly(true);
                },  
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();                    
                    if (parentComponent) {                    	
                    	var dependentCombo = parentComponent.down('#cmbResourceType');
                    	dependentCombo.reset();
                    	var resourceGroupParam=new Object();
                        if(!isNullOrEmpty(combo.getValue())){
                        	resourceGroupParam.resourceGroup=combo.getValue();
                        }
                        dependentCombo.getStore().load({
                            params: {
                            	resourceGroup: resourceGroupParam
                            }
                        });
                        
                        var params = this.createLoadingCriteria(parentComponent);
                        var frmResourceBooking = this.getFormComponent();
                        this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);
                    }
                }
            },
            
            'resourcebookingformlayout combo[itemId=cmbResourceType]': {
            	render: function(combo, options) {
            		var this$ = this;
            		var parentComponent = combo.up().up();                      
                    if (parentComponent) {                    	
                    	var cmbResourceGroup = parentComponent.down('#cmbResourceGroup');
                    	var resourceGroupParam=new Object();
                        if(cmbResourceGroup && !isNullOrEmpty(cmbResourceGroup.getValue())){
                        	resourceGroupParam.resourceGroup=cmbResourceGroup.getValue();
                        }else{
                        	resourceGroupParam.resourceGroup='EQUIPMENT';
                        }	
                        combo.getStore().load({
                        	params: {
                            	resourceGroup: resourceGroupParam
                            }
                        });
                    }
                },                
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                    	var params = this.createLoadingCriteria(parentComponent);
                    	var frmResourceBooking = this.getFormComponent();
                    	this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);                                               
                    }
                }
            },
            'resourcebookingformlayout combo[itemId=cmbDepartment]': {
            	render: function(component, options) {
                    component.getStore().load();
                },  
            	select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();                    
                    if (parentComponent) {                    	
                    	var dependentCombo = parentComponent.down('#cmbSubDepartment');
                    	dependentCombo.reset();
                    	dependentCombo.getStore().load({
                            params: {
                            	parentId: combo.getValue()
                            }
                        });
                    	var params = this.createLoadingCriteria(parentComponent);
                        var frmResourceBooking = this.getFormComponent();                        
                        this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);                                                                                                                                            
                    }
                }
            },
            
            'resourcebookingformlayout combo[itemId=cmbSubDepartment]': {
            	render: function(component, options) {
                    component.getStore().load();
                },                
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                    	var frmResourceBooking = this.getFormComponent();                        
                    	var params = this.createLoadingCriteria(parentComponent);
                    	this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);                                                
                    }
                }
            },
            
            'resourcebookingformlayout datefield[itemId=eventDate]': {
                select: function(field, value, eOpts) {
                    var frmResourceBooking = this.getFormComponent();
                    var chkRecurring = frmResourceBooking.down('#chkRecurring');
                	if(!chkRecurring.getValue()){
                		frmResourceBooking.down('#toDate').reset();
                	}
                    frmResourceBooking.down('#timeFrom').reset();
                    frmResourceBooking.down('#timeTo').reset();
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: false, isCource: false, isAcademyLocation: false
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                	
                }
            },
            'resourcebookingformlayout datefield[itemId=toDate]': {
                select: function(field, value, eOpts) {
                    var frmResourceBooking = this.getFormComponent();
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: false, isCource: false, isAcademyLocation: false
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                }
            },
            'resourcebookingformlayout timefield[itemId=timeFrom]': {
                select: function(combo, records, eOpts) {
                    var frmResourceBooking = this.getFormComponent();
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: false, isCource: false, isAcademyLocation: false
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                }
            },
            'resourcebookingformlayout timefield[itemId=timeTo]': {
                select: function(combo, records, eOpts) {
                    var frmResourceBooking = this.getFormComponent();
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: false, isCource: false, isAcademyLocation: false
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                }
            },
            'resourcebookingformlayout checkbox[itemId=chkRecurring]': {
                change: function(cmp, currentValue, oldValue, eOpts) {
                	var frmResourceBooking = this.getFormComponent();
                    var toDateField = frmResourceBooking.down('#toDate'),
                    repeatOnElm = frmResourceBooking.down('#repeatOnItemId');        
                    if (currentValue == true) {            
                    	toDateField.setDisabled(false);
                    	this.setAllowBlank(repeatOnElm,false);
                    	repeatOnElm.show();
                    } else {
                    	//toDateField.reset();
                    	if(frmResourceBooking.title == getCommonTranslation('ADD_NEW_EVENT_DETAILS')){
                    		toDateField.reset();
                    		repeatOnElm.reset();
                    	}
                    	toDateField.setDisabled(true);
                    	repeatOnElm.hide();
                    	this.setAllowBlank(repeatOnElm,true);
                    }
                    Ext.defer(function() {
                    	frmResourceBooking.isValid();	
                    },200);
                }
            },
            'resourcebookingformlayout resourcebookingprogramgrid combo[itemId=cmbProgram]': {
                render: function(combo, options) {
                	var me=this;
                	var academyLocationId=me.getCurrentAcademyLocation();
                	if(!isNullOrEmpty(academyLocationId)){
                		/*combo.getStore().load({
                    		params:{
                    			academyLocationId:academyLocationId
                    		},
        					callback: function(records, operation, success) {                            
        						var model = new Academia.model.common.IdValueDataModel();
        		                model.set('id','');
        		                model.set('value', 'All');
        		                combo.getStore().insert(0,model);
        		            }
                    	});*/
                	}                       	
                },
                select:function(programCombo,record){
                	var me=this;
                	var frmResourceBooking=this.getFormComponent();                	
                	var programListGrid=frmResourceBooking.down('#programListGrid');
                	var cmbBatch = programListGrid.down('#cmbBatch');
    				var cmbPeriod = programListGrid.down('#cmbPeriod');
    				var cmbSection = programListGrid.down('#cmbSection');
    				cmbPeriod.reset();
            		cmbPeriod.setDisabled(true);
            		cmbSection.reset();
            		cmbSection.setDisabled(true);
            		cmbBatch.reset();
            		var params = this.createLoadingCriteria(programListGrid);
                	this.loadSpecificResourceBookingTab(frmResourceBooking, 'programListGrid', params);
                	var academicTerm = programListGrid.down('#academicTerm');
            		var param=new Object();
            		param.id=programCombo.getValue();
            		param.academicTermId=academicTerm.getValue();
            		me.enableDisableCombo(programCombo,frmResourceBooking,'#cmbBatch',param);
            		
                }
            },
            'resourcebookingformlayout resourcebookingprogramgrid combo[itemId=academicTerm]': {
            	select:function(combo,record){
                	var me=this;
                	var frmResourceBooking=this.getFormComponent();                	
                	var programListGrid=frmResourceBooking.down('#programListGrid');
                	var alGrid = frmResourceBooking.down('#academyLocationListGrid');

					var alGridSel= alGrid.getSelectionModel().getSelection();
					var alids=[];
					var currentAcademyLocation = this.getCurrentAcademyLocation();
					if(alGridSel.length>0){
						for (var i in alGridSel) {
        					alids.push(alGridSel[i].data.id);
        				}
						currentAcademyLocation = null;
					}
					
    				var programListGridStore = programListGrid.getStore();
    				programListGridStore.getProxy().actionMethods.read = 'GET';
    				programListGridStore.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_PROGRAM_LIST;
    				programListGridStore.removeAll();
    				programListGridStore.loadData([]);
    				
    				var cmbProgram = programListGrid.down('#cmbProgram');
    				var cmbBatch = programListGrid.down('#cmbBatch');
    				var cmbPeriod = programListGrid.down('#cmbPeriod');
    				var cmbSection = programListGrid.down('#cmbSection');
    				cmbProgram.reset();
    				cmbProgram.getStore().getProxy().extraParams = {
    					academyLocationId:currentAcademyLocation,
    					academyLocationIds:alids.join(),
    					academicTermId:combo.getValue()
    				};
    				cmbProgram.getStore().load({
    					callback: function(records, operation, success) {                            
    						if(records.length == 1){
    							cmbProgram.setValue(records[0].data.id);
    							cmbBatch.setDisabled(false);
    							cmbBatch.reset();
    							cmbBatch.getStore().getProxy().extraParams = {
    								id:cmbProgram.getValue(),
        		            		academicTermId:combo.getValue()
    							}
    							cmbBatch.getStore().load({
    								callback: function(records1, operation, success) {
    									if(records1.length == 1){
    										cmbBatch.setValue(records1[0].data.id);
    										cmbPeriod.getStore().getProxy().extraParams = {
    		    								id:cmbBatch.getValue(),
    		        		            		academicTermId:combo.getValue()
    		    							}
    										cmbPeriod.getStore().load({
    											callback: function(records2, operation, success) {
    												if(records2.length == 1){
    													var alinfomodel = Academia.model.authentication.ALInfoModel;
        	    										var whetherSchool = alinfomodel.get('wheatherSchool');
        	    										if(whetherSchool){
        	    											cmbSection.setDisabled(false);
        	    											cmbSection.reset();
        	    											cmbSection.getStore().getProxy().extraParams = {
        	    												periodId:records2[0].data.id,
        	    												academicTermId:combo.getValue()
        	    											};
        	    											cmbSection.getStore().load();
        	    										}
        	    										else{
        	    											cmbPeriod.setValue(records2[0].data.id);
        	    											cmbPeriod.setDisabled(false);
        													cmbSection.getStore().getProxy().extraParams = {
        														periodId:records2[0].data.id,
        					    								academicTermId:combo.getValue()
        													};
        													cmbSection.getStore().load({
        														callback: function(records3, operation, success) {
        															if(records3.length == 1){
        																cmbSection.setValue(records3[0].data.id);
        															}
        															cmbSection.setDisabled(false);
                													cmbSection.reset();
        														}
        													});
        	    										}
    												}
    												else{
    													cmbPeriod.setDisabled(false);
    													cmbPeriod.reset();
    													cmbSection.setDisabled(false);
    	    											cmbSection.reset();
    												}
    											}
    										});
    									}
    								}
    							})
    						}
    		            }
    				});
    				
    				programListGridStore.getProxy().extraParams = {
    					academyLocationId:currentAcademyLocation,
    					academyLocationIds:alids.join(),
    					academicTermId:combo.getValue(),
    					isAccesibleProgram:true
    				};
    				programListGridStore.sorters.clear();
    				programListGridStore.load();
    				cmbBatch.reset();
    				cmbBatch.setDisabled(true);
    				cmbPeriod.reset();
    				cmbPeriod.setDisabled(true);
    				cmbSection.reset();
    				cmbSection.setDisabled(true);
                }
            },
            
            
            'resourcebookingformlayout resourcebookingprogramgrid combo[itemId=cmbBatch]': {
            	select:function(batchCombo,record){
                	var me=this;
                	var frmResourceBooking=this.getFormComponent();                	
                	var programListGrid=frmResourceBooking.down('#programListGrid');
                	var cmbPeriod = programListGrid.down('#cmbPeriod');
    				var cmbSection = programListGrid.down('#cmbSection');
    				cmbSection.reset();
    				cmbSection.setDisabled(true);
    				cmbPeriod.reset();
            		var params = this.createLoadingCriteria(programListGrid);
                	this.loadSpecificResourceBookingTab(frmResourceBooking, 'programListGrid', params);    
                	var academicTerm = programListGrid.down('#academicTerm');
                	var param=new Object();
            		param.id=batchCombo.getValue();
            		param.academicTermId=academicTerm.getValue();
            		me.enableDisableCombo(batchCombo,frmResourceBooking,'#cmbPeriod',param);
            		var alinfomodel = Academia.model.authentication.ALInfoModel;
					var whetherSchool = alinfomodel.get('wheatherSchool');
					if(whetherSchool){
						cmbSection.setDisabled(false);
					}
                }
            },
            'resourcebookingformlayout resourcebookingprogramgrid combo[itemId=cmbPeriod]': {
            	select:function(periodCombo,record){
                	var me=this;
                	var frmResourceBooking=this.getFormComponent();                	
                	var programListGrid=frmResourceBooking.down('#programListGrid');
    				var cmbSection = programListGrid.down('#cmbSection');
    				cmbSection.reset();
    				cmbSection.setDisabled(false);
            		var params = this.createLoadingCriteria(programListGrid);
                	this.loadSpecificResourceBookingTab(frmResourceBooking, 'programListGrid', params);                	
                	var academicTerm = programListGrid.down('#academicTerm');
                	var param=new Object();
            		param.periodId=periodCombo.getValue();
            		param.academicTermId=academicTerm.getValue();
            		me.enableDisableCombo(periodCombo,frmResourceBooking,'#cmbSection',param);
                }
            },
            'resourcebookingformlayout resourcebookingprogramgrid combo[itemId=cmbSection]': {
            	select:function(periodCombo,record){
                	var me=this;
                	var frmResourceBooking=this.getFormComponent();                	
                	var programListGrid=frmResourceBooking.down('#programListGrid');
            		var params = this.createLoadingCriteria(programListGrid);
                	this.loadSpecificResourceBookingTab(frmResourceBooking, 'programListGrid', params);                	
                }
            },
            'resourcebooking':{
	        	afterrender : function(structure){
	        		var panel = structure.items.items[0];
	        		var grid = panel.down('#resourceBookingGrid');
	        	    this.getCBGridHeaderFreeze(grid,panel);
	        	}
    		},
    		'assigncalendarwin button[itemId=saveBtn]':{
    			click:function(){
    				this.saveAssignCalendarDetails();
    			}
    		},
    		'assigncalendarwin button[itemId=cancelBtn]':{
    			click:function(){
    				this.getAssigncalendarwin().close();
    			}
    		},
    		
    		'meetingdocumentgrid[itemId=documentsGridResourceBooking] button[itemId=btnDelete]':{
    			click:function(){
    				var $this = this;
    				var grid = $this
    				.getMeetingdocumentgrid();
    				if (grid.getSelectionModel()
    						.getCount() > 0) {
    					
    					showConfirmMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    		                if (btn == 'yes') {
    		                	if (grid.getSelectionModel().getCount() > 0) {
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									var records = grid
									.getSelectionModel()
									.getSelection();
									var id = records[0]
									.get("documentId");
									if(!isNullOrEmpty(id)){
										Ext.Ajax
    									.request({
    										method : "DELETE",
    										type : 'rest',
    										url : SERVERURL.PATH_DELETE_COMMITTEE_DOCS
    										+ '?documentId='
    										+ id,
    										headers : {
    											'Content-Type' : 'application/json'
    										},
    										success : function(
    												form,
    												action) {
    											Ext.getBody().unmask();
    											grid
    											.getStore()
    											.reload();
    											showSuccessMessage(
    													getCommonTranslation('DOCMENT_NAME'),
    													getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
    											$this.getMeetingdocumentgrid().getStore().reload();
//    											$this.getQuestionpaperbankgrid().getSelectionModel().deselectAll();
    										}
    									});
									}
									else{
										grid.getStore().remove(records);
										Ext.getBody().unmask();
										showSuccessMessage(
												getCommonTranslation('DOCMENT_NAME'),
												getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
									}
									
								}
    		                }
    		            });
    				} else {
    					showWarningMessage(
    							getCommonTranslation('DOCMENT_NAME'),
    							getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'resourcebookingformlayout photouploadform[itemId=eventBannerItemId] filefield[itemId=photoFileImage]':{
    			change: function(photoFileImage, value, eOpts) {
    				var $this = this;
    				value = value.replace('C:\\fakepath\\', '');
    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    				photoFileImage.setRawValue(newValue);

    				if (!isNullOrEmpty(newValue)) {
    					var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    					if (extension == "gif" || extension == "png" || extension == "bmp"
    						|| extension == "jpeg" || extension == "jpg") {
    						var file = photoFileImage.fileInputEl.dom.files[0];
    						if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
    							photoFileImage.reset();
    							showWarningMessage(getCommonTranslation('EVENT_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
    							return false;
    						}
    					} else {
    						photoFileImage.reset();
    						showWarningMessage(getCommonTranslation('EVENT_DETAILS'), getServiceRequestTranslation('EVENT_DETAILS_VALID_FILE'));
    						return false;
    					}
    				}

    				var formPnl = $this.getPanelResourceBookingFormLayout();
    				var eventBannerBgImage = formPnl.down('#eventBannerBgImage');

    				var file = photoFileImage.fileInputEl.dom.files[0];
    				var reader = new FileReader();
    				reader.addEventListener('load', function(evt) {
    					eventBannerBgImage.setSrc(evt.target.result);
    				});
    				reader.readAsDataURL(file);
    				//formPnl.down('#eventBannerURLItemId').setValue(null);
    			}
            },
            'resourcebookinglistsearchform combo#eventIdItemId': {
				render: function(obj) {
					var store = obj.getStore();
                    var portalId = this.getCurrentLoggedPortalId();
					store.getProxy().extraParams = {
						portalId: portalId
					};
				}
			},
			  'resourcebooking searchresultgrid[itemId=resourceBookingGrid] #spBtnResourceBookingMoreActions menuitem[itemId=markEventAttendanceItemId]': {
	                click: this.resourceMarkEventAttendanceMenuClicked
	            },
	            'markeventattendancegrid datefield[itemId=EventAttendanceDate]':{
	            	select:function(obj){
	            		var grid = this.getMarkeventattendancegrid();
	            	//	me.getResourceBookingGrid();
	            		var submitBtn = grid.down('#submitBtn');
	            		var userType = grid.down('#userTypeEventAttend').getValue();
	            		if(isNullOrEmpty(userType)){
	            		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_USER_TYPE'));
	            		}else{
	            			var manageEventGrid = this.getResourceBookingGrid();
		            	    var records = manageEventGrid.getSelectionModel().getSelection()[0];
		            		var store = grid.getStore();
		            		var fromDate = Ext.Date.format(new Date(obj.getValue()), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
		            		store.getProxy().extraParams={
		            			resourceBookingId: records.data.ID,
		            			fromDate:fromDate,
		            			userType:userType
		            		};
		            		store.load();
		            		submitBtn.setDisabled(false);
	            		}
	            		
	            	}
	            },
	        	'markeventattendancegrid checkcolumn':{
					checkchange:function(obj, rowIndex, checked, eOpts ){
						var this$ = this;
						var grid = this$.getMarkeventattendancegrid();
						var store = grid.getStore();
						var models = grid.getStore().getRange();
						if(checked){
							if(obj.text=='Absent'){
								for(var i =0; i<store.data.length;i++){
									if(rowIndex==i){
										models[rowIndex].set('present', false);
										Ext.defer(function() {
											models[rowIndex].set('attendanceStatus', null);
										}, 50, this);
										break;
									}
								}
							}
							if(obj.text=='Present'){
								for(var i =0; i<store.data.length;i++){
									if(rowIndex==i){
										models[rowIndex].set('absent', false);
										Ext.defer(function() {
											models[rowIndex].set('attendanceStatus', null);
										}, 50, this);
										break;
									}
								}
							}
						}else{
							if(obj.text=='Absent'){
								for(var i =0; i<store.data.length;i++){
									if(rowIndex==i){
										models[rowIndex].set('present', true);
										Ext.defer(function() {
											models[rowIndex].set('attendanceStatus', null);
										}, 50, this);
										break;
									}
								}
							}
							if(obj.text=='Present'){
								for(var i =0; i<store.data.length;i++){
									if(rowIndex==i){
										models[rowIndex].set('absent', true);
										Ext.defer(function() {
											models[rowIndex].set('attendanceStatus', null);
										}, 50, this);
										break;
									}
								}
							}
						}
					}
				},
				'markeventattendancegrid radiogroup[itemId=markAttendanceRadioId]': {
					change:function(obj,record){
						this.onChangeRadioButton(obj,record);
					}
				},
				'markeventattendancegrid button[itemId=submitBtn]':{
					click:function(){
						this.saveMakrAttendance();
					}
				},
				'markeventattendancegrid':{
					render: function(grid) {
						var manageEventGrid = this.getResourceBookingGrid();
	            	    var records = manageEventGrid.getSelectionModel().getSelection()[0];
						grid.setTitle(getCommonTranslation('EVENT_NAME')+' : '+records.data.EVENT_NAME);
					}
				},
				'markeventattendancegrid customcombobox#userTypeEventAttend':{
					 select:function(obj, record){
						 var grid = this.getMarkeventattendancegrid();
						 this.resetEventMarkAttendance();
						 grid.getStore().getProxy().extraParams={
    							
    						};
						 if(obj.getValue() == "student"){
							 grid.columns[0].show();
							 grid.columns[1].show();
							 grid.columns[2].hide(); 
							 grid.columns[3].hide();
							 grid.columns[4].hide();
						 }else{
							 grid.columns[0].hide();
							 grid.columns[1].hide();
							 grid.columns[2].show(); 
							 grid.columns[3].show();
							 grid.columns[4].show();
						 }
					 }
				},
	            //Alumni Code: Start
				'alumniresourcebookingformlayout button[itemId=gradeMasterResetButtonId]': {
	            	click: function() {
	            	    $this = this;
	            	    var formLayout = $this.getAlumniresourcebookingformlayout()
	            	    var grid = $this.getResourcebookingalumniavailablegrid();
	            	    var form = formLayout.getForm();
	            	    form.reset();
	            	    var gridStore = grid.getStore();
	                    if (gridStore) {
	                        gridStore.removeAll(); 
	                        gridStore.reload();    
	                    }
	            	    var bookingPurposeCombo = formLayout.down('#cmbBookingPurpose');
	            	    if (bookingPurposeCombo) {
	            	        bookingPurposeCombo.reset(); 
	            	        bookingPurposeCombo.getStore().reload(); 
	            	    }		            	    
	            	}
	            },
				'alumniresourcebookingformlayout photouploadform[itemId=eventBannerItemId] filefield[itemId=photoFileImage]':{
	    			change: function(photoFileImage, value, eOpts) {
	    				var $this = this;
	    				value = value.replace('C:\\fakepath\\', '');
	    				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	    				photoFileImage.setRawValue(newValue);

	    				if (!isNullOrEmpty(newValue)) {
	    					var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	    					if (extension == "gif" || extension == "png" || extension == "bmp"
	    						|| extension == "jpeg" || extension == "jpg") {
	    						var file = photoFileImage.fileInputEl.dom.files[0];
	    						if (file && file.size > 5 * 1024 * 1024) {
	    							photoFileImage.reset();
	    							showWarningMessage(getAlumni('EVENT_DETAILS'), getAlumni('UPLOAD_FILE_SIZE_EXCEEDED'));
	    							return false;
	    						}
	    					} else {
	    						photoFileImage.reset();
	    						showWarningMessage(getAlumni('EVENT_DETAILS'), getAlumni('EVENT_DETAILS_VALID_FILE'));
	    						return false;
	    					}
	    				}

	    				var formPnl = $this.getAlumniresourcebookingformlayout();
	    				var eventBannerBgImage = formPnl.down('#eventBannerBgImage');

	    				var file = photoFileImage.fileInputEl.dom.files[0];
	    				var reader = new FileReader();
	    				reader.addEventListener('load', function(evt) {
	    					eventBannerBgImage.setSrc(evt.target.result);
	    				});
	    				reader.readAsDataURL(file);
	    				//formPnl.down('#eventBannerURLItemId').setValue(null);
	    			}
	            },
	            'resourcebooking searchresultgrid[itemId=resourceBookingGrid] button[itemId=searchResultGridBtnAdd]': {
	                click: function(btn){
	                	var modal = this.getOpenresourcebookingwindow()
	                	this.openAluminiWindow(btn,modal, this.getRESOURCE_BOOKING_PERMISSIONS());	            
	                }
	            },
	            'openresourcebookingwindow button[itemId=submitEventType]':{
	            	click: function(btn){
	            		var windowModel = btn.up('form').up();
	            		var form = btn.up('form').getForm();
	            		var addEventDetailsType = form.findField('addEventDetailsType')
	                    if(addEventDetailsType.inputValue == 'ALUMNI' && addEventDetailsType.checked == true){
	                    	this.addAlumniResourceBooking(getAlumni('ALUMNI_EVENT_DETAILS'), false, true);
	                    	windowModel.hide();
	                    }
	                    else{
	                    	this.addResourceBooking(getAlumni('EVENT_DETAILS'), false, true);
	                    	windowModel.hide();
	                    }

	            	}
	            },
	            'resourcebookingalumnigrid': {	            	
	            	beforerender: function(component, options) {
//	            		var gridStore = component.getStore()
//	            		var academyLocationId = this.getCurrentAcademyLocation()
//	            		gridStore.getProxy().extraParams = {
//	            			academyLocationId:academyLocationId
//	            		};
//	            		gridStore.load();
	            		this.checkAlumniGrid(component)
	                }
	            },
		            'resourcebookingalumnigrid combo[itemId=cmbAcademyLocation]': {
		            	render: function(component, options) {
		                    component.getStore().load();
		                },  
		                afterrender: function(combo){
		                	var grid = this.getResourcebookingalumnigrid();
		                	var academyLocationId=this.getCurrentAcademyLocation();
		                	grid.down('#cmbAcademyLocation').setValue(academyLocationId);
		                },
		            	select: function(combo, records, eOpts) {
		                    var parentComponent = combo.up().up();                    
		                    if (parentComponent) {                    	
		                    	var dependentCombo = parentComponent.down('#cmbAlumniProgram');
		                    	dependentCombo.reset();
		                    	dependentCombo.getStore().load({
		                            params: {
		                            	academyLocationId: combo.getValue()
		                            }
		                        });
		                    	this.searchAlimniBookingListGrid()
//		                    	var params = this.createLoadingCriteria(parentComponent);
//		                        var frmResourceBooking = this.getFormComponent();                        
//		                        this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);                                                                                                                                            
		                    }
		                }
		            },
		            'resourcebookingalumnigrid combo[itemId=cmbAlumniProgram]': {
		            	render: function(component, options) {
		                    component.getStore().load();
		                },                
		                select: function(combo, records, eOpts) {
		                    var parentComponent = combo.up().up();
		                    if (parentComponent) {
//		                    	var frmResourceBooking = this.getFormComponent();  
		                    	this.searchAlimniBookingListGrid();
//		                    	var params = this.createLoadingCriteria(parentComponent);
//		                    	this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);                                                
		                    }
		                }
		            },
		            'alumniresourcebookingformlayout button[itemId=btnSaveResourceBookingForm]': {
		                click: function(btn){
		                	this.saveAlumniResourceBookingForm(btn);
		                	/*if(Ext.isDefined(btn.firstTimeFire) && btn.firstTimeFire==true){
		                		btn.firstTimeFire = false;
		                	}
		                	else{
		                		btn.firstTimeFire = true;
		                		me.saveResourceBookingForm(btn);
		                	}*/
		                }
		            },
				'alumniresourcebookingformlayout':{
					afterrender: function(form){
			        	//set default logged user 
			           this.setDefaultBookingPurpose();
					}
				},
				 'alumniresourcebookingformlayout checkbox[itemId=chkCompleteDay]': {
		                change: this.checkCompleteDayValue
		            },
				'alumniresourcebookingformlayout checkbox[itemId=chkRecurring]': {
	                change: function(cmp, currentValue, oldValue, eOpts) {
	                	var frmResourceBooking = this.getFormComponent();
	                    var toDateField = frmResourceBooking.down('#toDate'),
	                    repeatOnElm = frmResourceBooking.down('#repeatOnItemId');        
	                    if (currentValue == true) {            
	                    	toDateField.setDisabled(false);
	                    	this.setAllowBlank(repeatOnElm,false);
	                    	repeatOnElm.show();
	                    } else {
	                    	//toDateField.reset();
	                    	if(frmResourceBooking.title == getAlumni('ADD_NEW_EVENT_DETAILS')){
	                    		toDateField.reset();
	                    		repeatOnElm.reset();
	                    	}
	                    	toDateField.setDisabled(true);
	                    	repeatOnElm.hide();
	                    	this.setAllowBlank(repeatOnElm,true);
	                    }
	                    Ext.defer(function() {
	                    	frmResourceBooking.isValid();	
	                    },200);
	                }
	            },
	            'button[itemId=viewEventDetailItemId]': {
	                click: this.openViewEventDetail	
	            },
	            'alumnieventregistrationdetailsfilter button[itemId=submitBtn]': {
	                click: function(cmp){
	                	var me = this, 
	                	form = me.getAlumnieventregistrationdetailsfilter(),
	                	grid = me.getAlumnieventregistrationdetailsgrid(),
	                	formVal = form.getForm().getValues(); 
	                	var resourceBookingGrid = me.getResourceBookingGrid()
	       				var store = resourceBookingGrid.getStore()
	       				var resourceBookingGridId = resourceBookingGrid.getSelectionModel().getSelection()[0].data.ID
	                	
	                	grid.getStore().getProxy().extraParams = {
	                		alumniName:formVal.alumniName?formVal.alumniName:null,
	                		alumniCode:formVal.alumniId?formVal.alumniId:null,
	                		academyLocationId:formVal.alumniAlName?formVal.alumniAlName:null,
	                		programId:formVal.alumniProgram?formVal.alumniProgram:null,
	                		registrationDate:formVal.registrationDate?formVal.registrationDate:null,
	                		eventId: resourceBookingGridId,
						}
	                	grid.getStore().load();
	                	
//	                	var resourceBookingGrid = me.getResourceBookingGrid()
//	       				var store = resourceBookingGrid.getStore()
//	       				var resourceBookingGridId = resourceBookingGrid.getSelectionModel().getSelection()[0].data.ID
//		 				store.load({
//		        			callback:function() {
//		        				store.getProxy().extraParams= {
//		        					eventId: resourceBookingGridId,
//		        				};
//		        				store.load()
//		        			}
//		        		});
	                	
//	                	grid.down('pagingtoolbar').moveFirst();
//	                    grid.getStore().load();
//	                    grid.config.searchFilterForm = me.getSignUpRequestFilter();
	                }
	            },
	            'alumnieventregistrationdetailsfilter button[itemId=resetBtn]': {
		            	click: function(cmp){
		            		var me = this
		            		form = me.getAlumnieventregistrationdetailsfilter()
		            		form.getForm().reset();
		            		var alProgram = form.down('#alumniProgramItemId')
		            			alProgram.setDisabled(true)
			            	 }
			            },
	            'alumnieventregistrationdetailsfilter customcombobox[itemId=alumniAlItemId]': {
	            	select: function(cmp, record){
	            		var me = this
	            		form = me.getAlumnieventregistrationdetailsfilter()
	            		var alProgram = form.down('#alumniProgramItemId')
	            		alProgram.reset()
	            		alProgram.setDisabled(false)
	            		var store = alProgram.getStore()
	            		store.getProxy().extraParams = {
	            			academyLocationIds: cmp.getValue(),
	   				 };
	   				 store.load();
	            	}	
	            },
	            'alumnieventregistrationdetailsgrid':{
	           	 afterrender:function(grid){
	       				var me = this;
	       				me.addDataGridConfigButton(grid,me.getRESOURCE_BOOKING_PERMISSIONS());
	       			},
	   			},
	   			
	   			'resourcebookingalumnigrid textfield[itemId=txtName]': {            	
	                change: function(txt, newValue, oldValue, eOpts) {
	                	if(newValue.length>=3 || newValue.length==0){ //At least enter allowed three characters for search
	                		var parentComponent = txt.up().up();                    
	                        if (parentComponent) {
	                        	var $this = this;
	                        	$this.searchAlimniBookingListGrid()
	                        }
	                	}                    
	                }
	            },
	            'resourcebookingalumniavailablefilter button[name=submitBtn]': {
	            	click: this.showAlumniAvailableData
	            },
	            'resourcebookingalumniavailablefilter customcombobox[name=cmbAcademyLocation]': {
	            	change: this.handleAvailableProgramFromAcademyLocation
	            },
	            'resourcebookingalumniavailablefilter customcombobox[name=cmbAlumniProgram]':{
	            	change: this.handleAvailableBatchFromProgram
	            },
	            'resourcebookingalumniavailablefilter button[name=btnReset]': {
	            	click: function(cmp){
	                    var me = this;
	                    form = me.getResourcebookingalumniavailablefilter();
	                    grid = me.getResourcebookingalumniavailablegrid();
	                    form.getForm().reset();                  
	                }
	            },
	            
	            'resourcebookingalumnimappedfilter button[name=submitBtn]': {
	            	click: this.showAlumniMappedData
	            },
	            'resourcebookingalumnimappedfilter customcombobox[name=cmbAcademyLocation]': {
	            	change: this.handleMappedProgramFromAcademyLocation
	            },
	            'resourcebookingalumnimappedfilter customcombobox[name=cmbAlumniProgram]':{
	            	change: this.handleMappedBatchFromProgram
	            },
	            'resourcebookingalumnimappedfilter button[name=btnReset]': {
	            	click: function(cmp){
	                    var me = this;
	                    form = me.getResourcebookingalumnimappedfilter();
	                    grid = me.getResourcebookingalumnimappedgrid();
	                    form.getForm().reset();                  
	                }
	            },
	            'resourcebookingalumnimappedgrid': {
	            	selectionchange: function(column, selected, eOpts ){
	            		var $this = this                
	        	        var grid = $this.getResourcebookingalumnimappedgrid();
	        	        var gridSeletion = grid.getSelectionModel().getCount();
	        	        var selectedRecord = grid.getSelectionModel().getSelection()[0];
	        	        if(grid.getSelectionModel().getCount()==0) {
		        	    	grid.down('#btnDelete').setDisabled(true)
		        	    } else {
		        	    	grid.down('#btnDelete').setDisabled(false)
		        	    }
	            	}
	            },
	            'resourcebookingalumnimappedgrid button[itemId=btnDelete]': {
	            	click: this.deleteMappedAlumni
	            },
	          //Alumni Code: End
	            'resourcebookingusergrid[itemId=userSelectedGrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            },
	            'resourcebookingprogramgrid[itemId=programSelectedGrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            },
	            'resourcebookingcoursegrid[itemId=courseSelectedGrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            },
	            'resourcebookingfacultygrid[itemId=facultySelectedgrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            },
	            'resourcebookingequipmentgrid[itemId=equipmentSelectedGrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            },
	            'resourcebookingexternalresourcegrid[itemId=externalResourceSelectedGrid]': {
	            	afterrender:function(grid){
	            		Ext.defer(function() {
	            			if(grid.down('#totalRecordDisplayField') && grid.store){
	            				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.store.getCount());
	            			}
	            		}, 1500, this);
	            	}
	            }
        });        
        /*this.getStore('facilitiesresources.resourcebooking.ResourceTypeStore').on('load',function(store){
        	 var model = this.getAllModel();
        	 store.add(model);        	 
        },this);*/
        this.getStore('facilitiesresources.resourcebooking.departmentFilterStore').on('load',function(store){
        	var model = new Academia.model.department.DepartmentModel();
            model.set('id','');
            model.set('name', 'ALL');
            store.add(model);       
       },this);
        this.getStore('facilitiesresources.resourcebooking.subdepartmentFilterStore').on('load',function(store){
        	var model = new Academia.model.department.DepartmentModel();
            model.set('id','');
            model.set('name', 'ALL');
            store.add(model);       
       },this);
        this.getStore('facilitiesresources.resourcebooking.AlumniAcademyLocationListByUserStore').on('load',function(store){
        	var model = new Academia.model.common.IdValueCodeDataModel();
            model.set('id','');
            model.set('value', 'ALL');
            store.add(model);       
       },this);
        this.getStore('facilitiesresources.resourcebooking.AlumniAllProgramsStore').on('load',function(store){
        	var model = new Academia.model.common.IdValueCodeDataModel();
            model.set('id','');
            model.set('value', 'ALL');
            store.add(model);       
       },this);
    },
    /*getAcademyLocationIdsForSearchForm: function(){
    	var resourceBookingListSearchForm = this.getResourceBookingListSearchForm();
    	var academyLocationCombo = resourceBookingListSearchForm.down('#multiselectAcademyLocationId');
    	return academyLocationCombo.getValue();
    },
    
    setParamsToComboField: function(field, newValue, oldValue, eOpts){
    	var academyLocationIds = "";
    	var comboArray = ['facility', 'equipment', 'external', 'faculty', 'user', 'program', 'course'];
    	var searchForm = this.getResourceBookingListSearchForm();
    	for(var i=0; i< newValue.length; i++){
    		academyLocationIds += newValue[i]+",";
    	}
    	if(!isNullOrEmpty(academyLocationIds)){
    		academyLocationIds = academyLocationIds.slice(0, academyLocationIds.lastIndexOf(","));
    	}
    	
    	for(var i=0; i< comboArray.length; i++){
    		var store = searchForm.down('#'+comboArray[i]).getStore();
    		store.proxy.extraParams = {
    				academyLocationIds : academyLocationIds
    		};
    	}
    	
    	this.onResetComboFieldContainer();
    	
    },*/
//  Add Alumni Resource Booking: Start
    deleteMappedAlumni: function(obj){
    	var this$ = this;
        var grid = this.getResourcebookingalumnimappedgrid(); 
        var formPanel = this.getAlumniresourcebookingformlayout();
        var formValues = formPanel.getValues();
        if (grid.getSelectionModel().getCount() > 0) {
            var selectionModel = grid.getSelectionModel().getSelection();
            var idsArr = [];

            selectionModel.forEach(function (record) {
                idsArr.push(record.raw.alumniUserId); 
            });

            var ids = idsArr.join();

            showConfirmMessage(getAlumni('MAPPED_ALUMNI'), getAlumni('DO_YOU_WANT_TO_DELETE'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');

                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_RESOURSE_ALUMNI_MAPPED_DELETE,
                        params: {
                        	alumniIds: ids, 
                        	eventId: Number(formValues.id)
                        },
                        method: 'POST',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getAlumni('MAPPED_ALUMNI'), getAlumni('DELETE_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }	
    },
    handleAvailableProgramFromAcademyLocation: function(obj, rec) {
    	var $this = this;
        var form = $this.getResourcebookingalumniavailablefilter();
        var program = form.down('#cmbAlumniProgram');
        var batch = form.down('#cmbAlumniBatch');
        
        // Reset the program and batch fields
        program.reset();
        batch.reset();

        if (!isNullOrEmpty(rec)) {
            // Enable the program dropdown and set the proxy parameters
            program.setDisabled(false);
            program.getStore().getProxy().extraParams = {
                academyLocationIds: rec
            };
            program.getStore().load();

            // Disable the batch dropdown, clear its value, and empty the store
            batch.setDisabled(true);
            batch.setValue(null);
            batch.getStore().removeAll();
        } else {
            // Disable both program and batch dropdowns and clear their values
            program.setDisabled(true);
            program.setValue(null);
            program.getStore().removeAll();

            batch.setDisabled(true);
            batch.setValue(null);
            batch.getStore().removeAll();
        }
    },
    handleAvailableBatchFromProgram:function(obj, rec) {
		var $this = this;
		var form = $this.getResourcebookingalumniavailablefilter();
		var batch = form.down('#cmbAlumniBatch');
		batch.reset();
        if (rec) {
        	batch.setDisabled(false);
        	batch.getStore().getProxy().extraParams = {
        		programIds: rec
			};
        	batch.getStore().load();
        	batch.setValue(null);
        } else {
        	batch.setDisabled(true);
        	batch.setValue(null);
        	batch.getStore().removeAll();
        }
	},
    showAlumniAvailableData: function() {
    	var me = this,
        form = me.getResourcebookingalumniavailablefilter(), 
        formW = me.getAlumniresourcebookingformlayout();
        grid = me.getResourcebookingalumniavailablegrid(),   
        formVal = form.getForm().getValues();
        formValW = formW.getForm().getValues();
        
        var eventId = formValW.id ? Number(formValW.id) : null;

    	grid.getStore().getProxy().extraParams = {
    		academyLocationId: Number(formVal.cmbAcademyLocation) || null,
	        programId: Number(formVal.cmbAlumniProgram) || null,
	        batchId: Number(formVal.cmbAlumniBatch) || null,
	        alumniId: Number(formVal.cmbAlumniName) || null,
	        eventId: eventId
    	};
    
	    grid.down('pagingtoolbar').moveFirst();
	    grid.config.searchFilterForm = me.getResourcebookingalumniavailablefilter();
    },
    // Mapped Alumni
    handleMappedProgramFromAcademyLocation: function(obj, rec) {
    	var $this = this;
        var form = $this.getResourcebookingalumnimappedfilter();
        var program = form.down('#cmbAlumniProgram');
        var batch = form.down('#cmbAlumniBatch');
        
        // Reset the program and batch fields
        program.reset();
        batch.reset();

        if (!isNullOrEmpty(rec)) {
            // Enable the program dropdown and set the proxy parameters
            program.setDisabled(false);
            program.getStore().getProxy().extraParams = {
                academyLocationIds: rec
            };
            program.getStore().load();

            // Disable the batch dropdown, clear its value, and empty the store
            batch.setDisabled(true);
            batch.setValue(null);
            batch.getStore().removeAll();
        } else {
            // Disable both program and batch dropdowns and clear their values
            program.setDisabled(true);
            program.setValue(null);
            program.getStore().removeAll();

            batch.setDisabled(true);
            batch.setValue(null);
            batch.getStore().removeAll();
        }
    },
    handleMappedBatchFromProgram:function(obj, rec) {
		var $this = this;
		var form = $this.getResourcebookingalumnimappedfilter();
		var batch = form.down('#cmbAlumniBatch');
		batch.reset();
        if (rec) {
        	batch.setDisabled(false);
        	batch.getStore().getProxy().extraParams = {
        		programIds: rec
			};
        	batch.getStore().load();
        	batch.setValue(null);
        } else {
        	batch.setDisabled(true);
        	batch.setValue(null);
        	batch.getStore().removeAll();
        }
	},
	showAlumniMappedData: function() {
    	var me = this,
        form = me.getResourcebookingalumnimappedfilter(),
        formW = me.getAlumniresourcebookingformlayout();
        grid = me.getResourcebookingalumnimappedgrid(),   
        formVal = form.getForm().getValues();
        formValW = formW.getForm().getValues();
        var structure = me.getResourcebookingalumnimappedstructure()
        //var storeData = grid.getStore();
        var eventId = formValW.id ? Number(formValW.id) : null;

    	grid.getStore().getProxy().extraParams = {
    		academyLocationId: Number(formVal.cmbAcademyLocation) || null,
	        programId: Number(formVal.cmbAlumniProgram) || null,
	        batchId: Number(formVal.cmbAlumniBatch) || null,
	        alumniId: Number(formVal.cmbAlumniName) || null,
	        eventId: eventId
    	};
    
    	grid.getStore().on('load', function() {
    		Ext.defer(function () { 
                var gridView = grid.getView();
                if (gridView && gridView.getEl()) {
                    gridView.addCls('alumniRSBMappingGridV2'); 
                    Ext.select('.x-grid-body').setStyle('height', 'auto!important');
                }
            }, 100);
    	});
	    grid.down('pagingtoolbar').moveFirst();
	    grid.config.searchFilterForm = me.getResourcebookingalumnimappedfilter();
    },
    
    openAluminiWindow: function(btn,modal,permissionsMap) {
		var $this = this;
    	var associatedAcadLocationIds = new Array();

    	associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var isModelRequired = false;
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === "ALUMNI_VIEW_MODAL") {
    			isModelRequired = true;	
    		}
    	});
    	if(isModelRequired){
        	Ext.widget('openresourcebookingwindow').show();
    	}
    	else{
        	$this.addResourceBooking(getAlumni('EVENT_DETAILS'), false, true);
    	}
    },
    createAlumniEvents: function(isUpdate, eventId, grid) {
    	var this$ = this;
    	var form = this$.getAlumniresourcebookingformlayout();
    	var uploadForm = form.down('#eventBannerItemId');
    	var photoFileImage = uploadForm.down('filefield#photoFileImage');
    	var fileUploadPath = photoFileImage.getValue();
    	var uploadUrl = SERVERURL.RESOURCE_BOOKING_UPLOAD_EVENT_BANNER;
    	if(!isNullOrEmpty(fileUploadPath)){
    		form.getForm().submit({
    			type: 'rest',
    			url: uploadUrl,
    			method: 'POST',
    			params:{
    				eventId : eventId
    			},
    			success: function(form, action) {
    				Ext.getBody().unmask();
    				if (isUpdate) {
    					showSuccessMessage(getAlumni('SUCCESS'), getAlumni('UPDATE_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) updated successfully.											
    				} else {
    					showSuccessMessage(getAlumni('SUCCESS'), getAlumni('ADD_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) added successfully.										
    				}
    				this$.closeResourceBookingFormTab();
    				tabName = getAlumni('ALUMNI_EVENT_DETAILS');
    				var getcontroller = this$.getController('menu.CoreERPNavigationController');
    				var getTab = getcontroller.getTab(tabName);
    				var campaignTabName = getMegaMenuTranslation('TS_TOOLS_MAKE_A_BOOKING');
    				// var getResourceBookingTabName = getcontroller.getTab(campaignTabName);
    				// if (getResourceBookingTabName != null) {
    				// 	contentPanel.setActiveTab(getResourceBookingTabName);
    				// }
    				if(grid != undefined) {
    					var grdStore = grid.getStore();
//    					grid.getSelectionModel().deselectAll();
    					grdStore.reload();
    				}
    				if (getTab != null) {
    					contentPanel.remove(getTab, true);
    				}
    				this$.loadBookingSearchResultGrid();
    				//showSuccessMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('ORGINFOSUCCESS'));

    			}
    		});
    	}
    	else{
    		Ext.getBody().unmask();
    		if (isUpdate) {
    			showSuccessMessage(getAlumni('SUCCESS'), getAlumni('UPDATE_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) updated successfully.											
    		} else {
    			showSuccessMessage(getAlumni('SUCCESS'), getAlumni('ADD_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) added successfully.										
    		}
    		tabName = getAlumni('ALUMNI_EVENT_DETAILS');
    		this$.closeResourceBookingFormTab();
    		var getcontroller = this$.getController('menu.CoreERPNavigationController');
    		var getTab = getcontroller.getTab(tabName);
    		// var campaignTabName = getMegaMenuTranslation('TS_TOOLS_MAKE_A_BOOKING');
    		// var getResourceBookingTabName = getcontroller.getTab(campaignTabName);
    		if (getTab != null) {
    			contentPanel.remove(getTab, true);
    		}
    		this$.loadBookingSearchResultGrid();
    		// if (getResourceBookingTabName != null) {
    		// 	contentPanel.setActiveTab(getResourceBookingTabName);
    		// }
    	}
         
    },
	
    searchAlimniBookingListGrid:function() {
    	var $this = this;
        var frmResourceBooking = $this.getFormComponent();   
        var listGrid = $this.getResourcebookingalumnigrid();
//        var params = this.createLoadingCriteria(parentComponent);
//        var parentComponent = tabItem.up('alumniresourcebookingformlayout');
        var params = {};
//        var academyLocationId=this.getCurrentAcademyLocation();
        var alumniAcademyLocation = frmResourceBooking.down('#cmbAcademyLocation');
        params = $this.getParamValues(alumniAcademyLocation, params, 'academyLocationId', (alumniAcademyLocation)?alumniAcademyLocation.getValue():'');
		
        var alumniProgram = frmResourceBooking.down('#cmbAlumniProgram');
        params = $this.getParamValues(alumniProgram, params, 'programId', (alumniProgram)?alumniProgram.getValue():'');
		
        var searchTextBox = frmResourceBooking.down('#txtName');
        params = $this.getParamValues(searchTextBox, params, 'searchText', (searchTextBox)?searchTextBox.getValue():'');
//        params.academyLocationId = academyLocationId;
		params.start = 0;
//        this.loadSpecificResourceBookingTab(frmResourceBooking, parentComponent.itemId, params);
		
		listGrid.getStore().sorters.clear();
    	var listGridStore = listGrid.getStore().load({
            params: params,
        });
    },
    
    openViewEventDetail:function(){
    	        var $this = this;
    	        var grid = $this.getResourceBookingGrid();
				var grdStore = grid.getStore();
				if (grid.getSelectionModel().getCount() == 1) {   
					var contentpanel = $this.getContentPanel();
	    	        var tabName = getAlumni('EVENTS_REGISTRATION_DETAILS');
	    	        var addViewEvetnTab = Ext.widget('alumnieventregistrationdetailsstructure')
	    	        var navigationController = $this.getController('menu.CoreERPNavigationController');
	    	        var existingTab = navigationController.getTab(tabName);
	    	        if (existingTab != null) {
	    	            contentpanel.remove(existingTab, true);
	    	        }    			
	    	        openTab(contentpanel, tabName, addViewEvetnTab, CONSTANTS.MENU_COLOR_ONE);
				}
				else{
					 showWarningMessage(getAlumni('ALERT'), getAlumni('PLEASE_SELECT_RECORD'));
				}
    	    },
    	    
    	    saveAlumniResourceBookingForm: function(button) {
    	        var $this = this;
    	        var grid = $this.getResourcebookingalumniavailablegrid();
    	        var form = $this.getAlumniresourcebookingformlayout();
    	        var json = $this.createJsonForAddAlumniEventDetail(form);
    	        var formData = json;

    	        button.setDisabled(true);

    	        var alumniBookingId = form.getForm().findField('id').getValue();
    	        var isView, submitUrl, successMsg, tabName, apiMethod;
    	        var isUpdate = false;

    	        if (!isNullOrEmpty(alumniBookingId)) {
    	            if (grid.getSelectionModel().getCount() >= 0) {
    	                isView = 'EDIT';
    	                submitUrl = SERVERURL.PATH_RESOURCE_BOOKING_ALUMNI_USER_UPDATE;
    	                successMsg = getAlumni('ALUMNI_EVENT_UPDATED_SUCCESSFULLY');
    	                tabName = getAlumni('ALUMNI_EVENT_DETAILS');
    	                apiMethod = 'PUT';
    	                isUpdate = true;
    	            } else {
    	                button.setDisabled(false); 
    	                showWarningMessage(getAlumni('ALERT'), getAlumni('PLEASE_SELECT_RECORD'));
    	                return;
    	            }
    	        } else {
    	            if (grid.getSelectionModel().getCount() > 0) {
    	                isView = 'ADD';
    	                submitUrl = SERVERURL.PATH_RESOURCE_BOOKING_ALUMNI_USER_CREATE;
    	                successMsg = getAlumni('ALUMNI_EVENT_CREATED_SUCCESSFULLY');
    	                tabName = getAlumni('ALUMNI_EVENT_DETAILS');
    	                apiMethod = 'POST';
    	                isUpdate = false;
    	            } else {
    	                button.setDisabled(false); 
    	                showWarningMessage(getAlumni('ALERT'), getAlumni('PLEASE_SELECT_RECORD'));
    	                return;
    	            }
    	        }

    	        // Generate JSON data for the request
    	        
    	        var data = Ext.encode(formData);

    	        // Submit the request
    	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	        Ext.Ajax.request({
    	            type: 'rest',
    	            url: submitUrl,
    	            jsonData: data,
    	            timeout: CONSTANTS.AJAX_TIMEOUT,
    	            method: apiMethod,
    	            timeout: 300000,
    	            success: function(response) {
    	                var eventId = response.responseText;
    	                Ext.getBody().unmask();
    	                if (grid !== undefined) {
    	                    var grdStore = grid.getStore();
    	                    grid.getSelectionModel().deselectAll();
    	                    grdStore.reload();
    	                }
    	                $this.createAlumniEvents(isUpdate, eventId, grid);
    	            },
    	            failure: function() {
    	                if (grid !== undefined) {
    	                    var grdStore = grid.getStore();
    	                    grdStore.reload();
    	                }
    	                button.setDisabled(false); // Re-enable Save button on failure
    	                button.firstTimeFire = false;
    	            }
    	        });
    	    },


    createJsonForAddAlumniEventDetail: function(form) {
        var $this = this;
        var form = $this.getAlumniresourcebookingformlayout();
        var formDatas = form.getValues();
        var currentUserId = this.getCurrentlyLoggedInUser().id;
        var grid = $this.getResourcebookingalumniavailablegrid();
    	
        var filter = $this.getResourcebookingalumniavailablefilter();
        
    	var ALVal = filter.down('#cmbAcademyLocation').getValue();
        
        var records = grid.getSelectionModel().getSelection();
        var ids = [];

        if (grid.getSelectionModel().getCount() >= 0) {
            // Gather alumni user IDs from the selected records in the grid
            Ext.Array.each(records, function(record) {
                ids.push(record.raw.alumniUserId);  
            });

            // Handle repeatOn array based on form data
            var repeatOn = null;
            if (!isNullOrEmpty(formDatas.repeatOn)) {  // Ext.isEmpty is used in Ext JS for null/undefined/empty checks
            	repeatOn  = []
            	Ext.Array.each(formDatas.repeatOn,function(value){
            		if(!isNullOrEmpty(value.data)) {
            			repeatOn.push(value.data.id);	
            		}else {
            			repeatOn.push(value);
            		}
        		});
                repeatOn = repeatOn.join();
            }

            // Clear repeatOn if not recurring
            if (formDatas.isRecurring == 'false') {
                repeatOn = null;
            }

            // Define the JSON structure for the event details
            var json = {
                "id": formDatas.id || "",
                "version": formDatas.id ? Math.floor(formDatas.version) + 1 : "",
                "eventName": formDatas.eventName,
                "bookingPurpose": { "id": formDatas.bookingPurpose },
                "bookedBy": { "id": formDatas.bookedBy },
                "venue": formDatas.venue,
                "academyLocationId": ALVal ? ALVal : $this.getCurrentAcademyLocation(),
                "eventDesc": formDatas.eventDesc,
                "isCompleteDay": formDatas.isCompleteDay,
                "timeFrom": formDatas.timeFrom,
                "timeTo": formDatas.timeTo,
                "isMandatory": formDatas.isMandatory, // Corrected spelling
                "isRecurring": formDatas.isRecurring,
                "purposeDesc": formDatas.purposeDesc,
                "noOfParticipants": formDatas.noOfParticipants,
                "toDate": formDatas.toDate,
                "eventDate": formDatas.eventDate,
                "resourceCategoryCode": formDatas.resourceCategoryCode,
                "conductedBy": formDatas.conductedBy,
                "eventBannerURL": formDatas.id ? formDatas.eventBannerURL:'', // Placeholder for image path or URL
                "repeatOn": repeatOn,
                "eventBudget": formDatas.eventBudget,
                "lastRegistrationDate": formDatas.lastRegistrationDate,
                "alumniUser": ids.join(",")  // Join alumni user IDs into a comma-separated string
            };

            return json;
        }
    },
      
    addAlumniResourceBooking: function(tabTitle, isEdit, setDefaultLoggedUser) {
    	var contentpanel = this.getContentPanel();
        var alumniResourceBookingFormLayout = Ext.widget('alumniresourcebookingformlayout',{
        	title: (isEdit)?getAlumni('EVENT_DETAILS'):getAlumni('ADD_NEW_EVENT_DETAILS')
        });
        var tabName = "";
        if (isNullOrEmpty(tabTitle)) {
            tabName = getAlumni('ALUMNI_EVENT_DETAILS');
        } else {
            tabName = tabTitle;
        }
        openTab(contentpanel, tabName, alumniResourceBookingFormLayout, CONSTANTS.MENU_COLOR_NINE);   
        
        if(setDefaultLoggedUser){
        	//set default logged user 
            var cmbBookedByStore =alumniResourceBookingFormLayout.down('#cmbBookedBy').getStore();
            alumniResourceBookingFormLayout.down('#eventDate').setMinValue(new Date())
            var loggedUserId=this.getCurrentlyLoggedInUser().id;
            	cmbBookedByStore.load({
            		scope:this,
            		callback: function(records, operation, success) {
            			if(success){
            				alumniResourceBookingFormLayout.down('#cmbBookedBy').setValue(loggedUserId);
            			}
            		}	
            	});
        }
      
    },
//  Add Alumni Resource Booking: End
    getDocumentController : function() {
    	var this$ = this;
    	return this$
    	.getController('Academia.controller.document.DocumentController');
    },

    onResetComboFieldContainer: function(){
    	var this$ = this;
    	var searchForm = this.getResourceBookingListSearchForm();
    	var comboFieldContainer = searchForm.down('#comboFieldContainer');
    	Ext.each(comboFieldContainer.items.items, function(field){
    		if(field.itemId == 'resourceGroupCombo'){
    			this$.showHideComboField(field, true, false);
    		}else if(field.itemId == 'resourceTypeCombo'){
    			this$.showHideComboField(field, true, true);
    		}else{
    			this$.showHideComboField(field, false, true);
    		}
    		field.clearValue();
    	});
		searchForm.isValid();
    },
    
    showHideComboField: function(field, isShow, isDisabled){
    	if(field){
    		field.setVisible(isShow);
			field.setDisabled(isDisabled);
    	}
    },
    
    showHideComboOnGroupSelection: function(combo, records, eOpts){
    	var this$ = this;
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var resourceBookingListSearchForm = this$.getResourceBookingListSearchForm();
    	var resourceGroup = combo.getValue();
    	var formLayout = this$.getPanelResourceBookingFormLayout();
    	if (!formLayout) {
    	    Ext.widget('resourcebookingformlayout');
    	    formLayout = this$.getPanelResourceBookingFormLayout();
    	}
    	form = formLayout.getForm();
    	var eventDate = form.getValues().eventDate;
    	var timeFrom = form.getValues().timeFrom;
    	var timeTo = form.getValues().timeTo;
    	var comboFieldContainer = resourceBookingListSearchForm.down('#comboFieldContainer');
    	Ext.each(comboFieldContainer.items.items, function(field) {
    		if(field.itemId != 'resourceGroupCombo') {
    			if(!(resourceGroup == 'facility' || resourceGroup == 'equipment' || resourceGroup == 'external') 
    					&& resourceGroup == field.itemId){
    				this$.showHideComboField(field, true, false);
    				var store = field.getStore();
    				store.proxy.extraParams = {
    	    				academyLocationIds : academyLocationId
    	    		};
    				store.clearFilter(true);
    				if(resourceGroup == 'faculty'){
    					store.load({
        					params: {
        						whetherFaculty: true,
        						eventDate : eventDate,
        						timeFrom : timeFrom,
        						timeTo : timeTo
        					}
        				});
    				}else if(resourceGroup == 'user'){
    					store.load({
    						params: {
        						whetherFaculty: false,
        						eventDate : eventDate,
        						timeFrom : timeFrom,
        						timeTo : timeTo
        					}
        				});
    				}else{
    					store.load();
    				}
        		}else if(field.itemId == 'resourceTypeCombo' && 
        				(resourceGroup == 'facility' || resourceGroup == 'equipment' || resourceGroup == 'external')){
        			this$.showHideComboField(field, true, false);
        		}else{
        			this$.showHideComboField(field, false, true);
        		}
    			field.clearValue();
    		}
    	});
    	resourceBookingListSearchForm.isValid();
    },
    
    showHideComboOnTypeSelection: function(combo, records, eOpts){
    	var this$ = this;
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var searchForm = this$.getResourceBookingListSearchForm();
    	var resourceGroup = searchForm.down('#resourceGroupCombo').getValue();
    	var comboFieldContainer = searchForm.down('#comboFieldContainer');
    	Ext.each(comboFieldContainer.items.items, function(field) {
    		if(field.itemId != 'resourceGroupCombo' && field.itemId != 'resourceTypeCombo') {
    			if(field.itemId == resourceGroup){
    				this$.showHideComboField(field, true, false);
    				var store = field.getStore();
    				store.clearFilter(true);
    				store.proxy.extraParams = {
    	    				academyLocationIds : academyLocationId
    	    		};
    				store.load({
    					params:{
    						resourceTypeId: combo.getValue()
    					}
    				});
        		}else {
        			this$.showHideComboField(field, false, true);
        		}
    			field.clearValue();
    		}
    	});
    	searchForm.isValid();
    },
    
    /**
	 * Add dynamic reset buttons in booking listing.
	 */
    gridRenderFunctionForBooking:function(grid){
    	grid.addButtonToolbar();
		var butonstoolbar=grid.down('#functionButtonsToolbar');
		 butonstoolbar.insert(4,{
		        xtype: 'splitbutton',
		        itemId: 'spBtnResourceBookingMoreActions',
		        text: getCommonTranslation('MOREACTIONS'), 
		        tooltip: getCommonTranslation('MOREACTIONS'), 
		        menu: [{
		            text: getCommonTranslation('FEEDBACK'), 
		            itemId: 'resourceFeedbackMenu',
		            tooltip: getCommonTranslation('FEEDBACK_QTIP') 
		        }, {
		            text: getCommonTranslation('CONFIRM_ADHOC_RESOURCE'), 
		            itemId: 'resourceADhocConfirmMenu',
		            tooltip: getCommonTranslation('ADHOC_RESOURCE_QTIP')  
		        },{
		            text: getCommonTranslation('ASSIGN_CALENDER'), 
		            itemId: 'assignCalender',
		            tooltip: getCommonTranslation('ASSIGN_CALENDER')  
		        } , {
		            text: getServiceRequestTranslation('EMM_MANAGE_MINUTES'),
		            itemId: 'manageMinutesButtonItemId',
		            tooltip: getServiceRequestTranslation('EMM_MANAGE_MINUTES'),
		        }, {
		            text: getServiceRequestTranslation('EMM_PRINT_ATTENDANCE_SHEET'),
		            itemId: 'printAttendanceSheetItemId',
		            tooltip: getServiceRequestTranslation('EMM_PRINT_ATTENDANCE_SHEET'),
		        },{
		            text: getCommonTranslation('MARK_EVENT_ATTENDANCE'),
		            itemId: 'markEventAttendanceItemId',
		            tooltip: getCommonTranslation('MARK_EVENT_ATTENDANCE'),
		        }],
		        listeners: { click: function() { this.showMenu(); } }
		    });
		 butonstoolbar.insert(5,{
	    		xtype: 'button',
	    		itemId: 'viewEventDetailItemId',
	    		text:getAlumni('VIEW_EVENT_DETAIL'),
	    		tooltip:getAlumni('VIEW_EVENT_DETAIL'),
	    	});
    },
    /**
     * load booking search result grid
     */
    loadBookingSearchResultGrid: function() {
    	var isValid = true;
        var resourceBookingListSearchForm = this.getResourceBookingListSearchForm();
        var fromDate = resourceBookingListSearchForm.down('#eventDate');
        var toDate = resourceBookingListSearchForm.down('#toDate');
        var timeFrom = resourceBookingListSearchForm.down('#timeFrom');
        var timeTo = resourceBookingListSearchForm.down('#timeTo');
        if(!resourceBookingListSearchForm.getForm().isValid()){
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_VALID_DETAILS'));
        	isValid = false;
        }
        if(!isNullOrEmpty(fromDate.getValue()) && isNullOrEmpty(toDate.getValue())){
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_TO_DATE'));
        	isValid = false;
        }else if(!isNullOrEmpty(toDate.getValue()) && isNullOrEmpty(fromDate.getValue())){
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_FROM_DATE'));
        	isValid = false;
        }else if(!isNullOrEmpty(timeFrom.getValue()) && isNullOrEmpty(timeTo.getValue())){
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_TIME_TO'));
        	isValid = false;
        }else if(!isNullOrEmpty(timeTo.getValue()) && isNullOrEmpty(timeFrom.getValue())){
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_TIME_FROM'));
        	isValid = false;
        }
        if(!isValid){
        	return;
        }
        var jsonFormatFormData = this.createSearchGridResultJsonFormat(resourceBookingListSearchForm);
        var resourceBookingGrid = this.getResourceBookingGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.RESOURCE_BOOKING_LIST_VIEWCODE);
        resourceBookingGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },
    
    exportResourceBookingList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getResourceBookingListSearchForm();	
    	var searchResultGrid = this.getResourceBookingGrid();
    	var pagingtoolbaroptions = searchResultGrid.down('custompagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createSearchGridResultJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('MANAGE_EVENT_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
	
	/**
     * create json format
     */
    createSearchGridResultJsonFormat: function(searchForm) {
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.RESOURCE_BOOKING_LIST_BASIC_CONFIGCODE;

        //formValues = searchForm.getValues();    
        
        /*var bookingId = searchForm.down('#ID');
        var eventIdObj = this$.getJsonObject( 'EVENT_ID' , bookingId.getValue());
        this$.pushJsonObjectInArray(eventIdObj,searchcriteria);*/
        
        var bookingPurposeId = searchForm.down('#cmbBookingPurpose');
        var bookingPurposeIdObj = this$.getJsonObject( 'BOOKING_PURPOSE_ID' , bookingPurposeId.getValue());
        this$.pushJsonObjectInArray(bookingPurposeIdObj,searchcriteria);
        
/*        var eventName = searchForm.down('#eventName');
        var eventNameObj = this$.getJsonObject( 'EVENT_NAME' , eventName.getValue());
        this$.pushJsonObjectInArray(eventNameObj,searchcriteria);*/
        
        var eventIdItemId = searchForm.down('#eventIdItemId');
        var eventNameObj = this$.getJsonObject( 'EVENT_ID' , eventIdItemId.getValue());
        this$.pushJsonObjectInArray(eventNameObj,searchcriteria);
        
        var calendarName = searchForm.down('#calendarName');
        var calendarNameObj = this$.getJsonObject( 'EVENT_CALENDAR_ID' , calendarName.getValue());
        this$.pushJsonObjectInArray(calendarNameObj,searchcriteria);
        
        var adhocStatus = searchForm.down('#adhocStatus');
        var adhocStatusObj = this$.getJsonObject( 'WHETHER_CONFIRMED' , adhocStatus.getValue());
        this$.pushJsonObjectInArray(adhocStatusObj,searchcriteria);
        
        var resourceGroup = searchForm.down('#resourceGroupCombo').getValue();
        if(resourceGroup == 'facility'){
        	var facility = searchForm.down('#facility');
        	var facilityObj = this$.getJsonObject( 'RESOURCE_ID' , facility.getValue());
            this$.pushJsonObjectInArray(facilityObj,searchcriteria);
        } else if(resourceGroup == 'equipment'){
        	var equipment = searchForm.down('#equipment');
        	var equipmentObj = this$.getJsonObject( 'RESOURCE_ID' , equipment.getValue());
            this$.pushJsonObjectInArray(equipmentObj,searchcriteria);
        } else if(resourceGroup == 'external'){
        	var external = searchForm.down('#external');
        	var externalObj = this$.getJsonObject( 'RESOURCE_ID' , external.getValue());
            this$.pushJsonObjectInArray(externalObj,searchcriteria);
        }else if(resourceGroup == 'faculty'){
        	var faculty = searchForm.down('#faculty');
        	var facultyObj = this$.getJsonObject( 'USER_ID' , faculty.getValue());
            this$.pushJsonObjectInArray(facultyObj,searchcriteria);
            
            var whetherFacultyObj = this$.getJsonObject( 'WHETHER_FACULTY' , true);
            this$.pushJsonObjectInArray(whetherFacultyObj,searchcriteria);
        }else if(resourceGroup == 'user'){
        	var user = searchForm.down('#user');
        	var userObj = this$.getJsonObject( 'USER_ID' , user.getValue());
            this$.pushJsonObjectInArray(userObj,searchcriteria);
            
            var whetherFacultyObj = this$.getJsonObject( 'WHETHER_FACULTY' , false);
            this$.pushJsonObjectInArray(whetherFacultyObj,searchcriteria);
        }else if(resourceGroup == 'program'){
        	var program = searchForm.down('#program');
        	var programObj = this$.getJsonObject( 'PROGRAM_ID' , program.getValue());
            this$.pushJsonObjectInArray(programObj,searchcriteria);
        }else if(resourceGroup == 'course'){
        	var course = searchForm.down('#course');
        	var courseObj = this$.getJsonObject( 'COURSE_ID' , course.getValue());
            this$.pushJsonObjectInArray(courseObj,searchcriteria);
        }
        
        var eventDate = searchForm.down('#eventDate');
        var toDate = searchForm.down('#toDate');
        if(!isNullOrEmpty(eventDate.getValue()) && !isNullOrEmpty(toDate.getValue())){
        	var EVENT_DATE = this.getJsonObject('EVENT_DATE', eventDate.getSubmitValue(), toDate.getSubmitValue());
            this.pushJsonObjectInArray(EVENT_DATE, searchcriteria);
            console.log(EVENT_DATE);
            console.log(searchcriteria);
        }
        
        var timeFrom = searchForm.down('#timeFrom');
        var timeTo = searchForm.down('#timeTo');
        if(!isNullOrEmpty(timeFrom.getSubmitValue()) && !isNullOrEmpty(timeTo.getSubmitValue())){
        	
        	var fromTime = Ext.Date.format(new Date('1970/01/01'+' '+timeFrom.getSubmitValue()), CONSTANTS.DATE_TIME_FORMAT);
        	var ToTime = Ext.Date.format(new Date('1970/01/01'+' '+timeTo.getSubmitValue()), CONSTANTS.DATE_TIME_FORMAT);
        	
        	var TIME_TO = this.getJsonObject('TIME_TO', fromTime, ToTime);
            this.pushJsonObjectInArray(TIME_TO, searchcriteria);
            console.log(TIME_TO);
            console.log(searchcriteria);
        }
        
        /*var multiselectAcademyLocationId = searchForm.down('#multiselectAcademyLocationId');
        if(!isEmpty(multiselectAcademyLocationId.getSubmitData().multiselectAcademyLocation)){
        	
        	var multiselectAcademyLocationIdObj = {
                    "paramCode": 'ACAD_LOC_ID',
                    "paramValues": multiselectAcademyLocationId.getSubmitData().multiselectAcademyLocation
            };
            this$.pushJsonObjectInArray(multiselectAcademyLocationIdObj,searchcriteria);
        }*/
        
        var academyLocationId = this.getCurrentAcademyLocation();
        var academyLocationObj = this$.getJsonObject( 'ACAD_LOC_ID' , academyLocationId);
        this$.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        
        var purposeDescObj = this$.getJsonObject('PURPOSE_DESCRIPTION_SESSION', 'Session');
        this$.pushJsonObjectInArray(purposeDescObj, searchcriteria);
        var purposeDescNullObj = this$.getJsonObject('PURPOSE_DESCRIPTION_NULL', 'null');
        this$.pushJsonObjectInArray(purposeDescNullObj, searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    /*
     * This function is used for to enable or disable combo
     * 
     */
    enableDisableCombo: function(selectedCombo,resouceBookingForm,itemId,params) {
    	if(resouceBookingForm){
    		var combo=resouceBookingForm.down(itemId);
    		if(combo){    			
    			combo.setDisabled(false);
    			combo.reset();
    			if(!isEmpty(params)){
    				combo.getStore().removeAll();
    				combo.getStore().load({
    					params:params,
    					callback: function(records, operation, success) {                            
    						var model = new Academia.model.common.IdValueDataModel();
    						var alinfomodel = Academia.model.authentication.ALInfoModel;
							var whetherSchool = alinfomodel.get('wheatherSchool');
							var cmbSection = resouceBookingForm.down('#cmbSection');
							var academicTerm = resouceBookingForm.down('#academicTerm');
							if(whetherSchool){
								if(selectedCombo.getItemId() == 'cmbProgram'){
									if(records.length == 1){
										combo.setValue(records[0].data.id);
										var cmbPeriod = resouceBookingForm.down('#cmbPeriod');
										cmbPeriod.getStore().getProxy().extraParams = {
		    								id:combo.getValue(),
		    								academicTermId:academicTerm.getValue()
		    							}
										cmbPeriod.getStore().load({
											callback: function(records2, operation, success) {
												if(records2.length == 1){
													cmbPeriod.setValue(records2[0].data.id);
													cmbSection.setDisabled(false);
													cmbSection.reset();
													cmbSection.getStore().getProxy().extraParams = {
														periodId:records2[0].data.id,
					    								academicTermId:academicTerm.getValue()
													};
													cmbSection.getStore().load({
														callback: function(records3, operation, success) {
															if(records3.length == 1){
																cmbSection.setValue(records3[0].data.id);
															}
														}
													});
												}
												else{
													cmbSection.setDisabled(false);
													cmbSection.reset();
													cmbSection.getStore().removeAll();
												}
											}
										});
									}
								}
								else if(selectedCombo.getItemId() == 'cmbBatch'){
									if(records.length == 1){
										cmbSection.setDisabled(false);
										cmbSection.reset();
										cmbSection.getStore().getProxy().extraParams = {
											periodId:records[0].data.id,
		    								academicTermId:academicTerm.getValue()
										};
										cmbSection.getStore().removeAll();
										cmbSection.getStore().load({
											callback: function(records3, operation, success) {
												if(records3.length == 1){
													cmbSection.setValue(records3[0].data.id);
												}
											}
										});
									}
									else{
										cmbSection.reset();
										cmbSection.getStore().removeAll();
									}
								}
							}
							else{
								if(selectedCombo.getItemId() == 'cmbProgram'){
									if(records.length == 1){
										combo.setValue(records[0].data.id);
										var cmbPeriod = resouceBookingForm.down('#cmbPeriod');
										cmbPeriod.setDisabled(false);
										cmbPeriod.reset();
										cmbPeriod.getStore().getProxy().extraParams = {
		    								id:combo.getValue(),
		    								academicTermId:academicTerm.getValue()
		    							}
										cmbPeriod.getStore().load({
											callback: function(records2, operation, success) {
												if(records2.length == 1){
													cmbPeriod.setValue(records2[0].data.id);
													cmbSection.setDisabled(false);
													cmbSection.reset();
													cmbSection.getStore().getProxy().extraParams = {
														periodId:records2[0].data.id,
					    								academicTermId:academicTerm.getValue()
													};
													cmbSection.getStore().load({
														callback: function(records3, operation, success) {
															if(records3.length == 1){
																cmbSection.setValue(records3[0].data.id);
															}
														}
													});
												}
											}
										});
										
									}
								}
								else if(selectedCombo.getItemId() == 'cmbBatch'){
									if(records.length == 1){
										combo.setValue(records[0].data.id);
										cmbSection.setDisabled(false);
										cmbSection.reset();
										cmbSection.getStore().getProxy().extraParams = {
											periodId:records[0].data.id,
		    								academicTermId:academicTerm.getValue()
										};
										cmbSection.getStore().load({
											callback: function(records3, operation, success) {
												if(records3.length == 1){
													cmbSection.setValue(records3[0].data.id);
												}
											}
										});
									}
								}
								else if(selectedCombo.getItemId() == 'cmbPeriod'){
									if(records.length == 1){
										combo.setValue(records[0].data.id);
									}
								}
							}
							
    		               // model.set('id','');
    		               // model.set('value', 'All');
    		               // combo.getStore().insert(0,model);
    		            }
    				});
    			}
    		}
    	}
    },
    
    sendCalendarEventsRequest:function(me,parentComponent,records){
    	var params=new Object();
    	var submitURL="";
    	var calendar=me.getCalendar();
    	if(parentComponent.itemId==='facultyListgrid' || parentComponent.itemId==='facultySelectedgrid' ){
    		calendar.eventStore.getProxy().actionMethods.read='GET';
    		submitURL=SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;  //URL-rest/calendar/getFacultyCalendarData
        	var id = records[0].data.id;
        	params.facultyId=id;
        }else if(parentComponent.itemId==='userListGrid' || parentComponent.itemId==='userSelectedGrid' ){
        	calendar.eventStore.getProxy().actionMethods.read='GET';
        	submitURL=SERVERURL.RESOURCE_BOOKING_GET_USER_CALENDAR_DATA;  //URL-rest/calendar/getUserCalendarData        	
        	var id = records[0].data.id;
        	params.userId=id;
        }else if(parentComponent.itemId==='programListGrid' || parentComponent.itemId==='programSelectedGrid'){
        	calendar.eventStore.getProxy().actionMethods.read='GET';        	         	
        	submitURL=SERVERURL.RESOURCE_BOOKING_GET_PROGRAM_CALENDAR_DATA;  //URL-rest/calendar/getProgramCalendarData        	        	      
        	params.programId=getObjectValue(records[0].data.program,'id');
        	params.batchId=getObjectValue(records[0].data.batch,'id');
        	params.sectionId=getObjectValue(records[0].data.section,'id');
        }else if(parentComponent.itemId==='courseListGrid' || parentComponent.itemId==='courseSelectedGrid'){
        	calendar.eventStore.getProxy().actionMethods.read='GET';        	 
        	submitURL=SERVERURL.RESOURCE_BOOKING_GET_COURSES_CALENDAR_DATA;  //URL-rest/calendar/getCourseCalendarData        	
        	var id = records[0].data.id;
        	params.courseId=id;
        }else if(parentComponent.itemId==='academyLocationListGrid'){
        	calendar.eventStore.getProxy().actionMethods.read='POST';
        	submitURL=SERVERURL.RESOURCE_BOOKING_GET_ACADEMY_LOCATION_CALENDAR_DATA;  //URL-rest/calendar/getAcademyLocationCalendarData
        	var ids=new Array();
        	var orgScheduleEventsCheckBox=parentComponent.down('#orgScheduleEvents');
        	if(orgScheduleEventsCheckBox.checked){
        		for(var count=0;count<records.length;count++){
        			var id = records[count].data.id;
        			ids.push(id);
        		}
        		params.academyLocationIds=ids;
        	}else{        		
            	var id = records[0].data.id;
            	ids.push(id);       
            	params.academyLocationIds=ids;
        	}        	
        }else{
        	calendar.eventStore.getProxy().actionMethods.read='GET';
        	submitURL=SERVERURL.RESOURCE_BOOKING_GET_RESOURCE_CALENDAR_DATA;  //URL-rest/calendar/getResourceCalendarData        	
        	var id = records[0].data.id;
        	params.resourceId=id;
        }    	    	    	                               
  	  	calendar.eventStore.getProxy().url =submitURL; //"data/systemusage/CalendarStaticData.json"   
  	  	calendar.eventStore.load(
  			  {
  				  params: params
  			  }
  	  );  	  	
  	  calendar.eventStore.on('beforeload', function(store, operation) {  		  
			if(!isEmpty(params)){
				store.proxy.extraParams = params;	
			}                                                                        
      });	
    },
    
    selectBookingPurpose: function(combo, records, eOpts) {    	
    	var me=this;
        var frmResourceBooking = me.getFormComponent();
        me.applyBusinessRule(me,frmResourceBooking,combo.getValue(), combo);
        var loadPanelObject = {
    			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
    			isUser: true, isProgram: true, isCource: true, isAcademyLocation: true
    	};
        //me.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
    },
    
    
    getResourceBookingTab:function(tabPanel,tabTitle){
       var tab =tabPanel.items.findBy(function(tab){
 		   return tab.title === tabTitle;
 	   });
       return tab;
    },
    
    /*
     * This function is used for to show resource booking feedback details Dialog box after clicking on feedback menu item   
     */
    showResourceFeedbackWindow: function() {
        var winResourceFeedback = Ext.widget('resourcefeedbackwindow');
        winResourceFeedback.show();
    },
    resourceFeedbackMenuClicked: function() {
        var me = this;
        var grid = me.getResourceBookingGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	me.showResourceFeedbackWindow();
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                me.getGrdResourceFeedback().getStore().load({
                    params: {
                        id: records[0].data.ID
                    }
                });
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /*
     * This function is used for to save Resource Feedback after clicking on save button on Dialog Box   
     */
    saveResourceFeedBack: function() {
        var me = this;
        var grid = me.getGrdResourceFeedback();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var feedbackGridStore = me.getGrdResourceFeedback().getStore();
                var resourceFeedbackArray = new Array();
                feedbackGridStore.each(function(record) {
                    var object = new Object();
                    object.id = record.get('id');
                    object.value = record.get('feedback');
                    resourceFeedbackArray.push(object);
                });
                if (resourceFeedbackArray.length > 0) {
                    var jsonData = Ext.encode(resourceFeedbackArray);
                    me.applyWindowMask(); 
                    
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.UPDATE_RESOURCE_FEEDBACK, //URL-rest/resourceBookingResourceResource/updateAll	
                        jsonData: jsonData,
                        method: 'POST',
                        success: function(form, action) {
                        	me.hideWindowMask();
                            me.cancelResourceFeedBack();
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_RESOURCE_FEEDBACK_MSG')); //Resource Feedback updated successfully.																													
                        },
                        failure: function(form, action) {
                        	me.hideWindowMask();
                            me.cancelResourceFeedBack();
                            showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                        }
                    });
                }
            }
        } else {
        	me.hideWindowMask();
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to close Resource Feedback Dialog box after clicking on cancel button   
     */
    cancelResourceFeedBack: function() {
        this.getWinResourceFeedBack().close();
    },


    /*
     * This function is used for to show ADHoc Resource booking details after clicking on Confirm ADHoc Resource menu item   
     */
    resourceADhocConfirmMenuClicked: function() {
        var me = this;
        var grid = me.getResourceBookingGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formData = me.getResourceBookingFormData(records[0].data.ID);
                if (!isEmpty(formData)) {
                    var tabTitle = records[0].data.EVENT_NAME +" " +getCommonTranslation('EVENT_DETAILS');
                    me.addResourceBooking(tabTitle, true, false);
                    var frmResourceBooking = me.getFormComponent(tabTitle);
                    me.setModelContentFromNestedObject(formData, 'bookedBy', 'id');
                    me.setModelContentFromNestedObject(formData, 'bookingPurpose', 'id');
                    if(!isNullOrEmpty(formData.eventDate))
                    	formData.eventDate = new Date(formData.eventDate);
                    if(!isNullOrEmpty(formData.toDate))
                    	formData.toDate = new Date(formData.toDate);
                    
                    var rec = new Academia.model.facilitiesresources.resourcebooking.ResourceBookingModel(formData);    
                    var timeFrom = rec.get('timeFrom');
                    var timeTo = rec.get('timeTo');
                    if(!isNullOrEmpty(timeFrom) && !isNullOrEmpty(timeTo)){
                    	rec.data.timeFrom = new Date(timeFrom);
                    	rec.data.timeTo = new Date(timeTo);
                    }
                    frmResourceBooking.loadRecord(rec);
                    me.loadDataInSelectedStores(frmResourceBooking, formData);
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: true, isCource: true, isAcademyLocation: true
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                    me.displayEventBannerImage(records[0].data.ID);
                    if(!isNullOrEmpty(formData.repeatOn)) {
                    	var repeatOnFld = frmResourceBooking.down('#repeatOnItemId'),
                    	repeatOnStore = repeatOnFld.getStore();
                    	var repeatOnIds=[];
                    	repeatOnStore.load({
                    		callback: function(records, operation, success) {
                    			var repeatOnVals = formData.repeatOn.split(',');
                    			for(var i in repeatOnVals){
                    				repeatOnIds.push(repeatOnVals[i]);
                    			}
                    			repeatOnFld.setValue(repeatOnIds);
                    		}
                    	});
                    }
                    if(!isNullOrEmpty(formData.committee) && formData.committee!= undefined &&  formData.committee.id !=null ) {
                    	me.populateFormData(undefined,getCommonTranslation('MEETING'), formData);
                    } else {
                    	var form = frmResourceBooking.getForm();
                    	var committee = form.findField('committee');
                    	var bookedBy = form.findField('bookedBy');
                    	committee.setVisible(false);
                    	committee.allowBlank=true;
                    	
                    	var conductedBy = form.findField('conductedBy');
                    	conductedBy.allowBlank = true;
                    	conductedBy.setVisible(false);
                    }
                    frmResourceBooking.down('tabpanel').setActiveTab(8); //Here 3 is Tab index of Adhoc Resource Tab on Resource Booking Form Tab Panel
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to check complete day value and according to this value enable/disable Time From and Time To fields   
     */
    checkCompleteDayValue: function(cmp, currentValue, oldValue, eOpts) {
        var frmResourceBooking = this.getFormComponent();
        var timeFromField = frmResourceBooking.down('#timeFrom');
        var timeToField = frmResourceBooking.down('#timeTo');
        if (currentValue == true) {
            timeFromField.setDisabled(true);
            timeToField.setDisabled(true);
            if(frmResourceBooking.title == getCommonTranslation('ADD_NEW_EVENT_DETAILS')){
            	timeFromField.reset();
            	timeToField.reset();
        	}
        } else {
            timeFromField.setDisabled(false);
            timeToField.setDisabled(false);
        }
        frmResourceBooking.isValid();
    },

    /*
     * This function is used for to show Resource Booking Tab after clicking on Add button   
     */
    addResourceBooking: function(tabTitle, isEdit, setDefaultLoggedUser, IsAlumni) {
    	var contentpanel = this.getContentPanel();
    	if(IsAlumni ==true) {
    		var resourceBookingFormLayout = Ext.widget('alumniresourcebookingformlayout',{
    			title: (isEdit)?getCommonTranslation('EVENT_DETAILS'):getCommonTranslation('ADD_NEW_EVENT_DETAILS')
    		});
    	}else {    		
    		var resourceBookingFormLayout = Ext.widget('resourcebookingformlayout',{
    			title: (isEdit)?getCommonTranslation('EVENT_DETAILS'):getCommonTranslation('ADD_NEW_EVENT_DETAILS')
    		});
    	}
        var tabName = "";
        if (isNullOrEmpty(tabTitle)) {
            tabName = getCommonTranslation('EVENT_DETAILS');
        } else {
            tabName = tabTitle;
        }
        /*if(Ext.isDefined(Ext.ComponentQuery.query('resourcebookingformlayout')[0])){
        	if(Ext.ComponentQuery.query('resourcebookingformlayout')[0].title == getCommonTranslation('EVENT_DETAILS')){
            	Ext.ComponentQuery.query('resourcebookingformlayout')[0].up().destroy();
        	}
        }*/
        openTab(contentpanel, tabName, resourceBookingFormLayout, CONSTANTS.MENU_COLOR_NINE);   
        
        if(setDefaultLoggedUser){
        	//set default logged user 
            var cmbBookedByStore =resourceBookingFormLayout.down('#cmbBookedBy').getStore();
            var loggedUserId=this.getCurrentlyLoggedInUser().id;
           // Ext.defer(function() {
            	cmbBookedByStore.load({
            		scope:this,
            		callback: function(records, operation, success) {
            			if(success){
            				resourceBookingFormLayout.down('#cmbBookedBy').setValue(loggedUserId);
            			}
            		}	
            	});
           // }, 100, this);
        }
              
        if(!isEdit){        	
        	var loadPanelObject = {
        			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
        			isUser: true, isProgram: true, isCource: true, isAcademyLocation: true
        	};
            this.loadDataForResourceBookingTab(resourceBookingFormLayout, loadPanelObject);
        }
      
        if(IsAlumni == false) {        	
        	var docGrid = resourceBookingFormLayout.down('#documentsGridResourceBooking');
        	var docStore = docGrid.getStore();
        	if (docStore)
        		docStore.removeAll();
        }
    },
    
    setDefaultBookingPurpose : function() {
    	var form = this.getAlumniresourcebookingformlayout()
        var cmbBookedPurposeStore =form.down('#cmbBookingPurpose').getStore();
        var cmbBookedPurposeId=cmbBookedPurposeStore.data.items[0].data.id;
        cmbBookedPurposeStore.load({
        		scope:this,
        		callback: function(records, operation, success) {
        			if(success){
        				form.down('#cmbBookingPurpose').setValue(cmbBookedPurposeId);
        			}
        		}	
        	});
    },
    
    editAlumniResourceBooking: function(isView) {
        var me = this;
        var grid = me.getResourceBookingGrid();
//        var form  = me.getResourceBookingFormData();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formData = me.getResourceBookingFormData(records[0].data.ID);
                if (!isEmpty(formData)) {
                    var tabTitle = records[0].data.EVENT_NAME + " " +getCommonTranslation('EVENT_DETAILS');
                    
                    me.addResourceBooking(tabTitle, true, false,records[0].data.IS_CHECK_ALUMNI);
                    var bookingPurposeId=formData.bookingPurpose;
                    var frmResourceBooking = me.getFormComponent(tabTitle);
                    var formAlum = me.getAlumniresourcebookingformlayout()
                    var form = frmResourceBooking.getForm();
                    var bookedBy = form.findField('bookedBy');
                    bookedBy.getStore().load({
                    	callback: function(records, operation, success) {
                    		bookedBy.setValue(formData.bookedBy);
							bookedBy.setReadOnly(true);
                		}
                    });
                    
                    var eventDateField = formAlum.down("#eventDate");
                    var toDateField = formAlum.down("#toDate");
                    var lastRegistrationDate = formAlum.down("#lastRegistrationDateId");
                    var currentDate = new Date();

                    if (!isNullOrEmpty(formData.eventDate)) {
                        formData.eventDate = new Date(formData.eventDate);
                        
                        eventDateField.setMinValue(formData.eventDate > currentDate ? currentDate : formData.eventDate);
                        eventDateField.setValue(formData.eventDate);
                        eventDateField.validate();
                    }

                    if (!isNullOrEmpty(formData.toDate)) {
                        formData.toDate = new Date(formData.toDate);
                        
                        var startDate = formData.eventDate ? new Date(formData.eventDate) : null;
                        
                        if (startDate && formData.toDate) {
                            toDateField.setMinValue(startDate > currentDate ? startDate : currentDate);
                        } else {
                            toDateField.setMinValue(currentDate);
                        }

                        toDateField.setValue(formData.toDate);
                        toDateField.validate();
                    } else {
                        toDateField.setMinValue(formData.eventDate > currentDate ? formData.eventDate : currentDate);
                    }

                    if (lastRegistrationDate) {
                        var maxRegDate;
                        if(formData.toDate) {
                        	maxRegDate = new Date(formData.toDate);
                        } else {
                        	maxRegDate = new Date(formData.eventDate);
                        }

                        lastRegistrationDate.setMinValue(currentDate);
                        lastRegistrationDate.setMaxValue(maxRegDate);
                        
                        if (!isNullOrEmpty(formData.lastRegistrationDate)) {
                            lastRegistrationDate.setValue(new Date(formData.lastRegistrationDate));
                        }
                        
                        lastRegistrationDate.validate();
                    }

                    eventDateField.on('change', function(field, newValue) {
                        var selectedStartDate = new Date(newValue);
                        
                        if (toDateField) {
                            toDateField.setMinValue(selectedStartDate < currentDate ? currentDate : selectedStartDate);
                            toDateField.validate();
                        }

                        if (lastRegistrationDate) {
                            lastRegistrationDate.setMinValue(currentDate);
                            lastRegistrationDate.setMaxValue(toDateField && toDateField.getValue() ? toDateField.getValue() : null);
                            lastRegistrationDate.validate();
                        }
                    });

                    toDateField.on('change', function(field, newValue) {
                        if (lastRegistrationDate) {
                            var selectedEndDate = new Date(newValue);
                            lastRegistrationDate.setMinValue(currentDate);
                            lastRegistrationDate.setMaxValue(selectedEndDate);
                            lastRegistrationDate.validate();
                        }
                    });
                    
                    var rec = new Academia.model.facilitiesresources.resourcebooking.ResourceBookingModel(formData);   
                    var timeFrom = rec.get('timeFrom');
                    var timeTo = rec.get('timeTo');
                    if(!isNullOrEmpty(timeFrom) && !isNullOrEmpty(timeTo)){
                    	rec.data.timeFrom = new Date(timeFrom);
                    	rec.data.timeTo = new Date(timeTo);
                    }
                    var CategoryCode=frmResourceBooking.down("#resourceCategoryCode").readOnly;
                    frmResourceBooking.loadRecord(rec);
                    frmResourceBooking.down("#resourceCategoryCode").setReadOnly(CategoryCode);
                    
                    //me.applyBusinessRule(me,frmResourceBooking,bookingPurposeId,null,records[0].data.IS_CHECK_ALUMNI);
                    if(!isNullOrEmpty(formData.eventBannerURL)) {                    	
                    	me.displayEventBannerImage(records[0].data.ID, records[0].data.IS_CHECK_ALUMNI);
                    }
                    frmResourceBooking.down('#gradeMasterResetButtonId').setVisible(false);
                    frmResourceBooking.down('#cmbBookingPurpose').setReadOnly(true);
                    me.setModelContentFromNestedObject(formData, 'bookedBy', 'id');
//                    me.setModelContentFromNestedObject(formData, 'bookingPurpose', 'id');
                    me.setDefaultBookingPurpose();
                    if(!isNullOrEmpty(formData.repeatOn)) {
                    	var repeatOnFld = frmResourceBooking.down('#repeatOnItemId'),
                    	repeatOnStore = repeatOnFld.getStore();
                    	var repeatOnIds=[];
                    	repeatOnStore.load({
                    		callback: function(records, operation, success) {
                    			var repeatOnVals = formData.repeatOn.split(',');
                    			for(var i in repeatOnVals){
                    				repeatOnIds.push(repeatOnVals[i]);
                    			}
                    			repeatOnFld.setValue(repeatOnIds);
                    		}
                    	});
                    }
                    
//                    var alumniGrid = me.getResourcebookingalumnigrid();
                    var alumniGrid = me.getResourcebookingalumniavailablegrid();
//                    var idsArray = [56, 15, 18,14,3,2];
//                    alumniGrid.getSelectionModel().select(idsArray);
//                      this.checkAlumniGrid(alumniGrid, formData.academyLocationId, formData.alumniUsers)
//                    grid.down('#cmbAcademyLocation').setValue(formData.academyLocationId)	
                      
                      // add addition config
                        var rsbMappingGrid = this.getResourcebookingalumnimappedgrid();                        
                            // Listen for the store load event
                        	rsbMappingGrid.getStore().on('load', function (store, records, successful) {
                                if (successful) {
                                    var gridBody = rsbMappingGrid.getView().getEl();
                                    if (gridBody) {
                                        var gridBodyHeight = gridBody.dom.scrollHeight;
                                        var maxHeight = 600;

                                        if (gridBodyHeight > maxHeight) {
                                        	rsbMappingGrid.setHeight(maxHeight);
                                            rsbMappingGrid.body.setStyle('overflow-y', 'auto');
                                        } else {
                                        	rsbMappingGrid.setHeight(maxHeight);
                                        }
                                    }
                                }
                            });
                    if (isView) {
                    	var mappingGrid = this.getResourcebookingalumnimappedgrid();
                    	mappingGrid.down('#btnDelete').setVisible(false)
                    	var meetingdocumentgrid = frmResourceBooking.down('#documentsGridResourceBooking');
                    	var resourceDate = frmResourceBooking.down('#eventDate');
                    	var meetingDocs = frmResourceBooking.down('#meetingDocsId');
                    	resourceDate.setMinValue(dateRender(rec.data.eventDate));
                    	resourceDate.isValid();
                    	frmResourceBooking.down('#btnSaveResourceBookingForm').setVisible(false);
                        Ext.suspendLayouts();
                        frmResourceBooking.getForm().getFields().each(function(field) {
                            field.setReadOnly(true);
                        });
                        Ext.resumeLayouts();
                        frmResourceBooking.down('#eventBannerItemId').setDisabled(true);                        
                    }

                	var committee = form.findField('committee');
                	committee.setVisible(false);
                	committee.allowBlank=true;                   	
						
                	if (!isView)
                		bookedBy.setReadOnly(false);
                
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    checkAlumniGrid:function(grid, alId, alumniUsers) {
    	var gridStore = grid.getStore()
		var academyLocationId = this.getCurrentAcademyLocation()
		gridStore.getProxy().extraParams = {
			academyLocationId:alId ? alId : academyLocationId
		};
		gridStore.load({
			callback:function(records, operation, success) {
//			  var idsArray = [56, 15, 18,14,3,2];
				if(!isNullOrEmpty(alumniUsers)){					
					for(var i in alumniUsers) {				  
						for(var j in records) {
							if(records[j].data.alumniUserId == alumniUsers[i]) {
								grid.getSelectionModel().select(records[j], true);
							}
						}
					}
				}
			}
		});
    },

    /*
     * This function is used for to show Resource Booking(Event) Details Tab with values of selected record after clicking on edit button   
     */
    editResourceBooking: function(isView) {
        var me = this;
        var grid = me.getResourceBookingGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var formData = me.getResourceBookingFormData(records[0].data.ID);
                if (!isEmpty(formData)) {
                    var tabTitle = records[0].data.EVENT_NAME + " " +getCommonTranslation('EVENT_DETAILS');
                    me.addResourceBooking(tabTitle, true, false);
                    var frmResourceBooking = me.getFormComponent(tabTitle);
                    me.setModelContentFromNestedObject(formData, 'bookedBy', 'id');
                    me.setModelContentFromNestedObject(formData, 'bookingPurpose', 'id');
                    var bookingPurposeId=formData.bookingPurpose;

                    if(!isNullOrEmpty(formData.eventDate))
                    	formData.eventDate = new Date(formData.eventDate);
                    if(!isNullOrEmpty(formData.toDate))
                    	formData.toDate = new Date(formData.toDate);
                    var rec = new Academia.model.facilitiesresources.resourcebooking.ResourceBookingModel(formData);   
                    var timeFrom = rec.get('timeFrom');
                    var timeTo = rec.get('timeTo');
                    if(!isNullOrEmpty(timeFrom) && !isNullOrEmpty(timeTo)){
                    	rec.data.timeFrom = new Date(timeFrom);
                    	rec.data.timeTo = new Date(timeTo);
                    }
                    var CategoryCode=frmResourceBooking.down("#resourceCategoryCode").readOnly;
                    frmResourceBooking.loadRecord(rec);
                    frmResourceBooking.down("#resourceCategoryCode").setReadOnly(CategoryCode);
                    
                    me.applyBusinessRule(me,frmResourceBooking,bookingPurposeId);
                    me.loadDataInSelectedStores(frmResourceBooking, formData);
                    var loadPanelObject = {
                			isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
                			isUser: true, isProgram: true, isCource: true, isAcademyLocation: true
                	};
                    this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
                    me.displayEventBannerImage(records[0].data.ID);
                    frmResourceBooking.down('#gradeMasterResetButtonId').setVisible(false);
                    frmResourceBooking.down('#cmbBookingPurpose').setReadOnly(true);
                    
                    if(!isNullOrEmpty(formData.repeatOn)) {
                    	var repeatOnFld = frmResourceBooking.down('#repeatOnItemId'),
                    	repeatOnStore = repeatOnFld.getStore();
                    	var repeatOnIds=[];
                    	repeatOnStore.load({
                    		callback: function(records, operation, success) {
                    			var repeatOnVals = formData.repeatOn.split(',');
                    			for(var i in repeatOnVals){
                    				repeatOnIds.push(repeatOnVals[i]);
                    			}
                    			repeatOnFld.setValue(repeatOnIds);
                    		}
                    	});
                    }
                   
                    
                    if (isView) {
                    	var meetingdocumentgrid = frmResourceBooking.down('#documentsGridResourceBooking');
                    	var resourceDate = frmResourceBooking.down('#eventDate');
                    	var meetingDocs = frmResourceBooking.down('#meetingDocsId');
                    	resourceDate.setMinValue(dateRender(rec.data.eventDate));
                    	resourceDate.isValid();
                    	frmResourceBooking.down('#btnSaveResourceBookingForm').setVisible(false);
                        Ext.suspendLayouts();
                        frmResourceBooking.getForm().getFields().each(function(field) {
                            field.setReadOnly(true);
                        });
                        Ext.resumeLayouts();
                        Ext.each(frmResourceBooking.down('tabpanel').items.items, function(tabCmp) {
                            if (tabCmp.items.items[0].xtype === 'adhocresourcesgrid') {
                                tabCmp.down('#btnAdd').setDisabled(true);
                                tabCmp.down('#btnEdit').setDisabled(true);
                                tabCmp.down('#btnDelete').setDisabled(true);
                            }
                            /*Ext.each(tabCmp.items.items, function(cmp) {
                                if (cmp.selType === "rowmodel") {
                                    cmp.getSelectionModel().setLocked(true);
                                }
                            });*/
                        });
                        
                        frmResourceBooking.down('#eventBannerItemId').setDisabled(true);
                        meetingdocumentgrid.down('#btnDelete').setVisible(false);
                        meetingDocs.setVisible(false);
                        
                        
                    }
                    if(!isNullOrEmpty(formData.committee) && formData.committee!= undefined &&  formData.committee.id !=null ) {
                    	me.populateFormData(undefined,getCommonTranslation('MEETING'), formData);
                    } else {
                    	var form = frmResourceBooking.getForm();
                    	var committee = form.findField('committee');
                    	var bookedBy = form.findField('bookedBy');
                    	committee.setVisible(false);
                    	committee.allowBlank=true;
                    	//var documentGrid = me.getMeetingdocumentgrid();
                    	var documentGrid = frmResourceBooking.down('#documentsGridResourceBooking');
                    	documentGrid.getStore().getProxy().api.read = SERVERURL.FIND_ALL_RESOURCE_BOOKING_DOCS;
   						documentGrid.getStore().getProxy().extraParams={
   						//	limit: -1,
   							resourceBookingId:formData.id
   						};
//   						documentGrid.down('#btnDelete').setVisible(false);
   						documentGrid.getStore().load();
   						
                    	if (!isView)
                    		bookedBy.setReadOnly(false);
                    }
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /*
     * This function is used for to delete Resource Booking after clicking on delete button   
     */
    deleteResourceBooking: function() {
        var grid = this.getResourceBookingGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {        	
        	showConfirmMessage(getCommonTranslation('DELETE_RESOURCE_BOOKING_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	 if (grid.getSelectionModel().getCount() > 0) {
                         var records = grid.getSelectionModel().getSelection();
                         for (var count = 0; count < records.length; count++) {
                             var id = "";
                             if (records[count].get("ID") != "" && records[count].get("ID") != undefined && records[count].get("ID") != null) {
                                 id = records[count].get("ID");
                             }
                             Ext.Ajax.request({
                                 type: 'rest',
                                 url: SERVERURL.RESOURCE_BOOKING_DELETE, //URL-rest/resourceBookingResource/delete													 
                                 method: 'DELETE',
                                 headers: {
                                     'Content-Type': 'application/json'
                                 },
                                 params: {
                                     id: id
                                 },
                                 success: function(form, action) {
                                     grdStore.reload();
                                     var responseObject = form.responseText;
                                  	if(!isNullOrEmpty(responseObject)) {
                                  		if(typeof responseObject == "string" && responseObject=="Not-Autorize"){
                                  			Ext.getBody().unmask();
                                  			showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_NOT_AUTORIZED"));
                                  			return false;
                                  		}
                                  		else if(typeof responseObject == "string" && responseObject=="Connection_refused"){
                                  			Ext.getBody().unmask();
                                  			 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_SERVICE_DOWN"));
                                  			return false;
                                  		}else{
                                     showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) deleted successfully
                                  		}
                                  	}
                                 },
                                 /*failure: function(form, action) {
                                 	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                                 }*/
                             });
                         }
                     }
                }
            });        	
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*
     * This function is used for to save/update Event Details(Resource Booking) Form Tab    
     */
    saveResourceBookingForm: function(button) {
    	var me = this;
    	var grid = me.getResourceBookingGrid();        
    	var frmResourceBooking = me.getContentPanel().getActiveTab().down('form');
    	var isMeetingValid = true;
    	if(frmResourceBooking.down('#cmbBookingPurpose').getRawValue() == "Meeting") {
    		var cntSelectedUser = frmResourceBooking.down('#userSelectedGrid').getStore().data.length;
    		if(cntSelectedUser == 0){
    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('AT_LEAST_ONE_USER_SHOULD_ALWAYS_BE_AVAILABLE_MSG'));
    			isMeetingValid = false;
    		}
    	}
    	if(isMeetingValid){
    		if(frmResourceBooking.isValid()){
    			var isCapacityAvailable= true;//me.checkAvailableCapacity();
    			if(isCapacityAvailable){
    	            var jsonFormatFormData = this.createJsonFormat(frmResourceBooking);
    			 /*** Check Conflicts***/
    	            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	            Ext.Ajax.request({
    	                type: 'rest',                
    	                url: SERVERURL.RESOURCE_BOOKING_CONFLICT, //URL-:rest/resourceBooking/checkConflicts
    	                jsonData: jsonFormatFormData,
    	                timeout: CONSTANTS.AJAX_TIMEOUT,
    	                method: 'POST',
    	                timeout:300000,
    	                success: function(response,form, action) {    
    	                	var responseObject = eval("(" + response.responseText + ")"); //make object of response text
    	                    var messageString = "",message="";                
    	                    for (var msgCount = 0; msgCount < responseObject.messages.length; msgCount++) {
    	                    	if (!isNullOrEmpty(responseObject.messages[msgCount])) {                        
    	                    		messageString += responseObject.messages[msgCount]; 
    	                        }
    	                    	if(msgCount==responseObject.messages.length-1){
    	                    		messageString += '<br>';
    	                    	}else{
    	                    		messageString += ',<br>';
    	                    	}
    	                    }                                                    
    	                    if (messageString.length > 0) {                	
    	                    	if(responseObject.code==0){
    	                    		Ext.getBody().unmask();
    	                    		message+= messageString+'<br>'+getCommonTranslation('RESOLVE_CONFLICT_OVERWITE_MSG'); //Above conflict(s) are occoured while saving record Do you still want to continue ?                	
    	                    		message = '<div style="overflow:auto;height: 290px;padding-bottom: 10px;">'+message+'</div>';
    	                    		showConfirmMessage(getCommonTranslation('WARNING'),message, function(btn, text) {
    	    	                        if (btn == 'yes') {
    	    	                        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	    	                        	me.sendRequestForSaveResource(frmResourceBooking,jsonFormatFormData,grid,button);
    	    	                        }
    	    	                        else{
    	    	                        	button.firstTimeFire = false;
    	    	                        }
    	                    		});
    	                    	}else if(responseObject.code==1){
    	                    		message+= getCommonTranslation('RESOLVE_CONFLICT_MSG')+'<br>'+messageString; //First resolve following conflict(s) then try to save record
    	                    		message = '<div style="overflow:auto;height: 290px;padding-bottom: 10px;">'+message+'</div>';
    	                    		showWarningMessage(getCommonTranslation('CONFLICT'),message);   
    	                    		Ext.getBody().unmask();
    	                    	}                    
    	                    }else{
    	                    	me.sendRequestForSaveResource(frmResourceBooking,jsonFormatFormData,grid,button);
    	                    }     
    	                    //Ext.getBody().unmask();
    	                },
    	                failure: function(form, action) {
    	                	Ext.getBody().unmask();
    	                	button.firstTimeFire = false;
    	                	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
    	                }
    	            });
    			}else{
    				Ext.getBody().unmask();
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NUMBER_PARTICIPANTS_LESS_THAN_CAPACITY')); //Number of participants should be less than available capacity of facilities.
    	        }     
    		}else{
    			Ext.getBody().unmask();
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    		}
    	}
    },
    
    sendRequestForSaveResource: function(frmResourceBooking,jsonFormatFormData,grid,button) {    	
    	button.setDisabled(true); //After clicking on save button it should be disabled
    	var me=this;
    	var submitUrl, isUpdate = false;
    	var id = frmResourceBooking.down('#ID').getValue();
        if (isNullOrEmpty(id)) {
            submitUrl = SERVERURL.RESOURCE_BOOKING_CREATE; //URL-rest/resourceBookingResource/create
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.RESOURCE_BOOKING_UPDATE; //URL-:rest/resourceBookingResource/update				    			
            isUpdate = true;
        }        
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            timeout: CONSTANTS.AJAX_TIMEOUT,
            method: 'POST',
            timeout:300000,
            success: function(form, action) {
                //Ext.getBody().unmask();
                var eventId = form.responseText;
            	if(grid != undefined) {
            		var grdStore = grid.getStore();
                    grid.getSelectionModel().deselectAll();
                    grdStore.reload();
            	}
                
             //   if(frmResourceBooking.down('#cmbBookingPurpose').getRawValue() == "Meeting") {
                	 var responseObject = form.responseText;
                 	if(!isNullOrEmpty(responseObject)) {
                 		
                 		if(typeof responseObject == "string" && responseObject=="Connection_refused"){
                 			Ext.getBody().unmask();
                 			showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_NOT_AUTORIZED"));
                 			return false;
                 		}
                 		else if(typeof responseObject == "string" && responseObject=="Connection_refused"){
                 			Ext.getBody().unmask();
                 			 showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("GOOGLE_CALENDAR_SERVICE_DOWN"));
                 			return false;
                 		}else{
                 			var returnedData = Ext.decode(responseObject);
                         	if(returnedData!=0){
                         			var meetingdocumentgrid = frmResourceBooking.down('#documentsGridResourceBooking');
                         			var docStore = meetingdocumentgrid.getStore();
//                         			if(!isNullOrEmpty(meetingdocumentgrid.getCode()) && meetingdocumentgrid.getCode() != undefined){
                         				/*docStore
                         				.add(meetingdocumentgrid.getCode());*/
                         				var docArray = [];
                         				if (docStore.data.items != null
                         						&& docStore.data.items.length > 0) {
                         					for(var i in docStore.data.items) {
                         						if(docStore.data.items[i].data.isNewRecord!=undefined && docStore.data.items[i].data.isNewRecord){
                         							var newData = {
                         									"name" : docStore.data.items[i].data.documentName,
                         									"path" : docStore.data.items[i].data.path,
                         									"type" : "DOCUMENT",
                         									"createdBy" : me.getIdValueJson(
                         											docStore.data.items[i].data.createdBy.id,
                         											docStore.data.items[i].data.createdBy.value)
                         							};
                         							var data = {
                         								 'resourceBooking':me.getIdValueJson(returnedData),
                         										'document':newData,
                         									   'committee':me.getIdValueJson(frmResourceBooking.down('#committeeItemId').getValue())
                         							};
                         							docArray.push(data);
                         						}
                         					}
                         					//console.log('hellosdsd');
                         					Ext.Ajax.request({
                         						type: 'rest',
                         						url: SERVERURL.COMMITTEE_MEETING_DOCS_CREATE,
                         						jsonData: docArray,
                         						method: 'POST',
                         						success: function(form, action) {
                         							 //me.closeResourceBookingFormTab();
                         						}
                         					});
//                         				}
                         			}
                         	}
                 		}
                 		
                 		
                 	}
                //}
                me.saveEventBannerImage(isUpdate, eventId, grid);
                /*Ext.defer(function() {
                	me.closeResourceBookingFormTab();
                }, 500);*/
            },
            failure: function(form, action) {
            	if(grid != undefined) {
            		var grdStore = grid.getStore();
            		grdStore.reload();
            	}
                button.setDisabled(false); 
                button.firstTimeFire = false;
            }
        });    	    	    	
    },

    /*
     * This function is used for to create Resource Booking Form JSON Format    
     */
    createJsonFormat: function(frmResourceBooking) {

        var values = frmResourceBooking.getValues();
        var resourceBookingModel = new Academia.model.facilitiesresources.resourcebooking.ResourceBookingModel(values);
        //				    	var resourceBookingModel = new Academia.model.facilitiesresources.resourcebooking.ResourceBookingModel();
        //				    	frmResourceBooking.updateRecord(resourceBookingModel);
        
        if(values.bookingPurpose == this.EXTERNAL_EVENT_BOOKING_PURPOSE) {
        	resourceBookingModel.set('bookedBy', null);
        	resourceBookingModel.set('conductedBy', resourceBookingModel.get('conductedBy'));
        } else {
        	resourceBookingModel.set('bookedBy', {
	            id: resourceBookingModel.get('bookedBy')
	        });
        	resourceBookingModel.set('conductedBy', null);
        }
        var academyLocationId=this.getCurrentAcademyLocation();
        resourceBookingModel.set('academyLocationId', academyLocationId);
        
        resourceBookingModel.set('venue', resourceBookingModel.get('venue'));
        resourceBookingModel.set('eventBudget', resourceBookingModel.get('eventBudget'));
        
        resourceBookingModel.set('bookingPurpose', {
            id: resourceBookingModel.get('bookingPurpose')
        });
        if(!isNullOrEmpty(values.committee)) {
        	  resourceBookingModel.set('committee', {
                  id: values.committee
              });
        } else {
        	resourceBookingModel.set('committee', null);
        }
        
        var repeatOnArry=[];
		if(!isNullOrEmpty(values.repeatOn) && values.repeatOn.length > 0) {
			for(var i in values.repeatOn){
				if (Ext.isObject(values.repeatOn[0])) {
					repeatOnArry.push(values.repeatOn[i].get("id"));
	            } else {
	            	repeatOnArry.push(values.repeatOn[i]);
	            }
			}
		}
		resourceBookingModel.set('repeatOn', repeatOnArry.join());
        
        var formData = resourceBookingModel.data;

        var selectedFacilities = this.createTabPanelJsonData(frmResourceBooking, 'resourcebookingfacilitytree');
        formData.facilities = selectedFacilities;

        var selectedEquipments = this.createTabPanelJsonData(frmResourceBooking, 'equipmentSelectedGrid');
        formData.equipments = selectedEquipments;

        var selectedExternalResources = this.createTabPanelJsonData(frmResourceBooking, 'externalResourceSelectedGrid');
        formData.externalResources = selectedExternalResources;

        var selectedAdhocresources = this.createTabPanelJsonData(frmResourceBooking, 'adhocresourcesgrid');
        formData.resourceBookingAdhocs = selectedAdhocresources;

        var selectedfaculties = this.createTabPanelJsonData(frmResourceBooking, 'facultySelectedgrid');
        if(frmResourceBooking.down('#cmbBookingPurpose').getRawValue()=='Meeting') {
        	formData.faculties = [];
        } else {
        	formData.faculties = selectedfaculties;
        }

        var selectedusers = this.createTabPanelJsonData(frmResourceBooking, 'userSelectedGrid');
        formData.users = selectedusers;

        var selectedprograms = this.createTabPanelJsonData(frmResourceBooking, 'programSelectedGrid');
        formData.resourceBookingPrograms = selectedprograms;

        var selectedcourses = this.createTabPanelJsonData(frmResourceBooking, 'courseSelectedGrid');
        formData.courses = selectedcourses;

        var selectedacadloc = this.createTabPanelJsonData(frmResourceBooking, 'academyLocationListGrid');
        formData.academyLocations = selectedacadloc;


        //var resourceBookingValues = addressFrom.getValues();
        //(frmResourceBooking.getValues());
        return Ext.encode(formData);
    },


    /*
     * This function is used for to create JSON Format
     */
    createTabPanelJsonData: function(frmResourceBooking, itemId) {
    	var me=this;
        var Ids = new Array();
        //				    	Ext.each(frmResourceBooking.down('tabpanel').items.items, function(tabCmp){								    						    	
        //					    	Ext.each(tabCmp.items.items, function(cmp) {
        var cmp = frmResourceBooking.down('#' + itemId);
        if (cmp.itemId === 'adhocresourcesgrid') {
            cmp.getStore().each(function(record) {         
            	delete record.data.client_Id;
                Ids.push(record.data);
            });
        } else if (cmp.itemId === 'academyLocationListGrid') {
            if (cmp.getSelectionModel().getCount() > 0) {
                var records = cmp.getSelectionModel().getSelection();
                if (records != "" && records != null && records != undefined) {
                    for (var count = 0; count < records.length; count++) {
                        Ids.push({
                            id: records[count].data.id
                        });
                    }
                }
            }
        } else if (cmp.itemId === 'resourcebookingfacilitytree') {
            var treeStore = cmp.getStore();
            treeStore.getRootNode().cascadeBy(function(node) {
                if (node.data.checked) {
                    Ids.push({
                        id: node.data.id
                    });
                }
            });
        } else if (cmp.itemId === 'programSelectedGrid') {
            var gridStore = cmp.getStore();
            gridStore.each(function(record) {
            	Ids=me.createJsonForSelectedPrograms(record,Ids);
            });
        } else if (cmp.itemId === 'userSelectedGrid') {
        	if(frmResourceBooking.down('#cmbBookingPurpose').getRawValue()=='Meeting') {
        		cmp.getStore().each(function(record) {
            		if (!isNullOrEmpty(record.get('id'))) {
            			Ids.push({
            				id: record.get('id'),
            				newEmpId:record.get('userType')
            			});
            		}
            	});
        	} else {
        		cmp.getStore().each(function(record) {
            		if (!isNullOrEmpty(record.get('id'))) {
            			Ids.push({
            				id: record.get('id'),
            			});
            		}
            	});
        	}
        	
        } else {
        	if (cmp.itemId === itemId) {
        		cmp.getStore().each(function(record) {
        			if (!isNullOrEmpty(record.get('id'))) {
        				Ids.push({
        					id: record.get('id')
        				});
        			}
        		});
        	}
        }      			    					    	    					   
        return Ids;
    },

    /*
     * This function is used for to create Json for Selected Programs 
     */
    createJsonForSelectedPrograms:function(record,Ids){
    	var recordObject=new Object();
    	
    	if (!isEmpty(record.get('program'))) {    		
    		recordObject.program=record.get('program');    		            
        }
    	
    	if (!isEmpty(record.get('batch'))) {    		
    		recordObject.batch=record.get('batch');    		            
        }
    	
    	if (!isEmpty(record.get('period'))) {    		
    		recordObject.period=record.get('period');    		            
        }
    	
    	if (!isEmpty(record.get('section'))) {    		
    		recordObject.section=record.get('section');    		            
        }
    	
    	Ids.push(recordObject);    	
    	return Ids;
    },

    /*
     * This function is used for to show filtered data in the list grid
     */
    filterData: function(frmResourceBooking, itemId1, itemId2, param) {
        var me = this;
        var listGrid, selectedGrid;
        if (!isNullOrEmpty(itemId1)) {
            listGrid = frmResourceBooking.down('#' + itemId1);
        }
        if (!isNullOrEmpty(itemId2)) {
            selectedGrid = frmResourceBooking.down('#' + itemId2);
        }
        if (itemId1 === 'programListGrid' && !isEmpty(listGrid) && !isEmpty(selectedGrid)) {
            var listGridStore = listGrid.getStore().load({
                params: param,
                callback: function(records, operation, success) {
                    var selectedGridStore = selectedGrid.getStore();
                    var listGridStore = listGrid.getStore();
                    var removeArray = new Array();
                    selectedGridStore.each(function(selectedRecord) {
                        var selectedProgramId = getObjectValue(selectedRecord.get('program'),'id'); 
                        var selectedBatchId = getObjectValue(selectedRecord.get('batch'),'id');
                        var selectedPeriodId = getObjectValue(selectedRecord.get('period'),'id');
                        var selectedSectionId = getObjectValue(selectedRecord.get('section'),'id');
                        listGridStore.each(function(record) {
                            var recProgramId = getObjectValue(record.get('program'),'id');
                            var recBatchId = getObjectValue(record.get('batch'),'id');
                            var recPeriodId = getObjectValue(record.get('period'),'id');
                            var recSectionId = getObjectValue(record.get('section'),'id');
                            if (recProgramId==selectedProgramId && recBatchId==selectedBatchId &&
                            	recPeriodId==selectedPeriodId && recSectionId==selectedSectionId) {
                                removeArray.push(record);
                            }
                        });
                    });
                    listGridStore.remove(removeArray);
                }
            });
        }else if (!isEmpty(listGrid) && !isEmpty(selectedGrid)) {
        	listGrid.getStore().sorters.clear();
        	var listGridStore = listGrid.getStore().load({
                params: param,
                callback: function(records, operation, success) {
                    var selectedGridStore = selectedGrid.getStore();
                    var listGridStore = listGrid.getStore();
                    var removeArray = new Array();
                    selectedGridStore.each(function(selectedRecord) {
                        var selectedRecId = selectedRecord.get('id');
                        listGridStore.each(function(record) {
                            var recId = record.get('id');
                            if (selectedRecId == recId) {
                                removeArray.push(record);
                            }
                        });
                    });
                    listGridStore.remove(removeArray);
                    selectedGridStore.removeAll();
                    selectedGridStore.add(removeArray);
                }
            });
        } else if (itemId1 === 'resourcebookingfacilitytree' && !isEmpty(listGrid)) {
        	listGrid.getStore().getProxy().extraParams = {	
        		resourceGroup:"FACILITY"
			};
        	listGrid.getStore().getProxy().url =SERVERURL.RESOURCE_BOOKING_LIST_FACILITIES //URL-rest/internalResource/findFacilitiesByCriteria
        	listGrid.getStore().getRootNode().removeAll();
        	var listGridStore = listGrid.getStore().load({
               // params: param,
        		params: Ext.apply(param || {}, {
        	        all: true // Add the 'all' parameter
        	    }),
                callback: function(records, operation, success) {
                    if (typeof facilitiesSelectedStore !== "undefined") {
                        var dataStore = frmResourceBooking.down('#selectedFacilitiesPanel')!= undefined ? frmResourceBooking.down('#selectedFacilitiesPanel').getStore():null;
                        if(dataStore != null) {
                        	dataStore.removeAll();
                            var selectedStore = facilitiesSelectedStore;
                            var treeStore = listGrid.getStore();
                            var data = new Array();
                            selectedStore.each(function(selectedRecord) {
                                var selectedRecId = selectedRecord.get('id');
                                treeStore.getRootNode().cascadeBy(function(node) {
                                    if (selectedRecId == node.data.id) {
                                        node.set('checked', true);
                                        var dataModel = new Academia.model.facilitiesresources.resourcebooking.SelectedFacilitiesModel();
                                        dataModel.set('selectedText', node.data.text);
                                        dataStore.add(dataModel);
                                    }                                
                                });
                            });
                        }
                        facilitiesSelectedStore.removeAll();
                    }
                }
            });
        } else if (!isEmpty(listGrid)) { //Resource Booking Academy Location Grid 
            var listGridStore = listGrid.getStore().load({
                callback: function(records, operation, success) {
                    if (typeof acadLocSelectedStore !== "undefined") {
                    	                    	
                        //Show already selected academy locations
                        var selectedRecords=new Array();
                        var selectedGridStore = acadLocSelectedStore;
                        selectedGridStore.each(function(selectedRecord) {
                        	var selectedId=selectedRecord.get('id');
                        	listGrid.getStore().each(function(visitedRecord) {
                                if (selectedId === visitedRecord.data.id) {
                                	selectedRecords.push(visitedRecord);
                                }
                            });                        	                          
                        });
                        if(selectedRecords.length>0){
                    		listGrid.getSelectionModel().select(selectedRecords);
                    		//listGrid.up('resourcebookingformlayout').up('panel').getEl().dom.lastChild.scrollTop=0;
                    		listGrid.up('resourcebookingformlayout').down('#resourceCategoryCode').focus();
                        }
                        acadLocSelectedStore.removeAll();                     	 
                    }                    
                }
            });
        }
    },
    /*
     * This function is used for to close Resource Booking Form Tab    
     */
    closeResourceBookingFormTab: function() {
    	var $this = this;
//        this.getContentPanel().getActiveTab().close();
    	var contentpanel = $this.getContentPanel();
        var getcontroller = $this.getController('menu.CoreERPNavigationController');
        var getTab = getcontroller.getTab($this.getContentPanel().getActiveTab().title);
        if (getTab != null) {
            contentPanel.remove(getTab, true);
        }
    },

    /*
     * This function is used for to get Object    
     */
    getIdValueJson: function(id, value) {
        if (id) return {
            id: id,
            value: value
        };
    },

    /*
     * This function is used for to load data in selected tab stores    
     */
    loadDataInSelectedStores: function(frmResourceBooking, formData) {
    	var params = {};
    	
    	facilitiesSelectedStore = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesSelectedStore');
        facilitiesSelectedStore.loadData(new Array());
        facilitiesSelectedStore.loadData(formData.facilities);
    	 
        var grid = frmResourceBooking.down('#equipmentSelectedGrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.EquipmentSelectedStore'));
        grid.getStore().loadData(formData.equipments);
        
        var grid = frmResourceBooking.down('#externalResourceSelectedGrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.ExternalResourceSelectedStore'));
        grid.getStore().loadData(formData.externalResources);
        
        var grid = frmResourceBooking.down('#adhocresourcesgrid');        
        for(var count=0;count<formData.resourceBookingAdhocs.length;count++){
        	formData.resourceBookingAdhocs[count].client_Id=count+1;
        }
        grid.getStore().loadData(formData.resourceBookingAdhocs);
        
        var grid = frmResourceBooking.down('#facultySelectedgrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.FacultySelectedStore'));
        grid.getStore().loadData(formData.faculties);
        
        var grid = frmResourceBooking.down('#userSelectedGrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.UserSelectedStore'));
        grid.getStore().loadData(formData.users);
        
        var grid=frmResourceBooking.down('#programSelectedGrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.ProgramSelectedStore'));
        grid.getStore().loadData(formData.resourceBookingPrograms);
        
        var grid = frmResourceBooking.down('#courseSelectedGrid');
        grid.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseSelectedStore'));
        grid.getStore().loadData(formData.courses);
        
        acadLocSelectedStore = Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationSelectedStore');
        acadLocSelectedStore.loadData(new Array());
        acadLocSelectedStore.loadData(formData.academyLocations);

    },

    /*
     * This function is used for to get Resource Booking Form Data
     */
    getResourceBookingFormData: function(id) {
        var responseObject = new Object();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.RESOURCE_BOOKING_FINDBYID, //URL-rest/resourceBookingResource/findById													 
            method: 'GET',
            async: false,
            headers: {
                'Content-Type': 'application/json'
            },
            params: {
                id: id
            },
            success: function(response, form, action) {
                responseObject = eval("(" + response.responseText + ")"); //make object of response text
            },
            failure: function(form, action) {
            	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
            }
        });
        return responseObject;
    },

    /*
     * This function is used for to set value in model object 
     */
    setModelContentFromNestedObject: function(object, field, type) {
        if (object && object[field] && object[field].hasOwnProperty(type)) {
            object[field] = object[field][type];
        }
    },

    /*
     * This function is used for to return Resource Booking Form component
     */
    getFormComponent: function(tabTitle) {
        if (isNullOrEmpty(tabTitle)) {
            return this.getContentPanel().getActiveTab().down('form');
        } else {
            var menuController = Academia.app.getController('menu.CoreERPNavigationController');
            var tab = menuController.getTab(tabTitle);
            return tab.down('form');
        }
    },
    
    /*
     * This function is used for to create ALL Model returns model    
     */
    getAllModel: function() {
        var model = new Academia.model.common.IdValueDataModel();
        model.set('id','');
        model.set('value', 'ALL');
        return model;
    },

    /*
     * This function is used for to show AdHoc Resource Dialog Box after clicking on Add button   
     */
    addAdhocResource: function(tabTitle) {
        //this.getGrdAdhocResources().showAdhocResourceForm();
    	if(!Ext.isDefined(Ext.ComponentQuery.query('adhocresourceformwindow')[0])){
    		var winAdhocResourceForm = Ext.widget('adhocresourceformwindow');
    		winAdhocResourceForm.show();
    	}
    	var frmAdhocResource = this.getFrmAdhocResource();
        var resourceTypeCmb=frmAdhocResource.down('#cmbResourceType');
        resourceTypeCmb.getStore().load({
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCmb.getStore().remove(this.data.items[0]);
                    	}                    	
                    }
                });
    },

    /*
     * This function is used for to show AdHoc Resource Dialog Box with values of selected record after clicking on edit button   
     */
    editAdhocResource: function(isView) {
        var me = this;
        var frmResourceBooking = this.getFormComponent();
        var grid = frmResourceBooking.down('#adhocresourcesgrid');
        if (grid.getSelectionModel().getCount() > 0) {
            //grid.showAdhocResourceForm();
        	if(!Ext.isDefined(Ext.ComponentQuery.query('adhocresourceformwindow')[0])){
        		var winAdhocResourceForm = Ext.widget('adhocresourceformwindow');
        		winAdhocResourceForm.show();
        	}
        	var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var frmAdhocResource = me.getFrmAdhocResource();  
               var resourceTypeCombo= frmAdhocResource.down('#cmbResourceType');
               var resourceTypeComboStore=resourceTypeCombo.getStore();
               resourceTypeComboStore.load();
               resourceTypeCombo.setValue(records[0].data.resourceType.id);
                var rec = new Academia.model.facilitiesresources.resourcebooking.AdhocResourceModel(records[0].data);
                rec.set('resourceType', rec.get('resourceType').id);
                frmAdhocResource.loadRecord(rec);
                if (isView) {
                    var winAdhocResourceForm = me.getWinAdhocResourceForm();
                    winAdhocResourceForm.down('#btnSaveAdhocResourceForm').setVisible(false);
                    toggleReadOnlyFormItems(frmAdhocResource.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /*
     * This function is used for to delete AdHoc Resource after clicking on delete button   
     */
    deleteAdhocResource: function() {
        var frmResourceBooking = this.getFormComponent();
        var grid = frmResourceBooking.down('#adhocresourcesgrid');
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('DELETE_ADHOC_RESOURCE_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            grid.getStore().remove(records[count]);
                        }
						grid.getView().refresh();
                        showWarningMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_ADHOC_RESOURCE_DETAILS_MSG')); //Adhoc Resource Details deleted successfully
                    }
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /*
     * This function is used for to save Adhoc Resource Details on client side after clicking on save button    
     */
    saveAdhocResource: function() {
        var winAdhocResourceForm = this.getWinAdhocResourceForm();
        var frmResourceBooking = this.getFormComponent();
        var grid = frmResourceBooking.down('#adhocresourcesgrid');
        var gridStore = grid.getStore();
        var frmAdhocResource = this.getFrmAdhocResource();        
        
        var loadedRecord = new Academia.model.facilitiesresources.resourcebooking.AdhocResourceModel(frmAdhocResource.getValues());        
        var cmbResourceType = frmAdhocResource.down('#cmbResourceType');
        loadedRecord.set('resourceType', {
            id: loadedRecord.get('resourceType'),
            value: cmbResourceType.getRawValue()
        });
        
        var client_Id=loadedRecord.get('client_Id');
        var server_Id=loadedRecord.get('id');
        
        if(isNullOrEmpty(server_Id)){  //Client Side 
        	if(client_Id==0){ //Client Side Add Case
        		if(gridStore.data.length==0){
                	client_Id=1;
                }else{
                	var record=gridStore.last();
                	if(!isEmpty(record)){
                		client_Id=record.get('client_Id')+1;
                	}            	
                }
        		
        		loadedRecord.set('client_Id',client_Id);            
                gridStore.add(loadedRecord);
                grid.getView().refresh();
                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_ADHOC_RESOURCE_MSG')); //Adhoc Resource added successfully
        	}else{  //Client Side update Case
        		
        		if (grid.getSelectionModel().getCount() > 0) {
                    var records = grid.getSelectionModel().getSelection();
                    if(!isEmpty(records[0].data)){
                    	Ext.each(loadedRecord.fields.items, function(field) {
                    		records[0].set(field.name,loadedRecord.get(field.name));
    	            	});
                    	 grid.getView().refresh();
                    	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_ADHOC_RESOURCE_MSG')); //Adhoc Resource updated successfully
                    }	        		
        		}
        	} 
        }else{  //Server Side Edit Case
        	
        	if (grid.getSelectionModel().getCount() > 0) {
                var records = grid.getSelectionModel().getSelection();
                if(!isEmpty(records[0].data)){
                	Ext.each(loadedRecord.fields.items, function(field) {
                		records[0].set(field.name,loadedRecord.get(field.name));
	            	});
                	 grid.getView().refresh();
                	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_ADHOC_RESOURCE_MSG')); //Adhoc Resource updated successfully
                }	        		
    		}
        }                	        	        	            
                	
        gridStore.commitChanges();
        winAdhocResourceForm.close();
    },


    /*
     * This function is used for to close Adhoc Resource Details Dialog box after clicking on cancel button   
     */
    cancelAdhocResource: function() {
        this.getWinAdhocResourceForm().close();
    },

    /**
     * Load perticular event tab on the basis of itemId and params
     */
    loadSpecificResourceBookingTab: function(frmResourceBooking, itemid, params){
    	if(frmResourceBooking && !isNullOrEmpty(itemid)){
    		switch(itemid){
    			case 'resourcebookingfacilitytree':{
    				this.filterData(frmResourceBooking, 'resourcebookingfacilitytree', null, params);
    				break;
    			}
    			case 'equipmentListGrid':{
    				this.filterData(frmResourceBooking, 'equipmentListGrid', 'equipmentSelectedGrid', params);
    				break;
    			}
    			case 'externalResourceListGrid':{
    				this.filterData(frmResourceBooking, 'externalResourceListGrid', 'externalResourceSelectedGrid', params);
    				break;
    			}
    			case 'facultyListgrid':{
    				this.filterData(frmResourceBooking, 'facultyListgrid', 'facultySelectedgrid', params);
    				break;
    			}
    			case 'userListGrid':{
    				this.filterData(frmResourceBooking, 'userListGrid', 'userSelectedGrid', params);
    				break;
    			}
    			case 'programListGrid':{
    				this.filterData(frmResourceBooking,'programListGrid','programSelectedGrid',params);
    				break;
    			}
				case 'courseListGrid':{
					this.filterData(frmResourceBooking, 'courseListGrid', 'courseSelectedGrid', params);
					break;
				}
				case 'academyLocationListGrid':{
					this.filterData(frmResourceBooking, 'academyLocationListGrid', null, params);
					break;
				}
				case 'alumniListEventGrid':{
					this.filterData(frmResourceBooking, 'alumniListEventGrid', 'alumniSelectedGrid', params);
					break;
				}
        	}
    	}
    	
    },
    /**
     * Load data for resource booking tab
     */
    loadDataForResourceBookingTab: function(frmResourceBooking, loadPanelObject) {
    	var params = {};
    	
    	if(loadPanelObject.isFacilityTree){
    		params = this.createLoadingCriteria(frmResourceBooking.down('#resourcebookingfacilitytree'));
    		this.filterData(frmResourceBooking, 'resourcebookingfacilitytree', null, params);
    	}
    	
    	if(loadPanelObject.isEquipement){
    		params = this.createLoadingCriteria(frmResourceBooking.down('#equipmentListGrid'));
    		this.filterData(frmResourceBooking, 'equipmentListGrid', 'equipmentSelectedGrid', params);
    	}
    		
    	if(loadPanelObject.isExternal){
    		params = this.createLoadingCriteria(frmResourceBooking.down('#externalResourceListGrid'));
    		this.filterData(frmResourceBooking, 'externalResourceListGrid', 'externalResourceSelectedGrid', params);
    	}
        
        if(loadPanelObject.isFaculty){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#facultyListgrid'));
        	this.filterData(frmResourceBooking, 'facultyListgrid', 'facultySelectedgrid', params);
        }
        	
        if(loadPanelObject.isUser){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#userListGrid'));
        	this.filterData(frmResourceBooking, 'userListGrid', 'userSelectedGrid', params);
        }
        
        if(loadPanelObject.isProgram){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#programListGrid'));
        	this.filterData(frmResourceBooking,'programListGrid','programSelectedGrid',params);
        }
        if(loadPanelObject.isCource){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#courseListGrid'));
            this.filterData(frmResourceBooking, 'courseListGrid', 'courseSelectedGrid', params);
        }
        if(loadPanelObject.isAcademyLocation){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#academyLocationListGrid'));
            this.filterData(frmResourceBooking, 'academyLocationListGrid', null, params);
        }
        if(loadPanelObject.isUser){
        	params = this.createLoadingCriteria(frmResourceBooking.down('#alumniListEventGrid'));
        	this.filterData(frmResourceBooking, 'alumniListEventGrid', 'alumniSelectedGrid', params);
        }
        
    },
    /**
     * create criteria for tab items load
     */
    createLoadingCriteria: function(tabItem) {
        var params = {};
        var academyLocationId=this.getCurrentAcademyLocation();
        params.academyLocationId = academyLocationId;
        if(tabItem){
	        var resourceBookingForm = tabItem.up('resourcebookingformlayout');
	        
	        var bookingPurposeField = resourceBookingForm.down('#cmbBookingPurpose');
	        var eventDateField = resourceBookingForm.down('#eventDate');
	        var toDateField = resourceBookingForm.down('#toDate');
	        var completeDayField = resourceBookingForm.down('#chkCompleteDay');
	        var timeFromField = resourceBookingForm.down('#timeFrom');
	        var timeToField = resourceBookingForm.down('#timeTo');
	        var departmentCombo = tabItem.down('#cmbDepartment');
	        var subDepartmentCombo = tabItem.down('#cmbSubDepartment');
	        var groupCombo = tabItem.down('#cmbResourceGroup');
	        var typeCombo = tabItem.down('#cmbResourceType');
	        var searchTextBox = tabItem.down('#txtName');
	        var alumniAcademyLocation = tabItem.down('#cmbAcademyLocation');
	        var alumniProgram = tabItem.down('#cmbAlumniProgram');
        
	        var tabItemId = tabItem.itemId;
        	switch(tabItemId){
        		case 'resourcebookingfacilitytree':
        		case 'resourcebookingformfacilityselectedpanel':
        		case 'equipmentListGrid':
        		case 'equipmentSelectedGrid':
        		case 'externalResourceListGrid':
        		case 'externalResourceSelectedGrid':{
        			params = this.getParamValues(bookingPurposeField, params, 'bookingPurposeId', (bookingPurposeField)?bookingPurposeField.getValue():'');
        			params = this.getParamValues(eventDateField, params, 'eventDate', (eventDateField)?eventDateField.getSubmitValue():'');
        			params = this.getParamValues(toDateField, params, 'toDate', (toDateField)?toDateField.getSubmitValue():'');
        			params = this.getParamValues(completeDayField, params, 'isCompleteDay', (completeDayField)?completeDayField.getValue():'');
        			params = this.getParamValues(timeFromField, params, 'timeFrom', (timeFromField)?timeFromField.getSubmitValue():'');
        			params = this.getParamValues(timeToField, params, 'timeTo', (timeToField)?timeToField.getSubmitValue():'');
        			if(tabItemId == 'externalResourceListGrid'){
        				params = this.getParamValues(groupCombo, params, 'resourceGroup', (groupCombo)?groupCombo.getValue():'FACILITY');
        			}
        			params = this.getParamValues(typeCombo, params, 'resourceTypeId', (typeCombo)?typeCombo.getValue():'');
        			params.start = 0;
        			params.limit = -1;
        			break;
        		}
        		case 'adhocresourcesgrid':break;
	        	case 'facultyListgrid':
	        	case 'facultySelectedgrid':
	        	case 'userListGrid':
	        	case 'userSelectedGrid':{
	        		if(tabItemId==='facultyListgrid' || tabItemId==='facultySelectedgrid'){
	            		params.whetherFaculty=true;
	            		params.eventDate=eventDateField.getSubmitValue();
	            	}else {
	            		params.whetherFaculty=false;        		
	            	}
	        		params = this.getParamValues(departmentCombo, params, 'departmentId', (departmentCombo)?departmentCombo.getValue():'');
        			params = this.getParamValues(subDepartmentCombo, params, 'subDepartmentId', (subDepartmentCombo)?subDepartmentCombo.getValue():'');
        			params = this.getParamValues(searchTextBox, params, 'searchText', (searchTextBox)?searchTextBox.getValue():'');
        			params.start = 0;
        			params.limit = -1;
	        		break;
	        		
	        	}
	        	//ALumniTab: Start
	        	case 'alumniListEventGrid':
	        	case 'alumniSelectedGrid':{
	        		if(tabItemId==='alumniListEventGrid' || tabItemId==='alumniSelectedGrid'){
	            		params.whetherFaculty=true;
	            		params.eventDate=eventDateField.getSubmitValue();
	            	}else {
	            		params.whetherFaculty=false;        		
	            	}
//	        		alumniAcademyLocation alumniProgram
	        		params = this.getParamValues(alumniAcademyLocation, params, 'academyLocationId', (alumniAcademyLocation)?alumniAcademyLocation.getValue():'');
        			params = this.getParamValues(alumniProgram, params, 'programId', (alumniProgram)?alumniProgram.getValue():'');
        			params = this.getParamValues(searchTextBox, params, 'searchText', (searchTextBox)?searchTextBox.getValue():'');
        			params.start = 0;
        			params.limit = -1;
	        		break;	        		
	        	}
	        	//AlumniTab: End
	        	case 'programListGrid':
        		case 'programSelectedGrid':{
        			params = {};
        			
        			if(!isNullOrEmpty(academyLocationId)){
        	    		params.academyLocationId = academyLocationId;
        	    	}
        			var alGrid= resourceBookingForm.down('#academyLocationListGrid');
        			var alGridSel= alGrid.getSelectionModel().getSelection();
					if(alGridSel.length>0){
						
						params.academyLocationId = null;
					}
        	    	
        	    	var cmbProgram = tabItem.down('#cmbProgram');
        	    	var cmbBatch = tabItem.down('#cmbBatch');
        	    	var cmbPeriod = tabItem.down('#cmbPeriod');
        	    	var cmbSection = tabItem.down('#cmbSection');
        	    	params = this.getParamValues(searchTextBox, params, 'programName', (searchTextBox)?searchTextBox.getValue():'');
        	    	params = this.getParamValues(cmbProgram, params, 'programId', (cmbProgram)?cmbProgram.getValue():'');
        	    	params = this.getParamValues(cmbBatch, params, 'batchId', (cmbBatch)?cmbBatch.getValue():'');
        	    	params = this.getParamValues(cmbPeriod, params, 'periodId', (cmbPeriod)?cmbPeriod.getValue():'');
        	    	params = this.getParamValues(cmbSection, params, 'sectionId', (cmbSection)?cmbSection.getValue():'');
        	    	params.start = 0;
        			params.limit = -1;
        	    	break;
        		}
        		case 'courseListGrid':
        		case 'courseSelectedGrid':{
        			params = this.getParamValues(searchTextBox, params, 'courseName', (searchTextBox)?searchTextBox.getValue():'');
        	    	if(!isNullOrEmpty(academyLocationId)){
        	    		params.academyLocationId = academyLocationId;
        	    	}
        	    	params.start = 0;
        			params.limit = -1;
        			break;
        		}
        		case 'academyLocationListGrid': break;
        	}
        	
        	
        	
        }        
        
        return params;
    },
    /**
     * Get param values to load tab grid and panel
     */
    getParamValues: function(field, param, paramKey, paramValue){
    	if(field){
    		if(!isNullOrEmpty(paramKey) && !isNullOrEmpty(paramValue)){
    			param[paramKey] = paramValue;
    		}
    	}
    	return param;
    	
    },
    
    applyBusinessRule:function(me,frmResourceBooking,comboValue, combo, IsAlumni){
    	if(IsAlumni==true) {
    		var tabPanel=frmResourceBooking.down('#alumniResourceTabPanel');
    	}else {    		
    		var tabPanel=frmResourceBooking.down('#resourceBookingTabPanel');
    	}
    	var resourceForm = me.getFormComponent();
    	
    	var conductedBy = resourceForm.down('#cmbconductedBy');
    	conductedBy.allowBlank = true;
    	conductedBy.setVisible(false);
    	var bookedBy = resourceForm.down('#cmbBookedBy');
    	bookedBy.allowBlank = false;
    	bookedBy.setVisible(true);
    	
    	var noOfParticipants = resourceForm.down('#numOfParticipants');
    	noOfParticipants.allowBlank = false;
    	
    	var isMandatoryEvent = resourceForm.down('#isMandatoryEvent');
    	isMandatoryEvent.setVisible(true);
    	if(IsAlumni == false){
    		var resourceBookingTabPanel = resourceForm.down('#resourceBookingTabPanel');
    		resourceBookingTabPanel.show();
    		if(tabPanel){
    			if(!isNullOrEmpty(comboValue)){
    				if(comboValue==me.ACADEMIC_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(true);
    					tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					
    				}else if(comboValue==me.NON_ACADEMIC_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(true);        	
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(false);        	
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(false); 
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				}else if(comboValue==me.SELECTION_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				}else if(comboValue==me.ADDMISION_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				}else if(comboValue==me.EXAMINATION_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(true);        	
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(false);        	
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				}else if(comboValue==me.ORGANIZATION_BOOKING_PURPOSE){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(false);  
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				} else if(comboValue==me.EXTERNAL_EVENT_BOOKING_PURPOSE){
    					
    					bookedBy.allowBlank = true;
    					bookedBy.setVisible(false);
    					conductedBy.setVisible(true);
    					conductedBy.allowBlank = false;
    					noOfParticipants.allowBlank = true;
    					isMandatoryEvent.setVisible(false);
    					
    					resourceBookingTabPanel.hide();       	
    				} else if((combo!=null && combo!= undefined) && combo.getRawValue()==getCommonTranslation('MEETING')){
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('PROGRAM_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('COURSE_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACULTY_TABTITLE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ACADEMY_LOCATION_TABTILE'));
    					tab.setDisabled(true);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('USER_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('FACILITIES_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EQUIPMENTS_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('EXTERNAL_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    					var tab=me.getResourceBookingTab(tabPanel,getCommonTranslation('ADHOC_RESOURCE_TABTITLE'));
    					tab.setDisabled(false);
    				}
    			}
    		}    	
    		
    	}
    },
        
    /*
     * This function is used for to create Program Grid criteria and return params object    
     */
    createProgramGridCriteria: function(container) {
    	var me=this;
    	var params = new Object();
        
    	var academyLocationId=me.getCurrentAcademyLocation();
    	if(!isNullOrEmpty(academyLocationId)){
    		params.academyLocationId = academyLocationId;
    	}  
        
        if(container){        	
          	params=me.getFieldParam(container,'#txtName','programName',params);
          	params=me.getFieldParam(container,'#cmbProgram','programId',params);
            params=me.getFieldParam(container,'#cmbBatch','batchId',params);
            params=me.getFieldParam(container,'#cmbPeriod','periodId',params);
            params=me.getFieldParam(container,'#cmbSection','sectionId',params);             	
        }                
        
        return params;
    },
    
    /*
     * This function is used for to return field value inside param object    
     */
    
    getFieldParam:function(container,fieldItemId,key,params){
    	
    	var field = container.down(fieldItemId);
        if (field) {
            var fieldValue = field.getValue();
            if (!isNullOrEmpty(fieldValue)) {
            	params[key]=fieldValue;
            }                             
        }
        
        return params;
    },
    
    
    getAcademyLocation:function(param){
    	var academyLocationId=this.getCurrentAcademyLocation();
    	if(!isNullOrEmpty(academyLocationId)){
    		param.academyLocationId = academyLocationId;
    	}
    	return param;
    },
    
    compareDate:function(currentDateStr,eventDateStr){
				
    	var currentDate=null;
    	var eventDate=null;
    	
		if(!isNullOrEmpty(currentDateStr)){
			currentDate=new Date(currentDateStr.replace(/(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"));
		};
		
		if(!isNullOrEmpty(eventDateStr)){
			eventDate=new Date(eventDateStr.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"));
		};
		
		if(currentDate instanceof Date && eventDate instanceof Date){
			if(eventDate>=currentDate){
				return true;
			}else{
				return false;
			}											
		};
	},	
	
	checkAvailableCapacity:function(){		
        	var sumOfAvailableCapacity=0;
        	var numberOfParticipants =0;
        	var frmResourceBooking = this.getFormComponent();
        	var treePanel = frmResourceBooking.down('treepanel');
        	var numOfParticipants = frmResourceBooking.down('#numOfParticipants');
        	if(numOfParticipants){
        		numberOfParticipants=numOfParticipants.getValue(); 
        	}        	
        	if(treePanel){
        		var treeStore = treePanel.getStore();                                
                treeStore.getRootNode().cascadeBy(function(eachNode) {
                    if (!isNullOrEmpty(eachNode.data.model) && eachNode.data.model.resourceGroup==='FACILITY' && eachNode.data.checked &&
                    		!isNullOrEmpty(eachNode.data.model.capacity)) {
                        sumOfAvailableCapacity=sumOfAvailableCapacity+eachNode.data.model.capacity;
                    }
                });
        	}                   
            if(numberOfParticipants>sumOfAvailableCapacity){
            	return false;
            }else{
            	return true;
            }
	},
	
	/**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var resourceButton = gridReference.down("#spBtnResourceBookingMoreActions");//itemId of split button
   		var viewCalendar = gridReference.down("#btnViewCalendar");//itemId of split button
   		var manageMinutesButton = gridReference.down("#manageMinutesButtonItemId");
   		var printAttendanceSheet = gridReference.down("#printAttendanceSheetItemId");
   		var viewEventDetail = gridReference.down("#viewEventDetailItemId");
   		
   		if(resourceButton)
   		resourceButton.setVisible(false);
   		if(viewCalendar)
   			viewCalendar.setVisible(false);
   		if(manageMinutesButton)
   			manageMinutesButton.setVisible(false);
   		if(printAttendanceSheet)
   			printAttendanceSheet.setVisible(false);
   		if(viewEventDetail)
   			viewEventDetail.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(resourceButton)){
           			resourceButton.setVisible(true);//enable more action button
           		}        		
           	}else if(privilege === 'VIEWCALENDAR') {
           		if(!isNullOrEmpty(viewCalendar)){
           			viewCalendar.setVisible(true);//enable more action button
           		}        		
           	} else if (privilege === 'MANAGE_MINUTES') {
           		if (!isNullOrEmpty(manageMinutesButton)) {
           			manageMinutesButton.setVisible(true);
           		}        		
           	} else if (privilege === 'PRINT_ATTENDANCE_SHEET') {
           		if (!isNullOrEmpty(printAttendanceSheet)) {
           			printAttendanceSheet.setVisible(true);
           		}        		
           	}
           	else if (privilege === 'ALUMNI_VIEW_EVENT_DETAIL') {
           		if (!isNullOrEmpty(viewEventDetail)) {
           			viewEventDetail.setVisible(true);
           		}        		
           	}
       	});
       },
       resourceAssignCalendarClicked:function(){
    	   var $this = this;
    	   var grid=$this.getResourceBookingGrid();
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   var formWindow = $this.getAssigncalendarwin();
    		   if (!formWindow) {
    			   Ext.widget('assigncalendarwin');
    			   formWindow = $this.getAssigncalendarwin();
    		   }
    		   formWindow.show();
    	   }else {
    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    	   }
       },
       saveAssignCalendarDetails:function(){
           var $this = this;
           var window = $this.getAssigncalendarwin();
           var form = $this.getAssignCalendarwin().getForm();
           var grid=$this.getResourceBookingGrid();
           var values = form.getValues();
          /* var id = form.down('#id');
           if (isNullOrEmpty(id.getSubmitValue())) {
               submitUrl = SERVERURL.EVENT_CALENDAR_SAVE;
               isUpdate = false;
           } else {
               submitUrl = SERVERURL.EVENT_CALENDAR_UPDATE;
               isUpdate = true;
           }
           var jsonFormatFormData = $this.getJsonSubmitData(form);*/
           if (grid.getSelectionModel().getCount() > 0) {
        	   var records = grid.getSelectionModel().getSelection();
        	   if (!isEmpty(records)) {
        		   var jsonFormatFormData = {
        				   "resourseBookingId": records[0].data.ID,
        				   "eventCalendarId": values.calendarId
        		   }
        	   }

        	   $this.applyWindowMask(); 

        	   this.sendSaveAjaxRequest(SERVERURL.ASSIGN_EVENT_CALENDAR, 'POST', jsonFormatFormData, function(option, success, response) {
        		   $this.hideWindowMask();
        		   if(success){
        			   window.close();
        			   grid.getStore().reload();
        			   grid.getSelectionModel().deselectAll();
        			   showSuccessMessage(getServiceRequestTranslation('ASSIGN_CALENDAR'), getServiceRequestTranslation('ASSIGN_CALENDAR_ADD_SUCCESS'));
        		   }else{
        			   window.close();
        			   grid.getStore().reload();
        			   alert(getErrorTranslation('CALENDER_DATE_MISMATCH'));
        		   }
        	   });
           }else {
    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    	   }
       },
       populateFormData:function(component ,meeting, formData) {
    	   if(formData != undefined) {
    		   var committeeId= formData.committee.id;
        	   var $this = this;
        	   var activeTab = $this.getActiveTabfromContentPanel();
        	   var purpose = component!=undefined?component.getRawValue():meeting;
        	   var form = activeTab.down('form').getForm();
        	   //var form = $this.getPanelResourceBookingFormLayout().getForm();
        	   var frmResourceBooking = $this.getFormComponent();
        	   var committee = form.findField('committee');
        	   var bookedBy = form.findField('bookedBy');
        	   if(purpose != null && purpose==getCommonTranslation('MEETING')) {
        			   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        			   var documentGrid = $this.getMeetingdocumentgrid();
        			   //documentGrid.setVisible(true);
        			   documentGrid.getStore().removeAll();
        			   documentGrid.getStore().loadData([]);
        			   var grid2 = $this.getPanelResourceBookingFormLayout().down('#userSelectedGrid');
        			   var grid1 = $this.getPanelResourceBookingFormLayout().down('#userListGrid');
        			   Ext.apply(grid1,{
        				   code:null,
        				   setCode : function(code){
        					   grid1.code = code;
        				   },
        				   getCode:function(){
        					   return grid1.code;
        				   }
        			   });
        			   var store1 = grid1.getStore();
        			   var store2 = grid2.getStore();
        			   if(meeting==getCommonTranslation('MEETING')) {
        				   grid1.setCode(1);
//        				   var grid = frmResourceBooking.down('#userSelectedGrid');
//        				   grid2.reconfigure(Ext.create('Academia.store.facilitiesresources.resourcebooking.UserSelectedStore'));
//        				   var store = $this.getStore('Academia.store.committee.committee.CommitteeParticipantGridStore');
        				   store1.removeAll();
        				   store1.loadData([]);
        				   store1.getProxy().api.read = SERVERURL.FIND_ALL_RESOURCE_BOOKING_USERS+"?resourceBookingId="+formData.id;
        				   store1.getProxy().actionMethods.read= 'GET';
        				   store1.load({
        					   callback:function(record){
        						   Ext.getBody().unmask();
        						   for(var i in record) {
        							   userListArr.push({
        								   "name":record[i].data.printName,
        								   "id":record[i].data.id,
        							   });
        						   }
        						   store2.removeAll();
        						   store2.loadData([]);
        						   store2.getProxy().api.read = SERVERURL.RESOURCE_BOOKING_LIST_USER;
        						   store2.getProxy().actionMethods.read= 'POST';
           						   store2.loadData(userListArr); 
           						   store1.loadData([]);
           						   store1.getProxy().api.read = SERVERURL.COMMITTEE_FIND_ALL_PARTICIPANT+"?committeeId="+committeeId;
           						   store1.getProxy().actionMethods.read= 'POST';
           						   store1.load({
           							  callback:function(records){
           								  store1.loadData([]);
           								  var userListArr=[];
           								  for(var i in records) {
           									  var flag = false;
           									  for(var j in record) {
           										 if(record[j].data.id == records[i].data.id) {
           											 flag=true;
           											 break;
           										 }
           									 }
           									 if(!flag) {
           										userListArr.push({
                   								   "name":records[i].data.name,
                   								   "id":records[i].data.id,
                   							   });
           									 }
              						     }
           								 store1.loadData(userListArr);
           								var component = form.findField('bookingPurpose');
           		        			   component.getStore().load({
           		        				   callback:function(record) {
           		        					   for (var i in record) {
           		        						  if(record[i].data.value==getCommonTranslation('MEETING')) {
           		        							  component.setValue(record[i].data.id);  
           		        						  }
           		        					   }
		           		        			Ext.suspendLayouts();
		//           		        			$this.selectBookingPurpose(form.findField('bookingPurpose'), null, null);  
		           		        			if(form.findField('bookingPurpose') != undefined && !isNullOrEmpty(form.findField('bookingPurpose').getValue())) {
		           		        				$this.applyBusinessRule($this,frmResourceBooking,form.findField('bookingPurpose').getValue(), form.findField('bookingPurpose'));
		            		        			   var loadPanelObject = {
		            		        					   isFacilityTree: true, isEquipement: true, isExternal: true, isFaculty: true, 
		            		        					   isUser: true, isProgram: false, isCource: false, isAcademyLocation: true
		            		        			   };
		            		        			$this.loadDataForResourceBookingTab(frmResourceBooking, loadPanelObject);
		           		        			}
		           		        			Ext.resumeLayouts();
           		        				   }
           		        			   });
           		        			   committee.setVisible(true);
           		        			   committee.allowBlank=false;
           		        			   var store = $this.getStore('user.UserAcademyLocationStore');
           		        			   var alids=[];
           		        			   store.getProxy().extraParams={
           		        				   id:$this.getCurrentlyLoggedInUser().id
           		        			   }
           		        			   store.load({
           		        				   callback:function(record) {
           		        					   for (var i in record) {
           		        						   alids.push(record[i].data.id);
           		        					   }
           		        					   committee.getStore().getProxy().extraParams={
           		        						   academyLocationIds:alids.join()
           		        					   };
           		        					   committee.getStore().load({
           		        						   callback:function(record) {
           		        	    					   for (var i in record) {
           		        	    						   if(record[i].data.id==committeeId){
           		        	    							   committee.setValue(record[i].data.id);
           		        	    						   }
           		        	    						   
           		        	    					   }
           		        						   }
           		        					   });
           		        				   }
           		        			   });
           		        			   var isMendatory  = form.findField('isMendatory');
           		        			   var eventDesc   = form.findField('eventDesc');
           		        			   var purposeDesc = form.findField('purposeDesc');
           		        			   isMendatory.setVisible(false);
           		        			   //eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA')+"<span style='color:red'>*</span>");
           		        			   eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA'));
           		        			   eventDesc.setWidth(256);
           		        			   eventDesc.clearInvalid();
           		        			   $this.setAllowBlank(eventDesc, false);
           		        			   purposeDesc.setVisible(false);
           		        			   Ext.getBody().unmask();
           							  }
           						  });
           						documentGrid.getStore().getProxy().api.read = SERVERURL.FIND_ALL_RESOURCE_BOOKING_DOCS;
           						documentGrid.getStore().getProxy().extraParams={
           							resourceBookingId:formData.id,
           							committeeId:committeeId
           						};
//           						documentGrid.down('#btnDelete').setVisible(false);
           						documentGrid.getStore().load();
        					   }
        				   });
        				   var selectedGridData = [], userListArr=[];
        				   var dataModel, dataModelGrid;//name, id
        				   var addIds=[];
        			   }
        	   }
    	   }
       },
       saveEventBannerImage : function(isUpdate, eventId, grid){
    	   var this$ = this;
    	   var form = this$.getPanelResourceBookingFormLayout();
    	   var uploadForm = form.down('#eventBannerItemId');
    	   var photoFileImage = uploadForm.down('filefield#photoFileImage');
    	   var fileUploadPath = photoFileImage.getValue();
    	   var uploadUrl = SERVERURL.RESOURCE_BOOKING_UPLOAD_EVENT_BANNER;
    	   if(!isNullOrEmpty(fileUploadPath)){
    		   form.getForm().submit({
    			   type: 'rest',
    			   url: uploadUrl,
    			   method: 'POST',
    			   params:{
    				   eventId : eventId
    			   },
    			   success: function(form, action) {
    				   Ext.getBody().unmask();
    				   if (isUpdate) {
    					   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) updated successfully.											
    				   } else {
    					   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) added successfully.										
    				   }
    				   this$.closeResourceBookingFormTab();
    				   tabName = getCommonTranslation('EVENT_DETAILS');
    	    		   var getcontroller = this$.getController('menu.CoreERPNavigationController');
    	    		   var getTab = getcontroller.getTab(tabName);
    	    		   var campaignTabName = getMegaMenuTranslation('TS_TOOLS_MAKE_A_BOOKING');
    				   var getResourceBookingTabName = getcontroller.getTab(campaignTabName);
    					if (getTab != null) {
    						contentPanel.remove(getTab, true);
    					}
    					if (getResourceBookingTabName != null) {
    						contentPanel.setActiveTab(getResourceBookingTabName);
    					}
                       if(grid != undefined) {
    	            		var grdStore = grid.getStore();
    	                    grid.getSelectionModel().deselectAll();
    	                    grdStore.reload();
    	            	}
    				  
    				   //showSuccessMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('ORGINFOSUCCESS'));

    			   }
    		   });
    	   }
    	   else{
    		   Ext.getBody().unmask();
    		   if (isUpdate) {
    			   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) updated successfully.											
    		   } else {
    			   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_EVENT_DETAILS_MSG')); //Event Details(Resource Booking) added successfully.										
    		   }
    		   tabName = getCommonTranslation('EVENT_DETAILS');
    		   this$.closeResourceBookingFormTab();
    		   var getcontroller = this$.getController('menu.CoreERPNavigationController');
    		   var getTab = getcontroller.getTab(tabName);
    		   var campaignTabName = getMegaMenuTranslation('TS_TOOLS_MAKE_A_BOOKING');
			   var getResourceBookingTabName = getcontroller.getTab(campaignTabName);
				if (getTab != null) {
					contentPanel.remove(getTab, true);
				}
				if (getResourceBookingTabName != null) {
					contentPanel.setActiveTab(getResourceBookingTabName);
				}
    	   }
       },
       displayEventBannerImage:function(eventId, isAlumni) {
    	   var this$ = this;
    	   var form;
    	   if(isAlumni == true) {
    		   form = this$.getAlumniresourcebookingformlayout()
    	   }else {
    		   form = this$.getPanelResourceBookingFormLayout();
    	   }
    	   Ext.Ajax.request({
    		   type: 'rest',
    		   binary: true,
    		   url: SERVERURL.RESOURCE_BOOKING_DOWNLOAD_EVENT_BANNER,
    		   method: 'GET',
    		   params:{
				   eventId : eventId
			   },
    		   success: function(res, action) {
    			   Ext.suspendLayouts();
    			   if(res.status == 200){
    				   var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
    				   var url = window.URL.createObjectURL(blob);
    				   if(form.down('#eventBannerBgImage') && form.down('#eventBannerBgImage').getEl()){
    					   form.down('#eventBannerBgImage').getEl().dom.src=url;
    				   }
    			   }
    			   Ext.resumeLayouts();
    		   }
    	   });
       },
       resourceMarkEventAttendanceMenuClicked:function(){

    	   var manageEventGrid = this.getResourceBookingGrid();
    	   if(grid.getSelectionModel().getCount()>0) {
    		   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		   var structure = Ext.widget('markeventattendancetab');
    		   var tabName = getCommonTranslation('MARK_EVENT_ATTENDANCE');
    		   /**
    		    * This is to remove tab from content panel and open same tab again
    		    */
    		   var getcontroller=this.getController('menu.CoreERPNavigationController');
    		   var getTab=getcontroller.getTab(tabName);
    		   if(getTab!=null){
    			   contentPanel.remove(getTab, true);
    		   }
    		   openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
    	   }else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
       },
       onChangeRadioButton:function(obj,record){
     	   var attendanceStatus = record.markAttendance;
    	   var grid = this.getMarkeventattendancegrid();
    	   var store = grid.getStore();
    	   var models = grid.getStore().getRange();
    	   var abs=0,pre=0,oth=0;
    	   store.suspendEvents();
    	   if(attendanceStatus == 'PRESENT' || attendanceStatus == 'Present'){
    		   store.each(function (rec) {
    			   rec.set('present', true);
    			   rec.set('absent', false);
    			   rec.set('attendanceStatus', null);
    		   });
    	   }else if(attendanceStatus == 'ABSENT' || attendanceStatus == 'Absent'){
    		   store.each(function (rec) {
    			   rec.set('present', false);
    			   rec.set('absent', true);
    			   rec.set('attendanceStatus', null);
    		   });
    	   }
    	   store.resumeEvents();
    	   grid.getView().refresh();
       },
       saveMakrAttendance:function() {
    	   var $this = this;
    	   var EventAttendance= [];
    	   var grid = $this.getMarkeventattendancegrid();
    	   var userType = grid.down('#userTypeEventAttend').getValue();
    	   var date = grid.down('#EventAttendanceDate').getValue();
    	   var store = grid.getStore();
    	   var manageEventGrid = this.getResourceBookingGrid();
   	       var records = manageEventGrid.getSelectionModel().getSelection()[0];
    	   
    	  
    	   if(store.data.length > 0) {
    		   var date = Ext.Date.format(new Date(date), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
    		   var models = store.getRange();
    		   for(var i=0; i<store.data.length; i++){
    			   var attendanceStatus = null;
    			   if(models[i].data.present == true || models[i].data.present == 'true'){
    				   attendanceStatus = 'PRESENT';
    			   }else if(models[i].data.absent == true || models[i].data.absent == 'true'){
    				   attendanceStatus = 'ABSENT';
    			   }else{
    				   continue;
    			   }
    			   
    			   var resourceBookingUser={
			   				"id":	models[i].data.resourceBookingUserId
			   			};
    			   var staff={
			   				"id":	models[i].data.userId
			   			};
    			   var student={
			   				"id":	models[i].data.studentId
			   			};
    			   var department={
			   				"id": models[i].data.deptNameId
			   			};
    			   if(userType=="faculty"){
    				   EventAttendance.push({
        				   "id": models[i].data.attendanceId,
        				   "resourceBookingUser":resourceBookingUser,
        				   "dateOfAttendance": date,
        				   "department": department,
        				   "staff": staff,
        				   "attendanceStatus": attendanceStatus
        			   });
    			   }else{
    				   EventAttendance.push({
        				   "id": models[i].data.attendanceId,
        				   "resourceBookingUser":resourceBookingUser,
        				   "dateOfAttendance": date,
        				   "student":student,
        				   "attendanceStatus": attendanceStatus
        			   });
    			   }
    			   
    		   }
    		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		   submitUrl = SERVERURL.PATH_SAVE_MARK_EVENT_ATTENDANCE;
    		   Ext.Ajax.request({
    			   type : 'rest',
    			   url : submitUrl,
    			   jsonData : EventAttendance,
    			   method : 'POST',
    			   success : function(form1, action) {
    				   Ext.getBody().unmask();
    				   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('SAVE_EVENT_ATTENDENCE_SUCCCESS'));
    				   $this.resetEventMarkAttendance()
    			   },
    		   });
    	   }
    	   else {
    		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));			
    	   }
       },
       resetEventMarkAttendance:function(){
    	   var $this = this;
    	   var grid = $this.getMarkeventattendancegrid();
    	   grid.getStore().removeAll();
    	   grid.down('#EventAttendanceDate').reset();
    	   grid.down('#markAttendanceRadioId').reset();
    	   grid.down('#submitBtn').setDisabled(true);
       },
});