/**
 * @author Sandeep.Ladvikar,prathamesh.sheth
 * 
 * This is the file is controller for the Resource Master
 *   
 * */
Ext.define('Academia.controller.facilitiesresources.resourcemaster.ResourceMaster', {
    extend: 'Academia.controller.base.BaseController',
    views: ['baselayout.contentarea.ContentPanel','facilitiesresources.resourcemaster.ResourceList', 
            'facilitiesresources.resourcemaster.EquipmentGrid', 'facilitiesresources.resourcemaster.ExternalResourcesGrid', 
            'facilitiesresources.resourcemaster.ResourceBasicDetails', 'facilitiesresources.resourcemaster.SeatCapacityGrid',
            'facilitiesresources.resourcemaster.ResourceFormTabs', 'facilitiesresources.resourcemaster.PrimaryAcademyLocationForm', 
            'facilitiesresources.resourcemaster.ResourceMasterForm', 'facilitiesresources.resourcemaster.OtherAcademyLocationGrid', 
            'facilitiesresources.resourcemaster.ProgramGrid', 'facilitiesresources.resourcemaster.ProgramGridWindow',
            'facilitiesresources.resourcemaster.PermanentUnavailibilityForm', 'facilitiesresources.resourcemaster.TemporyUnavailibilityForm', 
            'facilitiesresources.resourcemaster.PermanentUnavailabilityFormWindow', 'facilitiesresources.resourcemaster.TemporaryUnavailabilityFormWindow', 
            'facilitiesresources.resourcemaster.ProgramsTreeWindow', 'facilitiesresources.resourcemaster.ProgramsTree', 
            'facilitiesresources.resourcemaster.CoursesSelectorWindow', 'facilitiesresources.resourcemaster.CoursesSelector', 
            'facilitiesresources.resourcemaster.CourseGridWindow', 'facilitiesresources.resourcemaster.CourseGrid', 'facilitiesresources.resourcemaster.FacilityTree',
            'facilitiesresources.resourcemaster.HostelTree','facilitiesresources.resourcemaster.FacilityMasterUploaddownloadStructure',
            'facilitiesresources.resourcemaster.FacilityMasterDownloadForm','facilitiesresources.resourcemaster.FacilityMasterUploadForm',
             'importutility.ImportByModule.Importlistfacilitymastergridupload',
             'UploadOptionRadioGroup'
            ],
   
    stores: ['facilitiesresources.resourcebooking.EquipmentListStore', 'facilitiesresources.resourcebooking.ExternalResourceListStore',
             'facilitiesresources.resourcebooking.ResourceGroupStore', 'facilitiesresources.resourcebooking.ResourceTypeStore',
             'facilitiesresources.resourcemaster.ResourceStatusStore','facilitiesresources.resourcebooking.AcademyLocationListStore',
             'facilitiesresources.resourcemaster.SeatCapacityGridStore',
             'facilitiesresources.resourcemaster.OtherAcademyLocationStore', 'facilitiesresources.resourcemaster.ProgramGridStore',
             'facilitiesresources.resourcemaster.ProgramTreeStore', 'facilitiesresources.resourcemaster.CoursesSelectorStore',
             'facilitiesresources.resourcebooking.ResourceBookingFormFacilitiesTreeStore', 'facilitiesresources.resourcemaster.CalenderStore',
             'facilitiesresources.resourcemaster.OtherAcademyLocationComboStore',
             'facilitiesresources.resourcemaster.ReasonStore','facilitiesresources.resourcemaster.LocationListStore',
             'course.CourseComboStore',
             'facilitiesresources.resourcemaster.ProgramListGridStore','transport.vehicle.VehicleSubType','securitysetup.ProgramsForUsers',
             'facilitiesresources.resourcebooking.HostelResourceBookingFormFacilitiesTreeStore',
             'facilitiesresources.resourcebooking.HostelResourceTypeStore','facilitiesresources.resourcemaster.FacilityMasterTypeStore',
             'importutility.ImportFacilityMasterStore','importutility.ModuleName','facilitiesresources.resourcebooking.AcademyLocationListByUserStore'],
             
      models: ['facilitiesresources.resourcemaster.UnavailableInfoModel', 'facilitiesresources.resourcemaster.ResourceMasterModel',
               'facilitiesresources.resourcemaster.PrimaryAcademyLocationModel'],
   
    //models: ['facilitiesresources.resourcemaster.ResourceCriteria','facilitiesresources.resourcemaster.UnavailableInfoModel'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    },{
        ref: 'programgrid',
        selector: 'programgrid'
    }, {
        ref: 'grdEquipment',
        selector: 'equipmentgrid'
    },{
        ref: 'grdExternalResource',
        selector: 'externalresourcegrid'
    }, {
        ref: 'treeFacility',
        selector: 'facilitytree'
    },{
        ref: 'hosteltreeTreeFacility',
        selector: 'hosteltree'
    }, {
        ref: 'resourcebasicdetails',
        selector: 'resourcebasicdetails'
    }, {
        ref: 'permanentFormwindow',
        selector: 'permanentFormwindow'
    }, {
        ref: 'temporaryformwindow',
        selector: 'temporaryformwindow'
    }, {
        ref: 'temproryunavailform',
        selector: 'temproryunavailform'
    }, {
        ref: 'programTreeWindow',
        selector: 'programtreewindow'
    }, {
        ref: 'courseSelectorWindow',
        selector: 'courseselectorwindow'
    }, {
        ref: 'programgridwindow',
        selector: 'programgridwindow'
    }, {
        ref: 'coursegridwindow',
        selector: 'coursegridwindow'
    }, {
        ref: 'seatcapacity',
        selector: 'seatcapacity'
    },{
    	ref:'resourcemasterform',
    	selector:'resourcemasterform'
    },{
    	ref:'primaryacademyloc',
    	selector:'primaryacademyloc'
    },{
    	ref:'courseSelectorTree',
    	selector:'courseselector'
    },{
    	ref:'programTree',
    	selector:'programtree'
    },{
    	ref:'coursegrid',
    	selector:'coursegrid'
    },{
    	ref:'facilitymasteruploaddownloadstructure',
    	selector:'facilitymasteruploaddownloadstructure'
    },{
    	ref:'facilitymasterdownloadform',
    	selector:'facilitymasterdownloadform'
    },{
    	ref:'facilitymasterdownloadform',
    	selector:'facilitymasterdownloadform'
    },{
    	ref:'facilitymasteruploadform',
    	selector:'facilitymasteruploadform'
    },{
    	ref:'importlistfacilitymastergridupload',
    	selector:'importlistfacilitymastergridupload'
    },{
   		ref : 'uploadoptionradiogroup',
   		selector : 'uploadoptionradiogroup[itemId=facilityMasterListUploadOptionRadioGroupItemId]'
   	}],
    config: {
        slotCount: 0,
        courses: null,
        menuController:null,
        FACILITIES_RESOURCES_FACILITIES_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACILITIES_RESOURCES_FACILITIES_PRIVILEGES'),
        FACILITIES_RESOURCES_EQUIPMENT_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACILITIES_RESOURCES_EQUIPMENT_PRIVILEGES'),
        FACILITIES_RESOURCES_EXTERNALRES_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACILITIES_RESOURCES_EXTERNALRES_PRIVILEGES'),
        IMPORT_FACILITY_AND_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('IMPORT_FACILITY_AND_MASTER_PRIVILEGES'),
		CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
		FACILITIES_MASTER_HOSTEL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACILITIES_MASTER_HOSTEL_PRIVILEGES'),
    },
    init: function(application) {

        this.FACILITY_TAB = 1;
        this.EQUIPMENT_TAB = 2;
        this.EXTERNAL_RESOURCE_TAB = 3;
        this.HOSTEL_TAB = 4;

        this.INTERNAL_RESOURCE_CATEGORY = 1;
        this.EXTERNAL_RESOURCE_CATEGORY = 2;

        this.FACILITY_RESOURCE_GROUP = 1;
        this.EQUIPMENT_RESOURCE_GROUP = 2;
        this.HOSTAL_RESOURCE_GROUP = 3;
        
        
        this.setMenuController(Academia.app.getController('menu.CoreERPNavigationController'));
        
        this.unavailInfo = {};
        
        this.position = 4;
        
        this.unavailInfoModel = new Academia.model.facilitiesresources.resourcemaster.UnavailableInfoModel();

        this.control({        	
            'facilitytree[itemId=facilitytree] #spBtnFacilityTabAddActions menuitem[itemId=btnAddFacility]': {
                click: Ext.bind(this.addResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY, this.FACILITY_RESOURCE_GROUP])
            },
            'facilitytree[itemId=facilitytree] #spBtnFacilityTabAddActions menuitem[itemId=btnAddEquipment]': {
                click: Ext.bind(this.addResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY, this.EQUIPMENT_RESOURCE_GROUP])
            },
           /* 'facilitytree[itemId=facilitytree] #spBtnFacilityTabAddActions menuitem[itemId=btnAddHostel]': {
                click: Ext.bind(this.addResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY, this.HOSTAL_RESOURCE_GROUP])
            },*/
            'hosteltree[itemId=hostalfacilitytree] button[itemId=btnAdd]': {
                click: Ext.bind(this.addResource, this, [this.HOSTEL_TAB, this.INTERNAL_RESOURCE_CATEGORY, this.HOSTAL_RESOURCE_GROUP])
            },
            'equipmentgrid button[itemId=btnAdd]': {
                click: Ext.bind(this.addResource, this, [this.EQUIPMENT_TAB, this.INTERNAL_RESOURCE_CATEGORY, this.EQUIPMENT_RESOURCE_GROUP])
            },
            'externalresourcegrid #spBtnExtrenalResourceTabAddActions menuitem[itemId=btnAddFacExternalResource]': {
                click: Ext.bind(this.addResource, this, [this.EXTERNAL_RESOURCE_TAB, this.EXTERNAL_RESOURCE_CATEGORY, this.FACILITY_RESOURCE_GROUP])
            },
            'externalresourcegrid #spBtnExtrenalResourceTabAddActions menuitem[itemId=btnAddEquExternalResource]': {
                click: Ext.bind(this.addResource, this, [this.EXTERNAL_RESOURCE_TAB, this.EXTERNAL_RESOURCE_CATEGORY, this.EQUIPMENT_RESOURCE_GROUP])
            },
            'facilitytree[itemId=facilitytree] button[itemId=btnEdit]': {
                click: Ext.bind(this.editResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY,false])
            },
            'facilitytree[itemId=facilitytree] button[itemId=btnView]': {
                click: Ext.bind(this.editResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY,true])
            },
            'facilitytree[itemId=facilitytree] button[itemId=btnDelete]': {
                click: Ext.bind(this.deleteResource, this, [this.FACILITY_TAB, this.INTERNAL_RESOURCE_CATEGORY])
            },
            'hosteltree[itemId=hostalfacilitytree] button[itemId=btnEdit]': {
                click: Ext.bind(this.editResource, this, [this.HOSTEL_TAB, this.INTERNAL_RESOURCE_CATEGORY,false])
            },
            'hosteltree[itemId=hostalfacilitytree] button[itemId=btnView]': {
                click: Ext.bind(this.editResource, this, [this.HOSTEL_TAB, this.INTERNAL_RESOURCE_CATEGORY,true])
            },
            'hosteltree[itemId=hostalfacilitytree] button[itemId=btnDelete]': {
                click: Ext.bind(this.deleteResource, this, [this.HOSTEL_TAB, this.INTERNAL_RESOURCE_CATEGORY])
            },
            'equipmentgrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editResource, this, [this.EQUIPMENT_TAB, this.INTERNAL_RESOURCE_CATEGORY,false])
            },
            'equipmentgrid button[itemId=btnView]': {
                click: Ext.bind(this.editResource, this, [this.EQUIPMENT_TAB, this.INTERNAL_RESOURCE_CATEGORY,true])
            },
            'equipmentgrid button[itemId=btnDelete]': {
                click: Ext.bind(this.deleteResource, this, [this.EQUIPMENT_TAB, this.INTERNAL_RESOURCE_CATEGORY])
            },
            'externalresourcegrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editResource, this, [this.EXTERNAL_RESOURCE_TAB, this.EXTERNAL_RESOURCE_CATEGORY,false])
            },
            'externalresourcegrid button[itemId=btnView]': {
                click: Ext.bind(this.editResource, this, [this.EXTERNAL_RESOURCE_TAB, this.EXTERNAL_RESOURCE_CATEGORY,true])
            },
            'externalresourcegrid button[itemId=btnDelete]': {
                click: Ext.bind(this.deleteResource, this, [this.EXTERNAL_RESOURCE_TAB, this.EXTERNAL_RESOURCE_CATEGORY])
            },
            'primaryacademyloc customcombobox[itemId=academyLocation]': {
                render: function(component, options) {
                	component.getStore().load();
                	var form = component.up('primaryacademyloc');
                	var comboAssignCalender = form.down('#comboAssignCalender');
                	//this.loadCalendarCombo(comboAssignCalender, component.getValue());
                },
                select: function(combo, records, eOpts) {
                	var form = combo.up('primaryacademyloc');
                	var comboAssignCalender = form.down('#comboAssignCalender');
                	combo.isChecked = true;
                	comboAssignCalender.reset();
                	var newValue = records[0].get('id');
                	if(!isNaN(newValue)){
                		var store =comboAssignCalender.getStore();
                    	store.getProxy().extraParams = {              
                    		academyLocationId: newValue
                    	};
                    	store.load();	
                	}
                }
            },   
            /*'primaryacademyloc #comboAssignCalender': {
                render: function(combo, records, eOpts) {
                	this.loadCalendarCombo(combo);
                }                	
            },*/
            
            'primaryacademyloc #btnViewAvailableProgram': {
            	click: function(btn){
                	this.showProgramTree(btn, true, true);
                }
            },
            'facilitytree[itemId=facilitytree] button[itemId=exportReportsId]':{
				click : this.exportReportfun
			},
            'primaryacademyloc #btnAvailableProgram': {
                click: function(btn){
                	this.showProgramTree(btn, true, false);
                }
            },
            'programtreewindow programtree[itemId=programTreePanel]': {
                checkchange: function(node, checked, eOpts) {
                	if (!isNullOrEmpty(node.data.depth) && node.data.depth == 3) {
                		showInfoMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECTED_BATCH_NOT_MAPPED_INDEPENDENTLY')); //Selected equipment should not be booked independently.
                		if(node.parentNode.data.checked){
                			node.set('checked', true);
                		}else{
                			node.set('checked', false);
                		}
                		
                    }else{
	                    node.cascadeBy(function(node) {
	                        node.set('checked', checked);
	                    });
	                    
                    }    
                }
            },
            'programtreewindow button[itemId=btnAddSelectedItems]': {
                click: function(btn){
                	this.saveProgramTree(btn);
                }
            },

            'primaryacademyloc #btnViewAvailableCourses': {
            	click: function(btn){
                	this.showCoursesSelector(btn, true, true);
                }
            },
            
            'primaryacademyloc #btnAvailableCourses': {
                click: function(btn){
                	this.showCoursesSelector(btn, true, false);
                }
            },

            
            'courseselectorwindow button[itemId=btnAddSelectedItems]': {
            	click: function(btn){
                	this.saveCourseTree(btn);
                }
            },
            'otheracadloc button[itemId=othAcadLocAddButton]': {
            	click: Ext.bind(this.addOtherAcademyLocation, this)
            },
            'otheracadloc button[itemId=othAcadLocDeleteButton]': {
            	click: Ext.bind(this.deleteOtherAcademyLocation, this)
            },
            'otheracadloc #menuViewProgram': {
            	click: function(btn){
                	this.showProgramTree(btn, false, true);
                }
            },

            'otheracadloc #menuViewCourses': {
            	click: function(btn){
                	this.showCoursesSelector(btn, false, true);
                }
            },

            'otheracadloc #menuChangeProgram': {
            	click: function(btn){
                	this.showProgramTree(btn, false, false);
                }
            },

            'otheracadloc #menuChangeCourses': {
            	click: function(btn){
                	this.showCoursesSelector(btn, false, false);
                }
            },

            'resourcemasterform #btnSaveResource': {
                click: this.saveResource
            },
 		   'resourcemasterform button[itemId=resetButtonId]': {
 			   click: function(){
 				   var $this=this;
             	   var form = $this.getResourcemasterform();
 				   this.resetResourceMasterForm(form);
 			   }
 		   },
            'temproryunavailform #btnSaveTempUnavailReason': {
                click: this.saveUnavailableInfo
            },
            'temproryunavailform #cancelButtonId': {
                click: function(){
                	this.getTemporaryformwindow().close();
                	this.getResourcebasicdetails().getForm().findField('status').setValue("");
                } 	
            },
            'permananentunavailform #btnSavePermanentUnvailReason': {
                click: this.savePermanentUnvailReason
            },
            'permananentunavailform #cancelButtonId': {
                click: function(){
                	this.getPermanentFormwindow().close();
                	this.getResourcebasicdetails().getForm().findField('status').setValue("");
                } 	
            },
            'resourcebasicdetails':{
            	validitychange:function(form,valid,eopts) {
            		//this.checkFormValidity(form,valid);            		
            	},

        		afterrender:function(form){
        			var hostelTypeItemId =form.down('#hostelType');
					var clusterCodeItemId = form.down('#clusterCode');
					var hostelLevelItemId = form.down('#hostelLevel');
					var hostelCategoryItemId = form.down('#hostelCategory');
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						url: SERVERURL.COMMON_FORM_FIELD_INFO,
						params: {
							screenName: 'resourcebasicdetails',
							academyLocationId: this.getCurrentAcademyLocation(),
							languageCode:'en'
						},
						method: 'GET',
						success: function(res, action) {
							var response = Ext.decode(res.responseText);
							if( Object.keys(response).length > 0 ){
								var records=response.resourcebasicdetails;
								var allowblankFalse = '<span class="required" style="color:red"> *</span>'; 
								for(i in records){
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isVisible==true){
										form.clusterCodeVisible = true
									}
									
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isVisible==true){
										form.hostelTypeVisible = true
										
										
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isVisible==true){
										form.hostelLevelVisible = true
										
										
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isVisible==true){
										form.hostelCategoryVisible = true
										
										
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isVisible==true){
										clusterCodeItemId.setVisible(true);
										clusterCodeItemId.setFieldLabel(getCommonTranslation('CLUSTER_CODE') +':')
										
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isMandatory==true){
										clusterCodeItemId.allowBlank=false;
										clusterCodeItemId.setFieldLabel(getCommonTranslation('CLUSTER_CODE') +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isMandatory==true && records[i].isVisible==false){
										clusterCodeItemId.allowBlank=true;
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isVisible==true){
										hostelTypeItemId.setVisible(true);
										hostelTypeItemId.setFieldLabel(getCommonTranslation('HOSTEL_TYPE') +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isMandatory==true){
										hostelTypeItemId.allowBlank=false;
										hostelTypeItemId.setFieldLabel(getCommonTranslation('HOSTEL_TYPE') +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelTypeItemId.allowBlank=true;
									}
									
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isVisible==true){
										hostelLevelItemId.setVisible(true);
										hostelLevelItemId.setFieldLabel(getCommonTranslation('HOSTEL_LEVEL') +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isMandatory==true){
										hostelLevelItemId.allowBlank=false;
										hostelLevelItemId.setFieldLabel(getCommonTranslation('HOSTEL_LEVEL') +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelLevelItemId.allowBlank=true;
									}
									
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isVisible==true){
										hostelLevelItemId.setVisible(true);
										hostelLevelItemId.setFieldLabel(getCommonTranslation('HOSTEL_CATEGORY') +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isMandatory==true){
										hostelLevelItemId.allowBlank=false;
										hostelLevelItemId.setFieldLabel(getCommonTranslation('HOSTEL_CATEGORY') +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelLevelItemId.allowBlank=true;
									}

								}
							}else{
								hostelTypeItemId.setVisible(false);
								clusterCodeItemId.setVisible(false);
								hostelLevelItemId.setVisible(false);
								hostelCategoryItemId.setVisible(false);
							}
						}

					});
        		}
        	
            },
            'resourcebasicdetails #formComboResourceStatusId': {
                select: function(combo, records, eOpts) {
                	this.openStatusPopUp(records);
                }
            },
            'temproryunavailform #radioSpecificSlot':{
            	change:function(radio, newValue, oldValue,eopts){
            		this.toggleTimeSlots(newValue);
            	}
            },
            'hosteltree[itemId=hostalfacilitytree] button[itemId=resetButton]': {
            	click:function(){
            		var hosteltreeTreeFacility = this.getHosteltreeTreeFacility();
            		hosteltreeTreeFacility.down('#cmbLocation').clearValue();
            		hosteltreeTreeFacility.down('#cmbResourceTypeHosetl').clearValue();
            		hosteltreeTreeFacility.down('#cmbResourceStatus').clearValue();
            		
            		
            		 var param = this.createCriteria(hosteltreeTreeFacility);                        
                     param.all=true;                        
                     hosteltreeTreeFacility.getStore().load({
                         params: param
                     });
            		
            	}
            },
            'externalresourcegrid[itemId=externalresourcegrid] button[itemId=resetButtonItemId]': {
            	click:function(){
            		var $this = this;
            		var grdexternalresource = this.getGrdExternalResource();
            		//grdexternalresource.down('#cmbResourceGroup').clearValue();
            		var resourceGroup = grdexternalresource.down('#cmbResourceGroup');
            		resourceGroup.clearValue();
            		grdexternalresource.down('#cmbResourceType').clearValue();
            		grdexternalresource.down('#cmbResourceStatus').clearValue();
            		resourceGroup.getStore().load({
     				   callback : function(records,operation,success) {
    					   if (success) {
    						   resourceGroup.setValue(records[0].data.value);
    					   }
    				   }
    			   })
    			   var param = $this.createCriteria(grdexternalresource);                        
                    param.all=true;                        
                    grdexternalresource.getStore().load({
                        params: param
                    });
            	}
            },
            'equipmentgrid[itemId=equipmentgrid] button[itemId=resetButtonItemId]': {
            	click:function(){
            		var $this = this;
            		var equipmentgrid = this.getGrdEquipment();
            		equipmentgrid.down('#cmbResourceType').clearValue();
            		equipmentgrid.down('#cmbResourceStatus').clearValue();
    			   var param = $this.createCriteria(equipmentgrid);                        
                    param.all=true;                        
                    equipmentgrid.getStore().load({
                        params: param
                    });
            	}
            },
            'equipmentgrid[itemId=equipmentgrid] customcombobox[itemId=cmbResourceType]': {
            	render:function(component){
            		component.getStore().load({
                        params: {
                        	resourceGroup: 'EQUIPMENT'
                         }
                    });
            	}
            },
            'facilitytree[itemId=facilitytree] button[itemId=resetButtonItemId]': {
            	click:function(){
            		var $this = this;
            		var facilitytree = this.getTreeFacility();
            		facilitytree.down('#cmbLocation').clearValue();
            		var resourceGroup = facilitytree.down('#cmbResourceGroup');
            		resourceGroup.clearValue();
            		facilitytree.down('#cmbResourceType').clearValue();
            		facilitytree.down('#cmbResourceStatus').clearValue();
            		resourceGroup.getStore().load({
     				   callback : function(records,operation,success) {
    					   if (success) {
    						   resourceGroup.setValue(records[0].data.value);
    					   }
    				   }
    			   })
    			   var param = $this.createCriteria(facilitytree);                        
                    param.all=true;                        
                    facilitytree.getStore().load({
                        params: param
                    });
            	}
            },
            'resourcelist customcombobox[itemId=cmbLocation]': {
                render: function(component, options) {
                    var me = this;
                    component.getStore().load();
                },
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                        var param = this.createCriteria(parentComponent);
                        if(parentComponent.itemId==='facilitytree' || parentComponent.itemId==='hostalfacilitytree'){
                        	param.all=true;
                        }
                        parentComponent.getStore().load({
                            params: param
                        });
                    }
                }
            },

            'resourcelist combo[itemId=cmbResourceGroup]': {
            	select: function(combo, records, eOpts) {
            		var parentComponent = combo.up().up();
            		var dependentCombo = parentComponent.down('#cmbResourceType');
            		var param=new Object();
            		if(!isNullOrEmpty(combo.getValue())){
            			param.resourceGroup=combo.getValue();
            		}
            		dependentCombo.reset();
            		dependentCombo.getStore().load({
            			params: param
            		});
            		if (parentComponent) {
            			var param = this.createCriteria(parentComponent);
            			if(parentComponent.itemId==='facilitytree'){
            				param.all=true;
            			}
            				parentComponent.getStore().load({
            					params: param
            				});
            		}
            	}
            },
            'resourcelist customcombobox[itemId=cmbResourceType]': {
            	
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                        var param = this.createCriteria(parentComponent);
                        if(parentComponent.itemId==='facilitytree'){
                        	param.all=true;
                        }
//                        if(parentComponent.itemId==='hostalfacilitytree'){
//                        	param.all='HOSTEL';
                        	param.all=true;
//                        }
                        parentComponent.getStore().load({
                            params: param
                        });
                    }
                }
            },
            'resourcelist customcombobox[itemId=cmbResourceTypeHosetl]': {
            	render: function(combo, options) {
                    var me = this;
                    var parentComponent = combo.up().up();
//                    var dependentCombo = parentComponent.down('#cmbResourceType');
//                    var param=new Object();
                    /*if(!isNullOrEmpty(combo.getValue())){
                    	param.resourceGroup=combo.getValue();
                    }*/
                   /* dependentCombo.reset();
                    dependentCombo.getStore().load({
                        params: param
                    });*/
                    if (parentComponent) {
                        var param = this.createCriteria(parentComponent);
                        if(parentComponent.itemId==='hostalfacilitytree'){
                        	param.all='HOSTEL';
                        	combo.getStore().load({
                                params: param
                            });
                        }

                    }
                    /*component.getStore().load({
                        callback: function(records, operation, success) {
                            var model = me.getAllModel();
                            component.combo.getStore().insert(0, model);                            
                        }
                    });*/
                },
                select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                        var param = this.createCriteria(parentComponent);
                        if(parentComponent.itemId==='facilitytree'){
                        	param.all=true;
                        }
                        if(parentComponent.itemId==='hostalfacilitytree'){
//                        	param.all='HOSTEL';
                        	param.all=true;
                        }
                        parentComponent.getStore().load({
                            params: param
                        });
                    }
                }
            },

            'resourcelist combo[itemId=cmbResourceStatus]': {
                 select: function(combo, records, eOpts) {
                    var parentComponent = combo.up().up();
                    if (parentComponent) {
                        var param = this.createCriteria(parentComponent);
                        if(parentComponent.itemId==='facilitytree'|| parentComponent.itemId==='hostalfacilitytree'){
                        	param.all=true;
                        }
                        parentComponent.getStore().load({
                            params: param
                        });
                    }
                }
            },

            'facilitytree[itemId=facilitytree]': {
                render: function(cmp, eOpts) {
                    if (cmp) {
                        var param = this.createCriteria(cmp);                        
                        param.all=true;                        
                        cmp.getStore().load({
                            params: param
                        });
                    }
                    this.doAccessControlValidation(cmp, this.getFACILITIES_RESOURCES_FACILITIES_MASTER_PERMISSIONS());
            		this.disableMoreActionPivileges(cmp,this.getFACILITIES_RESOURCES_FACILITIES_MASTER_PERMISSIONS());
                }
            },
            
            'hosteltree[itemId=hostalfacilitytree]': {
                render: function(cmp, eOpts) {
                    if (cmp) {
                        var param = this.createCriteria(cmp);                        
                        param.all=true;                        
                        cmp.getStore().load({
                            params: param
                        });
                    }
                   this.doAccessControlValidation(cmp, this.getFACILITIES_MASTER_HOSTEL_PERMISSIONS());
            	   this.disableMoreActionPivileges(cmp,this.getFACILITIES_MASTER_HOSTEL_PERMISSIONS());
                },
            },
            
			'equipmentgrid': {
                render: function(cmp, eOpts) {
                    if (cmp) {
                        var param = this.createCriteria(cmp);
                        param.all=true;
                        cmp.getStore().load({
                            params: param
                        });
                    }
                    this.doAccessControlValidation(cmp, this.getFACILITIES_RESOURCES_EQUIPMENT_MASTER_PERMISSIONS());
            		this.disableMoreActionPivileges(cmp,this.getFACILITIES_RESOURCES_EQUIPMENT_MASTER_PERMISSIONS());
                }
            },     
            
		 'externalresourcegrid': {
                render: function(cmp, eOpts) {
                    if (cmp) {
                        var param = this.createCriteria(cmp);
                        param.all=true;
                        cmp.getStore().load({
                            params: param
                        });
                    }
                   this.doAccessControlValidation(cmp, this.getFACILITIES_RESOURCES_EXTERNALRES_MASTER_PERMISSIONS());
            		this.disableMoreActionPivileges(cmp,this.getFACILITIES_RESOURCES_EXTERNALRES_MASTER_PERMISSIONS());
                }
            },
            'programgrid': {
                render: function() {
                    var store = this.getProgramgrid().getStore();
                    store.getProxy().extraParams = {
                    	academyLocationId: this.getCurrentAcademyLocation()
                    };
                    store.load();
                }
            },
            'coursegrid':{
            	render: function() {
                    var store = this.getCoursegrid().getStore();
                    store.getProxy().extraParams = {
                    	academyLocationId: this.getCurrentAcademyLocation()
                    };
                    store.load();
                }
            },
            'temproryunavailform #addMoreSlots': {
                render: function(component) {
                	var me = this;              
                  component.getEl().on('click', function(e) {
                	  me.insertTimeSlots(true); 
                	  component.setVisible(false);
                  });
                }
            },
            'resourcebasicdetails nestedJsonCombo[itemId=formComboResourceTypeId]':{
            	change : function(combo, record){
            		if(combo.getRawValue()=='Vehicle'){
            			var form = combo.up('form');
            			var vehicleSubType = form.down("#vehicleSubTypeId");
            			vehicleSubType.getStore().load();
            		}
            		this.vehicleResourceTypeValidation(combo, combo.getRawValue());
            	}
            },
            
            'resourcelist': {
	  			render:function(resourcelist){
	  				this.disableFacilityMasterImportTab(resourcelist, this.getIMPORT_FACILITY_AND_MASTER_PERMISSIONS());
	  			}
	  		}, 
            
            'facilitymasteruploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	        	change: this.facilitymasterDownloadUploadFormChange
	        },
	        'facilitymasterdownloadform combo[itemId=downloadTypeItemId]':{
	        	select:function(){
	        		var form=this.getFacilitymasterdownloadform();
	        		form.down('#downoladBtnId').setVisible(true);
	        		form.down('#downoladBtnId').setDisabled(false);
	        	}
	        	
	        },
	        /****
	         * @author Ranga
	         * @since 12/07/2017
	         * START:Added code for Facility and Master Import Functionality
	         */
	        'facilitymasterdownloadform button[itemId=downoladBtnId]':{
	        	click:function(obj){
	        		var $this = this;
	        		var form =obj.up('facilitymasterdownloadform').getForm();
	        		var templateName = form.getValues().downloadType;
	        		var submitUrl= SERVERURL.DOWNLOAD_FACILITY_MASTER_IMPORT;
	        		var csvForm = Ext.create('Ext.form.Panel'); 
	        		csvForm.getForm().submit({
	        			target: '_blank',
	        			method:'POST',
	        			params :{
	        				access_token : Ext.Ajax.defaultHeaders.access_token,
	        				importType:templateName
	        			},
	        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        			url: submitUrl,
	        			standardSubmit :true
	        		});
	        	}  
	        },
	        'facilitymasteruploadform button[itemId=uploadId]':{
	        	click:function(obj){
	        		var $this=this;
	        		var form=obj.up('facilitymasteruploadform');
	        		var templateName = form.getValues().uploadType;
	        		var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        		var moduleName = null;
    	 			switch (templateName){
                    case 'FACILITY':
                    	moduleName = 'IMPORT_BULK_FACILITY';
                    	break;
                    case 'EQUIPMENT':
                    	moduleName = 'IMPORT_BULK_FACILITY';
                    	break;
                    case 'HOSTEL':
                    	moduleName = 'IMPORT_BULK_HOSTEL';
                    	break;
                    default : null;
                    }
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
		        		form.getForm().submit({
		        			method : 'POST',
		        			url : submitUrl,
		        			success : function(form, action){
		        				showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		        			},
		        			failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		        			}
		        		});
		        	},1000);
	        		Ext.defer(function() {
	        			var grid = $this.getImportlistfacilitymastergridupload();
	        			var form  = $this.getUploadoptionradiogroup();
	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	        		}, 2000, this);
	        	}  
	        },
	 		   'facilitymasteruploadform uploadoptionradiogroup[itemId=facilityMasterListUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	 			   change: function( radioGroup, newValue, oldValue, eOpts){
	 					var facilitymasteruploadform=this.getFacilitymasteruploadform();
		        		var templateName = facilitymasteruploadform.getValues().uploadType;
		        		var moduleName = null;
	    	 			switch (templateName){
	                    case 'FACILITY':
	                    	moduleName = 'IMPORT_BULK_FACILITY';
	                    	break;
	                    case 'EQUIPMENT':
	                    	moduleName = 'IMPORT_BULK_FACILITY';
	                    	break;
	                    case 'HOSTEL':
	                    	moduleName = 'IMPORT_BULK_HOSTEL';
	                    	break;
	                    default : null;
	                    }
	 				   var grid =this.getImportlistfacilitymastergridupload();
	 				   var form  = this.getUploadoptionradiogroup();
	 				   var isUploadAll = newValue.isUploadAll;
	 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
	 			   }   
	 		   },
	        'facilitymasteruploadform button[itemId=resetBtn]':{
	        	click:function(obj){
	        		var $this = this;
	        		var form =obj.up('facilitymasteruploadform').getForm();
	        		form.reset();
	        		form.findField('file').reset();
	        		var combo = form.findField('importUtilityMasterId');
	        		combo.setValue('Bulk FacilityMaster');
	        		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
	        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        			isUploadAll: false
	        		});
	        		form.isValid();
	        	},
	        	render :function(obj){
	        		var $this = this;
	        		var form =obj.up('facilitymasteruploadform').getForm();
	        		var combo = form.findField('importUtilityMasterId');
	        		combo.getStore().load({
	        			callback: function(records, operation, success) {
	        				for(var i in records){
	        					if(records[i].data.value=='Bulk FacilityMaster'){
	        						combo.setValue(records[i].data.id);
	        						combo.setReadOnly(true);
	        					}
	        				}
	        			}	   
	        		});
	        	}  
	        },
	        'importlistfacilitymastergridupload':{
	        	render:function(obj){
	        		var $this = this;
	        		var grid = $this.getImportlistfacilitymastergridupload();
	        		var form = $this.getFacilitymasteruploadform().getForm();
	        		var moduleName = 'IMPORT_BULK_FACILITY';
	        		var form  = $this.getUploadoptionradiogroup();
 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	        	},
	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        		if (e.target.tagName == 'A') {
	        			var fileType=null;
	        			if(cellIndex==1){
	        				fileType='successFile';
	        			}else if(cellIndex==6){
	        				fileType='errorFile';
	        			}else if(cellIndex==7){
	        				fileType='logFile';
	        			}
	        			var documentId = record.get("id");
	        			if (!isNullOrEmpty(documentId)) {
	        				this.getFacilityMasterdownloadFile(documentId,fileType);
	        			}
	        		}
	        	}
	        },
	        'importlistfacilitymastergridupload button[itemId=btnForce]':{
	        	click: function(obj) {
	        		var grid = this.getImportlistfacilitymastergridupload();
	        		if (grid.getSelectionModel().getCount() > 0) {
	        			if(grid.getSelectionModel().getCount() > 1){
	        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	        			}else{
	        				var this$ = this;
	        				var id = grid.getSelectionModel().selectionStart.data.id;
	        				console.log(id);
	        				var urlAppend="?jobName="+id;
	        				var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	        				Ext.Ajax.request({
	        					url: submitURL,
	        					method: 'GET',
	        					success: function(response) {
	        						this$.getTreeFacility().getStore().reload();
	        						this$.getHosteltreeTreeFacility().getStore().reload();
	        						this$.getGrdEquipment().getStore().reload();
	        						if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	        							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	        						}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	        							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	        						}else if(response.responseText==="SUCCESS"){
	        							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	        							grid.getStore().reload();
	        						}
	        					}
	        				});
	        			}
	        		} else {
	        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        		}  
	        	}
	        },
	 		//END:Added code for Facility and Master Import Functionality
	        
	        
	        'facilitymasteruploadform customcombobox[itemId=uploadTypeItemId]':{
	        	select:function(obj,record){
	        		var $this=this;
	        		var form=$this.getFacilitymasteruploadform().getForm();
	        		var templateName = form.getValues().uploadType;
	        		var moduleName = null;
    	 			switch (templateName){
                    case 'FACILITY':
                    	moduleName = 'Bulk FacilityMaster';
                    	break;
                    case 'EQUIPMENT':
                    	moduleName = 'Bulk FacilityMaster';
                    	break;
                    case 'HOSTEL':
                    	moduleName = 'Bulk Hostel';
                    	break;
                    default : null;
                    }
    	 			var combo = form.findField('importUtilityMasterId');
	 				combo.getStore().load({
	 					callback: function(records, operation, success) {
	 						for(var i in records){
	 							if(records[i].data.value==moduleName){
	 								combo.setValue(records[i].data.id);
	 								combo.setReadOnly(true);
	 							}
	 						}
	 					}	   
	 				});
	 				var grid = $this.getImportlistfacilitymastergridupload();
	 				var form  = $this.getUploadoptionradiogroup();
 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	        	}
	        },
	        
	        'facilitymasterdownloadform customcombobox[itemId=downloadTypeItemId]': {
	 			select: function(obj, record) {
	 			var $this = this;
	 			var form = this.getFacilitymasterdownloadform();
	 			form.down('#downoladBtnId').setDisabled(false);
	 		}
	 	},
	 		
        });
        this.getStore('facilitiesresources.resourcebooking.EquipmentListStore').on('beforeload',function(store,operation,eOpts){          	
        	store.getProxy().extraParams={
                all:true
            };
         },this);
    },
    /****************START:Applied Permission Management Import Facility Master**************/
    disableFacilityMasterImportTab:function(resourcelist,permissionsMap){
 	   var associatedAcadLocationIds = new Array();
 	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
 	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 	   var facilityMasterUploadDownloadStructureTab=false;
 	   Ext.each(permissionList, function(privilege) {
 		   if (privilege === 'IMPORT_F_N_M') {
 			  facilityMasterUploadDownloadStructureTab=true;       		
 		   }
 	   });

 	   this.showFacilityImportTab(facilityMasterUploadDownloadStructureTab, resourcelist);
    },
    
    showFacilityImportTab : function(facilityMasterUploadDownloadStructureTab, resourcelist) {
 	   var panelItem = new Array();
 	   var $this = this;
 	   var newcont=resourcelist.items.items.length;
 	   var insertPosition=newcont+1;
 	   if(facilityMasterUploadDownloadStructureTab) {
 		   panelItem.push({
 			   xtype:'tabpanel',
 			   itemId:'allVisibleTP',
 			   plain: true,
 			   style:{overflow:'hidden !important',margin:'0!important'},
// 			   
 			   frame: false,
 			   border:false,
 			   defaults: {
 				   labelAlign: 'top'
 			   },
 			   items:[{
 					title:getCommonTranslation('RESOURCE_FACILITIES'),
 					autoScroll:false,
 					items:[{			
 						xtype:'facilitytree',
 						maxHeight: 450,
 						itemId: 'facilitytree',
 						closable:false	
 					}]		
 				},{
 					title:getCommonTranslation('RESOURCE_EQUIPMENTS'),
 					autoScroll:false,
 					items:[{
 						xtype:'equipmentgrid',
 						maxHeight: 450,
 						itemId: 'equipmentgrid',
 						closable:false
 					}]		
 				},{
 					title:getCommonTranslation('RESOURCE_EXTERNAL_RESOURCE'),
 					autoScroll:false,
 					items:[{
 						xtype:'externalresourcegrid',	
 						maxHeight: 450,
 						itemId: 'externalresourcegrid',
 						closable:false
 					}]		
 				},{
 					title:getCommonTranslation('HOSTEL_RESOURCES'),
 					autoScroll:false,
 					cls: 'hostelResourcesCls',
 					items:[{	
 						xtype:'hosteltree',
 						maxHeight: 450,
 						itemId: 'hostalfacilitytree',
 						closable:false	
 					}]		
 				},{
 					title:getCommonTranslation('IMPORT_F_N_M'),
 					autoScroll:true,
 					items:[{	
 						xtype:'facilitymasteruploaddownloadstructure',
 						closable:false	
 					}]
 				}]
 		   });

 	   } else {
 		   panelItem.push({
 			   xtype:'tabpanel',
 			   itemId:'allVisibleTP',
 			   plain: true,
 			   style:{overflow:'hidden !important',margin:'0!important'},
 			   
 			   frame: false,
 			   border:false,
 			   defaults: {
 				   labelAlign: 'top'
 			   },
 			   items:[{
 					title:getCommonTranslation('RESOURCE_FACILITIES'),
 					autoScroll:false,
 					cls: 'panelNoSpace',
 					items:[{			
 						xtype:'facilitytree',
 						maxHeight: 450,
 						itemId: 'facilitytree',
 						closable:false	
 					}]		
 				},{
 					title:getCommonTranslation('RESOURCE_EQUIPMENTS'),
 					autoScroll:false,
 					cls: 'panelNoSpace',
 					items:[{
 						xtype:'equipmentgrid',
 						maxHeight: 450,
 						itemId: 'equipmentgrid',
 						closable:false
 					}]		
 				},{
 					title:getCommonTranslation('RESOURCE_EXTERNAL_RESOURCE'),
 					autoScroll:false,
 					cls: 'panelNoSpace',
 					items:[{
 						xtype:'externalresourcegrid',	
 						maxHeight: 450,
 						itemId: 'externalresourcegrid',
 						closable:false
 					}]		
 				},{
 					title:getCommonTranslation('HOSTEL_RESOURCES'),
 					autoScroll:false,
 					cls: 'panelNoSpace hostelResourcesCls',
 					items:[{	
 						xtype:'hosteltree',
 						maxHeight: 450,
 						itemId: 'hostalfacilitytree',
 						closable:false	
 					}]		
 				}]
 		   });

 	   }
 	  resourcelist.insert(insertPosition,panelItem);
    },
    /****************END:Applied Permission Management Import Facility Master**************/
    
    //Import Functionality
    facilitymasterDownloadUploadFormChange : function(cb, nv, ov){
   	 var $this = this;
   	 var structure = cb.up('facilitymasteruploaddownloadstructure');
   	 var downloadTemplateForm = structure.down('facilitymasterdownloadform');
   	 var uploadTemplateForm = structure.down('facilitymasteruploadform');
   	 var grid = $this.getImportlistfacilitymastergridupload();
   	 if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
   		 uploadTemplateForm.hide();
   		 downloadTemplateForm.show();
   		 if(grid)
   		 grid.setVisible(false);
   	 }else{
		 $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
		 var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
		 uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
			 isUploadAll: false
		 });
		 downloadTemplateForm.hide();
   		 uploadTemplateForm.show();
   		 if(grid)
   		 grid.setVisible(true);
   		 uploadTemplateForm.down("#uploadFileField").reset();
   	 }
    },    
    
    getFacilityMasterdownloadFile : function(documentId,fileType){
   	 if(!isNullOrEmpty(documentId)){
   		 var csvForm = Ext.create('Ext.form.Panel'); 
   		 csvForm.getForm().submit({
   			 target: '_blank',
   			 method:'POST',
   			 params :{
   				 access_token : Ext.Ajax.defaultHeaders.access_token
   			 },
   			 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
   			 url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
   			 standardSubmit :true
   		 });
   	 }
    },
    
    
    /**
     * This method is use to open popup on change the status.
     */
    openStatusPopUp:function(records) {
    	var unavailInfo;
        var value = records[0].get('value');
        if (value === "INACTIVE") {
        	var hiddenField = this.getUnavailInfoHiddenFormField();
        	if(hiddenField.getValue() !==''){
        		unavailInfo = Ext.decode(hiddenField.getValue());
        		if(unavailInfo.status !== 'INACTIVE'){
        			unavailInfo = undefined;
        		}
        	}                    	
            this.openPermanentUnavailForm(unavailInfo);
        } else if (value === "TEMP_INACTIVE") {
        	var hiddenField = this.getUnavailInfoHiddenFormField();
        	if(hiddenField.getValue() !==''){
        		unavailInfo = Ext.decode(hiddenField.getValue());
        		if(unavailInfo.status !== 'TEMP_INACTIVE'){
        			unavailInfo = undefined;
        		}
        	}    
            this.openTemproryUnavailForm(unavailInfo);
        }
    },
    
    /**
     * This method is use to hide and show the time slots on selecting radio button.
     */
    toggleTimeSlots:function(newValue) {    	
		var me= this;
        var tempUnavailForm = me.getTemproryunavailform();
        var version = tempUnavailForm.getForm().findField('version').value;
         var timeSlotsPanel = tempUnavailForm.down('#timeSlotsPanel');
         if (newValue ) {
         	if(version==undefined || version=='' || !version) {
         		me.insertTimeSlots(true);
         		timeSlotsPanel.setVisible(true);
                 me.hideAddSlotLink(tempUnavailForm);
         	} else{
         		if(!timeSlotsPanel.down('[name=timeFieldSet]')) {                     		
         			me.insertTimeSlots(true);     
         		}
         		timeSlotsPanel.setVisible(true);
                me.hideAddSlotLink(tempUnavailForm);                                
         	}                    	
         } else {
        	 if(version==undefined || version=='' || !version) {
        		this.removeTimeSlots();
        	 }
        	 timeSlotsPanel.setVisible(false);                        
         }
     
    },
    
    getUnavailInfoHiddenFormField:function(){
    	var masterForm = this.getMenuController().getTab();    
    	var hiddenField = masterForm.down('hidden');    
    	return hiddenField;
    },
    
    loadCalendarCombo:function(combo, academyLocationId) {
    	
    	var store = combo.getStore();
    	if(isNullOrEmpty(academyLocationId)){
    		academyLocationId= this.getCurrentAcademyLocation();
    	}
    	store.getProxy().extraParams = {              
    		academyLocationId: this.getCurrentAcademyLocation()
    	};
    },
    
    /**
     * This method is use to insert the created timeslots in the form. 
     */
    insertTimeSlots:function(isFormPluginRequired){
    	var me = this;        
    	  var tempForm  = me.getTemproryunavailform();    	 
    	  var fields = me.createTimeSlots(isFormPluginRequired);       
          var timePanel =me.getTemproryunavailform().down('#timeSlotsPanel');
          timePanel.insert(this.position, fields);
          tempForm.doLayout();     
          this.getTemporaryformwindow().center();
          this.position++;      
          return fields;
    },
    
    /**
     * This method is use to remove the time slots in the form
     */
    removeTimeSlots:function(){
    	 var timePanel  =this.getTemproryunavailform().down('#timeSlotsPanel');
         var timeFieldSet = timePanel.down('[name=timeFieldSet]');
         timePanel.remove(timeFieldSet);            
    },
    
    createTimeSlots: function(isFormPluginRequired) {
    	var me= this;
        var tempUnavailForm = me.getTemproryunavailform();
    	var timePanel = tempUnavailForm.down('#timeSlotsPanel');
    	var fieldSetArray = timePanel.query('fieldcontainer[name=timeFieldSet]');
    	var insertPosition = fieldSetArray.length + 1; // TODO need to check undefine
    	var fromTimeItemId = 'fromTime' + insertPosition;
    	var toTimeItemId = 'toTime' + insertPosition;
    	
        var fields = Ext.create('Ext.form.FieldContainer', {
        	layout: 'hbox',
        	plugins: (isFormPluginRequired)?"formlabelrequired":'',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            name:'timeFieldSet',
            items: [{
                xtype: 'timefield',
                fieldLabel: getCommonTranslation('TIME_FROM'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,
                name: 'fromTime',
                itemId:fromTimeItemId,
				vtype: 'timerange',
				increment: 30,      
				allowBlank: false,
	            endTimeField: toTimeItemId
            }, {
                xtype: 'timefield',
                fieldLabel: getCommonTranslation('TIME_TO'),
                format: CONSTANTS.DISPLAY_TIME_FORMAT,
                name: 'toTime',
                itemId:toTimeItemId,
				 increment: 30,
				vtype: 'timerange',
				allowBlank: false,
				startTimeField:fromTimeItemId
            },{
				xtype:'label',	
				width: 100,
				autoEl:{
					 tag: 'a',
					 href: '#',
					 cn: getCommonTranslation('ADD_SLOTS')
				},
				style:{
					marginTop: '30px',
					marginLeft: '5px'
				},
				itemId:'addMoreSlots'
			}]
        });
  
        return fields;
    },

    /**
     * This function is used for to create ALL Model returns model    
     */
    getAllModel: function() {
        var model = new Academia.model.common.IdValueDataModel();
        model.set('id','');
        model.set('value', 'ALL');
        return model;
    },

    /**
     * This function is used for to create facility criteria and return params object    
     */
    createCriteria: function(container) {
        var params = new Object();

        var locationCombo = container.down('#cmbLocation');
        if (locationCombo) {
            var locationValue = locationCombo.getValue();
            if (!isNullOrEmpty(locationValue)) {
                params.locationId = locationValue;
            } 
        }
        var groupCombo = container.down('#cmbResourceGroup');
        if (groupCombo) {
        	var grpValue = groupCombo.getValue();
        	if(grpValue =="ALL")
        		{
        		grpValue="";
        		}
        	if(container.xtype == 'hosteltree'){
        		params.resourceGroup = 'HOSTEL';
        	}else{
        		if (!isNullOrEmpty(grpValue)) {
        			params.resourceGroup = grpValue;
        		}
        	}
        }

        var typeCombo = container.down('#cmbResourceType');
        if (typeCombo) {
            var resourceValue = typeCombo.getValue();
            if (!isNullOrEmpty(resourceValue)) {
                params.resourceTypeId = resourceValue;
            }
        }
        
        if(container.xtype == 'hosteltree'){
        	 var typeCombo = container.down('#cmbResourceTypeHosetl');
             if (typeCombo) {
                 var resourceValue = typeCombo.getValue();
                 if (!isNullOrEmpty(resourceValue)) {
                     params.resourceTypeId = resourceValue;
                 }
             }
        }

        var statusCombo = container.down('#cmbResourceStatus');
        if (statusCombo) {
            var statusValue = statusCombo.getValue();
            if (!isNullOrEmpty(statusValue)) {
                params.resourceStatus = statusValue;
            }
        }
        return params;
    },

    /**
     * This function is used for to show Resource Master Form Tab after clicking on Add button   
     */
    addResource: function(tab_type, resource_category, resource_group,tab_Title,isEdit) {
        var me = this;
        var record;
        if (tab_type == this.FACILITY_TAB || tab_type == this.HOSTEL_TAB) {   //Business Rules : before adding internal facility or internal fixed equipment
        	var tree;
        	if(tab_type == this.FACILITY_TAB && resource_group == 3){
        		tree = me.getTreeFacility();
        	}
        	if(!Ext.isDefined(tree)){
        		if(resource_group == 3){
        			tree = me.getHosteltreeTreeFacility();
        		}else{
        			tree = me.getTreeFacility();	
        		}
        	}
            
            if (tree.getSelectionModel().getCount() > 0) {   //Check node selection before adding new facility or equipment
                var records = tree.getSelectionModel().getSelection();
                if (!isEmpty(records)) {
                    if (resource_group == me.FACILITY_RESOURCE_GROUP) {  //Check Selected node should not be an equipment node while adding internal facility
                        if (records[0].data.root || (!records[0].data.leaf && records[0].data.model.resourceGroup === "FACILITY") || isEdit) {
                            record = records[0].data;
                            if(record.id !== 'root'){
                            	this.setPrimaryAcademyLocation(record.id);    
                            }                                         
                           
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_NODE_NOT_EQUIPMENT')); //Selected node should not be an equipment node
                            return false;
                        }
                    } else if (resource_group == me.EQUIPMENT_RESOURCE_GROUP) {  //Check Selected node should not be an equipment or root node while adding internal fixed equipment
                        if (!records[0].data.leaf && records[0].data.model.resourceGroup === "FACILITY" || isEdit)  {
                            record = records[0].data;
                            this.setPrimaryAcademyLocation(record.id);
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_NODE_NOT_EQUIPMENT_OR_ROOT')); //Selected node should not be an equipment or root node
                            return false;
                        }
                    }else if (resource_group == me.HOSTAL_RESOURCE_GROUP) {  
                        if (records[0].data.root || (!records[0].data.leaf && records[0].data.model.resourceGroup === "HOSTEL") || isEdit) {
                            record = records[0].data;
                            if(record.id !== 'root'){
                            	this.setPrimaryAcademyLocation(record.id,records[0].data.model.resourceGroup);    
                            }                                         
                           
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_NODE_NOT_HOSTEL_OR_ROOT')); //Selected node should not be an equipment node
                            return false;
                        }
                    }
                }
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_NODE')); //Please select a node
                return false;
            }
        }
        var tabName = "";
        var menuController = Academia.app.getController('menu.CoreERPNavigationController');
        if(isNullOrEmpty(tab_Title)){
        tabName = getCommonTranslation('RESOURCE_DETAILS');
        var existingTab = menuController.getTab(tabName);
        if (existingTab) {
            existingTab.close();
            me.unavailInfo = {};
        }
        }else{
           tabName = tab_Title;
        }                       
        var contentpanel = me.getContentPanel();
        var resourceBookingFormLayout = Ext.widget('resourcemasterform');
		var resourceType = resourceBookingFormLayout.down('#formComboResourceTypeId');
		var typeStore = resourceType.getStore();
		store.removeAll();
        if(!isEdit && (resource_group == me.HOSTAL_RESOURCE_GROUP && record.model.type == "Room")) {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_NODE_NOT_ROOM_TYPE'));	
        } else {
         	var getcontroller=this.getController('menu.CoreERPNavigationController');
         	var getTab=getcontroller.getTab(tabName);
         	if(getTab!=null){
         		contentpanel.remove(getTab, true);
         	}
        	openTab(contentpanel, tabName, resourceBookingFormLayout, CONSTANTS.MENU_COLOR_THIRTEEN);   
        	var newTab = menuController.getTab(tabName);
        	newTab.tab.setTooltip(tabName);
        	this.layoutSetting(newTab, tab_type, resource_category, resource_group, record,isEdit);
        	if(isNullOrEmpty(tab_Title)) {
        		newTab.down('seatcapacity').getStore().load();
        	}
        	
        	//typeStore.load();
			if (typeStore.getCount() === 0) {
			    typeStore.load();
			}
        }
    },

    setPrimaryAcademyLocation:function(parentId,resourceGroup) {
    	var me = this;
    	var priAcadLocCombo;
    	var calenderCombo;
    	var priAcadLocComboStore;
    	var calenderStore;
    	if(parentId !=='') {
    		Ext.Ajax.request({
    			type:'rest',
    			method:'GET',
    			url:SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID,
    			params:{
    				id:parentId
    			},
    			success:function(response){
    				var parentObject = Ext.decode(response.responseText);//primaryResourceAcademyLocation)
    				var priLoc = null;
    				if(parentObject.primaryResourceAcademyLocation.academyLocation){
    					 priLoc= parentObject.primaryResourceAcademyLocation.academyLocation.id;
    				}
    				
    				var masterForm=me.getMenuController().getTab();
    				var priAcadLocForm = masterForm.down('#primaryacademyloc');
    				priAcadLocCombo = priAcadLocForm.down('#academyLocation');
    				priAcadLocForm.down('#version').setValue(parentObject.primaryResourceAcademyLocation.version);
    				priAcadLocComboStore = priAcadLocCombo.getStore();
    				
    			
    				calenderCombo = priAcadLocForm.down('#comboAssignCalender');
    				calenderStore = calenderCombo.getStore();
    				priAcadLocComboStore.load({
					callback:function(){
						priAcadLocCombo.setValue(priLoc);
						calenderStore.getProxy().extraParams = {              
	                		academyLocationId: priLoc
	                	};
						if(resourceGroup !== 'HOSTEL'){
							calenderStore.load({
								callback:function(){
									calenderCombo.setValue(parentObject.calendar.id);
								}
							});
						}
					}
    				});    		
//    			}
    		}
    		});
    	} 
    },
    
    /*
     *This function is used for to show Resource details in Resource Master Form after clicking on edit/view button   
     */
    editResource: function(tab_type, resource_category, isView) {
    	var me = this;
    	var parentComponent = me.getPanelReference(tab_type);    	        
        if (parentComponent.getSelectionModel().getCount() > 0) {
            var records = parentComponent.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
            		
            	var tabTitle = /*records[0].data.name + " "+*/getCommonTranslation('RESOURCE_DETAILS');
                    var resource_group=records[0].data.resourceGroup;
                    if(parentComponent.xtype=='facilitytree'){
                    	if(!isEmpty(records[0].data) && records[0].data.root){
                    		showWarningMessage(getCommonTranslation('RESOURCE_MASTER'), getCommonTranslation('NOOPERATIONSONROOT'));
                    		return false;
                    	}else{
                    		if(!isEmpty(records[0].data)){
                        		tabTitle =/* records[0].data.text + " "+*/getCommonTranslation('RESOURCE_DETAILS');
                        	}else{
                        		tabTitle = getCommonTranslation('RESOURCE_DETAILS');
                        	}
                        	if(isNullOrEmpty(records[0].data.model)){  //For Root Selection
                        		resource_group="FACILITY";                    		
                        	}else{
                        		resource_group=records[0].data.model.resourceGroup;
                        	}
                    	}                    	                    	
                    } 
                    if(parentComponent.xtype=='hosteltree'){
                    	if(!isEmpty(records[0].data) && records[0].data.root){
                    		showWarningMessage(getCommonTranslation('RESOURCE_MASTER'), getCommonTranslation('NOOPERATIONSONROOT'));
                    		return false;
                    	}else{
                    		if(!isEmpty(records[0].data)){
                        		tabTitle = /*records[0].data.text + " "+*/getCommonTranslation('RESOURCE_DETAILS');
                        	}else{
                        		tabTitle = getCommonTranslation('RESOURCE_DETAILS');
                        	}
                        	if(isNullOrEmpty(records[0].data.model)){  //For Root Selection
                        		resource_group="HOSTEL";                    		
                        	}else{
                        		resource_group=records[0].data.model.resourceGroup;
                        	}
                    	}                    	                    	
                    } 
					  id =  records[0].get("id");            	 
					  var submitUrl;
					  
					  if(resource_category === this.EXTERNAL_RESOURCE_CATEGORY) {						
						  submitUrl = SERVERURL.FIND_EXTERNAL_RESOURCE_BY_ID;
					  } else{						 
						  submitUrl = SERVERURL.FIND_INTERNAL_RESOURCE_BY_ID;
					  }
            	   Ext.Ajax.request({
            		   type:'rest',
            		   method:'GET',
            		   url:submitUrl,
            		   params:{
            			   id:id
            		   },
            		   success:function(response) {
            			   if(resource_group==="FACILITY"){
            				   resource_group=me.FACILITY_RESOURCE_GROUP;
            			   }else if(resource_group==="EQUIPMENT"){
            				   resource_group=me.EQUIPMENT_RESOURCE_GROUP;
            			   }else if(resource_group==="HOSTEL"){
            				   resource_group=me.HOSTAL_RESOURCE_GROUP;
            			   }
            			   me.addResource(tab_type, resource_category, resource_group,tabTitle,true); 
                           var frmResourceMsterForm = me.getMenuController().getTab(tabTitle);
                           me.populateFormForEdit(response,frmResourceMsterForm);
            			  frmResourceMsterForm.down('#resetButtonId').setVisible(false);
            			  if (isView) {                          	
            				 me.viewResource(frmResourceMsterForm);
                          }
            			  
            		   }
            	   });
                                  
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /**
     * This method is use to view the resource
     * */
    viewResource:function(frmResourceMsterForm){
    	var panelOtherAcadLoc = frmResourceMsterForm.down('#otheracadloc');
    	var panelPrimaryAcademyLoc = frmResourceMsterForm.down('#primaryacademyloc');
    	var panelSeatCapacity = frmResourceMsterForm.down('#seatcapacity');
    	
    	frmResourceMsterForm.down('#btnSaveResource').setVisible(false);
    	toggleReadOnlyFormItems(frmResourceMsterForm.down('#resourcebasicdetails').getForm(), true);
    	toggleReadOnlyFormItems(frmResourceMsterForm.down('#primaryacademyloc').getForm(), true);
    	                        
    	panelOtherAcadLoc.down('#othAcadLocCombo').setReadOnly(true);
        panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
        panelOtherAcadLoc.down('#othAcadLocDeleteButton').setDisabled(true);
        panelOtherAcadLoc.down('#restrictionSplitButton').setDisabled(true);
        
        panelOtherAcadLoc.getView().setDisabled(true);
        panelSeatCapacity.getView().setDisabled(true);
    },
    
    /**
     * This method is use to populate the form with response data in edit mode.
     */
    populateFormForEdit:function(response,frmResourceMsterForm) {
   
	   var formData =  Ext.decode(response.responseText);
	   var resourceForm = frmResourceMsterForm.down('resourcebasicdetails');
	   var primaryAcadLocForm = frmResourceMsterForm.down('primaryacademyloc');
	   var otherAcadLocGrid = frmResourceMsterForm.down('otheracadloc');
	   var othAcadLocCombo = otherAcadLocGrid.down('#othAcadLocCombo');
	   var clusterCodeField = resourceForm.down('#clusterCode');
	   var hostelTypeField = resourceForm.down('#hostelType');
	   var hostelLevelField = resourceForm.down('#hostelLevel');
	   var hostelCategoryField = resourceForm.down('#hostelCategory');
	   var resourceNameOtherLanguage = resourceForm.down('#resourceNameOtherLanguageId');
	   var resourceMasterModel = new Academia.model.facilitiesresources.resourcemaster.ResourceMasterModel(formData);
	   if(formData.clusterCode){
		   clusterCodeField.getStore().load({
			   callback:function(){
				   clusterCodeField.setValue(formData.clusterCode.id)
			   }
		   })
	   }
	   if(formData.hostelType){
		   hostelTypeField.getStore().load({
			   callback:function(){
				   hostelTypeField.setValue(formData.hostelType.id)
			   }
		   })
	   }
	   if(formData.hostelLevel){
		   hostelLevelField.getStore().load({
			   callback:function(){
				   hostelLevelField.setValue(formData.hostelLevel)
			   }
		   })
	   }
	   if(formData.hostelCategory){
		   hostelCategoryField.getStore().load({
			   callback:function(){
				   hostelCategoryField.setValue(formData.hostelCategory)
			   }
		   })
	   }
	   if(formData.resourceNameOtherLanguage) {
		   resourceNameOtherLanguage.setValue(formData.resourceNameOtherLanguage)
	   }
	   if(null != formData.parent){
		   resourceMasterModel.set('parent',formData.parent.id);
	   }
	   if( resourceMasterModel && resourceMasterModel.data.resourceType) {
		   resourceMasterModel.data.resourceType= resourceMasterModel.data.resourceType.id;
	   }
	   resourceForm.loadRecord(resourceMasterModel);
	   var concernedPersonCombo=resourceForm.down('#concernedPerson');
	              if(concernedPersonCombo && !isEmpty(formData.concernedPerson) && !isNullOrEmpty(formData.concernedPerson.id)){
	                      concernedPersonCombo.getStore().load({               
	                  callback: function(records, operation, success) {
	                   if(records.length>0){
	                           concernedPersonCombo.setValue(formData.concernedPerson.id);
	                   }
	                  }
	              });
	              }
	    var primaryAcademyLocationModel = new Academia.model.facilitiesresources.resourcemaster.PrimaryAcademyLocationModel(formData.primaryResourceAcademyLocation);
	    var store = frmResourceMsterForm.down('seatcapacity').getStore();
	    var seatCapacityArray = this.getSeatCapaityGridForEdit(formData.resourceBookingPurposes);
	    store.loadRecords(seatCapacityArray);
	    store.commitChanges();	   
	    var hiddenField = this.getUnavailInfoHiddenFormField();
	    var unavailReason = formData.resourceUnavailabilityInfo;
	    if(unavailReason !== undefined &&unavailReason !== null ){
	    	unavailReason.status = formData.status;
	    	hiddenField.setValue(Ext.encode(unavailReason));
	    }       
	  /*  this.unavailInfo = formData.resourceUnavailabilityInfo;
	    console.log(this.unavailInfo)*/
	    primaryAcademyLocationModel.set('calendar',formData.calendar);
	    primaryAcadLocForm.loadRecord(primaryAcademyLocationModel); 
	    if(!isNullOrEmpty(formData.primaryResourceAcademyLocation)){
	    	primaryAcadLocForm.down('#version').setValue(formData.primaryResourceAcademyLocation.version);
	    }
	    primaryAcadLocForm.down('#academyLocation').setReadOnly(true);
	    var comboAssignCalender = primaryAcadLocForm.down('#comboAssignCalender');
	    primaryAcadLocForm.down('#comboAssignCalender').setReadOnly(true);
	    if(!isNullOrEmpty(formData.calendar)){
	    	
	    	var priLoc= formData.primaryResourceAcademyLocation.academyLocation.id;
	    	
	    	if(!isNullOrEmpty(priLoc)){
	    		comboAssignCalender.getStore().getProxy().extraParams = {              
		    		academyLocationId: priLoc
		    	};
	    	}
	    	
	    	comboAssignCalender.getStore().load({               
	    		callback: function(records, operation, success) {
	    			if(records.length>0){
	    				comboAssignCalender.setValue(formData.calendar.id);
	    				comboAssignCalender.setReadOnly(true);
	    			}
	    		}
	    	});
	    }
	    
	    if(!isNullOrEmpty(primaryAcademyLocationModel.data.academyLocation)){
	    	primaryAcadLocForm.down('#academyLocation').getStore().load({               
	    		callback: function(records, operation, success) {
	    			if(records.length>0){
	    				primaryAcadLocForm.down('#academyLocation').setValue(primaryAcademyLocationModel.data.academyLocation.id);
	    			}
	    		}
	    	});
	    }
	    
	    
	    this.setProgramAndCoursesToPrimaryAcademyLocation(primaryAcadLocForm, formData);
	    
	   
	    if(formData.category!=='EXTERNAL'){
	    	
	    	otherAcadLocGrid.getStore().sorters.clear();
	    	
	    	otherAcadLocGrid.getStore().getProxy().extraParams = {
	    		resourceId: formData.id
	        }
	    	otherAcadLocGrid.getStore().load();
	    	
//	    	otherAcadLocGrid.getStore().load({
//		    	params:{resourceId:formData.id}
//		    });	    
		    
		    var param=new Object();
		    param.resourceId=formData.id;
		    
		    if(!isEmpty(formData.parent)){                
		        if(!isNullOrEmpty(formData.parent.id)){
		        	param.parentResourceId=formData.parent.id;
		        }        
		    }
	        
		    othAcadLocCombo.getStore().load({
		    	params: param	    	
		    });
	    }	    
	    
    },
    
    setProgramAndCoursesToPrimaryAcademyLocation: function(primaryAcadLocForm, formData){
    	var courses = [];
    	if(!isEmpty(formData)){
    		if(!isEmpty(formData.primaryResourceAcademyLocation)){
    			var primaryResourceAcademyLocation = formData.primaryResourceAcademyLocation;
    			if(!isEmpty(primaryResourceAcademyLocation.courses)){
    				
    				Ext.each(primaryResourceAcademyLocation.courses, function(courseArr) {
    		              if (!isEmpty(courseArr.course)) {
    		            	  courses.push({
    		            		  course: {
    		            			  id:  courseArr.course.id
    		            		  },
    		            		  id: (!isNullOrEmpty(courseArr.id))?courseArr.id:null,
    		            		  version: (!isNullOrEmpty(courseArr.version))?courseArr.version:null
    		            	  });
    		            	  
    		              }
    		        });
    				if(courses.length>0){
    					primaryAcadLocForm.courses = courses;
    				}else{
    					primaryAcadLocForm.courses = null;
    				}
    				
        		}

				if(!isEmpty(primaryResourceAcademyLocation.resourceAcademyLocationPrograms)){
					var resourceAcademyLocationPrograms = [];
					var resourceAcademyLocationProgramsArr = primaryResourceAcademyLocation.resourceAcademyLocationPrograms;
					Ext.each(resourceAcademyLocationProgramsArr, function(programBatches) {
						var obj = {};
  		              	if (!isEmpty(programBatches)) {
  		              		obj.id = (!isNullOrEmpty(programBatches.id))?programBatches.id:null;
  		              		obj.version = (!isNullOrEmpty(programBatches.version))?programBatches.version:null;
  		              		if(!isEmpty(programBatches.program)){
  		              			obj.program = {
  		              					id: programBatches.program.id
  		              			};
  		              		}
	  		              	if(!isEmpty(programBatches.batches)){
	  		              		var batchObjArr = [];
	  		              		Ext.each(programBatches.batches, function(batchArr) {
	  		              			batchObjArr.push({
	  		              				batch: {
	  		              					id : (!isNullOrEmpty(batchArr.batch.id))?batchArr.batch.id:null
	  		              				},
		  		              			id : (!isNullOrEmpty(batchArr.id))?batchArr.id:null,
		  		              			version : (!isNullOrEmpty(batchArr.version))?batchArr.version:null
	  		              			});
	  		              			
	  		              			obj.batches = batchObjArr;
	  		              		});
		  		              	
  		              		}else{
  		              			obj.batches = [];
  		              		}
  		              		
  		            		  
  		              	}
  		              	if(!isEmpty(obj)){
  		              		resourceAcademyLocationPrograms.push(obj);
  		              	}
  		              
  		              	
	    			});
		  				if(!isEmpty(resourceAcademyLocationPrograms)){
		  					primaryAcadLocForm.resourceAcademyLocationPrograms = resourceAcademyLocationPrograms;
		  				}else{
		  					primaryAcadLocForm.resourceAcademyLocationPrograms = null;
		  				}
				}
				
    		
    		}
    	}
    },
    getSeatCapaityGridForEdit:function(resourceBookingPurposes){
        var seatCapacityArray =[] ;
	    if(resourceBookingPurposes.length !=0) {
	    	Ext.each(resourceBookingPurposes,function(record){
	    		var seatCapacity = new Academia.model.facilitiesresources.resourcemaster.SeatCapacity();
			    seatCapacity.set('capacity',record.capacity);
			    seatCapacity.set('value',record.bookingPurpose.value);
			    seatCapacity.set('id',record.bookingPurpose.id);		
			    seatCapacityArray.push(seatCapacity);
	    	});			   
	    }	    	
		return seatCapacityArray;
    },
    
    /**
     * This function is used for to delete Resource after clicking on delete button   
     */
    deleteResource: function(tab_type, resource_category) {
    	var parentComponent = this.getPanelReference(tab_type);
        var parentComponentStore = parentComponent.getStore();
        var deleteUrl="";        
        if(resource_category==this.INTERNAL_RESOURCE_CATEGORY){
        	deleteUrl = SERVERURL.DELETE_INTERNAL_RESOURCE;    //URL-rest/internalResource/delete
        }else if(resource_category==this.EXTERNAL_RESOURCE_CATEGORY){
        	deleteUrl = SERVERURL.DELETE_EXTERNAL_RESOURCE;   //URL-rest/externalResource/delete
        }        
        if (parentComponent.getSelectionModel().getCount() > 0) {
           	var records = parentComponent.getSelectionModel().getSelection();
        	if(parentComponent.xtype=='facilitytree'){
            	if(!isEmpty(records[0].data) && records[0].data.root){
            		showWarningMessage(getCommonTranslation('RESOURCE_MASTER'), getCommonTranslation('NOOPERATIONSONROOT'));
            		return false;
            	}
            }            		            	
            showConfirmMessage(getCommonTranslation('DELETE_FACILITY_MASTER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (parentComponent.getSelectionModel().getCount() > 0) {                            
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,													 
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                	if(form.responseText == "DEPENDENT_RECORD_EXISTS"){
   									 showWarningMessage(getCommonTranslation('ALERT'),
   											getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
   								 }else{
                                	parentComponentStore.reload();
                                	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_RESOURECE_MSG')); //Resource deleted successfully.
                                }
                                },
                                failure: function(form, action) {
                                	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                                }
                            });
                        }
                    }
                }
        });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }        
    },

    /**
     * This function is used for to make layout settings according to type of resource   
     */
    layoutSetting: function(tab, tab_type, resource_category, resource_group, record,isEdit) {

        var frmResourceBasicDetails = tab.down('#resourcebasicdetails');
        var panelPrimaryAcademyLoc = tab.down('#primaryacademyloc');
        var panelOtherAcadLoc = tab.down('#otheracadloc');
        var panelSeatCapacity = tab.down('#seatcapacity');
        var hiddenTabType = tab.down('#tabType');
        var resourceTypeCombo = frmResourceBasicDetails.down('#formComboResourceTypeId');
        var resourceNameOtherLanguage = frmResourceBasicDetails.down('#resourceNameOtherLanguageId');
        var resourceStatusCombo = frmResourceBasicDetails.down('#formComboResourceStatusId');
        var concernedPerson = frmResourceBasicDetails.down('#concernedPerson');
        var hiddenResourceGroup = frmResourceBasicDetails.down('#resourceGroup');
        var hiddenCategory = frmResourceBasicDetails.down('#category');
        var hiddenParentId = frmResourceBasicDetails.down('#parentNodeId');
        var hiddenType = frmResourceBasicDetails.down('#type');
        var shortName = frmResourceBasicDetails.down('#shortName');
        var nameToPrint = frmResourceBasicDetails.down('#nameToPrint');
        var landMark = frmResourceBasicDetails.down('#landMark');
        var isSharingAllowed = frmResourceBasicDetails.down('#isSharingAllowed'); 
        var isBookingAllowed = frmResourceBasicDetails.down('#whetherBookingAllowed'); 
 	   	var othAcadLocCombo = panelOtherAcadLoc.down('#othAcadLocCombo'); 
 	    var hostelType = frmResourceBasicDetails.down('#hostelType'); 
        var clusterCode = frmResourceBasicDetails.down('#clusterCode');
        var hostelLevel = frmResourceBasicDetails.down('#hostelLevel');
        var hostelCategory = frmResourceBasicDetails.down('#hostelCategory'); 
        /*hostelType.setVisible(false); V2D-484480 manage from DFR also 
        hostelLevel.setVisible(false);
        clusterCode.setVisible(false);
        hostelCategory.setVisible(false);*/
        var resourceNameOtherLanguageVis = false;
        if(resourceNameOtherLanguage.isVisible()) {
        	resourceNameOtherLanguage.setVisible(false);
        	resourceNameOtherLanguageVis = true;
        }
//        resourceNameOtherLanguage.setVisible(false);
        if (tab_type == this.FACILITY_TAB) {  //Business Rules : before adding internal facility or internal fixed equipment in Facility Tab

            resourceStatusCombo.setValue('ACTIVE');
            hiddenCategory.setValue('INTERNAL');
            panelPrimaryAcademyLoc.setVisible(true);
            hiddenTabType.setValue(this.FACILITY_TAB);
            
            if(isEdit){
            	panelOtherAcadLoc.setVisible(true);
            }else{
            	panelOtherAcadLoc.setVisible(false);
            }

            if(!isEmpty(record)){
            	if (record.root) {
            		hiddenParentId.setValue('');
            	}else {
            		if (!isNullOrEmpty(record.id)) {
            			hiddenParentId.setValue(record.id);
            		} else {
            			hiddenParentId.setValue('');
            		}
            	}
            	hiddenType.setValue(record.model.type);
            }                        
            
          /*  if(resource_group == this.HOSTAL_RESOURCE_GROUP){  //Rules for hostal
                hiddenResourceGroup.setValue('HOSTEL');
                panelSeatCapacity.setVisible(false);
                hiddenTabType.setValue(this.HOSTEL_TAB);
                panelPrimaryAcademyLoc.down('#comboAssignCalender').setVisible(false);
                panelPrimaryAcademyLoc.down('#programsViewChange').setVisible(false);
                panelPrimaryAcademyLoc.down('#coursesViewChange').setVisible(false);
                resourceTypeCombo.getStore().load({
                	params: {
                		resourceGroup: 'HOSTEL'
                	},
                	callback: function(records, operation, success) {
                		if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                			resourceTypeCombo.getStore().remove(this.data.items[0]);
                		}
                	}
                });
                
                
                if(isEdit){
                	panelOtherAcadLoc.down('#restrictionSplitButton').setVisible(false);
                	panelOtherAcadLoc.down('#isProgramsRestricted').setVisible(false);
                	panelOtherAcadLoc.down('#isCoursesRestricted').setVisible(false);
                }
                
                
                if(!isEmpty(record)){
                	if(record.root){  //For Top Level Facility Only 
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), false);
                   }else{
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                   }
                }   
                
//                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
            }else*/ if (resource_group == this.FACILITY_RESOURCE_GROUP) {  //Rules for facility
                hiddenResourceGroup.setValue('FACILITY');
                panelSeatCapacity.setVisible(true);
				if(isEdit){
					resourceTypeCombo.getStore().load();
				} else {
					resourceTypeCombo.getStore().load({
						params: {
							resourceGroup: 'FACILITY'
						},
						callback: function(records, operation, success) {
							if (this.data.items.length > 0 && this.data.items[0].data.value === "ALL") {
								resourceTypeCombo.getStore().remove(this.data.items[0]);
							}
						}
					});
				}
                
                if(!isEmpty(record)){
                	if(record.root){  //For Top Level Facility Only 
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), false);
                   }else{
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                	 this.makeCalendarComboEditable(panelPrimaryAcademyLoc.getForm());
                   }
                }   
                
//                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
            } else if (resource_group == this.EQUIPMENT_RESOURCE_GROUP) {     //Rules for fixed equipment
                hiddenResourceGroup.setValue('EQUIPMENT');
                panelSeatCapacity.setVisible(false);
                nameToPrint.setVisible(false);
                shortName.setVisible(false);
                landMark.setVisible(false);
                isSharingAllowed.setVisible(false);
                isBookingAllowed.setVisible(false);
                //isBookingAllowed.setDisabled(true);
				if (isEdit) {
					resourceTypeCombo.getStore().load();
				} else {
					resourceTypeCombo.getStore().load({
						params: {
							resourceGroup: 'EQUIPMENT'
						},
						callback: function(records, operation, success) {
							if (this.data.items.length > 0 && this.data.items[0].data.value === "ALL") {
								resourceTypeCombo.getStore().remove(this.data.items[0]);
							}
						}
					});
				}
                toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                Ext.each(panelPrimaryAcademyLoc.items.items, function(cmp) {
                    if (cmp.xtype === "button") {
                        cmp.setDisabled(true);
                    }
                });

                panelOtherAcadLoc.down('#othAcadLocCombo').setReadOnly(true);
                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
                panelOtherAcadLoc.down('#othAcadLocDeleteButton').setDisabled(true);
                panelOtherAcadLoc.down('#restrictionSplitButton').setDisabled(true);

            }
        } else if (tab_type == this.EQUIPMENT_TAB) {  //Business Rules : before adding internal portable equipment in equipment Tab

            resourceStatusCombo.setValue('ACTIVE');
            hiddenCategory.setValue('INTERNAL');
            panelPrimaryAcademyLoc.setVisible(true);
            hiddenTabType.setValue(this.EQUIPMENT_TAB);
            isBookingAllowed.setVisible(false);
            //isBookingAllowed.setDisabled(true);
            if(isEdit){
            	toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
            	panelOtherAcadLoc.setVisible(true);
            }else{
            	panelOtherAcadLoc.setVisible(false);
            }
            
            hiddenParentId.setValue('');

            if (resource_group == this.EQUIPMENT_RESOURCE_GROUP) {  //Rules for portable equipment
                hiddenResourceGroup.setValue('EQUIPMENT');
                panelSeatCapacity.setVisible(false);
                nameToPrint.setVisible(false);
                shortName.setVisible(false);
                landMark.setVisible(false);
                isSharingAllowed.setVisible(false);
                resourceTypeCombo.getStore().load({
                    params: {
                    	resourceGroup: 'EQUIPMENT'
                    },
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCombo.getStore().remove(this.data.items[0]);
                    }
                    }
                });
            }
        } else if (tab_type == this.EXTERNAL_RESOURCE_TAB) {  //Business Rules : before adding external facility or external equipment in external resource Tab

            resourceStatusCombo.setValue('ACTIVE');
            hiddenCategory.setValue('EXTERNAL');
            panelPrimaryAcademyLoc.setVisible(false);
            panelOtherAcadLoc.setVisible(false);
            isBookingAllowed.setVisible(false);
            isBookingAllowed.setDisabled(true);
            concernedPerson.setVisible(true);
            concernedPerson.setDisabled(false);
            hiddenTabType.setValue(this.EXTERNAL_RESOURCE_TAB);

            if (resource_group == this.FACILITY_RESOURCE_GROUP) { //Rules for external facility 
                hiddenResourceGroup.setValue('FACILITY');
                panelSeatCapacity.setVisible(true);
                resourceTypeCombo.getStore().load({
                    params: {
                    	resourceGroup: 'FACILITY'
                    },
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCombo.getStore().remove(this.data.items[0]);
                    }
                    }
                });
            } else if (resource_group == this.EQUIPMENT_RESOURCE_GROUP) {  //Rules for external equipment
                hiddenResourceGroup.setValue('EQUIPMENT');
                panelSeatCapacity.setVisible(false);
                nameToPrint.setVisible(false);
                shortName.setVisible(false);
                landMark.setVisible(false);
                isSharingAllowed.setVisible(false);                
                resourceTypeCombo.getStore().load({
                    params: {
                    	resourceGroup: 'EQUIPMENT'
                   },
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCombo.getStore().remove(this.data.items[0]);
                    }
                    }
                });
            }
        }else if(tab_type == this.HOSTEL_TAB){  //Business Rules : before adding internal facility or internal fixed equipment in Facility Tab

            resourceStatusCombo.setValue('ACTIVE');
            hiddenCategory.setValue('INTERNAL');
            panelPrimaryAcademyLoc.setVisible(true);
            hiddenTabType.setValue(this.HOSTEL_TAB);
            
            if(isEdit){
            	panelOtherAcadLoc.setVisible(true);
            }else{
            	panelOtherAcadLoc.setVisible(false);
            }

            if(!isEmpty(record)){
            	if (record.root) {
            		hiddenParentId.setValue('');
            	}else {
            		if (!isNullOrEmpty(record.id)) {
            			hiddenParentId.setValue(record.id);
            		} else {
            			hiddenParentId.setValue('');
            		}
            	}
            	hiddenType.setValue(record.model.type);
            }                        
            
            if(resource_group == this.HOSTAL_RESOURCE_GROUP){  //Rules for hostal
            	var hostelResourcetype=record;
                hiddenResourceGroup.setValue('HOSTEL');
                panelSeatCapacity.setVisible(false);
                hiddenTabType.setValue(this.HOSTEL_TAB);
                panelPrimaryAcademyLoc.down('#comboAssignCalender').setVisible(false);
                panelPrimaryAcademyLoc.down('#programsViewChange').setVisible(false);
                panelPrimaryAcademyLoc.down('#coursesViewChange').setVisible(false);
                resourceTypeCombo.getStore().load({
                	params: {
                		resourceGroup: 'HOSTEL'
                	},
                	callback: function(records, operation, success) {
                		if(resourceNameOtherLanguageVis == true) {
	                		resourceNameOtherLanguage.setVisible(true);
                			
                		}
                		//resourceNameOtherLanguage.setVisible(true);
                		if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                			resourceTypeCombo.getStore().remove(this.data.items[0]);
                		}
                		else if(hostelResourcetype.root && !isEdit){
                			resourceTypeCombo.setValue(this.data.items[2]);
                			resourceTypeCombo.setReadOnly(true);
                			if(frmResourceBasicDetails.hostelTypeVisible){
                				hostelType.setVisible(true)
                			}if(frmResourceBasicDetails.clusterCodeVisible){
                				clusterCode.setVisible(true)
                			}if(frmResourceBasicDetails.hostelLevelVisible){
                				hostelLevel.setVisible(true)
                			}if(frmResourceBasicDetails.hostelCategoryVisible){
                				hostelCategory.setVisible(true)
                			}
                		}
                		else if(record.model.type=="Hostel" && !isEdit){
                			resourceTypeCombo.setValue(this.data.items[0]);
                			resourceTypeCombo.setReadOnly(true);    
                			 hostelType.allowBlank=true;
               			     clusterCode.allowBlank=true;
               			  hostelLevel.allowBlank=true;
               			hostelCategory.allowBlank=true;
                		}
                		else if(record.model.type=="Building" && !isEdit){
                			resourceTypeCombo.setValue(this.data.items[1]);
                			resourceTypeCombo.setReadOnly(true);
                			 hostelType.allowBlank=true;
               			  clusterCode.allowBlank=true;
               			hostelLevel.allowBlank=true;
               			hostelCategory.allowBlank=true;
                		}
                		else if(record.model.type=="Floor" && !isEdit){
                			resourceTypeCombo.setValue(this.data.items[3]);
                			resourceTypeCombo.setReadOnly(true);
                			 hostelType.allowBlank=true;
               			  clusterCode.allowBlank=true;
               			hostelLevel.allowBlank=true;
               			hostelCategory.allowBlank=true;
                		}
                		else if(record.model.type=="Room" && !isEdit){
                			resourceTypeCombo.setValue(this.data.items[3]);
                			resourceTypeCombo.setReadOnly(true);
                			 hostelType.allowBlank=true;
               			     clusterCode.allowBlank=true;
               			  hostelLevel.allowBlank=true;
               			hostelCategory.allowBlank=true;
                		}
                		else{
                			resourceTypeCombo.setReadOnly(true);
                			if(record.model.type=="Hostel" && isEdit){
                			if(frmResourceBasicDetails.hostelTypeVisible){
                				hostelType.setVisible(true)
                			}if(frmResourceBasicDetails.clusterCodeVisible){
                				clusterCode.setVisible(true)
                			}if(frmResourceBasicDetails.hostelLevelVisible){
                				hostelLevel.setVisible(true)
                			}if(frmResourceBasicDetails.hostelCategoryVisible){
                				hostelCategory.setVisible(true)
                			}
                		  }else{
                			  hostelType.allowBlank=true;
                			  clusterCode.allowBlank=true;
                			  clusterCode.reset();
                			  hostelType.reset();
                			  hostelLevel.allowBlank=true;
                			  hostelLevel.reset();
                			  hostelCategory.allowBlank=true;
                			  hostelCategory.reset();
                		  }
                		}
                	}
                });
                resourceTypeCombo.resetOriginalValue();
                
                
                if(isEdit){
                	panelOtherAcadLoc.down('#restrictionSplitButton').setVisible(false);
                	panelOtherAcadLoc.down('#isProgramsRestricted').setVisible(false);
                	panelOtherAcadLoc.down('#isCoursesRestricted').setVisible(false);
                }
                
                
                if(!isEmpty(record)){
                	if(record.root){  //For Top Level Facility Only 
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), false);
                   }else{
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                   }
                }   
                
//                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
            }/*else if (resource_group == this.FACILITY_RESOURCE_GROUP) {  //Rules for facility
                hiddenResourceGroup.setValue('FACILITY');
                panelSeatCapacity.setVisible(true);
                resourceTypeCombo.getStore().load({
                    params: {
                    	resourceGroup: 'FACILITY'
                    },
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCombo.getStore().remove(this.data.items[0]);
                    }
                    }
                });
                
                
                if(!isEmpty(record)){
                	if(record.root){  //For Top Level Facility Only 
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), false);
                   }else{
                   	 toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                   }
                }   
                
//                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
            } else if (resource_group == this.EQUIPMENT_RESOURCE_GROUP) {     //Rules for fixed equipment
                hiddenResourceGroup.setValue('EQUIPMENT');
                panelSeatCapacity.setVisible(false);
                nameToPrint.setVisible(false);
                shortName.setVisible(false);
                landMark.setVisible(false);
                isSharingAllowed.setVisible(false);
                isBookingAllowed.setVisible(false);
                //isBookingAllowed.setDisabled(true);
                resourceTypeCombo.getStore().load({
                    params: {
                    	resourceGroup: 'EQUIPMENT'
                     },
                    callback: function(records, operation, success) {
                    	if(this.data.items.length>0 && this.data.items[0].data.value==="ALL"){
                    		resourceTypeCombo.getStore().remove(this.data.items[0]);
                    }
                    }
                });
                
                toggleReadOnlyFormItems(panelPrimaryAcademyLoc.getForm(), true);
                Ext.each(panelPrimaryAcademyLoc.items.items, function(cmp) {
                    if (cmp.xtype === "button") {
                        cmp.setDisabled(true);
                    }
                });

                panelOtherAcadLoc.down('#othAcadLocCombo').setReadOnly(true);
                panelOtherAcadLoc.down('#othAcadLocAddButton').setDisabled(true);
                panelOtherAcadLoc.down('#othAcadLocDeleteButton').setDisabled(true);
                panelOtherAcadLoc.down('#restrictionSplitButton').setDisabled(true);

            }*/
        }
    },

    /**
     * This function is used for to get tree/grid panel reference   
     */
    getPanelReference: function(tab_type) {        
    	if(tab_type==this.FACILITY_TAB){
    		return this.getTreeFacility();
    	}else if(tab_type==this.EQUIPMENT_TAB){
    		return this.getGrdEquipment(); 
    	}else if(tab_type==this.EXTERNAL_RESOURCE_TAB){
    		return this.getGrdExternalResource();
    	}else if(tab_type==this.HOSTEL_TAB){
    		return this.getHosteltreeTreeFacility();
    	}
    },
    
    /**
     * This function is used for to add other academy location after clicking on add button   
     */
    addOtherAcademyLocation: function(combo,event) {
    	var me=this;
    	var grid = combo.up().up();  //Getting grid component
    	var masterTab = this.getContentPanel().getActiveTab();
    	var resourceBasicDetails=masterTab.down('resourcebasicdetails');
    	var othAcadLocCombo=grid.down('#othAcadLocCombo');
        var grdStore = grid.getStore();
        var selectedValue=othAcadLocCombo.getRawValue();
        if(!isNullOrEmpty(selectedValue)){
        	var findRecordIndex=grdStore.find('name',selectedValue);
        	if(findRecordIndex==-1){
        		var hiddenResourceId=resourceBasicDetails.down('#id');
        		var otherAcademyLocationRecord=new Object();
            	otherAcademyLocationRecord.academyLocation={id:othAcadLocCombo.getValue()};
            	otherAcademyLocationRecord.resource={id:hiddenResourceId.getValue()};
            	otherAcademyLocationRecord.resourceAcademyLocationPrograms=grid.resourceAcademyLocationPrograms;
            	otherAcademyLocationRecord.courses=grid.courses;
            	otherAcademyLocationRecord.isPrimary=false;
            	
            	Ext.Ajax.request({
    				 type: 'rest',
    				 url : SERVERURL.CREATE_OTHER_ACADEMY_LOCATION,  //URL-rest/resourceAcademyLocation/create
    				 jsonData:Ext.encode(otherAcademyLocationRecord),
    				 method:'POST',
    					success:function(form, action){    						
    						grid.getStore().reload();    						
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('ADD_ACADEMY_LOCATION_MSG'));//Other Academy location added successfully.
    						othAcadLocCombo.reset();
    						grid.resourceAcademyLocationPrograms=null;
    						grid.courses = null;
    					}
    				});
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ALREADY_ASSIGNED_MSG')); //Selected academy location is already assiged to this resource.
        	}        	
        }else{
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_OTHER_ACAD_LOC')); //Please select a other academy location from academy location combo.
        }        
    },
    /*
     * This function is used for to delete other academy location after clicking on delete button   
     */
    deleteOtherAcademyLocation: function(combo,event) {            	
        var grid = combo.up().up();  //Getting grid component
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('DELETE_ACADEMY_LOCATION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = records[count].get("id");                                
                            if (!isNullOrEmpty(id)) {
                            	Ext.Ajax.request({
                                    type: 'rest',
                                    url:  SERVERURL.DELETE_OTHER_ACADEMY_LOCATION,  //URL - rest/resourceAcademyLocation/delete													 
                                    method: 'DELETE',                                                                                
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                    	grdStore.reload();
                                    	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_ACADEMY_LOCATION_MSG')); //Other academy location deleted successfully.
                                    },
                                    failure: function(form, action) {
                                    	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
                                    }
                                });
                            }                                
                        }
                    }
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
    openPermanentUnavailForm: function(unavailInfo) {
    	var unavailInfoModel = new Academia.model.facilitiesresources.resourcemaster.UnavailableInfoModel(unavailInfo);
        var window = this.getPermanentFormwindow();
        if (!window) {
            window = Ext.widget('permanentFormwindow');
            var form = window.down('form').getForm();
            if(!isEmpty(unavailInfoModel)){
            	if(isNullOrEmpty(unavailInfoModel.get("reason"))){
					unavailInfoModel.set("reason", null);
				}
            	form.loadRecord(unavailInfoModel);
            }
            	
        }
        window.show();
    },

    openTemproryUnavailForm: function(unavailInfo) {
    	var me = this;    
        var window = this.getTemporaryformwindow();
        if (!window) {
            window = Ext.widget('temporaryformwindow');
            if(!isEmpty(unavailInfo)) {
            	var unavailInfoModel = new Academia.model.facilitiesresources.resourcemaster.UnavailableInfoModel(unavailInfo);
            	var unavailForm = window.down('form');
            	var form = window.down('form').getForm();
            	unavailForm.down('#reason').getStore().load({
            		callback:function(){
            			form.loadRecord(unavailInfoModel);
            			unavailForm.down('#reason').setValue(unavailInfo.reason);
            		}
            	});      
            	if(unavailInfo.slots != undefined) {
            	for(var i=0;i<=unavailInfo.slots.length-1;i++){      
            		var fields = me.insertTimeSlots(false);
            		if(!isNullOrEmpty(unavailInfo.slots[i].fromTime) && !isNullOrEmpty(unavailInfo.slots[i].toTime)){
            			var fromTime = unavailInfo.slots[i].fromTime.replace(/-/g, "/");
            			var toTime = unavailInfo.slots[i].toTime.replace(/-/g, "/");
						fields.down('[name=fromTime]').setValue(Ext.Date.format(new Date(fromTime), CONSTANTS.DISPLAY_TIME_FORMAT));
        				fields.down('[name=toTime]').setValue(Ext.Date.format(new Date(toTime), CONSTANTS.DISPLAY_TIME_FORMAT));
					}
            		
            	} 
            
            	me.hideAddSlotLink(unavailForm);
            }
            }
        }
        window.show();        
    },

    hideAddSlotLink:function(unavailForm){
    	var timePanel = unavailForm.down('#timeSlotsPanel');
    	var fieldSetArray = timePanel.query('fieldcontainer[name=timeFieldSet]');
    	for(var i=0;i<fieldSetArray.length-1;i++) {
    		fieldSetArray[i].down('#addMoreSlots').setVisible(false);
    	}
    },
    
    showProgramTree: function(btn, isPrimary, isView) {
    	var academyLocationId = null;
    	var resourceId = null;
    	if(isPrimary){
    		var form = btn.up('form');
    		var resourceMasterForm = btn.up('form').up('resourcemasterform');
    		resourceId = resourceMasterForm.down('#id').getValue();
    		academyLocationId = form.down('#academyLocation').getValue();
    	}else{
    		var grid = btn.up('grid');
    		resourceId = grid.up('resourcemasterform').down('#id').getValue();
    		academyLocationId = grid.down('#othAcadLocCombo').getValue();
    	}
    	if(!isNullOrEmpty(academyLocationId)){
    		var window = this.getProgramTreeWindow();
            if (!window) {
                window = Ext.widget('programtreewindow',{
                	isPrimaryAcademyLocation: isPrimary
                });
            }
            window.show();
            if(isView){
            	window.down('#btnAddSelectedItems').setVisible(false);
            }
            this.showProgramBatchTree(academyLocationId, resourceId);
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ACADEMY_LOCATION')); 
            return false;
    	}
        
        
    },
    showProgramBatchTree: function(academyLocationId, resourceId) {
    	if(!isNullOrEmpty(academyLocationId)){
    		var store = this.getProgramTree().getStore();
    		store.load({
    			params:{
    				academyLocationId: academyLocationId,
    				resourceId: resourceId
    			}
    		});
    	}
    },
    showCoursesSelector: function(btn, isPrimary, isView) {
        
        var academyLocationId = null;
        var resourceId = null;
    	if(isPrimary){
    		var form = btn.up('form');
    		var resourceMasterForm = btn.up('form').up('resourcemasterform');
    		resourceId = resourceMasterForm.down('#id').getValue();
    		academyLocationId = form.down('#academyLocation').getValue();
    	}else{
    		var grid = btn.up('grid');
    		resourceId = grid.up('resourcemasterform').down('#id').getValue();
    		academyLocationId = grid.down('#othAcadLocCombo').getValue();
    	}
    	if(!isNullOrEmpty(academyLocationId)){
    		var window = this.getProgramTreeWindow();
            if (!window) {
                window = Ext.widget('courseselectorwindow',{
                	isPrimaryAcademyLocation: isPrimary
                });
            }
            window.show();
            if(isView){
            	window.down('#btnAddSelectedItems').setVisible(false);
            }
            this.showCourseTree(academyLocationId, resourceId);
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ACADEMY_LOCATION')); 
            return false;
    	}
    },
    showCourseTree: function(academyLocationId, resourceId) {
    	if(!isNullOrEmpty(academyLocationId)){
    		var store = this.getCourseSelectorTree().getStore();
    		store.load({
    			params:{
    				academyLocationId: academyLocationId,
    				resourceId: resourceId
    			}
    		});
    	}
    },

    /**
     * This method is use to save the resource
     * */
    saveResource: function(button) {
    	var me = this;
    	var form = button.up('form');
    	var resourceForm = form.down('form').getForm();
    	var tabType = form.down('#tabType').getValue();
    	if(resourceForm.isValid()) {
    		var id =resourceForm.findField("id").getSubmitValue();
    		var submitUrl = '';	        
    		var resourceFormValues = resourceForm.getValues();
    		var category = resourceFormValues.category;
    		var resourceGroup = resourceFormValues.resourceGroup;

    		if(Ext.isObject(resourceFormValues.vehicleSubTypeId)){
    			resourceFormValues.vehicleSubTypeId = resourceFormValues.vehicleSubTypeId.id;	
    		}
    		delete resourceFormValues.type;

    		if (id == "" || id == null) {
    			if(category ==="EXTERNAL") {
    				submitUrl = SERVERURL.CREATE_EXTERNAL_RESOURCE;
    			} else{
    				submitUrl = SERVERURL.CREATE_INTERNAL_RESOURCE;
    			}	           
    		} else if(category ==="EXTERNAL") {
    			submitUrl = SERVERURL.UPDATE_EXTERNAL_RESOURCE;	            
    		} else {
    			submitUrl = SERVERURL.UPDATE_INTERNAL_RESOURCE;	        	
    		}

    		if(!isNullOrEmpty(resourceFormValues.parent)) {
    			var parentObject = new Object();
    			parentObject.id = resourceFormValues.parent;
    			resourceFormValues.parent = parentObject; 
    		} else {
    			delete resourceFormValues.parent;
    		}
    		
    		var unvailabilityInfo;

    		if(resourceFormValues.status !=='ACTIVE') {
    			var hiddenField = me.getUnavailInfoHiddenFormField()
    			if(hiddenField.getValue() !== '') {
    				unvailabilityInfo= Ext.decode(hiddenField.getValue());
    			}
    			unvailabilityInfo = this.createSlot(unvailabilityInfo,resourceFormValues.status);
    			if(isEmpty(unvailabilityInfo)){
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_UNAVAILABILITY_FORM_FIELDS'));
    				return 0;
    			}
    		} else if(unvailabilityInfo ){
    			unvailabilityInfo = undefined;
    		}
    		var capacityArray= new Array();
    		var resourceFormJson;	 

    		if(category ==="INTERNAL") {
    			var primaryALPFormValues;
    			var primaryALPForm = form.down('primaryacademyloc');
    			primaryALPFormValues = this.getPrimaryAcademyLocationValues(primaryALPForm);
    			if(primaryALPFormValues.academyLocation.academyLocation != undefined) {
    				if(resourceGroup ==="HOSTEL"){
    					resourceFormJson = this.createJsonForSaveResource(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo);
    					this.saveResourceAjaxRequest(submitUrl,resourceFormJson,tabType,button);
    				}else{
    					if(primaryALPForm.getForm().isValid()) {	 			
    						if(resourceGroup ==="FACILITY") {
    							// var store = form.down('#seatcapacity').getStore();
    							var store = this.getSeatcapacity().getStore();	      
    							capacityArray = this.getSeatCapacityArray(store);
    							if(capacityArray != undefined && capacityArray.length == store.count()) {
    								resourceFormJson = this.createJsonForSaveResource(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo);
    								this.saveResourceAjaxRequest(submitUrl,resourceFormJson,tabType,button);
    							}
    						} else{ // Internal Equipment
    							resourceFormJson = this.createJsonForSaveResource(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo);
    							this.saveResourceAjaxRequest(submitUrl,resourceFormJson,tabType,button);
    						}
    					} else { //pri acad is  not valid
    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    					}
    				}
    			}else{
    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    			}
    		} else {
    			if(resourceGroup ==="FACILITY") {	 			
    				var store = this.getSeatcapacity().getStore();	      
    				capacityArray = this.getSeatCapacityArray(store);
    				if(capacityArray != undefined && capacityArray.length == store.count()) {
    					resourceFormJson = this.createJsonForSaveResource(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo);
    					this.saveResourceAjaxRequest(submitUrl,resourceFormJson,tabType,button);
    				} 	 		 
    			} else{
    				resourceFormJson = this.createJsonForSaveResource(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo);
    				this.saveResourceAjaxRequest(submitUrl,resourceFormJson,tabType,button);
    			}
    		}	        
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    	}
    },
    
    
    /**
     * This method is use to create the slots object to be saved with the resource.
     */
    createSlot:function(unvailabilityInfo,status) {    
	        if(!isEmpty(unvailabilityInfo)){
	        	 unvailabilityInfo.status = status
	 	        if(unvailabilityInfo.fromTime !== undefined && !unvailabilityInfo.toTime !== undefined) {
	 	        	var fromTimeArray = unvailabilityInfo.fromTime;
	 	        	var slots = new Array();	
	 	        	if(fromTimeArray instanceof Array) {
	 	        		for( var i=0; i< unvailabilityInfo.fromTime.length;i++) {
 	 	        		var slotObject = {};
	  	 	        	slotObject.fromTime =unvailabilityInfo.fromTime[i];
	  	 	        	slotObject.toTime = unvailabilityInfo.toTime[i];
	  	 	        	slots.push(slotObject);
	  	 	        	unvailabilityInfo.slots = slots;
 	 	        	}
	 	        	} else{
	 	        	var slotObject = {};
 	 	        	slotObject.fromTime =unvailabilityInfo.fromTime;
 	 	        	slotObject.toTime = unvailabilityInfo.toTime;
 	 	        	slots.push(slotObject);
 	 	        	unvailabilityInfo.slots = slots;
	 	        	}		        	  	 	       
	 	        	
	 	        	delete unvailabilityInfo.fromTime;
	 	        	delete unvailabilityInfo.toTime
	 	        }
	        }
    	 return unvailabilityInfo;
    },
	/**
	 * This method is use to create json of primary academy location form data.
	 */
    getPrimaryAcademyLocationValues:function(primaryALPForm) {
    	var masterTab = this.getContentPanel().getActiveTab();
        var primaryALPFormValues = primaryALPForm.getValues();
        var academyLocationObject = new Object();
        academyLocationObject.academyLocation = primaryALPFormValues.academyLocation;
        primaryALPFormValues.academyLocation = academyLocationObject;
        //var masterForm = primaryALPForm.up('resourcemasterform');
        if(!isEmpty(primaryALPForm.resourceAcademyLocationPrograms)){
        	primaryALPFormValues.resourceAcademyLocationPrograms = primaryALPForm.resourceAcademyLocationPrograms;
        }
        if(!isEmpty(primaryALPForm.courses)){
        	primaryALPFormValues.courses = primaryALPForm.courses;
        }
        return primaryALPFormValues;
    },
    
    
	 /**
	 * This method is use to send the ajax request to save the resouce
	 */
    saveResourceAjaxRequest:function(submitUrl,resourceFormJson,tabType,button) {
    	button.setDisabled(true); //After clicking on save button it should be disabled
    	var me = this; 
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	
    	Ext.Ajax.request({
	            type: 'rest',
	            url: submitUrl,
	            jsonData: resourceFormJson,
	            method: 'POST',
	            success: function(response) {
	            	 Ext.getBody().unmask();
	            	showSuccessMessage(getCommonTranslation('RESOURCE_MASTER'),getCommonTranslation('SAVEDSUCCESSFULLY'));
	            	var store = me.getSeatcapacity().getStore();
	            	store.commitChanges();
	            	if(!isEmpty(me.unavailInfo)){	            	
	            		me.unavailInfo = {};
	            	}
	            	
	            	me.getContentPanel().getActiveTab().close();
	            	if(tabType == me.FACILITY_TAB) {
	            		me.getTreeFacility().getStore().reload();
	            	} else if(tabType == me.EQUIPMENT_TAB) {
	            		me.getGrdEquipment().getStore().reload();
	            	} else if(tabType == me.HOSTEL_TAB){
	            		me.getHosteltreeTreeFacility().getStore().reload();
	            	}else{
	            		me.getGrdExternalResource().getStore().reload();
	            	}               	
	            },
	            failure:function(){
	            	 Ext.getBody().unmask();
	            	button.setDisabled(false);
	            }
	    	        });
    },
    
    /**
     * This method is use to populate array for the seat capacity
     */
    getSeatCapacityArray:function(store) {    	
    	  var capacityArray = new Array();
	      for(var count=0;count<store.data.length;count++){
	    	  var record=store.getAt(count);	    	  
	    	  var capacity = record.get('capacity');
	            if (!isNullOrEmpty(capacity)) {
	                var capacityObject = new Object();
	                capacityObject.capacity = capacity;
	                var purpose = new Object();
	                purpose.id = record.get('id');
	                capacityObject.bookingPurpose = purpose;
	                capacityArray.push(capacityObject);
	            }else{
	            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENETER_CAPACITY_FOR_REC')+' '+record.get('value')); //Please enter capacity for  
		        	 capacityArray = new Array();
		        	 break;
		         }	       
	      }  
            return capacityArray;
    } ,
    /**
     * @author Rajkumar.patidar
     * Set default value 0
     */
    setDefaultSeatCapacityArray:function(value) {
    	var grid = this.getSeatcapacity();
    	var store = grid.getStore();
    	var models = store.getRange();

    	if(value=='Vehicle'){
    		for(var i=0;i<store.data.length;i++){
    			var record=store.getAt(i);	    	  
    			var capacity = record.get('capacity');
    			if (isNullOrEmpty(capacity)) {
    				models[i].set('capacity', '0');
    			}	       
    		}
    		grid.setVisible(false);
    	}

    } ,
    /**
     * on changing resource type and selecting vehicle as a resource type
     */
    vehicleResourceTypeValidation: function(combo, resourceType){
		var form = combo.up('form');
		var resourseType = form.down("#formComboResourceTypeId");
		var parentNodeId = form.down("#parentNodeId").getValue();
		var type = form.down("#type").getValue();
		var vehicleSubType = form.down("#vehicleSubTypeId");
		if(parentNodeId && resourceType=='Vehicle'){
			vehicleSubType.reset();
			resourseType.reset();
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('VEHICLE_CAN_BE_ADD_ONLY_MY_ORG')); //Selected node should not be an equipment node
			vehicleSubType.setVisible(false);
			vehicleSubType.setDisabled(true);
		}else if(!parentNodeId && resourceType=='Vehicle'){
			vehicleSubType.setVisible(true);
			vehicleSubType.setDisabled(false);
			this.setDefaultSeatCapacityArray(resourceType);
		}else{
			vehicleSubType.reset();
			vehicleSubType.setVisible(false);
			vehicleSubType.setDisabled(true);
		}
		if(type=='Vehicle' && parentNodeId){
			resourseType.reset();
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CHILD_CANT_NOT_ADD_IN_VEHICLE')); //Selected node should not be an equipment node
		}
	},
    
    /**
     * This method is use to save the permanant unavailable pop up form data.
     */
    savePermanentUnvailReason: function(button) {
        var form = button.up('form');
        var values = form.getValues(); 
        var hiddenField = this.getUnavailInfoHiddenFormField();
        hiddenField.setValue(Ext.encode(values));
        form.up('window').close();      
    },

    /**
     * This method is use to save the temprory unavailable pop up form data.
     */
    saveUnavailableInfo:function(button) {
    	 var form = button.up('form');
         var values = form.getValues();        
         this.position=4;
         if(values.type=='COMPLETE_DAY' && (values.fromTime !=undefined || values.toTime!=undefined)) {
        	 delete values.fromTime;
        	 delete values.toTime;
         }
         var hiddenField = this.getUnavailInfoHiddenFormField();
         hiddenField.setValue(Ext.encode(values));
         form.up('window').close();          
    } ,
    
    /**
     * This method is use to create json object of form data to save the resource to database.
     */
    createJsonForSaveResource: function(resourceFormValues, primaryALPFormValues, capacityArray, unvailabilityInfo) {
    	var $this = this;
    	if(!isEmpty(primaryALPFormValues)){
    		primaryALPFormValues.academyLocation.academyLocation = $this.getIdValueJson(primaryALPFormValues.academyLocation.academyLocation);
    		resourceFormValues.primaryResourceAcademyLocation = primaryALPFormValues.academyLocation;
    		resourceFormValues.primaryResourceAcademyLocation.version = primaryALPFormValues.version;
    		resourceFormValues.primaryResourceAcademyLocation.resourceAcademyLocationPrograms = primaryALPFormValues.resourceAcademyLocationPrograms;
			resourceFormValues.primaryResourceAcademyLocation.courses = primaryALPFormValues.courses;
    		
			resourceFormValues.calendar = primaryALPFormValues.calendar;
			if(resourceFormValues.resourceGroup=="HOSTEL") {
    			resourceFormValues.calendar=undefined;
    		}
    	}    	
    	if(!isEmpty(capacityArray)){
    		resourceFormValues.resourceBookingPurposes = capacityArray;
    	}
        
        if(!isEmpty(unvailabilityInfo)){
        	 resourceFormValues.resourceUnavailabilityInfo = unvailabilityInfo;
        }
        if(!isNullOrEmpty(resourceFormValues.clusterCode)) {
			var clusterCodeObject = new Object();
			clusterCodeObject.id = resourceFormValues.clusterCode;
			resourceFormValues.clusterCode = clusterCodeObject; 
		}else{
			delete resourceFormValues.clusterCode;
		}
		if(!isNullOrEmpty(resourceFormValues.hostelType)) {
			var hostelTypeObject = new Object();
			hostelTypeObject.id = resourceFormValues.hostelType;
			resourceFormValues.hostelType = hostelTypeObject; 
		}else{
			delete resourceFormValues.hostelType;
		}
		if(!isNullOrEmpty(resourceFormValues.hostelLevel)) {
			resourceFormValues.hostelLevel = resourceFormValues.hostelLevel; 
		}else{
			delete resourceFormValues.hostelLevel;
		}
		if(!isNullOrEmpty(resourceFormValues.hostelCategory)) {
			resourceFormValues.hostelCategory = resourceFormValues.hostelCategory; 
		}else{
			delete resourceFormValues.hostelCategory;
		}
        var resourceFormJson = Ext.encode(resourceFormValues)
        return resourceFormJson;
    },

    saveProgramTree:function(button) {
    	var window = this.getProgramTreeWindow();
    	var masterTab = this.getContentPanel().getActiveTab();
		var tree = button.up('window').down('programtree');
		var resourceAcademyLocationPrograms = [];
		var treeStore = tree.getStore();
		  treeStore.getRootNode().cascadeBy(function(programNode) {
              if (!isEmpty(programNode.data) && programNode.data.checked && programNode.data.depth==2) {
            	  var obj = {};
            	  var batches = [];
            	  var id = programNode.data.id;
            	  if(!isNullOrEmpty(programNode.data.tableId)){
            		  obj.id = programNode.data.tableId;
            	  }else{
            		  obj.id = null;
            	  }
            	  if(!isNullOrEmpty(programNode.data.version)){
            		  obj.version = programNode.data.version;
            	  }else{
            		  obj.version = null;
            	  }
            	  
            	  var programId = id.replace(/P/g, "");
            	  obj.program = {
            			  id:programId
            	  };
            	  if(!programNode.hasChildNodes()){
            		  obj.batches = batches;
            	  }else{
            		  programNode.eachChild(function(batchNode) {
            			  var batch = {};
                		  id = batchNode.data.id;
                		  var batchId = id.replace(/B/g, "");
                		  batch = {
                    			  id: batchId
                		  };
                		  batches.push({
                			  batch: batch,
                			  id: (!isNullOrEmpty(batchNode.data.tableId))?batchNode.data.tableId:null,
                			  version: (!isNullOrEmpty(batchNode.data.version))?batchNode.data.version:null
                		  });
                		  obj.batches = batches;
                	  });
            	  }
            	  
            	  
            	  resourceAcademyLocationPrograms.push(obj);
            	  
              }
          });
		  if(window.isPrimaryAcademyLocation){
			  var primaryAcademyLocationForm = masterTab.down('primaryacademyloc');
			  primaryAcademyLocationForm.resourceAcademyLocationPrograms = resourceAcademyLocationPrograms;
		  }else{
			  var otherAcademyLocationForm = masterTab.down('otheracadloc');
			  otherAcademyLocationForm.resourceAcademyLocationPrograms = resourceAcademyLocationPrograms;
		  }
		  
		  window.close();
		  console.log(resourceAcademyLocationPrograms);
	},
	
	saveCourseTree:function(button) {
		var window = this.getCourseSelectorWindow();
		var masterTab = this.getContentPanel().getActiveTab();
		var tree = button.up('window').down('courseselector');
		var courses = [];
		var treeStore = tree.getStore();
		  treeStore.getRootNode().cascadeBy(function(courseNode) {
              if (!isEmpty(courseNode.data) && courseNode.data.checked && courseNode.data.depth==2) {
            	  var course = {};
            	  var id = courseNode.data.id;
            	  var courseId = id.replace(/C/g, "");
            	  course = {
            			  id:  courseId
            	  };
            	  courses.push({
            		  course: course,
            		  id: (!isNullOrEmpty(courseNode.data.tableId))?courseNode.data.tableId:null,
            		  version: (!isNullOrEmpty(courseNode.data.version))?courseNode.data.version:null
            	  });
            	  
              }
          });
		  if(window.isPrimaryAcademyLocation){
			  var primaryAcademyLocationForm = masterTab.down('primaryacademyloc');
			  primaryAcademyLocationForm.courses = courses;
		  }else{
			  var otherAcademyLocationForm = masterTab.down('otheracadloc');
			  otherAcademyLocationForm.courses = courses;
		  }
		  window.close();
		  console.log(courses);
	},
	/**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var Button = gridReference.down("#spBtnExtrenalResourceTabAddActions");//itemId of split button
   		if(Button)
   		Button.setVisible(false);
   		var facilitiesButton = gridReference.down('#spBtnFacilityTabAddActions');
   		if(facilitiesButton)
   		facilitiesButton.setVisible(false);
       	 var exportButton=gridReference.down('#exportReportsId');
       	 if(exportButton) {
       		exportButton.setVisible(false); 
       	 }
       	 var resetButton=gridReference.down('#resetButtonItemId');
       	 if(resetButton) {
       		resetButton.setVisible(false); 
       	 }
       	 var hostelResetButton=gridReference.down('#resetButton');
      	 if(hostelResetButton) {
      		hostelResetButton.setVisible(false); 
      		resetButton = hostelResetButton;
      	 }
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(Button)){
           			Button.setVisible(true);//enable more action button
           		}else if(!isNullOrEmpty(facilitiesButton)){
           			facilitiesButton.setVisible(true);
           		}  }      	
           		if (privilege === 'EXPORT_REPORTS') {
            		if(!isNullOrEmpty(exportButton)){
            			exportButton.setVisible(true);
            		}        		
            	}
           		if (privilege === 'RESET') {
            		if(!isNullOrEmpty(resetButton)){
            			resetButton.setVisible(true);
            		}        		
            	}
       	});
       },
       
       /*
        * @author Surendra
        * To make Calendar not read only
        */
       makeCalendarComboEditable: function(form) {
    	   Ext.suspendLayouts();
    	   form.getFields().each(function(field) {
    		   if(field.xtype === 'nestedJsonCombo' && field.itemId == 'comboAssignCalender') {
    			   field.setReadOnly(false);
    		   }
    	   });
    	   Ext.resumeLayouts();
       },
       //Export report for facility resource
       exportReportfun : function(){
   		var $this = this;
   		// code to identify jasper
          var code = "FACILITIES_MASTER_REPORT";
          var reportParams =new Object();
          reportParams.code = code;
          reportParams.reportTitle = code;
          reportParams.locationId = $this.getTreeFacility().down('#cmbLocation').getValue();
          reportParams.resourceGroup = $this.getTreeFacility().down('#cmbResourceGroup').getValue();
          reportParams.resourceTypeId = $this.getTreeFacility().down('#cmbResourceType').getValue();
          reportParams.resourceStatus=$this.getTreeFacility().down('#cmbResourceStatus').getValue();
         
          reportParams.headerName = getCommonTranslation('RESOURCE_FACILITIES_REPORT');//"Facilities Master Report";
          
          var reportTitle="";
          
        $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',"rest/internalResource/exportXcelReport");
       }
       , 
       resetResourceMasterForm:function(form){
    	   var frmResourceBasicDetails = form.down('#resourcebasicdetails');
           var resourceTypeCombo = frmResourceBasicDetails.down('#formComboResourceTypeId');
           var resourceTypeId = resourceTypeCombo.getValue();
          
           var resourceGrouphiddenField = frmResourceBasicDetails.down('#resourceGroup');
           var resourceGroup = resourceGrouphiddenField.getValue();
          
           var resourceCategoryhiddenField = frmResourceBasicDetails.down('#category');
           var resourceCategory = resourceCategoryhiddenField.getValue();
           
           var resourceStatusCombo = frmResourceBasicDetails.down('#formComboResourceStatusId');
           var academyLocationfield= form.down('#primaryacademyloc').down('#academyLocation');
           var academyLocation = academyLocationfield.getValue();
           var parentNodeId= form.down('#parentNodeId').getValue();
           var tabType= form.down('#tabType').getValue();
           form.getForm().reset();
          
           if(resourceTypeId!=undefined){
           resourceTypeCombo.setValue(resourceTypeId);
           resourceGrouphiddenField.setValue(resourceGroup);
           resourceCategoryhiddenField.setValue(resourceCategory);
           resourceStatusCombo.setValue('ACTIVE');
           if(resourceGroup=="HOSTEL" && (resourceTypeId==8 || resourceTypeId==9 || resourceTypeId==10))
        	   academyLocationfield.setValue(academyLocation);
           }
           form.down('#parentNodeId').setValue(parentNodeId);
           form.down('#tabType').setValue(tabType);
       },
       getIdValueJson: function(id, value) {
      		if (id) return {
      			id: id,
      			value: value
      		};
      	},
});
