/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingController',{
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList',
	          'feeandpayment.accountingConfigurationMapping.AccountingYearType',
	          'feeandpayment.accountingConfigurationMapping.ControlAccountFindAll',
	          'feeandpayment.accountingConfigurationMapping.ControlAccountMappingFor',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationBank',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationDiscountCode',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationFeePlan',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationScholarship',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationSponsorship',
	          'feeandpayment.accountingConfigurationMapping.AccountConfigurationCash',
	          'feeandpayment.accountingConfigurationMapping.OtherControlAccountFindAll',
	          'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
	          'feeandpayment.controlAccount.AccountConfigName','feeandpayment.FeeHeads','feeandpayment.DependedFeeHead','feeandpayment.FeeThirdParties',
	          'feeandpayment.discount.DiscountMasterListStore'],
	models :['feeandpayment.accountingConfigurationMaaping.AccountingConfigurationMappingSave',
	         'feeandpayment.accountingConfigurationMaaping.OtherAccountsConfigurationSave'],
	views : ['feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingStructure',
	         'feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList',
	         'feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingWin',
	         'feeandpayment.accountingConfigurationMapping.ConfigureControlAccountTabStructure',
	         'feeandpayment.accountingConfigurationMapping.DefaultAccountsForm',
	         'feeandpayment.accountingConfigurationMapping.OtherAccountsForm',
	         'feeandpayment.accountingConfigurationMapping.OtherAccountsFormWindow'],
	config: {
			CONFIGURATION_MAPPING_GRID_CONFIGURATION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CONFIGURATION_MAPPING_GRID_CONFIGURATION')
	       },
     refs : [{
		    	 ref:'contentPanel',
		    	 selector:'contentpanel'
		     },{
		    	 ref:'accountingConfigurationMappingList',
		    	 selector:'accountingconfigurationmappinglist'
		     },{
		    	 ref:'accountingConfigurationMappingWin',
		    	 selector:'accountingconfigurationmappingwin'
		     },{
		    	 ref:'accountingConfigurationMappingWinForm',
		    	 selector:'accountingconfigurationmappingwin form'
		     },{
		    	 ref:'configureControlAccountTabStructure',
		    	 selector:'configurecontrolaccounttabstructure'
		     },{
		    	 ref:'defaultAccountsForm',
		    	 selector:'defaultaccountsform' 
		     },{
		    	 ref:'otherAccountsForm',
		    	 selector:'otheraccountsform' 
		     },{
		         ref:'stdOtherAccountGrid',
		         selector: 'otheraccountsform #stdOtherAccountGrid'
		     },{
		    	 ref:'otherAccountsFormWindow',
		    	 selector:'otheraccountsformwindow'
		     },{
		    	 ref:'otherAccountsFormWin',
		    	 selector:'otheraccountsformwindow form'
		     }],
     init : function() {
    	 this.control({
    		 'accountingconfigurationmappinglist':{
    			 render : this.getRenderAccountingConfigurationMappingList,
					afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getCONFIGURATION_MAPPING_GRID_CONFIGURATION());
					},1500);
    			 },
     		 },
     		 'accountingconfigurationmappinglist button[itemId=btnAdd]':{
   			     click : this.openAccountingConfigurationMappingWin
    		 },
    		 'accountingconfigurationmappinglist button[itemId=btnEdit]':{
   			     click : this.getEditAccountingConfigurationMappingWin
    		 },
    		 'accountingconfigurationmappinglist button[itemId=btnView]':{
   			     click : this.getViewAccountingConfigurationMappingWin
    		 },
    		 'accountingconfigurationmappinglist button[itemId=btnDelete]':{
   			     click : this.getDeleteAccountingConfigurationMappingWin
    		 },
    		 'accountingconfigurationmappingwin customcombobox#accountingYear':{
    			 select : function(obj,record){
    				 var form = this.getAccountingConfigurationMappingWin();
    				 form.down("#currentAccountingYear").setValue(record[0].get("currentAccountingYear"));
    				 form.down("#companyCode").setValue(record[0].get("companyCode"));
    				 form.down("#companyIp").setValue(record[0].get("companyIp"));
    			 }
    		 },
    		 'accountingconfigurationmappingwin button[itemId=SubmitBtn]' :{
    			 click : this.getSaveAccountingConfigurationMappingWin
    		 },
    		 'accountingconfigurationmappingwin button[itemId=CancelBtn]' :{
    			 click : this.getCloseMappingWin
    		 },
    		 'accountingconfigurationmappinglist menuitem[itemId=configureControlAccountLink]':{
   			     click : this.getOpenConfigureControlAccounts
    		 }/*,
    		 'defaultaccountsform button[itemId=SubmitBtn]':{
    			 click : this.saveDefaultAccounts
    		 }*/,
    		 'defaultaccountsform button[itemId=SubmitBtn]':{
    			 click : this.saveDefaultAccounts
    		 },
    		 'defaultaccountsform button[itemId=ResetBtn]' :{
    			 click : this.resetDefaultAccounts
    		 },
    		 'otheraccountsform' :{
    			 afterrender:function(){
    				 var form = this.getOtherAccountsForm();
    				    var grid = this.getAccountingConfigurationMappingList();
    				    var records=grid.getSelectionModel().getSelection()[0];	
    				    var accountConfigId = records.get("accountConfigId");
    		  			var configurationName = records.get("configurationName");
    		  			var iau = records.get("iau");
    		  			var id = records.get("id"); 
    		  			
    		  			form.down("#id").setValue(id);
    		  			form.down("#configureName").setValue(configurationName);
    		  			form.down("#organizationName").setValue(iau);
    		  			form.down("#iauAccountingId").setValue(id);
    		  			form.down("#accountConfigId").setValue(accountConfigId);
    		  			
    		  			/**
    		  			 * @author Rajkumar.patidar
    		  			 * setter getter  for iauId
    		  			 */
    		  			Ext.apply(form, {
    		  				iauId: null,
    		  				setIauId: function(iauId) {
    		  					form.iauId = iauId;
    		  				},
    		  				getIauId: function() {
    		  					return form.iauId;
    		  				}
    		  			});
    		  			form.setIauId(records.get("iauId"));
    			 }
    		 },
    		 'otheraccountsform customcombobox#controlAccountMappingFor' :{
    			 select:function(obj,record){
    				 var requestType = record[0].get("id");
    				 var url = this.getOtherAccountDetailsUrl(requestType);
    				 this.getStdOtherAccountGrid().setVisible(true);
    	    		 this.reconfigureGrid(requestType,url);
    			 }
    		 },
    		 'otheraccountsform #stdOtherAccountGrid  button[itemId=btnAdd]': {
                 click:this.showOtherAccountsWindow
             },
             'otheraccountsform #stdOtherAccountGrid  button[itemId=btnDelete]': {
                 click:this.getDeleteOtherAccounts
             },
             'otheraccountsform #stdOtherAccountGrid  button[itemId=btnEdit]': {
                 click:this.getEditOtherAccounts
             },
             'otheraccountsform #stdOtherAccountGrid  button[itemId=btnView]': {
                 click:this.getViewOtherAccounts
             },
             'otheraccountsformwindow button[itemId=CancelBtn]':{
            	 click : this.closeOtherAccountsWindow
             },
             'otheraccountsformwindow button[itemId=formSubmitButtonId]':{
            	 click : this.saveOtherAccountsWindow
             },
             'otheraccountsformwindow customcombobox#bankName':{
    			 select : function(obj,record){
    				 var form = this.getOtherAccountsFormWindow();
    				 form.down("#branchName").setValue(record[0].get("branchName"));
    				 form.down("#bankAccount").setValue(record[0].get("bankAccount"));
    			 }
    		 }
    	 });
     },
     /**
      * get List data of Accounting configuration mapping  grid
      */
     getRenderAccountingConfigurationMappingList : function(){
    	 
    	 var grid = this.getAccountingConfigurationMappingList();
    	 var store = grid.getStore();
    	 store.load();
     },
     /**
      * 
      */
     openAccountingConfigurationMappingWin : function(){
    	 var $this = this;
    	 var gridWindow = $this.getAccountingConfigurationMappingWin();
		  if (!gridWindow) {
			  Ext.widget('accountingconfigurationmappingwin');
			   gridWindow = $this.getAccountingConfigurationMappingWin();
		  }
		  gridWindow.show();
     },
     
     getCloseMappingWin : function(){
    	 this.getAccountingConfigurationMappingWin().close();
     },
     
     /**
      * save Account configuration Mapping information
      */
     getSaveAccountingConfigurationMappingWin : function(){
    	var this$ = this;
     	var grid = this$.getAccountingConfigurationMappingList();
     	var grdStore = grid.getStore();
     	var formWin = this$.getAccountingConfigurationMappingWinForm();
     	var form = formWin.getForm();
     	var value = form.getValues();
     	
     	var ACMModel = new Academia.model.feeandpayment.accountingConfigurationMaaping.AccountingConfigurationMappingSave();
     	
     	ACMModel.set("accountConfig",this$.getIdValueJson(value.accountConfig));
     	ACMModel.set("organizationUnit",this$.getIdValueJson(value.organizationUnit));
     	ACMModel.set("startDate",value.startDate);
     	ACMModel.set("tillDate",value.tillDate);
     	ACMModel.set("accountingYear",this$.getIdValueJson(value.accountingYear));
     	ACMModel.set("whetherSubLedgerAccounting",value.whetherSubLedgerAccounting);
     	ACMModel.set("whetherSales",value.whetherSales);
         
     	var MESSAGE;
     	if (value.id == null ||value.id == "") {
 			submitUrl = SERVERURL.ACCOUNT_CONFIGUARTION_MAPPING_CREATE;
 			MESSAGE = getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING_CREATED_SUCCESSFULLY');
 		} else {
 			ACMModel.set("id",value.id);
 			submitUrl = SERVERURL.ACCOUNT_CONFIGUARTION_MAPPING_UPDATE;
 			MESSAGE = getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING_UPDATED_SUCCESSFULLY');
 		}
     	var submitData = Ext.encode(ACMModel.data);
     	 this$.applyWindowMask(); 
     	
     	Ext.Ajax.request({
 			url: submitUrl,
 			jsonData: submitData,
 			method: 'POST',
 			success: function(response) {
 				this$.hideWindowMask();
 				grdStore.reload();
 				this$.getCloseMappingWin();
 				var id = response.responseText;
				if(id==0){
					showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'), getFeeAndPaymentCommonTranslation('CUTOM_MSG_FOR_SAME_IAU_PERIOD')); //Error occured while performing transaction
				}else{
					showSuccessMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),MESSAGE);
				}
 				
 			}
 		});
  	 },
  	 
  	  /**
      * get edit Account Configuration mapping Win
      */
  	getEditAccountingConfigurationMappingWin: function() {
  		 var this$ = this;
  		 var grid = this$.getAccountingConfigurationMappingList();
  		 if (grid.getSelectionModel().getCount() > 0) {
  			 this.openAccountingConfigurationMappingWin();
  			 var form = this$.getAccountingConfigurationMappingWinForm();
  			 var record = grid.getSelectionModel().getSelection()[0];
  			 var id = record.get("id");
  			 var editUrl = SERVERURL.ACCOUNT_CONFIGUARTION_MAPPING_FINDBYID;
//  			this$.applyWindowMask(); 
  			
  			 Ext.Ajax.request({
  				 method: "GET",
  				 type: 'rest',
  				 url: editUrl,
  				 params: {
  					 id: id
  				 },
  				 success: function(f, action) {
  					var ACMData = Ext.JSON.decode(f.responseText);
  					var ACMModel = new Academia.model.feeandpayment.accountingConfigurationMaaping.AccountingConfigurationMappingSave(ACMData);
  					form.loadRecord(ACMModel);
  					 var accountConfigId = ACMData.accountConfig.id;
  					 var organizationUnitId = ACMData.organizationUnit.id;
  					 var accountingYearId = ACMData.accountingYear.id;
  					 var whetherSubLedgerAccounting = ACMData.whetherSubLedgerAccounting;
  					 var whetherSales = ACMData.whetherSales;

  					 form.down("#whetherSubLedgerAccountingId").setValue(whetherSubLedgerAccounting);
  					 var whetherSalesId = form.down("#whetherSalesId");
  					 if(!whetherSales){
  						 whetherSalesId.items.items[0].setValue(true);
  					 }else{
  						 whetherSalesId.items.items[1].setValue(true);
  					 }
  					 var accountConfig = form.down("#accountConfig");
  					 accountConfig.store.load({
  						 callback: function(records, operation, success) {
  							 if (success) {
  								 accountConfig.setValue(accountConfigId);
  							 }
  						 }
  					 });

  					 var organizationUnit = form.down("#organizationUnit");
  					 organizationUnit.store.load({
  						 callback: function(records, operation, success) {
  							 if (success) {
  								organizationUnit.setValue(organizationUnitId);
  								
  							 }
  						 }
  					 });
  					 var accountingYear = form.down("#accountingYear");
   					var startDate=form.down("#startDate");
  					var tillDate=form.down("#tillDate");
  					 accountingYear.store.load({
  						 callback: function(records, operation, success) {
  							 if (success) {
  								accountingYear.setValue(accountingYearId);
  							 }
  						 }
  					 });
  					form.down("#currentAccountingYear").setValue(ACMData.accountingYear.currentAccountingYear);
  					form.down("#companyCode").setValue(ACMData.accountingYear.companyCode);
  					form.down("#companyIp").setValue(ACMData.accountingYear.companyIp);
  					startDate.setValue(dateRender(ACMData.startDate));
	  				tillDate.setValue(dateRender(ACMData.tillDate));
  					
  					
//  					this$.hideWindowMask();
  				 }
  				 
  			 });
  		 } else {
//  			this$.hideWindowMask();
  			 showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  		 }
  	 },
  	
  	/**
      * get view (read only) Accounting Configuration win
      */
  	getViewAccountingConfigurationMappingWin : function(){
  		var this$ = this;
  		this$.getEditAccountingConfigurationMappingWin();
  		var form = this$.getAccountingConfigurationMappingWinForm();
  		if (form) {
  			form.down("#SubmitBtn").setVisible(false);
  			form = form.getForm();
  			toggleReadOnlyFormItems(form, true);
  		}
  	},
  	
  	/**
     * get delete Accounting Configuration mapping information
     */
  	getDeleteAccountingConfigurationMappingWin : function(){
  		 var this$ = this;
    	 var grid = this$.getAccountingConfigurationMappingList();
    	 var grdStore = grid.getStore();
		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.ACCOUNT_CONFIGUARTION_MAPPING_DELETE+'?id='+id,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(form, action){
							grdStore.reload();
							showSuccessMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING_DELETED_SUCCESSFULLY'));
						}
					});
				}
			});
		}else{
			showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
  	},
  	
  	/**
  	 * get open configure control Accounts tab
  	 */
  	getOpenConfigureControlAccounts : function(){
  		var $this = this;

  		var grid = $this.getAccountingConfigurationMappingList();
  		var grdStore = grid.getStore();

  		if(grid.getSelectionModel().getCount()>0){

  			var contentpanel = $this.getContentPanel();
  			var structure = Ext.widget('configurecontrolaccounttabstructure');
  			var tabName = getFeeAndPaymentCommonTranslation('CONFIGURE_CONTROL_ACCOUNTS');

  			var getcontroller=this.getController('menu.CoreERPNavigationController');
  			var getTab=getcontroller.getTab(tabName);
  			if(getTab!=null){
  				contentpanel.remove(getTab, true);
  			}
  			openTab(contentpanel,tabName,structure,CONSTANTS.MENU_COLOR_FIVE);	

  			var records=grid.getSelectionModel().getSelection()[0];	
  			var accountConfigId = records.get("accountConfigId");
  			var configurationName = records.get("configurationName");
  			var iau = records.get("iau");
  			var iauAccountingId = records.get("id");
  			var iauId = records.get("iauId");

  			var store = $this.getStore('feeandpayment.accountingConfigurationMapping.ControlAccountFindAll');
  			store.getProxy().extraParams = {
  				accountConfigId : accountConfigId,
  				whetherDefault:true,
  				iauId:iauId
  			};
  			store.load();

  			var defaultForm = structure.down("#defaultaccountsform");

  			defaultForm.down("#configureName").setValue(configurationName);
  			defaultForm.down("#organizationName").setValue(iau);
  			defaultForm.down("#iauAccountingId").setValue(iauAccountingId);

  			var editUrl = SERVERURL.CONFIGURATION_CONTROL_DEFAULT_ACCOUNT_FIND_BY_ID;
  			Ext.Ajax.request({
  				method: "GET",
  				type: 'rest',
  				url: editUrl,
  				params: {
  					iauAccountingId: iauAccountingId
  				},
  				success: function(f, action) {
  					var defaultAccountsData = Ext.JSON.decode(f.responseText);
  					if(defaultAccountsData.length>0){
  						//defaultForm.loadRecord(DAModel);
  						
  						defaultForm.down("#ResetBtn").setVisible(false);
  						
  						defaultForm.down('#baseId').setValue(defaultAccountsData[0].id);
  						defaultForm.down('#id0').setValue(defaultAccountsData[0].id);
  						defaultForm.down('#id1').setValue(defaultAccountsData[1].id);
  						defaultForm.down('#id2').setValue(defaultAccountsData[2].id);
  						defaultForm.down('#id3').setValue(defaultAccountsData[3].id);
  						defaultForm.down('#id4').setValue(defaultAccountsData[4].id);
  						defaultForm.down('#id5').setValue(defaultAccountsData[5].id);
  						defaultForm.down('#id6').setValue(defaultAccountsData[6].id);
  						defaultForm.down('#id7').setValue(defaultAccountsData[7].id);
  						defaultForm.down('#id8').setValue(defaultAccountsData[8].id);
  						defaultForm.down('#id9').setValue(defaultAccountsData[9].id);
  						defaultForm.down('#id10').setValue(defaultAccountsData[10].id);
  						defaultForm.down('#id11').setValue(defaultAccountsData[11].id);
  						defaultForm.down('#id12').setValue(defaultAccountsData[12].id);
  						defaultForm.down('#id13').setValue(defaultAccountsData[13].id);
  						defaultForm.down('#id14').setValue(defaultAccountsData[14].id);
  						
  						var accountConfig0 = defaultForm.down('#controlAccount0');
  						var accountConfig1 = defaultForm.down('#controlAccount1');
  						var accountConfig2 = defaultForm.down('#controlAccount2');
  						var accountConfig3 = defaultForm.down('#controlAccount3');
  						var accountConfig4 = defaultForm.down('#controlAccount4');
  						var accountConfig5 = defaultForm.down('#controlAccount5');
  						var accountConfig6 = defaultForm.down('#controlAccount6');
  						var accountConfig7 = defaultForm.down('#controlAccount7');
  						var accountConfig8 = defaultForm.down('#controlAccount8');
  						var accountConfig9 = defaultForm.down('#controlAccount9');
  						var accountConfig10 = defaultForm.down('#controlAccount10');
  						var accountConfig11 = defaultForm.down('#controlAccount11');
  						var accountConfig12 = defaultForm.down('#controlAccount12');
  						var accountConfig13 = defaultForm.down('#controlAccount13');
  						var accountConfig14 = defaultForm.down('#controlAccount14');

  						accountConfig0.store.load({params:{accountConfigId : accountConfigId,whetherDefault:true},
  							callback: function(records, operation, success) {
  								if (success) {
  									accountConfig0.setValue(defaultAccountsData[0].controlAccount.id);
  									accountConfig1.setValue(defaultAccountsData[1].controlAccount.id);
  									accountConfig2.setValue(defaultAccountsData[2].controlAccount.id);
  									accountConfig3.setValue(defaultAccountsData[3].controlAccount.id);
  									accountConfig4.setValue(defaultAccountsData[4].controlAccount.id);
  									accountConfig5.setValue(defaultAccountsData[5].controlAccount.id);
  									accountConfig6.setValue(defaultAccountsData[6].controlAccount.id);
  									accountConfig7.setValue(defaultAccountsData[7].controlAccount.id);
  									accountConfig8.setValue(defaultAccountsData[8].controlAccount.id);
  									accountConfig9.setValue(defaultAccountsData[9].controlAccount.id);
  									accountConfig10.setValue(defaultAccountsData[10].controlAccount.id);
  									accountConfig11.setValue(defaultAccountsData[11].controlAccount.id);
  									accountConfig12.setValue(defaultAccountsData[12].controlAccount.id);
  									accountConfig13.setValue(defaultAccountsData[13].controlAccount.id);
  									accountConfig14.setValue(defaultAccountsData[14].controlAccount.id);

  								}
  							}
  						});
  					}
  				}
  			});
  		}else{
  			showWarningMessage(getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD')); 
  		}
  	},
  	
  	/**
  	 * get reset defaults accounts form
  	 */
  	resetDefaultAccounts : function(){
  		 var form = this.getDefaultAccountsForm().getForm();
    	 form.getFields().each(function(field) {
    		 if(field.name !== 'configureName' && field.name != 'organizationName' && field.name !='iauAccountingId') {
    			 field.reset();	
    		 }
    	 });
    	 Ext.resumeLayouts();
  	},
  	/**
  	 * Save Defaults Account information
  	 */
  	saveDefaultAccounts : function(){
  		var $this = this;
  		var frm = $this.getDefaultAccountsForm();
  		var form = frm.getForm();
  		var value = form.getValues();
  		var id = value.id;
  		var iauAccountingId = value.iauAccountingId;
  		var controlAccount = value.controlAccount;
  		var configurationKeyForTally = ['FEE_CONTROL_ACCOUNT','DISCOUNT_CONTROL_ACCOUNT','STUDENT_CONTROL_ACCOUNT',
  		                                'STUDENT_ACCOUNT_WITHOUT_ADMISSIONID','USER_PAYMENT_CONTROL_ACCOUNT_NON_TEACHING','USER_PAYMENT_CONTROL_ACCOUNT_TEACHING',
  		                                'APPLICANT_CONTROL_ACCOUNT','DEPENDENT_FEE_CONTROL_ACCOUNT',
  		                                'THIRDPARTY_CONTROL_ACCOUNT','SCHOLARSHIP_CONTROL_ACCOUNT','SPONSORSHIP_CONTROL_ACCOUNT',
  		                                'BANK_COLLECTION_CONTROL_ACCOUNT','CASH_COLLECTION_CONTROL_ACCOUNT',
  		                                'INTER_IAU_CONTROL_ACCOUNT','PROFIT_AND_LOSS_CONTROL_ACCOUNT'];
  		var defaultAccountsJson=[];
  		for(var i in controlAccount){
  			defaultAccountsJson.push({
  				 "id":id[i],
  				"iauAccountingId":iauAccountingId,
  				"controlAccount":$this.getIdValueJson(controlAccount[i]),
  				"configurationKeyForTally":configurationKeyForTally[i]
  			});
  		}
  		var submitData = Ext.encode(defaultAccountsJson);
  		
     	if (value.baseId == null ||value.baseId == "") {
 			submitUrl = SERVERURL.CONFIGURATION_CONTROL_DEFAULT_ACCOUNT_CREATE;
 		} else {
 			submitUrl = SERVERURL.CONFIGURATION_CONTROL_DEFAULT_ACCOUNT_UPDATE;
 		}
     	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     	
     	Ext.Ajax.request({
 			url: submitUrl,
 			jsonData: submitData,
 			method: 'POST',
 			success: function(response) {
 				 Ext.getBody().unmask();
 				form.reset();
 				showSuccessMessage(getFeeAndPaymentCommonTranslation('DEFAULT_ACCOUNTS'),getFeeAndPaymentCommonTranslation('TRANSACTION_SUCCESS'));
 			}
 		});

  	},
  	/**
  	 * it will return url for basis for mapping
  	 */
  	getOtherAccountDetailsUrl:function(requestType) { 
    	var url = '';
    	switch(requestType) {
    	case 'FEE_HEAD' :{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_FEE_HEAD;
    		break;
    	}
    	case 'FEE_PLAN':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_FEE_PLAN;
    		break;
    	}
    	case 'FEE_HEAD_PLUS_FEE_PLAN' :{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_FEE_HEAD_AND_FEE_PLAN;
    		break;
    	}
    	case 'SCHOLARSHIP':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_SCHOLARSHIP;
    		break;
    	}
    	case 'SPONSORSHIP':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_SPONSORSHIP;
    		break;
    	}
    	case 'BANK_ACCOUNT':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_BANK;
    		break;
    	}
    	case 'CASH_ACCOUNT':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_CASH;
    		break;
    	}
    	case 'DEPENDENT_FEE_HEAD':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_DFH;
    		break;
    	}
    	case 'THIRDPARTY':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_THIRD_PARTY;
    		break;
    	}
    	case 'DISCOUNT_CODE':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_DISCOUNT_CODE;
    		break;
    	}
    	case 'DISCOUNT_TYPE_MAPP':{
    		url = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FOR_DISCOUNT_TYPE;
    		break;
    	}
    	}
    	
    	return url;
    },
    /**
     * Dynamically create master grid and form from table id and table meta data.
     * 
     * @param requestType
     *             requestTyper for the column.
     * @param url
     *             url for store data. 
     */
    reconfigureGrid: function(requestType,url) {

        var this$ = this;
        var columnModel = [];
        var columnHeader = [];
        var grid = this.getStdOtherAccountGrid();

        this$.loadColumnModelAndHeader(requestType,columnModel,columnHeader);
        this$.createGrid(grid,columnModel,columnHeader,url);
    },
    /**
     *  This method loads header for grid and model fields of store.
     * 
     * @param columnModel
     *             Array in which model for store will be added.
     * @param columnHeader
     *             Array in which header for grid will be added.
     * @param requestType
     *             requestType for columns and store model. 
     */
    loadColumnModelAndHeader: function(requestType,columnModel, columnHeader) {
    	
    	var columnMetaData = [];
    	
        	switch(requestType) {
        	case 'FEE_HEAD' :{
        	 columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('FEE_HEAD'),'fieldName':'feeHead'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'FEE_PLAN':{
        	 columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('FEE_PLAN'),'fieldName':'feePlan'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                               {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'FEE_HEAD_PLUS_FEE_PLAN' :{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('FEE_HEAD'),'fieldName':'feeHead'},
           	                      {'fieldLabel':getFeeAndPaymentCommonTranslation('FEE_PLAN'),'fieldName':'feePlan'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'SCHOLARSHIP':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),'fieldName':'scholarShip'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'SPONSORSHIP':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('SPONSOR'),'fieldName':'sponsor'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'BANK_ACCOUNT':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('BANK_NAME'),'fieldName':'bankName'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('BRANCH_NAME'),'fieldName':'branchName'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('BANK_ACCOUNT'),'fieldName':'bankAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'CASH_ACCOUNT':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('LEDGER_NAME'),'fieldName':'ledgerName'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'DEPENDENT_FEE_HEAD':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('DEPENDED_FEE_HEADS'),'fieldName':'dependentFeeHead'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'THIRDPARTY':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('THIRD_PARTY'),'fieldName':'thirdParty'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'DISCOUNT_CODE':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),'fieldName':'discountCode'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	case 'DISCOUNT_TYPE_MAPP':{
        		columnMetaData = [{'fieldLabel':getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),'fieldName':'discountMaster'},
        		                  {'fieldLabel':getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),'fieldName':'controlAccount'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_DEBIT'),'fieldName':'textForNarrationOnDebit'},
                                  {'fieldLabel':getFeeAndPaymentCommonTranslation('TEXT_FOR_NARRATION_ON_CREDIT'),'fieldName':'textForNarrationOnCredit'}];
        		break;
        	}
        	}
        
        Ext.each(columnMetaData, function(obj) {
            var fieldLabel = obj.fieldLabel;
            var fieldName = obj.fieldName;
            columnModel.push({
            	name: fieldName
            });
            columnHeader.push({
            	header: fieldLabel,
            	flex: 1,
            	dataIndex: fieldName
            });
        });
    },
    /**
     * Create grid by dynamic columnModel, columnHeader and master table id .
     * 
     * @param grid
     *          Reference object of grid. 
     * @param columnModel
     *          Array for store model fields.
     * @param columnHeader
     *          Array of header of grid.
     * @param url
     *         url for diffrent request type.
     */
    createGrid: function(grid,columnModel,columnHeader,url) {
    	var form = this.getOtherAccountsForm();
    	var iauAccountingId = form.down("#id").getValue();
        
    	grid.getSelectionModel().deselectAll(true);
        
    	var params = {
        	iauAccountingId: iauAccountingId
        };
        var store = this.createGridStore(columnModel, url, params);
        store.load();
        Ext.suspendLayouts();
        grid.reconfigure(store, columnHeader);
        Ext.resumeLayouts(true);
        //Rebind store to grid
        grid.down('pagingtoolbar').bindStore(store);
    },

    /**
     * This function create dynamic store with pagination of size 30 by column model and url.
     * 
     * @param columnModel
     *          Column model contains array of fields. 
     * @param url
     *          URL for reading data. 
     */
    createGridStore: function(columnModel, url, params) {
        var store = Ext.create('Ext.data.Store', {
            fields: columnModel,

            autoDestroy: true,
            autoLoad: false,

            remoteFilter: true,
            remoteSort: true,
            sortOnLoad: true,
            pageSize: 5,

            extraParams: params,

            proxy: {
                type: 'rest',
                api: {
                    read: url
                },
                reader: {
                    type: 'json',
                    root: 'rows',
                    totalProperty: 'records'
                },
                extraParams: params
            }
        });
        return store;
    },
      /**
       * 
       * show dynamic window
       */  
    showOtherAccountsWindow: function() {
    	
        var parentFormWindow = this.getOtherAccountsFormWindow();
        if (!parentFormWindow) {
        	Ext.widget('otheraccountsformwindow');
            parentFormWindow = this.getOtherAccountsFormWindow();
        }
        var form = this.getOtherAccountsForm();
        var accountConfigId = form.down("#accountConfigId").getValue();
        var iauId = form.getIauId();
        var store = parentFormWindow.down("#controlAccount").getStore();
  			store.getProxy().extraParams = {
  				accountConfigId : accountConfigId,
  				whetherDefault:false,
  				iauId:iauId
  			};
  			store.load();
        	
      
        var mappingFor = form.down("#controlAccountMappingFor").getValue();
        switch(mappingFor) {
    	case 'FEE_HEAD' :{
    		var feeHead = parentFormWindow.down("#feeHead");
    		feeHead.setVisible(true);
    		feeHead.allowBlank=false;
    		
    		break;
    	}
    	case 'FEE_PLAN':{
    		var feePlan = parentFormWindow.down("#feePlan");
    		feePlan.setVisible(true);
    		feePlan.allowBlank=false;
    		break;
    	}
    	case 'FEE_HEAD_PLUS_FEE_PLAN' :{
    		var feeHead = parentFormWindow.down("#feeHead");
    		var feePlan = parentFormWindow.down("#feePlan");
    		
    		feeHead.setVisible(true);
    		feeHead.allowBlank=false;
    		
    		feePlan.setVisible(true);
    		feePlan.allowBlank=false;
    		
    		break;
    	}
    	case 'SCHOLARSHIP':{
    		var scholarship = parentFormWindow.down("#scholarship");
    		scholarship.setVisible(true);
    		scholarship.allowBlank=false;
    		break;
    	}
    	case 'SPONSORSHIP':{
    		var sponsorship = parentFormWindow.down("#sponsorship");
    		sponsorship.setVisible(true);
    		sponsorship.allowBlank=false;
    		break;
    	}
    	case 'BANK_ACCOUNT':{
    		var bankName = parentFormWindow.down("#bankName");
    		bankName.setVisible(true);
    		bankName.allowBlank=false;
    		parentFormWindow.down("#branchName").setVisible(true);
    		parentFormWindow.down("#bankAccount").setVisible(true);
    		break;
    	}
    	case 'CASH_ACCOUNT':{
    		var ledgerName = parentFormWindow.down("#ledgerName");
    		ledgerName.setVisible(true);
    		ledgerName.allowBlank=false;
    		break;
    	}
    	case 'DEPENDENT_FEE_HEAD':{
    		var dependantFeeHead = parentFormWindow.down("#dependantFeeHead");
    		dependantFeeHead.setVisible(true);
    		dependantFeeHead.allowBlank=false;
    		break;
    	}
    	case 'THIRDPARTY':{
    		var thirdParties = parentFormWindow.down("#thirdParties");
    		thirdParties.setVisible(true);
    		thirdParties.allowBlank=false;
    		break;
    	}
    	case 'DISCOUNT_CODE':{
    		var discountCode = parentFormWindow.down("#discountCode");
    		discountCode.setVisible(true);
    		discountCode.allowBlank=false;
    		break;
    	}
    	case 'DISCOUNT_TYPE_MAPP':{
    		var discountMaster = parentFormWindow.down("#discountMaster");
    		discountMaster.setVisible(true);
    		discountMaster.allowBlank=false;
    		break;
    	}
    	
    	}
        parentFormWindow.show();
    },
    /**
     * close wondow
     */
    closeOtherAccountsWindow : function(){
    	this.getOtherAccountsFormWindow().close();
    },
    saveOtherAccountsWindow : function(){
    	var $this = this;
    	 var grid = $this.getStdOtherAccountGrid();
    	 var store = grid.getStore();
    	var frm = $this.getOtherAccountsFormWin();
    	var form = frm.getForm();
    	var value = form.getValues();
    	var oaForm = $this.getOtherAccountsForm();
    	var iauAccountingId = oaForm.down("#iauAccountingId").getValue();
    	var mappingFor =  oaForm.down("#controlAccountMappingFor").getValue();
    	
    	submitData=[];
    	submitData.push({
    	 "id":value.id,	
    	 "iauAccountingId":iauAccountingId,
    	 "controlAccount":$this.getIdValueJson(value.controlAccount),
    	 "debitNarration":value.debitNarration,
    	 "creditNarration":value.creditNarration,
    	 "controlAccountMappingFor":mappingFor,
    	 "feeHead":$this.getIdValueJson(value.feeHead),
    	 "feePlan":$this.getIdValueJson(value.feePlan),
    	 "dependentFeeHead":$this.getIdValueJson(value.dependantFeeHead),
    	 "discountCode":$this.getIdValueJson(value.discountCode),
    	 "discountMaster":$this.getIdValueJson(value.discountMaster),
    	 "scholarship":$this.getIdValueJson(value.scholarship),
    	 "sponsor":$this.getIdValueJson(value.sponsorship),
    	 "feeThirdParties":$this.getIdValueJson(value.thirdParties),
    	 "bank":$this.getIdValueJson(value.bankName),
    	 "feeLedgerMaster":$this.getIdValueJson(value.ledgerName)
        });
    	var submitUrl ='';
    	if (value.id == null ||value.id == "") {
 			submitUrl = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_CREATE;
 		} else {
 			submitUrl = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_UPDATE;
 		}
    	$this.applyWindowMask(); 
    	
    	Ext.Ajax.request({
 			url: submitUrl,
 			jsonData: submitData,
 			method: 'POST',
 			success: function(response) {
 				  $this.hideWindowMask();
 				showSuccessMessage(getFeeAndPaymentCommonTranslation('OTHER_ACCOUNTS'),getFeeAndPaymentCommonTranslation('TRANSACTION_SUCCESS'));
 				$this.closeOtherAccountsWindow();
 				store.reload();
 			}
 		});
    },
   /**
    * get delete othr Account information
    */
    getDeleteOtherAccounts : function(){
    	 var this$ = this;
    	 var grid = this$.getStdOtherAccountGrid();
    	 var grdStore = grid.getStore();
		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getFeeAndPaymentCommonTranslation('OTHER_ACCOUNTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_DELETE+'?id='+id,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(form, action){
							showSuccessMessage(getFeeAndPaymentCommonTranslation('OTHER_ACCOUNTS'),getFeeAndPaymentCommonTranslation('TRANSACTION_SUCCESS'));
							grdStore.reload();
						}
					});
				}
			});
		}else{
			showWarningMessage(getFeeAndPaymentCommonTranslation('OTHER_ACCOUNTS'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    /**
     * get edit Control Account Win
     */
    getEditOtherAccounts: function() {
    	var this$ = this;
    	var grid = this$.getStdOtherAccountGrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		this$.showOtherAccountsWindow();
    		var form = this$.getOtherAccountsFormWin();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var id = record.get("id");
    		var editUrl = SERVERURL.CONFIGURATION_CONTROL_ACCOUNT_FINDBYID;
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: editUrl,
    			params: {
    				id: id
    			},
    			success: function(f, action) {
    				var otherAccountData = Ext.JSON.decode(f.responseText);
    				console.log('otherAccountData',otherAccountData);
    				var otherAccountModel = new Academia.model.feeandpayment.accountingConfigurationMaaping.OtherAccountsConfigurationSave(otherAccountData);
    				form.loadRecord(otherAccountModel);
    				
    				 	
    				var controlAccount = otherAccountData.controlAccount;
    				var feeHead = otherAccountData.feeHead;
    				var bank = otherAccountData.bank;
    				var dependentFeeHead = otherAccountData.dependentFeeHead;
    				var discountCode = otherAccountData.discountCode;
    				var feeLedgerMaster = otherAccountData.feeLedgerMaster;
    				var feePlan = otherAccountData.feePlan;
    				var feeThirdParties = otherAccountData.feeThirdParties;
    				var scholarship = otherAccountData.scholarship;
    				var sponsor = otherAccountData.sponsor;
    				var discountMaster = otherAccountData.discountMaster;

    				if(feeHead){
    					var feeHeadField =  form.down("#feeHead");
    					feeHeadField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								feeHeadField.setValue(feeHead.id);
    							}
    						}
    					});
    				}
    				
    				if(feePlan){
    					var feePlanField =  form.down("#feePlan");
    					feePlanField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								feePlanField.setValue(feePlan.id);
    							}
    						}
    					});
    				}
    				
    				if(scholarship){
    					var scholarshipField =  form.down("#scholarship");
    					scholarshipField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								scholarshipField.setValue(scholarship.id);
    							}
    						}
    					});
    				}
    				
    				if(sponsor){
    					var sponsorshipField = form.down("#sponsorship");
    					sponsorshipField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								sponsorshipField.setValue(sponsor.id);
    							}
    						}
    					});
    				}
    				
    				if(bank){
    					var bankName =  form.down("#bankName");
    					var branchName =  form.down("#branchName");
    					var bankAccount =  form.down("#bankAccount");
    					
    					bankName.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								bankName.setValue(bank.id);
    								branchName.setValue(bank.branchName);
    								bankAccount.setValue(bank.bankAccount);
    							}
    						}
    					});
    				}
    				
    				if(dependentFeeHead){
    					var dependantFeeHeadField =  form.down("#dependantFeeHead");
    					dependantFeeHeadField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								dependantFeeHeadField.setValue(dependentFeeHead.id);
    							}
    						}
    					});
    				}
    				
    				if(discountCode){
    					var discountCodeField =  form.down("#discountCode");
    					discountCodeField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								discountCodeField.setValue(discountCode.id);
    							}
    						}
    					});
    				}
    				
    				if(feeThirdParties){
    					var thirdPartiesField =  form.down("#thirdParties");
    					thirdPartiesField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								thirdPartiesField.setValue(feeThirdParties.id);
    							}
    						}
    					});
    				}
    				
    				if(feeLedgerMaster){
    					var feeLedgerMasterField =  form.down("#ledgerName");
    					feeLedgerMasterField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								feeLedgerMasterField.setValue(feeLedgerMaster.id);
    							}
    						}
    					});
    				}

    				if(controlAccount){
    					var controlAccountField =  form.down("#controlAccount");
    					controlAccountField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								controlAccountField.setValue(controlAccount.id);
    							}
    						}
    					});
    				}
    				if(discountMaster){
    					var discountMasterField =  form.down("#discountMaster");
    					discountMasterField.store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								discountMasterField.setValue(discountMaster.id);
    							}
    						}
    					});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getFeeAndPaymentCommonTranslation('CONTROL_ACCOUNT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    /**
     * get view (read only) other Acount win
     */
    getViewOtherAccounts : function(){
 		var this$ = this;
 		this$.getEditOtherAccounts();
 		var form = this$.getOtherAccountsFormWin();
 		if (form) {
 			form.down("#formSubmitButtonId").setVisible(false);
 			form = form.getForm();
 			toggleReadOnlyFormItems(form, true);
 		}
 	},
     /**
      * get Create id value format
      */
     getIdValueJson: function(id, value) {
 		if (id) return {
 			id: id,
 			value: value
 		};
 	}
});
