/**
 *  @author Deepika Parmar
 *
 */
Ext.define('Academia.controller.feeandpayment.creditfeemapping.CreditFeeMappingController', {
	extend: 'Academia.controller.base.BaseController',
	models:['feeandpayment.creditfeemapping.CreditFeeMappingGridModel'],
	stores: ['feeandpayment.creditfeemapping.CreditFeeMappingAcademicTermStore','feeandpayment.creditfeemapping.CreditFeeMappingGridStore','common.SeatTypesByBatchId',
		'common.AcademyLocationNameSeparated','program.ProgramGroupStore','feeandpayment.creditfeemapping.ImportCreditFeeMappingGridStore'],
	views: ['feeandpayment.creditfeemapping.CreditFeeMappingStructure','feeandpayment.creditfeemapping.CreditFeeMappingSearchTab',
		'feeandpayment.creditfeemapping.CreditFeeMappingRepeatTabGrid','feeandpayment.creditfeemapping.CreditFeeMappingRegularTabGrid',
		'feeandpayment.creditfeemapping.CreditFeeMappingFilter','feeandpayment.creditfeemapping.CreditFeeMappingGrid','feeandpayment.creditfeemapping.SetDefaultAmountWin',
		'feeandpayment.creditfeemapping.SetDefaultAmountWinForRegGrid','feeandpayment.creditfeemapping.SetDefaultAmountWinRepeatGrid',
		'feeandpayment.creditfeemapping.ImportCreditFeeMappingTab','feeandpayment.creditfeemapping.ImportCreditFeeMappingUploadForm','feeandpayment.creditfeemapping.ImportCreditFeeMappingDownloadForm',
		'feeandpayment.creditfeemapping.ImportCreditFeeMappingGrid','UploadOptionRadioGroup'],
	config: {
		CREDIT_FEE_MAPPING_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREDIT_FEE_MAPPING_PRIVILEGE'),
		CREDIT_FEE_MAPPING_REG_TAB_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREDIT_FEE_MAPPING_REG_TAB_PRIVILEGE'),
		CREDIT_FEE_MAPPING_REPEAT_TAB_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREDIT_FEE_MAPPING_REPEAT_TAB_PRIVILEGE'),
	},           
     refs: [{
    	 ref:'creditfeemappingstructure',
    	 selector:'creditfeemappingstructure'
     },{
    	 ref:'creditfeemappingsearchtab',
    	 selector:'creditfeemappingsearchtab'
     },{
    	 ref:'creditfeemappingfilter',
    	 selector:'creditfeemappingfilter'
     },{
    	 ref:'creditfeemappinggrid',
    	 selector:'creditfeemappinggrid'
     },{
    	 ref:'setdefaultmmountwin',
    	 selector:'setdefaultmmountwin'
     },{
    	 ref : 'contentPanel',
    	 selector:'contentpanel'
     },{
    	 ref:'creditfeemappingrepeattabgrid',
    	 selector:'creditfeemappingrepeattabgrid'
     },{
    	 ref:'creditfeemappingregulartabgrid',
    	 selector:'creditfeemappingregulartabgrid'
     },{
    	 ref:'setdefaultamountwinforreggrid',
    	 selector:'setdefaultamountwinforreggrid'
     },{
    	 ref:'setdefaultamountwinrepeatgrid',
    	 selector:'setdefaultamountwinrepeatgrid'
     },
     {
    	 ref:'importcreditfeemappingtab',
    	 selector:'importcreditfeemappingtab'
     },{
    	 ref:'uploadoptionradiogroup',
    	 selector:'uploadoptionradiogroup'
     },{
    	 ref:'importcreditfeemappingdownloadform',
    	 selector:'importcreditfeemappingdownloadform'
     },{
    	 ref:'importcreditfeemappinguploadform',
    	 selector:'importcreditfeemappinguploadform'
     },{
    	 ref:'importcreditfeemappinggrid',
    	 selector:'importcreditfeemappinggrid'
     }],
     init: function() {
    	 this.suspendcreditFeeALEvent=false;
    	 this.control({
    		 'creditfeemappingfilter':{
    			 afterrender:function(form){
    				 var $this =this;
    				 var filter=this.getCreditfeemappingfilter();
    				 var filterForm = filter.getForm();
    				 var academyLocation = filterForm.findField('academyLocationId');
    				var academicTerm = filterForm.findField('academicTerm');
    				var programName = filterForm.findField('programName');
    				var batchName = filterForm.findField('batchName');
    				var periodName = filterForm.findField('periodName');
    				var seatTypeName = filterForm.findField('seatTypeName');
    				var academyLocationId = this.getCurrentAcademyLocation();
    				/*academicTerm.getStore().getProxy().extraParams = {
    					academyLocationIds: academyLocationId
    				}*/
    				//academicTerm.getStore().load();
    				 var alStore = academyLocation.getStore();
					 alStore.load({
    					 callback: function(records, operation, success) {
    						 if (success) {
    							 for(var i in records){
    								   if(records[i].data.id==academyLocationId){
    									   $this.suspendcreditFeeALEvent=true;
    									   academyLocation.setValue(academyLocationId);
    									   $this.suspendcreditFeeALEvent=false;
    								   }
    							   }
    						 }
    					 }
    				 });
					 Ext.defer(function() {
						 var body = filter ? filter.body : null;
						 if (body) {
							 var toggleEl = body.down('.filter-toggle-button');
							 if (toggleEl && toggleEl.dom) {
								 for (var i = 0; i < 2; i++) {
									 toggleEl.dom.click();
								 }
							 }
						 }
					 }, 1000, this);
    			 }
    		 },
    		 'creditfeemappingfilter customcombobox#academicTermId' :{
    			 select:function(obj,record){
    				 var filter=this.getCreditfeemappingfilter();
    				var filterForm = filter.getForm();
    				var academicTerm = filterForm.findField('academicTerm');
    				var programName = filterForm.findField('programName');
    				var batchName = filterForm.findField('batchName');
    				var periodName = filterForm.findField('periodName');
    				var seatTypeName = filterForm.findField('seatTypeName');
    				var programGroup = filterForm.findField('programGroup');
    				programName.reset();
    				batchName.reset();
    				periodName.reset();
    				seatTypeName.reset();
    				programGroup.reset();
    			 }
    		 },
    		 'creditfeemappingfilter customcombobox#programNameId' :{
    			 select:function(obj,record){
    				 var filter=this.getCreditfeemappingfilter();
    				 var filterForm = filter.getForm();
    				 var filterFormValue=filter.getForm().getValues();
    				var academicTerm = filterForm.findField('academicTerm');
    				var programName = filterForm.findField('programName');
    				var batchName = filterForm.findField('batchName');
    				var periodName = filterForm.findField('periodName');
    				var seatTypeName = filterForm.findField('seatTypeName');
    				
    				batchName.reset();
    				periodName.reset();
    				seatTypeName.reset();
    				batchName.enable();
    				periodName.disable();
    				seatTypeName.disable();
    				
    				batchName.getStore().getProxy().extraParams = {
    					id:record[0].data.id
    				
    				}
					batchName.getStore().load({
						callback:function(batchRecord){
							if(batchRecord.length ==1){
								batchName.setValue(batchRecord[0].data.id);
								periodName.reset();
								periodName.enable();
								periodName.getStore().getProxy().extraParams = {
									id:batchRecord[0].data.id,
									batchId  : batchName.getValue(),
									academicTermId:	academicTerm.getValue()
    		    				}
								periodName.getStore().load({
									callback:function(periodRecord){
										if(periodRecord.length ==1){
											periodName.setValue(periodRecord[0].data.id);
											seatTypeName.reset();
											seatTypeName.enable();
											seatTypeName.getStore().getProxy().extraParams = {
												batchId:filterFormValue.batchName
    		    		    				}
											seatTypeName.getStore().load({
    											callback:function(seatTypeRecord){
    												if(seatTypeRecord.length ==1){
    													seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
    												}
    											}
    										});
										}
									}
								});
							}
						}
					});
    				 
    			 }
    		 },
    		 'creditfeemappingfilter customcombobox#batchNameId' :{
    			 select:function(obj,record){
    				 var filter=this.getCreditfeemappingfilter();
    				 var filterForm = filter.getForm();
    				 var filterFormValue=filter.getForm().getValues();
     				
    				 var academicTerm = filterForm.findField('academicTerm');
    				var programName = filterForm.findField('programName');
    				var batchName = filterForm.findField('batchName');
    				var periodName = filterForm.findField('periodName');
    				var seatTypeName = filterForm.findField('seatTypeName');
    				
    				periodName.reset();
    				seatTypeName.reset();
    				periodName.enable();
    				periodName.getStore().getProxy().extraParams = {
    					academicTermId:	academicTerm.getValue()	,
    					    batchId  : batchName.getValue()
    				}
					periodName.getStore().load({
						callback:function(periodRecord){
							if(periodRecord.length ==1){
								periodName.setValue(periodRecord[0].data.id);
								seatTypeName.reset();
								seatTypeName.enable();
								seatTypeName.getStore().getProxy().extraParams = {
									batchId:filterFormValue.batchName
    		    				}
								seatTypeName.getStore().load({
									callback:function(seatTypeRecord){
										if(seatTypeRecord.length ==1){
											seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
										}
									}
								});
							}
						}
					});
    				 
    			 }
    		 },
    		 'creditfeemappingfilter multiselectcombofield#periodNameId' :{
    			 change:function(obj,record){
    				 var filter=this.getCreditfeemappingfilter();
    				 var filterForm = filter.getForm();
    				 var filterFormValue=filter.getForm().getValues();

    				 var academicTerm = filterForm.findField('academicTerm');
    				 var programName = filterForm.findField('programName');
    				 var batchName = filterForm.findField('batchName');
    				 var periodName = filterForm.findField('periodName');
    				 var seatTypeName = filterForm.findField('seatTypeName');

    				 seatTypeName.reset();
    				 seatTypeName.enable();
    				 seatTypeName.getStore().getProxy().extraParams = {
    					 batchId:filterFormValue.batchName
    				 }
    				 seatTypeName.getStore().load({
    					 callback:function(seatTypeRecord){
    						 if(seatTypeRecord.length ==1){
    							 seatTypeName.setValue(seatTypeRecord[0].data.seatType.id);
    						 }
    					 }
    				 });

    			 }
    		 },
    		 'creditfeemappingfilter button#searchBtn':{
    			 click :function(){
    				 var filter=this.getCreditfeemappingfilter();
    				 filter.down('#searchBtn').setDisabled(true);
    				 var grid = this.getCreditfeemappinggrid();
    				 var regGrid = this.getCreditfeemappingregulartabgrid();
    				 var repeatGrid = this.getCreditfeemappingrepeattabgrid();
    				 var filterFormValue = filter.getForm().getValues();
    				 var academyLocationId = filterFormValue.academyLocationId;
    				 var periodData = filterFormValue.periodName;
    				 var academicTermId=filterFormValue.academicTerm;
					 var programId=filterFormValue.programName;
					 var programGroupId=filterFormValue.programGroup;
					 var batchId=filterFormValue.batchName;
					 var seatTypeId= filterFormValue.seatTypeName;
    				 var academyLocationIds = [];
    				 var periodIds = [];
    				 var periodJoinIds;
    				 var alIds;
    				 if(Array.isArray(academyLocationId)){
    					    for(var i in academyLocationId){
    					        if(Ext.isObject(academyLocationId[i])){
    					            academyLocationIds.push(academyLocationId[i].data.id);
    					        }
    					    }
    					}else{
    					    academyLocationIds.push(academyLocationId);
    					}
    				 alIds = academyLocationIds.join();
    				 for(var i in periodData){
    					 if(Ext.isObject(periodData[i])){
    						 periodIds.push(periodData[i].data.id);
    					 }else{
    						 periodIds.push(periodData[i]);
    					 }
    				 }
    				 periodJoinIds = periodIds.join();
    				 if(WhetherPaymentGroupSetting){
    					 this.loadGridData(regGrid,academicTermId,programId,programGroupId,batchId,periodJoinIds,seatTypeId,alIds);
        				 this.loadGridData(repeatGrid,academicTermId,programId,programGroupId,batchId,periodJoinIds,seatTypeId,alIds);
    				 }else{
    					 this.loadGridData(grid,academicTermId,programId,programGroupId,batchId,periodJoinIds,seatTypeId,alIds);
    				 }
    			 }
    		 },
    		 'creditfeemappingfilter button#resetBtn':{
    			 click :function(){
    				 var filter=this.getCreditfeemappingfilter();
    				 var filterForm = filter.getForm();
    				 var filterFormValue = filter.getForm().reset();
    				 
     				 var academicTerm = filterForm.findField('academicTerm');
     				 var programName = filterForm.findField('programName');
     				 var batchName = filterForm.findField('batchName');
     				 var periodName = filterForm.findField('periodName');
     				 var seatTypeName = filterForm.findField('seatTypeName');
     				 var academyLocation = filterForm.findField('academyLocationId');
     				 var academyLocationId = this.getCurrentAcademyLocation();
    				 batchName.disable();
    				 periodName.disable();
    				 seatTypeName.disable();
    				 
    				 var alStore = academyLocation.getStore();
					 alStore.load({
    					 callback: function(records, operation, success) {
    						 if (success) {
    							 for(var i in records){
    								   if(records[i].data.id==academyLocationId){
    									   academyLocation.setValue(academyLocationId);
    								   }
    							   }
    						 }
    					 }
    				 });
    			 }
    		 },
    		 'creditfeemappinggrid':{
	    			 render:function(grid){
		    			  this.doAccessControlValidation(grid, this.getCREDIT_FEE_MAPPING_PERMISSION());
		    		  },
		    		  afterrender:function(grid){
		    			  var structure = grid.up('creditfeemappingsearchtab');
		    			  this.getGridHeaderFreeze(grid,structure,false); 
		    			  var me = this;
		    			  setTimeout(function(){
		    				  me.addDataGridConfigButton(grid, me.getCREDIT_FEE_MAPPING_PERMISSION());
		    			  },1500);
		    		  },
	    			 
	    			 
    			 selectionchange: function( view, record, index, eOpts ){
    				 var grid = this.getCreditfeemappinggrid();
    					var saveBtn= grid.down('#saveBtn');
    					var setDefaultAmountId= grid.down('#setDefaultAmountId');
    					var resetBtn= grid.down('#resetBtn');
        				
    				 if(record.length >0){
    					
    					setDefaultAmountId.enable();
    					resetBtn.enable();
    					saveBtn.enable();
    				 }else{
    					 setDefaultAmountId.disable();
      					resetBtn.disable();
      					saveBtn.disable();
    				 }
    			 },
    			 render:function(grid){
	    			  this.disableCreditFeeMappingSetDefaultAmountResetBtnByPriivilege(grid, this.getCREDIT_FEE_MAPPING_PERMISSION());
	    		  },
    		 },
    		 'creditfeemappingregulartabgrid':{
    			 afterrender:function(grid){
    				 var structure = grid.up('creditfeemappingsearchtab');
    				 this.getGridHeaderFreeze(grid,structure,false); 
    				 var me = this;
    				 setTimeout(function(){
    					 me.addDataGridConfigButton(grid, me.getCREDIT_FEE_MAPPING_REG_TAB_PERMISSION());
    				 },1500);
    			 },
    			 selectionchange: function( view, record, index, eOpts ){
    				 var grid = this.getCreditfeemappingregulartabgrid();
    				 var saveBtn= grid.down('#saveBtn');
    				 var setDefaultAmountId= grid.down('#setDefaultAmountId');
    				 var resetBtn= grid.down('#resetBtn');

    				 if(record.length >0){
    					 setDefaultAmountId.enable();
    					 resetBtn.enable();
    					 saveBtn.enable();
    				 }else{
    					 setDefaultAmountId.disable();
    					 resetBtn.disable();
    					 saveBtn.disable();
    				 }
    			 },
    			 render:function(grid){
    				 this.disableCreditFeeMappingSetDefaultAmountResetBtnByPriivilege(grid, this.getCREDIT_FEE_MAPPING_REG_TAB_PERMISSION());
    			 },
    		 },
    		 'creditfeemappingrepeattabgrid':{
    			 afterrender:function(grid){
    				 var structure = grid.up('creditfeemappingsearchtab');
    				 this.getGridHeaderFreeze(grid,structure,false); 
    				 var me = this;
    				 setTimeout(function(){
    					 me.addDataGridConfigButton(grid, me.getCREDIT_FEE_MAPPING_REPEAT_TAB_PERMISSION());
    				 },1500);
    			 },
    			 selectionchange: function( view, record, index, eOpts ){
    				 var grid = this.getCreditfeemappingrepeattabgrid();
    				 var saveBtn= grid.down('#saveBtn');
    				 var setDefaultAmountId= grid.down('#setDefaultAmountId');
    				 var resetBtn= grid.down('#resetBtn');

    				 if(record.length >0){
    					 setDefaultAmountId.enable();
    					 resetBtn.enable();
    					 saveBtn.enable();
    				 }else{
    					 setDefaultAmountId.disable();
    					 resetBtn.disable();
    					 saveBtn.disable();
    				 }
    			 },
    			 render:function(grid){
    				 this.disableCreditFeeMappingSetDefaultAmountResetBtnByPriivilege(grid, this.getCREDIT_FEE_MAPPING_REPEAT_TAB_PERMISSION());
    			 },
    		 },
    		 'creditfeemappinggrid button#saveBtn': {
    			 click:function(btn){
    				 var grid = this.getCreditfeemappinggrid();
    				 this.onCreditFeeMappingSaveClick(grid);
    			 }
    		 },
    		 'creditfeemappingregulartabgrid button#saveBtn': {
    			 click:function(btn){
    				 var grid = this.getCreditfeemappingregulartabgrid();
    				 this.onCreditFeeMappingSaveClick(grid);
    			 }
    		 },
    		 'creditfeemappingrepeattabgrid button#saveBtn': {
    			 click:function(btn){
    				 var grid = this.getCreditfeemappingrepeattabgrid();
    				 this.onCreditFeeMappingSaveClick(grid);
    			 }
    		 },
    		 'creditfeemappinggrid button#resetBtn': {
    			 click:function(obj){
    				 var grid = obj.up().up();
    				 this.onCreditFeeMappingResetClick(grid);
    			 }
    		 },
    		 'creditfeemappingregulartabgrid button#resetBtn': {
    			 click:function(obj){
    				 var grid = obj.up().up();
    				 this.onCreditFeeMappingResetClick(grid);
    			 }
    		 },
    		 'creditfeemappingrepeattabgrid button#resetBtn': {
    			 click:function(obj){
    				 var grid = obj.up().up();
    				 this.onCreditFeeMappingResetClick(grid);
    			 }
    		 },
    		 'creditfeemappinggrid button#setDefaultAmountId': {
    			 click:function(){
    				 
    				var setDefaultAmountWin = Ext.widget('setdefaultmmountwin');
    				if(!isNullOrEmpty(setDefaultAmountWin)){
    					setDefaultAmountWin.show();
    				}
    				
    			 }
    		 },
    		 'creditfeemappingregulartabgrid button#setDefaultAmountId': {
    			 click:function(){
    				 
    				var setDefaultAmountWin = Ext.widget('setdefaultamountwinforreggrid');
    				if(!isNullOrEmpty(setDefaultAmountWin)){
    					setDefaultAmountWin.show();
    				}
    				
    			 }
    		 },
    		 'creditfeemappingrepeattabgrid button#setDefaultAmountId': {
    			 click:function(){
    				 
    				var setDefaultAmountWin = Ext.widget('setdefaultamountwinrepeatgrid');
    				if(!isNullOrEmpty(setDefaultAmountWin)){
    					setDefaultAmountWin.show();
    				}
    				
    			 }
    		 },
    		 'setdefaultamountwinforreggrid button#SubmitBtn':{
    			 click: function(){
    				 var win =  this.getSetdefaultamountwinforreggrid();
    				 var form =win.down('#setdefaultamountRegForm');
    				 var formValue= form.getForm().getValues();
    				 var grid = this.getCreditfeemappingregulartabgrid();
    				 this.saveDefaultWinData(grid,formValue,win);
    			 }
    		 },
    		 'setdefaultamountwinrepeatgrid button#SubmitBtn':{
    			 click: function(){
    				 var win =  this.getSetdefaultamountwinrepeatgrid();
    				 var form =win.down('#setdefaultamountRepeatForm');
    				 var formValue= form.getForm().getValues();
    				 var grid = this.getCreditfeemappingrepeattabgrid();
    				 this.saveDefaultWinData(grid,formValue,win);
    			 }
    		 },
    		 'setdefaultmmountwin button#SubmitBtn':{
    			 click: function(){
    				var win =  this.getSetdefaultmmountwin();
    				 var form =win.down('#setdefaultmmountform');
    				 var formValue= form.getForm().getValues();
    				 var grid = this.getCreditfeemappinggrid();
    		    	 if(grid.getSelectionModel().getCount() >0){
    		    		 var storeItems = grid.getSelectionModel().getSelection();
    		    		 var flag= true;
    		    	    	
    		    		 var jsonArray =[];
    		        	 if(storeItems.length > 0){
    		        		 storeItems.forEach(function(obj){
    		        			 var obj1 = new Object(); 
    		        			
    		        			 if(!isNullOrEmpty(obj.data.programName)){
    		                			 obj1.program= {
    		                					 id:obj.data.programId
    		                			 }
    		                 		        
    		                 		   
    		                		 }else{
    		                			 flag =false;
    		                		 }
    		                		 
    		                		 if(!isNullOrEmpty(obj.data.batchId)){
    		                			 obj1. batch= {
    		               		          id: obj.data.batchId
    		               		     
    		                		 }
    		                		 }else{
    		                			 flag =false;
    		                		 }
    		                		 if(!isNullOrEmpty(obj.data.periodId)){
    		                			 obj1.period= {
    		                       		          id: obj.data.periodId
    		                		   }
    		                		 }else if(!isNullOrEmpty(obj.data.programBatchPeriodConfigId)){
    		                			 obj1.period= {
   		                       		          id: obj.data.programBatchPeriodConfigId
   		                		   }
	   		                		 }else{
	    		                			 flag =false;
	    		                		 } 
	    		                		      
    		                		 if(!isNullOrEmpty(obj.data.seatTypeId)){
    		                	            obj1.seatType= {
    		                	            		id:obj.data.seatTypeId
    		                	            }
    		                	        }else{
    		                	            flag =false;
    		                	            }    
    		                		 if(!isNullOrEmpty(formValue.defaultAmount)){
    		                			 obj1.amountPerCredit = parseInt(formValue.defaultAmount);
    		                     		
    		                		 }
    		                		 else{
    		                			 flag =false;
    		                		 } 
    		                	
    		                		 jsonArray.push(obj1);
    		        		 });
    		        		 
    		        		 if(flag){
    		        				 submitUrl = SERVERURL.CREDIT_FEE_MAPPING_UPDATE_ALL;
    		        			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		                	 var jsonObj =Ext.encode(jsonArray);
    		                	 Ext.Ajax.request({
    		                		 type : 'rest',
    		             			url : submitUrl,
    		             			jsonData : jsonObj,
    		             			method : 'POST',
    		             			success : function(form, action) {
    		             				Ext.getBody().unmask();
    		             				win.close();
    		             				showSuccessMessage(getCommonTranslation('SET_DEFAULT_AMOUNT'),getCommonTranslation('SUCCESS'));
    		             				grid.getStore().load();
    		             			},
    		             			failure:function(form,action){
    		             				
    		             			}
    		                	 });
    		        		 }
    		        		
    		    	 }
    		       } else{
    		    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    		    	 }
    		     }
    			 },
    			 'setdefaultmmountwin button#CancelBtn':{
    				 click:function(){
    					var win = this.getSetdefaultmmountwin();
    					if(!isNullOrEmpty(win)){
    						win.close();
    					}
    				 }
    			 },
    			 'setdefaultamountwinforreggrid button#CancelBtn':{
    				 click:function(){
    					var win = this.getSetdefaultamountwinforreggrid();
    					if(!isNullOrEmpty(win)){
    						win.close();
    					}
    				 }
    			 },
    			 'setdefaultamountwinrepeatgrid button#CancelBtn':{
    				 click:function(){
    					var win = this.getSetdefaultamountwinrepeatgrid();
    					if(!isNullOrEmpty(win)){
    						win.close();
    					}
    				 }
    			 },
    			 'creditfeemappingfilter  multiselectcombofield[itemId=academyLocationItemId]':{
    				 change : function(obj, record) {
    					 var $this=this;
    					 var form = this.getCreditfeemappingfilter();
    					 var formValues = form.getValues();
    					 var academicTerm = form.down("#academicTermId");
    					 var ProgramGroup = form.down("#ProgramGroupItemId");
    					 var programName = form.down('#programNameId');
    					 var batchName = form.down('#batchNameId');
    					 var periodName = form.down('#periodNameId');
    					 var seatTypeName = form.down('#seatTypeNameId');

    					 programName.reset();
    					 batchName.reset();
    					 periodName.reset();
    					 seatTypeName.reset();
    					 academicTerm.setDisabled(true);
    					 academicTerm.reset();
    					 ProgramGroup.reset();
    					 var alId = obj.getValue();
    					 var alIds = [];
    					 for(var i in alId){
    						 if(Ext.isObject(alId[i])){
    							 alIds.push(alId[i].data.id);
    						 }else{
    							 alIds.push(alId[i]);
    						 }
    					 }
    					 var alIds = alIds.join();

    					 if(alId.length>0){
    						 academicTerm.setDisabled(false);
    						 //setTimeout(function(){
    							 var store = academicTerm.getStore();
    							 store.getProxy().extraParams = {
    								 academyLocationIds:alIds
    							 };
    							 if(!$this.suspendcreditFeeALEvent)
    							   store.load();
    						 //},1500);
    					 }
    					 form.getForm().checkValidity();
    				 }
    			 },	 
    			 'creditfeemappingfilter  customcombobox[itemId=ProgramGroupItemId]':{
    				 select : function(obj, record) {
    					 var form = this.getCreditfeemappingfilter();
    					 var formValues = form.getValues();
    					 var program = form.down("#programNameId");
    					 var batchName = form.down('#batchNameId');
    					 var periodName = form.down('#periodNameId');
    					 var seatTypeName = form.down('#seatTypeNameId');
                          var academicTermId = form.down('#academicTermId');
    					 batchName.reset();
    					// academicTermId.reset();
    					 periodName.reset();
    					 seatTypeName.reset();
    					 program.setDisabled(true);
    					 program.reset();
    					 var programGroup = obj.getValue();
    					 var alId = formValues.academyLocationId;
    					 var alIds = [];
    					 for(var i in alId){
    						 if(Ext.isObject(alId[i])){
    							 alIds.push(alId[i].data.id);
    						 }else{
    							 alIds.push(alId[i]);
    						 }
    					 }
    					 var alIds = alIds.join();
    					 program.setDisabled(false);
    					 var store = program.getStore();
    						 store.getProxy().extraParams = {
    							 programGroupId:programGroup,
    							 academyLocationIds:alIds
    						 };
    						 store.load();
    					 
    					 form.getForm().checkValidity();
    				 }
    			 },
    			 'creditfeemappingsearchtab':{
    				 afterrender:function(tab){
    					 var $this = this;
    					 var tabPanel = tab.down('#regRepeatItemId');
    					 var creditMappingGrid = $this.getCreditfeemappinggrid();
    					 var filter=this.getCreditfeemappingfilter();
    					 var formFields = filter.getForm().getFields().items;
    					 tab.body.on('scroll', function(e, target) {
     			         	Ext.each(formFields, function(field) {
     			         		if((field.xtype=='multiselectcombofield'|| field.xtype=='customcombobox' || field.xtype=='livesearchcombo') && field.getPicker()){
     			             		if(field.getPicker().isVisible()){
     			             			field.getPicker().hide();
     			             		}
     			             	}
     			         	});
     			         });
    					 Ext.Ajax.request({
		    				  method : 'GET',
		    				  type : 'rest',
		    				  url: SERVERURL.PATH_WHETHER_PAYMENT_GROUP_SETTINGS_DONE,
		    				  success: function(response) {
		    					  var data=response.responseText;	
		    					  if(data=='true'){
		    						  tabPanel.setVisible(true);
		    						  WhetherPaymentGroupSetting=true;
		    					  }else{
		    						  creditMappingGrid.setVisible(true);
		    						  WhetherPaymentGroupSetting=false;
		    					  }
		    				  }
		    			  });
    				 }
    			 },
    			 /*credit fee mapping loader related*/
    			 'importcreditfeemappingtab radiogroup[itemId=importDownloadgroupIds]':{
    	          	   change  : function(obj,newValue,oldValue){
    	          		   var form = obj.up('importcreditfeemappingtab');	 
    	          		   var value = obj.getValue();
    	          		   var downloadform = form.down('importcreditfeemappingdownloadform');
    	          		   var uploadform = form.down('importcreditfeemappinguploadform');
    	          		   var importGrid = form.down('importcreditfeemappinggrid');

    	          		   downloadform.setVisible(false);
    	          		   uploadform.setVisible(false);
    	          		   importGrid.setVisible(false);

    	          		   if(value.downloadUploadTemplate=='forDownloadTemplate'){
    	          			 downloadform.setVisible(true);
    	          		   }else if(value.downloadUploadTemplate=='forUploadTemplate'){
    	          			   var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
    	          			   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    	          				   isUploadAll: false
    	          			   });
    	          			  uploadform.setVisible(true);
    	          			  importGrid.setVisible(true);
    	          		   }
    	          	   }
    	             },
    	             'importcreditfeemappingdownloadform button[itemId=creditFeeMappingDownload]':{
    	            	 click:function(obj){
    	            		 var $this = this;
    	            		 // var form =$this.getImportcreditfeemappingdownloadform().getForm();
    	            		 var form = obj.up('form');
    	            		 var form1 =form.getForm();
    	            		 var values = form1.getValues();

    	            		 var academyLocationIdArray=new Array();

    	            		 Ext.each(values.academyLocationId, function(academyLocationId){
    	            			 if(!Ext.isDefined(academyLocationId .data)){
    	            				 academyLocationIdArray.push(academyLocationId);
    	            			 }else{
    	            				 academyLocationIdArray.push(academyLocationId.data.id);   
    	            			 }

    	            		 });
    	            		 var academyLocationIdValue = academyLocationIdArray.toString();

    	            		 var value = form.getValues();
    	            		 var csvForm = Ext.create('Ext.form.Panel'); 
    	            		 csvForm.getForm().submit({
    	            			 target: '_blank',
    	            			 method:'POST',
    	            			 params :{
    	            				 access_token : Ext.Ajax.defaultHeaders.access_token,
    	            				 academyLocationIds: academyLocationIdValue,
    	            				 academicTermId:value.academicTerm,
    	            				 programGroupId:value.programGroup,
    	            				 templateFor:value.templateFor
    	            			 },
    	            			 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    	            			 url: SERVERURL.PATH_DOWNLOAD_FILE_FOR_CREDIT_FEE_MAPPING,
    	            			 standardSubmit :true
    	            		 });
    	            	 }
					 },
    	             'importcreditfeemappingdownloadform button#resetBtn':{
    					   click:function(obj){
    						   var $this = this;
    						   var form = $this.getImportcreditfeemappingdownloadform();
    						   var downloadBtn =form.down('#creditFeeMappingDownload');
    						   var getForm = form.getForm();
    						   getForm.reset();
    						   if(form.isValid()){
    								downloadBtn.enable();
    							}else{
    								downloadBtn.disable();
    							}
    					   }
    		 		   },
    		 		 'importcreditfeemappinguploadform':{
						 render :function(obj){
							 var $this = this;
							 var form =$this.getImportcreditfeemappinguploadform().getForm();
							 var combo = form.findField('importUtilityMasterId');
							 combo.getStore().load({
								 callback: function(records, operation, success) {
									 for(var i in records){
										 if(records[i].data.value=='Bulk Credit Fee Mapping'){ 
											 combo.setValue(records[i].data.id);
											 combo.setReadOnly(true);
										 }
									 }
								 }	   
							 });
						 }  
					 },
					 'importcreditfeemappinguploadform button[itemId=SubmitBtn]':{
			   				click: function(obj){
			   					var temForm = obj.up('importcreditfeemappinguploadform');
			   			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getRawValue();
			   			    	var $this=this;
			   			    	var grdStore;
			   			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			       	            $this.getHashOfFile(temForm);
			   		            setTimeout(function() {
			   				    	temForm.getForm().submit({
			   				    		method : 'POST',
			   				    		url : submitUrl,
			   				    		success : function(form, action){
			   					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			   				    		},
			   				    		failure: function(form, action) {
			      		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
			   				    	    }
			   				    	});
			   		        	},1000);
			   			    	Ext.defer(function() {
			   			    	 var grid = $this.getImportcreditfeemappinggrid();
								 var form = $this.getUploadoptionradiogroup();
								 var isUploadAll = form.items.items[0].getValue().isUploadAll;
								 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Credit Fee Mapping');  
			   			    	}, 2000, this);
			   					
			   				}
			   			},
			   			'importcreditfeemappinguploadform button[itemId=resetBtn]':{
							click: function(obj){
								var $this=this;
								var temForm = $this.getImportcreditfeemappinguploadform();
								temForm.down('#uploadFileField').reset();
								temForm.down('#moduleName').reset();
								var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
								uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
									isUploadAll: false
								});
								temForm.getForm().isValid();
								var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
								var grid = $this.getImportcreditfeemappinggrid();
								var form = $this.getUploadoptionradiogroup();
								var isUploadAll = form.items.items[0].getValue().isUploadAll;
			                 	tempFormValue.getStore().load({
									callback:function(record){
										for(var i in record){
											if(record[i].data.value == "Bulk Credit Fee Mapping"){
												tempFormValue.setValue(record[i].data.id);
												tempFormValue.setReadOnly(true);
											}
										}
									}
								});
							}
						},
						'importcreditfeemappinguploadform uploadoptionradiogroup radiogroup[itemId=uploadgroupItemId]':{
			  				change: function( radioGroup, newValue, oldValue, eOpts){
			                    var grid =this.getImportcreditfeemappinggrid();
			                    var form =this.getUploadoptionradiogroup();
			                    var isUploadAll = newValue.isUploadAll;
			                    this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'Bulk Credit Fee Mapping');
			                }
			  			},
			  			'importcreditfeemappinggrid':{
			  				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts )  {
								 if (e.target.tagName == 'A') {
									 var fileType=null;
									 if(cellIndex==1){
										 fileType='successFile';
									 }else if(cellIndex==6){
										 fileType='errorFile';
									 }else if(cellIndex==7){
										 fileType='logFile';
									 }
									 var documentId = record.get("id");
									 if (!isNullOrEmpty(documentId)) {
										 this.getDownloadFile(documentId,fileType);
									 }
								 }
							 }
						},
						'importcreditfeemappinggrid button[itemId=btnRefresh]':{
							 click: function(obj) {
								 var grid = this.getImportcreditfeemappinggrid();
									var $this = this;
									grid.getStore().getProxy().extraParams = {
										moduleName: "Bulk Credit Fee Mapping"
									};
									this.resetPageSetting(grid.getStore());
									grid.getStore().load();
								
							 }
						 },
						'importcreditfeemappinggrid button[itemId=btnForce]':{
							 click: function(obj) {
								 var grid = this.getImportcreditfeemappinggrid();
								 if (grid.getSelectionModel().getCount() > 0) {
									 if(grid.getSelectionModel().getCount() > 1){
										 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
									 }else{
										 var this$ = this;
										 var id = grid.getSelectionModel().selectionStart.data.id;
										 //console.log(id);
										 var urlAppend="?jobName="+id;
										 var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
										 Ext.Ajax.request({
											 url: submitURL,
											 method: 'GET',
											 success: function(response) {
												 if(response.responseText==="JOB_STATUS_NOT_PENDING"){
													 showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
												 }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
													 //console.log("Manual trigger hit");
													 showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
												 }else if(response.responseText==="SUCCESS"){
													 //console.log("Manual trigger hit");
													 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
													 grid.getStore().reload();
												 }
											 }
										 });
									 }
								 } else {
									 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
								 }  
							 }
						 }
    	 });
     },
     onCreditFeeMappingResetClick :function(grid){
    	 if(grid.getSelectionModel().getCount() >0){
    		 var storeItems = grid.getSelectionModel().getSelection();
    		 storeItems.forEach(function(obj){
    			 obj.set('amountPerCredit',null);
    		 });
    	 }
 			
     },
     onCreditFeeMappingSaveClick :function(grid){
    	// var grid = this.getCreditfeemappinggrid();
    	 if(grid.getSelectionModel().getCount() >0){
    		 var storeItems = grid.getSelectionModel().getSelection();
    		 var flag= true;
    	     var isMapped = true;
    		 var jsonArray =[];
        	 if(storeItems.length > 0){
        		 storeItems.forEach(function(obj){
        			 var obj1 = new Object(); 
        			
        			 if(!isNullOrEmpty(obj.data.programName)){
                			 obj1.program= {
                					 id:obj.data.programId
                			 }
                 		        
                 		   
                		 }else{
                			 flag =false;
                		 }
                		 
                		 if(!isNullOrEmpty(obj.data.batchId)){
                			 obj1. batch= {
               		          id: obj.data.batchId
               		     
                		 }
                		 }else{
                			 flag =false;
                		 }
                		 if(!isNullOrEmpty(obj.data.programBatchPeriodConfigId)){
                			 obj1.period= {
                       		          id: obj.data.programBatchPeriodConfigId
                		   }
                		 }else{
                			 flag =false;
                		 } 
                		      
                		 if(!isNullOrEmpty(obj.data.seatTypeId)){
                	            obj1.seatType= {
                	            		id:obj.data.seatTypeId
                	            }
                	        }else{
                	            flag =false;
                	            }    
                		 if(!isNullOrEmpty(obj.data.amountPerCredit)){
                			 obj1.amountPerCredit = obj.data.amountPerCredit;
                     		
                		 }
                		 else{
                			 flag =false;
                		 } 
                		 obj1.allowAdditionalCourseBilling = obj.data.allowAdditionalCourseBilling;
                		 if(grid.xtype !='creditfeemappinggrid'){
                			 if(!isNullOrEmpty(obj.data.paymentGroupId)){
                    			 obj1.paymentGroup = obj.data.paymentGroupId;
                         		
                    		 }else{
                    			 isMapped =false;
                    		 }
                    		 if(!isNullOrEmpty(obj.data.paymentTermId)){
                    			 obj1.paymentTerm = obj.data.paymentTermId;
                         		
                    		 }else{
                    			 isMapped =false;
                    		 }
                		 }
                		
                		 if(grid.xtype=='creditfeemappingregulartabgrid'){
                			 obj1.courseType='REGULAR';
                		 }else if(grid.xtype=='creditfeemappingrepeattabgrid'){
                			 obj1.courseType='REPEAT';
                		 }
                	
                		 jsonArray.push(obj1);
        		 });
        		 
        		 if(flag && isMapped){
        				 submitUrl = SERVERURL.CREDIT_FEE_MAPPING_UPDATE_ALL;
        			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                	 var jsonObj =Ext.encode(jsonArray);
                	 Ext.Ajax.request({
                		 type : 'rest',
             			url : submitUrl,
             			jsonData : jsonObj,
             			method : 'POST',
             			success : function(form, action) {
             				Ext.getBody().unmask();
             				showSuccessMessage( getCommonTranslation('AMOUNT_PER_CREDIT'),getCommonTranslation('SUCCESS'));
             				grid.getStore().load();
             			},
             			failure:function(form,action){
             				
             			}
                	 });
        		 }
        		 else if(flag==false){
        			 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_ENTER_AMOUNT'));
        		 }else if(isMapped==false){
        			 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_MAP_PAYMENT_GROUP'));
        		 }
    	 }
       }
    	 else{
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	 }
     },
 disableCreditFeeMappingSetDefaultAmountResetBtnByPriivilege :function(grid,permissionsMap){
  	   var setDefaultamountBtn = grid.down('#setDefaultAmountId')
			 var resetBtn=	grid.down('#resetBtn')
			 var saveBtn=	grid.down('#saveBtn')
			 resetBtn.setVisible(false);
  	 setDefaultamountBtn.setVisible(false);
  	  saveBtn.setVisible(false);
			 var associatedAcadLocationIds = new Array();
		  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getCREDIT_FEE_MAPPING_PERMISSION());
		  		Ext.each(permissionList, function(privilege) {
		  			if(privilege === "SET_DEFAULT_AMOUNT"){
		  				if(!isNullOrEmpty(setDefaultamountBtn)){
		  					setDefaultamountBtn.setVisible(true);
		        		}
		  			}if(privilege === "RESET"){
		  				if(!isNullOrEmpty(resetBtn)){
		  					resetBtn.setVisible(true);
		        		}
		  			}
		  			if(privilege === "SAVE"){
		  				if(!isNullOrEmpty(saveBtn)){
		  					saveBtn.setVisible(true);
		        		}
		  			}
		  		});
     },
     loadGridData:function(grid,academicTermId,programId,programGroupId,batchId,periodId,seatTypeId,academyLocationIds){
    	 var filter=this.getCreditfeemappingfilter();
    	 grid.getStore().getProxy().extraParams ={
    		 academicTermId: academicTermId,
    		 programId: programId,
    		 programGroupId: programGroupId,
    		 batchId: batchId,
    		 periodId:periodId,
    		 seatTypeId:seatTypeId,
    		 academyLocationIds:academyLocationIds,

		 }
		 this.resetPageSetting(grid.getStore());
		 grid.getStore().load({
			 callback: function(records, operation, success) {
				 filter.down('#searchBtn').setDisabled(false);
			 }
		 });
		 grid.getSelectionModel().deselectAll();
     },
     saveDefaultWinData:function(grid,formValue,win){
    	 if(grid.getSelectionModel().getCount() >0){
    		 var storeItems = grid.getSelectionModel().getSelection();
    		 var flag= true;
    	    	
    		 var jsonArray =[];
        	 if(storeItems.length > 0){
        		 storeItems.forEach(function(obj){
        			 var obj1 = new Object(); 
        			
        			 if(!isNullOrEmpty(obj.data.programName)){
                			 obj1.program= {
                					 id:obj.data.programId
                			 }
                 		        
                 		   
                		 }else{
                			 flag =false;
                		 }
                		 
                		 if(!isNullOrEmpty(obj.data.batchId)){
                			 obj1. batch= {
               		          id: obj.data.batchId
               		     
                		 }
                		 }else{
                			 flag =false;
                		 }
                		 if(!isNullOrEmpty(obj.data.programBatchPeriodConfigId)){
                			 obj1.period= {
                       		          id: obj.data.programBatchPeriodConfigId
                		   }
                		 }else{
                			 flag =false;
                		 } 
                		      
                		 if(!isNullOrEmpty(obj.data.seatTypeId)){
                	            obj1.seatType= {
                	            		id:obj.data.seatTypeId
                	            }
                	        }else{
                	            flag =false;
                	            }    
                		 if(!isNullOrEmpty(formValue.defaultAmount)){
                			 obj1.amountPerCredit = parseInt(formValue.defaultAmount);
                     		
                		 }
                		 else{
                			 flag =false;
                		 } 
                		 
                		 if(!isNullOrEmpty(obj.data.paymentGroupId)){
                			 obj1.paymentGroup = obj.data.paymentGroupId;
                     		
                		 }else{
                			 flag =false;
                		 }
                		 if(!isNullOrEmpty(obj.data.paymentTermId)){
                			 obj1.paymentTerm = obj.data.paymentTermId;
                     		
                		 }else{
                			 flag =false;
                		 }
                		 if(grid.xtype=='creditfeemappingregulartabgrid'){
                			 obj1.courseType='REGULAR';
                		 }else if(grid.xtype=='creditfeemappingrepeattabgrid'){
                			 obj1.courseType='REPEAT';
                		 }
                	
                	
                		 jsonArray.push(obj1);
        		 });
        		 
        		 if(flag){
        				 submitUrl = SERVERURL.CREDIT_FEE_MAPPING_UPDATE_ALL;
        			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                	 var jsonObj =Ext.encode(jsonArray);
                	 Ext.Ajax.request({
                		 type : 'rest',
             			url : submitUrl,
             			jsonData : jsonObj,
             			method : 'POST',
             			success : function(form, action) {
             				Ext.getBody().unmask();
             				win.close();
             				showSuccessMessage(getCommonTranslation('SET_DEFAULT_AMOUNT'),getCommonTranslation('SUCCESS'));
             				grid.getStore().load();
             			},
             			failure:function(form,action){
             				
             			}
                	 });
        		 }else{
        			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_MAP_PAYMENT_GROUP'));
        			 win.close();
        		 }
        		
    	 }
       } else{
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	 }
     },
 	getDownloadFile : function(documentId,fileType){

		if(!isNullOrEmpty(documentId)){
			var csvForm = Ext.create('Ext.form.Panel'); 
			csvForm.getForm().submit({
				target: '_blank',
				method:'POST',
				params :{
					access_token : Ext.Ajax.defaultHeaders.access_token
				},
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
				standardSubmit :true
			});
		}
	},
    
});
