/**
 *  @author Amit G
 * 
 */
Ext.define('Academia.controller.feeandpayment.finance.ManageFinanceHoldController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['Academia.model.feeandpayment.finance.ManageFinanceHoldCreateModel','Academia.model.feeandpayment.finance.FinanceHoldGridDataModel'],
    stores: ['feeandpayment.finance.FinanceHoldTypeStore','feeandpayment.finance.FinanceHoldIdNameStore',
             'feeandpayment.finance.FinanceHoldStatusStore','feeandpayment.finance.FinanceAcademyLocationFeeMappingList',
             'feeandpayment.finance.FinanceAcademyLocationByName','feeandpayment.finance.FinanceALProgramList','feeandpayment.finance.FinanceALProgramSearchCombo',
             'feeandpayment.finance.FinanceALProgramBatchList','feeandpayment.finance.FinanceALProgramBatchSearchCombo',
             'feeandpayment.finance.FinanceALProgramBatchSeatTypeList','feeandpayment.finance.FinanceHoldGridDataListing',
             'feeandpayment.finance.FinanceHoldPBSFindByGridListing','program.ProgramByGroupIdStore',
             'common.SeatTypesByBatchId','feeandpayment.finance.FinanceHoldTypeStore',
             'feeandpayment.finance.FinanceHoldTypeCountList','feeandpayment.finance.FinanceBlockedStudentGridDataStore',
             'feeandpayment.finance.FinanceBlokedStudentFilterAcademyLocationStore','feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore',
             'feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore','facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
             'feeandpayment.finance.FinanceBlokedStudentFilterStore','feeandpayment.finance.FinanceHoldApplicableOnStore',
             'feeandpayment.finance.FindAllALAccordingToBaseCurrencyForFinancialHold'],
    views: ['feeandpayment.finance.ManageFinanceHoldStructure','feeandpayment.finance.ManageFinanceHoldGrid',
            'feeandpayment.finance.ManageFinanceHoldSearchForm','feeandpayment.finance.ManageFinanceHoldAddForm',
            'feeandpayment.finance.ManageFinanceHoldMappedProgramStructure','feeandpayment.finance.ManageFinanceMappedProgramGrid',
            'feeandpayment.finance.FinanceProgramMappingProgressTracker','feeandpayment.finance.FinanceWithProgramBatchSeatStructure',
            'feeandpayment.finance.ManageFinanceProgramFeeMappingTab','feeandpayment.finance.FinanceProgramMappingAcademyLocationGrid',
             'feeandpayment.finance.FinanceAlProgramGrid','feeandpayment.finance.FinanceAlProgramBatchGrid',
             'feeandpayment.finance.FinanceAlProgramBatchSeatTypeGrid','feeandpayment.FeeDoMappingAlertWin',
             'feeandpayment.finance.FinanceFeeDoMappingAlertWin','feeandpayment.finance.FinanceHoldListOfBlockedStudentStructure',
             'feeandpayment.finance.FinanceHoldBlockedStudentSearchForm','feeandpayment.finance.FinanceHoldBlockedStudentGrid',
             'feeandpayment.finance.FinanceHoldTypeWindow','feeandpayment.finance.FinanceMappedProgramWindow',
             'feeandpayment.finance.FinanceBlockedStudentRemarkWindow'],
    config: {
    	MANAGE_FINANCE_HOLD_PETMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_FINANCE_HOLD_PRIVILEGES'),
    	MANAGE_FINANCE_HOLD_APPLY_TO_PETMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_FINANCE_HOLD_APPLY_TO_PRIVILEGES'),
    	MANAGE_FINANCE_HOLD_BLOCKED_STUDENTS_PETMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_FINANCE_HOLD_BLOCKED_STUDENTS_PRIVILEGES'),
    },
    refs: [{
    	ref:'managefinanceholdsearchform',
    	selector:'managefinanceholdsearchform'
    },{
    	ref:'managefinanceholdgrid',
    	selector:'managefinanceholdgrid'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref:'managefinanceholdaddform',
    	selector:'managefinanceholdaddform'
    },{
    	ref:'managefinancemappedprogramgrid',
    	selector:'managefinancemappedprogramgrid'
    },{
    	ref:'financewithprogrambatchseatstructure',
    	selector:'financewithprogrambatchseatstructure'
    },{
    	ref:'managefinanceprogramfeemappingstructure',
    	selector:'managefinanceprogramfeemappingtab'
    },{
    	ref:'financeprogrammappingprogresstracker',
    	selector:'financeprogrammappingprogresstracker'
    },{
    	ref:'financeprogrammappingacademylocationgrid',
    	selector:'financeprogrammappingacademylocationgrid'
    },{
    	ref:'financealprogramgrid',
    	selector:'financealprogramgrid'
    },{
    	ref:'financealprogrambatchgrid',
    	selector:'financealprogrambatchgrid'
    },{
    	ref:'financealprogrambatchseattypegrid',
    	selector:'financealprogrambatchseattypegrid'
    },{
    	ref:'financefeedomappingalertwin',
    	selector:'financefeedomappingalertwin'
    },{
    	ref:'financeholdtypewindow',
    	selector:'financeholdtypewindow'
    },{
    	ref:'financemappedprogramwindow',
    	selector:'financemappedprogramwindow'
    },{
    	ref:'financeholdblockedstudentgrid',
    	selector:'financeholdblockedstudentgrid'
    },{
    	ref:'financeholdblockedstudentsearchform',
    	selector:'financeholdblockedstudentsearchform'
    	
    },{
    	ref:'financeblockedstudentremarkwindow',
    	selector:'financeblockedstudentremarkwindow'
    	
    },{
    	ref:'managefinanceholdstructure',
    	selector:'managefinanceholdstructure'
    	
    },{
    	ref:'financeholdlistofblockedstudentstructure',
    	selector:'financeholdlistofblockedstudentstructure'
    	
    },{
    	ref:'managefinanceholdmappedprogramstructure',
    	selector:'managefinanceholdmappedprogramstructure'
    	
    }],
    init: function() {
    	this.suspendPendingFeeEvent=false;
    	this.control({
    		'managefinanceholdsearchform button[itemId=searchBtn]': {
    			click: this.loadSearchFinanceHoldList
    		},
    		'managefinanceholdsearchform button[itemId=resetBtn]': {
    			click: function(obj) {
    				var form = obj.up('form').getForm();
    				form.reset();
    			}
    		},
    		
    		'financeholdblockedstudentsearchform button[itemId=searchBtn]': {
    			click: this.loadFinanceHoldBlockedStudent
    		},
    		'managefinanceholdaddform button[itemId=resetBtn]': {
    			 click: this.resetManagefinanceholdaddform
    		},
    		'managefinanceholdgrid button[itemId=btnAdd]': {
    			click: this.addFinanceHoldRecord
    		},
    		'managefinanceholdgrid button[itemId=btnEdit]': {
    			click: this.editFinanceHoldRecord
    		},
    		'managefinanceholdaddform button[itemId=btnAddTypeFeePercent]':{
    			click:this.addTypeFeePercentHeaderContainer
    		},
    		'managefinanceholdaddform button[itemId=SubmitBtn]':{
    			click: function(){
    				this.saveFinanceHoldDetails(true)
    			}
    		},
    		'managefinanceholdgrid button[itemId=applyToBtn]': {
    			click: this.openFinanceHoldMappedProgramDetail
    		},
    		
    		'managefinancemappedprogramgrid': {
    			render:function(grid){
    				this.doAccessControlValidation(grid, this.getMANAGE_FINANCE_HOLD_APPLY_TO_PETMISSION());
    			},
    		},
    		
    		'managefinancemappedprogramgrid button[itemId=btnAdd]': {
    			click: this.openFinanceProgramFeeMappingTab
    		},
    		'financeprogrammappingacademylocationgrid customcombobox#academylocationsearchcombo' : {
    			select:function(obj, record){
    				var grid =this.getFinanceprogrammappingacademylocationgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'id',
    					value: record[0].get('id'),
    					exactMatch: true,
    					caseSensitive: true});  
    				var gridDom = grid.el ? grid.el.dom : null;
                    gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
    			}
    		},
    		'financeprogrammappingacademylocationgrid button#nextButton':{
    			click:function(btn){
    				this.academyLocationFinanceProgMappNextEvent(btn);
    			}
    		},
    		'financealprogramgrid button#nextButton':{
    			click:function(btn){
    				this.financeALProgramNextEvent(btn);
    			}
    		},
    		'financealprogrambatchgrid button#nextButton':{
    			click:function(btn){
    				this.financeALProgramBatchNextEvent(btn);
    			}
    		},
    		
    		'financeholdblockedstudentgrid': {
    			render:function(grid){
    				this.doAccessControlValidation(grid, this.getMANAGE_FINANCE_HOLD_BLOCKED_STUDENTS_PETMISSION());
    				this.disableMoreActionPivileges(grid, this.getMANAGE_FINANCE_HOLD_BLOCKED_STUDENTS_PETMISSION());
    			},
    		},
    		
    		'financeholdblockedstudentgrid button[itemId=unblockBtn]':{
    			click:function(btn){
    				//this.financeHoldUnblockStudent(grid);
    				this.OpenBlockedStudentRemarkWindow();
    			}
    		},
            'financeblockedstudentremarkwindow button[itemId=submitButtonId]': {
            	click: function(obj) {
            		this.saveFinanceHoldUnblockStudent();
            	}
            },
            'financeblockedstudentremarkwindow button[itemId=cancelButtonId]': {
            	click: function(obj) {
            		this.getFinanceblockedstudentremarkwindow().close();  
            	}
            },
    		'financewithprogrambatchseatstructure button#resetBtn':{
    			click:function(btn){
    				var tabStructure = this.getFinancewithprogrambatchseatstructure();
    				var activeGrid = tabStructure.getActiveTab().down('grid');
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('customcombobox'))
    					activeGrid.down('customcombobox').reset();
    			}
    		},
    		'financewithprogrambatchseatstructure button#submitHinanceHoldMapping':{
    			click:function(btn){
    				this.submitFinanceHoldMappingWithProgramBatchSeatType();
    			}
    		},
    		'financefeedomappingalertwin button[itemId=financeFeePlanAlertBtn]':{
    			click : function(btn) {
    				var alertWin = this.getFinancefeedomappingalertwin();
    				alertWin.close();
    			}
    		},
    		'managefinanceprogramfeemappingtab':{
    			afterrender : function(structure){
    				structure.getOverflowEl().up('.x-panel-body').dom.style.overflow='hidden';
    			}
    		},
    		'managefinancemappedprogramgrid button[itemId=btnDelete]': {
    			click:this.deleteFinanceHoldMappingDetails
    		},
    		'managefinanceholdgrid button[itemId=btnDelete]': {
    			click:this.deleteFinanceHoldDetails
    		},
    		
    		'managefinanceholdgrid': {
       			render:function(grid){
       				this.doAccessControlValidation(grid, this.getMANAGE_FINANCE_HOLD_PETMISSION());
       				this.disableMoreActionPivileges(grid, this.getMANAGE_FINANCE_HOLD_PETMISSION());
       			},

			afterrender:function(grid){

					var me = this;
					setTimeout(function(){
					me.addDataGridConfigButton(grid, me.getMANAGE_FINANCE_HOLD_PETMISSION());
											},1500);
    			 },

    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				var $this =this;
    				if(columnName == "blockedStudentCount"){
    					if(e.target.tagName=='A'){
    						this.openFinanceBlockedStudentTab(grid,record);
    					}
    				}
    				if(columnName == "financeHoldCount"){
    					if(e.target.tagName=='A'){
    						this.openFinanceHoldCountWindow(grid,record);
    					}
    				}
    				if(columnName == "mappedProgramCount"){
    					if(e.target.tagName=='A'){
    						this.openMappedProgramsGridWindow(grid,record);
    					}
    				}
    			}
    		},
            'financeholdblockedstudentsearchform': {
    			  render: function(form) {
    				  var me = this;
    				  var academyLocationId = this.getCurrentAcademyLocation();
    				  if(academyLocationId>0){
    					  var store = this.getStore('facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore');
    					  store.getProxy().extraParams = {
    						academyLocationId: academyLocationId
    					  };
    					  store.load();
    				  }
    				  
    				  var store1 = this.getStore('feeandpayment.finance.FinanceBlokedStudentFilterAcademyLocationStore');
          				/*store1.getProxy().extraParams = {
          				id: academyId
          			};*/
          			store1.load(); 
          			
          			var studentFieldStore = form.down('#student').getStore();
          			studentFieldStore.on('beforeload', function(){
          				var grid = me.getManagefinanceholdgrid();
          				var records = grid.getSelectionModel().getSelection()[0];
          				var financeHoldId = records.data.financeHoldId;
          				studentFieldStore.getProxy().extraParams.financeHoldId = financeHoldId;
        			});
    			  }
            },
            
            'financeholdblockedstudentsearchform customcombobox[itemId=holdType]':{
  			  render:function(combo){
  				  $this = this;
  				  var store = combo.getStore(); 
  				  store.on('load', function(){
  						  var filterItemIds = ['EXAM_ENROLLMENT'];
  						  var storeItems = store.getRange();
  						  for(var i = 0; i<storeItems.length; i++){     
  							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
  								  store.remove(store.getById(storeItems[i].get('id')));            
  						  }  
  				  });

  			  }
  		  },
            'financeholdblockedstudentsearchform combo#academyLocationId': {
            	select: function(obj, record) {
            		var form = this.getFinanceholdblockedstudentsearchform();
            		var studentFilter = form.down("#student");
            		 var studentStore = studentFilter.getStore();
            		
            		var academyId = record[0].get("id");

            		if(academyId > 0){
            			//var store = this.getStore('feeandpayment.finance.FinanceBlokedStudFilterStudentByALStore');
            			studentStore.getProxy().extraParams = {
            				academyLocationIds: academyId
            			};
            			studentStore.load(); 
            			
            			var programFilter = form.down("#programId");
               		    var programStore = programFilter.getStore();
               		
            			
            			//var programStore = this.getStore('common.ProgramByAcademyLocationStore');
               		 programStore.getProxy().extraParams = {
            				academyLocationIds: academyId
            			};
               		programStore.load();   
            		}
            	}
            },
            'financeholdblockedstudentsearchform combo#programId': {
            	select: function(obj, record) {
            		var form = this.getFinanceholdblockedstudentsearchform();
            		form.down("#batchId").setDisabled(false);
            		var programId = record[0].get("id");
            		if(programId > 0){
            			var store = this.getStore('enquiry.AcademicBatchStore');
            			store.getProxy().extraParams = {
            				id: programId
            			};
            			store.load();
            		}
            	},
            	change: function(value,newValue) {
            		if(isNullOrEmpty(newValue)){
            			var form = this.getFinanceholdblockedstudentsearchform();
            			form.down("#batchId").setDisabled(true);
            			form.down("#seatTypeId").setDisabled(true);
            		}
            	}
            },
            'financeholdblockedstudentsearchform combo#batchId': {
            	select: function(obj, record) {
            		var form = this.getFinanceholdblockedstudentsearchform();
            		form.down("#seatTypeId").setDisabled(false);
            		var batchId = record[0].get("id");
            		if(batchId > 0){
            			var store = form.down("#seatTypeId").getStore();//this.getStore('common.SeatTypesByBatchId');
            			store.getProxy().extraParams = {
            				batchId: batchId
            			};
            			store.load();
            		}
            	}
            },
    		'financeholdblockedstudentsearchform button[itemId=resetBtn]': {
   			 click: this.resetBlockedStudentSearchForm
   		},
		 'financealprogramgrid customcombobox#programsearchcombo' : {
			  select:function(obj, record){
				  var grid =this.getFinancealprogramgrid();
				  grid.getStore().clearFilter();
				 //this.getAlprogramgrid().getStore().filter('programId', record[0].get('id'));
				  grid.getStore().filter({property: 'programId',
					  value: record[0].get('id'),
					  exactMatch: true,
					  caseSensitive: true});
				
 				var gridDom = grid.el ? grid.el.dom : null;
                 gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
 			
			  }
		  },
		 'financealprogrambatchgrid customcombobox#programbatchsearchcombo' : {
			  select:function(obj, record){
				  var grid =this.getFinancealprogrambatchgrid()
				 grid.getStore().clearFilter();
				 //this.getAlprogrambatchgrid().getStore().filter('batchId', record[0].get('id'));
				  grid.getStore().filter({property: 'batchId',
					  value: record[0].get('id'),
					  exactMatch: true,
					  caseSensitive: true});
					var gridDom = grid.el ? grid.el.dom : null;
	                 gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			  }
		  },
		  'managefinanceholdstructure':{
	  			afterrender:function(structure){
 				 var grid = structure.down('managefinanceholdgrid');
 				 this.getGridHeaderFreeze(grid,structure,true);
 			 }
		  },
		  'financeholdlistofblockedstudentstructure':{
			  afterrender:function(structure){
				  var structure = structure.up('panel');
				  var grid = structure.down('financeholdblockedstudentgrid');
				  this.getGridHeaderFreeze(grid,structure,true);
			  }
		  },
		  'managefinanceholdmappedprogramstructure':{
			  afterrender:function(structure){
				  var structure = structure.up('panel');
				  var grid = structure.down('managefinancemappedprogramgrid');
				  this.getGridHeaderFreeze(grid,structure,true);
			  }
		  },
		  'managefinanceholdaddform customcombobox[itemId=applicableOn]':{
			  select:function(obj, record){
				  var manageFinanaceForm = this.getManagefinanceholdaddform();
				  var pendingFeePercentfield = manageFinanaceForm.down('#pendingFeePercent');
				  var minimumDueAmountfield = manageFinanaceForm.down('#minimumDueAmount');
				  var typeFeePercentheaderPanel = manageFinanaceForm.down('#typeFeePercentheaderPanel');
				  if(Ext.isDefined(typeFeePercentheaderPanel)){
					  var tabDetail = typeFeePercentheaderPanel.items.items;
					  for(var i=tabDetail.length; i>tabDetail.length-1;i--){
						  if(tabDetail[i-1].getItemId()!='defaultFieldContainer'){
							  tabDetail[i-1].destroy();
						  }
					  }
				  }
				if(obj.getValue() == 'dueFeesAmount'){
					minimumDueAmountfield.show();
					pendingFeePercentfield.reset();
					pendingFeePercentfield.hide();
					this.setAllowBlank(pendingFeePercentfield,true);
					this.setAllowBlank(minimumDueAmountfield,false);
				}else{
					minimumDueAmountfield.reset();
					minimumDueAmountfield.hide();
					pendingFeePercentfield.show();
					this.setAllowBlank(minimumDueAmountfield,true);
					this.setAllowBlank(pendingFeePercentfield,false);
				}
				manageFinanaceForm.isValid();
				if(manageFinanaceForm.getForm().hasInvalidField()==false){
					manageFinanaceForm.down('#SubmitBtn').setDisabled(false);
		    	}else{
		    		manageFinanaceForm.down('#SubmitBtn').setDisabled(true);
		    	}
			  }  
		  },
		  'managefinanceholdaddform customcombobox[itemId=financeHoldType]':{
			  render:function(combo){
				  $this = this;
				  var managefinanceholdaddform = $this.getManagefinanceholdaddform();
				  var store = combo.getStore(); 
				  store.on('load', function(){
					  //if(managefinanceholdaddform.items.items[0]!=undefined && managefinanceholdaddform.items.items[0].getValue()==''){
						  var filterItemIds = ['EXAM_ENROLLMENT'];
						  var storeItems = store.getRange();
						  for(var i = 0; i<storeItems.length; i++){     
							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
								  store.remove(store.getById(storeItems[i].get('id')));            
						  }  
					 // }
				  });

			  },
			  beforeselect: function (combo, record, index) {
				  if (combo.listKeyNav.boundList.mouseOverItem.classList.contains('disabledComboItem')) {
					  return false;
				  } else {
					  return true;
				  }
			  }
		  },
		  'managefinanceholdaddform numberfield[itemId=pendingFeePercent]': {
         	 change : function(obj,newValue){
         		 var form = obj.up();
        		 if(obj.value > 100 || obj.value<1 && (!this.suspendPendingFeeEvent)){
        			 obj.reset();
        			 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PERCENTAGE_VALIDATION_MESSAGE'));
        		 }
        	 }
         },
		  'managefinanceholdsearchform customcombobox[itemId=holdType]':{
			  render:function(combo){
				  $this = this;
				  var store = combo.getStore(); 
				  store.on('load', function(){
						  var filterItemIds = ['EXAM_ENROLLMENT'];
						  var storeItems = store.getRange();
						  for(var i = 0; i<storeItems.length; i++){     
							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
								  store.remove(store.getById(storeItems[i].get('id')));            
						  }  
				  });

			  }
		  },
		  'managefinanceholdaddform':{
			  afterrender:function(){
				  this.setFinanceHoldDataSetting();
			  }
		  }
    	});
    }, 
    resetManagefinanceholdaddform:function(){
    	var form = this.getManagefinanceholdaddform();
    	this.suspendPendingFeeEvent=true;
    	form.getForm().reset();
    	this.suspendPendingFeeEvent=false;
    	var financeHoldStatus =  form.down("#financeHoldStatus");
    	financeHoldStatus.getStore().load({
    		callback: function(records, operation, success) {
    			financeHoldStatus.setValue(records[0].data.id);
    		}
    	});
    	var applicableOn =  form.down("#applicableOn");
    	applicableOn.getStore().load({
    		callback: function(records, operation, success) {
    			applicableOn.setValue('dueFeesPercentage');
    		}
    	});
    	if(form.getForm().hasInvalidField()==false){
    		form.down('#SubmitBtn').setDisabled(false);
    	}else{
    		form.down('#SubmitBtn').setDisabled(true);
    	}

    }, 
    resetBlockedStudentSearchForm:function(){
    	this.getFinanceholdblockedstudentsearchform().getForm().reset();
 	   
    },
    addFinanceHoldRecord:function(){
 	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
 	   var structure = Ext.widget('managefinanceholdaddform');
 	   var tabName = getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS');
 	   /**
 	    * This is to remove tab from content panel and open same tab again
 	    */
 	   var getcontroller=this.getController('menu.CoreERPNavigationController');
 	   var getTab=getcontroller.getTab(tabName);
 	   if(getTab!=null){
 		   contentPanel.remove(getTab, true);
 	   }
 	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);	
 	  var minimumDueAmount = structure.down('#minimumDueAmount');
 	 this.setAllowBlank(minimumDueAmount,true);
 	 var financeHoldStatus =  structure.down("#financeHoldStatus");
	   financeHoldStatus.getStore().load({
		   callback: function(records, operation, success) {
			   financeHoldStatus.setValue(records[0].data.id);
		   }
	   });
	   var applicableOn =  structure.down("#applicableOn");
	   applicableOn.getStore().load({
		   callback: function(records, operation, success) {
			   applicableOn.setValue('dueFeesPercentage');
		   }
	   });
    },
    openFinanceHoldMappedProgramDetail:function(){
    	var grid = this.getManagefinanceholdgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection()[0];
    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		var structure = Ext.widget('managefinanceholdmappedprogramstructure');
    		var tabName = getFeeAndPaymentCommonTranslation('APPLICABLE_FOR');
    		/**
    		 * This is to remove tab from content panel and open same tab again
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
    		var mappedProgramGrid = this.getManagefinancemappedprogramgrid();
    		mappedProgramGrid.getStore().getProxy().extraParams= {
    			financeHoldId: records.data.financeHoldId
    		};
    		mappedProgramGrid.getStore().load();
    		var alinfomodel = Academia.model.authentication.ALInfoModel;
    		var wheatherSchool = alinfomodel.get('wheatherSchool');
    		if(wheatherSchool){
    			for (var j = 0; j < mappedProgramGrid.columns.length; j++) {
    				if (mappedProgramGrid.columns[j].dataIndex == "periodName") {
    					mappedProgramGrid.columns[j].setVisible(false);

    				}
    			}
    		}else{
    			for (var j = 0; j < mappedProgramGrid.columns.length; j++) {
    				if (mappedProgramGrid.columns[j].dataIndex == "periodName") {
    					mappedProgramGrid.columns[j].setVisible(true);

    				}
    			}
    		}
    	}else{
    		showWarningMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record   
    	}
    },
    addTypeFeePercentHeaderContainer: function() {
  	  var this$ = this;
	  var form = this$.getManagefinanceholdaddform();
	  var getform = form.getForm();
	  var panelItem = new Array();
	  var pendingFeePercentVisible = '';
	  var minimumDueAmountVisible = '';
	  var allicableOnField = form.down('#applicableOn');
	  var pendingFeePercentField = form.down('#pendingFeePercent');
	  var minimumDueAmountField = form.down('#minimumDueAmount');
	  if(allicableOnField.getValue()== 'dueFeesAmount'){
		  minimumDueAmountVisible = false;
		  minimumDueAmountAllowBlank = false;
		  pendingFeePercentVisible = true;
		  pendingFeePercentAllowBlank = true;
	  }else if(allicableOnField.getValue()== 'dueFeesPercentage'){
		  minimumDueAmountVisible = true;
		  pendingFeePercentVisible = false;
		  minimumDueAmountAllowBlank = true;
		  pendingFeePercentAllowBlank = false;
	  }else{
		  pendingFeePercentVisible = false;
		  minimumDueAmountVisible = true;
		  minimumDueAmountAllowBlank = true;
		  pendingFeePercentAllowBlank = false;
	  }
	  panelItem.push({
		  xtype: 'fieldcontainer',
		  width: '100%',
		  layout: {
			  type: 'hbox',
			  align: 'bottom'
		  },
		  defaults : {
			   width: 256,
			   labelAlign : 'top'
		   },
		  items: [{
				xtype: 'customcombobox',
				itemId: 'financeHoldType',
				name: 'financeHoldType',
				fieldLabel: getFeeAndPaymentCommonTranslation('HOLD_TYPE')+':'+'<span class="required" style="color:red"> *</span>',
				labelSeparator: '',
				store: 'feeandpayment.finance.FinanceHoldTypeStore',
				valueField: 'id',
				displayField: 'value',
				 forceSelection:true,
				allowBlank: false,
				newHoldTypes: [
                    'MAKRSHEET_PUBLISH',
                    'ASSESSMENT_SCHEME_LEVEL',
                    'ASSESSMENT_SCHEME_TYPE_LEVEL',
                    'ASSESSMENT_SCHEME_SUBTYPE_LEVEL',
                    'METHOD_LEVEL',
                    'EVENT_LEVEL',
                    'GRADEBOOK_PUBLISH'
                ],
                listConfig: {
                	listeners: {
                		beforeshow: function (picker) {
                			picker.minWidth = picker.up('combobox').getSize().width;
                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(picker);
                		},
                		refresh: function (boundList, eOpts) {
                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(boundList);
                		}
                	}
                }
			}, {
				xtype:'numberfield',
				name:'pendingFeePercent',
				allowExponential:true,
				fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_PERCENTAGE_DUE')+':'+'<span class="required" style="color:red"> *</span>',
				labelSeparator: '',
				itemId:'pendingFeePercent',
				minValue:0,
				maxLength:8,
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowBlank: pendingFeePercentAllowBlank,
				hidden:pendingFeePercentVisible
			}, {
				xtype:'numberfield',
				name:'minimumDueAmount',
				allowExponential:true,
				fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_DUE_AMOUNT')+':'+'<span class="required" style="color:red"> *</span>',
				labelSeparator: '',
				itemId:'minimumDueAmount',
				minValue:0,
				maxLength:8,
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowBlank: minimumDueAmountAllowBlank,
				hidden:minimumDueAmountVisible
			},{
			  xtype: 'button',
			  glyph: ICONGLYPH.DELETEGLYPH,
			  cls: 'CustomBodyBtnReject',
			  tooltip: getCommonTranslation('DELETETOOLTIP'),
			  listeners:{
				  click:function(obj){
					  var frm = obj.ownerCt.ownerCt.ownerCt;
					  var receiptPanel = frm.down('#typeFeePercentheaderPanel');
					  var container = obj.up('fieldcontainer');
					  receiptPanel.remove(container);
					  if(getform.hasInvalidField()==false)
						  {
						  form.down('#SubmitBtn').setDisabled(false);
						  }else
							  {
							  form.down('#SubmitBtn').setDisabled(true);
							  }
					  frm.doLayout();
				  }
			  }
		  }]
	  });

   var typeFeePercentheaderPanel = form.down('#typeFeePercentheaderPanel');
      if(typeFeePercentheaderPanel.items.length<4){
    	  typeFeePercentheaderPanel.add(panelItem);
    	  typeFeePercentheaderPanel.doLayout();
    	  var panelItem = typeFeePercentheaderPanel.items.items;
      }
      if(getform.hasInvalidField()==false)
	  {
	  form.down('#SubmitBtn').setDisabled(false);
	  }else
		  {
		  form.down('#SubmitBtn').setDisabled(true);
		  }
      form.doLayout();
  },
   hasDuplicates: function(array) {
	    var valuesSoFar = Object.create(null);
	    for (var i = 0; i < array.length; ++i) {
	        var value = array[i];
	        if (value in valuesSoFar) {
	            return true;
	        }
	        valuesSoFar[value] = true;
	    }
	    return false;
	},
  saveFinanceHoldDetails: function(isAdd){

	  var $this = this;
	  var managefinanceholdform = $this.getManagefinanceholdaddform();
	  var grid = $this.getManagefinanceholdgrid();
	  var form = managefinanceholdform.getForm();
	  managefinanceholdform.down('#SubmitBtn').setDisabled(true);
	  var value = form.getValues();
	  var managefinanceholdcreatemodel = new Academia.model.feeandpayment.finance.ManageFinanceHoldCreateModel();
	  managefinanceholdcreatemodel.set("code",value.financeHoldId);
	  managefinanceholdcreatemodel.set("name",value.financeHoldName);
	  managefinanceholdcreatemodel.set("cutoffDate",value.cutOffDate);
	  managefinanceholdcreatemodel.set("financeHoldStatus",value.financeHoldStatus);
	  managefinanceholdcreatemodel.set("autoUnblockStudentWhnDueAmtPaid",value.autoUnblockStudent);
	  managefinanceholdcreatemodel.set("academyLocationId",$this.getCurrentAcademyLocation());
	  managefinanceholdcreatemodel.set("isVisibleStudentParent",value.visibleToStduentParent);
	  if(value.applicableOn =='dueFeesAmount'){
		  value.applicableOn = 'DUE_FEES_AMOUNT'; 
	  }else {
		  value.applicableOn = 'DUE_FEES_PERCENTAGE'; 
		  }
	  managefinanceholdcreatemodel.set("financeApplicableOn",value.applicableOn);

	  var myJson = new Array();
	  var isArr = isArray(value["financeHoldType"]);
	  var isArrFHT = isArray(value["financeHoldTypeId"]);
	  if(isArr){
		  if($this.hasDuplicates(value["financeHoldType"])){
			  var message = getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DUPLICATES_SUCCESSFULLY');
			  showWarningMessage(getCommonTranslation('ALERT'), message);
			  managefinanceholdform.down('#SubmitBtn').setDisabled(false);
			  return false;
		  }
	  }
	  if(isArr == true && !isArrFHT){
		  value["financeHoldTypeId"] = value["financeHoldTypeId"].split(',');
	  }
	  if (isArr == true) {
		  for (var i = 0; i < value["financeHoldType"].length; i++) {
			  var obj = new Object();

			  obj.id = value["financeHoldTypeId"][i];
			  obj.financeHoldType = value["financeHoldType"][i];
			  obj.pendingFeePercent = value["pendingFeePercent"][i];
			  obj.minimumDueAmount = value["minimumDueAmount"][i];
			  myJson.push(obj);
		  }
	  }else{
		  var obj = new Object();
		  obj.id = value["financeHoldTypeId"];
		  obj.financeHoldType = value["financeHoldType"];
		  obj.pendingFeePercent = value["pendingFeePercent"];
		  obj.minimumDueAmount = value["minimumDueAmount"];
		  myJson.push(obj);
	  }
	  managefinanceholdcreatemodel.set("financeHoldCriterias",myJson);


	  if(!isNullOrEmpty(value.id)){
		  submitUrl = SERVERURL.PATH_FINANCEHOLD_UPDATE; 
		  managefinanceholdcreatemodel.set("id",value.id);
		  message = getFeeAndPaymentCommonTranslation('PATH_FINANCE_HOLD_UPDATED_SUCCESSFULLY');
	  }
	  else{
		  submitUrl = SERVERURL.FINANCE_HOLD_CREATE; 
		  message = getFeeAndPaymentCommonTranslation('PATH_FINANCE_HOLD_CREATED_SUCCESSFULLY');
	  }
	  var formData = Ext.encode(managefinanceholdcreatemodel.data);

	  var submitUrl; 
	  var message;
	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	  Ext.Ajax.request({
		  type : 'rest',
		  url : submitUrl,
		  jsonData : formData,
		  method : 'POST',
		  success : function(frm, action) {
			  Ext.getBody().unmask();
			  var contentpanel = $this.getContentPanel();
			  var tabName = getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS');

			  var getcontroller=$this.getController('menu.CoreERPNavigationController');
			  var getTab=getcontroller.getTab(tabName);
			  if(getTab!=null){
				  contentpanel.remove(getTab, true);
			  }
			  grid.getStore().reload(); 
			 
			  showSuccessMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS'), message);
		  }
	  });

  },
  openFinanceProgramFeeMappingTab:function(){
	  var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	  var structure = Ext.widget('managefinanceprogramfeemappingtab');
	  var tabName = getFeeAndPaymentCommonTranslation('ADD_FINANCE_MAPPING');
	  var grid = this.getManagefinanceholdgrid();
	  if (grid.getSelectionModel().getCount() > 0) {
		  var records = grid.getSelectionModel().getSelection()[0];
	  }
	  //var financeHoldId = records.data.financeHoldId;
	  /**
	   * This is to remove tab from content panel and open same tab again
	   */
	  var getcontroller=this.getController('menu.CoreERPNavigationController');
	  var getTab=getcontroller.getTab(tabName);
	  if(getTab!=null){
		  contentPanel.remove(getTab, true);
	  }
	  openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);	
	  var academylocationgrid = this.getFinanceprogrammappingacademylocationgrid();
	  var financeWithProgramBatchSeatStructure = this.getFinancewithprogrambatchseatstructure();
	  academylocationgrid.getStore().clearFilter();
	  academylocationgrid.getStore().getProxy().extraParams= {
			id: records.data.financeHoldId
		};
	  academylocationgrid.getStore().load();
	  this.getFinanceprogrammappingprogresstracker().setVisible(true);
	  this.resetFinancecProgressTracker();
	  var financeprogrammappingprogresstracker = structure.down("#financeProgramMappingProgressId");
	  var progresstracker1 = financeprogrammappingprogresstracker.down("#progresstracker1");
	  progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
	  progresstracker1.textEl.addCls("inProgressCss-progress-text");
	  progresstracker1.updateText("Step 1 In Progress");
	  if(this.getManagefinanceholdgrid()){
  		var records = this.getManagefinanceholdgrid().getSelectionModel().getSelection()[0];
      	if(records){
      		financeWithProgramBatchSeatStructure.down("#financeHoldTabMappingId").setValue(records.data.name);
      		
      		structure.down('#financeHoldMappingName').setValue(records.get('name'));
      		structure.down('#financeHoldMappingId').setValue(records.get('financeHoldId'));
      	}
  	}
  },
  resetFinancecProgressTracker : function(){
	  var structure = this.getManagefinanceprogramfeemappingstructure();
	  var financeprogrammappingprogresstracker = structure.down("#financeProgramMappingProgressId");
	  var progresstracker1 = financeprogrammappingprogresstracker.down("#progresstracker1");
	  var progresstracker2 = financeprogrammappingprogresstracker.down("#progresstracker2");
	  var progresstracker3 = financeprogrammappingprogresstracker.down("#progresstracker3");
	  var progresstracker4 = financeprogrammappingprogresstracker.down("#progresstracker4");
	  progresstracker1.reset();
	  progresstracker1.updateText('');
	  progresstracker2.reset();
	  progresstracker2.updateText('');
	  progresstracker3.reset();
	  progresstracker3.updateText('');
	  progresstracker4.reset();
  	  progresstracker4.updateText('');

  },
  academyLocationFinanceProgMappNextEvent:function(btn){
  	var financeAcademyLocationGrid = this.getFinanceprogrammappingacademylocationgrid();
  	var financeSelectionModel = financeAcademyLocationGrid.getSelectionModel().getSelection();
  	var academyLocationIdsArr = [];
  	financeSelectionModel.forEach(function(obj){
  		academyLocationIdsArr.push(obj.get('id'));
  	});
  	if(academyLocationIdsArr.length > 0){
	    	var financeWithProgramBatchSeatStructure = this.getFinancewithprogrambatchseatstructure();
	    	var programcontainer = financeWithProgramBatchSeatStructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	financeWithProgramBatchSeatStructure.setActiveTab(programcontainer);
	    	var alProgramGrid = this.getFinancealprogramgrid();
	    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alProgramSearchCombo.getStore().load();
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join(),
	    		limit :-1
	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	this.setFinanceProgressTracker(1);
	    	if(this.getFinanceprogrammappingacademylocationgrid()){
	    		var records = this.getFinanceprogrammappingacademylocationgrid().getSelectionModel().getSelection()[0];
	    		if(records){
	    			var structure = this.getManagefinanceprogramfeemappingstructure();

	    			var financeHoldMappingName = structure.down('#financeHoldMappingName').getValue();
	    			financeWithProgramBatchSeatStructure.down("#financeFeePlanProgramTab").setValue(financeHoldMappingName); 
	    		}
	    	}
  	} else {
  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
  	}
  },
  financeALProgramNextEvent: function(btn){
  	var financealprogramgrid = this.getFinancealprogramgrid();
	var financeselectionModel = financealprogramgrid.getSelectionModel().getSelection();
	var alprogramgridIdsArr = [];
	var programIdsArr = [];
	financeselectionModel.forEach(function(obj){
		alprogramgridIdsArr.push(obj.get('academyLocationId'));
		programIdsArr.push(obj.get('programId'));
	});
	
	if(programIdsArr.length > 0){
    	var financeWithProgramBatchSeatStructure = this.getFinancewithprogrambatchseatstructure();
    	var programbatchcontainer = financeWithProgramBatchSeatStructure.down('#programbatchcontainer');
    	programbatchcontainer.setDisabled(false);
    	financeWithProgramBatchSeatStructure.setActiveTab(programbatchcontainer);
    	
    	var financeALProgramBatchGrid = this.getFinancealprogrambatchgrid();
    	
    	var financeALProgramBatchSearchCombo = financeALProgramBatchGrid.down('#programbatchsearchcombo');
    	financeALProgramBatchSearchCombo.getStore().getProxy().extraParams= {
    		academyLocationIds: alprogramgridIdsArr.join(),
    		programIds:programIdsArr.join()
    	};
    	financeALProgramBatchSearchCombo.getStore().load();
    	
    	var financeALProgramBatchGridStore = financeALProgramBatchGrid.getStore();
    	financeALProgramBatchGridStore.getProxy().extraParams= {
    		academyLocationIds: alprogramgridIdsArr.join(),
    		programIds:programIdsArr.join(),
    		limit :-1
    	};
    	financeALProgramBatchGridStore.clearFilter();
    	financeALProgramBatchGridStore.load();
    
    	this.setFinanceProgressTracker(2);
    	if(this.getFinanceprogrammappingacademylocationgrid()){
    		var records = this.getFinanceprogrammappingacademylocationgrid().getSelectionModel().getSelection()[0];
    		if(records){
    			var structure = this.getManagefinanceprogramfeemappingstructure();

    			var financeHoldMappingName = structure.down('#financeHoldMappingName').getValue();
    			financeWithProgramBatchSeatStructure.down("#financeFeePlanProgramBatchTab").setValue(financeHoldMappingName); 
    		}
    	}
	} else {
		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	}
	},
	financeALProgramBatchNextEvent:function(btn){
		var financealprogrambatchgrid = this.getFinancealprogrambatchgrid();
		var financeselectionModel = financealprogrambatchgrid.getSelectionModel().getSelection();
		var alprogramgridIdsArr = [];
		var programIdsArr = [];
		var batchIdsArr = [];
		financeselectionModel.forEach(function(obj){
			alprogramgridIdsArr.push(obj.get('academyLocationId'));
			programIdsArr.push(obj.get('programId'));
			batchIdsArr.push(obj.get('batchId'));
		});

		if(batchIdsArr.length > 0){
			var financeWithProgramBatchSeatStructure = this.getFinancewithprogrambatchseatstructure();
			var financeprogrambatchseattypecontainer = financeWithProgramBatchSeatStructure.down('#programbatchseattypecontainer');
			financeprogrambatchseattypecontainer.setDisabled(false);
			financeWithProgramBatchSeatStructure.setActiveTab(financeprogrambatchseattypecontainer);

			var financeALseattypegrid = this.getFinancealprogrambatchseattypegrid();
			var alinfomodel = Academia.model.authentication.ALInfoModel;
    		var wheatherSchool = alinfomodel.get('wheatherSchool');
    		if(wheatherSchool){
    			for (var j = 0; j < financeALseattypegrid.columns.length; j++) {
    				if (financeALseattypegrid.columns[j].dataIndex == "periodName") {
    					financeALseattypegrid.columns[j].setVisible(false);

    				}
    			}
    		}else{
    			for (var j = 0; j < financeALseattypegrid.columns.length; j++) {
    				if (financeALseattypegrid.columns[j].dataIndex == "periodName") {
    					financeALseattypegrid.columns[j].setVisible(true);

    				}
    			}
    		}
			var financecALProgramBatchSeatTypeGridStore = financeALseattypegrid.getStore();
			financecALProgramBatchSeatTypeGridStore.getProxy().extraParams= {
				academyLocationIds: alprogramgridIdsArr.join(),
				programIds:programIdsArr.join(),
				batchIds:batchIdsArr.join(),
				screen:'financeHold',
				limit :-1
			};
			financecALProgramBatchSeatTypeGridStore.clearFilter();
			financecALProgramBatchSeatTypeGridStore.load();
			this.setFinanceProgressTracker(3);
			if(this.getFinanceprogrammappingacademylocationgrid()){
	    		var records = this.getFinanceprogrammappingacademylocationgrid().getSelectionModel().getSelection()[0];
	    		if(records){
	    			var structure = this.getManagefinanceprogramfeemappingstructure();

	    			var financeHoldMappingName = structure.down('#financeHoldMappingName').getValue();
	    			financeWithProgramBatchSeatStructure.down("#financeFeePlanProgramBatchSeattypeTab").setValue(financeHoldMappingName); 
	    		}
	    	}
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	setFinanceProgressTracker : function(progresstracker){
		var structure = this.getManagefinanceprogramfeemappingstructure();
		var adjustmentprogresstracker = structure.down("#financeProgramMappingProgressId");

		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
		var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
		var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");

		if(progresstracker==1){
			for(var i = 0; i < 11; i ++ ){
				progresstracker1.updateProgress((i * 0.1), '');
			}
			progresstracker1.textEl.addCls("custom-progress-text");
			progresstracker1.textEl.removeCls("inProgressCss-progress-text");
			progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker2.textEl.addCls("inProgressCss-progress-text");
			progresstracker2.updateText("Step 2 In Progress");
			progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
		}
		if(progresstracker==2){
			for(var i = 0; i < 11; i ++ ){
				progresstracker2.updateProgress((i * 0.1), '');
			}
			progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker3.textEl.addCls("inProgressCss-progress-text");
			progresstracker3.updateText("Step 3 In Progress");
			progresstracker2.textEl.removeCls("inProgressCss-progress-text");
			progresstracker2.textEl.addCls("custom-progress-text");
			progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
		}
		if(progresstracker==3){
			for(var i = 0; i < 11; i ++ ){
				progresstracker3.updateProgress((i * 0.1), '');
			}
			progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
			progresstracker4.textEl.addCls("inProgressCss-progress-text");
			progresstracker4.updateText("Step 4 In Progress");
			progresstracker3.textEl.removeCls("inProgressCss-progress-text");
			progresstracker3.textEl.addCls("custom-progress-text");
			progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
		} 
		if(progresstracker==4){
			  for(var i = 0; i < 11; i ++ ){
				  progresstracker4.updateProgress((i * 0.1), '');
			  }
			  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
			  progresstracker4.textEl.addCls("custom-progress-text");
			  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
		  }
  },
  //*********create json formate**********
  getIdValueJson: function(id, value) {
	  if (id) return {
		  id: id,
		  value: value
	  };
  }, 
  loadSearchFinanceHoldList: function() {

	  var quickSearchForm = this.getManagefinanceholdsearchform();
	  quickSearchForm.down('#searchBtn').setDisabled(true);
	  var financeHoldPlanGrid = this.getManagefinanceholdgrid();
	  formValues = quickSearchForm.getValues();

	  var academyLocationId = this.getCurrentAcademyLocation();

	  var store = financeHoldPlanGrid.getStore();
	  store.getProxy().extraParams = {
		  financeId:formValues.financeHoldCodeName,
		  financeHoldStatus:formValues.status,
		  cutOffDate:formValues.cutOffDate,
		  financeHoldType:formValues.holdType
	  };
	  this.resetPageSetting(store);
	  store.load({
		   callback: function(records, operation, success) {
			   quickSearchForm.down('#searchBtn').setDisabled(false);
		   }
	   });
	  financeHoldPlanGrid.config.searchFilterForm = quickSearchForm;
  },
  loadFinanceHoldBlockedStudent: function() {

	  var quickSearchForm = this.getFinanceholdblockedstudentsearchform();
	  var financeHoldBlockedStudentGrid = this.getFinanceholdblockedstudentgrid();
	  formValues = quickSearchForm.getValues();

	  var academyLocationId = this.getCurrentAcademyLocation();

	  var me = this; 
	  var grid = me.getManagefinanceholdgrid();
	  var records = grid.getSelectionModel().getSelection()[0];
	  var financeHoldId = records.data.financeHoldId;
	  
	  var store = financeHoldBlockedStudentGrid.getStore();
	  store.getProxy().extraParams = {
		  financeHoldId:financeHoldId,
		  academyLocationId:formValues.academyLocationId,
		  studentId:formValues.student,
		  financeHoldType:formValues.holdType,
		  programId:formValues.programId,
		  batchId:formValues.batchId,
		  seatId:formValues.seatTypeId
	  };
	  this.resetPageSetting(store);
	  store.load();
  },
  submitFinanceHoldMappingWithProgramBatchSeatType: function(btn){
  	var financeTabStructure = this.getFinancewithprogrambatchseatstructure();
	var financeActiveGrid = financeTabStructure.getActiveTab().down('grid');
	var financeSelectedRecord = financeActiveGrid.getSelectionModel().getSelection();
	var addfinanceHoldMappingtab = this.getManagefinanceprogramfeemappingstructure();
	var financeHoldMappingId = addfinanceHoldMappingtab.down('#financeHoldMappingId').getValue();
	var submitJsonArr = [];
	if(financeSelectedRecord.length>0){
	if(financeActiveGrid.xtype == 'financealprogrambatchseattypegrid'){
			submitUrl = SERVERURL.PATH_FINANCEHOLD_PROGBATCHSEATCONFIG_CREATE;
			financeSelectedRecord.forEach(function(obj){
    			submitJsonArr.push({
    				financeHold: {id:financeHoldMappingId},
    				//financeHold: {id:1},
    				academyLocation: {id:obj.get('academyLocationId')},
    				program:{id:obj.get('programId')},
    				batch:{id:obj.get('batchId')},
    				seatType:{id:obj.get('programBatchSeatTypeId')},
    				progBatchSeatConfig:{id:obj.get('programBatchSeatTypeId')},
    				progBatchPeriodConfig:{id:obj.get('programBatchPeriodId')}
    			});
    		});
		}
		Ext.Ajax.request({
			method: "POST",
			type: 'rest',
			url: submitUrl,
			scope:this,
			jsonData:submitJsonArr,
			success : function(response, action) {
				var contentpanel = this.getContentPanel();
		    	var tabName = getFeeAndPaymentCommonTranslation('ADD_FINANCE_MAPPING');

		    	var getcontroller=this.getController('menu.CoreERPNavigationController');
		    	var getTab=getcontroller.getTab(tabName);
		    	if(getTab!=null){
		    		contentpanel.remove(getTab, true);
		    	}
		    	var grid = this.getManagefinancemappedprogramgrid();
		    	var grdStore = grid.getStore();
		    	grdStore.load();
		    	
		    	var data = response.responseText;
      			if(data == getFeeAndPaymentCommonTranslation('SUCCESS')){
      				showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
      			} else {
      				var alertWin = this.getFinancefeedomappingalertwin();
      				if(!alertWin){
      					alertWin = Ext.widget('financefeedomappingalertwin');
      				}
      				alertWin.down('#financeFeePlanAlert').setValue(data);
      				alertWin.show();
      			}
			}
		});
	} else {
		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	}
},
// *********** delete Finance Hold Mapping details records *********
deleteFinanceHoldMappingDetails:function(){

	var grid = this.getManagefinancemappedprogramgrid();
	var grdStore = grid.getStore();

	var gridModel = grid.getSelectionModel().getSelection();
	var id = [];
	gridModel.forEach(function(obj){
		id.push(obj.get('id'));

	});
	var delId = id.join();
	if (grid.getSelectionModel().getCount() > 0) {
		showConfirmMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			if (btn == 'yes') {
				var records = grid.getSelectionModel().getSelection();
				var id = records[0].get("id");
				Ext.Ajax.request({
					method: "DELETE",
					type: 'rest',
					url: SERVERURL.PATH_FINANCEHOLD_PBSCONFIG_DELETE+'?id='+delId,
					headers: {
						'Content-Type': 'application/json'
					},
					success: function(form, action) {
						//var data = Ext.JSON.decode(form.responseText);
						grdStore.reload();
						if(form.responseText == 'UNSUCCESS')
						{
							showSuccessMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_MAPPING'), getFeeAndPaymentCommonTranslation('FINANCE_HOLD_MAPPING_DELETE_UNSUCC'));
						}else
							{
							showSuccessMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_MAPPING'), getFeeAndPaymentCommonTranslation('FINANCE_HOLD_MAPPING_DELETE_SUCC'));
							}
						
						
					}
				});
			}
		});
	} else {
		showWarningMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	}
},
saveFinanceHoldUnblockStudent:function(){
	    $this = this;
	    var financeblockedstudentWin = $this.getFinanceblockedstudentremarkwindow();
    
	    var form = financeblockedstudentWin.down('#financeblockedstudentremarkwindow').getForm();
        var formValue = form.getValues();
	    var financealblockedstudentgrid = $this.getFinanceholdblockedstudentgrid();
	

		var financeblockedstudentModel = financealblockedstudentgrid.getSelectionModel().getSelection();
		var arr=[];
		for(var i in financeblockedstudentModel) {
			var jsonObj={
					"id":financeblockedstudentModel[i].data.id,
					"remarks" : formValue.remark
			}
			arr.push(jsonObj);
		}
		submitUrl = SERVERURL.PATH_FINANCE_UNBLOCK_STUDENT; 
		message = getFeeAndPaymentCommonTranslation('STUDENTS_UNBLOCKED_SUCCESSFULLY');
		var submitUrl; 
		var message;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		// $this.applyWindowMask();
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : arr,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask();
				financeblockedstudentWin.close();
				financealblockedstudentgrid.getStore().reload(); 
				financealblockedstudentgrid.getSelectionModel().deselectAll();
				showSuccessMessage(getFeeAndPaymentCommonTranslation('BLOCKED_STUDENTS'), message);
			}
		});
	
},
OpenBlockedStudentRemarkWindow:function(){
	$this = this;
	var financealblockedstudentgrid = $this.getFinanceholdblockedstudentgrid();

	if (financealblockedstudentgrid.getSelectionModel().getCount() > 0) {
		var formWindow = $this.getFinanceblockedstudentremarkwindow();
		if (!formWindow) {
			Ext.widget('financeblockedstudentremarkwindow');
			formWindow = $this.getFinanceblockedstudentremarkwindow();
		}
		formWindow.show();
	}
	else
	{
		showWarningMessage(getFeeAndPaymentCommonTranslation('BLOCKED_STUDENTS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	}
},

// *********** delete Finance Hold Mapping details records *********
  deleteFinanceHoldDetails:function(){

 	 var grid = this.getManagefinanceholdgrid();
      var grdStore = grid.getStore();

      if (grid.getSelectionModel().getCount() > 0) {
     	 showConfirmMessage(getFeeAndPaymentCommonTranslation('MANAGE_FINANCE_HOLD'), getFeeAndPaymentCommonTranslation('DELETE_CONFIRM_MESSAGE_AND_UNBLOCKED_STUDENTS'), function(btn, text) {
              if (btn == 'yes') {
                  var records = grid.getSelectionModel().getSelection();
                  var id = records[0].get("financeHoldId");
                  Ext.Ajax.request({
                      method: "DELETE",
                      type: 'rest',
                      url: SERVERURL.PATH_FINANCEHOLD_DELETE+'?id='+id,
                      headers: {
                          'Content-Type': 'application/json'
                      },
                      success: function(form, action) {
                          grdStore.reload();
                          showSuccessMessage(getFeeAndPaymentCommonTranslation('MANAGE_FINANCE_HOLD'), getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DELETED_SUCCESSFULLY'));
                      }
                  });
              }
          });
      } else {
          showWarningMessage(getFeeAndPaymentCommonTranslation('MANAGE_FINANCE_HOLD'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
      }
  },
  editFinanceHoldRecord:function(){
	   var $this = this;
	   var grid = $this.getManagefinanceholdgrid();

	   if (grid.getSelectionModel().getCount() > 0) {
		   
		   $this.addFinanceHoldRecord();
		   var form = this.getManagefinanceholdaddform();
		   var getform = form.getForm();
		   var record = grid.getSelectionModel().getSelection()[0];
		   var id = record.get("financeHoldId");
		   getform.findField("id").setValue(id);
		   var editUrl = SERVERURL.PATH_FINANCEHOLD_FINDBY;
		   Ext.Ajax.request({
			   method: "GET",
			   type: 'rest',
			   url: editUrl,
			   params: {
				   id: id
			   },
			   success: function(f, action) {
				   var data = Ext.JSON.decode(f.responseText);

				   form.down('#resetBtn').setVisible(false);
				   if(data.code){
					   var financeHoldId =  form.down("#financeHoldId");
					   financeHoldId.setValue(data.code);
				   }
				   if(data.name){
					   var financeHoldName =  form.down("#financeHoldName");
					   financeHoldName.setValue(data.name);
				   }
				   if(data.cutoffDate){
					   var cutoffDate =  form.down("#cutOffDate");
					   cutoffDate.setValue(dateRender(data.cutoffDate));

				   }
				   if(data.financeHoldStatus){
					   var financeHoldStatus =  form.down("#financeHoldStatus");
					   financeHoldStatus.getStore().load({
						   callback: function(records, operation, success) {
							   financeHoldStatus.setValue(data.financeHoldStatus);
						   }
					   });
				   }
				   if(data.financeApplicableOn){
					   var applicableOn =  form.down("#applicableOn");
					   applicableOn.getStore().load({
						   callback: function(records, operation, success) {
							   if(data.financeApplicableOn=='DUE_FEES_AMOUNT'){
								   applicableOn.setValue('dueFeesAmount');
							   }else{
								   applicableOn.setValue('dueFeesPercentage');
							   }
						   }
					   });
				   }
				   var autoUnblockStudentField = form.down("#autoUnblockStudentRadioGroup");
   				 if(data.autoUnblockStudentWhnDueAmtPaid==true){
   					autoUnblockStudentField.items.items[1].setValue(false);
   					autoUnblockStudentField.items.items[0].setValue(true);
   				 }else{
   					autoUnblockStudentField.items.items[1].setValue(true);
   					autoUnblockStudentField.items.items[0].setValue(false);
   				 }
   				 
   				 var isVisibleForParentStudent=form.down('#visibleToStduentParentPortal');
   				 if(data.isVisibleStudentParent==true){
   					isVisibleForParentStudent.items.items[1].setValue(false);
   					isVisibleForParentStudent.items.items[0].setValue(true);
    				 }else{
    					 isVisibleForParentStudent.items.items[1].setValue(true);
    					 isVisibleForParentStudent.items.items[0].setValue(false);
    				 }
				   form.down("#financeHoldName").setReadOnly(true);
				   var financeEvalParamsObject =data.financeHoldCriterias;
				   var formItems = [];

				   var i = 0;
				   Ext.each(financeEvalParamsObject, function(obj) {
					   if(i>0){
						   var field = {
								   xtype: 'fieldcontainer',
								   width: '100%',
								   name: obj.id + "_" + obj.evaluationParameter,
								   layout: {
									   type: 'hbox',
									   align: 'bottom'
								   },
								   items: [{
										xtype:'hidden',
										name:'financeHoldTypeId',
										itemId:'financeHoldTypeId'+obj.id
									},{
									   xtype: 'customcombobox',
									   itemId: 'financeHoldType'+obj.id,
									   name: 'financeHoldType',
									   fieldLabel: getFeeAndPaymentCommonTranslation('HOLD_TYPE'),
									   labelAlign: 'top',
									   width: 256,
									   store: 'feeandpayment.finance.FinanceHoldTypeStore',
									   valueField: 'id',
									   displayField: 'value',
									   forceSelection:true,
									   allowBlank: false,
									   newHoldTypes: [
						                    'MAKRSHEET_PUBLISH',
						                    'ASSESSMENT_SCHEME_LEVEL',
						                    'ASSESSMENT_SCHEME_TYPE_LEVEL',
						                    'ASSESSMENT_SCHEME_SUBTYPE_LEVEL',
						                    'METHOD_LEVEL',
						                    'EVENT_LEVEL',
						                    'GRADEBOOK_PUBLISH'
						                ],
						                listConfig: {
						                	listeners: {
						                		beforeshow: function (picker) {
						                			picker.minWidth = picker.up('combobox').getSize().width;
						                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(picker);
						                		},
						                		refresh: function (boundList, eOpts) {
						                			Academia.app.getController('Academia.controller.feeandpayment.finance.ManageFinanceHoldController').toggleHoldTypeOptions(boundList);
						                		}
						                	}
						                }
								   },{
										xtype:'hidden',
										name:'pendingFeePercentId',
										itemId:'pendingFeePercentId'+obj.id
								   }, {
									   xtype:'numberfield',
									   fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_PERCENTAGE_DUE'),
									   itemId:'pendingFeePercent'+obj.id,
									   name:'pendingFeePercent',
									   width: 256,
									   allowExponential:true,
									   labelAlign: 'top',
									   minValue:0,
									   maxLength:8,
									   hideTrigger:true,
									   mouseWheelEnabled:false,
									   allowBlank: false,
									   listeners:{
										   change : function(obj,newValue){
								        		 if(obj.value > 100 || obj.value<1){
								        			 obj.reset();
								        			 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PERCENTAGE_VALIDATION_MESSAGE'));
								        		 }
								        	 }
									   }
								   },{
										xtype:'hidden',
										name:'minimumDueAmountId',
										itemId:'minimumDueAmountId'+obj.id
								   },{
										xtype:'numberfield',
										itemId:'minimumDueAmount'+obj.id,
										name:'minimumDueAmount',
										width: 256,
										allowExponential:true,
										labelAlign: 'top',
										fieldLabel:getFeeAndPaymentCommonTranslation('MINIMUM_DUE_AMOUNT'),
										minValue:0,
										maxLength:8,
										hideTrigger:true,
										mouseWheelEnabled:false,
										allowBlank: false,
										hidden:true
									},{
									   xtype: 'button',
									   glyph: ICONGLYPH.DELETEGLYPH,
									   itemId:'delBtnInEditView'+obj.id,
									   cls: 'CustomBodyBtnReject',
									   tooltip: getCommonTranslation('DELETETOOLTIP'),
									   listeners:{
										   click:function(obj){
											   var frm = obj.ownerCt.ownerCt.ownerCt;
											   var receiptPanel = frm.down('#typeFeePercentheaderPanel');
											   var container = obj.up('fieldcontainer');
											   receiptPanel.remove(container);
											   if(getform.hasInvalidField()==false)
												  {
												  form.down('#SubmitBtn').setDisabled(false);
												  }else
													  {
													  form.down('#SubmitBtn').setDisabled(true);
													  }
											   getform.isValid();
											   frm.doLayout();
										   }
									   }
								   }]    
						   };
						   formItems.push(field);
						   var typeFeePercentheaderPanel = form.down('#typeFeePercentheaderPanel');
						   typeFeePercentheaderPanel.add(field);
						   var field = typeFeePercentheaderPanel.items.items;
						   
						   if(financeEvalParamsObject){
							   var financeHoldType =  form.down("#financeHoldType"+obj.id);
							   financeHoldType.getStore().load({
								   callback: function(records, operation, success) {
									   financeHoldType.setValue(obj.financeHoldType);
								   }
							   });
							   var pendingFeePercent =  form.down("#pendingFeePercent"+obj.id);
							   var minimumDueAmount =  form.down("#minimumDueAmount"+obj.id);
							   if(!isNullOrEmpty(obj.pendingFeePercent)){
								   pendingFeePercent.setVisible(true);
								   minimumDueAmount.setVisible(false);
								   pendingFeePercent.setValue(obj.pendingFeePercent	);  
								   if(!isNullOrEmpty(form.down("#pendingFeePercentId"+obj.id))){
									   form.down("#pendingFeePercentId"+obj.id).setValue(obj.id);  
								   }
								   $this.setAllowBlank(minimumDueAmount,true);
							   }else{
								   pendingFeePercent.setVisible(false);
								   minimumDueAmount.setVisible(true);
								   minimumDueAmount.setValue(obj.minimumDueAmount);
								   if(!isNullOrEmpty(form.down("#minimumDueAmountId"+obj.id))){
									   form.down("#minimumDueAmountId"+obj.id).setValue(obj.id);
								   }
								   $this.setAllowBlank(pendingFeePercent,true);
							   }
							   form.down("#financeHoldTypeId"+obj.id).setValue(obj.id);
							   
						   } 
						   $this.setAllowBlank(financeHoldType,false);
						   if(obj.isBlockedStudent == true){
							   financeHoldType.setReadOnly(true); 
							   pendingFeePercent.setReadOnly(true);
							   form.down("#financeHoldStatus").setReadOnly(true);
							   form.down("#cutOffDate").setReadOnly(true);
							   form.down("#delBtnInEditView"+obj.id).setDisabled(true);
						   }
					   }
					   else{
						   if(financeEvalParamsObject){
							   var financeHoldType =  form.down("#financeHoldType");
							   financeHoldType.getStore().load({
								   callback: function(records, operation, success) {
									   financeHoldType.setValue(obj.financeHoldType);
								   }
							   });
							   var pendingFeePercent =  form.down("#pendingFeePercent");
							   var minimumDueAmount =  form.down("#minimumDueAmount");
							   if(!isNullOrEmpty(obj.pendingFeePercent)){
								   $this.setAllowBlank(minimumDueAmount,true);
								   pendingFeePercent.setVisible(true);
								   minimumDueAmount.setVisible(false);
								   pendingFeePercent.setValue(obj.pendingFeePercent	);
								   if(!isNullOrEmpty(form.down("#pendingFeePercentId"))){
									   form.down("#pendingFeePercentId").setValue(obj.id);
								   }
							   }else{
								   $this.setAllowBlank(pendingFeePercent,true);
								   pendingFeePercent.setVisible(false);
								   minimumDueAmount.setVisible(true);
								   minimumDueAmount.setValue(obj.minimumDueAmount);
								   if(!isNullOrEmpty(form.down("#minimumDueAmountId"))){
									   form.down("#minimumDueAmountId").setValue(obj.id);   
								   }
							   }
							   form.down("#financeHoldTypeId").setValue(obj.id);
						   } 
						   $this.setAllowBlank(financeHoldType,true);
						   if(obj.isBlockedStudent == true){
							   financeHoldType.setReadOnly(true); 
							   pendingFeePercent.setReadOnly(true);
							   minimumDueAmount.setReadOnly(true);
							   form.down("#financeHoldStatus").setReadOnly(true);
							   form.down("#cutOffDate").setReadOnly(true);
							   //form.down("#delBtnInEditView").setDisabled(true);
						   }
					   }
					  
					   
					   
					   i=i+1;
					  
					   form.doLayout();

					   /*var btnAddTypeFeePercent = form.down("#btnAddTypeFeePercent");
					   var financeHoldType = form.down("#financeHoldType");
					   var pendingFeePercent = form.down("#pendingFeePercent");
					   btnAddTypeFeePercent.setVisible(false);
					   financeHoldType.setVisible(false);
					   pendingFeePercent.setVisible(false);
					   financeHoldType.allowBlank=true;
					   pendingFeePercent.allowBlank=true;*/
					   

				   });	

			   }
		   });
	   }else{
		   showWarningMessage(getFeeAndPaymentCommonTranslation('FINANCE_HOLD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	   }
  },
  openFinanceBlockedStudentTab:function(){
	  var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	  var structure = Ext.widget('financeholdlistofblockedstudentstructure');
	  var tabName = getFeeAndPaymentCommonTranslation('BLOCKED_STUDENTS');
	  /**
	   * This is to remove tab from content panel and open same tab again
	   */
	  var getcontroller=this.getController('menu.CoreERPNavigationController');
	  var getTab=getcontroller.getTab(tabName);
	  if(getTab!=null){
		  contentPanel.remove(getTab, true);
	  }
	  openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);
	  var grid = this.getManagefinanceholdgrid();
  	  var records = grid.getSelectionModel().getSelection()[0];
	  var financeBlockedStudentGrid = this.getFinanceholdblockedstudentgrid();
	  var store = financeBlockedStudentGrid.getStore();
	  store.removeAll();
	  store.currentPage = 1;
	  store.getProxy().extraParams = {
		  financeHoldId: records.data.financeHoldId,
	  };
	  store.clearFilter();
      store.load();
  },
  //**********View getMappedProgramsGridWindow ************//
  openMappedProgramsGridWindow : function(grid,record){
	  var $this=this;
	  var id = record.get("financeHoldId");

	  var formWindow = this.getFinancemappedprogramwindow();
	          if (!formWindow) {
	            Ext.widget('financemappedprogramwindow');
	            formWindow = this.getFinancemappedprogramwindow();
	          }
	          formWindow.show();
	        
	        var store = this.getStore('feeandpayment.finance.FinanceHoldPBSFindByGridListing');
	        store.getProxy().extraParams = {
	        	financeHoldId: id
		  };
	        $this.resetPageSetting(store);
	        store.load();
  },
  //**********View getFinanceHoldCountGridWindow ************//
  openFinanceHoldCountWindow : function(grid,record){
	  var $this=this;
	  var id = record.get("financeHoldId");
	  var formWindow = this.getFinanceholdtypewindow();
	  if (!formWindow) {
		  Ext.widget('financeholdtypewindow');
		  formWindow = this.getFinanceholdtypewindow();
	  }
	  formWindow.show();
	  var countPercentGrid = formWindow.down('#billHeaderGridWithPercent');
	  var countAmountGrid = formWindow.down('#billHeaderGridWithAmount');
	  if(record.get("financeApplicableOn") == 'DUE_FEES_PERCENTAGE'){
		  countPercentGrid.setVisible(true);
	  }else{
		  countAmountGrid.setVisible(true);
	  }
	 
	  var store = this.getStore('feeandpayment.finance.FinanceHoldTypeCountList');
	  store.getProxy().extraParams = {
		  id: id
	  };
	  $this.resetPageSetting(store);
	  store.load({
		  callback: function(records, operation, success) {
		   }
	  });
  },
  
  
  //************ disableMoreActionPivileges****************  
  disableMoreActionPivileges: function(gridReference,permissionsMap) {
  	
  	var associatedAcadLocationIds = new Array();
	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

    var applyToBtn = gridReference.down('#applyToBtn');
    var unBlock = gridReference.down('#unblockBtn');

    if(!isNullOrEmpty(applyToBtn)){
			applyToBtn.setVisible(false);
		} 
    if(!isNullOrEmpty(unBlock)){
    	unBlock.setVisible(false);
		} 
    
  	Ext.each(permissionList, function(privilege) {
  		if (privilege === 'APPLICABLEFOR') {
      		if(!isNullOrEmpty(applyToBtn)){
      			applyToBtn.setVisible(true);
      		}        		
      	}
  		if (privilege === 'UNBLOCK') {
      		if(!isNullOrEmpty(unBlock)){
      			unBlock.setVisible(true);
      		}        		
      	}
  	});
  },
  setFinanceHoldDataSetting: function() {
	  var $this=this,form = this.getManagefinanceholdaddform();
	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	  Ext.Ajax.request({
		  type: 'rest',
		  url: SERVERURL.PATH_FIND_ENTITY_SETTING_BY_TABLE_NAME,                            
		  method: 'GET',
		  params: {
			  tableName: 'finance_hold'
		  },
		  success: function(response) {
			  var response =  Ext.JSON.decode(response.responseText);
			  Ext.Ajax.request({
				  type: 'rest',
				  url: SERVERURL.FIND_BY_ENTITY_ID,                          
				  method: 'GET',
				  params: {
					  entityId: response
				  },
				  success: function(response) {
					  if(!isNullOrEmpty(response.responseText)){
						  var responseObject =  Ext.JSON.decode(response.responseText);
						  if(!isEmpty(responseObject)){
							  var financeHoldId = form.down("#financeHoldId");
							  if(responseObject.whetherManualId){
								  financeHoldId.setReadOnly(false);
								  $this.setAllowBlank(financeHoldId,false);  
								  $this.setFieldPlaceHolder(financeHoldId,'');
								  financeHoldId.emptyText=' ';
								  financeHoldId.applyEmptyText();
							  }else{
								  financeHoldId.setReadOnly(true);
								  $this.setAllowBlank(financeHoldId,true);
								  $this.setFieldPlaceHolder(financeHoldId,getCommonTranslation('ID_AUTOGENERATE'));
								  financeHoldId.applyEmptyText();
							  }
						  }
					  }   
					  Ext.getBody().unmask(); 
				  },
				  failure:function(){
					  Ext.getBody().unmask(); 
				  }	            
			  });
		  },
		  failure:function(){
			  Ext.getBody().unmask(); 
		  }
	  });
  },
  toggleHoldTypeOptions: function(boundList) {
	  if (boundList.up) {
		  var combo = boundList.up('combobox');
		  var comboStore = combo.getStore();
		  var allItems = boundList.all.elements;
		  var holdVals = combo.up('form').getValues().financeHoldType;
		  if(!isNullOrEmpty(holdVals) && Ext.isArray(holdVals)) {
			  var indexes = getAllIndexes(holdVals, "");
			  for(var cnt = 0; cnt < indexes.length; cnt++) {
				  holdVals.splice(indexes[cnt], 1);
			  }
			  Ext.each(allItems, function (currentItem) {
				  var currentHoldTypeId = currentItem.viewRecordId;
				  var currentHoldTypeRecord = comboStore.findRecord('id', currentHoldTypeId);
				  if (holdVals.indexOf('RESULT_PUBLISH') != -1 && Ext.Array.contains(combo.newHoldTypes, currentHoldTypeRecord.get('id'))) {
					  currentItem.classList.add("disabledComboItem");
				  } else {
					  //currentItem.classList.remove("disabledComboItem");
					  for(var i = 0; i < holdVals.length; i++) {
						  if(Ext.Array.contains(combo.newHoldTypes, holdVals[i]) && currentHoldTypeRecord.get('id') == 'RESULT_PUBLISH') {
							  currentItem.classList.add("disabledComboItem");
						  }
						  else {
							  currentItem.classList.remove("disabledComboItem");
						  }
					  }
				  }
			  });
		  }
		  else {
			  Ext.each(allItems, function (currentItem) {
				  currentItem.classList.remove("disabledComboItem");
			  });
		  }
	  }
  }
});
