/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.managehostel.ManageHostelController', {
	extend : 'Academia.controller.base.BaseController',

	models : ['hostel.managehostel.hostel.ManageHostelSaveM','hostel.managehostel.building.ManageBuildingSaveM',
	          'hostel.managehostel.hostel.HostelAddressDetails','hostel.managehostel.floor.ManageFloorDetailsM',
	          'hostel.managehostel.room.ManageRoomDetailsM'],
	
	stores : ['hostel.managehostel.hostel.HostelCodeName','scholarships.Status','hostel.managehostel.building.BuildingCodeName','common.CountryStore',
	          'organization.AddressTypeStore','organization.CityStore','organization.CountryRegionStore','organization.CountryRegionStore1',
	          'hostel.managehostel.hostel.ManageHostelGrid','hostel.managehostel.hostel.NoOfBuildingsGrid','hostel.managehostel.building.ManageBuildingGrid',
	          'hostel.managehostel.hostel.RestrictionType','hostel.managehostel.hostel.LinkedAcademyLocations',
	          'hostel.managehostel.hostel.Ownership','hostel.managehostel.hostel.HostelDocument',
	          'hostel.managehostel.building.FloorsCountList','hostel.managehostel.floor.ManageFloorGrid',
	          'hostel.managehostel.floor.RoomCountList','hostel.managehostel.room.ManageRoomDetails',
	          'hostel.managehostel.floor.RoomCodeName','hostel.managehostel.floor.FloorCodeName','hostel.manageroomtype.RoomType',
	          'hostel.managehostel.room.BedCountList','criteriabuilder.userquicksearch.QuickSearchName','hostel.managehostel.room.RoomDetailsStatus',
	          'hostel.managehostel.room.StatusChangeReason','importutility.ImportReceipts','importutility.ModuleName',
	          'hostel.importhostel.ImportBedHostel','organization.CityByCountryRegion','hostel.manageroomtype.ActiveRoomType',
	          'feeandpayment.discount.UserSmartSearchByUserCode','hostel.managehostel.room.RoomDetailSeatTypeStore'
	          ,'hostel.managehostel.hostel.SubWardenStore','scholarships.AccountYearStore','common.AcademicTermStore'],
	          
	views : ['hostel.managehostel.ManageHostelStructure','hostel.managehostel.ManageHostelSearch',
	         'hostel.managehostel.ManageHostelGrid','hostel.managehostel.hostel.EditHostelDetails',
	         'enquiry.student.StudentAddressFormWindow','hostel.managehostel.building.BuildingGrid',
	         'hostel.managehostel.hostel.NoOfBuildingsWin','hostel.managehostel.hostel.NoOfBuildingsGrid',
	         'hostel.managehostel.hostel.LinkedAcademyLocation','hostel.managehostel.hostel.HostelDocument',
	         'hostel.managehostel.building.EditBuildingDetails','hostel.managehostel.building.FloorsWinCount',
	         'hostel.managehostel.building.FloorsCountList','hostel.managehostel.floor.ManageFloorGrid',
	         'hostel.managehostel.floor.RoomWinCount','hostel.managehostel.floor.RoomCountList',
	         'hostel.managehostel.floor.EditFloorDetails','hostel.managehostel.room.ManageRoomDetailsGrid',
	         'hostel.managehostel.room.BedCounWin','hostel.managehostel.room.BedCountList',
	         'hostel.managehostel.room.EditRoomDetails','hostel.importhostel.ImportDownloadHostelForm',
	         'hostel.importhostel.DownloadHostelBedForm','importutility.ImportByModule.ImportListReceipts',
	         'hostel.importhostel.ImportHostelBedForm','hostel.importhostel.ImportListHostelBed',
	         'UploadOptionRadioGroup','hostel.managehostel.ManageHostelStructureNew','hostel.managehostel.hostel.HostelCapacityPlanWin'
	         ],
	         
	         config: {
	        	 MANAGE_HOSTEL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_MANAGE_HOSTEL_PRIVILEGES'),
	        	 CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES')
	         },
	         
	         refs :[{
	        	 ref : 'managehostelstructure',
	        	 selector : 'managehostelstructure'
	         },{
	        	 ref : 'managehostelsearch',
	        	 selector : 'managehostelsearch'
	         },{
	        	 ref : 'managehostelgrid',
	        	 selector : 'managehostelgrid'
	         },{
	        	 ref : 'buildinggrid',
	        	 selector : 'buildinggrid'
	         },{
	        	 ref : 'managefloorgrid',
	        	 selector : 'managefloorgrid'
	         },{
	        	 ref : 'manageroomdetailsgrid',
	        	 selector : 'manageroomdetailsgrid'
	         },{
	        	 ref : 'edithosteldetails',
	        	 selector : 'edithosteldetails'
	         },{
	        	 ref : 'editbuildingdetails',
	        	 selector : 'editbuildingdetails'
	         },{
	        	 ref : 'editfloordetails',
	        	 selector : 'editfloordetails'
	         },{
	        	 ref : 'editroomdetails',
	        	 selector : 'editroomdetails'
	         },{
	        	 ref: 'hostelManageAddress',
	        	 selector: 'studentaddress[itemId=hostelManageAddress]'   
	         },{
	        	 ref: 'hostelManageAddressForm',
	        	 selector: 'studentaddress[itemId=hostelManageAddress] form'   
	         },{
	        	 ref : 'noofbuildingswin',
	        	 selector : 'noofbuildingswin'
	         },{
	        	 ref : 'noofBuildingswin',
	        	 selector : 'noofbuildingswin form'
	         },{
	        	 ref : 'floorswincount',
	        	 selector : 'floorswincount'
	         },{
	        	 ref : 'floorsWincount',
	        	 selector : 'floorswincount form'
	         },{
	        	 ref : 'roomwincount',
	        	 selector : 'roomwincount'
	         },{
	        	 ref : 'roomWincount',
	        	 selector : 'roomwincount form'
	         },{
	        	 ref : 'bedcounwin',
	        	 selector : 'bedcounwin'
	         },{
	        	 ref : 'bedCounwin',
	        	 selector : 'bedcounwin form'
	         },{
	        	 ref : 'noofbuildingsgrid',
	        	 selector : 'noofbuildingsgrid'
	         },{
	        	 ref : 'floorscountlist',
	        	 selector : 'floorscountlist'
	         },{
	        	 ref : 'roomcountlist',
	        	 selector : 'roomcountlist'
	         },{
	        	 ref : 'bedcountlist',
	        	 selector : 'bedcountlist'
	         },{
	        	 ref : 'linkedacademylocation',
	        	 selector : 'linkedacademylocation'
	         },{
	        	 ref : 'linkedacademylocationgrid',
	        	 selector : 'linkedacademylocation grid'
	         },{
	        	 ref : 'hosteldocument',
	        	 selector : 'hosteldocument'
	         },{
	        	 ref : 'contentPanel',
	        	 selector : 'contentPanel'
	         },{
	        	 ref:'importListForHostel',
	        	 selector:'importlisthostelbed[itemId=importListHostelItemId]'
	         },{
	        	 ref: 'uploadoptionradiogroup',
	        	 selector: 'uploadoptionradiogroup[itemId=importhostelbedUploadOptionRadioGroupItemId]'
	         },{
	        	 ref: 'importhostelbedform',
	        	 selector: 'importhostelbedform'
	         },{
	        	 ref:'hostelCapacityPlanWin',
	        	 selector:'hostelCapacityPlanWin'
	         }],

	init : function() {
		this.control({
			'edithosteldetails':{
				afterrender:function(form){
					var hostelTypeItemId =form.down('#hostelTypeItemId');
					var clusterCodeItemId = form.down('#clusterCodeItemId');
					var hostelLevelItemId = form.down('#hostelLevelItemId');
					var hostelCategoryItemId = form.down('#hostelCategoryItemId');
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						url: SERVERURL.COMMON_FORM_FIELD_INFO,
						params: {
							//screenName: 'resourcebasicdetails',
							academyLocationId: this.getCurrentAcademyLocation(),
							languageCode:'en'
						},
						method: 'GET',
						success: function(res, action) {
							var response = Ext.decode(res.responseText);
							if( Object.keys(response).length > 0 ){
								var records=response.resourcebasicdetails;
								var allowblankFalse = '<span class="required" style="color:red"> *</span>'; 
								for(i in records){
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isVisible==true){
										clusterCodeItemId.setVisible(true);
										clusterCodeItemId.setFieldLabel(records[i].formFieldLabel +':')
										
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isMandatory==true){
										clusterCodeItemId.allowBlank=false;
										clusterCodeItemId.setFieldLabel(records[i].formFieldLabel +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='clusterCode' && records[i].isMandatory==true && records[i].isVisible==false){
										clusterCodeItemId.allowBlank=true;
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isVisible==true){
										hostelTypeItemId.setVisible(true);
										hostelTypeItemId.setFieldLabel(records[i].formFieldLabel +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isMandatory==true){
										hostelTypeItemId.allowBlank=false;
										hostelTypeItemId.setFieldLabel(records[i].formFieldLabel +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelType' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelTypeItemId.allowBlank=true;
									}
									
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isVisible==true){
										hostelLevelItemId.setVisible(true);
										hostelLevelItemId.setFieldLabel(records[i].formFieldLabel +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isMandatory==true){
										hostelLevelItemId.allowBlank=false;
										hostelLevelItemId.setFieldLabel(records[i].formFieldLabel +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelLevel' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelLevelItemId.allowBlank=true;
									}
									
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isVisible==true){
										hostelCategoryItemId.setVisible(true);
										hostelCategoryItemId.setFieldLabel(records[i].formFieldLabel +':')
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isMandatory==true){
										hostelCategoryItemId.allowBlank=false;
										hostelCategoryItemId.setFieldLabel(records[i].formFieldLabel +allowblankFalse)
									}
									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='hostelCategory' && records[i].isMandatory==true && records[i].isVisible==false){
										hostelCategoryItemId.allowBlank=true;
									}

								}
							}else{
								clusterCodeItemId.setVisible(false);
								hostelTypeItemId.setVisible(false);
								hostelLevelItemId.setVisible(false);
								hostelCategoryItemId.setVisible(false);
								clusterCodeItemId.allowBlank=true;
								hostelTypeItemId.allowBlank=true;
								hostelLevelItemId.allowBlank=true;
								hostelCategoryItemId.allowBlank=true;
							}
						}

					});
					 var associatedAcadLocationIds = new Array();
				        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getMANAGE_HOSTEL_PRIVILEGES());
				        var editHostelCapacityBtn =form.down('#editHostelCapacityBtn');
				      editHostelCapacityBtn.setVisible(false)
				        permissionList.forEach(function(btnName){
				        	if(btnName == 'MANAGE_CAPACITY'){
				        		 editHostelCapacityBtn.setVisible(true);
				        	}
				        });
				        
				}
			},
			'managehostelsearch':{
				render: function(obj){
//					var form = obj.up('form');
					var form = this.getManagehostelsearch();
					var hostelCodeName  = form.down('#hostelCodeName');
					var buildingCodeName  = form.down('#buildingCodeName');
					var floorCodeNoField  = form.down('#floorCodeNo');
					var roomNoField  = form.down('#roomNo');
					
					var buildingCodeStore =  buildingCodeName.getStore();
					var floorCodeNo = floorCodeNoField.getStore();
					var roomNo = roomNoField.getStore();

					var values = form.getForm().getValues();
					hostelCodeName.getStore().getProxy.extraParams = {
						academyLocationId:this.getCurrentAcademyLocation()
					}
					hostelCodeName.getStore().load();
					
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:values.hostelCodeName,
							status:values.status,
							resourceGroup:'Building'
						};
						buildingCodeStore.load();
						
						floorCodeNo.getProxy().extraParams = {
							buildingCode:values.floorCodeNo,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeNo.load();
						
						roomNo.getProxy().extraParams = {
							floorCode:values.roomNo,
							status:values.status,
							resourceGroup:'Room'
						};
						roomNo.load();
				}
			},
			
			'managehostelsearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					var buildingCodeStore =  buildingCodeName.getStore();

					var values = form.getForm().getValues();
					
					/*if(values.hostelType == 'BUILDING' || values.hostelType == 'FLOOR' || 
							values.hostelType == 'ROOM'){*/
						buildingCodeStore.getProxy().extraParams = {
							hostelCode:hostelCode,
							status:values.status
						};
						buildingCodeStore.load();
//					}
				}
			},
			'managehostelsearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					var floorCodeStore =  floorCodeName.getStore();
					floorCodeName.setDisabled(false);

					var values = form.getForm().getValues();
					
					if(values.hostelType == 'FLOOR' || values.hostelType == 'ROOM'){
						floorCodeStore.getProxy().extraParams = {
							buildingCode:buildingCode,
							status:values.status,
							resourceGroup:'Floor'
						};
						floorCodeStore.load();
					}
				}
			},
			'managehostelsearch customcombobox[itemId=floorCodeNo]':{
				select: function(obj,record){
					var form = obj.up('form');
					var floorCode = record[0].get("id");
					var roomNoField  = form.down('#roomNo');
					var roomStore =  roomNoField.getStore();

					var values = form.getForm().getValues();
					
					if(values.hostelType == 'ROOM'){
						roomStore.getProxy().extraParams = {
							floorCode:floorCode,
							status:values.status,
							resourceGroup:'Room'
						};
						roomStore.load();
					}
					roomNoField.setDisabled(false);
				}
			},
			'managehostelsearch customcombobox[itemId=statusId]':{
				select: function(obj,record){
					var form = obj.up('form');
					var roomNoField  = form.down('#roomNo');
					var roomStore =  roomNoField.getStore();
					var values = form.getForm().getValues();
					if(values.hostelType == 'ROOM'){
						roomStore.getProxy().extraParams = {
							status:values.status,
							resourceGroup:'Room'
						};
						roomStore.load();
					}
				}
			},
			'managehostelsearch radiogroup[itemId=hostelType]':{
				change:function(obj,record){
					this.changeHostelType(obj,record);
				}
			},
			'managehostelsearch button[itemId=searchBtn]':{
				click:function(obj){
					this.searchManageHostel(obj);
				}
			},
			'managehostelsearch button[itemId=resetBtn]':{
				click:function(obj){
					var form = obj.up('form');
					this.resetManageHostel(form);
				}
			},
			
			'managehostelgrid button[itemId=btnEdit]':{
				click:function(){
					this.editHostelDetails('EDIT');
				}
			},
			'managehostelgrid button[itemId=btnView]':{
				click:function(){
					var view ='HOSTEL';
					this.viewHostelDetails(view,'VIEW');
				}
			},
			
			'buildinggrid button[itemId=btnEdit]':{
				click:function(){
					this.editHostelDetails('EDIT');
				}
			},
			'buildinggrid button[itemId=btnView]':{
				click:function(){
					var view ='BUILDING';
					this.viewHostelDetails(view,'VIEW');
				}
			},
			
			'managefloorgrid button[itemId=btnEdit]':{
				click:function(){
					this.editHostelDetails('EDIT');
				}
			},
			'managefloorgrid button[itemId=btnView]':{
				click:function(){
					var view ='FLOOR';
					this.viewHostelDetails(view,'VIEW');
				}
			},
			
			'manageroomdetailsgrid button[itemId=btnEdit]':{
				click:function(){
					this.editHostelDetails('EDIT');
				}
			},
			'manageroomdetailsgrid button[itemId=btnView]':{
				click:function(){
					var view ='ROOM';
					this.viewHostelDetails(view, 'VIEW');
				}
			},
			'managehostelgrid':{
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				 var managehostelgrid = this.getManagehostelgrid();
    				 var columnName=managehostelgrid.columnManager.columns[cellIndex].dataIndex;

    				 if(columnName=='noOfBuilings'){
    					 if (e.target.tagName == 'A') {
    						 this.openListOfBuildingsWin(grid, rowIndex, record);
    					 }
    				 }

    			 },
    			 render:function(grid){
 					this.doAccessControlValidation(grid, this.getMANAGE_HOSTEL_PRIVILEGES());
 					grid.getStore().getProxy().extraParams = {
 						resourceGroup:'Hostel'
 					};
 				}
			},
			'buildinggrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var managehostelgrid = this.getBuildinggrid();
					var columnName=managehostelgrid.columnManager.columns[cellIndex].dataIndex;

					if(columnName=='noOfFloors'){
						if (e.target.tagName == 'A') {
							this.openListOfFloorsWin(grid, rowIndex, record);
						}
					}
				},
				render:function(grid){
					this.doAccessControlValidation(grid, this.getMANAGE_HOSTEL_PRIVILEGES());
					grid.getStore().getProxy().extraParams = {
 						resourceGroup:'Building'
 					};
				}
			},
			'managefloorgrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var managehostelgrid = this.getManagefloorgrid();
					var columnName=managehostelgrid.columnManager.columns[cellIndex].dataIndex;

					if(columnName=='noOfRooms'){
						if (e.target.tagName == 'A') {
							this.openListOfRoomWin(grid, rowIndex, record);
						}
					}
				},
				render:function(grid){
					this.doAccessControlValidation(grid, this.getMANAGE_HOSTEL_PRIVILEGES());
					grid.getStore().getProxy().extraParams = {
 						resourceGroup:'Floor'
 					};
				}
			},
			'manageroomdetailsgrid':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var managehostelgrid = this.getManageroomdetailsgrid();
					var columnName=managehostelgrid.columnManager.columns[cellIndex].dataIndex;

					if(columnName=='noOfBeds'){
						if (e.target.tagName == 'A') {
							this.openListOfBedWin(grid, rowIndex, record);
						}
					}
				},
				render:function(grid){
					this.doAccessControlValidation(grid, this.getMANAGE_HOSTEL_PRIVILEGES());
					grid.getStore().getProxy().extraParams = {
 						resourceGroup:'Room'
 					};
				}
			},
			'edithosteldetails button[itemId=viewAcademyLocation]':{
				click:function(){
					this.showViewLinkedAcademyLocation();
				}
			}, 
			'hosteldocument' : {
   			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
 				  var $this = this;
 				  var documentGrid = $this.getHosteldocument();
 				  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

 				  if (columnName == "documentName") {
 					  if (e.target.tagName == 'A') {
 						  var documentId = record.get("documentId");
 						  if (!isNullOrEmpty(documentId)) {
 							  $this.getDocumentController().downloadDocumentFile(documentId);
 						  }
 					  }
 				  }
			 }
		 },
		 'edithosteldetails customcombobox[itemId=ownership]':{
			 select:function(obj,record){
				 var ownership = record[0].get("id");
				 var form = obj.up('form');
				 var leaseEndDate = form.down('#leaseEndDate');

				 if(ownership == "THIRD_PARTY"){
					 leaseEndDate.setVisible(true);
				 }else{
					 leaseEndDate.setVisible(false);
					 leaseEndDate.reset();
				 }
			 }
		 },
			'edithosteldetails button[itemId=saveBtn]':{
				click:this.saveEditHostelDetails
			},
			'edithosteldetails combo[itemId=warden]':{
				render: function(obj){
//					var hostelForm = this.getEdithosteldetails();
					var managehostelgrid = this.getManagehostelgrid();	
					var records = managehostelgrid.getSelectionModel().getSelection()[0];
					var store = obj.getStore();
					store.getProxy().extraParams = {
						resourceId:records.data.resourceId
					};
					store.load();
				}
			},
			'edithosteldetails combo[itemId=subWarden]':{
				render: function(obj){
//					var hostelForm = this.getEdithosteldetails();
					var managehostelgrid = this.getManagehostelgrid();	
					var records = managehostelgrid.getSelectionModel().getSelection()[0];
					var store = obj.getStore();
					store.getProxy().extraParams = {
						resourceId:records.data.resourceId
					};
					store.load();
				}
			},
			'editbuildingdetails combo[itemId=subWarden]':{
				render: function(obj){
					var buildinggrid = this.getBuildinggrid();	
		    		var records = buildinggrid.getSelectionModel().getSelection()[0];
		    	    var store = obj.getStore();
					store.getProxy().extraParams = {
						resourceId:records.data.resourceId
					};
					store.load();
				}
			},
			'edithosteldetails combo[itemId=manager]':{
				render: function(obj){
//					var hostelForm = this.getEdithosteldetails();
					var managehostelgrid = this.getManagehostelgrid();	
					var records = managehostelgrid.getSelectionModel().getSelection()[0];
					var store = obj.getStore();
					store.getProxy().extraParams = {
						resourceId:records.data.resourceId
					};
					store.load();
				}
			},
			
			/*'edithosteldetails button[itemId=cancelBtn]':{
				click:function(obj){
					this.cancelEditHostelDetails(obj);	
				}
			},*/
			'edithosteldetails button[itemId=manageAddress]':{
				click:this.openManageAddress
			},
			'edithosteldetails radiogroup[itemId=entryRulesItemId]':{
 			   change:function(obj,data){
				   var form = obj.up('edithosteldetails');
				   var lastInTimeItemId = form.down("#lastInTimeItemId");
				   var punchStartTimeItemId = form.down("#punchStartTimeItemId");
				   var ruleItemId= form.down("#ruleItemId");
				   var value = obj.getValue();
				   var isGeneral = value.isGeneral;
				   lastInTimeItemId.reset();
				   punchStartTimeItemId.reset();
				   if(isGeneral){
					   lastInTimeItemId.setVisible(true);
					   lastInTimeItemId.allowBlank = false;
					   ruleItemId.setVisible(false);
					   ruleItemId.allowBlank = true;
					   punchStartTimeItemId.setVisible(true);
					   punchStartTimeItemId.allowBank = false ; 
				   }else{
					   lastInTimeItemId.setVisible(false);
					   lastInTimeItemId.allowBlank = true;
					   ruleItemId.setVisible(true);
					   ruleItemId.allowBlank = false;
					   punchStartTimeItemId.setVisible(false);
					   punchStartTimeItemId.allowBank = true ; 
				   }
				   //lastInTimeItemId.validate();
				   Ext.resumeLayouts();
			   },
			   beforerender:function(obj,data){
				   var form = obj.up('edithosteldetails');
				   var lastInTimeItemId = form.down("#lastInTimeItemId");
				   var punchStartTimeItemId = form.down("#punchStartTimeItemId");
				   var ruleItemId= form.down("#ruleItemId");
				   var value = obj.getValue();
				   var isGeneral = value.isGeneral;
				   lastInTimeItemId.reset();
				   punchStartTimeItemId.reset();
				   if(isGeneral){
					   lastInTimeItemId.setVisible(true);
					   lastInTimeItemId.allowBlank = false;
					   ruleItemId.setVisible(false);
					   ruleItemId.allowBlank = true;
					   punchStartTimeItemId.setVisible(true);
					   punchStartTimeItemId.allowBlank = false;
				   }else{
					   lastInTimeItemId.setVisible(false);
					   lastInTimeItemId.allowBlank = true;
					   ruleItemId.setVisible(true);
					   ruleItemId.allowBlank = false;
					   punchStartTimeItemId.setVisible(false);
					   punchStartTimeItemId.allowBlank = true;
				   }
			   }
		   },
			'editbuildingdetails button[itemId=saveBtn]':{
				click:this.saveEditBuildinglDetails
			},
			
			'editbuildingdetails radiogroup[itemId=entryBuildingRulesItemId]':{
	 			   change:function(obj,data){
					   var form = obj.up('editbuildingdetails');
					   var lastInTimeItemId = form.down("#lastInTimeItemId");
					   var punchStartTimeItemId = form.down("#punchStartTimeItemId");
					   var ruleItemId= form.down("#ruleItemId");
					   var value = obj.getValue();
					   var isGeneral = value.isGeneral;
					   lastInTimeItemId.reset();
					   punchStartTimeItemId.reset();
					   if(isGeneral){
						   lastInTimeItemId.setVisible(true);
						   lastInTimeItemId.allowBlank = false;
						   ruleItemId.setVisible(false);
						   ruleItemId.allowBlank = true;
						   punchStartTimeItemId.setVisible(true);
						   punchStartTimeItemId.allowBlank = false;
					   }else{
						   lastInTimeItemId.setVisible(false);
						   lastInTimeItemId.allowBlank = true;
						   ruleItemId.setVisible(true);
						   ruleItemId.allowBlank = false;
						   punchStartTimeItemId.setVisible(false);
						   punchStartTimeItemId.allowBlank = true;
					   }
					   //lastInTimeItemId.validate();
					   Ext.resumeLayouts();
				   },
				   beforerender:function(obj,data){
					   var form = obj.up('editbuildingdetails');
					   var lastInTimeItemId = form.down("#lastInTimeItemId");
					   var punchStartTimeItemId = form.down("#punchStartTimeItemId");
					   var ruleItemId= form.down("#ruleItemId");
					   var value = obj.getValue();
					   var isGeneral = value.isGeneral;
					   lastInTimeItemId.reset();
					   punchStartTimeItemId.reset();
					   if(isGeneral){
						   lastInTimeItemId.setVisible(true);
						   lastInTimeItemId.allowBlank = false;
						   ruleItemId.setVisible(false);
						   ruleItemId.allowBlank = true;
						   punchStartTimeItemId.setVisible(true);
						   punchStartTimeItemId.allowBlank = false;
					   }else{
						   lastInTimeItemId.setVisible(false);
						   lastInTimeItemId.allowBlank = true;
						   ruleItemId.setVisible(true);
						   ruleItemId.allowBlank = false;
						   punchStartTimeItemId.setVisible(false);
						   punchStartTimeItemId.allowBlank = true;
					   }
				   }
			   },
			/*'editbuildingdetails button[itemId=cancelBtn]':{
				click:function(obj){
					this.cancelEditHostelDetails(obj);	
				}
			},*/
			'editfloordetails button[itemId=saveBtn]':{
				click:this.saveEditFloorDetails
			},
			/*'editfloordetails button[itemId=cancelBtn]':{
				click:function(obj){
					this.cancelEditHostelDetails(obj);	
				}
			},*/
			'editroomdetails button[itemId=saveBtn]':{
				click:this.saveEditRoomDetails
			},
			 'hosteldocument button#btnDelete' : {
    			 click : this.deleteHostelDocumentFile
    		 },
			
			/*'editroomdetails button[itemId=cancelBtn]':{
				click:function(obj){
					this.cancelEditHostelDetails(obj);	
				}
			},*/
			'studentaddress[itemId=hostelManageAddress] button[itemId=studentWin_submitbuttonId]':{
				click:this.addHostelAddress
			},
			'studentaddress[itemId=hostelManageAddress]':{
				render:function(obj){
					var $this = this;
					$this.manageHostelAddressType();
				}
			},
  		  'studentaddress[itemId=hostelManageAddress] customcombobox[itemId=countryId]':{
  			select:function(f,r){
  			  var countryId=r[0].data.id;	  
//  			  var store = this.getStore('organization.CityStore');
  			  var store = this.getStore('organization.CountryRegionStore');
    				store.getProxy().extraParams = {
    					cid: countryId
    				};
    				store.load();
  			  }
  		  },
  		 /* 'studentaddress[itemId=hostelManageAddress] customcombobox[itemId=cityId]':{
    			select:function(obj,record){
    			  var form = obj.up('form').getForm();
    			  var countryId=form.findField('country').getValue();
    			  var store = this.getStore('organization.CountryRegionStore');
      				store.getProxy().extraParams = {
      					cid: countryId
      				};
      				store.load();
    			  }
    		  },*/
    		  'studentaddress[itemId=hostelManageAddress] customcombobox[itemId=genericFieldId1]':{
      			select:function(f,r){
      			 var countryRegionId=r[0].data.id;
//          	     var store = this.getStore('organization.CountryRegionStore1');
      			 var store = this.getStore('organization.CityByCountryRegion');
        				store.getProxy().extraParams = {
//        					pid: parentId
        					id: countryRegionId
        				};
        				store.load();
      			  }
          		},
  		  'studentaddress[itemId=hostelManageAddress] button[itemId=studentWin_cancelbuttonId]':{
  			  click:function(obj){
  				  this.getHostelManageAddress().close();
  			  }
  		  },
  		 'edithosteldetails button#uploadDocItemId' : {
			 click : function() {
				 this.getDocumentController().showDocumentFormWindow('hostelDetials','DOCUMENT');
			 }
		 },
  		 'documentformwindow[itemId=hostelDetials] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]' : {
			 click : function() {
				 var $this = this;
				 var isTransient = true;
				 var module = 'hostelDetails';
				 var entityId;
				 var entityType = 'hostelDetails';

				 $this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
						 function(success,response,isCallBackTransient) {
					 var documentModel = new Academia.model.hostel.managehostel.hostel.HostelDocument();
					 documentModel.set("documentName",response.name);
					 documentModel.set("path",response.path);
					 documentModel.set("type",response.type);
//					 documentModel.set("documentName",response.name);
					 documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
//					 var store = $this.getStore('feeandpayment.FeeAndPaymentDocument');
					 var store = $this.getStore('hostel.managehostel.hostel.HostelDocument');
					 store.add(documentModel);
					 $this.getDocumentController().closeDocumentFormWindow();
				 }, isTransient);
			 }
		 },
		 'editroomdetails button[itemId=bedDetailsBtn]':{
			 click: function(){
				 var bedNumber='';
				 var bedDeatails='';
				 var bedDetailsUpdateIds;
				 this.addBedDetails(bedNumber,bedDeatails,bedDetailsUpdateIds);   
			 }
		 },
		 'editroomdetails customcombobox[itemId=status]':{
			 select: function(obj,record){
				 this.roomStatusSelection(obj,record);
			 }
		 },
		 'managehostelstructure importdownloadhostelform radiogroup[itemId=importDownloadgroupId]':{
			 change  : function(obj,newValue,oldValue){
			   var $this = this;
			   var form = obj.up('importdownloadhostelform');	 
               var value = obj.getValue();
               var downloadhostelbedform = form.down('downloadhostelbedform');
               var importhostelbedform = form.down('importhostelbedform');
               var importList = form.down('importlisthostelbed');
               
               downloadhostelbedform.setVisible(false);
               importhostelbedform.setVisible(false);
               importList.setVisible(false);
               
               if(value.downloadUploadTemplate=='forDownloadTemplate'){
            	   downloadhostelbedform.setVisible(true);
               }else if(value.downloadUploadTemplate=='forUploadTemplate'){
            	   $this.doAccessControlValidationForLoader(importhostelbedform,this.getCORE_ERP_LOADER_PERMISSIONS());
            	   var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
       			   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
       			   isUploadAll: false
       			   });
            	   importhostelbedform.setVisible(true);
                   importList.setVisible(true);
               }
			 }
		 },
		 'managehostelstructure importdownloadhostelform downloadhostelbedform button[itemId=hostelBedDownload]':{
			 click:function(obj){
				 var $this = this;
				 var csvForm = Ext.create('Ext.form.Panel'); 
				 csvForm.getForm().submit({
					 target: '_blank',
					 method:'POST',
					 params :{
						 access_token : Ext.Ajax.defaultHeaders.access_token,
						 academyLocationId:$this.getCurrentAcademyLocation()
					 },
					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					 url: SERVERURL.IMPORT_UTILITY_DOWNLOAD_HOSTEL_BED_FILE,
					 standardSubmit :true
				 });
			 }  
		 },
		 'managehostelstructure importdownloadhostelform importhostelbedform button[itemId=SubmitBtn]':{
			 click :this.getHostelBedUploadtemplate
		 },
		 'managehostelstructure importdownloadhostelform importhostelbedform uploadoptionradiogroup[itemId=importhostelbedUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
			 change: function( radioGroup, newValue, oldValue, eOpts){
				  var $this = this;
				  var grid = this.getImportListForHostel();
      		      var isUploadAll = newValue.isUploadAll;
				  this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_HOSTEL_BED_UPLOAD');
			   }
		 },
		 'managehostelstructure importdownloadhostelform importhostelbedform button[itemId=resetBtn]':{click:function(obj){
			 var $this=this;
			 var form = $this.getImporthostelbedform().getForm();
			 form.findField('file').reset();
			 var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
			 uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				 isUploadAll: false
			 });
			 form.isValid();
		 },},
		 'managehostelstructure importdownloadhostelform importhostelbedform combo[itemId=moduleName]':{
			 afterrender : function(obj){
				 var store = obj.getStore();
				 store.load({
					 callback: function(records, operation, success) {
						 if (success) {
							 // V2D-25709
							 //obj.setReadOnly(true);
							 //obj.setValue(record[10].get('id'));
							 for(var i in records){
								 if(records[i].data.value=='Bulk Hostel Bed'){
									 obj.setValue(records[i].data.id);
									 obj.setReadOnly(true);
									 break;
								 }
							 }
						 }
					 }
				 });
			 }
		 },
		 'managehostelstructure importdownloadhostelform importlisthostelbed[itemId=importListHostelItemId]':{
			 render : function() {
				 var $this = this;
				 var grid = this.getImportListForHostel();
				 var form  = $this.getUploadoptionradiogroup();
				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
				 this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_HOSTEL_BED_UPLOAD');
			 },
			 afterrender : this.loadImportHostelBedGrid,
			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				 if (e.target.tagName == 'A') {
					 var fileType=null;
					 if(cellIndex==1){
						 fileType='successFile';
					 }else if(cellIndex==6){
						 fileType='errorFile';
					 }else if(cellIndex==7){
						 fileType='logFile';
					 }
					 var documentId = record.get("id");
					 if (!isNullOrEmpty(documentId)) {
						 this.getHostelBadDownloadFile(documentId,fileType);
					 }
				 }
			 }
		 },
		 'managehostelstructure importdownloadhostelform importlisthostelbed[itemId=importListHostelItemId] button[itemId=btnForce]':{
			 click : function(obj) {
				 var grid = this.getImportListForHostel();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		if(grid.getSelectionModel().getCount() > 1){
		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		        		}else{
		        			var this$ = this;
 	                	var id = grid.getSelectionModel().selectionStart.data.id;
 	                	var urlAppend="?jobName="+id;
 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
 	    	        	Ext.Ajax.request({
 	    	        		url: submitURL,
 	    	        		method: 'GET',
 	    	        		success: function(response) {
 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
 	    	        				//console.log("Manual trigger hit");
 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
 	    	        			}else if(response.responseText==="SUCCESS"){
 	    	        				//console.log("Manual trigger hit");
     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
 	    	        			}
 	    	        		}
 	    	        	});
		        		}
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
			 },
			 'managehostelstructure' : {
				  render:function(structure){
					  this.disableManageHostelBedImportTab(structure, this.getMANAGE_HOSTEL_PRIVILEGES()); 
				 },
				 afterrender : function(structure){
					 var $this = this;
					 structure.body.on('scroll', function(e, target) {
						 var formData =  $this.getManagehostelsearch().down('#hostelType');
						   var valu = formData.getValue();
						   if(valu.hostelType == "HOSTEL"){
						   var pcstructure = structure.down("managehostelgrid");	   
						   }else if(valu.hostelType == "BUILDING"){
						   var pcstructure = structure.down("buildinggrid");   
						   }else if(valu.hostelType == "FLOOR"){
						   var pcstructure = structure.down("managefloorgrid");   
						   }else if(valu.hostelType == "ROOM"){
						   var pcstructure = structure.down("manageroomdetailsgrid");   
						   }
		   				  var academyLocationId = $this.getCurrentAcademyLocation();
		   				  var grid = null;
		   				  
		   				  if(!pcstructure.isHidden()){
		   					  grid = pcstructure;
		   				  }
		   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
						 });
				 }
			 },
				'edithosteldetails button[itemId=editHostelCapacityBtn]':{
					click:function(){
						this.getHostelCapacityRecord();
						
					}
				},
				'hostelCapacityPlanWin button[itemId=addMoreCapacity]':{
					click:function(){
						this.addMoreCapacityRow();
					}
				},
				'hostelCapacityPlanWin button[itemId=deleteCapacityBtn]':{
				click:this.deletecapacityPanelFld
			},
				'hostelCapacityPlanWin numberfield[itemId=totalCapacity]':{
				change:function(cmp,val){
					var me = this,
					capacityForm = me.getHostelCapacityPlanWin(),
					totalCapacityOccupied= cmp.nextSibling(),
					totalCapacityLeft= cmp.nextSibling().nextSibling();
					totalCapacityLeft.setValue(val-totalCapacityOccupied.getValue());
					if(val < totalCapacityOccupied.getValue()){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('TOTALCAPACITY_IS_NOT_LESS_TOTAL_CAPACITY_OCCUPIED'));
					}
				}
			},
				'hostelCapacityPlanWin button[itemId=CancelBtn]':{
				click:function(btn){
					btn.up('window').close();
				}
			},
				'hostelCapacityPlanWin button[itemId=hostelCapacitySubmitBtn]':{
				click:this.saveHostelCapacity
			},
				'hostelCapacityPlanWin customcombobox[itemId=accountYearId]':{
				select:function(cmp){
					cmp.nextSibling().nextSibling().setValue(0);
					cmp.nextSibling().fireEvent('change',cmp.nextSibling(),cmp.nextSibling().getValue());
				}
			}
		});
	},
	getHostelBadDownloadFile : function(documentId,fileType){
		if(!isNullOrEmpty(documentId)){
			var csvForm = Ext.create('Ext.form.Panel'); 
			csvForm.getForm().submit({
				target: '_blank',
				method:'POST',
				params :{
					access_token : Ext.Ajax.defaultHeaders.access_token
				},
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
				standardSubmit :true
			});
		}
	},
	getHostelBedUploadtemplate:function(obj){
    	var temForm = obj.up('importhostelbedform');
    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
    	var $this=this;
    	var grdStore;
    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
        $this.getHashOfFile(temForm);
        setTimeout(function() {
	    	temForm.getForm().submit({
	    		method : 'POST',
	    		url : submitUrl,
	    		success : function(form, action){
		        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		        	//temForm.getForm().isValid();
		        	obj.setDisabled(true);
	    		},
	    		failure: function(form, action) {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	    	    }
	    	});
    	},1000);
    	Ext.defer(function() {
    		$this.loadImportHostelBedGrid();
    	}, 2000, this);
    },
    loadImportHostelBedGrid : function(){
    	var $this = this;
    	var grid = $this.getImportListForHostel();
    	var form  = $this.getUploadoptionradiogroup();
        var isUploadAll = form.items.items[0].getValue().isUploadAll;
        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_HOSTEL_BED_UPLOAD');
    	/*var store = grid.getStore();
    	store.getProxy().extraParams = {
    		moduleName:'BULK_HOSTEL_BED_UPLOAD'
    	};
    	store.load();*/
    },
	changeHostelType:function(obj,record){
		var mngHostelStructure = this.getManagehostelstructure();
		var managehostelgrid = mngHostelStructure.down('#managehostelgrid');
		var buildinggrid = mngHostelStructure.down('#buildinggrid');
		var managefloorgrid = mngHostelStructure.down('#managefloorgrid');
		var manageroomdetailsgrid = mngHostelStructure.down('#manageroomdetailsgrid');
		var grid;
		
		var hostelType = record.hostelType;
		var form = obj.up('form');
		var buildingCodeName = form.down('#buildingCodeName');
		var floorCodeNo = form.down('#floorCodeNo');
		var roomType = form.down('#roomType');
		var roomNo = form.down('#roomNo');
		var hostelCombo = form.down('#hostelCodeName');
		var statusCombo = form.down('#statusId');
		
		
		if(hostelType == 'BUILDING'){
			var  contentPanelMain = this.getContentPanel().getActiveTab().getActiveTab();
    		if(!isNullOrEmpty(contentPanelMain)){
    			contentPanelMain.scrollBy(0,1);
    			contentPanelMain.scrollBy(0,-1);
    		}
			
			var buildingCodeNameField  = form.down('#buildingCodeName');
			var buildingCodeStore =  buildingCodeNameField.getStore();
			
			

			var values = form.getForm().getValues();
			var hostelCode = values.hostelCodeName;
			hostelCombo.reset();
			buildingCodeNameField.reset();
			buildingCodeName.reset();
			roomType.reset();
			roomNo.reset();
			floorCodeNo.reset();
			statusCombo.reset();
//			if(!isNullOrEmpty(hostelCode)){
				
				buildingCodeStore.getProxy().extraParams = {
					//hostelCode:hostelCode,
					status:'ACTIVE',
					resourceGroup:'Building'
				};
				buildingCodeStore.load();
//			}
			
			grid=buildinggrid;
			buildingCodeName.setVisible(true); 
			managehostelgrid.setVisible(false);
			buildinggrid.setVisible(true);
			manageroomdetailsgrid.setVisible(false);
			managefloorgrid.setVisible(false);
			floorCodeNo.setVisible(false);
			roomType.setVisible(false);
			roomNo.setVisible(false);
			
		}else if(hostelType == 'FLOOR'){
			
			var  contentPanelMain = this.getContentPanel().getActiveTab().getActiveTab();
    		if(!isNullOrEmpty(contentPanelMain)){
    			contentPanelMain.scrollBy(0,1);
    			contentPanelMain.scrollBy(0,-1);
    		}
			
			var floorCodeName  = form.down('#floorCodeNo');
			var floorCodeStore =  floorCodeName.getStore();

			var values = form.getForm().getValues();
			var buildingValue = values.buildingCodeName;
			hostelCombo.reset();
			buildingCodeName.reset();
			roomType.reset();
			roomNo.reset();
			floorCodeNo.reset();
			floorCodeName.reset();
			statusCombo.reset();
			
			buildingCodeName.getStore().getProxy().extraParams = {
				//hostelCode:hostelCode,
				status:'ACTIVE',
				resourceGroup:'Building'
			};
			buildingCodeName.getStore().load();
			
//			if(!isNullOrEmpty(buildingValue)){
				floorCodeStore.getProxy().extraParams = {
					hostelCode:buildingValue,
					status:values.status,
					resourceGroup:'Floor'
				};
				floorCodeStore.load();
//			}
			grid=managefloorgrid;
			buildingCodeName.setVisible(true);
			managehostelgrid.setVisible(false);
			buildinggrid.setVisible(false);
			managefloorgrid.setVisible(true);
			manageroomdetailsgrid.setVisible(false);
			floorCodeNo.setVisible(true);
			roomType.setVisible(false);
			roomNo.setVisible(false);
			floorCodeNo.setDisabled(true);
			
		}else if(hostelType == 'ROOM'){
			var  contentPanelMain = this.getContentPanel().getActiveTab().getActiveTab();
    		if(!isNullOrEmpty(contentPanelMain)){
    			contentPanelMain.scrollBy(0,1);
    			contentPanelMain.scrollBy(0,-1);
    		}
			
			var roomNoField  = form.down('#roomNo');
			var roomNoStore =  roomNoField.getStore();

			var values = form.getForm().getValues();
			var floorCode = values.floorCodeNo;
			
			hostelCombo.reset();
			buildingCodeName.reset();
			roomType.reset();
			roomNo.reset();
			floorCodeNo.reset();
			roomNoField.reset();
			statusCombo.reset();
//			if(!isNullOrEmpty(floorCode)){
				roomNoStore.getProxy().extraParams = {
					hostelCode:floorCode,
					status:values.status,
					resourceGroup:'Room'
				};
				roomNoStore.load();
//			}
			grid=manageroomdetailsgrid;
			buildingCodeName.setVisible(true);
			managehostelgrid.setVisible(false);
			buildinggrid.setVisible(false);
			managefloorgrid.setVisible(false);
			manageroomdetailsgrid.setVisible(true);
			floorCodeNo.setVisible(true);
			roomType.setVisible(true);
			roomNo.setDisabled(true);
			roomNo.setVisible(true);
			
		}else if(hostelType == 'HOSTEL'){
			var  contentPanelMain = this.getContentPanel().getActiveTab().getActiveTab();
    		if(!isNullOrEmpty(contentPanelMain)){
    			contentPanelMain.scrollBy(0,1);
    			contentPanelMain.scrollBy(0,-1);
    		}
			grid=managehostelgrid;
			buildingCodeName.setVisible(false);
			managehostelgrid.setVisible(true);
			buildinggrid.setVisible(false);
			managefloorgrid.setVisible(false);
			manageroomdetailsgrid.setVisible(false);
			floorCodeNo.setVisible(false);
			roomType.setVisible(false);
			roomNo.setVisible(false);
			statusCombo.reset();
			hostelCombo.reset();
		}
		if(grid){
			grid.getHeader().removeCls('gridFixHeader');
	        grid.columnManager.headerCt.removeCls('gridFixHeader');
	        grid.dockedItems.items[3].removeCls('gridFixHeader');
		}
	},
	searchManageHostel:function(obj){
		var $this = this;
		var form = obj.up('form');
		var mngHostelStructure = this.getManagehostelstructure();
		var values = form.getForm().getValues();
		var resourceId = values.hostelCodeName;
		var status = values.status;
		
		if(values.hostelType == 'HOSTEL'){
			var managehostelgrid = mngHostelStructure.down('#managehostelgrid');
			var hostelStore = managehostelgrid.getStore();
			
			hostelStore.getProxy().extraParams = {
					resourceGroup:'Hostel',
					resourceId:resourceId,
					 status:status
				   };
			$this.resetPageSetting(hostelStore);
			hostelStore.loadPage(1);
			
		}else if(values.hostelType == 'BUILDING'){
			var buildinggrid = mngHostelStructure.down('#buildinggrid');
			var buildingStore = buildinggrid.getStore();
			
			buildingStore.getProxy().extraParams = {
				resourceGroup:'Building',
				resourceId:resourceId,
				status:status,
				buildingResourceId:values.buildingCodeName
			};
			$this.resetPageSetting(buildingStore);
			buildingStore.loadPage(1);
			
		}else if(values.hostelType == 'FLOOR'){
			var floorgrid = mngHostelStructure.down('#managefloorgrid');
			var floorStore = floorgrid.getStore();

			floorStore.getProxy().extraParams = {
				resourceGroup:'Floor',
				resourceId:resourceId,
				status:status,
				buildingResourceId:values.buildingCodeName,
				floorResourceId:values.floorCodeNo
			};
			$this.resetPageSetting(floorStore);
			floorStore.loadPage(1);


		}else if(values.hostelType == 'ROOM'){
			var manageroomdetailsgrid = mngHostelStructure.down('#manageroomdetailsgrid');
			var manageroomdetailsStore = manageroomdetailsgrid.getStore();
//			resourceGroup=Room&status=ACTIVE&resourceId=1&buildingResourceId=1&floorResourceId=1&roomResourceId=1&roomTypeId=1
			manageroomdetailsStore.getProxy().extraParams = {
				resourceGroup:'Room',
				resourceId:resourceId,
				status:status,
				buildingResourceId:values.buildingCodeName,
				floorResourceId:values.floorCodeNo,
				roomResourceId:values.roomNo,
				roomTypeId :values.roomType
					
			};
			$this.resetPageSetting(manageroomdetailsStore);
			manageroomdetailsStore.loadPage(1);
		}
		
	},
	/**
	 *  openListOfBuildingsWin is using when click on No. of building column cell of hostel grid 
	 */
	openListOfBuildingsWin:function(grid, rowIndex, record){
   	 var $this = this;
   	 var formWindow = $this.getNoofbuildingswin();
   	 if (!formWindow) {
   		 Ext.widget('noofbuildingswin');
   		 formWindow = $this.getNoofbuildingswin();
   	 }
   	 formWindow.show();
   	 
   	   var form = $this.getNoofBuildingswin().getForm();
    	 if(!isNullOrEmpty(record.data.hostelCode)){
    		 var hostelCodeName =   record.data.hostelCode + '/' + record.data.hostelName;
    		 form.findField('hostelCodeName').setValue(hostelCodeName);
    	 }
    	 if(!isNullOrEmpty(record.data.manager)){
    		 var manager =   record.data.manager;
    		 form.findField('manager').setValue(manager.value);
    	 }
    	 
    	 
   	  var store = $this.getNoofbuildingsgrid().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		$this.resetPageSetting(store);
		store.load({
			//Added for horizontal scroll show after 3 record for safari
            callback:function(rec,operation,success){
                if(rec.length <= 3){
                    $this.getNoofbuildingswin().setAutoScroll(false);
                }
            }
        });
		Ext.defer(function() {
			formWindow.center();
		}, 500);
	},
	/**
	 *  openListOfFloorsWin is using when click on No. of Floors column cell of building grid 
	 */
	openListOfFloorsWin:function(grid, rowIndex, record){
   	 var $this = this;
   	 var formWindow = $this.getFloorswincount();
   	 if (!formWindow) {
   		 Ext.widget('floorswincount');
   		 formWindow = $this.getFloorswincount();
   	 }
   	 formWindow.show();
   	 
   	   var form = $this.getFloorsWincount().getForm();
   	   
    	 if(!isNullOrEmpty(record.data.hostelCode) || !isNullOrEmpty(record.data.hostelName)){
    		 var hostelCodeName =   record.data.hostelCode + '/' + record.data.hostelName;
    		 form.findField('hostelCodeName').setValue(hostelCodeName);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.buildingCode) || !isNullOrEmpty(record.data.buildingName)){
    		 var buildingCodeName =   record.data.buildingCode + '/' + record.data.buildingName;
    		 form.findField('buildingCodeName').setValue(buildingCodeName);
    	 }
    	 
    	 
    	 if(!isNullOrEmpty(record.data.warden)){
    		 var warden =   record.data.warden;
    		 form.findField('warden').setValue(warden.value);
    	 }
    	 if(!isNullOrEmpty(record.data.subWarden)){
    		 var subWarden =   record.data.subWarden;
    		 form.findField('SubWarden').setValue(subWarden.value);
    	 }
    	 
   	  var store = $this.getFloorscountlist().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		$this.resetPageSetting(store);
		store.load({	
			//Added for horizontal scroll show after 3 record for safari
			callback:function(rec,operation,success){
				if(rec.length <= 3){
					$this.getFloorswincount().setAutoScroll(false);
				}
			}
		});
		Ext.defer(function() {
			formWindow.center();
		}, 500);
	},
	/**
	 *  openListOfRoomsWin is using when click on No. of Room column cell of Floor grid 
	 */
	openListOfRoomWin:function(grid, rowIndex, record){
   	 var $this = this;
   	 var formWindow = $this.getRoomwincount();
   	 if (!formWindow) {
   		 Ext.widget('roomwincount');
   		 formWindow = $this.getRoomwincount();
   	 }
   	 formWindow.show();
   	 
   	   var form = $this.getRoomWincount().getForm();
   	   
    	 if(!isNullOrEmpty(record.data.hostelCode) || !isNullOrEmpty(record.data.hostelName)){
    		 var hostelCodeName =   record.data.hostelCode + '/' + record.data.hostelName;
    		 form.findField('hostelCodeName').setValue(hostelCodeName);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.buildingCode) || !isNullOrEmpty(record.data.buildingName)){
    		 var buildingCodeName =   record.data.buildingCode + '/' + record.data.buildingName;
    		 form.findField('buildingCodeName').setValue(buildingCodeName);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.floorNo)){
    		 var floorNo = record.data.floorNo;
    		 form.findField('floorNo').setValue(floorNo);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.warden)){
    		 var warden =   record.data.warden;
    		 form.findField('warden').setValue(warden.value);
    	 }  	 
    	 
   	  var store = $this.getRoomcountlist().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		$this.resetPageSetting(store);
		store.load({	
			//Added for horizontal scroll show after 3 record for safari
			callback:function(rec,operation,success){
				if(rec.length <= 3){
					$this.getRoomWincount().setAutoScroll(false);
				}
			}
		});
		Ext.defer(function() {
			formWindow.center();
		}, 500);
	},
	/**
	 *  openListOfBedWin is using when click on No. of Bed column cell of Room grid 
	 */
	openListOfBedWin:function(grid, rowIndex, record){
   	 var $this = this;
   	 var formWindow = $this.getBedcounwin();
   	 if (!formWindow) {
   		 Ext.widget('bedcounwin');
   		 formWindow = $this.getBedcounwin();
   	 }
   	 formWindow.show();
   	 
   	   var form = $this.getBedCounwin().getForm();
   	   
    	 if(!isNullOrEmpty(record.data.floorNo)){
    		 var floorNo =   record.data.floorNo;
    		 form.findField('floorNo').setValue(floorNo);
    	 }
    	 
    	 if(!isNullOrEmpty(record.data.roomType)){
    		 var roomType =   record.data.roomType;
    		 form.findField('roomType').setValue(roomType);
    	 }
    	 	
    	 
    	 if(!isNullOrEmpty(record.data.roomNo)){
    		 var roomNo =   record.data.roomNo;
    		 form.findField('roomNo').setValue(roomNo);
    	 }
    	 
    	 
   	  var store = $this.getBedcountlist().getStore();
		store.getProxy().extraParams = {
			resourceId:record.data.resourceId
		};
		$this.resetPageSetting(store);
		store.load({	
			//Added for horizontal scroll only show after 3 record for safari
			callback:function(rec,operation,success){
				if(rec.length <= 3){
					$this.getBedcounwin().setAutoScroll(false);
				}
			}
		});
		Ext.defer(function() {
			formWindow.center();
		}, 500);
	},
	/** 
	 * openHostelDetails use to open hostel details tab 
	 */
	openHostelDetails:function(openView){
 	   var $this = this;
 	   var contentpanel = $this.getContentPanel();
 	   var structure = Ext.widget('edithosteldetails');
// 	   var tabName = getHostelTranslation('EDIT_HOSTEL_DETIALS');
 	   var tabName = '';
 	   if(openView == 'EDIT') {
 		   structure.setTitle(getHostelTranslation('EDIT_HOSTEL_DETIALS'));
 		   tabName = getHostelTranslation('EDIT_HOSTEL_DETIALS');
 	   } else if(openView == 'VIEW') {
 		   structure.setTitle(getHostelTranslation('VIEW_HOSTEL_DETIALS'));
 		   tabName = getHostelTranslation('VIEW_HOSTEL_DETIALS');
 	   }

 	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
 	   
 	  /** Remove all tab before open only one tab open either view or edit*/
		var getEditTab=getcontroller.getTab(getHostelTranslation('EDIT_HOSTEL_DETIALS'));
		var getViewTab=getcontroller.getTab(getHostelTranslation('VIEW_HOSTEL_DETIALS'));
		if(getEditTab!=null){
			contentPanel.remove(getEditTab, true);
		}
		if(getViewTab!=null){
			contentPanel.remove(getViewTab, true);
		}
		
 	  /* var getTab=getcontroller.getTab(tabName);
 	   if(getTab!=null){
 		   contentpanel.remove(getTab, true);
 	   }*/
 	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_TWELVE);
	},
	/** 
	 * open BuildingDetails use to open hostel details tab 
	 */
	openBuildingDetails:function(openView){
	 	   var $this = this;
	 	   var contentpanel = $this.getContentPanel();
	 	   var structure = Ext.widget('editbuildingdetails');
//	 	   var tabName = getHostelTranslation('EDIT_BUILDING_DETIALS');
	 	   
	 	   var tabName = '';
	 	   if(openView == 'EDIT') {
	 		   structure.setTitle(getHostelTranslation('EDIT_BUILDING_DETIALS'));
	 		   tabName = getHostelTranslation('EDIT_BUILDING_DETIALS');
	 	   } else if(openView == 'VIEW') {
	 		   structure.setTitle(getHostelTranslation('VIEW_BUILDING_DETIALS'));
	 		   tabName = getHostelTranslation('VIEW_BUILDING_DETIALS');
	 	   }

	 	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	 	   
	 	  /** Remove all tab before open */
			var getEditTab=getcontroller.getTab(getHostelTranslation('EDIT_BUILDING_DETIALS'));
			var getViewTab=getcontroller.getTab(getHostelTranslation('VIEW_BUILDING_DETIALS'));
			if(getEditTab!=null){
				contentPanel.remove(getEditTab, true);
			}
			if(getViewTab!=null){
				contentPanel.remove(getViewTab, true);
			}
			
	 	  /* var getTab=getcontroller.getTab(tabName);
	 	   if(getTab!=null){
	 		   contentpanel.remove(getTab, true);
	 	   }*/
	 	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_TWELVE);
		},
		/** 
		 * open FloorDetails use to open hostel details tab 
		 */
		openFloorDetails:function(openView){
		 	   var $this = this;
		 	   var contentpanel = $this.getContentPanel();
		 	   var structure = Ext.widget('editfloordetails');
//		 	   var tabName = getHostelTranslation('EDIT_FLOOR_DETAILS');
		 	   var tabName = '';
		 	   if(openView == 'EDIT') {
		 		   structure.setTitle(getHostelTranslation('EDIT_FLOOR_DETAILS'));
		 		   tabName = getHostelTranslation('EDIT_FLOOR_DETAILS');
		 	   } else if(openView == 'VIEW') {
		 		   structure.setTitle(getHostelTranslation('VIEW_FLOOR_DETAILS'));
		 		   tabName = getHostelTranslation('VIEW_FLOOR_DETAILS');
		 	   }

		 	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
		 	   
				/** Remove all tab before open */
				var getEditTab=getcontroller.getTab(getHostelTranslation('EDIT_FLOOR_DETAILS'));
				var getViewTab=getcontroller.getTab(getHostelTranslation('VIEW_FLOOR_DETAILS'));
				if(getEditTab!=null){
					contentPanel.remove(getEditTab, true);
				}
				if(getViewTab!=null){
					contentPanel.remove(getViewTab, true);
				}				
		 	   
		 	  /* var getTab=getcontroller.getTab(tabName);
		 	   if(getTab!=null){
		 		   contentpanel.remove(getTab, true);
		 	   }*/
		 	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_TWELVE);
			},
			/** 
			 * open RoomDetails use to open hostel details tab 
			 */
			openRoomDetails:function(openView){
				var $this = this;
				var contentpanel = $this.getContentPanel();
				var structure = Ext.widget('editroomdetails');
				var tabName = '';
				if(openView == 'EDIT') {
					structure.setTitle(getHostelTranslation('EDIT_ROOM_DETAILS'));
					tabName = getHostelTranslation('EDIT_ROOM_DETAILS');
				} else if(openView == 'VIEW') {
					structure.setTitle(getHostelTranslation('VIEW_ROOM_DETAILS'));
					tabName = getHostelTranslation('VIEW_ROOM_DETAILS');
				}
				//var tabName = getHostelTranslation('EDIT_ROOM_DETAILS');

				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				
				/** Remove all tab before open */
				var getEditTab=getcontroller.getTab(getHostelTranslation('EDIT_ROOM_DETAILS'));
				var getViewTab=getcontroller.getTab(getHostelTranslation('VIEW_ROOM_DETAILS'));
				if(getEditTab!=null){
					contentPanel.remove(getEditTab, true);
				}
				if(getViewTab!=null){
					contentPanel.remove(getViewTab, true);
				}
				
				/*var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}*/
				openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_TWELVE);

			},
	/** 
	 * editHostelDetails use to edit hostel details 
	 */
	editHostelDetails:function(openView){
		var form = this.getManagehostelsearch().getForm();
		var values = form.getValues();
		var hostelType = values.hostelType;

		var mngHostelStructure = this.getManagehostelstructure();

		if(hostelType == 'HOSTEL'){
			var managehostelgrid = mngHostelStructure.down('#managehostelgrid');
			if (managehostelgrid.getSelectionModel().getCount() > 0) {
				var records = managehostelgrid.getSelectionModel().getSelection()[0];
				this.openHostelDetails(openView);			//this.openHostelDetails(records);
				this.setHostelDetails(records);
			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}

		}else if(hostelType == 'BUILDING'){
			var managebuildinggrid = mngHostelStructure.down('#buildinggrid');
			if (managebuildinggrid.getSelectionModel().getCount() > 0) {
				var records = managebuildinggrid.getSelectionModel().getSelection()[0];
				this.openBuildingDetails(openView);
				this.setBuildingDetails(records);
			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}

		}else if(hostelType == 'FLOOR'){

			var managefloorgrid = mngHostelStructure.down('#managefloorgrid');
			if (managefloorgrid.getSelectionModel().getCount() > 0) {
				var records = managefloorgrid.getSelectionModel().getSelection()[0];
				this.openFloorDetails(openView);
				this.setFloorDetails(records);
				
			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
		

		}else if(hostelType == 'ROOM'){
			var manageroomdetailsgrid = mngHostelStructure.down('#manageroomdetailsgrid');
			if (manageroomdetailsgrid.getSelectionModel().getCount() > 0) {
				var records = manageroomdetailsgrid.getSelectionModel().getSelection()[0];
				this.openRoomDetails(openView);
				this.setRoomDetails(records);

			}else{
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}

		}
	},
	viewHostelDetails:function(view, openView){
		this.editHostelDetails(openView);
		if(view == 'HOSTEL'){
			var form = this.getEdithosteldetails();

			if (form) {
				form.down('#saveBtn').hide();
//				form.down('#cancelBtn').hide();
				form.down('#uploadDocItemId').hide();
				form = form.getForm();
				form.findField('isView').setValue(true);
				toggleReadOnlyFormItems(form, true);

				var grid = this.getHosteldocument();
				buttonsToolBar = grid.query('toolbar')[0];
				var gridDeleteBtn= buttonsToolBar.query('#btnDelete')[0];
				gridDeleteBtn.setVisible(false);
			}
		}
		if(view == 'BUILDING' ){
			var form = this.getEditbuildingdetails();
			if (form) {
				form.down('#saveBtn').hide();
//				form.down('#cancelBtn').hide();
				form = form.getForm();
				toggleReadOnlyFormItems(form, true);
			}
		}
		if(view == 'FLOOR' ){
			var form = this.getEditfloordetails();
			if (form) {
				form.down('#saveBtn').hide();
//				form.down('#cancelBtn').hide();
				form = form.getForm();
				toggleReadOnlyFormItems(form, true);
			}
		}
		if(view == 'ROOM' ){
			var form = this.getEditroomdetails();
			/*var viewRoomDetail = Ext.widget('editroomdetails');
			viewRoomDetail.setTitle('View Room Details');*/
			if (form) {
				form.down('#saveBtn').hide();
//				form.down('#cancelBtn').hide();
				
				/* for(var j=0; j<bedDetails.items.length; j++){
		    		 var bedDetailsContainer=bedDetails.items.items[j];
		    		 bedDetailsContainer.items.items[0].setVisible(false);
		    	 }*/
				bedForm = form.getForm();
				toggleReadOnlyFormItems(bedForm, true);
				var numberOfBeds = form.down('#numberOfBeds').hide();
				var bedDetails = form.down('#bedDetailsBtn').hide();
				 var docketNoContainer = form.down('#bedDetailsContainer');
		    	 for(var j=1; j<docketNoContainer.items.length; j++){
		    		 var docketNoPanelContainer=docketNoContainer.items.items[j];
		    		 docketNoPanelContainer.down('#bedDetailsBtn').setVisible(false);
		    		 docketNoPanelContainer.down('#bedDetailsDeleteBtn').setVisible(false);
		    		 //docketNoPanelContainer.items.items[3].setVisible(false);
		    		 //docketNoPanelContainer.items.items[4].setVisible(false);
		    	 }
			}
		}

	},
	showViewLinkedAcademyLocation:function(){
	  	  var formWindow = this.getLinkedacademylocation();
	  	  if (!formWindow) {
	  		  Ext.widget('linkedacademylocation');
	  		  formWindow = this.getLinkedacademylocation();
	  	  }
	  	  formWindow.show();
	  	  
	  	  
	  	var managehostelgrid = this.getManagehostelgrid();	
		var records = managehostelgrid.getSelectionModel().getSelection()[0];
	  	  
	  	  
	  	var grid = this.getLinkedacademylocationgrid();
	  	var store = grid.getStore();
	  	store.getProxy().extraParams = {
	  		resourceId:records.data.resourceId
	  	};
		store.load();
	},
	openManageAddress:function(){
  	  var formWindow = this.getHostelManageAddress();
  	  if (!formWindow) {
  		  Ext.widget('studentaddress',{
  			  itemId:'hostelManageAddress'
  		  });
  		  formWindow = this.getHostelManageAddress();
  	  }
  	  formWindow.show();
	},
	/**
	 * resetManageHostel is using to reset search master screen
	 */
	resetManageHostel:function(form){
		form.getForm().reset();
		var buildingCodeName = form.down('#buildingCodeName');
		var buildingCodeStore = buildingCodeName.getStore();
		var floorCodeNoField  = form.down('#floorCodeNo');
		var floorCodeNo = floorCodeNoField.getStore();
		buildingCodeStore.getProxy().extraParams = {
			//hostelCode:hostelCode,
			status:'ACTIVE',
			resourceGroup:'Building'
		};
		buildingCodeStore.load();
		
		floorCodeNo.getProxy().extraParams = {
			//status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();
	},
	/**
	 * Save Hostel Details 
	 */
	saveEditHostelDetails:function(){
		var $this = this;
		var form =  $this.getEdithosteldetails().getForm();

		var values = form.getValues();
		if($this.validatePhone(values)){
			var managehostelgrid = this.getManagehostelgrid();	
			var records = managehostelgrid.getSelectionModel().getSelection()[0];
			var resourceId = records.data.resourceId;
			var hostelId = records.data.hostelId;

			var manageHostel = new Academia.model.hostel.managehostel.hostel.ManageHostelSaveM();

			manageHostel.set("resourceId", values.resourceId);
			manageHostel.set("hostelId", values.id);
			manageHostel.set("hostelRestrictionTypeId", values.restrictionType);
			manageHostel.set("managerId", values.manager);//$this.getIdValueJson(values.manager));
			manageHostel.set("wardenId", values.warden);//$this.getIdValueJson(values.warden));
			manageHostel.set("status", values.status);
			manageHostel.set("leaseEndDate", values.leaseEndDate);
			manageHostel.set("startDate", values.startDate);
			manageHostel.set("closureDate", values.closureDate);
			manageHostel.set("phoneCountryCode", values.phoneCountryCode);
			manageHostel.set("phoneAreaCode", values.phoneAreaCode);
			manageHostel.set("phoneNo", values.phoneNo);
			manageHostel.set("cellCountryCode", values.mobileCountryCode);
			manageHostel.set("cellNo", values.cellNo);
			manageHostel.set("emailId", values.emailId);
			manageHostel.set("remarks", values.remarks);
			manageHostel.set("isGeneral", values.isGeneral);
			manageHostel.set("subWardenId", values.subWarden);
			if(values.isGeneral){
			manageHostel.set("punchStartTime", values.punchStartTime);
			manageHostel.set("lastInTime", values.lastInTime);
			}
			
//			manageHostel.set("noOfdocument", 1);

			if(values.ownership  == 'THIRD_PARTY' || values.ownership  == 'Third Party'){
				manageHostel.set("ownership", 'THIRD_PARTY');				
			}else if(values.ownership  == 'SELF' || values.ownership  == 'Self'){
				manageHostel.set("ownership", 'SELF');
			}
			
			
			
			var docStore = $this.getStore('hostel.managehostel.hostel.HostelDocument');
			var docArray = [];
			if (docStore.data.items != null
					&& docStore.data.items.length > 0) {
				Ext.each(docStore.data.items, function(val) {
					var newData = {
							"name" : val.data.documentName,
							"path" : val.data.path,
							"type" : val.data.type,
							"createdBy" : $this.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
					};
					if(val.data.documentId==""){
						docArray.push(newData);  
					}
//					docArray.push(newData);
				});
			}
			manageHostel.set("documents", docArray);
			manageHostel.set("noOfdocument", docArray.length);


			/*var hostelAddresses = [];
			hostelAddresses.push({
				"id":values.addressTableId,
				"address":$this.getIdValueJson(values.addressId),
				"hostel":$this.getIdValueJson(hostelId)
			});
			manageHostel.set("hostelAddresses", hostelAddresses);*/
			var formData = Ext.encode(manageHostel.data);
			/*var submitUrl;
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") {

			submitUrl = SERVERURL.UPDATE_HOSTEL;
		} else {
			manageHostel.set("id", values.id);*/
			submitUrl = SERVERURL.UPDATE_HOSTEL;
//			}

			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : formData,
				method : 'POST',
				success : function(form1, action) {
					showSuccessMessage(getHostelTranslation('EDIT_HOSTEL_DETIALS'),getCommonTranslation('SUCCESS'));
					form.reset();
					managehostelgrid.getSelectionModel().deselectAll(true);
					managehostelgrid.getStore().reload();
					var activeTab = $this.getEdithosteldetails().up('panel');
					$this.closeTab(activeTab);
				}
			});
		}
	},
	closeTab : function(tabReference) {
   	 tabReference.close();
    },
	/**
	 * 
	 */
    addHostelAddress:function(){
    	var $this = this;
//    	var form =Ext.getCmp('hostelAddressId').getForm();
    	var form = $this.getHostelManageAddressForm().getForm();
    	var values = form.getValues();
//    	if($this.validatePhone(values)){
    	var mngHostelStructure = $this.getManagehostelstructure();
    	var managehostelgrid = mngHostelStructure.down('#managehostelgrid');
    	var records = managehostelgrid.getSelectionModel().getSelection()[0];
    	var hostelId = records.get("hostelId");

    	var dataModel=new Academia.model.hostel.managehostel.hostel.HostelAddressDetails();
    	dataModel.set('id',values.addressId);
    	dataModel.set('version',values.version);
    	dataModel.set('addressText',values.addressText);
    	dataModel.set('country',$this.getIdValueJson(values.country));
    	dataModel.set('parentCountryRegion',$this.getIdValueJson(values.parentCountryRegion));
    	dataModel.set('city',$this.getIdValueJson(values.city));
    	dataModel.set('pincode',values.pincode);
    	dataModel.set('cellCountryCode',values.cellCountryCode);
    	dataModel.set('cellNo',values.cellNo);
    	dataModel.set('phoneCountryCode',values.phoneCountryCode);
    	dataModel.set('phoneAreaCode',values.phoneAreaCode);
    	dataModel.set('phoneNo',values.phoneNo);
    	dataModel.set('primaryeEmailId',values.primaryeEmailId);
    	dataModel.set('alternateEmailId',values.alternateEmailId);
    	dataModel.set('addressType',$this.getIdValueJson(values.addressType));
    	dataModel.set('countryRegion',$this.getIdValueJson(values.countryRegion));
    	dataModel.set('salutation',values.salutation);
    	/*var data={
//    		  "id":parseInt(values.id),
//    		  "addressTypeId":parseInt(values.addressType),
//    		  "hostelId":parseInt(hostelId),
//    		  "hostelAddresses":dataModel.data,
    		  "address":dataModel.data,
//    		  "enquiryStudentDetail":$this.getIdValueJson(parseInt(studentId))
               };*/

    	var isAddressAvailable = $this.getEdithosteldetails().getForm().findField('isAddressAvailable').getValue();
    	var url;
    	if(isAddressAvailable == true || isAddressAvailable == 'true'){
    		url = SERVERURL.VEHICLE_ADDRESS_CREATE;
    	}else{
    		url = SERVERURL.VEHICLE_ADDRESS_UPDATE;
    	}
		
    	Ext.Ajax.request({
    		method: 'POST',
//  		url: SERVERURL.UPDATE_HOSTEL,
    		url: url,
    		jsonData:dataModel.data,
    		success: function(response) {
    			var data = Ext.decode(response.responseText);
    			$this.getEdithosteldetails().getForm().findField('addressId').setValue(data);
    			
    			// UPDATE address
    			var hostelForm =  $this.getEdithosteldetails().getForm();
    			var hostelValues = hostelForm.getValues();
    			var hostelAddress = new Academia.model.AbstractDataModel();
    			hostelAddress.set("id", hostelValues.addressTableId);
    			hostelAddress.set("address", $this.getIdValueJson(data));
    			hostelAddress.set("hostel", $this.getIdValueJson(hostelId));
    			var formData = Ext.encode(hostelAddress.data);
    			Ext.Ajax.request({
    				type : 'rest',
    				url: SERVERURL.UPDATE_HOSTEL_ADDRESS,
    				jsonData : formData,
    				method : 'POST',
    				success : function(res) {
    					if(res.responseText == "SUCCESS") {
    						showSuccessMessage(getHostelTranslation('EDIT_HOSTEL_DETIALS'),getCommonTranslation('SUCCESS'));
    					}
    				}
    			});
    		}
    	});
    	
    	
//    	Ext.getCmp('hostelAddressId').up('window').close();
    	$this.getHostelManageAddress().close();
//    }
    },
	/**
	 * Save Building Details 
	 */
    saveEditBuildinglDetails:function(){
    	var $this = this;
    	var form =  $this.getEditbuildingdetails().getForm();
    	var values = form.getValues();

    	if($this.validatePhone(values)){
    		var buildinggrid = this.getBuildinggrid();	
    		var records = buildinggrid.getSelectionModel().getSelection()[0];
    		var resourceId = records.data.resourceId;
    		var hostelId = records.data.hostelId;
    		var hostelBuildingId = records.data.hostelBuildingId;


    		var manageBuilding = new Academia.model.hostel.managehostel.building.ManageBuildingSaveM();

    		manageBuilding.set("resourceId", values.resourceId);
    		manageBuilding.set("hostelId", values.hostelId);
    		manageBuilding.set("hostelBuildingId", values.id);
    		manageBuilding.set("hostelRestrictionTypeId", values.restrictionType);
    		manageBuilding.set("wardenId", values.warden);
    		manageBuilding.set("ownership", values.ownership);
    		manageBuilding.set("status", values.status);
    		manageBuilding.set("startDate", values.startDate);
    		manageBuilding.set("closureDate", values.closureDate);
    		manageBuilding.set("phoneCountryCode", values.phoneCountryCode);
    		manageBuilding.set("phoneAreaCode", values.phoneAreaCode);
    		manageBuilding.set("phoneNo", values.phoneNo);
    		manageBuilding.set("cellCountryCode", values.cellCountryCode);
    		manageBuilding.set("cellNo", values.cellNo);
    		manageBuilding.set("emailId", values.emailId);
    		manageBuilding.set("remarks", values.remarks);
    		manageBuilding.set("isGeneral", values.isGeneral);
    		manageBuilding.set("subWardenId", values.subWarden);
			if(values.isGeneral){
				manageBuilding.set("lastInTime", values.lastInTime);
				manageBuilding.set("punchStartTime", values.punchStartTime);
			}

    		var formData = Ext.encode(manageBuilding.data);
    		var submitUrl;
    		
    		submitUrl = SERVERURL.UPDATE_BUILDING;

    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : formData,
    			method : 'POST',
    			success : function(form1, action) {
    				showSuccessMessage(getHostelTranslation('EDIT_BUILDING_DETIALS'),getCommonTranslation('SUCCESS'));
    				form.reset();
    				buildinggrid.getSelectionModel().deselectAll(true);
    				buildinggrid.getStore().reload();
    				var activeTab = $this.getEditbuildingdetails().up('panel');
    				$this.closeTab(activeTab);
    			}
    		});
    	}
    },
    /**
	 * Save Floor Details 
	 */
    saveEditFloorDetails:function(){
    	var $this = this;
    	var form =  $this.getEditfloordetails().getForm();
    	var values = form.getValues();

    	var floorgrid = this.getManagefloorgrid();	
    	var records = floorgrid.getSelectionModel().getSelection()[0];
    	var resourceId = records.data.resourceId;
    	var hostelFloorId = records.data.hostelFloorId;
    	var hostelBuildingId = records.data.hostelBuildingId;

    	var manageFloor = new Academia.model.hostel.managehostel.floor.ManageFloorDetailsM();

    	manageFloor.set("resourceId", resourceId);
    	manageFloor.set("hostelBuildingId", hostelBuildingId);
    	manageFloor.set("hostelFloorId", hostelFloorId);
    	manageFloor.set("hostelRestrictionTypeId", values.restrictionType);
    	manageFloor.set("floorNumber", values.floorNumber);
    	manageFloor.set("status", values.status);
    	manageFloor.set("remarks", values.remarks);

    	var formData = Ext.encode(manageFloor.data);

    	submitUrl = SERVERURL.HOSTEL_FLOOR_UPDATE;

    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : formData,
    		method : 'POST',
    		success : function(form1, action) {
    			showSuccessMessage(getHostelTranslation('EDIT_FLOOR_DETAILS'),getCommonTranslation('SUCCESS'));
    			form.reset();
    			floorgrid.getSelectionModel().deselectAll(true);
    			floorgrid.getStore().reload();
    			var activeTab = $this.getEditfloordetails().up('panel');
    			$this.closeTab(activeTab);
    		}
    	});
    },
    /**
	 * Save Room Details 
	 */
    saveEditRoomDetails:function(){
    	var $this = this;
    	var form =  $this.getEditroomdetails().getForm();
    	var values = form.getValues();

    	var roomgrid = this.getManageroomdetailsgrid();	
    	var records = roomgrid.getSelectionModel().getSelection()[0];
    	var resourceId = records.data.resourceId;
    	var hostelFloorId = records.data.hostelFloorId;
//  	var hostelBuildingId = records.data.hostelBuildingId;
    	var hostelRoomId = records.data.hostelRoomId;


    	var manageRoom = new Academia.model.hostel.managehostel.room.ManageRoomDetailsM();

    	manageRoom.set("resourceId", resourceId);
    	manageRoom.set("hostelRoomId", hostelRoomId);
    	manageRoom.set("hostelFloorId", hostelFloorId);
    	manageRoom.set("hostelRestrictionTypeId", values.restrictionType);
    	manageRoom.set("hostelRoomTypeId", values.roomType);
    	manageRoom.set("hostelStatusChangeReasonId", values.statusChangeReason);
    	manageRoom.set("roomNumber", values.roomNumber);
    	manageRoom.set("numberOfBeds", values.numberOfBeds);
    	manageRoom.set("roomStatus", values.status);
    	manageRoom.set("statusChnageDate", values.statusChangeDate);

    	manageRoom.set("fromDate", values.fromDate);
    	manageRoom.set("toDate", values.toDate);
    	manageRoom.set("remarks", values.remarks);


    	var bedDetailsContiner = $this.getEditroomdetails().down('#bedDetailsContainer');
    	var bedDetailsFieldsCount = bedDetailsContiner.items.length;

    	var hostelBeds =[];
    	var bedDetailsCheck;
    	if(bedDetailsFieldsCount > 1){
    		for(var i=0; i<values.bedDetails.length && values.bedNo.length; i++){

//  			var bedDetailsCheck;
    			if(!isNullOrEmpty(values.bedDetails[i]) && !isNullOrEmpty(values.bedNo[i])){
    				bedDetailsCheck = true;
    			}else{
    				bedDetailsCheck = false;
    			}

    			hostelBeds.push({
    				"id":values.bedDetailsUpdateIds[i],
    				"hostelRoomId":hostelRoomId,
    				"bedNumber": values.bedNo[i],
    				"bedDeatails":values.bedDetails[i],
    				"seatTypeId":values.seatType[i]
    			});
    		}
    		manageRoom.set("hostelBeds",hostelBeds);	
    	}else{//if((!isNullOrEmpty(values.bedDetails)) &&  (!isNullOrEmpty(values.bedNo))){
//  		var bedDetailsCheck;
//  		if(!isNullOrEmpty(values.bedDetails) && !isNullOrEmpty(values.bedNo)){
    		//bedDetailsCheck = true;
//  		}else{
//  		bedDetailsCheck = false;
//  		}
    		hostelBeds.push({
    			"id":values.bedDetailsUpdateIds,
    			"hostelRoomId": hostelRoomId,
    			"bedNumber":values.bedNo,
    			"bedDeatails": values.bedDetails,
    			"seatTypeId":values.seatType
    		});
    		manageRoom.set("hostelBeds",hostelBeds);	
    	}
    	/*else{
    		bedDetailsCheck = false;
//  		manageRoom.set("hostelBeds",hostelBeds);
    	}*/
    	var editroomdetails = $this.getEditroomdetails();
		var bedDetailsContainer = editroomdetails.down('#bedDetailsContainer');
		var timeFieldsCount = bedDetailsContainer.items.length;


       var numberOfBeds = editroomdetails.down('#numberOfBeds').getValue();

    	var formData = Ext.encode(manageRoom.data);
    	submitUrl = SERVERURL.HOSTEL_ROOM_UPDATE;
//    	if(bedDetailsCheck == true){
    		if(parseInt(numberOfBeds) == timeFieldsCount ){
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : formData,
    			method : 'POST',
    			success : function(form1, action) {
    				showSuccessMessage(getHostelTranslation('EDIT_ROOM_DETAILS'),getCommonTranslation('SUCCESS'));
    				form.reset();
    				roomgrid.getSelectionModel().deselectAll(true);
    				roomgrid.getStore().reload();
    				var activeTab = $this.getEditroomdetails().up('panel');
    				$this.closeTab(activeTab);
    			}
    		});
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('FIELDS_AND_BEDS_NOT_EQUAL'));
    		}
    		/*}
    		else{
    		showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('IS_NULL_EMPTY_BED_DETAILS'));
    	}*/
    },
	/**
	 *  setHostelDetails for hostel Details radio
	 */
	setHostelDetails:function(records){
		var $this = this; 
		if (records != undefined && records != ""&& records != null) {
			var hostelId = records.get("hostelId");
			Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.HOSTEL_FIND_BY_ID,
				params : {
					hostelId : hostelId
				},
				method : 'GET',
				success : function(response) {
					var edithosteldetailsForm = $this.getEdithosteldetails();
					var form = edithosteldetailsForm.getForm();

					var data = Ext.decode(response.responseText);
					if(!isNullOrEmpty(data.startDate))
						data.startDate = new Date(data.startDate);
					if(!isNullOrEmpty(data.closureDate))
						data.closureDate = new Date(data.closureDate);
					var manageHostel = new Academia.model.hostel.managehostel.hostel.ManageHostelSaveM(data);
					form.loadRecord(manageHostel);

					if(!isNullOrEmpty(data.hostelAddresses[0])){
						form.findField('addressTableId').setValue(data.hostelAddresses[0].id);

						if(!isNullOrEmpty(data.hostelAddresses[0].address)){
							form.findField('addressId').setValue(data.hostelAddresses[0].address.id);
						}
					}
					if(!isNullOrEmpty(data.clusterCode)){
						form.findField('clusterCodeName').setValue(data.clusterCode.value);

						
					}
					if(!isNullOrEmpty(data.hostelType)){
						form.findField('hostelTypeName').setValue(data.hostelType.value);
					}
					if(!isNullOrEmpty(data.hostelLevel)){
						form.findField('hostelLevelName').setValue(data.hostelLevel);
					}
					if(!isNullOrEmpty(data.hostelCategory)){
						form.findField('hostelCategoryName').setValue(data.hostelCategory);
					}
					var hostelCodeNameField = edithosteldetailsForm.down('#hostelCodeName');

					var hostelCodeName='';
					if(!isNullOrEmpty(records.data.hostelCode) || !isNullOrEmpty(records.data.hostelName)){
						var hostelCode = records.get("hostelCode");
						var hostelName = records.get("hostelName");
						hostelCodeName = hostelCode+ '/' +hostelName;
						hostelCodeNameField.setValue(hostelCodeName);
					}

					var noOfBuildingsField = edithosteldetailsForm.down('#noOfBuildings');
					if(!isNullOrEmpty(records.data.noOfBuilings)){
						var noOfBuilings = records.get("noOfBuilings");
						noOfBuildingsField.setValue(noOfBuilings);
					}
					
					var resourceId = records.get("resourceId");
					var resourceIdField = form.findField('resourceId');
					resourceIdField.setValue(resourceId);
					
					var hostelId = records.get("hostelId");
					var store = $this.getHosteldocument().getStore();
					store.getProxy().extraParams = {
						hostelId:hostelId
					};
					store.load();

					if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
						var restrictionTypeCombo = edithosteldetailsForm.down('#restrictionType');
						restrictionTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
								}
							}
						});
					}

					if(!isNullOrEmpty(data.managerId)){
						var managerCombo = edithosteldetailsForm.down('#manager');
						managerCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									managerCombo.setValue(data.managerId);
								}
							}
						});
					}
					if(!isNullOrEmpty(data.wardenId)){
						var wardenCombo = edithosteldetailsForm.down('#warden');
						wardenCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									wardenCombo.setValue(data.wardenId);
								}
							}
						});
					}
					if(!isNullOrEmpty(data.subWardenId)){
						var subWardenCombo = edithosteldetailsForm.down('#subWarden');
						subWardenCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									subWardenCombo.setValue(data.subWardenId);
								}
							}
						});
					}

					if(!isNullOrEmpty(data.ownership)){
						
						var ownershipField = edithosteldetailsForm.down('#ownership');
						var leaseEndDateField = edithosteldetailsForm.down('#leaseEndDate');
						var ownership = data.ownership;
						
						if(ownership == 'THIRD_PARTY' || ownership == 'Third Party'){
							ownershipField.setRawValue('Third Party');
							leaseEndDateField.setVisible(true);
						}else if(ownership == 'SELF' || ownership == 'Self'){
							ownershipField.setRawValue('Self');
							leaseEndDateField.setVisible(false);
						}
						
					}
					if(!isNullOrEmpty(data.cellCountryCode)){
						edithosteldetailsForm.down('#cellCountryCode').setValue(data.cellCountryCode);
					}
					var entryRulesItemId = edithosteldetailsForm.down('#entryRulesItemId');
					entryRulesItemId.items.items[0].setValue({isGeneral:!data.isGeneral});
					if(data.isGeneral){
						entryRulesItemId.items.items[0].setValue({isGeneral:data.isGeneral});
						if(!isNullOrEmpty(data.lastInTime)){
							edithosteldetailsForm.down('#lastInTimeItemId').setValue(timeRender(data.lastInTime));
						}
						if(!isNullOrEmpty(data.punchStartTime)){
							edithosteldetailsForm.down('#punchStartTimeItemId').setValue(timeRender(data.punchStartTime));
						}
					}
					
				}
			});
		}
	},
	/**
	 *  setBuildingDetails for hostel Details radio
	 */
	setBuildingDetails:function(records){
		var $this = this; 
		if (records != undefined && records != ""&& records != null) {
			var hostelBuildingId = records.get("hostelBuildingId");
			Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.HOSTEL_BUILDING_FIND_BY_ID,
				params : {
					hostelBuildingId : hostelBuildingId
				},
				method : 'GET',
				success : function(response) {
					var editbuildingdetails = $this.getEditbuildingdetails();
					var form = editbuildingdetails.getForm();
					
					var data = Ext.decode(response.responseText);
					if(!isNullOrEmpty(data.startDate)) {
						var startDate = editbuildingdetails.down('#startDate');
						data.startDate = new Date(data.startDate);
						startDate.setMinValue(data.startDate);
					}

					if(!isNullOrEmpty(data.closureDate)){
						var closureDate = editbuildingdetails.down('#closureDate');
						data.closureDate = new Date(data.closureDate);
						closureDate.setMinValue(data.closureDate);}
					var manageBuilding = new Academia.model.hostel.managehostel.building.ManageBuildingSaveM(data);
					form.loadRecord(manageBuilding);


					var hostelCodeNameField = editbuildingdetails.down('#hostelCodeName');
					var buildingCodeNameField = editbuildingdetails.down('#buildingCodeName');
					var noOfFloorsField = editbuildingdetails.down('#noOfFloors');
					
					var hostelCodeName='';
					if(!isNullOrEmpty(records.data.hostelCode) || !isNullOrEmpty(records.data.hostelName)){
						 var hostelCode = records.get("hostelCode");
						 var hostelName = records.get("hostelName");
						 hostelCodeName = hostelCode+ '/' +hostelName;
						 hostelCodeNameField.setValue(hostelCodeName);
					}
					var buildingCodeName='';
					if(!isNullOrEmpty(records.data.buildingCode) || !isNullOrEmpty(records.data.buildingName)){
						var buildingCode = records.get("buildingCode");
						var buildingName = records.get("buildingName");
						buildingCodeName = buildingCode+ '/' +buildingName;
						buildingCodeNameField.setValue(buildingCodeName);
					}
					
					if(!isNullOrEmpty(records.data.noOfFloors)){
						var noOfFloors = records.get("noOfFloors");
						noOfFloorsField.setValue(noOfFloors);
					}
					/****************
					 * bug - V2D-14073
					 *  if hostel has any type of restriction then it also will applied on building level 
					 *  ***************/
					
					if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
						var restrictionTypeCombo = editbuildingdetails.down('#restrictionType');
						restrictionTypeCombo.setReadOnly(true);
						restrictionTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
								}
							}
						});
					}
					
					/*if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
						var restrictionTypeCombo = editbuildingdetails.down('#restrictionType');
						restrictionTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
								}
							}
						});
					}*/
					
					if(!isNullOrEmpty(data.wardenId)){
						var wardenCombo = editbuildingdetails.down('#warden');
						wardenCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									wardenCombo.setValue(data.wardenId);
								}
							}
						});
					}
					if(!isNullOrEmpty(data.subWardenId)){
						var subWardenCombo = editbuildingdetails.down('#subWarden');
						wardenCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									subWardenCombo.setValue(data.subWardenId);
								}
							}
						});
					}
					
					var entryRulesItemId = editbuildingdetails.down('#entryBuildingRulesItemId');
					entryRulesItemId.items.items[0].setValue({isGeneral:!data.isGeneral});
					if(data.isGeneral){
						entryRulesItemId.items.items[0].setValue({isGeneral:data.isGeneral});
						if(!isNullOrEmpty(data.lastInTime)){
							editbuildingdetails.down('#lastInTimeItemId').setValue(timeRender(data.lastInTime));
						}
						if(!isNullOrEmpty(data.punchStartTime)){
							editbuildingdetails.down('#punchStartTimeItemId').setValue(timeRender(data.punchStartTime));
						}
					}

				}
			});
		}
	},
	/**
	 *  setFloorDetails for hostel Details radio
	 */
	setFloorDetails:function(records){
		var $this = this; 
		if (records != undefined && records != ""&& records != null) {
			var hostelFloorId = records.get("hostelFloorId");
			Ext.Ajax.request({
				type : 'rest',
				url : SERVERURL.HOSTEL_FLOOR_FIND_BY_ID,
				params : {
					hostelFloorId : hostelFloorId
				},
				method : 'GET',
				success : function(response) {
					var editfloordetails = $this.getEditfloordetails();
					var form = editfloordetails.getForm();

					var data = Ext.decode(response.responseText);

					var manageFloor = new Academia.model.hostel.managehostel.floor.ManageFloorDetailsM(data);
					form.loadRecord(manageFloor);

					var hostelCodeNameField = editfloordetails.down('#hostelCodeName');
					var buildingCodeNameField = editfloordetails.down('#buildingCodeName');
					var floorNumberField = editfloordetails.down('#floorNumber');
					var noOfRoomsField = editfloordetails.down('#noOfRooms');
					
					
					var hostelCodeName='';
					if(!isNullOrEmpty(records.data.hostelCode) || !isNullOrEmpty(records.data.hostelName)){
						 var hostelCode = records.get("hostelCode");
						 var hostelName = records.get("hostelName");
						 hostelCodeName = hostelCode+ '/' +hostelName;
						 hostelCodeNameField.setValue(hostelCodeName);
					}
					var buildingCodeName='';
					if(!isNullOrEmpty(records.data.buildingCode) || !isNullOrEmpty(records.data.buildingName)){
						var buildingCode = records.get("buildingCode");
						var buildingName = records.get("buildingName");
						buildingCodeName = buildingCode+ '/' +buildingName;
						buildingCodeNameField.setValue(buildingCodeName);
					}
					
					if(!isNullOrEmpty(records.data.noOfRooms)){
						var noOfRooms = records.get("noOfRooms");
						noOfRoomsField.setValue(noOfRooms);
					}
					
					if(!isNullOrEmpty(data.floorNumber)){
						floorNumberField.setValue(data.floorNumber);
					}
					/****************
					 * bug - V2D-14073
					 *  if building has any type of restriction then it also will applied on floor level 
					 *  ***************/
					
					if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
						var restrictionTypeCombo = editfloordetails.down('#restrictionType');
						restrictionTypeCombo.setReadOnly(true);
						restrictionTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
								}
							}
						});
					}
					/*if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
						var restrictionTypeCombo = editfloordetails.down('#restrictionType');
						restrictionTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
								}
							}
						});
					}*/
					
				}
			});
		}
	},
	/**
	 *  setRoomDetails for hostel Details radio
	 */
	setRoomDetails:function(records){
		var $this = this; 
		if (records != undefined && records != ""&& records != null) {
			var hostelRoomId = records.get("hostelRoomId");
			Ext.Ajax.request({
				type : 'rest',
				async: false,
				url : SERVERURL.HOSTEL_ROOM_FIND_BY_ID,
				params : {
					hostelRoomId : hostelRoomId
				},
				method : 'GET',
				success : function(response) {
					var editroomdetails = $this.getEditroomdetails();
					var form = editroomdetails.getForm();

					var data = Ext.decode(response.responseText);

					var manageRoomHostel = new Academia.model.hostel.managehostel.room.ManageRoomDetailsM(data);
					form.loadRecord(manageRoomHostel);

					var hostelCodeNameField = editroomdetails.down('#hostelCodeName');
					var buildingCodeNameField = editroomdetails.down('#buildingCodeName');

					var hostelCodeName='';
					if(!isNullOrEmpty(records.data.hostelCode) || !isNullOrEmpty(records.data.hostelName)){
						var hostelCode = records.get("hostelCode");
						var hostelName = records.get("hostelName");
						hostelCodeName = hostelCode+ '/' +hostelName;
						hostelCodeNameField.setValue(hostelCodeName);
					}
					
					var buildingCodeName='';
					if(!isNullOrEmpty(records.data.hostelCode) || !isNullOrEmpty(records.data.hostelName)){
						var buildingCode = records.get("buildingCode");
						var buildingName = records.get("buildingName");
						buildingCodeName = buildingCode+ '/' +buildingName;
						buildingCodeNameField.setValue(buildingCodeName);
					}

					var floorNoField = editroomdetails.down('#floorNo');
					if(!isNullOrEmpty(records.data.floorNo)){
						var floorNo = records.get("floorNo");
						floorNoField.setValue(floorNo);
					}
					
					
					var noOfBedsField = editroomdetails.down('#numberOfBeds');
					if(!isNullOrEmpty(data.numberOfBeds) && data.numberOfBeds > 1){
						editroomdetails.down('#isActiveFirstTime').setValue(true);
//						var noOfBeds = records.get("numberOfBeds");
						noOfBedsField.setValue(data.numberOfBeds);
					}else{
						editroomdetails.down('#isActiveFirstTime').setValue(false);
						noOfBedsField.setValue(1);
					}
					
					
					if(!isNullOrEmpty(data.hostelRoomTypeId)){
						var roomTypeCombo = editroomdetails.down('#roomType');
						roomTypeCombo.store.load({
							callback: function(records, operation, success) {
								if (success) {
									roomTypeCombo.setValue(data.hostelRoomTypeId);
								}
							}
						});
					}
					
					if(!isNullOrEmpty(data.hostelRestrictionTypeId)){
					var restrictionTypeCombo = editroomdetails.down('#restrictionType');
					restrictionTypeCombo.setReadOnly(true);
					restrictionTypeCombo.store.load({
						callback: function(records, operation, success) {
							if (success) {
								restrictionTypeCombo.setValue(data.hostelRestrictionTypeId);
							}
						}
					});
				}
				
					var fromDate = editroomdetails.down('#fromDate');
					var toDate = editroomdetails.down('#toDate');
					var dateContainer = editroomdetails.down('#dateContainer');
					var status = editroomdetails.down('#status');
					var statusChangeDate = editroomdetails.down('#statusChangeDate');
					var statusChangeReason = editroomdetails.down('#statusChangeReason');
					var statusField = editroomdetails.down('#status');
					
					
					
					if(!isNullOrEmpty(data.roomStatus)){
						status.setValue(data.roomStatus);

						if(data.roomStatus == 'TEMPORARY_INACTIVE' || data.roomStatus == 'Temporary Inactive'){
//							statusField.setValue('Temporary Inactive');
							dateContainer.setVisible(true);
							fromDate.allowBlank=false;
							toDate.allowBlank=false;

							fromDate.setFieldLabel(getCommonTranslation('START_DATE')+'<span class="required" style="color:red"> *</span>');
							toDate.setFieldLabel(getCommonTranslation('END_DATE')+'<span class="required" style="color:red"> *</span>');
							editroomdetails.isValid();

							if(!isNullOrEmpty(data.fromDate) && !isNullOrEmpty(data.toDate)){
								fromDate.setValue(dateRender(data.fromDate));
								toDate.setValue(dateRender(data.toDate));
							}
						}else{
							dateContainer.setVisible(false);
							fromDate.allowBlank=true;
							 toDate.allowBlank=true;
							 editroomdetails.isValid();
						}

						if(data.roomStatus == 'INACTIVE' || data.roomStatus == 'Inactive'){
//							statusField.setValue('Inactive');
							statusChangeDate.setVisible(false);
							statusChangeReason.setVisible(false);
							
							if(!isNullOrEmpty(data.statusChnageDate)){
								statusChangeDate.setValue(dateRender(data.statusChnageDate));
							}

							if(!isNullOrEmpty(data.hostelStatusChangeReasonId)){
								var store = statusChangeReason.getStore();
								store.load({
									callback: function(records, operation, success) {
										if (success) {
											statusChangeReason.setValue(data.hostelStatusChangeReasonId);
										}
									}
								});
							}
						}

						if(data.roomStatus == 'ACTIVE' || data.roomStatus == 'Active'){
//							statusField.setValue('Active');
							var isActiveFirstTime = editroomdetails.down('#isActiveFirstTime').getValue();
							if(isActiveFirstTime == false || isActiveFirstTime == 'false'){
								statusChangeDate.setVisible(false);
								statusChangeReason.setVisible(false);
							}else{
								statusChangeDate.setVisible(false);
								statusChangeReason.setVisible(false);
							}

						}

					}
					
					var bedNoField = editroomdetails.down('#bedNo');
					var bedDetailsField = editroomdetails.down('#bedDetails');
					var bedDetailsUpdateIds = editroomdetails.down('#bedDetailsUpdateIds');
					var seatType = editroomdetails.down('#seatType');
					
					if(!isNullOrEmpty(data.hostelBeds)){
						
						var hostelBeds = data.hostelBeds;
						
						if(hostelBeds.length > 1){
						
						for(var i= 1; i< hostelBeds.length ; i++){
							bedNoField.setValue(hostelBeds[0].bedNumber);
							bedDetailsField.setValue(hostelBeds[0].bedDeatails);
							bedDetailsUpdateIds.setValue(hostelBeds[0].id);
							
							if(!isNullOrEmpty(hostelBeds[0].seatTypeId)){
								seatType.getStore().load({
									callback: function(records, operation, success) {
										if (success) {
											seatType.setValue(hostelBeds[0].seatTypeId)
										}
									}
								});	
							}
							$this.addBedDetails(hostelBeds[i].bedNumber,hostelBeds[i].bedDeatails,hostelBeds[i].id,hostelBeds[i].seatTypeId);
							}
						}else{
							if(hostelBeds.length > 0){
								bedNoField.setValue(hostelBeds[0].bedNumber);
								bedDetailsField.setValue(hostelBeds[0].bedDeatails);
								bedDetailsUpdateIds.setValue(hostelBeds[0].id);

								if(!isNullOrEmpty(hostelBeds[0].seatTypeId)){
									seatType.getStore().load({
										callback: function(records, operation, success) {
											if (success) {
												seatType.setValue(hostelBeds[0].seatTypeId)
											}
										}
									});	
								}
							}
						}
					}
				}
			});
		}
	},
	addBedDetails:function(bedNumber,bedDeatails,bedDetailsUpdateIds,seatTypeId){
		var $this = this;
		var form = $this.getEditroomdetails();
		var bedDetailsContainer = form.down('#bedDetailsContainer');
		var timeFieldsCount = bedDetailsContainer.items.length;
		
		var numberOfBedsField = form.down('#numberOfBeds');
		var numberOfBeds = numberOfBedsField.getValue();
		
		var checkValidationCount = timeFieldsCount+1;
		
		numberOfBedsField.setValue(checkValidationCount);
		var panelItem = new Array();
//		if(parseInt(numberOfBeds) > timeFieldsCount ){
		panelItem.push({
			xtype:'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			defaults : {
				width : 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'textfield',
				name : 'bedNo',		
				value:bedNumber,
				allowBlank:false,
				maskRe: /[A-Za-z0-9\s]/,
				itemId : 'bedNo' + timeFieldsCount,		
			},{
				xtype : 'textfield',
				name : 'bedDetails',
				value:bedDeatails,
				maskRe: /[A-Za-z0-9\s]/,
				itemId : 'bedDetails'+ timeFieldsCount,
			},{
                xtype: 'customcombobox',
                name: 'seatType',
                itemId: 'seatType'+ timeFieldsCount,
                editable: false,
                store: Ext.create('Academia.store.hostel.managehostel.room.RoomDetailSeatTypeStore'),
                valueField: 'id',
                displayField: 'value',
                listeners:{
                	render:function(obj){
                		if(!isNullOrEmpty(seatTypeId)){
							obj.getStore().load({
								callback: function(records, operation, success) {
									if (success) {
										obj.setValue(seatTypeId);
									}
								}
							});
						}
                	}
                }
                //queryMode : 'local'
            },{
				xtype:'hidden',
				name:'bedDetailsUpdateIds',
				value:bedDetailsUpdateIds,
				itemId:'bedDetailsUpdateIds'+ timeFieldsCount,		
			},{
				xtype: 'button',
				glyph: ICONGLYPH.DELETEGLYPH,
				cls: 'CustomBodyBtnReject',
				itemId: 'bedDetailsDeleteBtn',
				tooltip: getCommonTranslation('DELETETOOLTIP'),
				style:{
					marginTop:'0px!important;'
				},
				listeners:{
					click:function(obj){
						var container = obj.up('fieldcontainer');
						var lastField = container.down('#bedNo'+ timeFieldsCount);
						lastField.validate();
						
						var panelContiner = $this.getEditroomdetails().down('#bedDetailsContainer');
						panelContiner.remove(container);
						
						var removeFieldCount =  panelContiner.items.length;
						
						numberOfBedsField.setValue(removeFieldCount);
					}
				}
			},{
				xtype: 'button',
				itemId: 'bedDetailsBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
//					marginTop:'30px'
					marginLeft:'-190px!important',
					marginTop:'0px!important;'
				}
			}]
		});
		bedDetailsContainer.add(panelItem);
		bedDetailsContainer.doLayout();
		/*}else{
			showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('NO_OF_BED_EXCEED'));
		}*/
		
		

	},
	manageHostelAddressType:function(){
		var $this=this;
		var mngHostelStructure = this.getManagehostelstructure();
		var managehostelgrid = mngHostelStructure.down('#managehostelgrid');
		var records = managehostelgrid.getSelectionModel().getSelection()[0];
		var hostelId = records.get("hostelId");

		var edithosteldetailsForm = $this.getEdithosteldetails().getForm();

		var isView = edithosteldetailsForm.findField('isView').getValue();

//		var form =Ext.getCmp('hostelAddressId').getForm();
		var form = $this.getHostelManageAddressForm().getForm();
		form.findField('addressType').setVisible(false);
		form.findField('addressType').allowBlank=true;

		if(isView){
			$this.getHostelManageAddress().down('#studentWin_submitbuttonId').setVisible(false);
			$this.getHostelManageAddress().down('#studentWin_cancelbuttonId').setVisible(false);
			$this.toggleReadOnlyFormItems(form, true);
		}

		Ext.Ajax.request({
			url: SERVERURL.HOSTEL_FIND_BY_ID,
			method: 'GET',
			params : {
				hostelId : hostelId
			},
			success: function(f) {
				if(f.responseText){
					var  jData=Ext.JSON.decode(f.responseText);

					var isAddressAvailable = false;
					if (!isNullOrEmpty(jData.hostelAddresses[0])) {
						isAddressAvailable = true;
						edithosteldetailsForm.findField('addressTableId').setValue(jData.hostelAddresses[0].id);

						if (!isNullOrEmpty(jData.hostelAddresses[0].address)) {

							var address = jData.hostelAddresses[0].address;
							var dataModel=new Academia.model.hostel.managehostel.hostel.HostelAddressDetails(address);
							form.loadRecord(dataModel);


							if(address.id!=null){
								form.findField('id').setValue(address.id);
							}
							if(address!=null){
								form.findField('addressId').setValue(address.id);
							}

							/*if(jData.enquiryStudentDetail!=null){
							 form.findField('enquiryStudentDetailId').setValue(jData.enquiryStudentDetail.id);
						 }*/
							if(address.version!=null){
								form.findField('version').setValue(address.version);
							}

								 var addressTypeCombo=Ext.ComponentQuery.query('customcombobox#addressTypeId')[0];
								 if(dataModel.data.addressType!=null){
									 addressTypeCombo.store.load({
										 callback: function(records, operation, success) {
											 if (success) {
												 addressTypeCombo.setValue(dataModel.data.addressType.id);
											 }
										 }
									 });
								 }

							if(dataModel.data.country!=null){
								var countryCombo=form.findField('country');
								countryCombo.store.load({
									callback: function(records, operation, success) {
										if (success) {
											countryCombo.setValue(dataModel.data.country.id);
										}
									}
								});
							}

							if(dataModel.data.country!=null && dataModel.data.city!=null){
								var cityCombo=form.findField('city');
								cityCombo.store.load({
									/*params:{
										id:dataModel.data.country.id
									},*/
									callback: function(records, operation, success) {
										if (success) {
											for(var i in records){
												if(records[i].data.id == dataModel.data.city.id){
													cityCombo.setValue(records[i].data.id );
												}
											}
											
										}
									}
								});
							}

							if(dataModel.data.country!=null && dataModel.data.parentCountryRegion!=null){
								var parentCountryRegionCombo=form.findField('parentCountryRegion');
								parentCountryRegionCombo.store.load({
									params:{
										cid:dataModel.data.country.id
									},
									callback: function(records, operation, success) {
										if (success) {
											parentCountryRegionCombo.setValue(dataModel.data.parentCountryRegion.id);
										}
									}
								});
							}

							if(dataModel.data.parentCountryRegion!=null && dataModel.data.countryRegion!=null){
								var countryRegionCombo=form.findField('countryRegion');
								countryRegionCombo.store.load({
									params:{
										pid:dataModel.data.parentCountryRegion.id
									},
									callback: function(records, operation, success) {
										if (success) {
											countryRegionCombo.setValue(dataModel.data.countryRegion.id);
										}
									}
								});
							}
						}
					}
				}
			}
		});
	},
	roomStatusSelection:function(obj,record){
		var form = obj.up('form');
		var status = record[0].get("id");
		var dateContainer = form.down('#dateContainer');
		var isActiveFirstTime = form.down('#isActiveFirstTime').getValue();
		var statusChangeDate = form.down('#statusChangeDate');
		var statusChangeReason = form.down('#statusChangeReason');
		
		var fromDate = form.down('#fromDate');
		var toDate = form.down('#toDate');
		


		if(status == 'ACTIVE'){
			dateContainer.setVisible(false);
			fromDate.allowBlank=true;
			toDate.allowBlank=true;
			form.isValid();

			if(isActiveFirstTime == false || isActiveFirstTime == 'false'){
				statusChangeDate.setVisible(false);
				statusChangeReason.setVisible(false);
			}else{
				statusChangeDate.setVisible(true);
				statusChangeReason.setVisible(true);
				statusChangeDate.allowBlank=false;
				statusChangeDate.setFieldLabel(getHostelTranslation('STATUS_CHANGE_DATE')+'<span class="required" style="color:red"> *</span>');
			}

		}else if(status == 'INACTIVE'){
			dateContainer.setVisible(false);

			statusChangeDate.setVisible(true);
			statusChangeReason.setVisible(true);
			
			 statusChangeDate.allowBlank=true;
			 fromDate.allowBlank=true;
			 toDate.allowBlank=true;
			 form.isValid();
		}else if(status == 'TEMPORARY_INACTIVE'){
			dateContainer.setVisible(true);

			statusChangeDate.setVisible(true);
			statusChangeReason.setVisible(true);
			
			 statusChangeDate.allowBlank=true;
			 fromDate.allowBlank=false;
			 toDate.allowBlank=false;
			 fromDate.setFieldLabel(getCommonTranslation('START_DATE')+'<span class="required" style="color:red"> *</span>');
			 toDate.setFieldLabel(getCommonTranslation('END_DATE')+'<span class="required" style="color:red"> *</span>');
			 form.isValid();
			
		}
		statusChangeDate.validate();
	},
	deleteHostelDocumentFile :function(){
   	 var $this = this;
   	 var grid = $this.getHosteldocument();
   	 if (grid.getSelectionModel().getCount() > 0) {
   		 showConfirmMessage(getHostelTranslation('EDIT_HOSTEL_DETIALS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
   				 function(btn, text) {
   					 if (btn == 'yes') {
   						 var records = grid.getSelectionModel().getSelection();
   						 var id = records[0].get("id");
   					if (!isNullOrEmpty(id)) {
   						Ext.Ajax.request({
   							 method : "DELETE",
   							 type : 'rest',
   							 url : SERVERURL.HOSTEL_DOCUMENT_DELETE+ '?id='+ id,
   							 headers : {
   								 'Content-Type' : 'application/json'
   							 },
   							 success : function(form,action) {
   								 grid.getStore().reload();
   								 showSuccessMessage(getHostelTranslation('EDIT_HOSTEL_DETIALS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
   							 }
   						 });
   					}else{
   						var store = grid.getStore();
   						store.remove(records[0]);
   						showSuccessMessage(getHostelTranslation('EDIT_HOSTEL_DETIALS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
   					}	
   					 }
   				 });
   	 } else {
   		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
   	 }
	},
	/*cancelEditHostelDetails:function(obj){
		obj.up('form').getForm().reset();  
	},*/
	getDocumentController : function() {
		var this$ = this;
		return this$.getController('Academia.controller.document.DocumentController');
	},
	getIdValueJson : function(id, value, code) {
		if (id)
			return {
			id : id,
			value : value,
			code : code
		};
	},
	validatePhone:function(data){
		var isValid;
		if(!data.phoneNo && !data.cellNo){
			showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'),getCommonTranslation('ADD_PHONE_NO'));
			isValid= false;
		}
		else{
			isValid=true;
		}
		return isValid;
	},
	
	disableManageHostelBedImportTab: function(structure, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var hostelBedImportTab = false;
        
        for (var i = 0; i < permissionList.length; i++) {
            if (permissionList[i] === "IMPORT_BULK_HOSTEL_BED") {
                hostelBedImportTab = true;
            }
        }
        this.showHostelBedImportTab(hostelBedImportTab, structure);
    },

    showHostelBedImportTab: function(hostelBedImportTab, structure) {
        var panelItem = new Array();
        var $this = this;
        var newcont = structure.items.items.length;
        var insertPosition = newcont + 1;
        if (hostelBedImportTab) {
            panelItem.push({
                    xtype: 'managehostelstructurenew',
                    //autoScroll: true,
                   // layout:'vbox',
                    /*defaults:{
                    	width:'100%'
                    },*/
                    title: getCommonTranslation('SEARCH'),
	               items: [{
                        xtype: 'managehostelsearch'
                    },{
                    	xtype:'panel',
                    	items:[ {
                            xtype: 'managehostelgrid',
                            itemId: 'managehostelgrid'
                        }]
                    },{
                    	xtype:'panel',
                    	items:[ {
                            xtype: 'buildinggrid',
                            itemId: 'buildinggrid',
                            hidden: true
                        }]
                    },{
                    	xtype:'panel',
                    	items:[ {
                            xtype: 'managefloorgrid',
                            itemId: 'managefloorgrid',
                            hidden: true
                        }]
                    },{
                    	xtype:'panel',
                    	items:[{
                            xtype: 'manageroomdetailsgrid',
                            itemId: 'manageroomdetailsgrid',
                            hidden: true
                        }]
                    }]
                }, {
                    xtype: 'panel',
                    title: getCommonTranslation('IMPORT_HOSTEL_BED'),
                    autoScroll: true,
                    cls: 'panelNoSpace',
                //    layout:'vbox',
                    defaults:{
                    	width:'100%'
                    },
                    items: [{
                        xtype: 'importdownloadhostelform',
                        itemId: 'importdownloadhostelform'
                    }]
                
            });

        } else {
            panelItem.push({
                    xtype: 'managehostelstructurenew',
                    title: getCommonTranslation('SEARCH'),
                    //autoScroll: true,
                    items: [{
                        xtype: 'managehostelsearch'
                    },{
                    	xtype:'panel',
                    	items:[{
                            xtype: 'managehostelgrid',
                            itemId: 'managehostelgrid'
                        }]
                    } ,{
                    	xtype:'panel',
                    	items:[ {
                            xtype: 'buildinggrid',
                            itemId: 'buildinggrid',
                            hidden: true
                        }]
                    },{
                    	xtype:'panel',
                    	items:[  {
                            xtype: 'managefloorgrid',
                            itemId: 'managefloorgrid',
                            hidden: true
                        }]
                    },{
                    	xtype:'panel',
                    	items:[    {
                            xtype: 'manageroomdetailsgrid',
                            itemId: 'manageroomdetailsgrid',
                            hidden: true
                        }]
                    }]
            });

        }
        structure.insert(insertPosition, panelItem);
        structure.setActiveTab(0);
        
    },
    addMoreCapacityRow:function(record,isViewMode){
    	var me =this,
    	capacityForm = me.getHostelCapacityPlanWin(),
    	capacityPanel=capacityForm.down('#capacityPanel');
    	capacityPanel.add({

			xtype : 'fieldcontainer',
			layout : 'hbox',
			width: '100%',
			margin: '0 10 8 0',
			defaults : {
				labelAlign : 'top',
				width:'256'
			},
			layout : {
				type : 'hbox'
			},
			items:[{
				xtype : 'customcombobox',
				name: 'accountYearId',
				itemId: 'accountYearId',
				displayField : 'value',
				valueField : 'id',
				store:'common.AcademicTermStore',
				allowBlank:false,
				queryMode:'local',
				editable: false,
				forceSelection:true,
				msgTarget: 'qtip',
				readOnly:isViewMode?isViewMode:false,
				value:record?record.academicTerm.id:'',
				listConfig: {
					   listeners: {
						   beforeshow: function(picker) {
							   var pickerComboVal = picker.up('combobox').value;
							   picker.minWidth = picker.up('combobox').getSize().width;
							   var periodIdList = picker.up('form').getForm().getValues().accountYearId;
							   var periodArray = [], selectedIds = [];

							   if(!isNullOrEmpty(pickerComboVal)){
								   selectedIds.push(pickerComboVal);
							   }
							   for(var i in periodIdList){
								   if(typeof periodIdList[i] == "object" && periodIdList[i] != undefined){
									   periodArray.push(periodIdList[i].data.id)
								   }
								   else if(typeof periodIdList[i] == "number"){
									   periodArray.push(periodIdList[i])
								   }
							   }

							   if(periodArray.length>0 && selectedIds.length>0){
								   for(var j in selectedIds){
									   var index = periodArray.indexOf(selectedIds[j]);
									   if (index > -1) {
										   periodArray.splice(index, 1);
									   }
								   }
							   }

							   var store = picker.up('customcombobox').getStore();
							   store.clearFilter(true);
							   setTimeout(function(){
								   store.filterBy(function(record, id){
									   return !Ext.Array.contains(periodArray, id);
								   });
							   },300);
						   }
					   }
				   },
				   listeners:{
					   afterrender:function(combo){
						   combo.getStore().load();
					   }}
			},
			{
				xtype: 'numberfield',
				name: 'totalCapacity',
				itemId: 'totalCapacity',
				maxValue: 9999999999,
				maxLength:10,
				minValue : 1,
				allowBlank:false,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				msgTarget: 'qtip',
				enableKeyEvents: true,
				value:record?record.totalCapacity:'',
				readOnly:isViewMode?isViewMode:false,
				listeners: {
					keypress: function (field, e) {
		                // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
		                // or not backspace (keyCode 8), delete (keyCode 46)
		                if (e.getKey() < 48 || e.getKey() > 57) {
		                    e.preventDefault();
		                }
		            }
				}
			},{
				xtype:'numberfield',
				itemId:'totalCapacityOccupied',
				name:'totalCapacityOccupied',
				minValue : 0,
				maxValue: 9999999999,
				readOnly:true,
				hideTrigger: true,
		        keyNavEnabled: false,
		        value:record?record.totalCapacityOccupied:'',
		        mouseWheelEnabled: false,
		        value:0
			},
			{    
				xtype:'numberfield',
				itemId:'totalCapacityLeft',
				name:'totalCapacityLeft',
				minValue : 1,
				maxValue: 9999999999,
				hideTrigger: true,
		        keyNavEnabled: false,
		        value:record?record.totalCapacityLeft:'',
		        mouseWheelEnabled: false,
		        readOnly:true,
		        msgTarget: 'qtip'
			},{
				xtype: 'button',
				glyph: ICONGLYPH.DELETEGLYPH,
				itemId: 'deleteCapacityBtn',
				width: 'auto',
			//	disabled:(isView ? true : false),
				cls: 'CustomBodyBtnReject',
				hidden:isViewMode?isViewMode:false,
				tooltip: getCommonTranslation('DELETETOOLTIP'),
				listeners:{
					click:function(obj){
						var container = obj.up('fieldcontainer');
					}
				}
			},
			{
				xtype: 'button',
				itemId: 'addMoreCapacity',
				width: 'auto',
				cls: 'CustomBodyBtnSettings mtAddRow',
				width: 'auto',
				hidden:isViewMode?isViewMode:false,
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
			}]
    		
    	});
    	me.hideAddButton(capacityPanel);
    	capacityForm.down('form').getForm().isValid();
     	capacityForm.down('form').getForm().checkValidity();
     	capacityForm.down('form').getForm().clearInvalid();
    },
	hideAddButton: function(capacityPanel) {
		var this$ = this;
		var cnt = capacityPanel.items.length;
		capacityPanel.items.each(function(item, index, items) {
			var addButton = item.getComponent(item.items.length - 1);
			if (index == (items - 1)) {
				if (addButton != null) {
					addButton.show();
				}
			} else {
				if (addButton != null) {
					addButton.hide();
				}
			}
		});
	},
	deletecapacityPanelFld: function(deleteButton) {
		var me =this,
    	capacityForm = me.getHostelCapacityPlanWin(),
    	capacityPanel=capacityForm.down('#capacityPanel'),
     	container = deleteButton.up('fieldcontainer');
     	if (container != null && capacityPanel != null) {
     		if (capacityPanel.items.length > 1) {
     			capacityPanel.remove(container);
     			me.hideAddButton(capacityPanel);
     		}
     	}
     	capacityForm.down('form').getForm().isValid();
     	capacityForm.down('form').getForm().checkValidity();
     	capacityForm.down('form').getForm().clearInvalid();
     },
     getHostelCapacityRecord:function(){
    	 var me = this, 
    	 form = me.getEdithosteldetails(),
    	 resourceId= form.getForm().findField('resourceId').getValue();
    	 Ext.getBody().mask(getCommonTranslation('PLEASE_WAIT'), 'x-mask-loading')
    	 Ext.Ajax.request({
    		 url: SERVERURL.PATH_FIND_ALL_HOSTEL_CAPACITY_BY_RESOURCE_ID,
      		params:{
      			resourceId:resourceId
      		},
      		method: 'GET',
      		success: function(response) {
      			Ext.getBody().unmask();
      			Ext.widget('hostelCapacityPlanWin').show();
      			if(response.responseText){
      				var data = Ext.decode(response.responseText)
      				if(data.length){
      					me.setHostelCapacityValue(data);
      				}else{
      					me.setHostelCapacityValue([]);
      				}
      			}
      			
      		}
      	});
     },
     saveHostelCapacity:function(btn){
    	 btn.setDisabled(true);
    	 var me = this,wsHostelCapacity=[],
    	 edithosteldetailsForm = me.getEdithosteldetails(),
    	 grid = me.getManagehostelgrid(),
    	 gridRec = grid.getSelectionModel().getSelection()[0],
    	 form=btn.up('form'),
    	 capacityContainer =form.down('#capacityPanel').query('fieldcontainer');
    	 capacityContainer.forEach(function(containerItems){
    		 wsHostelCapacity.push({
			 "academicTerm":{
		            "id":containerItems.items.items[0].getValue()
		        },
		        "hostel":{
		            "id":gridRec.data.resourceId
		        },
		        "hostelCode":gridRec.data.hostelCode,
		        "hostelName":gridRec.data.hostelName,
		        "totalCapacity":containerItems.items.items[1].getValue(),
		        "totalCapacityOccupied":containerItems.items.items[2].getValue()?containerItems.items.items[2].getValue():0,
		        "totalCapacityLeft":containerItems.items.items[3].getValue()
    		 });
    	 });
    	 var params ={
    			    "resourceId":gridRec.data.resourceId,
    			    "wsHostelCapacity":wsHostelCapacity
    			};
    	 params= Ext.encode(params);
    	 me.applyWindowMask(); 
    	 Ext.Ajax.request({
    		 url: SERVERURL.PATH_SAVE_HOSTEL_CAPACITY,
      		jsonData:params,
      		method: 'POST',
      		success: function(response) {
      			me.hideWindowMask();
      			showSuccessMessage(getCommonTranslation('MANAGE_CAPACITY'),getCommonTranslation('SUCCESS'));
      			btn.up('window').close();
      			
      		}
      	});
     },
     setHostelCapacityValue:function(record){
    	 var me = this,count =0 ,isViewMode=false,
    	  winForm = me.getHostelCapacityPlanWin();
    	 if(me.getActiveTabfromContentPanel().title == getHostelTranslation('VIEW_HOSTEL_DETIALS')){
    		 isViewMode=true;
    	 }
    	 
    	 for (count;count<record.length;count++){
    		 if(count == 0 ){
    			 winForm.down('#accountYearId').getStore().load();
    			 winForm.down('#accountYearId').setReadOnly(isViewMode);
    			 winForm.down('#totalCapacity').setReadOnly(isViewMode);
    			 winForm.down('#addMoreCapacity').setVisible(!isViewMode);
    			 winForm.down('#hostelCapacitySubmitBtn').setVisible(!isViewMode);
    			 winForm.down('#accountYearId').setValue(record[count].academicTerm.id);
    			 winForm.down('#totalCapacity').setValue(record[count].totalCapacity);
    			 winForm.down('#totalCapacityOccupied').setValue(record[count].totalCapacityOccupied);
    			 winForm.down('#totalCapacityLeft').setValue(record[count].totalCapacityLeft);
    		 }else{
    			 me.addMoreCapacityRow(record[count],isViewMode)
    		 }
    	 }
    	 if(record.length ==0 && isViewMode){
    		 winForm.down('#accountYearId').setReadOnly(isViewMode);
			 winForm.down('#totalCapacity').setReadOnly(isViewMode);
			 winForm.down('#addMoreCapacity').setVisible(!isViewMode);
			 winForm.down('#hostelCapacitySubmitBtn').setVisible(!isViewMode);
    	 }
    	 
     }
});
