/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.manageroomtype.ManageRoomTypeController', {
	extend : 'Academia.controller.base.BaseController',

	models : [],
	
	stores : ['hostel.manageroomtype.RoomType','hostel.manageroomtype.ManageRoomTypeGrid','feeandpayment.managebill.FeePlanStage',
	          'personinfo.common.services.FeePlanStore','feeandpayment.managebill.BillSequence','common.StatusComboStore',
	          'scholarships.Status','hostel.manageroomtype.ChargeableNonChargeableDaysScheduleGridStore','hostel.manageroomtype.FeeHeadsStore',
	          'hostel.manageroomtype.RoomTypeWithoutFeePlan','hostel.manageroomtype.ChargeableNonChargeableDaysScheduleAddGridStore','feeandpayment.managebill.FeeRuleDefaultStage',
	          'feeandpayment.managebill.FeePlanStageDefaultStage'],
	          
	views : ['hostel.manageroomtype.ManageRoomTypeStructure','hostel.manageroomtype.ManageRoomTypeGrid','hostel.manageroomtype.CopyScheduleToWindow',
	         'hostel.manageroomtype.ManageRoomTypeSearch','hostel.manageroomtype.AddRoomType','hostel.manageroomtype.RoomTypeTabStructure','hostel.manageroomtype.RoomTypeForm',
	         'hostel.manageroomtype.ChargeableNonChargeableDaysScheduleGrid','hostel.manageroomtype.TariffPlanDetailsWindow','hostel.manageroomtype.TariffPlanDetailsEditWindow',
	         'hostel.manageroomtype.RoomTypeTabEditStructure','hostel.manageroomtype.RoomTypeEditForm','hostel.manageroomtype.ChargeableNonChargeableDaysScheduleEditGrid'],	           
	         config: {
	        	 MANAGE_ROOM_TYPE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_MANAGE_ROOM_TYPE_PRIVILEGES'),
	        	 CHARGEABLE_AND_NON_CHARGEABLE_GRID_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CHARGEABLE_AND_NON_CHARGEABLE_GRID_PRIVILEGES')
	         }, 
               
	         refs :[{
	        	 ref : 'manageroomtypesearch',
	        	 selector : 'manageroomtypesearch'
	         },{
	        	 ref : 'manageroomtypegrid',
	        	 selector : 'manageroomtypegrid'
	         },{
	        	 ref : 'addroomtype',
	        	 selector : 'addroomtype'
	         },{
	        	 ref : 'addRoomtype',
	        	 selector : 'addroomtype form'
	         },{
	        	 ref : 'contentPanel',
	        	 selector : 'contentPanel'
	         },{
	        	 ref : 'roomtypetabstructure',
	        	 selector : 'roomtypetabstructure'
	         },{
	        	 ref : 'roomtypeform',
	        	 selector : 'roomtypeform'
	         },{
	        	 ref : 'chargeablenonchargeabledaysschedulegrid',
	        	 selector : 'chargeablenonchargeabledaysschedulegrid'
	         },{
	        	 ref:'tariffplandetailswindow',
	        	 selector:'tariffplandetailswindow'
	         },{
	        	 ref:'roomtypetabeditstructure',
	        	 selector:'roomtypetabeditstructure'
	         },{
	        	 ref:'roomtypeeditform',
	        	 selector:'roomtypeeditform'
	         },{
	        	 ref:'chargeablenonchargeabledaysscheduleeditgrid',
	        	 selector:'chargeablenonchargeabledaysscheduleeditgrid'
	         },{
	        	 ref:'tariffplandetailseditwindow',
	        	 selector:'tariffplandetailseditwindow'
	         },{
            	 ref:'copyscheduletowindow',
            	 selector:'copyscheduletowindow'
             }],

	         init : function() {
	        	 this.control({
	        		 'manageroomtypesearch button[itemId=searchBtn]':{
	        			 click:function(obj){
	        				 var form = obj.up('form');
	        				 var values = form.getValues();
	        				 var roomType = values.roomType;
	        				 var status = values.status;

	        				 var grid = this.getManageroomtypegrid();
	        				 var store = grid.getStore();

	        				 store.getProxy().extraParams = {
	        					 roomTypeId: roomType,
	        					 status : status
	        				 };
	        				 store.load();
	        			 }
	        		 },
	        		 'manageroomtypegrid':{
	        			 render:function(grid){
	        				 this.doAccessControlValidation(grid, this.getMANAGE_ROOM_TYPE_PRIVILEGES());
	        				 grid.down('#copyScheduleToItemId').setVisible(true);
	        			 },
	        			 selectionchange: function(column, selected) {
	     					var $this=this;
	    					var grid = this.getManageroomtypegrid();;
	    					var copyScheduleToBtn = grid.down('#copyScheduleToItemId');
	    					if(selected.length==1){
	    						if((selected[0].data.feePlanStage=="Day Wise Calculation Stage")){
	    							copyScheduleToBtn.setDisabled(false);
	    						}
	    						else {
	    							copyScheduleToBtn.setDisabled(true);
	    						}
	    					}
	    					
	    					
	    				}
	        		 },
	        		 'addroomtype':{
	        			 render:function(form){
	        				 this.getServiceId(form);
	        			 }
	        		 },
	        		 'roomtypeeditform':{
	        			 render:function(form){
	        				 this.getServiceId(form);
	        			 }
	        		 },
	        		 'addroomtype customcombobox[itemId=feePlanType]':{
	        			 select:function(obj,record){
	        				 var feePlanTypeId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var feePlanRule = form.down('#feePlanRule');
	        				 feePlanRule.clearValue();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanId: feePlanTypeId,
	        				 };
	        				 store.load();

	        			 },
	        		 },
	        		 'addroomtype customcombobox[itemId=feePlanRule]':{
	        			 select:function(obj,record){
	        				 var feePlanRuleId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var feePlanRule = form.down('#feePlanStage');
	        				 feePlanRule.clearValue();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanRuleId: feePlanRuleId,
	        				 };
	        				 store.load();

	        			 }
	        		 },
	        		 'addroomtype customcombobox[itemId=feePlanStage]':{
	        			 select:function(obj,record){
	        				 var feePlanStageId =  record[0].get("id");
	        				 this.getFeeAmount(feePlanStageId);

	        			 }
	        		 },
	        		 'manageroomtypesearch button[itemId=resetBtn]':{
	        			 click:function(obj){
	        				 var form = obj.up('form');
	        				 form.getForm().reset();
	        			 }
	        		 },
	        		 'manageroomtypegrid button[itemId=btnAdd]':{
	        			 click:function(){
	        				 this.openAddRoomType();
	        			 }
	        		 },
	        		 'manageroomtypegrid button[itemId=btnEdit]':{
	        			 click:function(obj){
	        				 this.editRoomType(obj);
	        			 }
	        		 },
	        		 'manageroomtypegrid button[itemId=btnView]':{
	        			 click:function(obj){
	        				 this.viewRoomType(obj);
	        			 }
	        		 },
	        		 'manageroomtypegrid button[itemId=btnDelete]':{
	        			 click:function(obj){
	        				 this.deleteRoomType(obj);
	        			 }
	        		 },
	        		 'addroomtype button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 this.saveRoomType(obj);
	        			 }
	        		 },
	        		 'addroomtype button[itemId=cancelBtn]':{
	        			 click: function(){
	        				 this.resetRoomType();
	        			 }
	        		 },
	        		 'roomtypeform textfield[itemId=roomType]':{
	        			 change: function(obj){
	        				 var form = this.getRoomtypeform();
	        				 var structure = this.getRoomtypetabstructure();
	        				 var saveBtn = structure.down('#saveBtn');
	        				 var statusValue = form.down('#status').getValue();
	        				 if(form.isValid()){
	        					 saveBtn.setDisabled(false);
	        				 }else{
	        					 saveBtn.setDisabled(true);
	        				 }
	        			 }
	        		 },
	        		 'roomtypeform textfield[itemId=status]':{
	        			 change: function(obj){
	        				 var form = this.getRoomtypeform();
	        				 var structure = this.getRoomtypetabstructure();
	        				 var saveBtn = structure.down('#saveBtn');
	        				 var roomTypeValue = form.down('#roomType').getValue();
	        				 if(form.isValid()){
	        					 saveBtn.setDisabled(false);
	        				 }else{
	        					 saveBtn.setDisabled(true);
	        				 }
	        			 }
	        		 },
	        		 
	        		 'roomtypeeditform textfield[itemId=roomType]':{
	        			 change: function(obj){
	        				 var form = this.getRoomtypeeditform();
	        				 var structure = this.getRoomtypetabeditstructure();
	        				 var saveBtn = structure.down('#saveBtn');
	        				 var statusValue = form.down('#status').getValue();
	        				 if(form.isValid()){
	        					 saveBtn.setDisabled(false);
	        				 }else{
	        					 saveBtn.setDisabled(true);
	        				 }
	        			 }
	        		 },
	        		 'roomtypeeditform textfield[itemId=status]':{
	        			 change: function(obj){
	        				 var form = this.getRoomtypeeditform();
	        				 var structure = this.getRoomtypetabeditstructure();
	        				 var saveBtn = structure.down('#saveBtn');
	        				 var roomTypeValue = form.down('#roomType').getValue();
	        				 if(form.isValid()){
	        					 saveBtn.setDisabled(false);
	        				 }else{
	        					 saveBtn.setDisabled(true);
	        				 }
	        			 }
	        		 },
	        		 'roomtypetabstructure button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 this.saveRoomType(obj);
	        			 }
	        		 },
	        		 'chargeablenonchargeabledaysschedulegrid button[itemId=btnAdd]':{
	        			 click: function(obj){
	        				 var $this = this;
	        				 var formWindow = $this.getTariffplandetailswindow();
	        				 if (!formWindow) {
	        					 Ext.widget('tariffplandetailswindow');
	        					 formWindow = $this.getTariffplandetailswindow();
	        				 }
	        				 formWindow.show();
	        			 }
	        		 },
	        		 'chargeablenonchargeabledaysscheduleeditgrid button[itemId=btnAdd]':{
	        			 click: function(obj){
	        				 var $this = this;
	        				 var formWindow = $this.getTariffplandetailseditwindow();
	        				 if (!formWindow) {
	        					 Ext.widget('tariffplandetailseditwindow');
	        					 formWindow = $this.getTariffplandetailseditwindow();
	        				 }
	        				 formWindow.show();
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow button[itemId=addMoreRowBtn]':{
	        			 click: function(obj){
	        				 var tariffPlanDetailWin = this.getTariffplandetailseditwindow();
	        				 this.addRowForMultipleFeeHeads(tariffPlanDetailWin);
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow button[itemId=deleteRowBtn]':{
	        			 click: function(obj){
	        				 var form=this.getTariffplandetailseditwindow()
	        				 this.deleteRows(form,obj);
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 //this.getDatesAndDayBetweenSelectedDates();
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow button[itemId=cancelBtn]':{
	        			 click: function(obj){
	        				 this.getTariffplandetailseditwindow().close();
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow textfield[itemId=amount]':{
	        			 change: function(obj){
	        				 var tariffPlanDetailWin = this.getTariffplandetailseditwindow();
	        				 this.setSumOfAllHeads(tariffPlanDetailWin);
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow customcombobox[itemId=feeHead]':{
	        			 render: function(obj,record){
	        				 var roomTypeForm = this.getRoomtypeeditform();
	        				 var feePlanRuleId = roomTypeForm.down('#feePlanRule').getValue();
	        				 var store = obj.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanRuleId: feePlanRuleId,
	        				 };
	        				 store.load();
	        			 }
	        		 },
	        		 'tariffplandetailseditwindow button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 var form = this.getTariffplandetailseditwindow();
	        				 var grid = this.getChargeablenonchargeabledaysscheduleeditgrid();
	        				 var data = this.getDatesAndDayBetweenSelectedDates(form,grid);
	        				 var fieldContainersArray = this.getRoomtypeeditform().down('#defaultStageApplicableContainerId').items.items;
	        				 var values =  this.getRoomtypeeditform().getForm().getValues();
	        				 var roomType = new Object();
	        				 roomType.roomType=values.roomType;
	        				 roomType.feePlanRuleStageId=values.feePlanStage;
	        				 roomType.status=values.status;
	        				 roomType.id=values.id;
	        				 roomType.isDefaultStageApplicable=values.defaultStageApplicable;
	        				 var defaultStageApplicableData=new Array();
	        				 if(values.defaultStageApplicable){
	        					 Ext.each(fieldContainersArray,function (fieldContainer){
	        						 var obj = new Object();
	        						 obj.feePlan = {
	        								 id:values.feePlanType
	        						 };
	        						 obj.feePlanRule={
	        								 id:fieldContainer.items.items[0].getValue()   
	        						 };
	        						 obj.feePlanStage={
	        								 id:fieldContainer.items.items[1].getValue()   	   
	        						 };
	        						 var tempFeePlanRuleStage=fieldContainer.items.items[3].getValue();
	        						 obj.feePlanRuleStage={
	        								 id:parseFloat(tempFeePlanRuleStage)	   
	        						 };
	        						 obj.totalFeeHeadAmt = fieldContainer.items.items[2].getValue();
	        						 obj.id=fieldContainer.items.items[3].getValue();
	        						 defaultStageApplicableData.push(obj);
	        					 });
	        				 }
	                  	   roomType.wsHostelRoomTypeDefaultStageList=defaultStageApplicableData;

	        				 var recordData=new Array();
	        				 Ext.each(data,function(record){
	        					 var json = new Object();
	        					 json.day = record.day;
	        					 json.date = record.date;
	        					 json.feeHeadAmount = record.perDayTariff;
	        					 json.feeStageHeadConfigIds = record.feeStageHeadConfigIds;
	        					 json.hostelRoomType=roomType;
	        					 recordData.push(json);
	        				 });

	        				 var datesDataWithFeeHead = new Array();
	        				 Ext.each(recordData,function(record){
	        					 Ext.each(record.feeStageHeadConfigIds,function(headIds){
	        						 var jsonWithMultiHeads = new Object();
	        						 jsonWithMultiHeads.date = record.date;
	        						 jsonWithMultiHeads.day = record.day;
	        						 jsonWithMultiHeads.hostelRoomType = record.hostelRoomType;
	        						 //jsonWithMultiHeads.feeHeadAmount = record.feeHeadAmount;
	        						 jsonWithMultiHeads.feeStageHeadConfigId = headIds.headConfigId;
	        					     jsonWithMultiHeads.feeHeadAmount = headIds.headAmount;
	        						 //jsonWithMultiHeads.feeStageHeadConfigId = headIds;
	        						 datesDataWithFeeHead.push(jsonWithMultiHeads);
	        					 });
	        				 });
	        				 var formData = Ext.encode(datesDataWithFeeHead);
	        				 if(data!=undefined && form.isEditMode){
	        					 this.updateRoomTypeData(datesDataWithFeeHead)
	        				 }else{
	        				 var submitUrl = SERVERURL.UPDATE_HOSTEL_ROOM_TYPE_DAY_WISE_HEADS;
	        				 if(data!=undefined){
	        					 Ext.Ajax.request({
	        						 type : 'rest',
	        						 url : SERVERURL.PATH_FIND_DATE_EXIST,
	        						 jsonData : formData,
	        						 method : 'POST',
	        						 success : function(res, action) {
	        							 var alreadyDatesExists = Ext.decode(res.responseText);
	        							 if(alreadyDatesExists==true){
	        								 showConfirmMessage(getCommonTranslation('ALERT'),getHostelTranslation('DO_YOU_WANT_TO_OVERRIDE_DATES'),function(btn,text){
	        									 if (btn == 'yes') {
	        										 Ext.Ajax.request({
	        											 type : 'rest',
	        											 url : submitUrl,
	        											 jsonData : formData,
	        											 method : 'POST',
	        											 success : function(form1, action) {
	        												 showSuccessMessage(getHostelTranslation('ADD_ROOM_TYPE'),getCommonTranslation('SUCCESS'));
	        												 form.close();
	        												 grid.getStore().reload();
	        											 }
	        										 });
	        									 }
	        								 });
	        							 }else{
	        								 Ext.Ajax.request({
	        									 type : 'rest',
	        									 url : submitUrl,
	        									 jsonData : formData,
	        									 method : 'POST',
	        									 success : function(form1, action) {
	        										 showSuccessMessage(getHostelTranslation('ADD_ROOM_TYPE'),getCommonTranslation('SUCCESS'));
	        										 form.close();
	        										 grid.getStore().reload();
	        									 }
	        								 });
	        							 }
	        						 }
	        					 });
	        				 }
	        				
	        			 }
	        			 }
	        		 },
	        		 'tariffplandetailswindow button[itemId=addMoreRowBtn]':{
	        			 click: function(obj){
	        				 var tariffPlanDetailWin = this.getTariffplandetailswindow();
	        				 this.addRowForMultipleFeeHeads(tariffPlanDetailWin);
	        			 }
	        		 },
	        		 'tariffplandetailswindow button[itemId=deleteRowBtn]':{
	        			 click: function(obj){
	        				 var form=this.getTariffplandetailswindow();
	        				 this.deleteRows(form,obj);
	        			 }
	        		 },
	        		 'tariffplandetailswindow button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 var form = this.getTariffplandetailswindow();
	        				 var grid = this.getChargeablenonchargeabledaysschedulegrid();
	        				 this.getDatesAndDayBetweenSelectedDates(form,grid);
	        			 }
	        		 },
	        		 'tariffplandetailswindow button[itemId=cancelBtn]':{
	        			 click: function(obj){
	        				 this.getTariffplandetailswindow().close();
	        			 }
	        		 },
	        		 'tariffplandetailswindow textfield[itemId=amount]':{
	        			 change: function(obj){
	        				 var tariffPlanDetailWin = this.getTariffplandetailswindow();
	        				 this.setSumOfAllHeads(tariffPlanDetailWin);
	        			 }
	        		 },
	        		 'tariffplandetailswindow customcombobox[itemId=feeHead]':{
	        			 render: function(obj,record){
	        				 var roomTypeForm = this.getRoomtypeform();
	        				 var feePlanRuleId = roomTypeForm.down('#feePlanRule').getValue();
	        				 var store = obj.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanRuleId: feePlanRuleId,
	        				 };
	        				 store.load();
	        			 }
	        		 },
	        		 'roomtypeform':{
	        			 render:function(form){
	        				 this.getServiceId(form);
	        			 }
	        		 },
	        		 'roomtypeform customcombobox[itemId=feePlanType]':{
	        			 select:function(obj,record){
	        				 var feePlanTypeId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var structure = this.getRoomtypetabstructure();
	        				 var feePlanRule = form.down('#feePlanRule');
	        				 var feePlanStage = form.down('#feePlanStage');
	        				 var amountField = form.down('#amountToBePaid');
	        				 var grid = structure.down('#chargeablenonchargeabledaysschedulegrid');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
		            	     this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	        				 defaultStageApplicable.setDisabled(true);
	        				 defaultStageApplicable.setValue({defaultStageApplicable:false});
	        				 amountField.setVisible(true);
	        				 grid.setVisible(false);
	        				 feePlanStage.clearValue();
	        				 feePlanRule.clearValue();
	        				 amountField.reset();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanId: feePlanTypeId,
	        				 };
	        				 store.load();
	        				 var feePlanRuleDefaultStage = form.down('#feePlanRuleDefaultStageApplicableId');
	        				 var storeTemp = feePlanRuleDefaultStage.getStore();
	        				 storeTemp.getProxy().extraParams = {
	        					 feePlanId: feePlanTypeId,
	        				 };
	        				 storeTemp.load();

	        			 },
	        		 },
	        		 'roomtypeform customcombobox[itemId=feePlanRule]':{
	        			 select:function(obj,record){
	        				 var feePlanRuleId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var feePlanRule = form.down('#feePlanStage');
	        				 var amountField = form.down('#amountToBePaid');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 defaultStageApplicable.setDisabled(true);
	        				 defaultStageApplicable.setValue({defaultStageApplicable:false});
	        				 amountField.reset();
	        				 var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
		            	     this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	        				 feePlanRule.clearValue();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanRuleId: feePlanRuleId,
	        				 };
	        				 store.load();

	        			 }
	        		 },
	        		 'roomtypeform customcombobox[itemId=feePlanStage]':{
	        			 select:function(feePlanStageCombo,record){
	        				 var form = this.getRoomtypeform();
	        				 var structure = this.getRoomtypetabstructure();
	        				 var amountField = form.down('#amountToBePaid');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 var grid = structure.down('#chargeablenonchargeabledaysschedulegrid');
	        				 var feePlanRuleDefaultStageApplicable = form.down('#feePlanRuleDefaultStageApplicableId');
	        				 if(feePlanStageCombo.getDisplayValue()=='Day Wise Calculation Stage'){
	        					 amountField.setVisible(false);
	        					 grid.setVisible(true);
	        					 defaultStageApplicable.setDisabled(false);
	        					 feePlanRuleDefaultStageApplicable.allowBlank=true;
	        				 }else{
	        					 amountField.setVisible(true);
	        					 grid.setVisible(false);
	        					 defaultStageApplicable.setDisabled(true);
	        					 defaultStageApplicable.setValue({defaultStageApplicable:false});
	        					 feePlanRuleDefaultStageApplicable.allowBlank=true;
	        				 }
	        				 var feePlanStageId =  record[0].get("id");
	        				 this.getFeeAmount(feePlanStageCombo,feePlanStageId,false);

	        			 }
	        		 },
	        		 'roomtypeform customcombobox[itemId=feePlanRuleDefaultStageApplicableId]':{
	        			 select:function(obj,record){
	        				 this.setFeePlanStageAndAmountOnDefaultStageApplicable(obj,record);
	        				 var form =  this.getRoomtypeform();
	        				 var saveBtn = form.up().up().down('#saveBtn');
				           		if(form.hasInvalidField()){
				           			saveBtn.setDisabled(true);
				           		}else{
				           			saveBtn.setDisabled(false);
				           		}
	        			 }
	        		 },
	        		/* 'roomtypeform customcombobox[itemId=feePlanStageDefaultStageApplicableId]':{
	        			 select:function(feePlanStageCombo,record){
	        				 var form = this.getRoomtypeform();
	        				 var feePlanStageId =  record[0].get("id");
	        				 var feePlanRuleStageId =  record[0].get("displayOtherLanguage");
	        				 if(!isNullOrEmpty(feePlanRuleStageId)){
	        					 Ext.Ajax.request({
	        						 type : 'rest',
	        						 url : SERVERURL.PATH_FIND_FEE_HEAD_BY_FEE_RULE_STAGE_ID,
	        						 params : {
	        							 feePlanRuleStageId: feePlanRuleStageId
	        						 },
	        						 method : 'GET',
	        						 success : function(response, action) {
	        							 var res = Ext.JSON.decode(response.responseText);
	        							 if (!isNullOrEmpty(res)) {
	        								 var feeAmountTemp = 0.0;
	        								 for(var x=0;x<res.length;x++){
	        									 feeAmountTemp=feeAmountTemp+res[x].feeAmount;
	        								}
	        								 feePlanStageCombo.nextSibling().setValue(feeAmountTemp);
	        							 }
	        						 }
	        					 });
	        				 }

	        			 }
	        		 },*/
	        		 
	        		 'roomtypeeditform customcombobox[itemId=feePlanType]':{
	        			 select:function(obj,record){
	        				 var feePlanTypeId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var structure = this.getRoomtypetabeditstructure();
	        				 var feePlanRule = form.down('#feePlanRule');
	        				 var feePlanStage = form.down('#feePlanStage');
	        				 var amountField = form.down('#amountToBePaid');
	        				 var grid = structure.down('#chargeablenonchargeabledaysscheduleeditgrid');
	        				 var saveBtn = structure.down('#saveBtn');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
		            	     this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	        				 defaultStageApplicable.setDisabled(true);
	        				 defaultStageApplicable.setValue({defaultStageApplicable:false});
	        				 amountField.setVisible(true);
	        				 grid.setVisible(false);
	        				 grid.getStore().removeAll();
	        				 feePlanStage.clearValue();
	        				 feePlanRule.clearValue();
	        				 amountField.reset();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanId: feePlanTypeId,
	        				 };
	        				 store.load();
	        				 var feePlanRuleDefaultStage = form.down('#feePlanRuleDefaultStageApplicableId');
	        				 var feePlanRuleDefaultStore = feePlanRuleDefaultStage.getStore();
	        				 feePlanRuleDefaultStore.getProxy().extraParams = {
	        					 feePlanId: feePlanTypeId,
	        				 };
	        				 feePlanRuleDefaultStore.load();
	        			 },
	        		 },
	        		 'roomtypeeditform customcombobox[itemId=feePlanRule]':{
	        			 select:function(obj,record){
	        				 var feePlanRuleId =  record[0].get("id");
	        				 var form = obj.up('form');
	        				 var feePlanRule = form.down('#feePlanStage');
	        				 var amountField = form.down('#amountToBePaid');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
	        				 defaultStageApplicable.setDisabled(true);
	        				 defaultStageApplicable.setValue({defaultStageApplicable:false});
		            	     this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	        				 amountField.reset();
	        				 feePlanRule.clearValue();
	        				 var store = feePlanRule.getStore();
	        				 store.getProxy().extraParams = {
	        					 feePlanRuleId: feePlanRuleId,
	        				 };
	        				 store.load();

	        			 }
	        		 },
	        		 'roomtypeeditform customcombobox[itemId=feePlanStage]':{
	        			 select:function(obj,record){
	        				 var form = this.getRoomtypeeditform();
	        				 var structure = this.getRoomtypetabeditstructure();
	        				 var amountField = form.down('#amountToBePaid');
	        				 var grid = structure.down('#chargeablenonchargeabledaysscheduleeditgrid');
	        				 var defaultStageApplicable = form.down('#defaultStageApplicableId');
	        				 var saveBtn = structure.down('#saveBtn');
	        				 if(obj.getDisplayValue()=='Day Wise Calculation Stage'){
	        					 amountField.setVisible(false);
	        					 grid.setVisible(true);
	        					 defaultStageApplicable.setDisabled(false);
	        				 }else{
	        					 amountField.setVisible(true);
	        					 grid.setVisible(false);
	        					 defaultStageApplicable.setDisabled(true);
	        					 defaultStageApplicable.setValue({defaultStageApplicable:false});
	        				 }
	        				 var feePlanStageId =  record[0].get("id");
	        				 this.getFeeAmountOnEdit(feePlanStageId);

	        			 }
	        		 },
	        		 'chargeablenonchargeabledaysscheduleeditgrid button[itemId=btnDelete]':{
	        			 click:function(){
	        				 var grid  = this.getChargeablenonchargeabledaysscheduleeditgrid();
	        				 if (grid.getSelectionModel().getCount() > 0) {
	        						var records = grid.getSelectionModel().getSelection();
	        		            	var daysIds=[];
	        		                if(!isNullOrEmpty(records) && records.length > 0) {
	        		                    for( var i=0; i<records.length; i++ ) {
	        		                       if(!isNullOrEmpty(records[i].data.id)){
	        		                    	   daysIds.push(records[i].data.id);
	        		                    }
	        		                 }
	        		                }
	        		                var Ids = daysIds.join(',');
	        					 showConfirmMessage(getHostelTranslation('MANAGE_ROOM_TYPE'),getHostelTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	        						 if (btn == 'yes') {
	        			    				Ext.Ajax.request({
	        			    					method : "GET",
	        			    					type : 'rest',
	        			    					url : SERVERURL.DELETE_HOSTEL_ROOM_TYPE_DAY_WISE_HEADS,
	        			    					headers : {
	        			    						'Content-Type' : 'application/json'
	        			    					},
	        			    					params: {
	        			    						dayWiseFeeHeadIds: Ids
	        									},
	        									success : function(form,action) {
	        										Ext.getBody().unmask();
	        										grid.getStore().reload();
	        										showSuccessMessage(getHostelTranslation('MANAGE_ROOM_TYPE'), getCommonTranslation('SUCCESS'));

	        									}
	        			    				});
	        						 }
	        					 });
	        				 }
	        				 else{
	        					 showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('PLEASE_SELECT_RECORD'));
	        				 }
	        			 }
	        		 },
	        		 'chargeablenonchargeabledaysschedulegrid button[itemId=btnDelete]':{
	        			 click:function(){
	        				 this.deleteRecordsOnAddTabGrid();
	        			 }
	        		 },
	        		 'roomtypetabeditstructure button[itemId=saveBtn]':{
	        			 click: function(obj){
	        				 this.saveRoomTypeDeaultStageOnEdit(obj);
	        			 }
	        		 },
	        		 'manageroomtypegrid button[itemId=copyScheduleToItemId]' : {
	        			 click : this.openCopyScheduleToWindow
	        		 },
	        		 'copyscheduletowindow button[itemId=btnSubmit]':{
	        			 click: function(obj){
                            var grid = this.getManageroomtypegrid();
                            var record = grid.getSelectionModel().getSelection();
                            var gridRoomTypeId = record[0].data.id; //need to send this 
                            
                            var formWindow = this.getCopyscheduletowindow();
                            var win = this.getCopyscheduletowindow();
                            var copyRoomTypeValue = win.down('#copyRoomType').getValue();
                        	
                			                			
                			var roomTypeId=[];
                            if(!isNullOrEmpty(copyRoomTypeValue) && copyRoomTypeValue.length > 0) {
                                for( var i=0; i<copyRoomTypeValue.length; i++ ) {
                                   if(!isNullOrEmpty(copyRoomTypeValue[i].data.id)){
                                       roomTypeId.push(copyRoomTypeValue[i].data.id);
                                }
                             }
                            }
                            var Ids = roomTypeId.join(',');
                			
                			if(Ids!=""){
                				  Ext.Ajax.request({
      		    					method : "GET",
      		    					type : 'rest',
      		    					params: {
      		    						'copyRoomtypeId': gridRoomTypeId,
      		    						'roomTypeIds':Ids
      		    						
      	                            },
      		    					url : SERVERURL.PATH_COPY_TO_ROOMTYPE ,
      		    					/*headers : {
      		    						'Content-Type' : 'application/json'
      		    					},*/
      		    					
      								success : function(form,action) {
      									Ext.getBody().unmask();
      									grid.getStore().reload();
      									showSuccessMessage(getHostelTranslation('MANAGE_ROOM_TYPE'), getCommonTranslation('SUCCESS'));
      									formWindow.close();

      								}
      		    				});	
                			}else{
                				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
                			}
                          
	        			 }
	        		 },
	        		 
	        		 'copyscheduletowindow button[itemId=btnCancel]' : {
	     				click: function(obj) {
	     					this.getCopyscheduletowindow().close();
	         			}
	     			},
	     			'roomtypeeditform button[itemId=saveBtnOnEdit]':{
	        			 click: function(btn){
	        				 this.saveRoomTypeDeaultStageOnEdit(btn);
	        			 }
	        		 },
	        		 
	     			'chargeablenonchargeabledaysscheduleeditgrid button[itemId=btnEdit]':{
	     				click:function(btn){
	     					this.chargebleEditRoomType(btn);
	     				}
	     			},
	     			'chargeablenonchargeabledaysscheduleeditgrid':{
	     				selectionchange:function(cmp,selected){
	     					var chargebleGrid = this.getChargeablenonchargeabledaysscheduleeditgrid(),
	     					editBtn = chargebleGrid.down('#btnEdit');
	     					if(selected.length==1){
	     						editBtn.setDisabled(false);
	     					}else{
	     						editBtn.setDisabled(true);
	     					}
	     				},
	     				afterrender:function(cmp){
	     					var chargebleGrid = this.getChargeablenonchargeabledaysscheduleeditgrid();
	     					this.doAccessControlValidation(chargebleGrid, this.getCHARGEABLE_AND_NON_CHARGEABLE_GRID_PRIVILEGES());
	     					var roomTypeGrid = this.getManageroomtypegrid();
	     					var records = roomTypeGrid.getSelectionModel().getSelection();
	     					var id = records[0].data.id;
	     					var store = chargebleGrid.getStore();
	     					var btnAdd = chargebleGrid.down('#btnAdd'),
	     					btnDelete = chargebleGrid.down('#btnDelete');
	     					btnAdd.setVisible(true);
	     					btnDelete.setVisible(true);

	     					store.getProxy().extraParams = {
	     						roomTypeId : id,
	     					};
	     					store.load();
	     				}
	     			},
	     			'roomtypeform  radiogroup[itemId=defaultStageApplicableId]':{
	            		change:function(radioField, newValue, oldValue, eOpts){
	            	      var form = this.getRoomtypeform();
	            		  var defaultStageApplicable = radioField.getValue().defaultStageApplicable;
	            		  var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
	            		  var feePlanRuleDefaultStageApplicable = form.down('#feePlanRuleDefaultStageApplicableId');
	            		  var totalOneTimeAmtToBePaid = form.down('#totalOneTimeAmtToBePaid');
	            		  if(defaultStageApplicable){
	            			  defaultStageApplicableContainer.setVisible(true);
	            			  totalOneTimeAmtToBePaid.setVisible(true);
	            			  feePlanRuleDefaultStageApplicable.allowBlank=false;
	            			  feePlanRuleDefaultStageApplicable.setFieldLabel(getHostelTranslation('FEE_PLAN_RULE')+': <span class="required" style="color:red"> *</span>');
	            		  }else{
	            			  this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	            			  totalOneTimeAmtToBePaid.setVisible(false);
	            			  totalOneTimeAmtToBePaid.reset();
	            			  feePlanRuleDefaultStageApplicable.allowBlank=true;
	            		  }
			           		var saveBtn = form.up().up().down('#saveBtn');
			           		if(form.hasInvalidField()){
			           			saveBtn.setDisabled(true);
			           		}else{
			           			saveBtn.setDisabled(false);
			           		}
	            	  }
	            	},
	     			'roomtypeform button[itemId=addRowBtnId]':{
	     				click:function(){
	     					 var form = this.getRoomtypeform();
	     					this.addRowForDefaultStageApplicable(form);
	     				}
	     			},
	     			'roomtypeform button[itemId=deleteRowBtnId]':{
	     				click:function(button){
	     					var form = this.getRoomtypeform();
	     					this.removingRowForDefaultStageApplicable(button,form);
	     				}
	     			},
	     			'roomtypeform textfield[itemId=amountOfDefaultStageApplicableId]':{
	     				change: function(obj){
	     					var form = this.getRoomtypeform();
	     					this.setTotalAmountForDefaultStageApplicable(form);
	     				}
	     			},
	     			'roomtypeeditform button[itemId=addRowBtnId]':{
	     				click:function(){
	     					var form = this.getRoomtypeeditform();
	     					this.addRowForDefaultStageApplicable(form);
	     				}
	     			},
	     			/* 'roomtypeeditform button[itemId=saveBtnOnEdit]':{
	        			 click: function(btn){
	        				 this.saveRoomTypeDeaultStageOnEdit(btn);
	        			 }
	        		 }, */
	     			'roomtypeeditform button[itemId=deleteRowBtnId]':{
	     				click:function(button){
	     					var form = this.getRoomtypeeditform();
	     					this.removingRowForDefaultStageApplicable(button,form);
	     				}
	     			},
	     			'roomtypeeditform  radiogroup[itemId=defaultStageApplicableId]':{
	            		change:function(radioField, newValue, oldValue, eOpts){
	            		  var form = this.getRoomtypeeditform();
	            		  var defaultStageApplicable = radioField.getValue().defaultStageApplicable;
	            		  var feePlanRuleDefaultStageApplicable = form.down('#feePlanRuleDefaultStageApplicableId');
	            		  var defaultStageApplicableContainer = form.down('#defaultStageApplicableContainerId');
	            		  var totalOneTimeAmtToBePaid = form.down('#totalOneTimeAmtToBePaid');
	            		  if(defaultStageApplicable){
	            			  defaultStageApplicableContainer.setVisible(true);
	            			  feePlanRuleDefaultStageApplicable.allowBlank=false;
	            			  totalOneTimeAmtToBePaid.setVisible(true);
	            			  feePlanRuleDefaultStageApplicable.setFieldLabel(getHostelTranslation('FEE_PLAN_RULE')+': <span class="required" style="color:red"> *</span>');
	            		  }else{
	            			  this.resetMultipleFeePlanRuleStageRows(defaultStageApplicableContainer);
	            			  totalOneTimeAmtToBePaid.setVisible(false);
	            			  totalOneTimeAmtToBePaid.reset();
	            			  feePlanRuleDefaultStageApplicable.allowBlank=true;
	            		  }
	            		  
	            		  if(form.isValid()){
	            			  form.down('#saveBtnOnEdit').setDisabled(false);
	            		  }else{
	            			  form.down('#saveBtnOnEdit').setDisabled(true);
	            		  }
	            	  }
	            	},
	            	 'roomtypeeditform customcombobox[itemId=feePlanRuleDefaultStageApplicableId]':{
	        			 select:function(obj,record){
	        				 this.setFeePlanStageAndAmountOnDefaultStageApplicable(obj,record);
	        			 }
	        		 },
	        		 'roomtypeeditform textfield[itemId=amountOfDefaultStageApplicableId]':{
		     				change: function(obj){
		     					var form = this.getRoomtypeeditform();
		     					this.setTotalAmountForDefaultStageApplicable(form);
		     				}
		     			},
	        		 
	        	 });
	         },
               openAddRoomType:function(){
            	   var $this = this;
            	   var contentpanel = $this.getContentPanel();
            	   var structure = Ext.widget('roomtypetabstructure');
            	   var tabName = getHostelTranslation('ROOM_TYPE');

            	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
            	   var getTab=getcontroller.getTab(tabName);
            	   if(getTab!=null){
            		   contentpanel.remove(getTab, true);
            	   }
            	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
               
            	   /*var $this = this;
            	   	var formWindow = $this.getAddroomtype();
            	   	if (!formWindow) {
            	   		Ext.widget('addroomtype');
            	   		formWindow = $this.getAddroomtype();
            	   	}
            	   	 formWindow.show();*/
               },
               saveRoomTypeDeaultStageOnEdit:function(btn){
            	   var $this = this;
            	   var roomTypeEditForm = this.getRoomtypeeditform().getForm();
            	   var values = roomTypeEditForm.getValues();
            	   var feeplanStage = roomTypeEditForm.findField('feePlanStage').getDisplayValue();
            	   var manageRoomType = new Academia.model.hostel.manageroomtype.ManageRoomTypeGrid();
            	   var fieldContainersArray = $this.getRoomtypeeditform().down('#defaultStageApplicableContainerId').items.items;
            	   manageRoomType.set("roomType", values.roomType);
            	   manageRoomType.set("feePlanRuleStageId", values.feePlanStage);
            	   manageRoomType.set("status", values.status);
            	   manageRoomType.set("id", values.id);
            	   manageRoomType.set("isDefaultStageApplicable", values.defaultStageApplicable);
            	   var feePlanRuleArray = this.getRoomtypeeditform().query('#feePlanRuleDefaultStageApplicableId');
            	   if(this.tocheckDuplicateFeeRules(feePlanRuleArray)){
            		   return showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('DUPLICATE_FEE_RULE_SELECTED'));
            	   }
            	   var defaultStageApplicableData=new Array();
            	   if(values.defaultStageApplicable){
            		   Ext.each(fieldContainersArray,function (fieldContainer){
            			   var obj = new Object();
            			   obj.feePlan = {
            					   id:values.feePlanType
            			   };
            			   obj.feePlanRule={
            					   id:fieldContainer.items.items[0].getValue()   
            			   };
            			   obj.feePlanStage={
            					   id:fieldContainer.items.items[1].getValue()   	   
            			   };
            			   var tempFeePlanRuleStage=fieldContainer.items.items[3].getValue();
            			   obj.feePlanRuleStage={
            					  id:parseFloat(tempFeePlanRuleStage)	   
            			   };
            			   obj.totalFeeHeadAmt = fieldContainer.items.items[2].getValue();
            			   obj.id=fieldContainer.items.items[3].getValue();
            			   defaultStageApplicableData.push(obj);
            		   });
            	   }
            	   manageRoomType.set("wsHostelRoomTypeDefaultStageList", defaultStageApplicableData);
            	   
            	   submitUrl = SERVERURL.HOSTEL_ROOM_TYPE_UPDATE;
            	   delete manageRoomType.data.feePlanRule;
            	   delete manageRoomType.data.feePlanType;
            	   delete manageRoomType.data.feePlanName;
            	   delete manageRoomType.data.feePlanStage;
            	   delete manageRoomType.data.feePlanRuleId;
            	   delete manageRoomType.data.feePlanId;

            	   var formData = Ext.encode(manageRoomType.data);
            	   Ext.Ajax.request({
            		   type : 'rest',
            		   url : submitUrl,
            		   jsonData : formData,
            		   method : 'POST',
            		   success : function(form1, action) {
            			   showSuccessMessage(getHostelTranslation('ADD_ROOM_TYPE'),getCommonTranslation('SUCCESS'));
            			   //$this.resetRoomType();
            			  /* var roomTypeSearch = $this.getManageroomtypesearch();
            			   roomTypeSearch.down('#roomTypeId').getStore().load();*/
            			   var grid = $this.getManageroomtypegrid();
            			   grid.getSelectionModel().deselectAll(true);
            			   grid.getStore().reload();
            			   var tabName = getHostelTranslation('ROOM_TYPE');
            			   var getcontroller=$this.getController('menu.CoreERPNavigationController');
            			   var roomTypeEditForm = $this.getRoomtypeeditform().getForm();
                    	   var feeplanStage = roomTypeEditForm.findField('feePlanStage').getDisplayValue();
            			   var getTab=getcontroller.getTab(tabName);
            			   if(getTab!=null && feeplanStage!='Day Wise Calculation Stage'){
            				   contentPanel.remove(getTab, true);
            			   }

            		   }
            	   });
               },
               saveRoomType:function(obj){
            	   var $this = this;
            	   var form = $this.getRoomtypeform().getForm();
            	   var values = form.getValues();
            	   var feeplanStage = form.findField('feePlanStage').getDisplayValue();
            	   var manageRoomType = new Academia.model.hostel.manageroomtype.ManageRoomTypeGrid();
            	   var submitUrl;
            	   var feePlanRuleArray = $this.getRoomtypeform().query('#feePlanRuleDefaultStageApplicableId');
            	   if(this.tocheckDuplicateFeeRules(feePlanRuleArray)){
            		   return showWarningMessage(getHostelTranslation('ALERT'),getCommonTranslation('DUPLICATE FEE RULE SELECTED'));
            	   }
            	   if(feeplanStage=='Day Wise Calculation Stage'){
            		   var grid = this.getChargeablenonchargeabledaysschedulegrid();
                	   var gridStore = grid.getStore();
                	   var gridData = gridStore.data.items;
                	   var fieldContainersArray = $this.getRoomtypeform().down('#defaultStageApplicableContainerId').items.items;
                	   submitUrl = SERVERURL.SAVE_HOSTEL_ROOM_TYPE_DAY_WISE_HEADS;
                	   var roomType = new Object();
                	   roomType.roomType=values.roomType;
                	   roomType.feePlanRuleStageId=values.feePlanStage;
                	   roomType.status=values.status;
                	   roomType.isDefaultStageApplicable=values.defaultStageApplicable;
                	   
                	   var defaultStageApplicableData=new Array();
                	   if(values.defaultStageApplicable){
                		   Ext.each(fieldContainersArray,function (fieldContainer){
                			   var obj = new Object();
                			   obj.feePlan = {
                					   id:values.feePlanType
                			   };
                			   obj.feePlanRule={
                					   id:fieldContainer.items.items[0].getValue()   
                			   };
                			   obj.feePlanStage={
                					   id:fieldContainer.items.items[1].getValue()   	   
                			   };
                			   var tempFeePlanRuleStage=fieldContainer.items.items[3].getValue();
                			   obj.feePlanRuleStage={
                					  id:parseFloat(tempFeePlanRuleStage)	   
                			   };
                			   obj.totalFeeHeadAmt = fieldContainer.items.items[2].getValue();
                			   defaultStageApplicableData.push(obj);
                		   });
                	   }
                	   roomType.wsHostelRoomTypeDefaultStageList=defaultStageApplicableData;
                	   var recordData=new Array();
                	   Ext.each(gridData,function(record){
                		   var json = new Object();
                		   json.day = record.data.day;
                		   json.date = record.data.date;
                		   json.feeHeadAmount = record.data.perDayTariff;
                           json.feeStageHeadConfigIds = record.data.feeStageHeadConfigIds;
                		   json.hostelRoomType=roomType;
                		   recordData.push(json);
                	   });
                	   
                	   var datesDataWithFeeHead = new Array();
                	   Ext.each(recordData,function(record){
                		   Ext.each(record.feeStageHeadConfigIds,function(headIds){
                			   var jsonWithMultiHeads = new Object();
                			   jsonWithMultiHeads.date = record.date;
                			   jsonWithMultiHeads.day = record.day;
                			   jsonWithMultiHeads.hostelRoomType = record.hostelRoomType;
//                			   jsonWithMultiHeads.wsHostelRoomTypeDefaultStageList = defaultStageApplicableData;
                			   //jsonWithMultiHeads.feeHeadAmount = record.feeHeadAmount;
                			   jsonWithMultiHeads.feeStageHeadConfigId = headIds.headConfigId;
                			   jsonWithMultiHeads.feeHeadAmount = headIds.headAmount;
                			   datesDataWithFeeHead.push(jsonWithMultiHeads);
                		   });
                	   });
                	   
                	   if(recordData.length==0){
                		   var json= new Object();
            			   json.hostelRoomType = roomType;
            			   datesDataWithFeeHead.push(json);
                	   }
                	   var formData = Ext.encode(datesDataWithFeeHead);
            	   }else{

            	 	   manageRoomType.set("roomType", values.roomType);
                	   manageRoomType.set("feePlanRuleStageId", values.feePlanStage);
                	   manageRoomType.set("status", values.status);
                	
                	  /* if (form.roomTypeEditForm('id').getValue() == null
                			   || form.roomTypeEditForm('id').getValue() == "") {
                		   submitUrl = SERVERURL.HOSTEL_ROOM_TYPE_CREATE;
                	   } else {
                		   manageRoomType.set("id", values.id);
                		   submitUrl = SERVERURL.HOSTEL_ROOM_TYPE_UPDATE;
                	   }*/
                	   submitUrl = SERVERURL.HOSTEL_ROOM_TYPE_CREATE;
                	   delete manageRoomType.data.feePlanRule;
                	   delete manageRoomType.data.feePlanType;
                	   delete manageRoomType.data.feePlanName;
                	   delete manageRoomType.data.feePlanStage;
                	   delete manageRoomType.data.feePlanRuleId;
                	   delete manageRoomType.data.feePlanId;
                	   delete manageRoomType.data.isDefaultStageApplicable;
                	   delete manageRoomType.data.wsHostelRoomTypeDefaultStageList;
                	   
                	   var formData = Ext.encode(manageRoomType.data);
            	   }
            	  
            	   Ext.Ajax.request({
            		   type : 'rest',
            		   url : submitUrl,
            		   jsonData : formData,
            		   method : 'POST',
            		   success : function(form1, action) {
            			   showSuccessMessage(getHostelTranslation('ADD_ROOM_TYPE'),getCommonTranslation('SUCCESS'));
            			   //$this.resetRoomType();
            			   var roomTypeSearch = $this.getManageroomtypesearch();
            			   roomTypeSearch.down('#roomTypeId').getStore().load();
            			   var grid = $this.getManageroomtypegrid();
            			   grid.getSelectionModel().deselectAll(true);
            			   grid.getStore().reload();
            			   var tabName = getHostelTranslation('ROOM_TYPE');
            			   var getcontroller=$this.getController('menu.CoreERPNavigationController');
            			   var getTab=getcontroller.getTab(tabName);
            			   if(getTab!=null){
            				   contentPanel.remove(getTab, true);
            			   }
            		   }
            	   });

               },
               editRoomType:function(obj){
            	   var $this = this;
            	   viewMode=false;
            	   var grid = this.getManageroomtypegrid();
            	   if (grid.getSelectionModel().getCount() > 0) {
            		   var records = grid.getSelectionModel().getSelection();
            		   var contentpanel = $this.getContentPanel();
                	   var structure = Ext.widget('roomtypetabeditstructure');
                	   var roomTypeEditForm = $this.getRoomtypeeditform().getForm();
                	   var tabName = getHostelTranslation('ROOM_TYPE');
                	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
                	   var getTab=getcontroller.getTab(tabName);
                	   if(getTab!=null){
                		   contentpanel.remove(getTab, true);
                	   }
                	   openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
            		   if (records != undefined && records != ""&& records != null) {
            			   var id = records[0].data.id;
            			   structure.down('#id').setValue(id);
            			   Ext.Ajax.request({
            				   type : 'rest',
            				   url : SERVERURL.ROOM_TYPE_FIND_BY_ID,
            				   params : {
            					   id : id
            				   },
            				   method : 'GET',
            				   success : function(response) {
            					   var form = $this.getRoomtypeeditform();
            					   var roomTypeForm = form.getForm();
            					   var data = Ext.decode(response.responseText);
            					   var manageRoomType = new Academia.model.hostel.manageroomtype.ManageRoomTypeGrid(data);
            					   form.loadRecord(manageRoomType);
                                   var defaultStageApplicable = roomTypeForm.findField('defaultStageApplicable');
                                   defaultStageApplicable.setValue({defaultStageApplicable:data.isDefaultStageApplicable});
            					   if(data.isDefaultStageApplicable){
            						   Ext.Ajax.request({
            		            		   type : 'rest',
            		            		   url : SERVERURL.PATH_FIND_ALL_DEFAULT_STAGE_HOSTEL_ROOM_TYPE,
            		            		   params : {
            		            			   roomTypeId: id
            		            		   },
            		            		   method : 'GET',
            		            		   success : function(response, action) {
            		            			   var res = Ext.JSON.decode(response.responseText);
            		            				addMoreRowBtn = form.down('#addRowBtnId');
            					   				if(res.length > 1){
            					   					for(count = 1 ; count <= res.length-1; count++){
            					   						addMoreRowBtn.fireEvent('click');
            					   					}
            					   				}
            					   				Ext.defer(function(){
            					   					var feePlanRuleField = form.query('#feePlanRuleDefaultStageApplicableId');
            						   				var feePlanStageField = form.query('#feePlanStageDefaultStageApplicableId');
            						   				var amountField = form.query('#amountOfDefaultStageApplicableId');
            						   				var containerRowId = form.query('#containerRowId');
            						   				for(count = 0;count<feePlanRuleField.length;count++){
            						   					containerRowId[count].setValue(res[count].id);
            						   					feePlanRuleField[count].setValue(res[count].feePlanRule.id);
            						   					$this.setFeePlanStageAndAmountOnDefaultStageApplicable(feePlanRuleField[count],res[count].feePlanRule.id);
            						   				}
            					   				},400);
            		            		   }
            		            	   });
            					   }
            					   
            					 
            					   var serviceId = roomTypeForm.findField('serviceId').getValue();
            					   var feePlanId = records[0].data.feePlanId;
            					   
            					   var feePlanRuleId = records[0].data.feePlanRuleId;
            					   var feePlanRuleStageId = records[0].data.feePlanRuleStageId;
            					   

        						   Ext.Ajax.request({
        		            		   type : 'rest',
        		            		   url : SERVERURL.GET_SERVICE_ID,
        		            		   params : {
        		            			   serviceName: 'Hostel'
        		            		   },
        		            		   method : 'GET',
        		            		   success : function(form, action) {
        		            			   var res = Ext.JSON.decode(form.responseText);
        		            			   var serviceId;
        		            			   if (!isNullOrEmpty(res) && res.length > 0) {
        		            				   serviceId = res[0].id;
        		            			   }
        		            			   if(!isNullOrEmpty(serviceId) && !isNullOrEmpty(feePlanId) ){
                    						   var feePlanType = roomTypeForm.findField('feePlanType');
                    						   var feePlanTypeStore = feePlanType.getStore();
                    						   feePlanTypeStore.getProxy().extraParams = {
                    							   serviceId: serviceId
                    						   };
                    						   feePlanTypeStore.load({
                    							   callback: function(record, operation, success) {
                    								   if (success) {
                    									   feePlanType.setValue(feePlanId);
                    								   }
                    							   }
                    						   });
                    					   }
        		            		   }
        		            	   });	
        					   
            					   
                				   var feePlanRule = roomTypeForm.findField('feePlanRule');
            					   var feePlanRuleStore = feePlanRule.getStore();
            					   feePlanRuleStore.getProxy().extraParams = {
            						   feePlanId: feePlanId
    		                	   };
            					   feePlanRuleStore.load({
    	                			   callback: function(record, operation, success) {
    	                				   if (success) {
    	                						   feePlanRule.setValue(feePlanRuleId);
    	                					   }
    	                				   }
    		                	   });
            					   
            					   var feePlanRuleDefaultStageApplicable = roomTypeForm.findField('feePlanRuleDefaultStageApplicable');
            					   var feePlanRuleDefaultStore = feePlanRuleDefaultStageApplicable.getStore();
            					   feePlanRuleDefaultStore.getProxy().extraParams = {
            						   feePlanId: feePlanId
    		                	   };
            					   feePlanRuleDefaultStore.load({
    	                			   callback: function(record, operation, success) {
    	                				   if (success) {
    	                						   //feePlanRule.setValue(feePlanRuleId);
    	                					   }
    	                				   }
    		                	   });
            					   var feePlanStageDefaultStageApplicable = roomTypeForm.findField('feePlanStageDefaultStageApplicable');
            					   var feePlanStageDefaultStore = feePlanStageDefaultStageApplicable.getStore();
            					   feePlanStageDefaultStore.getProxy().extraParams = {
            						   feePlanRuleId: feePlanRuleId
            					   };
            					   feePlanStageDefaultStore.load({
            						   callback: function(record, operation, success) {
            							   if (success) {
            								   //feePlanRule.setValue(feePlanRuleId);
            							   }
            						   }
            					   });
            					   var feePlanStage = roomTypeForm.findField('feePlanStage');
            					   var feePlanStageStore = feePlanStage.getStore();
            					   feePlanStageStore.getProxy().extraParams = {
            						   feePlanRuleId: feePlanRuleId
    		                	   };
            					   feePlanStageStore.load({
            						   callback: function(record, operation, success) {
            							   if (success) {
            								   var amountField = roomTypeForm.findField('amountToBePaid');
            								   var structure = $this.getRoomtypetabeditstructure();
            								   var saveBtn = structure.down('#saveBtn');
            								   var defaultStageApplicable = roomTypeForm.findField('defaultStageApplicable');
            								   var grid = structure.down('chargeablenonchargeabledaysscheduleeditgrid');
            								   if(grid.getStore().data.items.length==0){
            									   grid.down('custompagingtoolbar').setHeight(365);  //no records to display was appearing in middle of grid
            								   }
            								   feePlanStage.setValue(feePlanRuleStageId);
            								   $this.getFeeAmountOnEdit(feePlanRuleStageId);
            								   if(feePlanStage.getDisplayValue()=='Day Wise Calculation Stage'){
            									   amountField.setVisible(false);
            									   grid.setVisible(true);
            									   defaultStageApplicable.setDisabled(false);

            								   }else{
            									   amountField.setVisible(true);
            									   grid.setVisible(false);
            									   defaultStageApplicable.setDisabled(true);
            								   }
            							   }
            						   }
    		                	   });
            					   grid.getSelectionModel().deselectAll(true);
                    			   grid.getStore().reload();
            				   }
            			   });
            		   }
            	   } else {
            		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            	   }

               },
               viewRoomType:function(){
            	   this.editRoomType();
            	   viewMode=true;
            	   var forms = this.getRoomtypeeditform();
            	   var structure = this.getRoomtypetabeditstructure();
            	   var grid = this.getChargeablenonchargeabledaysscheduleeditgrid();
            	   var form = forms.getForm();
            	   structure.down('#saveBtn').hide();
            	   structure.down('#saveBtnOnEdit').hide();
            	   grid.down('#btnAdd').setDisabled(true);
            	   grid.down('#btnDelete').setDisabled(true);
            	   toggleReadOnlyFormItems(form, true);
               },
               deleteRoomType:function(){
            	   var grid = this.getManageroomtypegrid();
            	   if (grid.getSelectionModel().getCount() > 0) {
            		   showConfirmMessage(getHostelTranslation('MANAGE_ROOM_TYPE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
            				   function(btn, text) {
            			   if (btn == 'yes') {
            				   var records = grid.getSelectionModel().getSelection()[0];
            				   var id = records.data.id;
            				   Ext.Ajax.request({
            					   method : "DELETE",
            					   type : 'rest',
            					   url : SERVERURL.ROOM_TYPE_DELETE + '?id=' + id,
            					   headers : {
            						   'Content-Type' : 'application/json'
            					   },
            					   success : function(form, action) {
            						   showSuccessMessage(getHostelTranslation('MANAGE_ROOM_TYPE'), getCommonTranslation('SUCCESS'));
            						   grid.getStore().reload();

            					   }
            				   });
            			   }
            		   });
            	   } else {
            		   showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('PLEASE_SELECT_RECORD'));
            	   }


               },
               
               getServiceId:function(form){
            	   var roomTypeForm = form.getForm();
            	   var feePlanType = roomTypeForm.findField('feePlanType');
            	   var feePlanTypeStore = feePlanType.getStore();
            	   
            	   Ext.Ajax.request({
            		   type : 'rest',
            		   url : SERVERURL.GET_SERVICE_ID,
            		   params : {
            			   serviceName: 'Hostel'
            		   },
            		   method : 'GET',
            		   success : function(form, action) {
            			   var res = Ext.JSON.decode(form.responseText);
            			   if (!isNullOrEmpty(res) && res.length > 0) {
            				   var serviceId = res[0].id;
            				   roomTypeForm.findField('serviceId').setValue(serviceId);

            				   feePlanTypeStore.getProxy().extraParams = {
            					   serviceId: serviceId
            				   };
            				   feePlanTypeStore.load();
            			   }else{
            				   roomTypeForm.findField('serviceId').setValue(null);
            				   feePlanTypeStore.getProxy().extraParams = {
            					   serviceId: null
            				   };
            				   feePlanTypeStore.load();
            			   }
            		   }
            	   });	            },
            	   getFeeAmount:function(feePlanStageCombo,feePlanStageId,isDefaultStageApplicable){
            		  // var roomTypeForm = this.getAddRoomtype().getForm();
            		   var $this = this;
            		   var roomTypeForm = this.getRoomtypeform();
            		   Ext.Ajax.request({
                		   type : 'rest',
                		   url : SERVERURL.BILL_FEE_STAGE_CONFID,
                		   params : {
                			   feePlanRuleStageId: feePlanStageId
                		   },
                		   method : 'GET',
                		   success : function(form, action) {
                			   var res = Ext.JSON.decode(form.responseText);
                			   if (!isNullOrEmpty(res)) {
                				   if(isDefaultStageApplicable){
                					   var sumOfHeadsAmount = $this.getSumOfAllFeeHeadAmount(res);
                					   feePlanStageCombo.nextSibling().setValue(sumOfHeadsAmount);
                				   }else{
                					   var feeAmount = res.rows[0].sumofFeeStageHeadAmount;
                					   roomTypeForm.down('#amountToBePaid').setValue(feeAmount);
                				   }
                			   }
                		   }
                	   });	
            		   
            	   },
            	   getFeeAmountOnEdit:function(feePlanStageId){
             		  // var roomTypeForm = this.getAddRoomtype().getForm();
            		   var roomTypeForm = this.getRoomtypeeditform();
            		   if(!isNullOrEmpty(feePlanStageId)){
            			   Ext.Ajax.request({
                     		   type : 'rest',
                     		   url : SERVERURL.BILL_FEE_STAGE_CONFID,
                     		   params : {
                     			   feePlanRuleStageId: feePlanStageId
                     		   },
                     		   method : 'GET',
                     		   success : function(form, action) {
                     			   var res = Ext.JSON.decode(form.responseText);
                     			   if (!isNullOrEmpty(res)) {
                     				   var feeAmount = res.rows[0].sumofFeeStageHeadAmount;
                     				   roomTypeForm.down('#amountToBePaid').setValue(feeAmount);
                     			   }
                     		   }
                     	   });
            		   }
             	   },
               resetRoomType:function(obj){
            	   this.getAddroomtype().close();
               },
               addRowForMultipleFeeHeads:function(tariffPlanDetailWin){
            	   var $this = this;
            	  // var tariffPlanDetailWin = $this.getTariffplandetailswindow();
            	   var feeHeadsContainer = tariffPlanDetailWin.down('#feeHeadContainerId');
            	   var panelItem = new Array();
            	   var newcont=feeHeadsContainer.items.items.length;
            	   var insertPosition=newcont+1;

            	   panelItem.push({
            		   xtype : 'fieldcontainer',
            		   width: '100%',
            		   layout : 'hbox',
            		   cls:'feeHeadsContainer',
            		   defaults: {
            			   labelAlign: 'top',
            		   },
            		   items : [{
            			   xtype : 'customcombobox',
            			   name : 'feeHead',	
            			   itemId:'feeHead',
            			   allowBlank:false,
            			   store: 'hostel.manageroomtype.FeeHeadsStore',
            			   displayField: 'feeHeadName',
            			   valueField: 'id',
            			   labelSeparator:'',
            			   fieldLabel:getHostelTranslation('FEE_HEAD')+': <span class="required" style="color:red"> *</span>',
            			   listeners: {
            				   change: function(combo, newValue, oldValue, eOpts) {
            					   if(combo.findRecordByValue(newValue)) {
            						   combo.nextSibling().setValue(combo.findRecordByValue(newValue).get('feeAmount'));
            						   combo.nextSibling().nextSibling().setValue(combo.findRecordByValue(newValue).get('feeStageHeadConfigId'));
            					   }
            				   },
            			   }
            		   },{
            			   xtype : 'textfield',
            			   allowBlank:false,
            			   name : 'amount',	
            			   itemId:'amount',
            			   style:{
   							marginLeft:'14px !important'
   						   },
            			   labelSeparator:'',
            			   fieldLabel:getHostelTranslation('AMOUNT')+': <span class="required" style="color:red"> *</span>',
            			   validator: function(value) {
   						    if (value > 0) {
   						        return true;  // Valid value
   						    }
   						    return 'Please enter a positive amount';  // Error message
   						}
            		   },{
            				xtype: 'hidden',
            				name: 'feeStageHeadConfigurationId',
            				itemId: 'feeStageHeadConfigId'
            			},{
            			   xtype: 'button',
            			   itemId: 'addMoreRowBtn',
            			   cls: 'CustomBodyBtnSettings',
            			   text: getCommonTranslation('ADDBUTTONTEXT'),
            			   tooltip: getCommonTranslation('ADD'),
            			   style:{
            				   marginTop:'30px'
            			   }
            		   },{
            			   xtype: 'button',
            			   itemId: 'deleteRowBtn',
            			   glyph: ICONGLYPH.DELETEGLYPH,
            			   cls: 'CustomBodyBtnReject',
            			   tooltip: getCommonTranslation('DELETETOOLTIP'),
            			   style:{
            				   marginTop:'30px',
            				   marginLeft:'8px !important'
            			   }
            		   }]
            	   });
            	   feeHeadsContainer.insert(insertPosition,panelItem);
            	   feeHeadsContainer.doLayout();
            	   var saveBtn = tariffPlanDetailWin.down('#saveBtn');
            	   if(tariffPlanDetailWin.down('form').isValid()){
					   saveBtn.setDisabled(false);
				   }else{
					   saveBtn.setDisabled(true);
				   }
               },
               deleteRows:function(form,obj){
            	   var this$ = this;
            	  // var form=this$.getTariffplandetailswindow()
            	   var feeHeadsContainer = form.down('#feeHeadContainerId');
            	   var saveBtn = form.down('#saveBtn');
            	   var container = obj.up('fieldcontainer');
            	   var saveBtn = form.down('#saveBtn');
            	   if (container != null && feeHeadsContainer != null) {
            		   if (feeHeadsContainer.items.length > 1) {
            			   feeHeadsContainer.remove(container);
            		   }
            	   }
            	   if(form.down('form').isValid()){
					   saveBtn.setDisabled(false);
				   }else{
					   saveBtn.setDisabled(true);
				   }
            	   this.setSumOfAllHeads(form);
               },
               setSumOfAllHeads:function(tariffPlanDetailWin){
            	   //var tariffPlanDetailWin = this.getTariffplandetailswindow();
				   var feeHeadsContainer = tariffPlanDetailWin.down('#feeHeadContainerId');
				   var defaultTariffAmount = tariffPlanDetailWin.down('#defaultTariffAmount');
				   var sumOfFeeHeads=0;
				   var fieldContainers = feeHeadsContainer.items.items;
				   Ext.each(fieldContainers,function (fieldContainer){
					   var amountField = fieldContainer.items.items[1];
					   if(!isNullOrEmpty(amountField.getValue())){
						  sumOfFeeHeads=sumOfFeeHeads+parseFloat(amountField.getValue());
					   }
				   });
				   defaultTariffAmount.setValue(sumOfFeeHeads);
               },
               getDatesAndDayBetweenSelectedDates:function(form,grid){
            	   var feeHeadsContainer = form.down('#feeHeadContainerId');
            	   var gridStore = grid.getStore();
            	   var defaultTariffAmount = form.down('#defaultTariffAmount').getValue();
            	   var fromDate = form.down('#fromDateId').getValue();
            	   var toDate = form.down('#toDateId').getValue();
            	   var date = new Date(fromDate.getTime());
            	   var finalData=new Array();
            	   var dates = [];
            	   var day = [];
            	   var feeStageHeadConfigIds = [];
            	   var fieldContainers = feeHeadsContainer.items.items;
				   Ext.each(fieldContainers,function (fieldContainer){
					   var headConfigId = parseFloat(fieldContainer.items.items[2].getValue());
					   var headAmount = parseFloat(fieldContainer.items.items[1].getValue());
					   var obj = new Object();
					   obj.headConfigId = headConfigId;
					   obj.headAmount = headAmount;
					   feeStageHeadConfigIds.push(obj);
				   });
				   
				   var duplicateHeadsExist = false;
				   
				   var valuesSoFar = [];
				    for (var i = 0; i < feeStageHeadConfigIds.length; ++i) {
				        var value = feeStageHeadConfigIds[i].headConfigId;
				        if (valuesSoFar.indexOf(value) !== -1) {
				        	duplicateHeadsExist=true;
				        }
				        valuesSoFar.push(value);
				    }
				   
				  
				   if(duplicateHeadsExist){
					   return  showWarningMessage(getCommonTranslation('ALERT'), getHostelTranslation('DUPLICATE_FEE_HEADS_SELECTED'));
				   }else{
					   while (date <= toDate) {
						   var gridData=new Object();
						   gridData.date = Ext.Date.format(date,'Y-m-d');
						   dates.push(dateRender(date));
						   if(date.getDay()==1){
							   gridData.day = 'Monday';
						   }else if(date.getDay()==2){
							   gridData.day = 'Tuesday';
						   }else if(date.getDay()==3){
							   gridData.day = 'Wednesday';
						   }else if(date.getDay()==4){
							   gridData.day = 'Thursday';
						   }else if(date.getDay()==5){
							   gridData.day = 'Friday';
						   }else if(date.getDay()==6){
							   gridData.day = 'Saturday';
						   }else if(date.getDay()==0){
							   gridData.day = 'Sunday';
						   }
						   gridData.perDayTariff=defaultTariffAmount;
						   gridData.feeStageHeadConfigIds = feeStageHeadConfigIds;
						   finalData.push(gridData);
						   date.setDate(date.getDate() + 1);
					   }
					   if(form.xtype=='tariffplandetailswindow'){
						   var extstingData = gridStore.data.items;
						   Ext.each(finalData,function (newData){
							   for( var i = 0; i < extstingData.length; i++){ 

								   if (extstingData[i].data.date === newData.date) { 
									   newData.newData=extstingData[i].data.feeStageHeadCOnfigId;
									   gridStore.removeAt(i);
								   }
							   }
						   });
						   gridStore.add(finalData);
						   gridStore.sort({
							   property : 'date',
							   direction : 'ASC'
						   });
						   var gridDom = grid.el ? grid.el.dom : null;
						   form.close();
					   }else{
						   return finalData;
					   }
				   }
               },
               deleteRecordsOnAddTabGrid:function(){
            	   var grid = this.getChargeablenonchargeabledaysschedulegrid();
            	   if (grid.getSelectionModel().getCount() > 0) {
            		   var record = grid.getSelectionModel().getSelection()[0];
            		   var dateToBeDelete = record.data.date;
            		   var store = grid.getStore();
            		   var extstingData = store.data.items;
            		   var gridDom = grid.el ? grid.el.dom : null;
            		   showConfirmMessage(getCommonTranslation('ALERT'),getHostelTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
            			   if (btn == 'yes') {
    						   Ext.each(extstingData,function (data,index){
    								   if (data!=undefined && data.data.date === dateToBeDelete){ 
    									   store.removeAt(index);
    									   gridDom.nextElementSibling.children[0].innerHTML=getCommonTranslation('TOTAL_RECORDS')+": "+ store.getCount();
    								   }
    						   });
            			   }
            		   });
            	   }
            	   else{
            		   showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('PLEASE_SELECT_RECORD'));
            	   }
               },
               openCopyScheduleToWindow:function(){
            	   var $this = this;
            	   var grid = this.getManageroomtypegrid();
            	   if (grid.getSelectionModel().getCount() > 0){
           			var formWindow = this.getCopyscheduletowindow();
           			if (!formWindow) {
           				Ext.widget('copyscheduletowindow');
           				formWindow = this.getCopyscheduletowindow();
           			}
           			formWindow.show();
           		}
           		else {
           			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
           		}

           	},
           	chargebleEditRoomType:function(btn){
           		var me = this,rec,dateVal,amountFields,feeHeadField,feesHeadForm,addMoreRowBtn,feeStageHeadConfigId,
           		chrgebleGrid = me.getChargeablenonchargeabledaysscheduleeditgrid(),
           		sellMOdel= chrgebleGrid.getSelectionModel();
           		if(sellMOdel.getCount()){
           			rec = sellMOdel.getSelection()[0];
           			dateVal = Ext.Date.format(new Date(rec.data.date), 'Y/m/d');
           		 Ext.Ajax.request({
					 type : 'rest',
					 url : SERVERURL.PATH_EDIT_ROOM_TYPE ,
					 method : 'GET',
					 params:{
						 roomTypeId:me.getRoomtypeeditform().down('#id').value,
						 date:dateVal
					 },
					 success : function(res, action) {
						 var manageFeeData = Ext.decode(res.responseText),
						 formWindow = me.getTariffplandetailseditwindow();
						 	 if (!formWindow) {
			   					 Ext.widget('tariffplandetailseditwindow');
			   					 formWindow = me.getTariffplandetailseditwindow();
			   				 }
			   				formWindow.isEditMode = true; 
			   				formWindow.down('#fromDateId').setVisible(false);
			   				formWindow.down('#fromDateId').allowBlank=true;
			   				formWindow.down('#toDateId').setVisible(false);
			   				formWindow.down('#toDateId').allowBlank=true;
			   				formWindow.show();
			   				formWindow.isEditMode = true;
			   				formWindow.manageFeeData = manageFeeData;
			   				formWindow.down('#fromDateId').setValue(dateRender(rec.data.date));
			   				formWindow.down('#toDateId').setValue(dateRender(rec.data.date));
			   				feesHeadForm = formWindow.down('form');
			   				addMoreRowBtn = feesHeadForm.down('#addMoreRowBtn');
			   				if(manageFeeData.length > 1){
			   					for(count = 1 ; count <= manageFeeData.length-1; count++){
			   						addMoreRowBtn.fireEvent('click');
			   					}
			   				}
			   				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			   				Ext.defer(function(){
			   					amountFields = feesHeadForm.query('#amount');
				   				feeHeadField = feesHeadForm.query('#feeHead');
				   				feeStageHeadConfigId = feesHeadForm.query('#feeStageHeadConfigId');
				   				for(count = 0;count<feeHeadField.length;count++){
				   					feeHeadField[count].suspendEvent('change');
				   					feeHeadField[count].setValue(manageFeeData[count].feeHeadId);
				   					amountFields[count].setValue(manageFeeData[count].feeHeadAmount);
				   					feeStageHeadConfigId[count].setValue(manageFeeData[count].feeStageHeadConfigId);
				   					feeHeadField[count].resumeEvent('change');
				   				}
				   				Ext.getBody().unmask();
			   				},400);
			   				
					 }
							
					});
	           			
           		}
           	},
           	updateRoomTypeData:function(record){
           		var me =this,
	           	    form = this.getTariffplandetailseditwindow(),
				    grid = this.getChargeablenonchargeabledaysscheduleeditgrid();
           		record.forEach(function(mainRec){
           			mainRec.createdBy = me.getCurrentlyLoggedInUser().id;
           			form.manageFeeData.forEach(function(rec){
           				if(rec.feeStageHeadConfigId == mainRec.feeStageHeadConfigId){
           					mainRec.id = rec.id;
           				}
               		});
           		});
           		var formData = Ext.encode(record);
		           	 Ext.Ajax.request({
						 type : 'rest',
						 url : SERVERURL.PATH_UPDATE_ROOM_TYPE,
						 jsonData : formData,
						 method : 'POST',
						 success : function(form1, action) {
							 showSuccessMessage(getHostelTranslation('UPDATE_ROOM_TYPE'),getHostelTranslation('UPDATE_ROOM_TYPE_MESSEGE'));
							 form.close();
							 grid.getStore().reload();
						 }
					 });
		           	},
		           	/*This method is addding more rows on clicking on add button
		           	 * @param form*/
		           	addRowForDefaultStageApplicable:function(form){
		           		var defaultStageApplicableContainerId = form.down('#defaultStageApplicableContainerId');
		           		var containerItems = new Array();
		           		var position=defaultStageApplicableContainerId.items.items.length;
		           		containerItems.push({
		           			xtype:'fieldcontainer',
		           			layout:'hbox',
		           			defaults:{
		           				width:256,
		           				labelAlign:'top'
		           			},
		           			items:[{
		           				xtype:'customcombobox',
		           				fieldLabel:getHostelTranslation('FEE_PLAN_RULE')+': <span class="required" style="color:red"> *</span>',
		           				name:'feePlanRuleDefaultStageApplicable',
		           				itemId:'feePlanRuleDefaultStageApplicableId',
		           				store : 'feeandpayment.managebill.FeeRuleDefaultStage',
		           				valueField:'id',
		           				displayField:'value',
		           				editable : false,
		           				allowBlank:false,
		           				labelSeparator:'',
		           				queryMode: 'local',
		           			},{
		           				xtype:'customcombobox',
		           				fieldLabel:getHostelTranslation('FEE_PLAN_STAGE'),
		           				name:'feePlanStageDefaultStageApplicable',
		           				itemId:'feePlanStageDefaultStageApplicableId',
		           				store : 'feeandpayment.managebill.FeePlanStageDefaultStage',
		           				valueField:'id',
		           				displayField:'value',
		           				readOnly:true,
		           				editable : false,
		           				queryMode: 'local',
		           			},{
		           				xtype:'textfield',
		           				fieldLabel:getHostelTranslation('AMOUNT_TO_BE_PAID'),
		           				name:'amountOfDefaultStageApplicable',
		           				itemId:'amountOfDefaultStageApplicableId',
		           				readOnly:true,
		           				editable : false
		           			},{
		        		    	xtype:'hidden',
		        		    	itemId:'feePlanRuleStageIdHidden',
		        		    	name:'feePlanRuleStageIdHidden'
		           			},{
		        		    	xtype:'hidden',
		        		    	itemId:'containerRowId',
		        		    	name:'containerRowId'
		        		    },{
		           				xtype:'button',
		           				text:'+',
		           				cls:'CustomBodyBtnSettings',
		           				tooltip: getCommonTranslation('ADD'),
		           				itemId:'addRowBtnId',
		           				style:{
		           					marginTop:'30px !important'
		           				}
		           			},{
		           				xtype: 'button',
		           				itemId: 'deleteRowBtnId',
		           				glyph: ICONGLYPH.DELETEGLYPH,
		           				cls: 'CustomBodyBtnReject',
		           				tooltip: getCommonTranslation('DELETETOOLTIP'),
		           				style:{
		           					marginTop:'30px',
		           					marginLeft:'-183px !important',
		           				}
		           			}]
		           		});
		           		defaultStageApplicableContainerId.insert(position,containerItems);
		           		var saveBtn;
		           		if(form.xtype=='roomtypeform'){
		           			saveBtn = form.up().up().down('#saveBtn');
		           		}else{
		           			saveBtn =form.down('#saveBtnOnEdit');
		           		}
		           		if(form.hasInvalidField()){
		           			saveBtn.setDisabled(true);
		           		}else{
		           			saveBtn.setDisabled(false);
		           		}
		           	},
		           	/*This method is removing rows on clicking on delete button
		           	 * @param1 - delete button on which user is clicking
		           	 * @param2 - form*/
		           	removingRowForDefaultStageApplicable:function(button,form){
		           		var defaultStageApplicableContainerId = form.down('#defaultStageApplicableContainerId');
		           		var container = button.up();
		           		defaultStageApplicableContainerId.remove(container);
		           		this.setTotalAmountForDefaultStageApplicable(form);
		           		var saveBtn;
		           		if(form.xtype=='roomtypeform'){
		           			saveBtn = form.up().up().down('#saveBtn');
		           		}else{
		           			saveBtn =form.down('#saveBtnOnEdit');
		           		}
		           		if(form.hasInvalidField()){
		           			saveBtn.setDisabled(true);
		           		}else{
		           			saveBtn.setDisabled(false);
		           		}
		           	},
		           	
		           	/*This method is used to calculate sum of all fee head amount from api response i.e first param of method
		           	 * @param api response of feestage combo api*/
		           	getSumOfAllFeeHeadAmount:function(data){
		           		var sumOfFeeHeadAmt=0;
		           		Ext.each(data.rows,function(record){
		           			sumOfFeeHeadAmt=sumOfFeeHeadAmt+record.feeAmount;
		           		});
		           		return sumOfFeeHeadAmt;
		           	},
		           	
		           	/*This method reset the multiple rows of fee plan rule , stage and amount
		           	 * @param ->container on which rows are put */
		           	resetMultipleFeePlanRuleStageRows:function(defaultStageApplicableContainer){
		           		defaultStageApplicableContainer.setVisible(false);
		           		defaultStageApplicableContainer.down('#feePlanRuleDefaultStageApplicableId').reset();
		           		defaultStageApplicableContainer.down('#feePlanStageDefaultStageApplicableId').reset();
		           		defaultStageApplicableContainer.down('#amountOfDefaultStageApplicableId').reset();
		           		var itemsLength = defaultStageApplicableContainer.items.items.length;
		           		for(var i=itemsLength-1 ; i>0 ;i--){
		           			defaultStageApplicableContainer.remove(defaultStageApplicableContainer.items.items[i]);
		           		}
		           	},
		           	
		           	/*method is used to set sum of all amount to be paid into the field TotalOneTimeAmtToBePaid
		           	 * @param - form*/
		            setTotalAmountForDefaultStageApplicable:function(form){
						   var feeHeadsContainer = form.down('#defaultStageApplicableContainerId');
						   var defaultTariffAmount = form.down('#totalOneTimeAmtToBePaid');
						   var sumOfFeeHeads=0;
						   var fieldContainers = feeHeadsContainer.items.items;
						   Ext.each(fieldContainers,function (fieldContainer){
							   var amountField = fieldContainer.items.items[2];
							   if(!isNullOrEmpty(amountField.getValue())){
								  sumOfFeeHeads=sumOfFeeHeads+parseFloat(amountField.getValue());
							   }
						   });
						   defaultTariffAmount.setValue(sumOfFeeHeads);
		               },
		               
		               /*This method is used to set FeePlanStage and Amount of fee head
		                * @param1 dropdown
		                * @param2 selected record*/
		               setFeePlanStageAndAmountOnDefaultStageApplicable:function(obj,record){
		            	   var feePlanRuleId;
		            	   if(typeof record == 'object'){
		            		    feePlanRuleId =  record[0].get("id");
		            	   }else{
		            		   feePlanRuleId=record;
		            	   }
		            	   var form = obj.up('form');
		            	   form.config.feePlanRuleStageId=null;
		            	   var feePlanStageDefaultStageApplicable =obj.nextSibling();
		            	   feePlanStageDefaultStageApplicable.getStore().removeAll();
		            	   var store = feePlanStageDefaultStageApplicable.getStore();
		            	   var feePlanRuleArray = form.query('#feePlanRuleDefaultStageApplicableId');
		            	   if(this.tocheckDuplicateFeeRules(feePlanRuleArray)){
		            		   obj.reset();
		            		   feePlanStageDefaultStageApplicable.reset();
		            		   feePlanStageDefaultStageApplicable.nextSibling().reset();
		            		   return showWarningMessage(getCommonTranslation('ALERT'),getHostelTranslation('DUPLICATE_FEE_RULE_SELECTED'));
		            	   }
		            	   
		            	   store.getProxy().extraParams = {
		            		   feePlanRuleId: feePlanRuleId,
		            	   };
		            	   store.load({
		            		   callback: function(records, operation, success) {
		            			   if(!isNullOrEmpty(records)){
		            				   feePlanStageDefaultStageApplicable.setValue(records[0].data.id);
		            				   form.config.feePlanRuleStageId = records[0].data.displayOtherLanguage;
		            				   feePlanStageDefaultStageApplicable.nextSibling().nextSibling().setValue(records[0].data.displayOtherLanguage);
		            				   
		            				   if(!isNullOrEmpty(form.config.feePlanRuleStageId)){
		            					   Ext.Ajax.request({
		            						   type : 'rest',
		            						   url : SERVERURL.PATH_FIND_FEE_HEAD_BY_FEE_RULE_STAGE_ID,
		            						   params : {
		            							   feePlanRuleStageId: form.config.feePlanRuleStageId
		            						   },
		            						   method : 'GET',
		            						   success : function(response, action) {
		            							   var res = Ext.JSON.decode(response.responseText);
		            							   if (!isNullOrEmpty(res)) {
		            								   var feeAmountTemp = 0.0;
		            								   for(var x=0;x<res.length;x++){
		            									   feeAmountTemp=feeAmountTemp+res[x].feeAmount;
		            								   }
		            								   feePlanStageDefaultStageApplicable.nextSibling().setValue(feeAmountTemp);
		            							   }
		            						   }
		            					   });
		            				   }
		            			   }
		            		   }	   
		            	   });

		               },
		               /*this method is used to check whether duplicate fee plann rules selected
		                * @param feePlanRuleArray*/
		               tocheckDuplicateFeeRules:function(feePlanRuleArray){
						   var valuesSoFar = [];
		            	   for (var i = 0; i < feePlanRuleArray.length; ++i) {
						        var value = feePlanRuleArray[i].getValue();
						        if (value!=null && valuesSoFar.indexOf(value) !== -1) {
						        	return true;
						        }
						        valuesSoFar.push(value);
						    }
		               }
});
