/**
 * @author pritam.patil
 * This is used for messaging Functionality
 */
Ext.define('Academia.controller.messaging.TemplateConfigurationController', {
	
	extend: 'Academia.controller.base.BaseController',

    views: ['messaging.TemplatePanel','messaging.TemplateSearchForm',
            'messaging.TemplateConfiguarationTabPanel','messaging.TemplateBasicSetUpForm',
            'messaging.GenrateTemplateForm','messaging.TemplateReportForm',
            'messaging.TemplateConfigurationPanel','messaging.TemplateDataForm','messaging.TemplateDataTabPanel','messaging.TemplateRecipientDataForm',
            'messaging.TemplateApproveRejectPanel','messaging.TemplateAppRejCommentTabPanel','messaging.TemplateApproveRejectFormPanel','messaging.TemplateAppRejCommentHistory',
            'messaging.StaticDocumentTemplateReportForm','messaging.StaticDocumentAttachmentGrid',
            'messaging.StaticDocumentUploadForm','baselayout.contentarea.ContentPanel','messaging.TemplatePanelView'],
    
    stores: ['messaging.MessageTypeStore','messaging.MessageModeStore','messaging.MessageCategoryStore',
             'messaging.MessageSubCategoryStore','messaging.TemplateDataProvider',
             'messaging.RecipientType','Academia.store.messaging.CbMetaDataStore',
             'messaging.SystemMessageEvent','messaging.RecipientTypeByEventId','messaging.CommentHistoryStore',
             'messaging.TemplateStatusStore','messaging.ApprovarComboStore','messaging.MessagingTemplateDocumentList',
             'messaging.StaticDocumentAttachmentGridStore','messaging.MessageLanguageComboStore','messaging.MessageTemplateConfigNameStore'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'templateSearchForm',
        selector: 'templatesearchform[itemId=template_quickSearch]'
    }, {
        ref: 'templateSearchResultGrid',
        selector: 'searchresultgrid[itemId=templateSearchResultGrid]'
    }, {
        ref: 'templatedataform',
        selector: 'templatedataform'
    }],
    config: {
    	TEMPLATE_MESSAGING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MESSAGING_TEMPLATE_PRIVILEGES')
    },
    init: function(application) {
    	this.control({
    		
    		/* Template Grid Button Events  */
            
    		'templatepanel grid[itemId=templateSearchResultGrid]': {
    			 afterrender: function(grid){
    				 this.loadTemplateGridAndSearchRequest();
    			 },
                render: function(grid){
                	this.gridRenderFunction(grid);
                	this.genericCBGridAccessControlValidation(grid, this.getTEMPLATE_MESSAGING_PERMISSIONS());
                	this.disableMoreActionPivileges(grid,this.getTEMPLATE_MESSAGING_PERMISSIONS());
                },
				cellclick : function(view, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					var grid=view.ownerCt;
					var button=grid.down('#enableDisableTemplateBtnId');
					var whetherEnabled=record.data.WHETHER_ENABLED;
					if(whetherEnabled == getMessagingModuleTranslation('YES')){
						button.setText(getExaminationTranslation('DISABLE'));
					}else{
						button.setText(getExaminationTranslation('ENABLE'));
					}
				}
            },
            
            'templatepanel combo': {
                render: function(combo){                	
                	this.loadComboData(combo);                	                	                
                }
            },
            
            'templatepanel button[itemId=searchResultGridBtnAdd]': {
                click: function(button){                	
                	this.openNewTemplateTab(button);
                }
            },
            
            'templatepanel button[itemId=searchResultGridBtnEdit]': {
                click: function(button){
                	var this$ = this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {   
                			var record = grid.getSelectionModel().getSelection()[0];
                			this$.validateGridTemplateDetailsToOpenTab(record, button,grid,false);
                			
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'templatepanel button[itemId=searchResultGridBtnView]': {
                click: function(button){
                	var this$=this;
                	var grid =button.up('grid');
                	if(grid){                		
                		if (grid.getSelectionModel().getCount() > 0) {        	
                			var record = grid.getSelectionModel().getSelection()[0];
                			var status=record.get('STATUS');
                			this$.openTemplateTab(button,grid, status, true);
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                	}
                }
            },
            
            'templatepanel button[itemId=searchResultGridBtnDelete]': {
                click: function(button){
                	this.deleteMessageTemplate(button);
                }
            },    
            'templatepanel combo[itemId=messageCategoryOnTemplateListScreen]': {
                select: function(combo,records){
                	var me=this;
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		var params=new Object();                	
                    	params.id=selectedCategoryId;
                    	me.loadDependentComboData(combo,records,params,'#messageSubCategoryOnTemplateListScreen');
                	}                					                	                	                	
                }
            },    
            
            'templatesearchform button[itemId=templateFindButtonId]': {
                click: this.loadTemplateGridAndSearchRequest
            },
            
            // This function is used for translation of Recipient Type
            
            'templatesearchform customcombobox[itemId=recipientTypeOnTemplateListScreen]': {
                render: function(obj) {
                	//var receiptType = obj.up('#templatesearchformId').down('#recipientTypeOnTemplateListScreen');
                	receiptTypeStore = obj.getStore();
                	receiptTypeStore.load({
                		callback: function(records,option,success){
                            for(var i=0; i< records.length; i++){
                                    var record = records[i];
                                    //if(isNullOrEmpty(record.get("code"))){
                                    	record.set("code",getCommonTranslation(record.get('code')));
                                    //}
                                    //record.set("value",getCommonTranslation(record.get('value')));
                                    record.set("id",record.get('id'));
                             }
                            receiptTypeStore.commitChanges();
                            obj.bindStore(receiptTypeStore);
                		}	   
	 				   });
                }
            },
            'templatesearchform button[itemId=templateClearSearch]': {
                click: this.clearSearchForm
            },
            
            'templatebasicsetupform button[itemId=templateCancelBtn]': {
                click: function(button){
                	button.up('form').getForm().getFields().each(function(field) {
                        field.reset();
                    });
                }
            },
            
        	/* Template Form combo rendering and loading */
        	'templatebasicsetupform combo': {
                render: function(combo){
                	if(!isNullOrEmpty(combo.itemId) && combo.itemId!=="property"){
                		this.loadComboData(combo);
                	}                	                
                }
            },
            
            'templatebasicsetupform combo[itemId=messageCategory]': {
                select: function(combo, records, eOpts){
                	var this$ = this;
                	var selectedCategoryId=combo.getValue();
                	if(!isNullOrEmpty(selectedCategoryId)){
                		this$.clearDependentFields(combo);
                		var params=new Object();                	
                    	params.id=selectedCategoryId;
                    	this$.loadDependentComboData(combo,records,params,'#messageSubCategory');
                	}                					                	                	                	
                }
            },
            
            'templatebasicsetupform combo[itemId=messageSubCategory]': {
                select: function(combo, records, eOpts){
                	var this$=this;
                	var selectedSubCategoryId=combo.getValue();                	
                	if(!isNullOrEmpty(selectedSubCategoryId)){
                		this$.clearDependentFields(combo);
                		var params=new Object();                	
                    	params.id=selectedSubCategoryId;
                    	this$.loadDependentComboData(combo,records,params,'#templateDataProvider');
                    	this$.loadDependentComboData(combo,records,params,'#systemMsgEventCombo');
                	}                	                	         	
                },
            	expand:function(field,eOpts){            		
            		this.validateParentCombo(field,"#messageCategory",getMessagingModuleTranslation('SELECT_MSG_CATEGORY')); //First select message category then select message sub category.
            	}
            },
            
            'templatebasicsetupform radiogroup#messageTemplateType': {
            	change:function(radio, newValue, oldValue, eOpts){                	
                	this.hideShowSysMsgEventCmb(radio,newValue,oldValue);
                }
            },
            
            'templatebasicsetupform combo[itemId=templateDataProvider]': {
                select: function(combo,records){                	         
                	this.clearDependentFields(combo);
                  	this.loadDependentComboInTemplateDataTabPanel(combo,records,'#genrateTemplateForm',false);                	               	                	
                },
            	expand:function(field,eOpts){            		
            		this.validateParentCombo(field,"#messageSubCategory",getMessagingModuleTranslation('SELECT_MSG_SUB_CATEGORY')); //First select message sub category then select template data provider.
            	}
            },
            
            'templatebasicsetupform combo[itemId=recipientType]': {
                select: function(combo,records){
                	this.clearDependentFields(combo);
                	this.loadDependentDocumentSelector(combo);
                	this.loadDependentComboInTemplateDataTabPanel(combo,records,'#templateRecipientForm',true);                		                		                    	                	                	                	
                }
            },
            
            'templatebasicsetupform checkbox[itemId=isStaticTemplate]': {
            	change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkTemplateType(checkbox,newValue,oldValue);
                }
            },
            
            'templatebasicsetupform checkbox[itemId=isCustomizeTemplate]': {
            	change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkTemplateType(checkbox,newValue,oldValue);
                }
            },

            'templatebasicsetupform checkbox[itemId=isApprovalRequired]': {
            	change:function(checkbox, newValue, oldValue, eOpts){                	
                	this.checkApproval(checkbox,newValue,oldValue);
                }
            },
            
            'templatebasicsetupform combo[itemId=messageTypes]': {
                change: function(combo, newValue, oldValue, eOpts ){
                	var this$ = this;
                	this$.onChangeMessageTypeCombo(combo, newValue, oldValue, eOpts);
                }
            },
            
            'templatebasicsetupform checkboxgroup[itemId=messageModeGrp]':{            	
            	change:function(checkbox, newValue, oldValue, eOpts ){
                    this.addOrRemoveMessageMode(checkbox, newValue, oldValue);
                }
            },
            
            'templatebasicsetupform combo[itemId=messageModeCombo]': {
                select: function(combo,records){                	
                	this.showHideSubjectField(combo,records);                		                		                    	                	                	                	
                }
            },
            
                        
            'templatebasicsetupform form[itemId=genrateTemplateForm] > fieldcontainer > combo[itemId=property]': {                
            	expand:function(field,eOpts){            		
            		this.validateParentCombo(field,"#templateDataProvider",getMessagingModuleTranslation('SELECT_TEMPLATE_DATA_PROVIDER')); //First select template data provider then select template data property.
            	}
            },
            
            'templatebasicsetupform form[itemId=templateRecipientForm] > fieldcontainer > combo[itemId=property]': {                
            	expand:function(field,eOpts){            		
            		this.validateParentCombo(field,"#recipientType",getMessagingModuleTranslation('SELECT_RECIPIENT_TYPE')); //First select recipient type then select recipient data property.
            	}
            },
            
            
            'templatebasicsetupform button[itemId=saveTemplate]':{
            	click:function(button){
            		this.saveMessageTemplateOnForm(button);
            	}            	
            },
            
        	/* template function*/
        	
            'templatedataform button[itemId=addTemplateButton]':{
            	click: function(button){
            		this.addDataToTemplate(button);            		
            	}
            },
            ' templatebasicsetupform button[itemId=templateSubmitBtn]':{
            	click: function(button){
            		this.saveMessageTemplateOnSystem(button);
            	}
            },
                        
            'templateapproverejectformpanel button[itemId=btnApproveReviewComment]': {
            	click: function(button, eOpts ){                	
            		this.approveRejectResubmitTemplate(button,getMessagingModuleTranslation('TEMP_APPROVED_MSG')); //Message template approved successfully.
                }
            },
            
            'templateapproverejectformpanel button[itemId=btnRejectReviewComment]': {
            	click: function(button, eOpts ){                	
            		this.approveRejectResubmitTemplate(button,getMessagingModuleTranslation('TEMP_REJECTED_MSG')); //Message template rejected successfully.
                }
            },
            
            'templateapproverejectformpanel button[itemId=btnReSubmitForApprovalComment]': {
            	click: function(btnReSubmitForApproval, eOpts ){
            		var me=this;
            		showConfirmMessage(getMessagingModuleTranslation('MSG_TEMP_RESUBMIT_FOR_APPROVAL'), getMessagingModuleTranslation('RESUBMIT_FOR_APPROVAL_MSG'), function(btn, text) {  //Have you checked the comments for rejection? Please click on Yes to proceed
                        if (btn == 'yes') {                        	
                        	var basicSetUpForm=btnReSubmitForApproval.up('templatebasicsetupform');
                        	if(basicSetUpForm){
                        		var templateSubmitBtn=basicSetUpForm.down("#templateSubmitBtn");
                    		    if(templateSubmitBtn){
                    		    	me.saveMessageTemplateOnSystem(templateSubmitBtn,true,btnReSubmitForApproval);
                    		    }
                        	}                        		                            	
                        }
                    });             		
                }
            },
            
            'templatebasicsetupform button[itemId=btnSendForApproval]': {
            	click: function(button, eOpts ){                       		
            		this.sentTemplateForApproval(button,getMessagingModuleTranslation('TEMP_SENT_FOR_APPROVAL_MSG')); //Message template sent for approval successfully.
                }
            },
            
            'genratetemplateform textfield[itemId=subject]': {
                focus: function(textfield){
                	textfield.selectOnFocus = true;
                	
                	var genrateTemplateForm = textfield.up('form');
                	var ckeditor=genrateTemplateForm.down('ckeditor');
                	ckeditor.editor.on('focus', function(){
                		textfield.selectOnFocus = false;
                	});
                }
            },
            
           /* 'templatebasicsetupform panel[itemId=templateReportForm]':{
            	activate:function(panel){
            		var templatebasicsetupform=panel.up('templatebasicsetupform');
            		var recipientTypeCmb=templatebasicsetupform.down("#recipientType");
                	this.loadDependentDocumentSelector(recipientTypeCmb);
            	}
            },*/
            
            /**
             * Static document attachment
             */
            'staticdocumentuploadform[itemId=staticDocumentUploadForm] filefield[itemId=staticUploadFileField]': {
            	render: function(fileField){
            		fileField.button.fileInputEl.on('focus', function(cmp){
            			var templateBasicSetUpForm = fileField.up('templatebasicsetupform');
                		var templateCode = templateBasicSetUpForm.down('#templateCode').getValue();
                		if(isNullOrEmpty(templateCode)){
                			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_FILL_TEMPLATE_CODE'));
                		}else{
                			fileField.button.fireEvent('click');
                		}
            		});
            		
            	},
	            change: function(fileField, value, eOpts){
	            	var this$ = this;
	            	this$.uploadStaticDocumentFile(fileField, value, eOpts);
	            }
            },
            
            'staticdocumentattachmentgrid[itemId=staticDocumentAttachmentGrid] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteStaticDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },
            
            'templatepanel':{
	        	afterrender : function(structure){
	        		//var container = structure.items.items[0];
	        		var grid = structure.down('#templateSearchResultGrid');
	        	    this.getGridHeaderFreeze(grid,structure);
	        	}
    		},
    		 'templatepanel button[itemId=enableDisableTemplateBtnId]': {
                 click: function(button){                	
                 	this.enableDisableTemplateEvent(button);
                 }
             },
        });        
    },
    /**
     * Validate status before to open template tab
     */
    validateGridTemplateDetailsToOpenTab: function(record, button, grid, isView){                	
    	var this$ = this;
    	var isEdit = false;
    	var templateTab=this$.getTabReferenceByTabTitle();
    	if(templateTab){
    		var templateGrid=templateTab.down('grid');
        	if(templateGrid){
        		
        		if(!isEmpty(record)){
            		var selectedTemplateAcadLocId=record.get('ACADEMY_LOCATION_ID');
            		var selectedTemplateApprovarId=record.get('APPROVER_ID');
            		var status=record.get('STATUS');
            		var user=this$.getCurrentlyLoggedInUser();
            		if(!isNullOrEmpty(selectedTemplateAcadLocId)){
            			var isAccessibleAcademyLocation = false;
            			if(user.id==1){
            				isAccessibleAcademyLocation = true;
            			}else{
            				isAccessibleAcademyLocation = this$.isAccessibleAcademyLocation(selectedTemplateAcadLocId);	
            			}
                		if(status==getMessagingModuleTranslation('MSG_TEMP_DRAFT')){ //Draft status
            				if(isAccessibleAcademyLocation){
            					isEdit = true;
                				record=this$.getEnableDisableParams(record,false,false,false,true);                                				
            				}else{
            					isEdit = false;
                				record=this$.getEnableDisableParams(record,false,false,false,false);
            				}                            				                            				
            			}else if(status==getMessagingModuleTranslation('MSG_TEMP_SENT_FOR_APPROVAL')){//Sent for Approval status
            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
            					isEdit = true;              
                				record=this$.getEnableDisableParams(record,true,true,false,false);                                    				
	        				}else{
	        					if(isAccessibleAcademyLocation){
	        						isEdit = true;                         
	                				record=this$.getEnableDisableParams(record,false,false,false,false);
	        					}else{
	        						isEdit = false;
	                				record=this$.getEnableDisableParams(record,false,false,false,false);
	        					}
	        				}                            				
        			
            			}else if(status==getMessagingModuleTranslation('MSG_TEMP_APPROVED')){//Approved status
            				if(isNullOrEmpty(selectedTemplateApprovarId) && isAccessibleAcademyLocation){
        						isEdit = true;                         
                				record=this$.getEnableDisableParams(record,false,false,false,false);
        					}else{
        						isEdit = false;
                				record=this$.getEnableDisableParams(record,false,false,false,false);
        					}                           				
            			}else if(status==getMessagingModuleTranslation('MSG_TEMP_REJECTED')){ //Rejected status                          				
            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
            					isEdit = false;          
                				record=this$.getEnableDisableParams(record,false,false,false,false);
            				}else{
            					if(isAccessibleAcademyLocation){
            						isEdit = true;
                    				record=this$.getEnableDisableParams(record,true,false,true,false);	                                				
            					}else{
            						isEdit = false;
                    				record=this$.getEnableDisableParams(record,false,false,false,false);
            					}
            				}    
            			}else if(status==getMessagingModuleTranslation('MSG_TEMP_RESUBMIT_FOR_APPROVAL')){//Resubmit status
            				if(!isEmpty(user) && user.id==selectedTemplateApprovarId){                            					                                					
            					isEdit = true;                                  
                				record=this$.getEnableDisableParams(record,true,true,false,false); 
            				}else{
            					if(isAccessibleAcademyLocation){
            						isEdit = true;
                    				record=this$.getEnableDisableParams(record,true,false,true,false);	                                				
            					}else{
            						isEdit = false;
                    				record=this$.getEnableDisableParams(record,false,false,false,false);
            					}
            				}    
            			}
                		
            		}
            		if(record.data.TEMPLATE_CONFIG_NAME == 'CommitteeTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}  
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'StudentTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'FacultyTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'EnquirerTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		} 
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'UserTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'ApplicantTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		} 
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'StudentDashletTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		} 
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'PlacementJobTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		} 
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'PlacementRecruitmentTemplate'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}
            		
            		else if(record.data.TEMPLATE_CONFIG_NAME == 'MSG_COURSE_WEEKLY_ATTENDANCE_TEMPLATE'){
            			isEdit = false;
            			record=this$.getEnableDisableParams(record,false,false,false,false);
            		}
            		
            		if(isEdit){
            			this$.openTemplateTab(button,grid, status, isView);
            		}else{
            			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('TEMPLATE_CANNOT_BE_EDITED')); //Please select a record.
            		}
            				                         			                            		        		
            	}
        		
        	}                    	                    	
    	} 
    },
    
    /**
     * On message type combo change event
     */
    onChangeMessageTypeCombo: function(combo, newValue, oldValue, eOpts){
    	
    	var me=this;
    	var templateBasicSetupForm=combo.up('templatebasicsetupform');
    	if(templateBasicSetupForm){
    	
    		var messageModeGrp=templateBasicSetupForm.down("#messageModeGroupContainer");
    		var email=templateBasicSetupForm.down("#EMAIL");
    		var sms=templateBasicSetupForm.down("#SMS");
    		var letter=templateBasicSetupForm.down("#LETTER");
    		var sysInternalMsg=templateBasicSetupForm.down("#SYS_INTERNAL_MSG");
    		var webLink=templateBasicSetupForm.down("#WEB_LINK");
    		
    		messageModeGrp.setDisabled(false);
    		var selectedMessageTypeId=combo.getValue();                		
        	if(!isNullOrEmpty(selectedMessageTypeId)){
        		
        		if(selectedMessageTypeId==1){ //GENERAL_MESSAGE                    			
        			letter.setVisible(true);
        			sysInternalMsg.setVisible(false);
        			sysInternalMsg.setValue(false);
        			webLink.setVisible(true);
        		}else if(selectedMessageTypeId==3){ //ALERT                    			
        			letter.setVisible(false);
        			letter.setValue(false);
        			sysInternalMsg.setVisible(true);
        			webLink.setVisible(false);
        		}else if(selectedMessageTypeId==4){  //NOTIFICATION                    			
        			letter.setVisible(false);
        			letter.setValue(false);
        			sysInternalMsg.setVisible(true);
        			webLink.setVisible(false);
        			webLink.setValue(false);
        		}
        	}   
    	}                	             					                	                	                	
    },
    /**
     * This method is used for to load dependent document selector   
     * @param button - button reference
     *    
     */
    loadDependentDocumentSelector: function(selectedField) {    	
    	var basicSetUpForm=selectedField.up('templatebasicsetupform');
    	if(basicSetUpForm){
        	var recipientType=basicSetUpForm.down("#recipientType");
        	var documentSelector=basicSetUpForm.down("#messagingTemplateDocumentSelector");
        	if(recipientType){
        		if(!isNullOrEmpty(recipientType.getValue())){        			
        			var selectedRecord=recipientType.getStore().getById(recipientType.getValue());
        			if(selectedRecord && !isNullOrEmpty(selectedRecord.get('recipientDefaultConfigId'))){
        				var recipientDefaultConfigId=selectedRecord.get('recipientDefaultConfigId');
        				
        				var params=new Object();
        				params.id=recipientDefaultConfigId;
        				
        				documentSelector.getStore().load({
        					params:params
        				});
        			}
        		}
        	}
    	}
    },
    
    
    /**
     * This method is used for to Accept/Reject/Resubmit message template
     * @param button  - button reference
     * @param successMsg - success message
     *          
     */
    approveRejectResubmitTemplate: function(button,successMsg) {
    	var me=this;
        var commentForm=button.up('form');
        if(commentForm){
        	var msgTemplateForm=commentForm.up("templatebasicsetupform");
        	var reviewCommentTxtArea=commentForm.down("#reviewCommentTxtArea");
        	var templateStatus=button.status;
        	var lastUpdateDate=Ext.Date.format(new Date(),'d-m-Y');
        	var loggedInUser=me.getCurrentlyLoggedInUser();
        	
        	if(reviewCommentTxtArea && !isNullOrEmpty(reviewCommentTxtArea.getValue())){
        		if(msgTemplateForm){
        			
        			var jsonObject=new Object();        			        		
        			jsonObject.msgTemplateConfigId=msgTemplateForm.down("#ID").getValue();
        			jsonObject.commentByUserName=loggedInUser.value;
        			jsonObject.commentByUserId=loggedInUser.id;
        			jsonObject.comment=reviewCommentTxtArea.getValue();
        			jsonObject.templateStatus=templateStatus;
        			jsonObject.lastUpdate=lastUpdateDate;
        			
        			var jsonFormatFormData=Ext.encode(jsonObject);        			        				        				
        	        if (!isNullOrEmpty(jsonFormatFormData)) {
        	                Ext.Ajax.request({
        	                    type: 'rest',
        	                    url: SERVERURL.REVIEW_MESSAGE_TEMPLATE,
        	                    jsonData: jsonFormatFormData,
        	                    method: 'POST',
        	                    success: function(response, form) {
        	                    	if (!isNullOrEmpty(response.responseText) && response.responseText=="true") {
        	                            showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
        	                            msgTemplateForm.close();
        	                            var SearchForm = me.getTemplateSearchForm();
        	                            if(SearchForm){
        	                            	var statusCombo=SearchForm.down("#statusCombo");
        	                            	if(statusCombo){
        	                            		statusCombo.setValue("All");
        	                            	}
        	                            }
        	                            me.loadTemplateGridAndSearchRequest();
        	                        }        	                        
        	                    }
        	                });        	            
        			}
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('ENTER_COMMENTS')); //Please enter comment in comment box
        	}
        }
    },
    
    
    /**
     * This method is used for to sent message template to approval.
     * @param button  - button reference
     * @param successMsg - success message
     *          
     */
    sentTemplateForApproval: function(button,successMsg) {
    	var me=this;
        var msgTemplateForm=button.up('form');
        if(msgTemplateForm){
        	
        	var templateStatus=button.status;
        	//var lastUpdateDate=Ext.Date.format(new Date(),'d-m-Y');
        	var loggedInUser=me.getCurrentlyLoggedInUser();
        	        	
        	var approver=msgTemplateForm.down("#approver");        	
        	if(approver && !isNullOrEmpty(approver.getValue())){
        		if(msgTemplateForm){
        			
        			var jsonObject=new Object();        			        		
        			jsonObject.msgTemplateConfigId=msgTemplateForm.down("#ID").getValue();
        			jsonObject.authorName=loggedInUser.value;
        			jsonObject.authorId=loggedInUser.id;        			
        			jsonObject.templateStatus=templateStatus;
        			//jsonObject.lastUpdate=lastUpdateDate;
        			
        			var jsonFormatFormData=Ext.encode(jsonObject);        			        				        				
        	        if (!isNullOrEmpty(jsonFormatFormData)) {
        	                Ext.Ajax.request({
        	                    type: 'rest',
        	                    url: SERVERURL.SEND_FOR_APPROVAL_MESSAGE_TEMPLATE, //rest/msgTemplateConfigResource/updateApprovalStatus
        	                    jsonData: jsonFormatFormData,
        	                    method: 'POST',
        	                    success: function(response, form) {
        	                    	if (!isNullOrEmpty(response.responseText) && response.responseText=="true") {
        	                            showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
        	                            msgTemplateForm.close();        	
        	                            var SearchForm = me.getTemplateSearchForm();
        	                            if(SearchForm){
        	                            	var statusCombo=SearchForm.down("#statusCombo");
        	                            	if(statusCombo){
        	                            		statusCombo.setValue("All");
        	                            	}
        	                            }        	                            
                                		me.loadTemplateGridAndSearchRequest();
        	                        }        	                        
        	                    }
        	                });        	            
        			}
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('SELECT_APPROVAR_USER')); //Please select approvar user
        	}        	        	
        }
    },
    
    /**
     * This method is used to load template grid according to search criteria
     * @param model 
     * @param records
     * @return request according to search criteria
     */
    loadTemplateGridAndSearchRequest: function(model, records) {
        var SearchForm = this.getTemplateSearchForm();
        var jsonFormatFormData = this.createJsonFormat(SearchForm, records);
        var templateResultGrid = this.getTemplateSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.MESSAGE_TEMPLATE_LIST_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        templateResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        setTimeout(function(){
       	 Ext.getBody().unmask();                          			
		},1500);
    },
    
    /**
     * This method is used to create JSON format of form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createJsonFormat: function(SearchForm) {
    	var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.MESSAGE_TEMPLATE_LIST_BASIC_CONFIGCODE;
        formValues = SearchForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * This method is used to crate JSON object
     * @param key 
     * @param value
     * @param additional value
     * @return JSON object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /**
     * This method is used to push JSON object into array & create Object array
     *@param JSON object
     *@param array
     *@return JSON object Array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * This method is used to clear fields on template search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {
        var form;
        form = button.up('form').getForm();
        form.getFields().each(function(field) {
            field.reset();
            if(field.getItemId()=='messageSubCategoryOnTemplateListScreen'){
            	field.getStore().removeAll();
            }
        });
    },

    /**
     * This method is used to add tool-bar at search result grid
     */
    gridRenderFunction: function(grid) {
        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: ['->', {
                xtype: 'button',
                itemId: 'searchResultGridBtnAdd',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnEdit',                
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'	
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnDelete',                
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            }, {				
            	xtype: 'button',
                itemId: 'enableDisableTemplateBtnId',                
                text:getExaminationTranslation('ENABLE'),
                tooltip: getExaminationTranslation('ENABLE')
            }]
        });
    },
    
    /**
     * This method is used to replace string content with replace content 
     * @param string -  main string content
     * @param find - find string in  main string content 
     * @param replace - replace string to find string in main string content
     * @return replaced string
     */
    replaceAll:function(string,find,replace) {
        var str = string;
        return str.replace(new RegExp(find.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'g'), replace);
    },

    /**
     * This method is used for to load combos 
     * @param combo - combo reference     
     */
    loadComboData:function(combo){
    	combo.getStore().load();
    },
    
    /**
     * This method is used for to validate parent combo 
     * @param field - combo field reference     
     */
    validateParentCombo:function(field,comboItemId,validateMessage){
    	var templatebasicsetupform=field.up('templatebasicsetupform');                	
    	if(templatebasicsetupform){
    		var parentCombo=templatebasicsetupform.down(comboItemId);
    		if(parentCombo){    	    			
    			var selectedId=parentCombo.getValue();                	
            	if(isNullOrEmpty(selectedId)){
            		showWarningMessage(getCommonTranslation('ALERT'), validateMessage);
            	}                			
    		}
    	}
    },
    
    
    /**
     * This method is used for to load dependent combo 
     * @param combo - combo reference     
     * @param records - selected combo record
     * @param params - param object to send parameter
     * @param comboItemId -dependent combo Item Id 
     */
    loadDependentComboData:function(combo,records,params,comboItemId,selectedRecordId){
    	var me=this;
    	var form=combo.up('form');
    	var selectedId=combo.getValue();
    	if(form && !isNullOrEmpty(selectedId)){
    		var dependentCombo=form.down(comboItemId);
    		if(dependentCombo){    	    			
    			dependentCombo.reset();    			    			
    			dependentCombo.getStore().removeAll();
    			dependentCombo.getStore().load({
    					params:params,
    					callback: function(records, operation, success) {
    						if(records.length>0 && !isNullOrEmpty(selectedRecordId)){
    							var selectedRecord=dependentCombo.getStore().getById(selectedRecordId);
    							if(!isEmpty(selectedRecord)){
    								dependentCombo.setValue(selectedRecordId);
    							}else{
    								dependentCombo.setValue("");
    							}
    						} 
    						
    						//To load Template Data Provider Property combo in edit mode
    						if(dependentCombo.itemId==='templateDataProvider' && !isNullOrEmpty(selectedRecordId)){                    			                    			
                    			var selectedRecord=dependentCombo.getStore().getById(selectedRecordId);
                    			var selectedRecords=new Array();
                    			selectedRecords.push(selectedRecord);
                                me.loadDependentComboInTemplateDataTabPanel(dependentCombo,selectedRecords,'#genrateTemplateForm',false);                    			                                        		
                        	}
    		            }
    				});
    			}
    		}    	
    },
      
    /**
     * This method is used for to load dependent combo in Template Data Tab Panel  
     * @param combo - combo reference     
     * @param records - selected combo record
     * @param params - param object to send parameter
     * @param formItemId - Differentiate a form with this item Id 
     */
    loadDependentComboInTemplateDataTabPanel:function(combo,records,formItemId,isRecipientCombo){
    	var params=new Object();
    	var form=combo.up('form');    	
    	var selectedId=combo.getValue(); 
    	
    	if(form && !isNullOrEmpty(selectedId)){
    		var dependentCombo=form.down(formItemId).down('#property');
    		if(dependentCombo){    	    			
    			dependentCombo.reset();    			
    			dependentCombo.getStore().removeAll();
    			
    			 if(!isEmpty(records)){
    				 var recipientTypeId=records[0].get('id');
    				 var viewCode=records[0].get('viewCode');
    		    	 var recipientType=records[0].get('type');
    		    	 if(isRecipientCombo){
    		    		if(recipientType==='CB'){
    		    			if(!isNullOrEmpty(viewCode)){
    		    				dependentCombo.getStore().getProxy().api.read=SERVERURL.FIND_CB_META_DATA;      //URL -rest/cb/getSeacrhResultViewData
    		    	           	params.viewCode=viewCode;                        	
    		    	   		}
    		    			//if(recipientType==='SQL') removed from below line for the sql
    		    		}else{
    		    			if(!isNullOrEmpty(recipientTypeId)){    		    				
    		    				dependentCombo.getStore().getProxy().api.read=SERVERURL.FIND_ALL_SQL_RECIPIENT_TYPE;      //URL -rest/msgRecipientTypeResource/findDataProviderByRecipientType
    		    	           	params.id=recipientTypeId;                        	
    		    			}    		    			
    		    		}
    		    	 }else{ //if it is not recipient combo then its template data provider combo
    		    		if(!isNullOrEmpty(viewCode)){    		    			
    		    			dependentCombo.getStore().getProxy().api.read=SERVERURL.FIND_CB_META_DATA;      //URL -rest/cb/getSeacrhResultViewData
    		               	params.viewCode=viewCode;
    		              //  if(recipientType==='SQL') removed from below line for the sql for getting the template data provider for 
    		        	}else {
    		        		 var dataProviderId=records[0].get('templateDataProviderId');
    		        		dependentCombo.getStore().getProxy().api.read=SERVERURL.FIND_SQL_DTP_METADATA;      //URL -rest/msgRecipientTypeResource/findDataProviderByRecipientType
		    	           	params.id=dataProviderId;  
    		        	}
    		    		
    		    	}
    		    	
    		    	 if(!isEmpty(params)){
    		    		 dependentCombo.getStore().load({
         					params:params
         				}); 
    		    	 }    		    		
    			 }
    		}    		    		
    	}
    		    	
    },
    
    /**
     * This method is used for to show or hide subject field in Template Panel  
     * @param combo - combo reference     
     * @param records - selected combo record 
     */
    showHideSubjectField:function(combo,records){
    	var me=this;
    	var form=combo.up('form');
    	var selectedId=combo.getValue();
    	if(form && !isNullOrEmpty(selectedId) && !isEmpty(records[0])){
    		var subjectField=form.down("#subject");
    		var templateForm=this.getTemplatedataform();
    		var genrateTemplateTabForm=templateForm.up("#genrateTemplateTabForm");
    		var ckeditor=genrateTemplateTabForm.down("ckeditor");
    		if(subjectField && ckeditor){    			    	
    			subjectField.setValue("");
    			if(!isEmpty(ckeditor)){
    				try{
        				ckeditor.setValue("");
        			}catch(e){
        				
        			}
    			} 
    			
    			if(records[0].data.whetherMsgSubjAvail==true){
    				subjectField.setVisible(true);
    				subjectField.setDisabled(false);
    			}else{
    				subjectField.setVisible(false);
    				subjectField.setDisabled(true);
    			}
        		
        		var templatebasicsetupform=form.up('templatebasicsetupform');
        		if(templatebasicsetupform){
        			var messageTemplatesHiddenField=templatebasicsetupform.down("#messageTemplates");
        			
        			if(!isNullOrEmpty(messageTemplatesHiddenField.getValue())){
        				messageTemplates = Ext.decode(messageTemplatesHiddenField.getValue());
                		
                		for(var count=0;count<messageTemplates.length;count++){
                			var messageDeliveryModeId=messageTemplates[count].msgDeliveryMode.id;
                			if(messageDeliveryModeId===selectedId){        				
                				var messageTemplateObject=messageTemplates[count];
                				if(!isEmpty(messageTemplateObject)){
                					if(!isNullOrEmpty(messageTemplateObject.subjectLine)){
                						subjectField.setValue(messageTemplateObject.subjectLine);
                					}
                					var editor = CKEDITOR.instances[ckeditor.inputEl.id];
                					if(!isNullOrEmpty(messageTemplateObject.msgContent)){
                						var msgString=messageTemplateObject.msgContent;  
                                         if(selectedId==2){ //SMS MODE
                                        	msgString = me.replaceAll(msgString,'$templateData["','$["');
                                            msgString = me.replaceAll(msgString,'$recipientData["','#["');
                                            ckeditor.editor.document.$.documentElement.innerHTML=msgString
                                        }else{
                                        	if(!isEmpty(editor.document)){
                                        		 msgString = me.replaceAll(msgString,'$templateData[&quot;','$[&quot;');
                                                 msgString = me.replaceAll(msgString,'$recipientData[&quot;','#[&quot;');
                                                 ckeditor.editor.document.$.documentElement.innerHTML=msgString
                                			}else{
                                				ckeditor.setValue(msgString);
                                			}
                                        }   
                                        
                                          
                					}           					        		                            		
                					break;
                				}            				
                			}    			
                		}                		
        			}            		            		
        		}        		
        			
    		}
    	}    	
    },
    
    
    
    getEnableDisableParams:function(record,isAllowToShowReviewCommentTab,isAllowToShowAppRejBtns,isAllowToShowResubmitBtn,isAllowToShowSendForApprovalBtn){
    	
    	if(!isEmpty(record)){
    		record.set('AllowToShowReviewCommentTab',isAllowToShowReviewCommentTab);
    		record.set('AllowToShowAppRejBtns',isAllowToShowAppRejBtns);
    		record.set('AllowToShowResubmitBtn',isAllowToShowResubmitBtn);
    		record.set('AllowToShowSendForApprovalBtn',isAllowToShowSendForApprovalBtn);
    	}    	
		
		return record;
    },
    
    
    /**
     * This method is used to open New Template Tab 
     * @param button -  button reference after firing click event    
     */
    openNewTemplateTab:function(button){
    	var me = this;
    	var editTemplateTab=me.getTabReferenceByTabTitle(getMessagingModuleTranslation('EDIT_TEMPLATE'));
    	var viewTemplateTab=me.getTabReferenceByTabTitle(getMessagingModuleTranslation('VIEW_TEMPLATE'));
    	if(editTemplateTab){
    		me.closeTab(editTemplateTab)
    	}
    	if(viewTemplateTab){
    		me.closeTab(viewTemplateTab)
    	}
    	this.openTab(getMessagingModuleTranslation('ADD_TEMPLATE'), 'templatebasicsetupform',CONSTANTS.MENU_COLOR_THIRTEEN);
    	
    	var templateTab=me.getTabReferenceByTabTitle(getMessagingModuleTranslation('ADD_TEMPLATE'));           
    	var staticDocumentTab = templateTab.down('#staticDocumentTemplateReportForm');
    	var staticDocumentGrid = staticDocumentTab.down('#staticDocumentAttachmentGrid');//me.getStaticDocumentAttachmentGrid();
	    var staticDocumentStore = staticDocumentGrid.getStore();
	    staticDocumentStore.loadRawData(null);
	    var msgLanguageCombo=templateTab.down('#msgLanguageCombo');
	    msgLanguageCombo.setValue('English');
    },
    
    /**
     * This method is used to open Template Tab in edit mode 
     * @param button -  button reference after firing click event    
     */
    openTemplateTab:function(button,grid, status, isViewMode){
    	var me=this;
    	var record = grid.getSelectionModel().getSelection()[0];        
        var tabTitle = (isViewMode)?getMessagingModuleTranslation('VIEW_TEMPLATE'):getMessagingModuleTranslation('EDIT_TEMPLATE');    	
        var ID = record.get("ID");
        var isAllowToShowReviewCommentTab=record.get('AllowToShowReviewCommentTab');
        var isAllowToShowAppRejBtns=record.get('AllowToShowAppRejBtns');
        var isAllowToShowResubmitBtn=record.get('AllowToShowResubmitBtn');
        var isAllowToShowSendForApprovalBtn=record.get('AllowToShowSendForApprovalBtn');
        
        if (!isNullOrEmpty(tabTitle) && !isNullOrEmpty(ID)) {
        	var param=new Object();        	
        	param.id=ID;
        	me.sendGetAjaxRequest(SERVERURL.MESSAGE_TEMPLATE_FIND_BY_ID, 'GET', param, function(option, success, response) {  //URL-:rest/msgTemplateConfigResource/findbyId
        		if(success){
        			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        			var data = Ext.decode(response.responseText);
                    if(!isEmpty(data)){  
                    	var templateTab=me.getTabReferenceByTabTitle(tabTitle);
                    	var addTemplateTab=me.getTabReferenceByTabTitle(getMessagingModuleTranslation('ADD_TEMPLATE'));
                        if (templateTab) {
                        	me.closeTab(templateTab);
                        }
                        if(addTemplateTab){
                        	me.closeTab(addTemplateTab);
                        }
                    	templateTab=me.openTab(tabTitle, 'templatebasicsetupform',CONSTANTS.MENU_COLOR_THIRTEEN);
                    	if(templateTab){            
//                    		var staticDocumentTab = me.getStaticDocumentTemplateReportForm();
                    		var staticDocumentTab = templateTab.down('#staticDocumentTemplateReportForm');
                            staticDocumentTab.setDisabled(false);
                    		var isStaticTemplate=templateTab.down('#isStaticTemplate');
                    		var isCustomizeTemplate=templateTab.down('#isCustomizeTemplate');
                    		
                    		if(isCustomizeTemplate && !isNullOrEmpty(data.recipientTypeId)){
                    			isCustomizeTemplate.setValue(true);
                    		}
                    		
                    		if(isStaticTemplate && data.whetherStaticMsg){
                    			isStaticTemplate.setValue(true);
                    		}
                    		
                    		templateTab.getForm().setValues(data);
                    		
                    		if(!isNullOrEmpty(data.id)){
                    			var dataview=templateTab.down('#commentHistoryTemplateView');
                    			if(dataview){
                    				dataview.getStore().load({
                            			params:{
                            				msgTemplateConfigId:data.id
                            			}
                            		});
                    			}                    			
                    		}                    		
                    		//For static document grid
                    		var staticDocumentGrid = staticDocumentTab.down('#staticDocumentAttachmentGrid');//me.getStaticDocumentAttachmentGrid();
                		    var staticDocumentStore = staticDocumentGrid.getStore();
                		    var staticDocumentData = data.staticDocuments;
                		    staticDocumentStore.loadRawData(null);
                		    if(!isNullOrEmpty(staticDocumentData)){
                		    	  Ext.each(staticDocumentData,function(values){
                      		    	staticDocumentStore.add({
          			            		id: values.id,
          			            		name: values.name,
          			            		path: values.path ,
          			            		createdBy : {
          			            			id : values.createdBy.id
          			            			/*value : values.createdBy.value,
          			            			code : values.createdBy.code*/
          			            		},
          			            		submissionDate: values.submissionDate,
          			            		templateConfigDocId : values.templateConfigDocId,
          			            		status : values.status,
          			            		documentType : values.documentType

          			            	});
                      		    });
                		    } 
                		    
                    		if(!isNullOrEmpty(data.msgCategoryId)  && !isNullOrEmpty(data.msgSubCategoryId)){
                    			var msgCategoryCombo=templateTab.down('#messageCategory');
                    			if(msgCategoryCombo){
                    				msgCategoryCombo.getStore().load({
                    					callback: function(records, operation, success) {
                        					if(records.length>0){
                        						var selectedRecord=msgCategoryCombo.getStore().getById(data.msgCategoryId);                        						
                        						if(!isEmpty(selectedRecord)){
                        							msgCategoryCombo.setValue(data.msgCategoryId);                        						
                        							var params=new Object();                	
                                                	params.id=data.msgCategoryId;
                                                	me.loadDependentComboData(msgCategoryCombo,null,params,'#messageSubCategory',data.msgSubCategoryId);
                        						}                        						
                        					}
                        					
                        					if(!isEmpty(data.messageTemplates)){
                        						
                                    			var messageTemplatesHiddenField=templateTab.down('#messageTemplates');      
                                    			var checkBoxGroup=templateTab.down('#messageModeGrp');
                                    			var messageModeCombo=templateTab.down('#messageModeCombo');
                                    			
                                    			if(messageTemplatesHiddenField && checkBoxGroup){
                                    				messageTemplatesHiddenField.setValue(Ext.encode(data.messageTemplates));                    				
                                    				me.insertMessageModes(checkBoxGroup, true, messageTemplatesHiddenField,messageModeCombo);                	    			
                                    			}
                                    			
                                    		}
                        		         }		
                    				});                    				
                    			}                    			
                    		}
                    		if(!isNullOrEmpty(data.msgSubCategoryId)){
                    			var messageSubCategoryCombo=templateTab.down('#messageSubCategory');
                    			if(messageSubCategoryCombo){
                    				var params=new Object();                	
                                	params.id=data.msgSubCategoryId;
                                	if(!isNullOrEmpty(data.templateDataProviderId)){
                                		me.loadDependentComboData(messageSubCategoryCombo,null,params,'#templateDataProvider',data.templateDataProviderId);
                                	}
                                	if(!isNullOrEmpty(data.systemMsgEventId)){
                                		me.loadDependentComboData(messageSubCategoryCombo,null,params,'#systemMsgEventCombo',data.systemMsgEventId);
                                	}
                    			}                                        			
                        	}
                    		
                    		if(!isNullOrEmpty(data.templatelanguageValue)){
                    			var msgLanguageCombo=templateTab.down('#msgLanguageCombo');
                    			msgLanguageCombo.getStore().load({
                    				callback:function(records, operation, success){
                    					if(records.length>0){
                    						msgLanguageCombo.setValue(data.templatelanguageValue);
                    					}
                    				}
                    			})
                    		}
                    		
                    		var messageTemplateTypeGrp=templateTab.down('#messageTemplateType');
                    		if(messageTemplateTypeGrp && !isNullOrEmpty(data.availableForAdhocMsg) && data.availableForAdhocMsg){                    			                    			
                    			messageTemplateTypeGrp.setValue({messageTemplateType:'ADHOC_MESSAGE_TEMPLATE'});
                    			
                    		}else if(messageTemplateTypeGrp && !isNullOrEmpty(data.availableForAdhocMsg) && !data.availableForAdhocMsg){
                    			messageTemplateTypeGrp.setValue({messageTemplateType:'SYSTEM_EVENT_TEMPLATE'});
                    		}
                    		
                    		if(!isNullOrEmpty(data.recipientTypeId)){
                    			var recipientTypeCombo=templateTab.down('#recipientType');
                    			if(recipientTypeCombo && messageTemplateTypeGrp){
                    				Ext.defer(function(){
                    					me.loadRecipientTypeComboInEditMode(messageTemplateTypeGrp,recipientTypeCombo,data.recipientTypeId,data.systemMsgEventId,templateTab,data);
                    				},500);
                    				
                    			}                    			
                    		}
                    		
                    		if(isViewMode){                    			
                    			me.SetMessagingTemplateInViewMode(templateTab);
                    		}else{           
                    			/* Only for Edit Mode */
                    	        if(isAllowToShowReviewCommentTab){
                    	        	var reviewCommentTab=templateTab.down('#reviewComment');
                    	        	if(reviewCommentTab){
                    	        		reviewCommentTab.setDisabled(false);                    	        		
                    	        		var templateapprejcommenttabpanel=reviewCommentTab.up('templateapprejcommenttabpanel');
                    	        		if(templateapprejcommenttabpanel){
                    	        			templateapprejcommenttabpanel.setActiveTab(reviewCommentTab);
                    	        		}     
                    	        		
                    	        		var basicConfigurationFieldSet = templateTab.down('#basicConfigurationFieldSet');
                    	        		basicConfigurationFieldSet.down('#isApprovalRequired').setReadOnly(true);
                    	        		basicConfigurationFieldSet.down('#approver').setReadOnly(true);
                    	        		
                    	        		var templateSubmitBtn=templateTab.down('#templateSubmitBtn');
                        	        	var btnSendForApproval=templateTab.down('#btnSendForApproval');
                    	        		
                        	        	var reviewCommentTxtArea=templateTab.down('#reviewCommentTxtArea');
                    	        		reviewCommentTxtArea.setVisible(true);                    	        		
                    	        		reviewCommentTxtArea.setDisabled(false);
                    	        		
                    	        		templateSubmitBtn.setVisible(false);
                    	        		btnSendForApproval.setVisible(false);
                    	        		
                        	        	if(isAllowToShowResubmitBtn){
                        	        		var btnReSubmitForApprovalComment=templateTab.down('#btnReSubmitForApprovalComment');
                        	        		btnReSubmitForApprovalComment.setVisible(true);
                        	        		btnReSubmitForApprovalComment.setDisabled(false);
                        	        		                              	        		
                        	        	}else if(isAllowToShowAppRejBtns){
                        	        		me.SetMessagingTemplateInViewMode(templateTab);
                        	        		reviewCommentTxtArea.setReadOnly(false);
                        	        		var btnApproveReviewComment=templateTab.down('#btnApproveReviewComment');
                        	        		var btnRejectReviewComment=templateTab.down('#btnRejectReviewComment');
                        	        		
                        	        		btnApproveReviewComment.setVisible(true);
                        	        		btnApproveReviewComment.setDisabled(false);
                        	        		
                        	        		btnRejectReviewComment.setVisible(true);
                        	        		btnRejectReviewComment.setDisabled(false);
                        	        		
                        	        	}
                    	        	}                    	        	
                    	        }
                    	        if(isAllowToShowSendForApprovalBtn){
                    	        	var templateSubmitBtn=templateTab.down('#templateSubmitBtn');
                    	        	var btnSendForApproval=templateTab.down('#btnSendForApproval');
                    	        	if(btnSendForApproval){
                    	        		btnSendForApproval.setVisible(true);
                    	        		btnSendForApproval.setDisabled(false);
                    	        		templateSubmitBtn.setDisabled(false);
                    	        	}
                    	        }
                    	        if(status==CONSTANTS.MSG_TEMP_APPROVED){
                    	        	me.makeReadOnleFieldOnApprovedStatus(templateTab);
                    	        }
                    		}                        	                    		
                    	}                    	
                    }
                    Ext.getBody().unmask();
        		}else{
        			Ext.getBody().unmask();
        		}
        		
            });        	          
        }    	                    	
    },
    
    makeReadOnleFieldOnApprovedStatus: function(templateTab){
    	if(templateTab){
    		var basicConfigurationFieldSet = templateTab.down('#basicConfigurationFieldSet');
    		
    		basicConfigurationFieldSet.down('#templateCode').setReadOnly(true);
    		basicConfigurationFieldSet.down('#templateConfigName').setReadOnly(true);
    		basicConfigurationFieldSet.down('#messageCategory').setReadOnly(true);
    		basicConfigurationFieldSet.down('#messageSubCategory').setReadOnly(true);
    		basicConfigurationFieldSet.down('#systemEventTemplate').setReadOnly(true);
    		basicConfigurationFieldSet.down('#adhocMessageTemplate').setReadOnly(true);
    		basicConfigurationFieldSet.down('#systemMsgEventCombo').setReadOnly(true);
    		basicConfigurationFieldSet.down('#isStaticTemplate').setReadOnly(true);
    		basicConfigurationFieldSet.down('#isCustomizeTemplate').setReadOnly(true);
    		basicConfigurationFieldSet.down('#recipientType').setReadOnly(true);
    		basicConfigurationFieldSet.down('#isApprovalRequired').setReadOnly(true);
    		basicConfigurationFieldSet.down('#approver').setReadOnly(true);
    		
    	}
    },
    SetMessagingTemplateInViewMode:function(templateTab){
    	templateTab.down('#saveTemplate').setVisible(false);       
		templateTab.down('#btnSendForApproval').setVisible(false);
		templateTab.down('#templateSubmitBtn').setVisible(false);
		templateTab.down('#templateCancelBtn').setVisible(false);
		var templateBtn=templateTab.query("tabpanel[itemId=templateDataTabPanel] > form[itemId=genrateTemplateForm] > fieldcontainer > button[itemId=addTemplateButton]")[0];
		var recipientBtn=templateTab.query("tabpanel[itemId=templateDataTabPanel] > form[itemId=templateRecipientForm] > fieldcontainer > button[itemId=addTemplateButton]")[0];
		if(templateBtn){
			templateBtn.setVisible(false);
		}
		if(recipientBtn){
			recipientBtn.setVisible(false);
		}
		var form = templateTab.down('#staticDocumentUploadForm'); 
		var uploadButton = form.down('#staticUploadFileField');
		uploadButton.setDisabled(true);
		templateTab.getForm().getFields().each(function(field) {
			 if(!isNullOrEmpty(field.itemId) && field.itemId!=="ckEditor" && field.itemId!=="reportSelector" && field.itemId !== "messagingTemplateDocumentSelector"){
				 field.setReadOnly(true);
			 }                    			      
		 });
    },
    
    
    loadRecipientTypeComboInEditMode:function(messageTemplateTypeGrp,recipientTypeCombo,recipientDataId,eventId,basicSetUpForm,data){
    	var me=this;
    	if(recipientTypeCombo && !isNullOrEmpty(recipientDataId)){
    		
    		recipientTypeCombo.reset();
    		recipientTypeCombo.getStore().removeAll();
    		
        	if(messageTemplateTypeGrp &&
     		   !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
     		   (messageTemplateTypeGrp.getValue().messageTemplateType=='ADHOC_MESSAGE_TEMPLATE')){    					    					
        				recipientTypeCombo.getStore().getProxy().api.read= SERVERURL.FIND_ALL_ADHOC_RECIPIENT_TYPES;  //URL - : 'rest/msgRecipientTypeResource/findAllAdhocRecipientTypes'
        				recipientTypeCombo.getStore().load({        					
        					callback: function(records, operation, success) {
        						if(records.length>0 && !isNullOrEmpty(recipientDataId)){
        							var selectedRecord=recipientTypeCombo.getStore().getById(recipientDataId);
        							if(!isEmpty(selectedRecord)){
        								recipientTypeCombo.setValue(recipientDataId);        								
                        				var selectedRecords=new Array();
                        				selectedRecords.push(selectedRecord);
                                    	me.loadDependentComboInTemplateDataTabPanel(recipientTypeCombo,selectedRecords,'#templateRecipientForm',true);                        		        
        							}else{
        								recipientTypeCombo.setValue("");
        							}
        						}         					
        		            }
        				});    		    
        				//me.showRecipientTypeCombo(isStaticTemplate,templateDataProviderCombo,templateDataTabPanel,recipientTypeCombo);    		    				
            			
        	}else if(messageTemplateTypeGrp &&
        			 !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
        			 (messageTemplateTypeGrp.getValue().messageTemplateType=='SYSTEM_EVENT_TEMPLATE')){    	
        		    		    		
        			if(!isNullOrEmpty(eventId)){
        				recipientTypeCombo.getStore().getProxy().api.read= SERVERURL.FIND_ALL_RECIPIENT_TYPES_BY_EVENT_ID;  //URL - : 'rest/msgRecipientTypeResource/findAllBySysMsgEventId'
        				recipientTypeCombo.getStore().load({
        					params:{
        						id:eventId
        					},
        					callback: function(records, operation, success) {
        						if(records.length>0 && !isNullOrEmpty(recipientDataId)){
        							var selectedRecord=recipientTypeCombo.getStore().getById(recipientDataId);
        							if(!isEmpty(selectedRecord)){
        								recipientTypeCombo.setValue(recipientDataId);
        								var selectedRecords=new Array();
                        				selectedRecords.push(selectedRecord);
                                    	me.loadDependentComboInTemplateDataTabPanel(recipientTypeCombo,selectedRecords,'#templateRecipientForm',true);
                                    	me.loadDocumentsInEditMode(basicSetUpForm,data);
                                    	
        							}else{
        								recipientTypeCombo.setValue("");
        							}
        						}         					
        		            }
        				});  
        				
        				
        				
        			}    			  			    		        		    		    			
        	}
    	}    	
    },
    
    
    loadDocumentsInEditMode:function(basicSetUpForm,data){
    	var recipientType=basicSetUpForm.down("#recipientType");
    	var documentSelector=basicSetUpForm.down("#messagingTemplateDocumentSelector");
    	if(recipientType){
    		if(!isNullOrEmpty(recipientType.getValue())){        			
    			var selectedRecord=recipientType.getStore().getById(recipientType.getValue());
    			if(selectedRecord && !isNullOrEmpty(selectedRecord.get('recipientDefaultConfigId'))){
    				var recipientDefaultConfigId=selectedRecord.get('recipientDefaultConfigId');
    				
    				var params=new Object();
    				params.id=recipientDefaultConfigId;
    				
    				documentSelector.getStore().load({
    					params:params,
    					callback: function(records, operation, success) {
    						if(records.length>0 && data.documents.length>0){
								var selectedArray=new Array();
								for(var count=0;count<data.documents.length;count++){
									selectedArray.push(data.documents[count].documentId);									
								}    					
								documentSelector.setValue(selectedArray);	
    						}         					
    		            }
    				});
    			}
    		}
    	}
    },
    
    
    /**
     * This method is used to return content panel active tab     
     * @return active tab of content panel
     */
    getActiveTab: function() {
    	var contentPanel=this.getContentPanel();
        if (contentPanel) {
            return contentPanel.getActiveTab();
        }else{
        	return null;  
        }        
    },
    
    /**
     * This method is used for to check template type (static/customize)  
     * @param checkbox - checkbox reference     
     * @param newValue - checkbox's new value
     * @param oldValue - checkbox's old value
     *  
     */
    checkTemplateType:function(checkbox,newValue,oldValue){
    	var me=this;
    	var form=checkbox.up('form');    	
    	if(form){
    		var isStaticTemplate=form.down('#isStaticTemplate');
    		var isCustomizeTemplate=form.down('#isCustomizeTemplate');
    		var recipientTypeCombo=form.down('#recipientType');
    		var templateDataProviderCombo=form.down('#templateDataProvider');
    		var templateDataTabPanel=form.down('#templateDataTabPanel');
    		var systemMsgEventCombo=form.down('#systemMsgEventCombo');
    		var messageTemplateTypeGrp=form.down('#messageTemplateType');
    		
    		//First to reset component data
//    		me.resetComponentData(form);
    		
    		if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isStaticTemplate' && newValue==true){    			
    			isCustomizeTemplate.setValue(false);
    			isCustomizeTemplate.setDisabled(true); 
    			recipientTypeCombo.setDisabled(true);
    			templateDataProviderCombo.setDisabled(true);
    			templateDataProviderCombo.clearValue();
    			templateDataTabPanel.setVisible(false);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isStaticTemplate' && newValue==false){         		
    			isCustomizeTemplate.setValue(false);
    			isCustomizeTemplate.setDisabled(false);
    			recipientTypeCombo.setDisabled(true);
    			templateDataProviderCombo.setDisabled(false);
    			templateDataTabPanel.setVisible(true);
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isCustomizeTemplate' && newValue==true){        		        		
        		        		      
        		if(recipientTypeCombo){
        			recipientTypeCombo.reset();
        			recipientTypeCombo.getStore().removeAll();
        			
        			if(messageTemplateTypeGrp &&
        	 		   !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
        	 		   (messageTemplateTypeGrp.getValue().messageTemplateType=='ADHOC_MESSAGE_TEMPLATE')){    					    					
        	    				recipientTypeCombo.getStore().getProxy().api.read= SERVERURL.FIND_ALL_ADHOC_RECIPIENT_TYPES;  //URL - : 'rest/msgRecipientTypeResource/findAllAdhocRecipientTypes'
        	    				recipientTypeCombo.getStore().load();    		    
        	    				me.showRecipientTypeCombo(isStaticTemplate,templateDataProviderCombo,templateDataTabPanel,recipientTypeCombo);    		    				
        	        			
        	    	}else if(messageTemplateTypeGrp &&
        	    			 !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
        	    			 (messageTemplateTypeGrp.getValue().messageTemplateType=='SYSTEM_EVENT_TEMPLATE')){    	
        	    		    		    		
        	    			if(!isNullOrEmpty(systemMsgEventCombo.getValue())){
        	    				recipientTypeCombo.getStore().getProxy().api.read= SERVERURL.FIND_ALL_RECIPIENT_TYPES_BY_EVENT_ID;  //URL - : 'rest/msgRecipientTypeResource/findAllBySysMsgEventId'
        	    				recipientTypeCombo.getStore().load({
        	    					params:{
        	    						id:systemMsgEventCombo.getValue()
        	    					}
        	    				});  
        	    				me.showRecipientTypeCombo(isStaticTemplate,templateDataProviderCombo,templateDataTabPanel,recipientTypeCombo);
        	    				
        	    			}else{
        	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_SYSTEM_MESSAGE_EVENT')); //Please select system message event
        	    				checkbox.setValue(false);
        	    			}    			  			    		        		    		    			
        	    	}
    				
    			}    			
    			
        	}else if(!isNullOrEmpty(checkbox.itemId) && checkbox.itemId==='isCustomizeTemplate' && newValue==false){        		
        		isStaticTemplate.setValue(false);
        		isStaticTemplate.setDisabled(false);
    			recipientTypeCombo.setDisabled(true);
    			recipientTypeCombo.clearValue();
    			templateDataProviderCombo.setDisabled(false);
    			templateDataTabPanel.setVisible(true);
        	}
    	}    	
    },
    
    
    /**
     * This method is used for to show  Recipient Type Combo and also show dependent components
     * @param isStaticTemplate - checkbox reference     
     * @param templateDataProviderCombo - Template Data Provider Combo reference
     * @param templateDataTabPanel - Template Data Tab Panel reference
     * @param recipientTypeCombo - Recipient Type Combo reference
     *  
     */
    showRecipientTypeCombo:function(isStaticTemplate,templateDataProviderCombo,templateDataTabPanel,recipientTypeCombo){
    	
    	isStaticTemplate.setValue(false);
		isStaticTemplate.setDisabled(true); 
//		templateDataProviderCombo.setVisible(true);
		templateDataProviderCombo.setDisabled(false);
		templateDataTabPanel.setVisible(true);
//		recipientTypeCombo.setVisible(true);
		recipientTypeCombo.setDisabled(false);
		
    },
    
    /**
     * This method is used for hide/show System Message Event Combo
     * @param radiofield - radiofield reference     
     * @param newValue - radiofield's new value
     * @param oldValue - radiofield's old value
     *  
     */
    hideShowSysMsgEventCmb:function(radiofield,newValue,oldValue){    	
    	var form=radiofield.up('form');    	
    	if(form){
    		var systemMsgEventCombo=form.down('#systemMsgEventCombo');
    		var messageSubCategoryCombo=form.down('#messageSubCategory');
    		var isStaticTemplate=form.down('#isStaticTemplate');
    		var isCustomizeTemplate=form.down('#isCustomizeTemplate');
    		var radioValue = radiofield.getValue().messageTemplateType;
    		
    		if(radioValue=='SYSTEM_EVENT_TEMPLATE'){
    			if(!isNullOrEmpty(messageSubCategoryCombo.getValue())){
    				systemMsgEventCombo.reset();
    				systemMsgEventCombo.getStore().removeAll();
    				systemMsgEventCombo.getStore().load({
    					params:{
    						id:messageSubCategoryCombo.getValue()
    					}
    				});
    				systemMsgEventCombo.setDisabled(false); 
    			}else{
    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_SUB_CATEGORY')); //Please select message sub category before selecting sys event template.
    				radiofield.setValue({messageTemplateType:'ADHOC_MESSAGE_TEMPLATE'});
    			}    			  			
        	}else{         		
        		systemMsgEventCombo.setDisabled(true); 
        		systemMsgEventCombo.clearValue();
        	}
    	}
    },
    
    /**
     * This method is used for to clear component data  
     * @param form - form reference 
     *  
     */
    resetComponentData:function(form){
    	
    	var genrateTemplateTabForm=form.down('#genrateTemplateTabForm');
    	var messageTemplatesHiddenField=form.down('#messageTemplates');
    	var recipientType=form.down('#recipientType');
    	
		genrateTemplateTabForm.getForm().reset();
		
		if(!isNullOrEmpty(messageTemplatesHiddenField.getValue())){
			showConfirmMessage(getMessagingModuleTranslation('CLEARE_MESSAGE_TEMPLATE'), getMessagingModuleTranslation('CLEARE_MESSAGE_TEMPLATE_CONTENT'), function(btn, text) {
	            if (btn == 'yes') {
	            	messageTemplatesHiddenField.setValue("");
	            	recipientType.setValue("");
	            }
	            });
		}		
    },
    
    /**
     * This method is used for to check approval assigned to template  
     * @param checkbox - checkbox reference     
     * @param newValue - checkbox's new value
     * @param oldValue - checkbox's old value 
     */
    checkApproval:function(checkbox,newValue,oldValue){
    	var form=checkbox.up('form');    	    	
    	if(form){
    		var approver=form.down('#approver');    
    		var btnSendForApproval=form.down('#btnSendForApproval');
    		if(newValue==true){
    			approver.setDisabled(false);
//    			approver.setVisible(true);
    			btnSendForApproval.setVisible(true);
        	}else if(newValue==false){
        		approver.clearValue();
        		approver.setDisabled(true);
//        		approver.setVisible(false);
        		btnSendForApproval.setVisible(false);
        	}    		
    	}    	
    },
    
    /**
     * This method is used for to insert message mode  
     * @param checkboxgroup - checkbox group reference
     *             
     */
    insertMessageModes:function(checkboxgroup,isEdit,messageTemplatesHiddenField,messageModeCombo){
    	var me=this;
    	
		if(!isNullOrEmpty(isEdit) && isEdit==true){
			
			if(!isNullOrEmpty(messageTemplatesHiddenField.getValue())){
				
				messageTemplates = Ext.decode(messageTemplatesHiddenField.getValue());        	    			
				var selectedMessageModeArray=checkboxgroup.items;            	    			
	    		    	
		    	for(var messageModeCount=0;messageModeCount<selectedMessageModeArray.length;messageModeCount++){
		    		 var messageMode=selectedMessageModeArray.items[messageModeCount];
	    		   	 var messageModeId=selectedMessageModeArray.items[messageModeCount].checkBoxId;     	    					
		    					
		    			var isTemplateExistForMessageMode=false;
	    	            for(var count=0;count<messageTemplates.length;count++){
	    	            	var messageDeliveryModeId=messageTemplates[count].msgDeliveryMode.id;
	    	            	if(messageDeliveryModeId===messageModeId){
	    	            		isTemplateExistForMessageMode=true;
	    	            		break;        	            				         				
	    	            	}    			
	    	            }   
	    	            		
	    	            if(isTemplateExistForMessageMode){
	    	           		messageMode.setValue(true);
	    	           		
	    	           		if(messageModeCombo){
	    	           			if(messageModeCombo.getStore().data.length>0){
	    	           				var firstRecord=messageModeCombo.getStore().data.items[0].data;
	    	           				if(!isNullOrEmpty(firstRecord.id)){                        	           					
	    	           					messageModeCombo.setValue(firstRecord.id);
	    	           					me.showHideSubjectField(messageModeCombo, messageModeCombo.getStore().data.items);                        	           					                        	           					
	    	           				}                        	           				
	    	           			}
	    	           		}
	    	            }                        	    					
		    	}
		    		 	                	    	    		                    	    				    	            		    	            		
			}                		
		}
                	
    },
    
    /**
     * This method is used for to add or remove message mode from message mode combo  
     * @param checkbox - message mode checkbox group reference
     * @param messageModes - object which contains key and values of new selected message mode checkbox
     * @param oldValue - object which contains key and values of old selected message mode checkbox
     *             
     */
    addOrRemoveMessageMode:function(checkboxgrp, messageModes, oldValue){
    	var form=checkboxgrp.up('form');    	    	
    	if(form){
    		var messageModeCombo=form.down("#messageModeCombo");
    		if(messageModeCombo){
    			var subject=form.down("#subject");
    			subject.setVisible(false);
        		var ckEditor=form.down("#ckEditor");
    			messageModeCombo.reset();
    			subject.reset();
    			try{
    				ckEditor.setValue("");
    			}catch(e){
    				
    			}
    			var messageModeComboStore=messageModeCombo.getStore();     			
    		    messageModeComboStore.removeAll();
    		    var checkBoxArray=checkboxgrp.getChecked();
    		    for(var count=0;count<checkBoxArray.length;count++){
    		    	var chkBox=checkBoxArray[count];
    		    	if(chkBox){
    		    		var messageModeObject=new Object();
        		    	messageModeObject.id=chkBox.checkBoxId;
        		    	messageModeObject.name=chkBox.name;
        		    	messageModeObject.value=getMessagingModuleTranslation(chkBox.name);
        		    	messageModeObject.whetherMsgSubjAvail=chkBox.whetherMsgSubjAvail;
        		    	messageModeObject.whetherAttachmentSupported=chkBox.whetherAttachmentSupported;	                    
        	            messageModeComboStore.add(messageModeObject); 
    		    	}
    		    }    		    
    		}
    	}
    },
    
    
    /**
     * This method is used for to add data to template  
     * @param button - button reference           
     */
    addDataToTemplate:function(button){
    	var templateForm=button.up('form');
    	if(templateForm){
    		var genrateTemplateTabForm=templateForm.up("#genrateTemplateTabForm");
    		var propertyCombo=templateForm.down("#property");
    		if(genrateTemplateTabForm && propertyCombo){    			   			
      		  	  var ckeditor=genrateTemplateTabForm.down('ckeditor');
      		  	  var subject=genrateTemplateTabForm.down("#subject");
                  var propertyValue=propertyCombo.getValue();
                  if(ckeditor && !isNullOrEmpty(propertyValue)){
                	  var dynamicVariable='';
                	  var templateDataTabPanel=button.up('templatedatatabpanel');
          			  if(templateDataTabPanel){          					
          					var activeTab=templateDataTabPanel.getActiveTab();          					
          					if(activeTab.itemId=="genrateTemplateForm"){
          						dynamicVariable='$["'+propertyValue+'"]';	
          					}else if(activeTab.itemId=="templateRecipientForm"){
          						dynamicVariable='#["'+propertyValue+'"]';
          					} 
          			  }                       
                     // ckeditor.editor.insertText(dynamicVariable);
                      
                      //TODO:To complete setting dynamic variable to subject text box
          			  
          			  if(subject.selectOnFocus){
          				var subjectValue = subject.getValue();                      
                        var caretPosition = subject.inputEl.dom.selectionStart;                      
                                              
                        subjectValue = subjectValue.substring(0, caretPosition)                      
                        + dynamicVariable  + subjectValue.substring(caretPosition);
                        
                        subject.setValue(subjectValue);
          			  }else{
          				ckeditor.editor.insertText(dynamicVariable);
          			  }
//          			subject.selectOnFocus = false;
                  }                  
    		}
    	}    	
    },
    
    /**
     * This method is used for to create/update template  
     * @param button - button reference          
     */
    saveMessageTemplateOnSystem:function(button,isResubmitForApprovalFlow,btnReSubmitForApproval){
    	var me=this;
    	var basicSetUpForm=button.up('form');
    	if(basicSetUpForm){
    		    var messageModeGrp=basicSetUpForm.down("#messageModeGrp");
    		    if(messageModeGrp){
    		    	var selectedMessageModeArray=messageModeGrp.getChecked();
    		    	if(selectedMessageModeArray.length==0){
    		    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_MODE')); //Please select message mode.
    		    		return 0;
    		    	}else{
    		    		//V2D-345728
    					var messageModeArray=[];
    		    		var messageTemplatesHiddenField=basicSetUpForm.down("#messageTemplates");
    	    			if(!isNullOrEmpty(messageTemplatesHiddenField.getValue())){
    	    				messageTemplates = Ext.decode(messageTemplatesHiddenField.getValue());
    	    				
    	    				for(var messageModeCount=0;messageModeCount<selectedMessageModeArray.length;messageModeCount++){
    	    					var messageModeId=selectedMessageModeArray[messageModeCount].checkBoxId;    	    					
    	    					var isTemplateExistForMessageMode=false;
        	            		for(var count=0;count<messageTemplates.length;count++){
        	            			var messageDeliveryModeId=messageTemplates[count].msgDeliveryMode.id;
        	            			if(messageDeliveryModeId===messageModeId){
        	            				isTemplateExistForMessageMode=true;
        	            				messageModeArray.push(messageDeliveryModeId);
        	            				break;        	            				         				
        	            			}    			
        	            		}   
        	            		
        	            		if(!isTemplateExistForMessageMode){
        	            			var modeName = '';
        	            			if(messageModeId == 1){
        	            				modeName = getMessagingModuleTranslation('EMAIL');
        	            			}else if(messageModeId == 2){
        	            				modeName = getMessagingModuleTranslation('SMS');
        	            			}else if(messageModeId == 3){
        	            				modeName = getMessagingModuleTranslation('LETTER');
        	            			}else if(messageModeId == 4){
        	            				modeName = getMessagingModuleTranslation('SYS_INTERNAL_MSG');
        	            			}else if(messageModeId == 5){
        	            				modeName = getMessagingModuleTranslation('WEB_LINK');
        	            			}
        	            			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ADD_TEMPLATE_FOR')+modeName); //Please add template for
        	            			return 0;
        	            		}
    	    					
    	    				}    	            		    	            		
    	    			}else{
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ADD_TEMPLATE')); //Please add template for selected message mode.
    	    				return 0;
    	    			}
    		    	}
    		    }
    		    var isApprovalRequired=basicSetUpForm.down("#isApprovalRequired");
    	        if(isApprovalRequired.getValue()){
    	        	var approver = basicSetUpForm.down("#approver").getValue();
    	        	if(!Ext.isNumber(approver) || isNullOrEmpty(approver)){	
    	        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('SELECT_APPROVAR_USER'));
    	        		return 0;
    	        	}
    	        }
    		    var staticDocumentGrid = basicSetUpForm.down('#staticDocumentAttachmentGrid');//this.getStaticDocumentAttachmentGrid();
    		    var staticDocumentStore = staticDocumentGrid.getStore();
    		    var staticDocuments = [];
    		    staticDocumentStore.each(function(values){
    		    	var staticDocumentObject = {};
    		    	staticDocumentObject.id = values.get('id');
    		    	staticDocumentObject.templateConfigDocId = values.get('templateConfigDocId');
    		    	staticDocumentObject.name = values.get('name');
    		    	var date = values.get('submissionDate');
    		    	if(isNullOrEmpty(date)){
    		    		date = Ext.Date.format(new Date(), 'd-m-Y');
    		    	}
    		    	
    		    	staticDocumentObject.submissionDate = date;
    		    	staticDocumentObject.path = values.get('path');
		    		staticDocumentObject.createdBy = {
		    			id : values.get('createdBy').id,
		    			value : values.get('createdBy').value,
		    			code : values.get('createdBy').code
		    		},
		    		staticDocumentObject.status = values.get('status');
		    		staticDocumentObject.documentType = values.get('documentType');
		    		staticDocuments.push(staticDocumentObject);
    		    });
    			
    			var submitUrl="",methodType="",isUpdate=false;
    	        var id = basicSetUpForm.down('#ID').getValue();
    	        if(isNullOrEmpty(id)){        	        	 
    	        	submitUrl = SERVERURL.MESSAGE_TEMPLATE_CREATE, //URL-:rest/msgTemplateConfigResource/create
    	        	methodType = 'POST';
    	        	isUpdate=false;
    	        }else{ 
    	        	submitUrl = SERVERURL.MESSAGE_TEMPLATE_UPDATE, //URL-:rest/msgTemplateConfigResource/update
    	        	methodType = 'POST';
    	        	isUpdate=true;
    	        }
    	        var jsonFormatFormData = me.getJsonDataToSaveTemplate(basicSetUpForm,staticDocuments,messageModeArray);
    	        if (!isNullOrEmpty(jsonFormatFormData)) { 
    	        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                	Ext.Ajax.request({
                        type: 'rest',                                    
                        url: submitUrl,
                        jsonData: jsonFormatFormData,
                        method: methodType,
                        success: function(response, action) {                        	                        	                                               	
                        	
                        	var isApprovalRequired=basicSetUpForm.down('#isApprovalRequired');
                        	var btnSendForApproval=basicSetUpForm.down('#btnSendForApproval');
                        	var templateSubmitBtn=basicSetUpForm.down('#templateSubmitBtn');
                        	
                        	if(isApprovalRequired.getValue() && !isUpdate){ //Create with approval
                        		btnSendForApproval.setDisabled(false);
                        		templateSubmitBtn.setDisabled(true);
                        		var hiddenIDField=basicSetUpForm.down("#ID");
                        		if(hiddenIDField && !isNullOrEmpty(response.responseText)){
                        			hiddenIDField.setValue(response.responseText);
                        		}
                        		me.giveSuccessMsg(isUpdate);
                        	}else if(!isNullOrEmpty(isResubmitForApprovalFlow) && isResubmitForApprovalFlow){
                        		var hiddenIDField=basicSetUpForm.down("#ID");
                        		if(hiddenIDField && !isNullOrEmpty(response.responseText)){
                        			hiddenIDField.setValue(response.responseText);
                        		}
                        		me.approveRejectResubmitTemplate(btnReSubmitForApproval,getMessagingModuleTranslation('TEMP_RESUBMITTED_MSG')); //Message template resubmitted successfully.
                        	}else{
                        		basicSetUpForm.up('templatebasicsetupform').close();
                        		me.giveSuccessMsg(isUpdate);
                        		var SearchForm = me.getTemplateSearchForm();
	                            if(SearchForm){
	                            	var statusCombo=SearchForm.down("#statusCombo");
	                            	if(statusCombo){
	                            		statusCombo.setValue("All");
	                            	}
	                            }
                        		me.loadTemplateGridAndSearchRequest();
                        	}
                        	Ext.getBody().unmask();
                        },
                        failure: function(response, action) {                        	                        	                                               	
                        	Ext.getBody().unmask();
                        }	
                    });
                }   	
    		}        		    	
    },
    
    giveSuccessMsg:function(isUpdate){
    	if(isUpdate){
    		showSuccessMessage(getMessagingModuleTranslation('UPDATE_MESSAGING_TEMPLATE'), getMessagingModuleTranslation('UPDATE_MESSAGING_TEMPLATE_MSG')); //Messaging template updated successfully
    	}else{
    		showSuccessMessage(getMessagingModuleTranslation('ADD_MESSAGING_TEMPLATE'), getMessagingModuleTranslation('ADD_MESSAGING_TEMPLATE_MSG')); //Messaging template added successfully
    	}     
    },
    /**
     * This method is used for to create json for saving template  
     *           
     */
    getJsonDataToSaveTemplate: function(basicSetUpForm,staticDocuments,messageModeArray) {
    	var this$=this;
    	var jsonDataObject=new Object();
        var basicSetUpDataTemplateArray = basicSetUpForm.getValues(); 
                
        if(!isEmpty(basicSetUpDataTemplateArray)){
        	jsonDataObject.id=(!isNullOrEmpty(basicSetUpDataTemplateArray.id)) ? basicSetUpDataTemplateArray.id : null;
        	jsonDataObject.code=(!isNullOrEmpty(basicSetUpDataTemplateArray.code)) ? basicSetUpDataTemplateArray.code : null;
        	jsonDataObject.templateConfigName=(!isNullOrEmpty(basicSetUpDataTemplateArray.templateConfigName)) ? basicSetUpDataTemplateArray.templateConfigName : null;
        	jsonDataObject.templateId=(!isNullOrEmpty(basicSetUpDataTemplateArray.templateId)) ? basicSetUpDataTemplateArray.templateId : null;
        	jsonDataObject.msgSubCategoryId=(!isNullOrEmpty(basicSetUpDataTemplateArray.msgSubCategoryId)) ? basicSetUpDataTemplateArray.msgSubCategoryId : null;
        	jsonDataObject.templateDataProviderId=(!isNullOrEmpty(basicSetUpDataTemplateArray.templateDataProviderId)) ? basicSetUpDataTemplateArray.templateDataProviderId : null;        	 	
        	
        	jsonDataObject.whetherStaticMsg=(!isNullOrEmpty(basicSetUpDataTemplateArray.whetherStaticMsg)) ? basicSetUpDataTemplateArray.whetherStaticMsg : false;
        	jsonDataObject.recipientTypeId=(!isNullOrEmpty(basicSetUpDataTemplateArray.recipientTypeId)) ? basicSetUpDataTemplateArray.recipientTypeId : null;
        	jsonDataObject.msgMessageTypeId=(!isNullOrEmpty(basicSetUpDataTemplateArray.msgMessageTypeId)) ? basicSetUpDataTemplateArray.msgMessageTypeId : null;
        	jsonDataObject.approvalRequired=(!isNullOrEmpty(basicSetUpDataTemplateArray.approvalRequired)) ? basicSetUpDataTemplateArray.approvalRequired:false;
        	if(!isNullOrEmpty(basicSetUpDataTemplateArray.approverId)){
        		jsonDataObject.approverId=basicSetUpDataTemplateArray.approverId.id;
        	}else{
        		jsonDataObject.approverId=null;
        	}        	 
        	jsonDataObject.messageTemplates=(!isEmpty(Ext.decode(basicSetUpDataTemplateArray.messageTemplates))) ? Ext.decode(basicSetUpDataTemplateArray.messageTemplates) : null;
        	var msgTemplateArray=[];
        	msgTemplateArray=jsonDataObject.messageTemplates;
        	var msgTempArray=[];
        	for(var i=0;i<msgTemplateArray.length;i++){
        		var msgTemp=msgTemplateArray[i];
        		for(var j=0;j<messageModeArray.length;j++){
        			if(messageModeArray[j]===msgTemp.msgDeliveryMode.id){
        				msgTempArray.push(msgTemp);
        				break;
        			}
        		}
        	}
        	jsonDataObject.messageTemplates=msgTempArray;
        	
        	var academyLocation=this$.getCurrentAcademyLocation();
        	if(!isNullOrEmpty(academyLocation)){
        		jsonDataObject.academyLocationId=academyLocation;
        	}
        	
        	var currentlyLoggedInUser=this$.getCurrentlyLoggedInUser();
        	if(!isEmpty(currentlyLoggedInUser)){
        		jsonDataObject.authorId=currentlyLoggedInUser.id;
        		jsonDataObject.authorName=currentlyLoggedInUser.value;
        	}
        	
        	var messageTemplateTypeGrp=basicSetUpForm.down('#messageTemplateType');
        	var systemMsgEventCombo=basicSetUpForm.down('#systemMsgEventCombo');
        	if(messageTemplateTypeGrp && systemMsgEventCombo &&
	    	   !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
	    	   (messageTemplateTypeGrp.getValue().messageTemplateType=='SYSTEM_EVENT_TEMPLATE')){
        		jsonDataObject.systemMsgEventId=systemMsgEventCombo.getValue();
        		jsonDataObject.availableForAdhocMsg=false; 
        	}else if(messageTemplateTypeGrp &&
     	    	   !isNullOrEmpty(messageTemplateTypeGrp.getValue().messageTemplateType) && 
    	    	   (messageTemplateTypeGrp.getValue().messageTemplateType=='ADHOC_MESSAGE_TEMPLATE')){
        		jsonDataObject.availableForAdhocMsg=true;
        	}
        	
        	var isApprovalRequired=basicSetUpForm.down('#isApprovalRequired');
        	if(isApprovalRequired.getValue()){
        		jsonDataObject.status=CONSTANTS.MSG_TEMP_DRAFT;
        	}else{
        		jsonDataObject.status=CONSTANTS.MSG_TEMP_APPROVED;
        	}        	        	
        	
        	var documentSelector=basicSetUpForm.down("#messagingTemplateDocumentSelector");        	
        	var selectedDocumentsArray=documentSelector.getValue();
        	if(selectedDocumentsArray.length>0){
				var documents=new Array();
				for(var selectedDocumentCount=0;selectedDocumentCount<selectedDocumentsArray.length;selectedDocumentCount++){					
					var record=documentSelector.getStore().findRecord('documentId',selectedDocumentsArray[selectedDocumentCount]);
					if(record){					
						var object=new Object();
						object.id=record.get('id');
						object.documentName=record.get('documentName');												
						object.documentId=record.get('documentId');												
						documents.push(object);
					}						
				}				
				if(documents.length>0){
					jsonDataObject.documents=documents;
				}
			}
        	if(staticDocuments){
        		jsonDataObject.staticDocuments = staticDocuments;
        	}
        	
        	if(!isNullOrEmpty(basicSetUpDataTemplateArray.MESSAGE_LANGUAGE)){
        		jsonDataObject.templatelanguageValue = basicSetUpDataTemplateArray.MESSAGE_LANGUAGE;
            	var msgLanguageCombo=basicSetUpForm.down("#msgLanguageCombo");
            	var store = msgLanguageCombo.getStore();
            	var record=store.findRecord('code',basicSetUpDataTemplateArray.MESSAGE_LANGUAGE);
            	jsonDataObject.templatelanguageId = record.data.id;
        	}
        }
        
        return Ext.encode(jsonDataObject);
    },
    
    
    /**
     * This method is used for to create/update template data and keep it in hidden field on Client Side  
     * @param button - button reference          
     */
    saveMessageTemplateOnForm:function(button){
    	var me=this;
    	var genrateTemplateTabForm=button.up('#genrateTemplateTabForm');
    	var templatebasicsetupform=button.up('templatebasicsetupform');
    	if(templatebasicsetupform && genrateTemplateTabForm){
    		var messageTemplates=new Array();
    		    		
    		var messageMode=genrateTemplateTabForm.down("#messageModeCombo");
    		var subject=genrateTemplateTabForm.down("#subject");
    		var ckeditor=genrateTemplateTabForm.down("ckeditor");
    		if(messageMode && !isNullOrEmpty(messageMode.getValue())){
    			
    			var messageModeId=messageMode.getValue();    			
    			var messageModeRecord=messageMode.getStore().getById(messageModeId);    			    	    	    	    		
    	    	if(subject){    	    			
    	    		if(messageModeRecord.get('whetherMsgSubjAvail')){ 
    	    			if(isNullOrEmpty(subject.getValue().trim())){
    	    				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_SUBJECT')); //Please enter subject.
    	    				return true;
    	    			}
    	    		}
    	    	}    	    	
    	    	
    	    	if(ckeditor && !isNullOrEmpty(ckeditor.editor.document.getBody().$.textContent)){
        			var messageTemplatesHiddenField=templatebasicsetupform.down("#messageTemplates");
        			var msgTemplateId="";
        			if(!isNullOrEmpty(messageTemplatesHiddenField.getValue())){
        				messageTemplates = Ext.decode(messageTemplatesHiddenField.getValue());
                		                		
                		for(var count=0;count<messageTemplates.length;count++){
                			var messageDeliveryModeId=messageTemplates[count].msgDeliveryMode.id;
                			if(messageDeliveryModeId===messageModeId){        				
                				if(!isNullOrEmpty(messageTemplates[count].id)){
                					msgTemplateId=messageTemplates[count].id;
                				}
                				messageTemplates.splice(count,1);
                			}    			
                		}                		
        			}
            		
            		var messageTemplate=new Object();        		
            		if(!isNullOrEmpty(msgTemplateId)){
						messageTemplate.id=msgTemplateId;
            		}
            		
            		if(subject && messageModeRecord.get('whetherMsgSubjAvail')){
            			messageTemplate.subjectLine=subject.getValue();
    	    		}
            		
            		var string="";
            		if(messageModeId==2 || messageModeId==6){ //SMS Mode and pushnotification mode
            			string=ckeditor.editor.document.getBody().$.textContent;
            			string = me.replaceAll(string,'$["', '$templateData["');
                        string = me.replaceAll(string,'#["', '$recipientData["');
            		}else{
            			string=ckeditor.getValue();
            			string = me.replaceAll(string,'$[&quot;', '$templateData[&quot;');
                        string = me.replaceAll(string,'#[&quot;', '$recipientData[&quot;');
                        /**
                         * @author Ravi Choudhary
                         * below code added to remove body and html close tages from the middle of html string
                         */
                        var str = string.split('</body>\n</html>');
                        if(str.length > 1 && str[1].length > 5) {
                            string=str[0]+str[1]+'</body>\n</html>';
                        }
            		}            		
            		string = string.replace(/(<p>&nbsp;<\/p>\s*)+(?=<\/body>)/gi, ""); // removing new line before body closing 
            		messageTemplate.msgContent=string;
            		
            		var msgDeliveryMode=new Object();
            		msgDeliveryMode.id= messageModeId;
            		msgDeliveryMode.code=messageMode.getRawValue();
            		msgDeliveryMode.whetherMsgSubjAvail=true;
            		msgDeliveryMode.whetherAttachmentSupported=true;
            		messageTemplate.msgDeliveryMode=msgDeliveryMode;
            		
            		messageTemplates.push(messageTemplate);
            		messageTemplatesHiddenField.setValue(Ext.encode(messageTemplates));
            		showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('ADD_TEMPLATE_DETAIL_SUCCESS'));
            		/********** Clear Message Template **************/
            		messageMode.reset();
            		if(subject && messageModeRecord.get('whetherMsgSubjAvail')){ 
            			subject.reset();
    	    		}        		
            		try{
        				ckeditor.setValue("");
        			}catch(e){
        				
        			}

    	    	}else{
    	    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_ENTER_MESSAGE_TEMPLATE_BODY')); //Please enter a message template body.
    	    	}    			
    		}else{
    			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_SELECT_MESSAGE_MODE')); //Please select a message mode.
    		}    		    		    		
    	}    	    	
    },
    
    /**
     * This method is used for to delete message template  
     * @param button - button reference   
     */
    deleteMessageTemplate: function(button) {
    	var this$ = this;
    	var grid =button.up('grid'),submitURL="";
    	if(grid){
    		var grdStore = grid.getStore();
    		if (grid.getSelectionModel().getCount() > 0) {        	
            	showConfirmMessage(getMessagingModuleTranslation('DELETE_MESSAGING_TEMPLATE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                    	 if (grid.getSelectionModel().getCount() > 0) {
                             var records = grid.getSelectionModel().getSelection();
                             for (var count = 0; count < records.length; count++) {
                                 var id = "";                                 
                                 if (!isNullOrEmpty(records[count].get("ID"))) {
                                     id = records[count].get("ID");
                                 }
                                 if(isNullOrEmpty(submitURL)){
                                	 submitURL=SERVERURL.MESSAGE_TEMPLATE_DELETE;  //URL-rest/msgTemplateConfigResource/delete
                                	 submitURL=submitURL.concat("?id="+id);
                                 }
                                 Ext.Ajax.request({
                                     type: 'rest',                                     
                                     url: submitURL, 													 
                                     method: 'DELETE',
                                     success: function(form, action) {
                                         grdStore.reload();
                                         this$.closeMessageTemplateTab();
                                         showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('DELETE_MESSAGING_TEMPLATE_MSG')); //Message Template deleted successfully
                                     }
                                 });
                             }
                         }
                    }
                });        	
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
    	}                        
    },
    
    closeMessageTemplateTab: function(){
    	var this$= this;
    	var editTab = this$.getTabReferenceByTabTitle(getMessagingModuleTranslation('EDIT_TEMPLATE'));
    	if(editTab){
    		editTab.close();
    	}
    	
    	var viewTab = this$.getTabReferenceByTabTitle(getMessagingModuleTranslation('VIEW_TEMPLATE'));
    	if(viewTab){
    		viewTab.close();
    	}
    	
    },
    
    /**
     * This method is used for to clear dependent fields   
     * @param button - button reference
     *    
     */
    clearDependentFields: function(selectedField) {
    	var isTemplateComboReset, isRecipientTemplateComboReset;
    	var basicSetUpForm=selectedField.up('templatebasicsetupform');
    	if(basicSetUpForm){
        	var messageSubCategory=basicSetUpForm.down("#messageSubCategory");
        	var templateDataProvider=basicSetUpForm.down("#templateDataProvider");
        	var systemMsgEventCombo=basicSetUpForm.down("#systemMsgEventCombo");
        	var recipientType=basicSetUpForm.down("#recipientType");        	
        	var adhocMessageTemplate=basicSetUpForm.down("#adhocMessageTemplate");
        	var isCustomizeTemplate=basicSetUpForm.down("#isCustomizeTemplate");
        	var isStaticTemplate=basicSetUpForm.down("#isStaticTemplate");
        	
        	if(selectedField && !isNullOrEmpty(selectedField.getItemId())){
        		var itemId=selectedField.getItemId();
        		switch(itemId) {
                case 'messageCategory':
                	messageSubCategory.reset();
                	messageSubCategory.getStore().removeAll();
                	templateDataProvider.reset();
                	templateDataProvider.getStore().removeAll();
                	systemMsgEventCombo.reset();
                	systemMsgEventCombo.getStore().removeAll();
                	recipientType.reset();
                	recipientType.getStore().removeAll();
                	adhocMessageTemplate.setValue(true);
                	isCustomizeTemplate.setValue(false);
                	isStaticTemplate.setValue(false);
                	isTemplateComboReset = true;
                	isRecipientTemplateComboReset = true;
                	this.clearTabDetailsField(basicSetUpForm, isTemplateComboReset, isRecipientTemplateComboReset);
                    break;
                    
                case 'messageSubCategory':
                	templateDataProvider.reset();
                	templateDataProvider.getStore().removeAll();
                	systemMsgEventCombo.reset();
                	systemMsgEventCombo.getStore().removeAll();                	
                	recipientType.reset();
                	recipientType.getStore().removeAll();
                	isCustomizeTemplate.setValue(false);
                	isStaticTemplate.setValue(false);
                	isTemplateComboReset = true;
                	isRecipientTemplateComboReset = true;
                	this.clearTabDetailsField(basicSetUpForm, isTemplateComboReset, isRecipientTemplateComboReset);
                    break;
                    
                case 'templateDataProvider':

                	isTemplateComboReset = true;
                	isRecipientTemplateComboReset = false;
                	this.clearTabDetailsField(basicSetUpForm, isTemplateComboReset, isRecipientTemplateComboReset);
                    break;                    
                
                case 'recipientType':
                	isTemplateComboReset = false;
                	isRecipientTemplateComboReset = true;
                	this.clearTabDetailsField(basicSetUpForm, isTemplateComboReset, isRecipientTemplateComboReset);
                    break;
                    
                default:
                	this.clearTabDetailsField(basicSetUpForm, true, true);
        		}
        	}
    	}    	    
    },
    
    clearTabDetailsField: function(basicSetUpForm, isTemplateComboReset, isRecipientTemplateComboReset){
    	if(basicSetUpForm){
    		var messageTemplates = basicSetUpForm.down('#messageTemplates');
    		messageTemplates.setValue("");
        	var genrateTemplateTabForm = basicSetUpForm.down('#genrateTemplateTabForm');
        	var genrateTemplatePropertyCombo=basicSetUpForm.query("form[itemId=genrateTemplateForm] > fieldcontainer > combo[itemId=property]")[0];
        	var recipientPropertyCombo=basicSetUpForm.query("form[itemId=templateRecipientForm] > fieldcontainer > combo[itemId=property]")[0];
        	genrateTemplateTabForm.down('#messageModeCombo').reset();
        	genrateTemplateTabForm.down('#subject').reset();
        	genrateTemplateTabForm.down('#ckEditor').setValue('');
        	if(isTemplateComboReset){
        		genrateTemplatePropertyCombo.reset();     
            	genrateTemplatePropertyCombo.getStore().removeAll();
        	}
        	if(isRecipientTemplateComboReset){
        		var templateReportForm = basicSetUpForm.down('#templateReportForm');
            	var messagingTemplateDocumentSelector = templateReportForm.down('#messagingTemplateDocumentSelector');
            	
        		recipientPropertyCombo.reset();
            	recipientPropertyCombo.getStore().removeAll();
            	
            	messagingTemplateDocumentSelector.getStore().removeAll();
            	messagingTemplateDocumentSelector.reset();
        	}
        	
    	}
    },
   
    /**
     * save document file. It's external call method
     * @param entityId : person id, It's mandatory. 
     * @param module : module name, for student module 'student', It's mandatory.
     * @param entityType : entity type, It's mandatory.
     * @param documentType : document type, It's mandatory.
     * @param isTransient : true or false (send json back to module controller or not)
     * @param callBackFunction : callback function return in module controller. It's mandatory.
     */
    saveStaticDocumentForm : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
    	var submitUrl = '';
    	var templateTab = this.getContentPanel().getActiveTab();
    	var form = templateTab.down('#staticDocumentUploadForm'); 
    	var id = form.down('#document_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
        }
        var data = new Object();
        if(!isNullOrEmpty(entityId)){
        	data.entityId = entityId;
        }else{
        	data.entityId = null;
        }
        if(!isNullOrEmpty(module)){
        	data.module = module;
        }else{
        	data.module = null;
        }
        if(!isNullOrEmpty(entityType)){
        	data.entityType = entityType;
        }else{
        	data.entityType = null;
        }
        form.getForm().setValues(data);
        form.getForm().submit({
        	method : 'POST',
        	url : submitUrl,
        	success : function(form, action){
        		callBackFunction(true, action, isTransient);
        		
        	}
        });
    },
    
    /**
     * Add value to grid
     */
    loadGridWithFileName:function(grid,value,store){
    	grid.bindStore(store);
    },
    
    /**
     * upload static document file
     */

    uploadStaticDocumentFile: function(fileField, fileUploadPath, eOpts){
    	var this$ = this;
    	var setupForm = fileField.up('templatebasicsetupform');
    	var grid = setupForm.down('#staticDocumentAttachmentGrid');
    	var templateCodeField = setupForm.down('#templateCode');
    	var templateCode = templateCodeField.getValue();
    	if(!isNullOrEmpty(templateCode)){
    		fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
    		var file = fileField.fileInputEl.dom.files[0];
    		if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
    			if(!isNullOrEmpty(fileUploadPath)){
    				var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    				if (extension == "gif" || extension == "png" || extension == "bmp"
    					|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
    						|| extension == "doc" || extension == "docx" || extension == "txt"
    							|| extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip") {
    					var entityId = templateCode;
    					var module = 'messaging';
    					var entityType = 'template';
    					var documentType = 'DOCUMENT';
    					var isTransient = true;
    					var this$ = this;
    					this$.saveStaticDocumentForm(entityId, module, entityType, documentType, function(success, action, isTransient){
    						if(success){
    							var path = Ext.JSON.decode(action.response.responseText).path;
    							var user = this$.getCurrentlyLoggedInUser();
    							var store = grid.getStore();
    							var documentStatus = "SUBMITTED";
    							var documentType = null;
    							if(!isNullOrEmpty(path)){
    								store.add({
    									id: '',
    									name: fileUploadPath,
    									path: path ,
    									createdBy : {
    										id :user.id,
    										value : user.value,
    										code : user.code
    									},
    									status : documentStatus,
    									documentType : documentType,
    									templateConfigDocId: '',
    									submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

    								});
    								store.totalCount = store.getCount();
    								grid.getView().refresh();
    								this$.loadGridWithFileName(grid,fileUploadPath,store);
    								showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
    							}

    							fileField.reset();
    						}

    					}, isTransient);
    				}else{
    					fileField.reset();
    					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
    				}

    			}
    		}else{
    			fileField.reset();
    			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    		
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('PLEASE_FILL_TEMPLATE_CODE'));
    		fileField.reset();
    		return 0;
    	}
    },
    
    /**
     * Remove entry from grid
     */
    deleteStaticDocument : function(view, rowIndex, colIndex, item, e, record, row){
    	var grid = view.up('#staticDocumentAttachmentGrid');
    	var panel = this.getContentPanel().getActiveTab();
    	var tabTitle = panel.title;
    	var store = grid.getStore();
    	var templateConfigDocId = record.get('templateConfigDocId');
    	var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
    	if(!(tabTitle == viewTitle)){
    		if(!isNullOrEmpty(templateConfigDocId)){
                showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                    	Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.STATIC_DOC_DELETE,
                            method: 'DELETE',
                            params: {
                            	templateConfigDocId : templateConfigDocId
                            },
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(form, action) {
                            	store.remove(record);
                                showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
                            }
                        });
                    }
                });
            
        	}else{
        		store.remove(record);
        		showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
        	}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
    	}
    	
    },
    
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var enableButton = gridReference.down('#enableDisableTemplateBtnId');
    	enableButton.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'ENABLE') {
    			if(!isNullOrEmpty(enableButton)){
    				enableButton.setVisible(true);
    			}        		
    		}
    	});
    },
    
    enableDisableTemplateEvent:function(button){
    	var grid = button.up('grid');
    	var status="";
    	if(grid){    		
    		if(grid.getSelectionModel().getCount() > 0) {    			
    			var record = grid.getSelectionModel().getSelection()[0];
    			if(!isEmpty(record.data)){                	
    				var selectedId=record.get("ID");
    				var selectedStatus=record.get("WHETHER_ENABLED");
    				if (!isNullOrEmpty(selectedId) &&  !isNullOrEmpty(record.get("WHETHER_ENABLED"))){
    					if(selectedStatus == getMessagingModuleTranslation('YES')){
    						selectedStatus=false;                        	
    					}else{
    						selectedStatus=true;
    					}

    					Ext.Ajax.request({
    						type: 'rest',                                     
    						url: SERVERURL.ENABLE_MSG_TEMPLATE, 												 
    						method: 'GET',         
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						params:{
    							id:selectedId,
    							whetherEnabled:selectedStatus
    						},
    						success: function(form, action) {
    							if(form.responseText == "DEFAULT_TEMPLATE_CANNOT_DISABLE"){
    								showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('DEFAULT_TEMPLATE_CANNOT_DISABLE_MSG'));
    							}
    							else{
    								grid.getStore().reload();
        							if(selectedStatus){
        								showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('MESSAGE_TEMPLATE_ENABLED_MSG'));            	
        							}else{
        								showSuccessMessage(getCommonTranslation('SUCCESS'), getMessagingModuleTranslation('MESSAGE_TEMPLATE_DISABLED_MSG'));
        							}
    							}
    						}
    					});
    				}                	

    			}    			 
    		} else {
    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    		}    		
    	}    	
    },
});
