/**
 * 	This controller is used for student and faculty course execution information actions.
 *	@author Sachin.Bangar    
 */
Ext.define('Academia.controller.personinfo.common.PersonCourseExecutionController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    alias: "widget.personcourseexecutioncontroller",
    models : [
		'examinationdegreeremark.DegreeAuditReportModel','employeeTeachingHourModel.EmployeeTeachingHourDetailUpdateModel'
	],

    stores: ['personinfo.common.course.FeePlanStore', 'personinfo.common.course.CourseAttendanceStore', 
             'personinfo.common.course.PerformanceTrackerStore', 'personinfo.common.course.PerformanceComboStore', 
             'common.ProgramByAcAndLoIdStore', 'admission.applications.admissionAndMidTermAdmission.PeriodComboStore', 
             'coursetransaction.sectionmanagement.SectionsStore', 'course.CourseStageStore', 
             'course.coursecomponent.CourseComponentStore', 'coursetransaction.coursereading.TopicType', 
             'common.BatchesByProgramId', 'coursetransaction.sectionmanagement.SectionMultiSelect', 
             'scholarships.AcademyYears', 'systemusage.YearStore', 'personinfo.common.course.FacultyPerformanceGridStore', 
             'personinfo.common.course.ProgramCourseStore', 'personinfo.common.course.ProgramCourseTreeStore', 'scholarships.AcademyYears', 
             'common.ProgramByAcademyLocationStore', 'enquiry.AcademicBatchStore', 'enquiry.ProgramBatchSeatTypeStore', 
             'feeandpayment.FeePlanTypeStore', 'feeandpayment.FeePlan', 'feeandpayment.FeePlanStageType', 
             'feeandpayment.MappingStatus', 'feeandpayment.FeePlanStatus', 'organization.BaseCurrencyStore', 
             'personinfo.common.course.PerformanceTrackerStore', 'common.ProgramStore', 'scholarships.Periods', 
             'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore', 
             'coursetransaction.facultytopicassignment.AlternateFacultyStore', 'program.programbatchdetail.BatchStore', 
             'organization.academylocations.AcademicYearStore', 'personinfo.common.course.FacutlyCourseAttendanceStore', 
             'personinfo.common.course.StudentWiseDetails', 'personinfo.common.course.FacultyWiseDetails',
             'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer','personinfo.common.course.ProgramCourseTopicStr',
             'personinfo.common.course.DevelopmentPlanGridStr','personinfo.common.course.CourseListExceptCurrentEquivalenceStore',
             'course.NoOfCourseVariantAssoGridStore','personinfo.common.course.CourseComponentListExceptIdsStore',
             'examinationcenters.examstaffallocation.ExaminationRoles', 'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter', 
             'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter','examinationcenters.roomallocation.ExaminationDutyGridStore',
             'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter','examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter',
             'examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter', 'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
             'examinationcenters.reports.ExamEligibilitySTPortalAndProfileStore','examinationcenters.evaluationgrouplisting.EvalGroupListingMasterStore',
             'common.AssignedProgramStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','common.AllAccessibleCVByperiodAndCourseId',
             'course.coursevariants.CourseVariantStore','attendance.SectionByCourseNComponent','attendance.AssignedSectionByCourseNComponent',
             'course.AssignedPeriodCoursesFacultyStore','common.ActiveUserStore','attendance.SectionAndFacultyByPeriodID','attendance.SectionAndFacultyByPeriodIDInPC','course.CourseDocument',
             'personinfo.common.course.FacultyAssociatedprogramStore','course.NoOfCourseVariantAssoGridStore', 
             'program.programDetails.programBatches.courseParameter.StudentCourseReportStore','program.programDetails.programBatches.courseParameter.StudentCourseReportByPeriodStore',
             'student.studentprofile.StudentAcademicsHistoryGridStore','student.studentprofile.AcademicsHistoryDetailsStore','common.CurrentBatchStore',
             'student.studentprofile.StudentProgramStore','common.AcademicTermStore','course.coursevariants.ParameterCourseVariantStore','common.AcademicTermStoreForIntakeYearId',
             'attendance.facultyportal.AttendanceCourses','attendance.facultyportal.AttendanceCourseVariantStore','examinationdegreeremark.DegreeAuditReportCoursesStatusChartStore',
             'examinationdegreeremark.DegreeAuditReportCreditStatusChartStore','examinationdegreeremark.DegreeAuditReportCGPAStatusChartStore',
             'examinationdegreeremark.DegreeAuditReportGridStore','student.studentprofile.AcademicsHistoryTranscriptStore','personinfo.common.course.stoStudentMyCourseLearningTargetStore','gradeMaster.LearningTargerGradeStore',
             'program.programDetails.programBatches.courseParameter.FacultyTeachingHourGridStore','hostel.hostelattendance.HostelMarkAttendanceStatus',
             'student.studentprofile.AcademicsHistoryGridForMarkTypeStore','course.AcademicTopicDocumentGridStore', 'course.AcademicTopicDocumenturlGridStore','student.studentprofile.StudentProgramCompletionDetailsStore','common.BatchesByProgramId'],

    views: ['personinfo.common.PersonCommonWindow','personinfo.common.course.ScheduleDetails', 'personinfo.common.course.ScheduleQuickSearchForm', 
            'personinfo.common.course.AttendanceQuickSearchForm', 'personinfo.common.course.AttendanceDetails', 
            'personinfo.common.course.FeePlanGrid', 'feeandpayment.NoOfFeeConfigHeadsWin', 
            'personinfo.common.course.PerformanceTrackerGrid', 'personinfo.common.course.PerformanceTrackerForm', 
            'personinfo.common.course.AttendanceQuickSearchGrid', 'personinfo.common.course.FacultyEvaluationDetails', 
            'personinfo.common.course.FacultyEvaluationQuickSearchForm', 'personinfo.common.course.FacultyPerformanceForm', 
            'personinfo.common.course.FacultyPerformanceGrid', 'personinfo.common.course.FacultyAttendanceDetails', 
            'personinfo.common.course.ProgramAndCourseForm', 'personinfo.common.course.ProgramAndCourseGrid', 'personinfo.common.course.ProgramAndCourseTreeGrid', 
            'personinfo.common.course.ProgramCourseSearchWindow', 'personinfo.common.course.ProgramCourseWindow', 
            'personinfo.common.course.ProgramCourseSearchPanel', 'feeandpayment.ManageFeeSearchForm', 
            'personinfo.common.course.FacultyAttendanceQuickSearchForm', 'personinfo.common.course.StudentWiseDetailData', 
            'personinfo.common.course.FacultyWiseDetailData','personinfo.common.course.MyCourseQuickSearchForm',
            'personinfo.common.course.MyCourseDetails','personinfo.common.course.DevelopmentPlanDetails',
            'personinfo.common.course.DevelopmentPlanGrid','personinfo.common.course.DevelopmentPlanForm',
            'personinfo.common.course.ProgramAndCourseTopicGrid',
            'personinfo.common.course.ProgramAndCourseTopicWin','personinfo.common.course.FacultyCourseInterestDetails',
            'personinfo.common.course.FacultyCourseInterestGrid','personinfo.common.course.FacultyCourseInterestForm',
            'personinfo.common.course.FacultyNoOfVariantGridWindow','personinfo.common.course.FacultyNoOfVariantGrid','personinfo.common.course.ExaminationDutyDetails',
            'personinfo.common.course.FacultyDutyFilter','personinfo.common.course.ExaminationDutyGrid','personinfo.common.course.ExaminationDutySupervisorGrid',
            'personinfo.common.course.ExaminationDutyExaminerGrid','personinfo.common.course.ExaminationDutyPaperSatterGrid',
            'examinationcenters.reports.ExamEligibiltySTPortalAndProfile','examinationcenters.reports.ExamEligibiltySTPortalAndProfileStructure',
            'studentPortal.ViewExaminationStructureForSTPortal','studentPortal.ViewExaminationSTPortalGrid',
            'student.studentprofile.AcademicsTopicsStructureForStudentProfile','student.studentprofile.AcademicsTopicQuickSearchForm',
            'student.studentprofile.AcademicsTopicQuickSearchGrid','student.studentprofile.AcademicTopicDetails','programCourseDashboard.CourseExecutionReportStructure',
            'programCourseDashboard.DelayedCourseSearch','course.CourseDocumentList','personinfo.common.course.FacultyProgramAssociatedWindow',
            'personinfo.common.course.FacultyProgramAssociatedDetailsGrid','personinfo.common.course.StudentCourseReportGrid',
            'personinfo.common.course.StudentCourseReportByPeriodGrid','personinfo.common.course.MyCourseDetailsStructure','personinfo.common.course.MyCourseDetailsAll','personinfo.common.course.MyCourseDetailsPass',
            'personinfo.common.course.MyCourseDetailsFail','personinfo.common.course.StudentCourseReportByPeriodGrid','student.studentprofile.StudentAcademicsHistoryStructure','student.studentprofile.StudentAcademicsHistoryGrid',
            'student.studentprofile.StudentAcademicHistoryWin','personinfo.common.course.ProgramCourseFacultySearchPanel',
            'personinfo.common.course.ProgramCourseFacultySearchWindow',
            'examinationdegreeremark.DegreeAuditReportProfileView',
    		'examinationdegreeremark.DegreeAuditReportGrid',
    		'reports.common.DegreeAuditReportGroupedBarChart','personinfo.student.ConsolidatedLearningPlanTemplateWindow',
    		'student.studentprofile.StudentAcademicHistoryPrintTranscriptWin','personinfo.common.course.VWMyCourseDetailsLearningTargets','personinfo.common.course.VWLearningTargetMyCourseGradeTypeGrid','personinfo.common.course.VWLearningTargetMyCourseMarkTypeGrid'
    		,'personinfo.common.course.FacultyTeachingHourdetails','personinfo.common.course.FacultyTeachingHourQuickSearchForm','personinfo.common.course.FacutltyTeachingHourGrid','student.studentprofile.AcademicsHistoryGridForMarkTypeCourse',
    		'student.studentprofile.AcademicTopicDocumentGrid', 'student.studentprofile.AcademicTopicDocumentURLGrid','student.studentprofile.ProgramCompletionDetails','student.studentprofile.StudentProgramCompletionDetailsGrid'],
   
    		 refs: [{
	           ref:'facutltyTeachingHourGrid',
	           selector:'facutltyteachinghourgrid'
     }],
    /**
     *  Load store after grid renderer
     *  @param gridItemId
     *  @param url
     */

    loadGridStore: function(gridItemId, url, params) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

		var personProfile = this$.getContentPanelActiveTab();
		var personObj = this$.getPersonObj();
		grid = personProfile.down(gridItemId);
		personId = personObj["id"];
	
        if (grid) {
    		var store = grid.getStore();
    		store.getProxy().api.read = url;
    		store.getProxy().extraParams = {
    			personId: personId,
    			limit: -1
    		};
    		store.load();
    	}
    },
    /**
     * show person common window
     * @param informationType
     * @param formItemId
     */
    showPersonCommonWindow: function(informationType, formItemId) {
        var this$ = this;
        var title = null,
            xtypeForm = null;
        var formWindow = this$.getPersonCommonWindow();
        if (!formWindow) {
            switch (informationType) {

            case 'PROGRAM_COURSES':
                { //Program Courses
                    title = getPersonModuleTranslation('PROGRAM_COURSES');
                    xtypeForm = 'programandcourseform';
                    break;
                }
            case 'FEE_PLAN_DETAILS':
                { //Program Courses
                    title = getPersonModuleTranslation('FEE_PLAN_DETAILS');
                    xtypeForm = 'feeplanform';
                    break;
                }
            case 'DEVELOPMENT_PLAN':
            { //DEVELOPMENT_PLAN
                title = getPersonModuleTranslation('DEVELOPMENT_PLAN');
                xtypeForm = 'developmentplanform';
                break;
            }
            case 'FACULTY_COURSE_INTEREST':
            { //DEVELOPMENT_PLAN
                title = getPersonModuleTranslation('FACULTY_COURSE_INTEREST');
                xtypeForm = 'facultycourseinterestform';
                break;
            }
            case 'ACADEMICS_TOPIC' : {
	    		title = getPersonModuleTranslation('ACADEMICS_TOPIC');
	    		xtypeForm = 'academictopicdetails';
	    		break;
	    	}
            case 'PROGRAM_COMPLETION_DETAILS' : {
	    		title = getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS');
	    		xtypeForm = 'programcompletiondetails';
	    		break;
	    	}
            default:
                {
                    break;
                }
            }

            formWindow = Ext.widget('personcommonwindow', {
                title: title,
                itemId: 'personCommonWindow',
                items: [{
                    xtype: xtypeForm,
                    itemId: formItemId
                }]
            });
        }

        formWindow.show();
    },
    
    viewAcademicTopicDetailFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
    	this$.editAcadmicTopicFormWindow(informationType, formItemId, gridItemId);
    	var form = this$.getAcademictopicdetails();
    	this$.viewPersonCommonWindow(form,informationType);
    	var docGrid =form.down('academictopicdocumentgrid');
    	//var addBtn = docGrid.down('#btnAdd');
    	var btnDelete = docGrid.down('#btnDelete');
    	btnDelete.disable();
    	var btnEdit = docGrid.down('#btnEdit');
    	btnEdit.disable();
    	//addBtn.disable();
    	setTimeout(function(){
    		var academicTopicItem = form.down('#academicTopicItemId');
        	academicTopicItem.setReadOnly(true);
        	var academicSubTopicItemId = form.down('#academicSubTopicItemId');
        	academicSubTopicItemId.setReadOnly(true);
		   },300);
    
    	var urlGrid =form.down('academictopicdocumenturlgrid');
    	var deleteBtn = urlGrid.down('#btnDelete');
    	deleteBtn.disable();
    	var btnEdit = urlGrid.down('#btnEdit');
    	btnEdit.disable();
    },
    
    deleteAcademicTopicRecord: function(gridItemId, deleteUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl+'?id='+id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('ACADEMIC_TOPIC_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * view person common window
     */
    viewPersonCommonWindow: function(form,informationType) {

        if (form) {
            form.down('#submitButtonId').setVisible(false);
            if(informationType=='ACADEMICS_TOPIC'){
                var academicTopicDocument=form.down('#academicTopicDocument');
                var academicTopicDocumentUrl=form.down('#academicTopicDocumentUrl');
                if(!isNullOrEmpty(academicTopicDocument) && !isNullOrEmpty(academicTopicDocumentUrl)){
                academicTopicDocument.setVisible(false);
                academicTopicDocumentUrl.setVisible(false);
                }
               }
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
            form.isValid();
        }
    },

    /**
     * Close person common window
     */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },
    /**
     * send calendar request for student and faculty
     * @param personType
     * @param calenderItemId
     * @param submitURL
     * 
     */
    sendCalendarEventsRequest: function(personType, calenderItemId, submitURL) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var calendar = personProfile.down(calenderItemId);
        var params = new Object();
        calendar.eventStore.getProxy().actionMethods.read = 'GET';
        if (personType == 'STUDENT') {
        	if(!isNullOrEmpty(personProfile.getUserId)){
        		params.studentId = personProfile.getUserId();
        	}else{
        		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        		params.studentId = studentPortalInfo.student.id;
        	}
        }else if(personType == 'FACULTY'){
        	if(!isNullOrEmpty(personProfile.getUserId)){
        		params.facultyId = personProfile.getUserId();
        	}else{
        		params.facultyId = this.getCurrentlyLoggedInUser().id;
        	}
        }
        calendar.eventStore.removeAll();
        calendar.eventStore.getProxy().url = submitURL;
        calendar.eventStore.getProxy().extraParams = params;
        calendar.eventStore.load();
    },

    /**
     * Student attendance search call
     */
    loadStudentSearchGrid: function(formItemId, gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        grid.show();
        var form = personProfile.down(formItemId);
        var values = form.getValues();
        var store = form.down('#attendanceProgram').getStore();
        var record = store.findRecord('programId', values.programId);
        var admissionId = record.get('admissionId');
        var periodId = values.period;
        var courseId = values.course;
        var programId= values.programId;
        var batchId = values.batch;
        var componentId = values.courseComponent;
        var startDate = values.fromDate;
        var endDate = values.toDate;

        var academyLocationId = this.getCurrentAcademyLocation();
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.GET_ATTENDANCE_TYPE_BY_ACADEMYLOCATION_ID,
			params: {
				academyLocatonId: academyLocationId
			},
			method: 'GET',
			success: function(response, action) {
				var data = Ext.decode(response.responseText);
				if (!isEmpty(data)) {
					var gridColumns = grid.columns;
					var len = gridColumns.length;
					if (data.studentAttendanceType == 'COMPLETE_DAY') {
						grid.columns[0].setVisible(false);
						grid.columns[1].setVisible(false);
						grid.columns[2].setVisible(false);
						grid.columns[3].setVisible(false);
						grid.columns[4].setVisible(false);
						grid.columns[5].setVisible(false);
						grid.columns[6].setVisible(true);
						grid.columns[7].setVisible(true);
						grid.columns[8].setVisible(true);
						grid.columns[9].setVisible(true);
					}else{
						grid.columns[0].setVisible(true);
						grid.columns[1].setVisible(true);
						grid.columns[2].setVisible(true);
						grid.columns[3].setVisible(true);
						grid.columns[4].setVisible(true);
						grid.columns[5].setVisible(false);
						grid.columns[6].setVisible(false);
						grid.columns[7].setVisible(false);
						grid.columns[8].setVisible(false);
						grid.columns[9].setVisible(false);
					}
				}
			}
		});
            

        if (grid) {
            var params = {
                admissionId: admissionId,
                periodId: periodId,
                courseId: courseId,
                componentId: componentId,
                programId:programId,
                batchId:batchId,
                startDate: startDate,
                endDate: endDate
            };
            var gridStore = grid.getStore();
            gridStore.getProxy().extraParams = params;
            gridStore.load();

        }
    },
    /**
     * Faculty attendance search call
     */
    loadFacultySearchGrid: function(formItemId, gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var userId = personProfile.getUserId();
        var form = personProfile.down(formItemId);
        var values = form.getValues();
        //TODO: test all values
        var params = new Object();
        if (values.facultyAttendanceType == 'COURSE_LEVEL') {
            params = {
                facultyId: userId,
                sectionId: values.section,
                courseId: values.course,
                startDate: values.fromDate,
                endDate: values.toDate,
                periodId: values.period,
                programId: values.programId,
                componentId: values.courseComponent,
                batchId: values.batch
            };
        } else {
            params = {
                facultyId: userId,
                startDate: values.fromDate,
                endDate: values.toDate
            };
        }

        if (grid) {
            var store = grid.getStore();
            store.getProxy().extraParams = params;
            store.load();

        }
    },
    
    
    loadFacultyTeachingHoursSearchGrid: function(formItemId, gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
         var  academyLocationIds=  this$.getCurrentAcademyLocation();

        var grid = personProfile.down(gridItemId);
      //  var grid=this.getExtendedtimetablecbsgrid();
        var userId = personProfile.getUserId();
        var form = personProfile.down(formItemId);
        var values = form.getValues();
        var academicTermId=values.ACADEMIC_TERM;
        //TODO: test all values
        var params = new Object();
       params = {
    		   academyLocationIds: academyLocationIds,
    		   academicTermId:academicTermId,
    		   facultyId: userId,
            };
     if (grid) {
          //  var store = grid.getStore();
    	 var store =  grid.getStore().getProxy().extraParams = {
   			academicTerm:academicTermId,
   			 facultyId:userId,
   		 };
    	 grid.getStore().load();
        }
    },

    /**
     * Faculty Program and Courses search call.
     * @author Akshay.Kalbhor
     */
    loadFacultyProgCoursesTreeGrid: function(button) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var userId = personProfile.getUserId();
        var grid = personProfile.down('#facultyProgramCourseTreeGrid');
        var alinfomodel = Academia.model.authentication.ALInfoModel;
	    var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool){
			   grid.columns[3].setVisible(false);
		}
        var form = button.up('form[itemId=facultyProgramCourseSearchPanel]');
        var values = form.getValues();
        var programId = values.programId;
        var batchId = values.batch;
        var periodId = values.period;
        var sectionId = values.section;
        var courseVariantId = values.courseVariant;
        var alternateFacultyId = values.alternateFaculty;
        var academicTermId = values.academicTerm;

        if (grid) {
            var store = grid.getStore();
            var params = {
                facultyId: userId,
                programId: programId,
                batchId: batchId,
                periodId: periodId,
                sectionId: sectionId,
//                academicTermId:academicTermId,
                courseVariantId: courseVariantId,
                alternateFacultyId: alternateFacultyId,
    			academyLocationId : this.getCurrentAcademyLocation()
            };
            store.getProxy().extraParams = params;
            store.load();
        }
    },
    /**
     * Faculty Program and Courses search call.
     * @author Akshay.Kalbhor
     */
    loadFacultyProgCoursesGrid: function(button) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var userId = personProfile.getUserId();
        var grid = personProfile.down('grid[itemId=facultyProgramCourseGrid]');
        var alinfomodel = Academia.model.authentication.ALInfoModel;
	    var wheatherSchool = alinfomodel.get('wheatherSchool');
		if(wheatherSchool){
			   grid.columns[3].setVisible(false);
		}
        var form = button.up('form[itemId=facultyProgramCourseSearchPanel]');
        var values = form.getValues();
        var programId = values.programId;
        var batchId = values.batch;
        var periodId = values.period;
        var sectionId = values.section;
        var courseVariantId = values.courseVariant;
        var alternateFacultyId = values.alternateFaculty;
        var academicTermId = values.academicTerm;

        var url = SERVERURL.PATH_GET_FACULTY_PROGRAM_COURSE_GRID_DATA;

        if (grid) {
            var store = grid.getStore();
            store.getProxy().api.read = url;
            var params = {
                facultyId: userId,
                programId: programId,
                batchId: batchId,
                periodId: periodId,
                sectionId: sectionId,
//                academicTermId:academicTermId,
                courseVariantId: courseVariantId,
                alternateFacultyId: alternateFacultyId,
    			academyLocationId : this.getCurrentAcademyLocation()
            };
            store.getProxy().extraParams = params;
            store.load();
        }
    },
    /**
     * This method is used to clear fields on student & faculty search Form
     * @param button which is reference of button
     */
    clearSearchForm: function(button) {
        var form = button.up('form').getForm();
        form.reset();
    },
    /**
     * View pending fee plan head for students 
     */
    viewFeePlan: function(gridItemId) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection()[0];
            var feeHeadsCovered = records.get('noOfFeeHeads');
            if (feeHeadsCovered > 0) {
                var formWindow = this.getNoOfFeeConfigHeadsWin();
                if (!formWindow) {
                    Ext.widget('nooffeeconfigheadswin');
                    formWindow = this.getNoOfFeeConfigHeadsWin();
                }
                formWindow.show();
                var params = "FEE_PLAN_RULE_ID";
                var paramsData = records.get('feePlanRuleId');
                var RESULT_GRID = this.getNoOfConfigureFeeHeadsId(); // getter of configurefeeheads
                this$.mixins.FeeAndPaymentController.loadDynamicGridForFee(CONSTANTS.CB.FEE_CONFIGURE_HEAD_LIST_VIEWCODE,
                CONSTANTS.CB.FEE_CONFIGURE_HEAD_LIST_CONFIGCODE, RESULT_GRID, params, paramsData);
            }

        } else {
            showWarningMessage(getPersonModuleTranslation('FEE_PLAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * Delete Development Plan history record
     * @param gridItemId
     * @param deleteUrl
     */
    deleteDevelopmentGoal: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('DEVELOPMENT_PLAN'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl+'?id='+id, //SERVERURL.DEVELOPMENT_GOAL_DELETE,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('DEVELOPMENT_PLAN_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('DEVELOPMENT_PLAN'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     * Edit Development Plan form window
     *  @param informationType
     *  @param formItemId
     *  @param gridItemId
     */
    editDevelopmentGoal: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getPersonDevelopmentPlanForm();
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
                
               var isAchievedField = form.down('#isAchievedId');
               /*  if (data.placementProcessRequired) {
					 isAchievedField.items.items[0].setValue(true);
					 isAchievedField.items.items[1].setValue(false);
				 } else if (!data.placementProcessRequired) {
					 isAchievedField.items.items[0].setValue(false);
					 isAchievedField.items.items[1].setValue(true);
				 }*/
                
                var improvementPlanField = form.down('#improvementPlan');
            	var improvementSuggesstionField = form.down('#improvementSuggestions');
            	if(records.data.isAchieved){
            		isAchievedField.items.items[0].setValue(true);
            		isAchievedField.items.items[1].setValue(false);

            		improvementPlanField.setVisible(false);
            		//improvementSuggesstionField.setVisible(false);
            	}else{
            		isAchievedField.items.items[0].setValue(false);
					 isAchievedField.items.items[1].setValue(true);
					 
            		improvementPlanField.setVisible(true);
            		//improvementSuggesstionField.setVisible(true);
            	}	
            }
        } else {
            showWarningMessage(getPersonModuleTranslation('DEVELOPMENT_PLAN'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
	editAcadmicTopicFormWindow: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
        	var filterForm =this$.getAcademictopicdetails();
            var form = this$.getAcademictopicdetails().getForm();
            var records= grid.getSelectionModel().getSelection();
            var documentGrid =filterForm.down('academictopicdocumentgrid');
            var urlGrid =filterForm.down('academictopicdocumenturlgrid');
            filterForm.down('#academicTopicItemId').setReadOnly(true);
            filterForm.down('#academicSubTopicItemId').setReadOnly(true);
            filterForm.down('#programItemId').setReadOnly(true);
            filterForm.down('#batchCombo').setReadOnly(true);
            filterForm.down('#periodId').setReadOnly(true);
             filterForm.down('#academicTermId').setReadOnly(true);
           /*  var rec = new Academia.model.student.studentprofile.AcademicsTopicQuickSearchGridModel(
                    records[0].data);*/
             var serverUrl=SERVERURL.FIND_ACADEMIC_TOPIC_BY_ID;
			 Ext.Ajax.request({
      		 method: "GET",
      		 type: 'rest',
      		 url: serverUrl,
      		 headers: {
      			 'Content-Type': 'application/json'
      		 },
      		 params: {
      			 id: records[0].data.id
      		 },
      		 success: function(f, action) {
      			var data = f.responseText;
      			var  jData=Ext.JSON.decode(data);
      			form.findField('id').setValue(jData.id);
      			var programIdField=form.findField('programId');
      			programIdField.setValue(records[0].data.programId);
      			var academicTopicIdField=form.findField('academicTopicId');
      			academicTopicIdField.setValue(records[0].data.academicTopicId);
      			var batchIdField=form.findField('batch');
      			var termId=form.findField('academicTerm');
      			
      			batchIdField.getStore().getProxy().extraParams={
      				studentId : jData.student.id,
      				
      			};
      			batchIdField.store.load({
     				 callback: function(records, operation, success) {
						   if (success) {
							   for(var i = 0; i< records.length; i++){
								   if(records[i].data.id == jData.batch.id){
									   batchIdField.setValue(jData.batch.id);
									   termId.getStore().getProxy().extraParams = {
										   batchId: jData.batch.id
									   };
									   termId.getStore().load({
										   callback: function() {
											   termId.setValue(jData.academicTerm.id);
										   }
									   });
				                  		batchIdField.setDisabled(false);
										form.isValid();
								   }
							   }
						   }
     				 }
      			});
      			var periodIdField=form.findField('period');
      			 periodIdField.setVisible(true);
				 if(jData.academicTopics.categoryTopic=="PRE_ENROLLED_PERIOD_DOCUMENTS"){
					  periodIdField.setVisible(false);
				 }
      			periodIdField.getStore().getProxy().extraParams={
      				batchId: jData.batch.id,
					studentId: jData.student.id
      			};
      			periodIdField.getStore().load({
      				callback:function(){
      					periodIdField.setValue(jData.period.id);
      					var grid = this$.getAcademicstopicquicksearchgrid();
      					periodIdField.setDisabled(false);
						if(grid.buttonName == 'ADD_VIEW') {
							periodIdField.setReadOnly(false);
						}
						form.isValid();
                  	}
      			});
      			var academicSubTopicIdField=form.findField('academicSubTopicId');
      			var store=academicSubTopicIdField.getStore();
      			store.getProxy().extraParams = {
      				academicTopicId : records[0].data.academicTopicId
				};
      			store.load({
      				callback:function(){
      					academicSubTopicIdField.setValue(jData.academicSubTopics.id);
      					academicSubTopicIdField.setDisabled(false);
						form.isValid();
                  	}
      			});
      			if(jData.isUploadDocument && jData.documents && jData.documents.length){
      				documentGrid.setVisible(true);
      				documentGrid.getStore().getProxy().extraParams= {
      					academicTopicId: records[0].data.id
      				}
      				documentGrid.getStore().load();
      				 var win=	filterForm.up('window');
      				 if(win ==! undefined){
      					win.el.setTop(40) 
      					 win.doLayout();
      				 }
//          			 win.el.setTop(40)
          			
      			}else{
      				documentGrid.setVisible(false)
      			}
      			if(jData.academicTopicUrls && jData.academicTopicUrls && jData.academicTopicUrls.length) {
      				urlGrid.setVisible(true);
      				urlGrid.getStore().getProxy().extraParams= {
      					academicTopicId: records[0].data.id
      				}
      				urlGrid.getStore().load();
      				 var win=	filterForm.up('window');
      				if(win ==! undefined){
      					win.el.setTop(40) 
      					 win.doLayout();
      				 }
//          			 win.el.setTop(40)
//          			 win.doLayout();
      			}else{
      				urlGrid.setVisible(false)
      			}
      			form.findField('description').setValue(jData.description);
      			form.findField('uploadDocument').setValue(jData.isUploadDocument);

      			form.findField('isPublished').setValue(jData.isPublished);
      			//form.findField('updatedDate').setValue(dateRender(jData.updatedAt));
      			form.findField('updatedDate').setValue(new Date());
      			form.findField('createdById').setValue(jData.createdBy.code.toLowerCase() + '/' + jData.createdBy.value);
      			form.findField('createdDate').setValue(jData.studentCreatedAt);
      			form.findField('updatedById').setValue(jData.updatedBy.code.toLowerCase() + '/' + jData.updatedBy.value);
      			 setTimeout(function(){
      				form.findField('date').setValue(dateRender(new Date()));
     			  },500);
      			var statusField=form.findField('status');
      			statusField.getStore().getProxy().extraParams={
      				id:jData.batch.id
      			};
      			statusField.getStore().load({
      				callback:function(){
      					statusField.setValue(jData.status);
						form.isValid();
                  	}
      			});
      			form.isValid();
      			if(jData.whetherCurrentPeriod == true){
      				var academicTopicIdField=form.findField('academicTopicId');
      				academicTopicIdField.setReadOnly(false);
      				var academicSubTopicIdField=form.findField('academicSubTopicId');
      				academicSubTopicIdField.setReadOnly(false);
    			}else{
    				var academicTopicIdField=form.findField('academicTopicId');
      				academicTopicIdField.setReadOnly(true);
      				var academicSubTopicIdField=form.findField('academicSubTopicId');
      				academicSubTopicIdField.setReadOnly(true);
    			}
       		 }
      		 
		 });
        } else {
            showWarningMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    saveStudentAcademicTopics:function(gridItemId, saveUrl, updateUrl){
        var this$ = this;
        var form = this$.getAcademictopicdetails();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

		var submitBtn = form.down("#submitButtonId");
		
		if(submitBtn) 
		{ //typesafe 
				submitBtn.disable();	
		}
        
        var submitUrl, isUpdate = false;
        var id = form.down('#acadmicTopicHiddenId');
        if (isNullOrEmpty(id) || isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.SAVE_ACADEMIC_TOPIC_DATA; //SERVERURL.SAVE_ACADEMIC_TOPIC_DATA,
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.UPDATE_ACADEMIC_TOPIC_DATA; //SERVERURL.UPDATE_ACADEMIC_TOPIC_DATA,
            isUpdate = true;
             id =grid.getSelectionModel().selected.items[0].data.id;
        }
        var personProfile = this$.getContentPanelActiveTab();
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        var values=form.getForm().getValues();
        var studentId = personProfile.getUserId();
		var admissionId = personProfile.getAdmissionId();
		if(!isNullOrEmpty(studentId) && isNullOrEmpty(admissionId)){
			var studentProfileUrl = SERVERURL.PATH_FIND_ADMISSION_ID_BY_STUDENTID;
			Ext.Ajax.request({
				type: 'rest',
				url : studentProfileUrl+"?studentId="+studentId,
				method: 'GET',
				async: false,
				success: function(res, action) {
					admissionId = Ext.decode(res.responseText);
				},
				failure: function(res, action) {
					Ext.getBody().unmask();
				}
			});
		}

        
        var documentGrid = this.getAcademictopicdocumentgrid();
   	    var docStore = documentGrid.getStore();
   	    var isUploadFlag = false;
   	    if(docStore.getCount()) {
   	    	isUploadFlag = true;
   	    }
   	    if(Ext.isObject(id)) {
			   id = id.getValue();
		   }
        data={
			   "id":id,
     		   "academicSubTopics" : this$.getAcademicTopicIdValueJson(values.academicSubTopicId),
     		   "batch" : this$.getAcademicTopicIdValueJson(values.batch),
     		   "period": this$.getAcademicTopicIdValueJson(values.period),
     		   "academicTerm": this$.getAcademicTopicIdValueJson(values.academicTerm),
     		   "admission" : this$.getAcademicTopicIdValueJson(admissionId),
     		   "student" : this$.getAcademicTopicIdValueJson(studentId),
    		   "description": values.description,
    		   "isUploadDocument": isUploadFlag, //values.uploadDocument
    		   "createdBy": {
    			   id: this$.getCurrentlyLoggedInUser().id
    		   },
    		   "updatedBy": {
    			   id: this$.getCurrentlyLoggedInUser().id
    		   },
    		   "updatedAt": values.updatedDate,
    		   "createdAt": values.createdDate,
    		   "status": values.status,
    		   "isPublished": values.isPublished
     	   };
        
            	var docArray = [];
            	if (docStore.data.items != null && docStore.data.items.length > 0 && (documentGrid.isVisible() == true)) {
            		var user = this$.getCurrentlyLoggedInUser();
            		Ext.each(docStore.data.items, function(val) {
            				var newData = {
            						"id" : val.data.id,
	             					"name" : val.data.documentName ? val.data.documentName : val.data.name,
	             					"path" : val.data.path,
	             					"type" : "DOCUMENT",
	             					"createdBy" : this$.getIdValueJson(
	             							user.id,
	             							user.value),
	             				   "isEdit":val.data.isEdit ? val.data.isEdit :false
	             			};
            				/*if(!isNullOrEmpty(values.isEdit)) {
            					newData.isEdit = true;
            		        }*/
            				
            				docArray.push(newData);
            			
            		});
            	}
            	data.documents= docArray;
        
            	var urlGrid = this.getAcademictopicdocumenturlgrid();
            	if(urlGrid) {
            		var urlStore = urlGrid.getStore();
            		var urlArray = [];
                	if (urlStore.data.items != null && urlStore.data.items.length > 0 && (urlGrid.isVisible() == true)) {
                		Ext.each(urlStore.data.items, function(val) {
                				var newData = {
                						"id" : val.data.id,
    	             					"name" : val.data.documentName ? val.data.documentName : val.data.name,
    	             					"path" : val.data.path,
    	             					"type" : "DOCUMENT",
    	             					"createdBy" : this$.getIdValueJson(
    	             							this$.getCurrentlyLoggedInUser().id,
    	             							this$.getCurrentlyLoggedInUser().value)
    	             			};
                				if(!isNullOrEmpty(values.isEdit)) {
                					newData.isEdit = true;
                		        }
                				urlArray.push(newData);
                			
                		});
                	}
                	data.academicTopicUrls = urlArray;
            	}
        
        this$.applyWindowMask(); 
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', data, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success) {
	        	if(response.responseText!=0){
	        		this$.closePersonCommonWindow();
	        		var admissionId = personProfile.getAdmissionId();
	        		if(isNullOrEmpty(admissionId)) {
	        			admissionId = data.admission.id;
	        		}
	        		grid.getStore().getProxy().extraParams={
	        			"admissionId" : admissionId
	        		};
	               // grid.getStore().reload();
	                //grid.getSelectionModel().deselectAll();
	                if (isUpdate) {
	                    showSuccessMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getPersonModuleTranslation('ACADEMIC_TOPIC_UPDATE_SUCCESS'));
	                } else {
	                    showSuccessMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getPersonModuleTranslation('ACADEMIC_TOPIC_ADD_SUCCESS'));
	                }
	    		} else {
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ACADEMIC_TOPIC_RECORD_EXIST'));
	    			setTimeout(function(){
		    			if(submitBtn) 
		    			{ //typesafe 
		    					submitBtn.enable();	
		    			}
		    			},500);
	    		}
        	}
        	else{
    			//this$.closePersonCommonWindow();
                //grid.getStore().reload();
    		}
        	var form = grid.up('form');
        	var values = form.getForm().getValues();
        	grid.getStore().getProxy().extraParams ={
    			acadmicTypeId:values.academicTopicId,
    			academicSubTypeId:values.academicSubTopicId,
    			programId:values.programId,
    			batchId:values.batch,
    			periodId:values.period,
    			studentId:studentId,
				userId: this$.getCurrentlyLoggedInUser().id
    		};
    		grid.getSelectionModel().deselectAll();
    		grid.getStore().load();
        });
    },
    
   /**
    * program completion details code start
    */
    saveProgramCompletionDetails: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var isValid = true;
        var submitUrl, isUpdate = false;
       
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
       var selectedRecords=grid.getSelectionModel().getSelection()[0];
       // grid=this$.getStudentprogramcompletiondetailsgrid();
        var form = this$.getProgramcompletiondetails();
        form.down('#submitButtonId').setDisabled(true);
        var admissionId=form.down('#admissionItemId').getValue();

        var values = form.getValues();
        records=grid.getStore().data.items;
        var id = form.down('#program_Completion_Details_HiddenId');
        if (!isNullOrEmpty(id.getSubmitValue())) {
        	if(selectedRecords.data.admId==admissionId){
        		isValid=true;
        	}
        	else{
        	      for(var i in records){
    			   if(grid.getStore().data.items[i].data.admId!=null){
    				if(grid.getStore().data.items[i].data.admId==admissionId){
    					isValid=false;
    				}
    			}
    		}
        }
        }else{
        	for(var i in records){
    			if(grid.getStore().data.items[i].data.admId!=null){
    				if(grid.getStore().data.items[i].data.admId==admissionId){
    					isValid=false;
    				}
    			}
    		}
        }
        if(isValid){
            var id = form.down('#program_Completion_Details_HiddenId');
            if (!isNullOrEmpty(id.getSubmitValue())) {
            	submitUrl = updateUrl,
                isUpdate = true;
            } else {
            	submitUrl = saveUrl,
                isUpdate = false;       
            }
            var jsonFormatFormData = this$.getJsonProgramCompletionDetails(form,grid,isUpdate);
            this$.applyWindowMask(); 
            this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
                this$.hideWindowMask();
                if(success){
                    this$.closePersonCommonWindow();
                    if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7){
                    	try{
                    		personId = this$.getPersonObj().id;
                    		if(isNullOrEmpty(personId)){
                    			personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                    		}
                    	}
                    	catch(e){
                    		personId = this$.getCurrentlyLoggedInUserWithPersonId().personId;
                    	}
                    	grid.getStore().getProxy().extraParams = {
                    		personId : personId
                    	};
                    }else if(!isNullOrEmpty(personProfile.getPersonInfo())){
	        			grid.getStore().getProxy().extraParams = {
	        				personId : personProfile.getPersonInfo().id
	        			};
	        		}
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll();
                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS_UPDATE_SUCCESS'));
                    } else {
                        showSuccessMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS_ADD_SUCCESS'));
                    }
                }else{
                    this$.hideWindowMask();
                    this$.closePersonCommonWindow();
                    grid.getStore().reload();
                    form.down('#submitButtonId').setDisabled(false);
                }
            });
        }else{
			showWarningMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('ALREADY_ADMISSION'));
			this$.closePersonCommonWindow();
			grid.getStore().reload();
			
		}

    },
    getJsonProgramCompletionDetails: function(form,grid,isUpdate) { 

        var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
            var personId = new Object();
            personId.id = personObj["id"];
            formData.personId = personId;
            delete formData.customData;
            delete formData.admissionIdProgramBatch;
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },

    editProgramCompletionDetails: function(informationType, formItemId, gridItemId) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
        	var form =this$.getProgramcompletiondetails();
            var records = grid.getSelectionModel().getSelection()[0];

      			form.down('#program_Completion_Details_HiddenId').setValue(records.data.id);
      			
            	 form.down('#studentItemId').setValue(records.data.studentId);
             	 form.down('#studentNameItemId').setValue(records.data.studentName);
              	 form.down('#dateOfGraduation').setValue(records.data.studentDateOfGradution);
            	 form.down('#isAlumni').setValue(records.data.isAlumni);
            	 form.down('#awardCertificationItemId').setValue(records.data.awardCertificateId);
              	 form.down('#awardRequestedDate').setValue(records.data.studentAwardRequestedDate);
              	 form.down('#awardGivenDate').setValue(records.data.studentAwardSentGivenDate);
              	 form.down('#periodId').setDisabled(false);
              	 form.down('#periodId').setValue(records.data.periodId);
              	 var admissionIdProgramBatch = form.down('#admissionIdProgramBatch');
             	 var admissionId = form.down('#admissionItemId');
             	 var programId = form.down('#programItemId');
    			 var batch = form.down('#batchCombo');
    			 var period = form.down('#periodId');
    			 form.down('#admissionItemId').hide();
                 form.down('#programItemId').hide();
                 form.down('#batchCombo').hide();
                 form.down('#admissionItemId').allowBlank=true;
                 form.down('#programItemId').allowBlank=true;
                 form.down('#batchCombo').allowBlank=true;
     			 
				 var academyLocationId = this$.getCurrentAcademyLocation();

             	if (!isNullOrEmpty(records.data.admId)) {	
					 admissionIdProgramBatch.getStore().proxy.extraParams = {
                            studentCode:records.data.studentId,
                            academyLocationId:academyLocationId
                    };
					 admissionIdProgramBatch.getStore().load({
						    callback: function(recordData, op, success) {
	        				if (success) {
						            var targetAdmId = records.data.admId;
						            var targetPrgId = records.data.prgId;
						            var targetBthId = records.data.bthId;

						            // Find the matching record in store
						            var match = recordData.find(function(rec) {
						                return rec.data.admissionId == targetAdmId &&
						                       rec.data.programId == targetPrgId &&
						                       rec.data.batchId == targetBthId;
						            });

						            if (match) {
						                admissionIdProgramBatch.setValue(match.get('id'));
						                admissionId.setValue(match.data.admissionId);
	        					}
	        				}
	        			}
	        		});
	          }

			var ProgramIdStore = programId.getStore();
			ProgramIdStore.proxy.extraParams = {
				admissionId: records.data.admId
			};
			ProgramIdStore.load({
				callback: function(record) {
					if (record && record.length == 1) {
						programId.setValue(record[0].data.programId);
					}
				}
			});

			var batchIdStore = batch.getStore();
			batchIdStore.proxy.extraParams = {
				admissionId: records.data.admId
			};
			batchIdStore.load({
				callback: function(record) {
					if (record && record.length == 1) {
						batch.setValue(record[0].data.batchId);
					}


				}
			});


			var periodStore = period.getStore();
			periodStore.proxy.extraParams = {
				admissionId: records.data.admId,
				programId: records.data.prgId,
				batchId: records.data.bthId
			};
			periodStore.load({
				callback: function(periods, operation, success) {
					if (success) {
					for (i in periods) {
						if (periods[i].data.id == records.data.periodId)
							period.setValue(periods[i].data.id);
					}
				  }
				}
			});

          		
	      		var classificationId=form.down('#classificationItemId');
		        if (!isNullOrEmpty(records.data.classId)) {		            	
		      			classificationId.getStore().load({
		        			callback: function(recordss, operation, success) {
		        				setTimeout(function(){
		        				if (success) {
		        					for(i in recordss){
		        						if(recordss[i].data.id == records.data.classId)
		        							classificationId.setValue(recordss[i].data.id);  	
		        					}
		        				}
		        				},300);
		        			}
		        		});
		          }
		        	
	      		var specializationId=form.down('#specializationItemId');   
	            if (!isNullOrEmpty(records.data.specialId)) {		            	
		      			specializationId.getStore().load({ 
		        			callback: function(recordss, operation, success) {
		        				setTimeout(function(){
		        				if (success) {
		        					for(i in recordss){
		        						if(recordss[i].data.id == records.data.specialId)
		        							specializationId.setValue(recordss[i].data.id);  	
		        					}
		        				}
		        				},300);
		        			}
		        		});
	                 }
	          
	        var awardType = form.down('#awardTypeItemId');   	 
           	if (!isNullOrEmpty(records.data.awardId)) {		            	
           		awardType.getStore().load({ 
	        			callback: function(recordss, operation, success) {
	        				setTimeout(function(){
	        				if (success) {
	        					for(i in recordss){
	        						if(recordss[i].data.id == records.data.awardId)
	        							awardType.setValue(recordss[i].data.id);  	
	        					}
	        				}
	        				},300);
	        			}
	        		});
	          }
           	
           	var awardDeliveryMethod = form.down('#awardDeliveryMethodItemId');
         	if (!isNullOrEmpty(records.data.awarddeliveryId)) {		            	
         		awardDeliveryMethod.getStore().load({ 
        			callback: function(recordss, operation, success) {
        				if (success) {
        					for(i in recordss){
        						if(recordss[i].data.id == records.data.awarddeliveryId)
        							awardDeliveryMethod.setValue(recordss[i].data.id);  	
        					}
        				}
        			}
        		});
          }
         	
       	var awardNominatedPerson = form.down('#awardNominatedPersonItemId');
       	var awardTrackingNumber = form.down('#awardTrackingNumberItemId');
	     setTimeout(function(){
         	 if(records.data.awardDeliveryMethod=='Nominated Person'){
       	    	awardNominatedPerson.setVisible(true);
       	    	awardNominatedPerson.setValue(records.data.awardNominatedPerson);
       	    	awardTrackingNumber.setVisible(false);
       	    	awardTrackingNumber.reset();
       	    }else if(records.data.awardDeliveryMethod=='Registered Mail'){
       	    	awardTrackingNumber.setVisible(true);
       	    	awardTrackingNumber.setValue(records.data.awardTrackingNumber);
       	    	awardNominatedPerson.setVisible(false);
       	    	awardNominatedPerson.reset();
       	    }else{
       	    	awardTrackingNumber.setVisible(false);
       	    	awardNominatedPerson.setVisible(false);
       	    }
  		},300);

        } else {
            showWarningMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    viewProgramCompletionDetailsFormWindow: function(informationType, formItemId, gridItemId) {
    	var this$ = this;
    	this$.editProgramCompletionDetails(informationType, formItemId, gridItemId);
    	var form = this$.getProgramcompletiondetails();
    	this$.viewPersonCommonWindow(form,informationType);
    	},
    
    deleteProgramCompletionDetails:function(gridItemId, deleteUrl) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('PROGRAM_COMPLETION_DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        var flag=false;
                        var ids=[];
                        for (var count = 0; count < records.length; count++) {
                            var id = [];
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                ids.push(records[count].get("id"));
                            }
                        }
                        Ext.Ajax.request({
                      	  type: 'rest',
                      	  url: deleteUrl+'?ids='+ids,
                      	  async:false,
                      	  method: 'DELETE',
                      	  headers: {
                      		  'Content-Type': 'application/json'
                      	  },
/*                      	  params: {
                      		  ids: ids
                      	  },*/
                      	  success: function(form, action) {
                      		  grid.getSelectionModel().deselectAll();
                      		  grid.getStore().reload();
                      		  showSuccessMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('PROGRAM_COMPLETION_DETAILS_DELETE_SUCCESS')); 
                      	  }
                        });
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * Development goal save   
     */
    saveDevelopmentGoal:function(gridItemId, saveUrl, updateUrl){
        var this$ = this;
        var form = this$.getPersonDevelopmentPlanForm();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        
        var submitUrl, isUpdate = false;
        var id = form.down('#developmentplan_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl; //SERVERURL.DEVELOPMENT_GOAL_CREATE,
            isUpdate = false;
        } else {
            submitUrl = updateUrl; //SERVERURL.DEVELOPMENT_GOAL_UPDATE,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        
        this$.applyWindowMask(); 
        
        this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatFormData, function(option, success, response) {
        	this$.hideWindowMask();
        	if(success){
        		this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('DEVELOPMENT_PLAN'), getPersonModuleTranslation('DEVELOPMENT_PLAN_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('DEVELOPMENT_PLAN'), getPersonModuleTranslation('DEVELOPMENT_PLAN_ADD_SUCCESS'));
                }
    		}else{
    			this$.closePersonCommonWindow();
                grid.getStore().reload();
    		}
        });
    },
    
    onChangeAchieved:function(obj,rec){
    	var form = obj.up('form');
    	var improvementPlanField = form.down('#improvementPlan');
    	var improvementSuggesstionField = form.down('#improvementSuggestions');
    	
    	if(rec.isAchieved){
    		improvementPlanField.reset();
    		//improvementSuggesstionField.reset();
    		
    		improvementPlanField.setVisible(false);
    		///improvementSuggesstionField.setVisible(false);
    	}else{
    		improvementPlanField.setVisible(true);
    		//improvementSuggesstionField.setVisible(true);
    	}	
    },
    getJsonSubmitData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        if (!isEmpty(formData)) {
        	var personObj = this$.getPersonObj();
            formData.person = personObj;

        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    saveEmployeeTeachingHours: function() {  
    	var $this = this;
    	var personProfile = $this.getContentPanelActiveTab();
    	var grid = personProfile.down("#facutltyTeachingHourGrid");
    	var models =grid.getStore().getModifiedRecords();
    	var myJson = new Array();
    	var employeeTeachingHourModel =[];
    	for (var i in models) {
    		if (models[i].dirty == true) {
    			if((!isNullOrEmpty(models[i].get('teachingHour')))){
    				employeeTeachingHourModel ={
    						"id" : models[i].get('id'),
    						"teachinghour" : models[i].get('teachingHour')
    				}

    			}
    		}
    		myJson.push(employeeTeachingHourModel);
    	}
    	
    	if (myJson.length > 0) {
    		var formData = Ext.encode(myJson);
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.FIND_EMPLOYEE_TEACHING_HOURS_UPDATE,
    			jsonData: formData,
    			method: 'POST',
    			success: function(frm, action) {
    				var data = frm.responseText;
    				if(data == 'DATA_UPDATE') {
    					showSuccessMessage(getPersonModuleTranslation('TEACHING_HOURS'), getCommonTranslation('TEACHING_HOUSR_SAVED_SUCCESSFULLY'));
    				} else {
    					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('PLEASE_ENTER_TEACHING_HOUSR'));
    					grid.getStore().load();
    				}

    				Ext.getBody().unmask();
    				grid.getStore().load();
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_ENTER_TEACHING_HOUSR'));
    	}
    },
    getIdValueJson : function(id, value) {
      	if (id)
      		return {
      		id : id,
      		value : value
      	};
      },
});