/**
 * This controller is used for the student, faculty Service & community functionality.
 * Add/Edit/delete/view
 * @author Sachin.Bangar
 */

var applyHostelFlag = true;
var applyForWaitingList = true;
Ext.define('Academia.controller.personinfo.common.PersonServiceController', {
	
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    models: ['personinfo.common.services.ServiceOptModel', 'personinfo.common.services.CommunityOptModel'],

    stores: ['personinfo.common.services.ServiceNameStore', 
             'personinfo.common.services.ServiceOptStore', 'personinfo.common.services.CommunityNameStore', 
             'personinfo.common.services.CommunityHistoryStore', 'personinfo.common.services.CommunityOptStore',
             'personinfo.common.services.FeePlanStore','feeandpayment.managebill.BillSequence','feeandpayment.managebill.FeePlanStage','servicerequest.HostelApplicationDetailsViewStore','hostel.hostelapplication.HostelChoicesStore','hostel.hostelapplication.HostelApplicationWaitingList'],

    views: [ 'personinfo.common.PersonCommonWindow', 'personinfo.common.services.ServiceOptForm', 'personinfo.common.services.ServiceOptGrid', 
             'personinfo.common.services.CommunityOptForm', 'personinfo.common.services.CommunityOptGrid','common.NestedJsonCombo','personinfo.common.services.HostelApplicationDetailsView','personinfo.common.services.HostelApplicationDetailsViewStructure','personinfo.common.services.ApplyForHostelForm',
             'personinfo.common.services.ApplyForWaitingListForm'
            ],

    alias: "widget.personservicecontroller",
    refs: [{
    	ref:"hostelApplicationDetailsView",
    	selector:"hostelApplicationDetailsView"
    }, {
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    },{
    	ref:'applyforhostelform',
    	selector:'applyforhostelform'
    },{
    	ref:'applyforwaitinglistform',
    	selector:'applyforwaitinglistform'
    }],
    config: {
    	HOSTEL_PERSONAL_REQUIREMENTS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_PERSONAL_REQUIREMENTS')
    },
    init: function(application) {
        this.control({
        	        	
        	'hostelApplicationDetailsView':{
        		render:function(grid){
        			var me = this;
        			var portalId = this.getCurrentLoggedPortalId();
        			var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        			var studentId=studentPortalInfo.student.id;
        			if (portalId == 3){
        	                        me.doAccessControlValidation(grid, me.getHOSTEL_PERSONAL_REQUIREMENTS());
        	                    }else{
        	                          me.doAccessControlValidation(grid, me.getHOSTEL_PERSONAL_REQUIREMENTS());
        	                    }
//        			 var store = grid.getStore();
//        			 store.getProxy().extraParams = {
//        				 studentId: studentId
//        	            };
//        	            store.load();
        			 
        		},
        		
            	afterrender:function(cmp){
            		var me = this;
            		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
            		var form = cmp;
            		var portalId = this.getCurrentLoggedPortalId();
            		var studentId=studentPortalInfo.student.id;
            		
            	     Ext.Ajax.request({
            	        	method: "GET",
            	        	type: 'rest',
            	        	url: SERVERURL.PATH_FIND_WAITING_LIST_SETUP_FOR_STUDENT,
            	        	params: {
            	        		studentId:studentId
            	        	},
            	        	success : function(response) {
            	        		var data = Ext.decode(response.responseText);
////            	        		showSuccessMessage(getCommonTranslation('REJECT_HOSTEL_APPLICATION'),getCommonTranslation('HOSTEL_APPLICATION_HAS_BEEN_REJECTED_SUCCESSFULLY'));
////            	        		grid.getStore().reload();
////            	        		obj.up('window').close();
//            	        		
                      	       var applyForHostel = form.down("#applyForHostel");
                      	       var applyWaitingList = form.down("#applyWaitingList");
                      		   
                      	       if(data == true){
                      	    	   applyWaitingList.setDisabled(false);
                      	       }
                      	       else{
                      	    	   applyWaitingList.setDisabled(true);
                      	       }
            	        	}
            	        	
            	        });	
            	     Ext.Ajax.request({
         	        	method: "GET",
         	        	type: 'rest',
         	        	url: SERVERURL.PATH_FIND_GENERAL_APPLICATION_SETUP_FOR_STUDENT,
         	        	params: {
         	        		studentId:studentId
         	        	},
         	        	success : function(response) {
         	        		var data = Ext.decode(response.responseText);
////         	        		showSuccessMessage(getCommonTranslation('REJECT_HOSTEL_APPLICATION'),getCommonTranslation('HOSTEL_APPLICATION_HAS_BEEN_REJECTED_SUCCESSFULLY'));
////         	        		grid.getStore().reload();
////         	        		obj.up('window').close();
//         	        		
                   	       var applyForHostel = form.down("#applyForHostel");
                   	       var applyWaitingList = form.down("#applyWaitingList");
                   		   
                   	       if(data == true){
                   	    	   applyForHostel.setDisabled(false);
                   	       }
                   	       else{
                   	    	   applyForHostel.setDisabled(true);
                   	       }
         	        	}
         	        });	
            	     

            	      
            		cmp.getStore().getProxy().extraParams = {
            			studentId : this.getContentPanelActiveTab().getUserId(),
					};
            		cmp.getStore().load();
            		setTimeout(function(){
            			if (portalId == 3){
            	                         me.addDataGridConfigButton(cmp, me.getHOSTEL_PERSONAL_REQUIREMENTS());
            	                    }else{
            	                         me.addDataGridConfigButton(cmp, me.getHOSTEL_PERSONAL_REQUIREMENTS());
            	                    }
            		},1000);
            	},
            	selectionchange: function(grid, selected) {
            		                            var revokeButton = grid.view.up().down('#revokeApplication');
            		                            
            		                              if(selected[0].data.applicationStatus == "SUBMITTED" || selected[0].data.applicationStatus == "ALLOCATED"){
            		                            	  revokeButton.setDisabled(false);
            		                              }
            		                              else{
            		                            	  revokeButton.setDisabled(true);
            		                              }
            		                        }
   
            },
            
            'applyforwaitinglistform[itemId=studentApplyForHostelForm]':{
            	afterrender:function(cmp){
            		var form = cmp;
            		var hostelChoice = form.down("#hostelChoicesIDItem");
            		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
            		var studentId=studentPortalInfo.student.id;
            		var  hostelChoicesStoreWaiting = hostelChoice.getStore();
            		hostelChoicesStoreWaiting.removeAll()
;            		 
            		 hostelChoicesStoreWaiting.proxy.extraParams = {
        				                studentId:studentId
        					                        };
            		 hostelChoicesStoreWaiting.load();
            	}
            },
            
            'hostelApplicationDetailsView button[itemId="applyForHostel"]':{
            	click: function(){
            		var formWindow = this.getPersonCommonWindow();
//            		this.showPersonCommonWindow(formWindow, 'studentApplyForHostelForm', 'APPLY_FOR_HOSTEL',true);
            		this.showPersonCommonWindow('APPLY_FOR_HOSTEL', 'studentApplyForHostelForm');
            	}
            },
            
            'hostelApplicationDetailsView button[itemId="applyWaitingList"]':{
            	click: function(){
            		Ext.resumeLayouts();
            		var formWindow = this.getPersonCommonWindow();
//          		this.showPersonCommonWindow(formWindow, 'studentApplyForHostelForm', 'APPLY_FOR_HOSTEL',true);
            		this.showPersonCommonWindow('APPLY_FOR_WAITING_LIST', 'studentApplyForHostelForm');            		 
                    
            	}
            	
            },
            
         	'applyforwaitinglistform[itemId=studentApplyForHostelForm] customcombobox[itemId=hostelChoicesIDItem]':{
            	select: function(btn,combo){
            		var form =  btn.up('applyforwaitinglistform');
            		var hostelChoice = form.down("#hostelChoicesIDItem");
            		var checkBox = form.down("#reallocationHostelId");
            		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
            		var studentId=studentPortalInfo.student.id;
            		var  hostelChoicesStoreWaiting = hostelChoice.getStore();
            		 
            		 hostelChoicesStoreWaiting.proxy.extraParams = {
             				                studentId:studentId
             					                        };
                 		 hostelChoicesStoreWaiting.load();
                 		 
               		 
                 		var recordsSelected = combo[0].raw.hostelLevel;
                 		
                 		if(recordsSelected == "Senior"){
                 			checkBox.setDisabled(false)
                 		}
                 		else{
                 			checkBox.setDisabled(true)
                 		}
                 		
                 		
                 	
            	}
            },
            
            
            'hostelApplicationDetailsView button[itemId="revokeApplication"]':{
            	click: function(){
            		this.revokeButtonCall("hostelApplicationDetailsView",SERVERURL.PATH_REVOKE_APPLICATION)
            	}
            },
            
            'applyforhostelform button[itemId="submitButtonId"]':{
            	click:function(btn){
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId!=1){
            			if(applyHostelFlag){
            				applyHostelFlag = false
            				var this$ = this;
            				var form =  btn.up('applyforhostelform');
            				var academyLocationId = this$.getCurrentAcademyLocation();
            				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
            				var studentId=studentPortalInfo.student.id;
            				var jsonFormFieldData = form.getValues();
            				var grid = this.getContentPanel().getActiveTab().down('hostelApplicationDetailsView')

            				var jsonData = {
            					"student":{
            						"id":studentId
            					},
            					"academyLocation":{
            						"id":academyLocationId
            					},
            					"isReallocateSameHostel":jsonFormFieldData.reallocationHostelId,
            					"resource":{
            						"id":jsonFormFieldData.hostelChoices
            					},
            					"hostelApplicationType":'HOSTEL_GENERAL_SETUP'

            				}

            				Ext.Ajax.request({
            					method: "POST",
            					type: 'rest',
            					url: SERVERURL.PATH_SAVE_FOR_HOSTEL_APPLICATION,
            					jsonData: Ext.encode(jsonData),
            					success : function(response) {
            						var data = Ext.decode(response.responseText);
            						applyHostelFlag = true;
            						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('HOSTEL_GENERAL_APPLICATION_SUBMITTED_SUCCESSFULLY'));            						
            						this$.getPersonCommonWindow().close();
            						grid.getStore().load();


            					},
            					  failure: function(result, request) {
            						applyHostelFlag = true;
            						                       this$.getPersonCommonWindow().close();
            						                    }
            				});	

            			}
            		}
                	}
           
            },
            'applyforhostelform checkboxfield[itemId="termsAndConditionId"]':{
            	change:function(obj, newValue, oldValue, eOpts){
        		  var formWin = obj.up('applyforhostelform');
        		  var saveBtn=formWin.down('#submitButtonId');
        		  var hostelChoices=formWin.down('#hostelChoicesID');
        		  var termsAndCondition=formWin.down('#termsAndConditionId');
        		  if(termsAndCondition.getValue()==true && hostelChoices.isValid()){
        			  saveBtn.setDisabled(false);
        		  }else{
        			  saveBtn.setDisabled(true);
        		  }
        	  },
        	},
        	 'applyforhostelform displayfield[itemId="termsAndConditionsLinkItemId"]':{
        		 render: function(component) {
        			 var $this=this;
        			 component.getEl().on('click', function(e) {
        				 var portalId = $this.getCurrentLoggedPortalId();
        				 if(portalId!=1){
        					 if(e.target.tagName=='A'){
        						 var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
        						 var studentId=studentPortalInfo.student.id;
        						 Ext.Ajax.request({
        							 method : "GET",
        							 type : 'rest',
        							 url: SERVERURL.FIND_DOCUMENT_PATH_GENERAL_SETUP,
        							 params: {
        								 studentId : studentId,
        							 },
        							 headers : {
        								 'Content-Type' : 'application/json'
        							 },
        							 success: function(response) {
        								 var data = response.responseText;
        								 if(!isNullOrEmpty(data)){
        					    				var path = data;
        					    	       		var csvForm = Ext.create('Ext.form.Panel'); 
        					    				if (!isNullOrEmpty(path)) {
        					    					csvForm.getForm().submit({
        												   target: '_blank',
        												   method:'POST',
        												   params :{
        													   access_token : Ext.Ajax.defaultHeaders.access_token,
        													   path: path
        												   },
        												   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        												   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
        												   standardSubmit :true
        											   });
        										}
        								 }else{
        									 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_MAPPED')); 
        								 }
        							 }
        						 });
        					 }
        				 }
        			 });
        		 }
              },
        	'applyforhostelform customcombobox[itemId=hostelChoicesID]':{
            	select: function(btn,combo){
            		var form =  btn.up('applyforhostelform');
            		var hostelChoice = form.down("#hostelChoicesID");
            		var checkBox = form.down("#reallocationHostelId");
            		
            		var submitButtonId = form.down("#submitButtonId");
            		var termsAndCondition = form.down("#termsAndConditionId");
            		if(termsAndCondition.getValue()==true && hostelChoice.isValid()){
             			submitButtonId.setDisabled(false);
             		}else{
             			submitButtonId.setDisabled(true);
             		}
                 		
                 		
                 	
            	}
            },
            
            'applyforwaitinglistform[itemId=studentApplyForHostelForm] button[itemId="submitButtonId"]':{
            	click:function(btn){
            		     if(applyForWaitingList){
            		    	 applyForWaitingList = false
            		    	 var this$ = this;
                    		 var form =  btn.up('applyforwaitinglistform');
                    		 var academyLocationId = this$.getCurrentAcademyLocation();
                    		 var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
                    		 var studentId=studentPortalInfo.student.id;
                    		 var hostelId = form.down("#hostelChoicesIDItem");
                    		 var reallocationId = form.down("#reallocationHostelId");
                    		 var grid = this.getContentPanel().getActiveTab().down('hostelApplicationDetailsView')
                    		 
                    		 var jsonData = {
                    				"student":{
                    					"id":studentId
                    				},
                    				"academyLocation":{
                    					"id":academyLocationId
                    				},
                    				"isReallocateSameHostel":reallocationId.checked,
                    				"resource":{
                    					"id":hostelId.lastValue
                    				},
                    				"hostelApplicationType":'WAITING_LIST_SETUP'
                    		}
                    		
                    		
                    	     Ext.Ajax.request({
                 	        	method: "POST",
                 	        	type: 'rest',
                 	        	url: SERVERURL.PATH_SAVE_FOR_HOSTEL_APPLICATION,
                 	        	jsonData: Ext.encode(jsonData),
                 	        	success : function(response) {
                 	        		var data = Ext.decode(response.responseText);
                 	        		applyForWaitingList = true
                 	        		this$.getPersonCommonWindow().close();
                 	        		grid.getStore().load();
                 	        		showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('HOSTEL_APPLIED_SUCCESSFULLY'));
                 	        	},
                 	        	 failure: function(result, request) {
                 	        		applyForWaitingList = true
                        	    	                        this$.getPersonCommonWindow().close();
                        	    	                     }
                 	        });	
            		     }
            		
            		
            	}
            },

            'applyforhostelform':{
        		afterrender:function(obj,rec){
        			var portalId = this.getCurrentLoggedPortalId();
        			if(portalId !=1){
        				var hostelChoices =obj.down('#hostelChoicesID');
        				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        				var studentId=studentPortalInfo.student.id;
        				var reallocationHostelId=obj.down('#reallocationHostelId');
        				var   hostelChoicesStore = hostelChoices.getStore();
        				hostelChoicesStore.proxy.extraParams = {
        						                studentId:studentId
        						                        };
        				hostelChoicesStore.load({
           					callback: function(records, operation, success) {
           						if(records.length==1 &&  records[0].data.displayOtherLanguage=="CHECKED_IN"){
           							reallocationHostelId.setVisible(false);
           						}
           					} 
           				});
        			}

        		},
        		render:function(obj,rec){
        			var $this=this;
        			var portalId = $this.getCurrentLoggedPortalId();
        			if(portalId !=1){
        				var reallocationHostelId=obj.down('#reallocationHostelId');
        				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        				var studentId=studentPortalInfo.student.id;
        				Ext.Ajax.request({
        					method : "GET",
        					type : 'rest',
        					scope:$this,
        					url: SERVERURL.PATH_FIND_CHECKED_IN_STATUS_BY_STUDENT_ID,
        					params: {
        						studentId : studentId,
        					},
        					headers : {
        						'Content-Type' : 'application/json'
        					},
        					success: function(response) {
        						var data = Ext.decode(response.responseText);
        						if(!isNullOrEmpty(data.id)){
        							reallocationHostelId.setVisible(true);
        						}else{
        							reallocationHostelId.setVisible(false);
        						}

        					}
        				});
        			}
        			
        		}

        	},
        	
       
        	
            
            
        	'applyforhostelform[itemId=studentApplyForHostelForm] button#applyforhostelCancelButtonId' : {
        		                    click: this.closePersonCommonWindow
        		            },
        		 
        		 'applyforwaitinglistform[itemId=studentApplyForHostelForm] button#applyforhostelCancelButtonId' : {
             		                    click: this.closePersonCommonWindow
             		            },

        });
        this.callParent(arguments); 
    },

    /*
     *  Load store after grid renderer
     */
  
    loadGridStore: function(gridItemId, url) {
        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var personObj = this$.getPersonObj();
        var grid = personProfile.down(gridItemId);
        if (grid) {
            var personId = personObj["id"];
            var store = grid.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = {
                personId: personId
            };
            store.load();
        }
    },
    
    changeServiceGridFieldStructure : function(grid){
    	grid.setTitle(getPersonModuleTranslation('SERVICES_HISTORY'));
        grid.down('#btnAdd').hide();
        grid.down('#btnEdit').hide();
        grid.down('#btnDelete').hide();
    },
    
    /*
     * Show Person Common window  with different form
     *  
     */
    showPersonCommonWindow : function(informationType, formItemId, showImmediately,isFormShow){
    	var this$ = this;
    	var title = null, xtypeForm = null;
    	var formWindow = this$.getPersonCommonWindow();
    	if(!formWindow){
    		switch(informationType){
        	
	    		case 'COMMUNITIES' : { //COMMUNITIES
		    		title = getPersonModuleTranslation('COMMUNITY_DETAILS');
		    		xtypeForm = 'communityoptform';
		    		break;
		    		
		    	}
    			case 'SERVICES_OPT_IN_OUT' : { //Services Opt/In Out
		    		title = getPersonModuleTranslation('SERVICE_DETAILS');
		    		xtypeForm = 'serviceoptform';
		    		break;
		    	}
    			case 'APPLY_FOR_HOSTEL' :{
    				title = getHostelTranslation('APPLY_FOR_HOSTEL');
		    		xtypeForm = 'applyforhostelform';
		    		break;
    			}
    			case 'APPLY_FOR_WAITING_LIST':{
    				title = getHostelTranslation('APPLY_FOR_WAITING_LIST');
		    		xtypeForm = 'applyforwaitinglistform';
		    		break;
    			}
		    	default :{
		    		break;
		    	}	    	
    		}
    		
    		formWindow = Ext.widget('personcommonwindow',{
        		title: title,
        		itemId : 'personCommonWindow',
        		items: [{
        			 xtype: xtypeForm,
        		     itemId: formItemId
        		}]
        	});
            formWindow = this$.getPersonCommonWindow();
    	}
    	if((showImmediately != 'no' || showImmediately == null || showImmediately == undefined) && !isFormShow){
    		formWindow.show();
    	}
    },
    
    /*
     * close Person Common window
     *  
     */
    closePersonCommonWindow: function() {
        var this$ = this;
        this$.getPersonCommonWindow().close();
    },
    /**
     * Get fee plan for selected service
     * @param combo
     * @param url
     */
    getFeePlanForSelectedService: function(combo, url,userId,userType){
    	var this$ = this;
        var form = this$.getServiceOptForm();
        var serviceId = combo.getValue();
        if(!isNullOrEmpty(serviceId)){
        	var feePlanComboField = form.down('#feePlanComboField');
        	feePlanComboField.reset();
        	var feePlanStore = feePlanComboField.getStore();
        	var academyLocationId = this$.getCurrentAcademyLocation();
            feePlanStore.getProxy().api.read = url;
            feePlanStore.getProxy().extraParams = {
            	serviceId: serviceId,
            	id:userId,
            	billedUserType:userType,
            	academyLocationId:academyLocationId
            };
            feePlanStore.load();
        }
        
    },
    /**
     * Load Fee plan Rule on the bases of Fee plan 
     */
    loadFeePlanRuleByFeePlan:function(combo,url){
    	var this$ = this;
        var form = this$.getServiceOptForm();
        form.down('#feePlanRuleComboField').setDisabled(false);
        var feePlanId = combo.getValue();
        if(!isNullOrEmpty(feePlanId)){
        	var feePlanRuleComboField = form.down('#feePlanRuleComboField');
        	feePlanRuleComboField.reset();
        	var feePlanRuleStore = feePlanRuleComboField.getStore();
        	feePlanRuleStore.getProxy().api.read = url;
        	feePlanRuleStore.getProxy().extraParams = {
        		feePlanId: feePlanId
            };
        	feePlanRuleStore.load();
        } 
    },
    /**
     * Load Fee plan Rule Stage on the bases of Fee plan Rule 
     */
    loadFeePlanRuleStageByFeePlanRule:function(combo,url){
    	var this$ = this;
        var form = this$.getServiceOptForm();
        form.down('#feePlanRuleStageComboField').setDisabled(false);
        var feePlanRuleId = combo.getValue();
        if(!isNullOrEmpty(feePlanRuleId)){
        	var feePlanRuleStageComboField = form.down('#feePlanRuleStageComboField');
        	var amountPaidComboField = form.down('#amountPaidComboField');
        	feePlanRuleStageComboField.reset();
        	amountPaidComboField.reset();
        	var feePlanRuleStageStore = feePlanRuleStageComboField.getStore();
         	feePlanRuleStageStore.getProxy().api.read = url;
         	feePlanRuleStageStore.getProxy().extraParams = {
         		feePlanRuleId: feePlanRuleId
             };
         	feePlanRuleStageStore.load();
        } 
    },
    /**
     * Load Amount to be paid on the bases of Fee plan rule stage 
     */
    loadAmountToBePaidByFeePlanRuleStage:function(combo,url){
    	var this$ = this;
	    var form = this$.getServiceOptForm();
	    var feePlanRuleStageId = combo.getValue();
	    if(!isNullOrEmpty(feePlanRuleStageId)){
	    	var amountPaidComboField = form.down('#amountPaidComboField');
	    	amountPaidComboField.reset();
	    	 var serverUrl=SERVERURL.BILL_FEE_STAGE_CONFID;
	    	 var serverUrl=SERVERURL.BILL_FEE_STAGE_CONFID_FOR_SERVICE_OPT_SCREEN;
			 Ext.Ajax.request({
    		 method: "GET",
    		 type: 'rest',
    		 url: serverUrl,
    		 headers: {
    			 'Content-Type': 'application/json'
    		 },
    		 params: {
        		feePlanRuleStageId: feePlanRuleStageId,
        		aiseBillCategory:"BILL_RECEIVABLE",
        		raiseBillType:"P_AND_C_FEE"
    		 },
    		 success: function(f, action) {
    			var data = f.responseText;
    			var  jData=Ext.JSON.decode(data);
    		      amountPaidComboField.setValue(jData[0].sumofFeeStageHeadAmount);
    		    }
			 });
	    }
    },
    
    loadServiceOptNameOnProgramBatchSeatType: function(combo,personType){
    	var this$ = this;
    	var progBatchSeatTypeId=null;
        var personProfile = this$.getContentPanelActiveTab();
        if(personType=='FACULTY'){
        	progBatchSeatTypeId = null;
        }else{
        	progBatchSeatTypeId = personProfile.getProgramBatchSeatTypeConfigId();
        	if(progBatchSeatTypeId == 0) {
        		progBatchSeatTypeId = null;
        	}
        }
        if(progBatchSeatTypeId == 0 || progBatchSeatTypeId == null) {
    		progBatchSeatTypeId = this$.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.progBatchSeatTypeId;
        }
    	var store = combo.getStore();
        store.getProxy().extraParams = {
        	progBatchSeatTypeId: progBatchSeatTypeId
        };
    },
    /**
     * view service opt in/out
     */
    viewServiceOptFormWindow: function(informationType, formItemId, gridItemId,msgTitle) {
        var this$ = this;
        this$.editServiceOptFormWindow(informationType, formItemId, gridItemId,msgTitle);;
        var form = this$.getServiceOptForm();
        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },
    /**
     *  Set Service Opt In/ Opt Out on edit
     */
    editServiceOptFormWindow: function(informationType, formItemId, gridItemId,msgTitle) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var studentProfile = this.getContentPanelActiveTab();
        
 	   	var userId;
        try{
 	   		userId = studentProfile.getUserId();
        }catch(err){
        	var user=this.getCurrentlyLoggedInUser();
        	userId = user.code;
        }
        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId, 'yes',false);
            var form = this$.getServiceOptForm();
            var personCommonWindow = this$.getPersonCommonWindow();
            var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
            myMask.show();
//            form.down("#endDate").setDisabled(false);
            /*var optOutRadioBtn=form.down("#optOutRadioBtn");
			optOutRadioBtn.setDisabled(false);
			optOutRadioBtn.setVisible(true);*/
            
            var records = grid.getSelectionModel().getSelection()[0];
          // form.down("#startDate").setMinValue(dateRender(records.get("fromDate")));
           // form.down("#endDate").setMinValue(dateRender(records.get("tillDate")));
            if(informationType=="SERVICES_OPT_IN_OUT"){
            			
            	/**
            	 * Load data in combo after rest call response has came.
            	 */
            	var task = new Ext.util.DelayedTask(function(){
            		if(records.data.feePlan != null){
            			form.down('#feePlanComboField').setValue(records.data.feePlan.id);
            		}
    				if(records.data.feePlanRuleId != null){
    					form.down('#feePlanRuleComboField').setValue(records.data.feePlanRuleId);
    				}
    				var task = new Ext.util.DelayedTask(function(){
    					if(records.data.feePlanRuleStage != null){
	        			form.down('#feePlanRuleStageComboField').setValue(records.data.feePlanRuleStage.id);
    					}
//	        			form.down("#endDate").setValue(dateRender(records.data.tillDate));
	        			if(records.data.fromDate!=null){
	        				//form.down("#startDate").setMinValue(dateRender(records.data.fromDate));
	                		form.down("#startDate").setValue(dateRender(records.data.fromDate));
	                	}
	                	
	        			if(records.data.tillDate!=null){
	                		form.down("#endDate").setValue(dateRender(records.data.tillDate));
	                	}
	        			myMask.hide();
        			});
    				task.delay(1000);
				});
            	task.delay(1000);
            }
            //myMask.hide();
            if (!isEmpty(records)) {
            	//delete records.data.feePlan;
            	form.loadRecord(records);
            	form.down('#feePlanComboField').reset();
            	form.down('#feePlanRuleComboField').reset();
            	form.down('#feePlanRuleStageComboField').reset();
            	form.down("#startDate").setValue(dateRender(records.data.fromDate));
                form.down("#endDate").setValue(dateRender(records.data.tillDate));
        	    //form.down('#serviceOptRadioGroup').setValue({'isOpted':records.get("isOpted")});
            }
            var optOutBtn=form.down("#isOpted")
            optOutBtn.setVisible(true);
        	var isOpted = records.get("isOpted");
        	if(isOpted) {
        		optOutBtn.setValue(false);
        	} else {
        		optOutBtn.setValue(true);
        	}
        	var taskNew = new Ext.util.DelayedTask(function(){
    			//personCommonWindow.setVisible(true);
    			myMask.hide();
			});
			task.delay(2000);
        	
        } else {
        	showWarningMessage(msgTitle, getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     *  Delete Service Opt In/ Opt Out record
     */
    deleteServiceOptRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var record = grid.getSelectionModel().getSelection()[0];                        
                        var id = "";
                        if (!isNullOrEmpty(record.get("id"))) {
                            id = record.get("id");
                            deleteUrl=deleteUrl.concat("/"+id);
                        }
                        Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl, 
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('SERVICES_OPT_IN_OUT_DELETE_SUCCESS'));
                                }
                        });                        
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    
    revokeButtonCall: function(gridItemId, Url) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);
        var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
        var studentCode=studentPortalInfo.student.code;
        var portalId = this.getCurrentLoggedPortalId();
        var revokeButton = grid.down('#revokeApplication');
        
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('REVOKE_APPLICATION'), getCommonTranslation('REVOKE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var record = grid.getSelectionModel().getSelection()[0];                        
                        var id = "";
                        if (!isNullOrEmpty(record.get("id"))) {
                            id = record.get("id");
                            
                        }
                      
                        Ext.Ajax.request({
                                type: 'rest',
                                url: Url, 
                                method: 'GET',
                                params:{
                                	id:record.data.id
                                },
                                success: function(form, action) {
                                	var response = Ext.decode(form.responseText)
                                    grid.getStore().reload();
                                    //revokeButton.setDisabled(true);
                                    if(response== -1){
                                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICATION_CANCELATION_NOT_ALLOWED'));
                                    }else if(response == -2){
                                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICATION_CANCELLATION_DATE_PASSED'));
                                    }else if(response == -3){
                                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICATION_NOT_STARTED_YET'));
                                    }else{
                                    	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REVOKE_SUCCESS'));
                                    }
                                }
                               
                        });                        
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    
    /*
     *  Save Service Opt In/ Opt Out form record
     */
    saveServiceOpt: function(gridItemId, saveUrl, updateUrl){

        var this$ = this;
        var form = this$.getServiceOptForm();
        form.down('#submitButtonId').setDisabled(true);

        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#service_hidden_field');
        /*if(!form.down("#serviceOptRadioGroup").getValue().isOpted && isNullOrEmpty(form.down("#endDate").getValue())){
        	showWarningMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), "Please select end date field");
        	return false;
        }*/
        
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl = updateUrl,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonServiceOptData(form);
        this$.applyWindowMask(); 
        
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	this$.hideWindowMask();
            	this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getPersonModuleTranslation('SERVICES_OPT_IN_OUT_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getPersonModuleTranslation('SERVICES_OPT_IN_OUT_ADD_SUCCESS'));
                }
            },
            failure: function(form, action) {
            	this$.hideWindowMask();
            	this$.closePersonCommonWindow();
                grid.getStore().reload();
            }
        });

    },
    
    /*
     *  Save Service Opt In/ Opt Out form record For Student
     */
    saveServiceOptForStudent: function(gridItemId, saveUrl, updateUrl){

        var this$ = this;
        var form = this$.getServiceOptForm();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#service_hidden_field');
        /*if(!form.down("#serviceOptRadioGroup").getValue().isOpted && isNullOrEmpty(form.down("#endDate").getValue())){
        	showWarningMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), "Please select end date field");
        	return false;
        }*/
        
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl = updateUrl,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonServiceOptData(form);
        this$.applyWindowMask(); 
        
        var serverUrl=SERVERURL.PATH_PERSON_COVERED_DATA;
        Ext.Ajax.request({
			  type : 'rest',
			  url : serverUrl,
			  jsonData : jsonFormatFormData,
			  method : 'POST',
			  success : function(response, action) {
			  this$.hideWindowMask();
//				if(response.responseText == '0' && isUpdate == false){
			  if(response.responseText == '0'){
					showWarningMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getPersonModuleTranslation('DUPLICATE_RECORD_CONDITION'));
				}else{
			        this$.applyWindowMask(); 
			        Ext.Ajax.request({
			            type: 'rest',
			            url: submitUrl,
			            jsonData: jsonFormatFormData,
			            method: 'POST',
			            success: function(form, action) {
			            	this$.hideWindowMask();
			            	this$.closePersonCommonWindow();
			                grid.getStore().reload();
			                grid.getSelectionModel().deselectAll();
			                if (isUpdate) {
			                    showSuccessMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getPersonModuleTranslation('SERVICES_OPT_IN_OUT_UPDATE_SUCCESS'));
			                } else {
			                    showSuccessMessage(getPersonModuleTranslation('SERVICES_OPT_IN_OUT'), getPersonModuleTranslation('SERVICES_OPT_IN_OUT_ADD_SUCCESS'));
			                }
			            },
			            failure: function(form, action) {
			            	this$.hideWindowMask();
			            	this$.closePersonCommonWindow();
			                grid.getStore().reload();
			            }
			        });
				}
			  }
		  });
        
        


    },
    
    /*
     *  Get Service Opt In/ Opt Out json for form submission
     */
    getJsonServiceOptData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        if(!isEmpty(personObj) && !isNullOrEmpty(personObj['personType'])){
        	delete personObj['personType'];
        }
        var formData = form.getValues();
        if (!isEmpty(formData)) {
            formData.person = personObj;
            delete formData.feePlanRule;
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    /*Community Opt In/ Opt Out Details*/
    
    changeCommunityGridFieldStructure : function(grid){
        grid.setTitle(getPersonModuleTranslation('COMMUNITY_HISTORY'));
        grid.down('#btnAdd').hide();
        grid.down('#btnEdit').hide();
        grid.down('#btnDelete').hide();
    },

    viewCommunityOptFormWindow: function(informationType, formItemId, gridItemId,msgTitle)  {
        var this$ = this;
        this$.editCommunityOptFormWindow(informationType, formItemId, gridItemId,msgTitle);
        var form = this$.getCommunityOptForm();
        if (form) {
            form.down('#submitButtonId').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
            form.isValid();
        }
    },
    
    /*
     *  Set Community Opt In/ Opt Out on edit
     */
    editCommunityOptFormWindow: function(informationType, formItemId, gridItemId,msgTitle) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
        	this.showPersonCommonWindow(informationType, formItemId);
            var form = this$.getCommunityOptForm();
//            form.down("#endDate").setDisabled(false);
            var optOutRadioBtn=form.down("#optOutRadioBtn");
			optOutRadioBtn.setDisabled(false);
			optOutRadioBtn.setVisible(true);
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	if (records != undefined && records != "" && records != null) {
            		if(!isNullOrEmpty(records.data.joiningDate))
                       	records.data.joiningDate = new Date(records.data.joiningDate);
            		if(!isNullOrEmpty(records.data.exitDate))
                       	records.data.exitDate = new Date(records.data.exitDate);
            	    form.loadRecord(records);
            	    if (records.get("isOpted") == true) {
            	        form.down('#optInRadioBtn').setValue(true);
            	        form.down('#optOutRadioBtn').setValue(false);
            	    } else {
            	        form.down('#optInRadioBtn').setValue(false);
            	        form.down('#optOutRadioBtn').setValue(true);
            	    }
            	}
            }
        } else {        	        		
        	showWarningMessage(msgTitle, getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /*
     *  Delete Community Opt In/ Opt Out record
     */
            
    deleteCommunityOptRecord: function(gridItemId, deleteUrl) {

        var this$ = this;
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                    	var record = grid.getSelectionModel().getSelection()[0];                        
                        var id = "";
                        if (!isNullOrEmpty(record.get("id"))) {
                            id = record.get("id");
                            deleteUrl=deleteUrl.concat("/"+id);
                        }
                        Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl, //APPLICANT_COMMUNITY_OPT_DELETE
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('COMMUNITY_OPT_DELETE_SUCCESS'));
                                }
                        });                        
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /*
     *  Save Community Opt In/ Opt Out form record
     */
    saveCommunityOpt: function(gridItemId, saveUrl, updateUrl) {

        var this$ = this;
        var form = this$.getCommunityOptForm();
        var personProfile = this$.getContentPanelActiveTab();
        var grid = personProfile.down(gridItemId);

        var submitUrl, isUpdate = false;
        var id = form.down('#community_hidden_field');
        if(!form.down("#communityOptRadioGroup").getValue().isOpted && isNullOrEmpty(form.down("#endDate").getValue())){
        	showWarningMessage(getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'), "Please select end date field");
        	return false;
        }
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = saveUrl,
            isUpdate = false;
        } else {
            submitUrl = updateUrl,
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonCommunityOptData(form);
        this$.applyWindowMask(); 
       
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(form, action) {
            	 this$.hideWindowMask();
            	this$.closePersonCommonWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'), getPersonModuleTranslation('COMMUNITY_OPT_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'), getPersonModuleTranslation('COMMUNITY_OPT_ADD_SUCCESS'));
                }
            },
            failure: function(form, action) {
            	 this$.hideWindowMask();
            	this$.closePersonCommonWindow();
                grid.getStore().reload();
            }
        });

    },
    /*
     *  Get Community Opt In/ Opt Out json for form submission
     */
    getJsonCommunityOptData: function(form) {

    	var this$ = this;
        var jsonFormFieldData = new Object();
        var personObj = this$.getPersonObj();
        if(!isEmpty(personObj) && !isNullOrEmpty(personObj['personType'])){
        	delete personObj['personType'];
        }
        var formData = form.getValues();
        if (!isEmpty(formData)) {
            formData.person = personObj;
            
        }
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    hideShowEndDateField:function(radiofield,newValue,oldValue){    	
    	var form=radiofield.up('form');    	
    	if(form){
    		var dateFieldDate=form.down('#endDate');
    		var radioValue = radiofield.getValue().isOpted;
    		
    		if(radioValue){
    			dateFieldDate.reset();
    			dateFieldDate.setDisabled(true);			  			
        	}else{         		
        		dateFieldDate.setDisabled(false);
        	}
    	}
    },
    hideShowEndDateFieldOnCommunity:function(radiofield,newValue,oldValue){    	
    	var form=radiofield.up('form');    	
    	if(form){
    		var dateFieldDate=form.down('#endDate');
    		var radioValue = radiofield.getValue().isOpted;
    		if(radioValue){
    			dateFieldDate.reset();
    			dateFieldDate.setDisabled(true);
    			this.setAllowBlank(dateFieldDate, true);
        	}else{         		
        		dateFieldDate.setDisabled(false);
        		this.setAllowBlank(dateFieldDate, false);
        	}
    	}
    	form.isValid();
    }
});
