/**
 * This controller is used for the faculty Payment & Refund Controller.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyPaymentRefundController', {
    extend: 'Academia.controller.personinfo.common.PersonPaymentRefundController',

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personPendingBillsForm',
        selector: 'billviewforpcstructure[itemId=facultyPendingBillsForm]'
    }],
    config: {
    	FACULTY_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_BILLS_PRIVILEGES'),
    	FACULTY_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PAYMENT_RECIEVED_PRIVILEGES'),
    	FACULTY_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REFUNDS_PRIVILEGES'),
    	FACULTY_REFUNDABLE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REFUNDABLE_PAYMENTS_PRIVILEGES'),
    	FACULTY_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_POST_DATED_CHEQUES_PRIVILEGES'),
    	FACULTY_PAYMENT_SETTINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PAYMENT_SETTINGS_PRIVILEGES'),
    	FACULTY_UNPAID_FACULTY_BILLSPERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNPAID_FACULTY_BILLS_PRIVILEGES'),
    	FACULTY_UNBILLED_SESSIONS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_UNBILLED_SESSIONS_PRIVILEGES'),
    	FACULTY_OVER_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_OVER_PAYMENTS_PRIVILEGES'),
    	FACULTY_PAYMENT_MADE_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PAYMENT_MADE_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PENDING_BILLS_PRIVILEGES'),
    	FACULTY_PROFILE_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PAYMENT_RECIEVED_PRIVILEGES'),
    	FACULTY_PROFILE_PAYMENT_MADE_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_PAYMENT_MADE_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_POST_DATED_CHEQUES_PRIVILEGES')
    },
    init: function(application) {
    	this.control({
    		/**
    		 * Pending Bills
    		 */
    		 'pendingbillsgrid[itemId=facultyPendingBillsGrid]': {
                 render: function(grid) {
                	 var this$= this;
              		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                	 var personProfile = this$.getContentPanelActiveTab();
                	 var userId = personProfile.getUserId();
                     var params = {
                     		id : userId,
                     		billedUserType : 'USER',
         					raiseBillCategory : 'BILL_PAYABLE'
                     };
                	 
                     this.loadGridStoreFaculty('#facultyPendingBillsGrid', SERVERURL.FACULTY_PENDING_BILLS_DETAILS, params);
                	 var portalId = this.getCurrentLoggedPortalId();
                	 if (portalId == 1){
                		 this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_PENDING_BILLS_PERMISSIONS());	
                	 } else if (portalId == 2){
                		 this.doAccessControlValidation(grid, this.getFACULTY_PENDING_BILLS_PERMISSIONS());
                	 }
                 }
             },
             'pendingbillsgrid[itemId=facultyPendingBillsGrid] button[itemId=btnView]': {
                 click: function() {
                     this.viewFacultyPendingBill('PENDING_BILL', 'facultyPendingBillsForm', '#facultyPendingBillsGrid', SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                 }
             },
             
             /**
     		 * Payment Received History 
     		 */
             
             'paymentreceivedhistorygrid[itemId=facultyPaymentReceivedHistoryGrid]': {
                 render: function(grid) {
                	 var this$= this;
              		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                	 var personProfile = this$.getContentPanelActiveTab();
                	 var userId = personProfile.getUserId();
                     var params = {
                    		 id : userId
                     };
                     this.loadGridStoreFaculty('#facultyPaymentReceivedHistoryGrid', SERVERURL.FACULTY_PAYMENT_RECEIVED_HISTORY_DETAILS, params);
                	 var portalId = this.getCurrentLoggedPortalId();
                	 if (portalId == 1){
                		 this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_PAYMENT_RECIEVED_PERMISSIONS());	
                	 } else if (portalId == 2){
                		 this.doAccessControlValidation(grid, this.getFACULTY_PAYMENT_RECIEVED_PERMISSIONS());
                	 }
                	 
                 },
                 cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
                	 var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
                	 if (cellDataIndex == "adjustment") {
                    	 this.viewFacultyPaymentRecievedHistory('PAYMENT_RECIEVED_HISTORY', 'billheaderadjustmentdetailsgridwindow', '#facultyPaymentReceivedHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);   
                     }else if(cellDataIndex == "instrument"){
                    	 this.viewFacultyPaymentRecievedHistory('PAYMENT_RECIEVED_HISTORY', 'paymentheaderinstrumentadjustmentdetailsgridwindow', '#facultyPaymentReceivedHistoryGrid', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
                     }
              		
                 },
                 afterrender : function(grid){
                	 if(this.getCurrentLoggedPortalId() == 2){
                    	 grid.columns[4].hide();
                	 }
                 }
             },
             
            /**
     		 *Payment made history
     		 */
           'paymentmadehistorygrid[itemId=facultyPaymentMadeGrid]': {
               render: function(grid) {
            	   var this$= this;
            	   var personProfile = this$.getContentPanelActiveTab();
            	   var userId = personProfile.getUserId();
            	   var params = {
            			   id : userId
                   };
                   this.loadGridStore('#facultyPaymentMadeGrid', SERVERURL.FACULTY_PAYMENT_MADE_HISTORY_DETAILS, params);
            	   var portalId = this.getCurrentLoggedPortalId();
            	   if (portalId == 1){
            		   this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_PAYMENT_MADE_HISTORY_PERMISSIONS());	
            	   } else if (portalId == 2){
            		   this.doAccessControlValidation(grid, this.getFACULTY_PAYMENT_MADE_HISTORY_PERMISSIONS());
            	   }
               },
               cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
            	   var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
            	   if (e.target.tagName == 'A') {
            		   if (cellDataIndex == "adjustment") {
            			   this.viewPaymentMadeHistory('PAYMENT_RECIEVED_HISTORY', 'billheaderadjustmentdetailsgridwindow', '#facultyPaymentMadeGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);   
            		   }else if(cellDataIndex == "instrument"){
            			   this.viewPaymentMadeHistory('PAYMENT_RECIEVED_HISTORY', 'paymentheaderinstrumentadjustmentdetailsgridwindow', '#facultyPaymentMadeGrid', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
            		   }
            	   }
               }
           },
         
         /**
  		 * Post Dated Cheque
  		 */
         'postdatedchequegrid[itemId=facultyPostDatedChequeGrid]': {
             render: function(grid) {
            	 var this$= this;
          		 var academyLocationId = this$.getCurrentAcademyLocation();
        		 Ext.Ajax.request({
		    		  method: "GET",
		    		  type: 'rest',
		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
		    		  params:{
		    			  academyLocationId: academyLocationId
		    		  },
		    		  success: function(response) {
		    			  if(response){
		    				  result=response.responseText;	
		    			  }
		    	    		  if(result === "false"){
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length != null && length != ""){
		    	 					 for(var i = 0; i < length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
		    	 							 gridColumns[i].setVisible(false);
		    	 						 }
		    	 					 }
		    	 				 }
		    	 			  }else{
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length!=null && length!=""){
		    	 					 for(var i=0; i<length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
		    	 							 gridColumns[i].setVisible(true);
		    	 						 }
		    	 					 }
		    	 				 }
		    	    	  }
		    		  }
		    	  });
            	 var personProfile = this$.getContentPanelActiveTab();
            	 var userId = personProfile.getUserId();
                 var params = {
                 		id : userId,
                 		billedUserType : 'USER'
                 };
                 this.loadGridStoreFaculty('#facultyPostDatedChequeGrid', SERVERURL.PERSON_POST_DATED_CHEQUE_DETAILS, params);
            	 var portalId = this.getCurrentLoggedPortalId();
            	 if (portalId == 1){
            		 this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_POST_DATED_CHEQUES_PERMISSIONS());	
            	 } else if (portalId == 2){
            		 this.doAccessControlValidation(grid, this.getFACULTY_POST_DATED_CHEQUES_PERMISSIONS());
            	 }
             }
         }
    	});
    },
    	loadGridStoreFaculty: function(gridItemId, url, params) {
            var this$ = this;
            var personProfile = this$.getContentPanelActiveTab();
            var grid = personProfile.down(gridItemId);
    		// toggleReadOnlyFormItems(grid, true);
            if(this.getCurrentLoggedPortalId()==3 || grid.itemId == "pendingBillsGridId"){
            	grid.columns[3].hidden = true;
            	}
            if (grid) {
            	var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
            	 if(portalId == 2){
        			 setTimeout(function(){
        			var check=grid.selModel.view.selModel.mode=='MULTI';
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='receiptStatus'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 					store.load({ 
   	                 	callback: function(record, operation, success) {
   	                 		if (record.length > 0) {
   	                 			for(var i in record){
   	                 				if (record[i].data.whetherDisplayTotal != false) {
   	                 					this$.toggleGridSummaryRow(grid,true); 
   	                 				}
   	                 			}
   	                 		}else{
   	                 			this$.toggleGridSummaryRow(grid,false);
   	                 		}
   	                 	}
   	                 });
   	 				} 
   	 				},300);
   	 				 
        			 
        		 } if(portalId == 1){

        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     					this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
        		 }
            	 else{
        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				if (record[i].data.whetherDisplayTotal != false) {
                     					this$.toggleGridSummaryRow(grid,true); 
                     				}
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 }
                
                
            }
    }
});
