
/**
 * @author Deepak.Nigam
 *  This controller is used for student manage complaint.
 */

Ext.define('Academia.controller.personinfo.student.StudentComplaintController', {
    extend: 'Academia.controller.base.BaseController',

    alias: "widget.studentcomplaintcontroller",

    stores: ['servicerequest.complaintrequest.ComplaintTypes', 'servicerequest.complaintrequest.ComplaintStatus', 
             'personinfo.common.services.ServiceOptStore', 'personinfo.common.services.CommunityNameStore', 
             'personinfo.common.services.CommunityHistoryStore', 'personinfo.common.services.CommunityOptStore',
             'personinfo.common.services.FeePlanStore','feeandpayment.managebill.BillSequence','feeandpayment.managebill.FeePlanStage',
             'feeandpayment.managebill.FeeStageConfigHead'],

    views: [ 'personinfo.common.PersonCommonWindow', 'servicerequest.studentPortal.StudentComplaintView', 'servicerequest.studentPortal.StudentComplaintSearchForm'],
    
    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    },{
        ref: 'studentcomplaintsearchform',
        selector: 'studentcomplaintsearchform'
    },{
    	ref:'studentComplaintSearchResultGrid',
    	selector:'searchresultgrid[itemId=studentComplaintSearchResultGrid]'
    }],
    config: {
    	
    	STUDENT_MANAGE_COMPLAINT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MANAGE_COMPLAINT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	'studentcomplaintsearchform button[itemId=complaintFindButtonId]': {
                click: function() {                	                	
            		this.loadComplaintGridAndSearchRequest();
                }
            },
            'studentcomplaintsearchform button[itemId=complaintClearSearch]': {
                click: function() {                	                	
            		var form = this.getStudentcomplaintsearchform();
            		form.getForm().reset();
                }
            },
            
            'searchresultgrid[itemId=studentComplaintSearchResultGrid]': {
            	render: function(grid) {
            		this.gridRenderFunction(grid);
            		this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_MANAGE_COMPLAINT_PERMISSIONS());
            	},
            	cellclick: function(grid, td, cellIndex, record){
            		var searchResultGrid =  this.getStudentComplaintSearchResultGrid();
            		this.cellclickComplaintTrackRequestGrid(searchResultGrid,cellIndex,record); 
            	},
            },
            
            /** Export Button for Faculty***/
            
            'searchresultgrid[itemId=studentComplaintSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
                click: function() {
                    this.exportCompalaintList(SERVERURL.PDFEXPORT,'pdf',false,'FACULTY');
                }
            },
            'searchresultgrid[itemId=studentComplaintSearchResultGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
                click: function() {
                    this.exportCompalaintList(SERVERURL.PDFEXPORT,'pdf',true,'FACULTY');
                }
            },
            'searchresultgrid[itemId=studentComplaintSearchResultGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
                click: function() {
                    this.exportCompalaintList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,'FACULTY');
                }
            },
            'searchresultgrid[itemId=studentComplaintSearchResultGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
                click: function() {
                    this.exportCompalaintList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,'FACULTY');
                }
            },
        });
    },
    
    loadComplaintGridAndSearchRequest: function(model, records) {
        var searchForm = this.getStudentcomplaintsearchform();
        var jsonFormatFormData = this.createComplaintJsonFormat(searchForm);
        if (jsonFormatFormData){
        var complaintResultGrid = this.getStudentComplaintSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.COMPLAINT_VIEWCODE);
        complaintResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        }
    },
    
    gridRenderFunction:function(grid){
		grid.addButtonToolbar();
    },
    
    exportCompalaintList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getStudentcomplaintsearchform().getForm();	
    	var searchResultGrid = this.getStudentComplaintSearchResultGrid();
    	var pagingtoolbaroptions = this.getStudentComplaintSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createComplaintJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('STUDENT_COMPLAINT_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
    
    /**
     * This method is used to create JSON format of complaint form values
     * @param SearchForm
     * @return formated JSON of form Values
     */
    createComplaintJsonFormat: function(searchForm) {
    	
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        if(searchForm){
        values.configCode = CONSTANTS.CB.COMPLAINT_BASIC_CONFIGCODE;
     
        formValues = searchForm.getValues();

        for (var key in formValues) {
         	var value = formValues[key]; 
         	if(!isNullOrEmpty(value) && key !== 'COMPLAINT_FROM_DATE' && key !== 'COMPLAINT_TO_DATE'){
         			var keyValueJsonObject = this.getJsonObject( key , value);
         	        this.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
         	}
         }
        var COMPLAINT_TIME_BETWEEN = this.getJsonObject('COMPLAINT_TIME_BETWEEN', formValues.COMPLAINT_FROM_DATE, formValues.COMPLAINT_TO_DATE);
        this.pushJsonObjectInArray(COMPLAINT_TIME_BETWEEN, searchcriteria);
        
        var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', this.getCurrentAcademyLocation());
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
      
        var ACADEMY_LOCATION_ID = this.getJsonObject('REQUESTER_ID', this.getCurrentlyLoggedInUser().id);
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID, searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
        }
    },
    
    createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    cellclickComplaintTrackRequestGrid: function(grid, cellIndex, record) {
	     var columnName = grid.columnManager.columns[cellIndex].dataIndex;
	     if (columnName === "GRIEVANCE_ID") {
	         var me = this;
	         	var requestId = record.get('ID');
	            var requestType = record.data.REQUEST_TYPE;
	            me.setComplaintRequestData(requestId,record,requestType);
	     }
	 },
	 
	 setComplaintRequestData : function(requestId,record,requestType){
		  var me = this;
		  var srBaseController = this.getController('Academia.controller.servicerequest.ServiceRequestController');
		  var param ={
	 			  id :requestId	
	           };
	       me.sendGetAjaxRequest(SERVERURL.COMPLAINT_FIND_BY_ID, 'GET', param, function(option, success, response) {
	       if (success) {
	    	   var data = Ext.decode(response.responseText);
	    	   if(!isNullOrEmpty(data.dueDate))
	              data.dueDate = new Date(data.dueDate);
	    	   if(!isNullOrEmpty(data.requestDate))
		              data.requestDate = new Date(data.requestDate);
	             me.openComplaintPanel(data);
	             me.saveComplaintRequestData(data,record);
	             srBaseController.toggleSubmitButtonOnFollowUpForm(data,requestType);
	     }
	    });
	 },
	 /**
     * This  method is used to Open complaint Panel 
     */
    openComplaintPanel:function(data){
   	 var me = this;
   	 var requestTitle = data.requestId;
   	 var tab = this.openTab(requestTitle, 'servicerequestpanel', CONSTANTS.MENU_COLOR_NINE);
   	 var requestId = data.id;
   	 var srBaseController = this.getController('Academia.controller.servicerequest.ServiceRequestController');
   	 srBaseController.applyServiceRequestConfig(tab);
   	 srBaseController.applyRequestId(tab,requestId);
   	 tab.setResponseData(data);
   	 tab.setServiceRequestId(requestId);
   	 tab.setServiceRequestId(requestId);
   	 var requestPanel = Ext.widget('studentcomplaintdetailsform');
   	 if (data.detail.complaintBy === 'PARENTS' || data.detail.complaintBy === 'OTHERS'){
			 var ref = requestPanel.down('#complaintByFieldContainer');
	     	 var complaintantRef = requestPanel.down('#selectComplaintantId');
	        	if(complaintantRef){
	        		ref.remove(complaintantRef);
	        		ref.insert( 1,{
	                    xtype: 'textfield',
	                    fieldLabel: getServiceRequestTranslation('COMPLAINTANT'),
	                    name: 'complainant',
	                    itemId: 'complaintantId',
	                    allowBlank: false
	           });
	        	ref.doLayout();	
	    	   }else{
	    		var	selectPersonCmbRef = requestPanel.down('#complaintantId');
	       		selectPersonCmbRef.reset();
	    	   }
	     }else{
	    		 var cmb = requestPanel.down('#selectPersonId');
	         	 //var combo = requestPanel.down('#selectComplaintantId');
	         	 cmb.setDisabled(false);
	         	 //combo.setDisabled(false);
	     }
   	 
   	 if(data.detail.against === 'NOT_APPLICABLE'){
   		 requestPanel.down('#selectPersonId').setVisible(false);
   		 requestPanel.down('#selectPersonId').setDisabled(true);
   	 }
   	 tab.add(requestPanel);
   	 var settingId = data.complaintTypeSetting.id;
   	 tab.setSettingId(settingId); 
    },
    
    saveComplaintRequestData : function(data,record){		 
    	var me = this;
    	var srBaseController = this.getController('Academia.controller.servicerequest.ServiceRequestController');
    	var serviceRequestForm = srBaseController.getContentPanelActiveTab();
    	var form = serviceRequestForm.down('form');
    	
    	form.down('#facilityCodeId').getStore().load();
    	
    	srBaseController.toggleWithdrawButton(data,record,form);
    	srBaseController.addComplaintDetailsForm(data,record,serviceRequestForm);
    	srBaseController.setPendingDays(form,data);
    	srBaseController.setComplaintData(data,form,record);		 
    	srBaseController.toggleReadOnlyFormItems(form.getForm(),true);
    	serviceRequestForm.down('#id').setValue(record.data.ID);
    	form.down('#btnSaveComplaint').setVisible(false);
    	form.down('#cancelIdComplaint').setVisible(false);
	 },
});
