/**
 * @author Prashant Choudhary

 */
Ext.define('Academia.controller.personinfo.student.StudentJourneyCoreErpController', {
	extend: 'Academia.controller.personinfo.common.PersonCourseExecutionController',
	alias: "widget.studentjourneycoreerpcontroller",
	stores : [
		'coursetransaction.studentenrollment.AcademyDisplayNameByAdmissionStore',
		'attendance.AttendanceProgramSectionStore',
		'enquiry.AcademicBatchStore',
		'personinfo.common.personalinfo.StudentJourneyPeriodStatusStore',
		'personinfo.common.personalinfo.StudentJourneyCoreERPPeriodStatusStore',
		'common.AcademyLocationNameSeparated',
		'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
		'facilitiesresources.resourcebooking.SeatTypeByBatchStore',
		'facilitiesresources.resourcebooking.CurrentAndFuturePeriodStore',
		'common.BatchesByProgramId',
		'student.studentJourney.ProgressionStatusStore','scholarships.AssociateProgramStore',
		'user.UserAcademyLocationStore','common.CurrentBatchStore',
		'student.studentJourney.StudentJourneyEnrollmentStatusSettingStore',
		'personinfo.common.personalinfo.StudentJourneyAddedStatusStore',
		'Academia.store.common.AcademicTermStore',
		'Academia.store.common.AcademicTermStoreByAdmId'
		],
		views : [
			'student.studentprofile.StudentJourneyStructureForCoreErp',
			'student.studentprofile.StudentJourneySearchForm',
			'personinfo.common.personalinfo.StudentJourneyCoreERPGrid',
			'student.studentJourney.ChangeProgressionStatusWin',
			'studentjourneysetup.StudentJourneySetupStructure',
			'studentjourneysetup.StudentJourneySetupForm','studentjourneysetup.StudentJourneySetupWindow',
			'program.programDetails.programBatches.ProgramBatchCopyGrid',
			'studentjourneysetup.StudentJourneySetupGrid',
			'studentjourneysetup.StudentJourneySetupFormAndGridStructure',
			'studentjourneysetup.StudentJourneyEnrollmentStatusSettingGrid',
			'student.studentJourney.EnrollmentStatusWin',
			'studentjourneysetup.StudentJourneyDashboardSetting',
			],
			refs: [{
				ref: 'studentjourneysearchform',
				selector: 'studentjourneysearchform'
			},{
				ref: 'studentjourneystructureforcoreerp',
				selector: 'studentjourneystructureforcoreerp'
			},{
				ref: 'studentjourneycoreerpgrid',
				selector: 'studentjourneycoreerpgrid'
			},{
				ref : 'changeprogressionstatuswin',
				selector : 'changeprogressionstatuswin'
			},{
				ref: 'studentjourneysetupform',
				selector: 'studentjourneysetupform'
			},{
				ref: 'programbatchcopygrid',
				selector: 'programbatchcopygrid'
			},{
				ref: 'studentjourneysetupwin',
				selector: 'studentjourneysetupwin'
			},
			{
				ref: 'studentjourneysetupgrid',
				selector: 'studentjourneysetupgrid'
			},{
				ref: 'studentjourneysetupformandgridstructure',
				selector: 'studentjourneysetupformandgridstructure'
			},{
				ref: 'studentjourneyenrollmentstatussettinggrid',
				selector: 'studentjourneyenrollmentstatussettinggrid'
			},{
				ref: 'enrollmentstatuswin',
				selector: 'enrollmentstatuswin'
			},
			{
				ref:'studentjourneydashboardsetting',
				selector: 'studentjourneydashboardsetting'
			}],
			
			config: {
				STUDENT_JOURNEY_CORE_ERP_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_JOURNEY_PRIVILEGES')
			},
			init: function(application) {
				this.control({
					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid]':{
						afterrender: function(grid){
							var me = this;
							if(me.getCurrentLoggedPortalId() == 1){
								me.disableChangeProgressionStatusButtonPivileges(grid, me.getSTUDENT_JOURNEY_CORE_ERP_PERMISSION()); 
							}
							setTimeout(function(){
								me.addDataGridConfigButton(grid, me.getSTUDENT_JOURNEY_CORE_ERP_PERMISSION());

							},1500);

							var gridStore = grid.getStore();

							gridStore.removeAll();

							var alStore = Ext.getStore('common.AcademyLocationNameSeparated');
							alStore.load();
							var personProfile = me.getContentPanelActiveTab();
							var studentId = personProfile.getUserId();
							gridStore.getProxy().extraParams = {
								studentId : studentId
							};
							//gridStore.load();
							gridStore.load({
								callback: function(){
									setTimeout(function(){
										grid.up().doLayout();
										 grid.getView().refresh();
						                    var view = grid.getView();
						                    var store = grid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('resultStatus') === 'Exempted'){
						                            var row = view.getRecord(index);
						                            if(row){
														var exemptedRow = grid.view.getNode(row);
														exemptedRow.classList.add('fadeOutRowCls');
						                            }
						                        }
						                    });
						                    me.removeMask();
									},300);
								}
							});

						},
						cellclick : function(view, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var grid = view.up();
							var button= grid.down('#changeProgressionStatusId');
							if (record.data.resultStatus == 'Exempt') {
								button.setDisabled(true);
							}else{
								button.setDisabled(false);
							}
						},
						selectionchange: function(grid, selected) {
							var modifyEnrollmentBtn = grid.view.up().down('#modifyEnrollmentBtnItemId');
							var cancelbtn = grid.view.up().down('#cancelButtonId');
							var addEnrollmentBtn = grid.view.up().down('#addEnrollmentSJ');
							var removeEnrollmentBtn = grid.view.up().down('#removeEnrollmentSJ');
							var addEnrollmentForLastLineBtn = grid.view.up().down('#addEnrollmentForLastLine');
							var spBtnMoreActionsSJ = grid.view.up().down('#spBtnMoreActionsSJ');
							var isLastRecord=false;
							if(selected.length && grid.getStore().getCount()-selected[0].index==1)
								{
								isLastRecord=true;
								}
							
							if (selected.length && selected[0].data.resultStatus.startsWith("Withdrawn")) {
								modifyEnrollmentBtn.setDisabled(true);
								spBtnMoreActionsSJ.setDisabled(true);
								cancelbtn.setDisabled(true);
								return;
							}
							if(selected.length && selected[0].data.resultStatus == "Pre-Enrolled"){
								addEnrollmentBtn.setDisabled(false);
								spBtnMoreActionsSJ.setDisabled(false);
								removeEnrollmentBtn.setDisabled(false);
							}else if(selected.length && selected[0].data.resultStatus == "Enrolled"){
								addEnrollmentBtn.setDisabled(false);
								spBtnMoreActionsSJ.setDisabled(false);
								removeEnrollmentBtn.setDisabled(true); //V2D-454728
							}
							
							else{
								addEnrollmentBtn.setDisabled(true);
								removeEnrollmentBtn.setDisabled(true);
							}
							if(selected.length && selected[0].data.resultStatus == "Exempted"){
								modifyEnrollmentBtn.setDisabled(true);
								cancelbtn.setDisabled(false);
							}else{
							modifyEnrollmentBtn.setDisabled(!selected.length);
							cancelbtn.setDisabled(true);
							}
							
							 if (isLastRecord)
								{
								addEnrollmentForLastLineBtn.setDisabled(false);
								}
							 else{
								 addEnrollmentForLastLineBtn.setDisabled(true);
							 }
						}
					},
					
					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=addedStatus]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');

							var addedStatus = combo.getValue();
							this.changeAddedStatus(combo, grid, addedStatus);
						}
					},

					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=alName]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendLayouts();
							grid.suspendEvents();
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							if(selectedRecord.raw.academicLocationName != combo.getValue()){
								selectedRecord.set('campusId','');
								selectedRecord.set('campusName','');
								selectedRecord.set('programName','');
								selectedRecord.set('periodName','');
								selectedRecord.set('batchName','');
								selectedRecord.set('programId','');
								selectedRecord.set('batchId','');
								selectedRecord.set('periodId','');

								Ext.Ajax.request({
									type : 'rest',
									url : SERVERURL.PATH_FIND_ACADEMY_CAMPUS_LOCATION_IDS,
									params : {
										academyLocationId : combo.store.findRecord(combo.valueField,combo.getValue()).data.id
									},
									method : 'GET',
									success : function(response) {
										var data = Ext.decode(response.responseText);
										if(data.length){
											grid.suspendLayouts();
											grid.suspendEvents();
											selectedRecord.set('campusId',data[0].id);
											selectedRecord.set('campusName',data[0].code);
											grid.resumeEvents();
											grid.resumeLayouts();
										}
									}
								});
								grid.resumeEvents();
								grid.resumeLayouts();
							}
							else{
								selectedRecord.set('campusId',selectedRecord.raw.campusId);
								selectedRecord.set('campusName',selectedRecord.raw.campusName);
								selectedRecord.set('programName',selectedRecord.raw.programName);
								selectedRecord.set('periodName',selectedRecord.raw.periodName);
								selectedRecord.set('batchName',selectedRecord.raw.batchName);
								selectedRecord.set('programId',selectedRecord.raw.programId);
								selectedRecord.set('batchId',selectedRecord.raw.batchId);
								selectedRecord.set('periodId',selectedRecord.raw.periodId);
								grid.resumeEvents();
								grid.resumeLayouts();
							}
						}
					},

					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=programName]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendLayouts();
							grid.suspendEvents();
							var selectedRecord = grid.getSelectionModel().getSelection()[0];

							try{
								var newProgramId = combo.store.findRecord(combo.valueField,combo.getValue()).data.id;
							}
							catch(e){
								var newProgramId = '';
								//
							}

							if(selectedRecord.raw.programId != newProgramId){
								Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading'); //

								grid.suspendLayouts();
								grid.suspendEvents();
								
								selectedRecord.set('periodName','');
								selectedRecord.set('batchName','');
								selectedRecord.set('batchId','');
								selectedRecord.set('periodId','');

								selectedRecord.set('seatTypeId','');
								selectedRecord.set('seatType','');

								grid.resumeEvents();
								grid.resumeLayouts();

								//setting programId
								var currentALId = selectedRecord.data.academicLocationId;
								var programStore = Ext.getStore('facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore');
								programStore.getProxy().extraParams = {
									academyLocationIds: currentALId
								};

								programStore.load({
									callback: function(){

										Ext.getBody().unmask(); //

										var recIdx = programStore.findExact('value',combo.getValue());
										if(recIdx != -1){

											Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading'); //

											var progRecord = programStore.getAt(recIdx);
											
											grid.suspendLayouts();
											grid.suspendEvents();
											
											selectedRecord.set('programId', progRecord.data.id);
											
											grid.resumeEvents();
											grid.resumeLayouts();

											if(selectedRecord.get('periodStatus') != 'PROGRAM_TRANSFER'){
												var url = SERVERURL.PATH_BY_PROGRAM_AND_PERIOD_SEQUENCE;
												Ext.Ajax.request({
													type : 'rest',
													url : url,
													params : {
														programId : progRecord.data.id,
														periodSequence: selectedRecord.get('programPeriodSeq'),
														academicTermSequence: selectedRecord.get('academicTermSeq'),
														academicTermId: selectedRecord.get('academicTermId')
													},
													method : 'GET',
													success : function(response) {

														grid.suspendLayouts();
														grid.suspendEvents();
														
														var data = Ext.decode(response.responseText);
														//Calling Batch Period API and setting accordingly
														selectedRecord.set('periodName',data.periodName);
														selectedRecord.set('batchName',data.batchName);
														selectedRecord.set('batchId',data.batchId);
														selectedRecord.set('periodId',data.periodId);
														selectedRecord.set('programPeriodSeq',data.periodSequence);
														selectedRecord.set('academicTermSeq',data.academicTermSequence);
														selectedRecord.set('academicTermCode',data.academicTermName);
														selectedRecord.set('academicTermId',data.academicTermId);

														grid.resumeEvents();
														grid.resumeLayouts();
														
														Ext.getBody().unmask(); //

														if(data.batchId){

															Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading'); //

															Ext.Ajax.request({
																type : 'rest',
																url : SERVERURL.PATH_FINDALL_SEAT_TYPE_BY_BATCH_ID,
																params : {
																	batchId : data.batchId
																},
																method : 'GET',
																success : function(response) {

																	Ext.getBody().unmask(); //

																	var data = Ext.decode(response.responseText);

																	if(data.length == 1){
																		grid.suspendLayouts();
																		grid.suspendEvents();
																		
																		selectedRecord.set('seatTypeId',data[0].id);
																		selectedRecord.set('seatType',data[0].value);

																		grid.resumeEvents();
																		grid.resumeLayouts();
																	}
																}
															});
														}
													}
												});
											}
											else{
												Ext.getBody().unmask();
											}
										}
									}
								});
								grid.resumeEvents();
								grid.resumeLayouts();
							}
							else{
								selectedRecord.set('periodName',selectedRecord.raw.periodName);
								selectedRecord.set('batchName',selectedRecord.raw.batchName);
								selectedRecord.set('programId',selectedRecord.raw.programId);
								selectedRecord.set('batchId',selectedRecord.raw.batchId);
								selectedRecord.set('periodId',selectedRecord.raw.periodId);
								selectedRecord.set('seatTypeId',selectedRecord.raw.seatTypeId);
								selectedRecord.set('seatType',selectedRecord.raw.seatTypeName);
								grid.resumeEvents();
								grid.resumeLayouts();
							}
						}
					},

					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=batchName]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendEvent();
							var selectedRecord = grid.getSelectionModel().getSelection()[0];

							try{
								var newBatchId = combo.store.findRecord(combo.valueField,combo.getValue()).data.id;
							}
							catch(e){
								var newBatchId = '';
								//
							}

							if(selectedRecord.raw.batchId != newBatchId){
								selectedRecord.set('batchId',combo.store.findRecord(combo.valueField,combo.getValue()).data.id);
								selectedRecord.set('periodName','');
								selectedRecord.set('periodId','');
								selectedRecord.set('seatType','');
								selectedRecord.set('seatTypeId','');
							}
							else{
								selectedRecord.set('batchId',selectedRecord.raw.batchId);
								selectedRecord.set('periodName',selectedRecord.raw.periodName);
								selectedRecord.set('periodId',selectedRecord.raw.periodId);
								selectedRecord.set('seatType',selectedRecord.raw.seatTypeName);
								selectedRecord.set('seatTypeId',selectedRecord.raw.seatTypeId);
							}
							grid.resumeLayouts();
						}
					},

					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=periodName]':{
						select: function(combo,records){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendEvent(); 
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							if(selectedRecord.data.isAcademicTermEditable){
							var selectedRecords = records[0];
                       		selectedRecord.set('programPeriodSeq', selectedRecords.get('sequence'));
                       		}
							//if(selectedRecord.raw.periodName != combo.getValue()){
							selectedRecord.set('periodId',combo.store.findRecord(combo.valueField,combo.getValue()).data.id);
							if(!isNullOrEmpty(selectedRecord.raw) && selectedRecord.raw.periodName != combo.getValue()){
							selectedRecord.set('campusId','');
							selectedRecord.set('campusName','');
							}
							/*}
 				   else{
 					   selectedRecord.set('periodId',selectedRecord.raw.periodId);
 				   }*/
							grid.resumeLayouts();
						}
					},
					
					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=campusName]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendEvent();
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							
							//if(selectedRecord.raw.periodName != combo.getValue()){
							
							selectedRecord.set('academyLocationCampusId',combo.store.findRecord(combo.valueField,combo.getValue()).data.id);
							selectedRecord.set('campusId',combo.store.findRecord(combo.valueField,combo.getValue()).data.id);
							/*}
 				   else{
 					   selectedRecord.set('periodId',selectedRecord.raw.periodId);
 				   }*/
							grid.resumeLayouts();
						}
					},

					'studentjourneycoreerpgrid[itemId=studentjourneycoreerpgrid] combo[itemId=seatTypeName]':{
						select: function(combo){
							var grid = combo.up('studentjourneycoreerpgrid');
							grid.suspendEvent();
							var selectedRecord = grid.getSelectionModel().getSelection()[0];
							selectedRecord.set('seatTypeId',combo.store.findRecord(combo.valueField,combo.getValue()).data.id);
							grid.resumeLayouts();
						}
					},

					'studentjourneystructureforcoreerp button[itemId=saveStudentJourney]':{
						click: function(btn){
							var me = this;
							me.submitStudentJourney(btn);
						}
					},

					'studentjourneystructureforcoreerp button[itemId=changeProgressionStatusId]':{
						click: function(btn){
							var me = this;
							me.showChangeProgressionStatusWin(btn); 				   
						}
					},
					
					


					'changeprogressionstatuswin button[itemId=progressionStatusCancelBtn]':{
						click: function(btn){
							this.closeChangeProgressionStatusWin(btn);
						}
					},

					'changeprogressionstatuswin button[itemId=addProgressionStatusSubmitBtn]':{
						click: function(btn){
							this.updateProgressionStatus(btn);
						}
					},
					
					'studentjourneystructureforcoreerp button[itemId=modifyEnrollmentBtnItemId]':{
						click: function(btn){
							var me = this;
							me.showModifyEnrollmentWin(btn); 				   
						}
					},
					
					'studentjourneystructureforcoreerp button[itemId=cancelButtonId]':{
						click: function(btn){
							var me = this;
							var grid = btn.up('studentjourneycoreerpgrid');
							var gridStore = grid.getStore();
							var modifiedRecords = gridStore.getModifiedRecords();
							var selections = grid.getSelectionModel().getSelection();
							var data = {};
							if (selections.length != 0) {
								showConfirmMessage(getCommonTranslation('CANCEL')
										,getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CANCEL'),function(btn,text){
									if (btn == 'yes') {
										data = {
												"id": selections[0].raw.id,
												"academicTermId":selections[0].data.academicTermId,
												"academicTermSeq":selections[0].data.academicTermSeq,
												"programId":selections[0].data.programId,
												"academicLocationId":selections[0].data.academicLocationId,
												"periodId":selections[0].data.periodId,
											//	"campusId": selections[0].data.campusId,
												"programPeriodSeq":selections[0].data.programPeriodSeq,
												"batchId":selections[0].data.batchId,
												"periodStatus": selections[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
												"seatTypeId": selections[0].data.seatTypeId,
												"progressionStatus": selections[0].data.progressionStatus,
												"admissionId":selections[0].data.admissionId,
												"studentId":selections[0].data.studentId,
												"fromAcademicLocationId": selections[0].raw.academicLocationId,
												"fromProgramId":selections[0].raw.programId,
												"fromBatchId":selections[0].raw.batchId,
												"fromPeriodId":selections[0].raw.periodId,
												"fromSeatTypeId":selections[0].raw.seatTypeId,
											//	"programJourneySeq": selections[0].raw.programJourneySeq,
												"resultStatus" : selections[0].raw.resultStatus,
												"transectionVersion" : selections[0].raw.transectionVersion
										}
										var	submitUrl=SERVERURL.PATH_STUDENT_JOURNEY_EXEMPT_CANCELLATION;
										Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
										Ext.Ajax.request({
											type : 'rest',
											url : submitUrl,
											jsonData : data,
											method : 'POST',
											success : function(form, action) {
												Ext.getBody().unmask();
												showSuccessMessage(getPersonModuleTranslation('STUDENT_JOURNEY'),getCommonTranslation('STUDENT_JOURNEY_CANCELLED_SUCCESSFULLY'));
												grid.getStore().load({
													callback: function(){
														setTimeout(function(){
															grid.up().doLayout();
															grid.getView().refresh();
															var view = grid.getView();
															var store = grid.getStore();
															store.each(function(record, index){
																if(record.get('resultStatus') === 'Exempted'){
																	var row = view.getRecord(index);
																	if(row){
																		var exemptedRow = grid.view.getNode(row);
																		exemptedRow.classList.add('fadeOutRowCls');
																	}
																}
															});
														},300);
													}
												});
												grid.getSelectionModel().deselectAll();
											}
										});
									}
								});
							} else {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},
					
					'studentjourneystructureforcoreerp splitbutton[itemId=spBtnMoreActionsSJ] menuitem[itemId=addEnrollmentSJ]' :{
						click: function(btn){
							var activeTab = this.getContentPanelActiveTab();
							var me = this;
							var grid = activeTab.down('studentjourneycoreerpgrid');
							var combo;
							var periodStatus = 'ADD_ENROLLMENT';
							var transAddEnroll =  getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT');
							me.changePeriodStatus(combo, grid, periodStatus,transAddEnroll);
						}
					},
					
					'studentjourneystructureforcoreerp splitbutton[itemId=spBtnMoreActionsSJ] menuitem[itemId=removeEnrollmentSJ]' :{
						click: function(btn){
							var activeTab = this.getContentPanelActiveTab();
							var me = this;
							var grid = activeTab.down('studentjourneycoreerpgrid');
							var combo;
							var periodStatus = 'REMOVE_ENROLLMENT';
							var transRemoveEnroll = getProgramandcourseTranslation('STUDENT_JOURNEY_REMOVE_ENROLLMENT');
							me.changePeriodStatus(combo, grid, periodStatus,transRemoveEnroll);
						}
					},
					'studentjourneystructureforcoreerp splitbutton[itemId=spBtnMoreActionsSJ] menuitem[itemId=addEnrollmentForLastLine]' :{
						click: function(btn){
						    var $this = this;
							$this.addEnrollmentForLastGridRecord();
						}
					},
					
					
					'studentjourneystructureforcoreerp button[itemId=btnRefresh]':{
						click: function(btn){
							var me = this;
							var grid = btn.up('studentjourneycoreerpgrid');
							grid.getSelectionModel().deselectAll();
							grid.getStore().load({
								callback: function(){
									setTimeout(function(){
										grid.up().doLayout();
										 grid.getView().refresh();
						                    var view = grid.getView();
						                    var store = grid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('resultStatus') === 'Exempted'){
						                            var row = view.getRecord(index);
						                            if(row){
														var exemptedRow = grid.view.getNode(row);
														exemptedRow.classList.add('fadeOutRowCls');
						                            }
						                        }
						                    });
									},300);
								}
							});
						}
					},
					
					'enrollmentstatuswin button[itemId=addEnrollmentStatusSubmitBtn]':{
						click: function(btn){
							var activeTab = this.getContentPanelActiveTab();
							var combo = btn.up('window').down('#periodStatus');
							var grid = activeTab.down('studentjourneycoreerpgrid');

							var periodStatus = combo.getValue();
							this.changePeriodStatus(combo, grid, periodStatus,periodStatus);
							
							combo.up('window').close();
						}
					},

					'enrollmentstatuswin button[itemId=enrollmentStatusCancelBtn]':{
						click: function(btn){
							btn.up('window').close();
						}
					},

					'studentjourneysetupgrid button[itemId=btnDelete]':{
						click:this.deleteStudentJourneySetup 
					},

					'studentjourneysetupform':{
						afterrender:function(form){
							var me = this;
							var academyLocationCombo = form.down('#academyLocationCombo');
							var academyLocationStore = academyLocationCombo.getStore();
							//academyLocationStore.load();

						}
					},

					'programbatchcopygrid':{
						afterrender:function(grid){
							var me = this;
							var gridStore = grid.getStore();
							gridStore.load();
						}
					} ,

					'studentjourneysetupgrid':{
						afterrender:function(grid){
							var me = this;
							/*var gridStore = grid.getStore();
							gridStore.getProxy().extraParams = {};
							gridStore.load();*/
							grid.store.removeAll();
						}
					} ,

					'studentjourneysetupform combo[itemId=academyLocationCombo]':{
						select:function(combo){
							var me = this;
							var form = combo.up('studentjourneysetupform');
							var academyLocationId= combo.getValue();
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');
							programCombo.setDisabled(false);
							batchCombo.setDisabled(true);
							programCombo.clearValue();
							programCombo.reset();
							batchCombo.clearValue();
							batchCombo.reset();
							var programStore = programCombo.getStore();

							programStore.getProxy().extraParams = {
								academyLocationIds: academyLocationId
							};
							programStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 1){
											programCombo.setValue(records[0].data.id);	
										}
									}
								}
							});

						}
					},

					'studentjourneysetupform combo[itemId=programId]':{
						select:function(combo){
							var me = this;
							var form = combo.up('studentjourneysetupform');
							var programId= combo.getValue();
							var batchCombo = form.down('#batchId');
							batchCombo.setDisabled(false);
							batchCombo.clearValue();
							batchCombo.reset();
							var batchStore = batchCombo.getStore();

							batchStore.getProxy().extraParams = {
								programId: programId
							};
							batchStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 1){
											batchCombo.setValue(records[0].data.id);	
										}
									}
								}
							});
						}
					},

					'studentjourneysetupform button[itemId=resetBtn]':{
						click:function(btn){
							var me = this;
							var form = btn.up('studentjourneysetupform');
							var academyLocationCombo = form.down('#academyLocationCombo');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');

							academyLocationCombo.clearValue();
							academyLocationCombo.reset();
							programCombo.clearValue();
							programCombo.reset();
							batchCombo.clearValue();
							batchCombo.reset();
							programCombo.setDisabled(true);
							batchCombo.setDisabled(true);
						}
					},

					'studentjourneysetupform button[itemId=searchBtn]':{
						click:function(btn){
							var me = this;
							var structure = btn.up('studentjourneysetupformandgridstructure');
							var form = structure.down('studentjourneysetupform');
							var grid = structure.down('studentjourneysetupgrid');
							var gridStore= grid.getStore();

							var academyLocationCombo = form.down('#academyLocationCombo');
							var programCombo = form.down('#programId');
							var batchCombo = form.down('#batchId');

							var alId = academyLocationCombo.getValue();
							var programId = programCombo.getValue();
							var batchId = batchCombo.getValue();

							gridStore.getProxy().extraParams={
								academyLocationId : alId,
								programId : programId,
								batchId:batchId
							};

							gridStore.load();

						}
					} ,

					'studentjourneysetupwin':{
						afterrender: function(win){
							if(!isNullOrEmpty(win.selectedRec)){
								var selectedRec = win.selectedRec;
								win.down('#programId').setDisabled(false);
								win.down('#batchId').setDisabled(false);
								win.down('#academicTermSequenceId').setValue(selectedRec.raw.academicTermSeq);
								win.down('#minAcademicTermId').setValue(selectedRec.raw.minAcademicTerm);
								win.down('#maxAcademicTermId').setValue(selectedRec.raw.maxAcademicTerm);
								win.down('#academyLocationId').getStore().load({
									callback: function(){
										win.down('#academyLocationId').setValue(selectedRec.raw.academyLocationId);
										win.down('#programId').getStore().getProxy().extraParams = {
											academyLocationIds: selectedRec.raw.academyLocationId
										};
										win.down('#programId').getStore().load({
											callback: function(){
												win.down('#programId').setValue(selectedRec.raw.programId);
												win.down('#batchId').getStore().getProxy().extraParams = {
													programId: selectedRec.raw.programId
												};
												win.down('#batchId').getStore().load({
													callback: function(){
														win.down('#batchId').setValue(selectedRec.raw.batchId);
													}
												});

											}
										});
									}
								});
							}
						}
					},

					'studentjourneysetupgrid button[itemId=btnAdd]':{
						click: function(btn){
							me=this;
							var win=me.getStudentjourneysetupwin();
							if(!win){
								Ext.widget('studentjourneysetupwin');
								win=me.getStudentjourneysetupwin();
							}
							win.selectedRec = null;
							win.show();
						}
					},

					'studentjourneysetupgrid button[itemId=btnEdit]':{
						click: function(btn){
							me=this;
							var grid=btn.up('studentjourneysetupgrid');
							var selectedRecord = grid.getSelectionModel().getSelection();

							if(selectedRecord.length){
								var win=me.getStudentjourneysetupwin();
								if(!win){
									Ext.widget('studentjourneysetupwin');
									win=me.getStudentjourneysetupwin();
								}
								win.selectedRec = selectedRecord[0];
								win.show();
							}
							else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},

					'studentjourneysetupgrid button[itemId=btnView]':{
						click: function(btn){
							me=this;
							var grid=btn.up('studentjourneysetupgrid');
							var selectedRecord = grid.getSelectionModel().getSelection();
							if(selectedRecord.length){
								var win=me.getStudentjourneysetupwin();
								if(!win){
									Ext.widget('studentjourneysetupwin');
									win=me.getStudentjourneysetupwin();
								}
								win.selectedRec = selectedRecord[0];
								win.show();

								if (win) {
									var form = win.down('form');
									form.down('#studentJourneySetupSubmitBtn').setVisible(false);
									form = form.getForm();
									toggleReadOnlyFormItems(form, true);
								}

							}
							else{
								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							}
						}
					},

					'studentjourneysetupwin combo[itemId=academyLocationId]':{
						select:function(combo){
							var me = this;
							var win=me.getStudentjourneysetupwin();
							var academyLocationId= combo.getValue();
							var programCombo = win.down('#programId');
							var batchCombo = win.down('#batchId');
							programCombo.setDisabled(false);
							batchCombo.setDisabled(true);
							programCombo.clearValue();
							programCombo.reset();
							batchCombo.clearValue();
							batchCombo.reset();
							var programStore = programCombo.getStore();

							programStore.getProxy().extraParams = {
								academyLocationIds: academyLocationId
							};
							programStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 1){
											programCombo.setValue(records[0].data.id);
											batchCombo.setDisabled(false);
											var batchStore = batchCombo.getStore();
											batchStore.getProxy().extraParams = {
												programId: programCombo.getValue()
											};
											batchStore.load({
												callback: function(records, operation, success) {
													if (success) {
														if(records.length == 1){
															batchCombo.setValue(records[0].data.id);	
														}
													}
												}
											});
										}
									}
								}
							});
							
							

						}
					},

					'studentjourneysetupwin combo[itemId=programId]':{
						select:function(combo){
							var me = this;
							var win=me.getStudentjourneysetupwin();
							var programId= combo.getValue();
							var batchCombo = win.down('#batchId');
							batchCombo.setDisabled(false);
							batchCombo.clearValue();
							batchCombo.reset();
							var batchStore = batchCombo.getStore();

							batchStore.getProxy().extraParams = {
								programId: programId
							};
							batchStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length == 1){
											batchCombo.setValue(records[0].data.id);	
										}
									}
								}
							});
						}
					},

					'studentjourneysetupwin button[itemId=studentJourneySetupCancelBtn]':{
						click:function(btn){
							var me = this;
							var win=me.getStudentjourneysetupwin();
							win.close();
						}
					},

					'studentjourneysetupwin button[itemId=studentJourneySetupSubmitBtn]':{
						click:function(btn){
							var me = this;
							var activeTab = this.getContentPanelActiveTab();
							var win=btn.up('studentjourneysetupwin');
							var grid=activeTab.down('studentjourneysetupgrid');
							var form = activeTab.down('studentjourneysetupform');
							var frmAcademyLocationCombo = form.down('#academyLocationCombo');
							var frmProgramCombo = form.down('#programId');
							var frmBatchCombo = form.down('#batchId');
							frmProgramCombo.setDisabled(true);
							frmBatchCombo.setDisabled(true);
							frmAcademyLocationCombo.reset();
							frmProgramCombo.reset();
							frmBatchCombo.reset();
							var academyLocationCombo = win.down('#academyLocationId');
							var programCombo = win.down('#programId');
							var batchCombo = win.down('#batchId');
							var academicTermSeqCombo = win.down('#academicTermSequenceId');
							var minAcademicTermCombo = win.down('#minAcademicTermId');
							var maxAcademicTermCombo = win.down('#maxAcademicTermId');
							var alId = academyLocationCombo.getValue();
							var programId = programCombo.getValue();
							var batchId = batchCombo.getValue();
							var academicTermSeq =academicTermSeqCombo.getValue();
							var minAcademicTerm =minAcademicTermCombo.getValue();
							var maxAcademicTerm =maxAcademicTermCombo.getValue();

							if(isNullOrEmpty(win.selectedRec)){


								var submitValue={
										"academyLocation":{
											"id":alId
										},
										"program":{
											"id":programId
										},
										"batch":{
											"id":batchId
										},
										academicTermSeq:academicTermSeq,
										minAcademicTerm:minAcademicTerm,
										maxAcademicTerm:maxAcademicTerm
								};

								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_STUDENT_JOURNEY_SETTING_SAVE,
									jsonData:submitValue,
									method : 'POST',
									success: function(f, action) {
										var data = f.responseText;
										grid.getStore().getProxy().extraParams = {

										};
										if(data == "SUCCESS"){
											showSuccessMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getCommonTranslation('SUCCESS'));
											grid.getStore().load();
											grid.getSelectionModel().deselectAll();
											win.close();
										}else if("Already Exists"){
											showWarningMessage(getCommonTranslation('ALERT'), 
													getErrorTranslation('RECORD_ALREADY_EXIST'));
											grid.getStore().load();
											grid.getSelectionModel().deselectAll();
											win.close();
										}
									},
									failure: function(result, request) {
										showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
										return false;
									}
								});
							}else{
								var submitValue={
										"academyLocation":{
											"id":alId
										},
										"program":{
											"id":programId
										},
										"batch":{
											"id":batchId
										},
										academicTermSeq:academicTermSeq,
										minAcademicTerm:minAcademicTerm,
										maxAcademicTerm:maxAcademicTerm,
										id:win.selectedRec.raw.id,
								};

								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_STUDENT_JOURNEY_SETTING_UPDATE,
									jsonData:submitValue,
									method : 'POST',
									success: function(f, action) {
										var data = f.responseText;
										if(data == "SUCCESS"){
											showSuccessMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
											grid.getStore().reload();
											grid.getSelectionModel().deselectAll();
											win.close();
										}else if(data == "Student Journey already created can not update"){
											showWarningMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION_STUDENT_JOURNEY'));	
										}else if("Already Exists"){
											showWarningMessage(getCommonTranslation('ALERT'), 
													getErrorTranslation('RECORD_ALREADY_EXIST'));
											grid.getStore().reload();
											grid.getSelectionModel().deselectAll();
											win.close();
										}
									},
									failure: function(result, request) {
										showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
										return false;
									}
								});
							}
						}
					},

					'studentjourneyenrollmentstatussettinggrid' :{
						afterrender: function(grid){
							var me = this;
							var gridStore = grid.getStore();
							
							gridStore.proxy.extraParams = '';
							gridStore.removeAll();
							gridStore.load();
						},					
					},					
					'studentjourneyenrollmentstatussettinggrid [itemId=isVisibleCheckColumn]':{
						checkchange:function (column, rowIndex, checked, eOpts) {                 
							var grid = column.up('grid');  
							var modifiedRecords = grid.store.getModifiedRecords();
							var button = grid.down('#btnSaveItemId');
							if(modifiedRecords.length){
								button.setDisabled(false);
							}else{
								button.setDisabled(true);
							}
						 }
							 
						},

					'studentjourneyenrollmentstatussettinggrid button[itemId=btnSaveItemId]':{
						click: function(btn){
							var me = this;
							var grid = btn.up('studentjourneyenrollmentstatussettinggrid');
							var modifiedRecords = grid.store.getModifiedRecords();
							if(modifiedRecords){
								me.updateEnrollmentSettingStatus(grid, modifiedRecords);
							}

						}
					},
'studentjourneydashboardsetting': {
	afterrender:function(){
		var academyLocationId = this.getCurrentAcademyLocation()
		var form = this.getStudentjourneydashboardsetting();
		
		var studentJourneyShowHide = form.down('radiogroup');

		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
			method : 'GET',
			params:{
				academyLocationId:academyLocationId ,
			},
			success: function(f, action) {
				var data = f.responseText;
				if(data == "true"){	
					form.getForm().findField("StudentJourneyShowHide").setValue(true);

				}else{
					form.getForm().findField("StudentJourneyShowHide").setValue(false);
				}
			},
			failure: function(result, request) {
				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
				return false;
			}
		});
	}
},
					'studentjourneydashboardsetting button[itemId=saveBtn]':{							
						click: function(btn){
							var form = this.getStudentjourneydashboardsetting().getForm();
							var studentJourneyInput = form.getValues();				
							var academyLocationId = this.getCurrentAcademyLocation();
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.PATH_SAVE_STUDENT_JOURNEY_DASHBOARD_SETTING+'?academyLocationId='+academyLocationId+'&isVisible='+ studentJourneyInput.StudentJourneyShowHide,
								method : 'POST',
								success: function(f, action) {
									var data = f.responseText;
									if(data == "SUCCESS"){										
										showSuccessMessage(getProgramandcourseTranslation('Transaction Success'))
									}
								},
								failure: function(result, request) {
									showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
									return false;
								}
							});
						
							
						}
					},

				});
			},

			removeMask: function () {
				var mask = document.getElementById('fullscreen-mask');
				if (mask && mask.parentNode) {
					mask.parentNode.removeChild(mask);
				}
			},

			deleteStudentJourneySetup : function(btn){
				var $this = this; 
				var grid = btn.up('studentjourneysetupgrid');
				var grdStore = grid.getStore();  

				if(grid.getSelectionModel().getCount()>0){
					showConfirmMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							var records=grid.getSelectionModel().getSelection();						        
							var id=records[0].get("id");
							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url: SERVERURL.PATH_STUDENT_JOURNEY_SETTING_DELETE+'?id='+id,
								headers: {
									'Content-Type': 'application/json'
								},
								success:function(response){
									var MSSG = response.responseText;
									if(MSSG=="dependency exist"){
										showWarningMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getCourseTxCommonTranslation('DEPENDENCY_EXIST'));
									}else if(MSSG=="Student Journey already created can not delete"){
										showWarningMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION_STUDENT_JOURNEY'));
									}
									else{
										grdStore.reload();
										showSuccessMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getCommonTranslation('SUCCESS'));
										grid.getStore().reload();
										grid.getSelectionModel().deselectAll();
									}}
							});
						}
					});
				}else{
					showWarningMessage(getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
				}
			},
			
			changeAddedStatus:function(combo, grid, addedStatus){
				var selectedRecord = grid.getSelectionModel().getSelection()[0];
				var selectedRow = grid.view.getNode(selectedRecord);
				var allRows = grid.view.getNodes();
				
				var addedStatusArray = combo.getValue();
				if(addedStatusArray && addedStatusArray.length && addedStatusArray[0]!=''){
					selectedRecord.set('studentJourneyAddedStatusDetails',addedStatusArray);
				}
				else{
					selectedRecord.set('studentJourneyAddedStatusDetails',[]);
				}
				
				//Removing All fadeOutRowCls, hiddenRowDataCls Cls
				Ext.each(allRows, function(currentRow){
					currentRow.classList.remove('fadeOutRowCls');
				});

				selectedRow.classList.remove('hiddenRowDataCls');

				Ext.each(allRows, function(currentRow){
					currentRow.classList.add('fadeOutRowCls');
				});

				//Remove fadeOutRowCls from current row
				selectedRow.classList.remove('fadeOutRowCls');
			},

			changePeriodStatus: function(combo, grid, periodStatus,transPeriodStatus){
				var selectedRecord = grid.getSelectionModel().getSelection()[0];
				var selectedRow = grid.view.getNode(selectedRecord);
				if(selectedRecord && (periodStatus == 'ADD_ENROLLMENT' || periodStatus == 'REMOVE_ENROLLMENT'|| periodStatus == 'EXEMPT')){
					var admissionId = selectedRecord.data.admissionId;
					var studentId = selectedRecord.data.studentId;
					var periodId = selectedRecord.data.periodId;
					var studentJourneyId = selectedRecord.data.id;
					var isOpenServiceRequest = false;
					
					Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_FIND_EXCHANGE_SUSPENSION,
						params : {
							studentJourneyId:studentJourneyId,
							admissionId: admissionId,
							studentId:studentId,
							periodId:periodId
						},
						async: false,
						method : 'GET',
						success : function(response) {
							var responseData = Ext.decode(response.responseText);
                            isOpenServiceRequest = responseData;
						}
					});
					
					Ext.getBody().unmask();
				    if(isOpenServiceRequest == true){
							grid.getSelectionModel().deselectAll();
							grid.getStore().load({
								callback: function(){
									setTimeout(function(){
										grid.up().doLayout();
										 grid.getView().refresh();
						                    var view = grid.getView();
						                    var store = grid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('resultStatus') === 'Exempted'){
						                            var row = view.getRecord(index);
						                            if(row){
														var exemptedRow = grid.view.getNode(row);
														exemptedRow.classList.add('fadeOutRowCls');
						                            }
						                        }
						                    });
									},300);
								}
							});
							if(periodStatus == 'ADD_ENROLLMENT')
							{
								showWarningMessage(getCommonTranslation('STUDENT_JOURNEY'),getCommonTranslation('EXCHANGE_SUSPENSION_REQ_MSG_ADD'));//Please select a record
								return false;
							}
							else if(periodStatus == 'REMOVE_ENROLLMENT')
							{
								showWarningMessage(getCommonTranslation('STUDENT_JOURNEY'),getCommonTranslation('EXCHANGE_SUSPENSION_REQ_MSG_REMOVE'));//Please select a record
								return false;
							}
							else if(periodStatus == 'EXEMPT')
							{
								showWarningMessage(getCommonTranslation('STUDENT_JOURNEY'),getCommonTranslation('EXCHANGE_SUSPENSION_REQ_MSG_EXEMPT'));//Please select a record
								return false;
							}
					}
					
				}
				if(selectedRecord && (periodStatus == 'OUT_OF_SEQUENCE'|| periodStatus =='RETAKE_OF_A_SEMESTER'
				|| periodStatus =='RESIT'  || periodStatus =='DEFERRED_RETAKE'  || periodStatus =='DEFERRED' )){
					var admissionId = selectedRecord.data.admissionId;
					var studentId = selectedRecord.data.studentId;
					var periodId = selectedRecord.data.periodId;
					var type = "";

					Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_FIND_PT_FOR_OOS,
						params : {
							admissionId: admissionId,
							studentId:studentId,
							periodId:periodId
						},
						async: false,
						method : 'GET',
						success : function(response) {
							var responseData = response.responseText;
							type = responseData;
						}
					});

					Ext.getBody().unmask();
					if(!isNullOrEmpty(type) && type != "" && type =="PROGRAM_TRANSFER"){
						grid.getSelectionModel().deselectAll();
						grid.getStore().load({
							callback: function(){
								setTimeout(function(){
									grid.up().doLayout();
									grid.getView().refresh();
									var view = grid.getView();
									var store = grid.getStore();
									store.each(function(record, index){
										if(record.get('resultStatus') === 'Exempted'){
											var row = view.getRecord(index);
											if(row){
												var exemptedRow = grid.view.getNode(row);
												exemptedRow.classList.add('fadeOutRowCls');
											}
										}
									});
								},300);
							}
						});
						if(periodStatus == 'OUT_OF_SEQUENCE' || periodStatus =='RETAKE_OF_A_SEMESTER'
						|| periodStatus =='RESIT'  || periodStatus =='DEFERRED_RETAKE'  || periodStatus =='DEFERRED')
						{
							showWarningMessage(getCommonTranslation('STUDENT_JOURNEY'),getCommonTranslation("PROGRAM_TRANSFER_REQUEST_EXIST_FOR_CURRENT_OR_FUTURE"));
							return false;
						}
					}

				}
					
				var allRows = grid.view.getNodes();
				//Removing All fadeOutRowCls, hiddenRowDataCls Cls
				Ext.each(allRows, function(currentRow){
					currentRow.classList.remove('fadeOutRowCls');
				});

				selectedRow.classList.remove('hiddenRowDataCls');

				this.setCurrentRowDefaultValues(selectedRecord, periodStatus,transPeriodStatus);

				switch(periodStatus){
				case "REGULAR":
					// -- No Action required here
					break;
				case "OUT_OF_SEQUENCE":
					//Add fadeOutRowCls on All
					Ext.each(allRows, function(currentRow){
						currentRow.classList.add('fadeOutRowCls');
					});

					//Remove fadeOutRowCls from current row
					selectedRow.classList.remove('fadeOutRowCls');
					selectedRecord.data.isAcademicTermEditable=true;
					break;
				case "PROGRAM_TRANSFER":
					//Add fadeOutRowCls on All
					Ext.each(allRows, function(currentRow){
						currentRow.classList.add('fadeOutRowCls');
					});

					//Remove fadeOutRowCls from current row
					selectedRow.classList.remove('fadeOutRowCls');
					break;
				case "EXCHANGE_SEMESTER":
					//Add fadeOutRowCls on All
					Ext.each(allRows, function(currentRow){
						currentRow.classList.add('fadeOutRowCls');
					});

					//Remove fadeOutRowCls from current row
					selectedRow.classList.remove('fadeOutRowCls');
					selectedRecord.data.isAcademicTermEditable=true;
					break;
				case "LEAVE_OF_ABSENCE":
					//Add fadeOutRowCls on All
					Ext.each(allRows, function(currentRow){
						currentRow.classList.add('fadeOutRowCls');
					});

					//Remove fadeOutRowCls from current row
					selectedRow.classList.remove('fadeOutRowCls');

					//Add hiddenRowDataCls on Current Row
					selectedRow.classList.add('hiddenRowDataCls');

					break;
				case "DIRECT_ENTRY":
					if(selectedRecord.raw.programPeriodSeq == 1){
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_DIRECT_MSG'));
						return false;
					}
					break;
				case "RETAKE_OF_A_SEMESTER":

					var allRecords = grid.store.getRange();
					var isLastSem = true;

					Ext.each(allRecords, function(cAllRecords){
						if(selectedRecord.data.programJourneySeq == cAllRecords.data.programJourneySeq){
							if(selectedRecord.data.programPeriodSeq < cAllRecords.data.programPeriodSeq){
								isLastSem = false;
							}
						}
					});

					if(selectedRecord.data.progressionStatus == "Retake" || (selectedRecord.data.progressionStatus == "Proceed with Condition")){
						//Add fadeOutRowCls on All
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						//Remove fadeOutRowCls from current row
						selectedRow.classList.remove('fadeOutRowCls');

						/*if(isLastSem == true){
						var progressionStatus = 'Proceed with Condition';
					}
					else{
						var progressionStatus = 'Retake';
					}*/

						var progressionStatus = selectedRecord.data.progressionStatus;

						selectedRecord.data.progressionStatus = progressionStatus;
					}
					else{
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);

						if(selectedRecord.raw.periodStatus != "RETAKE_OF_A_SEMESTER"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_RETAKE_MSG'));
						}
					}

					break;
				case "RESIT":

					var allRecords = grid.store.getRange();
					var isLastSem = true;

					Ext.each(allRecords, function(cAllRecords){
						if(selectedRecord.data.programJourneySeq == cAllRecords.data.programJourneySeq){
							if(selectedRecord.data.programPeriodSeq < cAllRecords.data.programPeriodSeq){
								isLastSem = false;
							}
						}
					});

					if(selectedRecord.data.progressionStatus == "Resit" || (selectedRecord.data.progressionStatus == "Proceed with Condition")){
						//Add fadeOutRowCls on All
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						//Remove fadeOutRowCls from current row
						selectedRow.classList.remove('fadeOutRowCls');

						/*if(isLastSem == true){
						var progressionStatus = 'Proceed with Condition';
					}
					else{
						var progressionStatus = 'Retake';
					}*/

						var progressionStatus = selectedRecord.data.progressionStatus;

						selectedRecord.data.progressionStatus = progressionStatus;
					}
					else{
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);

						if(selectedRecord.raw.periodStatus != "RESIT"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_RESIT_MSG'));
							grid.store.load();
						}
					}

					break;
					//proceed with condition
					
					case "PROCEED_WITH_CONDITION":

					var allRecords = grid.store.getRange();
					var isLastSem = true;

					Ext.each(allRecords, function(cAllRecords){
						if(selectedRecord.data.programJourneySeq == cAllRecords.data.programJourneySeq){
							if(selectedRecord.data.programPeriodSeq < cAllRecords.data.programPeriodSeq){
								isLastSem = false;
							}
						}
					});

					if(selectedRecord.data.progressionStatus = 'Proceed with condition' && isLastSem){
						//Add fadeOutRowCls on All
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						//Remove fadeOutRowCls from current row
						selectedRow.classList.remove('fadeOutRowCls');

						/*if(isLastSem == true){
						var progressionStatus = 'Proceed with Condition';
					}
					else{
						var progressionStatus = 'Retake';
					}*/

						var progressionStatus = selectedRecord.data.progressionStatus;

						selectedRecord.data.progressionStatus = progressionStatus;
					}
					else{
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);

						if(selectedRecord.raw.periodStatus != "PROCEED_WITH_CONDITION"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_PROCEED_WITH_CONDITION_MSG'));
						}
					}
					break;
					case "DEFERRED_RETAKE":

					var allRecords = grid.store.getRange();
					var isLastSem = true;

					Ext.each(allRecords, function(cAllRecords){
						if(selectedRecord.data.programJourneySeq == cAllRecords.data.programJourneySeq){
							if(selectedRecord.data.programPeriodSeq < cAllRecords.data.programPeriodSeq){
								isLastSem = false;
							}
						}
					});

					if(selectedRecord.data.progressionStatus=="Deferred Retake"){
						
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						selectedRow.classList.remove('fadeOutRowCls');

						var progressionStatus = selectedRecord.data.progressionStatus;

						selectedRecord.data.progressionStatus = progressionStatus;
					}
					else{
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);

						if(selectedRecord.raw.periodStatus != "DEFERRED_RETAKE"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_DEFERRED_RETAKE_MSG'));
						}
					}

					break;
					case "ADD_ENROLLMENT":
						//Add fadeOutRowCls on All
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						//Remove fadeOutRowCls from current row
						selectedRow.classList.remove('fadeOutRowCls');
						selectedRecord.data.isAcademicTermEditable=true;
						break;
						
					case "REMOVE_ENROLLMENT":
						//Add fadeOutRowCls on All
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						//Remove fadeOutRowCls from current row
						selectedRow.classList.remove('fadeOutRowCls');
						break;
					
					case "DEFERRED":
					var allRecords = grid.store.getRange();
					var isLastSem = true;

					Ext.each(allRecords, function(cAllRecords){
						if(selectedRecord.data.programJourneySeq == cAllRecords.data.programJourneySeq){
							if(selectedRecord.data.programPeriodSeq < cAllRecords.data.programPeriodSeq){
								isLastSem = false;
							}
						}
					});

					if(selectedRecord.data.progressionStatus=="Deferred"){
						
						Ext.each(allRows, function(currentRow){
							currentRow.classList.add('fadeOutRowCls');
						});

						selectedRow.classList.remove('fadeOutRowCls');

						var progressionStatus = selectedRecord.data.progressionStatus;

						selectedRecord.data.progressionStatus = progressionStatus;
					}
					else{
						selectedRecord.set(periodStatus, selectedRecord.raw.periodStatus);
						combo.setValue(selectedRecord.raw.periodStatus);

						if(selectedRecord.raw.periodStatus != "DEFERRED"){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_DEFERRED_MSG'));
							 grid.getStore().reload();
    						 grid.getView().refresh();
						}
					}
					break;
					//
					
				}
			},
			submitStudentJourney: function(btn){
				var me = this;
				var structure = btn.up('studentjourneystructureforcoreerp');
				//var filterForm = structure.down('studentjourneysearchform');
				var studentJourneyGrid = structure.down('studentjourneycoreerpgrid');
				var gridStore = studentJourneyGrid.getStore();
				var visibleColumns = studentJourneyGrid.down('headercontainer').getVisibleGridColumns();
				var modifiedRecords = studentJourneyGrid.store.getModifiedRecords();
				var regularAladmissionId = null;
				
				gridStore.data.items.forEach(function(item) {
					if (!isNullOrEmpty(item.raw) && item.raw.periodStatus !== "EXCHANGE_SEMESTER" && modifiedRecords[0].data.academicLocationId!= item.data.academicLocationId) {
						regularAladmissionId = item.data.admissionId;
					}
				});	
				
				if(modifiedRecords[0].data.periodStatus != 'EXCHANGE_SEMESTER' && modifiedRecords[0].data.periodStatus != 'EXEMPT'
				 && modifiedRecords[0].data.periodStatus != 'OUT_OF_SEQUENCE'){
				var modifiedIndex = gridStore.indexOf(modifiedRecords[0]);
				var hasLaterRecord = false;
                      
				for (var i = modifiedIndex + 1; i < gridStore.data.items.length; i++) {
					var item = gridStore.data.items[i];
					if (!isNullOrEmpty(item.raw) && item.raw.resultStatus.startsWith("Withdrawn")) {
						hasLaterRecord = true;
						break;
					}
				}

				if (hasLaterRecord) {
		           showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_CHECK_PROGRAM_WITHDRAWN_REQUEST'));
				   Ext.getBody().unmask();
				   studentJourneyGrid.getSelectionModel().deselectAll();
				   studentJourneyGrid.getStore().load();
				   return;
				}
				}
				
				var isVisibleSeatTypeColumn= false;
				var transAddEnrollPeriodStatus = getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT');
				var transRemoveEnrollPeriodStatus = getProgramandcourseTranslation('STUDENT_JOURNEY_REMOVE_ENROLLMENT');
                var isPeriodStatusForCampusAndAddedStatus = '';

                gridStore.load({
								callback: function(){
										studentJourneyGrid.up().doLayout();
										 studentJourneyGrid.getView().refresh();
						                    var view = studentJourneyGrid.getView();
						                    var store = studentJourneyGrid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('id') === modifiedRecords[0].data.id && record.get('periodStatus') == modifiedRecords[0].data.periodStatus
						                        && (record.get('campusName')!= modifiedRecords[0].data.campusName || record.get('addedStatus')!= modifiedRecords[0].data.addedStatus)){
						                            isPeriodStatusForCampusAndAddedStatus = "REGULAR";
						                        }
						                    });
								 }
					           });
				
				var data = {};
				if(modifiedRecords.length){
					showConfirmMessage(getCommonTranslation('STUDENT_JOURNEY'), getCommonTranslation('STUDENT_JOURNEY_CONFIRM_CHANGES_MSG'), function (btn, text){
                        if (btn == 'yes') {
        					var periodStatus = modifiedRecords[0].data.periodStatus;
        					if(isPeriodStatusForCampusAndAddedStatus === 'REGULAR'){
        					periodStatus = 'REGULAR';
        					}
        					Ext.each(visibleColumns, function(record) {
        						if( record.dataIndex=='seatType'){
        							isVisibleSeatTypeColumn=true;
        						}
        					});
        					
        					var addedStatus = [];
        					Ext.each(modifiedRecords[0].data.addedStatus, function(currentAddedStatus){
        						if(!isNullOrEmpty(currentAddedStatus)){
        							if(typeof currentAddedStatus == "object"){
        								var addedStatusId = currentAddedStatus.data.id;
        							}
        							else{
        								var addedStatusId = currentAddedStatus;
        							}
        							
        							if(!isNullOrEmpty(addedStatusId)){
        								addedStatus.push({
        									"studentJourneyAddedStatus":{
        										"id":addedStatusId
        									}
        								});
        							}
        						}
        						
        					});
        					
        					if(!isVisibleSeatTypeColumn && modifiedRecords[0].data.batchId && 
        							(periodStatus == "PROGRAM_TRANSFER" || periodStatus == "EXCHANGE_SEMESTER") ){
        						var seatTypeStore = me.getStore('facilitiesresources.resourcebooking.SeatTypeByBatchStore');
        						seatTypeStore.getProxy().extraParams = {
        							batchId: modifiedRecords[0].data.batchId
        						},

        						seatTypeStore.load({
        							callback: function(records, operation, success) {
        								if (success) {
        									if(records.length > 0){
        										modifiedRecords[0].data.seatTypeId =records[0].data.id;	
        									}else{
        										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEAT_TYPE_NOT_FOUND'));
        									}
        								}
        							}
        						});
        					}
        					
        					setTimeout(function(){
        					switch(periodStatus){
        						case "REGULAR":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId": modifiedRecords[0].data.academicTermId,
        								"academicTermSeq": modifiedRecords[0].data.academicTermSeq,
        								"programId": modifiedRecords[0].data.programId,
        								"academicLocationId": modifiedRecords[0].data.academicLocationId,
        								"periodId": modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq": modifiedRecords[0].data.programPeriodSeq,
        								"batchId": modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId": modifiedRecords[0].data.admissionId,
        								"studentId": modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus
        							}
        							break;
        						case "OUT_OF_SEQUENCE":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId": modifiedRecords[0].data.academicTermId,
        								"academicTermSeq": modifiedRecords[0].data.academicTermSeq,
        								"programId": modifiedRecords[0].data.programId,
        								"academicLocationId": modifiedRecords[0].data.academicLocationId,
        								"periodId": modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq": modifiedRecords[0].data.programPeriodSeq,
        								"batchId": modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId": modifiedRecords[0].data.admissionId,
        								"studentId": modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus
        							}
        							/*if(modifiedRecords[0].data.periodId == modifiedRecords[0].raw.periodId){
        								data = {};
        							}*/
        							break;
        						case "PROGRAM_TRANSFER":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId": modifiedRecords[0].data.academicTermId,
        								"academicTermSeq": modifiedRecords[0].data.academicTermSeq,
        								"programId": modifiedRecords[0].data.programId,
        								"academicLocationId": modifiedRecords[0].data.academicLocationId,
        								"periodId": modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq": modifiedRecords[0].data.programPeriodSeq,
        								"batchId": modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId": modifiedRecords[0].data.admissionId,
        								"studentId": modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus
        							}
        							break;
        						case "EXCHANGE_SEMESTER":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"isStudentJourney" : true,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"resultStatus" : modifiedRecords[0].raw.resultStatus 
        							}
        							break;
        						case "LEAVE_OF_ABSENCE":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus":modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"regularAlAdmId" : regularAladmissionId
        							}
        							break;
        						case "DIRECT_ENTRY":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus
        							}
        							break;
        						case "RETAKE_OF_A_SEMESTER":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"regularAlAdmId" : regularAladmissionId
        							}
        							break;
        						case "RESIT":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"regularAlAdmId" : regularAladmissionId
        							}
        							break;
        							case "PROCEED_WITH_CONDITION":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].raw.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus
        							}
        							break;
        							case "DEFERRED_RETAKE":
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"regularAlAdmId" : regularAladmissionId
        							}
        							break;
        							case transAddEnrollPeriodStatus:
        							data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? "ADD_ENROLLMENT" : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"resultStatus":modifiedRecords[0].raw.resultStatus
        							}
        							break;
        							case transRemoveEnrollPeriodStatus:
        								data = {
        									"id": modifiedRecords[0].raw.id,
        									"academicTermId":modifiedRecords[0].data.academicTermId,
        									"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        									"programId":modifiedRecords[0].data.programId,
        									"academicLocationId":modifiedRecords[0].data.academicLocationId,
        									"periodId":modifiedRecords[0].data.periodId,
        									"campusId": modifiedRecords[0].data.campusId,
        									"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        									"batchId":modifiedRecords[0].data.batchId,
        									"periodStatus": modifiedRecords[0].modified.periodStatus ? "REMOVE_ENROLLMENT" : "REGULAR",
        									"seatTypeId": modifiedRecords[0].data.seatTypeId,
        									"progressionStatus": modifiedRecords[0].data.progressionStatus,
        									"admissionId":modifiedRecords[0].data.admissionId,
        									"studentId":modifiedRecords[0].data.studentId,
        									"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        									"fromProgramId":modifiedRecords[0].raw.programId,
        									"fromBatchId":modifiedRecords[0].raw.batchId,
        									"fromPeriodId":modifiedRecords[0].raw.periodId,
        									"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        									"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        									"studentJourneyAddedStatusDetails":addedStatus
        								}
        								break;
        								case "EXEMPT":
        								data = {
        									"id": modifiedRecords[0].raw.id,
        									"academicTermId":modifiedRecords[0].data.academicTermId,
        									"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        									"programId":modifiedRecords[0].data.programId,
        									"academicLocationId":modifiedRecords[0].data.academicLocationId,
        									"periodId":modifiedRecords[0].data.periodId,
        									"campusId": modifiedRecords[0].data.campusId,
        									"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        									"batchId":modifiedRecords[0].data.batchId,
        									"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        									"seatTypeId": modifiedRecords[0].data.seatTypeId,
        									"progressionStatus": modifiedRecords[0].data.progressionStatus,
        									"admissionId":modifiedRecords[0].data.admissionId,
        									"studentId":modifiedRecords[0].data.studentId,
        									"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        									"fromProgramId":modifiedRecords[0].raw.programId,
        									"fromBatchId":modifiedRecords[0].raw.batchId,
        									"fromPeriodId":modifiedRecords[0].raw.periodId,
        									"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        									"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        									"studentJourneyAddedStatusDetails":addedStatus,
        									"resultStatus" : modifiedRecords[0].raw.resultStatus
        								}
        								break;
        								case "addEnrollmentForLastLine":
        								data = {
        									"academicTermId":modifiedRecords[0].data.academicTermId,
        									"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        									"programId":modifiedRecords[0].data.programId,
        									"academicLocationId":modifiedRecords[0].data.academicLocationId,
        									"periodId":modifiedRecords[0].data.periodId,
        									"campusId": modifiedRecords[0].data.campusId,
        									"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        									"batchId":modifiedRecords[0].data.batchId,
        									"periodStatus": "addEnrollmentForLastLine",
        									"progressionStatus": modifiedRecords[0].data.progressionStatus,
        									"admissionId":modifiedRecords[0].data.admissionId,
        									"studentId":modifiedRecords[0].data.studentId,
        									"studentJourneyAddedStatusDetails":addedStatus,
        									"programBatchPrefix" : modifiedRecords[0].data.programBatchPrefix,
        									"programBatchSeq"  : modifiedRecords[0].data.programBatchSeq,
        									"seatTypeId" : ""
        								}
        								break;
        								
										case "DEFERRED":
										data = {
        								"id": modifiedRecords[0].raw.id,
        								"academicTermId":modifiedRecords[0].data.academicTermId,
        								"academicTermSeq":modifiedRecords[0].data.academicTermSeq,
        								"programId":modifiedRecords[0].data.programId,
        								"academicLocationId":modifiedRecords[0].data.academicLocationId,
        								"periodId":modifiedRecords[0].data.periodId,
        								"campusId": modifiedRecords[0].data.campusId,
        								"programPeriodSeq":modifiedRecords[0].data.programPeriodSeq,
        								"batchId":modifiedRecords[0].data.batchId,
        								"periodStatus": modifiedRecords[0].modified.periodStatus ? modifiedRecords[0].data.periodStatus : "REGULAR",
        								"seatTypeId": modifiedRecords[0].data.seatTypeId,
        								"progressionStatus": modifiedRecords[0].data.progressionStatus,
        								"admissionId":modifiedRecords[0].data.admissionId,
        								"studentId":modifiedRecords[0].data.studentId,
        								"fromAcademicLocationId": modifiedRecords[0].raw.academicLocationId,
        								"fromProgramId":modifiedRecords[0].raw.programId,
        								"fromBatchId":modifiedRecords[0].raw.batchId,
        								"fromPeriodId":modifiedRecords[0].raw.periodId,
        								"fromSeatTypeId":modifiedRecords[0].raw.seatTypeId,
        								"programJourneySeq": modifiedRecords[0].raw.programJourneySeq,
        								"studentJourneyAddedStatusDetails":addedStatus,
        								"regularAlAdmId" : regularAladmissionId
									}
									break;
        					}
        					if(Object.keys(data).length){
        						if(data.batchId && data.periodId){
        							me.saveStudentJourney(data, studentJourneyGrid);
        						}
        						else{
        							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS')); 
        							return false;
        						}
        					}
        					else{
        						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NO_RECORD_TO_SAVE_MSG')); 
        						return false;
        					}},1500);
        				
						}
					  });
				}
			
				else{
					showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NO_RECORD_TO_SAVE_MSG')); 
					return false;
				}
			},

			saveStudentJourney: function(data, jGrid){
				var me = this;
				var	submitUrl=SERVERURL.PATH_STUDENTJOURNEY_UPDATE;
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : data,
					method : 'POST',
					success : function(form, action) {
						Ext.getBody().unmask();
						showSuccessMessage(getPersonModuleTranslation('STUDENT_JOURNEY'),getCommonTranslation('SUCCESS'));
						jGrid.getStore().load({
								callback: function(){
									setTimeout(function(){
										jGrid.up().doLayout();
										 jGrid.getView().refresh();
						                    var view = jGrid.getView();
						                    var store = jGrid.getStore();
						                    store.each(function(record, index){
						                        if(record.get('resultStatus') === 'Exempted'){
						                            var row = view.getRecord(index);
						                            if(row){
														var exemptedRow = jGrid.view.getNode(row);
														exemptedRow.classList.add('fadeOutRowCls');
						                            }
						                        }
						                    });
									},300);
								}
							});
						jGrid.getSelectionModel().deselectAll();
					},
					
					failure: function(response) {
						Ext.getBody().unmask();
						jGrid.getSelectionModel().deselectAll();
						jGrid.getStore().load();
						return;
					}
				});
			},

			setCurrentRowDefaultValues: function(record, periodStatus,transPeriodStatus){
				var me = this;
                var activeTab = me.getContentPanelActiveTab();
                var grid = activeTab.down('studentjourneycoreerpgrid');
				grid.suspendEvent();

				record.set({
					id: record.raw.id,
					academicLocationId:record.raw.academicLocationId,
					academicLocationName:record.raw.academicLocationName,
					academicTermCode:record.raw.academicTermCode,
					academicTermId:record.raw.academicTermId,
					academicTermSeq:record.raw.academicTermSeq,
					admissionId:record.raw.admissionId,
					batchId:record.raw.batchId,
					batchName:record.raw.batchName,
					campusId:record.raw.campusId,
					campusName:record.raw.campusName,
					id:record.raw.id,
					periodId:record.raw.periodId,
					periodName:record.raw.periodName,
					periodStatus: transPeriodStatus,
					programId:record.raw.programId,
					programName:record.raw.programName,
					programPeriodSeq:record.raw.programPeriodSeq,
					progressionStatus:record.raw.progressionStatus,
					resultStatus:record.raw.resultStatus,
					seatTypeId:record.raw.seatTypeId,
					seatTypeName:record.raw.seatTypeName,
					seatType:record.raw.seatTypeName,
					studentId:record.raw.studentId,
					programJourneySeq: record.raw.programJourneySeq
				});


				/*record.set('academicLocationName',record.raw.academicLocationName);
		record.set('campusName',record.raw.campusName);
		record.set('programName',record.raw.programName);
		record.set('periodName',record.raw.periodName);
		record.set('batchName',record.raw.batchName);
		record.set('resultStatus',record.raw.resultStatus);*/
				grid.resumeLayouts();
			},
			disableChangeProgressionStatusButtonPivileges: function(formReference,permissionsMap) {
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				formReference.down('#changeProgressionStatusId').setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'CHANGE_PROGRESSION_STATUS') {
						formReference.down('#changeProgressionStatusId').setVisible(true);
					}
				});
				formReference.down('#modifyEnrollmentBtnItemId').setVisible(false);
				formReference.up('studentjourneystructureforcoreerp').down('#saveStudentJourney').setVisible(false);
				formReference.down("#spBtnMoreActionsSJ").setVisible(false);
				formReference.down("#addEnrollmentForLastLine").setVisible(false);
				formReference.down("#cancelButtonId").setVisible(false);
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'MODIFY_ENROLLMENT') {
						formReference.down('#modifyEnrollmentBtnItemId').setVisible(true);
					}
					if (privilege === 'SAVE') {
						formReference.up('studentjourneystructureforcoreerp').down('#saveStudentJourney').setVisible(true);
					}
					if(privilege === 'MORE_ACTION'){
						formReference.down('#spBtnMoreActionsSJ').setVisible(true);
					}
					if (privilege === 'ADD_ENROLLMENT_FOR_THE_NEXT_LINE') {
						formReference.down('#addEnrollmentForLastLine').setVisible(true);
					}
					if (privilege === 'CANCEL') {
						formReference.down('#cancelButtonId').setVisible(true);
					}
				});
			},
			
			showModifyEnrollmentWin: function(btn){
				var $this = this;
				var journeyGrid=btn.up('studentjourneycoreerpgrid');
				var record=journeyGrid.getSelectionModel().getSelection()[0];
				if(journeyGrid.getSelectionModel().getSelection().length>0){
					var win = $this.getEnrollmentstatuswin();
					if(!win){
						Ext.widget('enrollmentstatuswin');
						win = $this.getEnrollmentstatuswin();
					}
					var gridPeriodStatus = record.data.periodStatus;
					var resultStatus = record.data.resultStatus;
					
					var periodStatusCombo = win.down('#periodStatus');
					periodStatusCombo.getStore().load();
					periodStatusCombo.setValue(gridPeriodStatus);
					periodStatusCombo.getStore().on('load', function(){
						if (resultStatus === 'Completed') {
		                    if(!isNullOrEmpty(periodStatusCombo.getStore())){
		                    periodStatusCombo.getStore().filterBy(function(record){
		                        return record.get('enrollmentStatus') !== 'EXEMPT';
		                    });
		                }
		               }
					});
				   
					win.show();	
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'))
				}
			},
			
			showChangeProgressionStatusWin:function(btn){
				var $this = this;
				var journeyGrid=btn.up('studentjourneycoreerpgrid');
				var record=journeyGrid.getSelectionModel().getSelection()[0];
				if(journeyGrid.getSelectionModel().getSelection().length>0){
					var win = $this.getChangeprogressionstatuswin();
					if(!win){
						Ext.widget('changeprogressionstatuswin');
						win = $this.getChangeprogressionstatuswin();
					}
					var oldProgressionStatusCombo=win.down('#oldProgressionStatusId');
					var newProgressionStatusCombo=win.down('#newProgressionStatusId');
					/*var newProgressionStatusStore = newProgressionStatusCombo.getStore();
			newProgressionStatusStore.load({
				callback: function(records, operation, success) {
						for(var i in records){
							if(records[i].data.id==record.data.progressionId){
								oldProgressionStatusCombo.setValue(records[i].data.value);
							}
						}
					}
			});*/


					oldProgressionStatusCombo.setValue(record.data.progressionStatus);
					win.show();	
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'))}
			},

			closeChangeProgressionStatusWin:function(btn){
				var win = btn.up('changeprogressionstatuswin');
				win.close();
			},

			updateProgressionStatus:function(btn){
				var $this = this;
				var activeTab = this.getContentPanelActiveTab();
				var win = btn.up('changeprogressionstatuswin');
				var newProgressionStausId=win.down('#newProgressionStatusId').getValue();
				var newProgressionStatus = win.down('#newProgressionStatusId').getDisplayValue();
				var grid = activeTab.down('studentjourneycoreerpgrid');
				var record=grid.getSelectionModel().getSelection()[0];
				if(record.raw.resultStatus == 'Pre-Enrolled' && (newProgressionStatus == 'Retake' || newProgressionStatus == 'Resit' )){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_RETAKE_MSG'));
					return false;
				}
				if(record.raw.resultStatus == 'Pre-Enrolled' && newProgressionStatus.localeCompare('Proceed with Condition')){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_SELECT_PROCEED_WITH_CONDITION_MSG'));
					return false;
				}
				if(!isNullOrEmpty(record.raw.isAvailableForPromote)){
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('The student exists in Manage Promotion screen. Please update the Progression status from the respective screen'));
					win.close();
					return false;
				}
				var submitValue={
						id:record.data.id,
						progressionStatusId:newProgressionStausId,
						progressionStatus:newProgressionStatus
				};

				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_UPDATE_SSTUDENT_JOURNEY_PROGRESSION_STATUS,
					jsonData:submitValue,
					method : 'POST',
					success: function(f, action) {
						var data = f.responseText;
						if(data == "SUCCESS")
							showSuccessMessage(getCommonTranslation('CHANGE_PROGRESSION_STATUS'),getCommonTranslation('SUCCESS'));
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll();
						win.close();
					},
					failure: function(result, request) {
						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
						return false;
					}
				});

			},

			updateEnrollmentSettingStatus:function(grid, records){
				var $this = this;
				var saveButton = grid.down('#btnSaveItemId');
				var submitValue = [];
				
				Ext.each(records, function(record){
					submitValue.push({
						id :record.data.id,
						enrollmentStatus:record.data.enrollmentStatus,
						isVisible:record.data.isVisible,
					})
				});
				
				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_UPDATE_ENROLLMENT_STATUS_SETTING,
					jsonData:submitValue,
					method : 'POST',
					success: function(f, action) {
						Ext.getBody().unmask();
						var data = f.responseText;
						if(data == "SUCCESS")
						showSuccessMessage(getCommonTranslation('ENROLLMENT_STATUS_SETTING'),getCommonTranslation('SUCCESS'));
						saveButton.setDisabled(true);
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll();
					},
					failure: function(result, request) {
						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
						Ext.getBody().unmask();
						return false;
					}
				});

			},
			
			addEnrollmentForLastGridRecord: function(){
				var me = this;
				var activePanel = me.getContentPanelActiveTab();
            	var studentjourneycoreerpgrid = activePanel.down('studentjourneycoreerpgrid');
            	    var ObjModel = studentjourneycoreerpgrid.getStore().data.items;
            		var studentjourneycoreerpgridModel = new Academia.model.personinfo.common.personalinfo.StudentJourneyModel();
            		//studentjourneycoreerpgridModel.set("academicTermId", ObjModel[ObjModel.length-1].data.academicTermId);
            		studentjourneycoreerpgridModel.set("id", '');
            		studentjourneycoreerpgridModel.set("academicTermCode", '');
            		studentjourneycoreerpgridModel.set("periodStatus", 'addEnrollmentForLastLine');
            		studentjourneycoreerpgridModel.set("academicLocationName", '');
					studentjourneycoreerpgridModel.set("campusName", '');
            		studentjourneycoreerpgridModel.set("programName", ObjModel[ObjModel.length-1].data.programName);
            		studentjourneycoreerpgridModel.set("programId", ObjModel[ObjModel.length-1].data.programId);
            		studentjourneycoreerpgridModel.set("batchName", '');
            		studentjourneycoreerpgridModel.set("batchId", ObjModel[ObjModel.length-1].data.batchId);
            		studentjourneycoreerpgridModel.set("programBatchPrefix", ObjModel[ObjModel.length-1].data.programBatchPrefix);
            		studentjourneycoreerpgridModel.set("programBatchSeq", ObjModel[ObjModel.length-1].data.programBatchSeq);
            		studentjourneycoreerpgridModel.set("periodName", '');
					studentjourneycoreerpgridModel.set("resultStatus", '');
            		studentjourneycoreerpgridModel.set("progressionStatus", '');
            		studentjourneycoreerpgridModel.set("addedStatus", '');
            		studentjourneycoreerpgridModel.set("studentId", ObjModel[ObjModel.length-1].data.studentId);
            		studentjourneycoreerpgridModel.set("admissionId", ObjModel[ObjModel.length-1].data.admissionId);
            		studentjourneycoreerpgridModel.set("isAcademicTermEditable", true);
            		studentjourneycoreerpgridModel.set("isperiodEditable", true);
            		studentjourneycoreerpgridModel.commit();
            		//ObjModel.push(studentjourneycoreerpgridModel);
            		studentjourneycoreerpgrid.getStore().add(studentjourneycoreerpgridModel);
            		//studentjourneycoreerpgrid.getStore().loadRawData(ObjModel, true);
            		studentjourneycoreerpgrid.getView().refresh();
            		setTimeout(function(){
            			studentjourneycoreerpgrid.up().doLayout();
					},300);
			},
	
});

