/*
 * This controller is used for student profile related actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentProfileController', {    
	extend: 'Academia.controller.personinfo.student.StudentListController',
	alias: "widget.studentprofilecontroller",
    stores: ['studentCurrentProfileView.RecentVisitedStudentProfileStore','studentCurrentProfileView.AllStudentProfileDataStore',
    		 'Academia.model.feeandpayment.managebill.StudentAdmission'],
    views: ['personinfo.student.StudentProfileViewStructure', 'personinfo.student.StudentProfileViewFilter',
    		'personinfo.student.RecentVisitedStudentProfile'],
	model: [],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    },{
        ref: 'studentprofileviewfilter',
        selector: 'studentprofileviewfilter'
    },{
    	ref: 'recentvisitedstudentprofile',
    	selector: 'recentvisitedstudentprofile'
    },{
    	ref: 'studentquicksearchform',
    	selector: 'studentquicksearchform'
    }, {
    	ref: 'recentvisitedstudentprofile',
    	selector: 'recentvisitedstudentprofile'
    }],
    config: {},
    init: function(application) {
        this.control({
        	'recentvisitedstudentprofile': {
        		afterrender: function(profile){
                    Ext.defer(function() {
//                        var storeDataLength = profile.down('dataview').getStore().data.length;
//                           var profileTitle = profile.title;
//                           var NoRecordFoundImg = profile.down('#NoRecordFoundContainer')
//
//                           if (storeDataLength > 0) {
//                               profile.setTitle(profileTitle + " (" + storeDataLength + ")");
//                           } else {
//                               NoRecordFoundImg.setVisible(true);
//                           }
                    	var dataView = profile.down('dataview');
        	            if (!dataView) return;
        	            var store = dataView.getStore();
        	            var NoRecordFoundImg = profile.down('#NoRecordFoundContainer');
        	            var profileTitle = profile.title;
        	            store.on('load', function () {
        	                var count = store.getCount();

        	                if (count > 0) {
        	                    profile.setTitle(profileTitle + " (" + count + ")");
        	                    NoRecordFoundImg.setVisible(false);
        	                } else {
        	                    NoRecordFoundImg.setVisible(true);
        	                }
        	            });

        	            // If store already loaded earlier
        	            if (!store.isLoading() && store.getCount() > 0) {
        	                profile.setTitle(profileTitle + " (" + store.getCount() + ")");
        	                NoRecordFoundImg.setVisible(false);
        	            }
                    }, 200, this);
                }
        	},
        	'studentprofileviewfilter customcombobox[name=studentProfileId]': {
        		 select: this.openStudentRecord
            },
            'studentprofileviewfilter component[itemId=studentProfileSearchComponent]': {
				  render: this.openStudentProfileFromFilter
			 },
			 'recentvisitedstudentprofile dataview[itemId=recentVisitedStudentId]': {
				  render: this.openStudentProfile
			 },
        });
    },
    
    openStudentRecord: function(combo, records) {
    	var me = this
        var portalId = this.getCurrentLoggedPortalId();
        var studentprofileviewfilter = this.getStudentprofileviewfilter();      
        var profileContainerId = combo.up('panel').down('#profileContainerId');
        var template = combo.up('panel').down('#studentProfileSearchComponent');
        var profileImage = profileContainerId.down('#profile_image');
        
        profileImage.setSrc('')
        var store = template.getStore();

        if (records.length > 0) {
            var record = records[0];
            var studentId = record.get('studentId');
            var personId = record.get('personId');
            var studentCode = record.get('studentCode');
            var admissionId = record.get('id');

            store.getProxy().extraParams = {
                studentId: studentId,
                personId: personId,
                studentCode: studentCode,
                admissionId: admissionId
            };

            Ext.getBody().mask(getCommonTranslation('Loading...'), 'x-mask-loading');
            // Fetch image first
            Ext.Ajax.request({
                url: SERVERURL.PERSON_IMAGE_DOWNLOAD + '?personId=' + personId + '&userType=STUDENT&portalId=' + portalId + '&isDefaultImageRequired=false',
                method: 'GET',
                binary: true,
                success: function (imageResponse) {
                    var imageUrl = null;

                    if (imageResponse.responseBytes && imageResponse.responseBytes.length > 0) {
                        var blob = new Blob([imageResponse.responseBytes], { type: 'image/jpg' });
                        imageUrl = window.URL.createObjectURL(blob);
                    }

                    // Now load the store
                    store.load({
                        callback: function (studentRecords, operation, success) {
                            Ext.defer(function(){
                            	if (success && studentRecords.length > 0) {
                                var data = studentRecords[0].data;
                                if(profileContainerId.isHidden() == true){
                                    profileContainerId.show();
                                    profileContainerId.up().updateLayout();
                               }
                                template.update({
                                    studId:data.id,
                                    name: data.studentName,
                                    studentId: data.studentCode,
                                    admissionCode: data.admissionID,
                                    admissionId: admissionId,
                                    contactNumber: data.cellNo,
                                    email: data.primaryeEmailId,
                                    program: data.programName,
                                    batch: data.batch,
                                    section: data.sectionCode,
                                    period: data.period,
                                    seatType: data.seatType,
                                    advisorName: data.advisorName,
                                    studentCode: records[0].raw['studentCode'],
                                    personId: records[0].raw['personId']
                                });

                                if (imageUrl && profileImage && profileImage.el) {
                                    profileImage.el.dom.src = imageUrl;
                                } else {
                                    var firstName = records[0].raw['firstName'];
                                    var middleName = records[0].raw['middleName'];
                                    var lastName = records[0].raw['lastName'];
                                    var fallbackImg = generateInitialsImage(firstName, middleName, lastName);
                                    profileImage.setSrc(fallbackImg);
                                }
                            }
                            	Ext.getBody().unmask();
                            },50, this)
                        }
                    });
                },
                failure:function(){
	   				 Ext.getBody().unmask(); 
	   			 }
            });
        }
    },
    
	 openStudentProfile: function(view) {
		    var this$ = this;
		    var el = view.getEl();

		    if (el) {
		        el.on('click', function(event, target) {
		            if (Ext.fly(target).hasCls('open-profile-link')) {
		                var infoBox, studentId, personId, studentCode, admissionId;
		                var userInfo = Academia.model.authentication.UserInfoModel;
		                var studentData = {};
		                var portal = userInfo.get('portalId');

		                infoBox = Ext.fly(target).up('.std-info-box') || Ext.fly(target).up('.recentVistedBox');

		                if (infoBox) {
		                    studentId = infoBox.down('.open-profile-link').getHTML();
		                    var userCode = target.getAttribute('data-usercode');
		                    var visitedStudentId = target.getAttribute('data-visitedStudentId');
		                    var admissionId = target.getAttribute('data-admissionId');
		                    var personId = target.getAttribute('data-studentPersonId');
		                    var programBatchSeatTypeConfigId = target.getAttribute('data-programBatchSeatTypeConfigId');
		                    studentData = {
		                    		studentId: studentId,
		                    		userCode: userCode,
		                    		admissionId: admissionId,
		                    		personId: personId,
		                    		programBatchSeatTypeConfigId: programBatchSeatTypeConfigId,
		                    		visitedStudentId: visitedStudentId
		                    };
		                    if (studentData) {
                                this$.openStudentProfilePage(studentData);
                            } else {
                                showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('NO_RECORD_FOUND'));
                            }
		                    
		                    }
		                
		            }
		        }, this, { delegate: 'a.open-profile-link' });
		    }
		},
		
		openStudentProfileFromFilter: function(view) {
		    var this$ = this;
		    var el = view.getEl();

		    if (el) {
		        el.on('click', function(event, target) {
		            target = target || event.target;

		            var link = Ext.fly(target);
		            if (link && link.hasCls('open-profile-link')) {
		                var container = link.up('.std-info-box') || link.up('.recentVistedBox');

		                if (container) {
		                    var studentIdEl = container.down('.open-profile-link');
		                    var studentId = studentIdEl ? studentIdEl.dom.innerHTML : '';

		                    var domEl = link.dom;

		                    var userCode = domEl.attributes['data-usercode'] ? domEl.attributes['data-usercode'].value : '';
		                    var studId = domEl.attributes['data-studId'] ? domEl.attributes['data-studId'].value : '';
		                    var visitedStudentId = domEl.attributes['data-visitedStudentId'] ? domEl.attributes['data-visitedStudentId'].value : '';
		                    var admissionId = container.down('.student-admissionId') ? container.down('.student-admissionId').dom.innerHTML : '';
		                    var personId = domEl.attributes['data-studentPersonId'] ? domEl.attributes['data-studentPersonId'].value : '';
		                    var programBatchSeatTypeConfigId = domEl.attributes['data-programBatchSeatTypeConfigId'] ? domEl.attributes['data-programBatchSeatTypeConfigId'].value : '';

		                    var studentData = {
		                        studentId: studentId,
		                        userCode: userCode,
		                        admissionId: admissionId,
		                        personId: personId,
		                        programBatchSeatTypeConfigId: programBatchSeatTypeConfigId,
		                        visitedStudentId: studId
		                    };

		                    if (studentData.studentId) {
		                        this$.openStudentProfilePage(studentData);
		                    } else {
		                        showWarningMessage(getCommonTranslation('ALERTS'), getCommonTranslation('NO_RECORD_FOUND'));
		                    }
		                }
		            }
		        }, this, { delegate: 'a.open-profile-link' });
		    }
		},


    
    openStudentProfilePage: function(studentData) {
    	var this$ = this;
    	var contentpanel = this$.getContentPanel();
        var tabName;
        var portalInfo = Academia.model.authentication.StudentERPInfoModel;
    	var academyLocationId = this$.getCurrentAcademyLocation();
    	var serviceRequestRequiredForInActiveStudent = this.getInActiveStudentServiceRequestRequired();
    	
    	var tabTitle = studentData['userCode'];
        var personId = studentData['personId'];
        var userId = studentData['visitedStudentId'];
        var admissionId = studentData['admissionId'];
        var programBatchSeatTypeConfigId = studentData['programBatchSeatTypeConfigId'];
    	
    	var submitUrl =SERVERURL.BATCH_ID_BY_STUDENT_ID;
    	
    	if(!isNullOrEmpty(userId)) {
        	Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
    			method : 'GET',
    			params:{
    				academyLocationId:academyLocationId ,
    			},
    			success: function(f, action) {
    				var data = f.responseText;
    				if(data == "true"){	
    	            	this$.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
    				}else{
    					this$.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
    					this$.addContentPanelTab(tabTitle, 'pendingbillsgrid', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
    				}
    			},
    			failure: function(result, request) {
    				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
    				return false;
    			}
    		});
             Ext.Ajax.request({
     			type: 'rest',
     			url: submitUrl,
     			params:
     				{
     				  studentId : userId
     				},
     			method: 'GET',
     			async: false,
     			success: function(res, action) {
     				var data = Ext.decode(res.responseText);
     				portalInfo.set('admissionDetails',data[0].admissionDetails);
     				portalInfo.set('student',data[0].student);
     				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
     				portalInfo.set('programBatchDetails',data[0].programBatchDetails);
     				portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
     			}
     		});
             // for user activities
             Ext.Ajax.request({
            	 url: SERVERURL.USER_ACTIVITY_RECENT_VISITED_STUDENT+"?visitedUserId="+encodeURIComponent(Number(userId))+"&userGroup="+encodeURIComponent("Student"),
            	 method: 'POST',
            	 success: function(response) {
            		 var responseData = Ext.decode(response.responseText);
            	 },
            	 failure: function(response) {
            	     showErrorMessage('Error', 'No update');
            	 }
             })
        
    	}
    }
 
});

