/*
 * This controller is used for student service information actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentServiceController', {
    extend: 'Academia.controller.personinfo.common.PersonServiceController',

    alias: "widget.studentservicecontroller",

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'serviceOptForm',
        selector: 'serviceoptform[itemId=studentServiceOptForm]'

    }, {
        ref: 'communityOptForm',
        selector: 'communityoptform[itemId=studentCommunityOptForm]'

    }, {
        ref: 'studentserviceoptgrid',
        selector: 'serviceoptgrid[itemId=studentServiceOptGrid]'
    }],
    config: {
    	STUDENT_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SERVICES_HISTORY_PRIVILEGES'),
    	STUDENT_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SERVICE_OPT_PRIVILEGES'),
    	STUDENT_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMMUNITIES_HISTORY_PRIVILEGES'),
    	STUDENT_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_COMMUNITIES_OPT_PRIVILEGES'),
    	PARENT_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_SERVICE_OPT_PRIVILEGES'),
    	PARENT_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_COMMUNITIES_OPT_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_SERVICE_OPT_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_SERVICE_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SERVICE_OPT_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_COMMUNITIES_OPT_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_COMMUNITIES_OPT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_COMMUNITIES_OPT_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	
        	'communityoptgrid[itemId=studentCommunityHistoryGrid]': {
        		render: function(grid) {                	                	
        			this.loadGridStore('#studentCommunityHistoryGrid', SERVERURL.PERSON_COMMUNITY_HISTORY_GRIDDATA);
        			grid.setTitle(getPersonModuleTranslation('COMMUNITY_HISTORY'));
        			grid.down('#btnAdd').hide();
        			grid.down('#btnEdit').hide();
        			grid.down('#btnDelete').hide();



        			var portalId = this.getCurrentLoggedPortalId();
        			if(portalId == 7) {
        				this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
        			}else if(portalId == 2){
        				this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
        			}else if(portalId == 3){
        				this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
        			}else{
        				this.doAccessControlValidation(grid, this.getSTUDENT_COMMUNITIES_HISTORY_PERMISSIONS());
        			}
        		}
            },
            'communityoptgrid[itemId=studentCommunityHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewCommunityOptFormWindow('COMMUNITIES', 'studentCommunityOptForm', '#studentCommunityHistoryGrid',getPersonModuleTranslation('COMMUNITY_HISTORY'));
                }
            },
            'communityoptform[itemId=studentCommunityOptForm] button[itemId=communityOptCancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
        	        	
        	/**
        	 * Communities Opt In/ Opt Out Details
        	 */
            
            'communityoptgrid[itemId=studentCommunityOptGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#studentCommunityOptGrid', SERVERURL.PERSON_COMMUNITY_OPT_GRIDDATA);
            		var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7) {
            			grid.down('#btnAdd').show();
            			grid.down('#btnEdit').show();
            			//grid.down('#btnDelete').show();
            			this.doAccessControlValidation(grid, this.getPARENT_COMMUNITIES_OPT_PERMISSIONS());
            		}else if(portalId == 2) {
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_COMMUNITIES_OPT_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_COMMUNITIES_OPT_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_COMMUNITIES_OPT_PERMISSIONS());
            		}
                }
            },
            'communityoptform[itemId=studentCommunityOptForm]': {
            	afterrender: function(form) {                	                	
            		if(form){
            			var optOutRadioBtn=form.down("#optOutRadioBtn");
            			optOutRadioBtn.setDisabled(true);
            			//optOutRadioBtn.setVisible(false);
                    	var pbstd;
                    	var isApplicant;
                    	var portalId = this.getCurrentLoggedPortalId();
        				if(portalId == 3 || portalId == 7) {
        					pbstd=this.getCurrentlyLoggedInUserInfoForPortal().programBatchDetails.progBatchSeatTypeId;
        				}else if(portalId == 1)
        					{
        					pbstd=this.getContentPanelActiveTab().programBatchSeatTypeConfigId;
        					} else if(portalId == 6)
        						{
        						isApplicant=1;
        						}
        				
        				
                    	var communityStore = form.getForm().findField('community').getStore();
                    	communityStore.getProxy().extraParams = {
                    		pbsIds : pbstd,
                    		isApplicant:isApplicant
                    		
						};

            		}
                }
            },
            'communityoptgrid[itemId=studentCommunityOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('COMMUNITIES', 'studentCommunityOptForm');
                }             	
            },
            'communityoptgrid[itemId=studentCommunityOptGrid] button[itemId=btnEdit]': {
                click: function(){                	
                	this.editCommunityOptFormWindow('COMMUNITIES', 'studentCommunityOptForm', '#studentCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));                	                	
                }
            },
            'communityoptgrid[itemId=studentCommunityOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewCommunityOptFormWindow('COMMUNITIES', 'studentCommunityOptForm', '#studentCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));
                }
            },
            'communityoptgrid[itemId=studentCommunityOptGrid] button[itemId=btnDelete]': {
                click: function(){                	            		                 	 
                    this.deleteCommunityOptRecord('#studentCommunityOptGrid', SERVERURL.COMMUNITY_OPT_DELETE);
                } 
            },
            'communityoptform[itemId=studentCommunityOptForm] button[itemId=submitButtonId]': {
                click:function(){
                	this.saveCommunityOpt('#studentCommunityOptGrid', SERVERURL.COMMUNITY_OPT_ADD, SERVERURL.COMMUNITY_OPT_UPDATE);
                } 
            },
            'communityoptform[itemId=studentCommunityOptForm] button[itemId=communityOptCancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
            
            
            'serviceoptgrid[itemId=studentServiceHistoryGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#studentServiceHistoryGrid', SERVERURL.PERSON_SERVICE_HISTORY_GRIDDATA);
            		grid.setTitle(getPersonModuleTranslation('SERVICE_HISTORY'));
            		/*grid.down('#btnAdd').hide();
                    grid.down('#btnEdit').hide();
                    grid.down('#btnDelete').hide();*/
                    
            		var this$ = this;
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down('#studentServiceHistoryGrid');
                    
            		Ext.defer(function() {
            			var portalId = this.getCurrentLoggedPortalId();
            				if(portalId == 3 || portalId == 7) {
            					for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
            						var column = grid.columnManager.columns[i];
            						if(column.dataIndex == 'feePlan'){
            							column.hide();
            						}
            					}
            			   }
            		 }, 500, this);
            		
                   
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 7) {
                    	grid.down('#btnAdd').hide();
                        grid.down('#btnEdit').hide();
                        grid.down('#btnDelete').hide();
                        this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS());
                    }else if(portalId == 2){
                    	this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS());
                    }else if(portalId == 3){
                    	this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_SERVICES_HISTORY_PERMISSIONS());
                    }else{
                    	 this.doAccessControlValidation(grid, this.getSTUDENT_SERVICES_HISTORY_PERMISSIONS());
                    }
                }
            },
            'serviceoptgrid[itemId=studentServiceHistoryGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'studentServiceOptForm', '#studentServiceHistoryGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));
                }
            },
            'serviceoptform[itemId=studentServiceOptForm] combo[itemId=serviceNameComboField]': {
                render: function(combo){
                	this.loadServiceOptNameOnProgramBatchSeatType(combo,'STUDENT');
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] button[itemId=cancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
            	
        	/**
             *  Service Opt In/ Opt Out
             */

            'serviceoptgrid[itemId=studentServiceOptGrid]': {
                render: function(grid) {
                	this.loadGridStore('#studentServiceOptGrid', SERVERURL.PERSON_SERVICE_OPT_GRIDDATA);
                	
                	var this$ = this;
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down('#studentServiceOptGrid');
                    
                    Ext.defer(function() {
            			var portalId = this.getCurrentLoggedPortalId();
            				if(portalId == 3 || portalId == 7) {
            					for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
            						var column = grid.columnManager.columns[i];
            						if(column.dataIndex == 'feePlan'){
            							column.hide();
            						}
            					}
            			   }
            		 }, 500, this);
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId == 7) {
                    	grid.down('#btnAdd').show();
                        grid.down('#btnEdit').show();
                        //grid.down('#btnDelete').show();
                        this.doAccessControlValidation(grid, this.getPARENT_SERVICE_OPT_PERMISSIONS());
                    }else  if(portalId == 2) {
                    	this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_SERVICE_OPT_PERMISSIONS());
                    }else  if(portalId == 3) {
                    	this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_SERVICE_OPT_PERMISSIONS());
                    }else{
                    	this.doAccessControlValidation(grid, this.getSTUDENT_SERVICE_OPT_PERMISSIONS());
                    }
                }
            },
            'serviceoptform[itemId=studentServiceOptForm]': {
            	afterrender: function(form) {                	                	
            		if(form){
            			/*var optOutRadioBtn=form.down("#optOutRadioBtn");
            			optOutRadioBtn.setDisabled(true);*/
            			//optOutRadioBtn.setVisible(false);
            			/**
            			 * Type of service its is "STUDENT".
            			 */
            			var billedUserTypeHiddenField=form.down("#billedUserTypeHiddenField");
            			billedUserTypeHiddenField.setValue("STUDENT");
            		}
                }
            },
            'serviceoptgrid[itemId=studentServiceOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('SERVICES_OPT_IN_OUT', 'studentServiceOptForm');
                }	
            },
            'serviceoptgrid[itemId=studentServiceOptGrid] button[itemId=btnEdit]': {
                click: function(){
                	var grid=this.getStudentserviceoptgrid();
                	if (grid.getSelectionModel().getCount() > 0) {
             			var gridRecord=grid.getSelectionModel().getSelection()[0];
             			//if(gridRecord.data.whetherBillGeneratedOrNot==false){
             				this.editServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'studentServiceOptForm', '#studentServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));	
             			/*}else{
             				 showWarningMessage(getCommonTranslation('ALERT'),"Already bill is generated");
             			}*/
                      	                	
                	  }else {
           	   		    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
           	   	  }
                }
            },
            'serviceoptgrid[itemId=studentServiceOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'studentServiceOptForm', '#studentServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));
                }
            },
            'serviceoptgrid[itemId=studentServiceOptGrid] button[itemId=btnDelete]': {
            	click:function(){            		        		 
                    this.deleteServiceOptRecord('#studentServiceOptGrid', SERVERURL.SERVICE_HISTORY_DELETE);
                } 
            },
/*            'serviceoptform[itemId=studentServiceOptForm] button[itemId=submitButtonId]': {
            	click:function(){            		 
            		this.saveServiceOpt('#studentServiceOptGrid', SERVERURL.SERVICE_OPT_ADD, SERVERURL.SERVICE_OPT_UPDATE);
                } 
            },*/
            'serviceoptform[itemId=studentServiceOptForm] button[itemId=submitButtonId]': {
            	click:function(){            		 
            		this.saveServiceOptForStudent('#studentServiceOptGrid', SERVERURL.SERVICE_OPT_ADD, SERVERURL.SERVICE_OPT_UPDATE);
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] nestedJsonCombo[itemId=serviceNameComboField]': {
                change: function(combo, record, index){
                	var studentProfile = this.getContentPanelActiveTab();
                    /*var studentProfileView = studentProfile.down('#studentProfileView');
                    studentProfileView.refresh();*/
                    var userId = studentProfile.getUserId();
                    this.getFeePlanForSelectedService(combo, SERVERURL.GET_FEE_PLAN_ON_SELECTION_SERVICE,userId,"STUDENT");
                    var this$=this;
                	var form = this$.getServiceOptForm();
                    var feePlanRule = form.down('#feePlanRuleComboField');
                    feePlanRule.reset();
                    feePlanRule.setDisabled(true);
                    var feePlanStage = form.down('#feePlanRuleStageComboField');
                    feePlanStage.reset();
                    feePlanStage.setDisabled(true);
                    var amountPaidComboField = form.down('#amountPaidComboField');
                    amountPaidComboField.reset();
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] nestedJsonCombo[itemId=feePlanComboField]': {
                change: function(combo, record, index){
                	this.loadFeePlanRuleByFeePlan(combo, SERVERURL.BILL_SEQUENCE_FINDALL_BYID);
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] nestedJsonCombo[itemId=feePlanRuleComboField]': {
                change: function(combo, record, index){
                	this.loadFeePlanRuleStageByFeePlanRule(combo, SERVERURL.BILL_STAGE_FINDALL);
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] nestedJsonCombo[itemId=feePlanRuleStageComboField]': {
                change: function(combo, record, index){
                	this.loadAmountToBePaidByFeePlanRuleStage(combo, SERVERURL.BILL_FEE_STAGE_CONFID);
                } 
            },
            'serviceoptform[itemId=studentServiceOptForm] button[itemId=cancelButtonId]': {
            	click:function(){
            		this.closePersonCommonWindow();
                }
            },
            
            'serviceoptform[itemId=studentServiceOptForm] radiogroup#serviceOptRadioGroup': {
            	change:function(radio, newValue, oldValue, eOpts){                	
                	this.hideShowEndDateField(radio,newValue,oldValue);
                }
            },
            
            'communityoptform[itemId=studentCommunityOptForm] radiogroup#communityOptRadioGroup': {
            	change:function(radio, newValue, oldValue, eOpts){                	
                	this.hideShowEndDateFieldOnCommunity(radio,newValue,oldValue);
                }
            },
            'communityoptform[itemId=studentCommunityOptForm] combo[name=community]': {
    			select: function(obj, newValue, oldValue, eOpts) {
    				var communityGrid=Ext.ComponentQuery.query('communityoptgrid')[0];
    				if(Ext.isDefined(communityGrid)){
    					if(communityGrid.getStore().data.length){
    						communityGrid.getStore().each(function(record){
            					if(record.get('community').id == newValue[0].get('id')){
            						obj.setValue();
            						showWarningMessage(getPersonModuleTranslation('COMMUNITY_DETAILS'), getFeeAndPaymentCommonTranslation('DUPLICATE_RECORD_CONDITION'));
            					}
            				});	
    					}
    				}
    			}
    		}
        	
        });
    }
});
