/**
 * @author Dharmendra.Prajapati
 * 
 */  
Ext.define('Academia.controller.portal.MasterScheduleController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : ['common.ProgramByAcAndLoIdStore','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','common.AssignedProgramStore','course.AssignedPeriodCoursesFacultyStore','course.coursevariants.CourseVariantStore','course.academyLocation.AcademyLocationByAssign',
	          'common.AcademicTermStore','course.coursevariants.ParameterCourseVariantStore'],
	          views : ['personinfo.common.course.MasterScheduleDetails', 'facultyPortal.masterScheduleFaculty.MasterScheduleFacultySearchFilter',
	                   'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableCalendar',
	                   'facultyPortal.masterScheduleFaculty.MasterTimetableCalendarWin',
	                   'facultyPortal.masterScheduleFaculty.MasterScheduleFacultySearchStructure',
	                   'personinfo.common.course.StudentTimeTableSearchFilter',
                       'personinfo.common.course.CancelledSessionDetail',
                       'personinfo.common.course.CancelledSessionDetailGrid'],

	                   refs : [{
	                	   ref: 'masterscheduledetails',
	                	   selector: 'masterscheduledetails'
	                   },{
	                	   ref: 'cancelledsessiondetailgrid',
	                	   selector: 'cancelledsessiondetailgrid'
	                   },{
	                	   ref: 'cancelledsessiondetail',
	                	   selector: 'cancelledsessiondetail'
	                   },{
	                	   ref: 'masterschedulefacultysearchfilter',
	                	   selector: 'masterschedulefacultysearchfilter'
	                   },{
	                	   ref: 'mastertimetablecalendarwin',
	                	   selector: 'mastertimetablecalendarwin mastertimetablecalendar[itemId=mastertimetablecalendarfaculty]'
	                   },{
	                	   ref: 'contentPanel',
	                	   selector: 'contentpanel'
	                   },{
	                	   ref: 'mastertimetablecalendar',
	                	   selector: 'mastertimetablecalendar'
	                   },{
	                	   ref: 'masterschedulefacultysearchstructure',
	                	   selector: 'masterschedulefacultysearchstructure'
	                   },{
	                	   ref: 'studenttimetablesearchfilter',
	                	   selector: 'studenttimetablesearchfilter'
	                   }],
	                   config: {
	                   	STUDENT_TIMETABLE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_TIMETABLE_PRIVILEGES'),
	                   },
	                   init : function() {
	                	   this.control({

	                		   /**
	                		    *   For student portal
	                		    * 
	                		    */
	                		   'masterscheduledetails':{
	                			   render:function(panel){
	                				   var this$ = this;
	                				   setTimeout(function(){
	                				   var form = this$.getStudenttimetablesearchfilter();
	        	                	   var programField = form.down("#programBatch_programId");
	        	                	   if(programField.value!=null && programField.value>0){
	        	                		   this$.showCalendarData();
	        	                	   }},2000);
	                				   this.disablePrintBtnPivileges(panel, this.getSTUDENT_TIMETABLE_PERMISSIONS());
	                			   }
	                		   },
                                'cancelledsessiondetail':{
	                			   afterrender : function(form){
								     var studentInfo=null;
			                     //    var programId=null;		
										

										if(this$.getCurrentLoggedPortalId()==3){
	                					   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   studentId = studentInfo.student.id;
                                            programId=studentInfo.programBatchDetails.programId; 
                                            batchId=studentInfo.programBatchDetails.batchId;  
                                            var admissionId =Ext.Array.pluck(studentInfo.admissionDetails,'id').join(); 
                                             acdemicLocation= studentInfo.admissionDetails[0].academyLocationId;

	                				  } 
	                			  var $this=this;
                              
	        				      var form = $this.getCancelledsessiondetail();
                                  var programBatchField = form.down("#programBatch_programId");
 								  var programBatch = form.down("#programBatch_batchId");
					              var programPeriod = form.down("#periodIdItemId");
	                			  var programBatchFieldStore = programBatchField.getStore();
                                  programBatchFieldStore.getProxy().extraParams = {
	                						   studentIds:studentId
	                					   };
	                					   programBatchFieldStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									 programBatchField.setValue(records[0].data.id);
                                                        programBatch.setDisabled(false);
	                					    }       else
                                                             {
	                                         programBatchField.setValue(records[0].data.id);
                                                        programBatch.setDisabled(false);
                                                    } 
 										  } 
										}
                                     });
                                   var course = form.down("#courseId");
	                				   var courseStore = course.getStore();
                                 courseStore.getProxy().extraParams = {
	                						admissionIds:admissionId  
              					   };
	                					   courseStore.load();
                                }
                               },	                		 
                             ' cancelledsessiondetailgrid':{
	                			   render:function(panel){
	                				  
	                				   
	                			   }

                                  
	                		   },

	                		   'masterscheduledetails button[itemId=btnPrint]' : {
	                			   click : function(){
	                				   this.exportTimeTableStudent();
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter':{
	                			   afterrender: function(form){
	                				   var me = this;
	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var programBatchField = form.down("#programBatch_programId");
	                				   var programBatchFieldStore = programBatchField.getStore();


	                				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                					   this$.setAllowBlank(studentALField, false);
	                					   studentALField.show();

	                					   programBatchFieldStore.on('beforeload', function(store, operation) {
	                						   var selectedALId = studentALField.getValue();
	                						   var currentALId = me.getCurrentAcademyLocation();
	                						   store.proxy.extraParams.academyLocationIds = isNullOrEmpty(selectedALId) ? currentALId : selectedALId;
	                					   });

	                					   var studentALStore = studentALField.getStore();
	                					   var portalId = me.getCurrentLoggedPortalId();
	                					   var currentALId = me.getCurrentAcademyLocation();

	                					   if(portalId==7){
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   } else {
	                						   var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
	                						   var admissionDetails=portalInfo.admissionDetails;
	                					   }

	                					   var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

	                					   studentALStore.getProxy().extraParams = {
	                						   admissionIds:admissionIds
	                					   };

	                					   studentALStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length > 0){
	                									   studentALField.setValue(currentALId);
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }else{
	                					   this$.setAllowBlank(studentALField, false);
	                					   studentALField.hide();
	                				   } 
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter combo[itemId=studentAcademyLocation]': {
	                			   change: function(combo, records, eOpts) {
	                				   var this$ = this;
	                				   var form = combo.up('studenttimetablesearchfilter');

	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var studentProgramField = form.down("#programBatch_programId");

	                				   studentProgramField.clearValue();
	                				   form.down('#programBatch_batchId').clearValue();
	                				   form.down('#periodIdItemId').clearValue();
	                				   
	                				   form.down('#programBatch_batchId').setDisabled(true);
	                				   form.down('#periodIdItemId').setDisabled(true);

	                				   var academyLocationId=studentALField.getValue();

	                				   if(this$.getCurrentLoggedPortalId()==3 || this$.getCurrentLoggedPortalId()==7){
	                					   studentPortalInfo = this$.getCurrentlyLoggedInUserInfoForPortal();
	                				   } else {
	                					   studentPortalInfo = this$.getStudentDetailForErpPortal();
	                				   }

	                				   var studentId = studentPortalInfo.student.id;
	                				   if(this$.getCurrentLoggedPortalId()==2){
	                					   var personProfile = this$.getContentPanelActiveTab();
	                					   studentId = personProfile.userId;
	                				   }
	                				   
	                				   studentProgramField.store.getProxy().extraParams={
	                					   studentId: studentId,
	                					   onlyCurrentRecord:false
	                				   };
	                				   
	                				   studentProgramField.store.load({
	                					   callback : function(records, operation, success) {
	                						   if (success) {
	                							   if(records.length==1){
	                								   studentProgramField.setValue(records[0].data.id);
	                							   }
	                						   }
	                					   }
	                				   });
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter combo#programBatch_programId': {
	                			   change: function(obj, record) {
	                				   var $this=this;
	                				   var records = obj.value;
	                				   var programId = 0;
	                				   if(!isNullOrEmpty(records)) {
	                					   if(typeof records=="number"){
	                						   programId = records;
	                					   }else if(!isNullOrEmpty(records.data)){
	                						   programId = records.data.id;
	                					   }
	                				   }
	                				   var form = obj.up('form');
	                				   var batchCombo=form.down("#programBatch_batchId");
	                				   var periodCombo=form.down("#periodIdItemId");

	                				   batchCombo.reset();
	                				   periodCombo.reset();

	                				   batchCombo.setDisabled(true);
	                				   periodCombo.setDisabled(true);

	                				   if(programId > 0) {
	                					   var studentInfo = null;
	                					   var studentId 
	                					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                						   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                						   studentId = studentInfo.student.id;
	                					   } else {
	                						   var personProfile = this.getContentPanelActiveTab();
	                						   studentId = personProfile.getUserId();
	                						   studentInfo = this.getStudentDetailForErpPortal()
	                					   }
	                					   var batchId=studentInfo.programBatchDetails.batchId;
	                					   batchCombo.setDisabled(false);
	                					   var batchComboStore = batchCombo.getStore();
	                					   batchComboStore.getProxy().extraParams = {
	                						   programId: programId,
	                						   studentId:studentId,
	                						   onlyCurrentRecords:false
	                					   };
	                					   batchComboStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									   batchCombo.setValue(records[0].data.id);
	                								   }else if(records.length>0){
	                									   batchCombo.setValue(batchId);
	                								   } 
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter combo#programBatch_batchId': {
	                			   change: function(obj, record) {
	                				   var $this=this;
	                				   var records = obj.value;
	                				   var batchId = 0;
	                				   if(!isNullOrEmpty(records)) {
	                					   if(typeof records=="number"){
	                						   batchId = records;
	                					   }else if(!isNullOrEmpty(records.data)){
	                						   batchId = records.data.id;
	                					   }
	                				   }
	                				   var form = obj.up('form');
	                				   var periodCombo=form.down("#periodIdItemId");

	                				   periodCombo.reset();
	                				   
	                				   periodCombo.setDisabled(true);
	                				   
	                				   if(batchId > 0) {
	                					   var studentInfo = null;
	                					   var studentId 
	                					   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                						   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                						   studentId = studentInfo.student.id;
	                					   } else {
	                						   var personProfile = this.getContentPanelActiveTab();
	                						   studentId = personProfile.getUserId();
	                						   studentInfo = this.getStudentDetailForErpPortal()
	                					   }
	                					   var periodId=studentInfo.programBatchDetails.periodId;
	                					   periodCombo.setDisabled(false);
	                					   var periodComboStore = periodCombo.getStore();
	                					   periodComboStore.getProxy().extraParams = {
	                						   batchId: batchId,
	                						   studentId:studentId,
	                						   onlyCurrentRecords:false
	                					   };
	                					   periodComboStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   for(var i in records){
	       	    		                      			if(records[i].data.code){
	       	    		                      				periodCombo.setValue(records[i].data.id);
	       	    		                      			}
	       	    		                      		 }
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter button[itemId=resetBtn]':{
	                			   click: function(obj){
	                				   var $this = this;
	                				   var form=obj.up('form');
	                				   var academyLocationId = $this.getCurrentAcademyLocation();
	                				   var studentALField = form.down("#studentAcademyLocation");
	                				   var programField = form.down('#programBatch_programId');
	                				   var batchField = form.down('#programBatch_batchId');
	                				   var periodField = form.down('#periodIdItemId');

	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   var studentInfo = null;
	                				   var studentId;
	                				   
	                				   if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
	                					   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   studentId = studentInfo.student.id;
	                				   } else {
	                					   var personProfile = this.getContentPanelActiveTab();
	                					   studentId = personProfile.getUserId();
	                					   studentInfo = this.getStudentDetailForErpPortal()
	                				   }
	                				   
	                				   var programId=studentInfo.programBatchDetails.programId;
	                				   programField.reset();
	                				   
	                				   batchField.reset();
	                				   batchField.setDisabled(true);
	                				   periodField.reset();
	                				   periodField.setDisabled(true);

	                				   var studentALStore = studentALField.getStore();
                				       var portalId = $this.getCurrentLoggedPortalId();
                					   var currentALId = $this.getCurrentAcademyLocation();

                					   if(portalId==7){
                						   var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
                						   var admissionDetails=portalInfo.admissionDetails;
                					   } else {
                						   var portalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
                						   var admissionDetails=portalInfo.admissionDetails;
                					   }

                					   var admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

                					   studentALStore.getProxy().extraParams = {
                						   admissionIds:admissionIds
                					   };

                					   studentALStore.load({
                						   callback: function(records, operation, success) {
                							   if (success) {
                								   if(records.length > 0){
                									   studentALField.setValue(currentALId);
                								   }
                							   }
                						   }
                					   });
	                			   }
	                		   },
	                		   'studenttimetablesearchfilter button[itemId=searchBtn]':{
	                                  click : function(obj){
	                                     var this$ = this;
	                                    var form = this$.getStudenttimetablesearchfilter();
	                                       var programField = form.down("#programBatch_programId");
	                                       if(programField.value!=null && programField.value>0){
	                                           this$.showCalendarData();
	                                       }
	                                  }
	                               },
	                		   'cancelledsessiondetail button[itemId=resetBtn]':{
	                			   click : function(obj){
		                           var $this=this;
		                           var form = $this.getCancelledsessiondetail();
                                   var programBatch = form.down("#programBatch_batchId");
                                  var programBatchField = form.down("#programBatch_programId");
                                  var programPeriod = form.down("#periodIdItemId");
                                  var course = form.down("#courseId");
                                  var startDate=form.down('#consolidateStartDate');
                                  var endDate=form.down('#consolidateEndDate');
	                               programBatch.reset();
                                   programBatchField.reset();
                                   programPeriod.reset();
                                   course.reset(); 
                                   startDate.setMinValue(false);
							   	   startDate.setMaxValue(false);
								   endDate.setMinValue(false);
								   endDate.setMaxValue(false);
                                   startDate.reset();
                                   endDate.reset();
                                 programBatch.setDisabled(true);
                                 programPeriod.setDisabled(true);
                                    form.show();
									var studentInfo=null;
										if(this$.getCurrentLoggedPortalId()==3){
	                					   studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                					   studentId = studentInfo.student.id;
                                            programId=studentInfo.programBatchDetails.programId; 
                                            batchId=studentInfo.programBatchDetails.batchId;  
                                              admissionId =Ext.Array.pluck(studentInfo.admissionDetails,'id').join(); 
                                             acdemicLocation= studentInfo.admissionDetails[0].academyLocationId;

	                				  } 
	                			  var $this=this;
                              
	        				     var form = $this.getCancelledsessiondetail();
                                  var programBatchField = form.down("#programBatch_programId");
	                				   var programBatchFieldStore = programBatchField.getStore();
                                 programBatchFieldStore.getProxy().extraParams = {
	                						   studentIds:studentId
	                					   };
	                					   programBatchFieldStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									 programBatchField.setValue(records[0].data.id);
	                								   }  else
                                                             {
	                                         programBatchField.setValue(records[0].data.id);
                                                        programBatch.setDisabled(false);
                                                    } 
	                							   }
	                						   }
	                					   });


	                			  }
	                		   },
                              'cancelledsessiondetail customcombobox[itemId=programBatch_programId]':{
	                			   change : function(obj, record) {
		                              
	             						var me = this;
	             						var form = obj.up('form');
										var programId = obj.getValue();
	             						if(programId > 0) {
	                				   var programBatch = form.down("#programBatch_batchId");
                                       var periodField = form.down("#periodIdItemId");
										   programBatch.setDisabled(false);
							               periodField.reset();
                                           periodField.setDisabled(true);
											 programBatch.reset();
	                				   var programBatchStore = programBatch.getStore();
                                 			programBatchStore.getProxy().extraParams = {
	                						   id : programId
	                					   };
	                					   programBatchStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									 programBatch.setValue(records[0].data.id);
	                								   }else if(records.length>0){
	                							  programBatch.setValue(batchId);
	                								   } 
	                							   }
	                						   }
	                					   });
										}
                                    }
	                			   },  
       						 'cancelledsessiondetail customcombobox[itemId=programBatch_batchId]':{
	                			   change : function(obj, record) {
	             						var me = this;
	             						var form = obj.up('form');
										var batchId = obj.getValue();
     								  var studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	              				          admissionId =Ext.Array.pluck(studentInfo.admissionDetails,'id').join();  
										
	             						if(batchId > 0) {
	                				    var programPeriod = form.down("#periodIdItemId");
                                            programPeriod.setDisabled(false);
											programPeriod.reset();
	                				   var programPeriodStore = programPeriod.getStore();
                                 			programPeriodStore.getProxy().extraParams = {
	                						   batchId : batchId
	                					   };
             
	                					   programPeriodStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length == 1) {
	                									 programPeriod.setValue(records[0].data.id);
                                                       var course = form.down("#courseId");
															course.reset();
	                				                 var courseStore = course.getStore();
                                                   courseStore.getProxy().extraParams = {
	                						              admissionIds:admissionId ,
                                                          periodId:records[0].data.id 
														};
	                					                       courseStore.load();
	                								   }
	                							   }
	                						   }
	                					   });

										}
                                    }
	                			   },
								'cancelledsessiondetail button[itemId=searchBtn]':{
	                			  click : function(obj){
		
		                          studentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
                                  acdemicLocation= studentInfo.admissionDetails[0].academyLocationId;
                                  admissionId =studentInfo.admissionDetails[0].id; 
		                          var $this=this;
		                          var form = $this.getCancelledsessiondetail();
								  var grid = $this.getCancelledsessiondetailgrid();
                                  var programField = form.down("#programBatch_programId");
                                  var programBatchField = form.down("#programBatch_batchId");
                                  var programPeriod = form.down("#periodIdItemId");
                                  var course = form.down("#courseId");
                                  var startDate=form.down('#consolidateStartDate');
                                  var endDate=form.down('#consolidateEndDate');
	                              var programId = programField.getValue();
                                  var batchId = programBatchField.getValue();
                                  var periodId = programPeriod.getValue();
                                  var courseRecord = course.getValue();
                                  var sessionStartDate = Ext.Date.format(startDate.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);
                                  var sessionEndDate = Ext.Date.format(endDate.getValue(),CONSTANTS.SUBMIT_DATE_FORMAT);

                      var courseIds = [];
					     if(!isNullOrEmpty(courseRecord)) {
						Ext.each(courseRecord,function(course){
							if(typeof course=="number"){
								courseIds.push(course);
							}else if(!isNullOrEmpty(course.data)){
								courseIds.push(course.data.id);
							}
						  });
						}
						var courseIdLst = courseIds.join();
								  var gridStore = grid.getStore();
						           gridStore.getProxy().extraParams = {
                						   academyLocationId:acdemicLocation,
										   programId : programId,
							               batchId : batchId,
										   periodId : periodId,
										   courseIds : courseIdLst,
										   admissionId : admissionId, 
										   fromDate : sessionStartDate,
										   toDate : sessionEndDate
										  
                					   };
								gridStore.load({
									callback: function(resp,success){
										
									}
								});
	                			  }
	                		   },
	                		   
	                		   'studenttimetablesearchfilter button[itemId=searchBtn]':{
	                                  click : function(obj){
	                                     var this$ = this;
	                                    var form = this$.getStudenttimetablesearchfilter();
	                                       var programField = form.down("#programBatch_programId");
	                                       if(programField.value!=null && programField.value>0){
	                                           this$.showCalendarData();
	                                       }
	                                  }
	                               },

                              
	                		   /**
	                		    *   For faculty portal
	                		    * 
	                		    */       
                              
                                 
	                		   'masterschedulefacultysearchfilter combo[itemId=masterProgramComboField]': {
	                			   change:function(obj,records) {
	             						var me = this;
	             						var form = obj.up('form');
	             						var programId = obj.getValue();
	             						if(programId > 0) {
	             							this.masterTimeTableProgramChange(form, programId);
	             						}
	             					}
	                		   },
	                		   'masterschedulefacultysearchfilter combo[itemId=masterBatch]': {
	                			   change:function(obj, record) {
	             						var me = this;
	             						var form = obj.up('form');
	             						var batchId = obj.getValue();
	             						if(batchId > 0) {
	             							this.masterTimetableBatchChange(form, batchId);
	             						}
	             					}
	                		   },
	                		   'masterschedulefacultysearchfilter combo[itemId=masterPeriod]': {
	                			   change: function(obj, record){
	             						var me = this;
	             						var form = obj.up('form');
	             						var periodId = obj.getValue();
	             						if(periodId > 0) {
	             							this.periodSelection(form, periodId);
	             						}
	             					}
	                		   },
	                		   'masterschedulefacultysearchfilter combo[itemId=masterSection]': {
	                			   select: function(combo, records, eOpts) {
	                				   var viewCalendarBtn = combo.up('form').down('#viewCalanderId');
	                				   //viewCalendarBtn.setDisabled(false);
	                			   }
	                		   },
	                		   'masterschedulefacultysearchfilter button[itemId=viewCalanderId]' : {
	                			   click : function() {
	                				   this.openCalendarFacultyWin(null);
	                				   var masterSearchFilterForm = this.getMasterschedulefacultysearchfilter();
	                				   masterSearchFilterForm.down('#masterTimeTableFormItemId').collapse();
	                			   }
	                		   },
	                		   'masterschedulefacultysearchfilter button[itemId=resetCalanderId]' : {
	                			   click : this.resetAndDisable
	                		   },
	                		   'mastertimetablecalendar button[itemId=btnPrint]' : {
	                			   click : function() {
	                				   this.exportTimeTableFaculty();
	                			   }
	                		   },
	                		   
	                		   'masterschedulefacultysearchfilter multiselectcombofield[itemId=academyLocationMasterId]':{
	                			   change: function(obj, records){
			             				    var me = this;
			             					var form = obj.up('form');
			             					var ids=[]
	    		                      		for(var i in records){
	    		                      			ids.push(records[i]);
	    		                      		}
			             				    var academyLocIdsjoin=	ids.join();
			             						this.onChangeAcademyLocation(form, academyLocIdsjoin);
	                			   }
	                		   },
	                		   'masterschedulefacultysearchfilter':{
	                			   render:this.renderMasterScheduleTimetableFacultyPortal,
	                			   afterrender: function(filter){
	                				   setTimeout(function(){
		                				   filter.down('#masterTimeTableFormItemId').collapse();
	                				   },300);
	                			   }
	                		   }, 
	                		   'masterschedulefacultysearchfilter customcombobox[itemId=academicTerm]' : {
		             			   change: function(obj, records){
		             				   var me = this;
		             					var form = obj.up('form');
		             					var academicTermId = obj.getValue();
		             					if(academicTermId > 0) {
		             						this.onChangeAcademicterm(form, academicTermId);
		             					}
		             			    }
		             			   },
		             			  'masterschedulefacultysearchfilter customcombobox[itemId=masterCourseVariantId]' : {
		             					change: function(obj, record){
		             						var me = this;
		             						var form = obj.up('form');
		             						var courseVariantId = obj.getValue();
		             						if(courseVariantId > 0) {
		             							var assignSectionType = obj.getStore().findRecord('id', courseVariantId).data.sectionType;
		             							this.courseVariantChange(form, courseVariantId, assignSectionType);
		             						}
		             					}
		             				},
	                	   });
	                   },

	                   /**
	                    * showCalendarData master calendar for Student 
	                    */
	                   showCalendarData:function(){
	                	   var $this = this;
	                	   $this.loadSectionIdForStudent();
	                	   $this.scrollToCurrentTime();
	                	},
	                  
	                   loadSectionIdForStudent:function() {
	                	   var $this = this;
	                	   var form = $this.getStudenttimetablesearchfilter();
	                	   var programField = form.down("#programBatch_programId");
	                	   var batchField = form.down("#programBatch_batchId");
	                	   var periodField = form.down("#periodIdItemId");
	                	   var sectionHiddenField = $this.getMasterscheduledetails().down("#stdSectionId");
	                	   if($this.getCurrentLoggedPortalId()==3 || $this.getCurrentLoggedPortalId()==7){
        					   studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
        				   } else {
        					   studentPortalInfo = $this.getStudentDetailForErpPortal();
        				   }

        				   var studentId = studentPortalInfo.student.id;
        				   if($this.getCurrentLoggedPortalId()==2){
        					   var personProfile = $this.getContentPanelActiveTab();
        					   studentId = personProfile.userId;
        				   }
	                	   Ext.Ajax.request({
	                		   method : "GET",
	                		   type : 'rest',
	                		   url : SERVERURL.PATH_GET_ADMISSION_ID_BY_STUDENT_ID,
	                		   params:{
	                			   programId:programField.value,
	                			   batchId:batchField.value,
	                			   periodId:periodField.value,
	                			   studentId:studentId
	                		   },
	                		   headers : {
	                			   'Content-Type' : 'application/json'
	                		   },
	                		   success : function(resp, action) {
	                			   var msg = resp.responseText;
	                			   if(!isNullOrEmpty(msg)) {
	                				    var admissionId = Ext.decode(msg);
	                			   }
	                			   Ext.Ajax.request({
	    	                		   method : "GET",
	    	                		   type : 'rest',
	    	                		   url : SERVERURL.STUDENT_ENROLLMENT_DETAILTAB_PERIOD_DETAILS_URL,
	    	                		   params:{
	    	                			   admissionId:admissionId,
	    	                			   batchId:batchField.value,
	    	                			   programId:programField.value,
	    	                			   periodId:periodField.value
	    	                		   },
	    	                		   headers : {
	    	                			   'Content-Type' : 'application/json'
	    	                		   },
	    	                		   success : function(resp, action) {
	    	                			   var mssg = resp.responseText;
	    	                			   if(!isNullOrEmpty(mssg)){
	    	                				   var data = Ext.decode(mssg);
	    	                				   var sectionId = data['sectionId'];
	    	                				   sectionHiddenField.setValue(sectionId);
	    	                				   $this.loadCalendar(sectionId);
	    	                			   }else{
	    	                				   $this.loadCalendar(null);
	    	                			   }
	    	                		   }
	    	                	   });
	                		   }
	                	   });
	                	   
	                   },

	                   loadCalendar: function(sectionId) { 
	                	   var calendar = this.getMasterscheduledetails();
	                	   calendar.eventStore.getProxy().url = SERVERURL.MASTER_TIME_TABLE_CALENDAR;
	                	   calendar.eventStore.getProxy().extraParams = {
	                		   sectionId:sectionId
	                   };
	                	   calendar.eventStore.load();
	                   },
	                   scrollToCurrentTime: function(){
	                	   try{
	                		   var $this =this;
	                		   var contentpanel = $this.getContentPanel();
	                		   var structure = contentpanel.down('personinfostudentportal');
	                		   var structureBody = structure.body;

	                		   var currentTimeHour = 8;//new Date().getHours();
	                		   structureBody.setScrollTop();
	                		   structureBody.scrollBy(0,168);
	                		   setTimeout(function(){
	                			   structureBody.scrollBy(0,((75*currentTimeHour)));
	                		   },100);
	                	   }
	                	   catch(e){}
	                   },
	                   /**
	                    * openCalendarWin open master calendar for Faculty 
	                    */
	                   openCalendarFacultyWin:function(courseVariantId, facultyId1){
	                	   var $this =this;
	                	   var contentpanel = $this.getContentPanel();
	                	   var portalId = this.getCurrentLoggedPortalId();
	               		   var facultyId = '';
	                	   var masterSearchFilterForm = this.getMasterschedulefacultysearchfilter();
	                	   var filterForm = masterSearchFilterForm.getForm();
	                	   var values = filterForm.getValues();
	                	   var sectionId = values.section;
	                	   var programId = values.programId;
	                	   var batchId = values.batch;
	                	   var periodId = values.period;
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   //var academicTermId = values.academicTerm;
	                	   if(isNullOrEmpty(courseVariantId)){
	                		   courseVariantId = null;
	                		   if(!isNullOrEmpty(values.courseVariant)){
	                			   courseVariantId = values.courseVariant
	                		   }else if(!isNullOrEmpty(values.dashletCourseVariantId)){
	                			   courseVariantId=values.dashletCourseVariantId;
		                		   values.dashletCourseVariantId=0;
	                		   }
	                		   
	                	   }
	                	   var calendar = this.getMastertimetablecalendar();
	                	   setTimeout(function(){
	                	   if(!isNullOrEmpty(facultyId1)){
	                		   facultyId=facultyId1;
	                		   masterSearchFilterForm.down('#masterTimeTableFormItemId').setVisible(false);
	                		   calendar.down('#btnPrint').setVisible(false);
	                		   calendar.down('#exportToPngBtn').setVisible(false);
	                	   }else{
	                		   calendar.down('#btnPrint').setVisible(true);
	                		   calendar.down('#exportToPngBtn').setVisible(true);
	                	   }
	                	   var academyLocationIds=null;
	                	   var courseVariantStore;
	                	   if(portalId == 2){
	                		   facultyId = $this.getCurrentlyLoggedInUser().id;
	                		   masterSearchFilterForm.down('#masterTimeTableFormItemId').setVisible(true);
	                		   var form = masterSearchFilterForm.down('#masterTimeTableFormItemId');
	                		   var courseVariant = form.down('#masterCourseVariantId');
	                		   courseVariantStore = form.down('#masterCourseVariantId').getStore();
	                		   calendar.down('#btnPrint').setVisible(true);
	                		   calendar.down('#exportToPngBtn').setVisible(true);
	                		   var academyLocIds=[];
	                		   if(!isEmpty(values.academyLocationMaster)){
	                			  for(var i = 0;i<values.academyLocationMaster.length;i++){
		                			   if((Ext.isObject(values.academyLocationMaster[i]))){
		                				   academyLocIds.push(values.academyLocationMaster[i].get("id"));
		                			   }else{
		                				   academyLocIds.push(values.academyLocationMaster[i]);
		                			   }
		                		   	
		                		   }
		                		   academyLocationIds = academyLocIds.join();
		                		   masterSearchFilterForm.isValid();
		                	   }else{
		                		   academyLocationIds=academyLocationId;
		                	   }
	                		   
	                		   if(courseVariantId!=null&&facultyId!=null&&academyLocationIds!=null
	                				   && !isNullOrEmpty(values.dashletCourseVariantId)){
	               				var data='?facultyId='+facultyId+'&courseVariantId='+courseVariantId+'&academyLocationId='+academyLocationIds;
	               				var uniqCheckUrl=SERVERURL.PATH_GET_ACADEMICTERM_BY_COURSEVARIANT+data;
	               				Ext.Ajax.request({
	               					 type: 'rest',
	               					 url: uniqCheckUrl,
	               					 method: 'GET',
	               					 success: function(resp, action) {
	               						 var objAcademicTerm = Ext.decode(resp.responseText);
	               						 if(!isNullOrEmpty(objAcademicTerm)){
	               							form.down("#academicTerm").setValue(objAcademicTerm.id);
	               						 }
	               									
	               					 }
	               				 });
	               			}
	               	    if(courseVariantId!=null&&facultyId!=null&&academyLocationIds!=null){
	               			var data='?id='+courseVariantId;
	               			var uniqCheckUrl=SERVERURL.COURSE_BY_COURSE_VARIANT+data;
	               			Ext.Ajax.request({
	               				 type: 'rest',
	               				 url: uniqCheckUrl,
	               				 method: 'GET',
	               				 success: function(resp, action) {
	               					 var objCourseVariants = Ext.decode(resp.responseText);
	               					 if(!isNullOrEmpty(objCourseVariants)){
	               						 setTimeout(function(){
	               							form.down("#masterCourseVariantId").setValue(objCourseVariants.id);
	               		                  },300);
	               					 }
	               								
	               				 }
	               			 });
	               		    }
	                	   }
	                	   var academicTerm = null;
	                	   if(portalId == 2){
	                		  // academicTerm = values.academicTerm;
	                		   academicTerm = form.down("#academicTerm").getValue();
	                	   }
	                	   $this.hideCalendarButtons(calendar);
	                	   calendar.eventStore.removeAll();
	                	   calendar.calendarStore.removeAll();
	                	   calendar.eventStore.getProxy().url = SERVERURL.PATH_GET_MASTER_TIMETABLE;
	                	   calendar.eventStore.getProxy().extraParams = {
	                		   sectionId:sectionId,
	                		   facultyId:facultyId,
	                		   programId:programId,
	                		   batchId:batchId,
	                		   periodId:periodId,
	                		   courseVariantId:courseVariantId,
	                		   academyLocationIds:academyLocationIds,
	                		   academicTermId:academicTerm
	                	   };
	                	   calendar.eventStore.load();
	                	   
	                	   var activeTabPnl = contentpanel.getActiveTab();

	                	   if(activeTabPnl.xtype == 'personinfofacultyportal'){
	                		   var structure = activeTabPnl;
	                		   var structureBody = structure.body;
	                		   var currentTimeHour = 8;//new Date().getHours();
	                		   structureBody.setScrollTop();
	                		   structureBody.scrollBy(0,168);
	                		   setTimeout(function(){
	                			   structureBody.scrollBy(0,((75*currentTimeHour)));   
	                		   },500); 

	                	   }
	                	   if(activeTabPnl.xtype != 'personinfofacultyportal' && activeTabPnl.xtype == 'masterschedulefacultysearchstructure'){
	                		   var structure = activeTabPnl;
	                		   var structureBody = structure.body;
	                		   var currentTimeHour = 8;//new Date().getHours();
	                		   structureBody.setScrollTop();
	                		   structureBody.scrollBy(0,168);
	                		   setTimeout(function(){
	                			   structureBody.scrollBy(0,((75*currentTimeHour)));   
	                		   },100);
	                	   }
	                	
	                	 },300);
	                	},

	                   loadAttendanceDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
	                	   var this$ = this;
	                	   this$.resetOtherDropdowns(dependentCombo);
	                	   dependentCombo.clearValue();
	                	   dependentCombo.store.removeAll();
	                	   var store = dependentCombo.getStore();
	                	   var id = comboValue;
	                	   if (!isNullOrEmpty(id)) {
	                		   var url = store.getProxy().proxyConfig.api.read;
	                		   if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
	                			   url = url.concat('?' + parameter + '=' + id);
	                		   } else {
	                			   url = url.concat('?' + parameter + '=' + id);
	                			   url = url.concat('&' + extraParameter + '=' + extraParamValue);
	                		   }
	                		   store.getProxy().api.read = url;
	                		   store.reload();
	                	   }
	                   },

	                   /**
	                    * Print time table for faculty
	                    */
	                   exportTimeTableFaculty: function() {
	                	   var $this = this;
	                	   //var sectionId = $this.getMasterschedulefacultysearchfilter().down('#section').getValue();
	                	   $this.printTimeTable(null);
	                   },

	                   exportTimeTableStudent : function() {
	                	   var $this = this;
	                	   var sectionId = $this.getMasterscheduledetails().down("#stdSectionId").getValue();
	                	   $this.printTimeTable(sectionId);
	                   },

	                   printTimeTable:function(sectionId) {
	                	   var $this = this;
	                	   var reportParams = new Object();
	                	   var exportUrl = "";
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var user = $this.getCurrentlyLoggedInUser();
	                	   var formValues;
	                	   var academicTermId;
	                	   var academyLocIds=[];
	                	   var programId;
	                	   var batchId;
	                	   var periodId;
	                	   var courseVariantId;
	                	   var sectionId;
	                	   var facultyId;
                		   var academyLocationId = this.getCurrentAcademyLocation();
	                	   if(portalId==2){
	                		   formValues = $this.getMasterschedulefacultysearchfilter().getForm().getValues();
	                		   programId = formValues.programId;
	                		   batchId = formValues.batch;
	                		   periodId = formValues.period;
	                		   courseVariantId = formValues.courseVariant;
	                		   sectionId = formValues.section;
	                		   if(!isEmpty(formValues.academyLocationMaster)){
	                			   for(var i = 0;i<formValues.academyLocationMaster.length;i++){
	                				   if((Ext.isObject(formValues.academyLocationMaster[i]))){
	                					   academyLocIds.push(formValues.academyLocationMaster[i].get("id"));
	                				   }else{
	                					   academyLocIds.push(formValues.academyLocationMaster[i]);
	                				   }

	                			   }
	                			   academyLocationIds = academyLocIds.join();
	                			   var masterSearchFilterForm = this.getMasterschedulefacultysearchfilter();
	                			   masterSearchFilterForm.isValid();
	                		   }else{
	                			   academyLocIds=academyLocationId;
	                		   }
	                		   academicTermId = formValues.academicTerm;
	                		   facultyId = user.id;
	                	   }else{
	                		   var formVal=$this.getStudenttimetablesearchfilter().getForm().getValues();
	                		   academyLocIds=academyLocationId;
	                	   }
	                	   if(academicTermId == "" || academicTermId == undefined){
	                		   academicTermId=null;
	                	   }
	                	   if(programId == "" || programId == undefined){
	                		   programId=null;
	                	   }
	                	   programId=formVal.programId;
	                	   batchId=formVal.batchId;
	                	   periodId=formVal.periodId;
	                	   if(batchId == "" || batchId == undefined){
	                		   batchId=null;
	                	   }
	                	   if(periodId == "" || periodId == undefined){
	                		   periodId=null;
	                	   }
	                	   if(courseVariantId == "" || courseVariantId == undefined){
	                		   courseVariantId=[];
	                	   }
	                	   if(sectionId == "" || sectionId == undefined || sectionId == null){
	                		   sectionId=[];
	                	   }
	                	   sectionId=sectionId;
	                	// code to identify jasper
	                	   var code = "MASTER_TIME_TABLE_PDF";
	                	   var reportTitle = 'Master Timetable Report';
	                	   var fileType = 'xls';
	                	   reportParams.academyLocationIds=academyLocIds;
	                	   reportParams.code = code;
	                	   reportParams.reportTitle = reportTitle;
	                	   reportParams.portalId = portalId;
	                	   reportParams.academicTermId = academicTermId;
	                	   reportParams.programId = programId;
	                	   reportParams.batchId = batchId;
	                	   reportParams.periodId = periodId;
	                	   reportParams.sectionIds = String(sectionId);
	                	   reportParams.courseVariantId = String(courseVariantId);
	                	   if(portalId==2){
	                		   reportParams.facultyIds = String(facultyId);
	                	   }
	                	   exportUrl = SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_PDF_REPORT;
	                	   
	                	   
	                	   $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_PDF_REPORT);
	                   },

	                   resetOtherDropdowns: function(combo) {
	                	   var container = combo.up('form');
	                	   switch (combo.name) {
	                	   case 'programId':
	                		   this.clearCombo(combo);
	                		   batchCombo = container.down('combo[name=batch]');
	                		   this.clearCombo(batchCombo);
	                		   break;
	                	   case 'batch':
	                		   this.clearCombo(combo);
	                		   periodCombo = container.down('combo[name=period]');
	                		   this.clearCombo(periodCombo);
	                		   break;
	                	   case 'period':
	                		   this.clearCombo(combo);
	                		   sectionCombo = container.down('combo[name=section]');
	                		   this.clearCombo(sectionCombo);
	                		   break;
	                	   case 'section':
	                		   this.clearCombo(combo);
	                		   break;
	                	   }
	                   },

	                   resetAndDisable: function(btn) {
	                	   var me = this;
	                       var contentpanel = me.getContentPanel();
	                	   var masterschedulefacultysearchstructure =btn.up('masterschedulefacultysearchstructure');
	                	   var form = btn.up('masterschedulefacultysearchfilter');
	                	   form.down('#masterTimeTableFormItemId').collapse(true);
	                	   var academyLocationField = form.down('#academyLocationMasterId');
	                	   var academicTermField = form.down('#academicTerm');
	                	   var courseVariantField = form.down('#masterCourseVariantId');
	                	   var programField = form.down('#masterProgramComboField');
	                	   var batchField = form.down('#masterBatch');
	                	   var periodField = form.down('#masterPeriod');
	                	   var sectionField = form.down('#masterSection');
	                	   academyLocationField.clearValue();
	                	   academicTermField.clearValue();
	                	   courseVariantField.clearValue();
	                	   programField.clearValue();
	                	   batchField.clearValue();
	                	   periodField.clearValue();
	                	   sectionField.clearValue();
	                	   
	                	   var academyLocationStore=academyLocationField.getStore();
	                	   var academyLocIdsjoin=null;
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	   var whetherSchool = alinfomodel.get('wheatherSchool');
	                	   if(whetherSchool){
	                		   form.down('#masterPeriod').setVisible(false);
	                	   } else {
	                		   form.down('#masterPeriod').setVisible(true);
	                	   }
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   academyLocationStore.load({
	                		   callback: function(records, operation, success) {
	                			   if (success) {
	                				   var academyLocationArray= [];
	                				   if(records.length > 0){
	                					   academyLocationArray.push(academyLocationId);
	                				   }
	                				   academyLocationField.setValue(academyLocationId);
	                				   academyLocIdsjoin = academyLocationArray.join();
	                			   }
	                			   form.isValid();
	                		   }
	                	   });
	                   },

	                   clearCombo: function(combo) {
	                	   combo.clearValue();
	                	   combo.store.removeAll();
	                   },

	                   hideCalendarButtons: function(calendarWin) {
	                	   calendarWin.down("#addButtonId").setVisible(false);
	                	   calendarWin.down("#btnDelete").setVisible(false);
	                   },
	                   disablePrintBtnPivileges: function(panel,permissionsMap) {
	                	   var associatedAcadLocationIds = new Array();
	                	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	   var printButton = panel.down('#btnPrint');
	                	   printButton.setVisible(false);
	                	   Ext.each(permissionList, function(privilege) {
	                		   if (privilege === 'PRINT') {
	                			   if(!isNullOrEmpty(printButton)){
	                				   printButton.setVisible(true);
	                			   }        		
	                		   }
	                	   });
	                   },
	                   renderMasterScheduleTimetableFacultyPortal:function(){
	                	   var this$ = this;
	                	   var form = this$.getMasterschedulefacultysearchfilter();
	                	   var calendar = this.getMastertimetablecalendar();
	                	   var courseVarientField = form.down("#masterCourseVariantId");
	                	   this.hideCalendarButtons(calendar);
	                	   var academyLocationIds=form.down('#academyLocationMasterId');
	                	   var academyLocationStore=academyLocationIds.getStore();
	                	   var academyLocIdsjoin=null;
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	   var whetherSchool = alinfomodel.get('wheatherSchool');
	                	   if(whetherSchool){
	                		   form.down('#masterPeriod').setVisible(false);
	                	   } else {
	                		   form.down('#masterPeriod').setVisible(true);
	                	   }
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   academyLocationStore.load({
	                		   callback: function(records, operation, success) {
	                			   if (success) {
	                				   var academyLocationArray= [];
	                				   if(records.length > 0){
	                					   academyLocationArray.push(academyLocationId);
	                				   }
	                				   academyLocationIds.setValue(academyLocationId);
	                				   academyLocIdsjoin = academyLocationArray.join();
	                				   this$.hideCalendarButtons(calendar)
	                			   }
	                			   form.isValid();
	                		   }
	                	   });
	                   },
	                   onChangeAcademyLocation:function(form,academyLocationIds){
	                	   var this$=this;
	                	   var academicTermField = form.down('#academicTerm');
	                	   var academicTermStore = academicTermField.getStore();
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   if(portalId==2){
	                		   if(academyLocationIds.length > 0) {
								   form.down('#viewCalanderId').setDisabled(false);
								   this$.openCalendarFacultyWin(null);
							   } else {
								   form.down('#viewCalanderId').setDisabled(true);
							   }
		                	   academicTermField.reset();
		                	   academicTermStore.load({
		                		   callback: function(record, operation, success) {
		                			   if (success) {
		                				   if(record.length>0){
		                					   Ext.each(record, function(value) {
		                						   if(value.get('whetherCurrentAcademicTerm')){
		                							   academicTermField.setValue(value.data.id);
		                						   }
		                						   
		                					   });
		                				   }
		                			   }
		                		   }
		                	   });
	                	   }
	                   },
	                   onChangeAcademicterm : function(form, academicTermId){
	                	   var this$=this;
	                	   var academyLocationField = form.down('#academyLocationMasterId');
	                	   var academyLocationArray = academyLocationField.getValue();
	                	   var courseVariantField = form.down('#masterCourseVariantId');
	                	   var programField = form.down('#masterProgramComboField');
	                	   var batchField = form.down('#masterBatch');
	                	   var periodField = form.down('#masterPeriod');
	                	   var sectionField = form.down('#masterSection');
	                	   if((typeof academyLocationArray=="object" && isNullOrEmpty(academyLocationArray[0])) 
	                			   || (typeof academyLocationArray!="object" && isNullOrEmpty(academyLocationArray))) {
	                		   courseVariantField.reset();
	                		   programField.reset();
	                		   batchField.reset();
	                		   periodField.reset();
	                		   sectionField.reset();

	                		   courseVariantField.setDisabled(true);
	                		   programField.setDisabled(true);
	                		   batchField.setDisabled(true);
	                		   periodField.setDisabled(true);
	                		   sectionField.setDisabled(true);

	                	   } else {
	                		   courseVariantField.reset();
	                		   programField.reset();
	                		   batchField.reset();
	                		   periodField.reset();
	                		   sectionField.reset();

	                		   courseVariantField.setDisabled(false);
	                		   programField.setDisabled(false);
	                		   batchField.setDisabled(true);
	                		   periodField.setDisabled(true);
	                		   sectionField.setDisabled(true);
	                		   var ids=[]
	                		   var academyLocationIds = null;
	                			   if(typeof academyLocationArray =="object"){
	                				   for(var i in academyLocationArray){
	                					   if(!isNullOrEmpty(academyLocationArray[i])) {
	                						   ids.push(academyLocationArray[i].data.id);
	                					   }
	                				   }
	                				   academyLocationIds = ids.join();

	                			   }else{
	                				   academyLocationIds = academyLocationArray;
	                			   }
	                			   var facultyId = this.getCurrentlyLoggedInUser().id;
	                			   var courseVarientStore = courseVariantField.getStore();
	                			   courseVarientStore.getProxy().extraParams = {
	                				   academyLocationIds: academyLocationIds,
	                				   facultyId: facultyId,
	                				   isCurrentPeriod:false,
	                				   academicTermId:academicTermId
	                			   };
	                			   courseVarientStore.load();
	                			   var programStore = programField.getStore();
	                			   programStore.getProxy().extraParams = {
	                				   academyLocationIds:academyLocationIds,
	                				   academicTermId:academicTermId,
	                				   facultyId: facultyId,
	                				   isAllProgram:true
	                			   }
	                			   programStore.load();
	                	   }
	                   },
        		 	     courseVariantChange : function(form, courseVariantId, assignSectionType) {
      		 	    	   var $this = this;
      		 	    	   var academyLocationField = form.down('#academyLocationMasterId');
      		 	    	   var academicTermField = form.down('#academicTerm');
						   var courseVariantField = form.down('#masterCourseVariantId');
						   var programField = form.down('#masterProgramComboField');
                      	   var batchField = form.down('#masterBatch');
                      	   var periodField = form.down('#masterPeriod');
                      	   var sectionField = form.down('#masterSection');
                      	   
                      	 	programField.reset();
                      	 	batchField.reset();
                      	 	periodField.reset();
                      	 	sectionField.reset();
                      	 	
                      	 	batchField.setDisabled(true);
                      	 	periodField.setDisabled(true);
                      	 	sectionField.setDisabled(true);
                      	 	
      		 	    	   var academicTermId = academicTermField.getValue();
      		 	    	   var academyLocationArray = academyLocationField.getValue();
      		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id; 
      		 	    	   
      		 	    	   var ids=[]
      		 	    	   var academyLocationIds = null;
      		 	    	   if(typeof academyLocationArray =="object"){
      		 	    		   for(var i in academyLocationArray){
      		 	    			   if(!isNullOrEmpty(academyLocationArray[i])) {
      		 	    				ids.push(academyLocationArray[i].data.id);
      		 	    			   }
      		 	    		   }
      		 	    		 academyLocationIds = ids.join();
      		 	    		   
      		 	    	   }else{
      		 	    		academyLocationIds = academyLocationArray;
      		 	    	   }
      		 	    	   if(assignSectionType == 'CourseSection') {
      		 	    		   programField.setDisabled(true);
      		 	    		   batchField.setDisabled(true);
      		 	    		   periodField.setDisabled(true);
      		 	    		   sectionField.setDisabled(true);

      		 	    	   } else {
      		 	    		   programField.setDisabled(false);
      		 	    		   batchField.setDisabled(true);
      		 	    		   periodField.setDisabled(true);
      		 	    		   sectionField.setDisabled(true);
      		 	    		   var programStore = programField.getStore();
      		 	    		   programStore.getProxy().extraParams = {
      		 	    			   academyLocationIds:academyLocationIds,
      		 	    			   academicTermId:academicTermId,
      		 	    			   facultyId: facultyId,
      		 	    			   isAllProgram:true,
      		 	    			   courseVariantId:courseVariantId
      		 	    		   }
      		 	    		   programStore.load({
      		 	    			   callback: function(records, operation, success) {
      		 	    				   if (success) {
      		 	    					   if(records.length == 1){
      		 	    						   programField.setValue(records[0].data.id);
      		 	    					   } 
      		 	    				   }
      		 	    			   }
      		 	    		   });
      		 	    	   }
      		 	       },
      		 	    masterTimeTableProgramChange : function(form, programId){
 		 	    	   var $this=this;
 		 	    	   var academyLocationField = form.down('#academyLocationMasterId');
		 	    	   var academicTermField = form.down('#academicTerm');
					   var courseVariantField = form.down('#masterCourseVariantId');
					   var programField = form.down('#masterProgramComboField');
                	   var batchField = form.down('#masterBatch');
                	   var periodField = form.down('#masterPeriod');
                	   var sectionField = form.down('#masterSection');
                	   
                	   batchField.reset();
 		 	    	   periodField.reset();
 		 	    	   sectionField.reset();
                	 	
                	   batchField.setDisabled(false);
  		 	    	   periodField.setDisabled(true);
  		 	    	   sectionField.setDisabled(true);
                	 	
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var academyLocationArray = academyLocationField.getValue();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   
		 	    	   var ids=[]
		 	    	   var academyLocationIds = null;
		 	    	   if(typeof academyLocationArray[0] =="object"){
		 	    		   for(var i in academyLocationArray){
		 	    			  if(!isNullOrEmpty(academyLocationArray[i])){
		 	    			   ids.push(academyLocationArray[i].data.id);
		 	    		    }
		 	    		   }
		 	    		 academyLocationIds = ids.join();
		 	    		   
		 	    	   }else{
		 	    		academyLocationIds = academyLocationArray;
		 	    	   }
 		 	    	   
 		 	    	   var batchStore = batchField.getStore();
 		 	    	   batchStore.getProxy().extraParams = {
 		 	    		   academicTermId:academicTermId,
 		 	    		   facultyId: facultyId,
 		 	    		   isAllProgram:true,
 		 	    		   courseVariantId:courseVariantId,
 		 	    		   programId:programId
 		 	    	   }
 		 	    	   batchStore.load({
 		 	    		   callback: function(records, operation, success) {
 		 	    			   if (success) {
 		 	    				   if(records.length == 1){
 		 	    					   batchField.setValue(records[0].data.id);
 		 	    			   }
 		 	    		     }
 		 	    		   }
 		 	    	   });
 		 	       },
 		 	     masterTimetableBatchChange : function(form, batchId){
		 	    	   var $this=this;
		 	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
		 	    	   var wheatherSchool = alinfomodel.get('wheatherSchool');
		 	    	   var academicTermField = form.down('#academicTerm');
					   var courseVariantField = form.down('#masterCourseVariantId');
					   var programField = form.down('#masterProgramComboField');
	               	   var batchField = form.down('#masterBatch');
	               	   var periodField = form.down('#masterPeriod');
	               	   var sectionField = form.down('#masterSection');
		 	    	   
		 	    	   periodField.reset();
		 	    	   sectionField.reset();

		 	    	   periodField.setDisabled(false);
		 	    	   sectionField.setDisabled(true);

		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var periodStore = periodField.getStore();
		 	    	   periodStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   batchId:batchId
		 	    	   }
		 	    	   periodStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 0){
		 	    					   if(wheatherSchool) {
		 	    						   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		 	    					   }
		 	    				   } else if(records.length == 1){
		 	    					   periodField.setValue(records[0].data.id);
		 	    					   if(wheatherSchool) {
		 	    						   periodField.setVisible(false);
		 	    					   }
		 	    				   } else {
		 	    					   periodField.setVisible(true);
		 	    					   }
		 	    			       }
		 	    		   }
		 	    	   });
		 	       },
		 	       periodSelection : function(form, periodId) {
		 	    	   var $this = this;
		 	    	   var academicTermField = form.down('#academicTerm');
					   var courseVariantField = form.down('#masterCourseVariantId');
					   var programField = form.down('#masterProgramComboField');
	               	   var batchField = form.down('#masterBatch');
	               	   var periodField = form.down('#masterPeriod');
	               	   var sectionField = form.down('#masterSection');

		 	    	   sectionField.reset();

		 	    	   sectionField.setDisabled(false);
		 	    	   var academyLocationIds = this.getCurrentAcademyLocation();
		 	    	   var facultyId = this.getCurrentlyLoggedInUser().id;
		 	    	   var academicTermId = academicTermField.getValue();
		 	    	   var courseVariantId = courseVariantField.getValue();
		 	    	   var sectionStore = sectionField.getStore();
		 	    	   sectionStore.getProxy().extraParams = {
		 	    		   academicTermId:academicTermId,
		 	    		   facultyId: facultyId,
		 	    		   isAllProgram:true,
		 	    		   periodId:periodId,
		 	    		   courseVariantId:courseVariantId
		 	    	   }
		 	    	   sectionStore.load({
		 	    		   callback: function(records, operation, success) {
		 	    			   if (success) {
		 	    				   if(records.length == 1 && !isNullOrEmpty(courseVariantId)) {
		 	    					   sectionField.setValue(records[0].data.id)
		 	    				   }
		 	    			   }
		 	    		   }
		 	    	   });
		 	       },
});
