/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.controller.portal.OnlinePaymentPortalController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['feeandpayment.adjustment.BillReceivable'],
	views : ['studentPortal.OnlinePaymentStructureForPortal','studentPortal.OnlinePaymentGridForPortal'],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	},{
		ref: 'onlinePaymentGridForPortal',
		selector: 'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal]'
	}],
	init: function(application) {
		this.control({
			/**
			 * Online Bills Payment
			 */
			'onlinepaymentstructureforportal onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal]': {
				render: this.getLoadOnlinePaymentGrid
			},
			'onlinepaymentstructureforportal onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] numberfield[itemId=amountToBeAdjusted]': {
				change : this.setAmountToPay
			},
			'onlinepaymentstructureforportal onlinePaymentGridForPortal[itemId=onlinepaymentgridforstudentportal] button[itemId=btnView]': {
				click: this.makePaymentForStudent 
			}
		});
	},
	/**
	 * @author Rajkumar.patidar
	 */
	getLoadOnlinePaymentGrid : function(grid){
		var this$= this;
		 var personProfile = this$.getContentPanelActiveTab();
    	 var userId = personProfile.getUserId();
		if (personProfile) {
			if(!isNullOrEmpty(userId)){
				var paramss = {
						id : userId,
						billedUserType : 'STUDENT',
						adjustmentType : 'Bill Receivable',
						showAllSettlement : 'Pending'
				};
				grid.getStore().load({params:paramss});
			}
		}
	},
	setAmountToPay : function(obj,newValue){
		var grid = obj.ownerCt.grid;
		var selectedRow = grid.getSelectionModel().getSelection()[0];
		var amounttobeadjusted = obj.getValue();

		var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
		var remainingAmount = totaltempbalanceamount - amounttobeadjusted
		selectedRow.set('tempRemainingAmount',remainingAmount);

		if(totaltempbalanceamount < amounttobeadjusted){
			obj.reset();
			// selectedRow.set('totalBalanceAmount',totaltempbalanceamount);
			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('SETTLED_AMOUNT_SHOULD_BE_EQUAL_TO_BALANCE_AMOUNT'));//Please select a reco
		}
	},
	makePaymentForStudent : function(){
		var $this = this;
		var grid = this.getOnlinePaymentGridForPortal();
		 var personProfile = this$.getContentPanelActiveTab();
		 console.log('personProfile',personProfile);
    	// var userId = personProfile.getUserId();
		/*var personInfoPanel=applicantProfile.down("#personInfoPanel");
		var personDetail = applicantProfile.getApplicationDataObject().person;
		if(grid.getSelectionModel().getCount()>0){
			var records = grid.selModel.getSelection();
			var totalAmount=0;
			var totalBalanceAmount=0;
			for(var i in records){
				var balanceAmounts = records[i].get('tempRemainingAmount');
				var amounts = records[i].get('totalBalanceAmount');

				totalBalanceAmount = totalBalanceAmount + balanceAmounts;
				totalAmount = totalAmount + amounts;
			}
			if(totalBalanceAmount >=0 && totalAmount>=0){ 
				var onlineAmount=[];
				for(var i in records){
					onlineAmount.push({
						"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
						"billId":records[i].get('billHeaderId'),
						"adjustedAmount":records[i].get('totalBalanceAmount'),
						"balanceAmount": records[i].get('tempRemainingAmount')   
					});
				}
				var submitData = {
						"receiptAmount" : totalAmount,
						"onlinePayments" : onlineAmount
				};

				var amount=totalAmount;
				var name=personDetail.printName;
				var mobileNo=personDetail.mobileNumber;
				var emailId=personDetail.emailId;
				var message = 'Are you sure, you want to make payment of INR '+totalAmount+' ?';
				var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
				showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
					if (btn == 'yes') {
						var buildInfo="";
						var paymentUrl="";  
						var XMLHttpRequestObject = false;  
						if (window.XMLHttpRequest) {  
							XMLHttpRequestObject = new XMLHttpRequest();  
							XMLHttpRequestObject.overrideMimeType("text/xml");  
						}  
						else if (window.ActiveXObject) {  
							XMLHttpRequestObject = new  
							ActiveXObject("Microsoft.XMLHTTP");  
						}  
						if(XMLHttpRequestObject) {  
							XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
							XMLHttpRequestObject.onreadystatechange = function(){       
								if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200){  
									var xmlDocument = XMLHttpRequestObject.responseXML;  
									buildInfo =xmlDocument.getElementsByTagName("buildInfo") [0];  
									paymentUrl = buildInfo.getElementsByTagName("paymentUrl") [0].childNodes[0].nodeValue;
									Ext.getBody().mask('wait..', 'x-mask-loading');
									Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : submitData,
										method : 'POST',
										success : function(response, action) {
											//onlinePaymentId
											var applicantId = response.responseText;
											window.open(paymentUrl+"?applicantId="+applicantId+"&name="+name+"&emailId="+emailId+"&mobileNo="+mobileNo+"&amount="+amount+'',"Online_Payment","width=1000,height=600");
											Ext.getBody().unmask();

											var tabName = getPersonModuleTranslation('ONLINE_PAYMENT');
											var tabDetail = personInfoPanel.items.items;
											for(var i in tabDetail){
												if(tabDetail[i].title==tabName){
													tabDetail[i].close();
												}
											}
										}
									});
								}  
							} 
							XMLHttpRequestObject.send(null);  
						}
					}
				})
			}else{
				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
			}
		}else{
			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
		}*/
	} 
});
