/**
 * sumit
 */
Ext.define('Academia.controller.program.programDetail.BasicDetailProgramController',{
	extend: 'Academia.controller.base.BaseController',
	stores : [ 'common.AcademyStore', 'common.LocationStore',
	           'campaign.MediaStructureStore',
	           'common.ProgramByAcAndLoIdStore',
	           'common.UsersComboStore',
	           'program.ProgramDepartmentStore',
	           'program.ProgramGroupStore',
	           'program.SelectSucceedingProgramStore',
	           'program.ProgramMarkGradeStore',
	           'program.ProgramSubDepartmentStore',
	           'program.ProgramMasterStore',
	           'common.UsersCodeComboStore','common.AcademyLocationByAcademyId','common.AcademyLocationByName','program.ProgramCategoryStore',
	           'common.AffiliatedUniversityStore','common.HEQFLevelStore',
		          'common.AcademicAwardStore','common.ModeOfDeliveryStore','common.RegistrationTypeStore'],
	           views : [ 'program.EditBasicProgramDetailsForm' ],
	           models : [ 'common.IdValueDataModel',
	                      'program.ProgramDepartmentModel',
	                      'program.ProgramGroupModel',
	                      'program.SelectSucceedingProgramModel',
	                      'program.ProgramSubDepartmentModel',
	                      'program.ProgramGroupModel',
	                      'program.ProgramMasterModel',
	                      'program.ProgramAddEditModel',
	                      'common.IdValueCodeDataModel','common.AcademyLocationDataModel' ],
	                      refs : [ {
	                    	  ref : 'editbasicprogramdetailsform',
	                    	  selector : 'editbasicprogramdetailsform'
	                      }, {
	                    	  ref : 'programmastergrid',
	                    	  selector : 'programmastergrid'
	                      }, {
	                    	  ref : 'createeditbasicprogramdetails',
	                    	  selector : 'createeditbasicprogramdetails'
	                      }, {
	                    	  ref : 'programbatchdetailstabstructure',
	                    	  selector : 'programbatchdetailstabstructure'
	                      },{
		                	   ref: 'contentPanel',
		                	   selector: 'contentPanel'
		                   }],
	                      init : function() {this.control({
	                    	  'editbasicprogramdetailsform combo#academyIdBasicDetail' : {
	                    		  select : function(obj, record) {
	                    			  this.basicDetailAcademyCodeCombo(obj, record);
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform combo[itemId=programDepartmentBasicDetail]' : {
	                    		  select : function(obj, record) {
	                    			  this.basicDetailProgramDepartmentCombo(obj, record);
	                    		  }
	                    	  },
	                			 'editbasicprogramdetailsform combo#programGroupesmCode': {
	                				 change: function(obj, record) {
	                					 var programGroupCESMId = record;
	                					 var form = obj.up('form').getForm();
	                					 var cesmCode = form.findField("cesmCode");
	                					 cesmCode.clearValue()
	                					 var store = cesmCode.getStore();
	                					 store.getProxy().extraParams = {
	                						 programGroupCESMId: programGroupCESMId
	                					 };
	                					 store.load({
                        					 callback:function(record){
                        						 cesmCode.setDisabled(false);
                        					 }
                        				 });
	                					 
	                				 }
	                			 },
	                    	  'editbasicprogramdetailsform combo[itemId=succeedingAcademyLocationId]' : {
	                    		  select : function(obj, record) {
	                    			  var succeedingALId = record[0].get("id");
	    	                    	  var form = obj.up('form').getForm();
	             					  var succeedingProgram = form.findField('program');
	             					  succeedingProgram.reset();
	             					  succeedingProgram.setDisabled(false);
	             					  succeedingProgram.allowBlank = false;
	             					  succeedingProgram.setFieldLabel(getCommonTranslation('SELECT_SUCCEEDING_PROGRAM') + '<span class="required" style="color:red"> *</span>');
		                    		 
	             					  var programId=form.findField('id').getValue();
	    	                    	  var store = succeedingProgram.getStore();
	    	                    	  store.getProxy().extraParams = {
	    	                    		  programId:programId,
	    	                    		  academyLocationId:succeedingALId
	    	                    	  };
	    	                    	  store.load();
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform radiogroup[itemId=radioIdBasicDetail]' : {
	                    		  change : function(cb) {
	                    			  this.openCloseProgramStatusRadioBasicDetail(cb);
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform radiogroup[itemId=thereIsSucceddingProgmBasicDetail]' : {
	                    		  change : function(cb) {
	                    			  this.disableSuccedingProgramBasicDetail(cb);
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform button[itemId=editBasicProgramFormCancelButtonId]' : {
	                    		  click : function() {
	                    			  this.getEditbasicprogramdetailsform().getForm().reset();
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform button[itemId=editBasicProgramFormEditButtonId]' : {
	                    		  click : function() {
	                    			  this.updateBasicProgramTab();
	                    		  }
	                    	  },'editbasicprogramdetailsform textfield[itemId=programShortNameBasicDetail]' : {
	                    		  blur: function(t,obj) {
	                    			  /*var $this=this;
	                    			  var programbatchtabform=$this.getProgramdetailstabstructure().getForm();
	                    			  var programId=programbatchtabform.findField('ids').getValue();
	                    			  var shortName=t.getValue();
	                    			  var uniqCheckUrl=SERVERURL.PROGRAM_SHORT_NAME_CHECK_UNIQ_UPDATE_URL+'programId='+programId+'&value='+shortName;
	                    			  Ext.Ajax.request({
	                    				  type: 'rest',
	                    				  url: uniqCheckUrl,
	                    				  method: 'POST',
	                    				  success: function(f, action) {
	                    				  }
	                    			  });*/
	                    		  }
	                    	  },
	                    	  'editbasicprogramdetailsform checkboxfield[itemId=whether_Accreditation]': {
	                				 change: function() {
	                					 console.log('inchng');
	                					 this.whetherAccreditationEditChange();
	                				 }
	                			 },
	                    		 'editbasicprogramdetailsform datefield[itemId=accreditationfromDate]' : {
	                    			 change : function(field, value) {
	                    				 if(!isNullOrEmpty(value)){
	                    					 var form = this.getEditbasicprogramdetailsform().getForm();
	                        				 var date = Ext.Date.add(value,Ext.Date.DAY, +1);
	                        				 form.findField('accreditationtillDate').setMinValue(date);
	                    				 }
	                    			 }
	                    		 },'editbasicprogramdetailsform datefield[itemId=accreditationtillDate]' : {
	                    			 change : function(field, value) {
	                    				 if(!isNullOrEmpty(value)){
	                    					 var form = this.getEditbasicprogramdetailsform().getForm();
	                    					 var date = Ext.Date.add(value,Ext.Date.DAY, -1);
	                        				 var tillDate = Ext.Date.format(new Date(value), 'Y-m-d'); 
	                        				 form.findField('accreditationfromDate').setMaxValue(date);
	                    				 }
	                    			 }
	                    		 },
	                    	  'editbasicprogramdetailsform combo#academyLocationId': {
	                				 select: function(obj, record) {
	                					 var academyLocationsIds = record[0].get("id");
	                					 var form = obj.up('form').getForm();
	                					 form.findField('departmentByProgramDepartmentId').reset();
	                					 var store = this.getStore('department.DepartmentAcademyLocationWiseStore');
	                					 store.getProxy().extraParams = {
	                						 academyLocationsIds: academyLocationsIds
	                					 };
	                					 store.load();                    
	                				 }
	                			 },
	                			 'editbasicprogramdetailsform': {
	                				 validitychange: function( form, valid, eOpts ){
	                					 var me = this;
	                					 try{
		                					 if(valid){
		                						 me.getContentPanel().getActiveTab().down('#editBasicProgramFormEditButtonId').setDisabled(false);
		                					 }
		                					 else{
		                						 me.getContentPanel().getActiveTab().down('#editBasicProgramFormEditButtonId').setDisabled(true);
		                					 }
	                					 }
	                					 catch(e){
	                						 console.log('');
	                					 }
	                				 }
	                			 }
	                      });
	                      },
	                      /** currently commenting this code because it is never used */ 
	                      /*
	                      renderBasicTab : function(records) {
	                    	  var $this = this;
	                    	  var grid = this.getProgrammastergrid();
	                    	  var records = grid.getSelectionModel().getSelection()[0];
	                    	  var form = this.getEditbasicprogramdetailsform();
	                    	  var programForm = Ext.widget('programdetailstabstructure');
	                    	  var id = records.data.id;
	                    	  Ext.Ajax.request({
	                    		  method : "GET",
	                    		  type : 'rest',
	                    		  url : SERVERURL.EDIT_PROGRAM_MASTER_GRID_URL,
	                    		  headers : {
	                    			  'Content-Type' : 'application/json'
	                    		  },
	                    		  params : {
	                    			  id : id
	                    		  },
	                    		  success : function(f, action) {
	                    			  var data = f.responseText;

	                    			  var jData = Ext.JSON.decode(data);
	                    			  var basicDetailTab = new Academia.model.program.ProgramAddEditModel(jData);
	                    			  form.loadRecord(basicDetailTab);
	                    			  $this.editBasicDetailTabLoadStore(form,jData);
	                    			  if (jData.whetherCreateNewAdmission) {
	                    				  Ext.ComponentQuery.query('radiogroup#radioId1BasicDetail')[0].items.items[0].setValue(true);
	                    				  Ext.ComponentQuery.query('radiogroup#radioId1BasicDetail')[0].items.items[1].setValue(false);
	                    			  } else if (!jData.whetherCreateNewAdmission) {
	                    				  Ext.ComponentQuery.query('radiogroup#radioId1BasicDetail')[0].items.items[0].setValue(false);
	                    				  Ext.ComponentQuery.query('radiogroup#radioId1BasicDetail')[0].items.items[1].setValue(true);
	                    			  }

	                    			  if (jData.whetherSucceedingProgram) {
	                    				  Ext.ComponentQuery.query('radiogroup#thereIsSucceddingProgmBasicDetail')[0].items.items[0].setValue(true);
	                    				  Ext.ComponentQuery.query('radiogroup#thereIsSucceddingProgmBasicDetail')[0].items.items[1].setValue(false);
	                    			  } else if (!jData.whetherSucceedingProgram) {
	                    				  Ext.ComponentQuery.query('radiogroup#thereIsSucceddingProgmBasicDetail')[0].items.items[0].setValue(false);
	                    				  Ext.ComponentQuery.query('radiogroup#thereIsSucceddingProgmBasicDetail')[0].items.items[1].setValue(true);
	                    			  }

	                    			  if (jData.isSingleCourseProgram) {
	                    				  Ext.ComponentQuery.query('radiogroup#isSingleCourseRadio')[0].items.items[0].setValue(true);
	                    				  Ext.ComponentQuery.query('radiogroup#isSingleCourseRadio')[0].items.items[1].setValue(false);
	                    			  } else if (!jData.isSingleCourseProgram) {
	                    				  Ext.ComponentQuery.query('radiogroup#isSingleCourseRadio')[0].items.items[0].setValue(false);
	                    				  Ext.ComponentQuery.query('radiogroup#isSingleCourseRadio')[0].items.items[1].setValue(true);
	                    			  }
	                    			  if (jData.status == 'O') {
	                    				  Ext.ComponentQuery.query('radiogroup#radioIdBasicDetail')[0].items.items[0].setValue(true);
	                    				  Ext.ComponentQuery.query('radiogroup#radioIdBasicDetail')[0].items.items[1].setValue(false);
	                    			  } else if (jData.status == 'C') {
	                    				  Ext.ComponentQuery.query('radiogroup#radioIdBasicDetail')[0].items.items[0].setValue(false);
	                    				  Ext.ComponentQuery.query('radiogroup#radioIdBasicDetail')[0].items.items[1].setValue(true);
//	                    				  var date = new Date(jData.programClosureDate);
	                    				  Ext.ComponentQuery.query('datefield#closureDateBasicDetail')[0]
	                    				  .setValue(dateRender(jData.programClosureDate));
	                    			  }
	                    		  }
	                    	  });
	                      },
	                      editBasicDetailTabLoadStore : function(form, data) {
	                    	  var f = form.getForm();
//	                    	  var academyCombo = f.findField('academy');
//	                    	  var locationCombo = f.findField('location');
	                    	  var academyLocationCombo = f.findField('academyLocation');
	                    	  var approverUserCombo = f.findField('user');
	                    	  var programGroupCombo = f.findField('programGroup');
	                    	  var prgrmDepartmntCombo = f.findField('departmentByProgramDepartmentId');
	                    	  var prgrmSubDepartmntCombo = f.findField('departmentBySubDepartmentId');
	                    	  var programCombo = f.findField('program');
	                    	  var programMarkGradeCombo = f.findField('programMarkGrade');
	                    	  var correspondingCourse = f.findField('correspondingCourse');
	                    	  if(!isNullOrEmpty(data.correspondingCourse)) {
	                    		  correspondingCourse.setValue(data.correspondingCourse.id);
	                    	  }

	                    	  academyLocationCombo.store.load({
	                    		  callback : function(records, operation, success) {
	                    			  if (success) {
	                    				  academyCombo.setValue(data.academy.id);
	                    			  }
	                    		  }
	                    	  });
	                    	  
//	                    	  academyCombo.store.load({
//	                    		  callback : function(records, operation, success) {
//	                    			  if (success) {
//	                    				  academyCombo.setValue(data.academy.id);
//	                    			  }
//	                    		  }
//	                    	  });
//	                    	  locationCombo.store.load({
//	                    		  params : {
//	                    			  academyId : data.academy.id
//	                    		  },
//	                    		  callback : function(records, operation, success) {
//	                    			  if (success) {
//	                    				  locationCombo.setValue(data.location.id);
//	                    			  }
//	                    		  }
//	                    	  });
	                    	  approverUserCombo.store.load({
	                    		  callback : function(records, operation, success) {
	                    			  if (success) {
	                    				  approverUserCombo.setValue(data.user.id);
	                    			  }
	                    		  }
	                    	  });
	                    	  programGroupCombo.store.load({
	                    		  callback : function(records, operation, success) {
	                    			  if (success) {
	                    				  programGroupCombo.setValue(data.programGroup.id);
	                    			  }
	                    		  }
	                    	  });
	                    	  prgrmDepartmntCombo.store
	                    	  .load({
	                    		  params:{
	 	                			 academyLocationsIds: data.academy.id
	 	                		 },
	                    		  callback : function(records, operation,success) {
	                    			  if (success) {
	                    				  prgrmDepartmntCombo.setValue(data.departmentByProgramDepartmentId.id);
	                    			  }
	                    		  }
	                    	  });
	                    	  prgrmSubDepartmntCombo.store
	                    	  .load({
	                    		  params : {
	                    			  parentId : data.departmentByProgramDepartmentId.id
	                    		  },
	                    		  callback : function(records, operation,success) {
	                    			  if (success) {
	                    				  prgrmSubDepartmntCombo.setValue(data.departmentBySubDepartmentId.id);
	                    			  }
	                    		  }
	                    	  });
	                    	  if (data.program != null) {
	                    		  programCombo.store
	                    		  .load({
	                    			  callback : function(records, operation,success) {
	                    				  if (success) {
	                    					  programCombo.setValue(data.program.id);
	                    				  }
	                    			  }
	                    		  });
	                    	  }
	                    	  programMarkGradeCombo.store
	                    	  .load({
	                    		  callback : function(records, operation,
	                    				  success) {
	                    			  if (success) {
	                    				  if (data.programMarkGrade == 'M') {
	                    					  programMarkGradeCombo.setValue('MARK');
	                    				  } else {
	                    					  programMarkGradeCombo.setValue('GRADE');
	                    				  }
	                    			  }
	                    		  }
	                    	  });
	                      },*/
	                      basicDetailAcademyCodeCombo : function(o, r) {
	                    	  var academyId = r[0].get("id");
	                    	  var store = this.getStore('common.AcademyLocationByAcademyId');
	                    	  store.getProxy().extraParams = {
	                    		  id : academyId
	                    	  };
	                    	  store.load();
	                      },
	                      basicDetailProgramDepartmentCombo : function(o, r) {
	                    	  var programDepartmentId = r[0].get("id");
	                    	  var form = o.up('form').getForm();
         					   form.findField('departmentBySubDepartmentId').reset();
	                    	  var store = this.getStore('program.ProgramSubDepartmentStore');
	                    	  store.getProxy().extraParams = {
	                    		  parentId : programDepartmentId
	                    	  };
	                    	  store.load();
	                      },
	                      openCloseProgramStatusRadioBasicDetail : function(cb) {
	                    	  var closrDte = Ext.ComponentQuery.query('datefield#closureDateBasicDetail')[0];
	                    	  var closrReasn = Ext.ComponentQuery.query('textfield#closureReasonBaisDetail')[0];
	                    	  var this$ = this.getEditbasicprogramdetailsform().getForm();
	                    	  if (cb.getValue().status == 'O' || cb.getValue().programStatus == 'O') {
	                    		  closrDte.allowBlank = true;
	                    		  closrReasn.allowBlank = true;
	                    		  this.setAllowBlank(closrDte, true);
	                    		  this.setAllowBlank(closrReasn, true);
	                    		  closrDte.hide();
	                    		  closrReasn.hide()
	                    		  this$.isValid();
	                    	  } else if (cb.getValue().status == 'C' || cb.getValue().programStatus == 'C') {
	                    		  closrDte.allowBlank = false;
	                    		  closrReasn.allowBlank = false;
	                    		  this.setAllowBlank(closrDte, false);
	                    		  this.setAllowBlank(closrReasn, false);
	                    		  closrDte.show();
	                    		  closrReasn.show();
	                    		  this$.isValid();
	                    	  }
	                      },
	                      disableSuccedingProgramBasicDetail : function(cb) {
	                    	  var this$ = this.getEditbasicprogramdetailsform().getForm();
	                    	  var slctSucdngPrgrm = Ext.ComponentQuery.query('combo#ceb_spIdBasicDetail')[0];
	                    	  var programId=this$.findField('id').getValue();
	                    	  var store=slctSucdngPrgrm.getStore();
	                    	  var radioSuccedding = Ext.ComponentQuery.query('radiogroup#radioId1BasicDetail')[0];
	                    	  var succeedingAcademyLocation = this$.findField('succeedingAcademyLocation');
	                    	  if (cb.getValue().whetherSucceedingProgram) {
	                    		  succeedingAcademyLocation.enable();
	                    		  succeedingAcademyLocation.allowBlank = false;
	                    		 // slctSucdngPrgrm.setFieldLabel(getCommonTranslation('SELECT_SUCCEEDING_PROGRAM') + '<span class="required" style="color:red"> *</span>');
	                    		  radioSuccedding.allowBlank = false;
	                    		  radioSuccedding.enable();
	                    		  /*store.getProxy().extraParams = {
	                    			  programId:programId
	                    		  };
	                    		  store.load();*/
	                    		  this$.isValid();
	                    	  } else {
	                    		  slctSucdngPrgrm.disable();
	                    		  slctSucdngPrgrm.clearValue();
	                    		  slctSucdngPrgrm.allowBlank = true;
	                    		  slctSucdngPrgrm.setFieldLabel(getCommonTranslation('SELECT_SUCCEEDING_PROGRAM'));
	                    		  radioSuccedding.allowBlank = true;
	                    		  radioSuccedding.reset();
	                    		  radioSuccedding.disable();
	                    		  succeedingAcademyLocation.disable();
	                    		  succeedingAcademyLocation.clearValue();
	                    		  succeedingAcademyLocation.allowBlank = true;
	                    		  this$.isValid();
	                    	  }
	                      }, 
	                      updateBasicProgramTab:function(){
	                    	  var this$ = this;
	                    	  var f = this.getEditbasicprogramdetailsform().getForm();
	                    	 
	                    	  var academyLocation =f.findField('academyLocation').getValue();
	                    	  var approverCordntrUserCombo=f.findField('coordinator');
	                    	  var cordnatorCode=approverCordntrUserCombo.findRecordByValue(approverCordntrUserCombo.getValue()).data.code;
	                    	  var programGroupCombo=f.findField('programGroup');
	                    	  var programCategoryCombo=f.findField('programCategory');
	                    	  var prgrmDepartmntCombo=f.findField('departmentByProgramDepartmentId');
	                    	  var prgrmSubDepartmntCombo=f.findField('departmentBySubDepartmentId');
	                    	  var programCombo=f.findField('program');
	                    	  var affiliatedUniversity=f.findField('affiliatedUniversity');
	                    	  var programPhase=f.findField('programPhase');
	                    	  var whetherCreateNewAdmission = f.findField('whetherCreateNewAdmission').getValue();
	                    	  var values = f.getValues();
	                    	  if(!values.programCode){
	                    		  showWarningMessage(getCommonTranslation('ALERT'), 
	     	        					getCommonTranslation('PROGRAM_CODE_CAN_NOT_BE_EMPTY')); 
	                    		  return false;
	                    	  }
	                    	  var date=values.programClosureDate;
	                    	  var editBasicProgramDetailsTabform= new Academia.model.program.ProgramAddEditModel();
	                    	  var whetherAccreditation =f.findField('whether_Accreditation').getValue();
	                    	  editBasicProgramDetailsTabform.set("id",values.id);
	                    	  editBasicProgramDetailsTabform.set("programCode",values.programCode);
	                    	  editBasicProgramDetailsTabform.set("programName",values.programName);
	                    	  editBasicProgramDetailsTabform.set("programShortName",values.programShortName);
	                    	  editBasicProgramDetailsTabform.set("isLongDistanceProgram",values.isLongDistanceProgram);
	                    	  editBasicProgramDetailsTabform.set("academyLocation",this.getIdValueJson(academyLocation));
	                    	  editBasicProgramDetailsTabform.set("whetherAccreditation",whetherAccreditation);
	                    	  editBasicProgramDetailsTabform.set("graduationCertificateToBePrint",values.graduationCertificateName);
	                    	  editBasicProgramDetailsTabform.set("printNameInOtherLanguage1",values.printNameInOtherLanguage1);
	                    	  editBasicProgramDetailsTabform.set("printNameInOtherLanguage2",values.printNameInOtherLanguage2);
	                         	if (whetherAccreditation) {
	                         		editBasicProgramDetailsTabform.set("accreditationFromDate",values.accreditationfromDate);
	                         		editBasicProgramDetailsTabform.set("accreditationTillDate", values.accreditationtillDate);
	       	                	editBasicProgramDetailsTabform.set("accreditationProgramAccreditation",values.accreditationprogramAccreditation);
	                         	}
	                    	  
	                    	  if(!isNullOrEmpty(values.certificateType)){
	                    		 if(values.certificateType=="Certificate of Attendance"){
		                    	  editBasicProgramDetailsTabform.set("certificateType","CERTIFICATE_OF_ATTENDANCE");
		                    	  }else if(values.certificateType=="Certificate of Competence"){
		                    		  editBasicProgramDetailsTabform.set("certificateType","CERTIFICATE_OF_COMPETENCE");
		                    	  }else{
		                    		  editBasicProgramDetailsTabform.set("certificateType",null);
		                    		  }
		                    	  
	                    	  }
	                    	  
	                    	  editBasicProgramDetailsTabform.set("program",this.getIdValueJson(programCombo.getValue(),programCombo.getRawValue(),values.programIdCode));
	                    	  editBasicProgramDetailsTabform.set("programGroup",this.getIdValueJson(programGroupCombo.getValue(),programGroupCombo.getRawValue()));
	                    	  editBasicProgramDetailsTabform.set("programCategory",this.getIdValueJson(programCategoryCombo.getValue(),programCategoryCombo.getRawValue()));
	                    	  editBasicProgramDetailsTabform.set("departmentByProgramDepartmentId",this.getIdValueJson(prgrmDepartmntCombo.getValue(),prgrmDepartmntCombo.getRawValue()));
	                    	  editBasicProgramDetailsTabform.set("departmentBySubDepartmentId",this.getIdValueJson(prgrmSubDepartmntCombo.getValue(),prgrmSubDepartmntCombo.getRawValue()));
	                    	  editBasicProgramDetailsTabform.set("programNameToBePrint",values.programNameToBePrint);
	                    	  editBasicProgramDetailsTabform.set("status",values.programStatus);
	                    	  if(values.programMarkGrade=='MARK'){
	                    		  editBasicProgramDetailsTabform.set("programMarkGrade",'M');	 
	                    	  }else if(values.programMarkGrade=='GRADE'){
	                    		  editBasicProgramDetailsTabform.set("programMarkGrade",'G');
	                    	  }
	                    	  
	                    	  var programCourseGroupIds = [];
	    	                  if(!isNullOrEmpty(values.programCourseGroupMapping) && values.programCourseGroupMapping !=undefined ){
	        		          if(typeof values.programCourseGroupMapping == "object"){
	            		        Ext.each(values.programCourseGroupMapping, function(courseGroupId){
	                    	         var courseGroup = '';
                                     var program  = ''; 
	                                   if(!isNullOrEmpty(courseGroupId)){
	                    	                mainObj = {
	                    			             "courseGroup" : {
	                    					     "id" : courseGroupId.data.id,
	                    						 "code":courseGroupId.data.code,
	                    					     "groupName":courseGroupId.data.groupName
	                    			                  },
	                    			             "program" : {
	                    					      "id": f.findField('id').getValue()
	                    		                	}		
	                    	     }
	                    	   programCourseGroupIds.push(mainObj);
	                         }
                             });
                             }
                      
        	         	else{
        			         var courseGroup = '';
	                	     var program = '';
	                	     var mainObj = '';
	                	     mainObj = {
	                			"courseGroup" : {
	                					"id" : courseGroupId.data.id,
	                    				"code":courseGroupId.data.code,
	                    				"groupName":courseGroupId.data.groupName
	                			},
	                			"program" : {
	                					"id": f.findField('id').getValue()
	                			}		
	                	      }
	                	     programCourseGroupIds.push(mainObj);
	        		         }
	        	         }
	                    	  editBasicProgramDetailsTabform.set("programCourseGroupMapping",programCourseGroupIds);
	                    	  editBasicProgramDetailsTabform.set("whetherSucceedingProgram",values.whetherSucceedingProgram);
	                    	  editBasicProgramDetailsTabform.set("succeedingAcademyLocationId",values.succeedingAcademyLocation);
	                    	  editBasicProgramDetailsTabform.set("whetherCreateNewAdmission",whetherCreateNewAdmission);
	                    	  editBasicProgramDetailsTabform.set("isPeriodTransitionApplicable",values.periodTransitionRadioGroup);
	                    	  editBasicProgramDetailsTabform.set("remark",values.remark);
	                    	  editBasicProgramDetailsTabform.set("user",this.getIdValueJson(approverCordntrUserCombo.getValue(),approverCordntrUserCombo.getRawValue(),cordnatorCode));
	                    	  editBasicProgramDetailsTabform.set("affiliatedUniversity", this.getIdValueJson(values.affiliatedUniversity));
	                    	  editBasicProgramDetailsTabform.set("programPhase", this.getIdValueJson(values.programPhase));
	                    	  editBasicProgramDetailsTabform.set("programSequence", values.programSequence);
	                    	  if(values.programStatus=='C'){
	                    		  editBasicProgramDetailsTabform.set("programClosureDate",date);   
	                    		  editBasicProgramDetailsTabform.set("programClosureReason",values.programClosureReason);
	                    	  }else{
	                    		  editBasicProgramDetailsTabform.set("programClosureDate");	 
	                    		  editBasicProgramDetailsTabform.set("programClosureReason");
	                    	  }
	                    	  editBasicProgramDetailsTabform.set("version",values.version);
	                    	  editBasicProgramDetailsTabform.set("isSingleCourseProgram",values.isSingleCourseProgram);
	                    	  /*if(values.isSingleCourseProgram.length>1){
	                    		  editBasicProgramDetailsTabform.set("isSingleCourseProgram",values.isSingleCourseProgram[1]); 
	                    	  }else{
	                    		  editBasicProgramDetailsTabform.set("isSingleCourseProgram",values.isSingleCourseProgram);  
	                    	  }*/
	                    	  
	                    	  editBasicProgramDetailsTabform.set("correspondingCourse",this.getIdValueJson(values.correspondingCourse));
	                    	  editBasicProgramDetailsTabform.set("heqfLevel", this.getIdValueJson(values.heqfLevel));
	                    	  editBasicProgramDetailsTabform.set("academicAward", this.getIdValueJson(values.academicAward));
	                    	  editBasicProgramDetailsTabform.set("modeOfDelivery", this.getIdValueJson(values.modeOfDelivery));
	                    	 
	                    	  /**
	 	                	  * Other Details fieldset field
	 	                	  */
	 	                	 editBasicProgramDetailsTabform.set("programNameLanguageOne",values.programNameLanguageOne);
	 	                	 editBasicProgramDetailsTabform.set("programShortNameLanguageOne",values.programShortNameLanguageOne);
	 	                	 editBasicProgramDetailsTabform.set("programNameToBePrintLanguageOne",values.programNameToBePrintLanguageOne);
	 	                	 editBasicProgramDetailsTabform.set("programNameLanguageTwo",values.programNameLanguageTwo);
	 	                	 editBasicProgramDetailsTabform.set("programShortNameLanguageTwo",values.programShortNameLanguageTwo);
	 	                	 editBasicProgramDetailsTabform.set("programNameToBePrintLanguageTwo",values.programNameToBePrintLanguageTwo);
	 	                	 editBasicProgramDetailsTabform.set("programNameLanguageThree",values.programNameLanguageThree);
	 	                	 editBasicProgramDetailsTabform.set("programShortNameLanguageThree",values.programShortNameLanguageThree);
	 	                	 editBasicProgramDetailsTabform.set("programNameToBePrintLanguageThree",values.programNameToBePrintLanguageThree);
	 	                	 editBasicProgramDetailsTabform.set("programRegistrationId",values.programRegistrationId);
	 	                	 editBasicProgramDetailsTabform.set("educationDepartmentProgramCode",values.educationDepartmentProgramCode);
	 	                	 editBasicProgramDetailsTabform.set("educationDepartmentRegistrationDate",values.educationDepartmentRegistrationDate);
	 	                	 editBasicProgramDetailsTabform.set("registrationType", this.getIdValueJson(values.registrationType));
	 	                	 editBasicProgramDetailsTabform.set("programDesignator",values.programDesignator);
	 	                	 editBasicProgramDetailsTabform.set("programQualifier",values.programQualifier);
	 	                	 editBasicProgramDetailsTabform.set("programSecondQualifier",values.programSecondQualifier);
	 	                	 editBasicProgramDetailsTabform.set("fieldOfStudyLanguageTwo",values.fieldOfStudyLanguageTwo);
	 	                	 editBasicProgramDetailsTabform.set("fieldOfStudyOtherLanguage",values.fieldOfStudyOtherLanguage);
	 	                	 editBasicProgramDetailsTabform.set("programSubMerchantId",values.programSubMerchant);
	 	                	 var programAreaOfInterests = [];
	 	                	 if(values.areaOfInterest && values.areaOfInterest.length){
	 	                		if(values.areaOfInterest.length == 1 && typeof values.areaOfInterest[0] == "string" && isNullOrEmpty(values.areaOfInterest[0])){
	 	                			programAreaOfInterests = [];
	 	                		}
	 	                		else{
	 	                			Ext.each(values.areaOfInterest, function(currentAreaOfInterest){
	 	                				if(typeof currentAreaOfInterest == "object"){
	 	                					programAreaOfInterests.push({
	 	                						program:{
	 	                							id: null
	 	                						},
	 	                						areaOfInterest:{
	 	                							id:currentAreaOfInterest.data.id
	 	                						}
	 	                					});
	 	                				}
	 	                				else{
	 	                					programAreaOfInterests.push({
	 	                						program:{
	 	                							id: null
	 	                						},
	 	                						areaOfInterest:{
	 	                							id:currentAreaOfInterest
	 	                						}
	 	                					});
	 	                				}
	 	                			});
	 	                		}
	 	                	 }
	 	                	editBasicProgramDetailsTabform.set("programAreaOfInterests",programAreaOfInterests);
	 	                	 
	 	                	 /**
	 	                	  * Catalogue Details fieldset field
	 	                	  */
	 	                	 editBasicProgramDetailsTabform.set("duration",values.duration);
	 	                	 editBasicProgramDetailsTabform.set("presentationLanguageId",values.presentationLanguage);
	 	                	 editBasicProgramDetailsTabform.set("programCESM", this.getIdValueJson(values.cesmCode));
	 	                	 editBasicProgramDetailsTabform.set("programGroupCESM", this.getIdValueJson(values.programGroupesmCode));
	 	                	 /** fieldOfStudy is commented because currently it is not created */
//	 	                	 editBasicProgramDetailsTabform.set("fieldOfStudy",values.fieldOfStudy);
	 	                	 
	 	                	 editBasicProgramDetailsTabform.set('isHtmlContent', values.isHtmlContent);
	 	                	
	 	                	 if(values.isHtmlContent){
	 	                		 editBasicProgramDetailsTabform.set("bursaryInformation","");
	 	                		 editBasicProgramDetailsTabform.set("admissionRequirements","");
	 	                		 editBasicProgramDetailsTabform.set("selectionCriteria","");
	 	                	 }
	 	                	 else{
	 	                		 editBasicProgramDetailsTabform.set("bursaryInformation",values.bursaryInformation_txt);
	 	                		 editBasicProgramDetailsTabform.set("admissionRequirements",values.admissionRequirements_txt);
	 	                		 editBasicProgramDetailsTabform.set("selectionCriteria",values.selectionCriteria_txt);
	 	                	 }
	 	                	 
	 	                	 editBasicProgramDetailsTabform.set("videoURL",values.videoURL);
	 	                	 editBasicProgramDetailsTabform.set("publishInCatalogue",values.publishInCatalogue);
	 	                	 editBasicProgramDetailsTabform.set("customData",values.customData);
	 	                	 editBasicProgramDetailsTabform.set("saqaId",values.saqaId);
	 	                	 editBasicProgramDetailsTabform.set("programEndorsement",this.getIdValueJson(values.programEndorsement));
	 	                	var docStore = this$.getStore('program.programDetails.programBatches.ProgramDocumentStore');
		                	 var docArray = [];
		                	 if (docStore.data.items != null
		                			 && docStore.data.items.length > 0) {
		                		 Ext.each(docStore.data.items, function(val) {
		                			 var newData = {
		                					 "id" : val.data.documentId,
		                					 "name" : val.data.documentName,
		                					 "path" : val.data.path,
		                					 "type" : "DOCUMENT",
		                					 "createdBy" : this$.getIdValueJson(
		                							 val.data.createdBy.id,
		                							 val.data.createdBy.value)
		                			 };
		                			 var programDoc = {
		                					 "id" : val.data.id,
		                					 "document" : newData,
		                					 "fileType" :val.data.fileType
		                			 }
		                			 docArray.push(programDoc);
		                		 });
		                	 }
		                	 editBasicProgramDetailsTabform.set("programDocuments", docArray);

		                	 if(values.isHtmlContent){
		                		 var bursaryInformationdata = f.findField('bursaryInformation').editor.document.getBody().getText();
		                		 var admissionRequirements = f.findField('admissionRequirements').editor.document.getBody().getText();
		                		 var selectionCriteria = f.findField('selectionCriteria').editor.document.getBody().getText();
		                	 }
		                	 else {
		                		 var bursaryInformationdata = values.bursaryInformation_txt;
		                		 var admissionRequirements = values.admissionRequirements_txt;
		                		 var selectionCriteria = values.selectionCriteria_txt;
		                	 }
		                	 
		                	if(bursaryInformationdata.length<=5000 && admissionRequirements.length<=5000 && selectionCriteria.length<=5000)
		 	                		{
		 	                		 var fData = Ext.encode(editBasicProgramDetailsTabform.data);
			                    	  submitUrl = SERVERURL.UPDATE_PROGRAM_BASIC_TAB_URL;
			                    	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			                    	  Ext.Ajax.request({
			                    		  type: 'rest',
			                    		  url: submitUrl,
			                    		  jsonData: fData,
			                    		  method: 'POST',
			                    		  success: function(f, action) {
			                    			  Ext.getBody().unmask();
			                    			  if(f.responseText == "DUPLICATE_SEQUENCE_NUMBER"){
			  	     	        				showWarningMessage(getCommonTranslation('ALERT'), 
			  	     	        						getCommonTranslation('THIS_SEQUENCE_ALREADY_EXISTS'));
			  	     	        			} else if (f.responseText == "DUPLICATE_PROGRAM") {
				     	        				showWarningMessage(getCommonTranslation('ALERT'), 
				     	        						getProgramandcourseTranslation('PROGRAM_CODE_IS_ALREADY_EXIST'));
				     	        			} 
			  	     	        			else if(f.responseText == "ADMISSION_REQUIREMENT_LIMIT_EXCEED") {
		 	                					showWarningMessage(getCommonTranslation('ALERT'), 
		 	                							getProgramandcourseTranslation('ADMISSION_REQUIREMENT_LIMIT_EXCEED'));
		 	                				}else {
			  	     	        				showSuccessMessage(getCommonTranslation('PROGRAMINFOTITLE'), getCommonTranslation('SUCCESS'));
				                    			  this$.getStore('program.ProgramMasterStore').load();
				                    			  this$.closeProgramDetailTab();
			  	     	        			}
			                    		  }
			                    	  });
		 	                		}else{
		 	                			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('EDITOR_LIMIT_VALIDATION'));
		 	                		}
	                    	 
	                      },
	                      getIdValueJson: function(id, value,code) {
	                    	  if (id) return {
	                    		  id: id,
	                    		  value: value,
	                    		  code: code
	                    	  };
	                      },
	                      getLocationObjectJson: function(locationObject) {

	                    	  if (locationObject) return {
	                    		  id: locationObject.id,
	                    		  academyId :locationObject.academyId,
	                    		  locationId: locationObject.locationId,
	                    		  locationName: locationObject.locationName
	                    	  };
	                      },
	                      closeProgramDetailTab:function(){
		                	   var tabName = getProgramandcourseTranslation('PROGRAM_DETAILS');
		                	   var contentpanel = this.getContentPanel();
		                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		                	   var getTab=getcontroller.getTab(tabName);
		                	   if(getTab!=null){
		                		   contentpanel.remove(getTab, true);
		                	   }
		                   },
	                      whetherAccreditationEditChange : function() {
           		    	   var this$ = this;
           		    	 var forms = this.getEditbasicprogramdetailsform();
     	                	 var form = this.getEditbasicprogramdetailsform().getForm();
     	                	 var whetherAccreditation =form.findField('whether_Accreditation').getValue();
     	                	 
     	                	var fromDate = form.findField('accreditationfromDate');
                       	var tillDate = form.findField('accreditationtillDate');
                       	var accreditationprogramAccreditation = form.findField('accreditationprogramAccreditation');
                       	if (whetherAccreditation) {
                       		fromDate.setVisible(true);
                       		tillDate.setVisible(true);
                       		accreditationprogramAccreditation.setVisible(true);
                       		fromDate.allowBlank=false;
                       		tillDate.allowBlank=false;
                       		accreditationprogramAccreditation.allowBlank=false;
                       	 
                       	} else {
                       		tillDate.reset();
                       		fromDate.reset();
                       		tillDate.setMinValue(null);
                    		fromDate.setMaxValue(null);
                       		accreditationprogramAccreditation.reset();
                       		tillDate.setVisible(false);
                       		fromDate.setVisible(false);
                       		accreditationprogramAccreditation.setVisible(false);
                       		fromDate.allowBlank=true;
                       		tillDate.allowBlank=true;
                       		accreditationprogramAccreditation.allowBlank=true;
                       	}
                        if(form.isValid()){
                        	forms.down('#editBasicProgramFormEditButtonId').setDisabled(false);
                   	   }else{
                   		forms.down('#editBasicProgramFormEditButtonId').setDisabled(true);
                   	   }
           		    	   console.log('onChange')
           		       },

});