/**
 * @author Seshagiri.k
 */
Ext.define('Academia.controller.program.reports.ProgramReportController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['program.reports.ProgramReportTabStore','common.AcademyLocationByAcademyId','common.ProgramByAcademyLocationStore',
             'enquiry.AcademicBatchStore','common.AcademyLocationNameSeparated'],
    views: ['program.reports.ProgramReportStructure',
            'program.reports.ProgramReportSearchForm',
            'program.reports.ProgramReportTreePanelAndGrid',
            'program.reports.ProgramReportTabStructure',
            'program.reports.programreporttab.ProgramReportBasicInfoForm',
            'program.reports.programreporttab.ProgramReportPeriodAssociatedStructure',
            'program.reports.programreporttab.ProgramReportAssociatedExamCenterStructure',
            'program.reports.programreporttab.ProgramReportSpecializationAvailableStructure',
            'program.reports.programreporttab.ProgramReportBatchCreatedProgramWiseStructure',
            'program.reports.programreporttab.ProgramReportSectionAssociatedStructure'],
            config: {
            	PANDCDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PANDCDASHBOARD_PRIVILEGES'),
            	PROGRAM_BATCH_ASSOCIATED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_BATCH_ASSOCIATED_PRIVILIGES'),
            	PROGRAM_PERIOD_ASSOCIATED_PRIVILIGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_PERIOD_ASSOCIATED_PRIVILIGES'),
            	PROGRAM_EXAM_CENTER_ASSOCIATED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_EXAM_CENTER_ASSOCIATED_PRIVILIGES'),
            	PROGRAM_SECTION_ASSOCIATED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_SECTION_ASSOCIATED_PRIVILIGES'),
            	PROGRAM_SPECIALIZATION_ASSOCIATED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROGRAM_SPECIALIZATION_ASSOCIATED_PRIVILIGES')
            },
    refs: [{
        ref: 'programreportstructure',
        selector: 'programreportstructure'
    },{
        ref: 'programreporttreepanelandgrid',
        selector: 'programreporttreepanelandgrid'
    },{
        ref: 'programreporttabstructure',
        selector: 'programreporttabstructure'
    },{
        ref: 'programreportsearchform',
        selector: 'programreportsearchform'
    },/*{
        ref: 'searchresultgrid',
        selector: 'searchresultgrid'
    },*/{
        ref: 'searchresultgrid',
        selector: 'programReportPeriodAssociatedStructure [itemId=programReportPeriodAssociatedGrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'programReportAssociatedExamCenterStructure [itemId=programReportAssociatedExamCenterGrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'programReportSpecializationAvailableStructure [itemId=programReportSpecializationAvailableGrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'programReportBatchCreatedProgramWiseStructure [itemId=programReportBatchCreatedProgramWiseGrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'programReportSectionAssociatedStructure [itemId=programReportSectionAssociatedStructureGrid]'
    }],
    
    init: function() {
        this.control({
        	/*FixingColumnHeader PNC ProgramReport all ScreensInSideTabpanel*/
        	'programreportstructure':{
        		afterrender : function(structure){
        			var $this = this;
        			var programreporttreepanelandgrid = structure.down('#programreporttreepanelandgridId');
        			structure.body.on('scroll', function(e, target) {
        				var activeTab = structure.down('#tabpanelIds').getActiveTab();
        				if(!isNullOrEmpty(activeTab)){
        					var baseStructure = activeTab;
        					var grid = activeTab.down('searchresultgrid');
        					if(grid != undefined){
        						$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
        					}else{
        						grid = activeTab.down('grid');
        						$this.getMultipleGridHeaderFreeze(grid,structure,true); 
        					}
        				}
        			});
        		} 
        	},
        	/*	'programreportstructure':{
        		afterrender : function(structure){
        			var $this = this;
        			var searchForm = structure.down('programreportsearchform');
        			var programreporttreepanelandgrid = structure.down('programreporttreepanelandgrid');
        			var programreporttabstructure = programreporttreepanelandgrid.down('programreporttabstructure');
        			structure.body.on('scroll', function(e, target) {
        				var activeTab = programreporttabstructure.items.items[0];
        				if(!isNullOrEmpty(activeTab)){
        					var grid = activeTab.items.items[0];
        					$this.getMultipleCBGridHeaderFreeze(grid,structure);	
        				}
        			});
        		} 

        	},*/
        	'programreporttreepanelandgrid panel[itemId=programReportLinkItemId] treepanel[itemId=programReportTreePanelItemId]' : {
  			   render:function(obj){
  				   var $this = this;
  				   var reportParantNode = $this.getProgramreporttreepanelandgrid().down('treepanel').getStore().tree.root;
  				  $this.applyPermissionOnNodes(reportParantNode);
  			   },
  			  itemclick : this.getOpenProgramReportStructure
  		   },
          'programreportsearchform button[itemId=btnSearch]': {
        	  click: function(){
        		  this.programReportSearchButton();  
        	  }
          	},
          	'programReportPeriodAssociatedStructure searchresultgrid[itemId=programReportPeriodAssociatedGrid]': {
                afterrender: function(grid) {
                	 this.gridRenderFunction(grid);
      				 this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_PERIOD_ASSOCIATED_PRIVILIGES_PERMISSIONS());
                	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_PERIOD_ASSOCIATED_VIEWCODE,
                			CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
                }
            },
            'programReportAssociatedExamCenterStructure searchresultgrid[itemId=programReportAssociatedExamCenterGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
                	this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_EXAM_CENTER_ASSOCIATED_PERMISSIONS());
                	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_VIEWCODE,
   						 CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
                }
            },
            'programReportSpecializationAvailableStructure searchresultgrid[itemId=programReportSpecializationAvailableGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
      				 this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_SPECIALIZATION_ASSOCIATED_PERMISSIONS());
                	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_VIEWCODE,
   						 CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE, getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
                }
            },
            'programReportBatchCreatedProgramWiseStructure searchresultgrid[itemId=programReportBatchCreatedProgramWiseGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
      				 this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_BATCH_ASSOCIATED_PERMISSIONS());
                	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_VIEWCODE,
   						 CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
                }
            },
            'programReportSectionAssociatedStructure searchresultgrid[itemId=programReportSectionAssociatedStructureGrid]': {
                afterrender: function(grid) {
                	this.gridRenderFunction(grid);
      				 this.genericCBGridAccessControlValidation(grid,this.getPROGRAM_SECTION_ASSOCIATED_PERMISSIONS());
                	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_SECTION_ASSOCIATED_VIEWCODE,
   						 CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
                }
            },
          //***1**************Export For Report**********************************************************************
			  'programReportPeriodAssociatedStructure [itemId=programReportPeriodAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programReportPeriodAssociatedGrid',CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
		            }
		        },
		        'programReportPeriodAssociatedStructure [itemId=programReportPeriodAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programReportPeriodAssociatedGrid',CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
		            }
		        },
		        'programReportPeriodAssociatedStructure [itemId=programReportPeriodAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programReportPeriodAssociatedGrid',CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
		            }
		        },
		        'programReportPeriodAssociatedStructure [itemId=programReportPeriodAssociatedGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programReportPeriodAssociatedGrid',CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
		            }
		        },
		       //***2*************************************************************************************************** 
		        'programReportAssociatedExamCenterStructure [itemId=programReportAssociatedExamCenterGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programReportAssociatedExamCenterGrid',CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
		            }
		        },
		        'programReportAssociatedExamCenterStructure [itemId=programReportAssociatedExamCenterGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programReportAssociatedExamCenterGrid',CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
		            }
		        },
		        'programReportAssociatedExamCenterStructure [itemId=programReportAssociatedExamCenterGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programReportAssociatedExamCenterGrid',CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
		            }
		        },
		        'programReportAssociatedExamCenterStructure [itemId=programReportAssociatedExamCenterGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programReportAssociatedExamCenterGrid',CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
		            }
		        },  
		      //****3**********************************************************************************************************
		        'programReportSpecializationAvailableStructure [itemId=programReportSpecializationAvailableGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programReportSpecializationAvailableGrid',CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE,getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
		            }
		        },
		        'programReportSpecializationAvailableStructure [itemId=programReportSpecializationAvailableGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programReportSpecializationAvailableGrid',CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE,getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
		            }
		        },
		        'programReportSpecializationAvailableStructure [itemId=programReportSpecializationAvailableGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programReportSpecializationAvailableGrid',CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE,getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
		            }
		        },
		        'programReportSpecializationAvailableStructure [itemId=programReportSpecializationAvailableGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programReportSpecializationAvailableGrid',CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE,getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
		            }
		        },
		      //***4**********************************************************************************************************  
		        'programReportBatchCreatedProgramWiseStructure [itemId=programReportBatchCreatedProgramWiseGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programReportBatchCreatedProgramWiseGrid',CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
		            }
		        },
		        'programReportBatchCreatedProgramWiseStructure [itemId=programReportBatchCreatedProgramWiseGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programReportBatchCreatedProgramWiseGrid',CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
		            }
		        },
		        'programReportBatchCreatedProgramWiseStructure [itemId=programReportBatchCreatedProgramWiseGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programReportBatchCreatedProgramWiseGrid',CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
		            }
		        },
		        'programReportBatchCreatedProgramWiseStructure [itemId=programReportBatchCreatedProgramWiseGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programReportBatchCreatedProgramWiseGrid',CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
		            }
		        },
		      //**5***********************************************************************************************************  
		        'programReportSectionAssociatedStructure [itemId=programReportSectionAssociatedStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,grid,'programReportSectionAssociatedStructureGrid',CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
		            }
		        },
		        'programReportSectionAssociatedStructure [itemId=programReportSectionAssociatedStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportPdfAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true,grid,'programReportSectionAssociatedStructureGrid',CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
		            }
		        },
		        'programReportSectionAssociatedStructure [itemId=programReportSectionAssociatedStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,grid,'programReportSectionAssociatedStructureGrid',CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
		            }
		        },
		        'programReportSectionAssociatedStructure [itemId=programReportSectionAssociatedStructureGrid] splitbutton[itemId=exportToPdfBtn] #exportExcelAll': {
		            click: function(obj) {
		            	var grid = obj.ownerCt.ownerButton.ownerCt.ownerCt;
		            	this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,grid,'programReportSectionAssociatedStructureGrid',CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
		            }
		        },
		      //*********************************************************************************************************************         
	       	'programreportsearchform combo[itemId=academyLocationId]': {
	      		 select: function(obj, record) {	      			 
	      			var locationId = record[0].get("id");
	      			 obj.ownerCt.nextSibling().items.items[0].clearValue();
	      			var form = this.getProgramreportsearchform();
	      			 form.down('#programId').setDisabled(false);
	      			 var store = this.getStore('common.ProgramByAcademyLocationStore');
	      			 store.getProxy().extraParams = {
	      				academyLocationId: locationId
	      			 };
	      			 store.load();                  
	      		 }	      		 	      		
	      	 },
	      	 
	      	'programreportsearchform combo[itemId=programId]': {
	      		 select: function(obj, record) {
	      			var programId = record[0].get("id");
	      			 obj.nextSibling().clearValue();
	      			var form = this.getProgramreportsearchform();
	      			 form.down('#batchId').setDisabled(false);
	      			 var store = this.getStore('enquiry.AcademicBatchStore');
	      			 store.getProxy().extraParams = {
	      				id: programId
	      			 };
	      			 store.load();                  
	      		 }
	      	 },
	      	'programreportsearchform button[itemId=btnReset]':{
	      		click : function(){
	      			var form = this.getProgramreportsearchform().getForm();
	      			form.reset();
	      			form.findField('programId').setDisabled(true);
	      			form.findField('batchId').setDisabled(true);
	      		}	                			   
 		   },
 		   'programreportsearchform':{
 			   render : function(obj){
 				   var ALField=this.getProgramreportsearchform().down("#academyLocationId");;
 				   this.setDefaultAcademyLocation(ALField);
 			   }
 		   }
        });
    },
    
    /************************ START: Common functions for dynamic grid links  ****************************************/
    	getDynamicProgramReportGrid : function(grid,respectiveLinkViewCode, respectiveLinkConfigCode, tabName,model, records) {
    	
    	/*var searchResultGrid = this.getSearchresultgrid();
		if (!searchResultGrid) {
			Ext.widget('searchresultgrid');
			searchResultGrid = this.getSearchresultgrid();
		}*/
    	grid.setTitle(tabName);
        var programReportSearchForm = this.getProgramreportsearchform();
        programReportSearchForm.down('#btnSearch').setDisabled(true);
        var jsonFormatFormData = this.createJsonFormat(programReportSearchForm, respectiveLinkConfigCode, records);

        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        
        resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode); // CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_VIEWCODE);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     
        grid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData, programReportSearchForm.down('#btnSearch'));
        Ext.getBody().unmask();
    	},
    createJsonFormat: function(programReportSearchForm, respectiveLinkConfigCode, records) {
      //  var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();
        
        var programFormvalues = this.getProgramreportsearchform().getValues();
        
        values.configCode = respectiveLinkConfigCode; // CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_CONFIGCODE;
        
        // this is temp commented bcoz for program batch wise report, only program id need to be passed  in case of any other 
        // value it raise exception
        var PROGRAM_BATCH_ID = this.getJsonObject('PROGRAM_BATCH_ID', programFormvalues.batchId);
        this.pushJsonObjectInArray(PROGRAM_BATCH_ID,searchcriteria);
        
        var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', programFormvalues.programId);
        this.pushJsonObjectInArray(PROGRAM_ID,searchcriteria);

        var ACADEMY_LOCATION_ID = this.getJsonObject('ACADEMY_LOCATION_ID', programFormvalues.academyLocationId);
        this.pushJsonObjectInArray(ACADEMY_LOCATION_ID,searchcriteria);
        
        var EXIT_DATE_NULL = this.getJsonObject('EXIT_DATE_NULL', true);
        this.pushJsonObjectInArray(EXIT_DATE_NULL,searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    getJsonObject: function(key, value, additionalValue) {
   	 if (value != '' && value != null && additionalValue == undefined) {
   		 return {
   			 "paramCode": key,
   			 "paramValues": [value]
   		 };
   	 } else if (value != '' && additionalValue != undefined) {
   		 return {
   			 "paramCode": key,
   			 "paramValues": [value, additionalValue]
   		 };
   	 }
    },
    pushJsonObjectInArray: function(object, array) {
   	 if (object) {
   		 array.push(object);
   	 }
    },
    programReportSearchButton:function(){
    	var $this = this;
    	var contentPanel = $this.getProgramreportstructure().down('tabpanel').items.items[0];
		if(contentPanel.items.items[0]){
			//var itm = $this.getProgramreportstructure().down('tabpanel').items.items[0].items.items[0].items.items[0];
			var itm = $this.getProgramreportstructure().down('tabpanel').getActiveTab().items.items[0].items.items[0];
			if(itm.itemId == 'programReportPeriodAssociatedGrid')
			{
				this.gridRenderFunction(itm);
 				this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
 				this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_PERIOD_ASSOCIATED_VIEWCODE,
           			CONSTANTS.CB.PR_PERIOD_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_PERIODS_ASSOCIATED'));
 				
			} else if(itm.itemId == 'programReportAssociatedExamCenterGrid') {
				
				this.gridRenderFunction(grid);
            	this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
            	this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_VIEWCODE,
						 CONSTANTS.CB.PR_ASSOCIATED_EXAM_CENTER_CONFIGCODE,getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'));
            	
			} else if(itm.itemId == 'programReportSpecializationAvailableGrid') {
				
				this.gridRenderFunction(grid);
 				this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
 				this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_VIEWCODE,
						 CONSTANTS.CB.PR_SPECIALIZATION_AVAILABLE_BATCHWISE_CONFIGCODE, getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'));
 				
			} else if(itm.itemId == 'programReportBatchCreatedProgramWiseGrid') {
				
				this.gridRenderFunction(grid);
 				this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
 				this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_VIEWCODE,
						 CONSTANTS.CB.PR_BATCH_CREATED_PROGRAM_WISE_CONFIGCODE,getCommonTranslation('PR_NO_OF_BATCHES_CREATED'));
 				
			} else if(itm.itemId == 'programReportSectionAssociatedStructureGrid') {
				
				this.gridRenderFunction(grid);
 				this.genericCBGridAccessControlValidation(grid,this.getPANDCDASHBOARD_PERMISSIONS());
 				this.getDynamicProgramReportGrid(grid,CONSTANTS.CB.PR_SECTION_ASSOCIATED_VIEWCODE,
						 CONSTANTS.CB.PR_SECTION_ASSOCIATED_CONFIGCODE,getCommonTranslation('PR_SECTIONS_ASSOCIATED'));
			}
		}
    },
    gridRenderFunction:function(grid){
     	 grid.addButtonToolbar();
      },
    /************************ END: Common functions for dynamic grid links  ****************************************/
    //**********************************Export Functionality********************************************************
      exportUserList : function(exportUrl,filetype,whetherAll,maingrid,grid,configcode,reportTitle) {
   	   var quickSearchForm = null;
   	   var searchResultGrid = null;
   	   var pagingtoolbaroptions = null; 
   	   var searchCriteriaString = null;
   	   var jsonFormatFormData = null;
     
   	     quickSearchForm=this.getProgramreportsearchform(); 
//   	     searchResultGrid = this.getSearchresultgrid();
   	     searchResultGrid = maingrid;
   	     pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
   	     searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
   	     jsonFormatFormData=this.createJsonFormat(quickSearchForm,configcode,null);
   	  
   	   
   	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
   	   //var reportTitle=getCommonTranslation("PROGRAM_REPORT_LIST");
   	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
   		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
   	   }
   	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
   	   console.log("exportSuccess");
      }, 
    //**************************************End*********************************************************************  
   	   createSearchCriteriaString: function(searchForm) {
   		   var me=this;
   		   var formValues = new Array();
   		   formValues = searchForm.getValues();        
   		   var searchCriteriaString="";
   		   for (var key in formValues) {
   			   var value = formValues[key];            
   			   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
   				     var keyValueJsonObject = me.getJsonObject( key , value);
   				   searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
   			   }
   		   }
   		   searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
   		   return searchCriteriaString;
   	   },
   	getOpenProgramReportStructure : function(treePanel, record, item,index, e, eOpts){
   		   var $this = this;
   		   var containpanel = $this.getProgramreporttreepanelandgrid();
   		   var treePanel = containpanel.down('#programReportTreePanelItemId');
   		   var tabDetail = record.data;
   		   var structure = Ext.widget(tabDetail.reportXtype);
   		   var tabstructure = containpanel.down('#tabpanelIds');

   		   if (!isNullOrEmpty(tabDetail.text)
   				   && !isNullOrEmpty(tabDetail.reportXtype)
   				   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
   			   treePanel.toggleCollapse();
   			   openTab(tabstructure, tabDetail.text,structure);
   			   treePanel.getSelectionModel().deselectAll();
   		   }
   	},
   	applyPermissionOnNodes:function(reportParantNode){
   		if(reportParantNode.hasChildNodes()){
   			reportParantNode.removeAll();
   		}
   		var $this = this;
   		var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
   		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   				associatedAcadLocationIds, $this.getPROGRAM_BATCH_ASSOCIATED_PERMISSIONS());
   		Ext.each(permissionList, function(privilege) {
   			if (privilege === 'LINK') {
   				reportParantNode.appendChild({
   					text: getCommonTranslation('PR_NO_OF_BATCHES_CREATED'),
   					reportXtype: 'programReportBatchCreatedProgramWiseStructure',
   					reportXtypeItemId: 'programReportBatchCreatedProgramWiseStructure',
   					leaf: true
   				});
   			}
   		});
   		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   				associatedAcadLocationIds, $this.getPROGRAM_PERIOD_ASSOCIATED_PRIVILIGES_PERMISSIONS());
   		Ext.each(permissionList, function(privilege) {
   			if (privilege === 'LINK') {
   				reportParantNode.appendChild({
   					text: getCommonTranslation('PR_PERIODS_ASSOCIATED'),
   					reportXtype: 'programReportPeriodAssociatedStructure',
   					reportXtypeItemId: 'programReportPeriodAssociatedStructure',
   					leaf: true
   				});
   			}
   		});
   		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   				associatedAcadLocationIds, $this.getPROGRAM_EXAM_CENTER_ASSOCIATED_PERMISSIONS());
   		Ext.each(permissionList, function(privilege) {
   			if (privilege === 'LINK') {
   				reportParantNode.appendChild({
   					text: getCommonTranslation('PR_ASSOCIATED_EXAM_CENTERS'),
   					reportXtype: 'programReportAssociatedExamCenterStructure',
   					reportXtypeItemId: 'programReportAssociatedExamCenterStructure',
   					leaf: true
   				});
   			}
   		});
   		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   				associatedAcadLocationIds, $this.getPROGRAM_SECTION_ASSOCIATED_PERMISSIONS());
   		Ext.each(permissionList, function(privilege) {
   			if (privilege === 'LINK') {
   				reportParantNode.appendChild({
   					text: getCommonTranslation('PR_SECTIONS_ASSOCIATED'),
   					reportXtype: 'programReportSectionAssociatedStructure',
   					reportXtypeItemId: 'programReportSectionAssociatedStructure',
   					leaf: true
   				});
   			}
   		});
   		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(
   				associatedAcadLocationIds, $this.getPROGRAM_SPECIALIZATION_ASSOCIATED_PERMISSIONS());
   		Ext.each(permissionList, function(privilege) {
   			if (privilege === 'LINK') {
   				reportParantNode.appendChild({
   					text: getCommonTranslation('PR_SPECIALIZATION_AVAILABLE'),
   					reportXtype: 'programReportSpecializationAvailableStructure',
   					reportXtypeItemId: 'programReportSpecializationAvailableStructure',
   					leaf: true
   				});
   			}
   		});

   	}
});