/**
 * @author Amit.G
 */
Ext.define('Academia.controller.quartz.QuartzController', {
	extend: 'Academia.controller.base.BaseController',
	//extend: 'Ext.app.Controller',
	stores: ['quartz.QuartzStateSearch','quartz.QuartzJobList','quartz.QuartzNameSmartSearch','quartz.QuartzJobWithStatusListStore'],
	views: ['quartz.quicksearch.QuartzManagementStructure',
	        'quartz.quicksearch.QuartzQuickSearch','quartz.QuartzList','quartz.UpdateStatus','quartz.QuartzListWithStatus'],

    refs: [{
    	ref: 'quartzquicksearch',
    	selector: 'quartzquicksearch'
    },{
    	ref: 'quartzGrid',
    	selector: 'searchresultgrid[itemId=quartzStructureGridId]'
    },{
    	ref:'quartzlist',
    	selector:'quartzlist'
    },{
    	ref:'updatestatus',
    	selector:'updatestatus'
    },{
    	ref:'updateStatus',
    	selector:'updatestatus form'
    },{
    	ref:'quartzManagementStructure',
    	selector:'quartzmanagementstructure'
    },{
    	ref:'quartzlistwithstatus',
    	selector:'quartzlistwithstatus'
    }],

    init: function(application) {
    	this.control({
    		'quartzlistwithstatus' : {
                afterrender : function(grid) {
//                    debugger;
                    var me = this;
                    var structure = grid.up('quartzmanagementstructure');

                    var grid = structure.down('quartzlistwithstatus');
                    me.getGridHeaderFreezeForQuartz(grid, structure, true);
                }
            },
            'quartzlist': {
                afterrender : function(grid) {
//                  debugger;
                  var me = this;
                  var structure = grid.up('quartzmanagementstructure');

                  me.getGridHeaderFreezeForQuartz(grid, structure, true);
              },
              cellclick: function(view, td, colIndex, record, event, target, pop) {
                    if (pop.target.tagName == 'A') {
                        var submitUrl = SERVERURL.PATH_DOWNLOAD_FILE_USING_ENCRYPTED_PATH;
                        var csvForm = Ext.create('Ext.form.Panel');
                        var filePath = record.data.report;
                        csvForm.getForm().submit({
                            url: submitUrl + "?path=" + filePath,
                            method: 'POST',
                            target: '_blank',
                            params: {
                                access_token: Ext.Ajax.defaultHeaders.access_token
                            },
                            headers: {
                                'Authorization': Ext.Ajax.defaultHeaders.Authorization
                            },
                            standardSubmit: true
                        });
                    }
                }
          },
    		'quartzquicksearch button[itemId=SearchBtn]' : {
    			click : function(obj){
    				var form = obj.up('form');
    				var structure = this.getQuartzManagementStructure();
    				var grid1 = structure.down("#quartzlistId");
    				var grid2 = structure.down("#quartzStructureGridId");
    				var grid3 = structure.down("#quartzlistwithstatusId");
    				var jobState = form.down("#jobState").getValue();
    				var jobName = form.down("#jobName").getValue();
    				
    				grid1.setVisible(false);
    				grid2.setVisible(false);
    				grid3.setVisible(false);
    				
    				var buttonsToolBar = grid2.query('toolbar')[0];
    				var buttons = buttonsToolBar.query('button');
			    	Ext.each(buttons, function(button) {
			    		if(button.itemId=="btnAdd" || button.itemId=="updateStatus"){
			    			button.setVisible(true);
			    		}
			    	});
    				
			    	if((!isNullOrEmpty(jobName) && jobState==null) || (isNullOrEmpty(jobName) && jobState==null)){
			    		this.loadQuartzJobWithStatusList();
			    	}else if(jobState=='HISTORY' || jobState==null ){
    					this.loadQuartzJobList(); // without CB
    				}else if(jobState=='BLOCKED' || jobState=='PAUSED_BLOCKED'){
    					this.loadGridAndSearchPrograms(); //with CB
    					
    					Ext.each(buttons, function(button) {
    			    		if(button.itemId=="btnAdd" || button.itemId=="updateStatus"){
    			    			button.setVisible(true);
    			    		}
    			    	});
    				}
    				else{
    					this.loadGridAndSearchPrograms(); //with CB
    				}
			    	
    			} 
    		},
    		'searchresultgrid[itemId=quartzStructureGridId]': {
    			render:function(grid){
    				this.gridRenderFunction(grid);
    			},
    			afterrender : function(grid) {
                  var me = this;
                  var structure = grid.up('quartzmanagementstructure');
                  me.getGridHeaderFreezeForQuartz(grid, structure, true);
    			}
    		},
    		'searchresultgrid[itemId=quartzStructureGridId] button[itemId=btnAdd]': {
    			click : this.checkTriggerJobState
    		},
    		'searchresultgrid[itemId=quartzStructureGridId] button[itemId=updateStatus]': {
    			click : this.updateStatus
    		},
    		'quartzquicksearch customcombobox#jobState':{
    			select : function(obj,record){
    				var form = obj.up('form');
    				var value = record[0].get("id");
    				var startDate = form.down("#quartz_date_from");
    				var endDate = form.down("#quartz_date_to");

    				startDate.setVisible(false);
    				endDate.setVisible(false);

    				startDate.reset();
    				endDate.reset();

    				if(value == 'HISTORY'){
    					startDate.setVisible(true);
    					endDate.setVisible(true);
    					startDate.setValue(new Date());
    					endDate.setValue(new Date());
    				}

    			}
    		},
    		'updatestatus button[itemId=saveBtn]' : {
    			click : function(){
    				this.saveUpdateStatus();
    			}
    		},
    		'updatestatus button[itemId=cancelBtn]' : {
    			click : function(){
    				this.getUpdatestatus().close();
    			}
    		}
    	});
    },
    gridRenderFunction: function(grid) {
    	grid.addDocked({
    		xtype: 'toolbar',
    		dock: 'top',
    		items: [{
    			xtype: 'button',
    			itemId: 'btnAdd',
    			text:getCommonTranslation('TRIGGER_JOB'),
    			tooltip: getCommonTranslation('TRIGGER_JOB')
    		},{
    			xtype: 'button',
    			itemId: 'updateStatus',
    			text:getCommonTranslation('CHANGE_JOB_STATE'),
    			tooltip: getCommonTranslation('TRIGGER_JOB')
    		}]
    	});
    },
    checkTriggerJobState : function(){
    	var grid = this.getQuartzGrid();
    	var record=grid.getSelectionModel().getSelection()[0];

    	 if (grid.getSelectionModel().getCount() > 0) {
	    	var state = record.get("TRIGGER_STATE");
	    	var jobName = record.get("JOB_NAME");
    		var triggerUrl = SERVERURL.QUARTZ_TRIGGERS;
    		Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: triggerUrl,
    			params: {
    				jobName: jobName
    			},
    			success: function(f, action) {
    				Ext.getBody().unmask();
    				if(f.responseText == '404'){
    					/*var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getCommonTranslation('TITLE_QUARTZ_DETAIL')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+'Can not run the job Job-Server is down'+'</span>';
    					var box2 =Ext.Msg.show({
    					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
						msg	: msg,
						buttons	: Ext.MessageBox.OK,
						icon: Ext.Msg.INFO,
						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
						fn	: function(response){
							if(response=="ok"){
								grid.getStore().reload();
							}
						}
    					});
    					box2.removeCls('newClsMessageConfirmBox');
    					box2.dockedItems.items[1].layout.pack = "end";
    					box2.doLayout();
    					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');*/
    					showSessionTimeOutMessage(
							getCommonTranslation('TITLE_QUARTZ_DETAIL'),
							'Can not run the job Job-Server is down',
							function(response){
								if(response=="ok"){
									grid.getStore().reload();
								}
							}
    					);
    				}else if(f.responseText == '500'){
    					/*var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getCommonTranslation('TITLE_QUARTZ_DETAIL')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+'Job is already running'+'</span>';
    					var box2 =Ext.Msg.show({
    					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
						msg	: msg,
						buttons	: Ext.MessageBox.OK,
						icon: Ext.Msg.INFO,
						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
						fn	: function(response){
							if(response=="ok"){
								grid.getStore().reload();
							}
						}
    					});
    					box2.removeCls('newClsMessageConfirmBox');
    					box2.dockedItems.items[1].layout.pack = "end";
    					box2.doLayout();
    					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');*/
    					showSessionTimeOutMessage(
							getCommonTranslation('TITLE_QUARTZ_DETAIL'),
							'Job is already running',
							function(response){
								if(response == "ok"){
									grid.getStore().reload();
								}
							}
    					);
    				}else{
    					/*var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getCommonTranslation('TITLE_QUARTZ_DETAIL')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('JOB_STARTED')+'</span>';
    					var box2 =Ext.Msg.show({
    						//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
    						msg	:msg,
    						buttons	: Ext.MessageBox.OK,
    						icon: Ext.Msg.INFO,
    						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
    						fn	: function(response){
    							if(response=="ok"){
    								grid.getStore().reload();
    							}
    						}
    					});
    					box2.removeCls('newClsMessageConfirmBox');
    					box2.dockedItems.items[1].layout.pack = "end";
    					box2.doLayout();
    					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');*/
    					showSessionTimeOutMessage(
    						getCommonTranslation('TITLE_QUARTZ_DETAIL'),
    						getCommonTranslation('JOB_STARTED'),
    						function(response) {
    							if(response == "ok"){
    								grid.getStore().reload();
    							}
    						}
    					);
    				}
    			}
    		});
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
    loadQuartzJobList : function(){
    	var form = this.getQuartzquicksearch();
    	var jobName = form.down("#jobName").getValue();
    	var startTime = form.down("#quartz_date_from").getValue();
        var endTime = form.down("#quartz_date_to").getValue();
        
        var endDateTime;
        var startDateTime = Ext.Date.format(startTime,CONSTANTS.SUBMIT_DATE_FORMAT);
        endDateTime = Ext.Date.format(endTime, CONSTANTS.SUBMIT_DATE_FORMAT);
        
        if(!isNullOrEmpty(endDateTime)){
        	endDateTime = endDateTime// +" 23:59:59";
        }
    	var grid = this.getQuartzlist();
    	grid.setVisible(true);
    	
    	var store = grid.getStore();
    	store.getProxy().extraParams = {
    		jobName:jobName,
    		startDateTime:startDateTime,
            endDateTime:endDateTime
		};
		store.load({
			callback: function(){
				var structure = grid.up('quartzmanagementstructure');
 				structure.scrollBy(0,1);
 				structure.scrollBy(0,-1);
			}
		});
		var gridTitle = grid.dockedItems.items[0];
    	var gridBttns = grid.dockedItems.items[1];
    	var gridHeader = grid.dockedItems.items[2];
    	if(Ext.isDefined(gridTitle)){
			gridTitle.removeCls('sticky-header-quartz-active-title');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.removeCls('sticky-header-quartz-active-buttons');
		}
		if(Ext.isDefined(gridTitle)){
			gridTitle.addCls('x-docked');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.addCls('x-docked');
		}
    },
    loadGridAndSearchPrograms : function() {
    	var quickSearchForm = this.getQuartzquicksearch();
    	var searchResultGrid = this.getQuartzGrid();
    	searchResultGrid.setVisible(true);
    	var jsonFormatFormData = this.createJsonFormat(quickSearchForm);
    	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.QUARTZ_JOB_LIST_VIEW_CODE);
    	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	
    	setTimeout(function(){
    		var structure = grid.up('quartzmanagementstructure');
				structure.scrollBy(0,1);
				structure.scrollBy(0,-1);
    	},1000);
    	var gridTitle = searchResultGrid.dockedItems.items[0];
    	var gridBttns = searchResultGrid.dockedItems.items[1];
    	var gridHeader = searchResultGrid.dockedItems.items[2];
    	if(Ext.isDefined(gridTitle)){
			gridTitle.removeCls('sticky-header-quartz-active-title');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.removeCls('sticky-header-quartz-active-buttons');
		}
		if(Ext.isDefined(gridTitle)){
			gridTitle.addCls('x-docked');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.addCls('x-docked');
		}
    },
    createJsonFormat:function(quickSearchForm){		
    
    	var jobName = quickSearchForm.getValues().jobName;
    	var jobState = quickSearchForm.getValues().jobState;
    	var quartzDateFrom = quickSearchForm.getValues().dateFrom; 
    	var quartzDateTO = quickSearchForm.getValues().enquiryDateto;  

    	value = Ext.Date.parse(quartzDateFrom,'d-m-Y');
    	var startTime = Ext.Date.format(value, CONSTANTS.DATE_TIME_FORMAT);

    	value = Ext.Date.parse(quartzDateTO,'d-m-Y');
    	var endTime = Ext.Date.format(value, CONSTANTS.DATE_TIME_FORMAT);

    	var values = new Object();
    	values.configCode = CONSTANTS.CB.QUARTZ_JOB_LIST_CONFIG_CODE;
    	var searchcriteria = new Array();
    	
    	
    	if(jobName != null){
    		searchcriteria.push({paramCode:"JOB_NAME", paramValues:[jobName]});
    	}
    	if(jobState != null){
    		if(jobState == 'BLOCKED'){
    			searchcriteria.push({paramCode:"TRIGGER_STATE", paramValues:[jobState,'PAUSED_BLOCKED']});
    		}else{
    		    searchcriteria.push({paramCode:"TRIGGER_STATE", paramValues:[jobState]});
    		}	
    	}
    	/*if(startTime != null){
    		searchcriteria.push({paramCode:"START_TIME", paramValues:[startTime]});
    	}
    	if(endTime != null){
    		searchcriteria.push({paramCode:"END_TIME", paramValues:[endTime]});
    	}*/
    	values.searchCriterias=searchcriteria;
    	return values;
    },
    
    updateStatusWindow:function(){
    	var formWindow = this.getUpdatestatus();
	        if (!formWindow) {
	            Ext.widget('updatestatus');
	            formWindow = this.getUpdatestatus();
	        }
	        formWindow.show();
     },
    
     updateStatus:function(){
    	 var $this = this;
    	 var grid = $this.getQuartzGrid();
    	 if (grid.getSelectionModel().getCount() > 0) {
    		 $this.updateStatusWindow();
    		 var records = grid.getSelectionModel().getSelection();
    		 var data = records[0].data;
    		 var jobName = data.JOB_NAME;
    		 
    		 var form = $this.getUpdateStatus().getForm();
    		 form.findField('jobName').setValue(jobName);
    		 
    	 }else{
    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));  	
    	 }
     },
     saveUpdateStatus:function(){
    	 var $this = this;
    	 var form = $this.getUpdateStatus().getForm();
    	 var values = form.getValues();
    	 
    	 var grid = $this.getQuartzGrid();
		 var records = grid.getSelectionModel().getSelection();
		 var data = records[0].data;
		 var jobName = data.JOB_NAME;
    	 
    	 var url = SERVERURL.CHANGE_JOB_STATE;
 		Ext.Ajax.request({
 			method: "GET",
 			type: 'rest',
 			url: url,
 			params: {
 				jobName:jobName,
 				triggerState: values.newJobState
 			},
 			success: function(f, action) {
 				showSuccessMessage(getCommonTranslation('CHANGE_JOB_STATE'), getCommonTranslation('SUCCESS'));
 				$this.getUpdatestatus().close();
 				grid.getStore().load();
 			}
 		});
     },
     loadQuartzJobWithStatusList : function(){
     	var form = this.getQuartzquicksearch();
     	var jobName = form.down("#jobName").getValue();
     	var startTime = form.down("#quartz_date_from").getValue();
         var endTime = form.down("#quartz_date_to").getValue();
         
         var endDateTime;
         var startDateTime = Ext.Date.format(startTime, CONSTANTS.DATE_TIME_FORMAT);
         endDateTime = Ext.Date.format(endTime, CONSTANTS.SUBMIT_DATE_FORMAT);
         
         if(!isNullOrEmpty(endDateTime)){
         	endDateTime = endDateTime+" 23:59:59";
         }
     	var grid = this.getQuartzlistwithstatus();
     	grid.setVisible(true);
     	
     	var store = grid.getStore();
     	store.getProxy().extraParams = {
     		jobName:jobName
 		};
     	this.resetQuartzStorePageSetting(store);
 		store.load({
 			callback: function(){
 				var structure = grid.up('quartzmanagementstructure');
 				structure.scrollBy(0,1);
 				structure.scrollBy(0,-1);
 			}
 		});
 		var gridTitle = grid.dockedItems.items[0];
    	var gridBttns = grid.dockedItems.items[1];
    	var gridHeader = grid.dockedItems.items[2];
    	if(Ext.isDefined(gridTitle)){
			gridTitle.removeCls('sticky-header-quartz-active-title');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.removeCls('sticky-header-quartz-active-buttons');
		}
		if(Ext.isDefined(gridTitle)){
			gridTitle.addCls('x-docked');
		}
		if(Ext.isDefined(gridBttns)){
			gridBttns.addCls('x-docked');
		}
     },/**
  	 * resetPageSetting used for reseting 
  	 *  page and start params for pagination
  	 */
  	resetQuartzStorePageSetting:function(store){
  		if(store){
  			store.currentPage = 1;
  			store.getProxy().setExtraParam('sort', null);
  		}
  	}
});