/**
 * This controller is used for the Receipt Setting Add/Edit/Delete/View
 * 
 * @author Varsha Gour
 */
Ext.define('Academia.controller.receipt.receiptsettings.ReceiptSettingsController', {
    extend: 'Academia.controller.base.BaseController',
    models: ['receipt.receiptsettings.ReceiptSettingsModel','receipt.receiptsettings.BillSettingsModel','common.IdValueCodeDataModel','receipt.receiptsettings.BankChargesSettingsModel',
    	'receipt.receiptsettings.BankChargesSettingsGridModel','feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel'],
    stores: ['receipt.receiptsettings.AcademyLocationNotInReceiptSettings',
        'receipt.receiptsettings.ReceiptSettingsStore','feeandpayment.CostCenterConfig',
        'common.AcademyLocationNameSeparated','receipt.receiptsettings.BillSettingsStore','receipt.receiptsettings.DiscountDateSettingsStore','feeandpayment.FeePaymentModeForReceiptStore',
        'feeandpayment.FeeCurrencyStore','feeandpayment.receipts.DrawnOnBank','receipt.receiptsettings.BankChargesGridStore','receipt.receiptsettings.BankChargesHistoryGridStore',
        'receipt.receiptsettings.ProgramGroupParentGridStore','receipt.receiptsettings.ProgramGroupChildGridStore','feeandpayment.AcademyLocationFeeMappingList','common.AcademyLocationByName',
        'feeandpayment.ALProgramList','feeandpayment.ALProgramSearchCombo','feeandpayment.finance.FinanceALProgramBatchList','feeandpayment.finance.FinanceALProgramBatchSearchCombo',
        'feeandpayment.finance.FinanceALProgramBatchSeatTypeList','receipt.receiptsettings.PaymentGroupMappedGridStore','common.MultiLanguageCorrespondenceLangStore','feeandpayment.DiscountType',
        'receipt.receiptsettings.StatementEmailEventMappingStore','receipt.receiptsettings.StatementEmailTemplateMappingStore','receipt.receiptsettings.StatementEmailPBSTMappingGridStore',
        'receipt.receiptsettings.StateEmailSettingALPBSTList','receipt.receiptsettings.FeeAndPaymentOtherSettingStore','sponsorship.ManageConfiguredFeeHeadsStore','feeandpayment.CostCenterConfig','feeandpayment.discount.DiscountFeeHeadStore'
    ],
    views: ['receipt.receiptsettings.ReceiptSettingsStructure',
        'receipt.receiptsettings.ReceiptSettingsGrid','receipt.receiptsettings.FeesAndPaymentOtherSettings',
        'receipt.receiptsettings.ReceiptSettingsWin','receipt.receiptsettings.CreditFeeMappingForm',
        'receipt.receiptsettings.EditReceiptSettingsWin','receipt.receiptsettings.DiscountDateSettingsGrid',
        'receipt.receiptsettings.BillSettingsGrid','receipt.receiptsettings.BillSettingsWin','receipt.receiptsettings.OnlinePaymentSettingsForm',
        'receipt.receiptsettings.EditBillSettingsWin','receipt.receiptsettings.DiscountDateSettingsWin',
        'receipt.receiptsettings.EditDiscountDateSettingsWin','receipt.receiptsettings.BankChargesSettingsGrid',
        'receipt.receiptsettings.BankChargesSettingsWin','receipt.receiptsettings.EditBankChangesSettingsWin','receipt.receiptsettings.BankChargesHistorySetUpWindow','receipt.receiptsettings.BankChargesHistoryGrid',
        'receipt.receiptsettings.ViewBankChangesSettingsWin','receipt.receiptsettings.VoucherSettingsForm','receipt.receiptsettings.ProgramGroupSettingPanel',
        'receipt.receiptsettings.PaymentGroupParentFormWindow','receipt.receiptsettings.PaymentGroupChildFormWindow','receipt.receiptsettings.PaymentGroupMappingResultStructure',
        'receipt.receiptsettings.PaymentGroupMappedGrid','receipt.receiptsettings.PaymentGroupMappingStructure','receipt.receiptsettings.PaymentGroupAddMappingTab','receipt.receiptsettings.PaymentGroupMappingProgressTracker',
        'receipt.receiptsettings.PaymentGrpWithProgramBatchSeatStructure','receipt.receiptsettings.PaymentGrpMappingAcademyLocationGrid','receipt.receiptsettings.PaymentGrpProgramGrid','receipt.receiptsettings.PaymentGrpProgramBatchGrid',
        'receipt.receiptsettings.PaymentGrpALProgramBatchSeatTypeGrid','receipt.receiptsettings.PaymentGroupMappingAlertWin','receipt.receiptsettings.CourseFeeDefConfigForm','receipt.receiptsettings.ConfigureFeeHeadGrid',
        'receipt.receiptsettings.PaymentGroupConfigureFeeHeadsStructure','receipt.receiptsettings.ConfigureFeeHeadViewWindow','receipt.receiptsettings.PaymentTermConfigureFeeHeadWindowGrid','receipt.receiptsettings.AutoSettlementJobConfigForm',
        'receipt.receiptsettings.StatementEmailSettingForm','receipt.receiptsettings.StatementEmailSettingGrid','receipt.receiptsettings.StatementEmailSettingApplyToWin','receipt.receiptsettings.DiscountBillAndSettlementForm','receipt.receiptsettings.WhetherFeeForCourseEnrollment',
        'receipt.receiptsettings.CourseFeeDefinitionMappingWin','receipt.receiptsettings.CourseFeeDefinitionFeePlanWin','receipt.receiptsettings.FinanceHoldSettingWin','receipt.receiptsettings.LateFeeBillCancellationForm','receipt.receiptsettings.CreditCancellationWithBillForm',
        'receipt.receiptsettings.isNewStatementOfAccountSettingWin','receipt.receiptsettings.ProgramFeePlanmappedperiod','receipt.receiptsettings.PaymentTermConfigureFeeHeadWin',
        'receipt.receiptsettings.InterestApplicableForm','receipt.receiptsettings.PaymentPlanCalculationConfigForm','receipt.receiptsettings.FeePlanAndPaymentTermForBillConfigForm','receipt.receiptsettings.ReceiptRemainsInCaseOfTransferConfigForm',
        'receipt.receiptsettings.FeePlanProrataConfigForm'
    ],
    config: {
        RECEIPT_SETTINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RECEIPT_SETTINGS_PRIVILEGES'),
        COURSE_FEE_HEAD_CONFIGURATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_FEE_HEAD_CONFIGURATION_PRIVILEGES'),
        BILL_GENERATION_ON_SUBMIT_APPLICATION_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('BILL_SETTINGS_PRIVILEGES'),
    },
    refs: [{
        ref: 'receiptsettingsgrid',
        selector: 'receiptsettingsgrid'
    },{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'receiptsettingswin',
        selector: 'receiptsettingswin'
    }, {
        ref: 'editreceiptsettingswin',
        selector: 'editreceiptsettingswin'
    },{
        ref: 'billsettingsgrid',
        selector: 'billsettingsgrid'
    },{
        ref: 'billsettingswin',
        selector: 'billsettingswin'
    }, {
        ref: 'editbillsettingswin',
        selector: 'editbillsettingswin'
    },{
        ref: 'discountdatesettingsgrid',
        selector: 'discountdatesettingsgrid'
    },{
        ref: 'discountdatesettingswin',
        selector: 'discountdatesettingswin'
    },{
        ref: 'editdiscountdatesettingswin',
        selector: 'editdiscountdatesettingswin'
    },{
    	ref: 'bankchargessettingsgrid',
        selector: 'bankchargessettingsgrid'
    },{
    	ref: 'bankchargessettingswin',
        selector: 'bankchargessettingswin'
    },{
    	ref: 'editbankchangessettingswin',
        selector: 'editbankchangessettingswin'
    },
    {
    	ref: 'bankchargeshistorysetupwindow',
        selector: 'bankchargeshistorysetupwindow'
    },
    {
    	ref: 'bankchargeshistorygrid',
        selector: 'bankchargeshistorygrid'
    },{
    	ref: 'viewbankchangessettingswin',
        selector: 'viewbankchangessettingswin'
    },{
    	ref: 'vouchersettingsform',
        selector: 'vouchersettingsform'
    },{
    	ref:'programgroupsettingpanel',
    	selector:'programgroupsettingpanel'
    },{
    	ref:'paymentgroupchildformwindow',
    	selector:'paymentgroupchildformwindow'
    },{
    	ref:'paymentgroupparentformwindow',
    	selector:'paymentgroupparentformwindow'
    },{
    	ref:'paymentgroupaddmappingtab',
    	selector:'paymentgroupaddmappingtab'
    },{
    	ref:'paymentgroupmappedgrid',
    	selector:'paymentgroupmappedgrid'
    },{
    	ref:'paymentgrpmappingacademylocationgrid',
    	selector:'paymentgrpmappingacademylocationgrid'
    },{
    	ref:'paymentgrpwithprogrambatchseatstructure',
    	selector:'paymentgrpwithprogrambatchseatstructure'
    },{
    	ref:'paymentgroupmappingprogresstracker',
    	selector:'paymentgroupmappingprogresstracker'
    },{
    	ref:'paymentgrpprogramgrid',
    	selector:'paymentgrpprogramgrid'
    },{
    	ref:'paymentgrpprogrambatchgrid',
    	selector:'paymentgrpprogrambatchgrid'
    },{
    	ref:'paymentgrpaLprogrambatchseattypegrid',
    	selector:'paymentgrpaLprogrambatchseattypegrid'
    },{
    	ref:'paymentgroupmappingalertwin',
    	selector:'paymentgroupmappingalertwin'
    },{
    	 ref:'coursefeedefconfigform',
         selector:'coursefeedefconfigform'
    },{
    	ref:'creditfeemappingform',
    	selector:'creditfeemappingform'
    },{
    	ref:'configurefeeheadgrid',
    	selector:'configurefeeheadgrid'
    },{
    	ref:'paymentgroupconfigurefeeheadsstructure',
    	selector:'paymentgroupconfigurefeeheadsstructure'
    },{
    	ref:'configurefeeheadviewwindow',
    	selector:'configurefeeheadviewwindow'
    },{
    	ref:'paymenttermconfigurefeeheadwindowgrid',
    	selector:'paymenttermconfigurefeeheadwindowgrid'
    },{
    	ref:'autosettlementjobconfigform',
    	selector:'autosettlementjobconfigform'
    },{
    	ref:'statementemailsettingform',
    	selector:'statementemailsettingform'
    },{
    	ref:'statementemailsettinggrid',
    	selector:'statementemailsettinggrid'
    },{
    	ref:'statementemailsettingapplytowin',
    	selector:'statementemailsettingapplytowin'
    },{
    	ref:'feesandpaymentothersettings',
    	selector:'feesandpaymentothersettings'
    },{
    	ref:'onlinepaymentsettingsform',
    	selector:'onlinepaymentsettingsform'
    },{
    	ref:'discountBillAndSettlementForm',
    	selector:'discountBillAndSettlementForm'
    },{
    	ref:'receiptsettingsstructure',
    	selector:'receiptsettingsstructure'
    },{
    	ref:'whetherfeeforcourseenrollment',
    	selector:'whetherfeeforcourseenrollment'
    },{
    	ref:'courseFeeDefinitionMappingWin',
    	selector:'courseFeeDefinitionMappingWin'
    },{
    	ref:'courseFeeDefinitionFeePlanWin',
    	selector:'courseFeeDefinitionFeePlanWin'
    },{
    	ref:'financeHoldSettingWin',
    	selector:'financeHoldSettingWin'
    },{
    	ref:'lateFeeBillCancellationForm',
    	selector:'lateFeeBillCancellationForm'
    },{
    	ref:'creditCancellationWithBillForm',
    	selector:'creditCancellationWithBillForm'
    },{
    	ref:'isNewStatementOfAccountSettingWin',
    	selector:'isNewStatementOfAccountSettingWin'
    },{
    	ref:'programFeePlanmappedperiod',
    	selector:'programFeePlanmappedperiod'
    },{
    	ref:'paymenttermconfigurefeeheadwin',
    	selector:'paymenttermconfigurefeeheadwin'
    },{
    	ref:'interestapplicableform',
    	selector:'interestapplicableform'
    },{
    	ref:'paymentplancalculationconfigform',
    	selector:'paymentplancalculationconfigform'
    },{
    	ref:'feeplanandpaymenttermforbillconfigform',
    	selector:'feeplanandpaymenttermforbillconfigform'
    },{
    	ref:'receiptRemainsInCaseOfTransferConfigForm',
    	selector:'receiptRemainsInCaseOfTransferConfigForm'
    },{
    	ref:'feeplanprorataconfigform',
    	selector:'feeplanprorataconfigform'
    }],
    init: function() {
    	this.screenName;
    	this.scrollPosition;
    	this.configFeeHeadDfrData;
    	this.control({
    		'receiptsettingsgrid': {
    			render: function(grid) {
    				//this.doAccessControlValidation(grid, this.getRECEIPT_SETTINGS_PERMISSIONS());
    				grid.getStore().load();
    			},
    		},
    		'receiptsettingsgrid button[itemId=btnAdd]': {
    			click: function() {
    				this.showReceiptSettingsWin();
    			}
    		},
    		'receiptsettingsgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editReceiptSettingsWin();
    			}
    		},
    		'receiptsettingsgrid button[itemId=btnView]': {
    			click: function() {
    				this.viewReceiptSettingWin();
    			}
    		},
    		'receiptsettingsgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteReceiptSettingRecord();
    			}
    		},
    		'receiptsettingswin button[itemId=btnSaveReceiptSettingsWinItemId]': {
    			click: function() {
    				this.saveReceiptSettingsRecords();
    			}
    		},
    		'receiptsettingswin button[itemId=btnCancelReceiptSettingsWinItemId]': {
    			click: function(obj) {
    				this.getReceiptsettingswin().close();
    			}
    		},
    		'editreceiptsettingswin button[itemId=btnSaveEditReceiptSettingsWinItemId]': {
    			click: function() {
    				this.editReceiptSettingsRecord();
    			}
    		},
    		'editreceiptsettingswin button[itemId=btnCancelEditReceiptSettingsWinItemId]': {
    			click: function(obj) {
    				this.getEditreceiptsettingswin().close();
    			}
    		},
    		'billsettingsgrid': {
    			render: function(grid) {
    				grid.getStore().load();
    			},
    		},
    		'billsettingsgrid button[itemId=btnAdd]': {
    			click: function() {
    				this.showBillSettingsWin();
    			}
    		},
    		'billsettingsgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editBillSettingsWin();
    			}
    		},
    		'billsettingsgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteBillSettingRecord();
    			}
    		},
    		'billsettingswin button[itemId=btnSaveBillSettingsWinItemId]': {
    			click: function() {
    				this.saveBillSettingsRecords();
    			}
    		},
    		'billsettingswin button[itemId=btnCancelBillSettingsWinItemId]': {
    			click: function(obj) {
    				this.getBillsettingswin().close();
    			}
    		},
    		'editbillsettingswin button[itemId=btnSaveEditBillSettingsWinItemId]': {
    			click: function() {
    				this.editBillSettingsRecord();
    			}
    		},
    		'editbillsettingswin button[itemId=btnCancelEditBillSettingsWinItemId]': {
    			click: function() {
    				this.getEditbillsettingswin().close();
    			}
    		},
    		'discountdatesettingsgrid': {
    			render: function(grid) {
    				grid.getStore().load();
    			},
    		},
    		'discountdatesettingsgrid button[itemId=btnAdd]': {
    			click: function() {
    				this.showDiscountDateSettingsWin();
    			}
    		},
    		'discountdatesettingsgrid button[itemId=btnEdit]': {
    			click: function() {
    				this.editDiscountDateSettingsWin();
    			}
    		},
    		'discountdatesettingsgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteDiscountDateSettingRecord();
    			}
    		},
    		'discountdatesettingswin button[itemId=btnSaveDiscountDateSettingsWinItemId]': {
    			click: function() {
    				this.saveDiscountDateSettingsRecords();
    			}
    		},
    		'discountdatesettingswin button[itemId=btnCancelDiscountDateSettingsWinItemId]': {
    			click: function(obj) {
    				this.getDiscountdatesettingswin().close();
    			}
    		},
    		'editdiscountdatesettingswin button[itemId=btnSaveEditDiscountDateSettingsWinItemId]': {
    			click: function() {
    				this.editDiscountDateSettingsRecord();
    			}
    		},
    		'editdiscountdatesettingswin button[itemId=btnCancelEditDiscountDateSettingsWinItemId]': {
    			click: function(obj) {
    				this.getEditdiscountdatesettingswin().close();
    			}
    		},
    		'bankchargessettingsgrid': {
    			render: function(grid) {
    				grid.getStore().load();                
    			},
    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				if(columnName == "fromDate"){
    					if(e.target.tagName=='A'){
    						this.getOpenBankChargesHistoryDetails(grid,record);
    					}
    				}
    			}
    		},
    		'bankchargessettingsgrid button[itemId=btnAdd]': {
    			click: function() {
    				this.showBankChargesSettingsWin();
    			}
    		},
    		'bankchargessettingswin datefield[itemId=fromDate]':{
    			change:function(){
    				var form =  this.getBankchargessettingswin();
    				var fromDate = form.down('#fromDate').getValue();
    				var toDate = form.down("#toDate");
    				toDate.reset();
    				toDate.setMinValue(fromDate);

    			}
    		},
    		'editbankchangessettingswin datefield[itemId=fromDate]':{
    			change:function(){
    				var form =  this.getEditbankchangessettingswin();
    				var fromDate = form.down('#fromDate').getValue();
    				var toDate = form.down("#toDate");
    				toDate.reset();
    				toDate.setMinValue(fromDate);

    			}
    		},
    		'bankchargessettingsgrid button[itemId=btnEdit]': {
    			click: Ext.bind(this.editBankChargesSettings, this, [false])
    			/*click: function() {
                    this.editBankChargesSettings();
                }*/
    		},
    		'bankchargessettingsgrid button[itemId=btnView]': {
    			click: Ext.bind(this.editBankChargesSettings, this, [true])
    		},




    		'bankchargessettingswin button[itemId=btnCancelBankChargesSettingsItemId]': {
    			click: function(obj) {
    				this.getBankchargessettingswin().close();
    			}
    		},
    		'bankchargessettingswin button[itemId=btnSaveBankChargesSettingsItemId]': {
    			click: function() {
    				this.saveBankChargesRecords();
    			}
    		},
    		'editbankchangessettingswin button[itemId=btnCancelEditBankChargesSettingsItemId]': {
    			click: function(obj) {
    				this.getEditbankchangessettingswin().close();
    			}
    		},
    		'viewbankchangessettingswin button[itemId=btnCancelViewBankChargesSettingsItemId]': {
    			click: function(obj) {
    				this.getViewbankchangessettingswin().close();
    			}
    		},

    		'editbankchangessettingswin button[itemId=btnSaveEditBankChargesSettingsItemId]': {
    			click: function() {
    				this.editBankChargesSettingsSaveRecords();
    			}
    		},
    		'bankchargessettingsgrid button[itemId=btnDelete]': {
    			click: function() {
    				this.deleteBankChargesRecord();
    			}
    		},
    		'vouchersettingsform': {
    			render: function(form) {
    				var verificationRequired = form.down('#verificationRequiredId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isVoucherVerificationRequired){
    							Ext.ComponentQuery.query('radiogroup#verificationRequiredId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#verificationRequiredId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#verificationRequiredId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#verificationRequiredId')[0].items.items[1].setValue(true);
    						}

    					}
    				});
    			},
    		},
    		'vouchersettingsform button[itemId=SubmitBtn]': {
    			click: function() {
    				this.saveVoucherSettings();
    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid]':{
    			selectionchange: function(view, records) {
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				var btnEdit = parentGrid.down('#btnEdit');
    				var btnView = parentGrid.down('#btnView');
    				var btnDelete = parentGrid.down('#btnDelete');
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    				var contentpanel = programGrpPnl.items.items[1];
					var tabName = getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD');
					var tabDetail = contentpanel.items.items;

    				var childAddBtn = childGrid.down('#btnAdd');

    				var parentRec = parentGrid.getSelectionModel().getSelection()[0];
    				if(records.length <= 0){
    					btnEdit.disable();
    					btnView.disable();
    					btnDelete.disable();
    				}else{
    					btnEdit.enable();
    					btnView.enable();
    					btnDelete.enable();
    					childAddBtn.enable();
    				}

    				if(records.length ==1){
    					var parentRec = parentGrid.getSelectionModel().getSelection()[0];
    					var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    					parentRecPaymentGroupId =parentRec.data.paymentGroupId;
    					childGrid.getStore().getProxy().extraParams = {
    						paymentGroupId : parentRec.data.paymentGroupId
    					};
    					childGrid.getStore().load();
    					this.resetPageSetting(childGrid.getStore());
    					for(var i in tabDetail){
 						   if(tabDetail[i] && tabDetail[i].title==tabName){
 							   tabDetail[i].close();
 						   }
 					   }
    				}
    			},
    			afterrender:function(){
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				parentGrid.getStore().load();
    			},	
    			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	 				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	 				var $this =this;
	 				if(columnName == "mappedProgramCount"){
	 					if(e.target.tagName=='A'){
	 						var $this = this;
	 						var programGrpPnl =this.getProgramgroupsettingpanel();
	 						var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	 						var contentpanel = $this.getContentPanel();
	 						var mappingTabstructure = Ext.widget('paymentgroupmappingstructure');  
	 						var tabName = getCommonTranslation('APPLY_TO');

	 						var getcontroller=$this.getController('menu.CoreERPNavigationController');
	 						var getTab=getcontroller.getTab(tabName);
	 						if(getTab!=null){
	 							contentpanel.remove(getTab, true);
	 						}
	 						openTab(contentpanel, tabName, mappingTabstructure,CONSTANTS.MENU_COLOR_TWO);

	 						var programGrpPnl =this.getProgramgroupsettingpanel();
	 						var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	 						var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data

	 						var gridMap = $this.getPaymentgroupmappedgrid();
	 						gridMap.getStore().getProxy().extraParams={
	 							paymentGroupId:records.data.paymentGroupId
	 						};
	 						$this.resetPageSetting(gridMap.getStore());
	 						gridMap.getStore().load();

	 					}
	 				}
	 			}
    			
    		},

    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid] button#btnAdd':{
    			click:function(){
    				var parentFormWin =Ext.widget('paymentgroupparentformwindow');
    				parentFormWin.show();
    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid] button#btnEdit':{
    			click:function(){
    				var parentFormWin =Ext.widget('paymentgroupparentformwindow');
    				parentFormWin.show();
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				if(parentGrid.getSelectionModel().getCount() > 0 ){
    					var record = parentGrid.getSelectionModel().getSelection()[0];
    					parentFormWin.down('#itemCode').setValue(record.data.code);
    					parentFormWin.down('#itemValue').setValue(record.data.name);
    					parentFormWin.down('#paymentGroupId').setValue(record.data.paymentGroupId);
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}

    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid] button#btnView':{
    			click:function(){
    				var parentFormWin =Ext.widget('paymentgroupparentformwindow');
    				parentFormWin.show();
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				if(parentGrid.getSelectionModel().getCount() > 0 ){
    					var record = parentGrid.getSelectionModel().getSelection()[0];
    					parentFormWin.down('#itemCode').setValue(record.data.code);
    					parentFormWin.down('#itemValue').setValue(record.data.name);
    					parentFormWin.down('#itemCode').setReadOnly(true);
    					parentFormWin.down('#itemValue').setReadOnly(true);
    					parentFormWin.down('#formSubmitButtonId').setVisible(false);
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid] button#btnDelete':{
    			click:function(){
    				var $this =this;
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    				if(parentGrid.getSelectionModel().getCount() > 0 ){
    					showConfirmMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    							function(btn, text) {
    						if (btn == 'yes') { 
    							var record = parentGrid.getSelectionModel().getSelection()[0];
    							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							var submitUrl = SERVERURL.PAYMENT_GROUP_PARENT_GRID_DELETE;
    							Ext.Ajax.request({
    								type : 'rest',
    								url : submitUrl+"?id="+record.data.paymentGroupId,
    								method : 'DELETE',
    								success : function(form, action) {
    									Ext.getBody().unmask();
    									showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'),getCommonTranslation('RECORD_DELETE_SUCCESS'));
    									parentGrid.getStore().reload();
    									parentGrid.getSelectionModel().deselectAll();
    									$this.resetPageSetting(parentGrid.getStore());
    									childGrid.getStore().reload();
    									childGrid.getSelectionModel().deselectAll();
    									$this.resetPageSetting(childGrid.getStore());
    								}
    							});
    						}
    					});

    				}else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}

    			}
    		},
    		'paymentgroupparentformwindow button#cancelItemId':{
    			click:function(){
    				var parentFormWin = this.getPaymentgroupparentformwindow();
    				parentFormWin.close();
    			}
    		},
    		'paymentgroupparentformwindow button#formSubmitButtonId':{
    			click:function(){
    				var $this= this;
    				var parentFormWin = this.getPaymentgroupparentformwindow();
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				var gridRec = parentGrid.getSelectionModel().getSelection()[0];
    				var paymentGroupId = parentFormWin.down('#paymentGroupId').getValue();

    				var form = parentFormWin.down('form');
    				var me = this;
    				var formValues = form.getForm().getValues();
    				var submitUrl, isUpdate = false;
    				if (isNullOrEmpty(paymentGroupId)) {
    					submitUrl = SERVERURL.PAYMENT_GROUP_PARENT_GRID_CREATE,
    					isUpdate = false;
    					var formData = {
    							code: formValues.code,
    							name: formValues.name,
    					};
    				} else {
    					submitUrl = SERVERURL.PAYMENT_GROUP_PARENT_GRID_UPDATE,
    					isUpdate = true;
    					var formData = {
    							id:   gridRec.data.paymentGroupId,
    							code: formValues.code,
    							name: formValues.name,
    					};
    				}

    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					type: 'rest',
    					url: submitUrl,
    					jsonData: formData,
    					method: 'POST',
    					success: function(response, form) {
    						Ext.getBody().unmask();
    						if (isUpdate) {
    							showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
    						} else {
    							showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('SUCCESS'));
    						}
    						parentFormWin.close();
    						parentGrid.getSelectionModel().deselectAll();
    						parentGrid.getStore().load();
    						$this.resetPageSetting(parentGrid.getStore());


    					}
    				});

    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid]':{
    		render: function(grid){
    			    var $this = this;
    				this.disableMoreActionPivileges(grid, this.getRECEIPT_SETTINGS_PERMISSIONS());
    				/*grid.getStore().on('beforeload', function() {
    					var structure = $this.getReceiptsettingsstructure();
    				    scrollPosition = structure.body.getScrollTop();
    				});
    				grid.getStore().on('load', function() {
    					var structure = $this.getReceiptsettingsstructure();
    				    structure.body.scrollBy(0,scrollPosition,false);
    				}); */
    			},
    			selectionchange: function(view, records) {
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');

    				var btnEdit = childGrid.down('#btnEdit');
    				var btnView = childGrid.down('#btnView');
    				var btnDelete = childGrid.down('#btnDelete');
    				var btnConfigureFeeHead = childGrid.down('#btnConfigureFeeHead');

    				if(records.length <= 0){
    					btnEdit.disable();
    					btnView.disable();
    					btnDelete.disable();
    					btnConfigureFeeHead.disable();
    				}else{
    					btnEdit.enable();
    					btnView.enable();
    					btnDelete.enable();
    					btnConfigureFeeHead.enable();
    				}
    			},
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "configureFeeHeadCount"){
						 if(e.target.tagName=='A'){
							 this.showFeeHeadOnPopUpWindow();
    			}
					 }
                }

    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid] button#btnAdd':{
    			click:function(){
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');

    				if(parentGrid.getSelectionModel().getCount() > 0 ){
    					var childFormWin =Ext.widget('paymentgroupchildformwindow');
    					childFormWin.show();
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}

    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid] button#btnEdit':{
    			click:function(){
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    				if(childGrid.getSelectionModel().getCount() > 0 ){
    					var childRec = childGrid.getSelectionModel().getSelection()[0];
    					var childFormWin =Ext.widget('paymentgroupchildformwindow');
    					childFormWin.show();
    					childFormWin.down('#itemCode').setValue(childRec.data.code);
    					childFormWin.down('#itemValue').setValue(childRec.data.name);
    					childFormWin.down('#sequenceNo').setValue(childRec.data.sequenceNo);
    					childFormWin.down('#paymentTermId').setValue(childRec.data.id);
    					childFormWin.down('#isDefaultId').setValue(childRec.data.isDefaultPaymentTerm);
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}

    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid] button#btnView':{
    			click:function(){
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');

    				if(childGrid.getSelectionModel().getCount() > 0 ){
    					var childFormWin =Ext.widget('paymentgroupchildformwindow');
    					childFormWin.show();
    					var childRec = childGrid.getSelectionModel().getSelection()[0];
    					childFormWin.down('#itemCode').setValue(childRec.data.code);
    					childFormWin.down('#itemValue').setValue(childRec.data.name);
    					childFormWin.down('#sequenceNo').setValue(childRec.data.sequenceNo);
    					childFormWin.down('#isDefaultId').setValue(childRec.data.isDefaultPaymentTerm);

    					childFormWin.down('#itemCode').setReadOnly(true);
    					childFormWin.down('#itemValue').setReadOnly(true);
    					childFormWin.down('#sequenceNo').setReadOnly(true);
    					childFormWin.down('#isDefaultId').setReadOnly(true);

    					childFormWin.down('#formSubmitButtonId').setVisible(false);
    				}
    				else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}

    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid] button#btnDelete':{
    			click:function(){
    				var $this =this;
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    				if(childGrid.getSelectionModel().getCount() > 0 ){
    					var ids= [];
    					showConfirmMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    							function(btn, text) {
    						if (btn == 'yes') {
    							var record = childGrid.getSelectionModel().getSelection()[0];

    							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							var submitUrl = SERVERURL.PAYMENT_TERM_CHILD_GRID_DELETE;
    							Ext.Ajax.request({
    								type : 'rest',
    								url : submitUrl+"?id="+record.data.id,
    								method : 'DELETE',
    								success : function(form, action) {
    									Ext.getBody().unmask();
    									showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'),getCommonTranslation('RECORD_DELETE_SUCCESS'));
    									childGrid.getStore().reload();
    									childGrid.getSelectionModel().deselectAll();
    									$this.resetPageSetting(childGrid.getStore());
    								}
    							});
    						}
    					});

    				} else {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupChildGrid] button#btnConfigureFeeHead':{
    			click:this.getOpenConfigureFeeHeadWindow
    		},
    		
    		'configurefeeheadgrid':{
    			cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
     				 
     				 var columnName = grid.getGridColumns()[cellIndex].dataIndex;
     				 if (e.target.tagName == 'DIV' &&  columnName == "addButton" ) {
     					 
     					serialNo = grid.getStore().getCount();
     					this.onFeeHeadGridAddClick(serialNo+1,grid);
     				 }
     				 else if (e.target.tagName == 'DIV' && columnName == "deleteButton") {
     					 var feeheadconfigurationgridStructure = this.getConfigurefeeheadgrid();
     					 var titleMessage = getCommonTranslation('SUBHEAD_CONFIGURATION');
     					 this.deleteFeeHeadConfigurationDetails(grid,record,feeheadconfigurationgridStructure,titleMessage,rowIndex);
     					 /*grid.getStore().removeAt(rowIndex);
     					 var storeCount = grid.getStore().getCount();*/
     				 }
     			   },
     			   afterrender:function(grid){
     				   var programGrpPnl = this.getProgramgroupsettingpanel();
     				   this.disableFeeConfigurationButtonByPriivilege(grid, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
     				   this.disableFeeConfigurationSaveResetBtnByPriivilege(grid, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
     				   if (programGrpPnl) {
     					   var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid'),
     					   childGrid = programGrpPnl.down('#paymentGroupChildGrid');
     					   if (parentGrid && childGrid) {
     						   var parentSelection = parentGrid.getSelectionModel().getSelection(),
     						   childSelection = childGrid.getSelectionModel().getSelection();
     						   if (parentSelection && parentSelection.length > 0 && parentSelection[0].data) {
     							   if (childSelection && childSelection.length > 0 && childSelection[0].data) {
     								   var parentRecPaymentGroupId = parentSelection[0].data.paymentGroupId,
     								   childRecPaymentTermId = childSelection[0].data.id;
     								   if (grid.store && grid.store.getProxy()) {
     									   grid.store.getProxy().extraParams = {
     										   paymentGroupId: parentRecPaymentGroupId,
     										   paymentTermId: childRecPaymentTermId
     									   };
     									   grid.store.load({
     										   callback: function(records, operation, success) {
     											   if (success && records && records.length>0) {
     												   if(records[0].data.whetherBillGenerated){
     													   grid.down('#btnAdd').setDisabled(true);
     												   }
     											   }
     										   }
     									   });
     								   } 
     							   }
     						   }
     					   }
     				   } 
     			   }
    		},
    		'configurefeeheadgrid button#btnAdd': {
    			click: function(){
    				var grid = this.getConfigurefeeheadgrid();
    				//this.onFeeHeadGridAddClick(1, grid);V2D-500472
    				this.openConfigFeeHeadWindow('Add');
    				//.disableFeeConfigurationSaveResetBtnByPriivilege(grid,this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
    			}
    		},
     		 'configurefeeheadgrid button#resetBtn': {
    			  click: function(){
    				
    				var grid = this.getConfigurefeeheadgrid();
    				
    				var record = grid.getSelectionModel().getSelection();
    				if(record.length == 1){
    					record[0].set("serialNo", record[0].data.serialNo);
    					record[0].set("feeHead", '');
    					record[0].set("amountOrWeightage", '');
    					record[0].set("isAddDeleteRow", true);
    				}
    				else{
    	    		   showWarningMessage(getFeeAndPaymentCommonTranslation('FEE_HEAD_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	    	   }
    			  }
    		  },
     		  
     		 'configurefeeheadgrid button#submitBtn': {
     			  click: function(){
     				this.saveFeeHeadConfigurationDetail();
     			  }
     		  },
    		
    		'paymentgroupchildformwindow button#cancelItemId':{
    			click:function(){
    				var childFormWin = this.getPaymentgroupchildformwindow();
    				childFormWin.close();
    			}
    		},
    		'paymentgroupchildformwindow button#formSubmitButtonId':{
    			click:function(){
    				var $this=this;
    				var childFormWin = this.getPaymentgroupchildformwindow();
    				childFormWin.show();
    				var programGrpPnl =this.getProgramgroupsettingpanel();
    				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
    				var gridRec = childGrid.getSelectionModel().getSelection()[0];
    				var parentGridRec = parentGrid.getSelectionModel().getSelection()[0];
    				var childRecId =   childFormWin.down('#paymentTermId').getValue();
    				var childGridAllRec = childGrid.getStore().data.items;
    				var isDefaultRecExist = false;
    				Ext.each(childGridAllRec,function(item){
    					if(item.data.isDefaultPaymentTerm){
    						isDefaultRecExist=true
    					}
    				});
    				var form = childFormWin.down('form');
    				var me = this;
    				var formValues = form.getForm().getValues();
    				if(!formValues.isDefault){
    					formValues.isDefault=false;
    				}
    				var submitUrl, isUpdate = false;
    				if (isNullOrEmpty(childRecId)) {
    					submitUrl = SERVERURL.PAYMENT_TERM_CHILD_GRID_CREATE,
    					isUpdate = false;
    					var formData = {
    							paymentGroup:parentGridRec.data.paymentGroupId,
    							code: formValues.code,
    							name: formValues.name,
    							sequenceNo:formValues.sequenceNo,
    							isDefaultPaymentTerm:formValues.isDefault
    					};
    				} else {
    					submitUrl = SERVERURL.PAYMENT_TERM_CHILD_GRID_UPDATE,
    					isUpdate = true;
    					var formData = {
    							paymentGroup:parentGridRec.data.paymentGroupId,
    							id:   gridRec.data.id,
    							code: formValues.code,
    							name: formValues.name,
    							sequenceNo:formValues.sequenceNo,
    							isDefaultPaymentTerm:formValues.isDefault
    					};
    				}
                    if(isDefaultRecExist && formValues.isDefault && isUpdate && !gridRec.data.isDefaultPaymentTerm){  //edit case
                    	showConfirmMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'),getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CHANGE_THE_DEFAULT_PAYMENT_TERM'), function(btn, text) {
							if (btn == 'yes') {
								$this.savePaymentTermSetting(submitUrl,formData,isUpdate,childFormWin,childGrid);
							}
						});
                    }else if(isDefaultRecExist && formValues.isDefault){  //add case
                    	showConfirmMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'),getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CHANGE_THE_DEFAULT_PAYMENT_TERM'), function(btn, text) {
							if (btn == 'yes') {
								$this.savePaymentTermSetting(submitUrl,formData,isUpdate,childFormWin,childGrid);
							}
						});
                    }else{
                    	$this.savePaymentTermSetting(submitUrl,formData,isUpdate,childFormWin,childGrid);
                    }
    			}
    		},
    		'programgroupsettingpanel grid[itemId=paymentGroupMasterParentGrid] menuitem[itemId=doMappingLink]':{
    			click:this.getOpenDoMappingStructureForPaymentGrp
    		},
    		'paymentgroupmappedgrid button[itemId=btnAdd]': {
    			 click: function(obj){
             		this.screenName='payementGroupSetting';
             		this.openPaymentGrpMappingTab();
             	 }
    		},
    		'paymentgrpmappingacademylocationgrid customcombobox#academylocationsearchcombo':{
    			select:function(obj, record){
    				var grid =  this.getPaymentgrpmappingacademylocationgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'id',
    					value: record[0].get('id'),
    					exactMatch: true,
    					caseSensitive: true});
    				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+1);
    			}
    		},
    		'paymentgrpprogramgrid customcombobox#programsearchcombo' : {
    			select:function(obj, record){
    				var grid =  this.getPaymentgrpprogramgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'programId',
    					value: record[0].get('id'),
    					exactMatch: true,
    					caseSensitive: true});
    				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+1);
    			}
    		},
    		'paymentgrpprogrambatchgrid customcombobox#programbatchsearchcombo' : {
    			select:function(obj, record){
    				var grid =  this.getPaymentgrpprogrambatchgrid();
    				grid.getStore().clearFilter();
    				grid.getStore().filter({property: 'batchId',
    					value: record[0].get('id'),
    					exactMatch: true,
    					caseSensitive: true});
    				grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+1);
    			}
    		},
    		'paymentgrpwithprogrambatchseatstructure button#resetBtn':{
    			click:function(btn){
    				//	 var paymentgrpwithprogrambatchseatstructure = this.getPaymentgrpwithprogrambatchseatstructure();
    				var tabStructure = this.getPaymentgrpwithprogrambatchseatstructure();
    				var activeGrid = tabStructure.getActiveTab().down('grid');
    				activeGrid.getSelectionModel().deselectAll();
    				activeGrid.getStore().clearFilter();
    				if(activeGrid.down('customcombobox'))
    					activeGrid.down('customcombobox').reset();
    			}
    		},
    		'paymentgrpmappingacademylocationgrid button#nextButton':{
    			click:function(btn){
    				this.academyLocationNextEventPaymentGrp(btn);
    			}
    		},
    		'paymentgrpprogramgrid button#nextButton':{
    			click:function(btn){
    				this.programNextEventPaymentGrp(btn);
    			}
    		},
    		'paymentgrpprogrambatchgrid button#nextButton':{
    			click:function(btn){
    				this.programBatchNextEventPaymentGrp(btn);
    			}
    		},
    		'paymentgrpaLprogrambatchseattypegrid button#submitPaymentGrpMapping':{
    			click:function(btn){
    				this.submitPaymentGrpMappingWithProgramBatchSeatType();
    			}
    		},
    		'paymentgrpprogrambatchgrid button#submitProgramBatchMapping':{
    			click:function(btn){
    				this.submitPaymentGrpMappingWithProgramBatchLevel();
    			}
    		},
    		'paymentgroupmappingalertwin button[itemId=paymentGrpMappingAlertBtn]':{
    			click : function(btn) {
    				var alertWin = this.getPaymentgroupmappingalertwin();
    				alertWin.close();
    			}
    		},
    		'paymentgroupmappedgrid button[itemId=btnDelete]': {
    			click: this.deletePaymentGrpMappingDetails
    		},
    		'coursefeedefconfigform': {
    			render: function(form) {
    				var radioField = form.down('#courseFeeDefinitionId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherCourseFeeDefinitionConfig){
    							form.config.showPopup = false;
    							radioField.setDisabled(true);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionId')[0].items.items[1].setValue(true);
    							form.config.showPopup = true;
    						}
    					}
    				});
    			}
    		},
    		'coursefeedefconfigform radiogroup[itemId=courseFeeDefinitionId]':{
    			change:function(radioField, newValue, oldValue, eOpts){
    				var form = this.getCoursefeedefconfigform();
    				var value = form.getValues();
    				var organization= Academia.model.singleton.Organization;
    				if(newValue.courseFeeDefinition != undefined && newValue.courseFeeDefinition==true){
    					if(newValue.courseFeeDefinition==true && form.config.showPopup==true){
    						showConfirmMessage(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION'), getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_FLOW_FOR_FEE_MODULE'), function(btn, text) {
    							if (btn == 'yes') {
    								Ext.Ajax.request({
    									type : 'rest',
    									url : SERVERURL.PATH_WHETHER_COURSE_FEE_DEFINITION_CONFIG,
    									params:{
    										'organizationId' : organization.id,
    										'iscourseFeeDefinition':value.courseFeeDefinition
    									},
    									method : 'GET',
    									success : function(response, action) {
    										var message = response.responseText;
    										showSuccessMessage(getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION'),getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_UPDATED_SUCCESSFULLY'));  
    										radioField.setDisabled(true);
    									}
    								});
    							}else{
    								radioField.reset();
    							}
    						});
    					}else{
    						radioField.setDisabled(true);
    					}
    				}
    			}
    		},
    		'creditfeemappingform button[itemId=SubmitBtn]':{
    			click : function(btn) {
    				var form = this.getCreditfeemappingform();
    				var radioField = form.down('#creditFeeMappingId');
    				var saveBtn = form.down('#SubmitBtn');
    				var value = form.getValues();
    				var organization= Academia.model.singleton.Organization;
    				showConfirmMessage(getFeeAndPaymentCommonTranslation('CREDIT_FEE_MAPPING'), getFeeAndPaymentCommonTranslation('CREDIT_FEE_MAPPING_FLOW_FOR_FEE_MODULE'), function(btn, text) {
						if (btn == 'yes') {
							Ext.Ajax.request({
								type : 'rest',
								url : SERVERURL.PATH_WHEATHER_CREDIT_FEE_MAPPING_CONFIG,
								params:{
									'organizationId' : organization.id,
									'whetherCreditFeeappingConfig':value.creditFeeMapping
								},
								method : 'GET',
								success : function(response, action) {
									var message = response.responseText;
									showSuccessMessage(getFeeAndPaymentCommonTranslation('CREDIT_FEE_MAPPING'),getFeeAndPaymentCommonTranslation('CREDIT_FEE_MAPPING_UPDATED_SUCCESSFULLY'));  
									if(value.creditFeeMapping==true){
										radioField.setDisabled(true);
										saveBtn.setDisabled(true);
									}
								}
							});
						}
					});
    			}
    		},
    		'creditfeemappingform': {
    			render: function(form) {
    				var radioField = form.down('#creditFeeMappingId');
    				var saveBtn = form.down('#SubmitBtn');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherCreditFeeMappingConfig){
    							Ext.ComponentQuery.query('radiogroup#creditFeeMappingId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#creditFeeMappingId')[0].items.items[1].setValue(false);
    							radioField.setDisabled(true);
    							saveBtn.setVisible(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#creditFeeMappingId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#creditFeeMappingId')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			}
    		},
    		'billsettingswin': {
    			      afterrender: function() {
    			                    this.disableBillGenerationchk();     
    			                 }
    			                    },
    		'editbillsettingswin': {
        			      afterrender: function() {
        			                    this.disableBillGenerationchkedit();     
        			                 }
        			                    },
    		'receiptsettingsstructure':{
    			render: function(structure) {
    				
    				var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getRECEIPT_SETTINGS_PERMISSIONS());
			    	var creditFeeMappingTab=false;
			    	var autoSettlementJobConfig=false;
			    	var feeSetting=false
     			   	 for (var i = 0; i < permissionList.length; i++) {
     			   		 if (permissionList[i] === "CREDIT_FEE_MAPPING") {
     			   			creditFeeMappingTab=true;
     			   		 }
     			   		 if (permissionList[i] === "AUTO_SETTLEMENT_JOB_CONFIGURATION") {
     			   			 autoSettlementJobConfig=true;
     			   		 }
     			   		 if (permissionList[i] === "FEES_AND_PAYMENT_OTHER_SETTINGS") {
     			   			 feeSetting=true;
     			   		 }
     			   	 }
			    	this.DisableCreditFeeMappingTab(structure,creditFeeMappingTab,autoSettlementJobConfig,feeSetting);
    			}
    		},
    		'autosettlementjobconfigform':{
    			afterrender:function(form){
    				var radioField = form.down('#checkVoucherTypeId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isAutoSettlementVoucherType){
    							Ext.ComponentQuery.query('radiogroup#checkVoucherTypeId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#checkVoucherTypeId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#checkVoucherTypeId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#checkVoucherTypeId')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			}
    		},
    		'autosettlementjobconfigform button[itemId=SubmitBtn]':{
    			click : function(btn) {
    				var form = this.getAutosettlementjobconfigform();
    				var radioField = form.down('#checkVoucherTypeId');
    				var value = form.getValues();
    				var organization= Academia.model.singleton.Organization;
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.SET_AUTO_SETTLEMENT_VOUCHER_TYPE,
    					params:{
    						'organizationId' : organization.id,
    						'isAutoSettlementVoucherType':value.checkVoucherType
    					},
    					method : 'GET',
    					success : function(response, action) {
    						showSuccessMessage(getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT_JOB_CONFIGURATION'),getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT_JOB_CONFIGURATION_UPDATED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		},
    		'statementemailsettingform':{
    			afterrender:function(form){
    				var $this = this;
    				var grid = this.getStatementemailsettinggrid();
    				grid.store.load();
    				form.body.mask(getCommonTranslation('LOADING'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.PATH_FIND_STATEMENT_EMAIL_SETTING,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						$this.setDataOnStateEmailSettingForm(data);
    						form.body.unmask();
    					}
    				});
    			}
    		},
    		'statementemailsettingform customcombobox#templateMappingItemId':{
    			render: function(field){
    				var templateMappingStore=field.getStore();
    				templateMappingStore.on('beforeload', function(store, operation) {
    					templateMappingStore.proxy.extraParams.reportTypeName='Student Statement of Account';
    				});
    			}
    		},
    		'statementemailsettingform customcombobox#languageItemId':{
    			select: function(field){
    				var form = this.getStatementemailsettingform();
    				var languageFields = form.query('#languageItemId');
    				if(this.isDuplicateValueSelected(languageFields)){
    					field.reset();
    				}
    			}
    		},
    		'statementemailsettingform button[itemId=addMoreRowsBtnId]':{
    			click: function(obj){
    				this.addMoreRowsForStatementEmailSetting(obj);
    			}
    		},
             'statementemailsettingform button[itemId=SubmitBtn]':{
            	 click: function(obj){
            		 this.saveStatementEmailSetting();
            	 }
             },
             'statementemailsettingform button[itemId=resetBtn]':{
            	 click: function(obj){
            		 var form = this.getStatementemailsettingform();
            		 form.down('form').getForm().reset();
            	 }
             },
             'statementemailsettingform checkboxfield[itemId=markAsDefaultItemId]':{
            	 change: function(obj){
            		 var form = this.getStatementemailsettingform();
            		 var checkboxes = Ext.ComponentQuery.query('#markAsDefaultItemId')
            		 var correspondenceLang = form.down('#correspondenceLang').getValue();
            		 if(obj.getValue()){
            			 for(var j=0; j<checkboxes.length; j++){
            				
            					 if(obj.up().itemId != checkboxes[j].up().itemId){
            						 checkboxes[j].suspendEvent('change');
            						 checkboxes[j].setValue(false);
            						 checkboxes[j].resumeEvent('change');
            					 }
            			 }
            		 }
            	 }
             },
             'statementemailsettinggrid button[itemId=btnAdd]': {
            	 click: function(obj){
            		 this.screenName='stateEmailSetting';
            		 var grid = obj.up('statementemailsettinggrid');
            		 this.openPaymentGrpMappingTab();
            	 }
     		},
            'statementemailsettinggrid button[itemId=btnView]':{
            	click: function(obj){
            		var $this=this;
            		var grid = $this.getStatementemailsettinggrid();
            		var records = grid.getSelectionModel().getSelection();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var emailSettingWin = this.getStatementemailsettingapplytowin();
            			if (!emailSettingWin) {
            				Ext.widget('statementemailsettingapplytowin');
            				emailSettingWin = this.getStatementemailsettingapplytowin();
            			}
            			emailSettingWin.show();
            			if(records){
            				emailSettingWin.down('#academyLocation').setValue(records[0].data.academyLocationName);
            				emailSettingWin.down('#program').setValue(records[0].data.programName);
            				emailSettingWin.down('#batch').setValue(records[0].data.batchName);
            				emailSettingWin.down('#seatType').setValue(records[0].data.seatName);
            				this.toggleReadOnlyFormItems(emailSettingWin.down('form').getForm(), true);
            			}
            		}else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}
            	}
     		},
     		'statementemailsettingapplytowin button[itemId=CancelBtn]':{
     			click: function(obj){
     				this.getStatementemailsettingapplytowin().close();
     			}
     		},
     		'statementemailsettinggrid button[itemId=btnDelete]':{
     			click: function(obj){
     				var $this=this;
     				var grid = $this.getStatementemailsettinggrid();
     				if (grid.getSelectionModel().getCount() > 0) {
     					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
     						if (btn == 'yes') {
     							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     							var records = grid.getSelectionModel().getSelection();
     							var id = records[0].get("id");
     							Ext.Ajax.request({
     								method : "DELETE",
     								type : 'rest',
     								params:{
                                        id:id
                                    },
     								url : SERVERURL.PATH_DELETE_EMAIL_SETTING_MAPPING,
     								headers : {
     									'Content-Type' : 'application/json'
     								},
     								success : function(form,action) {
     									Ext.getBody().unmask();
     									grid.getStore().reload();
     									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
     								}
     							});
     						}
     					});
     				}else {
     					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     				}
     			}
     		},
     		'feesandpaymentothersettings customcombobox[itemId=settingFor]':{
     			select: function(obj){
     				var settingForm = this.getFeesandpaymentothersettings();
     				var panelItem = new Array();
     				if(obj.getValue()=='VOUCHER_SETTINGS'){
     					panelItem.push({
     						xtype:'vouchersettingsform'
     					});
     				}else if(obj.getValue()=='COURSE_FEE_DEFINITION'){
     					panelItem.push({
     						xtype:'coursefeedefconfigform'
     					});
     				}else if(obj.getValue()=='CREDIT_FEE_MAPPING'){
     					panelItem.push({
     						xtype:'creditfeemappingform'
     					});
     				}else if(obj.getValue()=='AUTO_SETTLEMENT_JOB_CONFIGURATION'){
     					panelItem.push({
     						xtype:'autosettlementjobconfigform'
     					});
     				}else if(obj.getValue()=='ONLINE_PAYMENT_SETTING'){
     					panelItem.push({
     						xtype:'onlinepaymentsettingsform'
     					});
     				}else if(obj.getValue()=='DISCOUNT_BILLING_AND_SETTLEMENT_SETTING'){
     					panelItem.push({
     						xtype:'discountBillAndSettlementForm'
     					});
     				}else if(obj.getValue()=='WHETHER_FEE_APPLICABLE_FOR_COURSE_ENROLLMENT'){
     					panelItem.push({
     						xtype:'whetherfeeforcourseenrollment'
     					});
     				}else if(obj.getValue()=='COURSE_FEE_DEFINITION_MAPPING_AT_BATCH'){
     					panelItem.push({
     						xtype:'courseFeeDefinitionMappingWin'
     					});
     				}else if(obj.getValue()=='COURSE_FEE_DEFINITION_FEE_PLAN'){
     					panelItem.push({
     						xtype:'courseFeeDefinitionFeePlanWin'
     					});
     				}else if(obj.getValue()=='FINANCE_HOLD_SETTING'){
     					panelItem.push({
     						xtype:'financeHoldSettingWin'
     					});
     				}else if(obj.getValue()=='LATE_FEE_BILL_CANCELLATION'){
     					panelItem.push({
     						xtype:'lateFeeBillCancellationForm'
     					});
     				}
     				else if(obj.getValue()=='CREDIT_NOTE_CANCELLATION_WITH_BILL_CANCELLATION'){
     					panelItem.push({
     						xtype:'creditCancellationWithBillForm'
     					});
     				}
     				else if(obj.getValue()=='IS_NEW_STATEMENT_OF_ACCOUNT'){
     					panelItem.push({
     						xtype:'isNewStatementOfAccountSettingWin'
     					});
     				}
     				else if(obj.getValue()=='PROGRAM_FEE_PLAN_MAPPED_PERIOD_LEVEL'){
     					panelItem.push({
     						xtype:'programFeePlanmappedperiod'
     					});
     				}else if(obj.getValue()=='INTEREST_APPLICABLE'){
     					panelItem.push({
     						xtype:'interestapplicableform'
     					});
     				}else if(obj.getValue()=='PAYMENT_PLAN_CALCULATION_WITH_PREVIOUS_OPENING_BALANCE'){
     					panelItem.push({
     						xtype:'paymentplancalculationconfigform'
     					});
     				}else if(obj.getValue() == 'CHECK_FEE_PLAN_AND_PAYMENT_TERM_TO_CREATE_BILL'){
     					panelItem.push({
     						xtype:'feeplanandpaymenttermforbillconfigform'
     					});
     				}else if(obj.getValue() == 'RECEIPT_REMAINS_IN_CASE_OF_TRANSFER'){
     					panelItem.push({
     						xtype:'receiptRemainsInCaseOfTransferConfigForm'
     					});
     				}else if(obj.getValue() == 'ESCAPE_RETAIN_FNP_ON_PRO_RATA_SETTING'){
     					panelItem.push({
     						xtype:'feeplanprorataconfigform'
     					});
     				}
     				settingForm.remove(1);
 					settingForm.insert(1,panelItem);
 					settingForm.doLayout();
     			}
     		},
     		'programFeePlanmappedperiod':{
     			render: function(form) {
    				var programFeePlanmapped = form.down('#programFeePlanmapped'),
    				 saveBtn = form.down('#SubmitBtnCancellation');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherFeePlanMappingAtPeriodLevel){
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[1].setValue(false);
    							programFeePlanmapped.setDisabled(true);
								saveBtn.setVisible(false);
    						}else if(data.whetherFeePlanMappingAtPeriodLevel == false){
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[1].setValue(true);
    							programFeePlanmapped.setDisabled(true);
								saveBtn.setVisible(false);
    						}else {
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#programFeePlanmapped')[0].items.items[1].setValue(false);
    						}
    					}
    				});
    			}
     		},
     		'onlinepaymentsettingsform': {
    			render: function(form) {
    				var paymentForSingleInvoiceId = form.down('#paymentForSingleInvoiceId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherOnlinePaymentSettings){
    							Ext.ComponentQuery.query('radiogroup#paymentForSingleInvoiceId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#paymentForSingleInvoiceId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#paymentForSingleInvoiceId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#paymentForSingleInvoiceId')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			},
    		},
    		'onlinepaymentsettingsform button[itemId=SubmitBtn]': {
    			click: function() {
    		    	var $this = this;
    		    	var form = $this.getOnlinepaymentsettingsform();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'whetherOnlinePaymentSettings':value.paymentForSingleInvoice
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},
    		'discountBillAndSettlementForm': {
    			render: function(form) {
    				var discountBillAndSettlementId = form.down('#discountBillAndSettlementId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherDiscountDateSetting){
    							Ext.ComponentQuery.query('radiogroup#discountBillAndSettlementId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#discountBillAndSettlementId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#discountBillAndSettlementId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#discountBillAndSettlementId')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			},
    		},
    		'whetherfeeforcourseenrollment': {
    			render: function(form) {
    				var othersetting = form.down('#whetherfeeforcourseenrollment');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherFeeForCourseEnrollment){
    							Ext.ComponentQuery.query('radiogroup#whetherfeeforcourseenrollment')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#whetherfeeforcourseenrollment')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#whetherfeeforcourseenrollment')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#whetherfeeforcourseenrollment')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			},
    		},
    		'whetherfeeforcourseenrollment button[itemId=SubmitBtn]': {
    			click: function() {
    		    	var $this = this;
    		    	var form = $this.getWhetherfeeforcourseenrollment();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'whetherFeeForCourseEnrollment':value
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},
    		'discountBillAndSettlementForm button[itemId=SubmitBtn]': {
    			click: function() {
    		    	var $this = this;
    		    	var form = $this.getDiscountBillAndSettlementForm();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'whetherDiscountDateSetting':value.discountBillAndSettlement
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},
    		'financeHoldSettingWin button[itemId=SubmitBtn]': {
    			click: function() { 
    		    	var form = this.getFinanceHoldSettingWin();
    		    	var value = form.getValues();
    		    	var saveBtn = form.down('#SubmitBtn');
    		    	var radioField = form.down('#financeHoldSettingId');
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'whetherFinanceHoldWithoutSettlement':value.financeHoldSetting
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			radioField.setDisabled(true);
    		    			saveBtn.setVisible(false);
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},'financeHoldSettingWin': {
    			render: function(form) {
    				var financeHoldSetting = form.down('#financeHoldSettingId');
    				var saveBtn = form.down('#SubmitBtn');
    				var radioField = form.down('#financeHoldSettingId');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(isNullOrEmpty(data.whetherFinanceHoldWithoutSettlement) || !data.whetherFinanceHoldWithoutSettlement){ 
    							Ext.ComponentQuery.query('radiogroup#financeHoldSettingId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#financeHoldSettingId')[0].items.items[1].setValue(false);
    							if(!isNullOrEmpty(data.whetherFinanceHoldWithoutSettlement)) {
    								radioField.setDisabled(true);
    								saveBtn.setVisible(false);
    							}
    						}else{
    							Ext.ComponentQuery.query('radiogroup#financeHoldSettingId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#financeHoldSettingId')[0].items.items[1].setValue(true);
    							radioField.setDisabled(true);
    							saveBtn.setVisible(false);
    						}
    					}
    				});
    			},
    		},
    		'courseFeeDefinitionMappingWin button[itemId=SubmitBtn]': {
    			click: function() { 
    		    	var form = this.getCourseFeeDefinitionMappingWin();
    		    	var value = form.getValues();
    		    	var saveBtn = form.down('#SubmitBtn');
    		    	var radioField = form.down('#courseFeeDefinitionMappingId');
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'isCourseFeeDefinitionMapping':value.courseFeeDefinitionMapping
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			radioField.setDisabled(true);
    						saveBtn.setVisible(false);
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},'courseFeeDefinitionMappingWin': {
    			render: function(form) {
    				var courseFeeDefinitionMapping = form.down('#courseFeeDefinitionMappingId');
    				var saveBtn = form.down('#SubmitBtn');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(isNullOrEmpty(data.isCourseFeeDefinitionMapping) || data.isCourseFeeDefinitionMapping){ 
    						    if(data.isCourseFeeDefinitionMapping){
    						       courseFeeDefinitionMapping.setDisabled(true);
    						       saveBtn.setVisible(false);
    						    }
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionMappingId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionMappingId')[0].items.items[1].setValue(false);
    						}else{
    						    courseFeeDefinitionMapping.setDisabled(true);
    						    saveBtn.setVisible(false);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionMappingId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionMappingId')[0].items.items[1].setValue(true);
    						}
    					}
    				});
    			},
    		},
    		'courseFeeDefinitionFeePlanWin button[itemId=SubmitBtn]': {
    			click: function() { 
    		    	var form = this.getCourseFeeDefinitionFeePlanWin();
    		    	var value = form.getValues();
    		    	var saveBtn = form.down('#SubmitBtn');
    		    	var radioField = form.down('#courseFeeDefinitionFeePlanId');
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'isCourseFeeDefinitionFeePlan':value.courseFeeDefinitionFeePlan
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			radioField.setDisabled(true);
    						saveBtn.setVisible(false);
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},'courseFeeDefinitionFeePlanWin': {
    			render: function(form) {
    				var radioField = form.down('#courseFeeDefinitionFeePlanId');
    				var saveBtn = form.down('#SubmitBtn');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(isNullOrEmpty(data.isCourseFeeDefinitionFeePlan) || data.isCourseFeeDefinitionFeePlan){ 
    						    Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionFeePlanId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionFeePlanId')[0].items.items[1].setValue(false);
			                    if(data.isCourseFeeDefinitionFeePlan){
    						       radioField.setDisabled(true);
    						       saveBtn.setVisible(false);
    						    }
    						}
		               else{ 
    						 radioField.setDisabled(true);
    						 saveBtn.setVisible(false);
    						 Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionFeePlanId')[0].items.items[0].setValue(false);
    						 Ext.ComponentQuery.query('radiogroup#courseFeeDefinitionFeePlanId')[0].items.items[1].setValue(true);
    							
			               }
    					}
    				});
    			}
    		},
    		'lateFeeBillCancellationForm':{
    			render:function(form){
    				var radioField = form.down('#lateFeeBillCancellation');
    				var saveBtn = form.down('#SubmitBtnCancellation');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isLateFeeAssociatedWithMainBill){ 
    						    Ext.ComponentQuery.query('radiogroup#lateFeeBillCancellation')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#lateFeeBillCancellation')[0].items.items[1].setValue(false);
			             	}
		               else{ 
    						  Ext.ComponentQuery.query('radiogroup#lateFeeBillCancellation')[0].items.items[0].setValue(false);
    						 Ext.ComponentQuery.query('radiogroup#lateFeeBillCancellation')[0].items.items[1].setValue(true);
    							
			               }
    					}
    				});
    			}
    		},
    		'lateFeeBillCancellationForm button[itemId=SubmitBtnCancellation]':{
    			click:function(btn){
    				var form = this.getLateFeeBillCancellationForm();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_LATE_FEE_ASSOCIATED_WITH_MAIN_BILL,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'isLateFeeAssociatedWithMainBill':value.lateFeeBill
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},
    		'programFeePlanmappedperiod button[itemId=SubmitBtnCancellation]':{
    			click:function(btn){
    				var form = this.getProgramFeePlanmappedperiod();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_SAVE_FEE_PLAN_MAPPING_AT_PERIOD_LEVEL_CONFIG ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'whetherFeePlanMappingAtPeriodLevel':value.programFeePlan
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},
    		'creditCancellationWithBillForm':{
    			render:function(form){
    				var radioField = form.down('#creditNoteCancellation');
    				var saveBtn = form.down('#SubmitBtnNoteCancellation');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isCreditNoteCancellationWithBillCancellation){ 
    						    Ext.ComponentQuery.query('radiogroup#creditNoteCancellation')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#creditNoteCancellation')[0].items.items[1].setValue(false);
    						}
		               else{ 
    						  Ext.ComponentQuery.query('radiogroup#creditNoteCancellation')[0].items.items[0].setValue(false);
    						 Ext.ComponentQuery.query('radiogroup#creditNoteCancellation')[0].items.items[1].setValue(true);
    							
			               }
    					}
    				});
    			}
    		},
    		'creditCancellationWithBillForm button[itemId=SubmitBtnNoteCancellation]':{
    			click:function(btn){

    				var form = this.getCreditCancellationWithBillForm();
    		    	var value = form.getValues();
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_CREDIT_NOTE_CANCELLATION_WITH_BILL_CANCELLATION,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'isCreditNoteCancellationWithBillCancellation':value.creditNoteCancel
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			
    			}
    		},
    		'isNewStatementOfAccountSettingWin button[itemId=SubmitBtn]': {
    			click: function() { 
    		    	var form = this.getIsNewStatementOfAccountSettingWin();
    		    	var value = form.getValues();
    		    	var saveBtn = form.down('#SubmitBtn');
    		    	var radioField = form.down('#isNewStatementOfAccountMappingId');
    		    	var organization= Academia.model.singleton.Organization;
    		    	Ext.Ajax.request({
    		    		type : 'rest',
    		    		url : SERVERURL.PATH_UPDATE_FEES_AND_PAYMENT_OTHER_SETTINGS ,
    		    		params:{
    		    			'organizationId' : organization.id,
    		    			'isNewStatementOfAccount':value.isNewStatementOfAccount
    					},
    		    		method : 'GET',
    		    		success : function(response, action) {
    		    			var message = response.responseText;
    		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    		    		}
    		    	});
    			}
    		},'isNewStatementOfAccountSettingWin': {
    			render:function(form){
    				var radioField = form.down('#isNewStatementOfAccountMappingId');
    				var saveBtn = form.down('#SubmitBtnCancellation');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isNewStatementOfAccount){ 
    						    Ext.ComponentQuery.query('radiogroup#isNewStatementOfAccountMappingId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#isNewStatementOfAccountMappingId')[0].items.items[1].setValue(false);
			             	}
		               else{ 
    						  Ext.ComponentQuery.query('radiogroup#isNewStatementOfAccountMappingId')[0].items.items[0].setValue(false);
    						 Ext.ComponentQuery.query('radiogroup#isNewStatementOfAccountMappingId')[0].items.items[1].setValue(true);
    							
			               }
    					}
    				});
    			}
    		},
    		'paymenttermconfigurefeeheadwin':{
    			afterrender:function(form){
    				var $this = this,
    				costCenterId = form.down('#costCenterId'),
    				weightage = form.down('#weightageId'),
    				grid = this.getConfigurefeeheadgrid(),
    				store = grid.getStore(),
    				total = 0;
    				if(store && weightage){
    					store.each(function (rec) {
    						total += parseInt(rec.get('paymentTermWeightage'));
    					});
    					if(form.formType=='Add'){
    						weightage.setValue(100-total);
    						weightage.setMaxValue(100-total);
    					}
    				}
    				Ext.Ajax.request({
    					type: 'rest',
    					async: false,
    					url: SERVERURL.COMMON_FORM_FIELD_INFO,
    					params: {
    						screenName: 'configurefeeheadsaddform',
    						academyLocationId: this.getCurrentAcademyLocation(),
    						languageCode:'en'
    					},
    					method: 'GET',
    					success: function(res, action) {
    						var response = Ext.decode(res.responseText);
    						$this.configFeeHeadDfrData = response;
    						if( Object.keys(response).length > 0 ){
    							var records=response.configurefeeheadsaddform;
    							if(records){
    								for(i in records){
    									if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='costCentre' && records[i].isVisible==true){
    										costCenterId.setVisible(true);
    										costCenterId.setFieldLabel(records[i].formFieldLabel);
    										if(records[i].isMandatory){
    											$this.setAllowBlank(costCenterId,false);
    										}
    										break;
    									}else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='costCentre' && records[i].isVisible==false){
    										costCenterId.setVisible(false);
    										$this.setAllowBlank(costCenterId,true);
    										break;
    									}
    								}
    							}
    						}
    					}
    				})
    			}
    		 },
    		'paymenttermconfigurefeeheadwin checkboxfield[itemId=discountId]':{
    			change:function(value,newValue,oldValue){
    			   var $this = this,
    			   response = $this.configFeeHeadDfrData,
                   win = this.getPaymenttermconfigurefeeheadwin(),
                   discountFeeHead = win.down('#discountFeeheadId'),
                   discountApplicabilityId =  win.down('#discountApplicabilityId'),
                   discountApplicabilityStore = discountApplicabilityId.getStore(),
                   discountcostcenterField =  win.down('#discountCostCentreId');
                   if(newValue){
                	   discountFeeHead.setVisible(true);
                	   discountFeeHead.reset();
                	   this.setAllowBlank(discountFeeHead,false);
                	   discountApplicabilityId.setVisible(true);
                	   discountApplicabilityId.reset();
                	   discountApplicabilityStore.getProxy().extraParams={
                		   stageName:'Course execution'
                	   }
                	   discountApplicabilityStore.load();
                	   this.setAllowBlank(discountApplicabilityId,false);
                	   discountcostcenterField.setVisible(true);
                	   discountcostcenterField.reset();
                	   win.down('form').getForm().checkValidity();
                	   if(response && Object.keys(response).length > 0 ){
                		   var records=response.configurefeeheadsaddform;
                		   if(records){
                			   for(i in records){
                				   if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='discountCostCentre' && records[i].isVisible==true && newValue){
                					   discountcostcenterField.setVisible(true);
                					   discountcostcenterField.setFieldLabel(records[i].formFieldLabel);
                					   if(records[i].isMandatory){
                						   $this.setAllowBlank(discountcostcenterField,false);
                					   }
                					   break;
                				   }else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='discountCostCentre' && records[i].isVisible==false){
                					   discountcostcenterField.setVisible(false);
                					   $this.setAllowBlank(discountcostcenterField,true);
                					   break;
                				   }
                			   }
                			   win.down('form').getForm().checkValidity();
                		   }
                	   }
                   }else{
                	   this.setAllowBlank(discountFeeHead,true);
                	   discountFeeHead.reset();
                	   discountFeeHead.setVisible(false);

                	   this.setAllowBlank(discountApplicabilityId,true);
                	   discountApplicabilityId.reset();
                	   discountApplicabilityId.setVisible(false);

                	   this.setAllowBlank(discountcostcenterField,true);
                	   discountcostcenterField.reset();
                	   discountcostcenterField.setVisible(false);
                	   win.down('form').getForm().checkValidity();
                   }
    			}
    		},
    		'paymenttermconfigurefeeheadwin button[itemId=btnCancelItemId]':{
    			click:function(){
    				var win = this.getPaymenttermconfigurefeeheadwin();
    				win.close();
    			}
    		},
    		'paymenttermconfigurefeeheadwin button[itemId=btnSaveItemId]':{
    			click:function(){
    				var win = this.getPaymenttermconfigurefeeheadwin(),
    				form = win.down('form'),
    				feeHead = win.down('#feeHeadId'),
    				costCenter = win.down('#costCenterId'),
    				discountFeehead = win.down('#discountFeeheadId'),
    				discountApplicability = win.down('#discountApplicabilityId'),
    				discountCostCentre = win.down('#discountCostCentreId'),
    				grid = this.getConfigurefeeheadgrid(),
    				store = grid.getStore(),
    				values = form.getValues(),
    				isEdit = !isNullOrEmpty(values.tempId) || !isNullOrEmpty(values.id);

    				// Extract display values
    				var feeHeadDisplay = feeHead.getRawValue();
    				var costCenterDisplay = costCenter.getRawValue();
    				var discountFeeheadDisplay = discountFeehead.getRawValue();
    				var discountApplicabilityDisplay = discountApplicability.getRawValue();
    				var discountCostCentreDisplay = discountCostCentre.getRawValue();

    				values.paymentTermWeightage = parseInt(values.amountOrWeightage);
    				values.feeHeadName = feeHeadDisplay;

    				// Check for duplicate feeHeadName (excluding self in edit)
    				var duplicate = store.findBy(function (r) {	
    					var feeHeadObj = r.get('feeHead');
    					var existingFeeHeadId = feeHeadObj && feeHeadObj.id;
    					var currentFeeHeadId = parseInt(values.feeHead, 10);

    					var sameFeeHead = existingFeeHeadId === currentFeeHeadId;

    					var isSameRecord = false;
    					if (isEdit) {
    						isSameRecord = (r.get('id') && r.get('id') == values.id) ||
    						(r.get('tempId') && r.get('tempId') == values.tempId);
    					}

    					return sameFeeHead && !isSameRecord;
    				});

    				if (duplicate !== -1) {
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FEE_HEAD_NAME_MUST_BE_UNIQUE'));
    					return;
    				}

    				var recordData = {
    						//id: isEdit ? store.findRecord('tempId', values.tempId)?.get('id') || null : null,
    						tempId: isEdit ? values.tempId : Ext.id(),
    								feeHeadName: feeHeadDisplay,
    								paymentTermWeightage: parseInt(values.amountOrWeightage),
    								whetherPayableDiscount: !!values.discount,
    								feeHead: values.feeHead ? {
    									id: values.feeHead,
    									value: feeHeadDisplay
    								} : null,
    								costCentre: values.costCenter ? {
    									id: values.costCenter,
    									value: costCenterDisplay
    								} : null,
    								payableDiscountFeehead: values.discountFeehead ? {
    									id: values.discountFeehead,
    									value: discountFeeheadDisplay
    								} : null,
    								discountType: values.discountApplicability,
    								discountCostCentre: values.discountCostCentre ? {
    									id: values.discountCostCentre,
    									value: discountCostCentreDisplay
    								} : null,
    								remark: values.remark
    				};
    				if (isEdit) {
    					var record;
    					if(!isNullOrEmpty(values.tempId)){
    						record = store.findRecord('tempId', values.tempId);
    					}else{
    						record = store.findRecord('id', values.id);
    					}

    					if (record) {
    						record.set(recordData); // Update record with new structured data
    					}
    				} else {
    					// Adding a new record in the grid
    					store.add(recordData);
    					this.updateSerialNumbers(store);
    				}
    				grid.getView().refresh();
    				grid.getSelectionModel().deselectAll();
    				showSuccessMessage(getCommonTranslation('FEE_HEAD_CONFIGURATION'), getCommonTranslation('FEE_HEAD_ADDED_TO_THE_PAYMENT_TERM'));
    				win.close();
    			}
    		},
    		'configurefeeheadgrid button[itemId=btnEdit]':{
    			click:function(btn){
    				this.setFeeHeadConfigData(btn,'Edit');
    			}
    		},
    		'configurefeeheadgrid button[itemId=btnView]':{
    			click:function(btn){
    				this.setFeeHeadConfigData(btn,'View');
    			}
    		},
    		'configurefeeheadgrid button[itemId=btnDelete]':{
    			click:function(btn){
    				var $this=this,grid = btn.up('grid'),
    				//var grid = this.getConfigurefeeheadgrid(),
    				store = grid.getStore(),
    				rec = grid.getSelectionModel().getSelection()[0];
    				if (grid.getSelectionModel().getCount() > 0) {
    					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    						if (btn == 'yes') {
    							if(rec && rec.data && rec.data.whetherBillGenerated){
    								showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('BILL_IS_ALREADY_CREATED'));
    							}else{
    								store.remove(rec);
    								$this.updateSerialNumbers(store);
    							}
    						}
    					});
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}
    			}
    		},
    		'interestapplicableform':{
    			render: function(form) {
    				var interestApplicableSchlStd = form.down('#interestApplicableSchlStdId'),
    				interestApplicableDebitOrderStd = form.down('#interestApplicableDebitOrderStdId'),
    				saveBtn = form.down('#submitBtn');
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isInterestApplicableOnScholarship){
    							Ext.ComponentQuery.query('radiogroup#interestApplicableSchlStdId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#interestApplicableSchlStdId')[0].items.items[1].setValue(false);
    						}else if(data.isinterestApplicableOnScholarship == false){
    							Ext.ComponentQuery.query('radiogroup#interestApplicableSchlStdId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#interestApplicableSchlStdId')[0].items.items[1].setValue(true);
    						}
    						if(data.isInterestApplicableOnDebitOrder){
    							Ext.ComponentQuery.query('radiogroup#interestApplicableDebitOrderStdId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#interestApplicableDebitOrderStdId')[0].items.items[1].setValue(false);
    						}else if(data.isinterestApplicableOnDebitOrder == false){
    							Ext.ComponentQuery.query('radiogroup#interestApplicableDebitOrderStdId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#interestApplicableDebitOrderStdId')[0].items.items[1].setValue(true);
    						}
    						Ext.getBody().unmask(); 
    					}
    				});
    			}
     		},
    		'interestapplicableform button[itemId=submitBtn]':{
    			click:function(btn){
    				var form = this.getInterestapplicableform();
    				var value = form.getValues();
    				var organization= Academia.model.singleton.Organization;
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_SET_INTEREST_APPLICABLE_ON_SCHOLARSHIP_AND_DEBIT_ORDER ,
    					params:{
    						'organizationId' : organization.id,
    						'isInterestApplicableOnDebitOrder':value.interestApplicableDebitOrderStd,
    						'isInterestApplicableOnScholarship':value.interestApplicableSchlStd
    					},
    					method : 'GET',
    					success : function(response, action) {
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		},
    		'paymentplancalculationconfigform':{
    			render: function(form) {
    				var paymentPlanCalculationId = form.down('#paymentPlanCalculationId'),
    				saveBtn = form.down('#submitBtn');
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.isPaymentPlanCalculationWithOutstanding){
    							Ext.ComponentQuery.query('radiogroup#paymentPlanCalculationId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#paymentPlanCalculationId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#paymentPlanCalculationId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#paymentPlanCalculationId')[0].items.items[1].setValue(true);
    						}
    						Ext.getBody().unmask(); 
    					}
    				});
    			}
     		},
    		'paymentplancalculationconfigform button[itemId=submitBtn]':{
    			click:function(btn){
    				var form = this.getPaymentplancalculationconfigform();
    				var value = form.getValues();
    				var organization= Academia.model.singleton.Organization;
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_SET_PAYMENT_PLAN_CALCULATION_WITH_OUTSTANDING,
    					params:{
    						'organizationId' : organization.id,
    						'isPaymentPlanCalculationWithOutstanding':value.paymentPlanCalculation,
    					},
    					method : 'GET',
    					success : function(response, action) {
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		},
    		'feeplanandpaymenttermforbillconfigform':{
     			render: function(form) {
     				var feePlanPaymentTermToCreateBillId = form.down('#feePlanPaymentTermToCreateBillId'),
    				saveBtn = form.down('#submitBtn');
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.whetherNormalCourseBillingAtPaymentTermLevel || isNullOrEmpty(data.whetherNormalCourseBillingAtPaymentTermLevel)){//by default yes should be selected
    							Ext.ComponentQuery.query('radiogroup#feePlanPaymentTermToCreateBillId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#feePlanPaymentTermToCreateBillId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#feePlanPaymentTermToCreateBillId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#feePlanPaymentTermToCreateBillId')[0].items.items[1].setValue(true);
    						}
    						Ext.getBody().unmask(); 
    					}
    				});
     			}
     		},
     		'feeplanandpaymenttermforbillconfigform button[itemId=submitBtn]':{
    			click:function(btn){
    				var jsonData={},form = this.getFeeplanandpaymenttermforbillconfigform();
    				value = form.getValues(),
    				organization= Academia.model.singleton.Organization;
    				jsonData.id = organization.id;
    				jsonData.whetherNormalCourseBillingAtPaymentTermLevel = value.feePlanPaymentTermToCreateBill;
    				var encodeJsonData = Ext.encode(jsonData);
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_WHETHER_NORMAL_COURSE_BILLING_AT_PAYMENT_TERM_LEVEL,
    					jsonData:encodeJsonData,
    					method : 'POST',
    					success : function(response, action) {
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		},
    		'receiptRemainsInCaseOfTransferConfigForm':{
     			render: function(form) {
     				var receiptRemainsCaseofTransferId = form.down('#receiptRemainsCaseofTransferId'),
    				saveBtn = form.down('#submitBtn');
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.receiptRemainsCaseofTransfer){
    							Ext.ComponentQuery.query('radiogroup#receiptRemainsCaseofTransferId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#receiptRemainsCaseofTransferId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#receiptRemainsCaseofTransferId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#receiptRemainsCaseofTransferId')[0].items.items[1].setValue(true);
    						}
    						Ext.getBody().unmask(); 
    					}
    				});
     			}
     		},
     		'receiptRemainsInCaseOfTransferConfigForm button[itemId=submitBtn]':{
    			click:function(btn){
    				var jsonData={},form = this.getReceiptRemainsInCaseOfTransferConfigForm(),
    				value = form.getValues(),
    				organization= Academia.model.singleton.Organization;
    				jsonData.id = organization.id;
    				jsonData.receiptRemainsCaseofTransfer = value.receiptRemainsCaseofTransfer;
    				var encodeJsonData = Ext.encode(jsonData);
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_RECEIPT_REMAINS_CASE_OF_TRANSFER,
    					jsonData:encodeJsonData,
    					method : 'POST',
    					success : function(response, action) {
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		},
    		'feeplanprorataconfigform':{
     			render: function(form) {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.ORGINFOLOADREQUEST,
    					success: function(response, action) {
    						var data = JSON.parse(response.responseText);
    						if(data.escapeRetainFeesandPaymentsOnProrata){
    							Ext.ComponentQuery.query('radiogroup#feePlanProrataSettingId')[0].items.items[0].setValue(true);
    							Ext.ComponentQuery.query('radiogroup#feePlanProrataSettingId')[0].items.items[1].setValue(false);
    						}else{
    							Ext.ComponentQuery.query('radiogroup#feePlanProrataSettingId')[0].items.items[0].setValue(false);
    							Ext.ComponentQuery.query('radiogroup#feePlanProrataSettingId')[0].items.items[1].setValue(true);
    						}
    						Ext.getBody().unmask(); 
    					}
    				});
     			}
     		},
     		'feeplanprorataconfigform button[itemId=submitBtn]':{
    			click:function(btn){
    				var form = this.getFeeplanprorataconfigform(),
    				value = form.getValues(),
    				organization= Academia.model.singleton.Organization;
    				
    				Ext.Ajax.request({
    					type : 'rest',
    					url : SERVERURL.PATH_UPDATE_ESCAPE_RETAIN_FEESAND_PAYMENTS_ON_PRO_RATA,
    					//jsonData:encodeJsonData,
    					params:{
    						escapeRetainFeesandPaymentsOnProrata:value.feePlanProrataSetting,
    						organizationId: organization.id
    					},
    					method : 'GET',
    					success : function(response, action) {
    						showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));  
    					}
    				});
    			}
    		}
    	});
    },
    showReceiptSettingsWin: function() {
    	var formWindow = this.getReceiptsettingswin();
    	if (!formWindow) {
    		Ext.widget('receiptsettingswin');
    		formWindow = this.getReceiptsettingswin();
    	}
        formWindow.show();
    },
    showEditReceiptSettingsWin: function() {
        var formWindow = this.getEditreceiptsettingswin();
        if (!formWindow) {
            Ext.widget('editreceiptsettingswin');
            formWindow = this.getEditreceiptsettingswin();
        }
        formWindow.show();

    },
    saveReceiptSettingsRecords: function() {
        var $this = this;
        var form = $this.getReceiptsettingswin().down("#receiptSettingsFormItemId");
        var values = form.getValues();
        var aL = values.academyLocationId;

        var receiptSettingsModel = null;
        var myJson = [];
        if (aL != undefined && aL.length > 0) {
            for (var i in aL) {
                if (!isNullOrEmpty(aL[i].get("id"))) {
                    receiptSettingsModel = new Academia.model.receipt.receiptsettings.ReceiptSettingsModel();
                    var academyLocation = {
                        id: aL[i].get("id")
                    };
                    receiptSettingsModel.set("academyLocation", academyLocation);
                    receiptSettingsModel.set("backDateAllowed", true);
                    receiptSettingsModel.set("allowAmountValueInDecimal", values.allowAmountValueInDecimal);
                    receiptSettingsModel.set("autoFetchReceiptAmount", values.autoFetchReceiptAmount);
                    receiptSettingsModel.set("numberOfDays", values.numberOfDays);

                    myJson.push(receiptSettingsModel.data);
                }
            }
        }

        var formData = Ext.encode(myJson);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.RECEIPT_SETTING_CREATE,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getReceiptsettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getReceiptsettingswin().close();
                showSuccessMessage(getCommonTranslation('RS_RECEIPT_SETTINGS'), getCommonTranslation('RS_CREATED_SUCCESSFULLY'));
            }
        });

    },
    editReceiptSettingsWin: function() {
        var grid = this.getReceiptsettingsgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            this.showEditReceiptSettingsWin();
            var form = this.getEditreceiptsettingswin();
            if (!isNullOrEmpty(records) && records.length > 0) {
                var id = records[0].data.id;
                var academyLocationId = records[0].data.academyLocation.id;
                var academyLocationCombo = form.down("#academyLocationItemId");
                academyLocationCombo.store.load({
                    callback: function(records, operation, success) {
                        if (success) {
                            academyLocationCombo.setValue(academyLocationId);
                        }
                    }
                });
                form.down('#idItemId').setValue(id);
                form.down('#numberOfDaysItemId').setValue(records[0].data.numberOfDays);
                if(records[0].data.allowAmountValueInDecimal==true){
    				form.down('#allowAmountValueInDecimal').setValue(true);
    			}
                if(records[0].data.autoFetchReceiptAmount==true){
    				form.down('#autoFetchReceiptAmount').setValue(true);
    			}else{
    				form.down('#autoFetchReceiptAmount').setValue(false);
    			}
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    editReceiptSettingsRecord: function() {
        var $this = this;
        var form = $this.getEditreceiptsettingswin().down("#editReceiptSettingsFormItemId");
        var values = form.getValues();

        var receiptSettingsModel = new Academia.model.receipt.receiptsettings.ReceiptSettingsModel();
        var academyLocationId = values.academyLocationId;
        var academyLocation = {
            id: academyLocationId
        };
        if(values.allowAmountValueInDecimal != true){
        	values.allowAmountValueInDecimal = false;
        }
        receiptSettingsModel.set("academyLocation", academyLocation);
        receiptSettingsModel.set("backDateAllowed", true);
        receiptSettingsModel.set("numberOfDays", values.numberOfDays);
        receiptSettingsModel.set("allowAmountValueInDecimal", values.allowAmountValueInDecimal);
        receiptSettingsModel.set("autoFetchReceiptAmount", values.autoFetchReceiptAmount);
        receiptSettingsModel.set("id", values.id);

        var formData = Ext.encode(receiptSettingsModel.data);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.RECEIPT_SETTING_UPDATE,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getReceiptsettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getEditreceiptsettingswin().close();
                showSuccessMessage(getCommonTranslation('RS_RECEIPT_SETTINGS'), getCommonTranslation('RS_UPDATED_SUCCESSFULLY'));
            }
        });

    },
    deleteReceiptSettingRecord: function() {
    	var $this = this;
        var grid = this.getReceiptsettingsgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage('Receipt Settings', getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                function(btn, text) {
                    if (btn == 'yes') {
                        var records = grid.getSelectionModel().getSelection();
                        var id = records[0].data.id;
                        var academyLocationId = records[0].data.academyLocation.id;
                        Ext.Ajax.request({
                            method: "GET",
                            type: 'rest',
                            url: SERVERURL.RECEIPT_SETTING_DELETE + '?id=' + id, //+ '&academyLocationId=' + academyLocationId,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id
                            },
                            success: function(f, action) {
                                $this.resetPageSetting(grid.getStore());
                            	grid.getStore().load();
                            	grid.getSelectionModel().deselectAll(true);
                            	showSuccessMessage(getCommonTranslation('RS_RECEIPT_SETTINGS'), getCommonTranslation('RS_DELETED_SUCCESSFULLY'));}
                        });
                    }
                });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    viewReceiptSettingWin: function() {
        this.editReceiptSettingsWin();
        var form = this.getEditreceiptsettingswin().down("#editReceiptSettingsFormItemId");

        if (form) {
            form.down('#btnSaveEditReceiptSettingsWinItemId').hide();
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },
    showBillSettingsWin: function() {
        var formWindow = this.getBillsettingswin();
        if (!formWindow) {
            Ext.widget('billsettingswin');
            formWindow = this.getBillsettingswin();
        }
        formWindow.show();
        formWindow.down('#showAdditionalColumns').setValue(true);
    },
    showEditBillSettingsWin: function() {
        var formWindow = this.getEditbillsettingswin();
        if (!formWindow) {
            Ext.widget('editbillsettingswin');
            formWindow = this.getEditbillsettingswin();
        }
        formWindow.show();

    },
      //************* edit Bill Setting records********************
    editBillSettingsWin:function(){
    	var $this = this;
    	var grid = $this.getBillsettingsgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		$this.showEditBillSettingsWin();
    		var form = $this.getEditbillsettingswin();
    		if (!isNullOrEmpty(records) && records.length > 0) {
    			var id = records[0].data.id;
    			var academyLocationId = records[0].data.academyLocation.id;
    			var academyLocationCombo = form.down("#academyLocationItemId");
    			academyLocationCombo.setReadOnly(true);
    			academyLocationCombo.store.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						academyLocationCombo.setValue(academyLocationId);
    					}
    				}
    			});
    			if(records[0].data.showAdditionalColumns==true){
    				form.down('#showAdditionalColumns').setValue(true);
    			}
    			if(records[0].data.whetherDueDateEditable==true)
    			{
    			    form.down('#dueDateEditable').setValue(true);
    			}
    			if(records[0].data.billGenerationOnSubmitApplication==true){
    				form.down('#billGenerationOnSubmitApplication').setValue(true);
    			}
    			form.down('form').getForm().findField('id').setValue(id);
    			form.down('#backDateAllowInDaysItemId').setValue(records[0].data.backDateAllowInDays);
    			form.down('#futureDateAllowInDaysItemId').setValue(records[0].data.futureDateAllowInDays);
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    saveBillSettingsRecords: function() {
        var $this = this;
        var form = $this.getBillsettingswin().down("#billSettingsFormItemId");
        var values = form.getValues();
        var dateEditable = form.down('#dueDateEditable');
        var dueDateEditable = dateEditable.getValue();
        var aL = values.academyLocationId;
        var billSettingsModel = null;
        var myJson = [];
        if (aL != undefined && aL.length > 0) {
            for (var i in aL) {
                if (!isNullOrEmpty(aL[i].get("id"))) {
                    billSettingsModel = new Academia.model.receipt.receiptsettings.BillSettingsModel();
                    var academyLocation = {
                        id: aL[i].get("id")
                    };
                    billSettingsModel.set("academyLocation", academyLocation);
                    billSettingsModel.set("showAdditionalColumns", values.showAdditionalColumns);
                    billSettingsModel.set("backDateAllowInDays", values.backDateAllowInDays);
                    billSettingsModel.set("futureDateAllowInDays", values.futureDateAllowInDays);
                    billSettingsModel.set("whetherDueDateEditable", dueDateEditable);
                    billSettingsModel.set("billGenerationOnSubmitApplication",form.down('#billGenerationOnSubmitApplication').getValue());

                    myJson.push(billSettingsModel.data);
                }
            }
        }
        var submitURL = SERVERURL.PATH_BILLSETTING_CREATE;
        var formData = Ext.encode(myJson);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: submitURL,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getBillsettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getBillsettingswin().close();
                showSuccessMessage(getFeeAndPaymentCommonTranslation('BILL_SETTINGS'), getFeeAndPaymentCommonTranslation('BILL_SETTINGS_CREATED_SUCCESSFULLY'));
            }
        });

    },
    editBillSettingsRecord: function() {
        var $this = this;
        var form = $this.getEditbillsettingswin().down("#editBillSettingsFormItemId");
        var values = form.getValues();

        var dateEditable = form.down('#dueDateEditable');
        var dueDateEditable = dateEditable.getValue();
        var billSettingsModel = new Academia.model.receipt.receiptsettings.BillSettingsModel();
        var academyLocationId = values.academyLocationId;
        var academyLocation = {
            id: academyLocationId
        };
        billSettingsModel.set("academyLocation", academyLocation);
        billSettingsModel.set("showAdditionalColumns", values.showAdditionalColumns);
        billSettingsModel.set("backDateAllowInDays", values.backDateAllowInDays);
        billSettingsModel.set("futureDateAllowInDays", values.futureDateAllowInDays);
        billSettingsModel.set("id", values.id);
        billSettingsModel.set("whetherDueDateEditable", dueDateEditable);
        billSettingsModel.set("billGenerationOnSubmitApplication",form.down('#billGenerationOnSubmitApplication').getValue());
        

        var formData = Ext.encode(billSettingsModel.data);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_BILL_SETTING_UPDATE,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getBillsettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getEditbillsettingswin().close();
                showSuccessMessage(getFeeAndPaymentCommonTranslation('BILL_SETTINGS'), getFeeAndPaymentCommonTranslation('BILL_SETTINGS_UPDATED_SUCCESSFULLY'));
            }
        });

    },
    deleteBillSettingRecord: function() {
    	var $this = this;
        var grid = this.getBillsettingsgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage('Bill Settings', getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                function(btn, text) {
                    if (btn == 'yes') {
                        var records = grid.getSelectionModel().getSelection();
                        var id = records[0].data.id;
                        var academyLocationId = records[0].data.academyLocation.id;
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: SERVERURL.PATH_BILL_SETTING_DELETE + '?id=' + id, //+ '&academyLocationId=' + academyLocationId,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(f, action) {
                                $this.resetPageSetting(grid.getStore());
                            	grid.getStore().load();
                            	grid.getSelectionModel().deselectAll(true);
                            	showSuccessMessage(getFeeAndPaymentCommonTranslation('BILL_SETTINGS'), getFeeAndPaymentCommonTranslation('BILL_SETTINGS_DELETED_SUCCESSFULLY'));}
                        });
                    }
                });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    showDiscountDateSettingsWin: function() {
        var formWindow = this.getDiscountdatesettingswin();
        if (!formWindow) {
            Ext.widget('discountdatesettingswin');
            formWindow = this.getDiscountdatesettingswin();
        }
        formWindow.show();
    },
    showEditDiscountDateSettingsWin: function() {
        var formWindow = this.getEditdiscountdatesettingswin();
        if (!formWindow) {
            Ext.widget('editdiscountdatesettingswin');
            formWindow = this.getEditdiscountdatesettingswin();
        }
        formWindow.show();

    },
    showEditBankChargesSettingsWin: function() {
        var formWindow = this.getEditbankchangessettingswin();
        if (!formWindow) {
            Ext.widget('editbankchangessettingswin');
            formWindow = this.getEditbankchangessettingswin();
        }
        formWindow.show();

    },
    showViewBankChargesSettingsWin: function() {
        var formWindow = this.getViewbankchangessettingswin();
        if (!formWindow) {
            Ext.widget('viewbankchangessettingswin');
            formWindow = this.getViewbankchangessettingswin();
        }
        formWindow.show();

    },
    saveDiscountDateSettingsRecords: function() {
        var $this = this;
        var form = $this.getDiscountdatesettingswin().down("#discountDateSettingsFormItemId");
        var values = form.getValues();
        var aL = values.academyLocationId;

        var receiptSettingsModel = null;
        var myJson = [];
        if (aL != undefined && aL.length > 0) {
            for (var i in aL) {
                if (!isNullOrEmpty(aL[i].get("id"))) {
                    discountDateSettingsModel = new Academia.model.receipt.receiptsettings.DiscountDateSettingsModel();
                    var academyLocation = {
                        id: aL[i].get("id")
                    };
                    discountDateSettingsModel.set("academyLocation", academyLocation);
                    discountDateSettingsModel.set("backDateAllowInDays", values.backDateAllowInDays);

                    myJson.push(discountDateSettingsModel.data);
                }
            }
        }

        var formData = Ext.encode(myJson);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_DISCOUNT_DATE_SETTING_CREATE,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getDiscountdatesettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getDiscountdatesettingswin().close();
                showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'), getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTING_CREATED_SUCCESSFULLY'));
            }
        });

    },
    editDiscountDateSettingsWin: function() {
        var grid = this.getDiscountdatesettingsgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            this.showEditDiscountDateSettingsWin();
            var form = this.getEditdiscountdatesettingswin();
            if (!isNullOrEmpty(records) && records.length > 0) {
                var id = records[0].data.id;
                var academyLocationId = records[0].data.academyLocation.id;
                var academyLocationCombo = form.down("#academyLocationItemId");
                academyLocationCombo.store.load({
                    callback: function(records, operation, success) {
                        if (success) {
                            academyLocationCombo.setValue(academyLocationId);
                        }
                    }
                });
                form.down('#idItemId').setValue(id);
                form.down('#backDateAllowInDaysItemId').setValue(records[0].data.backDateAllowInDays);
                form.down('#futureDateAllowInDaysItemId').setValue(records[0].data.futureDateAllowInDays);
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    editDiscountDateSettingsRecord: function() {
        var $this = this;
        var form = $this.getEditdiscountdatesettingswin().down("#editDiscountDateSettingsFormItemId");
        var values = form.getValues();

        var discountDateSettingsModel = new Academia.model.receipt.receiptsettings.DiscountDateSettingsModel();
        var academyLocationId = values.academyLocationId;
        var academyLocation = {
            id: academyLocationId
        };
        discountDateSettingsModel.set("academyLocation", academyLocation);
        discountDateSettingsModel.set("backDateAllowInDays", values.backDateAllowInDays);
        discountDateSettingsModel.set("id", values.id);

        var formData = Ext.encode(discountDateSettingsModel.data);
        $this.applyWindowMask();
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_DISCOUNT_DATE_SETTING_UPDATE,
            jsonData: formData,
            method: 'POST',
            success: function(f, action) {
                $this.hideWindowMask();
                var grid = $this.getDiscountdatesettingsgrid();
                $this.resetPageSetting(grid.getStore());
                grid.getStore().load();
                grid.getSelectionModel().deselectAll(true);
                $this.getEditdiscountdatesettingswin().close();
                showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'), getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTING_UPDATED_SUCCESSFULLY'));
            }
        });

    },
    deleteDiscountDateSettingRecord: function() {
    	var $this = this;
        var grid = this.getDiscountdatesettingsgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                function(btn, text) {
                    if (btn == 'yes') {
                        var records = grid.getSelectionModel().getSelection();
                        var id = records[0].data.id;
                        var academyLocationId = records[0].data.academyLocation.id;
                        Ext.Ajax.request({
                            method: "DELETE",
                            type: 'rest',
                            url: SERVERURL.PATH_DISCOUNT_DATE_SETTING_DELETE + '?id=' + id, //+ '&academyLocationId=' + academyLocationId,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(f, action) {
                                $this.resetPageSetting(grid.getStore());
                            	grid.getStore().load();
                            	grid.getSelectionModel().deselectAll(true);
                            	showSuccessMessage(getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'), getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTING_DELETED_SUCCESSFULLY'));}
                        });
                    }
                });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    showBankChargesSettingsWin: function() {
        var formWindow = this.getBankchargessettingswin();
        if (!formWindow) {
            Ext.widget('bankchargessettingswin');
            formWindow = this.getBankchargessettingswin();
        }
        formWindow.show();
        //formWindow.down('#showAdditionalColumns').setValue(true);
    },
    saveBankChargesRecords: function() {
    	var $this = this;
    	var form = $this.getBankchargessettingswin().down("#bankChargesSettingsWinFormItemId");
    	var values = form.getValues();
    	var paymentModeField = form.down('#feePaymentModes');
    	var bankDrawnMasterField = form.down('#bankDrawnOnMaster');
    	var bankChargesModel = null;
    	var myJson = [];
    	bankChargesModel = new Academia.model.receipt.receiptsettings.BankChargesSettingsModel();

    	bankChargesModel.set("feePaymentMode", $this.getIdValueJson(paymentModeField.getValue(),paymentModeField.getRawValue()));
    	bankChargesModel.set("bankDrawnOnMaster", $this.getIdValueJson(bankDrawnMasterField.getValue(),bankDrawnMasterField.getRawValue()));
    	bankChargesModel.set("fromDate", values.fromDate);
    	bankChargesModel.set("toDate", values.toDate);
    	bankChargesModel.set("bankChargesApplicable", values.bankChargesApplicable);
    	bankChargesModel.set("thresholdLimit", values.thresholdLimit);

    	myJson.push(bankChargesModel.data);

    	if(values.bankChargesApplicable > 100){
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('BANK_CHARGES_APPLICABLE_ALERT'));
    	}
    	else{
    		var submitURL = SERVERURL.PATH_BANKCHARGES_SETTINGS_CREATE;
    		var formData = Ext.encode(myJson);
    		$this.applyWindowMask();
    		Ext.Ajax.request({
    			type: 'rest',
    			url: submitURL,
    			jsonData: formData,
    			method: 'POST',
    			success: function(f, action) {
    				$this.getBankchargessettingswin().close();
    				$this.hideWindowMask();
    				var grid = $this.getBankchargessettingsgrid();
    				grid.getStore().load();
    				grid.getSelectionModel().deselectAll(true);
    				showSuccessMessage(getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'), getFeeAndPaymentCommonTranslation('BANK_CHARGES_CREATED_SUCCESSFULLY'));

    			},failure: function(form, action) {
    				$this.getBankchargessettingswin().close();
    				this$.hideWindowMask();
    			}
    		});
    	}
    },
    getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	},
	  editBankChargesSettings:function(isView){
	    	var $this = this;
	    	var grid = $this.getBankchargessettingsgrid();
	    	if (grid.getSelectionModel().getCount() > 0) {
	    		var records = grid.getSelectionModel().getSelection();
	    		if(isView){

	    			
	    			$this.showViewBankChargesSettingsWin();
		    		var form = $this.getViewbankchangessettingswin();
		    		if (!isNullOrEmpty(records) && records.length > 0)
		    		{
		    			var id = records[0].data.id;
		    			var paymentMode = records[0].data.feePaymentMode.id;
		    			var paymentModeCombo = form.down("#feePaymentModes");
		    			paymentModeCombo.setReadOnly(true);
		    			paymentModeCombo.store.load({
		    				callback: function(records, operation, success) {
		    					if (success) {
		    						paymentModeCombo.setValue(paymentMode);
		    					}
		    				}
		    			});
		    			var bankMaster = records[0].data.bankDrawnOnMaster.id;
		    			var bankMasterCombo = form.down("#bankDrawnOnMaster");
		    			
		    			var thresholdLimit = form.down('#thresholdLimitItemId');
		    			thresholdLimit.setReadOnly(true);
		    			bankMasterCombo.setReadOnly(true);
		    			
		    			bankMasterCombo.store.load({
		    				callback: function(records, operation, success) {
		    					if (success) {
		    						bankMasterCombo.setValue(bankMaster);
		    					}
		    				}
		    			});
		    			form.down('form').getForm().findField('id').setValue(id);
		    			//form.down('#feePaymentModes').setValue(records[0].data.feePaymentMode.value);
		    			//form.down('#bankDrawnOnMaster').setValue(records[0].data.bankDrawnOnMaster.value);
		    			form.down('#fromDate').setValue(dateRender(records[0].data.fromDate));
		    			form.down('#toDate').setValue(dateRender(records[0].data.toDate));
		    			form.down('#bankChargesApplicable').setValue(records[0].data.bankChargesApplicable);
		    			thresholdLimit.setValue(records[0].data.thresholdLimit);
	    			
	    			
    				/*form.down('#btnSaveEditBankChargesSettingsItemId').setVisible(false);
    				//form.down('#btnCancelEditBankChargesSettingsItemId').setVisible(false);
     	         //  toggleReadOnlyFormItems(form.down('form').getForm(), true);
     	          form.down('#fromDate').setReadOnly(true);
     	         form.down('#toDate').setReadOnly(true);
	    			form.down('#bankChargesApplicable').setReadOnly(true);*/
     	        }
	    		
	    		}else{$this.showEditBankChargesSettingsWin();
	    		var form = $this.getEditbankchangessettingswin();
	    		if (!isNullOrEmpty(records) && records.length > 0)
	    		{
	    			var id = records[0].data.id;
	    			var paymentMode = records[0].data.feePaymentMode.id;
	    			var paymentModeCombo = form.down("#feePaymentModes");
	    			var thresholdLimit = form.down('#thresholdLimitItemId');
	    			
	    			paymentModeCombo.setReadOnly(true);
	    			paymentModeCombo.store.load({
	    				callback: function(records, operation, success) {
	    					if (success) {
	    						paymentModeCombo.setValue(paymentMode);
	    					}
	    				}
	    			});
	    			var bankMaster = records[0].data.bankDrawnOnMaster.id;
	    			var bankMasterCombo = form.down("#bankDrawnOnMaster");
	    			bankMasterCombo.setReadOnly(true);
	    			
	    			bankMasterCombo.store.load({
	    				callback: function(records, operation, success) {
	    					if (success) {
	    						bankMasterCombo.setValue(bankMaster);
	    					}
	    				}
	    			});
	    			form.down('form').getForm().findField('id').setValue(id);
	    			//form.down('#feePaymentModes').setValue(records[0].data.feePaymentMode.value);
	    			//form.down('#bankDrawnOnMaster').setValue(records[0].data.bankDrawnOnMaster.value);
	    			form.down('#fromDate').setValue(dateRender(records[0].data.fromDate));
	    			form.down('#toDate').setValue(dateRender(records[0].data.toDate));
	    			form.down('#bankChargesApplicable').setValue(records[0].data.bankChargesApplicable);
	    			thresholdLimit.setValue(records[0].data.thresholdLimit);
	    			
	    		}
	    	}
	    	} else {
	    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	}
	    },
	    editBankChargesSettingsSaveRecords: function() {
	        var $this = this;
	        var form = $this.getEditbankchangessettingswin().down("#editBankChargesSettingsWinFormItemId");
	        var values = form.getValues();
	        var paymentModeField = form.down('#feePaymentModes');
	        var bankDrawnMasterField = form.down('#bankDrawnOnMaster');
	        bankChargesModel = new Academia.model.receipt.receiptsettings.BankChargesSettingsModel();
            
			bankChargesModel.set("feePaymentMode", $this.getIdValueJson(paymentModeField.getValue(),paymentModeField.getRawValue()));
			bankChargesModel.set("bankDrawnOnMaster", $this.getIdValueJson(bankDrawnMasterField.getValue(),bankDrawnMasterField.getRawValue()));
			bankChargesModel.set("fromDate", values.fromDate);
			bankChargesModel.set("toDate", values.toDate);
			bankChargesModel.set("bankChargesApplicable", values.bankChargesApplicable);
			bankChargesModel.set("id", values.id);
			bankChargesModel.set("thresholdLimit", values.thresholdLimit);
			
			if(values.bankChargesApplicable > 100){
				 showWarningMessage(getCommonTranslation('ALERT'), getFeeAndPaymentCommonTranslation('BANK_CHARGES_APPLICABLE_ALERT'));
			}
			else{
				
				var formData = Ext.encode(bankChargesModel.data);
				$this.applyWindowMask();
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_BANKCHARGES_SETTINGS_UPDATE,
					jsonData: formData,
					method: 'POST',
					success: function(f, action) {
						$this.hideWindowMask();
						var grid = $this.getBankchargessettingsgrid();
						$this.resetPageSetting(grid.getStore());
						grid.getStore().load();
						grid.getSelectionModel().deselectAll(true);
						$this.getEditbankchangessettingswin().close();
						showSuccessMessage(getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'), getFeeAndPaymentCommonTranslation('BANK_CHARGES_UPDATED_SUCCESSFULLY'));
					}
				});
			}

	    },
	    deleteBankChargesRecord: function() {
	    	var $this = this;
	        var grid = this.getBankchargessettingsgrid();
	        if (grid.getSelectionModel().getCount() > 0) {
	            showConfirmMessage('Bank Charges Settings', getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	                function(btn, text) {
	                    if (btn == 'yes') {
	                        var records = grid.getSelectionModel().getSelection();
	                        var id = records[0].data.id;
	                        Ext.Ajax.request({
	                            method: "DELETE",
	                            type: 'rest',
	                            url: SERVERURL.PATH_BANKCHARGES_SETTINGS_DELETE + '?id=' + id,
	                            headers: {
	                                'Content-Type': 'application/json'
	                            },
	                            success: function(f, action) {
	                                $this.resetPageSetting(grid.getStore());
	                            	grid.getStore().load();
	                            	grid.getSelectionModel().deselectAll(true);
	                            	showSuccessMessage(getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'), getFeeAndPaymentCommonTranslation('BANK_CHARGES_DELETED_SUCCESSFULLY'));}
	                        });
	                    }
	                });
	        } else {
	            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        }
	    },
	    getOpenBankChargesHistoryDetails : function(grid,record){
	    	var this$=this;
	    	Ext.widget('bankchargeshistorysetupwindow');
	    	var	formWindow = this$.getBankchargeshistorysetupwindow();
	    	//var paymentMode=record.data.paymentMode.value;
	    //	var bankMaster=record.data;
	    //	var title = formCurrencyCode+" to "+toCurrencyCode;
	    	var title = getFeeAndPaymentCommonTranslation('DATE_WISE_BANKCHARGES');
	    	var tabName = getFeeAndPaymentCommonTranslation('DATE_WISE_BANKCHARGES');
	    	var contentpanel = this.getContentPanel();
	    	var coursetabstructure = Ext.widget('bankchargeshistorysetupwindow');
	    	var getcontroller=this.getController('menu.CoreERPNavigationController');
	    	var getTab=getcontroller.getTab(tabName);
	    	openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_FIVE);
	    	var grid = contentpanel.getActiveTab().down('grid');
	    	grid.setTitle(title);
	    	var store = grid.getStore();
	    	store.getProxy().extraParams={
	    		id: record.get('id'),
	    	}
	    	store.load();
	    },
	    saveVoucherSettings: function() {
	    	var $this = this;
	    	var form = $this.getVouchersettingsform();
	    	var value = form.getValues();
	    	var organization= Academia.model.singleton.Organization;
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : SERVERURL.PATH_WHEATHER_VERIFICATION_REQUIRED,
	    		params:{
	    			'organizationId' : organization.id,
	    			'isVoucherVerificationRequired':value.verificationRequired
				},
	    		method : 'GET',
	    		success : function(response, action) {
	    			var message = response.responseText;
	    			showSuccessMessage(getFeeAndPaymentCommonTranslation('VOUCHER_SETTINGS'),"Voucher Settings Updated Successfully");  

	    		}
	    	});
	    },
	 	getOpenDoMappingStructureForPaymentGrp: function(){
	 		var $this = this;
    		var programGrpPnl =this.getProgramgroupsettingpanel();
    		var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
    		if(parentGrid.getSelectionModel().getCount() > 0 ){

          		var contentpanel = $this.getContentPanel();
          		var mappingTabstructure = Ext.widget('paymentgroupmappingstructure');  
          		var tabName = getCommonTranslation('APPLY_TO');

          		var getcontroller=$this.getController('menu.CoreERPNavigationController');
          		var getTab=getcontroller.getTab(tabName);
          		if(getTab!=null){
          			contentpanel.remove(getTab, true);
          		}
          		openTab(contentpanel, tabName, mappingTabstructure,CONSTANTS.MENU_COLOR_TWO);
          		
          		
          		var programGrpPnl =this.getProgramgroupsettingpanel();
         		var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
                var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data
                  
               	
          		var gridMap = $this.getPaymentgroupmappedgrid();
          		gridMap.getStore().getProxy().extraParams={
          			paymentGroupId:records.data.paymentGroupId
      			};
          		$this.resetPageSetting(gridMap.getStore());
          		gridMap.getStore().load();
          	
    		}
    		else {
	            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        }
	 	},
	 	openPaymentGrpMappingTab: function(){

          	var contentpanel = this.getContentPanel();
          	var addMappingtabstructure = Ext.widget('paymentgroupaddmappingtab');
          	var tabName = getCommonTranslation('ADD_MAPPING');

          	var getcontroller=this.getController('menu.CoreERPNavigationController');
          	var getTab=getcontroller.getTab(tabName);
          	if(getTab!=null){
          		contentpanel.remove(getTab, true);
          	}
          	openTab(contentpanel, tabName, addMappingtabstructure,CONSTANTS.MENU_COLOR_TWO);
          	if(this.screenName=='stateEmailSetting'){
          		addMappingtabstructure.down('#paymentGrpALId').setVisible(false);
          	}
          	var academylocationgrid = this.getPaymentgrpmappingacademylocationgrid();
          	var paymentgrpwithprogrambatchseatstructure = this.getPaymentgrpwithprogrambatchseatstructure();

          	academylocationgrid.getStore().clearFilter();
          	academylocationgrid.body.mask(getCommonTranslation('LOADING'), 'x-mask-loading');
          	academylocationgrid.getStore().load({
          		callback:function(){
          			academylocationgrid.body.unmask();
          		}
          	});
          	this.getPaymentgroupmappingprogresstracker().setVisible(true);
          	
          	this.VMAdmResetProgressTracker();
          	var adjustmentprogresstracker = addMappingtabstructure.down("#paymentgroupmappingprogresstrackerId");
          	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
          	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
          	progresstracker1.textEl.addCls("inProgressCss-progress-text");
          	progresstracker1.updateText("Step 1 In Progress");
        	  
          var programGrpPnl =this.getProgramgroupsettingpanel();
    		var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
         	if(parentGrid){
          		var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data
              	if(records){
              		paymentgrpwithprogrambatchseatstructure.down("#paymentGrpALId").setValue(records.get('name'));
              		addMappingtabstructure.down('#PaymentGrpMappingName').setValue(records.get('name'));
              		addMappingtabstructure.down('#PaymentGrpMappingId').setValue(records.get('paymentGroupId'));
              	}
          	}
          
          
	 	},
	 	setProgressTracker : function(progresstracker){
  		  var structure = this.getPaymentgroupaddmappingtab();
  		  var adjustmentprogresstracker = structure.down("#paymentgroupmappingprogresstrackerId");

  		  var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
  		  var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
  		  var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
  		  var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");

  		  if(progresstracker==1){
  			  for(var i = 0; i < 11; i ++ ){
  				  progresstracker1.updateProgress((i * 0.1), '');
  			  }
  			  progresstracker1.textEl.addCls("custom-progress-text");
  			  progresstracker1.textEl.removeCls("inProgressCss-progress-text");
  			  progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
  			  progresstracker2.textEl.addCls("inProgressCss-progress-text");
  			  progresstracker2.updateText("Step 2 In Progress");
  			  progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
  		  }
  		  if(progresstracker==2){
  			  for(var i = 0; i < 11; i ++ ){
  				  progresstracker2.updateProgress((i * 0.1), '');
  			  }
  			  progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
  			  progresstracker3.textEl.addCls("inProgressCss-progress-text");
  			  progresstracker3.updateText("Step 3 In Progress");
  			  progresstracker2.textEl.removeCls("inProgressCss-progress-text");
  			  progresstracker2.textEl.addCls("custom-progress-text");
  			  progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
  		  }
  		  if(progresstracker==3){
  			  for(var i = 0; i < 11; i ++ ){
  				  progresstracker3.updateProgress((i * 0.1), '');
  			  }
  			  progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
  			  progresstracker4.textEl.addCls("inProgressCss-progress-text");
  			  progresstracker4.updateText("Step 4 In Progress");
  			  progresstracker3.textEl.removeCls("inProgressCss-progress-text");
  			  progresstracker3.textEl.addCls("custom-progress-text");
  			  progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
  		  }
  		  if(progresstracker==4){
  			  for(var i = 0; i < 11; i ++ ){
  				  progresstracker4.updateProgress((i * 0.1), '');
  			  }
  			  progresstracker4.textEl.removeCls("inProgressCss-progress-text");
  			  progresstracker4.textEl.addCls("custom-progress-text");
  			  progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
  		  }
  	  },
	 	 VMAdmResetProgressTracker : function(){
	          	var structure = this.getPaymentgroupaddmappingtab();
	          	var adjustmentprogresstracker = structure.down("#paymentgroupmappingprogresstrackerId");
	          	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
	          	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
	          	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
	          	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
	          	progresstracker1.reset();
	          	progresstracker1.updateText('');
	          	progresstracker2.reset();
	          	progresstracker2.updateText('');
	          	progresstracker3.reset();
	          	progresstracker3.updateText('');
	          	progresstracker4.reset();
	          	progresstracker4.updateText('');
	          },
	          
	          academyLocationNextEventPaymentGrp:function(btn){
	        	  	var paymentGrpAcademyLocationGrid = this.getPaymentgrpmappingacademylocationgrid();
	        	  	var paymentGrpSelectionModel = paymentGrpAcademyLocationGrid.getSelectionModel().getSelection();
	        	  	var academyLocationIdsArr = [];
	        	  	paymentGrpSelectionModel.forEach(function(obj){
	        	  		academyLocationIdsArr.push(obj.get('id'));
	        	  	});
	        	  	if(academyLocationIdsArr.length > 0){
	        		    	var paymentWithProgramBatchSeatStructure = this.getPaymentgrpwithprogrambatchseatstructure();
	        		    	var addMappingtabstructure = this.getPaymentgroupaddmappingtab();
	        		    	var programcontainer = paymentWithProgramBatchSeatStructure.down('#programcontainer');
	        		    	programcontainer.setDisabled(false);
	        		    	paymentWithProgramBatchSeatStructure.setActiveTab(programcontainer);
	        		    	if(this.screenName=='stateEmailSetting'){
	        	          		addMappingtabstructure.down('#paymentGrpProgramTab').setVisible(false);
	        	          	}
	        		    	var alProgramGrid = this.getPaymentgrpprogramgrid();
	        		    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	        		    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	        		    		academyLocationIds: academyLocationIdsArr.join()
	        		    	};
	        		    	alProgramSearchCombo.getStore().load();
	        		    	var alProgramGridStore = alProgramGrid.getStore();
	        		    	alProgramGridStore.getProxy().extraParams= {
	        		    		academyLocationIds: academyLocationIdsArr.join(),
	        		    		limit: 500
	        		    	};
	        		    	alProgramGridStore.clearFilter();
	        		    	alProgramGrid.body.mask(getCommonTranslation('LOADING'), 'x-mask-loading');
	        		    	alProgramGridStore.load({
	        		    		callback:function(){
	        		    			alProgramGrid.body.unmask();
	        		    		}
	        		    	});
	        		    	this.setProgressTracker(1);
	        		    	
	        		    	var programGrpPnl =this.getProgramgroupsettingpanel();
	        		    	var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	        		    	if(parentGrid){
	        		    		var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data
	        		    		if(records){
	        		    			var paymentGrpMappingName = addMappingtabstructure.down('#PaymentGrpMappingName').getValue();
	        		    			paymentWithProgramBatchSeatStructure.down("#paymentGrpProgramTab").setValue(paymentGrpMappingName); 
	        		    		}
	        		    	}
	        		    	
	        	  	} else {
	        	  		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	        	  	}
	        	  },
	        	  programNextEventPaymentGrp: function(btn){
	        		  var paymentgrpprogramgrid = this.getPaymentgrpprogramgrid();
	        		  var paymentGrpSelectionModel = paymentgrpprogramgrid.getSelectionModel().getSelection();
	        		  var alprogramgridIdsArr = [];
	        		  var programIdsArr = [];
	        		  paymentGrpSelectionModel.forEach(function(obj){
	        			  alprogramgridIdsArr.push(obj.get('academyLocationId'));
	        			  programIdsArr.push(obj.get('programId'));
	        		  });

	        		  if(programIdsArr.length > 0){
	        			  var paymentWithProgramBatchSeatStructure = this.getPaymentgrpwithprogrambatchseatstructure();
	        			  var addMappingtabstructure = this.getPaymentgroupaddmappingtab();
	        			  var programbatchcontainer = paymentWithProgramBatchSeatStructure.down('#programbatchcontainer');
	        			  programbatchcontainer.setDisabled(false);
	        			  paymentWithProgramBatchSeatStructure.setActiveTab(programbatchcontainer);
	        			  if(this.screenName=='stateEmailSetting'){
	        				  addMappingtabstructure.down('#submitProgramBatchMapping').setVisible(true);
	        				  addMappingtabstructure.down('#paymentGrpProgramBatchTab').setVisible(false);
	        			  }
	        			  var aLProgramBatchGrid = this.getPaymentgrpprogrambatchgrid();

	        			  var aLProgramBatchSearchCombo = aLProgramBatchGrid.down('#programbatchsearchcombo');
	        			  aLProgramBatchSearchCombo.getStore().getProxy().extraParams= {
	        				  academyLocationIds: alprogramgridIdsArr.join(),
	        				  programIds:programIdsArr.join()
	        			  };
	        			  aLProgramBatchSearchCombo.getStore().load();

	        			  var aLProgramBatchGridStore = aLProgramBatchGrid.getStore();
	        			  aLProgramBatchGridStore.getProxy().extraParams= {
	        				  academyLocationIds: alprogramgridIdsArr.join(),
	        				  programIds:programIdsArr.join()
	        			  };
	        			  aLProgramBatchGridStore.clearFilter();
	        			  aLProgramBatchGrid.body.mask(getCommonTranslation('LOADING'), 'x-mask-loading');
	        			  aLProgramBatchGridStore.load({
	        				  callback:function(){
	        					  aLProgramBatchGrid.body.unmask();
	        				  }
	        			  });

	        			  this.setProgressTracker(2);
	        			  var programGrpPnl =this.getProgramgroupsettingpanel();
	        		    	var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	        		    	if(parentGrid){
	        		    		var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data
	        		    		if(records){
	        		    			var paymentGrpMappingName = addMappingtabstructure.down('#PaymentGrpMappingName').getValue();
	        		    			paymentWithProgramBatchSeatStructure.down("#paymentGrpProgramBatchTab").setValue(paymentGrpMappingName); 
	        		    		}
	        		    	}

	        		  } else {
	        			  showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	        		  }
	        	  },
	        	  programBatchNextEventPaymentGrp:function(btn){
	        			var alprogrambatchgrid = this.getPaymentgrpprogrambatchgrid();
	        			var selectionModel = alprogrambatchgrid.getSelectionModel().getSelection();
	        			var alprogramgridIdsArr = [];
	        			var programIdsArr = [];
	        			var batchIdsArr = [];
	        			selectionModel.forEach(function(obj){
	        				alprogramgridIdsArr.push(obj.get('academyLocationId'));
	        				programIdsArr.push(obj.get('programId'));
	        				batchIdsArr.push(obj.get('batchId'));
	        			});

	        			if(batchIdsArr.length > 0){
	        				var paymentWithProgramBatchSeatStructure = this.getPaymentgrpwithprogrambatchseatstructure();
	        				var addMappingtabstructure = this.getPaymentgroupaddmappingtab();
	        				var programbatchseattypecontainer = paymentWithProgramBatchSeatStructure.down('#programbatchseattypecontainer');
	        				programbatchseattypecontainer.setDisabled(false);
	        				paymentWithProgramBatchSeatStructure.setActiveTab(programbatchseattypecontainer);
	        				var alProgramBatchSeatTypeGrid = this.getPaymentgrpaLprogrambatchseattypegrid();
	        				var alProgramBatchSeatTypeGridStore = alProgramBatchSeatTypeGrid.getStore();
	        				if(this.screenName=='stateEmailSetting'){
	        					addMappingtabstructure.down('#paymentGrpProgramBatchSeattypeTab').setVisible(false);
	        					alProgramBatchSeatTypeGrid.columns[4].hide();
	        					var store = Ext.getStore('receipt.receiptsettings.StateEmailSettingALPBSTList');
	        					alProgramBatchSeatTypeGrid.reconfigure(store);
	        					var alProgramBatchSeatTypeGridStore = alProgramBatchSeatTypeGrid.getStore();
	        					alProgramBatchSeatTypeGridStore.getProxy().extraParams= {
		        					academyLocationIds: alprogramgridIdsArr.join(),
		        					programIds:programIdsArr.join(),
		        					batchIds:batchIdsArr.join()
		        				};
	        				}else{
	        					var alProgramBatchSeatTypeGridStore = alProgramBatchSeatTypeGrid.getStore();
	        					alProgramBatchSeatTypeGridStore.getProxy().extraParams= {
		        					academyLocationIds: alprogramgridIdsArr.join(),
		        					programIds:programIdsArr.join(),
		        					batchIds:batchIdsArr.join(),
		        					screen:'paymentGroup'
		        				};
	        				}
	        				alProgramBatchSeatTypeGridStore.clearFilter();
	        				alProgramBatchSeatTypeGrid.body.mask(getCommonTranslation('LOADING'), 'x-mask-loading');
	        				alProgramBatchSeatTypeGridStore.load({
	        					callback:function(){
	        						alProgramBatchSeatTypeGrid.body.unmask();
	        					}
	        				});
	        				this.setProgressTracker(3);
	        				var programGrpPnl =this.getProgramgroupsettingpanel();
	        				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	        				if(parentGrid){
	        					var records = parentGrid.getSelectionModel().getSelection()[0]; //main grid data
	        					if(records){
	        						var paymentGrpMappingName = addMappingtabstructure.down('#PaymentGrpMappingName').getValue();
	        						paymentWithProgramBatchSeatStructure.down("#paymentGrpProgramBatchSeattypeTab").setValue(paymentGrpMappingName); 
	        					}
	        				}
	        			} else {
	        				showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	        			}
	        		},
	        		
	        		submitPaymentGrpMappingWithProgramBatchSeatType: function(btn){
	        			  	var tabStructure = this.getPaymentgrpwithprogrambatchseatstructure();
	        				var paymentgrpActiveGrid = tabStructure.getActiveTab().down('grid');
	        				var selectedRecord = paymentgrpActiveGrid.getSelectionModel().getSelection();
	        				var addMappingtabstructure = this.getPaymentgroupaddmappingtab();
	        				var paymentGroupId  = addMappingtabstructure.down('#PaymentGrpMappingId').getValue();
	        			//	var addfinanceHoldMappingtab = this.getManagefinanceprogramfeemappingstructure();
	        			//	var financeHoldMappingId = addfinanceHoldMappingtab.down('#financeHoldMappingId').getValue();
	        				var submitJsonArr = [];
	        				var submitUrl;
	        				if(selectedRecord.length>0){
	        					if(paymentgrpActiveGrid.xtype == 'paymentgrpaLprogrambatchseattypegrid'){
	        						if(this.screenName=='stateEmailSetting'){
	        							submitUrl= SERVERURL.PATH_SAVE_EMAIL_SETTING_AT_SEAT_TYPE_LEVEL;
	        							selectedRecord.forEach(function(obj){
		        							submitJsonArr.push({
		        								academyLocation: {id:obj.get('academyLocationId')},
		        								programBatchSeatConfiguration:{id:obj.get('programBatchSeatTypeId')}
		        							});
		        						});
	        						}else{
	        							submitUrl = SERVERURL.PATH_PAYMENT_GRP_MAPPING_PROGBATCHSEATCONFIG_CREATE;
	        							selectedRecord.forEach(function(obj){
		        							submitJsonArr.push({
		        								paymentGroup: {id:paymentGroupId},
		        								academyLocation: {id:obj.get('academyLocationId')},
		        								progBatchSeatConfig:{id:obj.get('programBatchSeatTypeId')},
		        								programBatchPeriodConfiguration:{id:obj.get('programBatchPeriodId')}
		        							});
		        						});
	        						}
	        					}
	        					Ext.Ajax.request({
	        						method: "POST",
	        						type: 'rest',
	        						url: submitUrl,
	        						scope:this,
	        						jsonData:submitJsonArr,
	        						success : function(response, action) {
	        							var contentpanel = this.getContentPanel();
	        							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');

	        							var getcontroller=this.getController('menu.CoreERPNavigationController');
	        							var getTab=getcontroller.getTab(tabName);
	        							if(getTab!=null){
	        								contentpanel.remove(getTab, true);
	        							}
	        							var grid;
	        							if(this.screenName=='stateEmailSetting'){
	        								grid = this.getStatementemailsettinggrid();
	        							}else{
	        								grid = this.getPaymentgroupmappedgrid();
	        							}
	        							var grdStore = grid.getStore();
	        							grdStore.load();
	        							grid.getSelectionModel().deselectAll(true);
	        							var data = response.responseText;
	        							if(data == 'success' || data == 'SUCCESS'){
	        								showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
	        							} else {
	        								var alertWin = this.getPaymentgroupmappingalertwin();
	        								if(!alertWin){
	        									alertWin = Ext.widget('paymentgroupmappingalertwin');
	        								}
	        								alertWin.down('#paymentGrpMappingAlertId').setValue(data);
	        								alertWin.show();
	        							}
	        						}
	        					});
	        				} else {
	        					showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	        				}
	        			},
	        			submitPaymentGrpMappingWithProgramBatchLevel:function(){
	        				var tabStructure = this.getPaymentgrpwithprogrambatchseatstructure();
	        				var paymentgrpActiveGrid = tabStructure.getActiveTab().down('grid');
	        				var selectedRecord = paymentgrpActiveGrid.getSelectionModel().getSelection();
	        				var addMappingtabstructure = this.getPaymentgroupaddmappingtab();
	        				var submitJsonArr = [];
	        				if(selectedRecord.length>0){
	        					selectedRecord.forEach(function(obj){
	        						submitJsonArr.push({
	        							academyLocation: {id:obj.get('academyLocationId')},
	        							program:{id:obj.get('programId')},
	        							batch:{id:obj.get('batchId')}
	        						});
	        					});
	        					Ext.Ajax.request({
	        						method: "POST",
	        						type: 'rest',
	        						url: SERVERURL.PATH_SAVE_EMAIL_SETTING_AT_BATCH_LEVEL,
	        						scope:this,
	        						jsonData:submitJsonArr,
	        						success : function(response, action) {
	        							var contentpanel = this.getContentPanel();
	        							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');

	        							var getcontroller=this.getController('menu.CoreERPNavigationController');
	        							var getTab=getcontroller.getTab(tabName);
	        							if(getTab!=null){
	        								contentpanel.remove(getTab, true);
	        							}
	        							var grid = this.getStatementemailsettinggrid();
	        							var grdStore = grid.getStore();
	        							grdStore.load();
	        							grid.getSelectionModel().deselectAll(true);
	        							var data = response.responseText;
	        							if(data == 'success'){
	        								showSuccessMessage(getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'), getFeeAndPaymentCommonTranslation('APPLY_TO_CREATED_SUCCESS'));
	        							} else {
	        								var alertWin = this.getPaymentgroupmappingalertwin();
	        								if(!alertWin){
	        									alertWin = Ext.widget('paymentgroupmappingalertwin');
	        								}
	        								alertWin.down('#paymentGrpMappingAlertId').setValue(data);
	        								alertWin.show();
	        							}
	        						}
	        					});
	        				} else {
	        					showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
	        				}
	        			},
	        			deletePaymentGrpMappingDetails:function(){
	        				var $this =this;
	        				var grid = this.getPaymentgroupmappedgrid();
	        				var grdStore = grid.getStore();

	        				var gridModel = grid.getSelectionModel().getSelection();
	        				var id = [];
	        				gridModel.forEach(function(obj){
	        					id.push(obj.get('id'));

	        				});
	        				var delId = id.join();
	        				if (grid.getSelectionModel().getCount() > 0) {
	        					showConfirmMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        						if (btn == 'yes') {
	        							var record = grid.getSelectionModel().getSelection()[0];

	        							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        							var submitUrl = SERVERURL.PATH_PAYMENT_GROUP_MAPPING_DELETE;
	        							Ext.Ajax.request({
	        								type : 'rest',
	        								url : submitUrl+"?id="+record.data.id,
	        								method : 'DELETE',
	        								success : function(form, action) {
	        									Ext.getBody().unmask();
	        									showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'),getCommonTranslation('RECORD_DELETE_SUCCESS'));
	        									grid.getStore().reload();
	        									grid.getSelectionModel().deselectAll();
	        									$this.resetPageSetting(grid.getStore());
	        								}
	        							});
	        						}
	        					});
	        				} else {
	        					showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));	        				}
	        			},
	        			DisableCreditFeeMappingTab:function(structure,creditFeeMappingTab,autoSettlementJobConfig,feeSetting){
	        				var panelItem = new Array();
	        				var $this = this;
	        				var newcont=structure.items.items.length;
	        				var insertPosition=newcont;
	        				panelItem.push({
	        					xtype: 'tabpanel',
	        					itemId: 'allVisibleTP',
	        					plain: true,
	        					style: {
	        						overflow: 'hidden !important'
	        					},
	        					frame: false,
	        					border: false,
	        					defaults: {
	        						labelAlign: 'top'
	        					},
	        					items: []
	        				});
	        				var insertAt = panelItem["0"].items.length;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						itemId:'BillContainer',
	        						autoScroll: true,
	        						title: getFeeAndPaymentCommonTranslation('BILL_SETTINGS'),
	        						items:[{
	        							xtype:'panel',
	        							items:[{
		        							xtype:'billsettingsgrid',
		        							itemId:'billsettingsgrid'
		        						}]
	        						}]
	        				};
	        				insertAt = insertAt + 1;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						itemId:'receiptContainer',
	        						autoScroll: true,
	        						title: getCommonTranslation('RS_RECEIPT_SETTINGS'),
	        						items:[{
	        							xtype:'receiptsettingsgrid',
		        						itemId:'receiptsettingsgrid',
	        						}]
	        				};
	        				insertAt = insertAt + 1;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						itemId:'discountContainer',
	        						autoScroll: true,
	        						title: getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'),
	        						items:[{
	        							xtype:'discountdatesettingsgrid',
	        							itemId:'discountdatesettingsgrid'
	        						}]
	        				};
	        				insertAt = insertAt + 1;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						itemId:'bankChargesContainer',
	        						autoScroll: true,
	        						title: getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'),
	        						items:[{
	        							xtype:'panel',
	        							items:[{
		        							xtype:'bankchargessettingsgrid',
		        							itemId:'bankchargessettingsgrid'
		        						}]
	        						}]
	        				};
	        				/*insertAt = insertAt + 1;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'vouchersettingsformparent',
	        						itemId:'vouchersettingsformItemId',
	        						title: getFeeAndPaymentCommonTranslation('VOUCHER_SETTINGS'),
	        				};*/
	        				insertAt = insertAt + 1;
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						autoScroll: true,
	        						title: getCommonTranslation('PAYMENT_GROUP_SETTINGS'),
	        						items:[{
	        							xtype:'programgroupsettingpanel',
		        						itemId:'programgroupsettingpanelItemId',
	        						}]
	        				};
	        				insertAt = insertAt + 1;
	        				/*panelItem["0"].items[insertAt] = {
	        						xtype:'coursefeedefconfigform',
	        						itemId:'coursefeedefconfigformItemId',
	        						title: getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION'),
	        				};
	        				insertAt = insertAt + 1;
	        				if(creditFeeMappingTab==true) {
	        					panelItem["0"].items[insertAt] = {
	        							xtype:'creditfeemappingform',
	        							itemId:'creditfeemappingformItemId',
	        							title: getFeeAndPaymentCommonTranslation('CREDIT_FEE_MAPPING'),
	        					};
	        					insertAt = insertAt + 1;
	        				}
	        				if(autoSettlementJobConfig==true) {
	        					panelItem["0"].items[insertAt] = {
	        							xtype:'autosettlementjobconfigform',
	        							itemId:'autosettlementjobconfigform',
	        							title: getFeeAndPaymentCommonTranslation('AUTO_SETTLEMENT_JOB_CONFIGURATION'),
	        					};
	        					insertAt = insertAt + 1;
	        				}*/
	        				if(feeSetting==true) {
	        					panelItem["0"].items[insertAt] = {
	        							xtype:'container',
	        							autoScroll: true,
		        						title: getFeeAndPaymentCommonTranslation('FEES_AND_PAYMENT_OTHER_SETTINGS'),
		        						items:[{
		        							xtype:'feesandpaymentothersettings',
		        							itemId:'feesandpaymentothersettings',
		        						}]
	        					};
	        					insertAt = insertAt + 1;
	        				}
	        				panelItem["0"].items[insertAt] = {
	        						xtype:'container',
	        						autoScroll: true,
	        						title: getFeeAndPaymentCommonTranslation('STATEMENT_EMAIL_SETTING'),
	        						items:[{
	        							xtype:'statementemailsettingform',
	        							itemId:'statementemailsettingform',
	        						}]
        					};
        					insertAt = insertAt + 1;
	        				structure.insert(insertPosition,panelItem);
	        			},
	        			disableMoreActionPivileges: function(grid,permissionMap){

	        				var associatedAcadLocationIds = new Array();
	        				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);

	        				var btnConfigureFeeHead = grid.down('#btnConfigureFeeHead');
	        				btnConfigureFeeHead.setVisible(false);

	        				Ext.each(permissionList, function(privilege) {

	        					if (privilege === 'CONFIGURE_FEE_HEAD') {
	        						if(!isNullOrEmpty(btnConfigureFeeHead)){
	        							btnConfigureFeeHead.setVisible(true);
	        						}        		
	        					}
	        				});
	        				

	        			},
	        			getOpenConfigureFeeHeadWindow : function(){
	        				var $this = this;
	        				var contentpanel = this.getProgramgroupsettingpanel().items.items[1];
	        				var paymentgroupconfigfeestructure = Ext.widget('paymentgroupconfigurefeeheadsstructure');
	        				var tabName = getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD');
	        				var tabDetail = contentpanel.items.items;
	        				for(var i in tabDetail){
	        					if(tabDetail[i].title==tabName){
	        						tabDetail[i].close();
	        					}
	        				}
	        				openTab(contentpanel, tabName, paymentgroupconfigfeestructure);
	        				
	        				var programGrpPnl =this.getProgramgroupsettingpanel();
	        				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	        				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
	        				var parentgridRecordId=parentRecPaymentGroupId;
	        				parentRecPaymentGroupName = parentGrid.getSelectionModel().getSelection()[0].data.name;
	        				childRecPaymentTermId = childGrid.getSelectionModel().getSelection()[0].data.id;
	        				childRecPaymentTermName = childGrid.getSelectionModel().getSelection()[0].data.name;
	        				
	        				var grid1=$this.getConfigurefeeheadgrid();
	        				/*this.disableFeeConfigurationSaveResetBtnByPriivilege(grid1,this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
	        		    	   grid1.down('#submitBtn').setVisible(true);
	        		    	   grid1.down('#resetBtn').setVisible(true);
	        		    	   grid1.down('#btnAdd').setVisible(false);
	        				
	        				var editUrl = SERVERURL.PATH_FIND_FEE_HEAD_BY_PAYMENT_GROUP_TERM_ID;
	        				Ext.Ajax.request({
	        					method: "GET",
	        					type: 'rest',
	        					url: editUrl,
	        					params: {
	        						paymentGroupId: parentRecPaymentGroupId,
	        						paymentTermId:childRecPaymentTermId
	        					},
	        					success: function(f, action) {
	        						var data = Ext.JSON.decode(f.responseText);
	        						var grid1=$this.getConfigurefeeheadgrid();
	        						if(data.subHeadArray.length>0){
	        							isUpdateConfigureFeeHead=1;
	        							grid1.getStore().removeAll();
	        							
	        							var ObjModel = [];
	        							var serialNo = 0;
	        							for(i=0;i< data.subHeadArray.length; i++){
	        								serialNo = serialNo+1;
	        								var subHeadData = data.subHeadArray[i];
	        								var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
	        								feeHeadConfGridModel.set("serialNo", subHeadData.serialNo);
	        								feeHeadConfGridModel.set("feeHead", subHeadData.feeHead.id);
	        								feeHeadConfGridModel.set("amountOrWeightage", subHeadData.paymentTermWeightage);

	        								feeHeadConfGridModel.set("id", subHeadData.id);
	        								feeHeadConfGridModel.set("isAddDeleteRow", true);
	        								ObjModel.push(feeHeadConfGridModel);
	        							}
	        							grid1.getStore().loadRawData(ObjModel, true);
	        							setTimeout(function() {
	        								                       grid1.down('#submitBtn').setVisible(true);
		        					    	grid1.down('#resetBtn').setVisible(true);
		        					    	grid1.down('#btnAdd').setVisible(false);    
	        								                            },300);

	        						}else{
	        							grid1.getStore().removeAll();
	        							grid1.down('#submitBtn').setVisible(false);
	        					    	grid1.down('#resetBtn').setVisible(false);
	        					    	grid1.down('#btnAdd').setVisible(true);
	        							isUpdateConfigureFeeHead=0;
	        						}
	        					}
	        				});*/
	        				
	        				
	        			},
	        			onFeeHeadGridAddClick: function(serialNo,grid){
	        		    	 var $this = this;
	        					 var ObjModel = [];
	        					 var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
	        					 feeHeadConfGridModel.set("serialNo", serialNo);
	        					 feeHeadConfGridModel.set("feeHead", '');
	        					 feeHeadConfGridModel.set("amountOrWeightage", '');
	        					 feeHeadConfGridModel.set("isAddDeleteRow", true);
	        					 ObjModel.push(feeHeadConfGridModel);
	        					 grid.getStore().loadRawData(ObjModel, true);
	        					 if(serialNo == 1){
	        						 grid.down('#btnAdd').hide();
	        						 grid.down('#submitBtn').setVisible(true);
	        						 grid.down('#resetBtn').setVisible(true);
	        					 }
	        		     },
	        		     deleteFeeHeadConfigurationDetails: function(grid,record,createexameventdetailsgridStructure,titleMessage,rowIndex){
	        		    	   if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
	        		    		   if (grid.getStore().getRange().length > 0) {
	        		    			   grid.getStore().removeAt(rowIndex);
	        		    			   var models = grid.getStore().getRange();
	        		    			   for (var i = 0; i < models.length; i++) {
	        		    				   models[i].data.serialNo = i + 1;
	        		    			   }
	        		    			   grid.getStore().loadRawData(models, true);
	        		    			   if(models.length == 0){
	        		    				   var grid1 =this.getConfigurefeeheadgrid();
	        		    				   this.disableFeeConfigurationButtonByPriivilege(grid1, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
	        		    				   this.disableFeeConfigurationSaveResetBtnByPriivilege(grid1, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION())
	        		    			
	        		    			   }
	        		    		   }
	        		    	   }
	        		       },
	        		       disableFeeConfigurationButtonByPriivilege: function(grid,permissionsMap){
	        		    	   var confugurationTab = this.getPaymentgroupconfigurefeeheadsstructure();
	        		    	  var addBtn =  grid.down('#btnAdd');
	        		    	  var submitBtn = grid.down('#submitBtn');
	        		    	  var resetBtn = grid.down('#resetBtn');
	        		    	  addBtn.setVisible(false);
	        		    	  //submitBtn.setVisible(false);
	        		    	  //resetBtn.setVisible(false);
	        		    	 
	        		    	  var associatedAcadLocationIds = new Array();
	        		  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	        		  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        		  		Ext.each(permissionList, function(privilege) {
	        		  			if(privilege === "ADD"){
	        		  				if(!isNullOrEmpty(addBtn)){
	        		  					addBtn.setVisible(true);
	        		  					confugurationTab.addPermission =true;
	        		        		}
	        		  			}if(privilege === "DELETE"){
	        		    			confugurationTab.deletePermission =true;
	        		  			}
	        		  		});
	        		       },
	        		       disableFeeConfigurationSaveResetBtnByPriivilege :function(grid,permissionsMap){
	        		    	   var submitBtn = grid.down('#submitBtn')
	        					 var resetBtn=	grid.down('#resetBtn')
	        					 //resetBtn.setVisible(false);
	        					 submitBtn.setVisible(false);
	        					 var associatedAcadLocationIds = new Array();
	        				  		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	        				  		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
	        				  		Ext.each(permissionList, function(privilege) {
	        				  			if(privilege === "SAVE"){
	        				  				if(!isNullOrEmpty(submitBtn)){
	        				  					submitBtn.setVisible(true);
	        				        		}
	        				  			}/*if(privilege === "RESET"){
	        				  				if(!isNullOrEmpty(resetBtn)){
	        				  					resetBtn.setVisible(true);
	        				        		}
	        				  			}*/
	        				  		});
	        		       },
	        		       
	        		       saveFeeHeadConfigurationDetail: function(){
	        		    	   var $this=this;
	        		    	   var structure =this.getPaymentgroupconfigurefeeheadsstructure();
	        		    	   var subHeadGrid = this.getConfigurefeeheadgrid();
	        		    	   var jsonObj ={};
	        		    	   var subHeadArray = [];
	        		    	   var checkDuplicateFeeHeadArray = [];
	        		    	   var flag= true;
	        		    	   var submitUrl = null;
	        		    	   var checkDefinationStatusURL = null
	        		    	   var storeItems = subHeadGrid.getStore().data.items;
	        		    	   var sumOfWeightage=0;  //childRecPaymentTermId
	        		    	   
	        		    	   var programGrpPnl =this.getProgramgroupsettingpanel();
	        		    	   var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
	        		    	   var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
	        		    	   
	        		    	   if(storeItems.length > 0){
	        		    		   	
	        		    		   for(var i=0;i<storeItems.length;i++){
	        		    			   if(storeItems[i].data.serialNo>0 && (!isNullOrEmpty(storeItems[i].data.feeHead) && !isNullOrEmpty(storeItems[i].data.amountOrWeightage))){
		        		    				  isSaveData=true;
		        		    			  }else{
		        		    				  isSaveData=false;
		        		    				  break;
		        		    			  } 
	        		    		   }
	        		    		   
	        		    		   storeItems.forEach(function(obj){
	        		    			   sumOfWeightage=sumOfWeightage+parseInt(obj.data.paymentTermWeightage);
	        		    			   
        		    			   });
	        		    		   
	        		    		   
	        		    		   //if(isSaveData){
	        		    		   if(sumOfWeightage==100){
	        		    			   storeItems.forEach(function(obj){
	        		    				   var obj1 = {};
	        		    				   var feeHeadObj = {};
	        		    				   var costCentreObj = {};
	        		    				   var payableDiscountFeeheadObj = {};
	        		    				   var discountCostCentreObj = {};
	        		    				   if (!Ext.isEmpty(obj.data.feeHead)) {
	        		    					   feeHeadObj = obj.data.feeHead;
	        		    					   obj1.feeHead = feeHeadObj;
	        		    					   checkDuplicateFeeHeadArray.push(obj.data.feeHead);
	        		    				   }
	        		    				   if (!Ext.isEmpty(obj.data.payableDiscountFeehead)) {
	        		    					   payableDiscountFeeheadObj = obj.data.payableDiscountFeehead;
	        		    					   obj1.payableDiscountFeehead = payableDiscountFeeheadObj;
	        		    				   }
	        		    				   if (!Ext.isEmpty(obj.data.discountCostCentre)) {
	        		    					   discountCostCentreObj = obj.data.discountCostCentre;
	        		    					   obj1.discountCostCentre = discountCostCentreObj;
	        		    				   }
	        		    				   if(!Ext.isEmpty(obj.data.costCentre)){
	        		    					  costCentreObj = obj.data.costCentre;
	        		    					  obj1.costCentre=costCentreObj;
	        		    				   }
	        		    				   obj1.paymentTermId = childRecPaymentTermId || null;
	        		    				   obj1.paymentGroupId = parentRecPaymentGroupId || null;
	        		    				   obj1.paymentTermWeightage = !Ext.isEmpty(obj.data.paymentTermWeightage) ? obj.data.paymentTermWeightage : 0;
	        		    				   obj1.id = !Ext.isEmpty(obj.data.id) ? obj.data.id : null;
	        		    				   obj1.discountType = !Ext.isEmpty(obj.data.discountType) ? obj.data.discountType : null;
	        		    				   obj1.remark = !Ext.isEmpty(obj.data.remark) ? obj.data.remark : '';
	        		    				   obj1.whetherPayableDiscount = obj.data.whetherPayableDiscount === true; // ensures boolean
	        		    				   obj1.serialNo = obj.data.serialNo;
	        		    				   obj1.whetherDiscountBillGenerated = obj.data.whetherDiscountBillGenerated=== true;
	        		    				   obj1.whetherBillGenerated = obj.data.whetherBillGenerated=== true;

	        		    				   subHeadArray.push(obj1);
	        		    			   });
	        		    			   var checkDuplicateFeeHeadSet=new Set(checkDuplicateFeeHeadArray);
	        		    			   if(checkDuplicateFeeHeadArray.length != checkDuplicateFeeHeadSet.size){
	        		    				   isNotDuplicate=false;
	        		    			   }else{
	        		    				   isNotDuplicate=true;
	        		    			   }

	        		    			   if(isNotDuplicate){
	        		    				   var objFinal=new Object();
	        		    				   objFinal.subHeadArray=subHeadArray
	        		    				   objFinal.parentRecPaymentGroupId=parentRecPaymentGroupId;
	        		    				   objFinal.parentRecPaymentGroupName=parentRecPaymentGroupName;
	        		    				   objFinal.childRecPaymentTermId=childRecPaymentTermId;
	        		    				   objFinal.childRecPaymentTermName=childRecPaymentTermName;

//	        		    				   jsonObj
	        		    				   Ext.Ajax.request({
	        		    					   type: 'rest',
	        		    					   url: SERVERURL.PATH_SAVE_PAYMENT_TERM_CONFIGURE_FEE_HEAD,
	        		    					   method: 'POST',
	        		    					   jsonData : objFinal,
	        		    					   success: function(res, action) {
//	        		    						   res.responseText=1;
	        		    						   var data = Ext.decode(res.responseText);

	        		    						   var contentpanel = $this.getProgramgroupsettingpanel().items.items[1];
	        		    							   var paymentgroupconfigfeestructure = Ext.widget('paymentgroupconfigurefeeheadsstructure');
	        		    							   var tabName = getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEAD');
	        		    							   var tabDetail = contentpanel.items.items;

	        		    						   if(data==2){
	        		    							   showSuccessMessage(getCommonTranslation('FEE_HEAD_CONFIGURATION'),getCommonTranslation('FEE_HEAD_UPDATED_SUCCESSFULLY'));
	        		    						   }else if(data==3){
	        		    							   showSuccessMessage(getCommonTranslation('FEE_HEAD_CONFIGURATION'),getCommonTranslation('FEE_HEAD_ADDED_SUCCESSFULLY'));
	        		    						   }else if(data==1){
	        		    							   showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('BILL_IS_ALREADY_CREATED'));
	        		    						   }
	        		    						   for(var i in tabDetail){
	        		    							   if(tabDetail[i].title==tabName){
	        		    								   tabDetail[i].close();
	        		    							   }
	        		    						   }

	        		    						   var parentgridRecordId=parentRecPaymentGroupId;
	        		    						   parentRecPaymentGroupName = parentGrid.getSelectionModel().getSelection()[0].data.name;
	        		    						   childRecPaymentTermId = childGrid.getSelectionModel().getSelection()[0].data.id;
	        		    						   childRecPaymentTermName = childGrid.getSelectionModel().getSelection()[0].data.name;

	        		    						   var grid1=$this.getConfigurefeeheadgrid();
	        		    						   grid1.store.getProxy().extraParams = {
	        		    	     					   paymentGroupId: parentRecPaymentGroupId,
	        		    	     					   paymentTermId:childRecPaymentTermId
	        		    	     				   };
	        		    	     				   grid1.store.load();
	        		    						   /*$this.disableFeeConfigurationSaveResetBtnByPriivilege(grid1,$this.getCOURSE_FEE_HEAD_CONFIGURATION_PERMISSION());
	        		    						   grid1.down('#submitBtn').setVisible(true);
	        		    						   grid1.down('#resetBtn').setVisible(true);
	        		    						   grid1.down('#btnAdd').setVisible(false);

	        		    						   var editUrl = SERVERURL.PATH_FIND_FEE_HEAD_BY_PAYMENT_GROUP_TERM_ID;
	        		    						   Ext.Ajax.request({
	        		    							   method: "GET",
	        		    							   type: 'rest',
	        		    							   url: editUrl,
	        		    							   params: {
	        		    								   paymentGroupId: parentRecPaymentGroupId,
	        		    								   paymentTermId:childRecPaymentTermId
	        		    							   },
	        		    							   success: function(f, action) {
	        		    								   var data = Ext.JSON.decode(f.responseText);
	        		    								   var grid1=$this.getConfigurefeeheadgrid();
	        		    								   if(data.subHeadArray.length>0){
	        		    									   isUpdateConfigureFeeHead=1;
	        		    									   grid1.getStore().removeAll();

	        		    									   var ObjModel = [];
	        		    									   var serialNo = 0;
	        		    									   for(i=0;i< data.subHeadArray.length; i++){
	        		    										   serialNo = serialNo+1;
	        		    										   var subHeadData = data.subHeadArray[i];
	        		    										   var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
	        		    										   feeHeadConfGridModel.set("serialNo", subHeadData.serialNo);
	        		    										   feeHeadConfGridModel.set("feeHead", subHeadData.feeHead.id);
	        		    										   feeHeadConfGridModel.set("amountOrWeightage", subHeadData.paymentTermWeightage);

	        		    										   feeHeadConfGridModel.set("id", subHeadData.id);
	        		    										   feeHeadConfGridModel.set("isAddDeleteRow", true);
	        		    										   ObjModel.push(feeHeadConfGridModel);
	        		    									   }
	        		    									   grid1.getStore().loadRawData(ObjModel, true);
	        		    									   setTimeout(function() {
	        		    										                          grid1.down('#submitBtn').setVisible(true);
	        		    										   grid1.down('#resetBtn').setVisible(true);
	        		    										   grid1.down('#btnAdd').setVisible(false);    
	        		    										                               },300);

	        		    								   }else{
	        		    									   grid1.getStore().removeAll();
	        		    									   grid1.down('#submitBtn').setVisible(false);
	        		    									   grid1.down('#resetBtn').setVisible(false);
	        		    									   grid1.down('#btnAdd').setVisible(true);
	        		    									   isUpdateConfigureFeeHead=0;
	        		    								   }
	        		    							   }
	        		    						   });*/
	        		    						   ////////////////////////////
	        		    						   childGrid.getStore().reload();

	        		    					   }
	        		    				   });
	        		    			   }else{
	        		    				   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FEE_HEAD_NAME_MUST_BE_UNIQUE'));
	        		    			   }  
	        		    		   }else{
	        		    				   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('THE_SUM_OF_WEIGHTAGE_FOR_FEE_HEADS_SHOULD_BE_100'));
	        		    			   }
	        		    		   /*}else{
	        		    			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_MANDATORY_DETAILS'));
	        		    		   }*/
	        		    	   }
	        		       },
	        		       showFeeHeadOnPopUpWindow: function(){
	        	 				var configureFeeHeadViewWindow = this.getConfigurefeeheadviewwindow();
	        	 				if (!configureFeeHeadViewWindow) {
	        	 					configureFeeHeadViewWindow = Ext.widget('configurefeeheadviewwindow',{
	        	 						itemId:'configurefeeheadviewwindowItemId'
	        	 					});
	        	 				}
	        	 				configureFeeHeadViewWindow.show();
	        	 				var grid = this.getPaymenttermconfigurefeeheadwindowgrid();
	        	 				grid.down('#btnExportToPDF').setVisible(false);
	        	 				grid.down('#btnExportToExcel').setVisible(false);
	        	 				
	        	 				var programGrpPnl =this.getProgramgroupsettingpanel();
		        				var parentGrid = programGrpPnl.down('#paymentGroupMasterParentGrid');
		        				var childGrid = programGrpPnl.down('#paymentGroupChildGrid');
		        				var parentgridRecordId=parentRecPaymentGroupId;
		        				parentRecPaymentGroupName = parentGrid.getSelectionModel().getSelection()[0].data.name;
		        				childRecPaymentTermId = childGrid.getSelectionModel().getSelection()[0].data.id;
		        				childRecPaymentTermName = childGrid.getSelectionModel().getSelection()[0].data.name;
		        				
		        				
		        				var editUrl = SERVERURL.PATH_FIND_FEE_HEAD_BY_PAYMENT_GROUP_TERM_ID;
		        				Ext.Ajax.request({
		        					method: "GET",
		        					type: 'rest',
		        					url: editUrl,
		        					params: {
		        						paymentGroupId: parentRecPaymentGroupId,
		        						paymentTermId:childRecPaymentTermId
		        					},
		        					success: function(f, action) {
		        						var data = Ext.JSON.decode(f.responseText);
		        						grid.getStore().removeAll();
		        						if(data.subHeadArray.length>0){
		        							var ObjModel = [];
		        							for(i=0;i< data.subHeadArray.length; i++){
		        								var subHeadData = data.subHeadArray[i];
		        								var feeHeadConfGridModel = new Academia.model.feeandpayment.coursefeedefinition.FeeHeadConfigurationGridModel();
		        								feeHeadConfGridModel.set("serialNo", subHeadData.serialNo);
		        								feeHeadConfGridModel.set("feeHeadName", subHeadData.feeHeadName);
		        								feeHeadConfGridModel.set("weightage", subHeadData.paymentTermWeightage);
		        								ObjModel.push(feeHeadConfGridModel);
		        							}
		        							grid.getStore().loadRawData(ObjModel, true);

		        						}
		        					}
		        				});
	        	 				
	        	 			},
	        	 			disableBillGenerationchk: function(){
		        				var associatedAcadLocationIds = new Array();
		        				var form=this.getBillsettingswin().down("#billSettingsFormItemId");
		        				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getBILL_GENERATION_ON_SUBMIT_APPLICATION_PERMISSION());
                                var chkBillGenerationOnSubmitApplication = form.down('#billGenerationOnSubmitApplication');
                                if(!isNullOrEmpty(chkBillGenerationOnSubmitApplication)){
		        				chkBillGenerationOnSubmitApplication.setVisible(false);
                                }
		        				Ext.each(permissionList, function(privilege) {
		        					if(privilege === 'BILL_GENERATION_ON_SUBMIT_APPLICATION'){
		        						if(!isNullOrEmpty(chkBillGenerationOnSubmitApplication)){
		        							chkBillGenerationOnSubmitApplication.setVisible(true);
		        						}
		        					}

		        				});
		        				

		        			},
		        			addMoreRowsForStatementEmailSetting:function(){
		        				   var $this =this;
		        				   var form = this.getStatementemailsettingform();
		        				   var langTemplateMappingContainerId = form.down('#langTemplateMappingContainerId');
		        				   var newItemsArray = new Array();
		        				   var insertPosition=langTemplateMappingContainerId.items.items.length+1;
		        				   newItemsArray.push({
		        					        xtype: 'fieldcontainer',
		        					        plugins : "formlabelrequired",
		        					        itemId:Math.random(),
		        					        scope: $this,
		        					        layout: {
		        					            type: 'hbox'
		        					        },
		        					        defaults: {
		        					            labelAlign: 'top',
		        					            allowBlank:false,
		        					        },
		        					        items: [{
		        			    				xtype: 'customcombobox',
		        			    				width: 256,
		        			    				name:'language',
		        			    				itemId:'languageItemId',
		        			    				store:'common.MultiLanguageCorrespondenceLangStore',
		        			    				editable: false,
		        			    				valueField: 'id',
		        			    	        	displayField: 'value', 
		        			    				fieldLabel: getFeeAndPaymentCommonTranslation('LANGUAGE')
		        			    			},{
		        			    				xtype: 'customcombobox',
		        			    				width: 256,
		        			    				name:'templateMapping',
		        			    				itemId:'templateMappingItemId',
		        			    				editable: false,
		        			    				valueField: 'id',
		        			    	        	displayField: 'value', 
		        			    	        	store:'receipt.receiptsettings.StatementEmailTemplateMappingStore',
		        			    				fieldLabel: getFeeAndPaymentCommonTranslation('TEMPLATE_MAPPING'),
		        			    				listConfig: {
		        			    	        		loadingText: getCommonTranslation('SEARCHING'),
		        			    	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        			    	        		listeners: {
		        			    	        			beforeshow: function(picker) {
		        			    	        				picker.width = picker.up('combobox').getSize().width;
		        			    	        			}
		        			    	        		},
		        			    	        	}
		        			    			},{
		        			    				xtype: 'customcombobox',
		        			    				width: 256,
		        			    				name:'eventMapping',
		        			    				itemId:'eventMappingItemId',
		        			    				editable: false,
		        			    				valueField: 'id',
		        			    	        	displayField: 'code', 
		        			    	        	store:'receipt.receiptsettings.StatementEmailEventMappingStore',
		        			    				fieldLabel: getFeeAndPaymentCommonTranslation('EVENT_MAPPING'),
		        			    				listConfig: {
		        			    	        		loadingText: getCommonTranslation('SEARCHING'),
		        			    	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        			    	        		listeners: {
		        			    	        			beforeshow: function(picker) {
		        			    	        				picker.width = picker.up('combobox').getSize().width;
		        			    	        			}
		        			    	        		}
		        			    	        	}
		        			    			},{
		        			    				xtype: 'checkboxfield',
		        			    				labelAlign: 'right',
		        			    				name:'markAsDefault',
		        			    				cls:'emailSettingFormCls',
		        			    				itemId:'markAsDefaultItemId',
		        			    				style:{margin:'24px'},
		        			    				boxLabel: getFeeAndPaymentCommonTranslation('MARK_AS_DEFAULT'),
		        			    				inputValue : true
		        			    			},{
		        			    				xtype: 'button',
		        			    				glyph: ICONGLYPH.DELETEGLYPH,
		        			    				cls: 'CustomBodyBtnReject',
		        			    				tooltip: getCommonTranslation('DELETETOOLTIP'),
		        			    				width:40,
		        			    				itemId:'deleteRowsBtnId',
		        			    				style:{
		        			    					marginTop:'26px !important',
		        			    				},
		        			    				listeners:{
		        			    					click:function(obj){
		        			    						var langTemplateMappingContainerId = form.down('#langTemplateMappingContainerId');
		        			    						
		        			    						var container = obj.up('fieldcontainer');
		        			    						if (container != null && langTemplateMappingContainerId != null) {
		        			    							if (langTemplateMappingContainerId.items.length > 1) {
		        			    								langTemplateMappingContainerId.remove(container);
		        			    								$this.hideShowAddDeleteBtns(langTemplateMappingContainerId);
		        			    							}
		        			    						}
		        			    						form.down('form').getForm().checkValidity();
		        			    					}
		        			    				}
		        			    			},{
		        			    				xtype: 'button',
		        			    				itemId: 'addMoreRowsBtnId',
		        			    				cls: 'CustomBodyBtnSettings',
		        			    				style:{marginTop:'28px'},
		        			    				text: getCommonTranslation('ADDBUTTONTEXT'),
		        			    				tooltip: getCommonTranslation('ADD'),
		        			    			}]
		        					   });
		        				   langTemplateMappingContainerId.insert(insertPosition,newItemsArray);
		        				   this.hideShowAddDeleteBtns(langTemplateMappingContainerId);
		        				   langTemplateMappingContainerId.doLayout();
		        			},
		        			saveStatementEmailSetting:function(){
		        				var $this =this;
		        				var form = this.getStatementemailsettingform();
		        				var markAsDefault=false;
		        				var markAsDefaultCheckBoxes = Ext.ComponentQuery.query('#markAsDefaultItemId')
		               			var correspondenceLang = form.down('#correspondenceLang').getValue();
		        				for(var j=0; j<markAsDefaultCheckBoxes.length; j++){
                                       if(markAsDefaultCheckBoxes[j].getValue()){
                                    	   markAsDefault=true;
                                       }
		        				}
		        				if(markAsDefault){
		        					var json = this.createJsonForStatementEmailSetting(form);
		        					var formData = Ext.encode(json);
		        					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		        					Ext.Ajax.request({
		        						type : 'rest',
		        						url : SERVERURL.PATH_SAVE_STATEMENT_EMAIL_SETTING,
		        						jsonData : formData,
		        						method : 'POST',
		        						success : function(frm, action) {
		        							Ext.getBody().unmask(); 
		        							showSuccessMessage(getCommonTranslation('SUCCESS'), getFeeAndPaymentCommonTranslation('STATEMENT_EMAIL_SETTING_UPDATED_SUCCESSFULLY'));
		        						}
		        					});
		        				}else{
		        					showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_AT_LEAST_ONE_OPTION'));
		        				}
		        			},
		        			createJsonForStatementEmailSetting:function(form){
		        				var statementFor = form.down('#statementFor').getValue();
		        				var isCorrespondenceLang = form.down('#correspondenceLang').getValue();
		        				var langTemplateMappingContainerId = form.down('#langTemplateMappingContainerId');
		        				var emailStateDataArray=new Array();
		        				var fieldContainer = langTemplateMappingContainerId.items.items;
		        				
		        				for(var j=0; j<fieldContainer.length; j++){
		        					var lang={
		        							"id":fieldContainer[j].items.items[0].getValue()
		        					}
		        					var templateMapping={
		        							"id":fieldContainer[j].items.items[1].getValue()
		        					}
		        					emailStateDataArray.push({
		        						"statementFor":statementFor,
		        						"language":lang,
		        						"reportTemplate":templateMapping,
		        						"messageTemplate":fieldContainer[j].items.items[2].getValue(),
		        						"isDefault":fieldContainer[j].items.items[3].getValue(),
		        						"isCorrespondenceLang":isCorrespondenceLang
		        					});
		        				}
		        				return emailStateDataArray;
		        			},
		        			isDuplicateValueSelected:function(fields){
		        				var valuesSoFar = [];
		        				for (var i = 0; i < fields.length; ++i) {
		        					var value = fields[i].getValue();
		        					if (value!=null && valuesSoFar.indexOf(value) !== -1) {
		            					showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('DUPLICATE_RECORD_CONDITION'));
		            					return true;
		        					}
		        					valuesSoFar.push(value);
		        				}
		        			},
		        			hideShowAddDeleteBtns: function(langTemplateMappingContainerId){
		        				var form = this.getStatementemailsettingform();
		        				var cnt = langTemplateMappingContainerId.items.length;
		        				langTemplateMappingContainerId.items.each(function(item, index, items) {
		        					var addButton = item.getComponent(item.items.length - 1);
		        					if (index == (items - 1)) {
		        						if (addButton != null) {
		        							addButton.show();
		        							if(cnt == 4){
		        								addButton.hide();
		        							}
		        						}
		        					} else {
		        						if (addButton != null) {
		        							addButton.hide();
		        						}
		        					}
		        				});
		        				if(cnt === 1){
		        					form.down('#markAsDefaultItemId').setValue(true);
		        				}
		        			},
		        			savePaymentTermSetting:function(submitUrl,formData,isUpdate,childFormWin,childGrid){
		        				var $this = this;
		        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			    				Ext.Ajax.request({
			    					type: 'rest',
			    					url: submitUrl,
			    					jsonData: formData,
			    					method: 'POST',
			    					success: function(response, form) {
			    						Ext.getBody().unmask();
			    						if (isUpdate) {
			    							showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
			    						} else {
			    							showSuccessMessage(getCommonTranslation('PAYMENT_GROUP_SETTINGS'), getCommonTranslation('SUCCESS'));
			    						}
			    						childFormWin.close();
			    						childGrid.getSelectionModel().deselectAll();
			    						childGrid.getStore().load();
			    						$this.resetPageSetting(childGrid.getStore());
			    					}
			    				});
		        			},
		        			setDataOnStateEmailSettingForm:function(data){
		        				var $this =this;
		        				var form = this.getStatementemailsettingform();
		        				var mainContainer = form.down('#langTemplateMappingContainerId');
		        				if(data.length>0){
		        					form.down('#statementFor').setValue(data[0].statementFor);
			        				if(data[0].isCorrespondenceLang){
			        				  form.down('#correspondenceLang').setValue(data[0].isCorrespondenceLang);
			        				}
			        				mainContainer.removeAll();
		        				}
		        				Ext.Array.each(data,function(value,index){
		        					var newItemsArray = new Array();
		        					newItemsArray.push({
		        						xtype: 'fieldcontainer',
		        						plugins : "formlabelrequired",
		        						itemId:Math.random(),
		        						scope: $this,
		        						layout: {
		        							type: 'hbox'
		        						},
		        						defaults: {
		        							labelAlign: 'top',
		        							allowBlank:false,
		        						},
		        						items: [{
		        							xtype: 'customcombobox',
		        							width: 256,
		        							name:'language',
		        							itemId:'languageItemId',
		        							store:'common.MultiLanguageCorrespondenceLangStore',
		        							editable: false,
		        							valueField: 'id',
		        							displayField: 'value', 
		        							fieldLabel: getFeeAndPaymentCommonTranslation('LANGUAGE'),
		        							listeners: {
		    									render: function(combo) {
		    										var store= combo.getStore();
		    										store.load({
		    											callback:function(record, operation, success){
		    												for(var i in record){
			    												if(record[i].data.id==value.language.id){
			    													combo.setValue(value.language.id);
			    												}
			    											}
		    											}
		    										});
		    									}
		    								}
		        						},{
		        							xtype: 'customcombobox',
		        							width: 256,
		        							name:'templateMapping',
		        							itemId:'templateMappingItemId',
		        							editable: false,
		        							valueField: 'id',
		        							displayField: 'value', 
		        							store:'receipt.receiptsettings.StatementEmailTemplateMappingStore',
		        							fieldLabel: getFeeAndPaymentCommonTranslation('TEMPLATE_MAPPING'),
		        							listConfig: {
	        			    	        		loadingText: getCommonTranslation('SEARCHING'),
	        			    	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			    	        		listeners: {
	        			    	        			beforeshow: function(picker) {
	        			    	        				picker.width = picker.up('combobox').getSize().width;
	        			    	        			}
	        			    	        		}
	        			    	        	},
	        			    	        	listeners: {
        			    	        			render: function(combo) {
		    										var store= combo.getStore();
		    										store.getProxy().extraParams = {
		    											reportTypeName : 'Student Statement of Account'
		    										};
		    										store.load({
		    											callback:function(record, operation, success){
		    												combo.setValue(value.reportTemplate.id);
		    											}
		    										});
		    									}
        			    	        		}
		        						},{
		        							xtype: 'customcombobox',
		        							width: 256,
		        							name:'eventMapping',
		        							itemId:'eventMappingItemId',
		        							editable: false,
		        							valueField: 'id',
		        							displayField: 'code', 
		        							store:'receipt.receiptsettings.StatementEmailEventMappingStore',
		        							fieldLabel: getFeeAndPaymentCommonTranslation('EVENT_MAPPING'),
		        							listeners: {
		        								beforeshow: function(picker) {
        			    	        				picker.width = picker.up('combobox').getSize().width;
        			    	        			}
		    								},
		    								listeners: {
		    									render: function(combo) {
		    										var store= combo.getStore();
		    										store.getProxy().extraParams = {
		    											msgRecipientCode : 'STUDENT_ACCOUNT_STATEMENT'
		    										};
		    										store.load({
		    											callback:function(record, operation, success){
		    												combo.setValue(value.messageTemplate);
		    												if(value.isDefault){
		    												  combo.up().down('#markAsDefaultItemId').setValue(value.isDefault);
		    												}
		    											}
		    										});
		    									}
		    								}
		        						},{
		        							xtype: 'checkboxfield',
		        							labelAlign: 'right',
		        							cls:'emailSettingFormCls',
		        							name:'markAsDefault',
		        							itemId:'markAsDefaultItemId',
		        							style:{margin:'24px'},
		        							boxLabel: getFeeAndPaymentCommonTranslation('MARK_AS_DEFAULT'),
		        							inputValue : true
		        						},{
		        							xtype: 'button',
		        							glyph: ICONGLYPH.DELETEGLYPH,
		        							cls: 'CustomBodyBtnReject',
		        							hidden:index>0?false:true,
		        							tooltip: getCommonTranslation('DELETETOOLTIP'),
		        							width:40,
		        							itemId:'deleteRowsBtnId',
		        							style:{
		        								marginTop:'26px !important',
		        							},
		        							listeners:{
		        								click:function(obj){
		        									var langTemplateMappingContainerId = form.down('#langTemplateMappingContainerId');
		        										var container = obj.up('fieldcontainer');
		        									if (container != null && langTemplateMappingContainerId != null) {
		        										if (langTemplateMappingContainerId.items.length > 1) {
		        											langTemplateMappingContainerId.remove(container);
		        											$this.hideShowAddDeleteBtns(langTemplateMappingContainerId);
		        										}
		        									}
		        									form.down('form').getForm().checkValidity();
		        								}
		        							}
		        						},{
		        							xtype: 'button',
		        							itemId: 'addMoreRowsBtnId',
		        							cls: 'CustomBodyBtnSettings',
		        							style:{marginTop:'28px'},
		        							text: getCommonTranslation('ADDBUTTONTEXT'),
		        							tooltip: getCommonTranslation('ADD'),
		        						}]
		        					});
		        					mainContainer.insert(index,newItemsArray);
		        					$this.hideShowAddDeleteBtns(mainContainer);
		        					mainContainer.doLayout();
		        				});
		        			},
		        			openConfigFeeHeadWindow:function(formType){
		        				var formWindow = this.getPaymenttermconfigurefeeheadwin();
		        		        if (!formWindow) {
		        		            Ext.widget('paymenttermconfigurefeeheadwin',{
		        		            	formType: formType,
		        		            });
		        		            formWindow = this.getPaymenttermconfigurefeeheadwin();
		        		        }
		        		        formWindow.show();
		        			},
		        			setFeeHeadConfigData:function(btn,mode){
		        				var grid = btn.up('grid'),
		        				record = grid.getSelectionModel().getSelection()[0],	
		        				store = grid.getStore(),
		        				total = 0;
		        				if (grid.getSelectionModel().getCount() > 0) {
		        					this.openConfigFeeHeadWindow(mode);
		        					var win = this.getPaymenttermconfigurefeeheadwin(),
		        					form = win.down('form').getForm(),
		        					feeHead = win.down('#feeHeadId'),
		        					costCenter = win.down('#costCenterId'),
		        					discountFeehead = win.down('#discountFeeheadId');
		        					discountApplicability = win.down('#discountApplicabilityId');
		        					discountCostCentre = win.down('#discountCostCentreId');
		        					
		        					if(record && record.data){
		        						var feeHeadStore = feeHead.getStore();
		        						feeHeadStore.load({
		        							callback: function(rec, operation, success) {
		        								if (success) {
		        									if(!isNullOrEmpty(record.data.feeHead)){
		        										feeHead.setValue(record.data.feeHead.id);
		        									}
		        									if(record.data.whetherBillGenerated){
                                                       feeHead.setReadOnly(true);
                                                    }
		        								}
		        							}
		        						});

		        						var costCenterStore = costCenter.getStore();
		        						costCenterStore.load({
		        							callback: function(rec, operation, success) {
		        								if (success) {
		        									if(!isNullOrEmpty(record.data.costCentre)){
		        										costCenter.setValue(record.data.costCentre.id);
		        									}
		        									if(record.data.whetherBillGenerated){
                                                      costCenter.setReadOnly(true);
                                                    }
		        								}
		        							}
		        						});

		        						var discountFeeheadStore = discountFeehead.getStore();
		        						discountFeeheadStore.load({
		        							callback: function(rec, operation, success) {
		        								if (success) {
		        									if(!isNullOrEmpty(record.data.payableDiscountFeehead)){
		        										discountFeehead.setValue(record.data.payableDiscountFeehead.id);
		        									}
		        									if(record.data.whetherDiscountBillGenerated){
                                                    		discountFeehead.setReadOnly(true);
                                                    }
		        								}
		        							}
		        						});

		        						var discountApplicabilityStore = discountApplicability.getStore();
		        						discountApplicabilityStore.load({
		        							callback: function(rec, operation, success) {
		        								if (success) {
		        									if(!isNullOrEmpty(record.data.discountType)){
		        										discountApplicability.setValue(record.data.discountType);

		        									}
		        									if(record.data.whetherDiscountBillGenerated){
                                                       discountApplicability.setReadOnly(true);
                                                     }
		        								}
		        							}
		        						});

		        						var discountCostCentreStore = discountCostCentre.getStore();
		        						discountCostCentreStore.load({
		        							callback: function(rec, operation, success) {
		        								if (success) {
		        									if(!isNullOrEmpty(record.data.discountCostCentre)){
		        										discountCostCentre.setValue(record.data.discountCostCentre.id);
		        										}
		        										if(record.data.whetherDiscountBillGenerated){
		        											discountCostCentre.setReadOnly(true);
		        										}

		        								}
		        							}
		        						});

		        						win.down('#id').setValue(record.data.id);
		        						win.down('#tempId').setValue(record.data.tempId);
		        						win.down('#discountId').setValue(record.data.whetherPayableDiscount);
		        						win.down('#weightageId').setValue(record.data.paymentTermWeightage);
		        						win.down('#remarkId').setValue(record.data.remark);
		        						if(record.data.whetherBillGenerated){
		        							win.down('#weightageId').setReadOnly(true);
		        							win.down('#remarkId').setReadOnly(true);
		        						}
		        						if(record.data.whetherDiscountBillGenerated){
		        							win.down('#discountId').setReadOnly(true);
										}
		        						if(store && win.down('#weightageId')){
		        							store.each(function (rec) {
		        								total += parseInt(rec.get('paymentTermWeightage'));
		        							});
		        							win.down('#weightageId').setMaxValue(100-total+record.get('paymentTermWeightage'));
		        						}
		        						if(win.formType=='View'){
		        							this.toggleReadOnlyFormItems(form, true);
		        							win.down('#btnSaveItemId').setVisible(false);
		        						}
		        					}
		        				}else{
		        					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
		        				}
		        			},
		        			updateSerialNumbers:function(store) {
		        			    store.each(function(record, index) {
		        			        record.set('serialNo', index + 1);
		        			    });
		        			},
		        			disableBillGenerationchkedit: function(){
		        				var associatedAcadLocationIds = new Array();
		        				var form=this.getEditbillsettingswin();
		        				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		        				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getBILL_GENERATION_ON_SUBMIT_APPLICATION_PERMISSION());
                                var chkBillGenerationOnSubmitApplication = form.down('#billGenerationOnSubmitApplication');
                                if(!isNullOrEmpty(chkBillGenerationOnSubmitApplication)){
		        				chkBillGenerationOnSubmitApplication.setVisible(false);
                                }
		        				Ext.each(permissionList, function(privilege) {
		        					if(privilege === 'BILL_GENERATION_ON_SUBMIT_APPLICATION'){
		        						if(!isNullOrEmpty(chkBillGenerationOnSubmitApplication)){
		        							chkBillGenerationOnSubmitApplication.setVisible(true);
		        						}
		        					}

		        				});
		        				

		        			},
   
});