/**
 * This controller is used for admission dashboard controller
 * 
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.reports.admission.AdmissionDashboardController', {
    extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: ['common.AcademyStore', 'common.AcademyStore', 'common.ProgramsByAcademyIdLocationId', 'common.BatchesByProgramId', 'common.SeatTypesByBatchId', 
             'admission.selectionProcess.QuotaTypes', 'admission.quotas.QuotaLists',  'reports.admission.AdmissionStatisticReportStore',
            'reports.admission.AdmissionStatisticsByAcademies','reports.admission.ApplicationStatisticsByAcademies', 'reports.admission.AdmissionStatisticsByLocations', 'reports.admission.AdmissionStatisticsByProgram',
             'reports.admission.AdmissionRejectionAnalysisStore', 'common.CountryStore', 'common.AcademicTermStore', 'common.IntakeYearStore','common.IntakeYearByBatchStore',
             'common.ReligionStore','reports.admission.SelectionProcessOverviewStore','admission.reports.AdmissionReportTreeStore',
             'program.ProgramCategoryStore','program.ProgramGroupStore','reports.admission.AdmissionSummaryStore','reports.admission.ApplicationSummaryStore','program.ProgramCategoryByProgramGroupStore',
             'reports.admission.ApplicationCommentsGridStore','reports.admission.ApplicationByMultipleAcademyStore','reports.admission.ApplicationStatisticReportStore','admission.applications.history.ExaminationName',
             'reports.admission.AdmissionSummaryApprovedStore','enquiry.ProgramBatchSeatTypeStore','enquiry.SeatTypeStore','admission.reports.AdmissionDTEFDashboardTreeStore','reports.admission.AdmissionDtefDashboardGridStore','common.ApplicationStatusStore','reports.admission.CourseEnrollmentDtefDashboardGridStore',
             'coursetransaction.studentenrollment.studentenrollmentdetail.DTEFCourseEnrollmentStudentNameStudentIdBySmartSearch', 'course.coursegroup.DTEFCourseDetailsStore',
             'reports.admission.dtefModuleResults.ModuleResultsProgramStore',
             'reports.admission.dtefModuleResults.ModuleResultsBatchStore',
             'reports.admission.dtefModuleResults.ModuleResultsPeriodStore','reports.admission.InvoicesDtefDashboardGridStore',
             'common.BatchIntakeYearStore','coursetransaction.studentenrollment.studentenrollmentdetail.DTEFCourseEnrollmentStudentNameStudentIdBySmartSearch', 'course.coursegroup.DTEFCourseDetailsStore',
             'common.DTEFInvoicesAdmissionIdStudentIdStore','common.DTEFInvoicesNationalIdStore',
             'reports.admission.dtefModuleResults.StudentNameStore',
             'reports.admission.dtefModuleResults.NationalIdStore',
             'reports.admission.dtefModuleResults.PeriodResultStore',
             'reports.admission.dtefModuleResults.ResponseStore',
             'reports.admission.dtefModuleResults.DtefModuleResultsGridStore'
	],

    views: ['reports.common.ColumnChartApplicationStatisticsReport', 'reports.common.BarChartReport', 'reports.common.GroupedBarChart', 'reports.common.PieChartReport', 'reports.admission.dashboard.AdmissionDashboardView', 
            'reports.admission.dashboard.AdmissionStatisticsView','reports.admission.dashboard.ApplicationStatisticsView', 'reports.admission.dashboard.AdmissionRejectionAnalysisView', 'Academia.view.reports.admission.dashboard.AdmissionRejectionAnalysisSearchForm', 
            'reports.admission.dashboard.SelectionProcessOverviewSearchForm', 'reports.admission.dashboard.SelectionProcessOverviewView', 'reports.common.StackedBarChartReport',
            'admission.reports.AdmissionReportTabPanel','reports.admission.dashboard.ApplicationSummaryStructure','reports.admission.dashboard.ApplicationSummaryFilter',
            'reports.admission.dashboard.ApplicationSummaryGrid','reports.admission.dashboard.AdmissionSummaryStructure','reports.admission.dashboard.AdmissionSummaryFilter',
            'reports.admission.dashboard.AdmissionSummaryGrid','reports.admission.dashboard.ApplicationCommentsStructure','reports.admission.dashboard.ApplicationCommentsFilter',
            'reports.admission.dashboard.ApplicationCommentsGrid','reports.admission.dashboard.applicationStaticsGrid','reports.admission.dashboard.AdmissionSummaryApprovedStructure','reports.admission.dashboard.AdmissionSummaryApprovedFilter',
            'reports.admission.dashboard.AdmissionSummaryApprovedGrid','reports.admission.dashboard.DtefDashboardView','admission.reports.AdmissionDtefReportTabPanel','reports.admission.dashboard.DtefAdmissionView','reports.admission.dashboard.DtefAdmissionFilter','reports.admission.dashboard.DtefAdmissionGrid',
            'reports.admission.dashboard.DtefCourseEnrollmentView','reports.admission.dashboard.DtefCourseEnrollmentFilter','reports.admission.dashboard.DtefCourseEnrollmentGrid','course.coursegroup.NoOfDTEFAssociatedCourse','course.coursegroup.DTEFCourseDetails',
            'reports.admission.dashboard.dtefModuleResults.DtefModuleResultsView',
            'reports.admission.dashboard.dtefModuleResults.DtefModuleResultsFilter',
            'reports.admission.dashboard.dtefModuleResults.DtefModuleResultsGrid',
            'reports.admission.dashboard.dtefInvoices.DtefInvoicesStructure',
            'reports.admission.dashboard.dtefInvoices.DtefInvoicesFilter',
            'reports.admission.dashboard.dtefInvoices.DtefInvoicesGrid'
    ],
config:{
	ADMISSIONDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSIONDASHBOARD_PRIVILEGES'),
	APPLICATION_SUMMARY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_SUMMARY_REPORT_PRIVILEGES'),
	ADDMISSION_SUMMARY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADDMISSION_SUMMARY_REPORT_PRIVILEGES'),
	
	ADMISSION_STATISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_STATISTICS_REPORT_TREELINKS_PRIVILEGES'),
	APPLICATION_STATISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_STATISTICS_REPORT_TREELINKS_PRIVILEGES'),
	ADMISSION_REJECTION_ANALYSIS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_REJECTION_ANALYSIS_REPORT_TREELINKS_PRIVILEGES'),
	SELECTION_PROCESS_OVERVIEW_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SELECTION_PROCESS_OVERVIEW_REPORT_TREELINKS_PRIVILEGES'),
	APPLICATION_SUMMARY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_SUMMARY_REPORT_TREELINKS_PRIVILEGES'),
	ADMISSION_SUMMARY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SUMMARY_REPORT_TREELINKS_PRIVILEGES'),
	APPLICATION_COMMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_COMMENTS_REPORT_TREELINKS_PRIVILEGES'),
	ADMISSION_SUMMARY_BYAPPROVEDATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SUMMARY_BYAPPROVEDATE_REPORT_TREELINKS_PRIVILEGES'),
	DTEF_DASHBOARD_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DTEF_DASHBOARD_PRIVILEGES'),
	DTEF_COURSE_ENROLLMENT_PRIVILEGES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DTEF_COURSE_ENROLLMENT_PRIVILEGES'),
	DTEF_MODULE_RESULTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DTEF_MODULE_RESULTS_PRIVILEGES'),
	DTEF_INVOICES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DTEF_INVOICES_PRIVILEGES')
},
    refs: [{
		ref:'AdmissionSummaryStructure',
		selector:'admissionsummarystructure'
	},{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'organizationunit',
        selector: 'organizationunit'
    }, {
        ref: 'admissionStatisticsSearchForm',
        selector: 'form[itemId=admissionStatisticsSearchForm]'
    }, {
        ref: 'applicationStatisticsSearchForm',
        selector: 'form[itemId=applicationStatisticsSearchForm]'
    }, {
        ref: 'admissionStatisticsByAcademiesPieChart',
        selector: 'piechartreport[itemId=admissionStatisticsByAcademiesPieChart]'
    },{
        ref: 'applicationShowStatisticsForPieChart',
        selector: 'columnchartapplicationstatisticsreport[itemId=applicationShowStatisticsForPieChart]'
    },{
        ref: 'applicationShowStatisticsForBarchartreport',
        selector: 'barchartreport[itemId=applicationShowStatisticsForBarchartreport]'
    }, {
        ref: 'admissionStatisticsByLocationsPieChart',
        selector: 'piechartreport[itemId=admissionStatisticsByLocationsPieChart]'
    }, {
        ref: 'admissionStatisticsByProgramBarChart',
        selector: 'barchartreport[itemId=admissionStatisticsByProgramBarChart]'
    }, {
        ref: 'admissionRejectionAnalysisSearchForm',
        selector: 'form[itemId=admissionRejectionAnalysisSearchForm]'
    }, {
        ref: 'admissionRejectionAnalysisBarChart',
        selector: 'barchartreport[itemId=admissionRejectionAnalysisBarChart]'
    }, {
        ref: 'admissionRejectionAnalysisSearchForm',
        selector: 'admissionrejectionanalysissearchform[itemId=admissionRejectionAnalysisSearchForm]'
    }, {
        ref: 'selectionProcessOverviewColumnChart',
        selector: 'stackedbarchartreport[itemId=selectionProcessOverviewColumnChart]'
    }, {
        ref: 'selectionProcessOverviewSearchForm',
        selector: 'selectionprocessoverviewsearchform[itemId=selectionProcessOverviewSearchForm]'
    }, {
        ref: 'selectionProcessForm',
        selector: 'form[itemId=selectionProcessForm]'
    }, {
        ref: 'admissionDashboardOrganizationUnit',
        selector: 'organizationunit[itemId=admissionDashboardOrganizationUnit]'
    },{
    	ref : 'admissionDashboardView',
    	selector: 'admissiondashboardview'
    },{
    	ref : 'dtefdashboardview',
    	selector: 'dtefdashboardview'
    },{
    	ref : 'dtefadmissionview',
    	selector: 'dtefadmissionview'
    },{
    	ref : 'dtefcourseenrollmentview',
    	selector: 'dtefcourseenrollmentview'
    },{
    	ref : 'admissionStatisticsView',
    	selector: 'admissionstatisticsview'
    },{
    	ref : 'applicationstatisticsview',
    	selector: 'applicationstatisticsview'
    },{
    	ref : 'admissionRejectionAnalysisView',
    	selector : 'admissionrejectionanalysisview'
    },{
    	ref : 'selectionProcessoverviewView',
    	selector : 'selectionprocessoverviewview'
    },{
    	ref : 'admissionsummarygrid',
    	selector : 'admissionsummarygrid'
    },{
    	ref : 'admissionsummaryfilter',
    	selector : 'admissionsummaryfilter'
    },{
    	ref : 'applicationsummarygrid',
    	selector : 'applicationsummarygrid'
    },{
    	ref : 'applicationsummaryfilter',
    	selector : 'applicationsummaryfilter'
    },{
    	ref : 'admissionreporttreestore',
    	selector : 'admissionreporttreestore'
    },{
    	ref : 'admissiondtefdashboardtreestore',
    	selector : 'admissiondtefdashboardtreestore'
    }, {
        ref: 'applicationCommentsFilter',
        selector: 'applicationcommentsfilter[itemId=applicationcommentsfilterId]'
    },{
        ref: 'dtefadmissionfilter',
        selector: 'dtefadmissionfilter[itemId=dtefAdmissionFilterId]'
    },{
        ref: 'dtefcourseenrollmentfilter',
        selector: 'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId]'
    },{
        ref: 'dtefcourseenrollmentgrid',
        selector: 'dtefcourseenrollmentgrid'
    },{
        ref: 'dtefadmissiongrid',
        selector: 'dtefadmissiongrid'
    },{
    	ref: 'applicationcommentsgrid',
        selector: 'applicationcommentsgrid'
    },{
    	ref: 'applicationstaticsgrid',
        selector: 'applicationstaticsgrid'
    },{
		ref:'admissionsummaryapprovedstructure',
		selector:'admissionsummaryapprovedstructure'
	},{
		ref:'admissionsummaryapprovedfilter',
		selector:'admissionsummaryapprovedfilter'
	},{
		ref:'admissionsummaryapprovedgrid',
		selector:'admissionsummaryapprovedgrid'
	},
	{
		ref:'dtefcoursedetails',
		selector:'dtefcoursedetails'
	},{
		ref:'noofdtefassociatedcourse',
		selector:'noofdtefassociatedcourse'
	}, {
		ref: 'dtefModuleResultsView',
		selector: 'dtefModuleResultsView'
	}, {
		ref: 'dtefModuleResultsFilter',
		selector: 'dtefModuleResultsFilter'
	}, {
		ref: 'dtefModuleResultsGrid',
		selector: 'dtefModuleResultsGrid'
	},{
		ref:'dtefinvoicesfilter',
		selector:'dtefinvoicesfilter'
	},{
		ref:'dtefinvoicesgrid',
		selector:'dtefinvoicesgrid'
	}],

    init: function(application) {
        this.control({
        	'admissiondashboardview panel[itemId=admissionReportView] treepanel[itemId=admissionReportTreePanelItemId]' : {
				itemclick : this.getOpenAdmissionReportStructure,
				render: function(structure) {
	                   this.doAccessAdmissionDashBoardReportTreePanel(structure);
	               }
			},
            'organizationunit[itemId=admissionDashboardOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
                change: function(obj, record) {
                    this.organizationUnitChange(obj,record);
                },
                render: function(obj) {
                	var permission = this.getADMISSIONDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
                }
        
            },
        	'dtefdashboardview panel[itemId=admissionDtefReportView] treepanel[itemId=admissionDtefReportTreePanelItemId]':{
    			itemclick : this.openDTEFFilterAndGrid
    		},
            'organizationunit[itemId=admissionDashboardOrganizationUnit] button[itemId=resetBtn]': {
                click: function(obj, record) {
                    this.resetOrganizationunit(obj);
//                    var admissionForm = this.getAdmissionStatisticsSearchForm();
//                    admissionForm.down('#admissionStatisticsFindButtonId').setDisabled(true);
//                    var combo = obj.up('form').down('#multiselectAcademyLocationId');
//                    if(combo.getValue() !== null){
//                    	this.getAdmissionRejectionAnalysisSearchForm().down('#searchButtonId').setDisabled(false);
//                    }else{
//                    	this.getAdmissionRejectionAnalysisSearchForm().down('#searchButtonId').setDisabled(true);
//                    }
                    
                   if(!isNullOrEmpty(Ext.ComponentQuery.query('admissionreporttabpanel') && Ext.ComponentQuery.query('admissionreporttabpanel') != undefined)){
                    	if( Ext.ComponentQuery.query('admissionreporttabpanel').length > 0 ){
                    		tabpanel = Ext.ComponentQuery.query('admissionreporttabpanel')[0];
                    		if(!isNullOrEmpty(tabpanel) && tabpanel != undefined){
                    			activeTab = tabpanel.getActiveTab();
                                //activeTabIndex = tabpanel.items.indexOf(activeTab);
                    			if(!isNullOrEmpty(activeTab) && activeTab != undefined){
                    				var admissionForm = activeTab.down('form');
                    				if(!isNullOrEmpty(admissionForm) && admissionForm != undefined){
                    					var searchButton1 = admissionForm.down('#searchBtn');
                        				if(!isNullOrEmpty(searchButton1) && searchButton1 != undefined){
                        					searchButton1.setDisabled(true);
                        				}
                        				var searchButton2 = admissionForm.down('#searchButtonId');
                        				if(!isNullOrEmpty(searchButton2) && searchButton2 != undefined){
                        					searchButton2.setDisabled(true);
                        				}
                        				var searchButton3 = admissionForm.down('#selectionProcessOverviewSearchButtonId');
                        				if(!isNullOrEmpty(searchButton3) && searchButton3 != undefined){
                        					searchButton3.setDisabled(true);
                        				}
                        				var searchButton4 = admissionForm.down('#admissionStatisticsFindButtonId');
                        				if(!isNullOrEmpty(searchButton4) && searchButton4 != undefined){
                        					searchButton4.setDisabled(true);
                        				}
                        				var searchButton5 = admissionForm.down('#applicationStatisticsFindButtonId');
                        				if(!isNullOrEmpty(searchButton5) && searchButton5 != undefined){
                        					searchButton5.setDisabled(true);
                        				}
                    				}
                    			}
                    		}
                    	}
                    }
                }
            },
            'organizationunit[itemId=admissionDashboardOrganizationUnit] multiselectcombofield[itemId=academyLocationId]': {
                select: function() {
                    console.log("academyLocationId")
                }
            },
            'organizationunit[itemId=admissionDashboardOrganizationUnit] multiselectcombofield[itemId=multiselectAcademyLocationId]': {
            	change: function(combo) {
            		if(this.getApplicationCommentsFilter())
            		{
            			var applicationCommentsForm = this.getApplicationCommentsFilter();
            			var applicantStudentNameSearchCombo = applicationCommentsForm.down('#applicantStudentNameSearch');
            			this.resetApplicationCommentsDropdowns(applicantStudentNameSearchCombo);
            			var applicationCommentsProgramCombo = applicationCommentsForm.down('#programId');
            			this.resetApplicationCommentsDropdowns(applicationCommentsProgramCombo);
            			var applicationCommentsbatchIdCombo = applicationCommentsForm.down('#batchId');
            			this.resetApplicationCommentsDropdowns(applicationCommentsbatchIdCombo);
            			var applicationCommentsintakeYearIdCombo = applicationCommentsForm.down('#intakeYearId');
            			this.resetApplicationCommentsDropdowns(applicationCommentsintakeYearIdCombo);
            			var applicationCommentsSeatTypeIdCombo = applicationCommentsForm.down('#seatTypeId');
            			this.resetApplicationCommentsDropdowns(applicationCommentsbatchIdCombo);
            		}
            		if(this.getSelectionProcessOverviewSearchForm()){
            			var selectionForm = this.getSelectionProcessOverviewSearchForm();
            			var programCombo = selectionForm.down('#programId');
            			this.resetOtherDropdowns(programCombo);	
            		}
            		/*if(this.getAdmissionRejectionAnalysisSearchForm())
            		{
            			var rejectionForm = this.getAdmissionRejectionAnalysisSearchForm();
            			var rejectionProgramCombo = rejectionForm.down('#programId');
            			this.resetOtherDropdowns(rejectionProgramCombo);
            		}*/


              if(this.getAdmissionRejectionAnalysisSearchForm()){
            	  if(combo.getValue() !== null){
      	       		this.getAdmissionRejectionAnalysisSearchForm().down('#searchButtonId').setDisabled(false);
              		}else{
              		this.getAdmissionRejectionAnalysisSearchForm().down('#searchButtonId').setDisabled(true);
               		}
                  }
            	}
            },        
            /**
             * This event is for admission statistics
             * dashboard
             */'admissionstatisticsview form[itemId=admissionStatisticsSearchForm] button[itemId=admissionStatisticsFindButtonId]': {
                click: function() {
                    this.loadAdmissionStatisticsChart();
                }
            },
            
            'admissionstatisticsview form[itemId=admissionStatisticsSearchForm]': {
                render: function() {
          	        var admissionStatisticsByAcademiesPieChart = this.getAdmissionStatisticsByAcademiesPieChart();
          	        var admissionStatisticsByLocationsPieChart = this.getAdmissionStatisticsByLocationsPieChart();
          	        var admissionStatisticsByProgramBarChart = this.getAdmissionStatisticsByProgramBarChart();
          	        
              		this.loadDisableChartOnSelection(null,admissionStatisticsByAcademiesPieChart);
              		this.loadDisableChartOnSelection(null,admissionStatisticsByLocationsPieChart);
              		this.loadDisableChartOnSelection(null,admissionStatisticsByProgramBarChart);
              	}
            },

            'admissionstatisticsview form[itemId=admissionStatisticsSearchForm] button[itemId=admissionStatisticsClearSearch]': {
                click: this.clearSearchForm
            },

            /**
             * This event is for admission rejection
             * dashboard
             */'admissionrejectionanalysisview form[itemId=admissionRejectionAnalysisSearchForm] button[itemId=resetButtonId]': {
                click: this.clearSearchForm
            },

            'admissionrejectionanalysisview form[itemId=admissionRejectionAnalysisSearchForm] button[itemId=searchButtonId]': {
                click: function() {
                    this.loadAdmissionRejectionAznalysisChart();
                }
            },

            'fieldcontainer[itemId=admissionRejectionAnalysisProgrmBatchSeatTypeContainer] combo[itemId=programId]': {
                render: function(programComboField,
                records, eOpts) {
                    this.loadProgramComboByApplyingMAUFilter(
                    programComboField,
                    records, eOpts);
                },
                select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    batchComboField,
                    comboValue, 'id');
                }
            },
            'fieldcontainer[itemId=admissionRejectionAnalysisProgrmBatchSeatTypeContainer] combo[itemId=batchId]':{
            	select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    sectionComboField,
                    comboValue, 'batchId');
            }
            },
           'dtefadmissionfilter[itemId=dtefAdmissionFilterId] combo[itemId=programId]': {
                render: function(combo, records, eOpts) {
                	var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var programComboField = combo.up('form').down('#programId');
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
                    programComboField.getStore().getProxy().extraParams={
                    	academyLocationIds : alIds
					};
                    programComboField.getStore().load();
                },
                select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    batchComboField.getStore().getProxy().extraParams={
						id : comboValue
					};
                    batchComboField.getStore().load();
                    batchComboField.setDisabled(false);
                }
            },
            'dtefadmissionfilter[itemId=dtefAdmissionFilterId] combo[itemId=programGroupItemId]': {
                select: function(combo, records, eOpts) {
                	var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var programComboField = combo.up('form').down('#programId');
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
                    programComboField.getStore().getProxy().extraParams={
                    	programGroupId : comboValue,
                    	academyLocationIds : alIds
					};
                    programComboField.getStore().load();
                    batchComboField.reset();
                    batchComboField.setDisabled(true);
                    programComboField.reset();
                }
            },
            'dtefadmissionfilter[itemId=dtefAdmissionFilterId] combo[itemId=batchId]': {
                select: function(combo, records, eOpts) {
                	var form = this.getDtefdashboardview();
                	var intake=combo.up('form').down('#intakeYear');
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    intake.getStore().getProxy().extraParams={
                    	batchId : comboValue,
					};
                    intake.getStore().load();
                }
            },
            'dtefadmissiongrid' : {
        		render: function(grid){
        			this.doAccessControlValidation(grid,this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS());
        			this.sendToDtefPivileges(grid, this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS());
        		},
                selectionchange: function(column, selected,eOpts ){	
	                var $this = this;
	                var dtefReportTabPanel = Ext.ComponentQuery.query('admissiondtefreporttabpanel')[0];
	                var grid = dtefReportTabPanel.getActiveTab().down('#dtefadmissiongridId');
	  				var counter =0;
	  		        var flag=true;
	  		    	var selectionModel = grid.getSelectionModel().getSelection();
	  		    	selectionModel.forEach(function(obj){
	  		            if(obj.get('applicationStatus')!="APPROVED" || obj.get('responseStatus')== getCommonTranslation('SUCCESS_STATUS')){
	  		                flag=false;
	  		                }
	  		        });
	  		        if(flag==true)
	  		            {
	  		            	grid.down('#sendToDTEFBtn').setDisabled(false);
	  		            }else{
	  		            	grid.down('#sendToDTEFBtn').setDisabled(true);    
	  		            }
	  		        if(selectionModel.length==0){
			            	grid.down('#sendToDTEFBtn').setDisabled(true);    
	  		        }	  		       
                }
            },
            
            'dtefcourseenrollmentgrid' : {
        		render: function(grid){
        			this.doAccessControlValidation(grid,this.getDTEF_COURSE_ENROLLMENT_PRIVILEGES_PERMISSIONS());
        			this.sendToDtefPivileges(grid, this.getDTEF_COURSE_ENROLLMENT_PRIVILEGES_PERMISSIONS());
        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var $this=this;
					//var searchResultGrid = $this.getSearchresultgrid();
					var columnName=grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName=='courseCodes' &&  record.data.courseCodes.length> 0){ // checked
						//var store=$this.getStore('course.coursegroup.AssignCoursesStructureStore');


						var formWindow = $this.getDtefcoursedetails();
						if (!formWindow) {
							Ext.widget('dtefcoursedetails');
							formWindow = $this.getDtefcoursedetails();
						}
						formWindow.show();
						var grid = formWindow.down('noofdtefassociatedcourse');
						var gridStore = grid.getStore();
						gridStore.removeAll();
						gridStore.add(record.data.courseCodes);
					}
				},
        		afterrender: function(grid) {
        			var me = this;
        			grid.getStore().removeAll();
        			setTimeout(function(){
        				me.addDataGridConfigButton(grid,me.getDTEF_COURSE_ENROLLMENT_PRIVILEGES_PERMISSIONS());
        			},3000);

        		},
                selectionchange: function(column, selected,eOpts ){	
	                var $this = this;
	  				var grid = $this.getDtefcourseenrollmentgrid();
	  				
	  		    	var selectionModel = grid.getSelectionModel().getSelection();
	  		    	
	  		    	if(selectionModel.length==0){
	  		    		grid.down('#sendToDTEFBtn').setDisabled(true);    
	  		    	}
	  		    	else{
	  		    		grid.down('#sendToDTEFBtn').setDisabled(false);  
	  		    	}
                }
            },
            'dtefcourseenrollmentgrid button[itemId=sendToDTEFBtn]':{
				click: function(btn){
					btn.disable();
					var grid =  btn.up('grid');
					var records = grid.getSelectionModel().getSelection();
					var studentCourseEnrollmentIdArray = [];
					Ext.each(records, function(studentRec){
						
							studentCourseEnrollmentIdArray.push({
								"studentCode":studentRec.data.studentCode,
									"admissionId":studentRec.data.admissionId,
									"periodId":studentRec.data.periodId
							})
					});
					
					var jsonData = Ext.encode(studentCourseEnrollmentIdArray);
					var submitUrl = SERVERURL.PATH_SCE_POST_DTEF_REGISTRATION_DATA;
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type: 'rest',
						url: submitUrl,
						jsonData:jsonData,
						method: 'POST',
						success: function(resp, action) {
							Ext.getBody().unmask();
							btn.setDisabled(false);
							showSuccessMessage(getExaminationTranslation('DTEF'),
								getExaminationTranslation('SEND_TO_DTEF_SUCESSFULLY'));
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
						}
					});
				}
			},
            'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId] combo[itemId=programId]': {
                render: function(combo, records, eOpts) {
                	var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var programComboField = combo.up('form').down('#programId');
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
                    programComboField.getStore().getProxy().extraParams={
                    	academyLocationIds : alIds
					};
                    programComboField.getStore().load();
                },
                select: function(combo, records, eOpts) {
                	
                	var batchComboField = combo.up('form').down('#batchId');
                	var form = combo.up('form');
                	var periodComboField = combo.up('form').down('#periodId');
                	var alinfomodel = Academia.model.authentication.ALInfoModel;
                	var wheatherSchool = alinfomodel.get('wheatherSchool');
                	var comboValue = combo.getValue();
                	var intake=combo.up('form').down('#intakeYear');
                	batchComboField.clearValue();
                	periodComboField.clearValue();
                	batchComboField.getStore().getProxy().extraParams={
                		id : comboValue
                	};

                	batchComboField.setDisabled(false);
                	periodComboField.setDisabled(true);
                	batchComboField.getStore().load({
                		callback: function(records, operation, success) {
                			if (success) {
                				if(records.length==1){
                					batchId=records[0].get('id');
                					batchComboField.setValue(records[0].get('id'));
                					periodComboField.setDisabled(false);
                					 intake.getStore().getProxy().extraParams={
                	                    	batchId : records[0].get('id'),
                						};
                	                    intake.getStore().load();

                					var periodStore = periodComboField.getStore();
                					periodStore.getProxy().extraParams = {
                						id : records[0].get('id')
                					};
                					periodStore.load({
                						callback: function(records, operation, success) {
                							if (success) {
                								   if(records.length == 0){
                									   if(wheatherSchool) {
                										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
                									   }
                								   } else if(records.length == 1){
                									   if(wheatherSchool) {
                										   periodComboField.setVisible(false);
                									   }
                									   periodComboField.setValue(records[0].get("id"));
                									   
                								   } else {
                									   periodComboField.setVisible(true);
                								   }
                							   }
                						}
                					});
                				} 	 
                			}
                		}

                	});
                	form.isValid();
                	form.getForm().clearInvalid();

                }
            },
            
            'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId] combo[itemId=batchId]': {
            	select: function(combo, records, eOpts) {
                	var form = this.getDtefdashboardview();
                	var intake=combo.up('form').down('#intakeYear');
                    var batchComboField = combo.up('form').down('#batchId');
                    var periodComboField = combo.up('form').down('#periodId');
                    var comboValue = combo.getValue();
                    var alinfomodel = Academia.model.authentication.ALInfoModel;
 				   var wheatherSchool = alinfomodel.get('wheatherSchool');
                    intake.getStore().getProxy().extraParams={
                    	batchId : comboValue,
					};
                    intake.getStore().load();
                    periodComboField.clearValue();
                    periodComboField.setDisabled(false);
                    var periodStore = periodComboField.getStore();
 				   periodStore.getProxy().extraParams = {
 					  id: comboValue
 				   };
 				   
 				  periodStore.load({

					   callback: function(rec, operation, success) {
						   if (success) {
							   if(rec.length == 0){
								   if(wheatherSchool) {
									   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
								   }
							   } else if(rec.length == 1){
								   if(wheatherSchool) {
									   periodComboField.setVisible(false);
								   }
								   periodComboField.setValue(rec[0].get("id"));
								   
							   } else {
								   periodComboField.setVisible(true);
							   }
						   }
					   }
				   
 				  });
 					form.isValid();
                	form.getForm().clearInvalid();
                    
                }
            
            },
            
            'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId] combo[itemId=studentFieldItemId]': {
            	render: function(combo, records, eOpts) {
            		var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var studentComboField = combo.up('form').down('#studentFieldItemId');
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
					var studentFieldStore = studentComboField.getStore();
					
					studentFieldStore.getProxy().extraParams = {
						academyLocationIds: alIds
	 				   };
					studentFieldStore.load();
            	}
            },

            'fieldcontainer[itemId=admissionRejectionAnalysisQuotaTypeQuotaContainer] combo[itemId=quotaTypeId]': {
                select: function(combo, records, eOpts) {
                    var quotaComboField = combo.up('form').down('#quotaId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    quotaComboField,
                    comboValue, 'quotaTypeId');
                }
            },

			'dtefadmissiongrid button[itemId=sendToDTEFBtn]': {
				click: function(obj) {
					var $this = this;
					var grid = $this.getDtefadmissiongrid();
					var records = grid.getSelectionModel().getSelection();
					var idValueModel = [];
					if (grid.getSelectionModel().getCount() > 0) {
						for (var i in records) {
							if (!isNullOrEmpty(records[i].raw.applicationProgramId)) {
								data = {
									"id": records[i].raw.applicationProgramId,
									"secondId": records[i].raw.applicantPersonId
								};
								idValueModel.push(data);
							}
						}
						var submitUrl = SERVERURL.PATH_SEND_TO_DTEF;
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									Ext.Ajax.request({
										type: 'rest',
										url: submitUrl,
										jsonData: idValueModel,
										method: 'POST',
										success: function(resp, action) {
											Ext.getBody().unmask();
											obj.setDisabled(false);
											showSuccessMessage(getExaminationTranslation('DTEF'),
												getExaminationTranslation('SEND_TO_DTEF_SUCESSFULLY'));
											grid.getStore().reload();
											grid.getSelectionModel().deselectAll();
										}
									});
					}
				}
			},
            /**
             * this event is for admission selection
             * process overview
             */'selectionprocessoverviewview form[itemId=selectionProcessOverviewSearchForm] button[itemId=selectionProcessOverviewResetButtonId]': {
                click: this.clearSearchForm
            },

            'selectionprocessoverviewview form[itemId=selectionProcessOverviewSearchForm] button[itemId=selectionProcessOverviewSearchButtonId]': {
                click: function() {
                    this.loadSelectionProcessOverviewChart();
                }
            },
            'admissionrejectionanalysissearchform[itemId=admissionRejectionAnalysisSearchForm] customcombobox[itemId=intakeYear]':{
				select:function(obj, record){
					var $this = this;
					var intakeYearId = record[0].data.id;
			        var academyLocationIds = this.getAcademyLocationIds();
					var program = obj.up('form').down('#programId');
					program.reset();
					program.getStore().getProxy().extraParams={
						academyLocationIds : academyLocationIds,
						intakeYearId : intakeYearId
					};
					program.getStore().load();
				}
    		},
            'fieldcontainer[itemId=selectionProcessProgrmBatchSeatTypeContainer] combo[itemId=programId]': {
                render: function(programComboField,
                records, eOpts) {
                    this.loadProgramComboByApplyingMAUFilter(
                    programComboField,
                    records, eOpts);
                },
                select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    batchComboField,
                    comboValue, 'id');
                }
            },
            'fieldcontainer[itemId=selectionProcessProgrmBatchSeatTypeContainer] combo[itemId=batchId]': {
                select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#seatTypeId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    sectionComboField,
                    comboValue, 'batchId');
                }
            },
            'fieldcontainer[itemId=selectionProcessQuotaTypeQuotaContainer] combo[itemId=quotaTypeId]': {
                select: function(combo, records, eOpts) {
                    var quotaComboField = combo.up('form').down('#quotaId');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(
                    quotaComboField,
                    comboValue, 'quotaTypeId');
                }
            },
            'admissionsummarygrid button #exportPDFCurrentPage':{
            	 click : function() {
            	 this.exportPDFAdmissionSummaryReport();
            	 }
            },
            'admissionsummarygrid':{
            	afterrender : function(grid) {
   				  	grid.down('#btnExportToPDFJasper').setDisabled(true);
   				  	grid.down('#btnExportToExcelJasper').setDisabled(true);
            	}
            },
            'admissionsummarygrid button #exportExcelCurrentPage':{
            	click : function() {
               	 this.exportXLAdmissionSummaryReport();
               	 }
            },
            'admissionsummaryfilter button[itemId=searchBtn]' : {
 			   click : function() {
 				   this.loadAdmissionSummary();
 			   }
 		   },
 		   'admissionsummaryfilter button[itemId=resetBtn]' : {
 			   click : function() {
 				   var admissionSummaryFilter = this.getAdmissionsummaryfilter();
 				   admissionSummaryFilter.getForm().reset();
 				   var admissionsummarygrid = this.getAdmissionsummarygrid();
 				   admissionsummarygrid.down('#btnExportToPDFJasper').setDisabled(true);
 				   admissionsummarygrid.down('#btnExportToExcelJasper').setDisabled(true);

 				   if(admissionSummaryFilter.down('#fromDate')){
 					   admissionSummaryFilter.down('#fromDate').setMinValue(false);
 					   admissionSummaryFilter.down('#fromDate').setMaxValue(false);
 				   }

 				   if(admissionSummaryFilter.down('#toDate')){
 					   admissionSummaryFilter.down('#toDate').setMinValue(false);
 					   admissionSummaryFilter.down('#toDate').setMaxValue(false);
 				   }
 			   }
 		   },
  		  'admissionsummaryfilter customcombobox#programGroupItemId': {
             	select: function(obj, record) {
             		var form = this.getAdmissionsummaryfilter();
             		form.down("#programCategoryId").setDisabled(false);
             		var programId = record[0].get("id");
             		if(programId > 0){
             			var store = this.getStore('program.ProgramCategoryByProgramGroupStore');
             			store.getProxy().extraParams = {
             				programGroupId: programId
             			};
             			store.load();
             		}
             	},
             	change: function(value,newValue) {
             		if(isNullOrEmpty(newValue)){
             			var form = this.getAdmissionsummaryfilter();             		
             			form.down("#programCategoryId").setDisabled(true);
             		}
             	}
             },
           'applicationsummarygrid':{
            	afterrender : function(grid) {
   				  	grid.down('#btnExportToPDFJasper').setDisabled(true);
   				  	grid.down('#btnExportToExcelJasper').setDisabled(true);
            	}
            },
 		   'applicationsummarygrid button #exportPDFCurrentPage':{
 			   click : function() {
 				   this.exportPDFApplicationSummaryReport();
 			   }
 		   },
 		   'applicationsummarygrid button #exportExcelCurrentPage':{
 			   click : function() {
 				   this.exportXLApplicationSummaryReport();
 			   }
 		   },
 		   'applicationsummaryfilter button[itemId=searchBtn]' : {
 			   click : function() {
 				   this.loadApplicationSummary();
 			   }
 		   },
 		   'applicationsummaryfilter button[itemId=resetBtn]' : {
 			   click : function() {
 				   var applicationSummaryFilter = this.getApplicationsummaryfilter();
 				   applicationSummaryFilter.getForm().reset();
 				   var applicationsummarygrid = this.getApplicationsummarygrid();
 				   applicationsummarygrid.down('#btnExportToPDFJasper').setDisabled(true);
 				   applicationsummarygrid.down('#btnExportToExcelJasper').setDisabled(true);
 				   
 				   if(applicationSummaryFilter.down('#fromDate')){
 					   applicationSummaryFilter.down('#fromDate').setMinValue(false);
 					   applicationSummaryFilter.down('#fromDate').setMaxValue(false);
 				   }

 				   if(applicationSummaryFilter.down('#toDate')){
 					   applicationSummaryFilter.down('#toDate').setMinValue(false);
 					   applicationSummaryFilter.down('#toDate').setMaxValue(false);
 				   }
 			   }
 		   },
 		  'applicationsummaryfilter customcombobox#programGroupItemId': {
           	select: function(obj, record) {
           		var form = this.getApplicationsummaryfilter();
           		form.down("#programCategoryId").setDisabled(false);
           		var programId = record[0].get("id");
           		if(programId > 0){
           			var store = this.getStore('program.ProgramCategoryByProgramGroupStore');
           			store.getProxy().extraParams = {
           				programGroupId: programId
           			};
           			store.load();
           		}
           	},
           	change: function(value,newValue) {
           		if(isNullOrEmpty(newValue)){
           			var form = this.getApplicationsummaryfilter();             		
           			form.down("#programCategoryId").setDisabled(true);
           		}
           	}
           },
 		   'admissiondashboardview' : {
 			   render:function(treePanel, record, item,index, e, eOpts){
 				   //this.doAccessControlValidation(grid, this.getAPPLICATION_SUMMARY_REPORT_PERMISSIONS());
 				   //this.doAccessControlValidation(grid, this.getADDMISSION_SUMMARY_REPORT_PERMISSIONS());
 				   this.disableMoreActionPivileges(treePanel,this.getADDMISSION_SUMMARY_REPORT_PERMISSIONS());
 				   this.disableMoreActionPivileges(treePanel,this.getAPPLICATION_SUMMARY_REPORT_PERMISSIONS());
 			   },
 			   afterrender : function(structure){
       			var $this = this;
    			//var programreporttreepanelandgrid = structure.down('#programreporttreepanelandgridId');
       			structure.body.on('scroll', function(e, target) {
       				var activeTab = structure.down('#admissionReportTabStructure').getActiveTab();
       				if(!isNullOrEmpty(activeTab)){
       					var baseStructure = activeTab;
       					var applicationcommentsstructure = baseStructure.down('applicationcommentsstructure');
       					var admissionsummaryapprovedstructure = baseStructure.down('admissionsummaryapprovedstructure');
       					if(applicationcommentsstructure!=null)
       						{
       					applicationcommentsgrid = applicationcommentsstructure.down('applicationcommentsgrid');
       					if(applicationcommentsgrid!=undefined)
       					{
       						$this.getMultipleGridHeaderFreeze(applicationcommentsgrid,structure,true);
       					}else{
       						var grid = activeTab.down('searchresultgrid');
       						if(grid != undefined){
       							$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
       						}else{
       							grid = activeTab.down('grid');
       							$this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
       						}

       					 }
       						}else if (!isNullOrEmpty(admissionsummaryapprovedstructure)){
       							var grid = admissionsummaryapprovedstructure.down('#admissionsummaryapprovedgridId');
       							$this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
       						}

       				}
       			});
    		}
 		   },
 		   'dtefdashboardview' : {
 			  render:function(structure, record, item,index, e, eOpts){
				    var treePanel =  structure.down('#admissionDtefReportTreePanelItemId');
			    	var treePnlRootNode = treePanel.getRootNode();
			    	this.checkPermissionAndRemoveDTEFReportTreePnl(treePnlRootNode,this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS(), "DTEF_DASHBOARD_ADMISSION_REPORT");
			    	this.checkPermissionAndRemoveDTEFReportTreePnl(treePnlRootNode,this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS(), "DTEF_DASHBOARD_COURSE_ENROLLMENT_REPORT");
			    	this.checkPermissionAndRemoveDTEFReportTreePnl(treePnlRootNode,this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS(), "DTEF_DASHBOARD_DTEF_MODULE_RESULTS");
			    	this.checkPermissionAndRemoveDTEFReportTreePnl(treePnlRootNode,this.getDTEF_DASHBOARD_PRIVILEGES_PERMISSIONS(), "DTEF_DASHBOARD_DTEF_INVOICES");
			   },
 			   afterrender : function(structure){
       			var $this = this;
       			structure.body.on('scroll', function(e, target) {
       				var activeTab = structure.down('#admissionDtefReportTabStructure').getActiveTab();
       				if(!isNullOrEmpty(activeTab)){
       					var baseStructure = activeTab;
       					var dtefAdmission = baseStructure.down('dtefadmissionview');
       					if(dtefAdmission!=null)
       						{
       					var dtefAddmissionGrid = $this.getDtefadmissiongrid();
       					if(dtefAddmissionGrid!=undefined)
       					{
       						$this.getMultipleGridHeaderFreeze(dtefAddmissionGrid,structure,true);
       					}else{
       						var grid = activeTab.down('searchresultgrid');
       						if(grid != undefined){
       							$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
       						}else{
       							grid = activeTab.down('grid');
       							$this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
       						}

       					}
       						}

       				}
       				
       				if(!isNullOrEmpty(activeTab)){
       					var baseStructure = activeTab;
       					var dtefCourseEnrollment = baseStructure.down('dtefcourseenrollmentview');
       					if(dtefCourseEnrollment!=null)
       						{
       					var dtefCourseEnrollmentGrid = $this.getDtefcourseenrollmentgrid();
       					if(dtefCourseEnrollmentGrid!=undefined)
       					{
       						$this.getMultipleGridHeaderFreeze(dtefCourseEnrollmentGrid,structure,true);
       					}else{
       						var grid = activeTab.down('searchresultgrid');
       						if(grid != undefined){
       							$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
       						}else{
       							grid = activeTab.down('grid');
       							$this.getMultipleGridHeaderFreezeWithoutPaggination(grid,structure,true); 
       						}

       					}
       						}
       					
       					var dtefModuleResults = baseStructure.down('dtefModuleResultsView');
       					if (dtefModuleResults != null) {
       					    var dtefModuleResultsGrid = $this.getDtefModuleResultsGrid();
       					    if (dtefModuleResultsGrid != undefined) {
       					        $this.getMultipleGridHeaderFreezeCss(dtefModuleResultsGrid, structure, true);
       					    }
       					}

       				}
       			});
       			
       			var form= this.getDtefdashboardview();
       			var alId=form.down('#academyLocationId');
       			alId.setValue(this.getCurrentAcademyLocation());
    		}   
 		   },
 		  
 		   
 		   'dtefdashboardview button[itemId=resetBtn]' : {
 			   click : function() {
 	       			var form= this.getDtefdashboardview();
 	       			var alId=form.down('#academyLocationId');
 	       		    alId.reset();
 	       		    alId.setValue(this.getCurrentAcademyLocation());
 			   }
 		   },
 		   'dtefdashboardview multiselectcombofield[itemId=academyLocationId]':{
 			   change: function(record){
 				  var $this = this;
 				  var form =$this.getDtefcourseenrollmentfilter();
 				  if(form) {
 					  var programField= form.down('#programId');
 					  form.getForm().reset();
 					  var store=form.down('#intakeYear').getStore();
 					  store.getProxy().extraParams = {};
 					  store.load(); 
 					  form.down('#batchId').setDisabled(true);
 					  form.down('#periodId').setDisabled(true);

 					  if(form.down('#toDate')){
 						  form.down('#toDate').setMinValue(false);
 					  }
 					  var alForm = this.getDtefdashboardview();
 					  var alId=alForm.down('#academyLocationId');
 					  var alValue = alId.getValue();
 					  var alIdArr=[];
 					  var alIds = null;
 					  if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
 						  for (var i in alValue) {
 							  if (Ext.isObject(alValue[0])) {
 								  alIdArr.push(alValue[i].get("id"));
 							  } else {
 								  alIdArr.push(alValue[i]);
 							  }
 						  }
 						  alIds = alIdArr.join();
 					  }
 					  else if(!isNullOrEmpty(alValue)){
 						  alIds = alValue;
 					  }
 					  if(isNullOrEmpty(alIds)) {
 						  alIds = this.getCurrentAcademyLocation();
 					  }

 					  programField.clearValue();
 					  programField.getStore().getProxy().extraParams={
 						  academyLocationIds : alIds
 					  };
 					  programField.getStore().load();
 				  }
					var dtefReportTabPanel = Ext.ComponentQuery.query('admissiondtefreporttabpanel')[0];
					if(dtefReportTabPanel && dtefReportTabPanel.getActiveTab() && dtefReportTabPanel.getActiveTab().title == getCommonTranslation('DTEF_MODULE_RESULTS')) {
						var filterForm = $this.getDtefModuleResultsFilter();
						var resetBtn = filterForm.down('#resetButtonId');
						this.resetDtefModuleResultsFilter(resetBtn);
					}else if(dtefReportTabPanel && dtefReportTabPanel.getActiveTab() && dtefReportTabPanel.getActiveTab().title == getCommonTranslation('DTEF_INVOICES')){
						this.resetDtefInvoicesFilter();
					}
 			   },
 			   
 		   },
           'fieldcontainer[itemId=applicationcommentsfilterprogrmbatchseattypecontainer] combo[itemId=programId]': {
               render: function(programComboField,
               records, eOpts) {
                   this.loadProgramComboByApplyingMAUFilter(
                   programComboField,
                   records, eOpts);
               },
               select: function(combo, records, eOpts) {
                   var batchComboField = combo.up('form').down('#batchId');
                   batchComboField.setDisabled(false);
                   var comboValue = combo.getValue();
                   this.loadDependentCombo(
                   batchComboField,
                   comboValue, 'id');
               }
           },
           'fieldcontainer[itemId=applicationcommentsfilterprogrmbatchseattypecontainer] combo[itemId=batchId]': {
      			  render: function(programComboField, records, eOpts) {
                   this.loadProgramComboByApplyingMAUFilter(programComboField, records, eOpts);
               },
        	   select: function(combo, record, eOpts) {
        		   
        	    var seatTypeComboField = combo.up('form').down('#seatTypeId');
        	    seatTypeComboField.setDisabled(false);
        	   	var batchId = record[0].get("id");
        	   	seatTypeComboField.reset();
        	    if (batchId > 0) {
        	   	  var store = this.getStore('enquiry.SeatTypeStore');
        	   	  store.getProxy().extraParams = {
        	   		  batchId: batchId
        	  	  };
        	   		store.load();
        	   }
        	   }
        	   
        	},
           'applicationcommentsfilter[itemId=applicationcommentsfilterId] button[itemId=searchBtn]' : {
        	   click : function() {
        		   this.loadApplicationCommentsGrid();
        	   }
           },
           'applicationcommentsfilter[itemId=applicationcommentsfilterId] button[itemId=resetBtn]' : {
        	   click : function() {
        		   $this=this;
        		   var admissionCommentsFilter = $this.getApplicationCommentsFilter();
        		   admissionCommentsFilter.getForm().reset();
        		   admissionCommentsFilter.down('#batchId').setDisabled(true);
        		   admissionCommentsFilter.down('#seatTypeId').setDisabled(true);
        		   if(admissionCommentsFilter.down('#fromDate')){
        			   admissionCommentsFilter.down('#fromDate').setMinValue(false);
        			   admissionCommentsFilter.down('#fromDate').setMaxValue(false);
        		   }

        		   if(admissionCommentsFilter.down('#toDate')){
        			   admissionCommentsFilter.down('#toDate').setMinValue(false);
        			   admissionCommentsFilter.down('#toDate').setMaxValue(false);
        		   }
        	   }
           },
           'dtefadmissionfilter[itemId=dtefAdmissionFilterId] button[itemId=searchButtonId]' : {
        	   click : function() {
        		   this.loadAdmissionDtefDashboardGrid();
        	   }
           },
           'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId] button[itemId=searchButtonId]' : {
        	   click : function() {
        		   this.loadCourseEnrollmentDtefDashboardGrid();
        	   }
           },
           'dtefadmissionfilter[itemId=dtefAdmissionFilterId] button[itemId=resetButtonId]' : {
        	   click : function() {
        		   $this=this;
        		   var admissionfilter = $this.getDtefadmissionfilter();
        		   admissionfilter.getForm().reset();
        		   var store=admissionfilter.down('#intakeYear').getStore();
        		   store.getProxy().extraParams = {};
				   store.load(); 
        		   admissionfilter.down('#batchId').setDisabled(true);
                	
                	var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var programComboField = admissionfilter.down('#programId');
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
                    programComboField.getStore().getProxy().extraParams={
                    	academyLocationIds : alIds
					};
                    programComboField.getStore().load();
                
        	   }
           },
           
           'dtefcourseenrollmentfilter[itemId=dtefCourseEnrollmentFilterId] button[itemId=resetButtonId]' : {
        	   click : function() {
        		   $this=this;
        		   var courseEnrollmentFilter = $this.getDtefcourseenrollmentfilter();
        		   courseEnrollmentFilter.getForm().reset();
        		   var store=courseEnrollmentFilter.down('#intakeYear').getStore();
        		   store.getProxy().extraParams = {};
				   store.load(); 
				   courseEnrollmentFilter.down('#batchId').setDisabled(true);
				   courseEnrollmentFilter.down('#periodId').setDisabled(true);
				   
				  
 				   if(courseEnrollmentFilter.down('#toDate')){
 					  courseEnrollmentFilter.down('#toDate').setMinValue(false);
 				   }
                	var form = this.getDtefdashboardview();
                	var AlId = form.down('#academyLocationId');
                	var alValue = AlId.getValue();
                    var programComboField = courseEnrollmentFilter.down('#programId');
                    var alIdArr=[];
					var alIds = null;
					if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
						for (var i in alValue) {
							if (Ext.isObject(alValue[0])) {
								alIdArr.push(alValue[i].get("id"));
							} else {
								alIdArr.push(alValue[i]);
							}
						}
						alIds = alIdArr.join();
					}
					else if(!isNullOrEmpty(alValue)){
						alIds = alValue;
					}
					if(isNullOrEmpty(alIds)) {
						alIds = this.getCurrentAcademyLocation();
					}
                    programComboField.getStore().getProxy().extraParams={
                    	academyLocationIds : alIds
					};
                    programComboField.getStore().load();
                
        	   }
           },
           /**
            * This event is for application statistics
            * dashboard
            */
           'applicationstatisticsview form[itemId=applicationStatisticsSearchForm] button[itemId=applicationStatisticsFindButtonId]': {
               click: function() {
                   this.loadApplicationStatisticsChart();
               }
           },
           'applicationstatisticsview form[itemId=applicationStatisticsSearchForm] button[itemId=applicationStatisticsClearSearch]': {
               click: this.clearApplicantStatisticsForm
           },
           'applicationstaticsgrid' : {
        	   render: function(structure) {
        		   var applicationStatisticsView = this.getApplicationstatisticsview();
        		   var applicationstaticsgrid = applicationStatisticsView.down('#applicationstaticsgrid');
        		   var buttonsToolBar = applicationstaticsgrid.query('toolbar')[0];
        		   buttonsToolBar.query('#btnExportToPDF')[0].setDisabled(true);
        		   buttonsToolBar.query('#btnExportToExcel')[0].setDisabled(true);
        	   }
           },
           'applicationstatisticsview customcombobox#applicationStatistics': {
        	   select: function(combo, records) {
        		   var form = this.getApplicationstatisticsview();
        		   var statisticsField = form.down('#applicationStatistics').getValue();
        		   if(statisticsField == 'COMPETITIVE_EXAM_PERCENTAGE'){
        			   form.down('#nameOfExam').allowBlank=false;
        			   form.down('#nameOfExam').setVisible(true);
        		   }else{
        			   form.down('#nameOfExam').setVisible(false);
        			   form.down('#nameOfExam').allowBlank=true;
        			   form.down('#nameOfExam').reset();
        		   }
        		   var newform = form.down('form').getForm();
        		   newform.isValid();
        	   }
           },
           'applicationstatisticsview': {
        	   afterrender: function(records) {
        		   var form = this.getApplicationstatisticsview();
        		   var statisticsField = form.down('#applicationStatistics').getStore();
        		   var cmpExam = statisticsField.findRecord('value','INTERVIEW_LOCATION');
        		   var cfConfigration=true;
        		   var resultViewUrl = SERVERURL.PATH_CF_CONFIGURATION_CHECK;
        		   Ext.Ajax.request({
        			   type: 'rest',
        			   url: resultViewUrl + '?tableName=applicant_other_information',
        			   method: 'GET',
        			   headers: {
        				   'Content-Type': 'application/json'
        			   },
        			   success: function(response) {
        				   data = Ext.decode(response.responseText);
        				   data.cfColumnNames.forEach(function(obj){
        					   if(obj == "cf11"){
        						   cfConfigration=false;
        					   }
        				   });
        				   if(cfConfigration){
        					   statisticsField.remove(cmpExam);
        				   }
        			   }
        		   });

        		   var souWithTSM = statisticsField.findRecord('value','SOURCE_FROM_WHICH_TSM');
        		   var result=true;
        		   var resultViewUrl = SERVERURL.PATH_CF_CONFIGURATION_CHECK;
        		   Ext.Ajax.request({
        			   type: 'rest',
        			   url: resultViewUrl + '?tableName=applicant_person',
        			   method: 'GET',
        			   headers: {
        				   'Content-Type': 'application/json'
        			   },
        			   success: function(response) {
        				   data = Ext.decode(response.responseText);
        				   data.cfColumnNames.forEach(function(obj){
        					   if(obj == "cf11"){
        						   result=false;
        					   }
        				   });
        				   if(result){
        					   statisticsField.remove(souWithTSM);
        				   }
        			   }
        		   });
        	   }
           },
           'admissionsummaryapprovedgrid':{
            	afterrender : function(grid) {
   				  	grid.down('#btnExportToPDFJasper').setDisabled(true);
   				  	grid.down('#btnExportToExcelJasper').setDisabled(true);
            	}
            },
           'admissionsummaryapprovedgrid button #exportPDFCurrentPage':{
          	 click : function() {
          	 this.exportPDFAdmissionSummaryApprovedReport();
          	 }
          },
          'admissionsummaryapprovedgrid button #exportExcelCurrentPage':{
          	click : function() {
             	 this.exportXLAdmissionSummaryApprovedReport();
             	 }
          },
            'admissionsummaryapprovedfilter button[itemId=searchBtn]' : {
 			   click : function() {
 				   this.loadAdmissionSummaryApprovedByDate();
 			   }
 		   },
 		   'admissionsummaryapprovedfilter button[itemId=resetBtn]' : {
 			   click : function() {
 				   var admissionSummaryapprovedFilter = this.getAdmissionsummaryapprovedfilter();
 				   admissionSummaryapprovedFilter.getForm().reset();
 				   var admissionsummaryapprovedgrid = this.getAdmissionsummaryapprovedgrid();
 				   admissionsummaryapprovedgrid.down('#btnExportToPDFJasper').setDisabled(true);
 				   admissionsummaryapprovedgrid.down('#btnExportToExcelJasper').setDisabled(true);

 				   if(admissionSummaryapprovedFilter.down('#fromDate')){
 					   admissionSummaryapprovedFilter.down('#fromDate').setMinValue(false);
 					   admissionSummaryapprovedFilter.down('#fromDate').setMaxValue(false);
 				   }

 				   if(admissionSummaryapprovedFilter.down('#toDate')){
 					   admissionSummaryapprovedFilter.down('#toDate').setMinValue(false);
 					   admissionSummaryapprovedFilter.down('#toDate').setMaxValue(false);
 				   }
 			   }
 		   },
  		  'admissionsummaryapprovedfilter customcombobox#programGroupItemId': {
             	select: function(obj, record) {
             		var form = this.getAdmissionsummaryapprovedfilter();
             		form.down("#programCategoryId").setDisabled(false);
             		var programId = record[0].get("id");
             		if(programId > 0){
             			var store = this.getStore('program.ProgramCategoryByProgramGroupStore');
             			store.getProxy().extraParams = {
             				programGroupId: programId
             			};
             			store.load();
             		}
             	},
             	change: function(value,newValue) {
             		if(isNullOrEmpty(newValue)){
             			var form = this.getAdmissionsummaryapprovedfilter();             		
             			form.down("#programCategoryId").setDisabled(true);
             		}
             	}
             },
             'dtefModuleResultsFilter button[itemId=resetButtonId]': {
            	 click: this.resetDtefModuleResultsFilter
             },
             'dtefModuleResultsFilter combo[itemId=programIdModuleResults]': {
            	 render: this.onModuleResultsProgramRender,
            	 select: this.onModuleResultsProgramSelect
             },
             'dtefModuleResultsFilter combo[itemId=batchIdModuleResults]': {
            	 select: this.onModuleResultsBatchSelect
             },
             'dtefModuleResultsFilter combo[itemId=periodIdModuleResults]': {
            	 select: this.onModuleResultsPeriodSelect
             },
             'dtefModuleResultsGrid': {
            	 render: this.onModuleResultsGridRender,
            	 cellclick: this.onModuleResultsGridCellClick,
            	 selectionchange: this.onModuleResultsGridSelectionChange
             },
             'dtefModuleResultsFilter customcombobox[itemId=admissionStatusModuleResults]': {
            	 select: this.onModuleResultsAdmissionStatusSelect
             },
             'dtefModuleResultsFilter button[itemId=searchButtonId]': {
            	 click: this.loadModuleResultsData
             },
             
             'dtefinvoicesfilter combo[itemId=programIdInvoices]': {
            	 select: this.onInvoicesProgramSelect
             },
             'dtefinvoicesfilter combo[itemId=batchIdInvoices]': {
            	 select: this.onInvoicesBatchSelect
             },
             'dtefinvoicesfilter button[itemId=dtefInvoiceSearchBtnId]': {
            	 click: this.searchDtefInvoiceFilter
             },
             'dtefinvoicesfilter button[itemId=dtefInvoiceResetBtnId]': {
            	 click:function(obj) {
            		 this.resetDtefInvoicesFilter();
            	 }
             },
             'dtefinvoicesfilter customcombobox[itemId=programIdInvoices]': {
            	 render: function(combo){
            		 var $this = this;
            		 combo.getStore().on('beforeload', function(store, operation) {
            			 store.proxy.extraParams = {
            					 academyLocationIds:$this.getAcademyLocationIdsForDtefDashboard(),
            			 };	
            		 });
            	 }
             },
             'dtefinvoicesgrid':{
            	 afterrender:function(grid){
            		 this.doAccessControlValidation(grid, this.getDTEF_INVOICES_PERMISSIONS());
            		 this.sendToDtefPivileges(grid, this.getDTEF_INVOICES_PERMISSIONS());
            	 },
            	 selectionchange:function(cmp,record){
            		 var gridView = this.getDtefinvoicesgrid();
            		 var selectedRecord=[];
            		 if(record.length){
         				record.forEach(function(data){
         					selectedRecord.push(data.get('responseStatus'));
         				});
         				if((selectedRecord.indexOf('SUCCESS') != -1) || (selectedRecord.indexOf('Success') != -1) || 
         						(selectedRecord.indexOf('success') != -1)){
     						gridView.down('#sendToDTEFBtn').setDisabled(true);
     					}else{
     						gridView.down('#sendToDTEFBtn').setDisabled(false);
     					}
         			}else{
         				gridView.down('#sendToDTEFBtn').setDisabled(true);
         			}
            	 }
             },
             'dtefinvoicesgrid button[itemId=sendToDTEFBtn]':{
            	 click:function(button){
            		 this.doSendDtefInvoices(button);
            	 }
             },
             'dtefinvoicesfilter customcombobox[itemId=studentFieldItemIdInvoices]': {
            	 render: function(combo){
            		 var $this = this;
            		 combo.getStore().on('beforeload', function(store, operation) {
            			 var filter = $this.getDtefinvoicesfilter();
            			 var dtefView = $this.getDtefdashboardview();
            			 var academyLocation = dtefView.down('#academyLocationId');
            			 var program = filter.down('#programIdInvoices').getValue();
            			 var batch = filter.down('#batchIdInvoices').getValue();
            			 var period = filter.down('#periodIdInvoices').getValue();
            			 store.proxy.extraParams = {
            					 programId:program,
            					 batchId:batch,
            					 periodId:period,
            					 academyLocationIds:$this.getAcademyLocationIdsForDtefDashboard(),
            			 };	
            		 });
            	 }
             },
             'dtefinvoicesfilter customcombobox[itemId=programIdInvoices]': {
                	 render: function(combo){
                		 var $this = this;
                		 combo.getStore().on('beforeload', function(store, operation) {
                			 store.proxy.extraParams = {
                				academyLocationIds:$this.getAcademyLocationIdsForDtefDashboard(),
                			 };	
                		 });
                	 }
               },
               'dtefinvoicesfilter customcombobox[itemId=nationalIdItemIdInvoices]': {
              	 render: function(combo){
              		 var $this = this;
              		 combo.getStore().on('beforeload', function(store, operation) {
              			 var filter = $this.getDtefinvoicesfilter();
              			 var dtefView = $this.getDtefdashboardview();
              			 var academyLocation = dtefView.down('#academyLocationId');
              			 var program = filter.down('#programIdInvoices').getValue();
              			 var batch = filter.down('#batchIdInvoices').getValue();
              			 var period = filter.down('#periodIdInvoices').getValue();
              			 store.proxy.extraParams = {
              					 programId:program,
              					 batchId:batch,
              					 periodId:period,
              					 academyLocationIds:$this.getAcademyLocationIdsForDtefDashboard(),
              			 };	
              		 });
              	 }
               },
             'dtefModuleResultsGrid button[itemId=sendToDTEFBtn]':{
            	 click:function(button){
            		 this.doSendDtefModuleResult(button);
            	 }
             }
        });
	}, 
    getOpenAdmissionReportStructure : function(treePanel, record, item,index, e, eOpts) {
		var $this = this;
		var admissionDashboardStructure = $this.getAdmissionDashboardView();
		var treeTab = admissionDashboardStructure.down('#admissionReportTreePanelItemId');
		var admissionReportTabStructure = admissionDashboardStructure.down('#admissionReportTabStructure');
		
		var tabDetail = record.data;
		var structure = Ext.widget(tabDetail.reportXtype);

		if (!isNullOrEmpty(tabDetail.text)
				&& !isNullOrEmpty(tabDetail.reportXtype)
				&& !isNullOrEmpty(tabDetail.reportXtypeItemId)) {

			openTab(admissionReportTabStructure, tabDetail.text,structure);
			treePanel.getSelectionModel().deselectAll();
		}
	},
	
    /**
     * load admission statistics graph store
     */
    loadAdmissionStatisticsChart: function() {
        var this$ = this;
        var organizationForm=this.getOrganizationunit().getForm();
  	    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
  	    if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
  	        var admissionStatisticsView = this.getAdmissionStatisticsView();
  	        var admissionStatisticsSearchForm = this.getAdmissionStatisticsSearchForm();
  	        var admissionStatisticsByAcademiesPieChart = this.getAdmissionStatisticsByAcademiesPieChart();
  	        var admissionStatisticsByLocationsPieChart = this.getAdmissionStatisticsByLocationsPieChart();
  	        var admissionStatisticsByProgramBarChart = this.getAdmissionStatisticsByProgramBarChart();
  	        var admissionStatisticsCombo = admissionStatisticsSearchForm.down('#admissionStatistics');
  	        var formValues = this$.createSeachCriteriaDashboardJsonFormat(
  	        admissionStatisticsSearchForm,
  	        admissionStatisticsCombo);
//  	        delete formValues.academicYear;
//  	        delete formValues.academyYearTenure;
  	        var value = admissionStatisticsCombo.getValue();
  	        var urlArray = new Array();
  	        
  	        var academicExport = admissionStatisticsView.down('#academyExtraBtns');
  	        var locationExport = admissionStatisticsView.down('#locationExtraBtns');
  	        var programExport = admissionStatisticsView.down('#programExtraBtns');
  	        
  	        switch (value) {

  	        case 'ADMISSION_GRANTED':

  	            urlArray[0] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        case 'ADMISSION_GRANTED_ON_TRIAL_BASIS':

  	            urlArray[0] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        case 'ADMISSION_GRANTED_ON_PROVISIONAL_BASIS':

  	            urlArray[0] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.ADMISSION_GRANTED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        case 'ADMISSIONS_OFFERED':

  	            urlArray[0] = SERVERURL.ADMISSION_OFFERED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.ADMISSION_OFFERED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.ADMISSION_OFFERED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        case 'ADMISSIONS_REJECTED':

  	            urlArray[0] = SERVERURL.ADMISSION_REJECTED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.ADMISSION_REJECTED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.ADMISSION_REJECTED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        case 'OFFER_LETTER_REJECTED':

  	            urlArray[0] = SERVERURL.OFFER_LETTER_REJECTED_STATISTICS_BY_ACADEMIES_PIE_CHART;
  	            urlArray[1] = SERVERURL.OFFER_LETTER_REJECTED_STATISTICS_BY_LOCATIONS_PIE_CHART;
  	            urlArray[2] = SERVERURL.OFFER_LETTER_REJECTED_STATISTICS_BY_PROGRAM_BAR_CHART;
  	            break;

  	        }
  	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	 
  	        Ext.Ajax.request({
  	            type: 'rest',
  	            url: urlArray[0],
  	            method: 'POST',
  	            headers: {
  	                'Content-Type': 'application/json'
  	            },
  	            jsonData: formValues,
  	            success: function(response) {
  	            	if (!isNullOrEmpty(response.responseText)) {
  	            		var data = Ext.decode(response.responseText);
  	            		this$.loadDisableChartOnSelection(data,admissionStatisticsByAcademiesPieChart);
  	            		this$.addExportToPngForDashboard(academicExport.menu,admissionStatisticsByAcademiesPieChart);
  	            		if(data.length > 0){
  	            			academicExport.setVisible(true);
  	            		}else{
  	            			academicExport.setVisible(false);
  	            		}
  	            		// 2nd call 
  	            		Ext.Ajax.request({
  	                        type: 'rest',
  	                        url: urlArray[1],
  	                        method: 'POST',
  	                        headers: {
  	                            'Content-Type': 'application/json'
  	                        },
  	                        jsonData: formValues,
  	                        success: function(response) {
  	                        	if (!isNullOrEmpty(response.responseText)) {
  	                        		var data = Ext.decode(response.responseText);
  	                        		this$.loadDisableChartOnSelection(data,admissionStatisticsByLocationsPieChart);
  	                        		this$.addExportToPngForDashboard(locationExport.menu,admissionStatisticsByLocationsPieChart);
  	                        		if(data.length > 0){
  	                        			locationExport.setVisible(true);
  	                        		}else{
  	                        			locationExport.setVisible(false);
  	                        		}
  	                        		// 3rd call
  	                        		 Ext.Ajax.request({
  	                        	            type: 'rest',
  	                        	            url: urlArray[2],
  	                        	            method: 'POST',
  	                        	            headers: {
  	                        	                'Content-Type': 'application/json'
  	                        	            },
  	                        	            jsonData: formValues,
  	                        	            success: function(response) {
  	                        	            	Ext.getBody().unmask();
  	                        	            	if (!isNullOrEmpty(response.responseText)) {
  	                        	            		var data = Ext.decode(response.responseText);
  	                        	            		this$.loadDisableChartOnSelection(data,admissionStatisticsByProgramBarChart);
  	                        	            		this$.addExportToPngForDashboard(programExport.menu,admissionStatisticsByProgramBarChart);
  	                        	            		if(data.length > 0){
  	                        	            			programExport.setVisible(true);
  	                        	            		}else{
  	                        	            			programExport.setVisible(false);
  	                        	            		}
  	                        	            	}
  	                        	            }
  	                        	        });
  	                        	}
  	                        }
  	                    });
  	            		
  	            	}
  	            }
  	        });
  	    }else{
			showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
   	    }
    },

    /**
     * This function is to load chart and disable when count is
     * zero
     */
    loadDisableChartOnSelection: function(data, form) {

        var isAllZero = true;
        var counts = new Array();
        Ext.each(data, function(value) {
            if (!isNullOrEmpty(value.count)) {
                counts.push(value.count);
            }
        });
        Ext.each(counts, function(value) {
            if (value != 0) {
                isAllZero = false;
                return false;
            }
        });

        if (isAllZero) {
        	if(form.nextSibling()!=null)
            form.nextSibling().setVisible(true);
            if (form) {
                form.setVisible(false);
            }
        } else {
            form.setVisible(true);
            if (form.nextSibling()) {
                form.nextSibling().setVisible(false);
            }
            form.getStore().loadData(data);
        }
    },
    /**
     * This function is to load Application Statistics chart and disable when count is
     * zero
     */
    loadApplicationChartDisableOnSelection: function(data, form) {

        var isAllZero = true;
        var counts = new Array();
        Ext.each(data, function(value) {
            if (!isNullOrEmpty(value.count)) {
                counts.push(value.count);
            }
        });
        Ext.each(counts, function(value) {
            if (value != 0) {
                isAllZero = false;
                return false;
            }
        });

        if (isAllZero) {
        	if(form.nextSibling()!=null){
        		if(form.xtype=="columnchartapplicationstatisticsreport")
        			{
        			form.nextSibling().nextSibling().setVisible(true);
        			}
        		else
        			{
        			form.nextSibling().setVisible(true);
        			}
        	}
            if (form) {
                form.setVisible(false);
            }
        } else {
            form.setVisible(true);
            if (form.nextSibling()) {
                form.nextSibling().setVisible(false);
            }
            setTimeout(function(){
            	form.getStore().loadData(data);
            }, 350);
        }
    },

    /**
     * load admission rejection analysis graph store
     */
    loadAdmissionRejectionAznalysisChart: function() {
        var this$ = this;
        
        var organizationForm=this.getOrganizationunit().getForm();
  	    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
  	    if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
  	    	var admissionRejectionAnalysisView = this$.getAdmissionRejectionAnalysisView();
  	        var admissionRejectionAnalysisSearchForm = this.getAdmissionRejectionAnalysisSearchForm();
  	        var admissionRejectionAnalysisBarChart = this.getAdmissionRejectionAnalysisBarChart();
  	        var formValues = this$.createSeachCriteriaDashboardJsonFormat(admissionRejectionAnalysisSearchForm);
  	        var rejectionExport = admissionRejectionAnalysisView.down('#rejectionExtraBtns');
  	        delete formValues.academicYear;
  	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	        Ext.Ajax.request({
  	            type: 'rest',
  	            url: SERVERURL.ADMISSION_REJECTION_ANALYSIS_CHART,
  	            method: 'POST',
  	            headers: {
  	                'Content-Type': 'application/json'
  	            },
  	            jsonData: formValues,
  	            success: function(response) {
  	            	Ext.getBody().unmask();
  	            	data = Ext.decode(response.responseText);
  	            	admissionRejectionAnalysisBarChart.getStore().loadData(data);
  	            	this$.addExportToPngForDashboard(rejectionExport.menu,admissionRejectionAnalysisBarChart);
  	            	if(data.length>0){
  	            		rejectionExport.setVisible(true);
  	            	}else{
  	            		rejectionExport.setVisible(false);
  	            	}
  	            }
  	        });
  	    }else{
			showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
  	    }
    },

    /**
     * Create dashboard search criteria json
     * 
     * @params searchCriteriaForm
     */
    createSeachCriteriaDashboardJsonFormat: function(
    searchCriteriaForm, combo) {
        var formValues = null;
        if (searchCriteriaForm) {
            formValues = searchCriteriaForm.getValues();
            for (var key in formValues) {
                var value = formValues[key];
                if (isNullOrEmpty(value) || value == 'All' || key == 'AL' || formValues == 'admissionStatistics') {
                    delete formValues[key];
                }
            }
            var academyLocationIds = this.getAcademyLocationIds();
            if (!isNullOrEmpty(academyLocationIds)) {
                academyLocationIds = academyLocationIds.toString();
                var commaIndex = academyLocationIds.indexOf(",");
                if (commaIndex != -1) {
                    var academyLocationArray = academyLocationIds.split(",");
                    formValues.academyLocationIds = academyLocationArray;
                } else {
                    formValues.academyLocationIds = [academyLocationIds];
                }

            }
            var seatTypeIds = formValues.seatType;
            if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
            	var seatTypeIdsArray=[];
            	for(var i in seatTypeIds) {
            		if(typeof seatTypeIds[i] == "object") {
            			seatTypeIdsArray.push(seatTypeIds[i].data.id);
            		} else {
            			seatTypeIdsArray.push(seatTypeIds[i]);
            		}
            	}
            	var seatTypeIdsString = seatTypeIdsArray.join();
            	seatTypeIdsString = seatTypeIdsString.toString();
            	var seatTypeCommaIndex = seatTypeIdsString.indexOf(",");
            	if (seatTypeCommaIndex != -1) {
            		var seatTypeIdsArray = seatTypeIdsString.split(",");
            		formValues.seatTypeIds = seatTypeIdsArray;
            	} else {
            		formValues.seatTypeIds = [seatTypeIdsString];
            	}
            }
            
            var obj =this. getOrganizationUnitIds();
            if(obj.ou){
            	formValues.ou = obj.ou;
            }else if(obj.mau){
            	formValues.mau = obj.mau;
            }
            if (!isNullOrEmpty(combo)) {
                var value = combo.getValue();
                if (value == 'ADMISSION_GRANTED') formValues.admissionType = 'CONFIRMED';
                if (value == 'ADMISSION_GRANTED_ON_TRIAL_BASIS') formValues.admissionType = 'TRIAL';
                if (value == 'ADMISSION_GRANTED_ON_PROVISIONAL_BASIS') formValues.admissionType = 'PROVISIONAL';
            }

        }
        delete formValues.admissionStatistics;
        delete formValues.multiselectAcademyLocation;
        delete formValues.organizationRadioUnit;
        delete formValues.seatType;
        return formValues;
    },

    /**
     * This method is used to clear fields on search Form
     * 
     * @param button
     *            which is reference of button
     */
    clearSearchForm: function(button) {

        var form = button.up('form');
        if (form) {
            var basicForm = form.getForm();
            var endDate = basicForm.findField('endDate');
            var startDate = basicForm.findField('startDate');
            endDate.setMaxValue(null);
            endDate.setMinValue(null);
            startDate.setMaxValue(null);
            startDate.setMinValue(null);
            
            basicForm.getFields().each(function(field) {
                field.reset();
            });
         
            
      
            var program = form.down('#programId');
            if(!isNullOrEmpty(program)) {
            	var academyLocationIds = this.getAcademyLocationIds();
				program.getStore().getProxy().extraParams={
					academyLocationIds : academyLocationIds
				};
				program.getStore().load();
            }
            var batch=form.down('#batchId');
            batch.getStore().removeAll();
            var seatType=form.down('#seatTypeId');
            seatType.getStore().removeAll();
        }
    },

    /**
     * On focus program combo load data according with MAU
     * filter's
     * 
     * @param programComboField
     * @param records
     * @param eOpts
     */

    loadProgramComboByApplyingMAUFilter: function(
    programComboField, records, eOpts) {
        var academyLocationIds = this.getAcademyLocationIds();
        var store = programComboField.getStore();
    	store.getProxy().extraParams = {
    					academyLocationIds: academyLocationIds
    					       }; 
    				store.load();
    },

    /**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue,
    parameter, extraParameter, extraParamValue) {
        var this$ = this;
    	if(this$.getApplicationCommentsFilter()){
    		this$.resetApplicationCommentsDropdowns(dependentCombo);
    	}else
    	{
        this$.resetOtherDropdowns(dependentCombo);
    	}
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if (!isNullOrEmpty(id)) {
            var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },

    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            break;
        case 'batchId':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(sectionCombo);
            break;
        case 'seatTypeId':
            this.clearCombo(combo);
            break;
        case 'quotaTypeId':
            this.clearCombo(combo);
            quotaCombo = container.down('combo[itemId=quotaId]');
            this.clearCombo(quotaCombo);
            break;
        case 'quotaId':
            this.clearCombo(combo);
            break;
       
        }
    },
    resetApplicationCommentsDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'programId':
            this.clearCombo(combo);
            var academyLocationIds = this.getAcademyLocationIds();
            combo.getStore().getProxy().extraParams={
				academyLocationIds : academyLocationIds
			};
            combo.getStore().load();
            batchCombo = container.down('combo[itemId=batchId]');
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(batchCombo);
            batchCombo.setDisabled(true);
            seatTypeCombo.setDisabled(true);
            break;
        case 'batchId':
            this.clearCombo(combo);
            combo.getStore().load();
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(seatTypeCombo);
            seatTypeCombo.setDisabled(true);
            break;
        case 'applicantStudentNameSearch':
            this.clearCombo(combo);
            var academyLocationIds = this.getAcademyLocationIds();
            combo.getStore().getProxy().extraParams={
				academyLocationIds : academyLocationIds
			};
            combo.getStore().load();
            break; 
        /*case 'intakeYearId':
            this.clearCombo(combo);
            break; */
        }
    },

    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },

    /**
     * load admission selection process overview graph store
     */
    loadSelectionProcessOverviewChart: function() {
        var this$ = this;
        
        var organizationForm=this.getOrganizationunit().getForm();
  	    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
  	    if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
  	        var selectionProcessoverviewView = this.getSelectionProcessoverviewView();
  	        var selectionProcessOverviewSearchForm = this.getSelectionProcessOverviewSearchForm();
  	      //  var selectionProcessOverviewColumnChart = this.getSelectionProcessOverviewColumnChart();
  	        var formValues = this$.createSelectionOverviewJsonFormat(selectionProcessOverviewSearchForm);
  	        delete formValues.academicYear;
  	        delete formValues.academyYearTenure;
  	        var selectionProcessExport = selectionProcessoverviewView.down('#selectionProcessExtraBtns');
  	        var form = this.getSelectionProcessForm();
  	        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  	        Ext.Ajax.request({
  	            type: 'rest',
  	            url: SERVERURL.SELECTION_PROCESS_OVERVIEW_REPORT,
  	            method: 'POST',
  	            headers: {
  	                'Content-Type': 'application/json'
  	            },
  	            jsonData: formValues,
  	            success: function(response) {
  	            	  Ext.getBody().unmask();
  	                data = Ext.decode(response.responseText);
  	                var mapArray = new Array();
  	                var fieldArray = new Array();
  	                for (var i = 0; i < data.stageStatistics.stages.length; i++) {
  	                    var stageData = data.stageStatistics.stages[i];
  	                    var stageName = stageData.name;
  	                    stageName = stageName.replace(/\s/gi, "_");
  	                    mapArray.push(stageName);
  	                    fieldArray.push(stageName);
  	                }
  	                var stageArray = new Object();
  	                stageArray['name'] = 'Stage Statistics';
  	                stageArray['count'] = 0;
  	                for (var i = 0; i < mapArray.length; i++) {
  	                    stageArray[mapArray[i]] = data.stageStatistics.stages[i].count;
  	                }
  	                mapArray.push('count');
  	                fieldArray.push('count');
  	                fieldArray.push('name');
  	                var selectionProcessOverviewColumnChart = form.down('#selectionProcessOverviewColumnChart');
  	                form.remove(selectionProcessOverviewColumnChart);
  	                var records = [{
  	                    'name': 'No. Of Application Sold',
  	                    'count': data.counts[0].count
  	                }, {
  	                    'name': 'No. Of Application Submitted',
  	                    'count': data.counts[2].count
  	                }, {
  	                    'name': 'No. Of Application Not Submitted',
  	                    'count': data.counts[1].count
  	                },
  	                stageArray, {
  	                    'name': 'Total Intake',
  	                    'count': data.counts[3].count
  	                }];

  	                form.add({
  	                    xtype: 'stackedbarchartreport',
  	                    itemId: 'selectionProcessOverviewColumnChart',
  	                    minWidth: 700,
  	                    height: 500,
  	                    columnHeight: 30,
  	                    columnColor: 'orange',
  	                    store: 'Academia.store.reports.admission.SelectionProcessOverviewStore',
  	                    fields: fieldArray,
  	                    xAxesNumericField: 'name',
  	                    xAxesNumericTitle: getAdmissionTranslation('COUNT_OF_STUDENTS'),
  	                    yAxesCategoryField: mapArray,
  	                    yAxesCategoryTitle: getAdmissionTranslation('SELECTION_PROCESS_OVERVIEW')
  	                });
  	                var selectionProcessOverviewColumnChart = form.down('#selectionProcessOverviewColumnChart');
  	                selectionProcessOverviewColumnChart.getStore().loadData(records);
  	                this$.addExportToPngForDashboard(selectionProcessExport.menu,selectionProcessOverviewColumnChart);
  	                selectionProcessExport.setVisible(true);
  	            }
  	        });
  	    }else{
  	    	showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
  	    }
    },

    /**
     * Create selection process overview search criteria json
     * 
     * @params searchCriteriaForm
     */
    createSelectionOverviewJsonFormat: function(searchCriteriaForm) {
        var formValues = null;
        if (searchCriteriaForm) {
            formValues = searchCriteriaForm.getValues();
            console.log(formValues)
            for (var key in formValues) {
                var value = formValues[key];
                if (isNullOrEmpty(value) || value == 'All' || key == 'AL') {
                    delete formValues[key];
                }
            }
            var academyLocationIds = this.getAcademyLocationIds();
            var obj =this. getOrganizationUnitIds();
            if(obj.ou){
            	formValues.ou = obj.ou;
            }else if(obj.mau){
            	formValues.mau = obj.mau;
            }
            
            if (!isNullOrEmpty(academyLocationIds)) {
                academyLocationIds = academyLocationIds.toString();
                var commaIndex = academyLocationIds.indexOf(",");
                if (commaIndex != -1) {
                    var academyLocationArray = academyLocationIds.split(",");
                    formValues.academyLocationIds = academyLocationArray;
                } else {
                    formValues.academyLocationIds = [academyLocationIds];
                }

            }
        }
        return formValues;
    },
    
    setFromDateToDateByAcademyYear:function(obj,academyYearId){
		var resultViewUrl = SERVERURL.ACADEMY_DATE_RANGE;
		var form = obj.up('form');
		var startDate = form.down('#startDate');
		var tillDate = form.down('#endDate');
		Ext.Ajax.request({
			type: 'rest',
			url: resultViewUrl + '?academicYear='+academyYearId,
			method: 'GET',
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response) {
				data = Ext.decode(response.responseText);
				if(!isNullOrEmpty(data[0].startDate)) {
					startDate.setValue(dateRender(data[0].startDate));
				} else {
					startDate.setValue(new Date());
				}
				if(!isNullOrEmpty(data[0].tillDate)) {
					tillDate.setValue(dateRender(data[0].tillDate));
				} else {
					tillDate.setValue(new Date());
				}
			}
		});
	},

	setFromDateToDateByAcademyYearTenure:function(obj,academicYearTenureId){
		var resultViewUrl = SERVERURL.ACADEMY_TENURE_DATE_RANGE;
		var form = obj.up('form');
		var startDate = form.down('#startDate');
		var tillDate = form.down('#endDate');
		Ext.Ajax.request({
			type: 'rest',
			url: resultViewUrl + '?academicYearTenureId='+academicYearTenureId,
			method: 'GET',
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response) {
				data = Ext.decode(response.responseText);
				startDate.setValue(dateRender(data[0].startDate));
				tillDate.setValue(dateRender(data[0].tillDate));
			}
		});
	},
	
	exportXLAdmissionSummaryReport : function(){
		var $this=this;
		var admissionSummaryFilter = this.getAdmissionsummaryfilter();
		var formValues = admissionSummaryFilter.getValues();
		var code = 'VelocityAdmissionSummaryReport_Excel';
		var reportParams =new Object();
		reportParams.academyLocationIds = $this.getAcademyLocationIds(),
		reportParams.intakeYearId=formValues.intakeYear;
		reportParams.programGroupId=formValues.programGroup;
		reportParams.programCategoryId=formValues.programCategory;
		reportParams.fromDate=formValues.fromDate;
		reportParams.toDate=formValues.toDate;
		//reportParams.academyLocationId=this.getCurrentAcademyLocation()
		reportParams.headerName = getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_ADMISSIONS_DATE');
		var reportTitle="AdmissionSummaryReport_Excel";
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.EXPORT_XL_ADMISSION_SUMMARY_REPORT);
	},
	   
	exportPDFAdmissionSummaryReport : function(){
		var $this=this;
		var admissionSummaryFilter = this.getAdmissionsummaryfilter();
		var formValues = admissionSummaryFilter.getValues();
		var code = 'VelocityAdmissionSummaryReport';
		var reportParams =new Object();
		reportParams.academyLocationIds = $this.getAcademyLocationIds();
		reportParams.intakeYearId=formValues.intakeYear;
		reportParams.programGroupId=formValues.programGroup;
		reportParams.programCategoryId=formValues.programCategory;
		reportParams.fromDate=formValues.fromDate;
		reportParams.toDate=formValues.toDate;
		//reportParams.academyLocationId=this.getCurrentAcademyLocation()
		reportParams.headerName = getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_ADMISSIONS_DATE');
		var reportTitle="AdmissionSummaryReport";
		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.EXPORT_PDF_ADMISSION_SUMMARY_REPORT);
	},
	   
	loadAdmissionSummary:function(){
	   var $this=this;
       var organizationForm=this.getOrganizationunit().getForm();
   	   var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
   	   if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
   		var admissionSummaryFilter = this.getAdmissionsummaryfilter();
		var formValues = admissionSummaryFilter.getValues();
		var grid = $this.getAdmissionsummarygrid();
		var buttonsToolBar = grid.query('toolbar')[0];
        var pdftoolbar = buttonsToolBar.query('#btnExportToPDFJasper')[0];
        var exceltoolbar = buttonsToolBar.query('#btnExportToExcelJasper')[0];
		var store =  grid.getStore();
		var startDate=null;
		var endDate=null;
		if(!isNullOrEmpty(formValues.fromDate)){
			startDate=Ext.Date.format(new Date(formValues.fromDate),'Y-m-d');
		}
		if(!isNullOrEmpty(formValues.toDate)){
			endDate=Ext.Date.format(new Date(formValues.toDate),'Y-m-d');
		}
		
		var seatTypeIdsValue = [];
		var seatTypeIds = formValues.seatType;
		if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
		 	var seatTypeIdsArray=[];
			for(var i in seatTypeIds) {
		 		if(typeof seatTypeIds[i] == "object") {
				seatTypeIdsArray.push(seatTypeIds[i].data.id);
		 		} else {
				seatTypeIdsArray.push(seatTypeIds[i]);
			}
		}
		var seatTypeIdsString = seatTypeIdsArray.join(",");
		seatTypeIdsString = seatTypeIdsString.toString();
		}
		store.getProxy().extraParams = {
			academyLocationIds : $this.getAcademyLocationIds(),
			intakeYearId:formValues.intakeYear,
			programGroupId:formValues.programGroup,
			programCategoryId:formValues.programCategory,
			startDate:formValues.fromDate,
			endDate:formValues.toDate,
			seatTypeIds:seatTypeIdsString
		};
		store.removeAll();
		store.load(  {
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 				    	pdftoolbar.setDisabled(false);
						    	exceltoolbar.setDisabled(false);
	 					}
						  }
	 				});
		
		 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
	   	
    	grid.config.searchFilterForm = $this.getAdmissionsummarygrid();
     /***************End Code added for show filter data on PDF/Excel Export Report **************/ 
		//grid.down('#btnExportToPDFJasper').setDisabled(false);
		//grid.down('#btnExportToExcelJasper').setDisabled(false);
   	  	}else{
			showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
   	 	}		
	},
	
	exportXLApplicationSummaryReport : function(){
		var $this=this;
		var applicationSummaryFilter = this.getApplicationsummaryfilter();
		var formValues = applicationSummaryFilter.getValues();
		var code = 'VelocityApplicationSummaryReport_Excel';
		var reportParams =new Object();
		reportParams.academyLocationIds = $this.getAcademyLocationIds(),
		reportParams.intakeYearId=formValues.intakeYear;
		reportParams.programGroupId=formValues.programGroup;
		reportParams.programCategoryId=formValues.programCategory;
		reportParams.fromDate=formValues.fromDate;
		reportParams.toDate=formValues.toDate;
		//reportParams.academyLocationId=this.getCurrentAcademyLocation()
		reportParams.headerName = getAdmissionTranslation('ADDMISSION_DASHBOARD_APPLICATION_SUMMARY');
		var reportTitle="ApplicationSummaryReport_Excel";
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.EXPORT_XL_APPLICATION_SUMMARY_REPORT);
	},
	   
	exportPDFApplicationSummaryReport : function(){
		var $this=this;
		var applicationSummaryFilter = this.getApplicationsummaryfilter();
		var formValues = applicationSummaryFilter.getValues();
		var code = 'VelocityApplicationSummaryReport';
		var reportParams =new Object();
		reportParams.academyLocationIds = $this.getAcademyLocationIds(),
		reportParams.intakeYearId=formValues.intakeYear;
		reportParams.programGroupId=formValues.programGroup;
		reportParams.programCategoryId=formValues.programCategory;
		reportParams.fromDate=formValues.fromDate;
		reportParams.toDate=formValues.toDate;
		//reportParams.academyLocationId=this.getCurrentAcademyLocation()
		reportParams.headerName = getAdmissionTranslation('ADDMISSION_DASHBOARD_APPLICATION_SUMMARY');
		var reportTitle="ApplicationSummaryReport";
		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.EXPORT_PDF_APPLICATION_SUMMARY_REPORT);
	},
	   
	loadApplicationSummary:function(){
	  var $this=this;
	  var organizationForm=this.getOrganizationunit().getForm();
   	  var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
   	  if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
  		var applicationSummaryFilter = this.getApplicationsummaryfilter();
		var formValues = applicationSummaryFilter.getValues();
		var grid = $this.getApplicationsummarygrid();
		 var buttonsToolBar = grid.query('toolbar')[0];
         var pdftoolbarapplicationsummary = buttonsToolBar.query('#btnExportToPDFJasper')[0];
         var exceltoolbarapplicationsummary  = buttonsToolBar.query('#btnExportToExcelJasper')[0];
		var store =  grid.getStore();
		var startDate=null;
		var endDate=null;
		if(!isNullOrEmpty(formValues.fromDate)){
			startDate=Ext.Date.format(new Date(formValues.fromDate),'Y-m-d');
		}
		if(!isNullOrEmpty(formValues.toDate)){
			endDate=Ext.Date.format(new Date(formValues.toDate),'Y-m-d');
		}
		var seatTypeIdsValue = [];
		var seatTypeIds = formValues.seatType;
        if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
        	var seatTypeIdsArray=[];
        	for(var i in seatTypeIds) {
        		if(typeof seatTypeIds[i] == "object") {
        			seatTypeIdsArray.push(seatTypeIds[i].data.id);
        		} else {
        			seatTypeIdsArray.push(seatTypeIds[i]);
        		}
        	}
        	var seatTypeIdsString = seatTypeIdsArray.join(",");
        	seatTypeIdsString = seatTypeIdsString.toString();
        }
		store.getProxy().extraParams = {
			academyLocationIds : $this.getAcademyLocationIds(),
			intakeYearId:formValues.intakeYear,
			programGroupId:formValues.programGroup,
			programCategoryId:formValues.programCategory,
			startDate:formValues.fromDate,
			endDate:formValues.toDate,
			seatTypeIds:seatTypeIdsString
		};
		store.removeAll();
		store.load({
	    	  callback: function(records, operation, success) {
	 				if(records.length>0){
	 					pdftoolbarapplicationsummary.setDisabled(false);
	 					exceltoolbarapplicationsummary.setDisabled(false);
	 					}
				     }
	 		});
		
		 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
	   	
    		grid.config.searchFilterForm = $this.getApplicationsummaryfilter();
   
    	/***************End Code added for show ilter data on PDF/Excel Export Report **************/     
		//grid.down('#btnExportToPDFJasper').setDisabled(false);
		//grid.down('#btnExportToExcelJasper').setDisabled(false);
   	  }else{
   				showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
   	  }
	},
	
	disableMoreActionPivileges: function(gridReference,permissionsMap) {
		var $this = this;
		var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var admissionDashboardStructure = $this.getAdmissionDashboardView();
    	/*var approveButton=grid.down('#approveLinked');
    	var editButton=grid.down('#btnAdd');
    	editButton.setVisible(false);
    	approveButton.setVisible(false);
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
    	//splitbuttons.setVisible(false);
    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
    		menuItems.setVisible(false);
    	});
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'MOREACTION') {
    			var button = buttonsToolBar.query('#spBtnMoreActions')[0];
    			if(!isNullOrEmpty(button)){
    				button.setVisible(true);
    			}        		
    		}
    		if (privilege === 'APPROVE') {
    			//var button = buttonsToolBar.query('#approveLinked')[0];
    			if(!isNullOrEmpty(approveButton)){
    				approveButton.setVisible(true);
    			}        		
    		}
    		if (privilege === 'UPDATE') {
    			if(!isNullOrEmpty(editButton)){
    				editButton.setVisible(true);
    			}        		
    		}
    	});*/
    	
    },
    loadApplicationCommentsGrid:function(){
    	var $this=this;
    	var orgUinitIds = $this.getAdmissionDashboardOrganizationUnit();
    	if(!isNullOrEmpty(orgUinitIds.getValues().multiselectAcademyLocation[0]))
    	{
    		var store = this.getApplicationcommentsgrid().getStore();
    		var values = this.getApplicationCommentsFilter().getForm().getValues();
    		
    		var seatTypeIds = values.seatType;
    		var seatTypeIdsValue = [];
    		if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
    		   var seatTypeIdsArray=[];
    		   for(var i in seatTypeIds) {
    		  	if(typeof seatTypeIds[i] == "object") {
    		  		seatTypeIdsArray.push(seatTypeIds[i].data.id);
    			} else {
    				seatTypeIdsArray.push(seatTypeIds[i]);
    			}
    		   }
    		  var seatTypeIdsString = seatTypeIdsArray.join();
    		  seatTypeIdsString = seatTypeIdsString.toString();
    	   }
    		store.getProxy().extraParams = {
    			academyLocationIds : $this.getAcademyLocationIds(),
    			intakeYearId : values.intakeYear,
    			programId : values.program,
    			batchId : values.batch,
    			applicationId : values.applicantStudentNameSearch,
    			fromDate : values.fromDate,
    			toDate : values.toDate,
    			seatTypeIds : seatTypeIdsString
    		}
    		this.resetPageSetting(store);
    		store.load();
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
    	}

    },
    loadAdmissionDtefDashboardGrid:function(){
    	var form = this.getDtefdashboardview();
    	var AlId = form.down('#academyLocationId');
    	var alValue = AlId.getValue();
    	var $this=this;
    		
    	var store = this.getDtefadmissiongrid().getStore();
    	var values = this.getDtefadmissionfilter().getForm().getValues();
    		
    	var alIdArr=[];
		var alIds = null;
		if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
			for (var i in alValue) {
				if (Ext.isObject(alValue[0])) {
					alIdArr.push(alValue[i].get("id"));
				} else {
					alIdArr.push(alValue[i]);
				}
			}
			alIds = alIdArr.join();
		}
		else if(!isNullOrEmpty(alValue)){
			alIds = alValue;
		}
		if(isNullOrEmpty(alIds)) {
			alIds = this.getCurrentAcademyLocation();
		}
    	store.getProxy().extraParams = {
    		academyLocationIds : alIds,
    		program : values.program,
    		batchId : values.batch,
    		fromDate : values.fromDate,
    		toDate : values.toDate,
    		applicationStatus : values.applicationstatus,
    		response : values.response,
    		responseStatus : values.responseStatus,
    		programGroup : values.programGroup,
    		seatType : values.seatType,
    		intakeYearId:values.intakeYear,
    		nationalId:values.nationalId
    	}
    	this.resetPageSetting(store);
    	store.load();
    	this.getDtefadmissiongrid().config.searchFilterForm = this.getDtefadmissionfilter();
    },
    
    /**
     * load course enrollment grid
     */
    loadCourseEnrollmentDtefDashboardGrid:function(){
    	var form = this.getDtefdashboardview();
    	var AlId = form.down('#academyLocationId');
    	var alValue = AlId.getValue();
    	var $this=this;
    		
    	var store = this.getDtefcourseenrollmentgrid().getStore();
    	var values = this.getDtefcourseenrollmentfilter().getForm().getValues();
    		
    	var alIdArr=[];
		var alIds = null;
		if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
			for (var i in alValue) {
				if (Ext.isObject(alValue[0])) {
					alIdArr.push(alValue[i].get("id"));
				} else {
					alIdArr.push(alValue[i]);
				}
			}
			alIds = alIdArr.join();
		}
		else if(!isNullOrEmpty(alValue)){
			alIds = alValue;
		}
		if(isNullOrEmpty(alIds)) {
			alIds = this.getCurrentAcademyLocation();
		}
    	store.getProxy().extraParams = {
    		academyLocationIds : alIds,
    		programId : values.program,
    		batchId : values.batch,
    		periodId: values.periodId,
    		fromDate : values.fromDate,
    		toDate : values.toDate,
    		admissionStatus : values.admissionstatus,
    		response : values.response,
    		responseStatus : values.responseStatus,
    		admissionId:values.studentNameSearch,
    		intakeYearId:values.intakeYear
    	}
    	this.resetPageSetting(store);
    	store.load();
    	this.getDtefcourseenrollmentgrid().config.searchFilterForm = this.getDtefcourseenrollmentfilter();
    },
    /**
     * load application statistics graph store
     */
    loadApplicationStatisticsChart: function() {
        var this$ = this;
        var applicationStatisticsView = this$.getApplicationstatisticsview();
        var organizationForm=this$.getOrganizationunit().getForm();
  	    var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
  	    if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
  	        var applicationStatisticsSearchForm = this$.getApplicationStatisticsSearchForm();
  	        var applicationShowStatisticsForPieChart = this$.getApplicationShowStatisticsForPieChart();
  	        var applicationShowStatisticsForBarchartreport = this$.getApplicationShowStatisticsForBarchartreport();
  	        var applicationStatisticsCombo = applicationStatisticsSearchForm.down('#applicationStatistics');
  	        var formValues = this$.createSeachCriteriaApplicationStatisticsJsonFormat(
  	        applicationStatisticsSearchForm,
  	        applicationStatisticsCombo);
  	        var value = applicationStatisticsCombo.getValue();
  	        var urlValue = SERVERURL.PATH_FIND_APPLICATION_STATISTICS;
	        
			var applicationstaticsgrid = applicationStatisticsView.down('#applicationstaticsgrid');
			var columnchartapplicationstatisticsreport = applicationStatisticsView.down('columnchartapplicationstatisticsreport');
			var barchartreport = applicationStatisticsView.down('barchartreport');
			var buttonsToolBar = applicationstaticsgrid.query('toolbar')[0];
			var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
			var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
			var pdftoolbarmenu = pdftoolbar.menu.items.items[1];
			var exceltoolbarmenu = exceltoolbar.menu.items.items[1];
			pdftoolbarmenu.setVisible(false);
			exceltoolbarmenu.setVisible(false);
			switch (value) {
			case 'PROGRAM_PREFERENCE':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('PROGRAM_PREFERENCE'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('PROGRAM_PREFERENCE');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('PROGRAM_PREFERENCE')+' List');
				break;
			case 'COUNTRY_REGION_WISE':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('COUNTRY_REGION_WISE'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('COUNTRY_REGION_WISE');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('COUNTRY_REGION_WISE')+' List');
				break;
			case 'GENDER':
				applicationstaticsgrid.columnManager.columns[0].setText(getCommonTranslation('GENDER'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getCommonTranslation('GENDER');
				applicationstaticsgrid.setTitle(getCommonTranslation('GENDER')+' List');
				break;
			case 'COMPETITIVE_EXAM':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('COMPETITIVE_EXAM'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('COMPETITIVE_EXAM');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('COMPETITIVE_EXAM')+' List');
				break;
			case 'WORK_EXPERIENCE':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('DESIGNATION'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('DESIGNATION');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('WORK_EXPERIENCE')+' List');
				break;
			case 'EXAM_PASSED':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('EXAM_PASSED_APPLICATION_STATISTICS'));
				barchartreport.axes.items[0].title =getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				barchartreport.axes.items[1].title =getAdmissionTranslation('EXAM_PASSED_APPLICATION_STATISTICS');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('EXAM_PASSED_APPLICATION_STATISTICS')+' List');
				break;
			case 'COMPETITIVE_EXAM_PERCENTAGE':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('PERCENTAGE_RANGE'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('PERCENTAGE_RANGE');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('COMPETITIVE_EXAM_PERCENTAGE_LIST'));
				break;
			case 'INTERVIEW_LOCATION':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('INTERVIEW_LOCATION'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('INTERVIEW_LOCATION');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('INTERVIEW_LOCATION_LIST'));
				break;
			case 'SOURCE_FROM_WHICH_TSM':
				applicationstaticsgrid.columnManager.columns[0].setText(getAdmissionTranslation('SOURCE_FROM_WHICH_TSM'));
				columnchartapplicationstatisticsreport.axes.items[0].title = getAdmissionTranslation('COUNT_OF_APPLICATIONS');
				columnchartapplicationstatisticsreport.axes.items[1].title = getAdmissionTranslation('SOURCE_FROM_WHICH_TSM');
				applicationstaticsgrid.setTitle(getAdmissionTranslation('SOURCE_FROM_WHICH_TSM_LIST'));
				break;
  	        }
	        var academicExport = applicationStatisticsView.down('#academyExtraBtns');
	        applicationShowStatisticsForPieChart.hide();
	        applicationShowStatisticsForBarchartreport.hide();
	        applicationShowStatisticsForBarchartreport.nextSibling().setVisible(false);
	        applicationShowStatisticsForPieChart.nextSibling().nextSibling().setVisible(false);
  	 
  	        Ext.Ajax.request({
  	            type: 'rest',
  	            url: urlValue,
  	            method: 'POST',
  	            headers: {
  	                'Content-Type': 'application/json'
  	            },
  	            jsonData: formValues,
  	            success: function(response) {
  	            	if (!isNullOrEmpty(response.responseText)) {
  	            		var data = Ext.decode(response.responseText);
  	            		if(response.request.options.jsonData.applicationType=="EXAM_PASSED")
  	            			{	
  	            			this$.loadApplicationChartDisableOnSelection(data,applicationShowStatisticsForBarchartreport);
  	  	            		this$.addExportToPngForApplicationStatistics(academicExport.menu,applicationShowStatisticsForBarchartreport);
  	            			}
  	            		else
  	            			{
  	            			this$.loadApplicationChartDisableOnSelection(data,applicationShowStatisticsForPieChart);
  	  	            		this$.addExportToPngForApplicationStatistics(academicExport.menu,applicationShowStatisticsForPieChart);
  	            			}
  	            		if(data.length > 0){
  	            		   academicExport.setVisible(true);
  	            			buttonsToolBar.query('#btnExportToPDF')[0].setDisabled(false);
  	            			buttonsToolBar.query('#btnExportToExcel')[0].setDisabled(false);
  	            		}else{
  	            			academicExport.setVisible(false);
  	            			buttonsToolBar.query('#btnExportToPDF')[0].setDisabled(true);
  	            			buttonsToolBar.query('#btnExportToExcel')[0].setDisabled(true);
  	            		}
  	            	}
  	            }
  	        });
  	      /***************Start Code added for show filter data on PDF/Excel Export Report **************/
  	      applicationstaticsgrid.config.searchFilterForm = applicationStatisticsView.down('form');
  	     /***************End Code added for show filter data on PDF/Excel Export Report **************/    
  	    }else{
			showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
   	    }
    },
    /**
     * Create dashboard search criteria json
     * 
     * @params searchCriteriaForm
     */
    createSeachCriteriaApplicationStatisticsJsonFormat: function(
							    searchCriteriaForm, combo) {
						var formValues = null;
						var $this = this;
						if (searchCriteriaForm) {
							formValues = searchCriteriaForm.getValues();
							var academyLocationIds = this
									.getAcademyLocationIds();
							if (!isNullOrEmpty(academyLocationIds)) {
								academyLocationIds = academyLocationIds
										.toString();
								var commaIndex = academyLocationIds
										.indexOf(",");
								if (commaIndex != -1) {
									var academyLocationArray = academyLocationIds
											.split(",");
									formValues.academyLocationIds = academyLocationArray;
								} else {
									formValues.academyLocationIds = [ academyLocationIds ];
								}

							}
							 var seatTypeIds = formValues.seatType;
					            if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
					            	var seatTypeIdsArray=[];
					            	for(var i in seatTypeIds) {
					            		if(typeof seatTypeIds[i] == "object") {
					            			seatTypeIdsArray.push(seatTypeIds[i].data.id);
					            		} else {
					            			seatTypeIdsArray.push(seatTypeIds[i]);
					            		}
					            	}
					            	var seatTypeIdsString = seatTypeIdsArray.join();
					            	seatTypeIdsString = seatTypeIdsString.toString();
					            	var seatTypeCommaIndex = seatTypeIdsString.indexOf(",");
					            	if (seatTypeCommaIndex != -1) {
					            		var seatTypeIdsArray = seatTypeIdsString.split(",");
					            		formValues.seatTypeIds = seatTypeIdsArray;
					            	} else {
					            		formValues.seatTypeIds = [seatTypeIdsString];
					            	}
					            }
							var academicTerm = formValues.academicTerm;
							var applicationType = formValues.applicationStatistics;
							var startDate = formValues.startDate;
							var intakeYear = formValues.intakeYear;
							var endDate = formValues.endDate;
							var academyLocationIds = formValues.academyLocationIds;
							var applicationStatisticsView = this.getApplicationstatisticsview();
							var nameOfExam = formValues.nameOfExam;
							var applicationstaticsgrid = applicationStatisticsView.down('#applicationstaticsgrid');
							
							 var seatTypeIds = formValues.seatType;
					            if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
					            	var seatTypeIdsArray=[];
					            	for(var i in seatTypeIds) {
					            		if(typeof seatTypeIds[i] == "object") {
					            			seatTypeIdsArray.push(seatTypeIds[i].data.id);
					            		} else {
					            			seatTypeIdsArray.push(seatTypeIds[i]);
					            		}
					            	}
					            	var seatTypeIdsString = seatTypeIdsArray.join();
					            	seatTypeIdsString = seatTypeIdsString.toString();
					            	var seatTypeCommaIndex = seatTypeIdsString.indexOf(",");
					            	if (seatTypeCommaIndex != -1) {
					            		var seatTypeIdsArray = seatTypeIdsString.split(",");
					            		formValues.seatTypeIds = seatTypeIdsArray;
					            	} else {
					            		formValues.seatTypeIds = [seatTypeIdsString];
					            	}
					            }
							
							applicationstaticsgrid.getStore().getProxy().extraParams = {
								academicTerm : academicTerm,
								applicationType : applicationType,
								startDate : startDate,
								intakeYear : intakeYear,
								seatTypeIds:formValues.seatTypeIds,
								endDate : endDate,
								academyLocationIds : academyLocationIds,
								
								nameOfExam:nameOfExam,
								sort:null
							}
							applicationstaticsgrid.getStore().load({
								  callback: function(record, operation, success) {
									  if (record.length > 0) {
										  //buttonsToolBar2.query('#configurefeeheadsequenceLink')[0].setDisabled(false);
										  $this.toggleGridSummaryRow(applicationstaticsgrid,true);
									  }else{
										  //buttonsToolBar2.query('#configurefeeheadsequenceLink')[0].setDisabled(true);
										  $this.toggleGridSummaryRow(applicationstaticsgrid,false);
									  }
								  }
							  });
					        //this.toggleGridSummaryRow(grid,false);

							var obj = this.getOrganizationUnitIds();
							if (obj.ou) {
								formValues.ou = obj.ou;
							} else if (obj.mau) {
								formValues.mau = obj.mau;
							}
							if (!isNullOrEmpty(combo)) {
								var value = combo.getValue();
								if (value == 'PROGRAM_PREFERENCE')
									formValues.applicationType = 'PROGRAM_PREFERENCE';
								if (value == 'COUNTRY_REGION_WISE')
									formValues.applicationType = 'COUNTRY_REGION_WISE';
								if (value == 'GENDER')
									formValues.applicationType = 'GENDER';
								if (value == 'COMPETITIVE_EXAM')
									formValues.applicationType = 'COMPETITIVE_EXAM';
								if (value == 'WORK_EXPERIENCE')
									formValues.applicationType = 'WORK_EXPERIENCE';
								if (value == 'EXAM_PASSED')
									formValues.applicationType = 'EXAM_PASSED';
								if(value == 'COMPETITIVE_EXAM_PERCENTAGE')
									formValues.applicationType = 'COMPETITIVE_EXAM_PERCENTAGE';
								if(value == 'INTERVIEW_LOCATION')
									formValues.applicationType = 'INTERVIEW_LOCATION';
								if(value == 'SOURCE_FROM_WHICH_TSM')
									formValues.applicationType = 'SOURCE_FROM_WHICH_TSM';
							}
						}
						delete formValues.applicationStatistics;
						delete formValues.multiselectAcademyLocation;
						delete formValues.organizationRadioUnit;
						delete formValues.seatType;
						return formValues;
					},
					toggleGridSummaryRow : function(grid,isVisible){
						var view = grid.getView();
						view.getFeature(0).toggleSummaryRow(isVisible);
						view.refresh();
					},
					clearApplicantStatisticsForm : function(button) {
						var form = button.up('form');
						if (form) {
							var basicForm = form.getForm();
							basicForm.getFields().each(function(field) {
								field.reset();
							});
							form.down('#nameOfExam').setVisible(false);
							var startDate = basicForm.getFields().items[4];
							var endDate = basicForm.getFields().items[5];
							startDate.setMinValue(false);
							startDate.setMaxValue(false);
							endDate.setMinValue(false);
							endDate.setMaxValue(false);
						}
					},
					doAccessAdmissionDashBoardReportTreePanel: function(structure) {
    			    	var treePanel = structure;
    			    	var treePnlRootNode = treePanel.getRootNode();
    			    	/*Removed OKR-2214*///this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getADMISSION_STATISTICS_PERMISSIONS(), "ADMISSION_STATISTICS_REPORT"); 
    			    	/*Removed OKR-2214*///this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getAPPLICATION_STATISTICS_PERMISSIONS(), "APPLICATION_STATISTICS_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getADMISSION_REJECTION_ANALYSIS_PERMISSIONS(), "ADMISSION_REJECTION_ANALYSIS_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getSELECTION_PROCESS_OVERVIEW_PERMISSIONS(), "SELECTION_PROCESS_OVERVIEW_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getAPPLICATION_SUMMARY_PERMISSIONS(), "APPLICATION_SUMMARY_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getADMISSION_SUMMARY_PERMISSIONS(), "ADMISSION_SUMMARY_BY_DATE_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getADMISSION_SUMMARY_BYAPPROVEDATE_PERMISSIONS(), "ADMISSION_SUMMARY_BYAPPROVE_DATE_REPORT");
    			    	this.checkPermissionAndRemoveFeeReportTreePnl(treePnlRootNode,this.getAPPLICATION_COMMENTS_PERMISSIONS(), "APPLICATION_COMMENTS_REPORT");
    			    },
    			    checkPermissionAndRemoveFeeReportTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
    			    	var associatedAcadLocationIds = new Array();
    			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    			    	var constView = 'VIEW';
    			    	if(!isNullOrEmpty(permissionList)){
    			    		if(!Ext.Array.contains(permissionList, constView)) {							
    			    			var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
    			    			if(!isNullOrEmpty(vacantNode)){
    			    				vacantNode.remove(); 
    			    			}
    			    		} 
    			    	}
    			    },
    			    checkPermissionAndRemoveDTEFReportTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
    			    	var associatedAcadLocationIds = new Array();
    			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    			    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    			    	var constView = permissionKey;
    			    	if(!isNullOrEmpty(permissionList)){
    			    		if(!Ext.Array.contains(permissionList, constView)) {	
    			    			var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
    			    			if(!isNullOrEmpty(vacantNode)){
    			    				vacantNode.remove(); 
    			    			}
    			    		}
    			    	}
    			    },
    			    
    			    
    			    sendToDtefPivileges: function(grid,permissionMap){

				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
						var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
				    	
						var sendToDtef = grid.down('#sendToDTEFBtn');
						sendToDtef.setVisible(false);
				    	
				    	Ext.each(permissionList, function(privilege) {
				    		
				    		if (privilege === 'DTEF_DASHBOARD_SEND_TO_DTEF') {
				        		if(!isNullOrEmpty(sendToDtef)){
				        			sendToDtef.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'DTEF_COURSE_ENROLLMENT_SEND_TO_DTEF') {
				        		if(!isNullOrEmpty(sendToDtef)){
				        			sendToDtef.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'DTEF_MODULE_RESULTS_SEND_TO_DTEF') {
				        		if(!isNullOrEmpty(sendToDtef)){
				        			sendToDtef.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'DTEF_INVOICES_SEND_TO_DTEF') {
				        		if(!isNullOrEmpty(sendToDtef)){
				        			sendToDtef.setVisible(true);
				        		}        		
				        	}
				    	});
    			    },
    			    
					addExportToPngForApplicationStatistics:function(panel,chart){
						var $this = this;
				    	var exportToPNG={
				    			 text: getAdmissionTranslation('EXPORT_TO_PNG'),
						         itemId :'exportToPng',
						         handler: function(btn, target, header, tool){
						        	 var customWidth = 30;
						        	 var title = 'Statistics By '+chart.axes.items[1].title;
						        	 var surface = chart.surface;
						        	 var svg = Ext.draw.engine.SvgExporter.generate(surface);
						        	 var canvas = document.createElement('canvas');
						        	 var context = canvas.getContext("2d");
						        	 canvas.height = surface.height + 100;
				      				 canvas.width = surface.width+200;
				      				 var x = canvas.width / 10;
				      				 
						        	 context.font = "18px Georgia";
						        	 context.textAlign = 'bottom';
						             context.fillText(title, x, 20);
				                     context.fillStyle = "#FFFFFF";
				                     context.fillRect(0,30,surface.width+100,surface.height + 100);
						             context.drawSvg(svg,customWidth,30);
						        	 var dataURL = canvas.toDataURL('image/png',1.0);
						        	 downloadImage(dataURL,'chart.png');
						         }
					     };
				    	if(!Ext.isDefined(panel.items.items[0])){
				    	    panel.add(exportToPNG);
				    	    }
					},
					exportXLAdmissionSummaryApprovedReport : function(){
						var $this=this;
						var admissionSummaryapprovedFilter = this.getAdmissionsummaryapprovedfilter();
						var formValues = admissionSummaryapprovedFilter.getValues();
						var code = 'VelocityAdmissionSummaryReport_Excel';
						var reportParams =new Object();
						reportParams.academyLocationIds = $this.getAcademyLocationIds(),
						reportParams.intakeYearId=formValues.intakeYear;
						reportParams.programGroupId=formValues.programGroup;
						reportParams.programCategoryId=formValues.programCategory;
						reportParams.fromDate=formValues.fromDate;
						reportParams.toDate=formValues.toDate;
						reportParams.isApprovalDate=true;
						reportParams.headerName = getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_ADMISSIONS_DATE');
						var reportTitle="AdmissionSummaryReport_Excel";
						this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.EXPORT_XL_ADMISSION_SUMMARY_REPORT);
					},
					   
					exportPDFAdmissionSummaryApprovedReport : function(){
						var $this=this;
						var admissionSummaryapprovedFilter = this.getAdmissionsummaryapprovedfilter();
						var formValues = admissionSummaryapprovedFilter.getValues();
						var code = 'VelocityAdmissionSummaryReport';
						var reportParams =new Object();
						reportParams.academyLocationIds = $this.getAcademyLocationIds();
						reportParams.intakeYearId=formValues.intakeYear;
						reportParams.programGroupId=formValues.programGroup;
						reportParams.programCategoryId=formValues.programCategory;
						reportParams.fromDate=formValues.fromDate;
						reportParams.toDate=formValues.toDate;
						reportParams.isApprovalDate=true;
						reportParams.headerName = getAdmissionTranslation('ADMISSIONS_SUMMARY_BY_ADMISSIONS_DATE');
						var reportTitle="AdmissionSummaryReport";
						this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.EXPORT_PDF_ADMISSION_SUMMARY_REPORT);
					},
					openDTEFFilterAndGrid : function(treePanel, record, item, index, e, eOpts){
					   	 var $this = this;
					   	 var reportstructure = $this.getDtefdashboardview();
					   	 var treeTab = reportstructure.down('#admissionDtefReportTreePanelItemId');
					   	 var tabStructure =  reportstructure.down('admissiondtefreporttabpanel');
					   	 var tabDetail = record.data;
					   	 var structure = Ext.widget(tabDetail.reportXtype);
					   	 var tabs = tabStructure.items.items;

					   	 if (!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype)
					   			 && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
					   		 treeTab.toggleCollapse();
					   		 openTab(tabStructure, tabDetail.text, structure);
					   		 treePanel.getSelectionModel().deselectAll();
					   	 }
					   	var admissionFilter= $this.getDtefadmissionfilter(); 
					   	if(admissionFilter) {
					   		var programGrp= admissionFilter.down('#programGroupItemId');
					   		var alId=reportstructure.down('#academyLocationId').getValue();
					   		programGrp.getStore().getProxy().extraParams={
					   			academyLocationIds : alId
					   		};
					   		programGrp.getStore().load();
					   	}
					},
					loadAdmissionSummaryApprovedByDate:function(){
						   var $this=this;
					       var organizationForm=this.getOrganizationunit().getForm();
					   	   var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation');
					   	   if(multiselectAcademyLocation.getValue() != undefined && multiselectAcademyLocation.getValue() != ""){
					   		var admissionSummaryapprovedFilter = this.getAdmissionsummaryapprovedfilter();
							var formValues = admissionSummaryapprovedFilter.getValues();
							var grid = $this.getAdmissionsummaryapprovedgrid();
							var buttonsToolBar = grid.query('toolbar')[0];
					        var pdftoolbar = buttonsToolBar.query('#btnExportToPDFJasper')[0];
					        var exceltoolbar = buttonsToolBar.query('#btnExportToExcelJasper')[0];
							var store =  grid.getStore();
							var startDate=null;
							var endDate=null;
							if(!isNullOrEmpty(formValues.fromDate)){
								startDate=Ext.Date.format(new Date(formValues.fromDate),'Y-m-d');
							}
							if(!isNullOrEmpty(formValues.toDate)){
								endDate=Ext.Date.format(new Date(formValues.toDate),'Y-m-d');
							}
							
							var seatTypeIdsValue = [];
							var seatTypeIds = formValues.seatType;
							if (!isNullOrEmpty(seatTypeIds) && !isNullOrEmpty(seatTypeIds[0])) {
							 	var seatTypeIdsArray=[];
								for(var i in seatTypeIds) {
							 		if(typeof seatTypeIds[i] == "object") {
									seatTypeIdsArray.push(seatTypeIds[i].data.id);
							 		} else {
									seatTypeIdsArray.push(seatTypeIds[i]);
								}
							}
							var seatTypeIdsString = seatTypeIdsArray.join(",");
							seatTypeIdsString = seatTypeIdsString.toString();
							}
							store.getProxy().extraParams = {
								academyLocationIds : $this.getAcademyLocationIds(),
								intakeYearId:formValues.intakeYear,
								programGroupId:formValues.programGroup,
								programCategoryId:formValues.programCategory,
								startDate:formValues.fromDate,
								endDate:formValues.toDate,								
								seatTypeIds:seatTypeIdsString,
								isApproval:true
							};
							store.removeAll();
							store.load(  {
						    	  callback: function(records, operation, success) {
						 				if(records.length>0){
						 				    	pdftoolbar.setDisabled(false);
											    	exceltoolbar.setDisabled(false);
						 					}
											  }
						 				});
							
							 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
						   	
					    	grid.config.searchFilterForm = $this.getAdmissionsummaryapprovedgrid();
					     /***************End Code added for show filter data on PDF/Excel Export Report **************/ 
							//grid.down('#btnExportToPDFJasper').setDisabled(false);
							//grid.down('#btnExportToExcelJasper').setDisabled(false);
					   	  	}else{
								showWarningMessage(getCommonTranslation('ALERT'),getCampaignTranslation('SELECT_LOCATION_ALERT'));
					   	 	}		
						},
						
						resetDtefModuleResultsFilter: function (btn) {
					        var form = btn.up('form');
					        form.getForm().reset();

					        var store = form.down('#intakeYearModuleResults').getStore();
					        store.getProxy().extraParams = {};
					        store.load();
					        form.down('#batchIdModuleResults').setDisabled(true);
					        form.down('#periodIdModuleResults').setDisabled(true);

					        if (form.down('#toDateModuleResults')) {
					            form.down('#toDateModuleResults').setMinValue(false);
					        }
					        var programFld = form.down('#programIdModuleResults');
					        this.onModuleResultsProgramRender(programFld);
					        this.loadNationalIdStore();
					        this.loadStudentNameCombo();
					    },

					    onModuleResultsProgramRender: function (combo) {
					        var alIds = this.getAcademyLocationIdsForDtefDashboard();
					        combo.getStore().getProxy().extraParams = {
					            academyLocationIds: alIds
					        };
					        combo.getStore().load();
					        this.loadNationalIdStore();
					        this.loadStudentNameCombo();
					    },

					    onModuleResultsProgramSelect: function (combo, records, eOpts) {
					        var form = combo.up('form');
					        var batchComboField = form.down('#batchIdModuleResults');
					        var periodComboField = form.down('#periodIdModuleResults');
					        var alinfomodel = Academia.model.authentication.ALInfoModel;
					        var wheatherSchool = alinfomodel.get('wheatherSchool');
					        var programId = combo.getValue();
					        var intake = form.down('#intakeYearModuleResults');

					        batchComboField.clearValue();
					        periodComboField.clearValue();

					        var alIds = this.getAcademyLocationIdsForDtefDashboard();
					        var batchStore = batchComboField.getStore();
					        batchStore.getProxy().extraParams = {
					            academyLocationIds: alIds,
					            programIds: programId.toString()
					        };
					        batchComboField.setDisabled(false);
					        periodComboField.setDisabled(true);

					        batchStore.load({
					            callback: function (records, operation, success) {
					                if (success) {
					                    if (records.length == 1) {
					                        var batchId = records[0].get('id');
					                        batchComboField.setValue(batchId);
					                        periodComboField.setDisabled(false);
					                        intake.getStore().getProxy().extraParams = {
					                            batchId: batchId
					                        };
					                        intake.getStore().load();

					                        var periodStore = periodComboField.getStore();
					                        periodStore.getProxy().extraParams = {
					                            batchId: batchId
					                        };
					                        periodStore.load({
					                            callback: function (records, operation, success) {
					                                if (success) {
					                                    if (records.length == 0) {
					                                        if (wheatherSchool) {
					                                            showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
					                                        }
					                                    } else if (records.length == 1) {
					                                        if (wheatherSchool) {
					                                            periodComboField.setVisible(false);
					                                        }
					                                        periodComboField.setValue(records[0].get("id"));

					                                    } else {
					                                        periodComboField.setVisible(true);
					                                    }
					                                }
					                            }
					                        });
					                    }
					                }
					            }
					        });
					        form.isValid();
					        form.getForm().clearInvalid();
					        this.loadNationalIdStore();
					        this.loadStudentNameCombo();
					    },

					    onModuleResultsBatchSelect: function (combo, records, eOpts) {
					        var form = this.getDtefdashboardview();
					        var filterForm = combo.up('form');
					        var vals = filterForm.getValues();
					        var intake = filterForm.down('#intakeYearModuleResults');
					        var batchComboField = filterForm.down('#batchIdModuleResults');
					        var periodComboField = filterForm.down('#periodIdModuleResults');
					        var comboValue = combo.getValue();
					        var alinfomodel = Academia.model.authentication.ALInfoModel;
					        var wheatherSchool = alinfomodel.get('wheatherSchool');
					        intake.getStore().getProxy().extraParams = {
					            programId: vals.program,
					            batchId: comboValue,
					            academyLocationIds: this.getAcademyLocationIdsForDtefDashboard()
					        };
					        intake.getStore().load();
					        periodComboField.clearValue();
					        periodComboField.setDisabled(false);
					        var periodStore = periodComboField.getStore();
					        periodStore.getProxy().extraParams = {
					            batchId: comboValue
					        };

					        periodStore.load({
					            callback: function (rec, operation, success) {
					                if (success) {
					                    if (rec.length == 0) {
					                        if (wheatherSchool) {
					                            showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
					                        }
					                    } else if (rec.length == 1) {
					                        if (wheatherSchool) {
					                            periodComboField.setVisible(false);
					                        }
					                        periodComboField.setValue(rec[0].get("id"));

					                    } else {
					                        periodComboField.setVisible(true);
					                    }
					                }
					            }
					        });
					        form.isValid();
					        form.getForm().clearInvalid();
					        this.loadNationalIdStore();
					        this.loadStudentNameCombo();
					    },
					    
					    onModuleResultsPeriodSelect: function (combo, records, eOpts) {
					        var form = this.getDtefdashboardview();
					        var filterForm = combo.up('form');
					        var vals = filterForm.getValues();
					        var intake = filterForm.down('#intakeYearModuleResults');
					        var batchComboField = filterForm.down('#batchIdModuleResults');
					        intake.getStore().getProxy().extraParams = {
					            programId: vals.program,
					            batchId: vals.batch,
					            periodId: vals.periodId,
					            academyLocationIds: this.getAcademyLocationIdsForDtefDashboard()
					        };
					        intake.getStore().load();
					        this.loadNationalIdStore();
					        this.loadStudentNameCombo();
					    },

					    onModuleResultsGridRender: function (grid) {
					        this.doAccessControlValidation(grid, this.getDTEF_MODULE_RESULTS_PERMISSIONS());
					        this.sendToDtefPivileges(grid, this.getDTEF_MODULE_RESULTS_PERMISSIONS());
					    },

					    onModuleResultsGridCellClick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					        var $this = this;
					        var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					        if (columnName == 'wSCoursesModelExam' && record.data.wSCoursesModelExam.length > 0 && e.target.tagName == 'A') {
					        	var formWindow = Ext.create('Ext.window.Window', {
					        		modal : true,
					        		resizable:true,
					        		overflowY: 'auto',
					        		width: '60%',
					        		maxHeight: window.innerHeight - 250,
					        		frame: true,
					        		title: getCourseTxCommonTranslation('COURSE_DETAILS'),
					        		layout: 'vbox',
					        		items: [{
					        			xtype: 'grid',
					        			border: true,
					        			width: '100%',
					        			viewConfig : {
					        				stripeRows : CONSTANTS.STRIPEROWS
					        			},
					        			title:getCourseTxCommonTranslation('COURSE_DETAILS'),
					        			columns: [{
					        				header : getCommonTranslation('COURSE_CODE'),
					        				dataIndex : 'courseCode',
					        				flex: 0.5
					        			}, {
					        				header : getCommonTranslation('COURSE_NAME'),
					        				dataIndex : 'courseName',
					        				flex: 1
					        			}, {
					        				header : getCommonTranslation('RESULT'),
					        				dataIndex : 'periodResult',
					        				flex: 0.5
					        			}],
					        			store: Ext.create('Ext.data.Store', {
					        				fields: [
					        					'courseCode',
					        					'courseName',
					        					{
					        						name: 'periodResult',
					        						convert: function(val) {
					        							if(!isNullOrEmpty(val) && typeof val == 'string') {
					        								return val.charAt(0).toUpperCase() + val.slice(1).toLowerCase();
					        							}
					        							return val;
					        						}
					        					}
					        				],
					        				proxy: {
					        					type: 'rest',
					        					reader: {
					        						type: 'json',
					        						root: 'rows',
					        						totalProperty: 'records'
					        					}
					        				}
					        			})
					        		}]
					        	}).show();
					        	var grid = formWindow.down('grid');
					            var gridStore = grid.getStore();
					            gridStore.removeAll();
					            gridStore.add(record.data.wSCoursesModelExam);
					            formWindow.center();
					        }
					    },

					    onModuleResultsGridSelectionChange: function (column, selected, eOpts) {
					        var grid = this.getDtefModuleResultsGrid();
					        var selectionModel = grid.getSelectionModel().getSelection();
					        if (selectionModel.length == 0) {
					            grid.down('#sendToDTEFBtn').setDisabled(true);
					        } else {
					            grid.down('#sendToDTEFBtn').setDisabled(false);
					        }
					    },
					    searchDtefInvoiceFilter:function(){
					    	var $this = this;
					    	var form = this.getDtefinvoicesfilter();
					    	var response = form.down('#responseIdInvoices').getDisplayValue();
					    	var formValues = form.getValues();
					    	var grid = this.getDtefinvoicesgrid();
					    	var store =  grid.getStore();
					    	store.getProxy().extraParams = {
					    		academyLocationIds:this.getAcademyLocationIdsForDtefDashboard(),
					    		programId: formValues.program,
					    		batchId: formValues.batch,
					    		periodId: formValues.periodId,
					    		responseStatus: formValues.responseStatus,
					    		response: response,
					    		admissionStatus: formValues.admissionstatus,
					    		fromDate: formValues.fromDate,
					    		toDate: formValues.toDate,
					    		intakeYearId: formValues.intakeYear,
					    		admissionId: formValues.studentNameSearch,
					    		nationalId: formValues.nationalId,
					    		billType:formValues.billType
					    	};
					    	store.load();
					    },
					    getAcademyLocationIdsForDtefDashboard: function () {
					        var form = this.getDtefdashboardview();
					        var AlId = form.down('#academyLocationId');
					        var alValue = AlId.getValue();
					        var alIdArr = [];
					        var alIds = null;
					        if (!isNullOrEmpty(alValue) && alValue.length > 0 && !isNullOrEmpty(alValue[0])) {
					            for (var i in alValue) {
					                if (Ext.isObject(alValue[0])) {
					                    alIdArr.push(alValue[i].get("id"));
					                } else {
					                    alIdArr.push(alValue[i]);
					                }
					            }
					            alIds = alIdArr.join();
					        } else if (!isNullOrEmpty(alValue)) {
					            alIds = alValue;
					        }
					        if (isNullOrEmpty(alIds)) {
					            alIds = this.getCurrentAcademyLocation();
					        }
					        return alIds;
					    },
					    
					    loadNationalIdStore: function() {
					    	var filterForm = this.getDtefModuleResultsFilter();
					        var vals = filterForm.getValues();
					        var nationalId = filterForm.down('#nationalIdItemIdModuleResults');
					        var store = nationalId.getStore();
					        var alIds = this.getAcademyLocationIdsForDtefDashboard();
					        store.getProxy().extraParams = {
					        	programId: vals.program,
					        	batchId: vals.batch,
					        	periodId: vals.periodId,
					        	academyLocationIds: alIds
					        };
					        store.load();
					    },
					    
					    onModuleResultsAdmissionStatusSelect: function (combo, records, eOpts) {
					        this.loadStudentNameCombo();
					    },
					    
					    loadStudentNameCombo: function() {
					    	var form = this.getDtefdashboardview();
					        var filterForm = this.getDtefModuleResultsFilter();
					        var vals = filterForm.getValues();
					        var studentName = filterForm.down('#studentFieldItemIdModuleResults');
					        var store = studentName.getStore();
					        var alIds = this.getAcademyLocationIdsForDtefDashboard();
					        store.getProxy().extraParams = {
					        	programId: vals.program,
					        	batchId: vals.batch,
					        	periodId: vals.periodId,
					        	academyLocationIds: alIds,
					        	status: vals.admissionstatus
					        };
					        store.load();
					    },
					    
					    loadModuleResultsData: function(btn) {
					    	var form = btn.up('form');
					    	var vals = form.getValues();
					    	var grid = this.getDtefModuleResultsGrid();
							var todate;  
							if(!isNullOrEmpty(vals.toDate)&&vals.toDate!=null){   
							todate =vals.toDate+' 23:59:59';   	
							}
							var store = grid.getStore();
					    	store.getProxy().extraParams = {
								alIds: this.getAcademyLocationIdsForDtefDashboard(),
					    		programId: vals.program,
					        	batchId: vals.batch,
					        	periodId: vals.periodId,
					        	responceStatus: vals.responseStatus,
					        	responce: vals.response,
					        	admissionStatus: vals.admissionstatus,
					        	fromDate: vals.fromDate,
					        	toDate: todate,   
					        	intakeYearId: vals.intakeYear,
					        	admissionId: vals.studentNameSearch,
					        	nationalId: vals.nationalId,
					        	periodResult: vals.periodResult
					    	};
					    	this.resetPageSetting(store, grid);
					    	store.pageSize = 100;
					    	grid.getSelectionModel().deselectAll();
					    	store.load();
					    },
						onModuleResultsGridRender: function(grid) {
							grid.down('#sendToDTEFBtn').up('toolbar').setHeight(59.6);
							this.doAccessControlValidation(grid, this.getDTEF_MODULE_RESULTS_PERMISSIONS());
		        			this.sendToDtefPivileges(grid, this.getDTEF_MODULE_RESULTS_PERMISSIONS());
						},
						onInvoicesProgramSelect:function(combo, records, eOpts){
						    var form = combo.up('form');
						    var batchComboField = form.down('#batchIdInvoices');
						    var periodComboField = form.down('#periodIdInvoices');
						    var alinfomodel = Academia.model.authentication.ALInfoModel;
						    var comboValue = combo.getValue();
						    var intake = form.down('#intakeYearInvoices');
						    
						    batchComboField.clearValue();
						    periodComboField.clearValue();
						    batchComboField.getStore().getProxy().extraParams = {
						        id: comboValue
						    };
						    batchComboField.setDisabled(false);
						    batchComboField.getStore().load({
						        callback: function (records, operation, success) {
						            if (success) {
						                if (records.length == 1) {
						                    batchId = records[0].get('id');
						                    batchComboField.setValue(records[0].get('id'));
						                    var periodStore = periodComboField.getStore();
						                    periodStore.getProxy().extraParams = {
						                        id: records[0].get('id')
						                    };
						                    periodStore.load({
						                    	callback: function (records, operation, success) {
						                    		periodComboField.setDisabled(false);
						                    		if (success) {
						                    			if (records.length == 1) {
						                    				periodComboField.setValue(records[0].get('id'));
						                    			}
						                    		}
						                    	}
						                    });
						                }
						            }
						        }
						    });
						    form.isValid();
						    form.getForm().clearInvalid();
						},
						onInvoicesBatchSelect:function(combo, records, eOpts){
						    var form = combo.up('form');
						    var periodComboField = form.down('#periodIdInvoices');
						    var comboValue = combo.getValue();
						    var intake = form.down('#intakeYearInvoices');
						    var periodStore = periodComboField.getStore();
						    periodComboField.clearValue();
						    periodStore.getProxy().extraParams = {
		                        id: records[0].get('id')
		                    };
						    periodComboField.setDisabled(false);
						    periodComboField.getStore().load({
						    	callback: function (records, operation, success) {
						    		if (success) {
						    			if (records.length == 1) {
						    				periodComboField.setValue(records[0].get('id'));
						    			}
						    		}
						    	}
						    });
						    form.isValid();
						    form.getForm().clearInvalid();
						},
						resetDtefInvoicesFilter:function(){
							var filterForm = this.getDtefinvoicesfilter();
							var values = filterForm.getValues();
							filterForm.getForm().reset();
							filterForm.down('#periodIdInvoices').setDisabled(true);
							filterForm.down('#batchIdInvoices').setDisabled(true);
							filterForm.down('#tillDateInvoices').setMinValue(false);
							this.loadProgramIdStoreInvoiceDtef();
							this.loadNationalIdStoreInvoiceDtef();
							this.loadStudentNameComboInvoiceDtef();
						},
						loadProgramIdStoreInvoiceDtef: function() {
							var filterForm = this.getDtefinvoicesfilter();
							var values = filterForm.getValues();
							var nationalId = filterForm.down('#programIdInvoices');
							var store = nationalId.getStore();
							var alIds = this.getAcademyLocationIdsForDtefDashboard();
							store.getProxy().extraParams = {
								academyLocationIds: alIds
							};
							store.load();
						},
						loadNationalIdStoreInvoiceDtef: function() {
							var filterForm = this.getDtefinvoicesfilter();
							var values = filterForm.getValues();
							var nationalId = filterForm.down('#nationalIdItemIdInvoices');
							var store = nationalId.getStore();
							var alIds = this.getAcademyLocationIdsForDtefDashboard();
							store.getProxy().extraParams = {
								programId: values.program,
								batchId: values.batch,
								periodId: values.periodId,
								academyLocationIds: alIds
							};
							store.load();
						},
						loadStudentNameComboInvoiceDtef: function() {
							var filterForm = this.getDtefinvoicesfilter();
							var values = filterForm.getValues();
							var studentName = filterForm.down('#studentFieldItemIdInvoices');
							var store = studentName.getStore();
							var alIds = this.getAcademyLocationIdsForDtefDashboard();
							store.getProxy().extraParams = {
								programId: values.program,
								batchId: values.batch,
								periodId: values.periodId,
								academyLocationIds: alIds
							};
							store.load();
						},
						doSendDtefInvoices:function(button){
							var $this = this;
							var grid = this.getDtefinvoicesgrid();
							var records = grid.getSelectionModel().getSelection();
							var recordArray=[];
							if(records.length){
								records.forEach(function(cmp){
		         					var json = {
											billId:cmp.get('billId'),
											studentCode:cmp.get('studentCode'),
											studentName:cmp.get('studentName'),
											studentFirstName:cmp.get('studentFirstName'),
											studentMiddleName:cmp.get('studentMiddleName'),
											studentLastName:cmp.get('studentLastName'),
											studentFirstAndMiddleName:cmp.get('studentFirstAndMiddleName'),
											academyName:cmp.get('academyName'),
											locationName:cmp.get('locationName'),
											programName:cmp.get('programName'),
											batchName:cmp.get('batchName'),
											seatType:cmp.get('seatType'),
											periodName:cmp.get('periodName'),
											responseStatus:cmp.get('responseStatus'),
											response:cmp.get('response'),
											responseDate:cmp.get('responseDate'),
											billType:cmp.get('billType'),
											billNo:cmp.get('billNo'),
											academyLocationIdList:cmp.get('academyLocationIdList'),
											programId:cmp.get('programId'),
											batchId:cmp.get('batchId'),
											periodId:cmp.get('periodId'),
											admissionStatus:cmp.get('admissionStatus'),
											intakeYearId:cmp.get('intakeYearId'),
											admissionId:cmp.get('admissionId'),
											nationalId:cmp.get('nationalId'),
											raiseBillTypes:cmp.get('raiseBillTypes'),
											courseCode:cmp.get('courseCode'),
											studyYear:cmp.get('studyYear'),
											studySemester:cmp.get('studySemester'),
											invoiceDate:cmp.get('invoiceDate'),
											invoiceFees:cmp.get('invoiceFees'),
											semesterStartDate:cmp.get('semesterStartDate'),
											semesterEndDate:cmp.get('semesterEndDate'),
											invoiceStage:cmp.get('invoiceStage'),
											fdate:cmp.get('fdate'),
											tdate:cmp.get('tdate')
									};
		         					recordArray.push(json);
		         				});
		         			}
							var submitData = Ext.encode(recordArray);
							var submitUrl = SERVERURL.PATH_INVOICES_SEND_TO_DTEF;
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								type: 'rest',
								url: submitUrl,
								jsonData: submitData,
								method: 'POST',
								success: function(resp, action) {
									showSuccessMessage(getExaminationTranslation('DTEF'),getExaminationTranslation('SEND_TO_DTEF_SUCESSFULLY'));
									Ext.getBody().unmask();
									button.setDisabled(false);
									grid.getStore().reload();
									grid.getSelectionModel().deselectAll();
								}
							});
						},
						doSendDtefModuleResult:function(button){
							button.disable();
							var $this = this;
							var grid = this.getDtefModuleResultsGrid();
							var records = grid.getSelectionModel().getSelection();
							var recordArray=[];
							if(records.length){
								records.forEach(function(rec){
									var wSCoursesModelExam = rec.get('wSCoursesModelExam');
									var courseCodes = [];
									var periodResults = [];
									for(var i = 0; i < wSCoursesModelExam.length; i++) {
										courseCodes.push(wSCoursesModelExam[i].courseCode);
										periodResults.push(wSCoursesModelExam[i].periodResult);
									}
		         					var json = {
										nationalId: rec.get('nationalId') ? rec.get('nationalId') : '',
										studentFirstName: rec.get('studentFirstName') ? rec.get('studentFirstName') : '',
										studentMidName:rec.get('studentMidName') ? rec.get('studentMidName') : '',
										studentLastName:rec.get('studentLastName') ? rec.get('studentLastName') : '',
										studyYear: rec.get('studyYear') ? rec.get('studyYear') : '',
										studySemester: rec.get('studySemester') ? rec.get('studySemester') : '',
										
										moduleCodes: courseCodes.join(','),
										moduleResults: periodResults.join(','),
										periodResults: rec.get('periodStatus') ? rec.get('periodStatus') : '',
										dtefExamResultMapId: rec.get('dtefExamResultMapId') ? rec.get('dtefExamResultMapId') : '',
										evalPeriodRankId: rec.get('evalPeriodRankId') ? rec.get('evalPeriodRankId') : '',
										dtefResponseStatus:rec.get('responceStatus') ? rec.get('responceStatus') : '',
									};
		         					recordArray.push(json);
		         				});
		         			}
							var submitData = Ext.encode(recordArray);
							var submitUrl = SERVERURL.PATH_MODULE_RESULT_SEND_TO_DTEF;
							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							Ext.Ajax.request({
								type: 'rest',
								url: submitUrl,
								jsonData: submitData,
								method: 'POST',
								success: function(resp, action) {
									showSuccessMessage(getExaminationTranslation('DTEF'),getExaminationTranslation('SEND_TO_DTEF_SUCESSFULLY'));
									Ext.getBody().unmask();
									button.enable();
									grid.getStore().reload();
									grid.getSelectionModel().deselectAll();
								}
							});
						}
});
