/**
 * 
 * This controller is used for completion dashboard and reports.
 * @author Prathamesh.Sheth 
 * 
 */
Ext.define('Academia.controller.reports.completion.CompletionDashboardController', {
	
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',

    stores: [
             'reports.completion.StatisticsForList',
             'reports.completion.StatisticsByList',
             'reports.completion.StatisticsByDependentList',
             'common.ProgramsByAcademyIdLocationId',
             'common.BatchesByProgramId',
             'coursetransaction.sectionmanagement.SectionMultiSelect',
             'reports.completion.TerminationStatisticsChartStore'
            ],

    views: [
            'Academia.view.reports.completion.CompletionView',
            'Academia.view.reports.completion.CompletionStatisticsPanel',
            'Academia.view.reports.completion.CompletionSearchForm'
           ],

    refs: [ {
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'organizationunit',
        selector: 'organizationunit'
    },{
        ref: 'completionSearchForm',
        selector: 'completionsearchform'
    },{
    	ref:'terminationReasonChartFormPanel',
    	selector:'completionstatisticspanel form[itemId=terminationReasonChartFormPanel]'
    },{
    	ref:'terminationStatisticsChart',
    	selector:'completionstatisticspanel chart[itemId=terminationStatisticsChart]'
    },
    {
    	ref:'completionStatisticsPanel',
    	selector:'completionstatisticspanel'
    },{
    	ref:'terminationReasonChart',
    	selector:'completionstatisticspanel chart[itemId=terminationReasonChart]'
    }],
    
    config: {
    	STUDENT_UNASSIGNEDREQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_UNASSIGNEDREQUEST_PRIVILEGES'),
    	STUDENT_FOLLOWUPSCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FOLLOWUPSCHEDULED_PRIVILEGES'),
    	COMPLETIONDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETIONDASHBOARD_PRIVILEGES')

    },
    
    init: function(application) {
        this.control({
        	'organizationunit[itemId=completionDashboardOrganizationUnit] radiogroup[itemId=organizationRadioUnitId]': {
    			change:function(obj,record){
    				this.organizationUnitChange(obj,record);
    			},
    			render:function(obj){
    				var permission = this.getCOMPLETIONDASHBOARD_PERMISSIONS();
  		  			this.organizationUnitChange(obj,null,permission);
    			}
    		},
    		'organizationunit[itemId=completionDashboardOrganizationUnit] button[itemId=resetBtn]': {
    			click:function(obj,record){ 
    				this.resetOrganizationunit(obj);
    				var radioGroup = obj.up('organizationunit').down('#organizationRadioUnitId');
    				radioGroup.fireEvent('render', radioGroup);
    			}
    		},
        	'completionsearchform combo[itemId=statisticsForListCombo]':{
        		select:function(combo, records, eOpts){
        			this.showHideChart(combo, records, eOpts);
        		}
        	},
        	
        	'completionsearchform combo[itemId=statisticsByListCombo]':{
        		select:function(combo, records, eOpts){
        			this.loadDependentComboData(combo, records, eOpts);
        		}
        	},
        	
        	'completionsearchform button[itemId=resetButtonId]': {
                click:function(button, eOpts){
                	this.clearSearchForm(button);
                }
            },
            
            'completionsearchform button[itemId=searchButtonId]': {
                click:function(button, eOpts){
                	this.loadBarCharts(button);
                },
    			afterrender: function(button){
    				var me = this;
    				setTimeout(function(){
        				me.loadBarCharts(button);
    				},1000);
    			}
            },
        	
            'completionsearchform combo[itemId=programComboField]': {
        		focus : function(programComboField, records, eOpts) {
        			this.loadProgramComboByApplyingMAUFilter(programComboField, records, eOpts);
        		},
        		select: function(combo, records, eOpts) {
                    var batchComboField = combo.up('form').down('#batchComboField');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( batchComboField, comboValue, 'id');
                }
        	},
        	'completionsearchform combo[itemId=batchComboField]': {
        		select: function(combo, records, eOpts) {
                    var sectionComboField = combo.up('form').down('#sectionComboField');
                    var comboValue = combo.getValue();
                    this.loadDependentCombo(sectionComboField, comboValue, 'batchIds');
                }
        	},
        	
        	'completionstatisticspanel chart[itemId=terminationStatisticsChart]':{
        		render:function(terminationStatisticsChart, eOpts ){
        			var me=this;       
        		    var completionstatisticspanel = terminationStatisticsChart.up('completionstatisticspanel');
        		    if(completionstatisticspanel){
        		    
        		    	var completionsearchform=completionstatisticspanel.down("completionsearchform");
        		    	
        		    	var param=new Object();        		       
            		    param.startDate=null;
            		    param.endDate=null;
            		    param.academyIds= [];
            		    param.locationsId= [];
            		    param.programs= [];
            		    param.batches= [];
            		    param.sections= [];
            		       
            		    var statisticsForListCombo=completionsearchform.down("#statisticsForListCombo");
            		    if(statisticsForListCombo){
            		    	var store=statisticsForListCombo.getStore();
            		    	if(store){
            		    		var record=store.findRecord('name','TERMINATION');
            		    		if(record){
            		    			statisticsForListCombo.setValue(record);
            		    			
            		    			var academyLocationId=me.getCurrentAcademyLocation();
            		    			if(!isNullOrEmpty(academyLocationId)){
            		    				param.academyLocationId=[academyLocationId];        		    				
            		    			}
            		    			
            		    			param.entityName=statisticsForListCombo.getValue();
        		    				param.isReasonFilter=false;
            		    			
            		    			/*if(terminationStatisticsChart){
            	        				terminationStatisticsChart.getStore().load({
            	        					params:param        	        					    
            	        				});
            	        			}*/
            		    		}
            		    	}
            		    }
        		    }        		            		    	        			
        		}
        	},
        	        	        
        });

    },
        
    /**
     * This method is used to hide show panel 
     * @param combo - statisticsForListCombo Reference
     * @param records-statisticsForListCombo selected records 
     * 
     */   
   showHideChart:function(combo, records){
	   var me=this;
	   var searchForm=combo.up('form');
	   if(searchForm){
		   var viewStatisticsByContainer=searchForm.down("#viewStatisticsByContainer");
		   var terminationReasonChartFormPanel=me.getTerminationReasonChartFormPanel();
		   var selectedName=combo.getValue();
		   
		   if(selectedName==='PASSING_OUT' && viewStatisticsByContainer && terminationReasonChartFormPanel){ //Check for Passing Out 
			   viewStatisticsByContainer.setDisabled(true);
			   viewStatisticsByContainer.setVisible(false);
			   
			   terminationReasonChartFormPanel.setDisabled(true);
			   terminationReasonChartFormPanel.setVisible(false);
		   }else{
			   viewStatisticsByContainer.setDisabled(false);
			   viewStatisticsByContainer.setVisible(true);
			   
			   terminationReasonChartFormPanel.setDisabled(false);
			   terminationReasonChartFormPanel.setVisible(true);
		   }
	   }	   
   },
    

   /**
    * This method is used to load dependent combo 
    * @param combo - statisticsByListCombo Reference
    * @param records-statisticsByListCombo selected records 
    * 
    */   
   loadDependentComboData:function(statisticsByListCombo, records){
	   var me=this;
	   var submitURL="";
	   var searchForm=statisticsByListCombo.up('form');
	   if(searchForm){
		   var statisticsByDependentListCombo=searchForm.down("#statisticsByDependentListCombo");
		   var selectedName=statisticsByListCombo.getValue();
		   
		   if(!isNullOrEmpty(selectedName)){
			   
			    if(selectedName==='ACADEMY'){                     			
		       		submitURL=SERVERURL.CALENDAR_ACADEMY_STORE;  //URL-rest/academy/findAcademyByUser                            	
		    	}else if(selectedName==='ACADEMY_LOCATION'){		    		
		       		submitURL=SERVERURL.FIND_ALL_ACADEMY_LOCATION_BY_USER;  //URL-rest/academyLocation/findAllByUser                             	
		    	}/*else if(messageScopeRawValue==='ACADEMIC_YEAR'){ 
		    		submitURL=SERVERURL.FIND_ALL_ACADEMY_LOCATION_BY_USER;  //URL-rest/academyLocation/findAllByUser
		    	}*/                 			
			   
				if(!isNullOrEmpty(submitURL)){
					statisticsByDependentListCombo.getStore().removeAll();
					statisticsByDependentListCombo.reset();
					statisticsByDependentListCombo.getStore().getProxy().api.read =submitURL;
					statisticsByDependentListCombo.getStore().load();
				}
		   			
		   }
	   }  	
   },
   
   /**
    * This method is used to clear fields on search Form
    * @param button which is reference of button
    */
   clearSearchForm: function(button) {
	   var this$ = this;
	   var form = this$.getCompletionSearchForm();
	   form.getForm().reset();
	   this$.clearCombo(form.down('#batchComboField'), true);
	   this$.clearCombo(form.down('#sectionComboField'), true);
    /*   var form;
       form = button.up('form').getForm();
       form.getFields().each(function(field) {
           field.reset();
       });*/
   },
   
   /**
    * This method is used to load bar charts 
    * @param button which is reference of button
    */
   loadBarCharts: function(button) {
	   var me=this;       
       var searchform = button.up('form');
       
       var param=new Object();       
       var acadLocMultiselect = this.getOrganizationunit().down("#multiselectAcademyLocationId").rawValue;
       var statisticsForListCombo=searchform.down("#statisticsForListCombo");
       var statisticsForListCmbValue=statisticsForListCombo.getValue();
       if(statisticsForListCombo && !isNullOrEmpty(statisticsForListCmbValue) && !isNullOrEmpty(acadLocMultiselect)){
    	   param.entityName=statisticsForListCmbValue;

    	   /*
    	    * 
    	    * This Developed according to Hot Gloo Screens
    	    * 
    	    * var statisticsByListCombo=searchform.down("#statisticsByListCombo");
    	   var statisticsByDependentListCombo=searchform.down("#statisticsByDependentListCombo");
    	   
    	   if(statisticsByListCombo && !isNullOrEmpty(statisticsByListCombo.getValue()) && 
    		  (statisticsByListCombo.getValue()==="ACADEMY_LOCATION") &&
    		  statisticsByDependentListCombo && !isNullOrEmpty(statisticsByDependentListCombo.getValue())
    	   ){
    		   param.academyLocationId=statisticsByDependentListCombo.getValue();
    	   }else{
    		   var academyLocationId=me.getCurrentAcademyLocation();
	   		   if(!isNullOrEmpty(academyLocationId)){
	   				param.academyLocationId=academyLocationId;        		    				
	   		   }
    	   }*/    	
    	   var academyLocationIds=me.getAcademyLocationIds();    	   
    	   if(!isNullOrEmpty(academyLocationIds)){
           		academyLocationIds = academyLocationIds.toString();
           		var commaIndex = academyLocationIds.indexOf(",");
           		if(commaIndex != -1){
           			var academyLocationArray = academyLocationIds.split(",");
           			param.academyLocationId = academyLocationArray;
           		}else{
           			param.academyLocationId = [academyLocationIds];
           		}               	
           }
    	   
    	   param=me.getParamKeyValue(param,"#startDate",searchform,"startDate",false);
    	   param=me.getParamKeyValue(param,"#endDate",searchform,"endDate",false);
    	   
    	   param=me.getParamKeyValue(param,"#programComboField",searchform,"programs",true);
    	   param=me.getParamKeyValue(param,"#batchComboField",searchform,"batches",true);
    	   param=me.getParamKeyValue(param,"#sectionComboField",searchform,"sections",true);
    	   
    	   
    	   var terminationStatisticsChart=me.getTerminationStatisticsChart();
    	   var terminationReasonChart=me.getTerminationReasonChart();

    	  // Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	  
           if(terminationStatisticsChart && !isEmpty(param)){
        	   param.isReasonFilter=false;
        	   terminationStatisticsChart.getStore().load({
    				params:param
    			});
    		}
           
           if(terminationReasonChart && !isEmpty(param) && (statisticsForListCmbValue!=='PASSING_OUT')){
        	   param.isReasonFilter=true;
        	   terminationReasonChart.getStore().load({
        		   params:param
    			});
    		}
           var taskDelay = new Ext.util.DelayedTask(function(){
       		Ext.getBody().unmask();
       	  });
       	taskDelay.delay(1000);
       } else if (isNullOrEmpty(acadLocMultiselect)){
    	   showWarningMessage(getCommonTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_ACADEMY_LOCATION')); //Please select Academy Location.
       } else {
    	 //  Ext.getBody().unmask();
    	   showWarningMessage(getCommonTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_VIEW_STATISTICS')); //Please select view statistics combo.
       }              
   },
   
   getParamKeyValue:function(param,itemId,searchForm,key,isArrayKeyValue){
	   if(searchForm && !isNullOrEmpty(itemId)){
		   var component=searchForm.down(itemId);
		   if(component && !isNullOrEmpty(component.getValue())){
			   if(isArrayKeyValue){
				   var array=new Array();
				   array.push(component.getValue());
				   param[key]=array;
			   }else{				   
				   param[key]=component.getValue();;
			   }
			   
		   }
	   }
	   return param;
   },
   
   /**
    * On focus program combo load data according with MAU filter's
    * @param programComboField
    * @param records
    * @param eOpts
    */
   
   loadProgramComboByApplyingMAUFilter: function(programComboField, records, eOpts){
		var academyLocationIds = this.getAcademyLocationIds();
		var store = programComboField.getStore();
		store.load({
			params: {
				academyLocationIds: academyLocationIds
			}
		});
	},
   
	/**
     * Method to load the next combo based on the selection of
     * the previous combo value.
     * 
     * @param {Object}
     *            dependentCombo is the reference of the next
     *            dropdown which should be populated with
     *            values.
     * @param {Object}
     *            selectedRecord is the record of the previous
     *            dropdown which is selected.
     * @param {Object}
     *            parameter is the value that should be attached
     *            in the url.
     * @param {Object}
     *            extraParameter (optional) If there is any
     *            extra parameter to be sent for loading the
     *            dependent dropdown.
     * @param {Object}
     *            extraParamValue (optional) The value of the
     *            extraParam that is sent for loading the store.
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.reset();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },
   
    /**
     * code to reset other dropdowns based on the selection of
     * any dropdown which is previous in the hierarchy. eg: if
     * all the dropdowns are loaded and the Academy is changed
     * then subsequent dropdowns should be changed accordingly,
     * so their value is cleared and reset and reloaded.
     * 
     * @param: {Object} combo The reference of the dropdown
     *         which is the dependent/next combo.
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.name) {
        case 'academy':
            break;
        case 'location':
            this.clearCombo(combo);
            programCombo = container.down('combo[name=programId]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[name=batchId]');
            this.clearCombo(batchCombo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'batchId':
            this.clearCombo(combo);
            sectionCombo = container.down('combo[name=sectionId]');
            this.clearCombo(sectionCombo);
            break;
        case 'sectionId':
            this.clearCombo(combo);
            break;
        }
    },
    
    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    }
});
