/**
 * @author Dharmendra.p
 *  
 */
Ext.define('Academia.controller.reports.programcourse.creditbasedreport.CreditBasedReportController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['reports.programcourse.creditbasedreport.CreditBasedReportStructure',
            'reports.programcourse.creditbasedreport.CreditBasedSearch',
            'reports.programcourse.creditbasedreport.CreditBasedGrid', 'reports.programcourse.creditbasedreport.CreditBasedReportSearchTab'
            ],

    stores: ['coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
             'attendance.AdmissionSearchByStudent','common.ProgramsByAcademyLocationsIds',
             'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'attendance.SectionAndFacultyByPeriodID','common.AcademyLocationNameSeparated',
             'reports.programcourse.creditbasedreport.AdmissionStudentByAcademyLocation',
             'reports.programcourse.creditbasedreport.CreditBasedGridStr',
             'examinationcenters.reports.ExaminationCreditBaseReportProgramStore'
             ],

    refs: [{
        ref: 'creditbasedreportstructure',
        selector: 'creditbasedreportstructure'
    },{
        ref: 'creditbasedsearch',
        selector: 'creditbasedsearch'
    },{
        ref: 'creditbasedgrid',
        selector: 'creditbasedgrid'
    }, {
    	ref: 'creditbasedreportsearchtab',
    	selector: 'creditbasedreportsearchtab'
    }],
    config : {
    	CREDIT_BASED_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
				.getFeaturePrivilegesMap('CREDIT_BASED_REPORT_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	 'creditbasedgrid':{
        		 afterrender:function(grid){
        			 var $this = this;
        			 setTimeout(function(){
        				 $this.addDataGridConfigButton(grid, $this.getCREDIT_BASED_REPORT_PERMISSIONS());
        				 $this.doAccessControlValidation(grid, $this.getCREDIT_BASED_REPORT_PERMISSIONS());
            			 $this.disableMoreActionExportReportPivileges(grid,$this.getCREDIT_BASED_REPORT_PERMISSIONS());
     	          },1500);
        			
        			 
          		},
    			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				 var $this=this;
    				 var searchResultGrid = $this.getCreditbasedgrid();
    				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
    				  
    				 if(columnName=='admissionId'){
 						if (e.target.tagName == 'A') {
 							var userId = record.get('studentId');
 							if(!isNullOrEmpty(userId)) {
 								var tabTitle = record.get('admissionId');
 								var dbAdmissionId = record.get('dbAdmissionId');
 								var personId = record.get('personId');
// 								var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
 								Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
 								var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
 								personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, dbAdmissionId, null);
 							}
 						}
 					}
    			 }
    		 },
    		 'creditbasedgrid button[itemId=exportReportsId]':{
				click : this.exportReportfun
			},
        	'creditbasedsearch radiogroup[itemId=programPeriodLevelId]' : {
        		change : function(obj, rec) {
        			this.changeCreditBasedType(obj, rec);
        		}
        	},
        	'creditbasedsearch multiselectcombofield[itemId=multiselectAcademyLocationId]' : {
        		render:function(obj,rec){
        			var store = obj.getStore();
        			store.load({
						callback: function(records, operation, success) {
							if (success) {
								var allAl =[];
								for(var i in records){
									allAl.push(records[i].get("id"));
								}
								obj.setValue(allAl);
							}
						}
					});
        			
        		},
        		change : function(obj, rec) {
        			this.onChangeAcadmyLocation(obj, rec);
        		}
        	},
        	'creditbasedsearch combo[itemId=admissionStudentId]' : {
        		select : function(obj, rec) {
        			this.onChangeStudentAdmissionCombo(obj, rec);
        		},
        		blur: function (combo) {
        		    var store = combo.getStore();
        		    if (store.loading && store.lastOperation) {
        				var requests = Ext.Ajax.requests;
        				for (id in requests) {
        					if (requests.hasOwnProperty(id) && requests[id].options == store.lastOperation.request) {
        						Ext.Ajax.abort(requests[id]);
        						store.lastOperation = null;
        					}
        				}
        			}
        		    var value = combo.getValue();
        		    var record = store.findRecord(combo.valueField, value);
        		    if (!record) {
        		    	combo.reset();
        		        Ext.defer(function() {
        		        	combo.reset();
        		        }, 100);
        		    }
        		},
        		afterrender: function(cmp) {
					cmp.getStore().on('beforeload', function(store, operation) {
						store.lastOperation = operation;
					});
				}
        	},
        	'creditbasedsearch combo#programId': {
        		select: function(obj, record) {
        			var $this=this;
        			var form = obj.up('form');
        			var programId = record[0].get("id");
        			var button = this.getCreditbasedgrid().down('#exportReportsId');
					var level = form.down("#programPeriodLevelId");
					var degreeType = level.getValue();
					form.down('#periodId').reset();
				     form.down('#sectionId').reset();
				     
        				form.down('#periodId').disable(true);
				        form.down('#sectionId').disable(true);
        			if(programId > 0){ 
        				form.down('#batchId').setDisabled(false);
        				var store =form.down('#batchId').getStore();
        				store.getProxy().extraParams = {
        					id: programId
        					//isActive:true
        				};
        				store.load({
        					callback : function(records, success){
								if(success){
									if(records.length==1){
										form.down('#batchId').setValue(records[0].data.id);
										var button = $this.getCreditbasedgrid().down('#exportReportsId');
					        			button.setDisabled(false);
					        			form.down('#periodId').enable();
									}
				        				

										if(degreeType.creditLevel=="PROGRAM"){
											form.down('#periodId').setDisabled(true);
										}/*else{
											form.down('#periodId').setDisabled(false);
										}*/
				        			
				            			//button.setDisabled(false);
				        				var store =form.down('#periodId').getStore();
				        				store.getProxy().extraParams = {
				        					id: records[0].data.id,
//				        					isCurrentPeriod:true
				        				};
				        				store.load();
				        			
								}
        					}
        				});
        				this.getCreditbasedsearch().isValid();
        			}
        		}
        	},
        	'creditbasedsearch combo#batchId': {
        		select: function(obj, record) {
        			var $this = this;
        			var form = obj.up('form');
        			var button = $this.getCreditbasedgrid().down('#exportReportsId');
					var level = form.down("#programPeriodLevelId");
					var degreeType = level.getValue();
        			button.setDisabled(false);
        			var batchId = record[0].get("id");
        			if(batchId > 0){
        				
        				form.down('#periodId').reset();
						
						if(degreeType.creditLevel=="PROGRAM"){
							form.down('#periodId').setDisabled(true);
						}else{
							form.down('#periodId').setDisabled(false);
						}

        				var store =form.down('#periodId').getStore();
        				store.getProxy().extraParams = {
        					id: batchId,
//        					isCurrentPeriod:true
        				};
        				store.load();
        			}
        		}
        	},
        	'creditbasedsearch combo#periodId': {
        		select: function(obj, record) {
        			var periodId = record[0].get("id");
        			//this.setAllowBlank(periodId,false);
        			var form = obj.up('form');
        			var button = this.getCreditbasedgrid().down('#exportReportsId');
        			button.setDisabled(false);
        			if(periodId > 0){
        				
        				form.down('#sectionId').reset();
        				form.down('#sectionId').setDisabled(false);
        				var store =form.down('#sectionId').getStore();
        				store.getProxy().extraParams = {
        					periodId: periodId
        				};
        				store.load();
        			}
        		}
        	},
        	'creditbasedsearch button[itemId=searchBtn]' : {
        		click : function() {
        			this.loadCreditBasedGrid();
        		}
        	},
        	'creditbasedsearch button[itemId=resetBtn]' : {
        		click : function(obj) {
        			this.resetCreditBasedForm(obj);
        		}
        	}
        	
        });
    },
    changeCreditBasedType:function(obj,rec){
		var form = obj.up('form');
		var periodLevel = form.down('#periodLevel');
		var creditBasedType = rec.creditLevel;
		
		var period =form.down('#periodId');
		var programField = form.down('#programId');
    	var batchField = form.down('#batchId');
		period.reset();
    	programField.reset();
		batchField.reset();
		period.reset();
		period.setDisabled(true); 
    	batchField.setDisabled(true);
		if(creditBasedType == 'PROGRAM'){
			periodLevel.setVisible(false);
			period.allowBlank = true;
		}else{
			periodLevel.setVisible(true);
			//period.allowBlank = false;
			period.setFieldLabel(getCourseTxCommonTranslation('PERIOD'));
		    this.setAllowBlank(period,false);
			form.getForm().isValid();
		}
		//form.getForm().reset();
		form.down('#admissionStudentId').reset();
		form.down('#programId').reset();
		form.down('#batchId').reset();
		form.down('#periodId').reset();
		form.down('#sectionId').reset();
		form.isValid(); 
    },
    onChangeAcadmyLocation:function(obj,rec){
    	var form = obj.up('form');
    	var admissionStudentField = form.down('#admissionStudentId');

    	var admissionStudentField = form.down('#admissionStudentId');
    	var programField = form.down('#programId');
    	var batchField = form.down('#batchId');
        var periodField = form.down('#periodId');
    	var sectionField = form.down('#sectionId');

		if (rec.length === 0) {
			programField.setDisabled(true);
			batchField.setDisabled(true);
			periodField.setDisabled(true);
		} else {
			programField.setDisabled(false);
		}
    	
    	var programStore = programField.getStore();
    	var batchStore = batchField.getStore();
    	var store = admissionStudentField.getStore();
    	var academyLocations = [];
    	if(rec.length > 0){
	    	academyLocations.push(rec);
			
	    	store.getProxy().extraParams = {
	    		academyLocations: academyLocations.join(),
	    	};
	    	store.load();

			programField.reset();
			batchField.reset();			
		    periodField.reset();
			sectionField.reset();
			
	    	programStore.getProxy().extraParams = {
	    		academyLocationIds: academyLocations.join(),
	    	};
	    	programStore.load();
    	}else{ 
			//else case added for V2D-301064
			programField.reset();
			batchField.reset();	
			periodField.reset();
			sectionField.reset();
		}
    },
    onChangeStudentAdmissionCombo:function(obj,rec){
    	
    	var $this = this;
		var button = $this.getCreditbasedgrid().down('#exportReportsId');
		button.setDisabled(false);
		
    	var form = obj.up('form');
    	var admissionId = rec[0].get("id");  	
    	var alIdsField = form.down('#multiselectAcademyLocationId');
    	var alIds = alIdsField.getValue();
    	var academyLocationIds = [];
    	
    	var alData;
 		if(alIds !="" && alIds !=null){
 			for(var i in alIds){
 				if(Ext.isObject(alIds[0])){
 					alData = alIds[i].get("id");
 					academyLocationIds.push(alData);
 				}else{
 					alData = alIds[i];
 					academyLocationIds.push(alData);
 				}
 			}
 		}	
    	
    	/*if(alIds !=null){
    		for(var i in alIds){
    			academyLocationIds.push(alIds[i].data.id);
    		}
    	}*/
    	var programField = form.down('#programId');
    	var batchField = form.down('#batchId');
    	var periodField = form.down('#periodId');
    	var sectionField = form.down('#sectionId');

    	var degreeField = form.down('#programPeriodLevelId');
    	var degreeType = degreeField.getValue();

    	var programStore = programField.getStore();
    	var batchStore = batchField.getStore();
    	var periodStore = periodField.getStore();
    	var sectionStore = sectionField.getStore();


    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.PROGRAM_BATCH_PERIOD_SECTION_BY_ADMISSION,
    		headers: {
    			'Content-Type': 'application/json'
    		},
    		params : {
    			admissionId: admissionId
    		},
    		method : 'GET',
    		success : function(f, action) {
    			var  jData=Ext.JSON.decode(f.responseText);

    			var programId = jData.program.id;
    			var batchId =   jData.batch.id;
    			var periodId =  jData.period.id;
    			var sectionId = jData.section.id;

    			programField.reset();
    			batchField.reset();
    			periodField.reset();
    			sectionField.reset();
    			batchField.setDisabled(true)
    			programStore.getProxy().extraParams = {
    				academyLocationIds:academyLocationIds.join(),
    				admissionId: admissionId,
    				whetherMarksheet: true
    			};
    			programStore.load({
    				callback: function(records, operation, success) {
    					if (records.length== 1) {
    						programField.setValue(programId);

    						batchStore.getProxy().extraParams = {
    							programIds:programId,
    						};
    						batchStore.load({
    							callback: function(records, operation, success) {
    								if (success) {
    									batchField.setDisabled(false);
    									batchField.setValue(batchId);
    								}
    							}
    						});


//  						if(degreeType.creditLevel == 'PERIOD'){ 
    						periodStore.getProxy().extraParams = {
    							id:batchId,
//    							isCurrentPeriod:true
    						};
    						periodStore.load({
    							callback: function(records, operation, success) {
    								if (success) {
    									periodField.setDisabled(false);
    									periodField.setValue(periodId);
    									form.down('#sectionId').setDisabled(false);
    									sectionStore.getProxy().extraParams = {
    										periodId: periodId
    									};
    									sectionStore.load({
    										callback: function(records, operation, success) {
    											if (success) {
    												for(var i in records){
    													if(records[i].data.sectionId==sectionId){
    														 Ext.defer(function() {
    														 
    												         form.down('#sectionId').setValue(sectionId);
    														 },300);
    												    }
    												}
    											}
    										}
    									});

    								}
    							}
    						});
    					}
    				}
//    			}
    			});

    		}
    	});
    },
    loadCreditBasedGrid:function(){
    	var $this = this;
    	var form = $this.getCreditbasedsearch();
    	var values = form.getValues();
    	
    	var grid = $this.getCreditbasedgrid();
    	var store = grid.getStore();
    	
    	var admissionId =values.admissionId;
    	var periodId = null;
    	var sectionId = null;
    	
    	var whetherProgramLevel;
    	if(values.creditLevel == 'PROGRAM'){
    		whetherProgramLevel=true;
    		//grid.columns[5].hide();
    	}else{
    		whetherProgramLevel=false;
    		//grid.columns[5].show();
    		periodId = values.period;
    		sectionId = values.section;
    	}
    	
    	store.getProxy().extraParams = {
    		admissionId:admissionId,
    		whetherProgramLevel:whetherProgramLevel,
    		programId:values.program,
    		batchId:values.batch,
    	    periodId:periodId,
    		sectionId:sectionId
    	};
    	grid.config.searchFilterForm = form;
		$this.resetPageSetting(grid.getStore(), grid);
		grid.getStore().load();
		grid.getSelectionModel().deselectAll();
		grid.getStore().pageSize = 100;

    },
    resetCreditBasedForm:function(obj){
    	var $this=this;
    	var form = obj.up('form').getForm();
//    	form.reset();
    	form.findField('program').reset();
    	form.findField('batch').reset();
    	form.findField('period').reset();
    	form.findField('section').reset();
    	form.findField('programPeriodLevelId').reset();
    	form.findField('multiselectAcademyLocation').reset();
    	form.findField('admissionId').reset();
//    	form.findField('program').setDisabled(true);
    	form.findField('batch').setDisabled(true);
    	form.findField('period').setDisabled(true);
    	form.findField('section').setDisabled(true);
    	
    	var button = $this.getCreditbasedgrid().down('#exportReportsId');
		button.setDisabled(true);
		
		var alIdsField = form.findField('multiselectAcademyLocation');
    	var alIds = alIdsField.getValue();
    	var academyLocationIds = [];
    	
    	var alData;
 		if(alIds !="" && alIds !=null){
 			for(var i in alIds){
 				if(Ext.isObject(alIds[0])){
 					alData = alIds[i].get("id");
 					academyLocationIds.push(alData);
 				}else{
 					alData = alIds[i];
 					academyLocationIds.push(alData);
 				}
 			}
 		}else{
 			var locstore = form.findField('multiselectAcademyLocation').getStore();
 			locstore.load({
 				callback: function(records, operation, success) {
					if (success) {
						var allAl =[];
						for(var i in records){
							allAl.push(records[i].get("id"));
						}
						alIdsField.setValue(allAl);
					}
				}
 			});
 		}
	/*	var store =form.findField('program').getStore();
		store.getProxy().extraParams = {
			academyLocationIds:academyLocationIds.join()
		};
		store.load();*/
    },
    
    exportReportfun : function(){
    	console.log('hi');
		var $this = this;
		var form = $this.getCreditbasedsearch().getForm();
		var values = form.getValues();
		var sections = [];
		if(!isNullOrEmpty(values.sectionId)){
			for (var i=0 ; i<values.sectionId.length; i++){
				sections.push(values.sectionId[i].data.id);
			}
		}
    	// code to identify jasper
		//var markrepowind = $this.getMarksheetreportswin();
		//var reportType = markrepowind.down('#reportTypeId');
       var code = "CreditBasedExamReport";//reportType.getValue();//"CourseWiseMarksheetReport"; //Enum value put here
       var reportParams =new Object();
       reportParams.code = code;
       reportParams.reportTitle = code;
       reportParams.programId = values.program;
       reportParams.batchId = values.batch;
       reportParams.periodId = values.period;
       reportParams.sectionId=values.section,
      /* if(sections.length >0) {
       	reportParams.sectionIds = sections;
       }*/
      // reportParams.courseId = values.courseId;
      // reportParams.courseVariantId = values.courseVariant;
       reportParams.admissionId = values.admissionId;
       reportParams.headerName = getCommonTranslation('CREDIT_BASED_EXAMINATION_REPORT');//"Course Wise Marksheet Report";
       
       var reportTitle="";
       
     $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',"rest/creditReport/exportXcelReport");
    },
    // *********************************Disable more action****************************************
    disableMoreActionExportReportPivileges: function(from,permissionsMap) {
     	 var associatedAcadLocationIds = new Array();
     	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
     	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    //  var adjustmentform = this.getAdjustmentstructure();	
     	var exportReports=from.down('#exportReportsId'); 
     	exportReports.setVisible(false);
     	
     	 Ext.each(permissionList, function(privilege) {
     		 if (privilege === 'EXPORTREPORTS') {
     			 if(!isNullOrEmpty(exportReports)){
     				exportReports.setVisible(true);	
     			 }
     		 } 
     	 });
      },
     
});