
Ext.define('Academia.controller.securitysetup.UserRoleAssociationController',{
	extend: 'Academia.controller.base.BaseController',
	views:['dashboard.UserRoleAssociationSearch','dashboard.UserRoleAssociationSearchPanel','dashboard.UserRolesAssociationStructure'],
	stores:['user.UserTypeStore','criteriabuilder.SearchResultStore','criteriabuilder.userquicksearch.QuickSearchName',
	        'criteriabuilder.userquicksearch.QuickSearchCode','common.AcademyLocationNameSeparated','securitysetup.ActiveRolesStore',
	        'userGroup.UserGroupStore','department.ParentDepartmentStore'],
	refs: [
	       {
	   		ref : 'userroleassociationsearch',
	   		selector : 'userroleassociationsearch'
	   	},{
	   		ref : 'searchResultGrid',
	   		selector:'searchresultgrid[itemId=userRoleAssociationListGrid]'
		},{
			ref: 'userroleassociationsearchpanel',
			selector : 'userroleassociationsearchpanel'
		}],
	
	config:{
		USER_ROLES_ASSOCIATION_REPORTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_ROLES_ASSOCIATION_REPORTS_PRIVILEGES'),
	},

	init: function(application) {
	    this.control({
	    	//for HeaderColumn fixing
	    	'userroleassociationsearchpanel':{
				afterrender : function(structure){
					var grid = structure.down('searchresultgrid');
					this.getCBGridHeaderFreeze(grid,structure);
				}
     		},
	    	'userroleassociationsearch button[itemId=searchBtnId]' : {
				click : function() {
					this.loadGridAndSearchUsers();
				}
			},
			
			'userroleassociationsearch' : {
				render : function(form) {
					var userIdCombo = form.down('#userId');
					var store = userIdCombo.getStore();
					store.getProxy().extraParams={
						excludeStudents:'true'
					};
					store.load();
				}
			},
			
			'userroleassociationsearch button[itemId=resetBtn]' : {
				click : function() {
					var userForm = this.getUserroleassociationsearch().getForm();
					userForm.reset();
				}
			},
			
			/*'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnAdd]': {
	            click:  function() {
	            	this.showFormTab(getCommonTranslation('ADD_USER'));
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnEdit]': {
	            click: function() {
	                this.editFormWindow();
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnView]': {
	            click: function() {
	                this.viewUserRecord();
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] button[itemId=searchResultGridBtnDelete]': {
	            click: function() {
	                this.deleteUserRecord();
	            }
	        },
	        'searchresultgrid[itemId=userSearchresultgrid] menuitem[itemId=resetButtonItemId]': {
	            click: function() {
	            	var grid = this.getSearchResultGrid();
		        	if (grid.getSelectionModel().getCount() > 0) {
		        		 this.openResetPasswordWindow();
	        		} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
		       	     
	            }
	        },*/
	        
			'userroleassociationsearchpanel searchresultgrid[itemId=userRoleAssociationListGrid]' : {
				render:  function(grid) {
					grid.addExportButtonToolbar();
					var butonstoolbar=grid.down('#functionButtonsToolbar');
					this.genericCBGridAccessControlValidation(grid, this.getUSER_ROLES_ASSOCIATION_REPORTS_PERMISSIONS());
				}
			},
			
	        'searchresultgrid[itemId=userRoleAssociationListGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=userRoleAssociationListGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',true);
	            }
	        },
	        'searchresultgrid[itemId=userRoleAssociationListGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=userRoleAssociationListGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	            click: function() {
	                this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	            }
	        }
	        
	    });
	    
	},
	
	loadGridAndSearchUsers : function(model, records) {
		var searchForm = this.getUserroleassociationsearch();
        var jsonFormatFormData = this.createJsonFormat(searchForm, records);
        var ResultGrid = this.getSearchResultGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.USER_ROLES_ASSOCIATION_REPORT_VIEW_CODE);
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
	},
	
	createJsonFormat: function(searchForm) {
    	var this$=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.USER_ROLES_ASSOCIATION_REPORT_CONFIG_CODE;

        formValues = searchForm.getValues();
        
        var userIdField = searchForm.getForm().findField('userId');
        var userNameField = searchForm.getForm().findField('userName');      
        var academyLocationField = searchForm.getForm().findField('academyLocationId');
        var roleIdField = searchForm.getForm().findField('userRole');
        var departmentIdField = searchForm.getForm().findField('userDepartment');
        var userGroupField = searchForm.getForm().findField('userGroup');
        var statusField = searchForm.getForm().findField('userRoleAssociationStatus');
	    
        if(!isNullOrEmpty(formValues.userId)){
        	var userIdObj = this$.getJsonObject('USER_ID' , userIdField.getValue());
        	this$.pushJsonObjectInArray(userIdObj,searchcriteria);
        }
        
        if(!isNullOrEmpty(formValues.userName)){
        	var userNameObj = this$.getJsonObject('USER_NAME' , userNameField.getValue());
        	this$.pushJsonObjectInArray(userNameObj,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.academyLocationId)){
        	var academyLocationObj = this$.getJsonObject('ACADEMY_LOCATION_ID' , academyLocationField.getValue());
        	this$.pushJsonObjectInArray(academyLocationObj,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.userRole)){
        	var roleIdObj = this$.getJsonObject('USER_ROLE_ID' , roleIdField.getValue());
        	this$.pushJsonObjectInArray(roleIdObj,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.userDepartment)){
        	var departmentObj = this$.getJsonObject('USER_DEPARTMENT_ID' , departmentIdField.getValue());
        	this$.pushJsonObjectInArray(departmentObj,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.userGroup)){
        	var userGroupObj = this$.getJsonObject('USER_GROUP_ID' , userGroupField.getValue());
        	this$.pushJsonObjectInArray(userGroupObj,searchcriteria);
        }
        if(!isNullOrEmpty(formValues.userRoleAssociationStatus)){
        	var statusObj = this$.getJsonObject('STATUS' , statusField.getValue());
        	this$.pushJsonObjectInArray(statusObj,searchcriteria);
        }
        values.searchCriterias = searchcriteria;
        return values;
    },
    
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    
    exportUserList : function(exportUrl,filetype,whetherAll) {
    	var quickSearchForm=this.getUserroleassociationsearch();	
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('USER_ROLE_ASSOCIATION_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
});
