/**
 * @author Priyanshi Sharma
 *  
 */
Ext.define('Academia.controller.setup.manageportalpermission.ManagePortalPermissionController', {
	extend: 'Academia.controller.base.BaseController',
    
    models:[],
    
    stores:['setup.manageportalpermission.ManagePortalPermissionSetupGridStore','setup.manageportalpermission.ManagePortalPermissionConfigureScreenGridStore'],
    
    views: ['setup.manageportalpermission.ManagePortalPermissionStructure','setup.manageportalpermission.StudentPortalManagePermissionSetupGrid',
    	'setup.manageportalpermission.ManagePortalPermissionSetupConfigureScreen','setup.manageportalpermission.SPManagePermissionSetupConfigureScreenGrid',
    	'setup.manageportalpermission.MobileAppManagePermissionSetupGrid'],
   
    refs: [{
        ref:'studentportalmanagepermissionsetupgrid',
        selector:'studentportalmanagepermissionsetupgrid'
    },{
        ref:'manageportalpermissionsetupconfigurescreen',
        selector:'manageportalpermissionsetupconfigurescreen'
    },{
    	ref:'spmanagepermissionsetupconfigurescreengrid',
    	selector:'spmanagepermissionsetupconfigurescreengrid'
    },{
    	ref:'manageportalpermissionstructure',
    	selector:'manageportalpermissionstructure'
    },{
    	ref:'mobileappmanagepermissionsetupgrid',
    	selector:'mobileappmanagepermissionsetupgrid'
    }],
    config: {
    	STUDENT_MANAGE_PORTAL_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PORTAL_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
        	'manageportalpermissionstructure':{
         	   render:function(structure){
					this.disableManagePortalPermissionStudentPortalTab(structure, this.getSTUDENT_MANAGE_PORTAL_PERMISSION());
				 }
            },
        	'studentportalmanagepermissionsetupgrid':{
 	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		if(columnName == "additionalSetup"){
 	        			if (e.target.tagName == 'A') {
 	        				var setupForm = grid.up('manageportalpermissionstructure');
 	        				var containpanel = setupForm.down('tabpanel');
 	        				var tabName = getCommonTranslation('CONFIGURE_SCREEN');
 	        				/*var tabDetail = containpanel.items.items;
 	        				  for(var i in tabDetail){
 	        					if(tabDetail[i].itemId!='pnlJobPostingId'){
 	        						tabDetail[i].close();
 	        					}
 	        				}*/
 	        				var configfeestructure = Ext.widget('manageportalpermissionsetupconfigurescreen');
 	        				openTab(containpanel, tabName, configfeestructure);
 	        				var configGrid = configfeestructure.down('spmanagepermissionsetupconfigurescreengrid');
 	        				configGrid.getStore().getProxy().extraParams = {
 	        					moduleInformationId:record.data.id,
 	        				};
 	        				configGrid.getStore().load();
 	        			}
 	        		}
 	        	},
 	        	render:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts){
 	        		var store = grid.getStore();
 	        		store.getProxy().extraParams = {
 	        		 portalId:3
       		    	};
 	        		store.load();
 	        	}
       		},
       		'mobileappmanagepermissionsetupgrid':{
 	        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		if(columnName == "additionalSetup"){
 	        			if (e.target.tagName == 'A') {
 	        				var setupForm = grid.up('manageportalpermissionstructure');
 	        				var containpanel = setupForm.down('tabpanel');
 	        				var tabName = getCommonTranslation('CONFIGURE_SCREEN');
 	        				/*var tabDetail = containpanel.items.items;
 	        				  for(var i in tabDetail){
 	        					if(tabDetail[i].itemId!='pnlJobPostingId'){
 	        						tabDetail[i].close();
 	        					}
 	        				}*/
 	        				var configfeestructure = Ext.widget('manageportalpermissionsetupconfigurescreen');
 	        				openTab(containpanel, tabName, configfeestructure);
 	        				var configGrid = configfeestructure.down('spmanagepermissionsetupconfigurescreengrid');
 	        				configGrid.getStore().getProxy().extraParams = {
 	        					moduleInformationId:record.data.id,
 	        				};
 	        				configGrid.getStore().load();
 	        			}
 	        		}
 	        	},
 	       	render:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts){
	        		var store = grid.getStore();
	        		store.getProxy().extraParams = {
	        		 portalId:8
   		    	};
	        		store.load();
	        	}
       		},
       	   'studentportalmanagepermissionsetupgrid button[itemId=saveStdPortalPermissions]':{
       		    click:function(grid){
        		  this.updateManagePortalPermissionScreenData(grid);
        	    }
       	    },
       	 'mobileappmanagepermissionsetupgrid button[itemId=saveMobileAppPortalPermissions]':{
    		    click:function(grid){
     		  this.updateManagePortalPermissionScreenData(grid);
     	    }
    	    },
       	 
       	 'spmanagepermissionsetupconfigurescreengrid button[itemId=saveStdPortalPermissions]':{
    		    click:function(){
     		     this.updateManagePortalPermissionConfigScreenData();
     	        }
    	    },
    	  'manageportalpermissionstructure tabpanel tab':{
    			 activate: function(tab){
    				 var tab = tab.up('tabpanel').getActiveTab();
    				// if(tab.isReloadTabRequire){
    					 if(tab.itemId=='StudentPortalTabId'){
    						 var grid =tab.down("#studentportalmanagepermissionsetupgrid");
    						 var store = grid.getStore();
    		 	        		store.getProxy().extraParams = {
    		 	        		 portalId:3
    		       		    	};
    		 	        		store.load();
    					 }else if(tab.itemId=='mobileAppPortalTabId'){
    						 var grid =tab.down("#mobileappmanagepermissionsetupgrid");
    						 var store = grid.getStore();
    		 	        		store.getProxy().extraParams = {
    		 	        		 portalId:8
    		       		    	};
    		 	        		store.load();
    					 }
    					// tab.isReloadTabRequire=false;
    				// }
    			 }
				},
        });
      },
      disableManagePortalPermissionStudentPortalTab:function(structure,permissionsMap){
		   	 var associatedAcadLocationIds = new Array();
		   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   	 var StudentPortalTab=false;
		   	 var mobileAppPortalTab=false;
		   	 for (var i = 0; i < permissionList.length; i++) {
		   		 if (permissionList[i] === "STUDENT_PORTAL_CONFIG_TAB") {
		   			StudentPortalTab=true;
		   		 }
		   		 if (permissionList[i] === "MOBILE_APP_CONFIG_TAB") {
		   			mobileAppPortalTab=true;
			   	}
		   	 }
		    	this.showmPortalPermissionStudentPortalTab(StudentPortalTab,mobileAppPortalTab, structure);
		   	
      },
      showmPortalPermissionStudentPortalTab:function(StudentPortalTab, mobileAppPortalTab, structure){
		   	 var panelItem = new Array();
		   	 var $this = this;
		   	 var newcont=structure.items.items.length;
		   	 var insertPosition=newcont+1;
		   	 if(StudentPortalTab==true&&mobileAppPortalTab==false) {
		   		 panelItem.push({
		   			xtype:'tabpanel',
		   			plain: true,
		   			style:{overflow:'hidden !important',margin:'0!important'},
		   			
		   			frame: false,
		   			border:false,
		   			items:[{
		   				title :getCommonTranslation('STUDENT_PORTAL'),     
		   				xtype:'panel',
		   				itemId:'StudentPortalTabId',
		   				items : [{
		   					xtype:'studentportalmanagepermissionsetupgrid',
		   					itemId:'studentportalmanagepermissionsetupgrid'
		   				}]
		   			}]
		   		});
		   	 }else if(mobileAppPortalTab==true&&StudentPortalTab==false) {
		   		 panelItem.push({
			   			xtype:'tabpanel',
			   			plain: true,
			   			style:{overflow:'hidden !important',margin:'0!important'},
			   			
			   			frame: false,
			   			border:false,
			   			items:[{
			   				title :getCommonTranslation('MOBILE_APP_PORTAL'),     
			   				xtype:'panel',
			   				itemId:'mobileAppPortalTabId',
			   				items : [{
			   					xtype:'mobileappmanagepermissionsetupgrid',
			   					itemId:'mobileappmanagepermissionsetupgrid'
			   				}]
			   			}]
			   		});
			   	 }else if(StudentPortalTab==true&&mobileAppPortalTab==true) {
			   		 panelItem.push({
				   			xtype:'tabpanel',
				   			plain: true,
				   			style:{overflow:'hidden !important',margin:'0!important'},
				   			
				   			frame: false,
				   			border:false,
				   			items:[{
				   				title :getCommonTranslation('STUDENT_PORTAL'),     
				   				xtype:'panel',
				   				itemId:'StudentPortalTabId',
				   				items : [{
				   					xtype:'studentportalmanagepermissionsetupgrid',
				   					itemId:'studentportalmanagepermissionsetupgrid'
				   				}]
				   			},{
				   				title :getCommonTranslation('MOBILE_APP_PORTAL'),     
				   				xtype:'panel',
				   				itemId:'mobileAppPortalTabId',
				   				items : [{
				   					xtype:'mobileappmanagepermissionsetupgrid',
				   					itemId:'mobileappmanagepermissionsetupgrid'
				   				}]
				   			}]
				   		});
				   	 }else{
		   		 panelItem.push({
		   		 });
		   	 }
		   	 structure.insert(insertPosition,panelItem);
      },
      updateManagePortalPermissionScreenData:function(grid1){
      	var $this = this;
      	var grid;
      	if(grid1.itemId == "saveStdPortalPermissions"){
      		grid = $this.getStudentportalmanagepermissionsetupgrid();
      	}else if(grid1.itemId == "saveMobileAppPortalPermissions"){
      		grid = $this.getMobileappmanagepermissionsetupgrid();
      	}
      	var records = grid.getStore().getRange();
      	if(records.length>0){
      		var configureJsonArr = [];
      		records.forEach(function(rec){
      			var obj=new Object();
      			obj.moduleName = rec.data.moduleName;
      			obj.moduleCode = rec.data.moduleCode;
          		obj.id = rec.data.id;
          		obj.isEditable = rec.data.isEditable;
      			obj.portal = {
    					"id":rec.data.portal.id
    			};
      			configureJsonArr.push(obj);
          	});
      		var formData = Ext.encode(configureJsonArr);
      		var submitUrl = SERVERURL.PATH_MANAGE_PORTAL_PERMISSION_UPDATE;
      		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      		Ext.Ajax.request({
      			type: 'rest',
      			url: submitUrl,
      			jsonData: formData,
      			method: 'POST',
      			success: function(response, action) {
      				Ext.getBody().unmask();
      				
      				if(response.responseText != null){
          		    	grid.getStore().load();
          		    	showSuccessMessage(getCommonTranslation('MANAGE_PORTAL_PERMISSION'), getCommonTranslation('SUCCESS'));
      				}
      			}
      		});
      	}
      },
      updateManagePortalPermissionConfigScreenData:function(){
      	    var $this = this;
      	    var grid = $this.getSpmanagepermissionsetupconfigurescreengrid();
      	    var gridParent = $this.getStudentportalmanagepermissionsetupgrid();
      	    var configureArray = [];
      	    var submitUrl;
      		//var record = grid.getSelectionModel().getSelection();
      	    var record = grid.getStore().getRange();
      	    var isEditable;
      		for(var i=0;i<record.length;i++){
      			if(record[i].data.isEditable == null || record[i].data.isEditable == false || record[i].data.isEditable == undefined){
      				isEditable = false;
      			}else{
      				isEditable = true;
      			}
      			configureArray.push({
      				"fieldId": record[i].data.fieldId,
      				"fieldDisplayName": record[i].data.fieldDisplayName,
      				"isEditable": isEditable,
      				"fieldName": record[i].data.fieldName,
      			     "formAliasName": record[i].data.formAliasName,
      				 "formName":record[i].data.formName,
      				 "id": record[i].data.id,
      				 "isLocked": record[i].data.isLocked,
      				 "wsModuleInformation": record[i].data.wsModuleInformation
      			});
      		}
      		submitUrl = SERVERURL.PATH_UPDATE_ALL_FORM_FIELD_INFORMATION;
      		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      		Ext.Ajax.request({
      			type : 'rest',
      			url : submitUrl,
      			jsonData : configureArray,
      			method : 'POST',
      			success : function(form, action) {
      				Ext.getBody().unmask();
      				showSuccessMessage(getCommonTranslation('CONFIGURE_SCREEN'),getCommonTranslation('SUCCESS'));
      				grid.getStore().load();
      				gridParent.getStore().load();
      			}
      		});
      }
});
