/**
 * This controller is used for the Visitors Add/Edit/delete/view
 * 
 * @author Abhishek Chouhan
 */
Ext.define('Academia.controller.sgmanagement.sgvisitor.sgVisitorController',
		{
	extend : 'Academia.controller.personinfo.common.PersonCommonController',
	stores : [ 'common.CountryStore','hostel.roomallocation.UserSmartSearchByUserType','sgvisitor.SgVisitorCardStore',
		'sgvisitor.SgManageVisitorStore','sgappointment.sgappointment.SGVisitorCategoryStore',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
		'sgvisitor.SgAllVisitorCardStore','sgvisitor.SgAllVisitorNameStore','sgappointment.sgappointment.SGBookingIDStore',
		'sgvisitor.SgAllVisitorNoStore','feeandpayment.managebill.Student','sgappointment.sgappointment.SGParentGuardianStore',
		'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
		'sgvisitor.SgVisitorDetailsByNameStore','enquiry.ReferredInternalUserId','criteriabuilder.userquicksearch.QuickSearchName',
		'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch','sgvisitor.SgVisitorFindByBookingId',
		'sgvisitor.SgVisitorFindByStudent','sgvisitor.SgVisitorEarlierContactIdStore',
		],
		views : ['securitygatemanagement.Sgvisitormangementstructure','criteriabuilder.userquicksearch.UserUploadForm',
			'securitygatemanagement.SgVisitorFilter','webcam.ImageCaptureWindow',
			'securitygatemanagement.SgManageVisitorGrid','securitygatemanagement.SgAddVisitor',
			'baselayout.contentarea.ContentPanel','sgappointment.sgappointment.SGReasonToMeetGridWin',
			'personinfo.common.personalinfo.PhotoUploadForm','securitygatemanagement.SgVisitorCardWindow',
			'securitygatemanagement.PrintDocumentWindow'
			],
			config:{
				VISITOR_MANAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VISITOR_MANAGE_PRIVILEGES')

			},
			refs : [{
				ref : 'sgvisitormangementstructure',
				selector : 'sgvisitormangementstructure'
			},{
				ref : 'sgvisitorfilter',
				selector : 'sgvisitorfilter'
			},{
				ref : 'sgmanagevisitorgrid',
				selector : 'sgmanagevisitorgrid'
			},{
				ref : 'sgaddvisitor',
				selector : 'sgaddvisitor'
			},{
				ref : 'contentpanel',
				selector : 'contentpanel'
			},{
				ref : 'sgreasontomeetgridwin',
				selector : 'sgreasontomeetgridwin'
			},{
				ref : 'imageCaptureWindow',
				selector : 'imagecapturewindow[itemId=sgvisitor]'
			},{
				ref : 'imageCaptureWindow',
				selector : 'imagecapturewindow' 
			},{
				ref : 'imageCaptureForm',
				selector : 'imagecapturewindow form' 
			},{
				ref : 'sgvisitorcardwindow',
				selector : 'sgvisitorcardwindow' 
			},{
				ref : 'printdocumentwindow',
				selector : 'printdocumentwindow' 
			},{
				ref : 'printdocumentwindow',
				selector : 'printdocumentwindow form' 
			}],
			init : function() {
				var trigger = null;
				this.control({
					'sgvisitormangementstructure' : {
						render : function(grid) {
							this.doAccessControlValidation(grid, this.getVISITOR_MANAGE_PERMISSIONS());
						}
					},
					'sgvisitormangementstructure sgmanagevisitorgrid' : {
						render : function(grid) {
							this.doAccessControlValidation(grid, this.getVISITOR_MANAGE_PERMISSIONS());
							this.disableSgGridMoreActionPivileges(grid, this.getVISITOR_MANAGE_PERMISSIONS());
						},
						 afterrender:function(grid){
         					var me = this;
         					setTimeout(function(){
         						me.addDataGridConfigButton(grid,me.getVISITOR_MANAGE_PERMISSIONS());
         					},1500);
         				 }
					},
					'sgmanagevisitorgrid button[itemId=btnAdd]' : {
						click : function() {
							this.addVisitorEntryTab();
							this.setEntrybyValuebydefault();
							this.getDefaultImage();
					    	 var form=this.getSgaddvisitor();
           				   var countryCodeField=form.down("#personPhoneCountryCode");
                       	   var mobileField = form.down("#personContactNo");
                       	  this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                       	  this.removePlaceHolder();

							/*var visitorProfile = this.getContentPanelActiveTab();
	                				   Ext.apply(visitorProfile, {
	                      					visitorUplaodSnap : null,
	                      					setVisitorSnap : function(visitorUplaodSnap) {
	                      						visitorProfile.visitorUplaodSnap = visitorUplaodSnap;
	                      					},
	                      				});*/
						}
					},
					'sgmanagevisitorgrid' : {
						cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
							var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;

							if(columnName == "reasonToVisit"){
								if(e.target.tagName=='A'){
									this.getReasonToMeetGridWindow(grid,record);
								}
							}
							if(columnName == "visitorCardNo"){
								if(e.target.tagName=='A'){
									this.getVisitorCardNoGridWindow(grid,record);
								}
							}
							/* if(columnName == "visitorCardNo"){
                    				   if (e.target.tagName == 'A') {
                    					   var visitorCardNo = record.get("visitorCardNo");
                    					   if (!isNullOrEmpty(visitorCardNo)) {
                    						   this.getDownloadFileForResumePDocument(visitorCardNo);
                    					   }
                    				   }
                    				  }*/
						},
					},
					'sgmanagevisitorgrid button[itemId=btnEdit]' : {
						click : this.editVisitorRecord
						
					},
					'sgmanagevisitorgrid button[itemId=btnView]' : {
						click : this.viewVisitorRecord
					},
					'sgmanagevisitorgrid button[itemId=btnDelete]' : {
						click : function() {
							this.deleteSGVisitorRecord();
						}
					},
					'sgaddvisitor button[itemId=resetVisitor]' : {
						click : function() {
							var form=this.getSgaddvisitor();
							form.getForm().reset();
							this.getDefaultImage();
							var parentName=form.getForm().findField('parentName');
							var visitorName=form.getForm().findField('visitorName');
							var inTime= form.getForm().findField('inTime');
							inTime.setValue(new Date());
							parentName.setVisible(false);
							visitorName.setVisible(false);
							//profileImage.reset();
						}
					},
					'sgaddvisitor' : {
						render : function(obj) {
							var bookingDate = obj.down("#bookingDate");
							bookingDate.setVisible(false);
							this.setAllowBlank(bookingDate,true);
						}   
					},
					'sgaddvisitor combo[itemId=parentName]':{
						render: function(obj){
							var store = obj.getStore();
							store.getProxy().extraParams = {
								academyLocationIds:this.getCurrentAcademyLocation()
							};
							store.load();
						}
					},
					/*  'sgaddvisitor combo[itemId=visitorName]':{
	                			   render: function(obj){
	                				   var store = obj.getStore();
	                				   store.getProxy().extraParams = {
	                					   visitorName:this.getCurrentAcademyLocation()
	                				   };
	                				   store.load();
	                			   }
	                		   },*/
					'sgvisitorfilter button[itemId=resetButtonId]' : {
						click : function() {
							var form=this.getSgvisitorfilter();
							var endDate=form.getForm().findField('endDate');
							var startDate=form.getForm().findField('startDate');
							var inTime=form.down('#fromTime');
							var outTime=form.getForm().findField('toTime');
							endDate.reset();
							startDate.reset();
							startDate.setMinValue(null);
							endDate.setMinValue(null);
							startDate.setMaxValue(null);
							endDate.setMaxValue(null);
							inTime.setMinValue(null);
							outTime.setMinValue(null);
							inTime.setMaxValue(null);
							outTime.setMaxValue(null);
							form.getForm().reset();
						}
					},
					'sgvisitorfilter button[itemId=searchButtonId]' : {
						click : function() {
							this.loadSgVisitorGrid();
						}
					},
					'sgaddvisitor radiogroup[itemId=formNoManuallyId]':{
						change:function(obj,data){
							var this$ = this;
							var form = obj.up('sgaddvisitor');
							var formNoId = form.down("#visitorCardNo");
							var  manualCardNo = form.down("#manualCardNo");
							var value = obj.getValue();
							var isFormNoManually = value.isFormNoManually;
							formNoId.reset();
							setTimeout(function(){
								if(isFormNoManually){
									formNoId.setVisible(true);
									formNoId.allowBlank = false;
									this$.setAllowBlank(formNoId, false);
									manualCardNo.allowBlank = true;
									this$.setAllowBlank(manualCardNo, true);
									manualCardNo.setVisible(false);
								}else{
									formNoId.setVisible(false);
									formNoId.allowBlank = true;
									this$.setAllowBlank(formNoId, true);
									manualCardNo.allowBlank = false;
									this$.setAllowBlank(manualCardNo, false);
									manualCardNo.setVisible(true);
								}
								form.isValid();
								Ext.resumeLayouts();
         					},100);
						},
						beforerender:function(obj,data){
							var form = obj.up('sgaddvisitor');
							var formNoId = form.down("#visitorCardNo");
							var  manualCardNo = form.down("#manualCardNo");
							var value = obj.getValue();
							var isFormNoManually = value.isFormNoManually;
							formNoId.reset();
							if(isFormNoManually){
								formNoId.setVisible(true);
								formNoId.allowBlank = false;
								manualCardNo.allowBlank = true;
								manualCardNo.setVisible(false);
							}else{
								formNoId.setVisible(false);
								formNoId.allowBlank = true;
								// form.down("#manualCardNo").setFieldLabel(getServiceRequestTranslation('CARD_NO')+'<span class="required" style="color:red"> *</span>');
								manualCardNo.allowBlank = true;
								manualCardNo.setVisible(true);
							}
							// formNoId.validate();
							// Ext.resumeLayouts();
						}
					},
					'sgaddvisitor combo#parentName' : {
						select : function(obj,record){
							this.getParentDetails();
						}
					},
					'sgaddvisitor combo#bookingId' : {
						select : function(obj,record){
							this.getBookingDetails();
						}/*,
					    blur : function(obj){
						form=this.getSgaddvisitor();
						var isAppointment=form.getForm().findField('isAppointment');
						var bookingId=form.getForm().findField('bookingId');
						if(isAppointment.getValue() && isNullOrEmpty(bookingId.getValue()))
						{
							form.getForm().reset();
							isAppointment.setValue(false);
							bookingId.setVisible(false);
							showWarningMessage(getServiceRequestTranslation('SG_VISITOR'), getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER')); 
						}
					}*/
					},
					'sgaddvisitor combo#personToMeet' : {
						select : function(obj,record){
							this.getPersonDetails();
						}
					},
					'sgaddvisitor textfield[itemId=manualCardNo]' : {
						blur : function(response){
							//this.checkUniquenessForVisitorCard(response);
						}
					},

					'sgaddvisitor combo[itemId=personToMeet]':{
						render: function(obj){
							var store = obj.getStore();
							store.getProxy().extraParams = {
								academyLocationIds:this.getCurrentAcademyLocation()
							};
							store.load();
						}
					},
					'sgaddvisitor combo[itemId=visitorName]' : {
						select : function(obj,record){
							this.getVisitorDetails(obj,record);
							trigger=null;
							trigger=record;
						}/*,
						blur : function(obj){
							form=this.getSgaddvisitor();
							var isAppointment=form.getForm().findField('isAppointment');
							var bookingId=form.getForm().findField('bookingId');
							if(isAppointment.getValue() && isNullOrEmpty(trigger))
							{
								isAppointment.setValue(false);
								bookingId.setVisible(false);
								showWarningMessage(getServiceRequestTranslation('SG_VISITOR'), getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER')); 
							}
						}*/
					},
					'sgaddvisitor combo#outTime' : {
						select : function(obj,record){
							form=this.getSgaddvisitor();
							var  visitorCategory= form.down("#visitorCategory").getValue();
							var isGoingOutWithStudent=form.down("#isGoingOutWithStudent");
							if(visitorCategory==1)
							{
								isGoingOutWithStudent.setVisible(true);
							}
						}
					},
					'sgaddvisitor combo#visitorCategory' : {
						select : function(obj,record){
							var visitorCategory = record[0].get("name");
							var form =this.getSgaddvisitor();
							var visitoOrganization= form.getForm().findField('visitorOrganization');
							var  visitorPlace=form.getForm().findField('visitorPlace');
							var bookingId=form.getForm().findField('bookingId');
							var address=form.getForm().findField('visitorAddress');
							var emailId=form.getForm().findField('visitorEmailId');
							var visitorName=form.getForm().findField('visitorName');
							var contactNo=form.getForm().findField('personContactNo');
							var parentName=form.getForm().findField('parentName');
							var studentName=form.getForm().findField('studentName');
							var isAppointment=form.getForm().findField('isAppointment');
							var isMultiDayPass=form.getForm().findField('isMultiDayPass');
							var bookingDate=form.getForm().findField('bookingDate');
							var personToMeet=form.getForm().findField('personToMeet');
							var others= form.getForm().findField('otherVisitor')
							visitorName.reset();
						    parentName.reset();
							var store = visitorName.getStore();
							if(isAppointment.getValue()==true){
								var bookingStore=bookingId.getStore();
								 bookingId.lastQuery=null;
								 bookingStore.getProxy().extraParams={
									visitorCategory:record[0].data.id
								};
								bookingStore.load();
							}
								store.getProxy().extraParams={
									visitorCategory:record[0].data.id
								};
								store.load();


								if(record[0].data.id==1)
								{
									visitoOrganization.setVisible(false);
									visitorPlace.setVisible(false);
									visitorName.setVisible(false);
									visitorName.allowBlank = true;
									visitorName.reset();
									emailId.setVisible(true);
									parentName.setVisible(true);
									isMultiDayPass.setVisible(false);
									this.setAllowBlank(parentName,false);
									//parentName.allowBlank = false;
									others.setVisible(false);
									others.reset();
									others.allowBlank = true;
									emailId.setFieldLabel(getServiceRequestTranslation('PARENT_EMAIL_ID'));
									address.setFieldLabel(getServiceRequestTranslation('PARENT_ADDRESS'));
									if(isAppointment.getValue()){
										isAppointment.setVisible(true);
										// bookingId.readOnly = true;
										bookingId.setVisible(true);
										bookingId.reset();
										//bookingDate.reset();
										personToMeet.reset();
									}
								} else  if(record[0].data.id>5) {
									visitoOrganization.setVisible(true);
									visitorPlace.setVisible(true);
									address.setFieldLabel(getServiceRequestTranslation('VISITOR_ADDRESS'));
									emailId.setVisible(false);
									visitorName.setVisible(false);
									visitorName.reset();
									visitorName.allowBlank=true
									parentName.setVisible(false);
									parentName.allowBlank = true;
									others.setVisible(true);
									isMultiDayPass.setVisible(true);
									//others.allowBlank = false;
									this.setAllowBlank(others,false);
									//  contactNo.setFieldLabel(getServiceRequestTranslation('VISITOR_CONTACT_NO'));
									if(isAppointment.getValue()){
										isAppointment.setVisible(true);
										//  bookingId.readOnly = true;
										bookingId.setVisible(true);
										bookingId.setReadOnly(false);
										bookingId.reset();
										//bookingDate.reset();
										personToMeet.reset();
									}
									form.down("#visitorphoneCountryCode").setEditable(true);
									var countryCodeFieldArray = ["#visitorphoneCountryCode"]
									this.setDefaultCountryCode(form, countryCodeFieldArray);
									var countryCodeField = form.down("#visitorphoneCountryCode");
	                              	var mobileField = form.down("#visitorContactNo");
	                              	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	                 			
								} else {
									if(record[0].data.id==2){
										visitorName.setFieldLabel(getCommonTranslation('ENQUIRER_NAME'));
										emailId.setFieldLabel(getCommonTranslation('EMAIL_ID'));
									}
									else if(record[0].data.id==3){
										visitorName.setFieldLabel(getServiceRequestTranslation('STUDENT_NAME'));
										emailId.setFieldLabel(getCommonTranslation('EMAIL_ID'));
									}
									else if(record[0].data.id==4){
										visitorName.setFieldLabel(getServiceRequestTranslation('EMPLOYEE_NAME'));
										emailId.setFieldLabel(getCommonTranslation('EMAIL_ID'));
									}
									else if(record[0].data.id==5){
										visitorName.setFieldLabel(getCommonTranslation('APPLICANT_NAME'));
										emailId.setFieldLabel(getCommonTranslation('EMAIL_ID'));
									}
									visitoOrganization.setVisible(true);
									visitorPlace.setVisible(true);
									address.setFieldLabel(getServiceRequestTranslation('VISITOR_ADDRESS'));
									emailId.setVisible(false);
									visitorName.setVisible(true);
									visitorName.reset();
									parentName.setVisible(false);
									parentName.allowBlank = true;
									isMultiDayPass.setVisible(true);
									others.setVisible(false);
									others.reset();
									this.setAllowBlank(visitorName,false);
									//visitorName.allowBlank = false;
									others.allowBlank = true;
									//  contactNo.setFieldLabel(getServiceRequestTranslation('VISITOR_CONTACT_NO'));
									if(isAppointment.getValue()){
										isAppointment.setVisible(true);
										//  bookingId.readOnly = true;
										bookingId.setVisible(true);
										bookingId.setReadOnly(false);
										bookingId.reset();
										//bookingDate.reset();
										personToMeet.reset();
									}

								}
								
							//}
							/*else{
								var bookingStore=bookingId.getStore();
								bookingStore.getProxy().extraParams={
									visitorCategory:record[0].data.id
								};
								bookingStore.load();
							}*/
						}
					},  
					/*'sgaddvisitor photouploadform[itemId=logoUploadField] filefield[itemId=photoFileImage]':{
	            	        	 change: function(photoFileImage, value, eOpts) {
	            	            		value = value.replace('C:\\fakepath\\', '');
	            	            		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	            	            		photoFileImage.setRawValue(newValue);
	            	            	}
	                		   },*/
					'sgaddvisitor checkboxfield[itemId=isAppointment]' : { 
						change : function($this,data){
							var form =this.getSgaddvisitor();
							var appointment= form.getForm().findField('isAppointment').getValue();
							var bookingId=form.getForm().findField('bookingId');
							var visitorCategory=form.getForm().findField('visitorCategory');
							var parentName=form.getForm().findField('parentName');
							var visitorName=form.getForm().findField('visitorName');
							var visitorphoneCountryCode=form.getForm().findField('visitorphoneCountryCode');
							var visitorContactNo=form.getForm().findField('visitorContactNo');
							var visitorEmailId=form.getForm().findField('visitorEmailId');
							var bookingDate=form.getForm().findField('bookingDate');
							var meetingDate=form.getForm().findField('meetingDate');
							var reasonToVisit=form.getForm().findField('reasonToVisit');
							
							//var studentName=form.getForm().findField('studentName');
							visitorName.setVisible(false);
							parentName.setVisible(false);
							form.getForm().findField('otherVisitor').setVisible(false);
							form.getForm().findField('bookingId');
							if(appointment==true)
							{ 
								
								bookingId.lastQuery=null;
								bookingId.getStore().getProxy().extraParams = {
									visitorCategory:null
		         				   }
								bookingId.reset();
								visitorCategory.reset();
								parentName.reset();
								visitorName.reset();
								visitorphoneCountryCode.reset();
								visitorContactNo.reset();
								visitorEmailId.reset();
								bookingId.setVisible(true);
								bookingDate.setVisible(true);
								this.setAllowBlank(bookingDate,false);
								visitorName.setReadOnly(true);
								parentName.setReadOnly(true);
								visitorName.emptyText = [ '' ];
								visitorName.reset();
								parentName.emptyText = [ '' ];
								parentName.reset();

							}
							else {
								form.getForm().reset();
								bookingId.setVisible(false);
								bookingDate.setVisible(false);
								this.setAllowBlank(bookingDate,true);
								visitorName.setReadOnly(false);
								parentName.setReadOnly(false);
								visitorName.emptyText = getCommonTranslation('ENTER_THREE_CHAR');
								parentName.emptyText = getCommonTranslation('ENTER_THREE_CHAR');
								visitorCategory.setReadOnly(false);
								bookingDate.setReadOnly(false);
								visitorName.reset();
								visitorCategory.reset();
								visitorContactNo.reset();
								visitorphoneCountryCode.reset();
								meetingDate.reset();
								reasonToVisit.reset();
							}
						}
					},
					'sgaddvisitor checkboxfield[itemId=isEarlierAppointment]' : { 
						change : function($this,data){
							var form =this.getSgaddvisitor();
							var earlierappointment= form.getForm().findField('isEarlierAppointment').getValue();
							var earlierContactId=form.getForm().findField('earlierContactId');
							var visitorCategory=form.getForm().findField('visitorCategory').getValue();
							var bookingDate=form.getForm().findField('bookingDate');
							var visitorName=form.getForm().findField('visitorName');
							var manualCardNo=form.getForm().findField('manualCardNo').getValue();
							var parentName=form.getForm().findField('parentName');
							var entryBy=form.getForm().findField('entryBy');
							var visitorName = form.down('#visitorName');
							var visitorVehicleNo= form.down("#visitorVehicleNo");
							  var visitorContactNo =form.down("#visitorContactNo");
							var visitorAddress =  form.down("#visitorAddress");
							var visitorCardNo = form.down('#visitorCardNo');
							var visitorphoneCountryCode= form.down("#visitorphoneCountryCode");
							var reasonToVisit =form.down("#reasonToVisit");
						     var personContactNo =form.down("#personContactNo");
						     var  personPhoneCountryCode=form.down("#personPhoneCountryCode");
						        var entryBy = form.down("#entryBy");
						       var personToMeet = form.down("#personToMeet");
						       var meetingDate =form.down("#meetingDate");
						       var visitorCategoryEarlier=form.down("#visitorCategory");
						        var inTime  =  form.down("#inTime");
                              var otherVisitor = form.down("#otherVisitor");
							
							if(earlierappointment==true){
								
								earlierContactId.setVisible(true);
								this.setAllowBlank(visitorName, true);
								this.setAllowBlank(parentName, true);
							}else{
								earlierContactId.setVisible(false);
								visitorName.reset();
								visitorVehicleNo.reset();
								visitorContactNo.reset();
								earlierContactId.reset();
								visitorAddress.reset();
								visitorphoneCountryCode.reset();
								reasonToVisit.reset();
								personContactNo.reset();
								personPhoneCountryCode.reset();
								entryBy.reset();
								personToMeet.reset();
								meetingDate.reset();
								visitorCategoryEarlier.reset();
								inTime.reset();
								otherVisitor.reset();
								
							}
							
							
						}
					},
					'sgaddvisitor customcombobox[itemId=earlierContactId]' : { 
						select:function(obj,rec){
							var this$ = this;
             				var form=this.getSgaddvisitor();
             				var earlierContactId=form.getForm().findField('earlierContactId').getValue();
             				var visitorCategory=form.down("#visitorCategory");
             				var visitorVehicleNo=form.down("#visitorVehicleNo");
             			  var visitorphoneCountryCode=form.down("#visitorphoneCountryCode");
             			  var personPhoneCountryCode=form.down("#personPhoneCountryCode");
             				var countryCodeField = form.down("#personPhoneCountryCode");
                          	var mobileField = form.down("#personContactNo");
                          	var entryBy = form.down("#entryBy");
                          	var visitorNameField = form.down("#visitorName");
                          	var otherVisitorField = form.down("#otherVisitor");
                          	var parentNames = form.down('#parentName');
                          	
                          	Ext.Ajax.request({
								method : "GET",
								type : 'rest',
								async: false,
								url: SERVERURL.PATH_FIND_VISITOR_DETAIL_EARLIER_CONTACT_ID,
								params: {
									earlierContactId : earlierContactId
						
								},
								headers : {
									'Content-Type' : 'application/json'
								},
								success: function(f, action) {
									var data = Ext.decode(f.responseText);
									var visitorCategoryId =	data[0].visitorCategoryId;
									//var otherVisitorId=data[0].id;
									var visitorVehicleNo =	data[0].visitorVehicleNo;
									var visitorContactNo =	data[0].visitorContactNo;
									 var personContactNo = data[0].personContactNo;
									 var visitorName =  data[0].visitorName;
									
									 var personContactNoIsdCode = ""; 

									 if (personContactNo && personContactNo.includes("-")) {
									     personContactNoIsdCode = personContactNo.split("-")[0];
									     personContactNoIsdCodeSplit =personContactNo.split("-")[1];
									 }
									 var isdCode = "";
									 if (visitorContactNo && visitorContactNo.includes("-")) {
										 var isdCode = visitorContactNo.split("-")[0];
										 var visitorContactNosplit = visitorContactNo.split("-")[1];
									 }
									 
									var visitorEmailId    = data[0].visitorEmailId;
									var reasonToVisit=   data[0].reasonToVisit;
									var personToMeet  =  data[0].personToMeet;
									var visitorAddress= data[0].visitorAddress;
									var meetingDate=data[0].meetingDate;
									 var entryByName=  data[0].entryByName;
									 var entryById=data[0].entryById;
									 var  enquiryId  =  data[0].enquiryId;
									 var parentId = data[0].parentId;
									 var meetingDates=  new Date(meetingDate);
									 
									
									 
									 if(visitorCategoryId == 1){
										 parentNames.setVisible(true);
										// this.setAllowBlank(parentNames, false);
										 
										 //visitorCategory.setVisible(false);
										// this.setAllowBlank(visitorCategory, true);
										 parentNames.getStore().getProxy().extraParams = {
											 visitorCategory:data[0].visitorCategoryId
										 };
										 parentNames.getStore().load({
											 callback: function(){
												 parentNames.setValue(data[0].parentId);
											 }
										 })
									 }else if(visitorCategoryId == 2){
										 visitorNameField.setVisible(true) ;
										
										 visitorNameField.getStore().getProxy().extraParams = {
												visitorCategory:data[0].visitorCategoryId
											};
											visitorNameField.getStore().load({
												callback:function(records, operation, success) {											
													form.down("#visitorName").setValue(data[0].enquiryId);
													
												}
											})
									 }
									 else if(visitorCategoryId == 3){
										 visitorNameField.setVisible(true);
										 visitorNameField.getStore().getProxy().extraParams = {
												visitorCategory:data[0].visitorCategoryId
											};
											visitorNameField.getStore().load({
												callback:function(records, operation, success) {											
													form.down("#visitorName").setValue(data[0].studentPersonId);
													
												}
											})
									 }
									 else if(visitorCategoryId == 5){
										 visitorNameField.setVisible(true);
										 visitorNameField.getStore().getProxy().extraParams = {
												visitorCategory:data[0].visitorCategoryId
											};
											visitorNameField.getStore().load({
												callback:function(records, operation, success) {											
													form.down("#visitorName").setValue(data[0].applicantId);
										
												}
											})
									 }
									 else if(visitorCategoryId == 4){
										 visitorNameField.setVisible(true);
										// visitorName.setFieldLabel(getServiceRequestTranslation('STUDENT_NAME'));
										 visitorNameField.getStore().getProxy().extraParams = {
												visitorCategory:data[0].visitorCategoryId
											};
											visitorNameField.getStore().load({
												callback:function(records, operation, success) {											
													form.down("#visitorName").setValue(data[0].staffId);
													//form.down("#visitorName").setValue(data[0].parentId);
												}
											})
									 }
									 else if(visitorCategoryId > 5){
										 visitorNameField.setVisible(false);
										 otherVisitorField.setVisible(true);
										 form.down("#otherVisitor").setValue(data[0].visitorName);
										
									 }
									
								
									visitorCategory.getStore().load({
										callback:function() {											
											form.down("#visitorCategory").setValue(data[0].visitorCategoryId);
											
											
										}
									})
									form.down("#visitorVehicleNo").setValue(data[0].visitorVehicleNo);
									visitorphoneCountryCode.getStore().load({
										callback:function(records, operation, success) {											
											form.down("#visitorphoneCountryCode").setValue(isdCode);
									
										}
									})
									personPhoneCountryCode.getStore().load({
										callback:function(records, operation, success) {											
											form.down("#personPhoneCountryCode").setValue(personContactNoIsdCode);
									
										}
									})
									entryBy.getStore().load({
										callback:function(records, operation, success) {											
											form.down("#entryBy").setValue(data[0].entryById);
									
										}
									})
									
									form.down("#visitorEmailId").setValue(data[0].visitorEmailId);
									form.down("#reasonToVisit").setValue(data[0].reasonToVisit);
									form.down("#personToMeet").setValue(data[0].personToMeet);
									form.down("#meetingDate","d/m/Y").setValue(new Date(data[0].meetingDate));
									form.down("#visitorAddress").setValue(data[0].visitorAddress);
									form.down("#visitorContactNo").setValue(visitorContactNosplit);
									if(!isNullOrEmpty(personContactNoIsdCode)){
										form.down("#personContactNo").setValue(personContactNoIsdCodeSplit);
										
									
									}
									
									
								}
							});	
                          	
                          	//////////////end ajax
						}
					},

					'sgaddvisitor combo#entryBy':{
						render: function(obj){
							var store = obj.getStore();
							store.getProxy().extraParams = {
								academyLocationIds:this.getCurrentAcademyLocation()
							};
							store.load();
						}
					},
					'sgaddvisitor combo#inTime':{
						render: function(obj){
							var form =this.getSgaddvisitor();
							var inTime= form.getForm().findField('inTime');
							inTime.setValue(new Date());
						},
						change : function(){
                            var form =this.getSgaddvisitor();
                            var inTime= form.getForm().findField('inTime');
                            var outTime= form.getForm().findField('outTime');
                            outTime.setMinValue(inTime.getValue());
                        }
					},
					'sgaddvisitor checkboxfield[itemId=isMultiDayPass]' : { 
						change : function($this,data){
							var form =this.getSgaddvisitor();
							var isMultiDayPass= form.getForm().findField('isMultiDayPass').getValue();
							var meetingDate=form.getForm().findField('meetingDate');

							var tillDate=form.getForm().findField('tillDate');
							if(isMultiDayPass==true)
							{
								tillDate.setVisible(true);
								tillDate.allowBlank=false;

							}
							else {
								tillDate.setVisible(false);
								tillDate.setValue();
								tillDate.allowBlank=true;
							}
							form.getForm().checkValidity();
						}
					},
					'sgaddvisitor button[itemId=saveVisitor]':{
						click: function(btn) {
							this.saveVisitorEntry(btn);
						}
					},
					'imagecapturewindow button#capturebuttonId':{
						click : this.captureVisitorProfilePhoto
					},
					'imagecapturewindow button#previewbuttonId':{
						click : this.previewVisitorProfilePhoto
					},
					'imagecapturewindow[itemId=sgvisitor] button#resetbuttonId':{
						click : function(btn){
							btn.up('window').close();
							Ext.widget('imagecapturewindow').show();
						}
					},
					'imagecapturewindow[itemId=sgvisitor] button#SubmitBtn':{
						click : function(btn){
							this.saveCapturedIMage(btn);
						}
					},
					'imagecapturewindow button#CancelBtn':{
						click : function(btn){
							btn.up('window').close();
						}
					},
					'imagecapturewindow' : {
						close : function(obj){
							Webcam.userMedia=true;
							Webcam.reset();
						}
					}, 'sgaddvisitor customcombobox[itemId=personPhoneCountryCode]': {
             			select: function(rowModel, record){
             				var this$ = this;
             				var form=this.getSgaddvisitor();var countryCodeField = form.down("#personPhoneCountryCode");
                          	var mobileField = form.down("#personContactNo");
                          	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
             			}
             		},
             		'sgaddvisitor numberfield[itemId=personContactNo]': {
             			change: function(record){
             				var this$ = this;
             				var form=this.getSgaddvisitor();
                             var mobileField = form.down("#personContactNo");
                         	mobileField.isValid();
                 			form.getForm().checkValidity();
                         }
             		},
                         'sgaddvisitor customcombobox[itemId=visitorphoneCountryCode]': {
                  			select: function(rowModel, record){
                 				var this$ = this;
                 				var form=this.getSgaddvisitor();
                 				var countryCodeField = form.down("#visitorphoneCountryCode");
                              	var mobileField = form.down("#visitorContactNo");
                              	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                 			}
                 		},
                 		'sgaddvisitor numberfield[itemId=visitorContactNo]': {
                 			change: function(record){
                 				var this$ = this;
                 				var form=this.getSgaddvisitor();
                                 var mobileField = form.down("#visitorContactNo");
                             	mobileField.isValid();
                     			form.getForm().checkValidity();
                             }
                 		},
                 		 'sgmanagevisitorgrid menuitem[itemId=printDocuments]': {
             	            click: function(obj) {
             	            	var grid = this.getSgmanagevisitorgrid();
             	            	if (grid.getSelectionModel().getCount() > 0) {
             	            		this.showPrintDocumentWindow();
             	            	} else {
             	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
             	            	}
             	            }
             	        },
             	       'printdocumentwindow button#btnPrint': {
           	        	click: function(button) {
           	        		var grid = this.getSgmanagevisitorgrid();
           	        		this.exportPrintGatePass(grid);
               			}
           	        },
				});
			},

			/**
			 * Add New Tab
			 */
			addVisitorEntryTab : function() {
				var me = this;
				var contentpanel = this.getContentpanel();
				var addVisitor = Ext.widget('sgaddvisitor');
				var tabName = getServiceRequestTranslation('SG_VISITOR_DETAILS');

				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				openTab(contentpanel, tabName, addVisitor,CONSTANTS.MENU_COLOR_NINE);	
			},
			
			/*checkUniquenessForVisitorCard : function(response) {
				$this=this;
				form=this.getSgaddvisitor();
				var manualCardNo=form.getForm().findField('manualCardNo').getValue();
				form.config.isValid=false;
				var id = form.getForm().findField('id').getValue();
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.SG_VISITOR_CARD_CHECK_UNIQUENESS,
					params : {
						visitorCard : manualCardNo,
						id : id,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(resp, action) {
						var mssg = resp.responseText;
						if (mssg == "false") {
							showWarningMessage(getCommonTranslation('ALERT'),
									getServiceRequestTranslation('SG_VISITOR_CARD_ALREADY_EXISTS'));
							form.getForm().findField('manualCardNo').reset();
							form.config.isValid=false;
						}else{
							
							form.config.isValid=true;
							
						}
					}
				});
			},*/
			//************* Add Visitor details records********************
			saveVisitorEntry: function(btn){
				$this=this;
				var form=this.getSgaddvisitor();
				var submitUrl,isUpdate = false;
				if (isNullOrEmpty(form.getForm().getValues().id)) {
					submitUrl = SERVERURL.SG_MANAGE_VISITORS_SAVE;
					isUpdate = false;
				} else {
					submitUrl =SERVERURL.SG_MANAGE_VISITORS_UPDATE;
					isUpdate = true;
				}
				var manualCardNo=form.getForm().findField('manualCardNo').getValue();
				
				var id = form.getForm().findField('id').getValue();
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.SG_VISITOR_CARD_CHECK_UNIQUENESS,
					params : {
						visitorCard : manualCardNo,
						id : id,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(resp, action) {
						var mssg = resp.responseText;
						var sgAddvisitor = $this.getSgaddvisitor();
						if (mssg == "false" && isUpdate==false) {
							showWarningMessage(getCommonTranslation('ALERT'),
							getServiceRequestTranslation('SG_VISITOR_CARD_ALREADY_EXISTS'));
							sgAddvisitor.getForm().findField('manualCardNo').reset();
						}else{
							var getuploadValue = btn.up('form');
							var personProfile = $this.getContentPanelActiveTab();
							var parentStore=sgAddvisitor.down("#parentName").getStore();
							var parentStoreValue=sgAddvisitor.down("#parentName").getValue();
							var uploadForm = sgAddvisitor.down('#logoUploadField');
							var others=sgAddvisitor.down('#otherVisitor');
							var photoFileImage = uploadForm.down('filefield#photoFileImage');
							var fileUploadPath = photoFileImage.getValue();
							var grid = $this.getSgmanagevisitorgrid();
							var form = sgAddvisitor.getForm();
							var formValues = form.getValues();
							var id=formValues.id;
							var tabName = getServiceRequestTranslation('ADD_ENTRY');
							var personImagePath=$this.getSgaddvisitor().down("#logoUploadField").down("#photoFileImage").getValue();
							var personId;
							var enquirer;
							var applicant;
							var visitorCategory={
									id:formValues.visitorCategory
							};
							var entryBy={
									id:formValues.entryBy
							};
							/*var submitUrl,isUpdate = false;
									if (isNullOrEmpty(formValues.id)) {
										submitUrl = SERVERURL.SG_MANAGE_VISITORS_SAVE;
										isUpdate = false;
									} else {
										submitUrl =SERVERURL.SG_MANAGE_VISITORS_UPDATE;
										isUpdate = true;
									}*/
							var visitormodel = new Academia.model.sgvisitor.SgManageVisitorModel();
							visitormodel.set("id",formValues.id);
							visitormodel.set("isAppointment",formValues.isAppointment);
							visitormodel.set("visitorCategory",visitorCategory);
							visitormodel.set("visitorNo",formValues.visitorNo);
							if(isNullOrEmpty(formValues.visitorCardNo))
							{
								visitormodel.set("visitorCardNo",formValues.manualCardNo);
								visitormodel.set("isManualCard",true);
							}else{
								visitormodel.set("visitorCardNo",formValues.visitorCardNo);
								visitormodel.set("isManualCard",false);
								delete formValues.manualCardNo
							}

							if(isNullOrEmpty(id))
							{
								var visitorName;
								var studentId;
								var parentPersonId;
								var str;
								var studentDetails;
								var person
								if(formValues.visitorCategory==1){

									for(var i in parentStore.data.items){
										if(parentStore.data.items[i].data.id==parentStoreValue){
											str=parentStore.data.items[i].data.value;
											parentPersonId= parentStore.data.items[i].data.id;
											var vName=str.split("-");
											/*  studentDetails=vName[1].split("/");
			   	                					   studentId=studentDetails[0].trim();*/
											studentId=parentStore.data.items[i].data.code;
										}
									}

									visitorName=vName[0].trim();
									var student={
											id:parentPersonId
									};
									var parentPerson={
											id:parentPersonId
									};	  

								}
								else if(formValues.visitorCategory>5){

									visitorName=formValues.otherVisitor;
								}

								else{ 
									var visitorStore=sgAddvisitor.down("#visitorName").getStore();
									var visitorStoreValue=sgAddvisitor.down("#visitorName").getValue();
									var enquiry;
									var application;
									for(var i in visitorStore.data.items){
										if(visitorStore.data.items[i].data.id==visitorStoreValue){
											str=visitorStore.data.items[i].data.value;

											parentPersonId= visitorStore.data.items[i].data.id;
											strSplit=str.split('/');
											visitorName=strSplit[strSplit.length-1];
											if(formValues.visitorCategory==2){
												enquiry=visitorStore.data.items[i].data.id;
											}
											else if(formValues.visitorCategory==5){
												application=visitorStore.data.items[i].data.id;
											}
											else{
												personId=visitorStore.data.items[i].data.id;
											}

										}
									}

									person={

											id:personId
									};
									if(formValues.visitorCategory==3){
										student={
												id:personId
										}
									}
									parentPerson={
											id:personId
									}

									enquirer={

											id:enquiry
									};
									applicant={
											id:application
									}
								}}
							else{ 
								//var visitorName;
								if(formValues.visitorCategory>5){

									visitorName=formValues.otherVisitor;
								}
								else
									if(formValues.visitorCategory==1){

										for(var i in parentStore.data.items){
											if(parentStore.data.items[i].data.id==parentStoreValue){
												str=parentStore.data.items[i].data.value;
												parentPersonId= parentStore.data.items[i].data.id;
												var vName=str.split("-");
												/*  studentDetails=vName[1].split("/");
			   	                					   studentId=studentDetails[0].trim();*/
												studentId=parentStore.data.items[i].data.code;
											}
										}

										visitorName=vName[0].trim();
										var student={
												id:studentId
										};
										var parentPerson={
												id:parentPersonId
										};	                		   
									}
									else{ 
										var visitorStore=sgAddvisitor.down("#visitorName").getStore();
										var visitorStoreValue=sgAddvisitor.down("#visitorName").getValue();
										for(var i in visitorStore.data.items){
											if(visitorStore.data.items[i].data.id==visitorStoreValue){
												str=visitorStore.data.items[i].data.visitorNewName;
												parentPersonId= visitorStore.data.items[i].data.id;
												visitorName=str;
												var vName=visitorName.split("/");
												visitorName=vName[vName.length-1].trim();
											}
										}

									}
								var person={

										id:personId
								}
								var student={
										id:formValues.person
								};
								var parentPerson={
										id:formValues.parentPersonId
										//id:parentPersonId
								};
								if(formValues.visitorCategory==2){
									enquirer={

											id:formValues.visitorName
									}
								}
								if(formValues.visitorCategory==5){
									applicant={
											id:formValues.visitorName
									}
								}
							}
							visitormodel.set("visitorName",visitorName);
							var countryCode=formValues.visitorphoneCountryCode;
							var mobileNo=formValues.visitorContactNo;
							var visitorMobileNoWithCode;
							if(isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo) ){
								visitorMobileNoWithCode=null;
							}else{
								visitorMobileNoWithCode=countryCode +'-'+ mobileNo;
							}
							visitormodel.set("visitorContactNo",visitorMobileNoWithCode);
							visitormodel.set("visitorEmailId",formValues.visitorEmailId);
							visitormodel.set("visitorVehicleNo",formValues.visitorVehicleNo);
							visitormodel.set("visitorOrganization",formValues.visitorOrganization);

							visitormodel.set("visitorPlace",formValues.visitorPlace);
							visitormodel.set("bookingId",formValues.bookingId);
							visitormodel.set("visitorAddress",formValues.visitorAddress);
							visitormodel.set("inTime",formValues.inTime);
							visitormodel.set("outTime",formValues.outTime);
							visitormodel.set("reasonToVisit",formValues.reasonToVisit);
							visitormodel.set("personToMeet",formValues.personToMeet);
							var personcountryCode=formValues.personPhoneCountryCode;
							var personmobileNo=formValues.personContactNo;
							var personMobileNoWithCode;
							if(isNullOrEmpty(personcountryCode) && isNullOrEmpty(personmobileNo) ){
								personMobileNoWithCode=null;
							}else{
								personMobileNoWithCode=personcountryCode +'-'+ personmobileNo;
							}
							visitormodel.set("personContactNo",personMobileNoWithCode);
							visitormodel.set("meetingDate",formValues.meetingDate);
							visitormodel.set("entryBy",entryBy);
							visitormodel.set("isGoingOutWithStudent",formValues.isGoingOutWithStudent);
							visitormodel.set("isParentOrGardian",formValues.isParentOrGardian);

							var academyLocationId={
									id:$this.getCurrentAcademyLocation()
							};
							/* if(isNullOrEmpty(formValues.academyLocationId)){
			   	                		   academyLocationId=$this.getCurrentAcademyLocation();
			   	                	   }else{
			   	                		   academyLocationId=formValues.academyLocationId;
			   	                	   }*/
							visitormodel.set("academyLocation",academyLocationId);
							if(formValues.isMultiDayPass){
								visitormodel.set("tillDate",formValues.tillDate);
							}
							visitormodel.set("isMultiDayPass",formValues.isMultiDayPass);
							//visitormodel.set("personImagePath",formValues.personImagePath);  
							if(formValues.visitorCategory==1)
							{
								visitormodel.set("person",null);
								visitormodel.set("parentPersonId",parentPerson);
								visitormodel.set("applicant",null);
								visitormodel.set("enquirer",null);
							}
							else if(formValues.visitorCategory>5){
								visitormodel.set("person",null);
								visitormodel.set("parentPersonId",null);
								visitormodel.set("applicant",null);
								visitormodel.set("enquirer",null);
							}
							else{

								//visitormodel.set("person",person);
								if(formValues.visitorCategory==2){
									visitormodel.set("enquirer",enquirer);
									visitormodel.set("person",null);
									visitormodel.set("parentPersonId",null);
									visitormodel.set("applicant",null);
								}
								else if(formValues.visitorCategory==5){
									visitormodel.set("applicant",applicant);
									visitormodel.set("person",null);
									visitormodel.set("parentPersonId",null);
									visitormodel.set("enquirer",null);
								}
								else if(formValues.visitorCategory==3){

									visitormodel.set("person",student);
									visitormodel.set("parentPersonId",null);
									visitormodel.set("applicant",null);
									visitormodel.set("enquirer",null);
								}
								else{
									visitormodel.set("person",null);
									visitormodel.set("parentPersonId",parentPerson);
									visitormodel.set("applicant",null);
									visitormodel.set("enquirer",null);
								}
								//visitormodel.set("person",formValues.person);
							}

							var bookingId= form.findField('bookingId');
							visitormodel.set("bookingDate",formValues.bookingDate);
							var isAppointment= form.findField('isAppointment');
							if(isAppointment.getValue() && isNullOrEmpty(bookingId.getValue()))
							{
								showWarningMessage(getServiceRequestTranslation('SG_VISITOR'),
										getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER')); 
								bookingId.setVisible(false);
							}
							if(personProfile.visitorSnap==undefined){
								visitormodel.set("personImagePath",formValues.personImagePath);
							}
							else{
								var visitorSnapShotPath=personProfile.visitorSnap.path
								var visitorImageByteCode=personProfile.visitorSnap.imageByteCode;
							}
							if(Ext.isDefined(visitormodel.data.entryByName)){
								delete visitormodel.data.entryByName;
							}


							var formData = Ext.encode(visitormodel.data);
							var message;
							Ext.Ajax.request({
								type : 'rest',
								url : submitUrl,
								async:false,
								jsonData : formData,
								method : 'POST',
								success : function(frm, action) {
									var data=frm.responseText;
									Ext.getBody().unmask();
									grid.getStore().reload(); 
									grid.getSelectionModel().deselectAll();
									if (isUpdate) {
										showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_VISITOR'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
										if(!isNullOrEmpty(visitorSnapShotPath))
										{
											$this.savePersonSnapshotUpload(visitorSnapShotPath,formValues.id);
											form.reset();
											$this.getDefaultImage(true);
										}/*else if (!isNullOrEmpty(fileUploadPath)){
			   	                					   $this.savePersonPhotoUpload(uploadForm,formValues.id);
			   	                					   form.reset();
			   	                					   $this.getDefaultImage();
			   	                				   }*/else{
			   	                					   form.reset();
			   	                					   $this.getDefaultImage(true);
			   	                				   }

									}
									else{
										showSuccessMessage(getServiceRequestTranslation('SG_VISITOR'), getCommonTranslation('SG_MANAGE_VISITORS_CREATED_SUCCESSFULLY'));
										if(!isNullOrEmpty(visitorSnapShotPath))
										{
											$this.savePersonSnapshotUpload(visitorSnapShotPath,data);
											form.reset();
											$this.getDefaultImage(true);
										}/*
			   	                				   else if (!isNullOrEmpty(fileUploadPath))
			   	                				   {
			   	                					   $this.savePersonPhotoUpload(uploadForm,data);
			   	                				   }*/else{
			   	                					   form.reset();
			   	                					   $this.getDefaultImage(true);
			   	                				   }

									}
								}
							});
						}
					}
				});
			 }, 

			//************* edit Visitor details records********************
			editVisitorRecord:function(){
				var $this = this;	  
				
				var grid = $this.getSgmanagevisitorgrid();
				
				if (grid.getSelectionModel().getCount() > 0) {
					$this.addVisitorEntryTab();
					var form=this.getSgaddvisitor();
					form.setTitle(getServiceRequestTranslation('SG_EDIT_VISITOR_DETAILS'));
					//sgAddvisitor.getForm().findField('#resetVisitor').setVisible(false);
					var record = grid.getSelectionModel().getSelection()[0];
					var dataModel = new Academia.model.sgvisitor.SgManageVisitorModel(record.data);
					form.loadRecord(dataModel);
					if(isNullOrEmpty(dataModel.data.personImagePath)){
						$this.getDefaultImage();
					}else{
						$this.imageRestMethod();
						form.getForm().findField('personImagePath').setValue(dataModel.data.personImagePath);
					}
					var visitorCategory= form.getForm().findField('visitorCategory');
					visitorCategory.setReadOnly(true);
					var visitorCardNo= form.getForm().findField('visitorCardNo');
					var manualCardNo= form.getForm().findField('manualCardNo');
					var visitorCardNoRead=form.down('#visitorCardNo');
					var manualCardNoRead=form.down('#manualCardNo');
					var formNoManuallyId=form.down('#formNoManuallyId');
					var others=form.down('#otherVisitor');
					form.down('#meetingDate').setValue(dateRender(record.data.meetingDate));

					form.down('#inTime').setValue(timeRender(record.data.inTime));
					form.down('#outTime').setValue(timeRender(record.data.outTime));
					if (!isNullOrEmpty(record.data.isManualCard) && record.data.isManualCard) {
						formNoManuallyId.setValue({isFormNoManually:!record.data.isManualCard});
					}
					formNoManuallyId.setReadOnly(true);

					// form.down('#parentName').setDisabled(true);
					visitorCardNoRead.setVisible(false);
					manualCardNoRead.setVisible(true);
					visitorCardNo.allowBlank = true;
					//visitorCardNo.setReadOnly(true);
					var personToMeet= form.getForm().findField('personToMeet');
					var entryBy= form.getForm().findField('entryBy');
					var personContactNo= form.getForm().findField('personContactNo');
					var visitorContactNo= form.getForm().findField('visitorContactNo');
					var visitorVehicleNo= form.getForm().findField('visitorVehicleNo');
					var resetButton =form.down('#resetVisitor');
					resetButton.setVisible(false);
					form.down('#saveVisitor').addCls('alone-footer-btn');
					var visitoOrganization= form.getForm().findField('visitorOrganization');
					var  visitorPlace=form.getForm().findField('visitorPlace');
					var bookingId=form.getForm().findField('bookingId');
					var address=form.getForm().findField('visitorAddress');
					var emailId=form.getForm().findField('visitorEmailId');
					var visitorName=form.getForm().findField('visitorName');
					var contactNo=form.getForm().findField('visitorContactNolabel');
					var parentName=form.getForm().findField('parentName');
					var parentNameRead=form.down('#parentName');
					parentNameRead.setReadOnly(true);
					//var visitorName=form.getForm().findField('visitorName');
					visitorName.setReadOnly(true);
					var visitorphoneCountryCode=form.getForm().findField('visitorphoneCountryCode');
					var visitorContactNo=form.getForm().findField('visitorContactNo');
					 this.setMaximumMinimumDigitsForMobileNoValidation(form,visitorphoneCountryCode,visitorContactNo,null);
					var personPhoneCountryCode=form.getForm().findField('personPhoneCountryCode');
					var personContactNo=form.getForm().findField('personContactNo');
					var outTime=form.getForm().findField('outTime');
					var isAppointment=form.getForm().findField('isAppointment');
					var isEarlierAppointment=form.getForm().findField('isEarlierAppointment');
					var isGoingOutWithStudent=form.getForm().findField('isGoingOutWithStudent');
					var isMultiDayPass=form.getForm().findField('isMultiDayPass');
				 this.setMaximumMinimumDigitsForMobileNoValidation(form,personPhoneCountryCode,personContactNo,null);

					if(!isAppointment.getValue())
					{
						isAppointment.setVisible(false);
					}else{
						isAppointment.setReadOnly(true);
						//emailId.setVisible(true);
					}
					isEarlierAppointment.setVisible(false);
					if(!isNullOrEmpty(dataModel.data.tillDate))
					{
						isMultiDayPass.setVisible(true);
						isMultiDayPass.setValue(true);
						form.down('#tillDate').setValue(dateRender(record.data.tillDate));

					}else{
						isMultiDayPass.setVisible(false);
					}
					if(dataModel.data.visitorCategory.id > 1){
						isMultiDayPass.setVisible(true);
					}
					outTime.setDisabled(false);
					var parentPersonId=form.getForm().findField('parentPersonId');
					var person=form.getForm().findField('person');
					// personToMeet.setRawValue(dataModel.data.personToMeet);
					var personToMeetValue = form.down("#personToMeet");
					personToMeetValue.getStore().load({
						callback: function(records, operation, success) {
							for(var i=0;i<records.length;i++){
								var str=records[i].data.value.split("/");
								if(str[0].trim()==dataModel.data.personToMeet.split("/")[0].trim()){
							        personToMeetValue.setValue(records[i].data.value);
								}
							}
						}
					});
					
					
					
					
					var visitorCategory=form.down("#visitorCategory");

					visitorCategory.getStore().load({
						callback: function(records, operation, success) {

							for(var i=0;i<records.length;i++){
								if(records[i].data.value==dataModel.data.visitorCategoryName){
									
									var visitorstore=form.down("#visitorName").getStore();
									var parentstore=parentName.getStore();
									visitorstore.getProxy().extraParams = {					  
										visitorCategory:records[i].data.id,
										codeOrName:record.data.visitorName
									};

									visitorstore.load({
										callback: function(records, operation, success) {

											//if(records.length == 1){
												for(var i=0;i<records.length;i++){
													if(dataModel.data.visitorCategory.id==5){
													if((records[i].data.id==dataModel.data.applicant.id)){
														visitorName.setValue(records[i].data.id);
													}
													}
													else if(dataModel.data.visitorCategory.id==2){
														if((records[i].data.id==dataModel.data.enquirer.id)){
															visitorName.setValue(records[i].data.id);
														}
														}
													else if(dataModel.data.visitorCategory.id==4){
														if((records[i].data.id==dataModel.data.parentPersonId.id)){
															visitorName.setValue(records[i].data.id);
														}
													}
													else{
														if((records[i].data.id==dataModel.data.person.id)){
															visitorName.setValue(records[i].data.id);
														}
													}
												}
												//}

										}
									});
                                  if(records[i].data.id==1){
                                	  visitorName.setVisible(false);
                                	  visitorName.allowBlank=true;
                                	  var other=	form.down("#otherVisitor");
                                	  other.setVisible(false);
                                	  other.allowBlank=true;
                                	  var parentstore =parentName.getStore();
                                	  parentstore.getProxy().extraParams = {					  
  										visitorCategory:records[i].data.id
  									};

  									parentstore.load({
  										callback: function(records, operation, success) {

  											//if(records.length == 1){
  												for(var i=0;i<records.length;i++){
  													if((records[i].data.id==dataModel.data.parentPersonId.id)){
  														parentName.setValue(records[i].data.id);
  													}
  												}
  												//}

  										}
  									});

                                    }
                                  else		
									if(records[i].data.id>5){
									var other=	form.down("#otherVisitor")
										visitorName.setVisible(false);
									    parentName.setVisible(false);
									    visitorName.allowBlank=true;
									    parentName.allowBlank=true;

									    other.setVisible(true);
									    //other.setValue(data[0].visitorName);
									    other.setReadOnly(true);
									    emailId.setVisible(false);
									}
									else{
										visitorName.setVisible(true);
									    parentName.setVisible(false);
									    visitorName.allowBlank=false;
									    parentName.allowBlank=true;
									    var other=	form.down("#otherVisitor")
									    other.setVisible(false);
									    other.allowBlank=true;
									}
									

								}

							}


						}
					})
					
				
					if(!isNullOrEmpty(dataModel.data.parentPersonId))
					{
						parentPersonId.setValue(dataModel.data.parentPersonId.id);
					}
					else
					{
						parentPersonId.setValue(null);
					} 
					if(!isNullOrEmpty(dataModel.data.person))
					{
						person.setValue(dataModel.data.person.id);  
					}
					else
					{
						person.setValue(null);  
					}
					manualCardNoRead.setRawValue(dataModel.data.visitorCardNo);
					manualCardNoRead.setReadOnly(true);
					if(isNullOrEmpty(dataModel.data.parentPersonId))
					{
						visitorName.setValue(dataModel.data.visitorName);
						parentName.allowBlank=true;
					}
					//parentName.setRawValue(dataModel.data.visitorName);
					/*   parentName.getStore().load({
	                			   callback: function(records, operation, success) {
	                				    parentName.setValue(dataModel.data.parentPersonId.id);
	                			   }
	                		   });*/
	                		   //parentName.allowBlank
	                		   var str=dataModel.data.visitorContactNo;
	                		   if(str!=null){
	                			   var spiltMobileNo=str.split("-");
	                			   if(dataModel.data.visitorContactNo != null){
	                				   if(spiltMobileNo.length == 2){
	                					   visitorphoneCountryCode.getStore().load({
	                						   callback: function(records, operation, success) {

	                							   //if(records.length == 1){
	                							   for(var i=0;i<records.length;i++){
	                								   if(records[i].data.isdCode==spiltMobileNo[0]){
	                									   visitorphoneCountryCode.setValue(spiltMobileNo[0]);
	                									   visitorContactNo.setValue(spiltMobileNo[1]);
	                								   }
	                							   }


	                						   }
	                					   })
	                					   /*visitorphoneCountryCode.setValue(spiltMobileNo[0]);
                    				   visitorContactNo.setValue(spiltMobileNo[1]);*/
	                				   }

	                			   }
	                		   }

	                		   var strperson=dataModel.data.personContactNo;
	                		   if(strperson!=null){
	                			   var spiltpersonMobileNo=strperson.split("-");
	                			   if(dataModel.data.personContactNo != null){
	                				   if(spiltpersonMobileNo.length == 2){
	                					   personPhoneCountryCode.setValue(spiltpersonMobileNo[0]);
	                					   personContactNo.setValue(spiltpersonMobileNo[1]);
	                				   }
	                			   } 
	                		   }
	                		   personToMeet.getStore().load({
	                			   callback: function(records, operation, success) {
	                				   personToMeet.setValue(dataModel.data.personToMeet);
	                			   }
	                		   });

	                		   visitorCategory.getStore().load({
	                			   callback: function(records, operation, success) {
	                				   visitorCategory.setValue(dataModel.data.visitorCategory.id);
	                			   }
	                		   });
	                		   entryBy.getStore().load({
	                			   callback: function(records, operation, success) {
	                				   entryBy.setValue(dataModel.data.entryBy.id);
	                			   }
	                		   });
	                		   var bookingIdRead=form.down('#bookingId');
	                		   if (dataModel.data.isAppointment)
	                		   {
	                			   bookingIdRead.setVisible(true);
	                			   var bookingStore= bookingIdRead.getStore();
	                			   bookingStore.getProxy().extraParams = {
	                				   visitorCategory:dataModel.data.visitorCategory.id,
	                				   bookingId:null
	                			   }
	                			   
	                			   bookingIdRead.getStore().load({
	                				   callback: function(records, operation, success) {
	                					   bookingIdRead.setValue(dataModel.data.bookingId);
	                					   bookingIdRead.emptyText="";
	                					   bookingIdRead.setReadOnly(true);
	                				   }
	                			   });

	                		   }
	                		   var personImagePath= form.getForm().findField('personImagePath');
	                		   if(dataModel.data.visitorCategory.id==1)
	                		   {
	                			   visitoOrganization.setVisible(false);
	                			   visitorPlace.setVisible(false);
	                			   visitorName.setVisible(false);
	                			   emailId.setVisible(true);
	                			   parentName.setVisible(true);
	                			   address.setFieldLabel(getServiceRequestTranslation('PARENT_ADDRESS'));
	                			   if(isNullOrEmpty(dataModel.data.parentPersonId))
	                			   {
	                				   visitorName.setValue(dataModel.data.visitorName);
	                				   parentName.allowBlank=true;
	                			   }
	                			   //parentName.setRawValue(dataModel.data.visitorName);
	                			   parentName.getStore().load({
	                				   callback: function(records, operation, success) {
	                					   parentName.setValue(dataModel.data.parentPersonId.id);
	                				   }
	                			   });
	                		   }
	                		   else if(dataModel.data.visitorCategory.id>5){
	                			   others.setVisible(true);
	                			   visitorName.allowBlank = true;
	                			   others.setValue(record.data.visitorName)
	                		   }
	                		   else
	                		   {
	                			   visitoOrganization.setVisible(true);
	                			   visitorPlace.setVisible(true);
	                			   address.setFieldLabel(getServiceRequestTranslation('VISITOR_ADDRESS'));
	                			   emailId.setVisible(false);
	                			   visitorName.setVisible(true);
	                			   parentName.setVisible(false);
	                			   //visitorName.setValue(record.data.visitorName)
	                			   visitorName.getStore().load({
	                				   callback: function(records, operation, success) {
	                					   visitorName.setValue(record.data.visitorName);
	                					  // visitorName.setDisplayField(record.data.visitorName)
	                				   }
	                			   });
	                			   //contactNo.setFieldLabel(getServiceRequestTranslation('VISITOR_CONTACT_NO'));
	                		   }
	                		var saveButton =form.down('#saveVisitor');
	                		saveButton.setDisabled(false);
	                		$this.removePlaceHolder();  
	                		form.isValid();
	                		   
	                		   
				}else{
					showWarningMessage(getServiceRequestTranslation('SG_VISITOR'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
				}
			},

			viewVisitorRecord:function(){
				$this=this;
				$this.editVisitorRecord();
				var form = $this.getSgaddvisitor();
				form.setTitle(getServiceRequestTranslation('SG_VIEW_VISITOR_DETAILS'));
				var sgAddvisitorForm = form.getForm();
				this.toggleReadOnlyFormItems(sgAddvisitorForm,true);
				form.down('#saveVisitor').setVisible(false);
				form.down('#resetVisitor').setVisible(false);
				form.down('#saveVisitor').addCls('alone-footer-btn');
				form.down('#visitorCardNo').setReadOnly(true);
				form.down('#parentName').setReadOnly(true);
				form.down('#logoUploadField').setVisible(false);
				form.down('#personImagePathSnap').setVisible(false);;

			},

			loadSgVisitorGrid:function(){
				var $this=this;
				var form = $this.getSgvisitorfilter();
				var visitorNo = form.down("#visitorNo").getValue();
				var visitorCategory = form.down("#visitorCategory").getValue();
				var visitorName = form.down("#visitorName").getValue();
				//var visitorName = form.down("#visitorName").display
				var visitorCardNo = form.down("#visitorCardNo").getValue();
				var studentName = form.down("#studentName").getValue();
				var personToMeet = form.down("#personToMeet").getValue();
				var bookingID = form.down("#bookingID").getValue();
				var fromTime = form.down("#fromTime").getValue();
				var formattedStartTime = Ext.Date.format(fromTime,
				'H:i:s');
				var toTime = form.down("#toTime").getValue();
				var formattedEndTime = Ext.Date.format(toTime,
				'H:i:s');
				var startDate = form.down("#startDate").getValue();
				var endDate = form.down("#endDate").getValue();
				var currentlyInPremises = form.down("#currentlyInPremises").getValue();
				
				if(startDate != null){
                	startDate= new Date(startDate);
                	startDate = Ext.Date.format(startDate, 'Y-m-d');
                 }
            
            	if(endDate != null){
                	endDate= new Date(endDate);
                	endDate = Ext.Date.format(endDate, 'Y-m-d');
                 }

				var grid = $this.getSgmanagevisitorgrid();
				var values = form.getForm().getValues();
				var store =  grid.getStore();
				store.getProxy().extraParams = {
					visitorNo: visitorNo,
					visitorCategory:visitorCategory,
					visitorName:visitorName,
					studentName:studentName,
					cardNo:visitorCardNo,
					appointmentWith:personToMeet,
					bookingId:bookingID,
					inTime:formattedStartTime,
					outTime:formattedEndTime,
					startDate:startDate,
					endDate:endDate,
					visitorPremises:currentlyInPremises
				};
				store.load();
				grid.config.searchFilterForm = form;
			},

			deleteSGVisitorRecord:function(){
				var $this=this;
				var grid = $this.getSgmanagevisitorgrid();
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getServiceRequestTranslation('SG_VISITOR'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
						if (btn == 'yes') {
							Ext.getBody().mask(getServiceRequestTranslation('SUBMITTING_FORM'), 'x-mask-loading');
							var records = grid.getSelectionModel().getSelection();
							var id = records[0].get("id");
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : SERVERURL.SG_MANAGE_VISITORS_DELETE+'?id='+ id,
								headers : {
									'Content-Type' : 'application/json'
								},
								success : function(form,action) {
									Ext.getBody().unmask();
									grid.getStore().reload();
									showSuccessMessage(getServiceRequestTranslation('SG_VISITOR'), getCommonTranslation('SG_MANAGE_VISITORS_DELETED_SUCCESSFULLY'));
								}

							});
						}
					});
				}else {
					showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
				}
			},
			getParentDetails: function() {
				$this = this;
				var printName = null;
				var form = $this.getSgaddvisitor();
				var id = form.down("#parentName").getValue();
				var mobileField = form.down("#visitorContactNo");
				var countryCodeField = form.down("#visitorphoneCountryCode");
				var emailId = form.down("#visitorEmailId");
				var bookingId = form.down("#bookingId");
				var isAppointment = form.down("#isAppointment");
				var address = form.down("#visitorAddress");
				var reasonToVisit = form.down("#reasonToVisit");
				var personToMeet = form.down("#personToMeet");
				var bookingDate = form.down("#bookingDate");
				var settedBooking;
				 this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);

				bookingId.reset();
				Ext.Ajax
				.request({
					method: "GET",
					type: 'rest',
					url: SERVERURL.SG_PARENT_GUARDIAN_DETAILS,
					params: {
						id: id,
					},
					headers: {
						'Content-Type': 'application/json'
					},
					success: function(response, action) {
						var data = Ext.decode(response.responseText);
						countryCodeField.setValue(data[0].code);
						mobileField.setValue(data[0].mobileNo);
						emailId.setValue(data[0].emailId);
						printName = data[0].printName;
						address.setValue(data[0].address);
					}
				});

				Ext.Ajax
				.request({
					method: "GET",
					type: 'rest',
					url: SERVERURL.SG_FIND_BY_PARENT_NAME,
					params: {
						id: id,
					},
					headers: {
						'Content-Type': 'application/json'
					},
					success: function(response, action) {
						var data = Ext.decode(response.responseText);
						if (data.length == 0) {
							if (isAppointment.getValue())
								showWarningMessage(getServiceRequestTranslation('SG_VISITOR'),
										getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER'));
							bookingId.setVisible(false);
							isAppointment.setValue(false);
						} else if (!isNullOrEmpty(data[0].bookingId)) {
							if (isAppointment.getValue()) {
								bookingId.setVisible(true);
								bookingId.setReadOnly(true);
								bookingId.getStore().load({
									callback: function(records, operation, success) {
										bookingId.setRawValue(data[0].bookingId);
									}
								});

								settedBooking = data[0].bookingId;
								// personToMeet.setRawValue(data[0].personToMeet);
								personToMeet.getStore().load({
									callback: function(records, operation, success) {
										personToMeet.setRawValue(data[0].personToMeet);
									}
								});
								reasonToVisit.setValue(data[0].reasonToVisit);
								bookingDate.setValue(data[0].bookingDate);
							}
						} else {
							showWarningMessage(getServiceRequestTranslation('SG_VISITOR'),
									getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER'));
							bookingId.setVisible(false);
							isAppointment.setValue(false);
							bookingDate.setVisible(false);
							$this.setAllowBlank(bookingDate,true);
						}
					}
				});
			},

			getBookingDetails : function(){
				$this=this;
				var form = $this.getSgaddvisitor();
				var BoookingId=form.down("#bookingId").getValue();
				var mobileField = form.down("#visitorContactNo");
				var countryCodeField=form.down("#visitorphoneCountryCode");
				this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
				var isAppointment=form.down("#isAppointment");
				var reasonToVisit=form.down("#reasonToVisit");
				var visitorName=form.down("#visitorName");
				var parentName=form.down("#parentName");
				var personToMeet=form.down("#personToMeet");
				//var visitorCategory=form.down("#visitorCategory");
				var bookingDate=form.down("#bookingDate"); 
				var inTime=form.down("#inTime");  
				var outTime=form.down("#outTime");  
				var entryBy=form.down("#entryBy");
				var meetingDate=form.down("#meetingDate");
				var visitorEmailId=form.down("#visitorEmailId"); 
				var other=	form.down("#otherVisitor");
             

				Ext.Ajax
				.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.SG_FIND_BY_PARENT_NAME,
					params : {
						bookingId: BoookingId,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(response, action) {
						var data=Ext.decode(response.responseText);
						if(!isNullOrEmpty(data)){
						var str=data[0].visitorContactNo;
						var str1=data[0].visitorContactNo;
						if(str!=null){
							var spiltMobileNo=str.split("-");
							if(data[0].visitorContactNo != null){
								if(spiltMobileNo.length == 2){
									countryCodeField.getStore().load({
										callback: function(records, operation, success) {

											//if(records.length == 1){
												for(var i=0;i<records.length;i++){
													if(records[i].data.isdCode==spiltMobileNo[0]){
														countryCodeField.setValue(records[i].data.isdCode);

													}
												}
												//}

										}
									})

									mobileField.setValue(spiltMobileNo[1]);
								}

							}
						}
						//visitorName.setValue(data[0].visitorName);

						reasonToVisit.setValue(data[0].reasonToVisit);
						personToMeet.setRawValue(data[0].personToMeet);
						bookingDate.setValue(data[0].bookingDate);
						bookingDate.setReadOnly(true);
						var visitorCategory=form.down("#visitorCategory");

						visitorCategory.getStore().load({
							callback: function(records, operation, success) {

								for(var i=0;i<records.length;i++){
									if(records[i].data.value==data[0].visitorCategoryName){
										visitorName.setVisible(true);	
										visitorName.setReadOnly(true);
										if(records[i].data.id==1){
											visitorEmailId.setVisible(true);
										}
										else{
										    visitorEmailId.setVisible(false);
										}
										visitorEmailId.setValue(data[0].visitorEmailId);
										visitorCategory.setValue(records[i].data.id);
										visitorCategory.setReadOnly(true);
										var visitorstore=form.down("#visitorName").getStore();
										var parentstore=parentName.getStore();
										visitorstore.getProxy().extraParams = {					  
											visitorCategory:records[i].data.id
										};

										visitorstore.load({
											callback: function(records, operation, success) {

												//if(records.length == 1){
													for(var i=0;i<records.length;i++){
														if((records[i].data.id==data[0].parentId)||((records[i].data.userId==data[0].staffId)&&records[i].data.userId!=null)||(records[i].data.id==data[0].studentPersonId)||(records[i].data.id==data[0].enquiryId)||(records[i].data.id==data[0].applicantId)){
															visitorName.setValue(records[i].data.id);
														}
													}
													//}

											}
										});
                                      
										
										if(records[i].data.id>5){
										
											visitorName.setVisible(false);
										    parentName.setVisible(false);
										    other.setVisible(true);
										    other.setValue(data[0].visitorName);
										    other.setReadOnly(true);
										    visitorName.allowBlank=true;
										    parentName.allowBlank=true;
										    other.allowBlank=false;
										}
										else
										 if(records[i].data.id==1){
											 visitorName.setVisible(false);
											 visitorName.allowBlank=true;
											  parentName.setVisible(true);
											  parentName.allowBlank=false;
											  other.allowBlank=true;
										 }
										 else{
											 if(records[i].data.id==2){
													visitorName.setFieldLabel(getCommonTranslation('ENQUIRER_NAME'));
													
												}
												else if(records[i].data.id==3){
													visitorName.setFieldLabel(getServiceRequestTranslation('STUDENT_NAME'));
													
												}
												else if(records[i].data.id==4){
													visitorName.setFieldLabel(getServiceRequestTranslation('EMPLOYEE_NAME'));
													
												}
												else if(records[i].data.id==5){
													visitorName.setFieldLabel(getCommonTranslation('APPLICANT_NAME'));
												}
											 visitorName.setVisible(true);
											 parentName.allowBlank=true;
											 parentName.setVisible(false);
											 other.allowBlank=true;
										 }

										parentstore.getProxy().extraParams = {					  
											visitorCategory:records[i].data.id
										};

										parentstore.load({
											callback: function(records, operation, success) {

												//if(records.length == 1){
													for(var i=0;i<records.length;i++){
														if((records[i].data.id==data[0].parentId)||(records[i].data.id==data[0].staffId)||(records[i].data.id==data[0].studentId)||(records[i].data.id==data[0].enquiryId)||(records[i].data.id==data[0].applicantId)){
															parentName.setValue(records[i].data.id);
														}
													}
													//}

											}
										});


									}

								}


							}
						})
                     	entryBy.getStore().load({
											callback: function(records, operation, success) {

												//if(records.length == 1){
													for(var i=0;i<records.length;i++){
														if((records[i].data.id==data[0].entryById)){
															entryBy.setValue(records[i].data.id);  
														}
													}
													//}

											}
										});
						//entryBy.setValue(data[0].entryByName);  
						meetingDate.setValue(dateRender(data[0].meetingDate));
						inTime.setValue(timeRender(data[0].visitTime));
						outTime.setValue(timeRender(data[0].outTime));
					}
					}
				});
			},
			getPersonDetails : function(){
				var form = this.getSgaddvisitor();
				var id=form.down("#personToMeet").getValue();
				var mobileField = form.down("#personContactNo");
				var countryCodeField=form.down("#personPhoneCountryCode");
				form.getForm().checkValidity();
           this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);

				Ext.Ajax
				.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.BILL_USER_DETAILS,
					params : {
						codeOrName: id,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(response, action) {
						var data=Ext.decode(response.responseText);
						if(data.length>0){
							countryCodeField.setValue(data[0].mobileCountryCode);
							mobileField.setValue(data[0].mobileNumber);
						}
					}
				});
			}, 
			getVisitorCardDetails : function(){
				$this=this;
				form=this.getSgaddvisitor();
				var manualCardNo=form.getForm().findField('manualCardNo');
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.BILL_USER_DETAILS,
					params : {
						codeOrName: id,
					},
					headers : {
						'Content-Type' : 'application/json'
					},
					success : function(response, action) {
						var data=Ext.decode(response.responseText);

					}
				});
			},
			getVisitorDetails: function(obj,record) {
				$this = this;
				var form = $this.getSgaddvisitor();
				var id = form.down("#visitorName").getValue();
				var mobileField = form.down("#visitorContactNo");
				var countryCodeField = form.down("#visitorphoneCountryCode");
				this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);

				var isAppointment = form.down("#isAppointment");
				var bookingId = form.down("#bookingId");
				var reasonToVisit = form.down("#reasonToVisit");
				var bookingIdRead = form.down('#bookingId');
				var bookingDate = form.down('#bookingDate');
				var personToMeet = form.down("#personToMeet");
				mobileField.reset();
				countryCodeField.reset();
				bookingId.reset();
				reasonToVisit.reset();
				var sgBookingId;
				var settedbookingId;
				Ext.Ajax.request({
					method: "GET",
					type: 'rest',
					async: false,
					url: SERVERURL.SG_FIND_CHECK_VISITOR_BOOKING_ID,
					params: {
						bookingId: record[0].data.bookingId,
					},
					headers: {
						'Content-Type': 'application/json'
					},
					success: function(frm, action) {
						var responseDate = Ext.decode(frm.responseText);
						if (responseDate.length > 0)
							sgBookingId = responseDate[0].value;

					}
				});

				/*  var str = record[0].data.personContactNo;
                           if (str != null) {
                               var spiltMobileNo = str.split("-");
                               if (record[0].data.personContactNo != null) {
                                   if (spiltMobileNo.length == 2) {
                                       countryCodeField.setValue(spiltMobileNo[0]);
                                       mobileField.setValue(spiltMobileNo[1]);
                                   }

                               }
                           }*/
				countryCodeField.getStore().load({
					callback: function(records, operation, success) {

						//if(records.length == 1){
						for(var i=0;i<records.length;i++){
							if(records[i].data.isdCode==record[0].data.countryCode){
								countryCodeField.setValue(records[i].data.isdCode);
								mobileField.setValue(record[0].data.mobileNo);
							}
						}


					}
				})
				if (isAppointment.getValue()) {
					isAppointment.setVisible(true);
					bookingId.getStore().load({
						callback: function(records, operation, success) {
							bookingIdRead.setValue(record[0].data.bookingId);
							bookingIdRead.emptyText = "";
							bookingIdRead.setReadOnly(true);
						}
					});
					if (sgBookingId != undefined) {
						//var responseBooookingId=Ext.decode(sgBookingId.responseText);
						var settedbookingId = sgBookingId;
					}
					if (!isNullOrEmpty(record[0].data.bookingId)) {
						if (settedbookingId != record[0].data.bookingId) {
							bookingId.setVisible(true);
							bookingId.setReadOnly(true);
							bookingDate.setReadOnly(true);
							bookingDate.setValue(record[0].data.bookingDate);
						}
					} else {
						bookingId.setVisible(false);
						isAppointment.setValue(false);
						bookingDate.setVisible(false);
						$this.setAllowBlank(bookingDate,true);
						showWarningMessage(getServiceRequestTranslation('SG_VISITOR'), getServiceRequestTranslation('NO_APPOINTMENT_BOOKED_FOR_THIS_USER'));
					}
				}
				reasonToVisit.setValue(record[0].data.reasonToVisit);
				personToMeet.getStore().load({
					callback: function(records, operation, success) {
						personToMeet.setRawValue(record[0].data.personToMeet);
					}
				});
			},

			getReasonToMeetGridWindow : function(grid,record){
				var frmWin = this.getSgreasontomeetgridwin();
				if(!frmWin){
					Ext.widget('sgreasontomeetgridwin');
					frmWin = this.getSgreasontomeetgridwin();
				}
				frmWin.show();
				var resonField=frmWin.down('#reasonMeetItemId')
				resonField.setValue(record.data.reasonToVisit);
			},

			getVisitorCardNoGridWindow : function(grid,record){
				var visitorFrmWin = this.getSgvisitorcardwindow();
				if(!visitorFrmWin){
					Ext.widget('sgvisitorcardwindow');
					visitorFrmWin = this.getSgvisitorcardwindow();
				}
				visitorFrmWin.show();
				var visitorCardNoField=visitorFrmWin.down('#visitorCardNo')
				visitorCardNoField.setValue(record.data.visitorCardNo);
			},


			imageRestMethod:function() {
				$this=this;
				var form = $this.getSgaddvisitor();
				id=form.getForm().findField('id').getValue();
				Ext.Ajax.request({
					type: 'rest',
					binary: true,
					url: SERVERURL.PATH_PICK_VISITOR_IMAGE,
					method: 'GET',
					params : {
						visitorId: id,
					},
					success: function(res, action) {
						Ext.suspendLayouts();
						if(res.status == 200){
							var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
							var url = window.URL.createObjectURL(blob);
							form.down('#visitorBgImage').setVisible(false);
							form.down('#visitorBgImage').getEl().dom.src=url;
							form.down('#visitorBgImage').setVisible(true);
						} else {
							form.down('#visitorBgImage').setVisible(false);
							form.down('#visitorBgImage').getEl().dom.src="";
							form.down('#visitorBgImage').setVisible(true);
						}
						Ext.resumeLayouts();
					}
				});
			},

			captureVisitorProfilePhoto : function(btn){ 
				var $this = btn.up('window');
				var form = btn.up('window').down('form');
				var imageUrl;
				Webcam.snap( function(data_uri) {
					imageUrl = data_uri;
				});
				Ext.defer(function() {
					var imgLoad = new Image();
					imgLoad.onload = (function(){
						var crop = new Academia.utilities.ImageCrop({
							id:'testing',
							width: 320,
							height: 240,
							src:imageUrl
						});
						crop.on('changeCrop', function(component,region) {
							$this.cropData = region;
							$this.component = component;
						});
						var PREVIEW_TEST = form.down('#previewPanelId');
						PREVIEW_TEST.add(crop);
						$this.down('#capturePanelId').setVisible(false);
						$this.down('#previewPanelId').setVisible(true);

						btn.setDisabled(true);
						$this.down('#previewbuttonId').setDisabled(false);

					}).bind($this);
					imgLoad.src = imageUrl;
					$this.imagesUrl = imageUrl;
				}, 500, $this);

			},

			previewVisitorProfilePhoto : function(btn){

				var $this = btn.up('window');
				var canvas = document.getElementById('canvas');
				var ctx = canvas.getContext("2d");
				var region = $this.cropData; 
				var component = $this.component;
				var sw = region.width - region.x;
				var sh = region.height - region.y;

				var imgWidth = component.width;
				var imgHeight = component.height;

				var img = new Image();
				img.src = component.src;

				ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);

				var dataUrl = canvas.toDataURL("image/png");

				$this.down('#showProfilePhotoPanel').getEl().dom.src=dataUrl;
				$this.down('#showGridPhotoPanel').getEl().dom.src=dataUrl;
				$this.down('#showDisplayPhotoPanel').getEl().dom.src=dataUrl;
				$this.captureImageaUrl = dataUrl;
				$this.down('#resetbuttonId').setDisabled(false);

				$this.down('#SubmitBtn').setDisabled(false);

			},

			saveCapturedIMage : function(btn){
				$this=this;
				var personProfile = $this.getContentPanelActiveTab();
				var userInfo = Academia.model.authentication.UserInfoModel;
				var canvas = document.getElementById('canvas');
				var access_token = userInfo.get("accessToken");
				var formSG = $this.getSgaddvisitor();
				var visitorProfile = this.getContentPanelActiveTab();
				var dataUrl = canvas.toDataURL("image/png");
				binary: true;
				var getImageUrl = 'rest/personImage/uploadVisitorSnapshotB64Image?access_token='+access_token;
				var form = new FormData();
				form.append('file', dataUrl);
				form.append('fileName', '1.png');
				var xhr = new XMLHttpRequest();
				xhr.open('POST', getImageUrl, true);

				xhr.onreadystatechange = function () {
					Ext.apply(visitorProfile, {
						visitorUplaodSnap : null,
						setVisitorSnap : function(visitorUplaodSnap) {
							visitorProfile.visitorUplaodSnap = visitorUplaodSnap;
						},
					});
					var data = xhr.responseText;
					//visitorProfile.setvisitorUplaodSnap(data);
					var visitorSnapShotPath=personProfile.visitorSnap.path;
					var visitorImageByteCode=personProfile.visitorSnap.imageByteCode;
					var blob = new Blob([visitorImageByteCode], {type: 'image/jpg'});
					var url = window.URL.createObjectURL(blob);

					var imag = Ext.getCmp('visitorBgImage');
					var profileImage=formSG.down('#visitorBgImage');
					profileImage.getEl().dom.src ="data:image/jpg;base64," + visitorImageByteCode;

				};
				xhr.send(form);
			},

			savePersonPhotoUpload: function(fileUploadPath,personId) {
				var $this=this;
				var sgAddvisitor = $this.getSgaddvisitor();
				var fileUploadPath = fileUploadPath;
				var uploadUrl = SERVERURL.VISITOR_IMAGE_UPLOAD;

				fileUploadPath.getForm().submit({
					type: 'rest',
					method: 'POST',
					url: uploadUrl,
					params: {
						personId: personId,
					},
					success: function(form, action) {
						var profileImage=sgAddvisitor.down('#visitorBgImage');
						profileImage.getEl().dom.src ="";
						sgAddvisitor.getForm().reset();
					}
				});
			},

			savePersonSnapshotUpload: function(path,personId) {
				var $this=this;
				var sgAddvisitor = $this.getSgaddvisitor();
				var logoUploadField=  sgAddvisitor.down('#logoUploadField');
				if(!isNullOrEmpty(personId))
				{ 
					logoUploadField.getForm().submit({
						type: 'rest',
						method: 'POST',
						url: SERVERURL.SG_SAVE__PERSON_SNAPSHOT,
						params: {
							personId: personId,
							path:path
						},
						success: function(response, action) {
							$this.getDefaultImage();
							/*var profileImage=sgAddvisitor.down('#visitorBgImage');
                    					profileImage.getEl().dom.src ="";
                    					sgAddvisitor.getForm().reset();*/
						}
					});
				}
			},
			setEntrybyValuebydefault : function() {
				var userId=this.getCurrentlyLoggedInUser();
				var form=this.getSgaddvisitor();
				var entryByField = form.getForm().findField('entryBy');
				entryByField.store.load({
					callback : function(operation,success) {
						if (success) {
							entryByField.setValue(userId.id);
						}
					}
				});
			},

			getDefaultImage : function(isSaveOrUpdateRecord) {
				var $this=this;
				var form=$this.getSgaddvisitor();
				Ext.Ajax.request({
					method : "GET",
					type : 'rest',
					url : SERVERURL.PERSON_IMAGE_DOWNLOAD,
					params : {
						id : null,
					},
					binary: true,
					headers : {
						'Content-Type' : 'application/json'
					},
					success: function(res, action) {
						Ext.suspendLayouts();
						Ext.defer(function() {
							if(res.status == 200){
								var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
								var url = window.URL.createObjectURL(blob);
								form.down('#visitorBgImage').setVisible(false);
								form.down('#visitorBgImage').getEl().dom.src=url;
								form.down('#visitorBgImage').setVisible(true);
								var tabName = getServiceRequestTranslation('SG_VISITOR_DETAILS');
								var controller=$this.getController('menu.CoreERPNavigationController');
								var tab=controller.getTab(tabName);
								if(isSaveOrUpdateRecord){
									if(tab!=null){
										contentPanel.remove(tab, true);
									}
								}
							}
						}, 500, this);
						Ext.resumeLayouts();
					}
				});
			},
		    disableSgGridMoreActionPivileges: function(grid,permissionMap){

		    	var associatedAcadLocationIds = new Array();
		    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
				var spBtnMoreActions = grid.down('#spBtnMoreActions');
				spBtnMoreActions.setVisible(false);
		    	var printDocuments = grid.down('#printDocuments');
		    	printDocuments.setVisible(false);
		    	Ext.each(permissionList, function(privilege) {
		    		
		    		if (privilege === 'MOREACTIONS') {
		        		if(!isNullOrEmpty(spBtnMoreActions)){
		        			spBtnMoreActions.setVisible(true);
		        		}        		
		        	}
		    		if (privilege === 'PRINT_DOCUMENTS') {
		        		if(!isNullOrEmpty(printDocuments)){
		        			printDocuments.setVisible(true);
		        		}        		
		        	}
		    	});
		    },
		    showPrintDocumentWindow: function(){
		    	var $this = this;
		    	var formWindow = $this.getPrintdocumentwindow();
		    	if (!formWindow) {
		    		Ext.widget('printdocumentwindow');
		    		formWindow = $this.getPrintdocumentwindow();
		    	}
		    	formWindow.show();
		    	var form = $this.getPrintdocumentwindow();
				var  templateNameField = form.down("#templateNameStudent");
				var store = templateNameField.getStore();
				var academyLocationId=$this.getCurrentAcademyLocation();
				store.getProxy().extraParams={
					certificateCategory:"VISITOR_PASS",
					academyLocationId:academyLocationId
				};
				store.load();
		    },
		    exportPrintGatePass: function(grid) {
		    	var $this = this;
		    	var record = grid.getSelectionModel().getSelection()[0];
		    	var sgManageVisitorId = record.data.id;
		    	var csvForm = Ext.create('Ext.form.Panel');
		    	var formWindow = $this.getPrintdocumentwindow();
		    	var certificateId = formWindow.down('#templateNameStudent');
		    	certificateId=certificateId.getValue();
		    	Ext.Ajax.request({
		    		type:'rest',
		    		method: 'POST',
		    		url:SERVERURL.PRINT_VISITOR_GATE_PASS,
		    		standardSubmit :true,
		    		params :{
		    			sgManageVisitorId:sgManageVisitorId,
		    			certificateId:certificateId
		    		},

		    		success : function(response){
		    			if(response){
		    				csvForm.getForm().submit({
		    					target: 'download_frame',
		    					method:'POST',
		    					params :{
		    						access_token : Ext.Ajax.defaultHeaders.access_token,
		    						sgManageVisitorId:sgManageVisitorId,
		    						certificateId:certificateId
		    					},
		    					headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                		  
		    					url : SERVERURL.PRINT_VISITOR_GATE_PASS,
		    					standardSubmit :true
		    				}); 
		    				formWindow.close();
		    				$this.hideWindowMask();
		    			}
		    		},
		    		failure: function(response,action){
		    			
		    			
		    			var res = Ext.decode(response.responseText);
		    			if(!res[0].key=="Unknown Data Provider Found. Please Check Document Configuration"){   // V2D-530263
		    				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('documenttemplate_conf_not_configured'));
		    			}
		    			
		    		}
		    	});

		    },
          
                removePlaceHolder:function(){
	            var sgaddvisitor=this.getSgaddvisitor();
                      Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
                         method: 'GET',
                         params: {
                             entityId: 32
                         },
                         success: function(response,form, action) {
                             if(!isNullOrEmpty(response.responseText)){
                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
                                 if(!isEmpty(responseObject)){
                                     var visitorNo = sgaddvisitor.down("#visitorNo");
                                     if(responseObject.whetherManualId){
                                         visitorNo.setReadOnly(false);
										 visitorNo.emptyText=' ';
									     visitorNo.allowBlank=false;
										 visitorNo.labelSeparator +='<span class="required" style="color:red"> *</span>';
										 visitorNo.setFieldLabel(visitorNo.fieldLabel);
										 visitorNo.applyEmptyText();
                                     }else{
										 visitorNo.setReadOnly(true);
									     visitorNo.allowBlank=true;
										 visitorNo.emptyText= getCommonTranslation('ID_AUTOGENERATE');
										 visitorNo.applyEmptyText();
	
                                    }
                                 }
                             }                                                     
                         }                
                     });
    
}
		});