Ext.define('Academia.controller.sponsorship.SponsorshipMasterController', {
    extend: 'Academia.controller.base.BaseController',

    views: ['Academia.view.sponsorship.SponsorshipMaster', 'sponsorship.SponsorshipMasterScreen', 'sponsorship.SponsorshipMasterSearchForm',
            'sponsorship.SponsorshipMasterViewSponsoredStudentsWindow', 'sponsorship.SponsorshipMasterSponsorDetails',
            'sponsorship.SponsorshipMasterSponsorContactPersonDetailsGrid', 'sponsorship.SponsorshipMasterSponsorContactPersonDetails',
            'sponsorship.SponsorshipMasterSponsorCompanyDetails', 'Academia.view.sponsorship.SponsorshipMasterSponsorContactPersonDetailsWindow',
            'Academia.view.criteriabuilder.grid.SearchResultGrid', 'Academia.view.sponsorship.SponsorshipMasterViewSponsoredStudentsGrid',
            'Academia.view.sponsorship.SponsorshipMasterSearchResultGrid','sponsorship.SponsorAcademyLocationMappingWin',
            'sponsorship.SponsorAcademyLocationMappingGrid','sponsorship.ManageQuotationStructure','sponsorship.QuotationDetailsGrid',
            'sponsorship.QuotationDetailStructure','sponsorship.QuotationDetailDocumentGrid','document.DocumentFormWindow','sponsorship.invoice.SponsorInvoiceStructure','sponsorship.invoice.SponsorInvoiceFilter','sponsorship.invoice.SponsorInvoiceGrid','sponsorship.invoice.SponsorInvoiceCaptureWin',
    		'sponsorship.invoice.SponsorInvoiceDocumentGrid','sponsorship.invoice.SponsorInvoiceDocumentListWin','sponsorship.invoice.SponsorInvoiceUpdateAmountReceivedWin'],

    stores: ['sponsorship.SponsorTypes', 'organization.CityStore', 'common.CountryStore','organization.CityByCountryRegion',
             'organization.CountryRegionStore', 'organization.CountryRegionStore1', 'sponsorship.SponsoredStudents',
             'sponsorship.ContactDetails','sponsorship.SponsorsList','sponsorship.SponsorsNameCodeStore','sponsorship.SponsorTypesStore',
             'sponsorship.SponsorshipMasterSearchResultGridStore','facilitiesresources.resourcebooking.AcademyLocationListStore',
             'sponsorship.SponsorAcademyLocationStore','common.AcademyLocationNameSeparated','sponsorship.QuatationDetailsGridStore',
             'common.BatchesByProgramId','sponsorship.QuotationDetailsDocGridStore','common.AllUserBySmartSearch','feeandpayment.receipts.BankNameStore',
             'feeandpayment.receipts.BankIfscStore','feeandpayment.receipts.BranchNameStore','feeandpayment.receipts.AccountTypeStore','sponsorship.SponsorsNameCodeStore','sponsorship.invoice.SponsorsInvoiceNumStore','sponsorship.invoice.SponsorInvoiceGridStore','sponsorship.invoice.SponsorInvoiceDocumentStore',
             'sponsorship.invoice.SponsorInvoiceAmountReceivedStore'],
    models:['personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel','sponsorship.SponsorUpdateAmtReceivedModel'],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'sponsorshipmaster',
        selector: 'sponsorshipmaster'
    },{
        ref: 'sponsorshipMasterForm',
        selector: 'sponsorshipmastersearchform form[itemId=sponsorshipMaster]'
    }, {
        ref: 'searchResultGrid',
        selector: 'sponsorshipmasterscreen grid[itemId=sponsorshipMasterGrid]'
    }, {
        ref: 'contactPersonDetailsGrid',
        selector: 'contactpersondetailsgrid'
    }, {
        ref: 'viewSponsoredStudents',
        selector: 'viewsponsoredstudents'
    }, {
        ref: 'companyDetailsWindow',
        selector: 'sponsorcompanydetailswindow'
    }, {
        ref: 'companyDetailsForm',
        selector: 'sponsorcompanydetailswindow form[itemId=addSponsorshipform]'
    }, {
        ref: 'contactPersonDetailsGrid',
        selector: 'contactpersondetailsgrid'
    }, {
        ref: 'contactPersonDetailsForm',
        selector: 'contactpersondetailswindow form[itemId=addContactform]'
    }, {
        ref: 'contactPersonDetailsWindow',
        selector: 'contactpersondetailswindow'
    }, {
        ref: 'sponsorshipMasterViewSponsoredStudentsWindow',
        selector: 'sponsorshipmasterviewsponsoredstudentswindow'
    }, {
        ref: 'sponsorshipmastersearchresultgrid',
        selector: 'sponsorshipmastersearchresultgrid'
    }, {
        ref: 'sponsoracademylocationmappingwin',
        selector: 'sponsoracademylocationmappingwin'
    }, {
        ref: 'sponsoracademylocationmappinggrid',
        selector: 'sponsoracademylocationmappinggrid'
    },{
    	ref:'quotationdetailsgrid',
    	selector:'quotationdetailsgrid'
    },{
    	ref:'quotationdetailstructure',
    	selector:'quotationdetailstructure'
    },{
    	ref:'documentformwindow',
    	selector:'documentformwindow'
    },{
    	ref:'quotationdetaildocumentgrid',
    	selector:'quotationdetaildocumentgrid'
    },{
    	ref:'sponsorinvoicegrid',
    	selector:'sponsorinvoicegrid'
    },{
    	ref: 'sponsorinvoicecapturewin',
    	selector: 'sponsorinvoicecapturewin'
    },{
    	ref:'sponsorinvoicedocumentgrid',
    	selector:'sponsorinvoicedocumentgrid'
    },{
    	ref:'sponsorinvoicefilter',
    	selector:'sponsorinvoicefilter'
    },{
    	ref:'sponsorinvoicedocumentlistwin',
    	selector:'sponsorinvoicedocumentlistwin'
    },{
    	ref:'sponsorinvoiceupdateamountreceivedwin',
    	selector:'sponsorinvoiceupdateamountreceivedwin'
    }],
    config: {
        SPONSOR_COMPANIES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_COMPANIES_PRIVILEGES'),
        SPONSOR_CONTRACT_PERSON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_CONTRACT_PERSON_PRIVILEGES'),
        SPONSOR_CONTRACT_PERSON_FORM_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_CONTRACT_PERSON_FORM_PRIVILEGES'),
        SPONSOR_INVOICE_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_INVOICE_PRIVILEGES')
    },
    init: function(application) {
    	this.sponsorAmtIdsToBeDeleted=[];
    	this.sponsorDocIdsToBeDeleted=[];
        this.control({
        	'sponsorshipmaster' : {
        		tabchange: function(view,newTab,oldtab){
        			var master=this.getSponsorshipmaster();
        			var advancesearch = master.down('advancedsearchquerybuilder');
        			var combo1 = advancesearch.down('#loadSavedSearchComboId');
        			combo1.setVisible(false);
        		}
        	},

            'sponsorshipmastersearchform  button[itemId=SponsorshipMasterSearchBtn]': {
                click: function(model, records) {
                    this.loadGridAndSearchUsers(model, records);
                    this.clearContactPersonDetailsGrid();
                }
            },
            'sponsorshipmastersearchresultgrid': {
               // render: this.gridRenderFunction,
                select: function(grid, record, index, eOpts) {
                    var contactsGrid = this.getContactPersonDetailsGrid();
                    var id = record.data.sponsorId;
                    var store = contactsGrid.getStore();
                    store.load({
                        params: {
                            sponsorId: id
                        }
                    });
                    store.getProxy().extraParams.sponsorId = id;
                },
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    this.onSponsoredStudentsCellClick(grid, td, cellIndex, record, tr, rowIndex, e, eOpts)
                },
                render: function(grid) {
                   //grid.getStore().removeAll();                
                   this.doAccessControlValidation(grid, this.getSPONSOR_COMPANIES_PERMISSIONS());
                   this.disableMoreActionPivileges(grid,this.getSPONSOR_COMPANIES_PERMISSIONS());
                   this.disableManageQuotationLink(grid,this.getSPONSOR_COMPANIES_PERMISSIONS());
                }
            },
            /*'sponsorshipmastersearchresultgrid[itemId=sponsorshipMasterGrid]': {
                render: function(grid) {
                    this.doAccessControlValidation(grid, this.getSPONSOR_COMPANIES_PERMISSIONS());
                }
            },*/
            'sponsorshipmastersearchresultgrid button[itemId=btnAdd]': {
                click: this.addSponsor
            },
            'sponsorshipmastersearchresultgrid button[itemId=btnEdit]': {
                click: function() {
                	this.editSponsor(this, false);
                }
            },
            'sponsorshipmastersearchresultgrid button[itemId=btnView]': {
            	click: function() {
                	this.editSponsor(this, true);
                }
            },
            'sponsorshipmastersearchresultgrid button[itemId=btnDelete]': {
                click: this.deletSponsor
            },

            'sponsorcompanydetailswindow button[itemId=btnCancelCompanyDetails]': {
                click: this.cancelSponsorCompanyDetails
            },
            'sponsorcompanydetailswindow button[itemId=btnSaveCompanyDetails]': {
                click: this.SaveSponsorCompanyDetails
            },
            'contactpersondetailswindow button[itemId=btnSaveContactForm]': {
                click: this.SaveContactDetailsForm
            },
            'contactpersondetailswindow button[itemId=btnCancelContactForm]': {
                click: this.cancelContactDetailsForm
            },
            'contactpersondetailsgrid button[itemId=btnAdd]': {
                click: this.addContact
            },
            'contactpersondetailsgrid button[itemId=btnEdit]': {
                click: Ext.bind(this.editContact, this, [false])
            },
            'contactpersondetailsgrid button[itemId=btnView]': {
                click: Ext.bind(this.editContact, this, [true])
            },
            'contactpersondetailsgrid button[itemId=btnDelete]': {
                click: this.deletContact
            },
            'contactpersondetailsgrid[itemId=contactPersonDetailsGrid]': {
                render: function(grid) {
                    this.clearContactPersonDetailsGrid(grid);
                    this.doAccessControlValidation(grid, this.getSPONSOR_CONTRACT_PERSON_PERMISSIONS());
                }
            },
            'sponsorcompanydetailswindow':{
            	render: function(form) {
            		this.loadDFRForSponsorCompanyDetail(form);
            	}
            },
            'sponsorcompanydetailswindow combo': {
                render: this.loadCombo
            },
            'contactpersondetailswindow combo': {
                render: this.loadContactCombo
            },
            'contactpersondetailswindow combo[itemId=countryId]': {
                select: this.loadcityParentRegionStore,

                change: function(obj, newValue) {
                    var phoneCountryCode = this.getContactPersonDetailsForm().down('customcombobox#phoneCountryCode');
                    var cellCountryCode = this.getContactPersonDetailsWindow().down('customcombobox#cellCountryCode');
                    var countryStore = this.getContactPersonDetailsForm().down('#countryId').getStore();
                    var val = countryStore.getById(newValue);
                    phoneCountryCode.setValue(val);
                    cellCountryCode.setValue(val);
                }
            },
            'contactpersondetailswindow combo[itemId=genericFieldId1]': {
                select: this.loadCityStore
            },


		'contactpersondetailswindow nestedJsonCombo[itemId=bankId]': {
	           change: function(obj, newValue) {
                    var form = this.getContactPersonDetailsForm();
                    var ifscCodeId = form.down('#ifscCode');
                        ifscCodeId.reset();      
                    var branchNameId = form.down('#branchName');
                        branchNameId.reset();
                        branchNameId.setDisabled(false);
                        ifscCodeId.setDisabled(false);
                    var ifscCodeValue= form.down('#ifscCode').getValue();
                    var bankIdValue=form.down('#bankId').getValue();
                    var ifscCodeId = form.down('#ifscCode');
                    if(bankIdValue>0){
                        ifscCodeId.getStore().getProxy().extraParams = {
            			bankNameId:bankIdValue,
                        
							}
            		ifscCodeId.getStore().load();
					branchNameId.getStore().getProxy().extraParams = {
	                    bankNameId:bankIdValue,
            								 		}
            		    branchNameId.getStore().load();}
}    
            },
			'contactpersondetailswindow nestedJsonCombo[itemId=ifscCode]': {
	           select: function(obj, newValue) {
                    var form = this.getContactPersonDetailsForm();
                    var bankIdValue=form.down('#bankId').getValue();
                    var branchNameId = form.down('#branchName');
                        //branchNameId.reset();
                        //branchNameId.clearValue();
					var ifscValue = form.down('#ifscCode').getValue();
                    var ifscCodeId = form.down('#ifscCode');
                    var branchNameValue = form.down('#branchName').getValue();
                        branchNameId.setDisabled(false);
	                  if(ifscValue>0){ 
		               branchNameId.getStore().load({
                        params: {
	                    bankNameId:bankIdValue,
            			ifscCode:ifscValue
                        },
                        callback: function(records, opt, success){
                             if (success) { 
	                            
                                 branchNameId.setValue(records[0].data.id);    
                             }
                        }    
                    });
	                  
			       }  
				}  
            },
'contactpersondetailswindow nestedJsonCombo[itemId=branchName]': {
	           select: function(obj, newValue) {
                    var form = this.getContactPersonDetailsForm();
                    var ifscCodeId = form.down('#ifscCode');
                      //  ifscCodeId.reset();      
                    var branchNameId = form.down('#branchName').getValue();
                    var ifscCodeValue= form.down('#ifscCode').getValue();
                    var bankIdValue=form.down('#bankId').getValue();
                    var ifscCodeId = form.down('#ifscCode');
                    ifscCodeId.getStore().load({
                        params: {
	                    bankNameId:bankIdValue,
						branchNameId:branchNameId
                        },
                        callback: function(records, opt, success){
                             if (success) { 
	                            
                                 ifscCodeId.setValue(records[0].data.id);    
                             }
                        }    
                    });
                  
   
          }  },

			
			
            'sponsorshipmastersearchform  combo[itemId=scholMaster_scholType]': {
                render: function(combo) {
                    combo.getStore().load({
                        callback: function(records, operation, success) {
                            var model = new Academia.model.common.IdValueDataModel();
                            model.set('id', '');
                            model.set('value', 'All');
                            combo.getStore().insert(0,model);
                            //combo.getStore().add(model);
                        }
                    });
                }
            },
            /***** Export Buttons************/'searchresultgrid[itemId=sponsorshipMasterGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
                click: function() {
                    this.exportSponsorshipMaster(SERVERURL.PDFEXPORT, 'pdf', false);
                }
            },
            'searchresultgrid[itemId=sponsorshipMasterGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
                click: function() {
                    this.exportSponsorshipMaster(SERVERURL.PDFEXPORT, 'pdf', true);
                }
            },
            'searchresultgrid[itemId=sponsorshipMasterGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
                click: function() {
                    this.exportSponsorshipMaster(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false);
                }
            },
            'searchresultgrid[itemId=sponsorshipMasterGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
                click: function() {
                    this.exportSponsorshipMaster(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true);
                }
            },
            'sponsorshipmasterviewsponsoredstudentsgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var me = this;
                    var columnsArray = grid.getGridColumns();
                    if (columnsArray[cellIndex].dataIndex === "studentCode") {
                        me.openStudentProfile(grid, td, cellIndex, record, tr, rowIndex, e, eOpts);
                    }
                }
            },
            'sponsorshipmastersearchresultgrid #spBtnMoreActions menuitem[itemId=mapSponsorAcademyLocationsLink]': {
            	
                click: this.openSponsorMappingALWindow
                
                
            },
            'sponsorshipmastersearchresultgrid splitbutton menuitem[itemId=manageQuatationLink]': {
            	
                click: this.openQuatationDetailTabPanel
                
                
            },
            'sponsoracademylocationmappinggrid button[itemId=btnAdd]': {
                click: this.mapSponsorAcademyLocations
            },
            'managequotationstructure' :{
            	afterrender:function(panelForm){
            		var sponsorshipMasterGrid = this.getSponsorshipmastersearchresultgrid();
            		var quotationdetailsgrid = this.getQuotationdetailsgrid();
            		var selectedRec = sponsorshipMasterGrid.getSelectionModel().getSelection()[0];
            		var sponserId=selectedRec.raw.sponsorId;
            		var sponsorNameId = panelForm.down('#sponsorNameId');
            		var sponsorCodeId = panelForm.down('#sponsorCodeId');
            		sponsorCodeId.setValue(selectedRec.data.sponsorCode);
            		sponsorNameId.setValue(selectedRec.data.sponsorName);
            		var grid = panelForm.down('grid');
            		var structure = panelForm.up();
					this.getGridHeaderFreeze(grid,structure,true);
					quotationdetailsgrid.getStore().getProxy().extraParams = {
						sponserId: sponserId
					    };
					quotationdetailsgrid.getStore().load();
					
            	}
            },
            'quotationdetailsgrid button[itemId=btnAdd]':{
            	click:function(){
            		 var contentpanel = this.getContentPanel();
                	 var coursetabstructure = Ext.widget('quotationdetailstructure');
                	 var tabName = getCommonTranslation('QUOTATION_DETAILS');

                	 var getcontroller=this.getController('menu.CoreERPNavigationController');
                	 var getTab=getcontroller.getTab(tabName);
                	 if(getTab!=null){
                		 contentpanel.remove(getTab, true);
                	 }
                	 openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TEN);
                	 coursetabstructure.down('quotationdetaildocumentgrid').getStore().removeAll();
            	}
            },
			'quotationdetailsgrid button[itemId=btnDelete]': {
			                click: this.deleteQuotation
			 			},
			'quotationdetailsgrid button[itemId=btnView]': {
            	click: function() {
                	this.editQuotation(this, true);
                }
            },
            'quotationdetailsgrid button[itemId=btnEdit]': {
            	click: function() {
                	this.editQuotation(this, false);
                }
            },
            'quotationdetailstructure':{
            	afterrender:function(form){
            		var brandCampus = form.down('#brandCampusId');
            		var approvalStatus =form.down('#approvalStatusId');
            		var academyLocationId = this.getCurrentAcademyLocation();
            		brandCampus.getStore().load({
            			callback: function(records, operation, success) {
   						 if (success) {
   							 for(var i in records){
   								   if(records[i].data.id==academyLocationId){
   									brandCampus.setValue(academyLocationId);
   									break;
   								   }
   							   }
   						 }
   					 }
            		});
            		approvalStatus.getStore().load({
            			callback:function(records, operation, success){
            				approvalStatus.setValue(records[2].data.value);
            			}
            		});
					
            	}
            },
            'quotationdetailstructure button[itemId=submitBtn]':{
            	click:function(btn){
            		var $this = this;
            		var form = btn.up('form');
            		var sponsorshipMasterGrid = this.getSponsorshipmastersearchresultgrid();
            		var selectedRec = sponsorshipMasterGrid.getSelectionModel().getSelection()[0];
            		var quotationDetailsGrid = this.getQuotationdetailsgrid();
            		var fromValue =form.getForm().getValues();
            		var docGrid = this.getQuotationdetaildocumentgrid();
            		var docGridStore = docGrid.getStore();
            		var userId=fromValue.createdBy;
            		var academyLocId=fromValue.academyLocation;
            		var approvalStatusValue=fromValue.approvalStatus;
            		var sponsorId=selectedRec.raw.sponsorId;
            		fromValue.approvalStatus=approvalStatusValue.toUpperCase();
            		var docGridArray =[];
            		if(docGridStore.getCount() >0){
            			var docGridJson =new Object();
            			var docGridItems = docGridStore.data.items;
            			var docGridDataLength = docGridStore.getCount()
            			for(var i =0;i< docGridDataLength;i++){
            				docGridJson.name =docGridItems[i].data.name;
            				 docGridJson.path =docGridItems[i].data.path;
            				 docGridJson.type =docGridItems[i].data.type;
            				 docGridJson.createdBy ={
            				 	id :docGridItems[i].data.createdBy.id
            				 }
            				docGridArray.push(docGridJson)
            			}
            		}
            		fromValue.documents =docGridArray;
            		
            		fromValue.sponsor={
            				id: sponsorId
            		}
            		fromValue.createdBy={
            				id: userId
            		}
            		fromValue.academyLocation={
            				id: academyLocId
            		}
            		var submitUrl;
            		if(!isNullOrEmpty(fromValue.id)){
            			 submitUrl = SERVERURL.PATH_UPDATE_QUOTATION_DETAIL;
            		}else{
                		 submitUrl = SERVERURL.PATH_SAVE_QUOTATION_DETAIL;

            		}
            		
            		var jsonDataEncode = Ext.encode(fromValue);
            		
            		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading'); 
            	        Ext.Ajax.request({
            	            type: 'rest',
            	            url: submitUrl,
            	            jsonData: jsonDataEncode,
            	            method: 'POST',

            	            success: function(res, action) {
            	            	Ext.getBody().unmask();            	            	
            	            	showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'), getCommonTranslation('SUCCESS'));
            	            	form.up().close();
            	            	quotationDetailsGrid.getStore().load();
            	            	$this.resetPageSetting(quotationDetailsGrid.getStore());
            	            	quotationDetailsGrid.getSelectionModel().deselectAll();
            	            }
            	        });
            	}
            },
            'quotationdetailstructure button[itemId=resetBtn]':{
            	click:function(btn){
            		var form = btn.up('form')
            		form.getForm().reset();
            		var brandCampus = form.down('#brandCampusId');
            		var approvalStatus =form.down('#approvalStatusId');
            		var academyLocationId = this.getCurrentAcademyLocation();
            		brandCampus.getStore().load({
            			callback: function(records, operation, success) {
   						 if (success) {
   							 for(var i in records){
   								   if(records[i].data.id==academyLocationId){
   									brandCampus.setValue(academyLocationId);
   									break;
   								   }
   							   }
   						 }
   					 }
            		});
            		approvalStatus.getStore().load({
            			callback:function(records, operation, success){
            				approvalStatus.setValue(records[2].data.value);
            			}
            		});
            	}
            },
            'quotationdetailstructure button#quotationDocumentUploadId' : {
    			click : function() {
    				this.getDocumentController().showDocumentFormWindow('quotationDocFormItemId','DOCUMENT');
    			}
    		},
    		
    		'documentformwindow[itemId=quotationDocFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = true;
    				var module = 'sponsorship';
    				var entityId;
    				var entityType = 'quotationDetail';

    				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
    						function(success,response,isCallBackTransient) {
    							var documentModel = new Academia.model.course.QuestionPaperDocument();
    							documentModel.set("name",response.name);
    							documentModel.set("path",response.path);
    							documentModel.set("type",response.type);
    							documentModel.set("isNewRecord",true);
    							documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
    							var quotationdocumentgrid = $this.getQuotationdetaildocumentgrid();
    							var store = quotationdocumentgrid.getStore();
    							store.add(documentModel);
    							if (quotationdocumentgrid.isHidden()&& store.data.items.length > 0) {
    								quotationdocumentgrid.setVisible(true);
    							}
    							Ext.apply(quotationdocumentgrid,{
					        		code:null,
					     		  setCode : function(code){
					     			 quotationdocumentgrid.code = code;
					     		  },
					     		  getCode:function(){
					     			  return quotationdocumentgrid.code;
					     		  }
								});
    							quotationdocumentgrid.setCode(documentModel);
    							$this.getDocumentController().closeDocumentFormWindow();
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=quotationDocFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		/*'quotationdetaildocumentgrid':{
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ){
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		if(columnName == "name"){
 	        			if (e.target.tagName == 'A') {
 	        				if(!isNullOrEmpty(record.data.id)){
 	        					var documentId = record.data.id;
 	            				if (!isNullOrEmpty(documentId)) {
 	            					$this.getDocumentController().downloadDocumentFile(documentId);
 	            				}
 	        				}
 	        			}
 	        		}
    			}
    		},*/
    		'quotationdetaildocumentgrid button#btnDelete' : {
    			click : function() {
    				var $this = this;
    				var grid = $this.getQuotationdetaildocumentgrid();
					
    				if (grid.getSelectionModel().getCount() > 0) {
    					showConfirmMessage(getCommonTranslation('DOCUMENTS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    							function(btn,text) {
    								if (btn == 'yes') {
    									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    									var records = grid.getSelectionModel().getSelection();
    									var id = records[0].get("id");
    									if(!isNullOrEmpty(id)){
    										Ext.Ajax.request({
        										method : "DELETE",
        										type : 'rest',
        										url : SERVERURL.DELETE_QUESTION_PAPER_BANK_DOCUMENTS+ '?id='+ id,
        										headers : {
        											'Content-Type' : 'application/json'
        										},
        										success : function(form,action) {
        											Ext.getBody().unmask();
        											grid.getStore().reload();
        											showSuccessMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
        												
        										}
        									});
    									}else{
    										if (records) {
    											grid.getStore().remove(records[0]);
    											Ext.getBody().unmask();    											
    	                 						showSuccessMessage(getCommonTranslation('COURSE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
    	                 						}
    									}
    									
    								}
    							});
    				} else {
    					showWarningMessage(getCommonTranslation('DOCMENT_NAME'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
    		},
    		'contactpersondetailswindow':{
    			render:function(form){
    				var associatedALIds = new Array();
    				associatedALIds.push(this.getCurrentAcademyLocation());
    				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedALIds, this.getSPONSOR_CONTRACT_PERSON_FORM_PERMISSIONS());
                    var country =form.down('#countryId');
                    var genericField= form.down('#genericFieldId1');
                    var postalCode = form.down('#postalCodeItemId');
                    var city = form.down('#cityId');
                    country.setVisible(false);
                    city.setVisible(false);
                    postalCode.setVisible(false);
                    genericField.setVisible(false);
                    country.allowBlank=true;
                    genericField.allowBlank=true;
                    city.allowBlank=true;
                    
                    
                    Ext.each(permissionList,function(priviledge){
                    	if(priviledge == 'COUNTRY'){
                    		country.setVisible(true);
                    		country.allowBlank=false;
                    	}else if(priviledge == 'CITY'){
                    		city.setVisible(true);
                    		city.allowBlank=false;
                    	}else if(priviledge == 'POSTAL_CODE'){
                    		postalCode.setVisible(true);
                    	}else if(priviledge == 'GENERIC_FIELD1'){
                    		genericField.setVisible(true);
                    		genericField.allowBlank=false;
                    	}
                    });
    			}
    		},
			'sponsorinvoicegrid':{
				afterrender: function(grid){
					this.doAccessControlValidation(grid, this.getSPONSOR_INVOICE_PERMISSIONS());
					this.disableGridButtonsPivileges(grid, this.getSPONSOR_INVOICE_PERMISSIONS());
				},
				cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					var $this = this,documentCount,
					columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex,
					documentId = record.get("encryptedDocId");
					if (columnName == "documentCount") {
						if (e.target.tagName == 'A') {
							documentCount = Ext.String.trim(record.get('documentCount'));
							if (/^\d+$/.test(documentCount) && parseInt(documentCount) > 1) {
								 var docWindow = this.getSponsorinvoicedocumentlistwin();
								 if (!docWindow) {
									 Ext.widget('sponsorinvoicedocumentlistwin');
									 docWindow = Ext.widget('sponsorinvoicedocumentlistwin',{
										 itemId:'sponsorinvoicedocumentlistwinId'
									 });
									 docWindow = this.getSponsorinvoicedocumentlistwin();
								 }
								 docWindow.show();
							}else{
								if (!isNullOrEmpty(documentId)) {
									$this.getDocumentController().downloadDocumentFile(documentId);
								}
							}
						}
					}
				}
			},
			'sponsorinvoicegrid button[itemId=btnAdd]': {
				click:function(){
					this.addSponsorInvoiceCaptureWin('add');
				}
			},
			'sponsorinvoicegrid button[itemId=btnEdit]': {
				click:function(){
					var grid = this.getSponsorinvoicegrid();
					if (grid.getSelectionModel().getCount() > 0) {
						this.addSponsorInvoiceCaptureWin('edit');
						this.setDataOnSponsorInvoiceCaptureWin();
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'sponsorinvoicegrid button[itemId=btnDelete]': {
				click:function(obj){
					var $this=this,
				    grid = this.getSponsorinvoicegrid();
     				if (grid.getSelectionModel().getCount() > 0) {
     					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
     						if (btn == 'yes') {
     							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     							var records = grid.getSelectionModel().getSelection();
     							var id = records[0].get("id");
     							Ext.Ajax.request({
     								method : "DELETE",
     								type : 'rest',
     								url : SERVERURL.PATH_SPONSOR_INVOICE_DELETE+'?id='+id,
     								headers : {
     									'Content-Type' : 'application/json'
     								},
     								success : function(form,action) {
     									var resp = Ext.decode(form.responseText);
     									if(resp==-1){
     										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENCY_EXISTS'));
     									}else{
     										grid.getStore().reload();
     										showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
     									}
     									Ext.getBody().unmask();
     								}
     							});
     						}
     					});
     				}else {
     					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     				}
     			
				}
			},
			'sponsorinvoicefilter button[itemId=resetBtn]': {
				click:function(){
					var filter = this.getSponsorinvoicefilter(),
					fnpMultiBrandCampusNameField = filter.down('#academyLocationId'),
					ALComboStore = fnpMultiBrandCampusNameField.getStore();
					filter.getForm().reset();

					ALComboStore.load({
						callback: function(records, operation, success) {
							if (success) {
								fnpMultiBrandCampusNameField.select(fnpMultiBrandCampusNameField.getStore().collect(fnpMultiBrandCampusNameField.valueField));
							}
						}   
					});
				}
			},
			'sponsorinvoicefilter button[itemId=searchBtn]': {
				click:function(){
					var alArray=[],academyLocationStr,aL,grid = this.getSponsorinvoicegrid(),
					filter = this.getSponsorinvoicefilter(),
					formValue  = filter.getForm().getValues(),
					invoiceNo = filter.down('#sponsorInvoiceNum'),
					academyLocation = filter.down('#academyLocationId'),
					whetherInactiveSponsor  = filter.down('#whetherInactiveSponsor'),
					fromDate = (!isNullOrEmpty(filter.down("#dateFrom").getValue()))?filter.down("#dateFrom").getValue().toISOString().split('.')[0]:'';
					tillDate = (!isNullOrEmpty(filter.down("#dateTill").getValue()))?filter.down("#dateTill").getValue().toISOString().split('.')[0]:'';
					store = grid.getStore(),
					aL = academyLocation.getValue();
					if(aL !=undefined && aL.length > 0) {
						for(var i in aL) {
							if(Ext.isObject(aL[0])) {
								alArray.push(aL[i].get("id"));
							} else {
								alArray.push(aL[i]);
							}
						}
						academyLocationStr= alArray.join();
					} else {
						academyLocationStr = null;
					}	
					if(fromDate.includes('T')){
						fromDate = fromDate.replace('T', ' ');
            		}
					
					if(tillDate.includes('T')){
						tillDate = tillDate.replace('T', ' ');
            		}
					
					store.getProxy().extraParams = {
						sponsorInvoiceNo: invoiceNo.getRawValue(),
						sponsorInvoiceDate:formValue.invoiceDate,
						sponsorInvoiceId:formValue.sponsorIdName,
						academyLocationIds:academyLocationStr,
						raiseBillCategory:formValue.billCategory,
						fromDate:fromDate,
						tillDate:tillDate,
						sponsorStatus:whetherInactiveSponsor.getValue()
					};
					grid.getSelectionModel().deselectAll();
					this.resetGridSetting(grid);
					this.resetPageSetting(store);
					store.load();
				}
			},
			'sponsorinvoicecapturewin':{
				afterrender: function(win){
					var $this=this,invoiceAmount = win.down('#invoiceAmountId'),
					isInvoiceSentToSponsor = win.down('#isInvoiceSentToSponsorId'),
					uploadSponsorInvoiceItemId =  win.down('#uploadSponsorInvoiceItemId');
					if(win.formType=='add'){
						this.setAllowBlank(invoiceAmount, true);
					}else{
						invoiceAmount.setVisible(true);
						isInvoiceSentToSponsor.setVisible(true);
						uploadSponsorInvoiceItemId.setVisible(true);
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_FIND_ENTITY_SETTING_BY_TABLE_NAME,                            
						method: 'GET',
						params: {
							tableName: 'sponsor_invoice'
						},
						success: function(response,form, action) {
							var response =  Ext.JSON.decode(response.responseText);
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.FIND_BY_ENTITY_ID,                            
								method: 'GET',
								params: {
									entityId: response
								},
								success: function(response,form, action) {
									if(!isNullOrEmpty(response.responseText)){
										var responseObject =  Ext.JSON.decode(response.responseText);
										if(!isEmpty(responseObject)){
											var sponsorInvoiceCode = win.down("#sponsorInvoiceId");
											if(responseObject.whetherManualId){
												sponsorInvoiceCode.setReadOnly(false);
												$this.setAllowBlank(sponsorInvoiceCode,false);  
												$this.setFieldPlaceHolder(sponsorInvoiceCode,'');
												sponsorInvoiceCode.emptyText=' ';
												sponsorInvoiceCode.applyEmptyText();
											}else{
												sponsorInvoiceCode.setReadOnly(true);
												$this.setAllowBlank(sponsorInvoiceCode,true);
												$this.setFieldPlaceHolder(sponsorInvoiceCode,getCommonTranslation('ID_AUTOGENERATE'));
												sponsorInvoiceCode.applyEmptyText();
											}
										}
									}   
									Ext.getBody().unmask(); 
								},
								failure:function(){
			    					Ext.getBody().unmask(); 
			    				}
							});
						},
						failure:function(){
	    					Ext.getBody().unmask(); 
	    				}             
					});
				},
				close:function(){
					this.sponsorDocIdsToBeDeleted=[];
				}
			},
			'sponsorinvoicecapturewin button[itemId=uploadSponsorInvoiceItemId]' : {
				 click : function() {
					 this.getDocumentController().showDocumentFormWindow('sponsor_Invoice_hidden_field','DOCUMENT');
				 }
			 },
			 'documentformwindow[itemId=sponsor_Invoice_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
				 click : function() {
					 this.uploadSponsorInvoiceDocuments();
				 }
			 },
			 'sponsorinvoicefilter':{
				 afterrender: function(form) {
					 var multiBrandCampusId = form.down('#academyLocationId');
					 var ALComboStore = multiBrandCampusId.getStore();
					 ALComboStore.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 multiBrandCampusId.select(multiBrandCampusId.getStore().collect(multiBrandCampusId.valueField));
							 }
						 }   
					 });
				 }
			 },
			 'sponsorinvoicefilter checkboxfield[itemId=whetherInactiveSponsor]':{
				 change:function(){
					 var sponsorInvoiceFilter = this.getSponsorinvoicefilter(),
					 sponsorIdName = sponsorInvoiceFilter.down('#sponsorIdName');
					 sponsorIdName.reset();
				 }
			 },
			 'sponsorinvoicefilter customcombobox[itemId=sponsorIdName]': {
				 afterrender: function(combo) {
					 var academyLocationStr,sponsorInvoiceFilter = this.getSponsorinvoicefilter(),
					 academyLocation = sponsorInvoiceFilter.down('#academyLocationId'),
					 whetherInactiveSponsor = sponsorInvoiceFilter.down('#whetherInactiveSponsor'),
					 sponsorStore = combo.getStore();
					 sponsorStore.on('beforeload',function() {
						 var aL = academyLocation.getValue();
						 var alArray=[];
						 if(aL !=undefined && aL.length > 0) {
							 for(var i in aL) {
								 if(Ext.isObject(aL[0])) {
									 alArray.push(aL[i].get("id"));
								 } else {
									 alArray.push(aL[i]);
								 }
							 }
							 academyLocationStr= alArray.join();
						 } else {
							 academyLocationStr = null;
						 }	
						 sponsorStore.getProxy().extraParams = {
							 academyLocationIds: academyLocationStr,
							 sponsorStatus: whetherInactiveSponsor.getValue()
						 };
					 }, this);
				 }
			 },
			 'sponsorinvoicecapturewin customcombobox[itemId=academyLocationId]': {
				 select: function(combo) {
					 var sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin();
					 sponsorInvoiceCaptureWin.down('#sponsorIdName').reset();
				 }
			 },
			 'sponsorinvoicefilter multiselectcombofield[itemId=academyLocationId]': {
				 change: function(combo) {
					 var sponsorInvoiceCaptureWin = this.getSponsorinvoicefilter();
					 sponsorInvoiceCaptureWin.down('#sponsorIdName').reset();
				 }
			 },
			 'sponsorinvoicecapturewin customcombobox[itemId=sponsorIdName]': {
				 afterrender: function(combo) {
					 var sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin(),
					 academyLocation = sponsorInvoiceCaptureWin.down('#academyLocationId');
					 sponsorStore = combo.getStore();
					 sponsorStore.on('beforeload',function() {
						 var alArray=[];
						 alArray.push(academyLocation.getValue());
						 sponsorStore.getProxy().extraParams = {
							 academyLocationIds: alArray.join()
						 };
					 }, this);
				 }
			 },
			'sponsorinvoicecapturewin button[itemId=btnSaveSponsorInvoice]': {
				click:function(btn){
					this.saveSponsorInvoiceDetails(btn);
				}
			},
			'sponsorinvoicecapturewin button[itemId=btnCancelSponsorInvoice]': {
				click:function(){
					var sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin();
					sponsorInvoiceCaptureWin.close();
				}
			},
			'sponsorinvoicedocumentgrid': {
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					var $this = this;
					var grid = $this.getSponsorinvoicedocumentgrid();
					var columnName = grid.columnManager.columns[cellIndex].dataIndex;
					if (columnName == "deleteButton") {
						if (e.target.className == "deleteButtonClsForGridActionCls") {
							$this.deleteSponsorInvoiceDocs();
						}
					}
				}
			},
			'sponsorinvoicedocumentlistwin grid[itemId=docListGridId]':{
				afterrender:function(grid){
					var sponsorGrid = this.getSponsorinvoicegrid(),
					record = sponsorGrid.getSelectionModel().getSelection()[0];
					docGridStore = grid.getStore();
					if(record && record.data){
						docGridStore.getProxy().extraParams = {
							sponsorInvoiceId: record.data.id
						};
						docGridStore.load();
					}
				},
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					var $this = this,
					columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex,
					documentId = record.get("encryptedDocId");
					if (columnName == "name") {
						if (e.target.tagName == 'A') {
							if (!isNullOrEmpty(documentId)) {
								$this.getDocumentController().downloadDocumentFile(documentId);
							}
						}
					}
				}
			},
			'sponsorinvoicedocumentlistwin button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					this.documentDownloadDocumentZip();
				}
			},
			'sponsorinvoicegrid button[itemId=updateAmountReceived]':{
				click:function(obj){
					var record,grid = this.getSponsorinvoicegrid();
					if (grid.getSelectionModel().getCount() > 0) {
						record = grid.getSelectionModel().getSelection()[0];
						if(record && record.data && record.data.invoiceAmount){
							var updateAmountReceivedWin = this.getSponsorinvoiceupdateamountreceivedwin();
							if (!updateAmountReceivedWin) {
								Ext.widget('sponsorinvoiceupdateamountreceivedwin');
								updateAmountReceivedWin = this.getSponsorinvoiceupdateamountreceivedwin();
							}
							updateAmountReceivedWin.show();
						}else{
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_UPDATE_INVOICE_AMOUNT_FIRST'));
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'sponsorinvoiceupdateamountreceivedwin':{
				close: function(){
					this.sponsorAmtIdsToBeDeleted=[];
				}
			},
			'sponsorinvoiceupdateamountreceivedwin grid[itemId=UpdateAmountReceivedGridId]':{
    			afterrender: function(button) {
    				this.getUpdatedAmountReceivedData();
    			},
    			cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				this.addDeleteRowToUpdateAmountReceived(grid, td, cellIndex, record, tr, rowIndex, e, eOpts);
                }
    		},
			'sponsorinvoiceupdateamountreceivedwin button[itemId=btnAdd]':{
    			click: function(button) {
    				this.addNewRowInUpdateAmountReceivedGrid(1);
    			}
    		},
    		'sponsorinvoiceupdateamountreceivedwin button[itemId=btnSaveUpdateAmountReceive]':{
    			click: function(button) {
    				this.saveUpdateAmountReceivedGridData();
    			}
    		}
        });
    },
    disableManageQuotationLink :function(grid,permissionMap){
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		var manageQuotationBtn  = grid.down('#manageQuatationLink');
		manageQuotationBtn.setVisible(false);
		
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'MANAGE_QUOTATION') {
				if (!isNullOrEmpty(manageQuotationBtn)) {
					manageQuotationBtn.setVisible(true);
				}
			}
			
		});
		
    },
    getIdValueJson : function(id, value) {
      	if (id)
      		return {
      		id : id,
      		value : value
      	};
      },
    getDocumentController : function() {
      	var this$ = this;
      	return this$.getController('Academia.controller.document.DocumentController');
      },
    openQuatationDetailTabPanel :function(){
    	 var contentpanel = this.getContentPanel();
    	 var coursetabstructure = Ext.widget('managequotationstructure');
    	 var tabName = getCommonTranslation('MANAGE_QUOTATION');
    	 var getcontroller=this.getController('menu.CoreERPNavigationController');
    	 var getTab=getcontroller.getTab(tabName);
    	 if(getTab!=null){
    		 contentpanel.remove(getTab, true);
    	 }
    	 openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TEN);
    	 //quotationDetailsGrid.getStore().load();
    	 
    },
    /**** Export function *******/
    exportSponsorshipMaster: function(exportUrl, filetype, whetherAll) {
        var quickSearchForm = this.getSponsorshipMasterForm();
        var searchResultGrid = this.getSearchResultGrid();
        var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString = this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData = this.createJsonFormat(quickSearchForm);
        var visibleColumns = this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('SPONSORSHIP_MASTER');
        if (!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) && searchResultGrid.store.getCurrentSortCriteria() != undefined && searchResultGrid.store.getCurrentSortCriteria() != null) jsonFormatFormData.sortCriterias = searchResultGrid.store.getCurrentSortCriteria();
        searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle);
    },
    
    createSearchCriteriaString: function(searchForm) {
        var me = this;
        var formValues = new Array();
        formValues = searchForm.getValues();
        var searchCriteriaString = "";
        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                searchCriteriaString = searchCriteriaString + keyValueJsonObject.paramCode + "  : " + searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString = searchCriteriaString.substring(0, searchCriteriaString.length - 1);
        return searchCriteriaString;
    },

    /**
     * @method to show number of sponsored student form
     */
    onSponsoredStudentsCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var searchResultGrid = grid.up('grid')
        var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        var manageQuatationLink = grid.up('sponsorshipmastersearchresultgrid').down('#manageQuatationLink');
        manageQuatationLink.enable();
        if (columnName == "noOfStudentSponsored") {
            var me = this;
            var value = record.get(columnName);
            var sponsorId = record.get('sponsorId');
            if (value > 0) {
                var popup = me.showSponsoredStudentPopUp(record);
                var grid = popup.down('grid');
                var store = grid.getStore();
                store.getProxy().extraParams = {
                    'sponsorId': sponsorId
                };
                store.load({
                	callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0){
								popup.down('#amountSponsoredTotal').setValue(records[0].data.amountSponsoredTillDate);
							}		 
						}
					}	
                });
            }
        }
    },

    showSponsoredStudentPopUp: function(record) {
        var sponsoredStudentWindow = this.getSponsorshipMasterViewSponsoredStudentsWindow();
        if (!sponsoredStudentWindow) {
            sponsoredStudentWindow = Ext.widget('sponsorshipmasterviewsponsoredstudentswindow');
        }
        var grid = sponsoredStudentWindow.down('grid');
        sponsoredStudentWindow.show();
        if(!isNullOrEmpty((record.data.sponsorCode) && (record.data.sponsorName))){
        	sponsoredStudentWindow.down('#sponsorCode').setValue(record.data.sponsorCode);
        	sponsoredStudentWindow.down('#sponsorName').setValue(record.data.sponsorName);
        	sponsoredStudentWindow.down('#amountSponsoredTotal').setValue(record.data.amountSponsoredTillDate);
        }
        return sponsoredStudentWindow;
    },

    loadcityParentRegionStore: function(combo, records, eOpts) {
        var this$$ = this;
        var id = records[0].data.id;
        var comboref = this$$.getContactPersonDetailsForm().down("#cityId");
        var parentcombo = this$$.getContactPersonDetailsForm().down("#genericFieldId1");
        var store = comboref.getStore();
        var parentStore = parentcombo.getStore();
        parentcombo.setDisabled(false);
        comboref.setDisabled(true);
        parentcombo.reset();
        comboref.reset();
        /*store.load({
            params: {
                id: id
            }
        });*/
        parentStore.load({
            params: {
                cid: id
            }
        });
    },
    loadCityStore: function(combo, records, eOpts) {
        var id = records[0].data.id;
        var cityRef = this.getContactPersonDetailsForm().down("#cityId");
        cityRef.reset();
        cityRef.setDisabled(false);
        var cityStore = cityRef.getStore();
        cityStore.load({
            params: {
                id: id
            }
        });
    },
    loadCountryRegionStore: function(combo, records, eOpts) {
        var id = records[0].data.id;
        var countryRef = this.getContactPersonDetailsForm().down("#genericFieldId2");
        var coutryStore = countryRef.getStore();
        coutryStore.load({
            params: {
                pid: id
            }
        });
    },
    
    /*loadGridAndSearchUsers: function(model, records) {
        var MasterForm = this.getSponsorshipMasterForm();
        var jsonFormatFormData = this.createJsonFormat(MasterForm, records);
        var ResultGrid = this.getSearchResultGrid();
        //var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        var resultViewUrl = SERVERURL.PATH_FIND_SEARCH_SPONSOR_MASTER_GRID;
        //resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.SPONSORSHIP_MASTER_VIEWCODE);
        ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    }*/
    loadGridAndSearchUsers: function(model, records) {
 	   var $this=this;
	   var form = $this.getSponsorshipMasterForm();
	  
	   var sponsorId = form.down("#sponMaster_sponId").getValue();
	   var sponsorType = form.down("#scholMaster_scholType").getValue();
	   if (sponsorType != 'All') {
		   var sponsorTypeVal = sponsorType;
       }
	   var amountRangeFrom = form.down("#sponMaster_amountRangeFrom").getValue();
	   var amountRangeTo = form.down("#sponMaster_amountRangeTo").getValue();
	   var sponsorAcademyLocations = form.down("#sponsorAcademyLocations").getValue();
	   var grid = $this.getSponsorshipmastersearchresultgrid();
	   var manageQuatationLink = grid.down('#manageQuatationLink');
       manageQuatationLink.disable();
       
	   var store =  grid.getStore();
	   this.resetPageSetting(store);
	   store.getProxy().extraParams = {
		   sponsorId: sponsorId,
		   sponsorType: sponsorTypeVal,
		   amountRangeFrom: amountRangeFrom,
		   amountRangeTo: amountRangeTo,
		   academyLocationId: sponsorAcademyLocations,
	   };
	   //$this.resetPageSetting(store);
	   store.load();
   }
    
    ,

    createJsonFormat: function(MasterForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.SPONSORSHIP_MASTER_BASIC_CONFIGCODE;

        formValues = MasterForm.getValues();

        var SPONSOR_ID = this.getJsonObject('SPONSOR_ID', formValues.SPONSOR_ID);
        this.pushJsonObjectInArray(SPONSOR_ID, searchcriteria);

        /*var SPONSOR_NAME = this.getJsonObject('SPONSOR_NAME', formValues.SPONSOR_NAME);
        this.pushJsonObjectInArray(SPONSOR_NAME, searchcriteria);*/

        var AMOUNT_RANGE_FROM = this.getJsonObject('AMOUNT_RANGE_FROM', formValues.AMOUNT_RANGE_FROM);
        this.pushJsonObjectInArray(AMOUNT_RANGE_FROM, searchcriteria);

        var AMOUNT_RANGE_TO = this.getJsonObject('AMOUNT_RANGE_TO', formValues.AMOUNT_RANGE_TO);
        this.pushJsonObjectInArray(AMOUNT_RANGE_TO, searchcriteria);


        /*var PROGRAM_NAME = this.getJsonObject('PROGRAM_NAME', formValues.PROGRAM_NAME);
        this.pushJsonObjectInArray(PROGRAM_NAME, searchcriteria);*/

        if (formValues.SPONSOR_TYPE != 'All') {
            var SPONSOR_TYPE = this.getJsonObject('SPONSOR_TYPE', formValues.SPONSOR_TYPE);
            this.pushJsonObjectInArray(SPONSOR_TYPE, searchcriteria);
        }
        values.searchCriterias = searchcriteria;
        return values;
    },

    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    gridRenderFunction: function(grid) {
        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'btnAdd',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'btnEdit',
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'btnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'	
            }, {
                xtype: 'button',
                itemId: 'btnDelete',
                cls: 'CustomToolbarBtnReject',
                tooltip: getCommonTranslation('DELETE'),
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            }, '->', {
                xtype: 'button',
                itemId: 'exportToPdfBtn',
                text: getCommonTranslation('PRINT_EXPORT_BTN'),
                //iconCls: 'export-combo-icon', // Optional icon
                cls: 'print_export_btn_cls',
                menu: [{
                    text: 'Export to PDF',
                    //itemId: 'btnExportToPDF',
                    menu: [{
                        text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
                        itemId: 'exportCurrentPagePdf'
                    }, {
                        text: getCommonTranslation('EXPORT_ALL_COMMON'),
                        itemId: 'exportPdfAll'
                    }]
                }, {
                    text: 'Export to Excel',
                    itemId: 'exportToPdfBtn',
                    menu: [{
                        text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
                        itemId: 'exportCurrentExcelPage'
                    }, {
                        text: getCommonTranslation('EXPORT_ALL_COMMON'),
                        itemId: 'exportExcelAll'
                    }]
                }]
            }/*{
                xtype: 'splitbutton',
                itemId: 'exportToPdfBtn',
                cls: 'CustomToolbarBtnExport export-cls',
                iconCls: 'export-pdf-icon',
                menu: [{
                    text: 'Export Current Page',
                    itemId: 'exportCurrentPagePdf'
                }, {
                    text: 'Export All',
                    itemId: 'exportPdfAll'
                }],
                listeners: {
                    click: function() {
                        this.showMenu();
                    }
                }
            }, {
                xtype: 'splitbutton',
                itemId: 'exportToPdfBtn',
                cls: 'CustomToolbarBtnExport export-cls',
                iconCls: 'export-excel-icon',
                menu: [{
                    text: 'Export Current Page',
                    itemId: 'exportCurrentExcelPage'
                }, {
                    text: 'Export All',
                    itemId: 'exportExcelAll'
                }],
                listeners: {
                    click: function() {
                        this.showMenu();
                    }
                }
            }*/]

        });
    },

    loadCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },
    loadContactCombo: function(combo) {
        var store = combo.getStore();
        store.load();
    },
    addSponsor: function() {
    	var  $this = this;
        var SponsorWindow = this.getCompanyDetailsWindow();
        if (!SponsorWindow) {
            SponsorWindow = Ext.widget('sponsorcompanydetailswindow');
        }
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.FIND_BY_ENTITY_ID,                            
            method: 'GET',
            params: {
                entityId: 14
            },
            success: function(response,form, action) {
                if(!isNullOrEmpty(response.responseText)){
                    var responseObject =  Ext.JSON.decode(response.responseText);//make object of response text
                    if(!isEmpty(responseObject)){
                        var sponsorID = SponsorWindow.down("#sponsorID");
                        if(responseObject.whetherManualId){
                        	sponsorID.setReadOnly(false)
                            $this.setAllowBlank(sponsorID,false);  
                            $this.setFieldPlaceHolder(sponsorID,'');
                        }else{
                        	sponsorID.setReadOnly(true);
                            $this.setAllowBlank(sponsorID,true);
                            $this.setFieldPlaceHolder(sponsorID,getCommonTranslation('ID_AUTOGENERATE'));
                        }
                    }
                }                                                     
            }                
        });
        
        SponsorWindow.show();
    },

    deletSponsor: function() {
        var grid = this.getSponsorshipmastersearchresultgrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection()[0];
                    var id = records.data.sponsorId;

                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'DELETE',
                        url: SERVERURL.SPONSORSHIP_DELETE + '?id=' + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            var data = form.responseText;
  						 if(data == 'DEPENDENCY_EXIST'){
  							  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENCY_EXISTS'));
  						  }else{
  							  grid.getStore().reload(); // after deleted a record reloading the grid data
  							showSuccessMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('SPONSORSHIP_DELETE_SUCCESS'));
  						  }
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DELETE_SPONSORSHIP'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    editSponsor: function(controllerRef, isView) {
        var this$$ = this;
        var grid = this$$.getSponsorshipmastersearchresultgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var id = record.raw.sponsorId;
            this$$.addSponsor();
            var SponsorWindow = this$$.getCompanyDetailsWindow();
           
            SponsorWindow.down('#sponsorID').setReadOnly(true);
            this$$.getCompanyDetailsForm().getForm().setValues({
                id: id
            });
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.SPONSORSHIP_URL,
                method: 'GET',
                params: {
                    id: id
                },
                success: function(res, action) {
                    var data = Ext.decode(res.responseText);
                    var form = this$$.getCompanyDetailsForm();
                    form.getForm().setValues(data);
                    if (isView) {
                        SponsorWindow.down('#btnSaveCompanyDetails').setVisible(false);
                        formWindow = this$$.getCompanyDetailsForm();
                        toggleReadOnlyFormItems(formWindow.getForm(), true);
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    cancelSponsorCompanyDetails: function() {
        this.getCompanyDetailsWindow().close();
    },

	SaveSponsorCompanyDetails: function() {
		var this$ = this;
		var refAddSponsorForm = this$.getCompanyDetailsForm();
		var resultGrid = this$.getSponsorshipmastersearchresultgrid();
		var formData = refAddSponsorForm.getValues();
		var sponsorName = formData.sponsorName;
		var sponsorshipCode = formData.sponsorshipCode;
		var tabNameSave = sponsorName + " - " + getCommonTranslation('ADD_SPONSORSHIP_MSG');
		var tabNameUpdate = sponsorName + " - " + getCommonTranslation('UPDATE_SPONSORSHIP_MSG');
		var tabName = getCommonTranslation('SPONSORSHIP_DETAILS');
		var submitUrl, isUpdate = false;
		var addSponsorshipField = refAddSponsorForm.down('#Hidden_id');

		Ext.Ajax.request({
			method: "GET",
			type: 'rest',
			url: SERVERURL.PATH_FIND_UNIQUE_SPONSOR_NAME,
			params: {
				sponsorName: sponsorName,
				sponsorId:formData.id
			},
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(resp, action) {
				var mssg = resp.responseText;

				if (mssg == "false") {

					showConfirmMessage(getCommonTranslation('SPONSORSHIP_MASTER'),
						getCommonTranslation('DUPLICATE_SPONSOR_MESSAGE'), function(btn, text) {
							if (btn == 'yes') {
							
								if (addSponsorshipField.getSubmitValue() == null || addSponsorshipField.getSubmitValue() == "" || addSponsorshipField.getSubmitValue() === undefined) {
									submitUrl = SERVERURL.ADD_SPONSORSHIP_CREATE,
										isUpdate = false;
								} else {
									submitUrl = SERVERURL.ADD_SPONSORSHIP_UPDATE,
										isUpdate = true;
								};

								jsonDataEncode = Ext.encode(formData);
								this$.applyWindowMask();


								Ext.Ajax.request({
									type: 'rest',
									url: submitUrl,
									jsonData: jsonDataEncode,
									method: 'POST',

									success: function(form, action) {
										this$.hideWindowMask();
										resultGrid.getStore().reload();
										this$.cancelSponsorCompanyDetails();
										resultGrid.getSelectionModel().deselectAll(true);

										if (isUpdate) {
											showSuccessMessage(tabName, getCommonTranslation('UPDATE_SPONSORSHIP_MSG'));

										} else {
											if (form.responseText == '0') {
												showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SPONSOR_CODE_EXIST')); //spoonsor code exist
											} else {
												showSuccessMessage(tabName, getCommonTranslation('ADD_SPONSORSHIP_MSG'));
											}
										}
									}
								});
							}
						});
					
				} else {
					if (addSponsorshipField.getSubmitValue() == null || addSponsorshipField.getSubmitValue() == "" || addSponsorshipField.getSubmitValue() === undefined) {
						submitUrl = SERVERURL.ADD_SPONSORSHIP_CREATE,
							isUpdate = false;
					} else {
						submitUrl = SERVERURL.ADD_SPONSORSHIP_UPDATE,
							isUpdate = true;
					};

					jsonDataEncode = Ext.encode(formData);
					this$.applyWindowMask();


					Ext.Ajax.request({
						type: 'rest',
						url: submitUrl,
						jsonData: jsonDataEncode,
						method: 'POST',

						success: function(form, action) {
							this$.hideWindowMask();
							resultGrid.getStore().reload();
							this$.cancelSponsorCompanyDetails();
							resultGrid.getSelectionModel().deselectAll(true);

							if (isUpdate) {
								showSuccessMessage(tabName, getCommonTranslation('UPDATE_SPONSORSHIP_MSG'));

							} else {
								if (form.responseText == '0') {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SPONSOR_CODE_EXIST')); //spoonsor code exist
								} else {
									showSuccessMessage(tabName, getCommonTranslation('ADD_SPONSORSHIP_MSG'));
								}
							}
						}
					});
				}
			}
		});



	},

    addContact: function() {
        var grid = this.getSponsorshipmastersearchresultgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            this.getContactPersonDetailsGrid().showContactPersonDetailsForm();
            if (records != "" && records != null && records != undefined) {}
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SPONSOR')); //Please select a sponsor 							
        }
    },
    
    cancelContactDetailsForm: function() {
        this.getContactPersonDetailsWindow().close();
    },

    /**
     * This function is used to load dependent combo
     */
    loadComboValue: function(combo, value, param) {
        var store = combo.getStore();
        if (!store.items) {
            store.load({
                params: param,
                callback: function(records, operation, success) {
                    if (success) {
                        combo.setValue(value);
                        combo.setDisabled(false);
                    }
                }
            });
        }
    },

    editContact: function(isView) {
        var this$$ = this;
        var grid = this$$.getContactPersonDetailsGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var id = record.data.id;
            this$$.getContactPersonDetailsGrid().showContactPersonDetailsForm();
            var addContactFormVar = this$$.getContactPersonDetailsForm();
            
            
            if (isView) {
                var contactPersonDetailsWindow = this$$.getContactPersonDetailsWindow();
                contactPersonDetailsWindow.down('#btnSaveContactForm').setVisible(false);
                toggleReadOnlyFormItems(addContactFormVar.getForm(), true);
            }

            this$$.getContactPersonDetailsForm().getForm().setValues({
                contactPersonId: id
            });

            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.SPONSORSHIP_CONTACT_URL + id,
                method: 'GET',
                success: function(res, action) {
                    var data = Ext.decode(res.responseText);
                    var form = this$$.getContactPersonDetailsForm().getForm();
                    var countryRef = this$$.getContactPersonDetailsForm().down('#countryId');
                    var cityRef = this$$.getContactPersonDetailsForm().down('#cityId');
                    var parentRegionRef = this$$.getContactPersonDetailsForm().down('#genericFieldId1');
                    var countryRegionRef = this$$.getContactPersonDetailsForm().down('#genericFieldId2');
                    var countryValue = data.address.country.id;
                    var cityValue = data.address.city.id;
                    var parentId = data.address.parentCountryRegion.id;
                    var countryRegionId = '';
                    
                    if (!isNullOrEmpty(data.address.countryRegion)) countryRegionId = data.address.countryRegion.id;

                    countryRef.setValue(countryValue);
                    this$$.loadComboValue(cityRef, cityValue, new Object({
                        id: parentId
                    }));
                    this$$.loadComboValue(parentRegionRef, parentId, new Object({
                        cid: countryValue
                    }));
                   /* this$$.loadComboValue(countryRegionRef, countryRegionId, new Object({
                        pid: parentId
                    }));*/
                    form.setValues(data);
                    form.setValues(data.address);

                  var ifscCode = this$$.getContactPersonDetailsForm().down('#ifscCode');
                   if(!isNullOrEmpty(data.ifscCodeId)) {
                     ifscCode.getStore().load({
                    callback: function(records, operation, success) {
                    if (success) {
                        for(var i in records){
                            if(records[i].data.id == data.ifscCodeId.id){
                            ifscCode.setValue(data.ifscCodeId.id);
                            }
                        }
                    }
                }
            });
           }

  var branchName = this$$.getContactPersonDetailsForm().down('#branchName');
                   if(!isNullOrEmpty(data.branchNameId)) {
                     branchName.getStore().load({
                    callback: function(records, operation, success) {
                    if (success) {
                        for(var i in records){
                            if(records[i].data.id == data.branchNameId.id){
                            branchName.setValue(data.branchNameId.id);
                            }
                        }
                    }
                }
            });
           }

                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * this function is used to get id of combo
     */
    getComboId: function(combo) {

        var id = combo.getValue();
        var obj = new Object();
        obj.id = id;
        return obj;
    },
    /**
     * this function is used to set values in form data
     */
    getObj: function(ref) {
        var obj = new Object();
        for (var i = 0; i < 4; i++) {
            obj = this.getComboId(ref);
        }
        return obj;
    },
    /** 
     * This function is used to validate phone number 
     * @param data
     * @returns {Boolean}
     */
    validatePhone: function(data) {
        var isValid;
        if (!data.phoneNo && !data.cellNo) {
            showErrorMessage(getCommonTranslation('CONTACT_PERSON_DETAILS'), getCommonTranslation('ADD_PHONE_NO'));
            isValid = false;
        } else {
            isValid = true;
        }
        return isValid;
    },

    /*
     * This function is used for to save contact form Details after clicking on save button    
     */
    SaveContactDetailsForm: function() {
        var this$ = this;
        var refAddContactForm = this$.getContactPersonDetailsForm();
        var formData = refAddContactForm.getValues();
        var address = new Academia.model.organization.Address(formData);
        var grid = this$.getContactPersonDetailsGrid();
        var sponsorGrid = this$.getSponsorshipmastersearchresultgrid();
        var record = sponsorGrid.getSelectionModel().getSelection()[0];
        var id = record.raw.sponsorId;
        var finalData = new Object();
        
        if (!isNullOrEmpty(id)) finalData.sponsorId = id;
		finalData.beneficiaryName=formData.beneficiaryName;
		finalData.accountNo=formData.accountNo
	//	finalData.accountType=formData.accountType
	    if(formData.accountTypeId!=undefined && formData.accountTypeId.id!=null)
		{
		finalData.accountTypeId=formData.accountTypeId.id
		}
		if(formData.bankNameId!=undefined && formData.bankNameId.id!=null)
		{
		finalData.bankNameId=formData.bankNameId.id
		}
		if(formData.branchNameId!=undefined && formData.branchNameId.id!=null)
		{
		finalData.branchNameId=formData.branchNameId.id
		}
		if(formData.ifscCodeId!=undefined && formData.ifscCodeId.id!=null)
		{
		finalData.ifscCodeId=formData.ifscCodeId.id
		}
        finalData.address = address.data;
        finalData.id = formData.contactPersonId;
        finalData.contactName = formData.contactName;
        finalData.designation = formData.designation;
        if (isNullOrEmpty(address.countryRegion)) delete finalData.address.countryRegion;
        delete finalData.address.customData;
        delete finalData.address.addressType;
        if (isNullOrEmpty(finalData.address.pincodeNew)){
        	delete finalData.address.pincodeNew;
        }

        if (this$.validatePhone(formData)) {

            var submitUrl, isUpdate = false;
            var addContactField = refAddContactForm.down('#AddContactId');

            if (addContactField.getSubmitValue() == null || addContactField.getSubmitValue() == "" || addContactField.getSubmitValue() === undefined) {
                submitUrl = SERVERURL.ADD_SPONSORSHIP_CONTACT_CREATE, //URL-rest/sponsorContact
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.UPDATE_SPONSORSHIP_CONTACT, //URL-rest/sponsorContact
                isUpdate = true;
            };

            var methodName = '';
            if (isUpdate == true) {
                methodName = 'PUT';
            } else {
                methodName = 'POST';
            }
            this$.applyWindowMask(); 
           
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: finalData,
                method: methodName,

                success: function(form, action) {
                	 this$.hideWindowMask();
                    this$.cancelContactDetailsForm();
                    grid.getStore().reload();
                    grid.getSelectionModel().deselectAll(true);

                    if (isUpdate) {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('UPDATE_SPONSORSHIP_CONTACT_MSG'));												
                    } else {
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('ADD_SPONSORSHIP_CONTACT_MSG'));												
                    }
                }
            });
        }
    },

    deletContact: function() {
        var grid = this.getContactPersonDetailsGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DELETE_SPONSORSHIP_CONTACT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection()[0];

                    var id = records.data.id;

                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'DELETE',
                        url: SERVERURL.SPONSORSHIP_CONTACT_DELETE + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getCommonTranslation('DELETE_SPONSORSHIP_CONTACT'), getCommonTranslation('SPONSORSHIP_CONTACT_DELETE_SUCCESS'));
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('DELETE_SPONSORSHIP_CONTACT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * Method to clear the contact person grid on load.
     * @author Akshay.Kalbhor
     * @param Reference of the contact person details grid.
     */
    clearContactPersonDetailsGrid: function(grid) {
        if (isNullOrEmpty(grid)) {
            grid = this.getContactPersonDetailsGrid();
        }
        grid.getStore().removeAll();
    },

    /**
     * @method to open the student profile on click of the student Id.
     * @author Akshay.Kalbhor
     */
    openStudentProfile: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var columnIndex = grid.getGridColumns()[cellIndex].dataIndex;
        if (columnIndex == "studentCode") {
            var tabTitle = record.get('studentCode');
            var studentId = record.get('studentId');
            var personId = record.get('userId');
            var programBatchSeatTypeConfigId = record.get('programBatchSeatConfigId');
            this.getController('Academia.controller.personinfo.common.PersonCommonController').
            addContentPanelTab(tabTitle, 'studentprofile', studentId, personId, null, null, programBatchSeatTypeConfigId);
            grid.up('window[xtype=sponsorshipmasterviewsponsoredstudentswindow]').close();
        }
    },
    openSponsorMappingALWindow: function() {
    	var me = this;
    	var grid = me.getSponsorshipmastersearchresultgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		if (records != "" && records != null && records != undefined) {
    			var rec = records[0];
    			var sponsorId = rec.get('sponsorId');
    			if (!isNullOrEmpty(sponsorId)) {
    				var formWindow = me.getSponsoracademylocationmappingwin();
    				if (!formWindow) {
    					Ext.widget('sponsoracademylocationmappingwin');
    					formWindow = me.getSponsoracademylocationmappingwin();
    				}
    				formWindow.show();
    				
    				var gridAcademic = me.getSponsoracademylocationmappinggrid();
    				Ext.apply(gridAcademic,{
    					codeAL:null,
    					setCodeAL : function(codeAL){
    						gridAcademic.codeAL = codeAL;
    					},
    					getCodeAL:function(){
    						return gridAcademic.codeAL;
    					}
    				});
    				gridAcademic.getStore().getProxy().extraParams = {
    					sponsorId:sponsorId
    				};
    				var arrr = [];
    				gridAcademic.getStore().load({
    					callback: function(records, operation, success) {
    						if (success) {
    							if(records.length > 0){
    								if(gridAcademic.getSelectionModel().getCount()>0){
    									gridAcademic.getSelectionModel().deselectAll();
    								}
    								for(i in records){
    									if(records[i].data.isMapped){
    										gridAcademic.getSelectionModel().select(records[i],true);
    										arrr.push(records[i]);
    									}
    								}
    							}		 
    						}
    					}	   
    				});
    				gridAcademic.setCodeAL(arrr);
    			}
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    //************ disableMoreActionPivileges****************  
       disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	buttonsToolBar = gridReference.query('toolbar')[0];
       	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
           		if(!isNullOrEmpty(button)){
           			button.setVisible(true);
           		}        		
           	}
       	});
       },
       mapSponsorAcademyLocations: function(button) {
    	   button.setDisabled(true);
    	   var $this = this;

    	   var grid = $this.getSponsorshipmastersearchresultgrid();
    	   var rec = grid.getSelectionModel().getSelection()[0];
    	   var sponsorId = rec.get('sponsorId');

    	   var acdemylocGrid = $this.getSponsoracademylocationmappinggrid();
    	   var arr=[],datatosave= new Object(); 
    	   if (acdemylocGrid.getSelectionModel().getCount() > 0) {
    		   var records = acdemylocGrid.getSelectionModel().getSelection();
    		   for(var i in records) {
    			   var jsonObj={
    					   "academyLocation": {
    						   "id": records[i].data.academyLocationId
    					   },
    					   "sponsor": {
    						   "id":sponsorId
    					   }
    			   }
    			   arr.push(jsonObj);
    		   }
    	   }else
    	   {
    		   var jsonObj={
    				   "academyLocation": {
    					   "id": 0
    				   },
    				   "sponsor": {
    					   "id":sponsorId
    				   }
    		   }
    		   arr.push(jsonObj);
    	   }

    	   var submitUrl; 
    	   var message;
    	   submitUrl = SERVERURL.PATH_CREATE_MAP_SPONSOR_AL; 
    	   message = getCommonTranslation('SPONSOR_ACADEMY_LOCATIONS_MAP_SUCCESSFULLY');
    	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	   Ext.Ajax.request({
    		   type : 'rest',
    		   url : submitUrl,
    		   jsonData : arr,
    		   method : 'POST',
    		   success : function(frm, action) {
    			   Ext.getBody().unmask();
    			   grid.getStore().reload(); 
    			   $this.getSponsoracademylocationmappingwin().close();  
    			   showSuccessMessage(getCommonTranslation('ACADEMY_LOCATION_MAPPING'), message);

    		   }
    	   });

       },
		deleteQuotation: function() {
        var grid = this.getQuotationdetailsgrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getFeeAndPaymentCommonTranslation('DELETE_QUOTATION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection()[0];
                    var id = records.data.id;

                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'DELETE',
                        url: SERVERURL.PATH_DELETE_QUOTATION_DETAIL + '?id=' + id,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                            grid.getStore().reload();
                            showSuccessMessage(getFeeAndPaymentCommonTranslation('DELETE_QUOTATION'), getFeeAndPaymentCommonTranslation('QUOTATION_DELETE_SUCCESS'));
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getFeeAndPaymentCommonTranslation('DELETE_QUOTATION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    loadDFRForSponsorCompanyDetail:function(form){
    	var $this = this;
    	var sponsorNameInOtherLanguage =  form.down('#sponsorNameInOtherLanguage');
	   	Ext.Ajax.request({
	   		type: 'rest',
	   		async: false,
	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	   		params: {
	   			screenName: 'sponsorcompanydetailswindow',
	   			academyLocationId: this.getCurrentAcademyLocation(),
	   			languageCode:'en'
	   		},
	   		method: 'GET',
	   		success: function(res, action) {
	   			var response = Ext.decode(res.responseText);
	   				var records=response.sponsorcompanydetailswindow;
	   				for(i in records){
	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='sponsorNameInOtherLanguage' && records[i].isVisible==true){
	   						sponsorNameInOtherLanguage.setVisible(true);
	   					}
	   				}
	   		}
	   		
	   	});
    },
		editQuotation: function(controllerRef, isView) {
        var this$$ = this;
        var grid = this$$.getQuotationdetailsgrid();

		if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var id = record.raw.id;
			var contentpanel = this.getContentPanel();
        	 var coursetabstructure = Ext.widget('quotationdetailstructure');
        	 var tabName = getCommonTranslation('QUOTATION_DETAILS');

        	 var getcontroller=this.getController('menu.CoreERPNavigationController');
        	 var getTab=getcontroller.getTab(tabName);
        	 if(getTab!=null){
        		 contentpanel.remove(getTab, true);
        	 }
        	 openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_TEN);
        	 var docGrid = coursetabstructure.down('quotationdetaildocumentgrid');
        	 var docGridDltBtn =docGrid.down('#btnDelete');
        	 var submitBtn = coursetabstructure.down('#submitBtn');
        	 var resetBtn = coursetabstructure.down('#resetBtn')
        	 var quotationDocumentUploadId = coursetabstructure.down('#quotationDocumentUploadId')
        	 docGrid.getStore().removeAll();

            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.PATH_VIEW_QUOTATION_DETAIL,
                method: 'GET',
                params: {
                    id: id
                },
                success: function(res, action) {
                    var data = Ext.decode(res.responseText);
                    var form = coursetabstructure.getForm();
                    docGrid.getStore().add(data.documents);
                    var ids = form.findField('id');
					var quotationCode = form.findField('quotationCode');
					var quotationName = form.findField('quotationName');
					var quotationDate = form.findField('quotationDate');
					var createdBy = form.findField('createdBy');
					var academyLocation = form.findField('academyLocation');
					var approvalStatus = form.findField('approvalStatus');
					var description = form.findField('description');
					ids.setValue(data.id);
					quotationCode.setValue(data.quotationCode);
					quotationName.setValue(data.quotationName);
					quotationDate.setValue(new Date(data.quotationDate));
					description.setValue(data.description);
					academyLocation.getStore().load({
            			callback: function(records, operation, success) {
   						 if (success) {
   							 for(var i in records){
   								   if(records[i].data.id==data.academyLocation.id){
   									academyLocation.setValue(records[i].data.id);
   									break;
   								   }
   							   }
   						 }
   					 }
            		});
            		approvalStatus.getStore().load({
            			callback:function(records, operation, success){
            				for(var i in records){
								   if(records[i].data.id==data.approvalStatus){
									   approvalStatus.setValue(data.approvalStatus);
									break;
								   }
							   }
            			}
            		});
            		createdBy.getStore().load({
            			callback: function(records, operation, success) {
   						
   							 for(var i in records){
   								   if(records[i].data.id==data.createdBy.id){
   									createdBy.setValue(data.createdBy.id);
   									break;
   								   }
   							   }
   						
   					 }
            		});

                    if (isView) {
                    	quotationCode.setReadOnly(true);
    					quotationName.setReadOnly(true);
    					quotationDate.setReadOnly(true);
    					createdBy.setReadOnly(true);
    					academyLocation.setReadOnly(true);
						approvalStatus.setReadOnly(true);
						description.setReadOnly(true);
						docGridDltBtn.setVisible(false);
						quotationDocumentUploadId.setVisible(false);
						resetBtn.setVisible(false);
						submitBtn.setVisible(false);
	
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    getIdValueJson : function(id, value) {
		if (id)
			return {
			id : id,
			value : value
		};
	},
	getDocumentController : function() {
		var this$ = this;
		return this$.getController('Academia.controller.document.DocumentController');
	},
	addSponsorInvoiceCaptureWin:function(formType){
		var $this=this,sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin();
		if (!sponsorInvoiceCaptureWin) {
			Ext.widget('sponsorinvoicecapturewin',{
				formType: formType
			});
			sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin();
		}
		sponsorInvoiceCaptureWin.show();
	},
	setDataOnSponsorInvoiceCaptureWin:function(){
		var win = this.getSponsorinvoicecapturewin(),
		grid = this.getSponsorinvoicegrid(),
		docGrid = this.getSponsorinvoicedocumentgrid(),
		sponsorInvoiceDocGridContainer = win.down('#sponsorInvoiceDocContainer');
		docGridStore = docGrid.getStore(),
		sponsor =  win.down('#sponsorIdName'),
		sponsorStore = sponsor.getStore(),
		academyLocationId = win.down('#academyLocationId'),
		aLStore = academyLocationId.getStore();
		record = grid.getSelectionModel().getSelection()[0];
		win.down('#bill_receivable_payable').setReadOnly(true);
		win.down('#academyLocationId').setReadOnly(true);
		if(record && record.data){
			win.down('#hidden_id').setValue(record.data.id);
			win.down('#sponsorInvoiceId').setValue(record.data.sponsorInvoiceNo);
			win.down('#invoiceDate').setValue(dateRender(record.data.invoiceDate));
			win.down('#bill_receivable_payable').setValue({bill_receivable_payable:record.data.raiseBillCategory}); 
			if(record.data.sponsor){
				sponsorStore.load({
					callback: function(records, operation, success) {
						if (!isNullOrEmpty(record.data.sponsor)) {
							 win.down('#sponsorIdName').setValue(record.data.sponsor.id);
						}
					}
				});
			}
			if(record.data.academyLocation){
				aLStore.load({
					callback: function(records, operation, success) {
						if (!isNullOrEmpty(record.data.academyLocation)) {
							 win.down('#academyLocationId').setValue(record.data.academyLocation.id);
						}
					}
				});
			}
			win.down('#invoiceAmountId').setValue(record.data.invoiceAmount);
			if(!isNullOrEmpty(record.data.totalInvoiceReceivedAmount)){
				if(record.data.totalInvoiceReceivedAmount==0){
					win.down('#invoiceAmountId').setMinValue(1);
				}else{
					win.down('#invoiceAmountId').setMinValue(record.data.totalInvoiceReceivedAmount);
				}
			}
			win.down('#isInvoiceSentToSponsorId').setValue(record.data.isInvoiceSent);
			
			docGridStore.getProxy().extraParams = {
        		sponsorInvoiceId: record.data.id
			};
        	docGridStore.load({
				callback:function(records, operation, success) {
					if(docGridStore.getCount()) {
						if (sponsorInvoiceDocGridContainer.isHidden()) {
							//docGrid.setVisible(true);
							sponsorInvoiceDocGridContainer.setVisible(true);
							Ext.defer(function() {
							    win.center();
							}, 100);
						}
					}					
				}
			});
		}
	},
	disableGridButtonsPivileges:function(grid,permissionMap){
		var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		
		var updateAmtReceivedBtn = grid.down('#updateAmountReceived');
		updateAmtReceivedBtn.setVisible(false);
		
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'UPDATE_AMOUNT_RECEIVED') {
        		if(!isNullOrEmpty(updateAmtReceivedBtn)){
        			updateAmtReceivedBtn.setVisible(true);
        		}        		
        	}
    	});
	},
	uploadSponsorInvoiceDocuments:function(){
		var entityId,$this = this,
		isTransient = true,
		module = 'sponsorInvoice',
		entityType = 'sponsorInvoiceDocument',
		sponsorinvoicecapturewin = $this.getSponsorinvoicecapturewin(),
		sponsorInvoiceDocumentGrid = $this.getSponsorinvoicedocumentgrid(),
		sponsorInvoiceDocGridContainer = sponsorinvoicecapturewin.down('#sponsorInvoiceDocContainer');
		store = sponsorInvoiceDocumentGrid.getStore();
		if(store.data.items.length >= 10){
			$this.getDocumentController().closeDocumentFormWindow();
			return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MAX_DOC_ALERT'));
		}
		$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',function(success,response,isCallBackTransient) {
			var documentModel = new Academia.model.personinfo.common.disciplinaryactivity.DisciplinaryActionDocumentModel();
			documentModel.set("name",response.name);
			documentModel.set("path", response.path);
			documentModel.set("type",response.type);
			documentModel.set("documentName",response.name);
			documentModel.set("createdBy",
					$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
			if(!sponsorInvoiceDocumentGrid) {
				sponsorInvoiceDocumentGrid = Ext.widget('sponsorinvoicedocumentgrid');
			}
			store.add(documentModel);
			if (sponsorInvoiceDocGridContainer.isHidden() && store.data.items.length > 0) {
				//sponsorInvoiceDocumentGrid.setVisible(true);
				sponsorInvoiceDocGridContainer.setVisible(true);
				Ext.defer(function() {
					sponsorinvoicecapturewin.center();
				}, 100);
			}
			$this.getDocumentController().closeDocumentFormWindow();
			showSuccessMessage(getCommonTranslation('SPONSOR_INVOICE'),getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));
		}, isTransient);
	},
	saveSponsorInvoiceDetails:function(btn){
		if (typeof btn.lastExecutionTime === 'undefined') {
			btn.lastExecutionTime = 0;
		}

		var currentTime = new Date().getTime();

		// Prevent function execution if called within the last 5+ seconds
		if (currentTime - btn.lastExecutionTime < 5000) {
			console.log('Function call skipped to prevent duplicate execution');
			return false;
		}

		// Update last execution time
		btn.lastExecutionTime = currentTime;

		var successMsg,submitUrl,jsonFormatFormData={},sponsorIdName,sponsor,uploadInvoicePath,uplaodUrl,this$ = this,academyLocation,
		grid = this.getSponsorinvoicegrid(),
		filter = this.getSponsorinvoicefilter(),
		searchBtn = filter.down('#searchBtn'),
		sponsorInvoiceCaptureWin = this.getSponsorinvoicecapturewin(),
		form = sponsorInvoiceCaptureWin.down('form').getForm(),
		formValue = sponsorInvoiceCaptureWin.down('form').getValues(),
		id = sponsorInvoiceCaptureWin.down('#hidden_id');
		
		sponsorIdName={
			"id":	formValue.sponsorIdName
		};
		academyLocation={
			"id":	formValue.academyLocation
		};
		if(isNullOrEmpty(id.getValue())){
			submitUrl=SERVERURL.PATH_SPONSOR_INVOICE_SAVE;
			jsonFormatFormData.sponsorInvoiceNo=formValue.sponsorInvoiceCode;
			jsonFormatFormData.invoiceDate=formValue.invoiceDate;
			jsonFormatFormData.sponsor=sponsorIdName;
			jsonFormatFormData.academyLocation = academyLocation;
			jsonFormatFormData.raiseBillCategory = formValue.bill_receivable_payable;
			successMsg=getCommonTranslation('RECORD_ADD_SUCCESS');
		}else{
			submitUrl=SERVERURL.PATH_SPONSOR_INVOICE_DOCUMENT_SAVE;
			jsonFormatFormData = this$.getJsonSponsorDocData(form);
			sponsor = {
                    "id":jsonFormatFormData.sponsorIdName
            };
            jsonFormatFormData.sponsor=sponsor;
            jsonFormatFormData.sponsorInvoiceNo=jsonFormatFormData.sponsorInvoiceCode;
            jsonFormatFormData.isInvoiceSent = jsonFormatFormData.isInvoiceSentToSponsor?(jsonFormatFormData.isInvoiceSentToSponsor):false;
            jsonFormatFormData.academyLocation = academyLocation;
			jsonFormatFormData.raiseBillCategory = formValue.bill_receivable_payable;
			jsonFormatFormData.recordIdToBeDeleted = this$.sponsorDocIdsToBeDeleted;
            delete jsonFormatFormData.sponsorIdName;
            delete jsonFormatFormData.sponsorInvoiceCode;
            delete jsonFormatFormData.isInvoiceSentToSponsor;
            delete jsonFormatFormData.bill_receivable_payable;
			if(jsonFormatFormData && jsonFormatFormData.documents && jsonFormatFormData.documents.length==0){
				return showWarningMessage(getCommonTranslation('ALERT'),getDocumentTranslation('PLEASE_UPLOAD_DOCUMENT'));
			}
			successMsg=getCommonTranslation('RECORD_UPDATE_SUCCESS');
		}
		this$.applyWindowMask(); 
		var jsonFormatSubmittData = Ext.encode(jsonFormatFormData);
		this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatSubmittData, function(option, success, response) {
			this$.hideWindowMask();
			if(success){
				var resp = response.responseText;
				if(resp=="0"){
					return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_INVOICE_NUMBER'));
				}
				if(resp=="-2"){
					return showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('DATA_SETTING_MISSING'));
				}
			    sponsorInvoiceCaptureWin.close();
				//grid.getStore().reload();
			    searchBtn.fireEvent("click",searchBtn);
				grid.getSelectionModel().deselectAll();
				showSuccessMessage(getCommonTranslation('SPONSOR_INVOICE'), successMsg);
			}else{
				this$.hideWindowMask();
				sponsorInvoiceCaptureWin.close();
			}
			this$.sponsorDocIdsToBeDeleted=[];
		});
	},
	deleteSponsorInvoiceDocs:function(){
		var $this=this,grid = this.getSponsorinvoicedocumentgrid(),
		sponsorGrid =  this.getSponsorinvoicegrid();
		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getCommonTranslation('SPONSOR_INVOICE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn, text) {
						if (btn == 'yes') {
							var store = grid.getStore();
							var record = grid.getSelectionModel().getSelection()[0];
							var id = record.get("documentIdCount");
							if (!isNullOrEmpty(id)) {
								$this.sponsorDocIdsToBeDeleted.push(id);
							}
							if (record) {
								store.remove(record);
								showSuccessMessage(getCommonTranslation('SPONSOR_INVOICE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
							}
						}
					});
		}
	},
	getSponsorDocDownloadFile : function(documentId){
		if(!isNullOrEmpty(documentId)){
			var $this = this;
			$this.getDocumentController().downloadDocumentFile(documentId);
		}
	},
	documentDownloadDocumentZip : function() {
		var $this = this;
		var win = $this.getSponsorinvoicedocumentlistwin();
		var docGrid=win.down('#docListGridId');
		if (docGrid.getSelectionModel().getCount() > 0) {
			var records = docGrid.getSelectionModel().getSelection();
			var dispatchZipName = "sponsor Invoice Document";
			var saveModel=[];  
			for(var i in records){
				if(!isNullOrEmpty(records[i].get('path'))) {
					saveModel.push(records[i].get('path'));
				}
				showConfirmMessage(getCommonTranslation('SPONSOR_INVOICE'),getFileManagementTranslation('DOWNLOAD_ALL_DOCUMENT_MSG'),function(btn, text) {
					if (btn == 'yes') {
						var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
						$this.getController('Academia.controller.document.DocumentController').downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
					}
				});
			}
		}else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	getJsonSponsorDocData: function(form) {
		var this$ = this,
		jsonFormFieldData = new Object(),
		formData = form.getValues();
		if (!isEmpty(formData)) {
			var docStore = this$.getStore('sponsorship.invoice.SponsorInvoiceDocumentStore');
			var docArray = [];
			if (docStore.data.items != null && docStore.data.items.length > 0) {
				Ext.each(docStore.data.items, function(val) {
					var newData = {
							"name" : val.data.name,
							"path" : val.data.path,
							"type" : val.data.type,
							"id" : val.data.id,
							"createdBy" : this$.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
					};
					docArray.push(newData);
				});
			}
		}
		formData.documents = docArray;
		jsonFormFieldData = formData;
		return jsonFormFieldData;
	},
	getUpdatedAmountReceivedData: function(serialNo) {
		var $this = this,
		updateAmountWin = $this.getSponsorinvoiceupdateamountreceivedwin(),
		updateAmountGrid = updateAmountWin.down('#UpdateAmountReceivedGridId'),
		grid = this.getSponsorinvoicegrid(),
		updateAmtGridStore = updateAmountGrid.getStore(),
		sponsorInvoiceRecord = grid.getSelectionModel().getSelection()[0],
		sponsorInvoiceId = sponsorInvoiceRecord.get("id");
		updateAmountGrid.down('#btnAdd').setVisible(true);
		updateAmtGridStore.removeAll();
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_SPONSOR_INVOICE_RECEIVED_AMOUNT_GRID_DATA,
			method: 'GET',
			params:{
				sponsorInvoiceId:sponsorInvoiceId
			},
			success: function(response, action) {
				var responseData = Ext.decode(response.responseText);
				var listOfAmount = responseData;
				if(!isNullOrEmpty(listOfAmount) && listOfAmount.length>0){
					var ObjModel = [];
					var count = 1; 
					listOfAmount.forEach(function(obj){
						var sponsorUpdateAmtReceivedModel = new Academia.model.sponsorship.SponsorUpdateAmtReceivedModel();
						sponsorUpdateAmtReceivedModel.set("serialNo", count);
						sponsorUpdateAmtReceivedModel.set("id", obj.id);
						sponsorUpdateAmtReceivedModel.set("receivedDate", obj.receivedDate);
						sponsorUpdateAmtReceivedModel.set("receivedAmount", obj.receivedAmount);
						sponsorUpdateAmtReceivedModel.set("preFilledReceivedDate", obj.preFilledReceivedDate);
						sponsorUpdateAmtReceivedModel.set("isAddDeleteRow", true);
						sponsorUpdateAmtReceivedModel.commit();
						ObjModel.push(sponsorUpdateAmtReceivedModel);
						count = count+1;
					});
					updateAmountGrid.getStore().loadRawData(ObjModel, true);
					updateAmountGrid.down('#btnAdd').setVisible(false);
				}else {
					updateAmountGrid.getStore().removeAll();
					updateAmountGrid.down('#btnAdd').setVisible(true);
				}
				Ext.getBody().unmask();
			}
		});
	},
	addNewRowInUpdateAmountReceivedGrid: function(serialNo) {
        var $this = this,totalRecordDisplayField,
        updateAmountWin = $this.getSponsorinvoiceupdateamountreceivedwin(),
        grid = updateAmountWin.down('#UpdateAmountReceivedGridId'),
        ObjModel = [],
        sponsorUpdateAmtReceivedModel = new Academia.model.sponsorship.SponsorUpdateAmtReceivedModel();
        sponsorUpdateAmtReceivedModel.set("serialNo", serialNo);
        sponsorUpdateAmtReceivedModel.set("receivedDate", '');
        sponsorUpdateAmtReceivedModel.set("receivedAmount", '');
        sponsorUpdateAmtReceivedModel.set("isAddDeleteRow", true);
        ObjModel.push(sponsorUpdateAmtReceivedModel);
        grid.getStore().loadRawData(ObjModel, true);
        Ext.defer(function() {
        	updateAmountWin.center();
		}, 100);
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        }
        totalRecordDisplayField=grid.down('#totalRecordDisplayField');
		totalRecordDisplayField.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+grid.getStore().getCount())
    },
    addDeleteRowToUpdateAmountReceived: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var $this = this,
        updateAmountWin = $this.getSponsorinvoiceupdateamountreceivedwin(),
        grid = updateAmountWin.down('#UpdateAmountReceivedGridId'),
        columnName = grid.columnManager.columns[cellIndex].dataIndex;

        if (e.target.tagName == 'DIV') {
        	if (columnName == "addButton") {
        		if (e.target.className == "addButtonClsForGridActionCls") {
        			if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
        				var serialNo;
        				if (grid.getStore() != null)
        					serialNo = grid.getStore().getCount();
        				this.addNewRowInUpdateAmountReceivedGrid(serialNo + 1);
        			}
        		}
        	} else if (columnName == "deleteButton") {
        		if (e.target.className == "deleteButtonClsForGridActionCls") {
        			if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
        				if (grid.getStore().getRange().length > 0) {
        					var id = record.get('id');
        					showConfirmMessage(getCommonTranslation('SPONSOR_INVOICE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
        						if (btn == 'yes') {
        							if(!isNullOrEmpty(id)){
        								$this.sponsorAmtIdsToBeDeleted.push(id);
        							}
        							grid.getStore().removeAt(rowIndex);
        							var models = grid.getStore().getRange();
        							for (var i = 0; i < models.length; i++) {
        								models[i].data.serialNo = i + 1;
        							}
        							grid.getStore().loadRawData(models, true);
        							if(models.length == 0){
        								grid.down('#btnAdd').show();
        							}
        							showSuccessMessage(getCommonTranslation('SPONSOR_INVOICE'),getCommonTranslation('RECORD_DELETE_SUCCESS'));
        						}
        					});
        				}
        			}
        		}
        	}
        }
    },
    saveUpdateAmountReceivedGridData:function(){
    	var this$ = this,jsonData=[],isEmptyRecord=false,receivedDate,
        updateAmountWin = this$.getSponsorinvoiceupdateamountreceivedwin(),
        grid = this.getSponsorinvoicegrid(),
        updateAmtGrid = updateAmountWin.down('#UpdateAmountReceivedGridId'),
        updateAmtGridStore = updateAmtGrid.getStore(),
        sponsorInvoiceRecord = grid.getSelectionModel().getSelection()[0],
		sponsorInvoiceId = sponsorInvoiceRecord.get("id"),
        submitUrl=SERVERURL.PATH_SPONSOR_INVOICE_RECEIVED_AMOUNT_SAVE;
    	
    	if(updateAmtGridStore.getCount()>0){
    		updateAmtGridStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.receivedDate) || isNullOrEmpty(obj.data.receivedAmount)) {
    				isEmptyRecord=true;
    				return false;
    			}else{
    				if(isNullOrEmpty(obj.data.id)){
    					receivedDate = Ext.Date.format(obj.data.receivedDate, 'Y-m-d')
    				}else{
    					receivedDate = Ext.Date.format(new Date(obj.data.receivedDate), 'Y-m-d')
    				}
    				var jsonObj = {
    						"id":obj.data.id,
        					"sponsorInvoiceId":sponsorInvoiceId,
        					"receivedDate":receivedDate,
        					"receivedAmount":obj.data.receivedAmount,
        					"recordIdToBeDeleted":this$.sponsorAmtIdsToBeDeleted
        			}
    				jsonData.push(jsonObj);
    				return true;
    			}
    		});
    	}else{
    		var jsonObj = {
    			"id":null,
    			"sponsorInvoiceId":sponsorInvoiceId,
    			"receivedDate":new Date(),
    			"receivedAmount":0.00,
    			"recordIdToBeDeleted":this$.sponsorAmtIdsToBeDeleted,
    			"isRecordToBeDeleted":true
			}
			jsonData.push(jsonObj);
    	}
    	if(isEmptyRecord){
    		showWarningMessage(getCommonTranslation('SPONSOR_INVOICE'), getCommonTranslation('PLEASE_FILL_DATA'));
    	}else{
    		this$.applyWindowMask(); 
    		var jsonFormatSubmittData = Ext.encode(jsonData);
    		this.sendSaveAjaxRequest(submitUrl, 'POST', jsonFormatSubmittData, function(option, success, response) {
    			if(success){
    				var resp = response.responseText;
    				if(resp=="-1"){
    					this$.hideWindowMask();
    					return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('AMOUNT_VALIDATION'));
    				}
    				showSuccessMessage(getCommonTranslation('SPONSOR_INVOICE'), getCommonTranslation('AMOUNT_UPDATED_SUCCESSFULLY'));
    			}
    			this$.sponsorAmtIdsToBeDeleted=[];
    			updateAmountWin.close();
    			grid.getStore().reload();
    			grid.getSelectionModel().deselectAll();
    			this$.hideWindowMask();
    		});
    	}
    }

});
