/**
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.student.bulkUploadDocumentAndNotes.BulkUploadDocumentAndNotesController', {
    extend: 'Academia.controller.base.BaseController',
    stores: [
        'student.studentprofile.AcademicTopicUserIdStore',
        'student.studentprofile.AcademicSubTopicStore',
        'examCenter.AssignSequence.Program',
        'examinationcenters.reports.ExaminationResultBatchStore',
        'examinationcenters.manageEvaluation.evaluationgroup.studentPeriodExaminationTableStore',
        'examinationcenters.manageEvaluation.evaluationgroup.AcademicTermByBatchStore',
        'student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGridStore'
    ],
    views: [
        'student.bulkUploadDocumentAndNotes.StudentBulkAcademicTopicAndNotesStructure',
        'student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesForm',
        'student.bulkUploadDocumentAndNotes.BulkAcademicTopicDocumentGrid',
        'student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGrid'
    ],
    config: {},
    refs: [{
        ref: 'bulkUploadDocAndNotesForm',
        selector: 'bulkUploadDocAndNotesForm'
    }, {
        ref: 'documentformwindow',
        selector: 'documentformwindow'
    }, {
        ref: 'bulkAcademicTopicDocumentGrid',
        selector: 'bulkAcademicTopicDocumentGrid'
    }, {
        ref: 'bulkUploadDocAndNotesGrid',
        selector: 'bulkUploadDocAndNotesGrid'
    }],
    config: {},

    init: function (application) {
        this.control({
            'bulkUploadDocAndNotesForm customcombobox[itemId=academicTopicItemIdBulkUpload]': {
                afterrender: this.onAcademicTopicComboRender,
                select: this.onAcademicTopicSelect
            },
            'bulkUploadDocAndNotesForm customcombobox[itemId=programItemIdBulkUpload]': {
                render: this.onProgramComboRender,
                select: this.onProgramSelect
            },
            /*'bulkUploadDocAndNotesForm customcombobox[itemId=batchComboBulkUpload]': {
                select: this.onBatchSelect
            },*/
            'bulkUploadDocAndNotesForm customcombobox[itemId=academicTermIdBulkUpload]': {
                select: this.onAcademicTermSelect
            },
            'bulkUploadDocAndNotesForm customcombobox[itemId=periodIdBulkUpload]': {
                select: this.onPeriodSelect
            },
            'bulkUploadDocAndNotesForm button[itemId=resetButtonId]': {
                click: this.resetBulkUploadForm
            },
            'bulkUploadDocAndNotesForm button[itemId=academicTopicDocumentBulkUpload]': {
                click: this.showUploadWindow
            },
            'documentformwindow[itemId=academicTopicBulkUploadFormItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId': {
                click: this.doUploadZipFile
            },
            'bulkAcademicTopicDocumentGrid button[itemId=btnDelete]': {
                click: this.deleteTempDoc
            },
            'bulkUploadDocAndNotesForm button[itemId=submitButtonId]': {
                click: this.saveBulkDocument,
                afterrender: this.onSaveBtnRender
            },
            'bulkUploadDocAndNotesForm button[itemId=searchButtonId]': {
                click: this.searchBulkDocument
            },
            'bulkAcademicTopicDocumentGrid': {
                show: this.onTempDocumentGridShow,
                hide: this.onTempDocumentGridHide
            },
            'bulkUploadDocAndNotesGrid': {
            	cellclick: this.docAndNotesGridCellClick,
            	afterrender: function(grid){
            		var me = this;
            		var refreshBtn = grid.down('#btnRefresh');
            		refreshBtn.setDisabled(true);
            		grid.getStore().on('load', function(){
            			refreshBtn.setDisabled(false);
            		});
            	}
            }
        });
    },

    onAcademicTopicComboRender: function (academicTopic, records, eOpts) {
        var user = this.getCurrentlyLoggedInUser();
        var academicTopicStore = academicTopic.getStore();
        academicTopicStore.proxy.extraParams = {
            userId: user.id
        };
        academicTopicStore.load();
    },

    onAcademicTopicSelect: function (academicTopic, records, eOpts) {
        var form = academicTopic.up('form');
        var academicSubTopic = form.down('#academicSubTopicItemIdBulkUpload');
        academicSubTopic.setDisabled(false);
        var academicSubTopicValue = academicTopic.getValue();

        var code = records[0].raw.code;
        var periodField = form.down('#periodIdBulkUpload');
        periodField.setVisible(true);
        this.setAllowBlank(periodField, false);
        if (code == 'PRE_ENROLLED_PERIOD_DOCUMENTS') {
            periodField.setVisible(false);
            this.setAllowBlank(periodField, true);
        }
        this.loadAcademicTopicDependentCombo(academicSubTopic, academicSubTopicValue, 'academicTopicId');
    },

    onProgramComboRender: function (obj) {
        var $this = this;
        var form = obj.up('form').getForm();
        var academyLocationId = $this.getCurrentAcademyLocation();
        var programId = form.findField('programId');
        var programIdStore = obj.getStore();
        programIdStore.proxy.extraParams = {
            academyLocationIds: academyLocationId
        };
        programIdStore.load({
            callback: function (record) {
                if (record && record.length == 1) {
                    obj.setValue(record[0].data.id);
                    obj.setReadOnly(true);
                    var batchCombo = form.findField('batch');
                    batchCombo.enable();
                    batchCombo.getStore().getProxy().extraParams = {
                        programId: record[0].get('id')
                    };
                    batchCombo.store.load({
                        callback: function (records, operation, success) {
                            if (success) {
                                if (records && records.length == 1) {
                                    batchCombo.setValue(records[0].data.id);
                                    batchCombo.setDisabled(false);
                                    batchCombo.setReadOnly(true);
                                    var periodCombo = form.findField('period');
                                    periodCombo.enable();
                                    var programId = form.findField('programId');
                                    periodCombo.getStore().getProxy().extraParams = {
                                        programId: obj.getValue(),
                                        batchId: records[0].get('id')
                                    };
                                    periodCombo.store.load({
                                        callback: function (records, operation, success) {
                                            if (success) {
                                                if (records && records.length == 1) {
                                                    periodCombo.setValue(records[0].get('id'));
                                                    periodCombo.setReadOnly(true);
                                                }
                                                /*else{
    												var grid = $this.getAcademicstopicquicksearchgrid();
    												if(grid.buttonName == 'ADD_VIEW') {
    													periodCombo.setReadOnly(false);
    												}
    											}*/
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            }
        });
    },

    resetBulkUploadForm: function (btn) {
        var form = btn.up('form');
        form.getForm().reset();
        form.down('#academicSubTopicItemIdBulkUpload').disable();
        form.down('#batchComboBulkUpload').disable();
        form.down('#periodIdBulkUpload').disable();
        var grid = this.getBulkAcademicTopicDocumentGrid();
        var store = grid.getStore();
        store.removeAll();
        grid.hide();
        this.getBulkUploadDocAndNotesForm().down('#academicTopicDocumentBulkUpload').enable();
    },

    showUploadWindow: function (btn) {
        this.getDocumentController().showDocumentFormWindow("academicTopicBulkUploadFormItemId", "DOCUMENT");
        var win = this.getDocumentformwindow();
        var docNameFld = win.down('#documentNameField');
        docNameFld.disable();
        docNameFld.hide();
        docFileField = win.down('#uploadFileField');
        docFileField.disable();
        docFileField.hide();
        win.down('simpledocumentform').insert(7, {
            xtype: 'filefield',
            ui: 'CustomBtnSubmit',
            fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
            buttonText: getPersonModuleTranslation('UPLOAD'),
            itemId: 'uploadFileFieldZ',
            name: 'file',
            allowBlank: false,
            validateOnChange: true,
            listeners: {
                change: function (fileField, value) {
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if (!isNullOrEmpty(extension) && extension.toLowerCase() == 'zip') {
                            var file = fileField.fileInputEl.dom.files[0];
                            var fileSizeLimit = '500';
                            if (file.size / 1048576 > fileSizeLimit) {
                                fileField.reset();
                                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_SIZE_CAN_NOT_MORETHAN_500'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getCommonTranslation('BDU_UPLOAD_ZIP_FILE'), getCommonTranslation('BDU_PLEASE_UPLOAD_ZIP_FILE'));
                        }
                    }
                }
            }
        });
    },

    getDocumentController: function () {
        return this.getController("Academia.controller.document.DocumentController");
    },

    loadAcademicTopicDependentCombo: function (dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
        var this$ = this;
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        dependentCombo.reset();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if (id != null) {
            var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.load();
        }
    },

    onProgramSelect: function (cmp, record) {
        var form = cmp.up('form');
        var batch = form.down('#batchComboBulkUpload');
        var period = form.down('#periodIdBulkUpload');
        period.clearValue();
        period.store.removeAll();
        period.reset();
        batch.setDisabled(false);
        var comboValue = cmp.getValue();
        var academyLocationId = this.getCurrentAcademyLocation();
        this.loadAcademicTopicDependentCombo(batch, comboValue, 'programId');
    },

    onBatchSelect: function (cmp, record) {
        var form = cmp.up('form');
        var periodCombo = form.down('#periodIdBulkUpload');
        periodCombo.reset();
        periodCombo.enable();
        var periodStore = periodCombo.getStore();
        periodStore.getProxy().extraParams = {
            id: record[0].get('id')
        };
        periodStore.load();
    },
    
    onAcademicTermSelect: function (cmp, record) {
        var form = cmp.up('form');
        var periodCombo = form.down('#periodIdBulkUpload');
        periodCombo.reset();
        periodCombo.enable();
        var periodStore = periodCombo.getStore();
        periodStore.getProxy().extraParams = {
        	academicTermId: record[0].get('id'),
        	programId: form.getValues().programId
        };
        periodStore.load();
    },
    
    onPeriodSelect: function (cmp, record) {
        var form = cmp.up('form');
        var batchCombo = form.down('#batchComboBulkUpload');
        batchCombo.reset();
        batchCombo.enable();
        if(batchCombo.getStore().getCount()) {
        	batchCombo.setValue(record[0].get('secondId'));
        }
        else {
        	batchCombo.getStore().load({
        		callback: function() {
        			batchCombo.setValue(record[0].get('secondId'));
        		}
        	});
        }
    },

    doUploadZipFile: function (btn) {
        var $this = this;
        var docAddEditWin = btn.up('documentformwindow');
        var id = '';
        if (docAddEditWin.down('hiddenfield[name=documentId]')) {
            id = docAddEditWin.down('hiddenfield[name=documentId]').getValue();
        }
        var isTransient = true;
        var module = 'examination';
        var entityId;
        var entityType = 'bulkAcademicTopic';
        var windows = Ext.ComponentQuery.query('#academicTopicBulkUploadFormItemId')[0];
        var fileField = windows.down('#uploadFileFieldZ');
        var fileRawValue = fileField.getRawValue();
        var extension = fileRawValue.substring(fileRawValue.lastIndexOf('.'));
        var fileName = fileRawValue.split(extension)[0];
        $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT',
            function (success, response, isCallBackTransient) {
                var documentModel = new Academia.model.course.QuestionPaperDocument();
                documentModel.set("documentName", fileName);
                documentModel.set("path", response.path);
                documentModel.set("type", response.type);
                documentModel.set("isEdit", false);
                documentModel.set("isNewRecord", true);
                var documentGrid = $this.getBulkAcademicTopicDocumentGrid();
                documentGrid.getHeader().hide();
                var store = documentGrid.getStore();
                store.add(documentModel);
                $this.getBulkUploadDocAndNotesForm().down('#academicTopicDocumentBulkUpload').disable();
                $this.getDocumentController().closeDocumentFormWindow();
                documentGrid.setVisible(true);
                showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'), getCommonTranslation('DOCUMENT_ADDED_SUCCESSFULLY'));
            }, isTransient);
    },

    deleteTempDoc: function () {
        var $this = this;
        var grid = $this.getBulkAcademicTopicDocumentGrid();
        var sm = grid.getSelectionModel();
        var store = grid.getStore();
        if (sm.getCount() > 0) {
            showConfirmMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
                function (btn, text) {
                    if (btn == 'yes') {
                        var records = sm.getSelection();
                        store.remove(records[0]);
                        showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
                        if (store.getCount() == 0) {
                            grid.hide();
                            $this.getBulkUploadDocAndNotesForm().down('#academicTopicDocumentBulkUpload').enable();
                        }
                    }
                });
        } else {
            showWarningMessage(getCommonTranslation('DOCMENT_NAME'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    saveBulkDocument: function (btn) {
        var this$ = this;
        var form = this$.getBulkUploadDocAndNotesForm();
        var formVals = form.getValues();
        var submitBtn = form.down("#submitButtonId");
        if (submitBtn) {
            submitBtn.disable();
        }
        var submitUrl = SERVERURL.PATH_SAVE_BULK_ACADEMIC_DOC;
        var isUpdate = false;
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        var values = form.getForm().getValues();

        data = {
            "academicTopicsId": formVals.academicTopicId,
            "academicSubTopicsId": formVals.academicSubTopicId,
            "programId": formVals.programId,
            "batchId": formVals.batch,
            "periodId": formVals.period,
            "academicTermId": formVals.academicTerm,
            "isUploadDocument": true,
            "createdBy": userId,
            "updatedBy": userId,
            "updatedAt": new Date(),
            "createdAt": new Date(),
            "status": formVals.status,
            "isPublished": formVals.isPublished,
            "publishOnStudentPortal": formVals.isPublished
        };

        var docArray;
        var documentGrid = this.getBulkAcademicTopicDocumentGrid();
        var docStore = documentGrid.getStore();
        var docItems = docStore.data.items;
        var isUploadFlag = false;
        if (docStore.getCount()) {
            isUploadFlag = true;
        }
        if (docItems != null && docItems.length > 0 && (documentGrid.isVisible() == true)) {
            Ext.each(docItems, function (val) {
                var newData = {
                    "id": val.data.id,
                    "name": val.data.documentName ? val.data.documentName : val.data.name,
                    "path": val.data.path,
                    "type": "DOCUMENT",
                    "isEdit": false
                };
                docArray = newData;
            });
        }
        data.documents = docArray;

        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.timeout = 90000;
		this.sendSaveAjaxRequest(submitUrl, 'POST', data, function(option, success, response) {
			Ext.getBody().unmask();
			if (success) {
				if (response.responseText == "true") {
					showSuccessMessage(getPersonModuleTranslation('ACADEMICS_TOPIC'), getPersonModuleTranslation('ACADEMIC_TOPIC_ADD_SUCCESS'));
					this$.searchBulkDocument();
					setTimeout(function() {
						if (submitBtn) {
							submitBtn.enable();
							docStore.remove(docStore.getAt(0));
							if (docStore.getCount() == 0) {
								documentGrid.hide();
								form.down('#academicTopicDocumentBulkUpload').enable();
							}
						}
					}, 500);
				}
			} else {
				submitBtn.enable();
			}
			Ext.Ajax.timeout = 300000;
		});
    },

    getJsonSubmitData: function (form) {
        var this$ = this;
        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },

    searchBulkDocument: function (btn) {
    	var form = this.getBulkUploadDocAndNotesForm();
        var formVals = form.getValues();
        var grid = this.getBulkUploadDocAndNotesGrid();
        var store = grid.getStore();
        store.getProxy().extraParams = {
        	academicTopicId: formVals.academicTopicId,
        	academicSubTopicId: formVals.academicSubTopicId,
        	programId: formVals.programId,
        	batchId: formVals.batch,
        	periodId: formVals.period,
        	academicTermId: formVals.academicTerm,
            status: formVals.status,
            publishOnStudentPortal: formVals.isPublished
        };
        store.load();
    },

    docAndNotesGridCellClick: function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        if (e.target.tagName == 'A') {
            var documentPath = null;
            if (cellIndex == 6) {
            	documentPath = record.get("uploadedZipFilePath");
            }
            else if (cellIndex == 7) {
            	documentPath = record.get("logFilePath");
            }
            if (!isNullOrEmpty(documentPath)) {
            	var csvForm = Ext.create('Ext.form.Panel');
            	csvForm.getForm().submit({
            		target: '_blank',
            		method: 'POST',
            		params: {
            			access_token: Ext.Ajax.defaultHeaders.access_token
            		},
            		headers: {
            			'Authorization': Ext.Ajax.defaultHeaders.Authorization
            		},
            		url: SERVERURL.PATH_FILE_DOWNLOAD_API + '?path=' + documentPath.replace(/\\/g, "/"),
            		standardSubmit: true
            	});
            }
        }
    },
    
    onSaveBtnRender: function(btn) {
    	btn.on('enable', this.onSaveBtnEnable, this);
    },
    
    onSaveBtnEnable: function(btn) {
    	if(!this.getBulkAcademicTopicDocumentGrid().isVisible()) {
    		Ext.defer(function() {
    			btn.disable();
    		}, 1);
    	}
    	else {
    		if(this.getBulkUploadDocAndNotesForm().isValid()) {
    			btn.un('enable', this.onSaveBtnEnable, this);
    			btn.enable();
    			btn.on('enable', this.onSaveBtnEnable, this);
    		}
    	}
    },
    
    onTempDocumentGridShow: function() {
    	var form = this.getBulkUploadDocAndNotesForm();
    	var btn = form.down('#submitButtonId');
    	if(form.isValid()) {
    		btn.un('enable', this.onSaveBtnEnable, this);
    		btn.enable();
    		btn.on('enable', this.onSaveBtnEnable, this);
    	}
    },
    
    onTempDocumentGridHide: function() {
    	var form = this.getBulkUploadDocAndNotesForm();
    	var btn = form.down('#submitButtonId');
    	btn.disable();
    }
});