/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.controller.student.demographicReport.StudentDemographicReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['common.ReligionStore','common.IntakeYearStore','common.AcademicTermStore','common.ProgramForBillStore',
	         'program.ProgramGroupStore','program.ProgramCategoryStore','enquiry.AcademicBatchStore','organization.CityByCountryRegion',
	         'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','organization.CountryRegionStore',
	         'common.CastCategoryStore','common.CountryStore','student.report.StudentDemographicReportStore',
	         'student.report.StdDemographicReportGridStore','enquiry.studentDetail.GenderStore','coursetransaction.sectionmanagement.CourseSectionCombo',
	         'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore','common.GenderTypeStore'],
	         views: ['student.demographicReport.StudentDemographicsReportTabStructure',
	                 'student.demographicReport.StudentDemographicsReportStructure','student.demographicReport.StudentDemographicsReportGrid',
	                 'student.demographicReport.StudentDemographicsReportFilter','student.demographicReport.StudentDemographicReportWin'],
	                 config : {
	                	 STUDENT_DEMOGRAPHIC_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
	                	 .getFeaturePrivilegesMap('STUDENT_DEMOGRAPHIC_REPORT_PRIVILEDGE')
	                 },
	                 refs: [{
	                	 ref: 'studentdemographicsreportfilter',
	                	 selector: 'studentdemographicsreportfilter'
	                 },{
	                	 ref: 'StudentDemographicsReportGrid',
	                	 selector: 'contentpanel'
	                 },{
	                	 ref: 'studentdemographicsreportgrid',
	                	 selector: 'studentdemographicsreportgrid'
	                 },{
	             		ref: 'studentdemographicreportwin',
	            		selector: 'studentdemographicreportwin[itemId=studentdemographicreportwinId]'
	            	}],
	            	
	                 init: function(application) {
	                	 this.control({
	                		 'studentdemographicsreportfilter combo#programGroup': {
	                			 select: function(obj, record){
	                				 var programGroupId = record[0].get("id");
	        	                	 var form = obj.up('form');
	        	                	 var programId = form.down('#programId');
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	        	                	 programId.reset();
	        	                	 if(programGroupId > 0){
	        	                		 var store = programId.getStore();
	        	                		 store.getProxy().extraParams = {
	        	                			 programGroupId : programGroupId,
	        	                			 academyLocationIds : academyLocationId
	        	                		 };
	        	                		 store.load();
	        	                	 }
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#programCategory': {
	                			 select: function(obj, record){
	                				 var programCategoryId = record[0].get("id");
	        	                	 var form = obj.up('form');
	        	                	 var programId = form.down('#programId');
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	        	                	 programId.reset();
	        	                	 if(programCategoryId > 0){
	        	                		 var store = programId.getStore();
	        	                		 store.getProxy().extraParams = {
	        	                			 programCategoryId : programCategoryId,
	        	                			 academyLocationIds : academyLocationId
	        	                		 };
	        	                		 store.load();
	        	                	 }
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.demographicReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.demographicReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#periodId':{
	                			 select: function(obj, record){
	                				 this.demographicReportPeriodSelect(obj, record)
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#country': {
	                			 render : function(country) {
	                				 var form = country.up('form');
	                				 var countryStore = country.getStore();
	                				 countryStore.load({
	                					 callback:function(record, success) {
	                						 if(success){
	                							 for(var i in record) {
	                								 if(record[i].data.countryName === 'INDIA') {
	                									 var countryId = record[i].data.id;
	                									 country.setValue(record[i].data.id);
	                									 var state = form.down('#state');
	                									 state.clearValue();
	                									 var store = state.getStore();
	                									 store.getProxy().extraParams = {
	                										 cid: countryId
	                									 };
	                									 store.load();
	                								 }
	                							 }
	                						 }
	                					 }
	                				 });
	                			 },
	                			 select: function(obj, record) {
	                				 var form = obj.up('form');
	                				 var state = form.down('#state');
	                				 state.clearValue();
	                				 var countryId = record[0].get("id");
	                				 if (countryId > 0) {
	                					 var store = state.getStore();
	                					 store.getProxy().extraParams = {
	                						 cid: countryId
	                					 };
	                					 store.load();

	                				 }
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter combo#state':{
	                			 select:function(obj,rec){
	                				 var form = obj.up('form');
	                				 var city = form.down('#city');
	                				 city.clearValue();
	                				 city.setDisabled(false);
	                				 var countryRegionId=rec[0].data.id;
	                				 var store = city.getStore();
	                				 store.getProxy().extraParams = {
	                					 id: countryRegionId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'studentdemographicsreportfilter button[itemId=searchBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getStudentdemographicsreportgrid();
	                				 var store = grid.getStore();
	                				 var form = this.getStudentdemographicsreportfilter();
	                				 form.down('#searchBtn').setDisabled(true);
	                				 var values = this.getStudentdemographicsreportfilter().getForm().getValues();
	                				 store.getProxy().extraParams = {
	                					 intakeYearId : values.intakeYear,
	                					 academicTermId : values.academicTerm,
	                					 religionId : values.religion,
	                					 studentCategoryId : values.castCategory,
	                					 programCategoryId : values.programCategory,
	                					 programGroupId : values.programGroup,
	                					 programId : values.programId,
	                					 batchId : values.batchId,
	                					 periodId : values.periodId,
	                					 countryId : values.country,
	                					 stateId : values.state,
	                					 cityId : values.city,
	                					 gender: values.gender,
	                					 seatTypeId: values.SEAT_TYPE,
	                					 sectionId: values.sectionId
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                					 callback:function(record, success) {
	                						 if(success){
	                							 form.down('#searchBtn').setDisabled(false); 
	                						 }
	                					 }
	                				 
	                				 });
	                				 grid.config.searchFilterForm = this.getStudentdemographicsreportfilter();	                			 }
	                		 },
	                		 'studentdemographicsreportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var batch = form.down('#batchId');
	                				 var period = form.down('#periodId');
	                				 var section = form.down('#sectionId');
	                				 var city = form.down('#city');
	                				 city.clearValue();
	                				 city.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 period.setDisabled(true);
	                				 section.setDisabled(true);

	                				 var program = form.down('#programId');
	                				 var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 programStore.load();
	                			 }
	                			 },
	                		 'studentdemographicsreportgrid button[itemId=exportReportsId]': {
	                        	 click: function(obj) {
	                        		 this.openStdDemgraphicReportWin();
	                        	 }
	                         },
	                         'studentdemographicsreportgrid': {
	                        	 render : function(grid) {
	             					this.doAccessControlValidation(grid, this.getSTUDENT_DEMOGRAPHIC_REPORT_PERMISSIONS());
	             					this.disableStdDemographicReportPivileges(grid, this.getSTUDENT_DEMOGRAPHIC_REPORT_PERMISSIONS());
	             				},
	             				afterrender : function(grid){
	             					var alinfomodel = Academia.model.authentication.ALInfoModel;
	             					var wheatherSchool = alinfomodel.get('wheatherSchool');
	             					if(wheatherSchool){
	             						for (var j = 0; j < grid.columns.length; j++) {
	             							if (grid.columns[j].dataIndex == "periodName") {
	             								grid.columns[j].setVisible(false);
	             								
	             							}
	             							if (grid.columns[j].dataIndex == "academicTerm") {
	             								grid.columns[j].setVisible(false);
	             								break;
	             							}
	             						}
	             					}else{
	             						for (var j = 0; j < grid.columns.length; j++) {
	             							if (grid.columns[j].dataIndex == "periodName") {
	             								grid.columns[j].setVisible(true);
	             								
	             							}
	             							if (grid.columns[j].dataIndex == "academicTerm") {
	             								grid.columns[j].setVisible(true);
	             								break;
	             							}
	             						}
	             					}
	             				}
	                         },
	                		 'studentdemographicreportwin[itemId=studentdemographicreportwinId] button[itemId=submitBtn]': {
	                        	 click: function(btn) {
	                        			this.exportXlsStdDemographicReport();
	                        	 }
	                         },
	                         'studentdemographicsreportfilter': {
	                        	 render : function(obj) {
	                        		 var $this = this;
	                        		 var form = $this.getStudentdemographicsreportfilter().getForm();
	                        		 var academicTerm = form.findField('academicTerm');
	                        		 var periodField = form.findField('periodId');
	                        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                        		 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                        		 if(wheatherSchool){
	                        			 academicTerm.setVisible(false);
	                        			 periodField.setVisible(false);
	                        		 }else{
	                        			 academicTerm.setVisible(true);
	                        			 periodField.setVisible(true);
	                        		 }
	                        		 var seatType = form.findField('SEAT_TYPE');
	                        		 var SeatTypeStore = seatType.getStore();
	                        		 SeatTypeStore.load();

	                        	 }
	                         },
	                         
	                         'studentdemographicsreporttabstructure':{
		               			   render:function(studentdemographicsreporttabstructure){
		               				   this.enableTabforstudentdemographicPanel(studentdemographicsreporttabstructure);
		               			   },
		               		   afterrender:function(structure)
		               		   {
		               			   var grid=structure.down('studentdemographicsreportgrid');
		               			   this.getGridHeaderFreeze(grid,structure,true);
		               		   }
		               		   }
	                         
	                         
	                         
	                	 });
	                 },
	                 
	                 enableTabforstudentdemographicPanel:function(studentdemographicsreporttabstructure)
	                 {
	                	 this.showTabforDemographicReportPanel(studentdemographicsreporttabstructure);
	                 },
	                 
	                 showTabforDemographicReportPanel : function(studentdemographicsreporttabstructure) {
					  	   var panelItem = new Array();
					  	   var $this = this;
					  	   var newcont=studentdemographicsreporttabstructure.items.items.length;
					  	   var insertPosition=newcont+1;
					  		   panelItem.push({
					  			   xtype:'tabpanel',
					  			   itemId:'allVisibleTP',
					  			   plain: true,
					  			   style:{overflow:'hidden !important',margin:'0!important'},
					  			   
					  			   frame: false,
					  			   border:false,
					  			   defaults: {
					  				   labelAlign: 'top'
					  			   },
					  			   items:[{
					  					xtype : 'studentdemographicsreportstructure',
					  					itemId : 'studentdemographicsreportstructure',
					  					title : getCommonTranslation('SEARCH'),
					  					tabCls : 'right-tab'
					  				}]
					  		   });

					  		 studentdemographicsreporttabstructure.insert(insertPosition,panelItem);
					     },

	                 demographicReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 var period = form.down('#periodId');
	                	 var section = form.down('#sectionId');
	                	 period.reset();
	                	 section.reset();
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 period.setDisabled(true);
	                	 section.setDisabled(true);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 demographicReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var period = form.down('#periodId');
	                	 period.reset();
	                	 period.setDisabled(false);
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var periodStore = period.getStore();
	                		 periodStore.getProxy().extraParams = {
	                			 id: batchId
	                		 };
	                			periodStore.load({
	     						   callback: function(records, operation, success) {
	     							   if (success) {
	     								   if(records.length==0){
	     									   if(wheatherSchool) {
	     										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

	     									   } 
	     								   }
	     								   else if(records.length==1){
	     									   form.down("#periodId").setValue(records[0].get('id'))
	     									   form.down("#sectionId").setDisabled(false);
	     									   var store = form.down("#sectionId").getStore();
	     									   store.getProxy().extraParams = {
	     										   periodId: records[0].get('id')
	     									   };
	     									   store.load();

	     								   }else{
	     									   form.down('#periodId').setVisible(true); 
	     								   }
	     							   }
	     						   }
	     					   
	     					   
	     					});
	                	 }
	                 },
	                 demographicReportPeriodSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var section = form.down('#sectionId');
	                	 section.reset();
	                	 section.setDisabled(false);
	                	 var periodId = record[0].get("id");
	                	 if(periodId > 0){	    	        					  
	                		 var store = section.getStore();
	                		 store.getProxy().extraParams = {
	                			 periodId: periodId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 openStdDemgraphicReportWin : function(){
	             		var window = this.getStudentdemographicreportwin();
	             		if(!window){
	             			window = Ext.widget('studentdemographicreportwin',{
	                    			itemId:'studentdemographicreportwinId'
	                    		});
	             		}
	             		window.show();
	             	},
	             	exportXlsStdDemographicReport : function() {
	            		var $this = this;
	            		var form = $this.getStudentdemographicsreportfilter().getForm();
	            		var reportType = $this.getStudentdemographicreportwin().down("#reportType");
	            		var values = form.getValues();
	            		var reportParams = new Object();
	            		var academyLocationId = this.getCurrentAcademyLocation();
	            		var reportTitle = "Student Statistics Report";
	            		var code;
	            		var alinfomodel = Academia.model.authentication.ALInfoModel;
	            		var wheatherSchool = alinfomodel.get('wheatherSchool');
	            		
	            		if (reportType.getValue() === 'STATISTICS') {
	            			code = 'STUDENT_STATISTICS_REPORT';
	            			reportParams.headerName = getCommonTranslation('CASTE_CATEGORY');
	            			reportTitle=getCommonTranslation('STUDENT_CASTE_CATEGORY_REPORT');
	            		}else if (reportType.getValue() === 'GENDER') {
	            			var reportTitle = "Student Gender Report";
	            			code = 'STUDENT_GENDER_REPORT';
	            			reportParams.headerName = 'Student Statistics Report- Gender';
	            		}else if (reportType.getValue() === 'SEATTYPE') {
	            			code = 'STUDENT_STATISTICS_SEAT_TYPE_REPORT';
	            			reportParams.headerName = 'Student Statistics Report- Seat Type';
	            			reportTitle=getCommonTranslation('STUDENT_SEAT_TYPE_REPORT');
						} else if (reportType.getValue() === 'NATIONALITY') {
							code = 'STUDENT_NATIONALITY_WISE_REPORT';
							reportParams.headerName = 'Student Nationality Report';
							reportTitle = getCommonTranslation('STUDENT_NATIONALITY_WISE_REPORT');
						} else if (reportType.getValue() === 'CITIZENSHIP') {
							code = 'STUDENT_CITIZENSHIP_WISE_REPORT';
							reportParams.headerName = 'Student Citizen Report';
							reportTitle = getCommonTranslation('STUDENT_CITIZENSHIP_WISE_REPORT');
						} else {
							code = 'STUDENT_RELGION_WISE_REPORT';
							reportParams.headerName = 'Student Statistics Report- Religion';
							reportTitle = getCommonTranslation('STUDENT_RELIGION_REPORT');
						}
	            		
	            		reportParams.code = code;
	            		reportParams.wheatherSchool = wheatherSchool;
	            		reportParams.reportTitle = reportTitle;
	            		reportParams.intakeYearId = values.intakeYear;
	            		reportParams.academicTermId = values.academicTerm;
	            		reportParams.religionId = values.religion;
	            		reportParams.studentCategoryId = values.castCategory;
	            		reportParams.programCategoryId = values.programCategory;
	            		reportParams.programGroupId = values.programGroup;
	            		reportParams.programId = values.programId;
	            		reportParams.batchId = values.batchId;
	            		reportParams.periodId = values.periodId;
	            		reportParams.seatTypeId = values.SEAT_TYPE;
	            		reportParams.sectionId = values.sectionId;
	            		reportParams.countryId = values.country;
	            		reportParams.stateId = values.state;
	            		reportParams.cityId = values.city;
	            		reportParams.academyLocationId = academyLocationId;
	            		reportParams.reportType = reportType.getValue();
	            		reportParams.gender = values.gender;
	            		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_STUDENT_STATISTICS_EXCEL_REPORT);
	            		$this.getStudentdemographicreportwin().close();
	            	},
	            	disableStdDemographicReportPivileges : function(gridReference, permissionsMap) {

	            		var associatedAcadLocationIds = new Array();
	            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	            		var permissionList = Academia.utilities.accessControl.AccessControlManager
	            		.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	            		buttonsToolBar = gridReference.query('toolbar')[0];
	            		buttonsToolBar.setVisible(false);
	            		var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	            		Ext.each(permissionList, function(privilege) {
	            			if (privilege === 'EXPORTREPORTS') {
	            				if(!isNullOrEmpty(exportReport)){
	            					exportReport.setVisible(true);
	            				}        		
	            			}
	            		});
	            		buttonsToolBar.setVisible(true);
	            	}
});
