/**
 * @ author Kamini Birla
 */
Ext.define('Academia.controller.student.report.StudentHealthInformationReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['feeandpayment.managebill.Student','user.UserAcademyLocationStore','Academia.store.program.ProgramSortedSequenceWiseStore',
		'Academia.store.program.programbatchdetail.BatchStore','Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'Academia.store.common.MedicalIndicatorsStore','Academia.store.program.ConfiguredProgramListStore','student.report.StudentHealthInformationReportStore',
		'personinfo.common.pasthistory.StudentHealthInformationUrlGridStore','personinfo.common.pasthistory.StudentHealthInformationDocumentGridStore','Academia.store.student.report.ProgramWithAcademicTermStore'],
	         views: ['Academia.view.student.healthInformationReport.StudentHealthInformationReportTabStructure',
	                 'Academia.view.student.healthInformationReport.StudentHealthInformationReportStructure','Academia.view.student.healthInformationReport.StudentHealthInformationReportFilter',
	                 'Academia.view.student.healthInformationReport.StudentHealthInformationReportGrid','Academia.view.student.healthInformationReport.StudentHealthInformationReportGrid',
	                 'Academia.view.personinfo.common.pasthistory.StudentHealthInformationReportDocumentListGrid','Academia.view.personinfo.common.pasthistory.StudentHealthInformationReportUrlList',
	                 'Academia.view.personinfo.common.pasthistory.StudentHealthInformationReportUrlListGrid','Academia.view.personinfo.common.pasthistory.StudentHealthInformationReportDocumentList',
	                 'Academia.view.document.DocumentFormWindow'],
	                 config : {
	                	 STUDENT_HEALTH_INFORMATION_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HEALTH_INFORMATION_REPORT_PRIVILEGES')
	                 },
	                 refs: [{
	                	 ref: 'studenthealthinformationreporttabstructure',
	                	 selector: 'studenthealthinformationreporttabstructure'
	                 },{
	                	 ref: 'studenthealthinformationreportfilter',
	                	 selector: 'studenthealthinformationreportfilter[itemId=studenthealthinformationreportfilterItemId]'
	                 },{
	                	 ref: 'studenthealthinformationreportgrid',
	                	 selector: 'studenthealthinformationreportgrid'
	                 },{
	                	 ref: 'documentformwindow',
	                	 selector: 'documentformwindow'
	             	},{
	             		ref: 'studenthealthinformationreportdocumentlist',
	             		selector: 'studenthealthinformationreportdocumentlist[itemId=studenthealthinformationreportdocumentlistId]'
	             	},{
	                      ref: 'studenthealthinformationreportdocumentlistgrid',
                          selector: 'studenthealthinformationreportdocumentlistgrid'
	                },{
	                      ref: 'studenthealthinformationreporturllist',
                          selector: 'studenthealthinformationreporturllist[itemId=studenthealthinformationreporturllistId]'
	                },{
	                      ref: 'studenthealthinformationreporturllistgrid',
                          selector: 'studenthealthinformationreporturllistgrid'
	                }],
	                 
	                 init : function() {
	     	        	this.control({
	     	        		
	     	        		'studenthealthinformationreportfilter customcombobox[itemId=academyLocationId]': {
	     	        			 afterrender: function(combo) {
	     	                    	var me = this;
	     	                    	this.loadAcadLocCombo(combo);
	     	                        var store = combo.getStore();
	     	                    	store.load({
	     	                			callback:function(records,response,success){
	     	                				combo.setValue(me.getCurrentAcademyLocation())
	     	                			}
	     	                		});

	     	                    },
	     	                    change: function(ob, rec){
	     	                       var form = this.getStudenthealthinformationreportfilter().getForm();
	     	                       var academyLocationId = ob.up('form').down('#academyLocationId').getValue(); 
	     	                       var academyLocationIds;

	     	                      if (academyLocationId != undefined && academyLocationId !== "") {
	     	                    	    academyLocationIds = academyLocationId;
	     	                      } 
	     	                      else{
	     	                    	    academyLocationIds = this.getCurrentAcademyLocation();
	     	                      }

	     	                       var programId = ob.up('form').down('#programId');
	     	                       programId.reset();

	     	                       var programStore = programId.getStore();
	     	                       programStore.getProxy().extraParams = {
	     	                           academyLocationIds: academyLocationIds
	     	                       };

	     	                       programStore.load();
	     	                   }
	     	          	},
	     	       	
	     	       	 'studenthealthinformationreportfilter[itemId=studenthealthinformationreportfilterItemId] multiselectcombofield[itemId=programId]': {
	 	                   change : function(obj){
						   var form = obj.up('form');
						   var values = form.getForm().getValues();
						   var programId = values.program;
						   var batch = form.down('#batchId');
						   var period = form.down('#periodId');
						   batch.reset();
						   period.reset();
						   var programids=[];
						   var programs; 
						   if(programId !=undefined && programId.length > 0){
							   batch.setDisabled(false);
					    		for(var i in programId){
					    			if(Ext.isObject(programId[0])){
					    				programids.push(programId[i].get("id"));
					    			}else{
					    				programids.push(programId[i]);
					    			}
					    		}
					    	programs = programids.join();
					    	var store = batch.getStore();
	                       	store.proxy.extraParams = {
	                       		programIds : programs
	      					};
	                       	store.load();
					    	}else{
					    		batch.setDisabled(true);
					    		period.setDisabled(true);
					    	}
					   }
				   },
				   'studenthealthinformationreportfilter[itemId=studenthealthinformationreportfilterItemId] multiselectcombofield[itemId=batchId]': {
					    change : function(obj){
						    var form = this.getStudenthealthinformationreportfilter().getForm();
		            		var batchId = obj.up('form').down('#batchId').getValue();
							   var batchids=[];
							   var batchs; 
							   var period = obj.up('form').down('#periodId');
							   period.reset();
							   if(batchId !=undefined && batchId.length > 0){
								   period.setDisabled(false);
						    		for(var i in batchId){
						    			if(Ext.isObject(batchId[0])){
						    				batchids.push(batchId[i].get("id"));
						    			}else{
						    				batchids.push(batchId[i]);
						    			}
						    		}
						    		batchs = batchids.join();
						    		var store = period.getStore();
									   store.getProxy().extraParams = {
										   batchIds : batchs
											};
									   store.load();
						    	}else{
						    		period.setDisabled(true);
						    		period.getStore().removeAll();
						    	}
					   }
				   },
				   'studenthealthinformationreportfilter multiselectcombofield[itemId=medicalIndicatorId]': {
					   render:function(combo,pivileges){
         				 var me = this;
         				 me.HideMedicalIndicatorPivileges(combo, me.getSTUDENT_HEALTH_INFORMATION_REPORT_PERMISSIONS());
					   }
			    	},
				   'studenthealthinformationreportfilter button[itemId=searchBtn]' : {
	          			 click : function(form) {
	          				 var grid = this.getStudenthealthinformationreportgrid();
	          				 var store = grid.getStore();
	          				 var form = this.getStudenthealthinformationreportfilter();
	          				 form.down('#searchBtn').setDisabled(true);
	          				 var values = form.getForm().getValues();
	          				// var multiselectProgramIdField = form.down('#programId');
	          		        	var programIdsArray = values.program;
	          		        	var programIds;
	          		        	if (!isNullOrEmpty(programIdsArray)) {
	          		        		if(typeof programIdsArray[0]!="object"){
	              	            		var programIds = programIdsArray;
	              	            	}
	              	            	else {
	              	            		var programIdsTempArray = [];
	              	            		Ext.each(programIdsArray,function(currentProgramId){
	              	            			programIdsTempArray.push(currentProgramId.data.id);
	              	            		});
	              	            		var programIds = programIdsTempArray.join(',');
	              	            	}
	    						}
	          	            	
	           		        	var batchIdsArray = values.batch;
	           		        	var batchIds;
	           		        	if (!isNullOrEmpty(batchIdsArray)) {
	           		        		if(typeof batchIdsArray[0]!="object"){
	               	            		var batchIds = batchIdsArray;
	               	            	}
	               	            	else {
	               	            		var batchIdsTempArray = [];
	               	            		Ext.each(batchIdsArray,function(currentBatchId){
	               	            			batchIdsTempArray.push(currentBatchId.data.id);
	               	            		});
	               	            		var batchIds = batchIdsTempArray.join(',');
	               	            	}
	    						}

	           		        	var periodIdsArray = values.period;
	           		        	var periodIds;
	           		        	if (!isNullOrEmpty(periodIdsArray)) {
	           		        		if(typeof periodIdsArray[0]!="object"){
	               	            		var periodIds = periodIdsArray;
	               	            	}
	               	            	else {
	               	            		var periodIdsTempArray = [];
	               	            		Ext.each(periodIdsArray,function(currentPeriodId){
	               	            			periodIdsTempArray.push(currentPeriodId.data.id);
	               	            		});
	               	            		var periodIds = periodIdsTempArray.join(',');
	               	            	}
	    						}
	           		        	
	           		        	var medicalIdicatorsIdsArray = values.medicalIndicator;
	           		        	var medicalIndicatorsIds;
	           		        	if (!isNullOrEmpty(medicalIdicatorsIdsArray)) {
	           		        		if(typeof medicalIdicatorsIdsArray[0]!="object"){
	               	            		var medicalIndicatorsIds = medicalIdicatorsIdsArray;
	               	            	}
	               	            	else {
	               	            		var medicalIndicatorsIdsTempArray = [];
	               	            		Ext.each(medicalIdicatorsIdsArray,function(currentMedicalIndicatorsId){
	               	            			medicalIndicatorsIdsTempArray.push(currentMedicalIndicatorsId.data.id);
	               	            		});
	               	            		var medicalIndicatorsIds = medicalIndicatorsIdsTempArray.join(',');
	               	            	}
	    						}
	           		        	var isMedicalCondition = false;
	           		        	var isMedication = false;
	           		        	var isAllergies = false;
	           		        	var isLearningDifficulties = false;
	           		        	var gridCols = [];
		           		        	if(!isNullOrEmpty(medicalIndicatorsIds) && medicalIndicatorsIds.includes('MEDICAL_CONDITIONS')){
		           		        		isMedicalCondition = true;
		           		        	}
		           		        	if(!isNullOrEmpty(medicalIndicatorsIds) && medicalIndicatorsIds.includes('MEDICATION')){
		           		        		isMedication = true;
		           		        	}
		           		        	if(!isNullOrEmpty(medicalIndicatorsIds) && medicalIndicatorsIds.includes('ALLERGIES')){
		           		        		isAllergies = true;
		           		        	}
		           		        	if(!isNullOrEmpty(medicalIndicatorsIds) && medicalIndicatorsIds.includes('LEARNING_DIFFICULTIES')){
		           		        		isLearningDifficulties = true;
		           		        	}
		           		        	var gridCols = this.showHideDataGridColumns(grid, gridCols, isMedicalCondition, isMedication, isAllergies, isLearningDifficulties);
			           		        grid.reconfigure(store,gridCols);
			           		        grid.getView().refresh();
			           		        store.getProxy().extraParams = {
			           		        	academyLocationId : values.academyLocation,
			           		        	studentId : values.STUDENT_ID,
			           		        	academicTermId : values.ACADEMIC_TERM_ID,
			           		        	programId : programIds,
			           		        	batchId : batchIds,
			           		        	periodId : periodIds,
			           		        	medicalIndicators : medicalIndicatorsIds,
			           		        }
			           		        this.resetPageSetting(store);
			           		        store.load({
			           		        	callback: function(record){
			           		        		form.down('#searchBtn').setDisabled(false);
			           		        	}
			           		        });
			           		        grid.getStore().reload();
			           		        grid.config.searchFilterForm = this.getStudenthealthinformationreportfilter();
		          				 
		          			 }
	          		 },
	            	 'studenthealthinformationreportfilter button[itemId=resetBtn]' : {
            			 click : function(obj) {
            				 var form = obj.up('form');
            				 form.getForm().reset();
            				 var batch = form.down('#batchId');
            				 var period = form.down('#periodId');
    	                	 var program = form.down('#programId');
    	                	 var medicalIndicator = form.down('#medicalIndicatorId')
    	                	 var academyLocationIds = form.down('#academyLocationId');
    	                	 program.setReadOnly(false);
    	                	 medicalIndicator.setReadOnly(false);
            				 batch.setDisabled(true);
            				 period.setDisabled(true);

            				 var program = form.down('#programId');
            				 var programStore = program.getStore();
            				 var academyLocationId= this.getCurrentAcademyLocation();
                              var academyLocationIdStore = academyLocationIds.getStore();
            				 
                            var academyLocationId = this.getCurrentAcademyLocation();
                            academyLocationIds.getStore().load({
              					callback: function(record){
              						academyLocationIds.select(academyLocationId);
              					}
              				});
            				
            				 programStore.getProxy().extraParams = {
            					 academyLocationIds: academyLocationId,
            					 isAllProgram:true
            				 };
            				 programStore.load();
            				 
            			 }
            		  },
            		  'studenthealthinformationreportgrid': {
            			  afterrender:function(grid){
            				  var me = this;
            				  me.addDataGridConfigButton(grid,me.getSTUDENT_HEALTH_INFORMATION_REPORT_PERMISSIONS());
            				  grid.getStore().removeAll();
            				  grid.down('#exportExcelAll').setVisible(false);
            				  grid.down('#exportPDFAll').setVisible(false);
			    			},
            			  cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
								var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if(columnName == "studentHealthDocument"){
									if(e.target.tagName=='A'){
										if(record.data.studentHealthDocument.length == 1){
											var whetherFile = false;
											var documentId= record.data.studentHealthDocument[0].id;
											if(!isNullOrEmpty(documentId)){
												Ext.Ajax.request({
													type: 'rest',
													url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
													method: 'GET',
													callback : function(opt, success, response){
														if(response.responseText == 'true') {
															var csvForm = Ext.create('Ext.form.Panel'); 
															csvForm.getForm().submit({
																target: '_blank',
																method:'GET',
																params :{
																	access_token : Ext.Ajax.defaultHeaders.access_token
																},
																headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
																url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
																standardSubmit :true
															});
														} else {
															showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
														}
													}
												});
											}} else if(record.data.studentHealthDocument.length > 1){
												var docWindow = this.getStudenthealthinformationreportdocumentlist();
												var ID = record.data.studentHealthId;
												if (!docWindow) {
													docWindow = Ext.widget('studenthealthinformationreportdocumentlist',{
														itemId:'studenthealthinformationreportdocumentlistId'
													});
												}
												docWindow.show();
												 var studenthealthinformationreportdocumentlistgrid = docWindow.down('#studenthealthinformationreportdocumentlistgridItemId');
												 var store = studenthealthinformationreportdocumentlistgrid.getStore();
												  store.getProxy().extraParams = {
				             						  ID: record.data.studentHealthId
				             					  };
				             					  store.load();
											}
									}
								}
								if(columnName == "studentHealthDocumentUrl"){
									if(e.target.tagName=='A'){
										if(record.data.studentHealthDocumentUrl.length == 1){
											
										} else if(record.data.studentHealthDocumentUrl.length > 1){    	
												var docWindow = this.getStudenthealthinformationreportdocumentlist();
				             					  var ID = record.data.studentHealthId;
				             					  	             					  
				             					 if (!docWindow) {
				             						docWindow = Ext.widget('studenthealthinformationreporturllist',{
														itemId:'studenthealthinformationreporturllistId'
													});
				             					 }
												docWindow.show();
												
												 var studenthealthinformationreporturllistgrid = docWindow.down('#studenthealthinformationreporturllistgridItemId');
												 var store = studenthealthinformationreporturllistgrid.getStore();
												  store.getProxy().extraParams = {
				             						  ID: record.data.studentHealthId
				             					  };
				             					  store.load();
											}
									  }
									}
							}
                       },
						   'studenthealthinformationreportdocumentlistgrid':{
							cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
								var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
								if(columnName == "documentName"){
									if(e.target.tagName=='A'){
										var documentId=record.get('ecrptydocumentId');
										if(!isNullOrEmpty(documentId)){
											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
												method: 'GET',
												callback : function(opt, success, response){
													if(response.responseText == 'true') {
														var csvForm = Ext.create('Ext.form.Panel'); 
														csvForm.getForm().submit({
															target: '_blank',
															method:'GET',
															params :{
																access_token : Ext.Ajax.defaultHeaders.access_token
															},
															headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
															url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
															standardSubmit :true
														});
														showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOWNLOAD_HEALTH_DOCUMENT_SUCCESSFULLY'));
													} else {
														showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
													}
												}
											});
										}
									}
								}
							}
						},
						'studenthealthinformationreportdocumentlistgrid button[itemId=btnDelete]':{
			 				click:function(obj){
			 					var $this=this;
			 					var form = this.getStudenthealthinformationreportdocumentlist();
								var studentHealthInformationlistgrid=obj.up('grid');
								var studentHealthInformationGrid= $this.getStudenthealthinformationreportgrid();
			 					if (studentHealthInformationlistgrid.getSelectionModel().getCount() > 0) {
			 						var records = studentHealthInformationlistgrid.getSelectionModel().getSelection();
			 						var ids=[];
			 						Ext.Array.each(records,function(value){
			 							ids.push(value.data.id);
			 						});
			 							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('HEALTH_INFORMATION_DELETE_CONFIRM_MESSAGE'),function(btn,text){
			 							if (btn == 'yes'){
			 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 								Ext.Ajax.request({
			 									method: "DELETE",
			 									type: 'rest',
			 									url : SERVERURL.PATH_STUDENTD_HEALTH_INFORMATION_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
			 									headers: {
			 										'Content-Type': 'application/json'
			 									},
			 									success: function(form, action) {

			 										Ext.getBody().unmask();
			 										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
			 										studentHealthInformationlistgrid.store.reload();
			 										studentHealthInformationGrid.store.reload();
			 										studentHealthInformationlistgrid.getSelectionModel().deselectAll(true);
			 									}
			 								});
			 							}
			 						});
			 					} else {
			 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			 					}
			 				}
			       	 },			   
					'studenthealthinformationreportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
							click:function(obj){
								var $this = this;
								var form = $this.getStudenthealthinformationreportdocumentlist();
								var StudentHealthDetailActionGrid=obj.up('grid');
								if (StudentHealthDetailActionGrid.getSelectionModel().getCount() > 0) {
									var records = StudentHealthDetailActionGrid.getSelectionModel().getSelection();
									var dispatchZipName = "Student Health Information Document";
									var saveModel=[];  
									for(var i in records){
										if(!isNullOrEmpty(records[i].get('path'))) {
											saveModel.push(records[i].get('path'));
										}
										showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS'),
												getCommonTranslation('STUDENT_HEALTH_INFORMATION_DOCUMENTS_ALERT'),
												function(btn, text) {
											if (btn == 'yes') {
												var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
												$this.getController('Academia.controller.document.DocumentController')
												.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
											}
										});
									}
								}
								else {
									$this.hideWindowMask();
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
								}
							}
			     	 },
			     	'studenthealthinformationreporturllistgrid button[itemId=btnDelete]':{
		 				click:function(obj){
		 					var $this=this;
		 					var studentHealthInformationGrid= $this.getStudenthealthinformationreportgrid();
		 					var studentHealthInformationUrlListgrid=$this.getStudenthealthinformationreporturllistgrid();
		 					if (studentHealthInformationUrlListgrid.getSelectionModel().getCount() > 0) {
		 						var records = studentHealthInformationUrlListgrid.getSelectionModel().getSelection();
		 						var ids=[];
		 						Ext.Array.each(records,function(value){
		 							ids.push(value.data.id);
		 						});
		 							showConfirmMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
		 							if (btn == 'yes'){
		 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 								Ext.Ajax.request({
		 									method: "DELETE",
		 									type: 'rest',
		 									url : SERVERURL.PATH_STUDENTD_HEALTH_INFORMATION_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
		 									headers: {
		 										'Content-Type': 'application/json'
		 									},
		 									success: function(form, action) {

		 										Ext.getBody().unmask();
		 										showSuccessMessage(getCommonTranslation('STUDENT_HEALTH_INFORMATION_URL'),getCommonTranslation('URL_SUCCESS_MSG'));	 
		 										studentHealthInformationUrlListgrid.store.reload();
		 										studentHealthInformationGrid.store.reload();
		 										studentHealthInformationUrlListgrid.getSelectionModel().deselectAll(true);
		 									}
		 								});
		 							}
		 						});
		 					} else {
		 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 					}
		 				}
		       	 },
	     	  })
	         },
	         HideMedicalIndicatorPivileges : function(combo,pivileges) {
	        	    var me = this;
					var associatedAcadLocationIds = new Array();
	    	       	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getSTUDENT_HEALTH_INFORMATION_REPORT_PERMISSIONS());
					combo.getStore().on('load', function(record){
						var firstArray = ['MEDICAL_CONDITION', 'MEDICATION', 'ALLERGIES', 'LEARNING_DIFFICULTIES'];
						var secondArray = permissionList;
						var thirdArray= [];
						
						Ext.each(firstArray, function(currentItem){
						    if(secondArray.indexOf(currentItem) == -1){
						        thirdArray.push(currentItem);
						    }
						});
						
						Ext.each(thirdArray, function(privilege) {
							if (privilege == 'MEDICAL_CONDITION' || privilege == 'MEDICATION' || privilege == 'ALLERGIES' || privilege == 'LEARNING_DIFFICULTIES') {
								var index = record.findExact('permissionKey',privilege)
								record.removeAt(index);
							}
						});
					});
				},
			    loadAcadLocCombo: function(combo) {
			    var store = combo.getStore();
			    store.getProxy().extraParams = {
					id: this.getCurrentlyLoggedInUser().id
				};
			    
			},
			showHideDataGridColumns:function(grid,gridCols, isMedicalCondition, isMedication, isAllergies, isLearningDifficulties){
				var gridColumn=grid.columns;
				var parentUserId =localStorage.getItem('parentUserId');
				var currentPortalId = localStorage.getItem('portalId');
				var gridClass= grid.$className;
				var columnsArray = [];
				columnsArray.push({
   		     		header:  getCommonTranslation('STUDENT_ID'),
   		     		dataIndex: 'studentId',
   		     		flex:.1
   		     	});
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION,
					params : {
						portalId : currentPortalId,
						parentUserId : parentUserId,
						gridName : gridClass
					},
					method : 'GET',
					async: false,
					success : function(response) {
						if(response.responseText!="") {
							var respData = Ext.decode(response.responseText);
							var responseData = Ext.decode(respData.jsonObject);
							var respUserData = respData;
							var responseColumnsArray = [];
							Ext.each(responseData, function(currentCol){
								if(currentCol.columnVisibility == "SHOW"){
									responseColumnsArray.push(currentCol.dataIndex);
								}
							})
							

							if(responseColumnsArray.includes("academyLocation")){
								columnsArray.push({
		           		     		header:  getCommonTranslation('ACADEMY_LOCATION'),
		           		     		dataIndex: 'academyLocation',
		           		     		flex:.1
		           		     	});
							}
						    if(responseColumnsArray.includes("programName")){
						    	columnsArray.push({
		           		     		header:  getCommonTranslation('PROGRAM'),
		           		     		dataIndex: 'programName',
		           		     		flex:.1
		           		     	});
							}
						    if(responseColumnsArray.includes("batchName")){
						    	columnsArray.push({
		           		     		header:  getCommonTranslation('BATCH'),
		           		     		dataIndex: 'batchName',
		           		     		flex:.1
		           		     	});
							}
						    if(responseColumnsArray.includes("academicTerm")){
						    	columnsArray.push({
		           		     		header:  getCommonTranslation('ACADEMIC_TERM'),
		           		     		dataIndex: 'academicTerm',
		           		     		flex:.1
		           		     	});
							}
						    if(responseColumnsArray.includes("periodName")){
						    	columnsArray.push({
		           		     		header:  getCommonTranslation('PERIOD'),
		           		     		dataIndex: 'periodName',
		           		     		flex:.1
		           		     });
							}
						    
						    if(isMedicalCondition){
						    	columnsArray.push({
						    		header : getCommonTranslation('MEDICAL_CONDITIONS'),
						    		dataIndex : 'medicalConditionsVal',
						    		flex : .1,
						    		renderer:function(value, metaData, record, rowIdx, colIdx, store){
						    			if(!isNullOrEmpty(value)){
						    				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
						    				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
						    				metaData.tdCls ="student-thesis-column-cls";
						    				return value;
						    			}	
						    		}
						    	});
						    	columnsArray.push({
						    		header: getCommonTranslation('MEDICAL_CONDITIONS_NAME'), 
						    		dataIndex: 'medicalConditionOther',
						    		sortable:true,
						    		flex: .1,
						    		renderer:function(value, metaData, record, rowIdx, colIdx, store){
						    			if(!isNullOrEmpty(value)){
						    				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
						    				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
						    				metaData.tdCls ="student-thesis-column-cls";
						    				return value;
						    			}	
						    		}
						    	});
						    }
						    
						    if(isMedication){
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('MEDICATION'), 
    	           		     		dataIndex: 'medicationVal',
    	           		     		sortable:true,
    	           		     		flex: .1
    	           		     	});
						    	
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('MEDICATION_NAME'), 
    	           		     		dataIndex: 'medicationOther',
    	           		     		sortable:true,
    	           		     		flex: .1,
    	           		     		renderer:function(value, metaData, record, rowIdx, colIdx, store){
    	           		     			if(!isNullOrEmpty(value)){
    	           		     				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
    	           		     		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
    	           		     				metaData.tdCls ="student-thesis-column-cls";
    	           		     	            return value;
    	           		     			}	
    	           		     		}
    	           		     	});
						    }
						    
						    if(isAllergies){
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('ALLERGIES'), 
    	           		     		dataIndex: 'allergiesVal',
    	           		     		sortable:true,
    	           		     		flex: .1
    	           		     	});
						    	
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('ALLERGIES_NAME'), 
    	           		     		dataIndex: 'allergiesOther',
    	           		     		sortable:true,
    	           		     		flex: .1,
    	           		     		renderer:function(value, metaData, record, rowIdx, colIdx, store){
    	           		     			if(!isNullOrEmpty(value)){
    	           		     				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
    	           		     		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
    	           		     				metaData.tdCls ="student-thesis-column-cls";
    	           		     	            return value;
    	           		     			}	
    	           		     		}
    	           		     	});
						    }
						    
						    if(isLearningDifficulties){
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('LEARNING_DIFFICULTIES'), 
    	           		     		dataIndex: 'learningDifficultiesVal',
    	           		     		sortable:true,
    	           		     		flex: .1
    	           		     	});
						    	
						    	columnsArray.push({
    	           		     		header: getCommonTranslation('LEARNING_DIFFICULTIES_NAME'), 
    	           		     		dataIndex: 'learningDifficultiesOther',
    	           		     		sortable:true,
    	           		     		flex: .1,
    	           		     		renderer:function(value, metaData, record, rowIdx, colIdx, store){
    	           		     			if(!isNullOrEmpty(value)){
    	           		     				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
    	           		     		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
    	           		     				metaData.tdCls ="student-thesis-column-cls";
    	           		     	            return value;
    	           		     			}	
    	           		     		}
    	           		     	});
						    }
						    
						    
						    
						    if(responseColumnsArray.includes("studentHealthDocument")){
						    	columnsArray.push({
						    		header: getCommonTranslation('UPLOAD_DOCUMENT'), 
						    		dataIndex: 'studentHealthDocument',
						    		sortable:true,
						    		flex: .2,
						    		renderer:function(value, meta, record){
						    			if(!isNullOrEmpty(record.data.studentHealthDocument.length)) {
						    				if(record.data.studentHealthDocument.length>1) {					
						    					return '<a href=#>'+record.data.studentHealthDocument.length+'<a>';
						    				} else if(record.data.studentHealthDocument.length==1) {
						    					var pathSplit=record.data.studentHealthDocument[0].path.split('/');
						    					var newPath=pathSplit[2];
						    					var newName=record.data.studentHealthDocument[0].name;
						    					var newValue=newName!=null?newName:newPath;
						    					return '<a href=#>'+newValue+'<a>';
						    				} 
						    			}                        
						    		}
						    	});
							}
						    if(responseColumnsArray.includes("studentHealthDocumentUrl")){
						    	columnsArray.push({
						    		header: getCommonTranslation('ADD_URL'),
						    		dataIndex: 'studentHealthDocumentUrl',
						    		sortable:true,
						    		flex: .2,
						    		renderer:function(value, meta, record){
						    			if(!isNullOrEmpty(record.data.studentHealthDocumentUrl.length)) {
						    				if(record.data.studentHealthDocumentUrl.length>1) {					
						    					return '<a href=#>'+record.data.studentHealthDocumentUrl.length+'<a>';
						    				} else if(record.data.studentHealthDocumentUrl.length==1) {
						    					var newPath=record.data.studentHealthDocumentUrl[0].path;
						    					var newName=record.data.studentHealthDocumentUrl[0].name;
						    					var newValue=newName!=""?newName:newPath;
						    					var prefix = 'https://';
						    					if (newPath.substr(0, prefix.length) !== prefix){
//						    						s = prefix + s;
						    						return "<a href="+prefix+newPath+" target='_blank'>"+newValue;
						    					}else {
						    						return "<a href="+newPath+" target='_blank'>"+newValue;
						    					}
						    				} 
						    			}                        
						    		} 
						    	});
							}
							
						}
					} 
				});

				return columnsArray;
			},
			
	                 
});
