/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.transport.reports.JourneyAssignmentReportController', {
	//extend: 'Academia.controller.base.BaseController',
	extend: 'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
	//models: [],
	stores: ['transport.reports.DetailForEnum','transport.reports.DetailViewEnum',
	         'transport.reports.StopsName','transport.reports.UserTypeEnum','transport.vehicle.VehicleNo',
	         'transport.vehicle.TransServiceRouteUser','transport.route.RouteName','transport.serviceRoute.ServiceRouteName',
	         'transport.vehicle.JourneyAssignmentUserCount'],
	views: ['transport.reports.JourneyAssignmentReportStructure','transport.reports.JourneyAssignmentFilter',
	        'transport.reports.NumberOfUserCoveredReportGridWindow'],
    config: {
    			JOURNEY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('JOURNEY_REPORT_PRIVILEGES')  ,		  
    			JOURNEYREPORTDASHBOARD_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('JOURNEYREPORTDASHBOARD_PRIVILEGES')  		  

    },        
	 refs: [{
		 ref : 'journeyAssignmentFilter',
		 selector : 'journeyassignmentfilter' 
	 },{
		 ref : 'journeyAssignmentReportStructure',
		 selector : 'journeyassignmentreportstructure' 
	 },{
    	 ref: 'orgUnitForJourneyAssignment',
    	 selector: 'organizationunit[itemId=orgunitforjourneyassignment]'
	 },{
		 ref:'searchResultGridForUser',
		 selector:'searchresultgrid[itemId=searchresultgridforuser]'
	 },{
		 ref:'searchResultGridForConsolidated',
		 selector:'searchresultgrid[itemId=searchresultgridforconsolidated]'
	 },{
		 ref: 'organizationunit',
		 selector: 'organizationunit'
	 },{
		 ref:'numberofusercoveredreportgridwindow',
		 selector:'numberofusercoveredreportgridwindow'
	 },{
		 ref:'numberofusercoveredreportgrid',
		 selector:'numberofusercoveredreportgridwindow grid'
	 }],
	 
	 init: function(application) {
		 this.control({
			 'journeyassignmentfilter':{
				 render : this.setDefaultValue
			 },
			 'journeyassignmentfilter combo[itemId=detailFor]':{
				 select : this.getChangeFileds
			 },
			 'journeyassignmentfilter combo[itemId=detailView]':{
				 select : this.getConsolidated
			 },
			 'organizationunit[itemId=orgunitforjourneyassignment] radiogroup[itemId=organizationRadioUnitId]': {
				 change:function(obj,record){
					 this.organizationUnitChange(obj,record);
				 },
				 render:function(obj){
					 var permission = this.getJOURNEYREPORTDASHBOARD_PERMISSIONS();
	  		  			this.organizationUnitChange(obj,null,permission);
				 }
			 },
			 'organizationunit[itemId=orgunitforjourneyassignment] combo[itemId=multiselectAcademyLocationId]': {
				 change: function(obj) {
					 this.getLoadStores(obj);
				 }
			 },
			 'organizationunit[itemId=orgunitforjourneyassignment] combo[itemId=multiselectAcademyLocationId]': {
				 change: function(obj) {
					 this.getLoadStores(obj);
				 }
			 },
			 'organizationunit button[itemId=resetBtn]': {
				 click: this.resetOrganizationRadioUnit
			 },
			 'searchresultgrid[itemId=searchresultgridforuser]': {
				 render: function(grid) {
					 //grid.addButtonToolbar();
					 this.gridRenderFunction(grid);
					 this.genericCBGridAccessControlValidation(grid,this.getJOURNEY_REPORT_PERMISSIONS());
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated]': {
				 render: function(grid) {
					 // grid.addButtonToolbar();
					 //this.gridRenderFunction(grid);
					 //this.genericCBGridAccessControlValidation(grid,this.getJOURNEY_REPORT_PERMISSIONS());
				 }
			 },
				
			 'journeyassignmentfilter button[itemId=SearchBtn]':{
				 click : function(){
					 this.getLoadCommonGridData();
//					 var userGrid=this.getSearchResultGridForUser();
					 var consolidatedGrid=this.getSearchResultGridForConsolidated();
					 /*if(userGrid.isVisible()){
						 this.gridRenderFunctionForUser(userGrid);	 
					 }*/
					 if(consolidatedGrid.isVisible()){
						 this.gridRenderFunction(consolidatedGrid);
						 this.genericCBGridAccessControlValidation(grid,this.getJOURNEY_REPORT_PERMISSIONS());
					 }
				 }
			 },
			 
			 'journeyassignmentfilter combo[itemId=userType]':{
				 select : function(obj,record){
					 var form = obj.up('form');
					 var filterForm = this.getJourneyAssignmentFilter().getForm();
					 var ALIds = this.getAcademyLocationIds();
					 var route =filterForm.findField("route"); 
					 var serviceRoute =filterForm.findField("serviceRoute");
					 var vehicle =filterForm.findField("vehicle");
					 var stop =filterForm.findField("stop");
					 var usersId =filterForm.findField("usersId");
					 var dateTill =filterForm.findField("dateTill"); 
					 var dateFrom =filterForm.findField("dateFrom");
					 dateTill.reset();
					 dateFrom.reset();
					 route.reset();
					 serviceRoute.reset();
					 vehicle.reset();
					 stop.reset();
					 usersId.reset();
					 usersId.setDisabled(false);
					 usersId.clearValue();
					 usersId.store.removeAll();
					 usersId.clearAllDataFn();
					 var userType = record[0].get("id");
					 usersId.setFieldLabel(getCommonTranslation(userType)+': <span class="required" style="color:red"> *</span>');
					 this.setAllowBlank(usersId, false);					 
					 var orgUnit = this.getOrganizationunit();
					 var academyLocationID = orgUnit.down('#multiselectAcademyLocationId').getValue();
					 var userIdStore = form.down("#usersId").getStore();
					 userIdStore.removeAll();
					 var orgUnit = this.getOrganizationunit();
					 var academyLocationID = orgUnit.down('#multiselectAcademyLocationId').getValue();
                     if(!isNullOrEmpty(academyLocationID) && academyLocationID.length > 0 && !isNullOrEmpty(academyLocationID[0])) {
                    	 userIdStore.getProxy().extraParams = {
    						 academyLocationIds : ALIds,
    						 userType : userType
    					 };
                    	 userIdStore.load();
					 }
				 }
			 },
			 'journeyassignmentfilter button[itemId=cancelBtn]':{
				 click : this.resetFilter
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated]':{
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	                     var $this =this;
					  if (e.target.tagName == 'A') {
						  $this.getNumberOfServicedUserWin(record);
					  }
				 }
			 },
			//***********************Export for Report	  
			 'searchresultgrid[itemId=searchresultgridforuser] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForUser();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('USER_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_USER_CONFIG_CODE;
					 this.exportReportList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforuser] button[itemId=exportToPdfBtn] #exportPdfAll': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForUser();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('USER_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_USER_CONFIG_CODE;
					 this.exportReportList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforuser] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForUser();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('USER_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_USER_CONFIG_CODE;
					 this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforuser] button[itemId=exportToPdfBtn] #exportExcelAll': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForUser();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('USER_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_USER_CONFIG_CODE;
					 this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForConsolidated();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('CONSOLIDATED_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_CONSOLIDATED_CONFIG_CODE;
					 this.exportReportList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated] button[itemId=exportToPdfBtn] #exportPdfAll': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForConsolidated();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('CONSOLIDATED_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_CONSOLIDATED_CONFIG_CODE;
					 this.exportReportList(SERVERURL.PDFEXPORT,'pdf',true,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForConsolidated();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('CONSOLIDATED_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_CONSOLIDATED_CONFIG_CODE;
					 this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 'searchresultgrid[itemId=searchresultgridforconsolidated] button[itemId=exportToPdfBtn] #exportExcelAll': {
				 click: function() {
					 var searchResultGrid=this.getSearchResultGridForConsolidated();
					 var quickSearchForm = this.getJourneyAssignmentFilter();
			         var reportTitle=getCommonTranslation('CONSOLIDATED_VIEW');
					 var configCode = CONSTANTS.CB.TRANS_JOURNEY_ASSIGNMENT_REPORT_CONSOLIDATED_CONFIG_CODE;
					 this.exportReportList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode,reportTitle);
				 }
			 },
			 
			 'journeyassignmentreportstructure':{
		        	afterrender : function(structure){
		        		var this$ = this;
		        		var form = structure.down('form');
		        		form.body.on('scroll', function(e, target) {
					 		
		   				 	 var searchresultgridforuser = structure.down('#searchresultgridforuser');
		   					 var searchresultgridforconsolidated = structure.down('#searchresultgridforconsolidated');
		   					 
		   					 var grid = null;
		   					 if(!searchresultgridforuser.isHidden()){
		   						 grid = searchresultgridforuser;
		   					 }
		   					 if(!searchresultgridforconsolidated.isHidden()){
		   						 grid = searchresultgridforconsolidated;
		   					 }   					 

							//this$.getMultipleGridHeaderFreeze(grid,form);
		   				 });
		        	}
	    		}
		 });
	 },
	 setDefaultValue : function(obj){
		 var form = obj.up('form');
		 var detailFor = form.down("#detailFor");
		 var detailView = form.down("#detailView");
		 
		 detailFor.store.load({
			 callback : function(records, operation, success) {
				// detailFor.setValue('STOPS');
				 detailFor.setValue('STOP_LOCATIONS');
			 }
		 });
		 detailView.store.load({
			 callback : function(records, operation, success) {
				 detailView.setValue('USER_VIEW');
			 }
		 });
	 },
	 getChangeFileds : function(obj,record){
		 var form = obj.up('form');
		 var value = record[0].get("id");
		// var userType = form.down("#userType");
		 var vehicle = form.down("#vehicle");
		 var route = form.down("#route");
		 var serviceRoute = form.down("#serviceRoute");
		 var stop = form.down("#stop");
		 
		 route.setVisible(false);
		 serviceRoute.setVisible(false);
		 stop.setVisible(false);
		 vehicle.setVisible(false);
		 
		 route.reset();
		 serviceRoute.reset();
		 stop.reset();
		 vehicle.reset();
		 
		 switch(value) {
	    	case 'STOP_LOCATIONS' :{
	    		 stop.setVisible(true);
	    		break;
	    	}
	    	case 'ROUTES':{
	    		 route.setVisible(true);
	    		break;
	    	}
	    	case 'VEHICLES':{
	    		 vehicle.setVisible(true);
	    		break;
	    	}
	    	case 'SERVICE_ROUTES':{
	    		 serviceRoute.setVisible(true);
	    		break;
	    	}
		 }
	 },
	 getConsolidated : function(obj,record){
		 var form = obj.up('form');
		 var detailFor = form.down("#detailFor");
		 var detailView = form.down("#detailView");
		 
		 var value = record[0].get("id");

		 var userType = form.down("#userType");
		 var userId = form.down("#usersId");
		 var route = form.down("#route");
		 var serviceRoute = form.down("#serviceRoute");
		 var vehicle = form.down("#vehicle");
		 var stop = form.down("#stop");

		 route.setVisible(false);
		 serviceRoute.setVisible(false);
		 stop.setVisible(false);
		 userId.setVisible(false);
		 userType.setVisible(false);
		 vehicle.setVisible(false);
		 
		 route.reset();
		 serviceRoute.reset();
		 stop.reset();
		 userId.reset();
		 userType.reset();
		 vehicle.reset();
		 
		 var userGrid=this.getSearchResultGridForUser();
		 var consolidatedGrid=this.getSearchResultGridForConsolidated();
		 
		 userId.allowBlank=true;
		 userType.allowBlank=true;
		 
		 userGrid.setVisible(false);
		 consolidatedGrid.setVisible(false);

		 if(value=='CONSOLIDATED_VIEW'){
			 route.setVisible(true);
			 serviceRoute.setVisible(true);
			 stop.setVisible(true);
			 consolidatedGrid.setVisible(true);
			 vehicle.setVisible(true);
			 detailFor.setDisabled(true);
		 }else{
			 switch(detailFor.getValue()) {
		    	case 'STOP_LOCATIONS' :{
		    		 stop.setVisible(true);
		    		break;
		    	}
		    	case 'ROUTES':{
		    		 route.setVisible(true);
		    		break;
		    	}
		    	case 'VEHICLES':{
		    		 vehicle.setVisible(true);
		    		break;
		    	}
		    	case 'SERVICE_ROUTES':{
		    		 serviceRoute.setVisible(true);
		    		break;
		    	}
			 }
			 var alloBlank = ': <span class="required" style="color:red"> *</span>';
			 detailFor.setDisabled(false);
			 userId.allowBlank=false;
			 userType.allowBlank=false;
			 userId.labelSeparator='';
			 userType.labelSeparator='';
			 userId.setFieldLabel(getTransportTranslation('USER')+alloBlank);
			 userType.setFieldLabel(getTransportTranslation('USER_TYPE')+alloBlank);
			 userId.setVisible(true);
			 userType.setVisible(true);
			 userGrid.setVisible(true);
		 }
		 form.isValid();
		 form.getForm().clearInvalid();
	 },
	 getLoadStores : function(obj){
		 var form = this.getJourneyAssignmentFilter();
		 var ALIds = this.getAcademyLocationIds();
		 
		 var userId = form.down("#usersId");
		 var route = form.down("#route");
		 var serviceRoute = form.down("#serviceRoute");
		 var vehicle = form.down("#vehicle");
		 var stop = form.down("#stop");
		 var userType = form.down("#userType").getValue();
		 
		 var orgUnit = this.getOrganizationunit();
		 var academyLocationID = orgUnit.down('#multiselectAcademyLocationId').getValue();
		 var userIdStore = userId.getStore();
		 userIdStore.removeAll();
		 if(!isNullOrEmpty(userType) && !isNullOrEmpty(academyLocationID) && academyLocationID.length > 0 && !isNullOrEmpty(academyLocationID[0])) {
			 userIdStore.getProxy().extraParams = {
				 academyLocationIds : ALIds,
				 userType : userType
			 };
			 userIdStore.load();
		 }
		 route.getStore().getProxy().extraParams = {
			 academyLocationIds : ALIds
		 };
		 
		 serviceRoute.getStore().getProxy().extraParams = {
			 academyLocationIds : ALIds
		 };
		 
		 vehicle.getStore().getProxy().extraParams = {
			 academyLocationIds : ALIds
		 };
		 
		 stop.getStore().getProxy().extraParams = {
			 academyLocationIds : ALIds
		 };
	 },
	 gridRenderFunction: function(grid) {
		 grid.addExportButtonToolbar();
	 },
	/* gridRenderFunctionForConsolidated: function(grid) {
		 grid.addExportButtonToolbar();
	 },*/
	 getLoadCommonGridData: function() {
		 var form = this.getJourneyAssignmentFilter();
		 var searchForm = form.getForm();
		 var formValues = searchForm.getValues();
		 
		 var viewCode =null;
		 var searchResultGrid = null;
		 switch(formValues.detailView) {
	    	case 'USER_VIEW' :{
	    		viewCode = 'TRANS_JOURNEY_ASSIGNMENT_REPORT_USER';
	    	    searchResultGrid = this.getSearchResultGridForUser();
	    		break;
	    	}
	    	case 'CONSOLIDATED_VIEW':{
	    		viewCode = 'TRANS_JOURNEY_ASSIGNMENT_REPORT_CONSOLIDATED';
	    		searchResultGrid = this.getSearchResultGridForConsolidated();
	    		break;
	    	}
		 }
		 
    	 var jsonFormatFormData = this.getSearchJsonFormat(viewCode);
    	 var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	 resultViewUrl = resultViewUrl.concat(viewCode);
    	 searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	 return searchResultGrid;
     },
	 getSearchJsonFormat : function(respectiveLinkConfigCode){
		 var searchcriteria = new Array();
		 var values = new Object();
    	 values.configCode = respectiveLinkConfigCode;
    	 
		 var form = this.getJourneyAssignmentFilter();
		 var searchForm = form.getForm();
		 var formValues = searchForm.getValues();
		 
		 var stop = formValues.stop;
		 var user = formValues.usersId;
		 var route = formValues.route;
		 var serviceRoute = formValues.serviceRoute;
		 var vehicle = formValues.vehicle;
		 
		 var stopIds=[];
		 var userIds = [];
		 var routeIds = [];
		 var serviceRouteIds = [];
		 var vehicleIds = [];
		 
		 var VEHICLE_ID=null;
		 var SERVICE_ROUTE_ID=null;
		 var SERVICE_ROUTE_USER_ID=null;
		 var ROUTE_ID=null;
		 var SERVICE_ROUTE_USER_STOP_ID=null;
		 
		 if(!isEmpty(stop)){
			 Ext.Array.each(stop,function(value){
    			 if(Ext.isObject(value)){
    				 stopIds.push(value.get("value"));
    			 }else{
    				 stopIds.push(value);
    			 }
    		 });
			 var stopIdsArray = [];
			 for(var i=0; i<stopIds.length;i++) {
				 stopIdsArray.push(stopIds[i]);
			 }
			 
			 //var stopIdArr = Ext.encode(stopIds);
			 SERVICE_ROUTE_USER_STOP_ID = stopIds.join("','");
		 }
		
		 if(!isEmpty(user)){
			 Ext.Array.each(user,function(value){
    			 if(Ext.isObject(value)){
    				 userIds.push(value.get("value"));
    			 }else{
    				 userIds.push(value);
    			 }
    		 });
			 SERVICE_ROUTE_USER_ID = userIds.join("','");
		 }
		
		 if(!isEmpty(route)){
			 Ext.Array.each(route,function(value){
    			 if(Ext.isObject(value)){
    				 routeIds.push(value.get("id"));
    			 }else{
    				 routeIds.push(value);
    			 }
    		 });
			 ROUTE_ID = routeIds.join();
		 }
		 
		 if(!isEmpty(serviceRoute)){
			 Ext.Array.each(serviceRoute,function(value){
    			 if(Ext.isObject(value)){
    				 serviceRouteIds.push(value.get("id"));
    			 }else{
    				 serviceRouteIds.push(value);
    			 }
    		 });
			 SERVICE_ROUTE_ID = serviceRouteIds.join();
		 }
		 
		 if(!isEmpty(vehicle)){
			 Ext.Array.each(vehicle,function(value){
    			 if(Ext.isObject(value)){
    				 vehicleIds.push(value.get("id"));
    			 }else{
    				 vehicleIds.push(value);
    			 }
    		 });
			 VEHICLE_ID = vehicleIds.join();
		 }
		 
		 var VEHICLE_IDS = this.getJsonObject('VEHICLE_IDS', VEHICLE_ID);
    	 this.pushJsonObjectInArray(VEHICLE_IDS, searchcriteria);
    	 
    	 var SERVICE_ROUTE_IDS = this.getJsonObject('SERVICE_ROUTE_IDS', SERVICE_ROUTE_ID);
    	 this.pushJsonObjectInArray(SERVICE_ROUTE_IDS, searchcriteria);
    	 
    	 var SERVICE_ROUTE_USER_IDS = this.getJsonObject('SERVICE_ROUTE_USER_NAMES', SERVICE_ROUTE_USER_ID);
    	 this.pushJsonObjectInArray(SERVICE_ROUTE_USER_IDS, searchcriteria);
    	 
    	 var ROUTE_IDS = this.getJsonObject('ROUTE_IDS', ROUTE_ID);
    	 this.pushJsonObjectInArray(ROUTE_IDS, searchcriteria);
    	 
    	 var SERVICE_ROUTE_USER_STOP_IDS = this.getJsonObject('SERVICE_ROUTE_USER_STOP_NAMES', SERVICE_ROUTE_USER_STOP_ID);
    	 this.pushJsonObjectInArray(SERVICE_ROUTE_USER_STOP_IDS, searchcriteria);
    	 
    	 var FROM_DATE = this.getJsonObject('FROM_DATE', formValues.dateFrom);
    	 this.pushJsonObjectInArray(FROM_DATE, searchcriteria);
    	 
    	 var TILL_DATE = this.getJsonObject('TILL_DATE', formValues.dateTill);
    	 this.pushJsonObjectInArray(TILL_DATE, searchcriteria);
    	 
    	 values.searchCriterias = searchcriteria;
    	 return values;

	 },
	   getJsonObject: function(key, value, additionalValue) {
      	 if (value != '' && value != null && additionalValue == undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value]
      		 };
      	 } else if (value != '' && additionalValue != undefined) {
      		 return {
      			 "paramCode": key,
      			 "paramValues": [value, additionalValue]
      		 };
      	 }
       },
       pushJsonObjectInArray: function(object, array) {
      	 if (object) {
      		 array.push(object);
      	 }
       },
       resetOrganizationRadioUnit:function(){
    	     this.getOrganizationunit().getForm().reset();
    	     var alFld = Ext.ComponentQuery.query('#multiselectAcademyLocationId')[0];
    	     if (alFld && !isNullOrEmpty(alFld.defaultValueBeforeReset)) {
    	    	 alFld.setValue(alFld.defaultValueBeforeReset)
    	     }
    	     
       },
       exportReportList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode,reportTitle) {
    	   var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
    	   var searchCriteriaString=this.createSearchCriteriaStringDashboard(quickSearchForm);
    	   var jsonFormatFormData=this.getSearchJsonFormat(configCode);
    	   var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	   if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
    		   jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
    	   }
    	   searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
       },
       createSearchCriteriaStringDashboard: function(searchForm) {
	    	  var me=this;
	    	  var formValues = new Array();
	    	  formValues = searchForm.getValues();        
	    	  var searchCriteriaString="";
	    	  for (var key in formValues) {
	    		  var value = formValues[key];            
	    		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
	    			  var keyValueJsonObject = me.getJsonObject( key , value);
	    			  if(keyValueJsonObject.paramCode == "detailView"){
		    			  	keyValueJsonObject.paramCode=getTransportTranslation('REPORT_VIEW');
		    			  }else if(keyValueJsonObject.paramCode == "detailFor"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('REPORT_FOR');
		    			  }else if(keyValueJsonObject.paramCode == "userType"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('USER_TYPE');
		    			  }else if(keyValueJsonObject.paramCode == "usersId"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('USER');
		    			  }else if(keyValueJsonObject.paramCode == "stop"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('STOP_LOCATIONS');
		    			  }else if(keyValueJsonObject.paramCode == "dateFrom"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('DATE_FROM');
		    			  }else if(keyValueJsonObject.paramCode == "dateTill"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('DATE_TILL');
		    			  }else if(keyValueJsonObject.paramCode == "route"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('ROUTES');
		    			  }else if(keyValueJsonObject.paramCode == "serviceRoute"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('SERVICE_ROUTES');
		    			  }else if(keyValueJsonObject.paramCode == "vehicle"){
			    			  	keyValueJsonObject.paramCode=getTransportTranslation('VEHICLES');
		    			  }
	    			  if(!isNullOrEmpty(keyValueJsonObject)){
	    				  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";  
	    			  }
	    		  }
	    	  }
//	    	  searchCriteriaString="";
	    	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
	    	  return searchCriteriaString;
	      },
	      getNumberOfServicedUserWin : function(record){
		    	var transJourneyAssignmentId = record.get("JOURNEY_ASSIGNMENT_ID");
		    	var formWindow = this.getNumberofusercoveredreportgridwindow();
		    	if (!formWindow) {
		    		Ext.widget('numberofusercoveredreportgridwindow');
		    		formWindow = this.getNumberofusercoveredreportgridwindow();
		    	}
		    	var grid = this.getNumberofusercoveredreportgrid();
		    	var store = grid.getStore();
		    	store.getProxy().extraParams = {
		    		transJourneyAssignmentId: transJourneyAssignmentId
		    	};
		    	store.load();
		    	formWindow.show();
	   	},
	   	resetFilter : function(obj){
	   		var form = obj.up('form').getForm();
	   		var usersId = form.findField('usersId');
	   		form.getFields().each(function(field) {
	   			if(field.name != 'detailFor' && field.name != 'detailView') {
	   				form.reset();
	   			}
	   		});
	   		if(!isNullOrEmpty(usersId)){
	   			usersId.setDisabled(true);
		   		usersId.clearValue();
		   		usersId.store.removeAll();
		   		usersId.clearAllDataFn();
		   		usersId.setFieldLabel(getTransportTranslation('USER'));
	   		}
	   	}
});
