/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.transport.serviceRoute.ServiceRouteController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['transport.serviceRoute.DateExceptionSubmitData','transport.serviceRoute.VehicleLinkSubmitData',
	         'transport.serviceRoute.PeopleCoveredSubmitData','transport.serviceRoute.ServiceRouteTimeData',
	         'transport.serviceRoute.TimeDataModel'],
	stores: ['transport.serviceRoute.ServiceRouteMasterGrid','transport.vehicle.VehicleNo','transport.serviceRoute.ServiceRouteResponsableName',
	         'transport.route.RouteName','transport.route.LocationName','transport.serviceRoute.ServiceRouteForVehicle',
	         'transport.serviceRoute.ServiceRouteForUserCovered','transport.route.RouteMasterStore',
	         'examinationcenters.CenterType','transport.serviceRoute.InternalUser','transport.vehicle.VehicleYesNoEnum',
	         'transport.serviceRoute.DateExceptionGrid','transport.serviceRoute.VehicleStatus',
	         'transport.vehicle.VehicleGridData','transport.serviceRoute.PeopleCoveredGrid',
	         'transport.serviceRoute.ServiceRouteStop','transport.serviceRoute.WeekDays',
	         'transport.serviceRoute.ServiceRouteName','campaign.UserByAcademyLocation',
	         'common.AcademyLocationNameSeparated','transport.serviceRoute.ServiceOptaUser',
	         'transport.route.RouteInfoStore', 'transport.vehicle.TransportUserTypeStore', 'transport.route.RouteUserTypeStore',
	         'hostel.roomallocation.UserSmartSearchByUserType', 'transport.serviceRoute.RevisedVehicleStatusStore',
	         'transport.route.ServiceRouteUserByUserType','common.CountryStore','transport.route.AllLocationName','messaging.MessagingTemplatesStore',
	         'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore','importutility.ModuleName','hostel.importhostel.ImportHostelAllocation','transport.vehicle.VehicleSubType','transport.route.TransportProviderStore'],
	views: ['transport.serviceRoute.ServiceRouteStructure','transport.serviceRoute.ServiceRouteMasterGrid',
	        'transport.serviceRoute.ServiceRouteSearch','transport.serviceRoute.ServiceRoutesForUserCoveredGridWindow',
	        'transport.serviceRoute.ServiceRoutesForVehicleGridWindow','transport.serviceRoute.ServiceRouteDetailTabStructure',
	        'transport.serviceRoute.ServiceRouteDetailForm','transport.serviceRoute.DateExceptionGrid',
	        'transport.serviceRoute.DateExceptionWindow','transport.serviceRoute.VehicleServiceRouteLinkWindow',
	        'transport.serviceRoute.VehicleServiceRouteLinkGrid','transport.serviceRoute.PeopleCoveredGrid',
	        'transport.serviceRoute.PeopleCoveredWindow','transport.serviceRoute.AssignDriverDetailWindow','transport.serviceRoute.ServiceRouteSendMessages',
	        'transport.serviceRoute.ServiceRouteStaticDocumentAttachmentGrid','transport.serviceRoute.ServiceRouteSendMessages',
	        'transport.serviceRoute.ServiceRouteStaticDocumentAttachmentGrid','transport.serviceRoute.ServiceRouteDetailLoaderStructure',
	        'transport.serviceRoute.ImportServiceRouteDetailsForm','transport.serviceRoute.DownloadServiceRouteDetails','UploadOptionRadioGroup',
	        'transport.serviceRoute.ImportServiceRouteLoaderGrid'],
   config:{
	   		  TRANSPORT_SERVICE_ROUTE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_SERVICE_ROUTE_PRIVILEGES'),
	   		  TRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PRIVILEGES')
	       },       
    refs: [{
    	ref : 'contentPanel',
    	selector : 'contentpanel' 
    },{
    	ref : 'serviceRouteMasterGrid',
    	selector : 'serviceroutemastergrid' 
    },{
    	ref : 'serviceRouteSearch',
    	selector : 'serviceroutesearch' 
    },{
    	ref : 'serviceRouteStructure',
    	selector : 'serviceroutestructure' 
    },{
    	ref : 'serviceRoutesForVehicleGridWindow',
    	selector : 'serviceroutesforvehiclegridwindow'
    },{
    	ref : 'serviceRoutesForVehicleGrid',
    	selector : 'serviceroutesforvehiclegridwindow grid'
    },{
    	ref : 'serviceRoutesForUserCoveredGridWindow',
    	selector : 'serviceroutesforusercoveredgridwindow'
    },{
    	ref : 'serviceRoutesForUserCoveredGrid',
    	selector : 'serviceroutesforusercoveredgridwindow grid'
    },{
    	ref : 'serviceRouteDetailForm',
    	selector : 'serviceroutedetailform'
    },{
    	ref : 'serviceRouteDetailTabStructure',
    	selector : 'serviceroutedetailtabstructure'
    },{
    	ref : 'dateExceptionGrid',
    	selector : 'dateexceptiongrid'
    },{
    	ref : 'dateExceptionWindow',
    	selector : 'dateexceptionwindow'
    },{
    	ref : 'dateExceptionForm',
    	selector : 'dateexceptionwindow form'
    },{
    	ref : 'vehicleServiceRouteLinkWindow',
    	selector : 'vehicleserviceroutelinkwindow'
    },{
    	ref : 'vehicleServiceRouteLinkForm',
    	selector : 'vehicleserviceroutelinkwindow form'
    },{
    	ref : 'vehicleServiceRouteLinkGrid',
    	selector : 'vehicleserviceroutelinkgrid'
    },{
    	ref : 'peopleCoveredWindow',
    	selector : 'peoplecoveredwindow'
    },{
    	ref : 'peopleCoveredForm',
    	selector : 'peoplecoveredwindow form'
    },{
    	ref : 'peopleCoveredGrid',
    	selector : 'peoplecoveredgrid'
    },{
    	ref : 'assigndriverdetailwindow',
    	selector : 'assigndriverdetailwindow'
    },{
    	ref :'serviceroutesendmessages',
    	selector : 'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId]'
    },{
    	ref :'servicerRouteStaticDocumentAttachmentGrid',
    	selector : 'serviceroutestaticdocumentattachmentgrid [itemId=servicerRouteStaticDocumentAttachmentGridMessage]'
    },{
    	ref :'serviceroutesendmessages',
    	selector : 'serviceroutesendmessages'
    },{
    	ref :'serviceroutedetailloaderstructure',
    	selector :'serviceroutedetailloaderstructure'
    },{
    	ref :'importserviceroutedetailsform',
    	selector :'importserviceroutedetailsform'
    },{
    	ref :'downloadserviceroutedetails',
    	selector :'downloadserviceroutedetails'
    },{
    	ref :'uploadoptionradiogroup',
    	selector :'uploadoptionradiogroup'
    },{
    	ref :'importservicerouteloadergrid',
    	selector :'importservicerouteloadergrid'
    }],
    init: function(application) {
    	this.control({
    		'serviceroutesearch button[itemId=SearchBtn]':{
    			click : this.loadServiceRouteMasterGridData
    		},
    		'serviceroutesearch button[itemId=cancelBtn]':{
    			click : function(obj){
    				var form = obj.up('form').getForm();
    				form.reset();
    				var $this=this;
      		    	var academyLocationId = $this.getCurrentAcademyLocation();
      		    	var serviceNameField=form.findField('serviceName');
      		    	var serviceNameStore =serviceNameField.getStore();
      		    	serviceNameStore.getProxy().extraParams = {
      		        	academyLocationIds : academyLocationId
      		    	},
      		    	serviceNameStore.load();
      		    	
      		    	var periodFromField=form.findField('periodFrom');
      		    	var dateTillField=form.findField('dateTill');
      		    	
      		    	periodFromField.setMinValue(null);
      		    	periodFromField.setMaxValue(null);
      		    	dateTillField.setMinValue(null);
      		    	dateTillField.setMaxValue(null);
    			}
    		},
    		'serviceroutesearch':{
    			render : function(obj){
    				this.loadDataOnTheBasesOfAcademyLocation(obj);
    			}
    		},
    		'serviceroutemastergrid':{
    			render: function(grid){
    				var me = this;
    				me.doAccessControlValidation(grid, this.getTRANSPORT_SERVICE_ROUTE_PERMISSION());
 	            	var itemIdPrivilegeNameArray = [{"#btnRouteStoppageReportItemId" : "ROUTE_STOPPAGE_REPORT"}];
 	            	me.disableRadioGroupAndOtherPivileges(grid, me.getTRANSPORT_SERVICE_ROUTE_PERMISSION(), itemIdPrivilegeNameArray);
     			 },
     			afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getTRANSPORT_SERVICE_ROUTE_PERMISSION());
    				},1500);

    			},
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
    				
    				console.log(columnName);
    				if(columnName==='noOfVehicles'){
    					if (e.target.tagName == 'A') {
    						this.getNoOfVehicleDetails(record);
    					}
    				}else if(columnName==='noOfUsersCovered'){
    					if (e.target.tagName == 'A') {
    						this.getNoOfUserCovered(record);
    					}
    				}
    			},
    			selectionchange: function(column, selected,eOpts ){
                	this.disableEditViewDeleteBtnButton(column,selected);                	
                }
    		},
    		'serviceroutemastergrid button[itemId=btnAdd]':{
    			click : this.getOpenServiceRouteDetailForm
    		},
    		'serviceroutemastergrid button[itemId=btnEdit]' :{
    			click : this.getEditServiceRouteDetail
    		},
    		'serviceroutemastergrid button[itemId=btnView]' :{
    			click : this.getViewServiceRouteDetail
    		},
    		'serviceroutemastergrid button[itemId=btnDelete]' :{
    			click : this.getDeleteServiceRouteDetail
    		},
    		'serviceroutemastergrid splitbutton[itemId=btnRouteStoppageReportItemId] #PDFRouteStoppageReportItemId' :{
    			click : this.getServiceRouteStoppageDetail 
    		},
    		'serviceroutemastergrid splitbutton[itemId=btnRouteStoppageReportItemId] #ExcelRouteStoppageReportItemId' :{
    			click : this.getExcelServiceRouteStoppageDetail
    		},
    		'serviceroutedetailform':{
    			render : this.loadServiceRoteDetailDataOnTheBasesOfAcademyLocation
    		},
    		'serviceroutedetailform combo[itemId=route]':{
    			change : function(obj,record){
    				var form = obj.up('form');
    				var routeData = obj.displayTplData[0];
    				if(!isNullOrEmpty(routeData)){
    					/*var responsoblePerson=null;
    					if(!isNullOrEmpty(routeData.responsiblePersonName)){
    						responsoblePerson = routeData.responsiblePersonName;
    					}else if(!isNullOrEmpty(routeData.responsiblePersonNameExt)){
    						responsoblePerson = routeData.responsiblePersonNameExt;
    					}
    					form.down("#responsiblePersonName").setValue(responsoblePerson);
    					var isTrip = routeData.whetherRoundTrip;
    					if(isTrip==true){
    						form.down("#whetherRoundTrip").setValue(getTransportTranslation('YES'));
    					}else{
    						form.down("#whetherRoundTrip").setValue(getTransportTranslation('NO'));
    					}*/
    					//form.down("#startsFromItemId").setValue(routeData.wsStartLocation.locationName);
    					//form.down("#endsAtItemId").setValue(routeData.wsEndLocation.locationName);
    					//form.down("#academyLocationValue").setValue(routeData.academyLocation.value);
    					if(!isNullOrEmpty(routeData.wsStartLocation)){
    						form.down("#startsFromIdItemId").setValue(routeData.wsStartLocation.id);
    					}
    					if(!isNullOrEmpty(routeData.wsEndLocation)){
    						form.down("#endsAtIdItemId").setValue(routeData.wsEndLocation.id);
    					}
    					if(!isNullOrEmpty(routeData.academyLocation)){
    						form.down("#academyLocationId").setValue(routeData.academyLocation.id);
    					}
    				}
    			},
    			select : function(obj,record){
    				this.removeDynamicFields(obj);
    				this.getserviceRouteStopDetails(record[0].get("id"));
    			}
    		},
    		'serviceroutedetailform combo[itemId=userType]':{
    			select : function(obj,newValue){
    				data = newValue[0].data.id;
    				var form = obj.up('form');
    				var srpName = form.down("#serviceResponsiblePersonName");
    				var srpId = form.down("#responsiblePersonId");
    				srpId.getStore().removeAll();
    				
    				srpName.setVisible(false);
    				srpId.setVisible(false);
    				srpName.allowBlank=true;
    				srpId.allowBlank=true;
    				
    				srpName.labelSeparator = '';
    				srpId.labelSeparator = '';
    				
    				var allowblankFalse = getTransportTranslation('SERVICE_RESPONSIBLE_PERSON')+'<span class="required" style="color:red"> *</span>';
    				
    				if(data!=0){
    					srpName.reset();
    					srpId.setVisible(true);
    					srpId.allowBlank=false;
    					srpId.setFieldLabel(allowblankFalse);
    					srpId.getStore().load();
    				}else{
    					srpId.reset();
    					srpName.setVisible(true);
    					srpName.allowBlank=false;
    					srpName.setFieldLabel(allowblankFalse);
    				}
    			}/*,
    			select : function(obj,record){
    				var form = obj.up('form');
    				var srpName = form.down("#serviceResponsiblePersonName");
    				var srpId = form.down("#responsiblePersonId");

    				if(record[0].get("id")=='INTERNAL'){
    					srpName.reset();
    				}else{
    					srpId.reset();
    				}
    			}*/
    		},
    		'serviceroutedetailform customcombobox[itemId=responsiblePersonId]':{
    			render : function(combo){
    				combo.getStore().removeAll();
    				this.loadUserComboData(combo);
    			}
    		},
    		'serviceroutedetailform button[itemId=stopBtn]':{
    			click: function(obj){
    				this.addMultipleStops(obj);
        			this.showHideTimeFields(obj);

    			}
    		},
    		'serviceroutedetailform button[itemId=btnSave]':{
    			click: this.getSaveServiceRoute
    		},
    		'serviceroutedetailform button[itemId=btnReset]':{
    			click: function(obj){
    				obj.up('form').getForm().reset();
    				this.removeDynamicFields(obj);
    			}
    		},
    		'dateexceptiongrid':{
    			render : this.getRenderDateExceptionTab	
    		},
    		'dateexceptiongrid button[itemId=btnAdd]':{
    			click : this.getOpenDateExceptionDetail
    		},
    		'dateexceptiongrid button[itemId=btnEdit]':{
    			click : this.getEditDateExceptionDetail
    		},
    		'dateexceptiongrid button[itemId=btnView]':{
    			click : this.getViewDateExceptionDetail
    		},
    		'dateexceptiongrid button[itemId=btnDelete]':{
    			click : this.getDeleteDateExceptionDetail
    		},
    		'dateexceptionwindow customcombobox[itemId=originalStatus]':{
    			select : function(obj, record) {
    				var form = obj.up('form');
    				var id = record[0].data.id;
    				var revisedStatusCombo = form.down('#revisedStatus')
    				var revisedStatusStore = revisedStatusCombo.getStore();
    				revisedStatusCombo.reset();
    				revisedStatusStore.load({
    					callback : function(obj){
    						var revisedStatusValues = revisedStatusStore.getRange();
    						var index = revisedStatusStore.find('id',id);
    						revisedStatusStore.removeAt(index);
    						
    					}
    					});
    			}
    		},
    		'dateexceptionwindow customcombobox[itemId=revisedStatus]':{
    			render : function(combo) {
    				combo.getStore().removeAll();
    			}
    		},
    		'dateexceptionwindow button[itemId=SubmitBtn]':{
    			click : this.getSaveDateExceptionDetail
    		},
    		'dateexceptionwindow button[itemId=CancelBtn]':{
    			click : this.getCloseDateException
    		},
    		'vehicleserviceroutelinkgrid':{
    			render : this.getRenderVehicleServiceLinkTab	
    		},
    		'vehicleserviceroutelinkgrid button[itemId=btnAdd]':{
    			click : this.getOpenVehicleServiceLinkDetail
    		},
    		'vehicleserviceroutelinkgrid button[itemId=btnEdit]':{
    			click : this.getEditVehicleServiceLinkDetail
    		},
    		'vehicleserviceroutelinkgrid button[itemId=btnView]':{
    			click : this.getViewVehicleServiceLinkDetail
    		},
    		'vehicleserviceroutelinkgrid button[itemId=btnDelete]':{
    			click : this.getDeleteVehicleServiceLinkDetail
    		},
    		'vehicleserviceroutelinkwindow button[itemId=SubmitBtn]':{
    			click : this.getSaveVehicleServiceLinkDetail
    		},
    		'vehicleserviceroutelinkwindow button[itemId=CancelBtn]':{
    			click : this.getCloseVehicleServiceLink
    		},
    		'vehicleserviceroutelinkgrid menuitem[itemId=assignServiceRouteDriverDetail]':{
    			click : this.showAssignDriverWindow
    		},
    		'assigndriverdetailwindow button[itemId=CancelBtn]':{
    			click : this.closeAssignDriverDetailWindow
    		},
    		'assigndriverdetailwindow button[itemId=SubmitBtn]':{
    			click : this.saveAssignDriverDetailWindow
    		},
    		'assigndriverdetailwindow customcombobox[itemId=driverId]':{
    			render : function(combo){
    				combo.getStore().removeAll();
    				var serviceroutedetailform = this.getServiceRouteDetailForm();
    				var alCombo = serviceroutedetailform.down('#allAcademyLocationId');
    				var academyLocationId = alCombo.getValue();
    				var alIds = [];
    				var academyLocationIds = null;
    				if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    					for (var i in academyLocationId) {
    						if (Ext.isObject(academyLocationId[0])) {
    							alIds.push(academyLocationId[i].get("id"));
    						} else {
    							alIds.push(academyLocationId[i]);
    						}
    					}
    					academyLocationIds = alIds.join();
    					if(!isNullOrEmpty(combo.getStore())) {
    						combo.getStore().getProxy().extraParams = {
    							academyLocationIds : academyLocationIds,
    							userType: 5
    						};
    					}
    				}
    			}
    		},
    		'vehicleserviceroutelinkwindow combo[itemId=vehicleNo]':{
    			select : function(obj,record){
    				var form = obj.up('form');
    				form.down("#resourceCode").setValue(record[0].data.code);
    				/*var transServiceRouteId = this.getServiceRouteDetailForm().down('#transServiceRouteId').getValue();
    				var vehicleId = record[0].get("id");
    				var transServiceRouteVehicleId=null;
    				var grid = this.getVehicleServiceRouteLinkGrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    		      		var rec = grid.getSelectionModel().getSelection()[0];
    		      		 transServiceRouteVehicleId = rec.get("id");
    		      	}
    				Ext.Ajax.request({
		      			method: "GET",
		      			type: 'rest',
		      			url: SERVERURL.SERVICE_ROUTE_VEHICLE_UNIQUENESS,
		      			params: {
		      				transServiceRouteVehicleId:transServiceRouteVehicleId,
		      				vehicleId:vehicleId,
		      				transServiceRouteId:transServiceRouteId
		      			},
		      			success: function(f, action) {
		      				var data = Ext.JSON.decode(f.responseText);
		      				if(data==true){
		      					form.down("#resourceCode").setValue(record[0].get("vehicleCode"));
		      				}else{
		      					form.down("#vehicleNo").reset();
		      					showWarningMessage(getTransportTranslation('VEHICLE_LINKED'),getTransportTranslation('VEHICLE_ALREADY_EXIST')); //Please select a record
		      				}
		      			}
    				});*/
    			}
    		},
    		'serviceroutesendmessages': {
    			render: function(grid){
	            	var this$ = this;
	            	var docGrid = grid.down('#servicerRouteStaticDocumentAttachmentGridMessage');
	            	docGrid.getStore().removeAll();
	            	docGrid.getStore().sync();
	            	var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
  	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getTRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PERMISSION(), itemIdPrivilegeNameArray);
	            }
    		},
    		'peoplecoveredgrid':{
    			render : function(grid) {
    				this.doAccessControlValidation(grid, this.getTRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#sendMessageBtn" : "SEND_MESSAGE" , "#printBusPassStd" : "PRINT_BUS_PASS"}];
    				this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PERMISSION(), itemIdPrivilegeNameArray);
    				this.getRenderPeopleCoveredTab();
    				//var grid = this.getPeopleCoveredGrid();
		 	    	var sendButtonItemId = grid.down('#sendMessageBtn');
		 	    	var printBusPass = grid.down('#printBusPassStd');
		 	    	sendButtonItemId.setDisabled(true);
		 	    	printBusPass.setDisabled(true);
    			},
    			selectionchange: function(column, selected,eOpts ){
                	this.disableSendBtnButton(column,selected);                	
                }
    		},
    		
    		'peoplecoveredgrid button[itemId=btnAdd]':{
    			click : this.getOpenPeopleCoveredDetail
    		},
    		'peoplecoveredgrid button[itemId=btnEdit]':{
    			click : this.getEditPeopleCoveredDetail
    		},
    		'peoplecoveredgrid button[itemId=btnView]':{
    			click : this.getViewPeopleCoveredDetail
    		},
    		'peoplecoveredgrid button[itemId=btnDelete]':{
    			click : this.getDeletePeopleCoveredDetail
    		},
    		'peoplecoveredwindow button[itemId=SubmitBtn]':{
    			click : this.getSavePeopleCoveredDetail
    		},
    		'peoplecoveredwindow button[itemId=CancelBtn]':{
    			click : this.getClosePeopleCovered
    		},    		
    		'peoplecoveredwindow combo[itemId=userType]':{
    			select : function(obj,newValue){
    				var form = obj.up('form');
    				var userName = form.down("#userName");
    				var userId = form.down("#userId");
    				
    				userName.setVisible(false);
    				userId.setVisible(false);
    				userName.reset();
    				userId.reset();
    				userName.allowBlank=true;
    				userId.allowBlank=true;
    				userName.labelSeparator = '';
    				userId.labelSeparator = '';
    				
    				var allowblankFalse = getTransportTranslation('USER')+'<span class="required" style="color:red"> *</span>';
    				
    				if(newValue[0].data.id != 0){
    					userId.setVisible(true);
    					userName.setVisible(false);
    					//userId.allowBlank=false;
    					this.setAllowBlank(userId, false);
    					userName.allowBlank=true;
    					this.loadPeopleCoverWindowUserCombo(form);
    					//userId.setFieldLabel(allowblankFalse);
    				}else{
    					userId.setVisible(false);
    					userName.setVisible(true);
    				//	userName.allowBlank=false;
    					this.setAllowBlank(userName, false);
    					userId.allowBlank=true
    					userName.setFieldLabel('External');
    				}
    			}
    		},
    		'peoplecoveredwindow combo[itemId=userId]':{
    			select : function(obj,record){
    				var form = obj.up('form').getForm();
    				var servicerouteForm = this.getServiceRouteDetailForm();
    				var transServiceRouteId = servicerouteForm.down('#transServiceRouteId').getValue();
    				var userId = record[0].get("id");
    				var transServiceRouteUserId;
    				var grid = this.getPeopleCoveredGrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					var rec = grid.getSelectionModel().getSelection()[0];
    					transServiceRouteUserId = rec.get("id");
    				}
    				var params={
		    			 transServiceRouteUserId:transServiceRouteUserId,
		    			 userId:userId,
		    			 transServiceRouteId:transServiceRouteId
		    		 };
    				this.getUniqueCheckUser(obj,params);
    				
    				var startDate = servicerouteForm.down("#startDate").getValue();
    				var endDate = servicerouteForm.down("#endDate").getValue();
    				var activeDate = dateRender(record[0].get("activeDate"));
    				var inActiveDate = dateRender(record[0].get("inActiveDate"));
    				
    				if(activeDate){
    					if(startDate > activeDate){
    	    				form.findField('addtionEffectiveFrom').setMinValue(startDate);
    					}else if(startDate < activeDate){
    	    				form.findField('addtionEffectiveFrom').setMinValue(activeDate);
    					}
    				}
    				
    				if(inActiveDate){
    					if(endDate > inActiveDate){
    	    				form.findField('removalEffectiveForm').setMaxValue(endDate);
    					}else{
    	    				form.findField('removalEffectiveForm').setMaxValue(inActiveDate);
    					}
    				}
    			}
    		},
    		'peoplecoveredwindow textfield[itemId=userName]':{
    			blur : function(obj){
    				var form = obj.up('form').getForm();
    				var servicerouteForm = this.getServiceRouteDetailForm();
    				var transServiceRouteId = servicerouteForm.down('#transServiceRouteId').getValue();
    				var userName = obj.getValue();
    				var transServiceRouteUserId;
    				var grid = this.getPeopleCoveredGrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					var rec = grid.getSelectionModel().getSelection()[0];
    					transServiceRouteUserId = rec.get("id");
    				}
    				var params={
    						transServiceRouteUserId:transServiceRouteUserId,
    						userName:userName,
    						transServiceRouteId:transServiceRouteId
    				};
    				this.getUniqueCheckUser(obj,params);

    				var startDate = servicerouteForm.down("#startDate").getValue();
    				var endDate = servicerouteForm.down("#endDate").getValue();

    				if(startDate){
    					form.findField('addtionEffectiveFrom').setMinValue(startDate);
    				}
    				if(endDate){
    					form.findField('removalEffectiveForm').setMaxValue(endDate);
    				}
    			}
    		},
    		'serviceroutedetailform numberfield[itemId=endDistance]':{
    			change : function(obj){
    				var form = obj.up('form');
    				var value = obj.getValue();
    				form.down("#distanceInKmItemId").reset();
    				form.down("#distanceInKmItemId").setValue(value);
    			}
    		},
    		'serviceroutedetailform timefield[itemId=arrivalTime]':{
    			change : function(obj,record){
    				obj.nextSibling().setValue(record);
    				obj.nextSibling().setMinValue(obj.getValue());
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			}
    		},
    		'serviceroutesearch customcombobox[itemId=vehicleName]':{
  			  select:function(obj,rec){
  				var data=rec[0].data.id;  
  				var filterForm=obj.up('form');
  				var $this=this;
  		    	var academyLocationId = $this.getCurrentAcademyLocation();
  				var serviceName=filterForm.down('#serviceName');
  				serviceName.setDisabled(false);
  				serviceName.reset();
  				serviceName.getStore().getProxy().extraParams={
  					vehicleId:data,
  					academyLocationIds : academyLocationId
  				};
  		    	serviceName.getStore().load();
  			}
  		  },
    		'serviceroutedetailform timefield[itemId=startArrivalTime]':{
    			change : function(obj,record){
    				//obj.nextSibling().setValue(record);
    				obj.nextSibling().setMinValue(obj.getValue());
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			},
    			select:function(obj,record){ 
    				obj.nextSibling().setValue(record);
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			}
    		},
    		'serviceroutedetailform timefield[itemId=startTime]':{
    			select : function(obj,record){
    				var form = obj.up('form');
    				var arrivalTimeField = form.down("#startArrivalTime");
    				arrivalTimeField.setValue(form.down("#startTime").getValue());
    				arrivalTimeField.setMinValue(form.down("#startTime").getValue());
    			}
    		},
    		'serviceroutedetailform timefield[itemId=reachEndLocationAt]':{
    			select : function(obj,record){
    				var form = obj.up('form');
    				var departureTimeField = form.down("#startDepartureTime");
    				departureTimeField.setMinValue(form.down("#startTime").getValue());
    				departureTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());
    				var arrivalTimeField = form.down("#startArrivalTime");
    				arrivalTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());
    				
    				    var task = new Ext.util.DelayedTask(function(){
  						var fieldContainer=form.down('#endDistance');
  						fieldContainer.nextSibling().setMinValue(form.down("#startTime").getValue());
  						fieldContainer.nextSibling().setMaxValue(form.down("#reachEndLocationAt").getValue());
  						fieldContainer.nextSibling().nextSibling().setMinValue(form.down("#reachEndLocationAt").getValue());
  						fieldContainer.nextSibling().nextSibling().setMaxValue(form.down("#reachEndLocationAt").getValue());
  						fieldContainer.nextSibling().nextSibling().setValue(form.down("#reachEndLocationAt").getValue());
  					});
  					task.delay(500);
    			}
    		},
    		'serviceroutedetailform timefield[itemId=endArrivalTime]':{
    			change : function(obj,record){
    				var form = obj.up('form');
        		    obj.nextSibling().setValue(form.down("#reachEndLocationAt").getValue());
        		    obj.nextSibling().setMinValue(obj.getValue());
    			}
    		},
    		'serviceroutedetailform multiselectcombofield[itemId=allAcademyLocationId]':{
    			change : function(obj,newValue,oldValue){
    				var form = obj.up('form');
    				var academyLocationId = form.down("#academyLocationId").getValue();
    				var academyLocationIds=null;
    				var searchJson=[];
    				if(newValue.length>0){
    					for(var i in newValue){
    						searchJson.push(newValue[i]);
    					}
    				}
    				searchJson.push(academyLocationId);
					academyLocationIds=searchJson.join();
					
					var responsiblePersonCombo = form.down("#responsiblePersonId");
					var responsiblePersonComboStore= responsiblePersonCombo.getStore();
					if(newValue.length == 0) {
						responsiblePersonCombo.reset();
					}
					responsiblePersonComboStore.removeAll();
					responsiblePersonComboStore.load();
					
    				var store = this.getStore('transport.route.LocationName');
    				store.getProxy().extraParams = {
    					academyLocationIds : academyLocationIds
    				};
    				store.load();
    				if(oldValue){
    					if(oldValue.length > newValue.length){
    						if(!isNullOrEmpty(form.getForm().findField('id').getValue())){
    						showWarningMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'),getTransportTranslation('DELETE_THE_STOPS_MSSG')); 
    					}
    				 }
    				}
    			}
    		},
    		'serviceroutedetailform combo[itemId=recordStopListWithTimesId]':{
    			change : function(obj,newValue){
    				var form = obj.up('form').getForm();
    				Ext.suspendLayouts();
    				if(newValue=='NO'){
    					form.getFields().each(function(field) {
    						if(field.name == 'arrivalTime' || field.name == 'departureTime') {
    							field.setVisible(false);
    							field.setDisabled(true);
    							field.reset();
    							field.allowBlank=true;
    							Ext.resumeLayouts();
    							form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    						if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
    							field.setVisible(false);
    							field.setDisabled(true);
    							field.reset();
    							field.allowBlank=true;
    							Ext.resumeLayouts();
    							form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    					});
    				}else{
    					form.getFields().each(function(field) {
    						if(field.name == 'arrivalTime' || field.name == 'departureTime') {
    							field.setVisible(true);
    							field.reset();
    							field.setDisabled(false);
    							field.allowBlank=false;
    							Ext.resumeLayouts();
    							form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    						if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
    							field.setVisible(true);
    							field.setDisabled(false);
    							field.reset();
    							//field.allowBlank=false;
    							Ext.resumeLayouts();
    							form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    					});
    					var formTemp=obj.up('form');
    					var arrivalTimeField = formTemp.down("#startArrivalTime");
        				arrivalTimeField.setValue(formTemp.down("#startTime").getValue());
        				arrivalTimeField.setMinValue(formTemp.down("#startTime").getValue());
        				
        				var departureTimeField = formTemp.down("#startDepartureTime");
        				departureTimeField.setMinValue(formTemp.down("#startTime").getValue());
        				departureTimeField.setMaxValue(formTemp.down("#reachEndLocationAt").getValue());
        				var arrivalTimeField = formTemp.down("#startArrivalTime");
        				arrivalTimeField.setMaxValue(formTemp.down("#reachEndLocationAt").getValue());
        				
        				    var task = new Ext.util.DelayedTask(function(){
      						var fieldContainer=formTemp.down('#endDistance');
      						fieldContainer.nextSibling().setMinValue(formTemp.down("#startTime").getValue());
      						fieldContainer.nextSibling().setMaxValue(formTemp.down("#reachEndLocationAt").getValue());
      						fieldContainer.nextSibling().nextSibling().setMinValue(formTemp.down("#reachEndLocationAt").getValue());
      						fieldContainer.nextSibling().nextSibling().setMaxValue(formTemp.down("#reachEndLocationAt").getValue());
      						fieldContainer.nextSibling().nextSibling().setValue(formTemp.down("#reachEndLocationAt").getValue());
      					});
      					task.delay(500);
    					
    				}
    			}
    		},
    		'peoplecoveredwindow datefield[itemId=addtionEffectiveFrom]':{
    			change : function(obj,newValue){
    				var form = obj.up('form').getForm();
    				var id = form.findField('id').getValue();
    				if(isNullOrEmpty(id)){
    					if(!isNullOrEmpty(obj.getValue())){
    						obj.nextSibling().setValue(new Date());	
    					}else{
    						obj.nextSibling().reset();
    					}
    				}
    			}
    		},
    		'peoplecoveredwindow datefield[itemId=removalEffectiveForm]':{
    			change : function(obj,newValue){
    				var form = obj.up('form').getForm();
    				var id = form.findField('id').getValue();
    				if(isNullOrEmpty(id)){
    					if(!isNullOrEmpty(obj.getValue())){
    						obj.nextSibling().setValue(new Date());	
    					}else{
    						obj.nextSibling().reset();
    					}
    				}
    			}
    		},
    		
    		'serviceroutestructure':{
	        	afterrender : function(structure){
	        		var container = structure.items.items[0];
	        		var grid = container.down('serviceroutemastergrid');
	        		this.getGridHeaderFreeze(grid,structure,true);
	        	}
    		},
    		
    		/*Added for adhoc send message functionality*/
    		'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] radiogroup[itemId=messageType]':{
    			change : function(val,nV,oV){
    				this.selectSectionMessageType(val,nV,oV);
    			}
    		},
    		'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] customcombobox[itemId=msgTempletId]':{
    			select : function(obj,rec){
    				this.selectMessageTemp(obj,rec);
    			}
    		},
            'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] textarea[itemId=pushNotificationDiscription]':{
  	        	change : function(val,nV,oV){
  	        		var studentSendMessages = this.getServiceroutesendmessages();
  	        		var pushTextField = studentSendMessages.down('#pushNotificationDiscription');
  	        		var pushTextFieldDiscription = studentSendMessages.down('#pushNotificationDiscriptionNotice');
  	        		var maxLength = 1000;
  	        		var newValue = maxLength - pushTextField.getValue().length;
  	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	        	}
  	        },
    		'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] button[itemId=adhocMsgSubmitBtn]':{
    			click: function(obj) {
    				var grid = this.getPeopleCoveredGrid();
    				var studentsendmessage = this.getServiceroutesendmessages();
    				var wsMsgEventRecipientConfigsUpdated = [];
    				/*var wsMsgEventRecipientConfigsUpdated = [{ 
								                           	 	msgRecipientTypeId: 500,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            },{ 
								                           	 	msgRecipientTypeId: 600,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            }];*/
    				
    				var studArry = [];
	 	    		var facultyOtherUserArry = [];
	 	    		var isMultipleRecordSelect = false;
	 	    		if(grid.getSelectionModel().getCount() > 1) {
		 	    		grid.getSelectionModel().getSelection().forEach(function(rec, index, opt) {
		 	    			gridData = rec.data.user.userGroup.value;
		 	    			if(gridData == 'Student'){
		 	    				studArry.push(rec.data.id);
		 	    			}
		 	    			else{
		 	    				facultyOtherUserArry.push(rec.data.id);
		 	    			}
		 	    		});
		 	    		if(studArry.length>0 && facultyOtherUserArry.length>0){
		 	    			isMultipleRecordSelect = true;
		 	    		}
		 	    	}
	 	    		
    				var formData = obj.up('form').getValues();
    				
    				var sendMessageToOptions = formData.recieverType;
    				var isStudentChecked = false;
    				var isParentChecked = false;
    				var isFeePayerChecked = false;
    				
    				var isMySelfChecked = false;
    				//isMySelfChecked = sendMessageToOptions;
    				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    				
    				var formPnl = obj.up('form');
    				var fldValues = formPnl.getForm().getFieldValues();
    				if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false ){
  	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
  	        	    	return;
  	        	    }
    				
    				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
    					if(sendMessageToOptions.constructor === Array){
    						if(sendMessageToOptions.length > 0){
    							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
            						if(current_value == 1 || current_value == '1'){
            							isStudentChecked = true;
            						}
									if(current_value == 2 || current_value == '2'){
										isParentChecked = true;
									}
									if(current_value == 3 || current_value == '3'){
										isMySelfChecked = true;
										isFeePayerChecked = true;
									}
            					});
    						}
    					}else{
    						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
    							isStudentChecked = true;
    						}
							if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
								isParentChecked = true;
							}
							if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
								isMySelfChecked = true;
								isFeePayerChecked = true;
							}
    					}
    				}
    				
    				//var abc = xyz.c;
    				
    				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
    					//wsMsgEventRecipientConfigsUpdated = [];
    					var facultyGrp = grid.getSelectionModel().getSelection()[0].data.user.userGroup.value;
    					if(facultyGrp == 'Faculty'){
    						isStudentChecked = true;
    					}
    					studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
    				}else{
    					var recipientIds;
    						recipientIds = this.getAdhocServiceRouteRecipientIds(grid);
    						recipientIds = Ext.encode(recipientIds);
    						//typeId = 2;
    						//recipientId = 2;
    					
    					var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];
    					
    					/*if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
    						// Ajax Call to get Parent Ids by Admission Ids
    						
    						Ext.Ajax.request({
        						type: 'rest',
        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
        						jsonData: RecipientTypeCodes,
        						method: 'POST',
        						success: function(response) {
        							var RecipientTypeCodesData = Ext.decode(response.responseText);
        							
        							Ext.Ajax.request({
	            						type: 'rest',
	            						url:SERVERURL.PATH_FIND_PARENT_BY_STUDENTIDS,
	            						jsonData: recipientIds,
	            						method: 'POST',
	            						success: function(response) {
	            							// update wsMsgEventRecipientConfigsUpdated with parent ids
	            							var wsMsgEventRecipientConfigsParents = {
									            									msgRecipientTypeId: 66,
													                           	 	msgTemplateConfigId: 0,	//formData.id, 
													                           	 	selectiveRecipientIds: []
										            							};
	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
	            							}
	            							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
	            							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
	            							
	            							// Ajax Call to get Fee Payer Ids by Admission Ids
	            						   Ext.Ajax.request({
	    	            						type: 'rest',
	    	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
	    	            						jsonData: recipientIds,
	    	            						method: 'POST',
	    	            						success: function(response) {
	    	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
	    	            							var wsMsgEventRecipientConfigsFeePayer = {
			            									msgRecipientTypeId: 67,
							                           	 	msgTemplateConfigId: 0,	//formData.id, 
							                           	 	selectiveRecipientIds: []
				            							};
	    	            							
	    	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	    	            							}
	    	            							
	    	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
													wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
	    	            							studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked);
	    	            						}
	    	            					});
	            						}
	            					});
        						}
    						});
    					}else{*/ // Only one checkbox is selected
    						var urlNew = '';
    						if(isParentChecked) { // If Parent checkbox is selected
    							// url for getting parent ids
    							urlNew = SERVERURL.PATH_FIND_PARENT_BY_STUDENTIDS;
    						}
    						/*if(isFeePayerChecked) { // If Fee Payer checkbox is selected
    							// url for getting fee payer ids
    							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
    						}*/
    						
    						Ext.Ajax.request({
        						type: 'rest',
        						url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
        						jsonData: RecipientTypeCodes,
        						method: 'POST',
        						success: function(response) {
        							var RecipientTypeCodesData = Ext.decode(response.responseText);
        							if(!isNullOrEmpty(urlNew)){
        								Ext.Ajax.request({
    	            						type: 'rest',
    	            						url: urlNew,
    	            						jsonData: recipientIds,
    	            						method: 'POST',
    	            						success: function(response) {
    	            							if(isParentChecked) { // If Parent checkbox is selected
    	            								// update wsMsgEventRecipientConfigsUpdated with parent ids
    	            								var wsMsgEventRecipientConfigsParents = {
    		            									msgRecipientTypeId: 66,
    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
    						                           	 	selectiveRecipientIds: []
    			            							};
    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
        	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
        	            							}
    												wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
    	                						}
    	            							/*if(isFeePayerChecked) { // If Fee Payer checkbox is selected
    	                							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
    	            								var wsMsgEventRecipientConfigsFeePayer = {
    		            									msgRecipientTypeId: 67,
    						                           	 	msgTemplateConfigId: 0,	//formData.id, 
    						                           	 	selectiveRecipientIds: []
    			            							};
    	            								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
    	            									wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
        	            							}
        	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
    												wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
    	                						}*/
    	            							if(isMultipleRecordSelect && !isStudentChecked){
    	            								studentsendmessage.sendMessageForMultipleUserType(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
    	            							}
    	            							else{
    	            								studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);	
    	            							}
    	            						}
    	            					});

        							}else{
        								studentsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId);
        							}
        							
        						}
    						});
    						
    					}
    					//studentsendmessage.sendMessage(obj,grid);
    				}
    				
    			//}
    		},
    		/*V2D-13247*/
    		'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] textarea[itemId=smsDiscription]':{
    			change : function(val,nV,oV){
    				var studentsendmessage = this.getServiceroutesendmessages();
    				var smsTextField = studentsendmessage.down('#smsDiscription');
    				var smsTextFieldDiscription = studentsendmessage.down('#smsDiscriptionNotice');
    				var maxLength = localStorage.getItem('maxLength');
    				var newValue = maxLength - smsTextField.getValue().length;
    				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    			}
    		},
    		'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId]  filefield[itemId=staticUploadFileField]': {
    			change: function(fileField, value, eOpts){
    				var this$ = this;
    				//value = value.replace('C:\\fakepath\\', '');
    				this$.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
    			}
    		},
    		'serviceroutestaticdocumentattachmentgrid[itemId=servicerRouteStaticDocumentAttachmentGridMessage] actioncolumn': {
    			click : function(view, rowIndex, colIndex, item, e, record, row){
    				this.deleteServiceRouteStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
    			}
    		},'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId]': {
    			render: function(grid){
    				var this$ = this;
    				var docGrid = grid.down('#servicerRouteStaticDocumentAttachmentGridMessage');
    				docGrid.getStore().removeAll();
    				docGrid.getStore().sync();
    			}
    		}, 'serviceroutesendmessages[itemId=serviceRouteSendMessagesItemId] radiogroup#sendingPriority': {
    			change: function( radio, newValue, oldValue, eOpts) {
    				this.loadAdhocServiceRouteScheduleField(radio, newValue, oldValue);
    			}
    		},
    		'peoplecoveredgrid button[itemId=sendMessageBtn]': {
    			click: this.openStudentSendMessage
    		},
    		'serviceroutedetailform button[itemId=fromSchlStopBtn]':{
    			click: function(obj){
    				this.fromSchlAddMultipleStops(obj);
        			this.showHideTimeFields(obj);

    			}
    		},
    		'serviceroutedetailform timefield[itemId=fromSchlStartArrivalTime]':{
    			change : function(obj,record){
    				obj.nextSibling().setValue(record);
    				obj.nextSibling().setMinValue(obj.getValue());
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			}
    		},
    		'serviceroutedetailform timefield[itemId=fromSchlEndArrivalTime]':{
    			change : function(obj,record){
    				obj.nextSibling().setMinValue(obj.getValue());
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			}
    		},
    		'serviceroutedetailform timefield[itemId=fromSchlArrivalTime]':{
    			select : function(obj,record){
    				obj.nextSibling().setValue(record);
    				obj.nextSibling().setMinValue(obj.getValue());
    				if(obj.nextSibling().isValid()){
    					obj.nextSibling().clearInvalid();
    				}
    			}
    		},
    		/*'serviceroutedetailform combo[itemId=recordStopListWithTimesId]':{
    			change : function(obj,newValue){
    				var form = obj.up('form').getForm();
    				Ext.suspendLayouts();
    				if(newValue=='NO'){
    					form.getFields().each(function(field) {
    						if(field.name == 'arrivalTime' || field.name == 'departureTime') {
    							field.setVisible(false);
    							field.reset();
    							field.allowBlank=true;
    							Ext.resumeLayouts();
    							form.isValid(); 
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    						if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
    							field.setVisible(false);
    							field.reset();
    							//field.allowBlank=true;
    							Ext.resumeLayouts();
    							//form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    					});
    				}else{
    					form.getFields().each(function(field) {
    						if(field.name == 'arrivalTime' || field.name == 'departureTime') {
    							field.setVisible(true);
    							field.allowBlank=false;
    							Ext.resumeLayouts();
    							form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 
    						if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
    							field.setVisible(true);
    							//field.allowBlank=false;
    							Ext.resumeLayouts();
    							//form.isValid();
    							form.checkValidity();
    							form.clearInvalid();
    						} 

    					});
    				}
    			}
    		}*/
    		'serviceroutedetailloaderstructure radiogroup[itemId=bulkImportGroupItemId]':{
    			change  : function(obj,newValue,oldValue){
					var form = obj.up('serviceroutedetailloaderstructure');	 
					var value = obj.getValue();
					var downAllocationform = form.down('downloadserviceroutedetails');
					var importAllocationform = form.down('importserviceroutedetailsform');
					var importList = form.down('importservicerouteloadergrid');

					downAllocationform.setVisible(false);
					importAllocationform.setVisible(false);
					importList.setVisible(false);

					if(value.downloadUploadTemplate=='forDownloadTemplate'){
						downAllocationform.setVisible(true);
					}else if(value.downloadUploadTemplate=='forUploadTemplate'){
						var uploadoptionradiogroupform  = this.getUploadoptionradiogroup();
						uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
							isUploadAll: false
						});
						importAllocationform.setVisible(true);
						importList.setVisible(true);
					}
				}
    		},
    		'downloadserviceroutedetails button[itemId=serviceRouteDownoladBtnId]':{
				click: function(obj){
					 var $this = this;
					 var csvForm = Ext.create('Ext.form.Panel'); 
					 var grid = $this.getServiceRouteMasterGrid();
					 var records = grid.getSelectionModel().getSelection()[0];
			     	var formServiceRoute= this.getServiceRouteDetailForm();
			   var academyLocationId  =	formServiceRoute.getForm().findField('academyLocations').getValue();
			   var academyLocations =  $this.unique(academyLocationId);
					 csvForm.getForm().submit({
						 target: '_blank',
						 method:'POST',
						 params :{
							 access_token : Ext.Ajax.defaultHeaders.access_token,
							 academyLocationId:academyLocations,
							 trnasservieRouteId: records.get("id"),
							 //serviceName: records.get("serviceName")
						 },
						 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						 url: SERVERURL.DOWNLOAD_TRANS_PERSON_COVERD_LOADER_TEMPLATE,
						 standardSubmit :true
					 });
				}
			},
			'importserviceroutedetailsform button[itemId=SubmitBtn]':{
				click: function(obj){
					var temForm = obj.up('importserviceroutedetailsform');
			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
			    	var $this=this;
			    	var grdStore;
			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	            $this.getHashOfFile(temForm);
		            setTimeout(function() {
				    	temForm.getForm().submit({
				    		method : 'POST',
				    		url : submitUrl,
				    		success : function(form, action){
					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        	temForm.getForm().isValid();
				    		},
				    		failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				    	    }
				    	});
		        	},1000);
			    	Ext.defer(function() {
			    		$this.loadImportServiceRouteGrid();
			    	}, 2000, this);
					
				}
			},
			'importserviceroutedetailsform':{
				render: function(obj){
					var $this = this;
					var temForm = $this.getImportserviceroutedetailsform();
					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
					//var grid = $this.getServiceRouteMasterGrid();
					var grid = $this.getImportservicerouteloadergrid();
					var form = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_TRANSPORT_PERSON_COVERD');
					tempFormValue.getStore().load({
						callback:function(record){
							for(var i in record){
								if(record[i].data.value == 'Transport-Person Coverd'){
									tempFormValue.setValue(record[i].data.id);
									tempFormValue.setReadOnly(true);
								}
							}
						}
					});
				}
			},
			'importservicerouteloadergrid button[itemId=btnForce]':{
				 click : function(obj) {
					 var grid = this.getImportservicerouteloadergrid();
		            	if (grid.getSelectionModel().getCount() > 0) {
		            		if(grid.getSelectionModel().getCount() > 1){
			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			        		}else{
			        			var this$ = this;
	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
	 	                	var urlAppend="?jobName="+id;
	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	 	    	        	Ext.Ajax.request({
	 	    	        		url: submitURL,
	 	    	        		method: 'GET',
	 	    	        		success: function(response) {
	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	 	    	        				//console.log("Manual trigger hit");
	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	 	    	        			}else if(response.responseText==="SUCCESS"){
	 	    	        				//console.log("Manual trigger hit");
	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 	    	        			}
	 	    	        		}
	 	    	        	});
			        		}
		            	} else {
		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            	}  
		            }
			 },
			 'peoplecoveredgrid button[itemId=printBusPassStd]': {
	    			click: this.studentPrintBusPass
	    	  },
			 'importservicerouteloadergrid':{
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						if (e.target.tagName == 'A') {
							var fileType=null;
							if(cellIndex==1){
								fileType='successFile';
							}else if(cellIndex==6){
								fileType='errorFile';
							}else if(cellIndex==7){
								fileType='logFile';
							}
							var documentId = record.get("id");
							if (!isNullOrEmpty(documentId)) {
								this.getDownloadFile(documentId,fileType);
							}
						}
					}
				},
    	  });
       },
	    /**
	     * Load Master grid
	     */
	    loadServiceRouteMasterGridData:function(obj){
	    	var $this=this;
	    	var form = obj.up('form');
	    	var getForm = form.getForm();
	    	var getFormValues=getForm.getValues();
	    	
	    	var grid=$this.getServiceRouteMasterGrid();
	    	var store = grid.getStore();
	    	
	    	var academyLocationId = this.getCurrentAcademyLocation();
	    	
	    	store.getProxy().extraParams = {
	    		academyLocationIds : academyLocationId,
	    		vehicleNumber : form.down("#vehicleName").getRawValue(),
	    		routeName : form.down("#routeName").getRawValue(),
	    		startLocationId : getFormValues.startLocationId,
	    		endLocationId : getFormValues.endLocationId,
	    		routeDistanceGreater : getFormValues.distanceFrom,
	    		routeDistanceSmaller : getFormValues.distanceTo,
	    		serviceName:form.down("#serviceName").getRawValue(),
	    		responsiblePersonName : form.down("#responsiblePersonName").getRawValue(),
	    		distanceGreater:getFormValues.distanceGreater,
	    		distanceSmaller : getFormValues.distanceSmaller,
	    		startTimeGreater:getFormValues.startTimeGreater,
	    		startTimeSmaller : getFormValues.startTimeSmaller,
	    		reachTimeGreater :getFormValues.reachTimeGreater,
	    		reachTimeSmaller:getFormValues.reachTimeSmaller,
	    		MinCapacity:getFormValues.MinCapacity,
	    		MaxCapacity : getFormValues.MaxCapacity,
	    		periodFrom : getFormValues.periodFrom,
	    		dateTill : getFormValues.dateTill,
	    		routeId:form.down("#routeName").getValue(),
	    		transportProviderId:form.down("#transportProviderName").getValue(),
	    		vehicleTypeId:getFormValues.subType
	    	},
	    	$this.resetPageSetting(store);
	    	store.load();
	    	grid.getSelectionModel().deselectAll(true);
	    },
	    /**
	     * Load combo on the bases of academy location id (it is also used in create route also)
	     */
	    loadDataOnTheBasesOfAcademyLocation:function(obj){
	    	var $this=this;
	    	var academyLocationId = $this.getCurrentAcademyLocation();
	    	
	    	var routeSearchForm=obj.getForm();
	    	var vehicleNameField=routeSearchForm.findField('vehicleName');
	    	var vehicleNameStore =vehicleNameField.getStore();
	    	vehicleNameStore.getProxy().extraParams = {
	        	academyLocationIds : academyLocationId
	    	},
	    	vehicleNameStore.load();    
	    	
	    	var routeNameField=routeSearchForm.findField('routeName');
	    	var routeNameStore =routeNameField.getStore();
	    	routeNameStore.getProxy().extraParams = {
	        	academyLocationIds : academyLocationId
	    	},
	    	routeNameStore.load();  
	    	
	    	var serviceNameField=routeSearchForm.findField('serviceName');
	    	var serviceNameStore =serviceNameField.getStore();
	    	serviceNameStore.getProxy().extraParams = {
	        	academyLocationIds : academyLocationId
	    	},
	    	serviceNameStore.load();
	    	
	    	var responsiblePersonName=routeSearchForm.findField('responsiblePersonName');
	    	var responsiblePersonNameStore =responsiblePersonName.getStore();
	    	responsiblePersonNameStore.getProxy().extraParams = {
	        	academyLocationIds : academyLocationId
	    	},
	    	responsiblePersonNameStore.load();  
	    },
	    loadServiceRoteDetailDataOnTheBasesOfAcademyLocation:function(obj){
	    	var $this=this;
	    	var academyLocationId = $this.getCurrentAcademyLocation();
	    	var form=obj.getForm();
	    	var field=form.findField('route');
	    	var fieldStore =field.getStore();
	    	fieldStore.getProxy().extraParams = {
	        	status : true,
	        	academyLocationId:academyLocationId
	    	},
	    	fieldStore.load();
	    	
	    	//$this.getStore('transport.route.LocationName').load();
	    	
	    	var recordStopListField=form.findField('recordStopListWithTimes');
	    	recordStopListField.getStore().load({
	    		callback : function(rec,operation,success){
	    			recordStopListField.setValue('YES');		      							
	    		}
	    	});
	    },
	    /**
	     * get no of vehicle on service routes
	     */
	    getNoOfVehicleDetails : function(record){
	    	var transServiceRouteId = record.get("id");
	    	var formWindow = this.getServiceRoutesForVehicleGridWindow();
	    	if (!formWindow) {
	    		Ext.widget('serviceroutesforvehiclegridwindow');
	    		formWindow = this.getServiceRoutesForVehicleGridWindow();
	    	}
	    	var grid = this.getServiceRoutesForVehicleGrid();
	    	var store = grid.getStore();
	    	store.getProxy().extraParams = {
	    		transServiceRouteId: transServiceRouteId
	    	};
	    	store.load();
	    	formWindow.show();
	    },
	    /**
	     * get no of user covered on service routes
	     */
	    getNoOfUserCovered : function(record){
	    	var transServiceRouteId = record.get("id");
	    	var formWindow = this.getServiceRoutesForUserCoveredGridWindow();
	    	if (!formWindow) {
	    		Ext.widget('serviceroutesforusercoveredgridwindow');
	    		formWindow = this.getServiceRoutesForUserCoveredGridWindow();
	    	}
	    	var grid = this.getServiceRoutesForUserCoveredGrid();
	    	var store = grid.getStore();
	    	store.getProxy().extraParams = {
	    		transServiceRouteId: transServiceRouteId,
	    		usageStatus:'YES'
	    	};
	    	formWindow.show();
	    	store.load();
	    	//formWindow.show();	
	    },
	    /**
	     * common function for open vehicle detail form 
	     */
	    getOpenServiceRouteDetailForm : function(){
	    	
	     var contentpanel = this.getContentPanel();
	   	 var structure = Ext.widget('serviceroutedetailtabstructure');
	   	 var tabName = getTransportTranslation('SERVICE_ROUTE_DETAILS');

	   	 var getcontroller=this.getController('menu.CoreERPNavigationController');
	   	 var getTab=getcontroller.getTab(tabName);
	   	 if(getTab!=null){
	   		 contentpanel.remove(getTab, true);
	   	 }
	   	 openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_ELEVEN);
	   	 
	   	structure.body.scrollTo('top', 0);
	    },
	    /**
	     * get Route details 
	     */
	    getserviceRouteStopDetails : function(routeId){
	    	var $this = this;
	    	var form = $this.getServiceRouteDetailForm();
	    	var getForm = form.getForm();
	    	Ext.Ajax.request({
	    		method: "GET",
	    		type: 'rest',
	    		url: SERVERURL.STOP_EDIT_URL,
	    		headers: {
	    			'Content-Type': 'application/json'
	    		},
	    		params: {
	    			routeId: routeId
	    		},
	    		success: function(resp, action) {
	    			var data = resp.responseText;
	    			var  stopjData=Ext.JSON.decode(data);
	    			var fieldContainerIndex=1;
	    			form.down("#startLocation").getStore().load();
	    			Ext.Array.each(stopjData.rows,function(value,index){
	    				var fieldContainer=form.down('#serviceStopPanelId');
	    				/**
	    				 * Load start Location and distance
	    				 * startLocationField is fetch to send in addmultipleStops functionality to create multiple stops.
	    				 */
	    				var startLocationField= form.down("#startLocation");
	    				if(value.routeStopType==getTransportTranslation('START')){
	    					startLocationField.setValue(value.routeLocation.id);
	    					form.down("#startDistance").setValue(value.distanceOnward);
	    				}
	    				/**
	    				 * Load End Location and distance
	    				 */
	    				if(value.routeStopType==getTransportTranslation('END')){
	    					form.down("#endLocation").setValue(value.routeLocation.id);
	    					form.down("#endDistance").setValue(value.distanceOnward);
	    				}

	    				if(value.routeStopType==getTransportTranslation('TRANSPORT_INTERMEDIATE')){
	    					$this.addMultipleStops(startLocationField);	 
	    					/**
	    					 * It is used to delay task 
	    					 */
	    					var task = new Ext.util.DelayedTask(function(){
	    						var currentFieldContainer=fieldContainer.items.items[fieldContainerIndex];
	    						currentFieldContainer.items.items[1].setValue(value.routeLocation.id);
	    						currentFieldContainer.items.items[2].setValue(value.distanceOnward);
	    						fieldContainerIndex=fieldContainerIndex+1;
	    					});
	    					task.delay(1000);
	    				}
	    			});
	    			
	    			
	    			/*================ From School tab data ===============*/
	    			
	    			var fieldContainerIndex1=1;
	    			var reverseData = stopjData.rows.reverse();
	    			Ext.Array.each(reverseData,function(value,index){
	    				var fromSchFieldContainer=form.down('#fromSchlServiceStopPanelId');
	    				/**
	    				 * Load start Location and distance
	    				 * startLocationField is fetch to send in addmultipleStops functionality to create multiple stops.
	    				 */
	    				var fromSchlstartLocationField= form.down("#fromSchlStartLocation");
	    				if(value.routeStopType==getTransportTranslation('START')){
	    					fromSchlstartLocationField.setValue(value.routeLocation.id);
	    					form.down("#fromSchlStartDistance").setValue(value.distanceOnward);
	    				}
	    				/**
	    				 * Load End Location and distance
	    				 */
	    				var fromSchlEndLocation= form.down("#fromSchlEndLocation");
	    				if(value.routeStopType==getTransportTranslation('END')){
	    					form.down("#fromSchlEndLocation").setValue(value.routeLocation.id);
	    					form.down("#fromSchlEndDistance").setValue(value.distanceOnward);
	    				}

	    				if(value.routeStopType==getTransportTranslation('TRANSPORT_INTERMEDIATE')){
	    					$this.fromSchlAddMultipleStops(fromSchlEndLocation);	 
	    					/**
	    					 * It is used to delay task 
	    					 */
	    					var task = new Ext.util.DelayedTask(function(){
	    						var frmSchlCurrentFieldContainer=fromSchFieldContainer.items.items[fieldContainerIndex1];
	    						frmSchlCurrentFieldContainer.items.items[1].setValue(value.routeLocation.id);
	    						frmSchlCurrentFieldContainer.items.items[2].setValue(value.distanceOnward);
	    						fieldContainerIndex1=fieldContainerIndex1+1;
	    					});
	    					task.delay(1000);
	    				}
	    			});
	    			
	    		}
	    	});	
	    },
	    getIdValueJson: function(id, value) {
			if (id) return {
				id: id,
				value: value
			};
	    },
	    /**
	     * Save service route data
	     */
	    getSaveServiceRoute:function(){
	    	var $this = this;
	    	var tabStructure = $this.getServiceRouteDetailTabStructure();
	    	var grid = $this.getServiceRouteMasterGrid();
	    	var form = $this.getServiceRouteDetailForm();
	    	var getForm=form.getForm();

//	    	if(getForm.isValid()){
	    	var formValues=getForm.getValues();
	    	var routeName = form.down("#route").getRawValue();
	    	var academyLocationId = form.down("#academyLocationId").getValue();
	    	var timeRecordForStops=null;
	    	if(formValues.recordStopListWithTimes=="YES"){
	    		timeRecordForStops=true;
	    	}else if(formValues.recordStopListWithTimes=="NO"){
	    		timeRecordForStops=false; 
	    	}

	    	var isActiveValue=null;
	    	if(formValues.isActive=="YES"){
	    		isActiveValue=true;
	    	}else if(formValues.isActive=="NO"){
	    		isActiveValue=false; 
	    	}
	    	var weekdays=[];
	    	var runOnDays = formValues.runOnDays;
	    	if(Ext.isObject(runOnDays[0])){
	    		for(var i in runOnDays){
	    			weekdays.push(runOnDays[i].get("value"));
	    		}
	    	}else{
	    		weekdays = runOnDays;
	    	}

	    	var academyLocations=[];
	    	var academyLocation = formValues.academyLocations;
	    	if(academyLocation){
	    		if(Ext.isObject(academyLocation[0])){
	    			for(var i in academyLocation){
	    				academyLocations.push(academyLocation[i].get("id"));
	    			}
	    		}else{
	    			academyLocations = academyLocation;
	    		}
	    	}
	    	//academyLocations.push(academyLocationId);
	    	var uniqueresultArr =  $this.unique(academyLocations);
	    	var submitUrl;
	    	var message;
	    	if (formValues.id == null || formValues.id == "") {
	    		submitUrl = SERVERURL.SERVICE_ROUTE_CREATE_URL;
	    		message = getTransportTranslation('SERVICE_ROUTE_SUCCESFULLY_CREATED');
	    	} else {
	    		submitUrl = SERVERURL.SERVICE_ROUTE_UPDATE_URL;
	    		message = getTransportTranslation('SERVICE_ROUTE_SUCCESFULLY_UPDATED');
	    	}

	    	/**
	    	 * Json for stop
	    	 */
	    	var stopContiner = form.down('#serviceStopPanelId');
	    	var stopFieldsCount = stopContiner.items.length;
	    	var stopArray=new Array();
	    	var endJson=null;
	    	var fieldSequence=1;
	    	//if(stopFieldsCount>1){
	    		for(var j=0; j<stopContiner.items.length; j++){
	    			var stopPanelContainer=stopContiner.items.items[j];
	    			if(stopPanelContainer.items.items[5].getValue()=="START"){
	    				stopArray.push({
	    					"sequence" : j+1,
	    					"id":stopPanelContainer.items.items[0].getValue(),
	    					"transServiceRoute":$this.getIdValueJson(routeId),
	    					"stopLocation":$this.getIdValueJson(stopPanelContainer.items.items[1].getValue()),
	    					"distance": stopPanelContainer.items.items[2].getValue(),
	    					"arrivalTime": $this.timeFormator(stopPanelContainer.items.items[3].getValue()),
	    					"departureTime": $this.timeFormator(stopPanelContainer.items.items[4].getValue()),
	    					"routeStopType": stopPanelContainer.items.items[5].getValue(),
	    					"fromOrToSchool": 'TO_SCHOOL',
	    				});

	    			}else if(stopPanelContainer.items.items[5].getValue()=="INTERMEDIATE"){
	    				stopArray.push({
	    					"sequence" : fieldSequence+1,
	    					"id":stopPanelContainer.items.items[0].getValue(),
	    					"transServiceRoute":$this.getIdValueJson(routeId),
	    					"stopLocation":$this.getIdValueJson(stopPanelContainer.items.items[1].getValue()),
	    					"distance": stopPanelContainer.items.items[2].getValue(),
	    					"arrivalTime": $this.timeFormator(stopPanelContainer.items.items[3].getValue()),
	    					"departureTime": $this.timeFormator(stopPanelContainer.items.items[4].getValue()),
	    					"routeStopType": stopPanelContainer.items.items[5].getValue(),
	    					"fromOrToSchool": 'TO_SCHOOL',
	    				});
	    				fieldSequence=fieldSequence+1;
	    			}
	    		}
	    		if(form.down("#endRouteStopType").getValue()=="END"){
	    			endJson={
	    					"sequence" : formValues.location.length,
	    					"id":form.down("#endRouteStopId").getValue(),
	    					"transServiceRoute":$this.getIdValueJson(routeId),
	    					"stopLocation":$this.getIdValueJson(form.down("#endLocation").getValue()),
	    					"distance": form.down("#endDistance").getValue(),
	    					"arrivalTime": $this.timeFormator(form.down("#endArrivalTime").getValue()),
	    					"departureTime": $this.timeFormator(form.down("#endDepartureTime").getValue()),
	    					"routeStopType": form.down("#endRouteStopType").getValue(),
	    					"fromOrToSchool": 'TO_SCHOOL',
	    			};
	    		}
	    		 
	    		/* From School Json */
	    		var stopContinerFromSchl = form.down('#fromSchlServiceStopPanelId');
		    	var stopFieldsCountFromSchl = stopContinerFromSchl.items.length;
		    	var endJsonFromSchl=null;
		    	var fieldSequenceFromSchl=1;
		    	//if(stopFieldsCount>1){
		    		for(var j=0; j<stopContinerFromSchl.items.length; j++){
		    			var stopPanelContainerFromSchl=stopContinerFromSchl.items.items[j];
		    			if(stopPanelContainerFromSchl.items.items[5].getValue()=="START"){
		    				stopArray.push({
		    					"sequence" : j+1,
		    					"id":stopPanelContainerFromSchl.items.items[0].getValue(),
		    					"transServiceRoute":$this.getIdValueJson(routeId),
		    					"stopLocation":$this.getIdValueJson(stopPanelContainerFromSchl.items.items[1].getValue()),
		    					"distance": stopPanelContainerFromSchl.items.items[2].getValue(),
		    					"arrivalTime": $this.timeFormator(stopPanelContainerFromSchl.items.items[3].getValue()),
		    					"departureTime": $this.timeFormator(stopPanelContainerFromSchl.items.items[4].getValue()),
		    					"routeStopType": stopPanelContainerFromSchl.items.items[5].getValue(),
		    					"fromOrToSchool": 'FROM_SCHOOL',
		    				});

		    			}else if(stopPanelContainerFromSchl.items.items[5].getValue()=="INTERMEDIATE"){
		    				stopArray.push({
		    					"sequence" : fieldSequenceFromSchl+1,
		    					"id":stopPanelContainerFromSchl.items.items[0].getValue(),
		    					"transServiceRoute":$this.getIdValueJson(routeId),
		    					"stopLocation":$this.getIdValueJson(stopPanelContainerFromSchl.items.items[1].getValue()),
		    					"distance": stopPanelContainerFromSchl.items.items[2].getValue(),
		    					"arrivalTime": $this.timeFormator(stopPanelContainerFromSchl.items.items[3].getValue()),
		    					"departureTime": $this.timeFormator(stopPanelContainerFromSchl.items.items[4].getValue()),
		    					"routeStopType": stopPanelContainerFromSchl.items.items[5].getValue(),
		    					"fromOrToSchool": 'FROM_SCHOOL',
		    				});
		    				fieldSequenceFromSchl=fieldSequenceFromSchl+1;
		    			}
		    		}
		    		if(form.down("#fromSchlEndRouteStopType").getValue()=="END"){
		    			endJsonFromSchl={
		    					"sequence" : formValues.fromSchlLocation.length,
		    					"id":form.down("#fromSchlEndRouteStopId").getValue(),
		    					"transServiceRoute":$this.getIdValueJson(routeId),
		    					"stopLocation":$this.getIdValueJson(form.down("#fromSchlEndLocation").getValue()),
		    					"distance": form.down("#fromSchlEndDistance").getValue(),
		    					"arrivalTime": $this.timeFormator(form.down("#fromSchlEndArrivalTime").getValue()),
		    					"departureTime": $this.timeFormator(form.down("#fromSchlEndDepartureTime").getValue()),
		    					"routeStopType": form.down("#fromSchlEndRouteStopType").getValue(),
		    					"fromOrToSchool": 'FROM_SCHOOL',
		    			};
		    		}
	    		
	    		
	    		stopArray.push(endJson);
	    		stopArray.push(endJsonFromSchl);
	    	//}
	    	var routeData={
	    			"id":formValues.id,
	    			"responsiblePerson":$this.getIdValueJson(formValues.responsiblePersonId),
	    			"responsiblePersonName":formValues.serviceResponsiblePersonName,
	    			"endLocation":$this.getIdValueJson(formValues.endsAtIdItemId),
	    			"startLocation":$this.getIdValueJson(formValues.startsFromIdItemId),
	    			"route":$this.getIdValueJson(formValues.route),
	    			"serviceName" : formValues.serviceName,
	    			"startTime": formValues.startTime,
	    			"reachTime": formValues.reachTime,
	    			"distance": formValues.distanceInKm,
	    			"whetherActive": isActiveValue,
	    			"startDate": formValues.startDate,
	    			"endDate": formValues.endDate,
	    			"routeBillType":null,//not found in wire frame
	    			"feePlan":null,//not found in wire frame
	    			"droolsAgenda":null,//not found in wire frame
	    			"droolsRuleRemarks":null,//not found in wire frame
	    			"timeRecordForStops":timeRecordForStops,
                    "transportProviderName":isNullOrEmpty(formValues.transportProviderName)?null:formValues.transportProviderName,
	    			"weekday":weekdays,
	    			"academyLocations":uniqueresultArr,
	    			"transServiceRouteStops":stopArray
	    	};
	    	
	    	var routeId=0;
	    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : submitUrl,
	    		jsonData : routeData,
	    		method : 'POST',
	    		success : function(resp, action) {
	    			 Ext.getBody().unmask();
	    			routeId=resp.responseText;
	    			if (formValues.id == null || formValues.id == "") {
	    				form.getForm().findField('id').setValue(routeId);
	    				form.down("#transServiceRouteId").setValue(routeId); 
	    			}else{
	    				routeId = form.down("#transServiceRouteId").getValue();  
	    			}
	    			
	    			var academyLocationId = $this.getCurrentAcademyLocation();
	    	    	var store = grid.getStore();
	    	    	store.getProxy().extraParams = {
	    	    		academyLocationIds : academyLocationId
	    	    	};
	    	    	store.load();
	    	    	grid.getSelectionModel().deselectAll(true);
	    			form.down("#btnReset").setVisible(false);
	    			showSuccessMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'),message);
	    			tabStructure.down("#dateexceptioncontainer").setDisabled(false);
	    			tabStructure.down("#vehiclelinkcontainer").setDisabled(false);
	    			tabStructure.down("#peoplecoveredcontainer").setDisabled(false);
	    			tabStructure.down("#serviceRouteDetailBulkImport").setDisabled(false);

	    			tabStructure.down("#serviceRouteName").setValue(formValues.serviceName);
	    			tabStructure.down("#routeName").setValue(routeName);

	    			tabStructure.down("#serviceRouteNameLink").setValue(formValues.serviceName);
	    			tabStructure.down("#routeNamelink").setValue(routeName);

	    			tabStructure.down("#serviceRouteNameUserLink").setValue(formValues.serviceName);
	    			tabStructure.down("#routeNameuserLink").setValue(routeName);
	    		}
	    	});
	    },
	     /**
	      * Edit service route data
	      */
	     getEditServiceRouteDetail:function(){
	    	  var $this=this;
			  var grid = $this.getServiceRouteMasterGrid();
			  var academyLocationId = $this.getCurrentAcademyLocation();
          	 if (grid.getSelectionModel().getCount() > 0) {
          		$this.getOpenServiceRouteDetailForm();
          		var records = grid.getSelectionModel().getSelection()[0];
          		 var tabStructure = $this.getServiceRouteDetailTabStructure();
          		 var form = $this.getServiceRouteDetailForm();
	    		 var getForm = form.getForm();
	    		 form.config.mode = 'edit';
	    		 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				 Ext.Ajax.request({
          		 method: "GET",
          		 type: 'rest',
          		 url: SERVERURL.SERVICE_ROUTE_FINDBYID,
          		 headers: {
          			 'Content-Type': 'application/json'
          		 },
          		 params: {
          			 id: records.get("id")
          		 },
          		 success: function(f, action) {
          			var SRData=Ext.JSON.decode(f.responseText);
          			if(SRData.endDate!=null){
          			SRData.endDate = new Date(SRData.endDate);
          			}
          			SRData.reachTime = new Date(SRData.reachTime);
          			SRData.startDate = new Date(SRData.startDate);
          			SRData.startTime = new Date(SRData.startTime);
          			var datas = new Academia.model.transport.serviceRoute.ServiceRouteTimeData(SRData);
          			form.loadRecord(datas);
          			getForm.findField('id').setValue(SRData.id);
          			getForm.findField('transServiceRouteId').setValue(SRData.id);
          			getForm.findField('serviceName').setValue(SRData.serviceName);
          			getForm.findField('distanceInKm').setValue(SRData.distance);
          			getForm.findField('transServiceRouteId').setValue(SRData.id);
          			//getForm.findField('transportProviderName').setValue(SRData.id);
          			getForm.findField('startDate').setValue(dateRender(SRData.startDate));
          			getForm.findField('endDate').setValue(dateRender(SRData.endDate));
          			
          			form.down("#btnReset").setVisible(false);
          			
          			var transportProviderName=getForm.findField('transportProviderName');
          			transportProviderName.getStore().load({
      					callback:function(){
      						if(SRData && SRData.transportProviderName)
      						transportProviderName.setValue(SRData.transportProviderName.id);		
      					}
      				});
          			
          			var routeField=getForm.findField('route');
          			
          			var routeFieldStore = routeField.getStore();
          			routeFieldStore.load({
          				callback:function(){
          					var range = routeFieldStore.getRange();
          					if(isNullOrEmpty(range)) {
          						routeFieldStore.getProxy().extraParams = {
          	        	        	status : true,
          	        	        	academyLocationId:null
          	        	    	};
          						routeFieldStore.load({
          							callback :function(){
          								 Ext.getBody().unmask();
          								routeField.setValue(SRData.route.id);
          								routeField.setReadOnly(true);
          							}
          						});
          					} else {
          						var result = range.filter(function (obj) {
                					  return obj.data.id === SRData.route.id;
                					})[0];
          						if(isNullOrEmpty(result)) {
          							routeFieldStore.getProxy().extraParams = {
              	        	        	status : true,
              	        	        	academyLocationId:null
              	        	    	};
          							routeFieldStore.load({
              							callback :function(){
              								Ext.getBody().unmask();
              								routeField.setValue(SRData.route.id);
              								routeField.setReadOnly(true);
              							}
              						});
          						} else {
          							Ext.getBody().unmask();
          							routeField.setValue(SRData.route.id);		
          						}
          					}
          				}
          			
          			});	
          			
          			var responsiblePerson = SRData.responsiblePerson; 
          			var responsiblePersonName = SRData.responsiblePersonName; 
          			var multipleAcademyLocationId;
          			
          			if(SRData.academyLocations){
          				 multipleAcademyLocationId = SRData.academyLocations.join();
          			}
          			
          			var responsiblePersonIdField = form.down("#responsiblePersonId");
          			var serviceResponsiblePersonName = form.down("#serviceResponsiblePersonName");
          			
          			var userType = SRData.userType;
          			var userTypeCombo = form.down("#userType");
          			
          			var academyLocationsField=getForm.findField('academyLocations');
      				academyLocationsField.getStore().load({
      					callback:function(){
      						academyLocationsField.setValue(SRData.academyLocations);		
      						if(!isNullOrEmpty(responsiblePerson)){
      	          				userTypeCombo.setValue(userType);
      	          				serviceResponsiblePersonName.setVisible(false);
      	          			    serviceResponsiblePersonName.allowBlank=true;
      	          			    responsiblePersonIdField.setVisible(true);
      	      					responsiblePersonIdField.getStore().load({
      	      						callback : function(rec,operation,success){
      	      							responsiblePersonIdField.setValue(responsiblePerson.id);		      							
      	      						}
      	      					});
      	          			}
      					}
      				});
          			
  					if(!isNullOrEmpty(responsiblePersonName)){
  						userTypeCombo.setValue(0);
  						responsiblePersonIdField.setVisible(false);
  						responsiblePersonIdField.allowBlank=true;
          				serviceResponsiblePersonName.setVisible(true);
						form.down("#serviceResponsiblePersonName").setValue(responsiblePersonName);
      				}
      				var isActiveField=getForm.findField('isActive');
      				var isActiveValue=null;
      				if(SRData.whetherActive==true){
      					isActiveValue="YES";
      				}else if(SRData.whetherActive==false){
      					isActiveValue="NO";
      				}
      				isActiveField.getStore().load({
      					callback:function(){
      						isActiveField.setValue(isActiveValue);		
      					}
      				});	
      				
      				var runOnDaysField=getForm.findField('runOnDays');
      				
      				/*runOnDaysField.getStore().load({
      					callback:function(){
      						//runOnDaysField.setValue(SRData.weekday);		
      					}
      				});	*/
      				runOnDaysField.setValue(SRData.weekday);
         			
          			/**
	           		 * Load Stop data
	           		 */
      				
      				if(SRData.transServiceRouteStops.length>0){
      					var fieldContainerIndex=1;
		         			Ext.Array.each(SRData.transServiceRouteStops,function(value,index){
			    				var fieldContainer=form.down('#serviceStopPanelId');
			    				/**
			    				 * Load start Location and distance
			    				 * startLocationField is fetch to send in addmultipleStops functionality to create multiple stops.
			    				 */
			    				var startLocationField= form.down("#startLocation");

			    				
			    				var serviceRouteDetailForm = $this.getServiceRouteDetailForm();
			    		   	   var stopContiner = serviceRouteDetailForm.down('#serviceStopPanelId');	
			    			  var startMinVal= stopContiner.up().query('#startArrivalTime')[0].getValue();
			    			  var endMaxVal= stopContiner.up().query('#endDepartureTime')[0].getValue();
			    				
			    				if(value.routeStopType==getTransportTranslation('START') && value.fromOrToSchool=="TO_SCHOOL"){
			    					startLocationField.setValue(value.stopLocation.id);
			    					form.down("#startDistance").setValue(value.distance);
			    					form.down("#startRouteStopId").setValue(value.id);
			    					form.down("#startArrivalTime").setValue(timeRender(value.arrivalTime));	
		    						form.down("#startDepartureTime").setValue(timeRender(value.departureTime));	
		    						if(form.down("#arrivalTime")){
		    						 form.down("#arrivalTime").setMinValue(startMinVal);	
		    						}
		    						if(form.down("#departureTime")){
		    						 form.down("#departureTime").setMaxValue(endMaxVal);	
		    						}
			    				}
			    				/**
			    				 * Load End Location and distance
			    				 */
			    				if(value.routeStopType==getTransportTranslation('END')  && value.fromOrToSchool=="TO_SCHOOL"){
			    					form.down("#endLocation").setValue(value.stopLocation.id);
			    					form.down("#endDistance").setValue(value.distance);
			    					form.down("#endRouteStopId").setValue(value.id);
			    					form.down("#endArrivalTime").setValue(timeRender(value.arrivalTime));	
		    						form.down("#endDepartureTime").setValue(timeRender(value.departureTime));
		    						if(form.down("#arrivalTime")){
		    							form.down("#arrivalTime").setMinValue(startMinVal);	
		    						}
		    						if(form.down("#departureTime")){
		    							form.down("#departureTime").setMaxValue(endMaxVal);
		    						}
			    				}
			    				
			    				if(value.routeStopType==getTransportTranslation('TRANSPORT_INTERMEDIATE')  && value.fromOrToSchool=="TO_SCHOOL"){
			    					$this.addMultipleStops(startLocationField);	 
			    					/**
			    					 * It is used to delay task 
			    					 */
			    					var task = new Ext.util.DelayedTask(function(){

			    						var currentFieldContainer=fieldContainer.items.items[fieldContainerIndex];
			    						currentFieldContainer.items.items[0].setValue(value.id);
			    						currentFieldContainer.items.items[1].setValue(value.stopLocation.id);
			    						currentFieldContainer.items.items[2].setValue(value.distance);
			    						currentFieldContainer.items.items[3].setValue(timeRender(value.arrivalTime));
			    						currentFieldContainer.items.items[4].setValue(timeRender(value.departureTime));
			    						fieldContainerIndex=fieldContainerIndex+1;
			    					});
			    					task.delay(1000);
			    					
			    					
			    				
			    				}
			    			});
		         			var recordStopListWithTimes = getForm.findField('recordStopListWithTimes');
		      				var timeRecordForStops=null;
		      				if(SRData.timeRecordForStops==true){
		      					timeRecordForStops="YES";
		      				}else if(SRData.timeRecordForStops==false){
		      					timeRecordForStops="NO";
		      				}
		      				recordStopListWithTimes.getStore().load({
		          				callback:function(){
		          					recordStopListWithTimes.setValue(timeRecordForStops);		
		          				}
		          			});
		         		 }
      				    
      				     /* ============= Load From School Tab Data ============= */
      				if(SRData.transServiceRouteStops.length>0){
      					var fieldContainerIndex1=1;
		         			Ext.Array.each(SRData.transServiceRouteStops,function(value,index){
			    				var fieldContainerFromSchl=form.down('#fromSchlServiceStopPanelId');
			    				/**
			    				 * Load start Location and distance
			    				 * startLocationField is fetch to send in addmultipleStops functionality to create multiple stops.
			    				 */
			    				var fromSchlEndLocation= form.down("#fromSchlEndLocation");
			    				if(value.routeStopType==getTransportTranslation('START')  && value.fromOrToSchool=="FROM_SCHOOL"){
			    					form.down("#fromSchlStartLocation").setValue(value.stopLocation.id);
			    					form.down("#fromSchlStartDistance").setValue(value.distance);
			    					form.down("#fromSchlStartRouteStopId").setValue(value.id);
			    					form.down("#fromSchlStartArrivalTime").setValue(timeRender(value.arrivalTime));	
		    						form.down("#fromSchlStartDepartureTime").setValue(timeRender(value.departureTime));	
			    				}
			    				/**
			    				 * Load End Location and distance
			    				 */
			    				if(value.routeStopType==getTransportTranslation('END') && value.fromOrToSchool=="FROM_SCHOOL"){
			    					form.down("#fromSchlEndLocation").setValue(value.stopLocation.id);
			    					form.down("#fromSchlEndDistance").setValue(value.distance);
			    					form.down("#fromSchlEndRouteStopId").setValue(value.id);
			    					form.down("#fromSchlEndArrivalTime").setValue(timeRender(value.arrivalTime));	
		    						form.down("#fromSchlEndDepartureTime").setValue(timeRender(value.departureTime));	
			    				}
			    				
			    				if(value.routeStopType==getTransportTranslation('TRANSPORT_INTERMEDIATE') && value.fromOrToSchool=="FROM_SCHOOL"){
			    					$this.fromSchlAddMultipleStops(fromSchlEndLocation);	 
			    					/**
			    					 * It is used to delay task 
			    					 */
			    					var task = new Ext.util.DelayedTask(function(){

			    						var fieldContainer1=fieldContainerFromSchl.items.items[fieldContainerIndex1];
			    						fieldContainer1.items.items[0].setValue(value.id);
			    						fieldContainer1.items.items[1].setValue(value.stopLocation.id);
			    						fieldContainer1.items.items[2].setValue(value.distance);
			    						fieldContainer1.items.items[3].setValue(timeRender(value.arrivalTime));
			    						fieldContainer1.items.items[4].setValue(timeRender(value.departureTime));
			    						fieldContainerIndex1=fieldContainerIndex1+1;
			    					});
			    					task.delay(1000);
			    				}
			    			});
		         		 }
      				
      				
		         		//});
						 tabStructure.down("#dateexceptioncontainer").setDisabled(false);
						 tabStructure.down("#vehiclelinkcontainer").setDisabled(false);
						 tabStructure.down("#peoplecoveredcontainer").setDisabled(false);
						 tabStructure.down("#serviceRouteDetailBulkImport").setDisabled(false);

						 tabStructure.down("#serviceRouteName").setValue(SRData.serviceName);
						 tabStructure.down("#routeName").setValue(SRData.route.value);

						 tabStructure.down("#serviceRouteNameLink").setValue(SRData.serviceName);
						 tabStructure.down("#routeNamelink").setValue(SRData.route.value);

						 tabStructure.down("#serviceRouteNameUserLink").setValue(SRData.serviceName);
						 tabStructure.down("#routeNameuserLink").setValue(SRData.route.value);
						 tabStructure.down("#capacity").setValue(SRData.capacity);
          		    }
				 });
            }else {
      		  showWarningMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
      	   }
	      },
	      getViewServiceRouteDetail : function(){
	    	  this.getEditServiceRouteDetail();
	    		var form =this.getServiceRouteDetailForm();
	    		if (form) {
	    			form.config.mode = 'view';
	    			form.down('#btnSave').setVisible(false);
	    			form.down("#stopBtn").setVisible(false);
	    			form.down("#buttonId").setValue('ViewMode');
	    			form = form.getForm();
	    		    toggleReadOnlyFormItems(form,true);
	    		}
	      },
	      
		  /**
		    * Add multiple stops in panel
		    */
	      addMultipleStops:function(obj){
		   	   var $this = this;
		   	   var serviceRouteDetailForm = $this.getServiceRouteDetailForm();
		   	    var recordStopListWithTimes = serviceRouteDetailForm.down('#recordStopListWithTimesId').getValue();
		   	   var stopContiner = serviceRouteDetailForm.down('#serviceStopPanelId');
		   	  // var timeFieldsCount = stopContiner.items.length;
		   	   var panelItem = new Array();
		   	   var fieldContainer=obj.up('fieldcontainer');
		   	   var newcont=stopContiner.items.indexOf(fieldContainer);
			   var insertPosition=newcont+1;
			  var startMinVal= stopContiner.up().query('#startArrivalTime')[0].getValue();
			  var endMaxVal= stopContiner.up().query('#endDepartureTime')[0].getValue();
			   if(!isNullOrEmpty(recordStopListWithTimes) && recordStopListWithTimes == 'NO'){
				   panelItem.push({
			   		   xtype:'fieldcontainer',
			   		   width: '100%',
			   		   layout : 'hbox',
			   		 //style:{'margin':'20px'},
			   		   defaults : {
			   			   width: 256,
			   			   labelAlign : 'top'
			   		   },
			   		   items : [{
			   			    xtype:'hidden',
			   			    name:'routeStopId',
			   			    itemId:'routeStopId'
			   		   },{
							xtype : 'customcombobox',
							name : 'location',
							 width: 256,
							store: 'transport.route.LocationName',
							displayField: 'locationName',
							valueField: 'id',		
							allowBlank:false
						},{
							xtype : 'numberfield',
							name : 'distance',	
							minValue : 0,
							 width: 256,
			                hideTrigger:true,
							allowBlank:false
			   		    },{
			   		    	xtype : 'timefield',
							name : 'arrivalTime',
							itemId:'arrivalTime',
							minValue:startMinVal,
							maxValue:endMaxVal,
							submitFormat : 'g:i A',
							allowBlank: false,
							hidden : true,
							width: 105,
							listeners: {
								render: function(field) {
									
									return timeFormatRender(field);
								}
							}
						},{
							xtype : 'timefield',
							itemId:'departureTime',
							name : 'departureTime',
							minValue:startMinVal,
							maxValue:endMaxVal,
							submitFormat : 'g:i A',
							hidden : true,
							allowBlank: false,
							width: 125,
							listeners: {
								render: function(field) {
									return timeFormatRender(field);
								}
							}
						},{
							xtype:'hidden',
							name:'routeStopType',
							value:getTransportTranslation('TRANSPORT_INTERMEDIATE')
			   		    },{
			   		    	xtype: 'button',
							itemId: 'stopBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							width:40,
							margin: '-3 0 0 0'
							/*listeners:{
								click:function(obj){
									$this.showHideTimeFields(obj);
								}
							}*/
				   	   },{
			   			   xtype: 'button',
			   			   glyph: ICONGLYPH.DELETEGLYPH,
			   			   cls: 'CustomBodyBtnReject',
			   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
			   			   width:40,
			   			   listeners:{
			   				   click:function(obj){
			   					   var container = obj.up('fieldcontainer');
			   					   var panelContiner = $this.getServiceRouteDetailForm().down('#serviceStopPanelId');
			   					   panelContiner.remove(container);
			   					   $this.getServiceRouteDetailForm().getForm().checkValidity();
			   					   $this.getServiceRouteDetailForm().getForm().isValid();
			   					   $this.getServiceRouteDetailForm().getForm().clearInvalid();
			   				   }
			   			   }
			   		   }]
			   	   });
			   } else {
				   panelItem.push({
			   		   xtype:'fieldcontainer',
			   		   width: '100%',
			   		   layout : 'hbox',
			   		// style:{'margin':'20px'},
			   		   defaults : {
			   			   width: 256,
			   			   labelAlign : 'top'
			   		   },
			   		   items : [{
			   			    xtype:'hidden',
			   			    name:'routeStopId',
			   			    itemId:'routeStopId'
			   		   },{
							xtype : 'customcombobox',
							name : 'location',
							 width: 256,
							store: 'transport.route.LocationName',
							displayField: 'locationName',
							valueField: 'id',		
							allowBlank:false
						},{
							xtype : 'numberfield',
							name : 'distance',	
							minValue : 0,
							 width: 256,
			                hideTrigger:true,
							allowBlank:false
			   		    },{
			   		    	xtype : 'timefield',
							name : 'arrivalTime',
							itemId:'arrivalTime',
							minValue:startMinVal,
							maxValue:endMaxVal,
							submitFormat : 'g:i A',
							allowBlank: false,
							width: 105,
							listeners: {
								render: function(field) {
								 	  	
									return timeFormatRender(field);
								}
							}
						},{
							xtype : 'timefield',
							itemId:'departureTime',
							name : 'departureTime',
							submitFormat : 'g:i A',
							minValue:startMinVal,
							maxValue:endMaxVal,
							allowBlank: false,
							width: 125,
							listeners: {
								render: function(field) {
									return timeFormatRender(field);
								}
							}
						},{
							xtype:'hidden',
							name:'routeStopType',
							value:getTransportTranslation('TRANSPORT_INTERMEDIATE')
			   		    },{
			   		    	xtype: 'button',
							itemId: 'stopBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							width:40,
							/*listeners:{
								click:function(obj){
									$this.showHideTimeFields(obj);
								}
							}*/
				   	   },{
			   			   xtype: 'button',
			   			   glyph: ICONGLYPH.DELETEGLYPH,
			   			   cls: 'CustomBodyBtnReject',
			   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
			   			   width:40,
			   			   listeners:{
			   				   click:function(obj){
			   					   var container = obj.up('fieldcontainer');
			   					   var panelContiner = $this.getServiceRouteDetailForm().down('#serviceStopPanelId');
			   					   panelContiner.remove(container);
			   					   $this.getServiceRouteDetailForm().getForm().checkValidity();
			   					   $this.getServiceRouteDetailForm().getForm().isValid();
			   					   $this.getServiceRouteDetailForm().getForm().clearInvalid();
			   				   }
			   			   }
			   		   }]
			   	   });
			   }
		   	     

			  stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
		      },
		      /**
		       * Date Exception Tab
		       * 
		       */
		      getRenderDateExceptionTab : function(){
		    	  var serviceRouteform = this.getServiceRouteDetailForm();
		    	  var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	  var grid = this.getDateExceptionGrid();
		    	  var store = grid.getStore();
		    	  store.getProxy().extraParams = {
		    		  transServiceRouteId:transServiceRouteId
		    	  };
		    	  store.load();
		    	  
		    	  // for view mode
		    	  var mode = serviceRouteform.down("#buttonId").getValue();
		    	  if(mode=='ViewMode'){
		    	  		buttonsToolBar = grid.query('toolbar')[0];
		    	  		buttonsToolBar.query('#btnAdd')[0].setVisible(false);
		    	  		buttonsToolBar.query('#btnEdit')[0].setVisible(false);
		    	  		buttonsToolBar.query('#btnDelete')[0].setVisible(false);
		    	  }
		      },
		      getCloseDateException : function(obj){
		    	  this.getDateExceptionWindow().close();
		      },
		      getSaveDateExceptionDetail : function(){
		    	    var this$ = this;
		    	    var serviceRouteform = this.getServiceRouteDetailForm();
			    	var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	   var grid = this$.getDateExceptionGrid();
		       	   var gridStore = grid.getStore();
		    	   var form = this$.getDateExceptionForm();
		    	   var values = form.getForm().getValues();
		    	   
		    	   var dateExceptionModel = new Academia.model.transport.serviceRoute.DateExceptionSubmitData();
		    	   dateExceptionModel.set("transServiceRoute",this.getIdValueJson(transServiceRouteId));
		    	   dateExceptionModel.set("exceptionDate",values.exceptionDate);
		    	   dateExceptionModel.set("revisedStatus",values.revisedStatus);
		    	   dateExceptionModel.set("originalStatus",values.originalStatus);
		    	   dateExceptionModel.set("description",values.description);
		    	
		    	   var submitUrl;
		    	   var message;
		    	   
		    	   if (values.id == null || values.id == "") {
		    		   submitUrl = SERVERURL.DATE_EXCEPTION_CREATE_URL;
		    		   message = getTransportTranslation('DATE_EXCEPTION_SUCCESFULLY_CREATED');
		    	   } else {
		    		   dateExceptionModel.set("id",values.id);
		    		   submitUrl = SERVERURL.DATE_EXCEPTION_UPDATE_URL;
		    		   message = getTransportTranslation('DATE_EXCEPTION_SUCCESFULLY_UPDATED');
		    	   }
		    	   var submitData = Ext.encode(dateExceptionModel.data);
		    	   this$.applyWindowMask(); 
		    	
		    	   Ext.Ajax.request({
		    		   url: submitUrl,
		    		   jsonData: submitData,
		    		   method: 'POST',
		    		   success: function(response) {
		    			   this$.hideWindowMask();
		    			   this$.getCloseDateException();
		    			   gridStore.reload();
		    			   showSuccessMessage(getTransportTranslation('DATE_EXCEPTION'),message);		    		   }
		   		});
		      },
		      getOpenDateExceptionDetail : function(){
		    	  var frmWin = this.getDateExceptionWindow();
		    	  if(!frmWin){
		    		  Ext.widget('dateexceptionwindow');
		    		  frmWin = this.getDateExceptionWindow();
		    	  }
		    	  frmWin.show();
		    	  var startDate = this.getServiceRouteDetailForm().down("#startDate").getValue();
		    	  var form = this.getDateExceptionForm();
		    	  var exceptionDate = form.down("#exceptionDate");
		    	  /**
		    	   * @author Ravi Choudhary
		    	   * to manage organization date format
		    	   */
//		    	  var orgModel = Academia.model.common.OrgSettingDateTimeModel;
//		    	  var currentDateFormat = orgModel.get('dateFormat');
//		    	  if(currentDateFormat ==="DMY_DESH") {
		    	//	  startDate = this.getDateFromDMYdate(awardedOnDateValue)
//		    	  } else if(currentDateFormat ==="DMY_SLASH") {
//		    		  startDate = this.getDateFromDMYdate(awardedOnDateValue, 'd/m/Y')
//		    	  }
		    	  
		    	  var date1 = new Date(startDate);
                  var date2 = new Date();

				  var sec = 1000;
				  var min = sec * 60;
				  var hour = min * 60;
				  var day = hour * 24;

                  var dateDiff = (Math.ceil(Math.abs((date1 - date2) / day))-1);
		    	  
                  if(dateDiff>=3){
                	  exceptionDate.setMinValue(Ext.Date.add (new Date(),Ext.Date.DAY,-3));
                  }else{
                	  exceptionDate.setMinValue(startDate);
                  }
		      },
		      getEditDateExceptionDetail : function(){
		    	var this$ = this;
		        var grid = this$.getDateExceptionGrid();
		      	if (grid.getSelectionModel().getCount() > 0) {
		      		this$.getOpenDateExceptionDetail();
		      		var form = this$.getDateExceptionForm();
		      		var record = grid.getSelectionModel().getSelection()[0];
		      		var id = record.get("id");
		      		var editUrl = SERVERURL.DATE_EXCEPTION_FINDBYID_URL;
		      		Ext.Ajax.request({
		      			method: "GET",
		      			type: 'rest',
		      			url: editUrl,
		      			params: {
		      				id: id
		      			},
		      			success: function(f, action) {
		      				var data = Ext.JSON.decode(f.responseText);
		      				if(!isNullOrEmpty(data.exceptionDate)) {
		      					data.exceptionDate = new Date(data.exceptionDate);
	    					}
		      				var dateExceptionModel = new Academia.model.transport.serviceRoute.DateExceptionGridData(data);
		      				form.loadRecord(dateExceptionModel);
		      				
		      				var id = dateExceptionModel.get("originalStatus");
		      				
		      				var originalStatus = form.down("#originalStatus");
		      				originalStatus.getStore().load({
		      					callback : function(rec,operation,success){
		      						originalStatus.setValue(id);
		      					}
		      				});
		      				
		      				var revisedStatus = form.down("#revisedStatus");
		      				var revisedStatusStore = revisedStatus.getStore();
		      				revisedStatusStore.load({
		      					callback : function(res,operation,success){
		      						var revisedStatusValues = revisedStatusStore.getRange();
		    						var index = revisedStatusStore.find('id',id);
		    						revisedStatusStore.removeAt(index);
		      						revisedStatus.setValue(dateExceptionModel.get("revisedStatus"));
		      					}
		      				});
		      			}
		      		 });
		      		}else{
		      			 showWarningMessage(getTransportTranslation('DATE_EXCEPTION'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		      		} 
		      },
		      getViewDateExceptionDetail : function(){
		    	  this.getEditDateExceptionDetail();
		    		var form =this.getDateExceptionForm();
		    		if (form) {
		    			form.down('#SubmitBtn').setVisible(false);
		    			form = form.getForm();
		    		    toggleReadOnlyFormItems(form,true);
		    		}
		      },
		      getDeleteDateExceptionDetail:function(){
		    	  var $this=this;
				  var grid = $this.getDateExceptionGrid();
             	 if (grid.getSelectionModel().getCount() > 0) {
             		 var records = grid.getSelectionModel().getSelection()[0];
             		 var id=records.get("id");
             		showConfirmMessage(getTransportTranslation('DATE_EXCEPTION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
             				 function(btn, text) {
             			 if (btn == 'yes'){
		             		 Ext.Ajax.request({
		             			 method: "DELETE",
		             			 type: 'rest',
		             			 url: SERVERURL.DATE_EXCEPTION_DELETE_URL+'?id='+id,
		             			 headers: {
		             				 'Content-Type': 'application/json'
		             			 },
		             			 success: function(form, action) {
		             				 grid.store.reload();
		             				 showSuccessMessage(getTransportTranslation('DATE_EXCEPTION'), getTransportTranslation('DATE_EXCEPTION_SUCCESFULLY_DELETED'));
		             			 }
		             		 });
             			 }
             		 });
             	 } else {
             		 showWarningMessage(getTransportTranslation('DATE_EXCEPTION'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
             	 }
		      },
		      
		      /**
		       * Vehicle linked to service route Tab
		       * 
		       */
		      getRenderVehicleServiceLinkTab : function(){
		    	  var serviceRouteform = this.getServiceRouteDetailForm();
		    	  var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	  var grid = this.getVehicleServiceRouteLinkGrid();
		    	  var store = grid.getStore();
		    	  store.getProxy().extraParams = {
		    		  transServiceRouteId:transServiceRouteId
		    	  };
		    	  store.sorters.clear();
		    	  store.load();
		    	  var itemIdPrivilegeNameArray = [{"#spBtnMoreActions" : "MOREACTIONS"},{"#assignServiceRouteDriverDetail" : "ASSIGN_DRIVER"}];
		    	  this.disableRadioGroupAndOtherPivileges(grid, this.getTRANSPORT_SERVICE_ROUTE_PERMISSION(), itemIdPrivilegeNameArray);
	
		    	  // for view mode
		    	  var mode = serviceRouteform.down("#buttonId").getValue();
		    	  if(mode=='ViewMode'){
		    		  buttonsToolBar = grid.query('toolbar')[0];
		    		  buttonsToolBar.query('#btnAdd')[0].setVisible(false);
		    		  buttonsToolBar.query('#btnEdit')[0].setVisible(false);
		    		  buttonsToolBar.query('#btnDelete')[0].setVisible(false);
		    	  }
		      },
		      getCloseVehicleServiceLink : function(obj){
		    	  this.getVehicleServiceRouteLinkWindow().close();
		      },
		      getSaveVehicleServiceLinkDetail : function(){
		    	  var this$ = this;
		    	  var serviceRouteform = this.getServiceRouteDetailForm();
		    	  var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	  var grid = this$.getVehicleServiceRouteLinkGrid();
		    	  var gridStore = grid.getStore();
		    	  var form = this$.getVehicleServiceRouteLinkForm();
		    	  var values = form.getForm().getValues();
		    	  var isActiveValue=null;
		    	  var isActiveUpper = values.isActive.toUpperCase();
		    	  if(isActiveUpper=="YES"){
		    		  isActiveValue=true;
		    	  }else if(isActiveUpper=="NO"){
		    		  isActiveValue=false; 
		    	  }

		    	  var vehicleLinkModel = new Academia.model.transport.serviceRoute.VehicleLinkSubmitData();
		    	  vehicleLinkModel.set("transServiceRoute",this.getIdValueJson(transServiceRouteId));
		    	  vehicleLinkModel.set("vehicle",this.getIdValueJson(values.vehicleNo));
		    	  vehicleLinkModel.set("whetherActive",isActiveValue);
		    	  if(!isNullOrEmpty(values.transServiceRouteDriverDetail)){
		    		  vehicleLinkModel.set("transServiceRouteDriverDetail",this.getIdValueJson(values.transServiceRouteDriverDetail));
		    	  }
		    	  else{
		    		  vehicleLinkModel.set("transServiceRouteDriverDetail",null);
		    	  }
		    	  

		    	  var submitUrl;
		    	  var message;

		    	  if (values.id == null || values.id == "") {
		    		  submitUrl = SERVERURL.VL_TO_SR_CREATE_URL;
		    		  message = getTransportTranslation('VEHICLE_LINK_SUCCESFULLY_CREATED');
		    	  } else {
		    		  vehicleLinkModel.set("id",values.id);
		    		  submitUrl = SERVERURL.VL_TO_SR_UPDATE_URL;
		    		  message = getTransportTranslation('VEHICLE_LINK_SUCCESFULLY_UPDATED');
		    	  }
		    	  var submitData = Ext.encode(vehicleLinkModel.data);
		    	  this$.applyWindowMask(); 
		    	 
		    	  Ext.Ajax.request({
		    		  url: submitUrl,
		    		  jsonData: submitData,
		    		  method: 'POST',
		    		  success: function(response) {
		    			  this$.hideWindowMask();
		    			  var data = response.responseText;
		    			  if(data=='OTHER_VAHICLE_ACTIVE'){
		    				  showWarningMessage(getTransportTranslation('VEHICLE_LINKED'), getTransportTranslation('OTHER_VAHICLE_ACTIVE')); //Please select a record  
		    			  }else if(data=='VAHICLE_IS_NOT_UNIQUE'){
		    				  showWarningMessage(getTransportTranslation('VEHICLE_LINKED'),getTransportTranslation('VEHICLE_ALREADY_EXIST')); //Please select a record
		    			  }else if(data=='0'){
		    				  this$.getCloseVehicleServiceLink();
			    			  gridStore.reload();
			    			  showSuccessMessage(getTransportTranslation('VEHICLE_LINKED'),message);		    		   }  
		    			  }
		    	  });
		      },
		      getOpenVehicleServiceLinkDetail : function(obj){
		    	  var frmWin = this.getVehicleServiceRouteLinkWindow();
		    	  if(!frmWin){
		    		  Ext.widget('vehicleserviceroutelinkwindow');
		    		  frmWin = this.getVehicleServiceRouteLinkWindow();
		    	  }
		    	  frmWin.show(); 

		    	  var srForm = this.getServiceRouteDetailForm();
		    	  var academyLocationIds = srForm.getForm().findField('academyLocations').getValue();
		    	  var academyLocations=[];
		    	  if(Ext.isObject(academyLocationIds[0])){
		    		  for(var i in academyLocationIds){
		    			  academyLocations.push(academyLocationIds[i].get("id"));
		    		  }
		    	  }else{
		    		  academyLocations = academyLocationIds;
		    	  }
		    	  var academyLocationId = academyLocations.join();
		    	  var form  = this.getVehicleServiceRouteLinkForm();
		    	  var vehicleNo = form.down("#vehicleNo");
		    	  var store = vehicleNo.getStore();
		    	  
			      var transServiceRouteId = srForm.down("#transServiceRouteId").getValue();
			        
			      Ext.Ajax.request({
			    	  method : 'GET',
			    	  type : 'rest',
			    	  url: SERVERURL.PATH_FIND_ACADEMY_LOCATIONS_BY_SERVICE_ROUTE_ID,
			    	  params: {
			    		  transServiceRouteId : transServiceRouteId
			    	  },
			    	  success : function(record, action) {
			    		  var record = Ext.decode(record.responseText);
			    		  var alids=[];
			    		  for (var i in record) {
			    			  alids.push(record[i].id);
			    		  }
			    		  store.getProxy().extraParams = {
			    			  academyLocationIds : alids.join()
			    		  };
			    	  }
			      });
		      },
		      getEditVehicleServiceLinkDetail : function(obj){
		    	var this$ = this;
		        var grid = this$.getVehicleServiceRouteLinkGrid();
		      	if (grid.getSelectionModel().getCount() > 0) {
		      		this$.getOpenVehicleServiceLinkDetail(obj);
		      		var form = this$.getVehicleServiceRouteLinkForm();
		      		var record = grid.getSelectionModel().getSelection()[0];
		      		var id = record.get("id");
		      		var vehicleNoSearch = record.data.vehicle.vehicleNumber;
		      		var editUrl = SERVERURL.VL_TO_SR_FINDBYID_URL;
		      		Ext.Ajax.request({
		      			method: "GET",
		      			type: 'rest',
		      			url: editUrl,
		      			params: {
		      				id: id
		      			},
		      			success: function(f, action) {
		      				var data = Ext.JSON.decode(f.responseText);
		      				form.getForm().findField('id').setValue(data.id);
		      				if(!isNullOrEmpty(data.transServiceRouteDriverDetail)){
		      					form.getForm().findField('transServiceRouteDriverDetail').setValue(data.transServiceRouteDriverDetail.id);
		      				}

		      				/*var vehicleNo = form.down("#vehicleNo");
		      				vehicleNo.getStore().getProxy().extraParams = {
		      					vehicleNumber: vehicleNoSearch
		      				};*/

		      				var srForm = this$.getServiceRouteDetailForm();
		      				var transServiceRouteId = srForm.down("#transServiceRouteId").getValue();

		      				Ext.Ajax.request({
		      					method : 'GET',
		      					type : 'rest',
		      					url: SERVERURL.PATH_FIND_ACADEMY_LOCATIONS_BY_SERVICE_ROUTE_ID,
		      					params: {
		      						transServiceRouteId : transServiceRouteId
		      					},
		      					success : function(record, action) {
		      						var record = Ext.decode(record.responseText);
		      						var alids=[];
		      						for (var i in record) {
		      							alids.push(record[i].id);
		      						}
		      						var vehicleNo = form.down("#vehicleNo");
		      						vehicleNo.getStore().getProxy().extraParams = {
		      							academyLocationIds: alids.join()
		      						};

		      						vehicleNo.getStore().load({
		      							callback : function(rec,operation,success){
		      								vehicleNo.setValue(data.vehicle.id);
		      								form.down("#resourceCode").setValue(data.vehicle.resourceCode);
		      							}
		      						});
		      					}
		      				});

		      				var isActive = form.down("#isActive");
		      				isActive.getStore().load({
		      					callback : function(res,operation,success){
		      						if(data.whetherActive==true){
		      							isActive.setValue(getTransportTranslation('YES'));
		      						}else{
		      							isActive.setValue(getTransportTranslation('NO'));
		      						}
		      					}
		      				});
		      			}
		      		 });
		      		}else{
		      			 showWarningMessage(getTransportTranslation('VEHICLE_LINKED'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		      		} 
		      },
		      getViewVehicleServiceLinkDetail : function(obj){
		    	  this.getEditVehicleServiceLinkDetail(obj);
		    		var form =this.getVehicleServiceRouteLinkForm();
		    		if (form) {
		    			form.down('#SubmitBtn').setVisible(false);
		    			form = form.getForm();
		    		    toggleReadOnlyFormItems(form,true);
		    		}
		      },
		      getDeleteVehicleServiceLinkDetail:function(){
		    	  var $this=this;
				  var grid = $this.getVehicleServiceRouteLinkGrid();
             	 if (grid.getSelectionModel().getCount() > 0) {
             		 var records = grid.getSelectionModel().getSelection()[0];
             		 var id=records.get("id");
             		showConfirmMessage(getTransportTranslation('VEHICLE_LINKED'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
             				 function(btn, text) {
             			 if (btn == 'yes'){
		             		 Ext.Ajax.request({
		             			 method: "DELETE",
		             			 type: 'rest',
		             			 url: SERVERURL.VL_TO_SR_DELETE_URL+'?id='+id,
		             			 headers: {
		             				 'Content-Type': 'application/json'
		             			 },
		             			 success: function(form, action) {
		             				 grid.store.reload();
		             				 showSuccessMessage(getTransportTranslation('VEHICLE_LINKED'), getTransportTranslation('VEHICLE_LINK_SUCCESFULLY_DELETED'));
		             			 }
		             		 });
             			 }
             		 });
             	 } else {
             		 showWarningMessage(getTransportTranslation('VEHICLE_LINKED'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
             	 }
		      },
		      /**
		       * People Covered linked to service route Tab
		       * 
		       */
		      getRenderPeopleCoveredTab : function(){
		    	  var serviceRouteform = this.getServiceRouteDetailForm();
		    	  var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	  var grid = this.getPeopleCoveredGrid();
		    	  var store = grid.getStore();
		    	  store.getProxy().extraParams = {
		    		  transServiceRouteId:transServiceRouteId
		    	  };
		    	  store.load();
		    	  
		    	// for view mode
		    	  var mode = serviceRouteform.down("#buttonId").getValue();
		    	  if(mode=='ViewMode'){
		    	  		buttonsToolBar = grid.query('toolbar')[0];
		    	  		buttonsToolBar.query('#btnAdd')[0].setVisible(false);
		    	  		buttonsToolBar.query('#btnEdit')[0].setVisible(false);
		    	  		buttonsToolBar.query('#btnDelete')[0].setVisible(false);
		    	  		buttonsToolBar.query('#sendMessageBtn')[0].setVisible(false);
		    	  }
		      },
		      getClosePeopleCovered : function(obj){
		    	  this.getPeopleCoveredWindow().close();
		      },
		      getSavePeopleCoveredDetail : function(){
		    	   var this$ = this;
		    	   var serviceRouteform = this.getServiceRouteDetailForm();
			       var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	   var grid = this$.getPeopleCoveredGrid();
		       	   var gridStore = grid.getStore();
		    	   var form = this$.getPeopleCoveredForm();
		    	   var values = form.getForm().getValues();
		    	   form.down('#SubmitBtn').setDisabled(true);
		    	   var personCoveredModel = new Academia.model.transport.serviceRoute.PeopleCoveredSubmitData();
		    	   personCoveredModel.set("transServiceRoute",this.getIdValueJson(transServiceRouteId));
		    	   personCoveredModel.set("transServiceRouteStop",this.getIdValueJson(values.transServiceRouteStop));
		    	   personCoveredModel.set("user",this.getIdValueJson(values.userId));
		    	   personCoveredModel.set("userName",values.userName);
		    	   //personCoveredModel.set("dateAdded",Ext.Date.format(new Date(),CONSTANTS.DISPLAY_DATE_FORMAT));
		    	   personCoveredModel.set("dateAdded",values.dateAdded);
		    	   personCoveredModel.set("addtionEffectiveFrom",values.addtionEffectiveFrom);
		    	   //personCoveredModel.set("dateRemoved",Ext.Date.format(new Date(),CONSTANTS.DISPLAY_DATE_FORMAT));
		    	   personCoveredModel.set("dateRemoved",values.dateRemoved);
		    	   personCoveredModel.set("removalEffectiveForm",values.removalEffectiveForm);
		    	   personCoveredModel.set("usageStatus",values.usageStatus);
		    	
		    	   var submitUrl;
		    	   var message;
		    	   
		    	   if (values.id == null || values.id == "") {
		    		   submitUrl = SERVERURL.PEOPLE_COVERED_CREATE_URL;
		    		   message = getTransportTranslation('PEOPLE_COVERED_SUCCESFULLY_CREATED');
		    	   } else {
		    		   personCoveredModel.set("id",values.id);
		    		   submitUrl = SERVERURL.PEOPLE_COVERED_UPDATE_URL;
		    		   message = getTransportTranslation('PEOPLE_COVERED_SUCCESFULLY_UPDATED');
		    	   }
		    	   var submitData = Ext.encode(personCoveredModel.data);
		    	   this$.applyWindowMask(); 
		    
		    	   Ext.Ajax.request({
		    		   url: submitUrl,
		    		   jsonData: submitData,
		    		   timeout:60000,
		    		   method: 'POST',
		    		   success: function(response) {
		    			   if(response.responseText.startsWith("success")||response.responseText.includes("true")){
		    			   this$.hideWindowMask();
		    			   this$.getClosePeopleCovered();
		    			   gridStore.reload();
		    			   grid.getSelectionModel().deselectAll(true); 
		    			   showSuccessMessage(getTransportTranslation('PEOPLE_COVERED'),message);	
		    			   }else{
		    				   form.down('#SubmitBtn').setDisabled(false);
		    				    this$.hideWindowMask();
	                    		showWarningMessage(getCommonTranslation('ALERT'),response.responseText); 
	                    		
		    			   }
		   		}});
		      },
		      getOpenPeopleCoveredDetail : function(obj){
		    	  var serviceRouteform = this.getServiceRouteDetailForm();
		    	  var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
		    	  var frmWin = this.getPeopleCoveredWindow();
		    	  if(!frmWin){
		    		  Ext.widget('peoplecoveredwindow');
		    		  frmWin = this.getPeopleCoveredWindow();
		    	  }
		    	  frmWin.show();
		    	  
		    	  if(obj.itemId=='btnAdd'){
		    		  frmWin.down('#userType').setValue(3);
		    		  this.loadPeopleCoverWindowUserCombo(frmWin)
		    		  var grid = this.getPeopleCoveredGrid();
				      	if (grid.getSelectionModel().getCount() > 0) {
		    		        grid.getSelectionModel().deselectAll(true);  
				      	}
		    	  }
		    	  var srForm = this.getServiceRouteDetailForm();
		    	  var academyLocationIds = srForm.getForm().findField('academyLocations').getValue();
		    	  var academyLocationId = srForm.getForm().findField('academyLocationId').getValue();
		    	  var academyLocations=[];
		    	  if(Ext.isObject(academyLocationIds[0])){
		    		  for(var i in academyLocationIds){
		    			  academyLocations.push(academyLocationIds[i].get("id"));
		    		  }
		    	  }else{
		    		  academyLocations = academyLocationIds;
		    	  }
		    	  console.log('academyLocations',academyLocations);
		    	  console.log('academyLocationId',academyLocationId);
		    	  academyLocations.push(academyLocationId);
		  	      var uniqueresultArr =  this.unique(academyLocations);
		  	      console.log(uniqueresultArr);
		    	   var academyLocationId = uniqueresultArr.join();
		    	   console.log('academyLocationId',academyLocationId);
		    	    var form  = this.getPeopleCoveredForm();
			    	/*var field=form.down("#userId");
			    	var fieldStore =field.getStore();
			    	fieldStore.getProxy().extraParams = {
			    		serviceName:'Transport',
			    		academyLocationIds : academyLocationId
			    	};*/
		    	  var srviceRouteStop = form.down("#srviceRouteStop");
		    	  var store = srviceRouteStop.getStore();
			    	store.getProxy().extraParams = {
			    		academyLocationIds : academyLocationId,
			    		transServiceRouteId : transServiceRouteId
			    	};
			    	store.load();
		      },
		      getEditPeopleCoveredDetail : function(obj){
		    	var this$ = this;
		        var grid = this$.getPeopleCoveredGrid();
		      	if (grid.getSelectionModel().getCount() > 0) {
		      		this$.getOpenPeopleCoveredDetail(obj);
		      		var form = this$.getPeopleCoveredForm();
		      		this$.applyWindowMask(getCommonTranslation('LOADING_MASK')); 
		      		var record = grid.getSelectionModel().getSelection()[0];
		      		var id = record.get("id");
		      		var editUrl = SERVERURL.PEOPLE_COVERED_FINDBYID_URL;
		      		Ext.Ajax.request({
		      			method: "GET",
		      			type: 'rest',
		      			url: editUrl,
		      			params: {
		      				id: id
		      			},
		      			success: function(f, action) {
		      				var data = Ext.JSON.decode(f.responseText);
		      				if(!isNullOrEmpty(data.addtionEffectiveFrom))
		      					data.addtionEffectiveFrom = new Date(data.addtionEffectiveFrom);
		      				if(!isNullOrEmpty(data.dateAdded))
		      					data.dateAdded = new Date(data.dateAdded);
		      				if(!isNullOrEmpty(data.dateRemoved))
		      					data.dateRemoved = new Date(data.dateRemoved);
		      				if(!isNullOrEmpty(data.removalEffectiveForm))
		      					data.removalEffectiveForm = new Date(data.removalEffectiveForm);
		      				var pcModel = new Academia.model.transport.serviceRoute.PeopleCoveredSubmitData(data);
		      				form.loadRecord(pcModel);
		      				var user = form.down("#userId");
		      				if(pcModel.get("user")){
		      					var userType = form.down("#userType");
		      					userType.setValue(data.user.userGroup.id);	
		      					//var userStore = user.getStore();
		      					this$.loadPeopleCoverWindowUserCombo(form, data.user.id)
		      					/*userStore.getProxy().extraParams = {
		      							serviceName: userStore.getProxy().extraParams.serviceName,
		            					userType : data.user.userGroup.id,
		            					academyLocationIds: userStore.getProxy().extraParams.academyLocationIds
		        				};
		      					userStore.load({
	      						callback : function(rec,operation,success){
	      							user.setValue(data.user.id);		      							
	      						}
	      					});*/
		      				}
		      				if(pcModel.get("userName")){
		      					user.setVisible(false);
		      					var userNameCombo = form.down("#userName");
		      					userNameCombo.setFieldLabel('External');
		      					userNameCombo.setVisible(true);
		      					this$.setAllowBlank(userNameCombo, false);
		      					var userType = form.down("#userType");
      							userType.setValue(0);
      							userNameCombo.setValue(pcModel.get("userName"));
		      					/*userType.getStore().load({
		      						callback : function(rec,operation,success){
		      							userType.setValue(0);
		      							form.down("#userName").setValue(pcModel.get("userName"));
		      						}
		      					});*/
		      				}
		      				this$.hideWindowMask(); 
		      				var usageStatus = form.down("#usageStatus");
		      				usageStatus.getStore().load({
		      					callback : function(res,operation,success){
		      						usageStatus.setValue(pcModel.get("usageStatus"));
		      					}
		      				});
		      				if(pcModel.get("transServiceRouteStop")){
		      				var srviceRouteStop = form.down("#srviceRouteStop");
		      				srviceRouteStop.getStore().load({
		      					callback : function(res,operation,success){
		      						srviceRouteStop.setValue(pcModel.get("transServiceRouteStop").id);
		      					}
		      				});
		      			}}
		      		 });
		      		}else{
		      			 showWarningMessage(getTransportTranslation('PEOPLE_COVERED'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		      		} 
		      },
		      getViewPeopleCoveredDetail : function(obj){
		    	  this.getEditPeopleCoveredDetail(obj);
		    		var form =this.getPeopleCoveredForm();
		    		if (form) {
		    			form.down('#SubmitBtn').setVisible(false);
		    			form = form.getForm();
		    		    toggleReadOnlyFormItems(form,true);
		    		}
		      },
		      getDeletePeopleCoveredDetail:function(){
		    	  var $this=this;
				  var grid = $this.getPeopleCoveredGrid();
             	 if (grid.getSelectionModel().getCount() > 0) {
             		 var records = grid.getSelectionModel().getSelection()[0];
             		 var id=records.get("id");
             		showConfirmMessage(getTransportTranslation('PEOPLE_COVERED'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
             				 function(btn, text) {
             			 if (btn == 'yes'){
		             		 Ext.Ajax.request({
		             			 method: "DELETE",
		             			 type: 'rest',
		             			 url: SERVERURL.PEOPLE_COVERED_DELETE_URL+'?id='+id,
		             			 headers: {
		             				 'Content-Type': 'application/json'
		             			 },
		             			 success: function(form, action) {
		             				 grid.store.reload();
		             				 showSuccessMessage(getTransportTranslation('PEOPLE_COVERED'), getTransportTranslation('PEOPLE_COVERED_SUCCESFULLY_DELETED'));
		             			 }
		             		 });
             			 }
             		 });
             	 } else {
             		 showWarningMessage(getTransportTranslation('PEOPLE_COVERED'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
             	 }
		      },
		      /**
		       * delete service route detail
		       */
		     getDeleteServiceRouteDetail : function(){
		    	 var $this=this;
		    	 var grid = $this.getServiceRouteMasterGrid();
		    	  
            	 if (grid.getSelectionModel().getCount() > 0) {
            		 var records = grid.getSelectionModel().getSelection()[0];
            		 var id=records.get("id");
            		 showConfirmMessage(getTransportTranslation('DATE_EXCEPTION'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
            				 function(btn, text) {
            			 if (btn == 'yes'){
		             		 Ext.Ajax.request({
		             			 method: "DELETE",
		             			 type: 'rest',
		             			 url: SERVERURL.SERVICE_ROUTE_DELETE_URL+'?id='+id,
		             			 headers: {
		             				 'Content-Type': 'application/json'
		             			 },
		             			 success: function(form, action) {
		             				 if(form.responseText == '0') {
		             					showWarningMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'), getTransportTranslation('SERVICE_ROUTE_DELETE_MSG'));
		             				 } else {
		             					grid.store.reload();
			             				showSuccessMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'), getTransportTranslation('SERVICE_ROUTE_SUCCESFULLY_DELETED'));
		             				 }
		             			 }
		             		 });
            			 }
            		 });
            	 } else {
            		 showWarningMessage(getTransportTranslation('SERVICE_ROUTE_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
            	 }
		     },
		     getServiceRouteStoppageDetail : function() {
		    	 var $this = this;
		    	 var grid = $this.getServiceRouteMasterGrid();
		    	 var academyLocationId = $this.getCurrentAcademyLocation();
		    	 var records = grid.getSelectionModel().getSelection();
		    	 var tansIdArr = new Array();
		    	 if(!isNullOrEmpty(records) && records.length > 0) {
		    		 for( var i=0; i<records.length; i++ ) {
		    			 if(!isNullOrEmpty(records[i].data.id)){
		    				 tansIdArr.push(records[i].data.id);
		    			 }
		    		 }
		    		 var reportParams = new Object();
                     var reportTitle = 'Route Stop Timing Report Pdf';
                     var code = 'ROUTE_STOPE_TIMING_REPORT_PDF';
                     reportParams.code = code;
                     reportParams.reportTitle = reportTitle;
                     reportParams.serviceRouteIds = tansIdArr.join(',');

                     $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.SERVICE_ROUTE_EXPORT_PDF_ROUTE_REPORT);
		    	 } else {
		    		 showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		         }
		     },
		     getExcelServiceRouteStoppageDetail : function() {
		    	 var $this = this;
		    	 var grid = $this.getServiceRouteMasterGrid();
		    	 var academyLocationId = $this.getCurrentAcademyLocation();
		    	 var records = grid.getSelectionModel().getSelection();
		    	 var tansIdArr = new Array();
		    	 if(!isNullOrEmpty(records) && records.length > 0) {
		    		 for( var i=0; i<records.length; i++ ) {
		    			 if(!isNullOrEmpty(records[i].data.id)){
		    				 tansIdArr.push(records[i].data.id);
		    			 }
		    		 }
		    		 var reportParams = new Object();
                     var reportTitle = 'Route Stop Timing Report Excel';
                     var code = 'ROUTE_STOPE_TIMING_REPORT_EXCEL';
                     reportParams.code = code;
                     reportParams.reportTitle = reportTitle;
                     reportParams.serviceRouteIds = tansIdArr.join(',');

                     $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.SERVICE_ROUTE_EXPORT_EXCEL_ROUTE_REPORT);
		    	 } else {
		    		 
		    		 showWarningMessage(getServiceRequestTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		         }
		     },

		     removeDynamicFields : function(obj){
		    	 var form = obj.up('form');
		    	 var panel = form.down('#serviceStopPanelId');
		    	 var fromSchlPanel = form.down('#fromSchlServiceStopPanelId');
		    	 for(var i=panel.items.length-2; i>0;i--){
		    		 panel.remove(panel.items.items[i]);
		    	 }
		    	 
		    	 for(var i=fromSchlPanel.items.length-2; i>0;i--){
		    		 fromSchlPanel.remove(fromSchlPanel.items.items[i]);
		    	 }
		    	 form.doLayout();
		     },
		   /*
		    * check uniqe user 
		    */
		     getUniqueCheckUser : function(obj,params){
		    	 if(!isNullOrEmpty(params.userName)){ 
		    		 var form = obj.up('form');
		    		 Ext.Ajax.request({
		    			 method: "GET",
		    			 type: 'rest',
		    			 url: SERVERURL.SERVICE_ROUTE_USER_UNIQUENESS,
		    			 params:params, 
		    			 success: function(f, action) {
		    				 var data = Ext.JSON.decode(f.responseText);
		    				 if(data==false){
		    					 form.down("#userId").reset();
		    					 form.down("#userName").reset();
		    					 /* form.down("#dateAdded").reset();
			     				 form.down("#addtionEffectiveFrom").reset();
			     				 form.down("#dateRemoved").reset();
			     				 form.down("#removalEffectiveForm").reset();*/
		    					 showWarningMessage(getTransportTranslation('PEOPLE_COVERED'),getTransportTranslation('USER_ALREADY_EXIST')); //Please select a record
		    				 }
		    			 }
		    		 });
		    	 }
		     },
		     timeFormator : function(value){
                 var time="";
                 if(!isNullOrEmpty(value)){
                	  var model = new Academia.model.transport.serviceRoute.TimeDataModel;
                	  model.set('startTime',value);
                     time=Ext.Date.format(model.get('startTime'), 'g:i A');
                 }
                 return time;
             },
             unique : function(list) {
            	 var newArr = [];
            	 var found;
            	 for (var i = 0; i < list.length;i++) {
            		 found = undefined;
            		 for (var j=0; j<newArr.length;j++) {
            			 if (list[i] == newArr[j]) {
            				 found = true;
            				 break;
            			 }
            		 }
            		 if (!found) {
            			 newArr.push(list[i]);
            		 }
            	 }
            	 return newArr;
             },
             showHideTimeFields : function(obj){
            	 //var form = obj.up('form').getForm();
            	 var me = this;
            	 var form = this.getServiceRouteDetailForm().getForm();
            	 var max = form.findField("reachTime").getValue();
            	 var min = form.findField("startTime").getValue();
            	 var isWithTime = form.findField('recordStopListWithTimes').getValue();
            	 var count = 0;
            	 var countFrom = 0;
            	 if(isWithTime=='YES'){
            		// Ext.suspendLayouts();
            		 form.getFields().each(function(field) {
            			 var count1 = 2;
            			 if(field.name == 'arrivalTime' || field.name == 'departureTime') {
            				 if(count1>count){
            					 field.setVisible(true);
                				 field.allowBlank=false;
                				 field.setMaxValue(max);
                				 field.setMinValue(min);
                				 count++;
            				 }
            				 
            				 //var forms = $this.getServiceRouteDetailForm().getForm();
            				 /*
            				 departureTimeField.setMinValue(form.down("#startTime").getValue());
             				departureTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());
             				var arrivalTimeField = form.down("#startArrivalTime");
             				arrivalTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());*/
            				 
            				// Ext.resumeLayouts();
            			 } 
            			 if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
            				 
            				 if(count1>countFrom){
            					 field.setVisible(true);
                				 field.setMaxValue(max);
                				 field.setMinValue(min);
                				 countFrom++;
            				 }
            				
            				 //field.allowBlank=false;
            				 var forms = me.getServiceRouteDetailForm().getForm();
            				 /*
            				 departureTimeField.setMinValue(form.down("#startTime").getValue());
             				departureTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());
             				var arrivalTimeField = form.down("#startArrivalTime");
             				arrivalTimeField.setMaxValue(form.down("#reachEndLocationAt").getValue());*/
            				// Ext.resumeLayouts();
            			 } 
            		 });
            	 }else{
            		 Ext.suspendLayouts();
            		 form.getFields().each(function(field) {
            			 if(field.name == 'arrivalTime' || field.name == 'departureTime') {
            				 field.setVisible(false);
            				 field.reset();
            				 field.allowBlank=true;
            				 form.isValid();
            				 Ext.resumeLayouts();
            			 } 
            			 if(field.name == 'fromSchlArrivalTime' || field.name == 'fromSchlDepartureTime') {
            				 field.setVisible(false);
            				 field.reset();
            				 //field.allowBlank=true;
            				 //form.isValid();
            				 Ext.resumeLayouts();
            			 } 
            		 });
            	 }
             },
             
             loadPeopleCoverWindowUserCombo : function(form, userIdValue) {
            	var $this = this;
            	var userTypeCombo = form.down('#userType');
            	var userType = userTypeCombo.getValue();
                var userId = form.down('#userId');
                userId.setFieldLabel(userTypeCombo.rawValue);
                this.setAllowBlank(userId, false);
                form.down('#userName').allowBlank = true;
                var serviceRouteform = this.getServiceRouteDetailForm();
		        var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
               
		        Ext.Ajax.request({
                	method : 'GET',
    	    		type : 'rest',
    	    		url: SERVERURL.PATH_FIND_ACADEMY_LOCATIONS_BY_SERVICE_ROUTE_ID,
	      			params: {
	      				transServiceRouteId : transServiceRouteId
	      			},
    	    		success : function(record, action) {
    	    			var record = Ext.decode(record.responseText);
    	    			var store = userId.getStore();
        	        	var alids=[];
        	        	for (var i in record) {
	        				alids.push(record[i].id);
	        			}
        	        	if(userIdValue != null) {
        	        		transServiceRouteId = null;
        	        	}
        	        	store.getProxy().extraParams = {
        	        		serviceName:'Transport',
        					userType : userType,
        					transServiceRouteId : transServiceRouteId,
        					academyLocationIds:alids.join()
        				};
        	        	store.load({
      						callback : function(rec,operation,success){
      							if(! isNullOrEmpty(userIdValue)) {
      								userId.setValue(userIdValue);
      								userTypeCombo.setReadOnly(true);
      								userId.setReadOnly(true);
      							}
      						}
      					});
    	    		}
    	    	});
             },
             loadUserComboData : function(combo) {
					var this$ = this;
						combo.getStore().on('beforeload', function(){
							var serviceroutedetailform = this$.getServiceRouteDetailForm();
							var userTypeCombo = serviceroutedetailform.down('#userType');
							var userType = userTypeCombo.getValue();
							var alCombo = serviceroutedetailform.down('#allAcademyLocationId');
							var academyLocationId = alCombo.getValue();
							var alIds = [];
							var academyLocationIds = null;
							var store = combo.getStore();
							
								if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0]) && !isNullOrEmpty(userType) && userType != 0) {
									for (var i in academyLocationId) {
										if (Ext.isObject(academyLocationId[0])) {
											alIds.push(academyLocationId[i].get("id"));
										} else {
											alIds.push(academyLocationId[i]);
										}
									}
									academyLocationIds = alIds.join();
								    if(!isNullOrEmpty(store)) {
								    	store.getProxy().extraParams = {
								    		academyLocationIds : academyLocationIds,
											userType: userType
										};
								    }
									return true;
								} else {
									combo.rawValue = '';
									combo.lastValue = '';
									combo.lastQuery = '';
									 if(!isNullOrEmpty(combo.getStore())) {
										 combo.getStore().removeAll();
									 }
									return false;
								}
						});
				},
				showAssignDriverWindow: function(button){
					var grid = this.getVehicleServiceRouteLinkGrid();
					var serviceDetailForm = this.getServiceRouteDetailForm();
					if (grid.getSelectionModel().getCount() > 0) {
						var rec = grid.getSelectionModel().getSelection()[0];
						var transServiceRouteDriverDetail = rec.get("transServiceRouteDriverDetail");
						var formWindow = this.getAssigndriverdetailwindow();
						if (!formWindow) {
							Ext.widget('assigndriverdetailwindow');
							formWindow = this.getAssigndriverdetailwindow();
							var formPnl = formWindow.down('form');
							
							if(serviceDetailForm.config.mode == 'view'){
								toggleReadOnlyFormItems(formPnl.getForm(),true);
								formPnl.down('#SubmitBtn').setVisible(false);
							}
							var driverFld = formPnl.down('#driverId');
							var conductorFld = formPnl.down('#conductorId');

							var transServiceRouteId = serviceDetailForm.down("#transServiceRouteId").getValue();
					        
							Ext.Ajax.request({
								method : 'GET',
								type : 'rest',
								url: SERVERURL.PATH_FIND_ACADEMY_LOCATIONS_BY_SERVICE_ROUTE_ID,
								params: {
									transServiceRouteId : transServiceRouteId
								},
								success : function(record, action) {
									var record = Ext.decode(record.responseText);
									var alids=[];
									for (var i in record) {
										alids.push(record[i].id);
									}
									driverFld.getStore().getProxy().extraParams = {
										academyLocationIds : alids.join(),
										userType: 5
									};
									driverFld.getStore().load({
										callback:function(){
											if(!isNullOrEmpty(transServiceRouteDriverDetail)){
												driverFld.setValue(transServiceRouteDriverDetail.driverId.id);
												if(!isNullOrEmpty(transServiceRouteDriverDetail.conductorId)){
													conductorFld.setValue(transServiceRouteDriverDetail.conductorId.id);
												}
											}
										}
									});
								}
							});
							
							if(!isNullOrEmpty(transServiceRouteDriverDetail)){
								formPnl.getForm().setValues(transServiceRouteDriverDetail);
								var countryCodeFld = formPnl.down('#driverMobileCountryCode');
								var countryCodeConductorFld = formPnl.down('#conductorMobileCountryCode');
								countryCodeFld.getStore().load({
									callback:function(){
										countryCodeFld.setValue(transServiceRouteDriverDetail.driverMobileCountryCode);
									}
								});
								countryCodeConductorFld.getStore().load({
									callback:function(){
										countryCodeConductorFld.setValue(transServiceRouteDriverDetail.conductorMobileCountryCode);
									}
								});
								
							}
						}
						formWindow.show();
					}
					else {
						showWarningMessage(getTransportTranslation('VEHICLE_LINKED_LIST'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				},
				closeAssignDriverDetailWindow: function(){
					 this.getAssigndriverdetailwindow().close();
				},
				saveAssignDriverDetailWindow: function(){
					var this$ = this;
					var formWindow = this$.getAssigndriverdetailwindow();
					var getForm = formWindow.down('form').getForm();
					var formValues=getForm.getValues();
					var grid = this$.getVehicleServiceRouteLinkGrid();
					var serviceRouteform = this.getServiceRouteDetailForm();
					var transServiceRouteId = serviceRouteform.down("#transServiceRouteId").getValue();
					var submitUrl = '';
					var isUpdate = false;
					var rec = grid.getSelectionModel().getSelection()[0];

					if(isNullOrEmpty(formValues.id)){
						submitUrl = SERVERURL.PATH_TRANS_SERVICE_ROUTE_DRIVER_DETAIL_SAVE
					}
					else{
						submitUrl = SERVERURL.PATH_TRANS_SERVICE_ROUTE_DRIVER_DETAIL_UPDATE
						isUpdate = true;
					}
					if(!isNullOrEmpty(formValues.conductorId)){
						var data = {
								"id":formValues.id,
								"licenseNumber" : formValues.licenseNumber,
								"driverMobileCountryCode" : formValues.driverMobileCountryCode,
								"driverMobileNumber" : formValues.driverMobileNumber,
								"conductorMobileCountryCode" : formValues.conductorMobileCountryCode,
								"conductorMobileNumber" : formValues.conductorMobileNumber,
								"driverId" : {
									"id" : formValues.driverId
								},
								"conductorId" : {
									"id" : formValues.conductorId
								},
								"transServiceRouteVehicleId":rec.get("id")
						}
					}
					else{
						var data = {
								"id":formValues.id,
								"licenseNumber" : formValues.licenseNumber,
								"driverMobileCountryCode" : formValues.driverMobileCountryCode,
								"driverMobileNumber" : formValues.driverMobileNumber,
								"conductorMobileCountryCode" : formValues.conductorMobileCountryCode,
								"conductorMobileNumber" : formValues.conductorMobileNumber,
								"driverId" : {
									"id" : formValues.driverId
								},
								"transServiceRouteVehicleId":rec.get("id")
						}
					}
					this$.applyWindowMask(); 
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : data,
						method : 'POST',
						success : function(resp, action) {
							this$.hideWindowMask();
							formWindow.close();
							var store = grid.getStore();
							store.getProxy().extraParams = {
								transServiceRouteId : transServiceRouteId
							};
							store.load();
							grid.getSelectionModel().deselectAll(true);
							if(isUpdate){
								showSuccessMessage(getTransportTranslation('TRANS_DRIVER_DETAIL'), getTransportTranslation('TRANS_DRIVER_DETAIL_UPDATED_SUCCESSFULLY'));	
							}
							else{
								showSuccessMessage(getTransportTranslation('TRANS_DRIVER_DETAIL'), getTransportTranslation('TRANS_DRIVER_DETAIL_ADDED_SUCCESSFULLY'));
							}
							
						}
					});
				},
				
				/*Added for Adhoc messaging*/
				selectSectionMessageType : function(val,nV,oV){

			      	 var $this =  this;
			      	 var formWin = $this.getServiceroutesendmessages();

			      	 //var value = nV.1;
			      	 if(nV.messageType==2){
			      		 formWin.down("#messageId").hide();
			      		 formWin.down("#selectTemplate").allowBlank=true;
			      		 formWin.down("#selectTemplate").setVisible(false);     		 
			      		 formWin.down("#messageName").allowBlank=true;   
			      		 formWin.down("#messageName").setVisible(false);
			      		 formWin.down("#msgTempletId").setVisible(true);
			      		 formWin.down("#msgTempletId").allowBlank=false;
			      		 formWin.down("#msgTempletId").reset();
			      		 formWin.down("#subject").setVisible(true);
			      		 //formWin.down("#subject").allowBlank=false;
			      		 formWin.down("#subject").reset();
			      		 formWin.down("#discriptionId").setVisible(true);
			      		 formWin.down("#discriptionId").reset();
			      		 formWin.down('#smsDiscription').reset();
			      		 formWin.down('#smsDiscription').hide();
			      		 formWin.down('#smsDiscriptionNotice').hide();
			     		 formWin.down('#pushNotificationDiscription').hide();
			     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
			      		 this.setAllowBlank (formWin.down("#subject"),false);
			      	 }else{
			      		 formWin.down("#msgTempletId").allowBlank=true;
			      		 formWin.down("#msgTempletId").setVisible(false);     		
			      		 formWin.down("#messageId").setVisible(true);
			      		 formWin.down("#selectTemplate").setVisible(true);     		
			      		 formWin.down("#messageName").setVisible(true);
			      		 formWin.down("#messageName").reset();
			      		 //formWin.down("#subject").allowBlank=true;
			      		 this.setAllowBlank (formWin.down("#subject"),true);
			      		 formWin.down("#subject").setVisible(false);
			      		 formWin.down("#discriptionId").setVisible(false);
			      		 formWin.down("#messageName").allowBlank=false;  
			      		 formWin.down("#selectTemplate").allowBlank=false;
			      		 formWin.down("#selectTemplate").reset();
			      		 formWin.down("#servicerRouteStaticDocumentAttachmentGrid").setVisible(false);
			      		 formWin.down("#staticUploadFileField").setVisible(false);
			      		 formWin.down('#smsDiscription').reset();
			      		 formWin.down('#smsDiscription').hide();
			      		 formWin.down('#smsDiscriptionNotice').hide();
			     		 formWin.down('#pushNotificationDiscription').hide();
			     		 formWin.down('#pushNotificationDiscriptionNotice').hide();
			      		 this.setAllowBlank (formWin.down("#messageName"),false);
			      		 this.setAllowBlank (formWin.down("#selectTemplate"),false);
			      		// var allowblankFalse = '<span class="required" style="color:red"> *</span>';
			      		// formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
			      		 //formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
			      	 }
			       },
			       selectMessageTemp: function(obj,rec){
				       	var $this =  this;
				       	 var formWin = $this.getServiceroutesendmessages();
				      	 var subject = formWin.down('#subject');
				      	 var smsDiscription = formWin.down('#smsDiscription');
				 		 var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
				 		 var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
				 		 var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
				       	 if(rec[0].data.value == "SMS")
				       	 {  
				       		 this.setAllowBlank (formWin.down("#subject"),true);
				       		 //formWin.down("#subject").allowBlank=true;
				       		 formWin.down("#subject").hide();
				       		 formWin.down("#staticUploadFileField").hide();
				       		 formWin.down("#servicerRouteStaticDocumentAttachmentGrid").hide();
				       		 formWin.down('#discriptionId').reset();
				       		 formWin.down('#discriptionId').hide();	       		 
				       		 formWin.down('#subject').reset();
				       		 formWin.down('#smsDiscription').show();
				       		 formWin.down('#smsDiscriptionNotice').show();
				      		 pushNotificationDiscription.hide();
				      		 pushNotificationDiscriptionNotice.hide();
				      		 pushNotificationDiscription.reset();
				       	 }else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only"){
				       		 formWin.down('#discriptionId').reset();
				       		 formWin.down('#smsDiscription').reset();
				       		 formWin.down('#smsDiscription').hide();
				       		 formWin.down('#smsDiscriptionNotice').hide();
				       		 formWin.down("#staticUploadFileField").hide();
				       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
				       		 formWin.down("#servicerRouteStaticDocumentAttachmentGrid").hide()
				       		 formWin.down("#subject").show();
				       		 this.setAllowBlank (formWin.down("#subject"),false);
				       		 //formWin.down("#subject").allowBlank=false;
				       		 formWin.down('#discriptionId').show();
				      		 pushNotificationDiscription.hide();
				      		 pushNotificationDiscriptionNotice.hide();
				      		 pushNotificationDiscription.reset();
				       	 }
				       	 /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
				      		 subject.show();
				      		 formWin.down("#staticUploadFileField").hide();
				      		 this.setAllowBlank(subject,false);
				      		 formWin.down("#servicerRouteStaticDocumentAttachmentGrid").hide();
				      		 formWin.down('#discriptionId').reset();
				      		 formWin.down('#discriptionId').hide();
				      		 subject.reset();
				      		 smsDiscription.reset();
				      		 smsDiscription.hide();
				      		 smsDiscriptionNotice.hide();
				      		 pushNotificationDiscription.reset();
				      		 pushNotificationDiscription.show();
				      		 pushNotificationDiscriptionNotice.show();
				      		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
				      		 //formWin.down('#smsDiscription')
				      	 }*/else{
				       		 formWin.down('#discriptionId').reset();
				       		 formWin.down('#smsDiscription').reset();
				       		 formWin.down('#smsDiscription').hide();
				       		 formWin.down('#smsDiscriptionNotice').hide();
				       		 formWin.down("#staticUploadFileField").show();
				       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
				       		 formWin.down("#servicerRouteStaticDocumentAttachmentGrid").show()
				       		 formWin.down("#subject").show();
				       		 this.setAllowBlank (formWin.down("#subject"),false);
				       		 //formWin.down("#subject").allowBlank=false;
				       		 formWin.down('#discriptionId').show();
				      		 pushNotificationDiscription.hide();
				      		 pushNotificationDiscriptionNotice.hide();
				      		 pushNotificationDiscription.reset();
				       	 }
				       },
				       /**
				        * upload static document file for Student
				        */
				       uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
				    	   var this$ = this;
				    	   var setupForm = fileField.up('serviceroutesendmessages');
				    	   var grid = setupForm.down('#servicerRouteStaticDocumentAttachmentGridMessage');
				    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
				    	   fileField.setRawValue(fileUploadPath);
				    	   var file = fileField.fileInputEl.dom.files[0];
				    	   fileField.setRawValue(fileUploadPath);
				    	   if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
				    		   if(!isNullOrEmpty(fileUploadPath)){
				    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
				    			   if (extension == "gif" || extension == "png" || extension == "bmp"
				    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
				    					   || extension == "doc" || extension == "docx" || extension == "txt"
				    						   || extension == "xls" || extension == "csv" || extension == "xml" 
				    							   || extension == "zip" || extension == "xlsx" || t == "ppt" || t == "pptx") {
				    				   var entityId = 'student';
				    				   var module = 'messaging';
				    				   var entityType = 'template';
				    				   var documentType = 'DOCUMENT';
				    				   var isTransient = true;
				    				   var this$ = this;
				    				   this$.saveServiceRouteStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
				    					   if(success){
				    						   var path = Ext.JSON.decode(action.response.responseText).path;
				    						   var user = this$.getCurrentlyLoggedInUser();
				    						   var store = grid.getStore();
				    						   var documentStatus = "SUBMITTED";
				    						   var documentType = null;
				    						   if(!isNullOrEmpty(path)){
				    							   store.add({
				    								   id: '',
				    								   name: fileUploadPath,
				    								   path: path ,
				    								   createdBy : {
				    									   id :user.id,
				    									   value : user.value,
				    									   code : user.code
				    								   },
				    								   status : documentStatus,
				    								   documentType : documentType,
				    								   templateConfigDocId: '',
				    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

				    							   });
				    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
				    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
				    						   }

				    						   fileField.reset();
				    					   }

				    				   }, isTransient);
				    			   }else{
				    				   fileField.reset();
				    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				    			   }
				    		   }
				    	   }else{
				    		   fileField.reset();
				    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				    	   }
				       },

				       /**
				        * Add value to grid
				        */
				       loadGridWithFileNameMessage:function(grid,value,store){
				    	   grid.bindStore(store);
				       },
				       /**
				        * Remove entry from grid
				        */
				       deleteServiceRouteStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
				    	   var grid = view.up('#servicerRouteStaticDocumentAttachmentGridMessage');
				    	   var panel = this.getContentPanel().getActiveTab();
				    	   var tabTitle = panel.title;
				    	   var store = grid.getStore();
				    	   var templateConfigDocId = record.get('templateConfigDocId');
				    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
				    	   if(!(tabTitle == viewTitle)){
				    		   if(!isNullOrEmpty(templateConfigDocId)){
				    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				    				   if (btn == 'yes') {
				    					   Ext.Ajax.request({
				    						   type: 'rest',
				    						   url: SERVERURL.STATIC_DOC_DELETE,
				    						   method: 'DELETE',
				    						   params: {
				    							   templateConfigDocId : templateConfigDocId
				    						   },
				    						   headers: {
				    							   'Content-Type': 'application/json'
				    						   },
				    						   success: function(form, action) {
				    							   store.remove(record);
				    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
				    						   }
				    					   });
				    				   }
				    			   });

				    		   }else{
				    			   store.remove(record);
				    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
				    		   }
				    	   }else{
				    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
				    	   }

				       },
				       /**
				        * save document file. It's external call method
				        * @param entityId : person id, It's mandatory. 
				        * @param module : module name, for student module 'student', It's mandatory.
				        * @param entityType : entity type, It's mandatory.
				        * @param documentType : document type, It's mandatory.
				        * @param isTransient : true or false (send json back to module controller or not)
				        * @param callBackFunction : callback function return in module controller. It's mandatory.
				        */
				       saveServiceRouteStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
				       	var submitUrl = '';
				       	var templateTab = this.getContentPanel();
				       	var formWin =  this.getServiceroutesendmessages();
				       	var form = formWin.down('#msgDetailsForm');
				       	var id = form.down('#document_hidden_field');
				           if (isNullOrEmpty(id.getSubmitValue())) {
				               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
				           }
				           var data = new Object();
				           if(!isNullOrEmpty(entityId)){
				           	data.entityId = entityId;
				           }else{
				           	data.entityId = null;
				           }
				           if(!isNullOrEmpty(module)){
				           	data.module = module;
				           }else{
				           	data.module = null;
				           }
				           if(!isNullOrEmpty(entityType)){
				           	data.entityType = entityType;
				           }else{
				           	data.entityType = null;
				           }
				           form.getForm().setValues(data);
				           form.getForm().submit({
				           	method : 'POST',
				           	url : submitUrl,
				           	success : function(form, action){
				           		callBackFunction(true, action, isTransient);
				           		
				           	}
				           });
				       }, 
				       /**
				        * This method is to enable schedule field
				        */
				       loadAdhocServiceRouteScheduleField : function(radio,newValue, oldValue){
				       	var adhocMessageForm = radio.up('form');
				       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
				       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
				       	var radioValue = radio.getValue().sendingPriority;
				       	
				       	if(radioValue=='IMMEDIATE'){
				       		scheduleDateField.setVisible(false);
				       		scheduleDateField.setDisabled(true);
				       		scheduleTimeField.setVisible(false);
				       		scheduleTimeField.setDisabled(true);    		
				       	}
				       	else if(radioValue=='SCHEDULE'){
				       		scheduleDateField.setVisible(true);
				       		scheduleDateField.setDisabled(false);
				       		scheduleTimeField.setVisible(true);
				       		scheduleTimeField.setDisabled(false);
				       	}
				       },
				       /**
				    	 * This method is used to getAdmission Ids for Student Parent sent messaging.
				    	 */
				       getAdhocServiceRouteRecipientIds : function(grid){
				    		
				    	   if (grid.getSelectionModel().getCount() > 0) {
				    		   var records = grid.getSelectionModel().getSelection();
				    		   //records[0].data.user.id;
				    		   var ids=[];
				    		   for(var i in records) {
				    			   ids.push(records[i].data.user.id);
				    		   }
				    	   }
				    		return ids;
				    	},
				    	 openStudentSendMessage:function(obj){

				    		var thisObj = this; 
				 	    	var grid = thisObj.getPeopleCoveredGrid();
				 	    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
				 	    	var gridData;
				 	    	if(grid.getSelectionModel().getCount() == 0){
				 	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				 	    	}
				 	    	else if(grid.getSelectionModel().getCount() > 0) {
				 	    		var $this=this;
				 	    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				 	    		var structure = Ext.widget('serviceroutesendmessages',{
				 	    			itemId:'serviceRouteSendMessagesItemId'
				 	    		});
				 	    		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
				 	    		/**
				 	    		 * This is to remove tab from content panel and open same tab again
				 	    		 */
				 	    		var getcontroller=this.getController('menu.CoreERPNavigationController');
				 	    		var getTab=getcontroller.getTab(tabName);
				 	    		if(getTab!=null){
				 	    			contentPanel.remove(getTab, true);
				 	    		}
				 	    		var formWindowTab = $this.getServiceroutesendmessages();
				 	    		formWindowTab.down("#selectTemplate").allowBlank=true;
				 	    		formWindowTab.down("#selectTemplate").setVisible(false);
				 	    		formWindowTab.down("#messageName").allowBlank=true;   
				 	    		formWindowTab.down("#messageName").setVisible(false);
				 	    		var templateStore = formWindowTab.down('#selectTemplate').getStore();
				 	    		templateStore.getProxy().extraParams={
				 	    			msgRecipientTypeId:2
				 	    		};
				 	    		templateStore.load();

				 	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 	    		Ext.Ajax.request({
				 	    			method : "GET",
				 	    			type : 'rest',
				 	    			async: false,
				 	    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=ServiceRouteTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
				 	    			headers : {
				 	    				'Content-Type' : 'application/json'
				 	    			},
				 	    			success : function(form,action) {
				 	    				var data = Ext.JSON.decode(form.responseText);
				 	    				formWindowTab.down("#id").setValue(data.id);
				 	    				formWindowTab.down("#code").setValue(data.code);
				 	    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
				 	    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
				 	    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
				 	    				Ext.getBody().unmask();

				 	    				//grid.getStore().reload();
				 	    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
				 	    			}
				 	    		});
				 	    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
				 	    		var sendToReciver = formWindowTab.down("#recieverType");
				 	    		
				 	    		var studArry = [];
				 	    		var facultyOtherUserArry = [];
				 	    		if(grid.getSelectionModel().getCount() > 1) {
					 	    		grid.getSelectionModel().getSelection().forEach(function(rec, index, opt) {
					 	    			gridData = rec.data.user.userGroup.value;
					 	    			if(gridData == 'Student'){
					 	    				studArry.push(rec.data.id);
					 	    			}
					 	    			else{
					 	    				facultyOtherUserArry.push(rec.data.id);
					 	    			}
					 	    		});
					 	    		if(studArry.length>0 && facultyOtherUserArry.length>0){
					 	    			$this.setAllowBlank(sendToReciver,false);
					 	    			sendToReciver.setVisible(true);
					 	    			sendToReciver.down('#adhocMessageParentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setValue(1);
					 	    			//sendToReciver.reset();
					 	    		}
					 	    		else if(studArry.length>0){
					 	    			$this.setAllowBlank(sendToReciver,false);
					 	    			sendToReciver.setVisible(true);
					 	    			sendToReciver.down('#adhocMessageParentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setValue(1);
					 	    			//sendToReciver.reset();
					 	    		}
					 	    		else if(facultyOtherUserArry.length>0){
					 	    			$this.setAllowBlank(sendToReciver,true);
					 	    			//sendToReciver.setValue(1);
					 	    			sendToReciver.setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setValue(1);
					 	    			sendToReciver.down('#adhocMessageParentSR').setVisible(false);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setVisible(false);
					 	    		}
					 	    	}
				 	    		else if(grid.getSelectionModel().getCount() == 1) {
				 	    			gridData = grid.getSelectionModel().getSelection()[0].data.user.userGroup.value
				 	    			
				 	    			if(gridData == 'Student'){
					 	    			//sendToReciver.allowBlank = false;
					 	    			$this.setAllowBlank(sendToReciver,false);
					 	    			sendToReciver.setVisible(true);
					 	    			sendToReciver.down('#adhocMessageParentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setValue(1);
					 	    			//sendToReciver.reset();
					 	    		}else{
					 	    			//sendToReciver.allowBlank = true;
					 	    			$this.setAllowBlank(sendToReciver,true);
					 	    			//sendToReciver.setValue(1);
					 	    			sendToReciver.setVisible(true);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setValue(1);
					 	    			sendToReciver.down('#adhocMessageParentSR').setVisible(false);
					 	    			sendToReciver.down('#adhocMessageStudentSR').setVisible(false);
					 	    			//sendToReciver.down('[name=recieverType]').setValue(true);
					 	    		}
				 	    		}
				 	    	}
				 	    },
				 	    disableSendBtnButton:function(column,selected) {
				 	    	var grid = this.getPeopleCoveredGrid();
				 	    	var record = grid.getSelectionModel().getSelection()[0];
				 	    	var serviceDetailForm = this.getServiceRouteDetailForm();
				 	    	var sendButtonItemId = grid.down('#sendMessageBtn');
				 	    	var btnEdit = grid.down('#btnEdit');
				 	    	var btnView = grid.down('#btnView');
				 	    	var btnDelete = grid.down('#btnDelete');
				 	    	var printBusPass = grid.down('#printBusPassStd');
				 	    	var count=selected.length;
				 	    	btnEdit.setDisabled(false);
			 	    		btnView.setDisabled(false);
			 	    		btnDelete.setDisabled(false);
			 	    		printBusPass.setDisabled(false);
				 	    	if(count == 1){ // enable
				 	    		if(serviceDetailForm.config.mode == 'view'){
				 	    			sendButtonItemId.setDisabled(true);
				 	    		}
				 	    		else{
				 	    			sendButtonItemId.setDisabled(false);
				 	    		}
				 	    		if(record.data.user.userGroup.value != 'Student'){
				 	    			printBusPass.setDisabled(true);
				 	    		}
				 	    		
				 	    	}else if(count>1){ // enable
				 	    		if(serviceDetailForm.config.mode == 'view'){
				 	    			sendButtonItemId.setDisabled(true);
				 	    		}
				 	    		else{
				 	    			sendButtonItemId.setDisabled(false);
				 	    		}
				 	    		btnEdit.setDisabled(true);
				 	    		btnView.setDisabled(true);
				 	    		btnDelete.setDisabled(true);
				 	    		printBusPass.setDisabled(true);
				 	    	}
				 	    	else{  // disable
				 	    		sendButtonItemId.setDisabled(true);
				 	    		printBusPass.setDisabled(true);
				 	    	}
				 	    },
				 	    disableEditViewDeleteBtnButton:function(column,selected) {
				 	    	var grid = this.getServiceRouteMasterGrid();
				 	    	var btnEdit = grid.down('#btnEdit');
				 	    	var btnView = grid.down('#btnView');
				 	    	var btnDelete = grid.down('#btnDelete');
				 	    	btnEdit.setDisabled(false);
			 	    		btnView.setDisabled(false);
			 	    		btnDelete.setDisabled(false);
				 	    	var count=selected.length;
				 	    	if(count>1){
				 	    		btnEdit.setDisabled(true);
				 	    		btnView.setDisabled(true);
				 	    		btnDelete.setDisabled(true);
				 	    	}
				 	    },
				 	   fromSchlAddMultipleStops:function(obj){
					   	   var $this = this;
					   	   var serviceRouteDetailForm = $this.getServiceRouteDetailForm();
					   	    var recordStopListWithTimes = serviceRouteDetailForm.down('#recordStopListWithTimesId').getValue();
					   	   var stopContiner = serviceRouteDetailForm.down('#fromSchlServiceStopPanelId');
					   	  // var timeFieldsCount = stopContiner.items.length;
					   	   var frmSchlPanelItem = new Array();
					   	   var fieldContainer=obj.up('fieldcontainer');
					   	   var newcont=stopContiner.items.indexOf(fieldContainer);
						   var insertPosition=newcont+1;
						   if(!isNullOrEmpty(recordStopListWithTimes) && recordStopListWithTimes == 'NO'){
							   frmSchlPanelItem.push({
						   		   xtype:'fieldcontainer',
						   		   width: '100%',
						   		   layout : 'hbox',
						   		   //style:{'margin':'20px'},
						   		   defaults : {
						   			   width: 256,
						   			   labelAlign : 'top'
						   		   },
						   		   items : [{
						   			    xtype:'hidden',
						   			    name:'fromSchlRouteStopId',
						   			    itemId:'fromSchlRouteStopId'
						   		   },{
										xtype : 'customcombobox',
										name : 'location',
										 width: 256,
										store: 'transport.route.LocationName',
										displayField: 'locationName',
										valueField: 'id',		
										//allowBlank:false
									},{
										xtype : 'numberfield',
										name : 'distance',	
										minValue : 0,
										 width: 256,
						                hideTrigger:true,
										//allowBlank:false
						   		    },{
						   		    	xtype : 'timefield',
										name : 'fromSchlArrivalTime',
										itemId:'fromSchlArrivalTime',
										submitFormat : 'g:i A',
										//allowBlank: false,
										hidden : true,
										width: 105,
										listeners: {
											render: function(field) {
												return timeFormatRender(field);
											}
										}
									},{
										xtype : 'timefield',
										itemId:'fromSchlDepartureTime',
										name : 'fromSchlDepartureTime',
										submitFormat : 'g:i A',
										hidden : true,
										//allowBlank: false,
										width: 125,
										listeners: {
											render: function(field) {
												return timeFormatRender(field);
											}
										}
									},{
										xtype:'hidden',
										name:'routeStopType',
										value:getTransportTranslation('TRANSPORT_INTERMEDIATE')
						   		    },{
						   		    	xtype: 'button',
										itemId: 'fromSchlStopBtn',
										cls: 'CustomBodyBtnSettings',
										text: getCommonTranslation('ADDBUTTONTEXT'),
										tooltip: getCommonTranslation('ADD'),
										width:40,
										/*listeners:{
											click:function(obj){
												$this.showHideTimeFields(obj);
											}
										}*/
							   	   },{
						   			   xtype: 'button',
						   			   glyph: ICONGLYPH.DELETEGLYPH,
						   			   cls: 'CustomBodyBtnReject',
						   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
						   			   width:40,
						   			   listeners:{
						   				   click:function(obj){
						   					   var container = obj.up('fieldcontainer');
						   					   var panelContiner = $this.getServiceRouteDetailForm().down('#fromSchlServiceStopPanelId');
						   					   panelContiner.remove(container);
						   					   $this.getServiceRouteDetailForm().getForm().checkValidity();
						   					   $this.getServiceRouteDetailForm().getForm().isValid();
						   					   $this.getServiceRouteDetailForm().getForm().clearInvalid();
						   				   }
						   			   }
						   		   }]
						   	   });
						   } else {
							   frmSchlPanelItem.push({
						   		   xtype:'fieldcontainer',
						   		   width: '100%',
						   		   layout : 'hbox',
						   		   //style:{'margin':'20px'},
						   		   defaults : {
						   			   width: 256,
						   			   labelAlign : 'top'
						   		   },
						   		   items : [{
						   			    xtype:'hidden',
						   			    name:'fromSchlRouteStopId',
						   			    itemId:'fromSchlRouteStopId'
						   		   },{
										xtype : 'customcombobox',
										name : 'location',
										 width: 256,
										store: 'transport.route.LocationName',
										displayField: 'locationName',
										valueField: 'id',		
										//allowBlank:false
									},{
										xtype : 'numberfield',
										name : 'distance',	
										minValue : 0,
										 width: 256,
						                hideTrigger:true,
										//allowBlank:false
						   		    },{
						   		    	xtype : 'timefield',
										name : 'fromSchlArrivalTime',
										itemId:'fromSchlArrivalTime',
										submitFormat : 'g:i A',
										//allowBlank: false,
										width: 105,
										listeners: {
											render: function(field) {
												return timeFormatRender(field);
											}
										}
									},{
										xtype : 'timefield',
										itemId:'fromSchlDepartureTime',
										name : 'fromSchlDepartureTime',
										submitFormat : 'g:i A',
										//allowBlank: false,
										width: 125,
										listeners: {
											render: function(field) {
												return timeFormatRender(field);
											}
										}
									},{
										xtype:'hidden',
										name:'routeStopType',
										value:getTransportTranslation('TRANSPORT_INTERMEDIATE')
						   		    },{
						   		    	xtype: 'button',
										itemId: 'fromSchlStopBtn',
										cls: 'CustomBodyBtnSettings',
										text: getCommonTranslation('ADDBUTTONTEXT'),
										tooltip: getCommonTranslation('ADD'),
										width:40,
										/*listeners:{
											click:function(obj){
												$this.showHideTimeFields(obj);
											}
										}*/
							   	   },{
						   			   xtype: 'button',
						   			   glyph: ICONGLYPH.DELETEGLYPH,
						   			   cls: 'CustomBodyBtnReject',
						   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
						   			   width:40,
						   			   listeners:{
						   				   click:function(obj){
						   					   var container = obj.up('fieldcontainer');
						   					   var panelContiner = $this.getServiceRouteDetailForm().down('#fromSchlServiceStopPanelId');
						   					   panelContiner.remove(container);
						   					   $this.getServiceRouteDetailForm().getForm().checkValidity();
						   					   $this.getServiceRouteDetailForm().getForm().isValid();
						   					   $this.getServiceRouteDetailForm().getForm().clearInvalid();
						   				   }
						   			   }
						   		   }]
						   	   });
						   }
					   	  
					     	stopContiner.insert(insertPosition,frmSchlPanelItem);
					     	stopContiner.doLayout();
					      },
					      studentPrintBusPass: function(){
					    		var $this = this;
					    	  var grid = this.getPeopleCoveredGrid();
					 	      var record = grid.getSelectionModel().getSelection()[0];
					 	      var reportParams = new Object();
					 	      var studentId=  record.data.user.id;
					 	      var studentName=  record.data.user.code;
					          var routeName   =record.data.transServiceRoute.value;
					          var removalEffectiveForm= record.data.removalEffectiveForm;
                              var reportTitle = 'Krmu Student Bus Pass';
		                     var code = 'KRMU_STUDENT_BUS';
		                     reportParams.code = code;
		                     reportParams.reportTitle = reportTitle;
		                     reportParams.routeName = record.data.transServiceRoute.value;
		                     reportParams.studentId = studentId;
		                     reportParams.studentName = studentName;
		                     reportParams.removalEffectiveForm = removalEffectiveForm;

		                     $this.exportJRXMLReport(code, reportParams, reportTitle, '.pdf', SERVERURL.SERVICE_ROUTE_EXPORT_PDF_STUDENT_BUSS_PASS);
					 	 	
					      },
					      loadImportServiceRouteGrid : function(){
					      	var $this = this;
					      	var grid = $this.getImportservicerouteloadergrid();
					      	var form  = $this.getUploadoptionradiogroup();
					          var isUploadAll = form.items.items[0].getValue().isUploadAll;
					          $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_TRANSPORT_PERSON_COVERD');
					      	/*var store = grid.getStore();
					      	store.getProxy().extraParams = {
					      		moduleName:'BULK_HOSTEL_BED_UPLOAD'
					      	};
					      	store.load();*/
					      },
					      getDownloadFile : function(documentId,fileType){

						    	if(!isNullOrEmpty(documentId)){
						    		var csvForm = Ext.create('Ext.form.Panel'); 
						    		csvForm.getForm().submit({
						    			target: '_blank',
						    			method:'POST',
						    			params :{
						    				access_token : Ext.Ajax.defaultHeaders.access_token
						    			},
						    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
						    			standardSubmit :true
						    		});
						    	}
						    }
				 	    
				    	
});
