/**
 * This controller is used for the TVET Report Management Add/Edit/Delete/View
 * 
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.controller.tvet.TVETReportController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
			'tvet.TEVTReportFileStore',
			'tvet.TVETReportStore',
			'tvet.TVETReportNoOfFilesStore'
    ],
    views: ['tvet.TVETReportStructure',
			'tvet.TVETReportTabStructure',
			'tvet.TVETReportFilter',
			'tvet.TVETReportGrid',
			'tvet.TVETReportNoOfFilesWin',
			'tvet.TVETReportNoOfFilesGrid'
    ],
    models: [],
    refs: [{
        ref: 'tvetreportfilter',
        selector: 'tvetreportfilter'
    },{
        ref: 'tvetreportgrid',
        selector: 'tvetreportgrid'
    },{
        ref: 'tvetreportnooffileswin',
        selector: 'tvetreportnooffileswin'
    },{
        ref: 'tvetreportnooffilesgrid',
        selector: 'tvetreportnooffilesgrid'
    }],
    config: {},
    init: function() {
        this.control({
            'tvetreportfilter button[itemId=searchBtnTVETReportFilterItemId]': {
                click: function() {
                    this.loadTVETReportGrid();
                }
            },
 			'tvetreportfilter': {
				afterrender: function(filter) {
					var $this = this;
        			var filter = $this.getTvetreportfilter();
        			var tvetReportFilesItemId = filter.down('#tvetReportFilesItemId');
					tvetReportFilesItemId.getStore().load({
		    			callback: function(records, operation, success) {
		    				if (success) {
								tvetReportFilesItemId.setValue(records);
		    				}
		    			}
    				});

					var academyLocationItemId = filter.down('#academyLocationItemId');
					academyLocationItemId.getStore().load({
		    			callback: function(records, operation, success) {
		    				if (success) {
								academyLocationItemId.setValue(records);
		    				}
		    			}
    				});
                }
            },
			'tvetreportfilter button[itemId=resetBtnTVETReportFilterItemId]': {
                click: function() {
                    this.resetTVETReportfilter();
                }
            },
			'tvetreportgrid': {
                render: function(grid) {
					grid.getStore().load();
                },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        var $this = this;
                        if (columnName == 'noOfFiles') {
                            var formWindow = $this.getTvetreportnooffileswin();
                            if (!formWindow) {
                                Ext.widget('tvetreportnooffileswin');
                                formWindow = $this.getTvetreportnooffileswin();
                            }
                            formWindow.show();
                            var noofFilesGrid = $this.getTvetreportnooffilesgrid();
                            noofFilesGrid.getStore().getProxy().extraParams = {
                                requestId: record.data.id
                            };
                            noofFilesGrid.getStore().load();
                        } 
                    }
                }
            },
			'tvetreportgrid button[itemId=btnRefreshItemId]': {
                click: function() {
                    var $this = this;
                    var grid = $this.getTvetreportgrid();
                    $this.resetPageSetting(grid.getStore());
                    grid.getStore().reload();
                }
            },
		});
    },
    loadTVETReportGrid: function() {
        var $this = this;
        var filter = $this.getTvetreportfilter();
        var filterForm = filter.getForm();
        var grid = $this.getTvetreportgrid();
        var store = grid.getStore();
        var academyLocationItemId = filter.down('#academyLocationItemId');
        var intakeYearField = filter.down('#intakeYear');
        var tvetReportFilesItemId = filter.down('#tvetReportFilesItemId');

        var academyLocationValue = academyLocationItemId.getValue();
		var alIds = [];
        var academyLocationIds;
        if (academyLocationValue != undefined && academyLocationValue.length > 0) {
            for (var i in academyLocationValue) {
                if (Ext.isObject(academyLocationValue[0])) {
                    alIds.push(academyLocationValue[i].get("id"));
                } else {
                    alIds.push(academyLocationValue[i]);
                }
            }
            academyLocationIds = alIds.join();
        } else {
			alIds.push(academyLocationValue);
			academyLocationIds = alIds.join();
		}
        
        var intakeYearValue = intakeYearField.getValue();
		
		
		var tvetReportFilesValue = tvetReportFilesItemId.getValue();
		var tvetReportFilesIdArr = [];
        var tvetReportFilesIds;
        if (tvetReportFilesValue != undefined && tvetReportFilesValue.length > 0) {
            for (var i in tvetReportFilesValue) {
                if (Ext.isObject(tvetReportFilesValue[0])) {
                    tvetReportFilesIdArr.push(tvetReportFilesValue[i].get("id"));
                } else {
                    tvetReportFilesIdArr.push(tvetReportFilesValue[i]);
                }
            }
            tvetReportFilesIds = tvetReportFilesIdArr.join();
        } else {
			alIds.push(tvetReportFilesValue);
			tvetReportFilesIds = tvetReportFilesIdArr.join();
		}
		console.log('academyLocationIds : ' + academyLocationIds);
		console.log('tvetReportFilesIds : ' + tvetReportFilesIds);

		var jsonObject = {
			"academyLocationIds" : academyLocationIds,
			"intakeYearId": intakeYearValue,
			"reportIds" : tvetReportFilesIds
		}
		var formData = Ext.encode(jsonObject);
        var url = SERVERURL.PATH_TVET_REPORT_FILE_REQUEST_SAVE;
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            jsonData: formData,
            method: 'POST',
            success: function(response, action) {
                Ext.getBody().unmask();
                var data = Ext.decode(response.responseText);
                showSuccessMessage("Success", getCommonTranslation('TVET_REQUEST_CREATED_SUCCESSFULLY'));
 				$this.resetPageSetting(grid.getStore());
                grid.getStore().reload();
            }
        });
    },
    resetTVETReportfilter: function() {
        var form = this.getTvetreportfilter();
        form.getForm().reset();
        form.fireEvent('afterrender', form);
    }
});