/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.controller.webcam.ImageCaptureController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',
	views: ['Academia.view.webcam.ImageCaptureWindow'],
	refs: [{
		ref : 'contentPanel',
		selector : 'contentpanel' 
	},{
		ref : 'imageCaptureWindow',
		selector : 'imagecapturewindow' 
	},{
		ref : 'imageCaptureForm',
		selector : 'imagecapturewindow form' 
	},{
		ref : 'personInfoPanel',
		selector : 'personinfopanel'
	}],
	init: function(application) {
		this.control({
			'imagecapturewindow button#capturebuttonId':{
				click : this.captureStudentProfilePhoto
			},
			'imagecapturewindow button#previewbuttonId':{
				click : this.previewStudentProfilePhoto
			},
			'imagecapturewindow button#resetbuttonId':{
				click : function(btn){
					btn.up('window').close();
					Ext.getBody().mask(getCommonTranslation('RESETTING'), 'x-mask-loading');
					setTimeout(function(){
						Ext.widget('imagecapturewindow').show();
						Ext.getBody().unmask();
                	},1500);
					
				}
			},
			'imagecapturewindow button#SubmitBtn':{
				click : function(btn){
					this.saveCapturedIMage(btn);
				}
			},
			'imagecapturewindow button#CancelBtn':{
				click : function(btn){
					btn.up('window').close();
				}
			},
			'imagecapturewindow' : {
				close : function(obj){
					Webcam.userMedia=true;
					Webcam.reset();
				}
			}
		});
	},
	
	captureStudentProfilePhoto : function(btn){
		var $this = btn.up('window');
		var form = btn.up('window').down('form');
		var imageUrl;
		Webcam.snap( function(data_uri) {
			imageUrl = data_uri;
		});
        Ext.defer(function() {
        	var imgLoad = new Image();
    		imgLoad.onload = (function(){
    			var crop = new Academia.utilities.ImageCrop({
    				id:'testing',
    				width: 320,
    				height: 240,
    				src:imageUrl
    			});
    			crop.on('changeCrop', function(component,region) {
    				$this.cropData = region;
    				$this.component = component;
    			});
    			var PREVIEW_TEST = form.down('#previewPanelId');
    			PREVIEW_TEST.add(crop);
    			$this.down('#capturePanelId').setVisible(false);
    			$this.down('#previewPanelId').setVisible(true);
    			
    			btn.setDisabled(true);
    			$this.down('#previewbuttonId').setDisabled(false);
    			
    		}).bind($this);
    		imgLoad.src = imageUrl;
    		$this.imagesUrl = imageUrl;
  	  }, 500, $this);
		
	},
	
	previewStudentProfilePhoto : function(btn){
		
			var $this = btn.up('window');
			var canvas = document.getElementById('canvas');
			var ctx = canvas.getContext("2d");
			var region = $this.cropData; 
			var component = $this.component;
			var sw = region.width - region.x;
			var sh = region.height - region.y;

			var imgWidth = component.width;
			var imgHeight = component.height;

			var img = new Image();
			img.src = component.src;

			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
			
			var dataUrl = canvas.toDataURL("image/png");
			
			$this.down('#showProfilePhotoPanel').getEl().dom.src=dataUrl;
			$this.down('#showGridPhotoPanel').getEl().dom.src=dataUrl;
			$this.down('#showDisplayPhotoPanel').getEl().dom.src=dataUrl;
			$this.captureImageaUrl = dataUrl;
			$this.down('#resetbuttonId').setDisabled(false);
			
			$this.down('#SubmitBtn').setDisabled(false);
			
		},
		
		saveCapturedIMage : function(btn){
			
			var this$ = this;
			this$.applyWindowMask();
			var personProfile = this$.getContentPanelActiveTab();
	    	if(personProfile.title=="Visitor Details")
	    	{
		    	var personId = null;
			var win = btn.up('imagecapturewindow');
			var userInfo = Academia.model.authentication.UserInfoModel;
			var access_token = userInfo.get("accessToken");
			
			var canvas = document.getElementById('canvas');
			var dataUrl = canvas.toDataURL("image/png");
			
			var url = 'rest/personImage/uploadVisitorSnapshotB64Image?access_token='+access_token;
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', '1.png');
			//form.append('personId', personId);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);
			
			xhr.onreadystatechange = function () {
				  if (xhr.readyState == 4 && xhr.status == 200) {
			          if (xhr.responseText != "") {
			        	  var data = Ext.decode(xhr.responseText);
			        	  Ext.apply(personProfile, {
			        		  visitorSnap : null,
								setVisitorSnap : function(visitorSnap) {
									personProfile.visitorSnap = visitorSnap;
								},
							});
			        	  personProfile.setVisitorSnap(data);
			        	  this$.hideWindowMask();
							btn.up('window').close();
			          }
			      }
				
			};
			xhr.send(form);
	    	}
	    	else if(Ext.isDefined(Ext.ComponentQuery.query('parentguardianform')[0]) && Ext.ComponentQuery.query('parentguardianform')[0].itemId == "studentParentGuardianForm"){
	    		var form = Ext.ComponentQuery.query('parentguardianform')[0];
	    		var canvas = document.getElementById('canvas');
				var dataUrl = canvas.toDataURL("image/png");
				var fileName = 'ci_'+randomString(10,randomString(20))+'_img.png';
				var uploadField = form.down('#photoFileImageParent');
				uploadField.setRawValue(fileName);
				localStorage.setItem('parentDataURL',dataUrl);
				btn.up('window').close();
				this$.hideWindowMask();
	    	}
	    	else if(Ext.isDefined(Ext.ComponentQuery.query('facultyfamilydetailform')[0]) && Ext.ComponentQuery.query('facultyfamilydetailform')[0].itemId == "facultyFamilyDetailForm"){
	    		var form = Ext.ComponentQuery.query('facultyfamilydetailform')[0];
	    		var canvas = document.getElementById('canvas');
				var dataUrl = canvas.toDataURL("image/png");
				var fileName = 'ci_'+randomString(10,randomString(20))+'_img.png';
				var uploadField = form.down('#photoFileImageParent');
				uploadField.setRawValue(fileName);
				localStorage.setItem('parentDataURL',dataUrl);
				btn.up('window').close();
				this$.hideWindowMask();
	    	}
	    	else if(Ext.isDefined(Ext.ComponentQuery.query('parentguardianform')[0]) && Ext.ComponentQuery.query('parentguardianform')[0].itemId == "applicantParentGuardianForm"){
	    		var form = Ext.ComponentQuery.query('parentguardianform')[0];
	    		var canvas = document.getElementById('canvas');
				var dataUrl = canvas.toDataURL("image/png");
				var fileName = 'ci_'+randomString(10,randomString(20))+'_img.png';
				var uploadField = form.down('#photoFileImageParent');
				uploadField.setRawValue(fileName);
				localStorage.setItem('parentDataURL',dataUrl);
				btn.up('window').close();
				this$.hideWindowMask();
	    	}
	    	else if(Ext.isDefined(Ext.ComponentQuery.query('evaluationremarkmasterstructure')[0]) && Ext.isDefined(Ext.ComponentQuery.query('photouploadform')[0]) && Ext.ComponentQuery.query('photouploadform')[0].itemId == "studentPhotoUploadForm"){
	    		var form = Ext.ComponentQuery.query('photouploadform')[0];
	    		var canvas = document.getElementById('canvas');
				var dataUrl = canvas.toDataURL("image/png");
				var fileName = 'ci_'+randomString(10,randomString(20))+'_img.png';
				var uploadField = form.down('#photoFileImage');
				uploadField.setRawValue(fileName);
				localStorage.setItem('parentDataURL',dataUrl);
				btn.up('window').close();
				this$.hideWindowMask();
	    	}
	    	else
	    	{
	    	var personId = personProfile.getPersonId();
			
			var win = btn.up('imagecapturewindow');
			var userInfo = Academia.model.authentication.UserInfoModel;
			var access_token = userInfo.get("accessToken");
			
			var canvas = document.getElementById('canvas');
			var dataUrl = canvas.toDataURL("image/png");
			
			var url = 'rest/personImage/uploadeB64Image?access_token='+access_token;
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', '1.png');
			form.append('personId', personId);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);

			xhr.onreadystatechange = function () {
				if(personProfile.xtype!='applicantprofile'){
									           if (personProfile.xtype == 'studentprofile') {
										if (xhr.readyState == 4
												&& xhr.status == 200) {
											if (xhr.responseText != "") {
												var data = Ext
														.decode(xhr.responseText);
												var personinfo = personProfile
														.getPersonInfo();
												personinfo.photoUrl = data.path;
											}
										}
									}
					this$.getDownloadPhotoToPersonProfile();
					this$.getLoadPersonInfo();
				}
				if(Ext.isDefined(btn.up('window'))){
					btn.up('window').close();	
				}
				this$.hideWindowMask();
			};
			xhr.send(form);
	      }
		},
		getLoadPersonInfo : function(){
			var this$ = this;
			var portalId = this$.getCurrentLoggedPortalId();
			if(portalId!=3 && portalId!=7) {
			var personInfoPanel = this$.getPersonInfoPanel();
			var tabName = getPersonModuleTranslation('STUDENT_PERSONAL_DETAILS');
			var tabDetail = personInfoPanel.items.items;
			for(var i in tabDetail){
				if(tabDetail[i].title==tabName){
					tabDetail[i].close();
				}
			}

			var tabPanelTitle = 'STUDENT_PERSONAL_DETAILS';
			var tabPanelItemId = 'studentPersonalDetails';
			var tabPanelItemXtype = 'personalinformationform';
			var xtypeItemId = 'studentPersonalInformationForm';
			var defaultPanel = true;
			var renderPanel= true;

			if (!isNullOrEmpty(renderPanel) && renderPanel) {
				this.addPersonTabPanel('STUDENT', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
			}
			 }
		},
		
		 /**
	     * Set photo to person profile image 
	     * @param  form
	     * @param personId
	     * @param personId
	     */
	    getDownloadPhotoToPersonProfile : function(){
	    	var this$ = this;
	    	var personProfile = this$.getContentPanelActiveTab();
	    	var personId = personProfile.getPersonId();
	    	var portalId = this$.getCurrentLoggedPortalId();
	    	if(!isNullOrEmpty(personId)){
	    		Ext.Ajax.request({
	                type: 'rest',
	                binary: true,
	                url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
	                method: 'GET',
	                success : function(response){
	                	if(response.responseBytes.length>0){
	    					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	    					 var url = window.URL.createObjectURL(blob);
	    					
	    					 if(portalId==2 || portalId==3 || portalId==7) {
	    						 try{
	    							 var fimg = this$.getUserInfo().down('#userInfoButton');
	    						 }catch(e){
	    							 var fimg = Ext.ComponentQuery.query('userinfo')[0].down('#userInfoButton');
	    						 }
	    						 fimg.setIcon(url);
	    						 fimg.setVisible(true);
	    					 } else {
	    						 var a=personProfile.down("#profile_image");
	    						 a.getEl().dom.src=url;
	    						 a.setVisible(true);
	    					 }         	    		
	    					 /**
	    					  * @Author Surendra Jha
	    					  * Show user image for applicant portal user
	    					  */
	    					 if(portalId==6) {
	    						 var fimg = this$.getUserInfo().down('#userInfoButton');
	    						 fimg.setIcon(url);
	    						 fimg.setVisible(true);
	    					 }
	    					 
	    				}else{
	    					var a=personProfile.down("#profile_image");
	       				    a.setVisible(false);
	    				}
	               }

	            });
	    	}
	    },
	    
});
