Ext.define('Academia.model.common.ECAcademyLocationProgramModel', {
	extend : 'Academia.model.VersionableDataModel',
	fields : ['programBatchSeatConfigurationId','academyId', 'academyName', 'locationId', 'locationName',
	          'academyLocationId', 'academyLocationName', 'programId', 'programName',
	          'batchId', 'batchName' ,'seatName','count','status','batch','id','programBatchSeatTypeId','mappingStatus','periodName','programBatchPeriodId',
	          "seatCapacity","sectionCount","sectionCode","periodId","sectionId","program1Id","batch1Id",
				{
		            name: 'percentageSeatsFilled',
		            convert: function(v, rec) {
		            	var totalSeats = parseFloat(rec.data.seatCapacity); 
		    			var seatsFilled = parseFloat(rec.data.count);
		    			var percentageSeatsFilled = (seatsFilled/totalSeats)*100;
		    			return Math.round(percentageSeatsFilled * 100) / 100;
		            }
		        },{
		            name: 'programBatch',
		            convert: function(v, rec) {
		    			return rec.data.programName+" - "+ rec.data.batchName;
		            }
		        },]
});