/**
 * @author Suraj Chouhan
 */

Ext.define('Academia.model.hostel.hostelapplication.HostelApplicationsListGridModel', {
	extend : 'Academia.model.AbstractDataModel',
//	fields : ['id','academicTermId','locationId','studentId','programGroupId','programId','intakeId','intakeYearId','seatTypeId','hostelId','waitingListId','HostelApplicationStatusEnum','applicationStatus','HostelSetupTypeEnum','hostelSetupType']
	fields:["id","applicationType","applicationId","studentCode","admissionId","studentName","programName","programGroup","intake","seatType","waitingListType","hosteCode","hosteName","applicationStatus","applicationDate","allocatedHostelName","hostelApplicationYear","cancellationReason","cancelledBy", "isReallocateSameHostel","studentId","hostelLevel","hostelType","clusterCode","hostelCategory","warden","restrictionType","waitingListName",{
    	name:'program',
    	convert: function(v, rec) {
        	if(rec.data.programName && !isNullOrEmpty(rec.data.programName)){
        		return rec.data.programName;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'batch',
    	convert: function(v, rec) {
        	if(rec.data.intake && !isNullOrEmpty(rec.data.intake)){
        		return rec.data.intake;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'waitingListIdName',
    	convert: function(v, rec) {
        	if(!isNullOrEmpty(rec.data.waitingListName)){
        		return rec.data.waitingListName;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'cancellationBy',
    	convert: function(v, rec) {
        	if(rec.data.cancelledBy && !isNullOrEmpty(rec.data.cancelledBy)){
        		return rec.data.cancelledBy;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'reallocateSameResidence',
    	convert: function(v, rec) {
        	if(rec.data.isReallocateSameHostel && !isNullOrEmpty(rec.data.isReallocateSameHostel)){
        		return rec.data.isReallocateSameHostel;
        	}
        	else{
        		return "";
        	}
        }
    },
    {
    	name:"allocatedHostel",
		convert:function(v,rec)
		{
			if(rec.data.allocatedHostelName && !isNullOrEmpty(rec.data.allocatedHostelName)){
		         return rec.data.allocatedHostelName;
		     }
		     else{
		         return "";
		     }
		}
    }]
});
