 Ext.define('Academia.store.datasetting.DataSettingDynamicEntityStore', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.datasetting.DataSettingDynamicModel',     
     proxy: {
         type: 'rest',
         api: {
             read: SERVERURL.FIND_ALL_DYNAMIC_ENTITIES_FIELDS   //rest/idDefinition/findTablesConfig   ?configCode=USER_LIST
         },
         reader: {
             type: 'json'             
         }
     },
	 listeners: {
		 load: {
	         fn: function(store, records, successful, eOpts){ 
	        	 var me=this;
	        	 store.each(function(record){
	        		 if(!isEmpty(record.data)){
	        			 me.translation(record,false);	        			  			 	        			 
	        		 }
	        		 if(!isEmpty(record.data.wsSearchTableColumns)){
	        			 var count;
	        			 for(count=0;count<record.data.wsSearchTableColumns.length;count++){
	        				 me.translation(record.data.wsSearchTableColumns[count],true);
	        			 }	        			 	        			    			 	        		
	        		 }
	        	 });
	         }
	     }
	 },
     translation:function(record,isObject){
    	 if(isObject){
    		 if(!isNullOrEmpty(record.displayCode)){
    			 var res = (record.displayCode).split(".");
    			 if(res[2]){
    				 var valueText=getCBTranslation(res[2]);
    				 record.displayCode=valueText;  
    				 record.code=res[2];
    			 }else{
    				 var valueText=getCBTranslation(res[1]);
    				 record.displayCode=valueText; 
    				 record.code=res[1];
    			 }	        				 
    		 } 
    	 }else{
    		 if(!isNullOrEmpty(record.get('displayCode'))){
    			 /*var res = (record.get('displayCode')).split(".");
    			 if(res[1]){
    				 var valueText=getCBTranslation(res[1]);
    				 record.set('displayCode',valueText);  
    				 record.code=res[1];
    			 }else{
    				 var valueText=getCBTranslation(res[0]);
    				 record.set('displayCode',valueText); 
    				 record.code=res[0];
    			 }	 */  

				 record.code=record.get('displayCode');
    			 var valueText=getCBTranslation(record.get('displayCode'));
    			 record.set('displayCode',valueText);  
    		 }
    	 }    	 	       
     }
 });