/**
 * @author kuldeep yadav
 */
Ext.define('Academia.store.examinationcenters.evaluationgroup.ProgramMappingProgBatchStore', {
	extend : 'Ext.data.Store',
	fields: [
		'batchId', 'batchName', 'programId', 'programName', 'programGroupName',
		{
			name: 'value',
			convert: function(value, record) {
				return record.get('programGroupName') + ' / ' + record.get('programName') + ' - ' + record.get('batchName');
			}
		}
	],
	autoLoad : false,
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PATH_FIND_PROGRAM_AND_BATCHES
		},
		reader: {
			type:'json',
			root: 'rows',
			totalProperty: 'records'
		}
	}

});
