/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.facilitiesresources.managegallery.ManageGalleryStore', {
    extend: 'Ext.data.Store',
    fields: [
        { name:'path', type:'string' },
        { name:'imageName', type:'string' },
        {name:'labelOfHyperlink'},
        {name:'addHyperlink'},
        { name:'id'},
        { name:'uploadedDate'},
        { name:'fileSize'},
        { name:'fileType'},
        { name:'azureIconPath', type:'string' },
        { 
        	name:'iconImage', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(rec.get('path'))){
        			try{
        				if(rec.data.fileType.toLowerCase() == "odt"){
        					return "resources/images/driveToolImages/odt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "doc" || rec.data.fileType.toLowerCase() == "docx"){
        					return "resources/images/driveToolImages/doc.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "pdf"){
        					return "resources/images/driveToolImages/pdf.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "ppt" || rec.data.fileType.toLowerCase() == "pptx"){
        					return "resources/images/driveToolImages/ppt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "txt"){
        					return "resources/images/driveToolImages/txt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "xls" || rec.data.fileType.toLowerCase() == "xlsx"){
        					return "resources/images/driveToolImages/xls.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "xls" || rec.data.fileType.toLowerCase() == "zip"){
        					return "resources/images/driveToolImages/zip.svg";
        				}else if(!isNullOrEmpty(rec.data.azureIconPath)){
        					return rec.data.azureIconPath;
        				}
        				else{
        					return "resources/images/uploads" + rec.get('path').split('.')[0]+'_icon.'+rec.get('path').split('.')[1];
        				}
        			}
        			catch(e){
            			return null;
        			}
        		}else{
        			return null;
        		}
        	}
        }
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        method: 'GET',
        api: {
            read: SERVERURL.PATH_GET_GALLERY_IMAGES
        },
        reader: {
            type: 'json',
            //root: 'rows',
            //totalProperty: 'records'
        }
    }
});
