/**
 *   @author Abhishek Prajapati
 */

 Ext.define('Academia.store.feeandpayment.managebill.ScholarshipAwardeeListStore', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.feeandpayment.managebill.Student',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('studentName');
	        var value2 = o2.get('studentName');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PATH_FIND_SCHOLARSHIP_AWARDEE_LIST_STUDENT_DETAILS_BY_STUDENT_NAME_AND_CODE
		},
		reader: {
			type:'json'
		}
	},
	listeners:{
		beforeload: function(store){
			store.getProxy().extraParams.page = 1;
			store.getProxy().extraParams.start = 0;
			store.getProxy().extraParams.limit = 500;
		}
	}

});