Ext.define('Academia.store.messaging.SystemMessageEvent', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.messaging.SystemEventMessageModel',
     autoLoad: false,
     sorters: [{
         property: 'displayCode',
         direction: 'ASC'
     }],
     sortOnLoad: true,
     remoteSort: false,
     proxy: {
         type: 'rest',
         api: {        	   
             read: SERVERURL.SYSTEM_MESSAGE_EVENT_LIST_BY_SUBCATEGORY_ID      //URL -rest/systemMsgEventResource/findByMsgSubCatagoryId?id=# 
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('displayCode');
                     if(!isNullOrEmpty(resultKey)){
                    	 records[count].set('displayCode', getMessagingModuleTranslation(resultKey));
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });