/**
 * @author Rohit Sharma
 */
Ext.define('Academia.store.sunsuccess.BusinessRuleApplyToStudentGroupAddGridStore', {
	extend: 'Ext.data.Store',
	fields: [
		'disbursementMode', 'droolAgenda', 'id', 'organizationName', 'scholarshipAmountType', 'scholarshipAwardees', 
		'scholarshipName', 'scholarshipStatus', 'scholarshipType', 'committeeAcademyLocations', 'committeeCode', 'committeeCoordinator',
		'committeeCoordinatorId', 'committeeCoordinatorName', 'committeeName', 'committeeParticipants', 'committeeType', 'committeeTypeValue',
		'description', 'noOfParticipants', 'status', 'validFromDate', 'validTillDate', 'hostelCode', 'hostelName', 'noOfBuilings',
		'manager', 'scholarshipCode',
		{ name: 'managername', 
			convert: function(val, record) {
				if(!record.get('manager')){
					return '';
				}
				var manager = record.get('manager');
				return manager.value;
			}
		}, 'startDate', 'hostelId', 'resourceId'
	],
	autoLoad: false,
	sortOnLoad: false,
	proxy: {
		type: 'rest',
		api: {
			read: SERVERURL.PATH_FIND_UNMAPPED_SCHOLARSHIP
		},
		method: 'GET',
		reader: {
			type: 'json',
			root: 'rows',
			totalProperty: 'total'
		}
	}
});