
Ext.define('Academia.utilities.CustomAlerts',{});

function showSuccessMessage (title,message){
	var iconHtml = '<span class="titleIcon ph-fill ph-check-circle"></span>';
	Ext.create('widget.uxNotification', {
		title: iconHtml + "<span class='toastTitle'>" + title + "</span>",
		position: 'br',
		width:480,
		minWidth: 480,
		maxWidth: 480,
		maxHeight: 'auto',
		manager: 'instructions',
		cls: 'toast-notification success',
		//iconCls: 'x-btn-icon-el ph ph-megaphone',
		html: message,
		autoCloseDelay: 10000,
		slideBackDuration: 500,
		slideInDuration:500,
		autoClose:true,
		slideInAnimation: 'easeIn',
		slideBackAnimation: 'easeIn',
		resizable:false,
		paddingY:50,
		stickOnClick:false,
		tools: [{
			type: 'close', // Default close tool
			cls: 'ph ph-x', // Add Phosphor Icons class for the close icon
			handler: function (event, toolEl) {
			    var notification = toolEl.up('uxNotification');
			    if (notification) {
			        notification.close();
			    }
			}
		}]
	}).show();
}

function showErrorMessage (title,message){
	var iconHtml = '<span class="titleIcon ph-fill ph-warning-circle"></span>';
	Ext.create('widget.uxNotification', {
		title: iconHtml + "<span class='toastTitle'>" + title + "</span>",
		position: 'br',
		width:480,
		minWidth: 480,
		maxWidth: 480,
		maxHeight: 'auto',
		manager: 'instructions',
		cls: 'toast-notification error',
		html: message,
		autoCloseDelay: 10000,
		slideBackDuration: 500,
		slideInDuration:500,
		autoClose:true,
		slideInAnimation: 'easeIn',
		slideBackAnimation: 'easeIn',
		resizable:false,
		paddingY:50,
		stickOnClick:false,
		tools: [{
			type: 'close', // Default close tool
			cls: 'ph ph-x', // Add Phosphor Icons class for the close icon
			handler: function (event, toolEl) {
			    var notification = toolEl.up('uxNotification');
			    if (notification) {
			        notification.close();
			    }
			}
		}]
		}).show();
}


function showInfoMessage (title,message){
	var iconHtml = '<span class="titleIcon ph-fill ph-warning"></span>';
	Ext.create('widget.uxNotification', {
		title: iconHtml + "<span class='toastTitle'>" + title + "</span>",
		position: 'br',
		width:480,
		minWidth: 480,
		maxWidth: 480,
		maxHeight: 'auto',
		manager: 'instructions',
		cls: 'toast-notification warning',
		html: message,
		autoCloseDelay: 10000,
		slideBackDuration: 500,
		slideInDuration:500,
		autoClose:true,
		slideInAnimation: 'easeIn',
		slideBackAnimation: 'easeIn',
		resizable:false,
		paddingY:50,
		stickOnClick:false,
		tools: [{
			type: 'close', // Default close tool
			cls: 'ph ph-x', // Add Phosphor Icons class for the close icon
			handler: function (event, toolEl) {
			    var notification = toolEl.up('uxNotification');
			    if (notification) {
			        notification.close();
			    }
			}
		}]
		}).show();
}

function showWarningMessage(title,message){
	var iconHtml = '<span class="titleIcon ph-fill ph-warning"></span>';
	try{
		if(Ext.ComponentQuery.query('uxNotification') && Ext.ComponentQuery.query('uxNotification').length && Ext.ComponentQuery.query('uxNotification')[0].initialConfig && Ext.ComponentQuery.query('uxNotification')[0].initialConfig.html==message){
			return;
		}
	}
	catch(e){
		//--
	}
	
	Ext.create('widget.uxNotification', {
		title: iconHtml + "<span class='toastTitle'>" + title + "</span>",
		position: 'br',
		width:480,
		minWidth: 480,
		maxWidth: 480,
		maxHeight: 'auto',
		manager: 'instructions',
		cls: 'toast-notification warning',
		html: message,
		autoCloseDelay: 10000,
		slideBackDuration: 500,
		slideInDuration:500,
		autoClose:true,
		slideInAnimation: 'easeIn',
		slideBackAnimation: 'easeIn',
		resizable:false,
		paddingY:50,
		stickOnClick:false,
		tools: [{
			type: 'close', // Default close tool
			cls: 'ph ph-x', // Add Phosphor Icons class for the close icon
			handler: function (event, toolEl) {
			    var notification = toolEl.up('uxNotification');
			    if (notification) {
			        notification.close();
			    }
			}
		}]
		}).show();
}

function showConfirmMessage(title, message, fn, yesBtnTxt, noBtnTxt, isRedConfirmTheme) {
    var msg = '<span class="confirmMessageBoxTitle">' + title + '</span>' +
              '<span class="confirmMessageBoxBody">' + message + '</span>';

    var iconColorCls = (Ext.isDefined(isRedConfirmTheme) && isRedConfirmTheme == true) ? 'negative-btn-color' : 'primary-btn-color';

    var box = Ext.MessageBox.show({
        cls: 'confirmMessageBoxCls',
        msg: msg,
        buttons: Ext.Msg.YESNO,
        buttonText: {
            yes: yesBtnTxt || getCommonTranslation('YES'),
            no: noBtnTxt || getCommonTranslation('NO')
        },
        width: 480,
        minWidth: 480,
        maxWidth: 480,
        resizable: false,
        callback: fn
    });
    
    // Hide the title bar (header)
    box.header.hide();
    box.removeCls('x-message-box');

    // Defer to make sure the box is rendered and buttons are available
    Ext.defer(function () {
        var footer = box.down('toolbar[dock="bottom"]');
        if (footer) {
            var yesBtn = footer.down('button[itemId=yes]');
            var noBtn = footer.down('button[itemId=no]');

            if (yesBtn && noBtn) {
            	yesBtn.removeCls('negative-btn-color');
            	yesBtn.removeCls('primary-btn-color');
            	
                // Add custom classes
                yesBtn.addCls('cta02 '+iconColorCls);
                noBtn.addCls('cta02 secondary-btn-color');
                
                // Move buttons to the right
                footer.layout.pack = 'end';
                
                footer.remove(noBtn, false);   // remove without destroying
                footer.insert(0, noBtn);       // insert No button at the beginning
                footer.doLayout();             // re-render layout
            }
        }
    }, 10); // Defer to allow rendering
}


function showNotificationMessage (title,message){
	var msg = '<span class="confirmMessageBoxTitle">' + title + '</span>' +
    '<span class="confirmMessageBoxBody">' + message + '</span>';

	var box = Ext.MessageBox.show({
	cls: 'confirmMessageBoxCls',
		msg: msg,
		buttons: Ext.Msg.OK,
		buttonText: {
			ok : getCommonTranslation('OK')
		},
		width: 480,
		minWidth: 480,
		maxWidth: 480,
		resizable: false
	});
	
	// Hide the title bar (header)
	box.header.hide();
	box.removeCls('x-message-box');
	
	// Defer to make sure the box is rendered and buttons are available
	Ext.defer(function () {
		var footer = box.down('toolbar[dock="bottom"]');
		if (footer) {
		  var okBtn = footer.down('button[itemId=ok]');
		
		  if (okBtn) {
			  okBtn.removeCls('negative-btn-color');
			  okBtn.removeCls('primary-btn-color');

			  // Add custom classes
			  okBtn.addCls('cta02 primary-btn-color no-icon-btn');

			  // Move buttons to the right
			  footer.layout.pack = 'end';
			  footer.doLayout();             // re-render layout
		  }
		}
	}, 10); // Defer to allow rendering
}
function showOkWithSuccessMessage (title,message){
	showNotificationMessage(title, message);
}
function showSessionTimeOutMessage (title,message,fn){
	var msg = '<span class="confirmMessageBoxTitle">' + title + '</span>' +
    '<span class="confirmMessageBoxBody">' + message + '</span>';

	var box = Ext.MessageBox.show({
	cls: 'confirmMessageBoxCls',
		msg: msg,
		buttons: Ext.Msg.OK,
		buttonText: {
			ok : getCommonTranslation('OK')
		},
		width: 480,
		minWidth: 480,
		maxWidth: 480,
		resizable: false,
	    callback: fn
	});
	
	// Hide the title bar (header)
	box.header.hide();
	box.removeCls('x-message-box');
	
	// Defer to make sure the box is rendered and buttons are available
	Ext.defer(function () {
		var footer = box.down('toolbar[dock="bottom"]');
		if (footer) {
		  var okBtn = footer.down('button[itemId=ok]');
		
		  if (okBtn) {
			  okBtn.removeCls('negative-btn-color');
			  okBtn.removeCls('primary-btn-color');

			  // Add custom classes
			  okBtn.addCls('cta02 primary-btn-color no-icon-btn');

			  // Move buttons to the right
			  footer.layout.pack = 'end';
			  footer.doLayout();             // re-render layout
		  }
		}
	}, 10); // Defer to allow rendering
}

function showCustomConfirmMessage(title, message, fn) {
	var msg = '<span class="confirmMessageBoxTitle">' + title + '</span>' +
	'<span class="confirmMessageBoxBody">' + message + '</span>';

	var iconColorCls = 'primary-btn-color';

	var box = Ext.MessageBox.confirm({
		cls: 'confirmMessageBoxCls',
		msg: msg,
		buttons: Ext.Msg.YESNOCANCEL,
		buttonText: {
			yes: getExaminationTranslation('DELETE_ONLY_REMARK'),
			no: getCommonTranslation('YES'),
			cancel: getCommonTranslation('NO')
		},
		width: 480,
		minWidth: 480,
		maxWidth: 480,
		resizable: false,
		callback: fn
	});
	
	// Hide the title bar (header)
	box.header.hide();
	box.removeCls('x-message-box');
	
	// Defer to make sure the box is rendered and buttons are available
	Ext.defer(function () {
		var footer = box.down('toolbar[dock="bottom"]');
		if (footer) {
			var yesBtn = footer.down('button[itemId=yes]');
			var noBtn = footer.down('button[itemId=no]');
			var cancelBtn = footer.down('button[itemId=cancel]');

			if (yesBtn && noBtn && cancelBtn) {
				yesBtn.removeCls('negative-btn-color');
				yesBtn.removeCls('primary-btn-color');
				noBtn.removeCls('negative-btn-color');
				noBtn.removeCls('primary-btn-color');

				// Add custom classes
				yesBtn.addCls('cta02 '+iconColorCls);
				noBtn.addCls('cta02 '+iconColorCls);
				cancelBtn.addCls('cta02 secondary-btn-color');

				// Move buttons to the right
				footer.layout.pack = 'end';

				footer.remove(cancelBtn, false);   // remove without destroying
				footer.insert(0, cancelBtn);       // insert No button at the beginning
				footer.doLayout();             // re-render layout
			}
		}
	}, 10); // Defer to allow rendering
}
function showDraftConfirmMessage (title,message,fn){
	var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+title+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+message+'</span>';
var box =	Ext.MessageBox.confirm({
	    // title:title,
	  cls: 'warningMessageBox commonMsgBoxCls newClsMessageConfirmBox x-custom-confirmation-box',
	     msg: msg,
	     buttons: Ext.Msg.YESNO,
	     icon: Ext.Msg.WARNING,
	     buttonText : {
	    	 yes : getProgramandcourseTranslation('SAVE_AS_DRAFT'),
	    	 no : getCommonTranslation('CANCEL')
	     },
	    
	     callback: fn
	});
box.removeCls('newClsMessageSuccessBox');
box.dockedItems.items[1].layout.pack = "end"; //items[0] is the header, [1] is the footer
box.doLayout();
box.dockedItems.items[1].items.items[1].setUI('SaveAsDraft');
box.dockedItems.items[1].items.items[2].setUI('CustomBtnCancel');
box.dockedItems.items[1].items.items[1].addCls('messageBoxButton');
}